/**
 * @author Deepak.Nigam
 *  Student Enrollment Generation Controller
 */
Ext.define('Academia.controller.personinfo.student.StudentEnrollmentGenerationController', {
    extend: 'Academia.controller.personinfo.common.PersonCommonController',

   views: ['personinfo.student.StudentEnrollmentGenerationView',
           //'personinfo.student.StudentMasterEnrollmentGenerationForm',
           //'personinfo.student.StudentBachelorEnrollmentGenerationForm'
           ],
           
    stores:['common.ProgramByAcAndLoIdStore','program.programbatchdetail.BatchStore',
            'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'],
    
    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    },/*{
        ref: 'studentmasterenrollmentgenerationform',
        selector: 'studentmasterenrollmentgenerationform'
    },{
        ref: 'studentbachelorenrollmentgenerationform',
        selector: 'studentbachelorenrollmentgenerationform'
    },*/{
        ref: 'studentenrollmentgenerationview',
        selector: 'studentenrollmentgenerationview'
    }],
    config: {
    	//STUDENT_DEBARMENT_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_DEBARMENT_PRIVILEGES')
    },
    init: function(application) {
        this.control({
        	
        	'studentenrollmentgenerationview button[itemId=generateEnrollmentButtonId]':{
        		click:function() {
        			var $this = this;
        			var form=$this.getStudentenrollmentgenerationview().getForm();
        			var values = form.getValues();
        			
        			var programId = values.programId;
        			var batchId = values.batchId;
        			var periodId = values.periodId;
        			var collegeNo = values.collegeNo;
        			var padding = values.padding;
        			var start = values.start;
        			
        			submitUrl = SERVERURL.STUDENT_ENROLLMENT_BACHELOR_GENERATION;
        			var json = {
        					programId:programId,
        					batchId:batchId,
        					periodId:periodId,
        					collegeCode:collegeNo,
        					padding:padding,
        					start:start
        			}
        			
                	Ext.Ajax.request({
        				method : 'POST',
        				url : submitUrl,
        				params : json,
        				success : function(form, action){
        					var response= form.responseText;
        					if(response=='SUCCESS'){
        						showSuccessMessage(getPersonModuleTranslation('STUDENT_ENROLLEMENT_GENERATION')
            							,getCommonTranslation('SUCCESS'));
        					}else if(response=='NO_PROGRAM_ID'){
        						showWarningMessage(getPersonModuleTranslation('STUDENT_ENROLLEMENT_GENERATION'), 
        								getPersonModuleTranslation('NO_PROGRAM_ID'));
        					}else if(response=='NO_BATCH_ID'){
        						showWarningMessage(getPersonModuleTranslation('STUDENT_ENROLLEMENT_GENERATION'), 
        								getPersonModuleTranslation('NO_BATCH_ID'));
        					}else if(response=='NO_PERIOD_ID'){
        						showWarningMessage(getPersonModuleTranslation('STUDENT_ENROLLEMENT_GENERATION'), 
        								getPersonModuleTranslation('NO_PERIOD_ID'));
        					}else if(response=='NO_START_ID'){
        						showWarningMessage(getPersonModuleTranslation('STUDENT_ENROLLEMENT_GENERATION'), 
        								getPersonModuleTranslation('NO_START_ID'));
        					}else if(response=='NO_STUDENT_FOUND'){
        						showWarningMessage(getPersonModuleTranslation('STUDENT_ENROLLEMENT_GENERATION'), 
        								getPersonModuleTranslation('NO_STUDENT_FOUND'));
        					}else{
        						showWarningMessage(getPersonModuleTranslation('STUDENT_ENROLLEMENT_GENERATION'), 
    							response);
        					}	
        					
        				},
        				failure: function(form, action) {
        					showWarningMessage(getPersonModuleTranslation('STUDENT_ENROLLEMENT_GENERATION'), 
        							getCommonTranslation('ERROR'));
        				}
        			});
        		}
        	},
        	
        	'studentenrollmentgenerationview button[itemId=resetBtn]':{
        		click:function() {
        			var bachelorForm = this.getStudentenrollmentgenerationview()
        			var batch = bachelorForm.down('#batchId');
        			var period = bachelorForm.down('#periodId');
        			bachelorForm.getForm().reset();
        			batch.setDisabled(true);
        			period.setDisabled(true);        			
        		}
        	},
        	
        	'studentenrollmentgenerationview customcombobox[itemId=programId]': {
        		afterrender : function(combo){
        			var academyLocationId = this.getCurrentAcademyLocation();
        			var store = combo.getStore();
        			store.proxy.extraParams = {
        					academyLocationId : academyLocationId
        			};
        		},
        		select: function(programCombo, records, eOpts) {
        			var this$ = this;
        			var stuEnrollBachelorGenForm=this$.getStudentenrollmentgenerationview();
        			var batchCombo = stuEnrollBachelorGenForm.down('#batchId');
        			batchCombo.setDisabled(false);
        			this$.loadDependentCombo(batchCombo, programCombo.getValue(), 'id');
        		}
        	},

        	'studentenrollmentgenerationview customcombobox[itemId=batchId]': {
        		select: function(batchCombo, records) {
        			var this$ = this;
        			var stuEnrollBachelorGenForm=this.getStudentenrollmentgenerationview();
        			var periodCombo = stuEnrollBachelorGenForm.down('#periodId');
        			periodCombo.setDisabled(false);
        			this$.loadDependentCombo(periodCombo, batchCombo.getValue(), 'id');
        		}
        	},

        	/*'studentmasterenrollmentgenerationform customcombobox[itemId=programId1]': {
        		afterrender : function(combo){
        			var academyLocationId = this.getCurrentAcademyLocation();
        			var store = combo.getStore();
        			store.proxy.extraParams = {
        					academyLocationId : academyLocationId
        			};
        		},
        	},
        	
        	'studentmasterenrollmentgenerationform customcombobox[itemId=programId2]': {
        		afterrender : function(combo){
        			var academyLocationId = this.getCurrentAcademyLocation();
        			var store = combo.getStore();
        			store.proxy.extraParams = {
        					academyLocationId : academyLocationId
        			};
        		}
        	},

        	'studentmasterenrollmentgenerationform button[itemId=generateEnrollmentButtonId]':{
        		click:function() {
        			var $this = this;
        			var form=$this.getStudentmasterenrollmentgenerationform().getForm();
        			var values = form.getValues();
        			
        			var programId1 = values.PROGRAM_NAME1;
        			var batchId1 = values.BATCH_NAME1;
        			var periodId1 = values.PERIOD_NAME1;
        			
        			var programId2 = values.PROGRAM_NAME2;
        			var batchId2 = values.BATCH_NAME2;
        			var periodId2 = values.PERIOD_NAME2;
        			
        			var collegeNo = values.collegeNo;
        			var padding = values.padding;
        			
        			submitUrl = SERVERURL.STUDENT_ENROLLMENT_MASTER_GENERATION;
        			var json = {
        					programId1:programId1,
        					batchId1:batchId1,
        					periodId1:periodId1,
        					
        					programId2:programId2,
        					batchId2:batchId2,
        					periodId2:periodId2,
        					
        					collegeCode:collegeNo,
        					padding:padding
        			}
        			
        			Ext.Ajax.request({
        				method : 'POST',
        				url : submitUrl,
        				params : json,
        				success : function(form, action){
        					showSuccessMessage(PERSON.STUDENT_ENROLLEMENT_GENERATION,getCommonTranslation("SUCCESS"));
        				}
        			});
        		}
        	},
        	
        	
        	'studentenrollmentgenerationview radiogroup[itemId=masterBachelorgroupId]':{
        		change: this.masterBachelorFormChange
        	},
        	'studentmasterenrollmentgenerationform button[itemId=resetBtn]': {
        		click: function() {
        			var studentEnrollGeneration = this.getStudentmasterenrollmentgenerationform();
        			var form = studentEnrollGeneration.getForm();
        			form.reset();
        			this.resetAndDisableDropdowns(form);
        		}
        	}
        	 */
        });
    },
    
    /*resetAndDisableDropdowns: function(form) {
    	var batchId1 = form.findField('BATCH_NAME1');
    	batchId1.setDisabled(true);
    	
    	var batchId2 = form.findField('BATCH_NAME2');
    	batchId2.setDisabled(true);
    	
    	var periodId1 = form.findField('PERIOD_NAME1');
    	periodId1.setDisabled(true);
    	
    	var periodId2 = form.findField('PERIOD_NAME2');
    	periodId2.setDisabled(true);
    },*/
   
    loadDependentCombo: function(dependentCombo, comboValue, parameter, extraParameter, extraParamValue) {
    	var this$ = this;
    	//this$.resetOtherDropdowns(dependentCombo);
        dependentCombo.clearValue();
        //dependentCombo.store.removeAll();
        var store = dependentCombo.getStore();
        var id = comboValue;
        if(!isNullOrEmpty(id)){
        	var url = store.getProxy().proxyConfig.api.read;
            if (isNullOrEmpty(extraParameter) && isNullOrEmpty(extraParamValue)) {
                url = url.concat('?' + parameter + '=' + id);
            } else {
                url = url.concat('?' + parameter + '=' + id);
                url = url.concat('&' + extraParameter + '=' + extraParamValue);
            }
            store.getProxy().api.read = url;
            store.reload();
        }
    },
    
    /** Download upload form change **/

	/*masterBachelorFormChange : function(cb, nv, ov){
		var $this = this;
		var masterTemplateForm = this.getStudentmasterenrollmentgenerationform();
		var bachelorTemplateForm = this.getStudentbachelorenrollmentgenerationform();
		
		if(nv.enrollmentGenerationChange == 'forBachelorTemplate'){
			masterTemplateForm.hide();
			bachelorTemplateForm.show();
			bachelorTemplateForm.getForm().reset();
		}else{
			bachelorTemplateForm.hide();
			masterTemplateForm.show();
			masterTemplateForm.getForm().reset();
		}
	},*/
    
    /**
     * function to clear the combo store, clear its existing
     * value and remove all the records from the store.
     * 
     * @param {Object}
     *            the reference of the combo whose store should
     *            be cleared.
     */
    clearCombo: function(combo, isDisabled) {
        combo.clearValue();
        //combo.store.removeAll();
        combo.setDisabled(isDisabled);
    }  
});