/**
 * This controller is used for the student Payment & Refund Controller.
 * @author Sachin.Bangar
 */
Ext.define('Academia.controller.personinfo.student.StudentPaymentRefundController', {
    extend: 'Academia.controller.personinfo.common.PersonPaymentRefundController',
    
    stores: ['feeandpayment.receipts.DrawnOnBank'],

    views: ['scholarship.scholarshiplisting.StudentPortalScholarshipStructure','personinfo.common.paymentandrefund.PendingBillStructure','personinfo.common.paymentandrefund.PendingBillsFilter',
            'personinfo.common.paymentandrefund.PaymentSummaryWin','personinfo.common.paymentandrefund.PendingBillsGrid','personinfo.student.StudentPrintTaxCertificatePortal','personinfo.common.paymentandrefund.HeadWiseBillsGrid',
            'personinfo.student.StcStdOnlinePaymentStructureForAdmin','personinfo.common.paymentandrefund.CreditNoteGrid','personinfo.common.DebitNoteAndCreditNotePanel',
            'personinfo.common.paymentandrefund.DebitNoteAndCreditNoteStructureParentPortal','personinfo.common.NSFAS.NSFABursaryDetailStructure',
            'personinfo.common.NSFAS.BursaryApplicationStatus','personinfo.common.NSFAS.BursaryApplicationDetails', 'personinfo.common.NSFAS.BursaryFunddingDetails',
            'personinfo.common.paymentandrefund.PendingCreditFilter','personinfo.common.ProFormaInvoice.ProFormaInvoiceStructure','personinfo.common.ProFormaInvoice.ProFormaInvoiceGrid'],

    refs: [{
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personPendingBillsForm',
        selector: 'billviewforpcstructure[itemId=studentPendingBillsForm]'
    }, {
    	ref: 'personRefundablePaymentForm',
        selector: 'billviewforpcstructure[itemId=studentRefundablePaymentForm]'
    },{
    	ref:'onlinePaymentGridForPortal',
    	selector:'onlinepaymentgridforportal[itemId=onlinepaymentgridforstudentportal]'
    },{
    	ref:'onlinepaymentbilllevelgridforportal',
    	selector:'onlinepaymentbilllevelgridforportal[itemId=opbilllevelgridforSTportal]'
    },{
    	ref:'paymentReceivedHistoryGrid',
    	selector:'paymentreceivedhistorygrid[itemId=studentPaymentReceivedHistoryGrid]'
    },{
    	ref : 'pendingBillsGrid',
        selector : 'pendingbillsgrid[itemId=studentPendingBillsGrid]'
    },{
        ref: 'searchResultGrid',
        selector: 'searchresultgrid[itemId=STscholarshipListGrid]'
    },{
        ref: 'pendingbillsfilter',
        selector: 'pendingbillsfilter'
    },{
        ref: 'paymentsummarywin',
        selector: 'paymentsummarywin [itemId=student]'
    },{
        	ref :'studentprinttaxcertificateportal',
        	selector : 'studentprinttaxcertificateportal'
    },{
    	ref :'studentprinttaxcertificateportal',
    	selector : 'studentprinttaxcertificateportal form'
    },{
        ref: 'paymentsummarywin',
        selector: 'paymentsummarywin [itemId=studentPaytmPayment]'
    },{
        ref: 'onlinepaymentstructureforportal',
        selector: 'onlinepaymentstructureforportal'
    },{
    	ref : 'headWiseBillsGrid',
    	selector : 'headwisebillsgrid[itemId=studentHeadWiseBillsGrid]'
    },{
    	ref : 'stcstdonlinepaymentstructureforadmin',
    	selector : 'stcstdonlinepaymentstructureforadmin'
    },{
    	ref : 'creditNoteGrid',
    	selector : 'creditnotegrid[itemId=creditNoteGridForErp]'
    },{
    	ref : 'debitnoteandcreditnotepanel',
    	selector : 'debitnoteandcreditnotepanel'
    },{
    	ref:'pendingbillsgrid',
    	selector:'pendingbillsgrid[itemId=pendingBillsGridForParentPortal]'
    },{
    	ref:'creditnotegrid',
    	selector:'creditnotegrid [itemId=creditNoteGridForParentPortal]'
    },{
    	ref:'pendingbillsgrid',
    	selector:'pendingbillsgrid[itemId=pendingBillsGridForErp]'
    },{
    	ref:'debitnoteandcreditnotepanel',
    	selector:'debitnoteandcreditnotepanel'
    },{
    	ref:'pendingbillstructure',
    	selector:'pendingbillstructure'
    },{
    	ref:'debitnoteandcreditnotestructureparentportal',
    	selector:'debitnoteandcreditnotestructureparentportal'
    },{
    	ref:'BursaryApplicationStatus',
    	selector:'bursaryapplicationstatus'
    },{
    	ref:'BursaryApplicationDetails',
    	selector:'bursaryapplicationdetails'
    },{
    	ref:'BursaryFunddingDetails',
    	selector:'bursaryfunddingdetails'
    },{
    	ref:'paymentsummarywin',
    	selector:'paymentsummarywin [itemId=paymentTechProcess]'
    },{
    	ref:'pendingcreditfilter',
    	selector:'pendingcreditfilter'
    },{
    	ref:'creditnotegridforstudentportal',
        selector:'creditnotegridforstudentportal'
    },{
    	ref:'pendingbillsgridforstudentportal',
    	selector:'pendingbillsgridforstudentportal'
    },{
    	ref:'fundingandmonitoringgrid',
    	selector:'fundingandmonitoringgrid'
    },{
    	ref:'fundingandmonitoringdetailswin',
    	selector:'fundingandmonitoringdetailswin'
    },{
    	ref:'financialsupportgrid',
    	selector:'financialsupportgrid'
    },{
    	ref:'financialsupportdetailswin',
    	selector:'financialsupportdetailswin'
    },{
      ref:'proformainvoicegrid',
      selector:'proformainvoicegrid'
    }],
    config: {
    	STUDENT_PENDING_BILLS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PENDING_BILLS_PRIVILEGES'),
    	STUDENT_PORTAL_PENDING_BILLS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_PENDING_BILLS_PRIVILEGES'),
    	STUDENT_PAYMENT_RECIEVED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PAYMENT_RECIEVED_PRIVILEGES'),
    	STUDENT_REFUNDS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_REFUNDS_PRIVILEGES'),
    	STUDENT_REFUNDABLE_PAYMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_REFUNDABLE_PAYMENTS_PRIVILEGES'),
    	STUDENT_POST_DATED_CHEQUES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_POST_DATED_CHEQUES_PRIVILEGES'),
    	SCHOLARSHIP_LISTING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SCHOLARSHIP_LISTING_PRIVILEGES'),
    	STUDENT_SCHOLARSHIP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_SCHOLARSHIP_PRIVILEGES'),
		STUDENT_ONLINE_PAYMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_ONLINE_PAYMENTS_PRIVILEGES'),
		PARENT_PENDING_BILLS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PENDING_BILLS_PRIVILEGES'),
		PARENT_ONLINE_PAYMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_ONLINE_PAYMENTS_PRIVILEGES'),
		STUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_PENDING_BILLS_PRIVILEGES'),
		STUDENT_PORTAL_STUDENT_PENDING_BILLS_TABS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_PENDING_BILLS_TABS_PRIVILEGES'),
		STUDENT_PORTAL_STUDENT_CREDIT_TAB_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_CREDIT_TAB_PRIVILEGES'),
		FACULTY_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_PENDING_BILLS_PRIVILEGES'),
		STUDENT_PORTAL_STUDENT_PAYMENT_RECIEVED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_PAYMENT_RECIEVED_PRIVILEGES'),
		STUDENT_PORTAL_STUDENT_PAYMENT_RECIEVED_DATA_GRID_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_PAYMENT_RECIEVED_DATA_GRID_PRIVILEGES'),
		PARENT_PORTAL_STUDENT_PAYMENT_RECIEVED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_PAYMENT_RECIEVED_PRIVILEGES'),
		FACULTY_PORTAL_STUDENT_PAYMENT_RECIEVED_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_PAYMENT_RECIEVED_PRIVILEGES'),
		STUDENT_PORTAL_STUDENT_REFUNDS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_REFUNDS_PRIVILEGES'),
		FACULTY_PORTAL_STUDENT_REFUNDS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_REFUNDS_PRIVILEGES'),
		PARENT_PORTAL_STUDENT_REFUNDS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_REFUNDS_PRIVILEGES'),
		STUDENT_PORTAL_STUDENT_REFUNDABLE_PAYMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_REFUNDABLE_PAYMENTS_PRIVILEGES'),
		FACULTY_PORTAL_STUDENT_REFUNDABLE_PAYMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_REFUNDABLE_PAYMENTS_PRIVILEGES'),
		PARENT_PORTAL_STUDENT_REFUNDABLE_PAYMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_REFUNDABLE_PAYMENTS_PRIVILEGES'),
		STUDENT_PORTAL_STUDENT_POST_DATED_CHEQUES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_POST_DATED_CHEQUES_PRIVILEGES'),
		FACULTY_PORTAL_STUDENT_POST_DATED_CHEQUES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_POST_DATED_CHEQUES_PRIVILEGES'),
		PARENT_PORTAL_STUDENT_POST_DATED_CHEQUES_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_POST_DATED_CHEQUES_PRIVILEGES'),
		FACULTY_PORTAL_STUDENT_SCHOLARSHIP_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_SCHOLARSHIP_PRIVILEGES'),
		STUDENT_PORTAL_ONLINEPAYMENT_TAB_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_ONLINEPAYMENT_TAB_PRIVILEGES'),
		PARENT_PORTAL_ONLINEPAYMENT_TAB_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_ONLINEPAYMENT_TAB_PRIVILEGES'),
		STUDENT_HEAD_WISE_BILLS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_HEAD_WISE_BILLS_PRIVILEGES'),
		STUDENT_ONLINEPAYMENT_TAB_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_ONLINEPAYMENT_TAB_PRIVILEGES'),
		STUDENT_BILLS_ONLINE_PAYMENTS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_BILLS_ONLINE_PAYMENTS_PRIVILEGES'),
		STUDENT_NSFAS_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_NSFAS_PRIVILEGES'),
		STUDENT_FUNDING_AND_MONITORING_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FUNDING_AND_MONITORING_PRIVILEGES'),
		NSFAS_STUDENT_STATUS_DATA_GRID_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('NSFAS_STUDENT_STATUS_DATA_GRID_PRIVILEGES'),
		NSFAS_STD_FUNDDING_DATA_GRID_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('NSFAS_STD_FUNDDING_DATA_GRID_PRIVILEGES'),
		NSFAS_STUDENT_DETAIL_DATA_GRID_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('NSFAS_STUDENT_DETAIL_DATA_GRID_PRIVILEGES'),
		FACULTY_PORTAL_STUDENT_HEAD_WISE_BILLS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_HEAD_WISE_BILLS_PRIVILEGES'),
		FACULTY_PORTAL_STUDENT_NSFAS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_NSFAS_PRIVILEGES'),
		STUDENT_FINANCIAL_SUPPORT_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FINANCIAL_SUPPORT_PRIVILEGES'),
		STUDENT_PRO_FORMA_INVOICE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PRO_FORMA_INVOICE_PRIVILEGES')
		
		
    },
    init: function(application) {
    	this.control({
    		 'pendingbillsgridforstudentportal button[itemId=btnPrint]': {
             	 click : function(btn){
   				   var gridType = "student";
   				   var grid = btn.up('pendingbillsgridforstudentportal');
   				   this.exportJRXMLForPendingBill('pdf',gridType,grid);
   			   }
              },
              'pendingbillsgridforstudentportal button[itemId=btnStudentPrintConsolidateOutstandingVoucherPortal]': {
              	 click : function(btn){
    				   var gridType = "student";
    				   var grid = btn.up('pendingbillsgridforstudentportal');
    				   this.exportJRXMLForPendingBillVoucher('pdf',gridType,grid);
    			   }
               },
              'pendingbillsgrid button[itemId=btnPrint]': {
              	 click : function(btn){
    				   var gridType = "student";
    				   var grid = btn.up('pendingbillsgrid');
    				  // var grid = this.getPendingbillsgrid();
    				   this.exportJRXMLForPendingBill('pdf',gridType,grid);
    			   }
               },
                'onlinepaymentbilllevelgridforportal button[itemId=btnPrint]': {
             	 click : function(btn){
   				   var gridType = "student";
   				   var grid = btn.up('onlinepaymentbilllevelgridforportal');
   				   this.exportJRXMLForPendingBill('pdf',gridType,grid);
   			   }
              },
              'creditnotegridforstudentportal button[itemId=btnPrint]': {
              	 click : function(btn){
    				   var gridType = "student";
    				   var grid = btn.up('creditnotegridforstudentportal');
    				   this.exportJRXMLForPendingBill('pdf',gridType,grid);
    			   }
               },
               
               'pendingbillsgrid[itemId=pendingBillsGridForParentPortal] button[itemId=btnPrint]': {
            	   click : function(btn){
       				   var gridType = "student";
       				   var grid = btn.up('pendingbillsgrid');
       				   this.exportJRXMLForPendingBill('pdf',gridType,grid);
       			   }
              },
              'creditnotegrid[itemId=creditNoteGridForParentPortal] button[itemId=btnPrint]': {
            	  click : function(btn){
   				   var gridType = "student";
   				   var grid = btn.up('creditnotegrid');
   				   this.exportJRXMLForPendingBill('pdf',gridType,grid);
   			   }
             },
    		//for Parent portal button
    		'pendingbillsgrid[itemId=pendingBillsGridForParentPortal] button[itemId=btnView]': {
    			 click: function(btn) {
                 	var grid = btn.up('grid')
                     this.viewPendingBill('PENDING_BILL', 'studentPendingBillsForm', grid, SERVERURL.FIND_ALL_BILL_FEE_HEADS);
                 }
            },
            'creditnotegrid[itemId=creditNoteGridForParentPortal] button[itemId=btnView]': {
            	click: function(btn) {
                 	var grid = btn.up('grid')
                     this.viewPendingBill('PENDING_BILL', 'studentPendingBillsForm', grid, SERVERURL.FIND_ALL_BILL_FEE_HEADS);
                 }
           },
            'pendingbillsgrid[itemId=pendingBillsGridForParentPortal] button[itemId=btnStudentPrintTaxCertificatePortal]': {
                click: function() {
               	 this.showStudentTaxCertificateWindowWin();
                }
            },
            'creditnotegrid[itemId=creditNoteGridForParentPortal] button[itemId=btnStudentPrintTaxCertificatePortal]': {
                click: function() {
               	 this.showStudentTaxCertificateWindowWin();
                }
            },
            
            
        	'creditnotegridforstudentportal button[itemId=btnView]': {
                click: function(btn) {
                	var grid = btn.up('grid')
                    
                    this.viewPendingBill('PENDING_BILL', 'studentPendingBillsForm', grid, SERVERURL.FIND_ALL_BILL_FEE_HEADS);
                }
            },
            'creditnotegridforstudentportal button[itemId=btnStudentPrintTaxCertificatePortal]': {
                click: function() {
               	 this.showStudentTaxCertificateWindowWin();
                }
            },'creditnotegrid[itemId=creditNoteGridForParentPortal]' : {

  			  afterrender:function(grid){
  			     var this$= this;
          		 var academyLocationId = this$.getCurrentAcademyLocation();
          		 Ext.Ajax.request({
  		    		  method: "GET",
  		    		  type: 'rest',
  		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
  		    		  params:{
  		    			  academyLocationId: academyLocationId
  		    		  },
  		    		  success: function(response) {
  		    			  if(response){
  		    				  result=response.responseText;	
  		    			  }
  		    	    		  if(result === "false"){
  		    	 				 var gridColumns=grid.columns;
  		    	 				 var length = gridColumns.length;
  		    	 				 if(length != null && length != ""){
  		    	 					 for(var i = 0; i < length; i++){
  		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
  		    	 							 gridColumns[i].setVisible(false);
  		    	 						 }
  		    	 					 }
  		    	 				 }
  		    	 			  }else{
  		    	 				 var gridColumns=grid.columns;
  		    	 				 var length = gridColumns.length;
  		    	 				 if(length!=null && length!=""){
  		    	 					 for(var i=0; i<length; i++){
  		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
  		    	 							 gridColumns[i].setVisible(true);
  		    	 						 }
  		    	 					 }
  		    	 				 }
  		    	    	  }
  		    		  }
  		    	  });
          		var personProfile = this$.getContentPanelActiveTab();
          		var userId = personProfile.getUserId();
          		var params = {
          				id : userId,
          				billedUserType : 'STUDENT',
          				whetherDeleted: false,
          				billStatus:"",
          				raiseBillCategory:'BILL_PAYABLE'	        					

          		};
          			 this.loadStudenPaymentBillsGridStore(grid, SERVERURL.STUDENT_PENDING_BILLS_DETAILS, params);
          			 this.doAccessControlValidation(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
              		 this.disablePendingBillsGridActionPivileges(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
              	
          		/*portalId = this.getCurrentLoggedPortalId();
          		if(portalId == 7){
          			this.doAccessControlValidation(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
          			this.disablePendingBillsGridActionPivileges(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
          		}else if(portalId == 2){
          			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
          		}else if(portalId == 3){
          			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
          			this.disablePendingBillsGridActionPivileges(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
          		}else{
          			this.doAccessControlValidation(grid, this.getSTUDENT_PENDING_BILLS_PERMISSIONS());
          			this.stdDisablePendingBillMakePaymentPivileges(grid, this.getSTUDENT_PENDING_BILLS_PERMISSIONS());
          		}*/
          	
  			
  			},select :function($this, record, index){
        		var grid = this.getDebitnoteandcreditnotestructureparentportal().down('creditnotegrid');
        		this.getCheckedBillsForStudent($this, record, index, 'select',grid);
        	},
        	deselect :function($this, record, index){
        		var grid = this.getDebitnoteandcreditnotestructureparentportal().down('creditnotegrid');
	        	
        		this.getCheckedBillsForStudent($this, record, index, 'deselct',grid);
        	}
  		
            },
    		'pendingbillsgrid[itemId=pendingBillsGridForParentPortal]': {
			  afterrender:function(grid){
			        		var this$= this;
        		 var academyLocationId = this$.getCurrentAcademyLocation();
        		 Ext.Ajax.request({
		    		  method: "GET",
		    		  type: 'rest',
		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
		    		  params:{
		    			  academyLocationId: academyLocationId
		    		  },
		    		  success: function(response) {
		    			  if(response){
		    				  result=response.responseText;	
		    			  }
		    	    		  if(result === "false"){
		    	 				 var gridColumns=grid.columns;
		    	 				 var length = gridColumns.length;
		    	 				 if(length != null && length != ""){
		    	 					 for(var i = 0; i < length; i++){
		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
		    	 							 gridColumns[i].setVisible(false);
		    	 						 }
		    	 					 }
		    	 				 }
		    	 			  }else{
		    	 				 var gridColumns=grid.columns;
		    	 				 var length = gridColumns.length;
		    	 				 if(length!=null && length!=""){
		    	 					 for(var i=0; i<length; i++){
		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
		    	 							 gridColumns[i].setVisible(true);
		    	 						 }
		    	 					 }
		    	 				 }
		    	    	  }
		    		  }
		    	  });
        		var personProfile = this$.getContentPanelActiveTab();
        		var userId = personProfile.getUserId();
        		var params = {
        				id : userId,
        				billedUserType : 'STUDENT',
        				whetherDeleted: false,
        				billStatus:"",
        				raiseBillCategory:'BILL_RECEIVABLE'	        					

        		};
        		/* if(portalId == 3){
        			 setTimeout(function(){
        			 var gridColumns=grid.columns;
   	 				 var length = gridColumns.length;
   	 				 if(length != null && length != ""){
   	 					 for(var i = 0; i < length; i++){
   	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
   	 							 gridColumns[i].destroy();
   	 						 }
   	 					 }
   	 				 } 
        			 },300);
        		 }*/
        			 this.loadStudenPaymentBillsGridStore(grid, SERVERURL.STUDENT_PENDING_BILLS_DETAILS, params);
        			 this.doAccessControlValidation(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
            		 this.disablePendingBillsGridActionPivileges(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
            	
        		/*portalId = this.getCurrentLoggedPortalId();
        		if(portalId == 7){
        			this.doAccessControlValidation(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
        			this.disablePendingBillsGridActionPivileges(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
        		}else if(portalId == 2){
        			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
        		}else if(portalId == 3){
        			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
        			this.disablePendingBillsGridActionPivileges(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
        		}else{
        			this.doAccessControlValidation(grid, this.getSTUDENT_PENDING_BILLS_PERMISSIONS());
        			this.stdDisablePendingBillMakePaymentPivileges(grid, this.getSTUDENT_PENDING_BILLS_PERMISSIONS());
        		}*/
        	
			
			},
			select :function($this, record, index){
        		var grid = this.getDebitnoteandcreditnotestructureparentportal().down('pendingbillsgrid');
        		this.getCheckedBillsForStudent($this, record, index, 'select',grid);
        	},
        	deselect :function($this, record, index){
        		var grid = this.getDebitnoteandcreditnotestructureparentportal().down('pendingbillsgrid');
	        	
        		this.getCheckedBillsForStudent($this, record, index, 'deselct',grid);
        	}
		},
		'creditnotegrid [itemId=creditNoteGridForParentPortal]': {
			afterrender:function(grid){
        		var this$= this;
        		 var academyLocationId = this$.getCurrentAcademyLocation();
        		 Ext.Ajax.request({
		    		  method: "GET",
		    		  type: 'rest',
		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
		    		  params:{
		    			  academyLocationId: academyLocationId
		    		  },
		    		  success: function(response) {
		    			  if(response){
		    				  result=response.responseText;	
		    			  }
		    	    		  if(result === "false"){
		    	 				 var gridColumns=grid.columns;
		    	 				 var length = gridColumns.length;
		    	 				 if(length != null && length != ""){
		    	 					 for(var i = 0; i < length; i++){
		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
		    	 							 gridColumns[i].setVisible(false);
		    	 						 }
		    	 					 }
		    	 				 }
		    	 			  }else{
		    	 				 var gridColumns=grid.columns;
		    	 				 var length = gridColumns.length;
		    	 				 if(length!=null && length!=""){
		    	 					 for(var i=0; i<length; i++){
		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
		    	 							 gridColumns[i].setVisible(true);
		    	 						 }
		    	 					 }
		    	 				 }
		    	    	  }
		    		  }
		    	  });
        		var personProfile = this$.getContentPanelActiveTab();
        		var userId = personProfile.getUserId();
        		var params = {
        				id : userId,
        				billedUserType : 'STUDENT',
        				whetherDeleted: false,
        				billStatus:"",
        				raiseBillCategory:'BILL_PAYABLE'	        					

        		};
        		/* if(portalId == 3){
        			 setTimeout(function(){
        			 var gridColumns=grid.columns;
   	 				 var length = gridColumns.length;
   	 				 if(length != null && length != ""){
   	 					 for(var i = 0; i < length; i++){
   	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
   	 							 gridColumns[i].destroy();
   	 						 }
   	 					 }
   	 				 } 
        			 },300);
        		 }*/
        			    this.loadStudenPaymentBillsGridStore(grid, SERVERURL.STUDENT_PENDING_BILLS_DETAILS, params);
        				this.doAccessControlValidation(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
            			this.disablePendingBillsGridActionPivileges(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
            		
        		/*portalId = this.getCurrentLoggedPortalId();
        		if(portalId == 7){
        			this.doAccessControlValidation(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
        			this.disablePendingBillsGridActionPivileges(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
        		}else if(portalId == 2){
        			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
        		}else if(portalId == 3){
        			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
        			this.disablePendingBillsGridActionPivileges(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
        		}else{
        			this.doAccessControlValidation(grid, this.getSTUDENT_PENDING_BILLS_PERMISSIONS());
        			this.stdDisablePendingBillMakePaymentPivileges(grid, this.getSTUDENT_PENDING_BILLS_PERMISSIONS());
        		}*/
        	
			
			},
			select :function($this, record, index){
        		var grid = this.getDebitnoteandcreditnotestructureparentportal().down('creditnotegrid');
        		this.getCheckedBillsForStudent($this, record, index, 'select',grid);
        	},
        	deselect :function($this, record, index){
        		var grid = this.getDebitnoteandcreditnotestructureparentportal().down('creditnotegrid');
	        	
        		this.getCheckedBillsForStudent($this, record, index, 'deselct',grid);
        	}
		},
    		'creditnotegridforstudentportal': {
    			afterrender:function(grid){

	        		var this$= this;
            		 var academyLocationId = this$.getCurrentAcademyLocation();
            		 Ext.Ajax.request({
   		    		  method: "GET",
   		    		  type: 'rest',
   		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
   		    		  params:{
   		    			  academyLocationId: academyLocationId
   		    		  },
   		    		  success: function(response) {
   		    			  if(response){
   		    				  result=response.responseText;	
   		    			  }
   		    	    		  if(result === "false"){
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length != null && length != ""){
   		    	 					 for(var i = 0; i < length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
   		    	 							 gridColumns[i].setVisible(false);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	 			  }else{
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length!=null && length!=""){
   		    	 					 for(var i=0; i<length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
   		    	 							 gridColumns[i].setVisible(true);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	    	  }
   		    		  }
   		    	  });
	        		var personProfile = this$.getContentPanelActiveTab();
	        		var userId = personProfile.getUserId();
	        		var params = {
	        				id : userId,
	        				billedUserType : 'STUDENT',
	        				whetherDeleted: false,
	        				billStatus:"",
	        				raiseBillCategory:'BILL_PAYABLE'	        					

	        		};
            		 if(portalId == 3){
            			 setTimeout(function(){
            			 var gridColumns=grid.columns;
       	 				 var length = gridColumns.length;
       	 				 if(length != null && length != ""){
       	 					 for(var i = 0; i < length; i++){
       	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
       	 							 gridColumns[i].destroy();
       	 						 }
       	 					 }
       	 				 } 
            			 },300);
            		 }
            			 //this.loadStudenPaymentBillsGridStore(grid, SERVERURL.STUDENT_PENDING_BILLS_DETAILS, params);
            			 this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_CREDIT_TAB_PERMISSIONS());
 	        			 this.disablePendingBillsGridActionPivileges(grid, this.getSTUDENT_PORTAL_STUDENT_CREDIT_TAB_PERMISSIONS());
 	        		
	        		/*portalId = this.getCurrentLoggedPortalId();
	        		if(portalId == 7){
	        			this.doAccessControlValidation(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
	        			this.disablePendingBillsGridActionPivileges(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
	        		}else if(portalId == 2){
	        			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	        		}else if(portalId == 3){
	        			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	        			this.disablePendingBillsGridActionPivileges(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	        		}else{
	        			this.doAccessControlValidation(grid, this.getSTUDENT_PENDING_BILLS_PERMISSIONS());
	        			this.stdDisablePendingBillMakePaymentPivileges(grid, this.getSTUDENT_PENDING_BILLS_PERMISSIONS());
	        		}*/
	        	
    			
    			},
    			select :function($this, record, index){
	        		var grid = this.getPendingbillstructure().down('creditnotegridforstudentportal');
	        		this.getCheckedBillsForStudent($this, record, index, 'select',grid);
	        	},
	        	deselect :function($this, record, index){
	        		var grid = this.getPendingbillstructure().down('creditnotegridforstudentportal');
		        	
	        		this.getCheckedBillsForStudent($this, record, index, 'deselct',grid);
	        	},
	        	selectionchange: function(column, selected,grid ){
	        		 var grid = this.getCreditnotegridforstudentportal();
	        		 var viewButtonItemId = grid.down('#btnView');
					 var printTaxCertificatePortalItemId = grid.down('#btnStudentPrintTaxCertificatePortal');
					 var count=selected.length;
					 if(count> 1){ // disable
						 viewButtonItemId.setDisabled(true);
						 printTaxCertificatePortalItemId.setDisabled(true);
						}else{  // enable
							viewButtonItemId.setDisabled(false);
							printTaxCertificatePortalItemId.setDisabled(false);
						}
	        	 }
    		},
    		'pendingbillsgridforstudentportal':{
    			afterrender:function(grid){
   	        		var this$= this;
            		 var academyLocationId = this$.getCurrentAcademyLocation();
            		 Ext.Ajax.request({
   		    		  method: "GET",
   		    		  type: 'rest',
   		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
   		    		  params:{
   		    			  academyLocationId: academyLocationId
   		    		  },
   		    		  success: function(response) {
   		    			  if(response){
   		    				  result=response.responseText;	
   		    			  }
   		    	    		  if(result === "false"){
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length != null && length != ""){
   		    	 					 for(var i = 0; i < length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
   		    	 							 gridColumns[i].setVisible(false);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	 			  }else{
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length!=null && length!=""){
   		    	 					 for(var i=0; i<length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
   		    	 							 gridColumns[i].setVisible(true);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	    	  }
   		    		  }
   		    	  });
	        		var personProfile = this$.getContentPanelActiveTab();
	        		var userId = personProfile.getUserId();
	        		var params = {
	        				id : userId,
	        				billedUserType : 'STUDENT',
	        				whetherDeleted: false,
	        				billStatus:"",
	        				raiseBillCategory:'BILL_RECEIVABLE'
	        					/* End
	        					 */

	        		};
            		 if(portalId == 3){
            			 setTimeout(function(){
            			 var gridColumns=grid.columns;
       	 				 var length = gridColumns.length;
       	 				 if(length != null && length != ""){
       	 					 for(var i = 0; i < length; i++){
       	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
       	 							 gridColumns[i].destroy();
       	 						 }
       	 					 }
       	 				 } 
            			 },300);
            		 }
            		
            		//this.loadStudenPaymentBillsGridStore(grid, SERVERURL.STUDENT_PENDING_BILLS_DETAILS, params);
            	    this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_TABS_PERMISSIONS());
        			this.disablePendingBillsGridActionPivileges(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_TABS_PERMISSIONS());
        			this.disablePrintVaucherGridActionPivileges(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_TABS_PERMISSIONS());
        	
	        		/*portalId = this.getCurrentLoggedPortalId();
	        		if(portalId == 7){
	        			this.doAccessControlValidation(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
	        			this.disablePendingBillsGridActionPivileges(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
	        		}else if(portalId == 2){
	        			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	        		}else if(portalId == 3){
	        			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	        			this.disablePendingBillsGridActionPivileges(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	        		}else{
	        			this.doAccessControlValidation(grid, this.getSTUDENT_PENDING_BILLS_PERMISSIONS());
	        			this.stdDisablePendingBillMakePaymentPivileges(grid, this.getSTUDENT_PENDING_BILLS_PERMISSIONS());
	        		}*/
	        	
    			},

    			select :function($this, record, index,column, selected,eOpts){
	        		var grid = this.getPendingbillstructure().down('pendingbillsgridforstudentportal');
	        		this.getCheckedBillsForStudent($this, record, index, 'select',grid);
	        		
	        		var flag = false;
	        		var selectionModel = grid.getSelectionModel().getSelection();
	        		selectionModel.forEach(function(obj){
	        		    if(obj.get('billStatus') !== "PENDING" && 
	        		       obj.get('billStatus') !== "PARTLY_SETTLED" && 
	        		       obj.get('billStatus') !== "FULLY_PENDING") {
	        		        flag = true;
	        		    }
	        		});
	        		if(selectionModel.length){
		        		grid.down('#btnStudentPrintConsolidateOutstandingVoucherPortal').setDisabled(flag);

	        		}else{
	        			grid.down('#btnStudentPrintConsolidateOutstandingVoucherPortal').setDisabled(true);
	        		}
	        		
	        	},
	        	deselect :function($this, record, index,column, selected,eOpts){
	        		var grid = this.getPendingbillstructure().down('pendingbillsgridforstudentportal');
	        		this.getCheckedBillsForStudent($this, record, index, 'deselct',grid);
	        		
	        		var flag = false;
	        		var selectionModel = grid.getSelectionModel().getSelection();
	        		selectionModel.forEach(function(obj){
	        		    if(obj.get('billStatus') !== "PENDING" && 
	        		       obj.get('billStatus') !== "PARTLY_SETTLED" && 
	        		       obj.get('billStatus') !== "FULLY_PENDING") {
	        		        flag = true;
	        		    }
	        		});
	        		if(selectionModel.length){
		        		grid.down('#btnStudentPrintConsolidateOutstandingVoucherPortal').setDisabled(flag);

	        		}else{
	        			grid.down('#btnStudentPrintConsolidateOutstandingVoucherPortal').setDisabled(true);
	        		}
	        	},
	        	selectionchange: function(column, selected,grid ){
	        		 var grid = this.getPendingbillsgridforstudentportal();
	        		 var viewButtonItemId = grid.down('#btnView');
	        		 var billMakePaymentButtonItemId = grid.down('#stdbtnBillMakePaymentButton');
					 var printTaxCertificatePortalItemId = grid.down('#btnStudentPrintTaxCertificatePortal');
					 var printConsolidateOutstandingVoucherPortalItemId = grid.down('#btnStudentPrintConsolidateOutstandingVoucherPortal');
					 var count=selected.length;
					 if(count> 1){ // disable
						 viewButtonItemId.setDisabled(true);
						 billMakePaymentButtonItemId.setDisabled(true);
						 printTaxCertificatePortalItemId.setDisabled(true);
						 printConsolidateOutstandingVoucherPortalItemId.setDisabled(true);
						}else{  // enable
							viewButtonItemId.setDisabled(false);
							billMakePaymentButtonItemId.setDisabled(false);
							printTaxCertificatePortalItemId.setDisabled(false);
							printConsolidateOutstandingVoucherPortalItemId.setDisabled(false);
						}
	        	 }
    		},
    		/**
    		 * online payment grid for student portal
    		 */
    		 'onlinepaymentgridforportal[itemId=onlinepaymentgridforstudentportal]':{
  			   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
  				   this.onlinePaymentSTPortalGridCellClick(grid,td, cellIndex, record, tr, rowIndex, e, eOpts );
  			   },
  			 activate:function(grid){
  				 var $this = this;
  				grid.getStore().load({
						callback: function(record, operation, success) {
							setTimeout(function() {
								 if (record.length > 0) {
										for(var i in record){
				                				if (record[i].data.whetherDisplayTotal != false) {
				                					$this.toggleGridSummaryRow(grid,true); 
				                				}
				                				 if (record[i].data.whetherActive == true && record[i].data.whetherChecked == true)
				                				 {	
												 grid.getSelectionModel().select(record[i],true);
				                				 }
				                				if (record[i].data.whetherActive == true && record[i].data.whetherChecked == false)
				                				{	
												grid.getSelectionModel().deselect(record[i],true);
				                				}
				                			}
									 }else{
										 $this.toggleGridSummaryRow(grid,false);
									 }
			                  }, 500);
							
						 }
					});
  				
  			 }  
    		 },
  			 'onlinepaymentgridforportal[itemId=onlinepaymentgridforstudentportal] customcombobox#bankItemId' : {
  				 select:function(obj,record){
  					 var grid = this.getOnlinePaymentGridForPortal();
  					 var submitUrl = SERVERURL.FIND_BANK_CHARGE_APPLICABLE_AND_THRESHOLD_LIMIT_BY_BANK_ID;
  					var currentDate = Ext.Date.format(new Date(), 'Y-m-d');
	    			
					  Ext.Ajax.request({
							type : 'rest',
							url : submitUrl,
							method : 'GET',							
							params : {
								bankId:record[0].data.id,
								date:currentDate
							},
							success : function(response, action) {
								if(!isNullOrEmpty(response.responseText)){
									var responseData = Ext.decode(response.responseText);
									grid.config.thresholdLimit = responseData.thresholdLimit;
									grid.config.bankChargeApplicable = responseData.bankChargesApplicable;
								}else{
									grid.config.thresholdLimit = undefined;
									grid.config.bankChargeApplicable = undefined;
								}								
							}
					  });
  				 }
  			 },
  			'onlinepaymentbilllevelgridforportal[itemId=opbilllevelgridforSTportal] customcombobox#bankItemId': {
				 select:function(obj,record){
					 var grid = this.getOnlinepaymentbilllevelgridforportal();
					 var submitUrl = SERVERURL.FIND_BANK_CHARGE_APPLICABLE_AND_THRESHOLD_LIMIT_BY_BANK_ID;
	  					var currentDate = Ext.Date.format(new Date(), 'Y-m-d');
		    			
						  Ext.Ajax.request({
								type : 'rest',
								url : submitUrl,
								method : 'GET',							
								params : {
									bankId:record[0].data.id,
									date:currentDate
								},
								success : function(response, action) {
									if(!isNullOrEmpty(response.responseText)){
										var responseData = Ext.decode(response.responseText);
										grid.config.thresholdLimit = responseData.thresholdLimit;
										grid.config.bankChargeApplicable = responseData.bankChargesApplicable;
									}else{
										grid.config.thresholdLimit = undefined;
										grid.config.bankChargeApplicable = undefined;
									}	
								}
						  });					 
				  }

  			},
    		'onlinepaymentgridforportal[itemId=onlinepaymentgridforstudentportal]': {
				afterrender: function(grid){
					var this$= this;
					var bankField = grid.down('#bankItemId');
					var btnPaytmTechprocess = grid.down('#btnPaytmTechprocess');
				    var allowblankFalse = '<span class="required" style="color:red"> *</span>';
					 bankField.setFieldLabel(getCommonTranslation('BANK')+allowblankFalse);
					if(this$.getCurrentLoggedPortalId() == 7)
            		{
						this$.disableMoreActionPivileges(grid, this$.getPARENT_ONLINE_PAYMENTS_PERMISSIONS());
            		}else if(this$.getCurrentLoggedPortalId() == 3){
            			this$.disableMoreActionPivileges(grid,this$.getSTUDENT_ONLINE_PAYMENTS_PERMISSIONS());
            		}else{
            			this$.disableMoreActionPivileges(grid,this$.getSTUDENT_BILLS_ONLINE_PAYMENTS_PERMISSIONS());
            			btnPaytmTechprocess.setVisible(false);
            		}
					
					
					 var personProfile = this$.getContentPanelActiveTab();
			    	 var userId = personProfile.getUserId();
					if (personProfile) {
						if(!isNullOrEmpty(userId)){
						grid.getStore().getProxy().extraParams={
								id : userId,
								billedUserType : 'STUDENT',
								adjustmentType : 'Bill Receivable',
								showAllSettlement : 'Pending',
								isStudentFeeHeadScreen : false,
								limit : -1
							};
							if(this$.getCurrentLoggedPortalId() == 1){
								var pendingGrid = this$.getDebitnoteandcreditnotepanel().down('pendingbillsgrid');
								var billIdsArray = [];
								var gridRec=pendingGrid.getSelectionModel().getSelection();
								for( var i = 0; i < gridRec.length; i++) {
		            				billIdsArray.push(gridRec[i].data.billId);
		            			}
								grid.getStore().getProxy().extraParams={
									id : userId,
									billedUserType : 'STUDENT',
									adjustmentType : 'Bill Receivable',
									screen:'erp',
									billIds:billIdsArray.join(),
									showAllSettlement : 'Pending',
									limit : -1
								};	
							}else{
								grid.getStore().getProxy().extraParams={
									id : userId,
									billedUserType : 'STUDENT',
									adjustmentType : 'Bill Receivable',
									showAllSettlement : 'Pending',
									limit : -1
								};
							}
							
							grid.getStore().load({
								callback: function(record, operation, success) {
									setTimeout(function() {
										 if (record.length > 0) {
			 									for(var i in record){
			  		                				if (record[i].data.whetherDisplayTotal != false) {
			  		                					this$.toggleGridSummaryRow(grid,true); 
			  		                				}
			  		                				 if (record[i].data.whetherActive == true && record[i].data.whetherChecked == true)
				 									 {	
				 										 grid.getSelectionModel().select(record[i],true);
				 									 }
			  		                				 if (record[i].data.whetherActive == true && record[i].data.whetherChecked == false)
			  		                				 {	
			  		                					 grid.getSelectionModel().deselect(record[i],true);
			  		                				 }
			 									}
			 									recordCount = grid.store.getCount();
			 									if(grid.down('#totalRecordDisplayField')){
			 										grid.down('#totalRecordDisplayField').setValue(getCommonTranslation('TOTAL_RECORDS')+": "+ recordCount);
			 									}
										 }else{
											 this$.toggleGridSummaryRow(grid,false);
			 								 }
					                  }, 500);
	 							 }
							});
						}
					}
					var XMLHttpRequestObject = false;  
					   if (window.XMLHttpRequest) {  
						   XMLHttpRequestObject = new XMLHttpRequest();  
						   XMLHttpRequestObject.overrideMimeType("text/xml");  
					   }  
					   else if (window.ActiveXObject) {  
						   XMLHttpRequestObject = new  
						   ActiveXObject("Microsoft.XMLHTTP");  
					   } 
					   if(XMLHttpRequestObject) {  
						   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
						   XMLHttpRequestObject.onreadystatechange = function() {       
							   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
								   var xmlDocument = XMLHttpRequestObject.responseXML;  
								   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
								   paymentPostUrl = buildInfo.getElementsByTagName("paymentPostUrl") [0].childNodes[0].nodeValue;
								   techprocessPaymentPostUrl = buildInfo.getElementsByTagName("techprocessPaymentPostUrl") [0].childNodes[0].nodeValue;
								   Ext.apply(grid,{
									   paymentPostUrl:null,
									   techprocessPaymentPostUrl :null,
									   setPaymentPostUrl : function(paymentPostUrl){
										   grid.paymentPostUrl = paymentPostUrl;
									   },
									   getPaymentPostUrl:function(){
										   return grid.paymentPostUrl;
									   },
									   setTechprocessPaymentPostUrl : function(techprocessPaymentPostUrl){
										   grid.techprocessPaymentPostUrl = techprocessPaymentPostUrl;
									   },
									   getTechprocessPaymentPostUrl:function(){
										   return grid.techprocessPaymentPostUrl;
									   }
								   });
								   grid.setPaymentPostUrl(paymentPostUrl);
								   grid.setTechprocessPaymentPostUrl(techprocessPaymentPostUrl);
							   }  
						   }  
						   XMLHttpRequestObject.send(null);  
					   }
				},
				beforedeselect:function(cmp, record, index){
					if(record.data.whetherChecked){
						return false;
					}else{
						return true;
					}
				}
			},
			'onlinepaymentgridforportal[itemId=onlinepaymentgridforstudentportal] numberfield[itemId=amountToBeAdjusted]': {
				change : function(obj,newValue){
					var grid = obj.ownerCt.grid;
					var selectedRow = grid.getSelectionModel().getSelection()[0];
					var amounttobeadjusted = obj.getValue();

					var totaltempbalanceamount = selectedRow.get('totalTempBalanceAmount');
					var remainingAmount = totaltempbalanceamount - amounttobeadjusted
					//selectedRow.set('tempRemainingAmount',remainingAmount);
					if(amounttobeadjusted == 0){
						obj.reset();
						grid.getSelectionModel().deselect(selectedRow);
						showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));//Please select a reco
					}
					if(totaltempbalanceamount < amounttobeadjusted){
						obj.reset();
						grid.getSelectionModel().deselect(selectedRow);
						// selectedRow.set('totalBalanceAmount',totaltempbalanceamount);
						showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_EQUALORLESSTHAN_BALANCE_AMOUNT'));//Please select a reco
					}
					var storeItems = grid.getStore().data.items;
					var paymentMndatoryRecArr = [];
					Ext.each(storeItems,function(rec){
                        if(rec.data.whetherMandatoryToPay && rec.data.whetherActive) {
						paymentMndatoryRecArr.push(rec);
					}
					});
					paymentMndatoryRecArr.push(selectedRow);
					if(paymentMndatoryRecArr.length>0) {
						grid.getSelectionModel().select(paymentMndatoryRecArr);
						
					}
				},
				blur : function(obj,newValue){
					var grid = obj.ownerCt.grid;
					var selectedRow = grid.getSelectionModel().getSelection()[0];
					var amounttobeadjusted = obj.getValue();

					var totaltempbalanceamount = selectedRow.get('totalTempBalanceAmount');
					var remainingAmount = totaltempbalanceamount - amounttobeadjusted
					selectedRow.set('tempRemainingAmount',remainingAmount);

					if(totaltempbalanceamount < amounttobeadjusted){
						obj.reset();
						grid.getSelectionModel().deselect(selectedRow);
						// selectedRow.set('totalBalanceAmount',totaltempbalanceamount);
						showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_EQUALORLESSTHAN_BALANCE_AMOUNT'));//Please select a reco
					}
					var storeItems = grid.getStore().data.items;
					var paymentMndatoryRecArr = [];
					Ext.each(storeItems,function(rec){
                        if(rec.data.whetherMandatoryToPay && rec.data.whetherActive) {
						paymentMndatoryRecArr.push(rec);
					}
					});
					paymentMndatoryRecArr.push(selectedRow);
					if(paymentMndatoryRecArr.length>0) {
						grid.getSelectionModel().select(paymentMndatoryRecArr);						
					}
				}
			},
			'paymentsummarywin[itemId=student] button[itemId=okBtn]' : {
				click : function(obj) {
					var $this = this;
					//var grid = $this.getOnlinePaymentGridForPortal(); //V2D-300483
					//grid.getSelectionModel().deselectAll();//V2D-300483
					//var formWindow  = obj.up().up().up();
					//grid.getStore().reload();//V2D-300483
					//var newGrid = $this.getOnlinepaymentbilllevelgridforportal();
					//newGrid.getSelectionModel().deselectAll();
					//newGrid.getStore().reload();
					//formWindow.close();

					var getActiveTab = $this.getContentPanelActiveTab();
					var tabPanel = getActiveTab.down("tabpanel");
					//var grid = tabPanel.activeTab;
					 var grid1 = this.getOnlinepaymentbilllevelgridforportal();
					 if(!isNullOrEmpty(grid1)){
						 grid1.getSelectionModel().deselectAll();
						 grid1.getStore().reload();
					 }
					 var grid2 = this.getOnlinePaymentGridForPortal();
					 if(!isNullOrEmpty(grid2)){
						 grid2.getSelectionModel().deselectAll();
						 grid2.getStore().reload();
					 }
					 var formWindow  = obj.up().up().up();
					 formWindow.close();
				}
		   },
		   'paymentsummarywin[itemId=student] button[itemId=cancelBtn]' : {
			   click : function(obj) {
				   var $this = this;
				   var formWindow  = obj.up().up().up();
				   formWindow.close();
			   }
		   },
		   'paymentsummarywin[itemId=student] checkboxfield[itemId=onlinePaymentTermCondCheck]' : {
			   change : function(obj,newVal,oldVal) {
				   var $this = this;
				   var formWindow  = obj.up('form');
				   if(newVal == true){
					   formWindow.down('#payNow').enable();	
				   }
				   else{
					   formWindow.down('#payNow').disable();	
				   }		   
			   }
		   },
		   'paymentsummarywin[itemId=student] displayfield[itemId=onlinePaymentConditionMsg]' : {
			   afterrender : function(obj,newVal,oldVal) {
				   obj.getEl().on('click', function() {
					   var serverUrl = SERVERURL.DOWNLOAD_ONLINE_PAYMENT_DOC;
					   var csvForm = Ext.create('Ext.form.Panel'); 
	        	    	csvForm.getForm().submit({
	        		    	target: '_blank',
	        		    	method:'GET',
	        		    	params :{
	        		    		access_token : Ext.Ajax.defaultHeaders.access_token
	        		    	},
	        		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
	        		    	url: serverUrl,
	        		    	standardSubmit :true
	        	    	});
		            });
				   			   
			   }
		   },
			'paymentsummarywin[itemId=student] button[itemId=payNow]' : {
 			   click : function(obj) {
 			   var $this = this;
 				  if (typeof obj.lastExecutionTime === 'undefined') {
						 obj.lastExecutionTime = 0;
					 }

					 var currentTime = new Date().getTime();

					 // Prevent function execution if called within the last 5+ seconds
					 if (currentTime - obj.lastExecutionTime < 5000) {
						 return false;
					 }

					 // Update last execution time
					 obj.lastExecutionTime = currentTime;
 				   
 				   var $this = this,payNowBtn=obj; 
				   var formWindow  = obj.up().up().up();
				   var structure = null;
				   if(portalId == 1){
					    structure = $this.getStcstdonlinepaymentstructureforadmin();
				   }else{
					   structure = $this.getOnlinepaymentstructureforportal();   
				   }
				   var activeGrid = structure.getActiveTab();
				   if(activeGrid != undefined) {
					   var  record = activeGrid.getSelectionModel().getSelection()[0].data;
				   }
 				   var XMLHttpRequestObject = false;  
					   if (window.XMLHttpRequest) {  
						   XMLHttpRequestObject = new XMLHttpRequest();  
						   XMLHttpRequestObject.overrideMimeType("text/xml");  
					   }  
					   else if (window.ActiveXObject) {  
						   XMLHttpRequestObject = new  
						   ActiveXObject("Microsoft.XMLHTTP");  
					   } 
					   payNowBtn.setDisabled(true);
					   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					   payNowBtn.setDisabled(true);
					   if(XMLHttpRequestObject) {  
						   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
						   XMLHttpRequestObject.onreadystatechange = function() {       
							   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
								   var xmlDocument = XMLHttpRequestObject.responseXML;  
								   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
								   gatewayPostUrl = buildInfo.getElementsByTagName("gatewayPostUrl") [0].childNodes[0].nodeValue;
								   var w ='900',h ='500';
								// Fixes dual-screen position                         Most browsers      Firefox
								    var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
								    var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;

								    var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
								    var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

								    var left = ((width / 2) - (w / 2)) + dualScreenLeft;
								    var top = ((height / 2) - (h / 2)) + dualScreenTop;
								    var url = gatewayPostUrl+"?id="+formWindow.getData()+"&academyLocationIds="+$this.getCurrentAcademyLocation(); 
  								    if(!isNullOrEmpty(record)) {
  								    	url = gatewayPostUrl+"?id="+formWindow.getData()+"&academyLocationIds="+record.academyLocationId+"&merchantReference="+record.schoolTypeCode; 
  								    }
  								    Ext.getBody().unmask();
  								    payNowBtn.setDisabled(false); 
								    var newWindow = window.open(url,'Online_Payment', 'scrollbars=yes, width=' + w + ', height=' + h + ', top=' + 120 + ', left=' + left+5);

								    // Puts focus on the newWindow
								    if (window.focus) {
								        newWindow.focus();
								    }
								    
								  /* window.open(revalPaymentUrl+"?id="+formWindow.getData(),'Online_Payment',
										    "status=no,height=" + 800 + ",width=" + 800 + ",resizable=yes,left="
										    + left + ",top=" + top + ",screenX=" + left + ",screenY="
										    + top + ",toolbar=no,menubar=no,scrollbars=no,location=no,directories=no");*/
             				   Ext.defer(function() {
             					   formWindow.down('#payNow').setVisible(false);
             					   formWindow.down('#cancelBtn').setVisible(false);
             					   formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
             					   formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
             					   formWindow.down('#okBtn').setVisible(true);
             				   }, 150, this);
							   }else{
								   Ext.getBody().unmask();
								   payNowBtn.setDisabled(false);
							   }  
						   }  
						   XMLHttpRequestObject.send(null);  
					   }
 			   }
 		   },
			'onlinepaymentgridforportal[itemId=onlinepaymentgridforstudentportal] button[itemId=btnView]': {
				click: function(obj){
					var $this = this;
					var grid = this.getOnlinePaymentGridForPortal();
					var bankField = grid.down('#bankItemId');
					var thresholdValue;
					var bankChargeApplicable;
					var personProfile = $this.getContentPanelActiveTab();
					var userId = personProfile.getUserId();
					if(grid.getSelectionModel().getCount()>0){
						if($this.getCostCenterValidationAtFeeHeadLevel(grid)){
						   return  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BILL_PAYMENT_IS_NOT_ALLOWED_FOR_INVOICES_WITH_MULTIPLE_COST_CENTERS'));
						}
						Ext.Ajax.request({
							method: "GET",
							type: 'rest',
							scope:$this,
							url: SERVERURL.ORGINFOLOADREQUEST,
							success: function(response, action) {
								var data = JSON.parse(response.responseText);
								var grid = $this.getOnlinePaymentGridForPortal();
								if(data.whetherOnlinePaymentSettings && grid.getSelectionModel().getCount()>1){
									return showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MULTIPLE_INVOICES_DETECTED_PLEASE_SELECT_ONLY_ONE_INVOICE_TO_PROCEED_WITH_ONLINE_PAYMENT')); 
								}
								var gridRecords = grid.selModel.getSelection();
								var flagIsHostelFee = true;
								var flagForHostelJSON=true;
								for( var i = 0; i < gridRecords.length; i++) {
									for( var j = i; j < gridRecords.length; j++) {
										if(gridRecords[i].data.isHostelFee==true){
											if(gridRecords[j].data.isHostelFee==true){
												flagIsHostelFee=true;
												flagForHostelJSON=true;
											}else{
												flagIsHostelFee=false;
												break;
											}
										}else if(gridRecords[i].data.isHostelFee==false){
											if(gridRecords[j].data.isHostelFee==true){
												flagIsHostelFee=false;
												break;
											}else{
												flagIsHostelFee=true;
												flagForHostelJSON=false;
											}
										}
									}
									if(flagIsHostelFee==false){
										break;
									}
								}
								/**************************start*****************************/
								if($this.getCurrentLoggedPortalId() == 1){
									var pendingGrid = $this.getDebitnoteandcreditnotepanel().down('pendingbillsgrid');
									var billIdsArray = [];
									var gridRec=pendingGrid.getSelectionModel().getSelection();
									for( var i = 0; i < gridRec.length; i++) {
										billIdsArray.push(gridRec[i].data.billId);
									}
									params={
											id : userId,
											billedUserType : 'STUDENT',
											adjustmentType : 'Bill Receivable',
											screen:'erp',
											billIds:billIdsArray.join(),
											showAllSettlement : 'Pending',
											limit : -1,
											page: 1
									};	
								}else{
									params={
											id : userId,
											billedUserType : 'STUDENT',
											adjustmentType : 'Bill Receivable',
											showAllSettlement : 'Pending',
											limit : -1,
											page: 1
									};
								}
								var grid = $this.getOnlinePaymentGridForPortal();
								var submitUrl = SERVERURL.BILL_ADJUSTMENT_GRID_ONLINEPAYMENT;
								Ext.Ajax.request({
									type : 'rest',
									url : submitUrl,
									params : params, 
									method : 'GET',
									success: function(res, action) {
										var isTransDone=false;
										var response = Ext.decode(res.responseText);

										if( Object.keys(response).length > 0 ){
											var records=response.rows;
											var recordLength = records.length;
											if(recordLength==0){
												isTransDone = true;
											}
											var grid=$this.getOnlinePaymentGridForPortal();
											var gridRecords = grid.selModel.getSelection();
											/***for record is not there in the grid****/
											var responseBillIdsArray = [];
											for( var i = 0; i < records.length; i++) {
												responseBillIdsArray.push(records[i].billFeePlanRuleStageId);
											}

											for( var a = 0; a < gridRecords.length; a++) {
												for(rec in records){
													if(gridRecords[a].data.billFeePlanRuleStageId == records[rec].billFeePlanRuleStageId){
														if(gridRecords[a].data.totalBalanceAmount != records[rec].totalBalanceAmount){
															if(gridRecords[a].data.tempRemainingAmount >0){
																isTransDone = false;
															}else{
																isTransDone = true;
																break;
															}
														}
													}
												}
												if(responseBillIdsArray.indexOf(gridRecords[a].data.billFeePlanRuleStageId) === -1){
													/************* transaction Done ***************/
													isTransDone = true;
													break;
												}
											}

											if(isTransDone==false){
												$this.redirectOnlinePaymentProcessFromHeadLevelGrid(flagIsHostelFee,flagForHostelJSON,gridRecords);
											}else{
												showNotificationMessage(getCommonTranslation('PAYMENT_PEOCESS'), getFeeAndPaymentCommonTranslation('PAYMENT_ALREADY_DONE_FOR_INVOICE')); 
												whetherGridRefresh =true;
												var grid = $this.getOnlinePaymentGridForPortal();
												if($this.getCurrentLoggedPortalId() == 1){
													var pendingGrid = $this.getDebitnoteandcreditnotepanel().down('pendingbillsgrid');
													var billIdsArray = [];
													var gridRec=pendingGrid.getSelectionModel().getSelection();
													for( var i = 0; i < gridRec.length; i++) {
														billIdsArray.push(gridRec[i].data.billId);
													}
													grid.getStore().getProxy().extraParams={
														id : userId,
														billedUserType : 'STUDENT',
														adjustmentType : 'Bill Receivable',
														screen:'erp',
														billIds:billIdsArray.join(),
														showAllSettlement : 'Pending',
														limit : -1
													};	
												}else{
													grid.getStore().getProxy().extraParams={
														id : userId,
														billedUserType : 'STUDENT',
														adjustmentType : 'Bill Receivable',
														showAllSettlement : 'Pending',
														limit : -1
													};
												}

												grid.getStore().load();
											}
										}
									}

								});


								/****************************End**************************/
							}
						});
					}else{
						 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
					 }
				} 
			},
			
			'onlinepaymentbilllevelgridforportal':{
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					this.onlinePaymentSTPortalGridCellClick(grid,td, cellIndex, record, tr, rowIndex, e, eOpts );
				}},
  		'onlinepaymentbilllevelgridforportal[itemId=opbilllevelgridforSTportal]': {
  			afterrender: function(grid){
  				var this$= this;
		        this.disableMoreActionPivileges(grid,this.getSTUDENT_ONLINE_PAYMENTS_PERMISSIONS());
                this.disableMoreActionPivileges(grid,this.getSTUDENT_ONLINE_PAYMENTS_PERMISSIONS());
  				var bankField = grid.down('#bankItemId');
  				var btnPaytmTechprocess = grid.down('#btnPaytmTechprocess');
				 var allowblankFalse = '<span class="required" style="color:red"> *</span>';
				 bankField.setFieldLabel(getCommonTranslation('BANK')+allowblankFalse);
			
  				if(this$.getCurrentLoggedPortalId() == 7)
        		{
  					this$.disableMoreActionPivileges(grid, this$.getPARENT_ONLINE_PAYMENTS_PERMISSIONS());
        		}else if(this$.getCurrentLoggedPortalId() == 3){
        			this$.disableMoreActionPivileges(grid,this$.getSTUDENT_ONLINE_PAYMENTS_PERMISSIONS());
        		}else{
        			this$.disableMoreActionPivileges(grid,this$.getSTUDENT_BILLS_ONLINE_PAYMENTS_PERMISSIONS());
        			var paytmPaymentButton = grid.down('#btnPaytmPayment');
        			paytmPaymentButton.setVisible(false);
        			btnPaytmTechprocess.setVisible(false);
        		}
  				
  				var personProfile = this$.getContentPanelActiveTab();
  				var userId = personProfile.getUserId();
  				if (personProfile) {
  					if(!isNullOrEmpty(userId)){
  						if(this$.getCurrentLoggedPortalId() == 1){
							var pendingGrid = this$.getDebitnoteandcreditnotepanel().down('pendingbillsgrid');
							var billIdsArray = [];
							var gridRec=pendingGrid.getSelectionModel().getSelection();
							for( var i = 0; i < gridRec.length; i++) {
	            				billIdsArray.push(gridRec[i].data.billId);
	            			}
							grid.getStore().getProxy().extraParams={
								id : userId,
								billedUserType : 'STUDENT',
								adjustmentType : 'BILL_RECEIVABLE',
								screen:'erp',
								billIds:billIdsArray.join(),
								limit : -1
							};	
						}else{
  						grid.getStore().getProxy().extraParams={
  							id : userId,
  							billedUserType : 'STUDENT',
  							raiseBillCategory : 'BILL_RECEIVABLE',
  							limit : -1
  						};
						}
  						grid.getStore().load({
  							callback: function(record, operation, success) {
  								if (record.length > 0) {
  									for(var i in record){
  		                				if (record[i].data.whetherDisplayTotal != false) {
  									this$.toggleGridSummaryRow(grid,true);
  		                				}
  		                			}
  								}else{
  									this$.toggleGridSummaryRow(grid,false);
  								}
  								for(var i in record) {
  									if (record[i].data.whetherActive == true && record[i].data.whetherChecked == true)
  									{	
  										grid.getSelectionModel().select(record[i],true);
  									}
  									if (record[i].data.whetherActive == true && record[i].data.whetherChecked == false)
  									{	
  										grid.getSelectionModel().deselect(record[i],true);
  									}
  								}
  							}
  						});
  					}
  				}
  				var XMLHttpRequestObject = false;  
				   if (window.XMLHttpRequest) {  
					   XMLHttpRequestObject = new XMLHttpRequest();  
					   XMLHttpRequestObject.overrideMimeType("text/xml");  
				   }  
				   else if (window.ActiveXObject) {  
					   XMLHttpRequestObject = new  
					   ActiveXObject("Microsoft.XMLHTTP");  
				   } 
				   if(XMLHttpRequestObject) {  
					   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
					   XMLHttpRequestObject.onreadystatechange = function() {       
						   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
							   var xmlDocument = XMLHttpRequestObject.responseXML;  
							   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
							   paymentPostUrl = buildInfo.getElementsByTagName("paymentPostUrl") [0].childNodes[0].nodeValue;
							   techprocessPaymentPostUrl = buildInfo.getElementsByTagName("techprocessPaymentPostUrl") [0].childNodes[0].nodeValue;
							   Ext.apply(grid,{
								   paymentPostUrl:null,
								   techprocessPaymentPostUrl :null,
								   setPaymentPostUrl : function(paymentPostUrl){
									   grid.paymentPostUrl = paymentPostUrl;
								   },
								   getPaymentPostUrl:function(){
									   return grid.paymentPostUrl;
								   },
								   setTechprocessPaymentPostUrl : function(techprocessPaymentPostUrl){
									   grid.techprocessPaymentPostUrl = techprocessPaymentPostUrl;
								   },
								   getTechprocessPaymentPostUrl:function(){
									   return grid.techprocessPaymentPostUrl;
								   }
							   });
 							   grid.setPaymentPostUrl(paymentPostUrl);
							   grid.setTechprocessPaymentPostUrl(techprocessPaymentPostUrl);
						   }  
					   }  
					   XMLHttpRequestObject.send(null);  
				   }
  			},
	select :function($this, record, index){
	        		var grid = this.getOnlinepaymentbilllevelgridforportal();
	        		this.getCheckedBillsForStudent($this, record, index, 'select',grid);
	        	},
	        	deselect :function($this, record, index){
	        		var grid = this.getOnlinepaymentbilllevelgridforportal();
	        		this.getCheckedBillsForStudent($this, record, index, 'deselct',grid);
	        	}
	
			},
			'onlinepaymentbilllevelgridforportal[itemId=opbilllevelgridforSTportal] numberfield[itemId=amountToBeAdjusted]': {
				change : function(obj,newValue){
					var grid = obj.ownerCt.grid;
					var selectedRow = grid.getSelectionModel().getSelection()[0];
					var amounttobeadjusted = obj.getValue();

					var totaltempbalanceamount = selectedRow.get('totalTempBalanceAmount');
					var remainingAmount = totaltempbalanceamount - amounttobeadjusted
					if(amounttobeadjusted == 0){
						obj.reset();
						grid.getSelectionModel().deselect(selectedRow);
						showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));//Please select a reco
					}
					if(totaltempbalanceamount < amounttobeadjusted){
						obj.reset();
						grid.getSelectionModel().deselect(selectedRow);
						showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_EQUALORLESSTHAN_BALANCE_AMOUNT'));//Please select a reco
					}
					var storeItems = grid.getStore().data.items;
					var paymentMndatoryRecArr = [];
					Ext.each(storeItems,function(rec){
						if((rec.data.whetherMandatoryToPay && rec.data.whetherActive) || rec.data.whetherChecked) {
							paymentMndatoryRecArr.push(rec);
						}
					});
					paymentMndatoryRecArr.push(selectedRow);
					if(paymentMndatoryRecArr.length>0) {
						grid.getSelectionModel().select(paymentMndatoryRecArr);						
					}
				},
				blur : function(obj,newValue){
					var grid = obj.ownerCt.grid;
					var selectedRow = grid.getSelectionModel().getSelection()[0];
					var amounttobeadjusted = obj.getValue();

					var totaltempbalanceamount = selectedRow.get('totalTempBalanceAmount');
					var remainingAmount = totaltempbalanceamount - amounttobeadjusted
					selectedRow.set('tempRemainingAmount',remainingAmount);

					if(totaltempbalanceamount < amounttobeadjusted){
						obj.reset();
						grid.getSelectionModel().deselect(selectedRow);
						showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_EQUALORLESSTHAN_BALANCE_AMOUNT'));//Please select a reco
					}
					var storeItems = grid.getStore().data.items;
					var paymentMndatoryRecArr = [];
					Ext.each(storeItems,function(rec){
						if((rec.data.whetherMandatoryToPay && rec.data.whetherActive) || rec.data.whetherChecked) {
							paymentMndatoryRecArr.push(rec);
						}
					});
					paymentMndatoryRecArr.push(selectedRow);
					if(paymentMndatoryRecArr.length>0) {
						grid.getSelectionModel().select(paymentMndatoryRecArr);						
					}
				}
			
			},
			'onlinepaymentbilllevelgridforportal[itemId=opbilllevelgridforSTportal] button[itemId=btnView]': {
				click: function(obj){
					var $this = this;
					var grid = this.getOnlinepaymentbilllevelgridforportal();
					var personProfile = $this.getContentPanelActiveTab();
					var bankField = grid.down('#bankItemId');
					var userId = personProfile.getUserId();
					var thresholdValue;
					var bankChareApplicable;
					if(grid.getSelectionModel().getCount()>0){
						if($this.getCostCenterValidationAtBillLevel(grid)){
							return  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BILL_PAYMENT_IS_NOT_ALLOWED_FOR_INVOICES_WITH_MULTIPLE_COST_CENTERS'));
						}
						Ext.Ajax.request({
							method: "GET",
							type: 'rest',
							scope:$this,
							url: SERVERURL.ORGINFOLOADREQUEST,
							success: function(response, action) {
								var data = JSON.parse(response.responseText);
								var grid = $this.getOnlinepaymentbilllevelgridforportal();
								if(data.whetherOnlinePaymentSettings && grid.getSelectionModel().getCount()>1){
									return showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MULTIPLE_INVOICES_DETECTED_PLEASE_SELECT_ONLY_ONE_INVOICE_TO_PROCEED_WITH_ONLINE_PAYMENT')); 
								}
								var gridRecords = grid.selModel.getSelection();
								var flagIsHostelFee = true;
								var flagForHostelJSON=true;
								var count;
								var whetherGridRefresh = false;
								for( var i = 0; i < gridRecords.length; i++) {
									count = i;
									for( var j = i; j < gridRecords.length; j++) {
										if(gridRecords[i].data.isHostelFee==true){
											if(gridRecords[j].data.isHostelFee==true){
												flagIsHostelFee=true;
												flagForHostelJSON=true;
											}else{
												flagIsHostelFee=false;
												break;
											}
										}else if(gridRecords[i].data.isHostelFee==false){
											if(gridRecords[j].data.isHostelFee==true){
												flagIsHostelFee=false;
												break;
											}else{
												flagIsHostelFee=true;
												flagForHostelJSON=false;
											}
										}
									}
									if(flagIsHostelFee==false){
										break;
									}
								}
								/***************new code to be written here -start*****************/
								if($this.getCurrentLoggedPortalId() == 1){
									var pendingGrid = $this.getDebitnoteandcreditnotepanel().down('pendingbillsgrid');
									var billIdsArray = [];
									var gridRec=pendingGrid.getSelectionModel().getSelection();
									for( var i = 0; i < gridRec.length; i++) {
										billIdsArray.push(gridRec[i].data.billId);
									}
									params={
											id : userId,
											billedUserType : 'STUDENT',
											adjustmentType : 'BILL_RECEIVABLE',
											screen:'erp',
											billIds:billIdsArray.join(),
											limit : -1,
											page: 1
									};	
								}else{
									params={
											id : userId,
											billedUserType : 'STUDENT',
											raiseBillCategory : 'BILL_RECEIVABLE',
											limit : -1,
											page: 1
									};
								}
								var grid = $this.getOnlinepaymentbilllevelgridforportal();
								var submitUrl = SERVERURL.ONLINE_PAYMENT_BILL_LEVEL_GRID;
								Ext.Ajax.request({
									type : 'rest',
									url : submitUrl,
									params : params,
									method : 'GET',
									success: function(res, action) {
										var isTransDone=false;
										var response = Ext.decode(res.responseText);

										if( Object.keys(response).length > 0 ){
											var responseRecords=response.rows;
											var recordLength = responseRecords.length;
											if(recordLength==0){
												isTransDone = true;
											}
											var grid=$this.getOnlinepaymentbilllevelgridforportal();
											var gridRecords = grid.selModel.getSelection();

											/***for record is not there in the grid****/
											var responseBillIdsArray = [];
											for( var i = 0; i < responseRecords.length; i++) {
												responseBillIdsArray.push(responseRecords[i].billId);
											}

											for( var a = 0; a < gridRecords.length; a++) {
												for(rec in responseRecords){
													if(gridRecords[a].data.billId == responseRecords[rec].billId){
														if(gridRecords[a].data.balanceAmount != responseRecords[rec].balanceAmount){
															if(gridRecords[a].data.tempRemainingAmount >0){
																isTransDone = false;
															}else{
																isTransDone = true;
																break;
															}

														}
													}

												}
												if(responseBillIdsArray.indexOf(gridRecords[a].data.billId) === -1){
													/************* transaction Done ***************/
													isTransDone = true;
													break;
												}
											}

											if(isTransDone==false){
												$this.redirectOnlinePaymentProcess(flagIsHostelFee,flagForHostelJSON,gridRecords);
											}else{
												showNotificationMessage(getCommonTranslation('PAYMENT_PEOCESS'), getFeeAndPaymentCommonTranslation('PAYMENT_ALREADY_DONE_FOR_INVOICE')); 
												whetherGridRefresh =true;
												var grid = $this.getOnlinepaymentbilllevelgridforportal();
												if($this.getCurrentLoggedPortalId() == 1){
													var pendingGrid = $this.getDebitnoteandcreditnotepanel().down('pendingbillsgrid');
													var billIdsArray = [];
													var gridRec=pendingGrid.getSelectionModel().getSelection();
													for( var i = 0; i < gridRec.length; i++) {
														billIdsArray.push(gridRec[i].data.billId);
													}
													grid.getStore().getProxy().extraParams={
														id : userId,
														billedUserType : 'STUDENT',
														adjustmentType : 'BILL_RECEIVABLE',
														screen:'erp',
														billIds:billIdsArray.join(),
														limit : -1
													};	
												}else{
													grid.getStore().getProxy().extraParams={
														id : userId,
														billedUserType : 'STUDENT',
														raiseBillCategory : 'BILL_RECEIVABLE',
														limit : -1
													};
												}

												grid.getStore().load();
											}
										}
									}

								});
							}
						});
						/****************new code written above - end****************/

					}else{
						showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
					}
				} 
			},
    		/*
    		
    		 'pendingbillsgrid[itemId=studentPendingBillsGrid]': {
                 render: function(grid) {
                	 var this$= this;
                	 var personProfile = this$.getContentPanelActiveTab();
                	 var userId = personProfile.getUserId();
                     var params = {
                     		id : userId,
                     		billedUserType : 'STUDENT',
         					raiseBillCategory : 'BILL_RECEIVABLE'
                     };
                	 
                     this.loadStudenPaymentGridStore('#studentPendingBillsGrid', SERVERURL.STUDENT_PENDING_BILLS_DETAILS, params);
                	 this.doAccessControlValidation(grid, this.getSTUDENT_PENDING_BILLS_PERMISSIONS());
                 }
             },*/
             /*'pendingbillsgrid[itemId=studentPendingBillsGrid] button[itemId=btnView]': {
                 click: function() {
                     this.viewPendingBill('PENDING_BILL', 'studentPendingBillsForm', '#studentPendingBillsGrid', SERVERURL.FIND_ALL_BILL_FEE_HEADS);
                 }
             },*/
			 'pendingbillsgrid[itemId=pendingBillsGridForErp] button[itemId=btnView]': {
				 click: function(btn) {
	                	var grid = btn.up('grid')
	                     this.viewPendingBill('PENDING_BILL', 'studentPendingBillsForm', grid, SERVERURL.FIND_ALL_BILL_FEE_HEADS);
	                }
              },
              'creditnotegrid[itemId=creditNoteGridForErp] button[itemId=btnView]': {
            	  click: function(btn) {
                  	var grid = btn.up('grid')
                       this.viewPendingBill('PENDING_BILL', 'studentPendingBillsForm', grid, SERVERURL.FIND_ALL_BILL_FEE_HEADS);
                  }
              },	               
             'pendingbillsgridforstudentportal button[itemId=btnStudentPrintTaxCertificatePortal]': {
                 click: function() {
                	 this.showStudentTaxCertificateWindowWin();
                 }
             },
             'pendingbillsgridforstudentportal button[itemId=btnView]':{
            	 click: function(btn) {
	                	var grid = btn.up('grid')
	                     this.viewPendingBill('PENDING_BILL', 'studentPendingBillsForm', grid, SERVERURL.FIND_ALL_BILL_FEE_HEADS);
	                }
             },
             'studentprinttaxcertificateportal button#btnPrint': {
 	        	click: function(button) {
 	        		var grid = this.getSearchResultGrid();
 	        		this.exportPrintCertificateJRXMLPortal('pdf',grid);
     			}
 	        },
 	       'studentprinttaxcertificateportal button#cancelButton': {
	        	click: function(button) {
	        		var $this=this;
	        		var formWindow = $this.getStudentprinttaxcertificateportal();
	            	if (!formWindow) {
	            		Ext.widget('studentprinttaxcertificateportal');
	            		formWindow = $this.getStudentprinttaxcertificateportal();
	            		
	            	}
	            	formWindow.close();
    			}
	        },
             /**
     		 * Pending Bills
     		 */
	        'pendingbillsgrid[itemId=pendingBillsGridForErp]': {
	        	render: function(grid) {
	        		var this$= this;
            		 var academyLocationId = this$.getCurrentAcademyLocation();
            		 Ext.Ajax.request({
   		    		  method: "GET",
   		    		  type: 'rest',
   		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
   		    		  params:{
   		    			  academyLocationId: academyLocationId
   		    		  },
   		    		  success: function(response) {
   		    			  if(response){
   		    				  result=response.responseText;	
   		    			  }
   		    	    		  if(result === "false"){
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length != null && length != ""){
   		    	 					 for(var i = 0; i < length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
   		    	 							 gridColumns[i].setVisible(false);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	 			  }else{
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length!=null && length!=""){
   		    	 					 for(var i=0; i<length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
   		    	 							 gridColumns[i].setVisible(true);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	    	  }
   		    		  }
   		    	  });
	        		var personProfile = this$.getContentPanelActiveTab();
	        		var userId = personProfile.getUserId();
	        		var params = {
	        				id : userId,
	        				billedUserType : 'STUDENT',
	        				whetherDeleted: false,
	        				billStatus:"",
	        				raiseBillCategory:'BILL_RECEIVABLE'
	        					/* End
	        					 */

	        		};
            		 if(portalId == 3){
            			 setTimeout(function(){
            			 var gridColumns=grid.columns;
       	 				 var length = gridColumns.length;
       	 				 if(length != null && length != ""){
       	 					 for(var i = 0; i < length; i++){
       	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
       	 							 gridColumns[i].destroy();
       	 						 }
       	 					 }
       	 				 } 
            			 },300);
            		 }
            		 this.loadStudenPaymentBillsGridStore(grid, SERVERURL.STUDENT_PENDING_BILLS_DETAILS, params);
	        		portalId = this.getCurrentLoggedPortalId();
	        		if(portalId == 7){
	        			this.doAccessControlValidation(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
	        			this.disablePendingBillsGridActionPivileges(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
	        		}else if(portalId == 2){
	        			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	        		}else if(portalId == 3){
	        			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	        			this.disablePendingBillsGridActionPivileges(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	        		}else{
	        			this.doAccessControlValidation(grid, this.getSTUDENT_PENDING_BILLS_PERMISSIONS());
	        			grid.down('#btnPrint').setVisible(true);
	        			this.stdDisablePendingBillMakePaymentPivileges(grid, this.getSTUDENT_PENDING_BILLS_PERMISSIONS());
	        		}
	        	},
	        	select :function($this, record, index){
	        		var grid = this.getDebitnoteandcreditnotepanel().down('pendingbillsgrid');
	        		this.getCheckedBillsForStudent($this, record, index, 'select',grid);
	        	},
	        	deselect :function($this, record, index){
	        		var grid = this.getDebitnoteandcreditnotepanel().down('pendingbillsgrid');
		        	
	        		this.getCheckedBillsForStudent($this, record, index, 'deselct',grid);
	        	}
	        },
             // Duplicate function line no: 640
              /*'pendingbillsgrid[itemId=studentPendingBillsGrid] button[itemId=btnView]': {
                  click: function() {
                      this.viewPendingBill('PENDING_BILL', 'studentPendingBillsForm', '#studentPendingBillsGrid', SERVERURL.FIND_ALL_BILL_FEE_HEADS);
                  }
              },*/
	        
	        'creditnotegrid[itemId=creditNoteGridForErp]': {
	        	render: function(grid) {
	        		var this$= this;
            		 var academyLocationId = this$.getCurrentAcademyLocation();
            		 if(portalId == 1)
        			 {
        			 grid.down('#btnStudentPrintTaxCertificatePortal').setVisible(false);
        			 grid.down('#btnPrint').setVisible(false);
        			 }
            		 Ext.Ajax.request({
   		    		  method: "GET",
   		    		  type: 'rest',
   		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
   		    		  params:{
   		    			  academyLocationId: academyLocationId
   		    		  },
   		    		  success: function(response) {
   		    			  if(response){
   		    				  result=response.responseText;	
   		    			  }
   		    	    		  if(result === "false"){
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length != null && length != ""){
   		    	 					 for(var i = 0; i < length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
   		    	 							 gridColumns[i].setVisible(false);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	 			  }else{
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length!=null && length!=""){
   		    	 					 for(var i=0; i<length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
   		    	 							 gridColumns[i].setVisible(true);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	    	  }
   		    		  }
   		    	  });
	        		var personProfile = this$.getContentPanelActiveTab();
	        		var userId = personProfile.getUserId();
	        		var params = {
	        				id : userId,
	        				billedUserType : 'STUDENT',
	        				whetherDeleted: false,
	        				billStatus:"",
	        				raiseBillCategory:'BILL_PAYABLE'
	        					/* End
	        					 */

	        		};
            		 if(portalId == 3){
            			 setTimeout(function(){
            			 var gridColumns=grid.columns;
       	 				 var length = gridColumns.length;
       	 				 if(length != null && length != ""){
       	 					 for(var i = 0; i < length; i++){
       	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
       	 							 gridColumns[i].destroy();
       	 						 }
       	 					 }
       	 				 } 
            			 },300);
            		 }
            		 this.loadStudenCreditNoteGridStore(grid, SERVERURL.STUDENT_PENDING_BILLS_DETAILS, params);
	        		portalId = this.getCurrentLoggedPortalId();
	        		if(portalId == 7){
	        			this.doAccessControlValidation(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
	        			this.disablePendingBillsGridActionPivileges(grid, this.getPARENT_PENDING_BILLS_PERMISSIONS());
	        		}else if(portalId == 2){
	        			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	        		}else if(portalId == 3){
	        			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	        			this.disablePendingBillsGridActionPivileges(grid, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	        		}
	        	},
	        	select :function($this, record, index){
	        		var grid = this.getDebitnoteandcreditnotepanel().down('creditnotegrid');
	        	
	        		this.getCheckedBillsForStudent($this, record, index, 'select',grid);
	        	},
	        	deselect :function($this, record, index){
	        		var grid = this.getDebitnoteandcreditnotepanel().down('creditnotegrid');
		        	
	        		this.getCheckedBillsForStudent($this, record, index, 'deselct',grid);
	        	}
	        },
             
	        
            /*  'pendingbillsgrid[itemId=studentPendingBillsGrid] button[itemId=btnPrint]': {
             	 click : function(){
   				   var gridType = "student";
   				   var grid = this.getPendingBillsGrid();
   				   this.exportJRXMLForPendingBill('pdf',gridType,grid);
   			   }
              },*/
	      
             /**
     		 * Payment Recieved History 
     		 */
             
             'paymentreceivedhistorygrid[itemId=studentPaymentReceivedHistoryGrid]': {
                 render: function(grid) {
                	 var this$= this;
            		 var academyLocationId = this$.getCurrentAcademyLocation();
            		 Ext.Ajax.request({
   		    		  method: "GET",
   		    		  type: 'rest',
   		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
   		    		  params:{
   		    			  academyLocationId: academyLocationId
   		    		  },
   		    		  success: function(response) {
   		    			  if(response){
   		    				  result=response.responseText;	
   		    			  }
   		    	    		  if(result === "false"){
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length != null && length != ""){
   		    	 					 for(var i = 0; i < length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   		    	 							 gridColumns[i].setVisible(false);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	 			  }else{
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length!=null && length!=""){
   		    	 					 for(var i=0; i<length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   		    	 							 gridColumns[i].setVisible(true);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	    	  }
   		    		  }
   		    	  });
                	 var personProfile = this$.getContentPanelActiveTab();
                	 var userId = personProfile.getUserId();
                     var params = {
                    		 studentId : userId
                     };
                     this.loadStudenReceiptGridStore('#studentPaymentReceivedHistoryGrid', SERVERURL.STUDENT_PAYMENT_RECIEVED_DETAILS, params);
                    
                     portalId = this.getCurrentLoggedPortalId();
                     if(portalId == 7){
            			 this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_PAYMENT_RECIEVED_PERMISSIONS());
            		 }else if(portalId == 2){
            			 this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_PAYMENT_RECIEVED_PERMISSIONS());
            		 }else if(portalId == 3){
            			 this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_PAYMENT_RECIEVED_PERMISSIONS());
//            			 this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_PAYMENT_RECIEVED_DATA_GRID_PERMISSIONS());
            		 }else{
            			 this.doAccessControlValidation(grid, this.getSTUDENT_PAYMENT_RECIEVED_PERMISSIONS());
            		 }
                	 var grid = personProfile.down('#studentPaymentReceivedHistoryGrid');
                     
                	 Ext.defer(function() {
                		 var portalId = this.getCurrentLoggedPortalId();
                		 if(portalId == 3 || portalId == 7) {
                			 if(grid.columnManager.columns!=null)
                			 {
                				 for(var i=grid.columnManager.columns.length-1;i>=0;i--) {
                					 var column = grid.columnManager.columns[i];
                					 if(column.dataIndex == 'billType'){
                						 column.hide();
                					 }
                				 }
                			 }
                		 } }, 50, this);
                 	
                 },
                 afterrender:function(grid){
                	 var me = this;
                	 portalId = this.getCurrentLoggedPortalId();
                	 if(portalId == 3){
                		 setTimeout(function(){
                			 me.addDataGridConfigButton(grid,me.getSTUDENT_PORTAL_STUDENT_PAYMENT_RECIEVED_PERMISSIONS());
                		 },1500);
                	 }else if(portalId == 1){
                		 setTimeout(function(){
                			 me.addDataGridConfigButton(grid,me.getSTUDENT_PAYMENT_RECIEVED_PERMISSIONS());
                		 },1500);
                	 }
                 },
                 cellclick: function(view, cell, cellIndex, record, row, rowIndex, e){
                	 var cellDataIndex = view.getGridColumns()[cellIndex].dataIndex;
                	 if (cellDataIndex == "adjustment") {
                    	 //this.viewPaymentRecievedHistory('PAYMENT_RECIEVED_HISTORY', 'billheaderadjustmentdetailsgridwindow', '#studentPaymentReceivedHistoryGrid', SERVERURL.BILL_HEADER_ADJUSTMENT_DETAILS);
                    	 this.viewPaymentRecievedHistoryForProfile('PAYMENT_RECIEVED_HISTORY', 'receiptsettlementheadwindow', '#studentPaymentReceivedHistoryGrid', SERVERURL.BILL_HEADER_ADJUSTMENT_DETAILS, record);
                     }else if(cellDataIndex == "instrument"){
                    	 this.viewPaymentRecievedHistory('PAYMENT_RECIEVED_HISTORY', 'studentpaymentheaderinstrumentadjustmentdetailsgridwindow', '#studentPaymentReceivedHistoryGrid', SERVERURL.PAYMENT_HEADER_INSTRUMENT_ADJUSTMENT_DETAILS,record);
                     }
              		
                 },
	        	select :function($this, record, index){
	        		this.getCheckedReceiptsForStudent($this, record, index, 'select');
	        	},
	        	deselect :function($this, record, index){
	        		this.getCheckedReceiptsForStudent($this, record, index, 'deselct');
	        	}
             },
             'paymentreceivedhistorygrid[itemId=studentPaymentReceivedHistoryGrid] button[itemId=btnPrint]': {
            	 click : function(obj){
            		 $this= this;
            		 var gridType = "student";
            		 var personProfile = $this.getContentPanelActiveTab();
            		 var grid = personProfile.down('paymentreceivedhistorygrid');
            		 if(grid!=null){
            			 this.exportJRXMLForStudent('pdf',gridType,grid);  
            		 }
            		 //var grid = this.getPaymentReceivedHistoryGrid()
            	 }
             },
             /**
      		 * Refunds History 
      		 */
              
              'refundhistorygrid[itemId=studentRefundHistoryGrid]': {
                  render: function(grid) {
                	  var this$= this;
             		 var academyLocationId = this$.getCurrentAcademyLocation();
            		 Ext.Ajax.request({
   		    		  method: "GET",
   		    		  type: 'rest',
   		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
   		    		  params:{
   		    			  academyLocationId: academyLocationId
   		    		  },
   		    		  success: function(response) {
   		    			  if(response){
   		    				  result=response.responseText;	
   		    			  }
   		    	    		  if(result === "false"){
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length != null && length != ""){
   		    	 					 for(var i = 0; i < length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   		    	 							 gridColumns[i].setVisible(false);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	 			  }else{
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length!=null && length!=""){
   		    	 					 for(var i=0; i<length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   		    	 							 gridColumns[i].setVisible(true);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	    	  }
   		    		  }
   		    	  });
                	  var personProfile = this$.getContentPanelActiveTab();
                	  var userId = personProfile.getUserId();
                      var params = {
                    		  studentId : userId
                      };
                 	 if(portalId == 3){
            			 setTimeout(function(){
            			 var gridColumns=grid.columns;
       	 				 var length = gridColumns.length;
       	 				 if(length != null && length != ""){
       	 					 for(var i = 0; i < length; i++){
       	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
       	 							 gridColumns[i].destroy();
       	 						 }
       	 					 }
       	 				 } 
            			 },300);
            		 }
                      this.loadStudenRefundHistoryGridStore('#studentRefundHistoryGrid', SERVERURL.STUDENT_REFUNDS_HISTORY_DETAILS, params);  
                     portalId = this.getCurrentLoggedPortalId();
            		 if(portalId == 7){
            			 this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_REFUNDS_PERMISSIONS());
            		 }else if(portalId == 2){
            			 this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_REFUNDS_PERMISSIONS());
            		 }else if(portalId == 3){
            			 this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_REFUNDS_PERMISSIONS());
            		 }else{
            			 this.doAccessControlValidation(grid, this.getSTUDENT_REFUNDS_PERMISSIONS());
            		 }
                  },
                  cellclick: function(view, cell, cellIndex, record, row, rowIndex, e){
                 	 var cellDataIndex = view.getGridColumns()[cellIndex].dataIndex;
                 	 if (cellDataIndex == "adjustment") {
                     	 this.viewRefundHistory('REFUND_HISTORY', 'billheaderadjustmentdetailsgridwindow', '#studentRefundHistoryGrid', SERVERURL.BILL_HEADER_ADJUSTMENT_DETAILS);   
                      }else if(cellDataIndex == "instrument"){
                     	 this.viewRefundHistory('REFUND_HISTORY', 'paymentheaderinstrumentadjustmentdetailsgridwindow', '#studentRefundHistoryGrid', SERVERURL.PAYMENT_HEADER_INSTRUMENT_ADJUSTMENT_DETAILS);
                      }
               		
                  }
                  
              },
              
              /**
        		 * Refundable Payment History 
        		 */
                
                'refundablepaymentgrid[itemId=studentRefundablePaymentGrid]': {
                	render: function(grid) {
                		var this$= this;
               		 var academyLocationId = this$.getCurrentAcademyLocation();
            		 Ext.Ajax.request({
   		    		  method: "GET",
   		    		  type: 'rest',
   		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
   		    		  params:{
   		    			  academyLocationId: academyLocationId
   		    		  },
   		    		  success: function(response) {
   		    			  if(response){
   		    				  result=response.responseText;	
   		    			  }
   		    	    		  if(result === "false"){
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length != null && length != ""){
   		    	 					 for(var i = 0; i < length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   		    	 							 gridColumns[i].setVisible(false);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	 			  }else{
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length!=null && length!=""){
   		    	 					 for(var i=0; i<length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   		    	 							 gridColumns[i].setVisible(true);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	    	  }
   		    		  }
   		    	  });
                		var personProfile = this$.getContentPanelActiveTab();
                		var userId = personProfile.getUserId();
                		var params = {
                				id : userId,
                				billedUserType : 'STUDENT',
                				raiseBillCategory : 'BILL_PAYABLE'
                		};
               		 if(portalId == 3){
            			 setTimeout(function(){
            			 var gridColumns=grid.columns;
       	 				 var length = gridColumns.length;
       	 				 if(length != null && length != ""){
       	 					 for(var i = 0; i < length; i++){
       	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
       	 							 gridColumns[i].destroy();
       	 						 }
       	 					 }
       	 				 } 
            			 },300);
            		 }
                		this.loadStudenPaymentGridStore('#studentRefundablePaymentGrid', SERVERURL.STUDENT_PENDING_BILLS_DETAILS, params);
                		portalId = this.getCurrentLoggedPortalId();
                		if(portalId == 7){
                			this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_REFUNDABLE_PAYMENTS_PERMISSIONS());
                		}else if(portalId == 2){
                			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_REFUNDABLE_PAYMENTS_PERMISSIONS());
                		}else if(portalId == 3){
                			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_REFUNDABLE_PAYMENTS_PERMISSIONS());
                		}else{
                			this.doAccessControlValidation(grid, this.getSTUDENT_REFUNDABLE_PAYMENTS_PERMISSIONS());
                			this.doAccessControlValidation(grid, this.getSTUDENT_REFUNDABLE_PAYMENTS_PERMISSIONS());
                		}
                	}
                },
                'refundablepaymentgrid[itemId=studentRefundablePaymentGrid] button[itemId=btnView]': {
                    click: function() {
                        this.viewRefundablePaymentHistory('REFUNDABLE_PAYMENT', 'studentRefundablePaymentForm', '#studentRefundablePaymentGrid', SERVERURL.FIND_ALL_BILL_FEE_HEADS);
                    }
                },
             
             /**
      		 * Post Dated Cheque
      		 */
             'postdatedchequegrid[itemId=studentPostDatedChequeGrid]': {
                 render: function(grid) {
                	 
                	 var this$= this;
              		 var academyLocationId = this$.getCurrentAcademyLocation();
            		 Ext.Ajax.request({
   		    		  method: "GET",
   		    		  type: 'rest',
   		    		  url: SERVERURL.PATH_FIND_WHETHER_MULTI_CURR_APPLICABLE_FOR_ACAD_LOC,
   		    		  params:{
   		    			  academyLocationId: academyLocationId
   		    		  },
   		    		  success: function(response) {
   		    			  if(response){
   		    				  result=response.responseText;	
   		    			  }
   		    	    		  if(result === "false"){
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length != null && length != ""){
   		    	 					 for(var i = 0; i < length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   		    	 							 gridColumns[i].setVisible(false);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	 			  }else{
   		    	 				 var gridColumns=grid.columns;
   		    	 				 var length = gridColumns.length;
   		    	 				 if(length!=null && length!=""){
   		    	 					 for(var i=0; i<length; i++){
   		    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   		    	 							 gridColumns[i].setVisible(true);
   		    	 						 }
   		    	 					 }
   		    	 				 }
   		    	    	  }
   		    		  }
   		    	  });
                	 var personProfile = this$.getContentPanelActiveTab();
                	 var userId = personProfile.getUserId();
                     var params = {
                     		id : userId,
                     		billedUserType : 'STUDENT'
                     };
                     this.loadStudenPaymentGridStore('#studentPostDatedChequeGrid', SERVERURL.PERSON_POST_DATED_CHEQUE_DETAILS, params);
                     portalId = this.getCurrentLoggedPortalId();
             		if(portalId == 7){
             			this.doAccessControlValidation(grid, this.getPARENT_PORTAL_STUDENT_POST_DATED_CHEQUES_PERMISSIONS());
             		}else if(portalId == 2){
             			this.doAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_POST_DATED_CHEQUES_PERMISSIONS());
             		}else if(portalId == 3){
             			this.doAccessControlValidation(grid, this.getSTUDENT_PORTAL_STUDENT_POST_DATED_CHEQUES_PERMISSIONS());
             		}else{
             			this.doAccessControlValidation(grid, this.getSTUDENT_POST_DATED_CHEQUES_PERMISSIONS());
             		}
                	 
                 }
             },
             /**
              * scholarships list	
              */
             'searchresultgrid[itemId=STscholarshipListGrid] splitbutton[itemId=exportToPdfBtn] #exportCurrentPage': {
            	 click: function() {
            		 this.exportScholarshipList(SERVERURL.PDFEXPORT,'pdf',false);
            	 }
             },
             'searchresultgrid[itemId=STscholarshipListGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
            	 click: function() {
            		 this.exportScholarshipList(SERVERURL.PDFEXPORT,'pdf',true);
            	 }
             },
             'searchresultgrid[itemId=STscholarshipListGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
            	 click: function() {
            		 this.exportScholarshipList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
            	 }
             },
             'searchresultgrid[itemId=STscholarshipListGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
            	 click: function() {
            		 this.exportScholarshipList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
            	 }
             },
             'searchresultgrid[itemId=STscholarshipListGrid]': {
            	 render: function(grid) {
            		 grid.setTitle('Scholarships');
            		 grid.addExportButtonToolbar();
            		 this.loadScholarshipListGrid();
            		 portalId = this.getCurrentLoggedPortalId();
            		 if(portalId == 2){
            			 this.genericCBGridAccessControlValidation(grid, this.getFACULTY_PORTAL_STUDENT_SCHOLARSHIP_PERMISSIONS());
            		 }else{
            			 this.genericCBGridAccessControlValidation(grid, this.getSTUDENT_SCHOLARSHIP_PERMISSIONS());
            		 }

            	 }
             },
             
             'pendingbillsfilter button[itemId=searchBtn]':{
     			click:this.loadPendingBillGrid
     		},
     		
            'pendingbillsfilter button[itemId=resetBtn]':{
            	 click:function(obj, rec){
    				 var $this = this;
    				 var form = $this.getPendingbillsfilter().getForm().reset();
    			 }
     		},
     		 'pendingcreditfilter button[itemId=searchBtn]':{
      			click:this.loadPendingCreditGrid
      		},
      		
             'pendingcreditfilter button[itemId=resetBtn]':{
             	 click:function(obj, rec){
     				 var $this = this;
     				 var form = $this.getPendingcreditfilter().getForm().reset();
     			 }
      		},
			'onlinepaymentgridforportal[itemId=onlinepaymentgridforstudentportal] button[itemId=btnPaytmPayment]': {
				click: function(obj){
					var $this = this;
					var grid = this.getOnlinePaymentGridForPortal();
					var personProfile = $this.getContentPanelActiveTab();
					var userId = personProfile.getUserId();
					if(grid.getSelectionModel().getCount()>0){
						var records = grid.selModel.getSelection();
						var totalAmount=0;
						var totalBalanceAmount=0;
						for(var i in records){
							var balanceAmounts = records[i].get('tempRemainingAmount');
							var amounts = records[i].get('totalBalanceAmount');
							if(isNullOrEmpty(amounts)){
								showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
								return false;
							}
							totalBalanceAmount = totalBalanceAmount + balanceAmounts;
							totalAmount = totalAmount + amounts;
						}
						if(totalBalanceAmount >=0 && totalAmount>0){ 
							var onlineAmount=[];
							for(var i in records){
								onlineAmount.push({
									"billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
									"billId":records[i].get('billHeaderId'),
									"adjustedAmount":records[i].get('totalBalanceAmount'),
									"balanceAmount": records[i].get('tempRemainingAmount')   
								});
							}
							var submitData = {
									"receiptAmount" : totalAmount,
									"onlinePayments" : onlineAmount
							};
							var amount=totalAmount;
							var orgModel = Academia.model.common.OrgSettingDateTimeModel;
							//var message = 'Are you sure, you want to make payment of ' + orgModel.get('currencyFormat') + ' ' +totalAmount+' ?';
							var currency = records[0].data.currencyId;
							var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);
							var message = 'Are you sure, you want to make payment of ' + billCurrency + ' ' +totalAmount+' ?';
							var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE
							showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
								if (btn == 'yes') {
									var XMLHttpRequestObject = false;  
									if (window.XMLHttpRequest) {  
										XMLHttpRequestObject = new XMLHttpRequest();  
										XMLHttpRequestObject.overrideMimeType("text/xml");  
									}  
									else if (window.ActiveXObject) {  
										XMLHttpRequestObject = new  
										ActiveXObject("Microsoft.XMLHTTP");  
									} 
									XMLHttpRequestObject.withCredentials = false;
									XMLHttpRequestObject.onreadystatechange = function() {
										if (this.readyState == 4 && this.status == 200) {
											var id = parseInt(XMLHttpRequestObject.responseText);
											if(!isNaN(id)) {
												var formWindow = Ext.widget('paymentsummarywin',{
													itemId:'studentPaytmPayment'
												});
												 var emailID = null;
           									    var mobileNo = null; 
           									  	if(portalId == 1){
           									  		 emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
           									  		mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
           									  	}else{
           									  		 emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
           									  		mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber
           									  	}
           									  
												formWindow.down('#name').setValue(records[0].data.printName);
												formWindow.down('#email').setValue(emailID);
												formWindow.down('#mobileNo').setValue(mobileNo);
												//formWindow.down('#amount').setValue(currencyRenderer(totalAmount,records.currencyId));
												 formWindow.down('#amount').setValue(billCurrency+' '+totalAmount);

												formWindow.show();
												Ext.apply(formWindow,{
													data:null,
													setData : function(data){
														formWindow.data = data;
													},
													getData:function(){
														return formWindow.data;
													}
												});
												formWindow.setData(id);
												if(records[0].data.isonlinePaymentDocAvailable == false ) {
          										   formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
          										   formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
          										   formWindow.down('#payNow').enable();
          									   }else{
          										   formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
          										   formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
          										   formWindow.down('#payNow').disable();
          									   }
											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('CAN_NOT_COMMUNICATE_VIA_PAYTM'));
											}
										}
									};
									var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE;
									Ext.Ajax.request({
										type : 'rest',
										url : submitUrl,
										jsonData : submitData,
										method : 'POST',
										success : function(response, action) {
											//onlinePaymentId
											var onlinePaymentId = response.responseText;
											XMLHttpRequestObject.open("POST", grid.getPaymentPostUrl(), true);
											XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
											XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId);
										}
									});
								}
							})
						}else{
							showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
						}
					}else{
						showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
					}
				} 
			},
			'onlinepaymentgridforportal[itemId=onlinepaymentgridforstudentportal] button[itemId=btnPaytmTechprocess]': {
				click: function(obj){
					var $this = this;
					var grid = this.getOnlinePaymentGridForPortal();
					var personProfile = $this.getContentPanelActiveTab();
					var userId = personProfile.getUserId();
					if(grid.getSelectionModel().getCount()>0){
						var records = grid.selModel.getSelection();
						var totalAmount=0;
						var totalBalanceAmount=0;
						for(var i in records){
							var balanceAmounts = records[i].get('tempRemainingAmount');
							var amounts = records[i].get('totalBalanceAmount');
							if(isNullOrEmpty(amounts)){
								showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
								return false;
							}
							totalBalanceAmount = totalBalanceAmount + balanceAmounts;
							totalAmount = totalAmount + amounts;
						}
						if(totalBalanceAmount >=0 && totalAmount>0){ 
							var onlineAmount=[];
							for(var i in records){
								onlineAmount.push({
									"billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
									"billId":records[i].get('billHeaderId'),
									"adjustedAmount":records[i].get('totalBalanceAmount'),
									"balanceAmount": records[i].get('tempRemainingAmount')   
								});
							}
							var submitData = {
									"receiptAmount" : totalAmount,
									"onlinePayments" : onlineAmount
							};
							var amount=totalAmount;
							var orgModel = Academia.model.common.OrgSettingDateTimeModel;
							//var message = 'Are you sure, you want to make payment of ' + orgModel.get('currencyFormat') + ' ' +totalAmount+' ?';
							var currency = records[0].data.currencyId;
							var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);
							var message = 'Are you sure, you want to make payment of ' + billCurrency + ' ' +totalAmount+' ?';
							var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE
							showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
								if (btn == 'yes') {
									var XMLHttpRequestObject = false;  
									if (window.XMLHttpRequest) {  
										XMLHttpRequestObject = new XMLHttpRequest();  
										XMLHttpRequestObject.overrideMimeType("text/xml");  
									}  
									else if (window.ActiveXObject) {  
										XMLHttpRequestObject = new  
										ActiveXObject("Microsoft.XMLHTTP");  
									} 
									XMLHttpRequestObject.withCredentials = false;
									XMLHttpRequestObject.onreadystatechange = function() {
										if (this.readyState == 4 && this.status == 200) {
											var id = parseInt(XMLHttpRequestObject.responseText);
											if(!isNaN(id)) {
												var formWindow = Ext.widget('paymentsummarywin',{
													itemId:'paymentTechProcess'
												});
												 var emailID = null;
           									    var mobileNo = null; 
           									  	if(portalId == 1){
           									  		 emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
           									  		mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
           									  	}else{
           									  		 emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
           									  		mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber
           									  	}
           									  
												formWindow.down('#name').setValue(records[0].data.printName);
												formWindow.down('#email').setValue(emailID);
												formWindow.down('#mobileNo').setValue(mobileNo);
												//formWindow.down('#amount').setValue(currencyRenderer(totalAmount,records.currencyId));
												 formWindow.down('#amount').setValue(billCurrency+' '+totalAmount);

												formWindow.show();
												Ext.apply(formWindow,{
													data:null,
													setData : function(data){
														formWindow.data = data;
													},
													getData:function(){
														return formWindow.data;
													}
												});
												formWindow.setData(id);
												formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
												formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
												/*if(records[0].data.isonlinePaymentDocAvailable == false ) {
          										   formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
          										   formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
          										   formWindow.down('#payNow').enable();
          									   }else{
          										   formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
          										   formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
          										   formWindow.down('#payNow').disable();
          									   }*/
											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('CAN_NOT_COMMUNICATE_VIA_PAYTM'));
											}
										}
									};
									var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE;
									Ext.Ajax.request({
										type : 'rest',
										url : submitUrl,
										jsonData : submitData,
										method : 'POST',
										success : function(response, action) {
											//onlinePaymentId
											var onlinePaymentId = response.responseText;
											XMLHttpRequestObject.open("POST", grid.getPaymentPostUrl(), true);
											XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
											XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId);
										}
									});
								}
							})
						}else{
							showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
						}
					}else{
						showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
					}
				} 
			},
			'onlinepaymentbilllevelgridforportal[itemId=opbilllevelgridforSTportal] button[itemId=btnPaytmTechprocess]': {
				click: function(obj){
					var $this = this;
					var grid = $this.getOnlinepaymentbilllevelgridforportal();
					var personProfile = $this.getContentPanelActiveTab();
					var userId = personProfile.getUserId();
					if(grid.getSelectionModel().getCount()>0){
						var records = grid.selModel.getSelection();
						var totalAmount=0;
						var totalBalanceAmount=0;
						for(var i in records){
							var balanceAmounts = records[i].get("tempRemainingAmount");
							var amounts = records[i].get("balanceAmount");
							if(isNullOrEmpty(amounts)){
								showWarningMessage(getPersonModuleTranslation("PAYMENT_PEOCESS"),getPersonModuleTranslation("AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT"));
								return false;
							}
							totalBalanceAmount = totalBalanceAmount + balanceAmounts;
							totalAmount = totalAmount + amounts;
						}
						if(totalBalanceAmount >=0 && totalAmount>0){ 
							var onlineAmount=[];
							for(var i in records){
								onlineAmount.push({
									"billFeePlanRuleStageId":records[i].get("billFeePlanRuleStageId"),
									"billId":records[i].get("billId"),
									"adjustedAmount":records[i].get("balanceAmount"),
									"balanceAmount": records[i].get("tempRemainingAmount")   
								});
							}
							var submitData = {
									"receiptAmount" : totalAmount,
									"onlinePayments" : onlineAmount
							};
							var amount=totalAmount;
							var orgModel = Academia.model.common.OrgSettingDateTimeModel;
							
							var currency = records[0].data.currencyId;
							var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);
							var message = "Are you sure, you want to make payment of " + billCurrency + " " +totalAmount+" ?";
							var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL
							showConfirmMessage(getPersonModuleTranslation("PAYMENT_PEOCESS"), message, function(btn, text) {
								if (btn == "yes") {
									var XMLHttpRequestObject = false;  
									if (window.XMLHttpRequest) {  
										XMLHttpRequestObject = new XMLHttpRequest();  
										XMLHttpRequestObject.overrideMimeType("text/xml");  
									}  
									else if (window.ActiveXObject) {  
										XMLHttpRequestObject = new  
										ActiveXObject("Microsoft.XMLHTTP");  
									} 
									XMLHttpRequestObject.withCredentials = false;
									XMLHttpRequestObject.onreadystatechange = function() {
										if (this.readyState == 4 && this.status == 200) {
											var id = parseInt(XMLHttpRequestObject.responseText);
											if(!isNaN(id)) {
												var formWindow = Ext.widget("paymentsummarywin",{
													itemId:"paymentTechProcess"
												});
												 var emailID = null;
           									    var mobileNo = null;
												var printName = null;
           									  	if(portalId == 1){
           									  		 emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
           									  		mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
													printName = $this.getStudentDetailForErpPortal().student.person.printName;
           									  	}else{
           									  		 emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
           									  		mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber;
           									  	printName = $this.getCurrentlyLoggedInUserInfoForPortal().student.printName;
												}
           									  
												formWindow.down("#name").setValue(printName);
												formWindow.down("#email").setValue(emailID);
												formWindow.down("#mobileNo").setValue(mobileNo);
												 formWindow.down("#amount").setValue(billCurrency+" "+totalAmount);

												formWindow.show();
												Ext.apply(formWindow,{
													data:null,
													setData : function(data){
														formWindow.data = data;
													},
													getData:function(){
														return formWindow.data;
													}
												});
												formWindow.setData(id);
												formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
												formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
													
												/*if(records[0].data.isonlinePaymentDocAvailable == false ) {
													formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
													formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
													formWindow.down('#payNow').enable();
												}else{
													formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
													formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
													formWindow.down('#payNow').disable();
												}*/
											} else {
												showWarningMessage(getCommonTranslation("ALERT"),getPersonModuleTranslation("CAN_NOT_COMMUNICATE_VIA_PAYTM"));
											}
										}
									};
									var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL;
									Ext.Ajax.request({
										type : "rest",
										url : submitUrl,
										jsonData : submitData,
										method : "POST",
										success : function(response, action) {
											
											var onlinePaymentId = response.responseText;
											XMLHttpRequestObject.open("POST",  grid.getPaymentPostUrl(), true);
											XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
											XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId);
										}
									});
								}
							})
						}else{
							showWarningMessage(getPersonModuleTranslation("PAYMENT_PEOCESS"),getPersonModuleTranslation("AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT"));
						}
					}else{
						showWarningMessage(getPersonModuleTranslation("PAYMENT_PEOCESS"), getCommonTranslation("PLEASE_SELECT_RECORD")); //Please select a record  
					}
				} 
			},
			'paymentsummarywin[itemId=paymentTechProcess] button[itemId=okBtn]' : {
				click : function(obj) {
					var $this = this;
					var getActiveTab = $this.getContentPanelActiveTab();
					var tabPanel = getActiveTab.down("tabpanel");
					/*var grid = tabPanel.activeTab;
					grid.getSelectionModel().deselectAll();*/
					 var grid1 = this.getOnlinepaymentbilllevelgridforportal();
					 if(!isNullOrEmpty(grid1)){
						 grid1.getSelectionModel().deselectAll();
						 grid1.getStore().reload();
					 }
					 var grid2 = this.getOnlinePaymentGridForPortal();
					 if(!isNullOrEmpty(grid2)){
						 grid2.getSelectionModel().deselectAll();
						 grid2.getStore().reload();
					 }
					var formWindow  = obj.up().up().up();
					formWindow.close();
				}
			   },
			'paymentsummarywin[itemId=studentPaytmPayment] button[itemId=okBtn]' : {
				click : function(obj) {
					var $this = this;
					var getActiveTab = $this.getContentPanelActiveTab();
					var tabPanel = getActiveTab.down("tabpanel");
					var grid = tabPanel.activeTab;
					grid.getSelectionModel().deselectAll();
					var formWindow  = obj.up().up().up();
					grid.getStore().reload();
					formWindow.close();
				}
			   },
			   'paymentsummarywin[itemId=studentPaytmPayment] button[itemId=cancelBtn]' : {
				   click : function(obj) {
					   var $this = this;
					   var formWindow  = obj.up().up().up();
					   formWindow.close();
				   }
			   },
			   'paymentsummarywin[itemId=studentPaytmPayment] checkboxfield[itemId=onlinePaymentTermCondCheck]' : {
				   change : function(obj,newVal,oldVal) {
					   var $this = this;
					   var formWindow  = obj.up('form');
					   if(newVal == true){
						   formWindow.down('#payNow').enable();	
					   }
					   else{
						   formWindow.down('#payNow').disable();	
					   }			   
				   }
			   },
			   'paymentsummarywin[itemId=studentPaytmPayment] displayfield[itemId=onlinePaymentConditionMsg]' : {
				   afterrender : function(obj,newVal,oldVal) {
					   obj.getEl().on('click', function() {
						   var serverUrl = SERVERURL.DOWNLOAD_ONLINE_PAYMENT_DOC;
						   var csvForm = Ext.create('Ext.form.Panel'); 
		        	    	csvForm.getForm().submit({
		        		    	target: '_blank',
		        		    	method:'GET',
		        		    	params :{
		        		    		access_token : Ext.Ajax.defaultHeaders.access_token
		        		    	},
		        		    	headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		        		    	url: serverUrl,
		        		    	standardSubmit :true
		        	    	});
			            
			           });
					   			   
				   }
			   },
				'paymentsummarywin[itemId=studentPaytmPayment] button[itemId=payNow]' : {
	 			   click : function(obj) {
	 				   var $this = this;
					   var formWindow  = obj.up().up().up();
					   var record=null;
					   var getActiveTab = $this.getContentPanelActiveTab();
					   var tabPanel = getActiveTab.down("tabpanel");
					   var grid = tabPanel.activeTab;
	   				   if(grid != undefined) {
	   					   record = grid.getSelectionModel().getSelection()[0].data;
	   				   }
	 				   var XMLHttpRequestObject = false;  
						   if (window.XMLHttpRequest) {  
							   XMLHttpRequestObject = new XMLHttpRequest();  
							   XMLHttpRequestObject.overrideMimeType("text/xml");  
						   }  
						   else if (window.ActiveXObject) {  
							   XMLHttpRequestObject = new  
							   ActiveXObject("Microsoft.XMLHTTP");  
						   } 
					
						   if(XMLHttpRequestObject) {  
							   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
							   XMLHttpRequestObject.onreadystatechange = function() {       
								   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
									   var xmlDocument = XMLHttpRequestObject.responseXML;  
									   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
									   paytmGatewayPostUrl = buildInfo.getElementsByTagName("paytmGatewayPostUrl") [0].childNodes[0].nodeValue;
									   var w ='900',h ='500';
									// Fixes dual-screen position                         Most browsers      Firefox
									    var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
									    var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;

									    var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
									    var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

									    var left = ((width / 2) - (w / 2)) + dualScreenLeft;
									    var top = ((height / 2) - (h / 2)) + dualScreenTop;
									    var url = paytmGatewayPostUrl+"?id="+formWindow.getData()+"&academyLocationIds="+$this.getCurrentAcademyLocation(); 
	  								    if(!isNullOrEmpty(record)) {
	  								    	url = paytmGatewayPostUrl+"?id="+formWindow.getData()+"&academyLocationIds="+record.academyLocationId+"&merchantReference="+record.schoolTypeCode; 
	  								    }
									    var newWindow = window.open(url,'Online_Payment', 'scrollbars=yes, width=' + w + ', height=' + h + ', top=' + 120 + ', left=' + left+5);

									    // Puts focus on the newWindow
									    if (window.focus) {
									        newWindow.focus();
									    }
									    
	             				   Ext.defer(function() {
	             					   formWindow.down('#payNow').setVisible(false);
	             					   formWindow.down('#cancelBtn').setVisible(false);
	             					  formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
	             					   formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
	             					  
	             					   formWindow.down('#okBtn').setVisible(true);
	             				   }, 150, this);
								   }  
							   }  
							   XMLHttpRequestObject.send(null);  
						   }
	 			   }
	 		   },
	 		   'paymentsummarywin[itemId=paymentTechProcess] button[itemId=payNow]' :{
	 			 click:function(obj){
	 				var $this = this;
					   var formWindow  = obj.up().up().up();
					   var record=null;
					   var getActiveTab = $this.getContentPanelActiveTab();
					   var tabPanel = getActiveTab.down("tabpanel");
					   var grid = tabPanel.activeTab;
	   				   if(grid != undefined) {
	   					   record = grid.getSelectionModel().getSelection()[0].data;
	   				   }
	 				   var XMLHttpRequestObject = false;  
						   if (window.XMLHttpRequest) {  
							   XMLHttpRequestObject = new XMLHttpRequest();  
							   XMLHttpRequestObject.overrideMimeType("text/xml");  
						   }  
						   else if (window.ActiveXObject) {  
							   XMLHttpRequestObject = new  
							   ActiveXObject("Microsoft.XMLHTTP");  
						   } 
					
						   if(XMLHttpRequestObject) {  
							   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
							   XMLHttpRequestObject.onreadystatechange = function() {       
								   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
									   var xmlDocument = XMLHttpRequestObject.responseXML;  
									   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
									   paytmGatewayPostUrl = buildInfo.getElementsByTagName("techprocessPaymentPostUrl") [0].childNodes[0].nodeValue;
									   var w ='900',h ='500';
									// Fixes dual-screen position                         Most browsers      Firefox
									    var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
									    var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;

									    var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
									    var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

									    var left = ((width / 2) - (w / 2)) + dualScreenLeft;
									    var top = ((height / 2) - (h / 2)) + dualScreenTop;
									    var url = paytmGatewayPostUrl+"?id="+formWindow.getData()+"&academyLocationIds="+$this.getCurrentAcademyLocation(); 
	  								    if(!isNullOrEmpty(record)) {
	  								    	url = paytmGatewayPostUrl+"?id="+formWindow.getData()+"&academyLocationIds="+record.academyLocationId+"&merchantReference="+record.schoolTypeCode; 
	  								    }
									    var newWindow = window.open(url,'Online_Payment', 'scrollbars=yes, width=' + w + ', height=' + h + ', top=' + 120 + ', left=' + left+5);

									    // Puts focus on the newWindow
									    if (window.focus) {
									        newWindow.focus();
									    }
									    
	             				   Ext.defer(function() {
	             					   formWindow.down('#payNow').setVisible(false);
	             					   formWindow.down('#cancelBtn').setVisible(false);
	             					  formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
	             					   formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
	             					  
	             					   formWindow.down('#okBtn').setVisible(true);
	             				   }, 150, this);
								   }  
							   }  
							   XMLHttpRequestObject.send(null);  
						   }
	 			 }  
	 		   },
	 		   'paymentsummarywin[itemId=paymentTechProcess] button[itemId=cancelBtn]' : {
				   click : function(obj) {
					   var $this = this;
					   var formWindow  = obj.up().up().up();
					   formWindow.close();
				   }
	 		   },
	 		   'onlinepaymentstructureforportal': {
	 			   render: function(structure) {
	 				   if(this.getCurrentLoggedPortalId() == 3){
	 					   this.disableOnlinePaymentTabPivileges(structure,this.getSTUDENT_PORTAL_ONLINEPAYMENT_TAB_PERMISSIONS());
	 				   }else if(this.getCurrentLoggedPortalId() == 7){
	 					   this.disableOnlinePaymentTabPivileges(structure,this.getPARENT_PORTAL_ONLINEPAYMENT_TAB_PERMISSIONS());
	 				   }
	 			   }
	 		   }, 
	 		   "personinfostudentportal displayfield[itemId=outstandingAmount]":{
	 			   render:function(field){
	 				   var userInfo=Academia.model.authentication.UserInfoModel;
	 				   var userId=userInfo.get("userId");
	 				   var url=SERVERURL.PATH_GET_STUDENTDETAIL_WITHPARENT+"?studentId="+userId;
	 				   if(portalId==7){
	 					   var personId=null;
	 					   var parentID=localStorage.getItem("loggedInParentPersonId");
	 					   parentId=localStorage.getItem("personId");
	 					   if(isNullOrEmpty(parentId)){
	 						   Ext.Ajax.request({
	 							   type:"rest",
	 							   url:SERVERURL.FIND_PARENT_PERSON_ID+"?userId="+localStorage.getItem("parentUserId"),
	 							   method:"GET",
	 							   async:false,
	 							   success:function(res, action){
	 								   parentId = Ext.decode(res.responseText);
	 							   }})
	 					   }
	 					   url=SERVERURL.PATH_GET_STUDENTDETAIL_WITHPARENT+"?studentId="+userId+"&parentId="+parentId
	 				   }
	 				   Ext.Ajax.timeout=CONSTANTS.AJAX_TIMEOUT;
	 				   Ext.Ajax.request(
	 						   {
	 							   type:"rest",
	 							   async:false,
	 							   method:"GET",
	 							   url:url,
	 							   success:function(response, action){
	 								   var records=Ext.decode(response.responseText);
	 								   field.setValue(records.feeAmount);
	 								   var onlinepaymentstructureforportal=field.up("#grayQuestPanel");
	 								   onlinepaymentstructureforportal.parentStudentDetails=records}
	 						   })
	 			   }
	 		   },
	 		   'stcstdonlinepaymentstructureforadmin': {
	 			   render: function(structure) {
	 				  this.disableOnlinePaymentAdminTabPivileges(structure,this.getSTUDENT_ONLINEPAYMENT_TAB_PERMISSIONS());
	 			   }
	 		   },
	 		   'headwisebillsgrid[itemId=studentHeadWiseBillsGrid]': {
	 			   render: function(grid){
	 				   var this$= this;
	 				   var personProfile = this$.getContentPanelActiveTab();
	 				   var userId = personProfile.getUserId();
	 				   if (personProfile) {
	 					   if(!isNullOrEmpty(userId)){
	 						   buttonsToolBar = grid.query('toolbar')[0];
	 						   var pdftoolbar = buttonsToolBar.query('#btnExportToPDF')[0];
	 						   var exceltoolbar = buttonsToolBar.query('#btnExportToExcel')[0];
	 						   grid.getStore().getProxy().extraParams={
	 							   id : userId,
	 							   billedUserType : 'STUDENT',
	 							   adjustmentType : 'Bill Receivable',
	 							   showAllSettlement : 'All',
	 							   isStudentFeeHeadScreen:true,
	 							   limit : -1
	 						   };
	 						   grid.getStore().load({
	 							   callback: function(record, operation, success) {
	 								   if (record.length > 0) {
	 									   pdftoolbar.setDisabled(false);
	 									   exceltoolbar.setDisabled(false);
	 									   this$.toggleGridSummaryRow(grid,true);
	 								   }else{
	 									   pdftoolbar.setDisabled(true);
	 									   exceltoolbar.setDisabled(true);
	 									   this$.toggleGridSummaryRow(grid,false);
	 								   }
	 							   }
	 						   });
	 					   }
	 					   portalId = this$.getCurrentLoggedPortalId();
	 					   this$.doAccessControlValidation(grid, this$.getSTUDENT_HEAD_WISE_BILLS_PERMISSIONS());
	 				   }
	 			   }
	 		   },
	 		  // 'pendingbillsgrid[itemId=studentPendingBillsGrid] button[itemId=stdbtnBillMakePaymentButton]': {
	 		  'pendingbillsgrid[itemId=pendingBillsGridForErp] button[itemId=stdbtnBillMakePaymentButton]': {
	 			   click: function(obj) { 
	 				   var $this = this; 
	 				   var grid =  obj.up('pendingbillsgrid');
	 				   if(grid.getSelectionModel().getCount()>0){
	 					  if(this.getCostCenterValidationAtBillLevel(grid)){
							   return  showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BILL_PAYMENT_IS_NOT_ALLOWED_FOR_INVOICES_WITH_MULTIPLE_COST_CENTERS'));
						 }
	 					  var gridRec=grid.getSelectionModel().getSelection();
							for( var i = 0; i < gridRec.length; i++) {
	            				if(gridRec[i].data.billStatus=="REVERSED" || gridRec[i].data.billStatus=="SETTLED" || gridRec[i].data.billStatus=="CANCELLED"){
	            					showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('ONLY_PENDING_BILL_CAN_BE_PROCESSED'));
	            					return false;
	            				}
	            			}
	 					   var tabStructure = Ext.widget('stcstdonlinepaymentstructureforadmin');
	 					   var tabName = getFeeAndPaymentCommonTranslation('ONLINE_PAYMENT');
	 					   var contentpanel = obj.up('personinfopanel');
	 					   var tabDetail = contentpanel.items.items;
	 					   for(var i in tabDetail){
	 						   if(tabDetail[i].title==tabName){
	 							   tabDetail[i].close();
	 						   }
	 					   }
	 					   openTab(contentpanel, tabName, tabStructure);
	 				   }else{
							showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
						}
	 			   }
	 		   },
	 		   'onlinepaymentbilllevelgridforportal[itemId=opbilllevelgridforSTportal] button[itemId=btnPaytmPayment]': {
					click: function(obj){
						var $this = this;
						var grid = $this.getOnlinepaymentbilllevelgridforportal();
						var personProfile = $this.getContentPanelActiveTab();
						var userId = personProfile.getUserId();
						if(grid.getSelectionModel().getCount()>0){
							var records = grid.selModel.getSelection();
							var totalAmount=0;
							var totalBalanceAmount=0;
							for(var i in records){
								var balanceAmounts = records[i].get("tempRemainingAmount");
								var amounts = records[i].get("balanceAmount");
								if(isNullOrEmpty(amounts)){
									showWarningMessage(getPersonModuleTranslation("PAYMENT_PEOCESS"),getPersonModuleTranslation("AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT"));
									return false;
								}
								totalBalanceAmount = totalBalanceAmount + balanceAmounts;
								totalAmount = totalAmount + amounts;
							}
							if(totalBalanceAmount >=0 && totalAmount>0){ 
								var onlineAmount=[];
								for(var i in records){
									onlineAmount.push({
										"billFeePlanRuleStageId":records[i].get("billFeePlanRuleStageId"),
										"billId":records[i].get("billId"),
										"adjustedAmount":records[i].get("balanceAmount"),
										"balanceAmount": records[i].get("tempRemainingAmount")   
									});
								}
								var submitData = {
										"receiptAmount" : totalAmount,
										"onlinePayments" : onlineAmount
								};
								var amount=totalAmount;
								var orgModel = Academia.model.common.OrgSettingDateTimeModel;
								
								var currency = records[0].data.currencyId;
								var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);
								var message = "Are you sure, you want to make payment of " + billCurrency + " " +totalAmount+" ?";
								var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL
								showConfirmMessage(getPersonModuleTranslation("PAYMENT_PEOCESS"), message, function(btn, text) {
									if (btn == "yes") {
										var XMLHttpRequestObject = false;  
										if (window.XMLHttpRequest) {  
											XMLHttpRequestObject = new XMLHttpRequest();  
											XMLHttpRequestObject.overrideMimeType("text/xml");  
										}  
										else if (window.ActiveXObject) {  
											XMLHttpRequestObject = new  
											ActiveXObject("Microsoft.XMLHTTP");  
										} 
										XMLHttpRequestObject.withCredentials = false;
										XMLHttpRequestObject.onreadystatechange = function() {
											if (this.readyState == 4 && this.status == 200) {
												var id = parseInt(XMLHttpRequestObject.responseText);
												if(!isNaN(id)) {
													var formWindow = Ext.widget("paymentsummarywin",{
														itemId:"studentPaytmPayment"
													});
													 var emailID = null;
	           									    var mobileNo = null;
													var printName = null;
	           									  	if(portalId == 1){
	           									  		 emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
	           									  		mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
														printName = $this.getStudentDetailForErpPortal().student.person.printName;
	           									  	}else{
	           									  		 emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
	           									  		mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber;
	           									  	printName = $this.getCurrentlyLoggedInUserInfoForPortal().student.printName;
													}
	           									  
													formWindow.down("#name").setValue(printName);
													formWindow.down("#email").setValue(emailID);
													formWindow.down("#mobileNo").setValue(mobileNo);
													 formWindow.down("#amount").setValue(billCurrency+" "+totalAmount);

													formWindow.show();
													Ext.apply(formWindow,{
														data:null,
														setData : function(data){
															formWindow.data = data;
														},
														getData:function(){
															return formWindow.data;
														}
													});
													formWindow.setData(id);
													if(records[0].data.isonlinePaymentDocAvailable == false ) {
														formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
														formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
														formWindow.down('#payNow').enable();
													}else{
														formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
														formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
														formWindow.down('#payNow').disable();
													}
												} else {
													showWarningMessage(getCommonTranslation("ALERT"),getPersonModuleTranslation("CAN_NOT_COMMUNICATE_VIA_PAYTM"));
												}
											}
										};
										var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL;
										Ext.Ajax.request({
											type : "rest",
											url : submitUrl,
											jsonData : submitData,
											method : "POST",
											success : function(response, action) {
												
												var onlinePaymentId = response.responseText;
												XMLHttpRequestObject.open("POST",  grid.getPaymentPostUrl(), true);
												XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
												XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId);
											}
										});
									}
								})
							}else{
								showWarningMessage(getPersonModuleTranslation("PAYMENT_PEOCESS"),getPersonModuleTranslation("AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT"));
							}
						}else{
							showWarningMessage(getPersonModuleTranslation("PAYMENT_PEOCESS"), getCommonTranslation("PLEASE_SELECT_RECORD")); //Please select a record  
						}
					} 
				},
	 		   'bursaryapplicationstatus[itemId=bursaryapplicationstatusItemId] button[itemId=checkStatus]':{
	 			  click: function(obj) { 
	 				 var grid = obj.up('bursaryapplicationstatus');
		 				 var url = SERVERURL.PATH_NSFAS_GET_PERSON_STATUS_CHECK_INFO;
		 				this.loadBursaryapplicationstatusGrid(grid, url,false);
	 			  }
	 		   },
	 		  'bursaryapplicationdetails[itemId=bursaryapplicationdetailsItemId] button[itemId=checkStatus]':{
	 			  click: function(obj) { 
	 				  var grid =obj.up('bursaryapplicationdetails')
	 				  var url =SERVERURL.PATH_NSFAS_GET_APPLICATION_DATA;
		 				this.loadBursaryapplicationstatusGrid(grid, url,false);
	 			  }
	 		   },
	 		  'bursaryapplicationdetails[itemId=bursaryapplicationdetailsItemId]':{
	 			 afterrender:function(grid){
						var me = this;
						var url =SERVERURL.PATH_NSFAS_GET_APPLICATION_DATA;
		 				   this.disableCheckStatusButtonByPrivilege(grid,me.getNSFAS_STUDENT_DETAIL_DATA_GRID_PERMISSIONS());
		 				  var personProfile = me.getContentPanelActiveTab();
		 			    	if(!isNullOrEmpty(personProfile)){
		 			    		var person = personProfile.personInfo;
		 			    		var nationalId = person.nationalID;
		 			    		if(!isNullOrEmpty(nationalId)){
		 			    			this.loadBursaryapplicationstatusGrid(grid,url,true);
		 			    		}else{
		 			    			setTimeout(function(){
			 		    				showWarningMessage(getPersonModuleTranslation('BURSARY_DETAILS'), getPersonModuleTranslation("PROVIDE_NATIONAL_ID"));
			 													},300);
		 			    		}
		 			    	}
						
						setTimeout(function(){
						me.addDataGridConfigButton(grid, me.getNSFAS_STUDENT_DETAIL_DATA_GRID_PERMISSIONS());
												},1500);
	    			 }
	 		   },
	 		  'bursaryfunddingdetails[itemId=bursaryfunddingdetailsItemId] button[itemId=checkStatus]':{
	 			  click: function(obj) { 
	 				 var grid = obj.up('bursaryfunddingdetails');
	 				 var url = SERVERURL.PATH_SAVE_PROVISIOANAL_FUND_NSFAS;
	 				 this.loadBursaryapplicationstatusGrid(grid, url,false);
	 			  }
	 		   },
	 		  'bursaryfunddingdetails[itemId=bursaryfunddingdetailsItemId]':{
	 			 render: function(grid){
	 				 var url = SERVERURL.PATH_GET_PROVISIONAL_FUND_DATA;
	 				 this.disableCheckStatusButtonByPrivilege(grid,this.getNSFAS_STD_FUNDDING_DATA_GRID_PERMISSIONS());
	 				var personProfile = this.getContentPanelActiveTab();
 			    	if(!isNullOrEmpty(personProfile)){
 			    		var person = personProfile.personInfo;
 			    		var nationalId = person.nationalID;
 			    		if(!isNullOrEmpty(nationalId)){
 			    			this.loadBursaryapplicationstatusGrid(grid,url,true);
 			    		}
 			    	}
	 			  },
	 			 afterrender:function(grid){
						var me = this;
						setTimeout(function(){
						me.addDataGridConfigButton(grid, me.getNSFAS_STD_FUNDDING_DATA_GRID_PERMISSIONS());
												},1500);
	    			 }
	 		   },
	 		  'bursaryapplicationstatus[itemId=bursaryapplicationstatusItemId]':{
	 			 render: function(grid){
	 				 var url = SERVERURL.PATH_NSFAS_GET_PERSON_STATUS_CHECK_INFO;
	 				    this.disableCheckStatusButtonByPrivilege(grid,this.getNSFAS_STUDENT_STATUS_DATA_GRID_PERMISSIONS());
	 				   var personProfile = this.getContentPanelActiveTab();
	 			    	if(!isNullOrEmpty(personProfile)){
	 			    		var person = personProfile.personInfo;
	 			    		var nationalId = person.nationalID;
	 			    		if(!isNullOrEmpty(nationalId)){
	 			    			this.loadBursaryapplicationstatusGrid(grid,url,true);
	 			    		}
	 			    	}
	 			  },
	 			 afterrender:function(grid){
						var me = this;
						setTimeout(function(){
						me.addDataGridConfigButton(grid, me.getNSFAS_STUDENT_STATUS_DATA_GRID_PERMISSIONS());
												},1500);
	    			 }
	 		   },
	 		   'pendingbillstructure':{
	 			  render: function(structure){
	 				 this.disableBillCreditTabByPriviledge(structure, this.getSTUDENT_PORTAL_STUDENT_PENDING_BILLS_PERMISSIONS());
	 			  }
	 		   },
	 		   'onlinepaymentgridforportal[itemId=onlinepaymentgridforstudentportal] button[itemId=btnPaytmTechprocess]': {
	 			   click: function(obj){
	 				   var $this = this;
	 				   var grid = this.getOnlinePaymentGridForPortal();
	 				   var personProfile = $this.getContentPanelActiveTab();
	 				   var userId = personProfile.getUserId();
	 				   if(grid.getSelectionModel().getCount()>0){
	 					   var records = grid.selModel.getSelection();
	 					   var totalAmount=0;
	 					   var totalBalanceAmount=0;
	 					   for(var i in records){
	 						   var balanceAmounts = records[i].get('tempRemainingAmount');
	 						   var amounts = records[i].get('totalBalanceAmount');
	 						   if(isNullOrEmpty(amounts)){
	 							   showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
	 							   return false;
	 						   }
	 						   totalBalanceAmount = totalBalanceAmount + balanceAmounts;
	 						   totalAmount = totalAmount + amounts;
	 					   }
	 					   if(totalBalanceAmount >=0 && totalAmount>0){ 
	 						   var onlineAmount=[];
	 						   for(var i in records){
	 							   onlineAmount.push({
	 								   "billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
	 								   "billId":records[i].get('billHeaderId'),
	 								   "adjustedAmount":records[i].get('totalBalanceAmount'),
	 								   "balanceAmount": records[i].get('tempRemainingAmount')   
	 							   });
	 						   }
	 						   var submitData = {
	 								   "receiptAmount" : totalAmount,
	 								   "onlinePayments" : onlineAmount
	 						   };
	 						   var amount=totalAmount;
	 						   var orgModel = Academia.model.common.OrgSettingDateTimeModel;
	 						   //var message = 'Are you sure, you want to make payment of ' + orgModel.get('currencyFormat') + ' ' +totalAmount+' ?';
	 						   var currency = records[0].data.currencyId;
	 						   var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);
	 						   var message = 'Are you sure, you want to make payment of ' + billCurrency + ' ' +totalAmount+' ?';
	 						   var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE
	 						   showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
	 							   if (btn == 'yes') {
	 								   var XMLHttpRequestObject = false;  
	 								   if (window.XMLHttpRequest) {  
	 									   XMLHttpRequestObject = new XMLHttpRequest();  
	 									   XMLHttpRequestObject.overrideMimeType("text/xml");  
	 								   }  
	 								   else if (window.ActiveXObject) {  
	 									   XMLHttpRequestObject = new  
	 									   ActiveXObject("Microsoft.XMLHTTP");  
	 								   } 
	 								   XMLHttpRequestObject.withCredentials = false;
	 								   XMLHttpRequestObject.onreadystatechange = function() {
	 									   if (this.readyState == 4 && this.status == 200) {
	 										   var id = parseInt(XMLHttpRequestObject.responseText);
	 										   if(!isNaN(id)) {
	 											   var formWindow = Ext.widget('paymentsummarywin',{
	 												   itemId:'paymentTechProcess'
	 											   });
	 											   var emailID = null;
	 											   var mobileNo = null; 
	 											   if(portalId == 1){
	 												   emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
	 												   mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
	 											   }else{
	 												   emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
	 												   mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber
	 											   }

	 											   formWindow.down('#name').setValue(records[0].data.printName);
	 											   formWindow.down('#email').setValue(emailID);
	 											   formWindow.down('#mobileNo').setValue(mobileNo);
	 											   //formWindow.down('#amount').setValue(currencyRenderer(totalAmount,records.currencyId));
	 											   formWindow.down('#amount').setValue(billCurrency+' '+totalAmount);

	 											   formWindow.show();
	 											   Ext.apply(formWindow,{
	 												   data:null,
	 												   setData : function(data){
	 													   formWindow.data = data;
	 												   },
	 												   getData:function(){
	 													   return formWindow.data;
	 												   }
	 											   });
	 											   formWindow.setData(id);
	 											  formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
												  formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
	 											   /*if(records[0].data.isonlinePaymentDocAvailable == false ) {
	 												   formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
	 												   formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
	 												   formWindow.down('#payNow').enable();
	 											   }else{
	 												   formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
	 												   formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
	 												   formWindow.down('#payNow').disable();
	 											   }*/
	 										   } else {
	 											   showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('CAN_NOT_COMMUNICATE_VIA_PAYTM'));
	 										   }
	 									   }
	 								   };
	 								   var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE;
	 								   Ext.Ajax.request({
	 									   type : 'rest',
	 									   url : submitUrl,
	 									   jsonData : submitData,
	 									   method : 'POST',
	 									   success : function(response, action) {
	 										   //onlinePaymentId
	 										   var onlinePaymentId = response.responseText;
	 										   XMLHttpRequestObject.open("POST", grid.getPaymentPostUrl(), true);
	 										   XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	 										   XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId);
	 									   }
	 								   });
	 							   }
	 						   })
	 					   }else{
	 						   showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
	 					   }
	 				   }else{
	 					   showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record  
	 				   }
	 			   } 
	 		   },
	 		   'onlinepaymentbilllevelgridforportal[itemId=opbilllevelgridforSTportal] button[itemId=btnPaytmTechprocess]': {
	 			   click: function(obj){
	 				   var $this = this;
	 				   var grid = $this.getOnlinepaymentbilllevelgridforportal();
	 				   var personProfile = $this.getContentPanelActiveTab();
	 				   var userId = personProfile.getUserId();
	 				   if(grid.getSelectionModel().getCount()>0){
	 					   var records = grid.selModel.getSelection();
	 					   var totalAmount=0;
	 					   var totalBalanceAmount=0;
	 					   for(var i in records){
	 						   var balanceAmounts = records[i].get("tempRemainingAmount");
	 						   var amounts = records[i].get("balanceAmount");
	 						   if(isNullOrEmpty(amounts)){
	 							   showWarningMessage(getPersonModuleTranslation("PAYMENT_PEOCESS"),getPersonModuleTranslation("AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT"));
	 							   return false;
	 						   }
	 						   totalBalanceAmount = totalBalanceAmount + balanceAmounts;
	 						   totalAmount = totalAmount + amounts;
	 					   }
	 					   if(totalBalanceAmount >=0 && totalAmount>0){ 
	 						   var onlineAmount=[];
	 						   for(var i in records){
	 							   onlineAmount.push({
	 								   "billFeePlanRuleStageId":records[i].get("billFeePlanRuleStageId"),
	 								   "billId":records[i].get("billId"),
	 								   "adjustedAmount":records[i].get("balanceAmount"),
	 								   "balanceAmount": records[i].get("tempRemainingAmount")   
	 							   });
	 						   }
	 						   var submitData = {
	 								   "receiptAmount" : totalAmount,
	 								   "onlinePayments" : onlineAmount
	 						   };
	 						   var amount=totalAmount;
	 						   var orgModel = Academia.model.common.OrgSettingDateTimeModel;

	 						   var currency = records[0].data.currencyId;
	 						   var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);
	 						   var message = "Are you sure, you want to make payment of " + billCurrency + " " +totalAmount+" ?";
	 						   var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL
	 						   showConfirmMessage(getPersonModuleTranslation("PAYMENT_PEOCESS"), message, function(btn, text) {
	 							   if (btn == "yes") {
	 								   var XMLHttpRequestObject = false;  
	 								   if (window.XMLHttpRequest) {  
	 									   XMLHttpRequestObject = new XMLHttpRequest();  
	 									   XMLHttpRequestObject.overrideMimeType("text/xml");  
	 								   }  
	 								   else if (window.ActiveXObject) {  
	 									   XMLHttpRequestObject = new  
	 									   ActiveXObject("Microsoft.XMLHTTP");  
	 								   } 
	 								   XMLHttpRequestObject.withCredentials = false;
	 								   XMLHttpRequestObject.onreadystatechange = function() {
	 									   if (this.readyState == 4 && this.status == 200) {
	 										   var id = parseInt(XMLHttpRequestObject.responseText);
	 										   if(!isNaN(id)) {
	 											   var formWindow = Ext.widget("paymentsummarywin",{
	 												   itemId:"paymentTechProcess"
	 											   });
	 											   var emailID = null;
	 											   var mobileNo = null;
	 											   var printName = null;
	 											   if(portalId == 1){
	 												   emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
	 												   mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
	 												   printName = $this.getStudentDetailForErpPortal().student.person.printName;
	 											   }else{
	 												   emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
	 												   mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber;
	 												   printName = $this.getCurrentlyLoggedInUserInfoForPortal().student.printName;
	 											   }

	 											   formWindow.down("#name").setValue(printName);
	 											   formWindow.down("#email").setValue(emailID);
	 											   formWindow.down("#mobileNo").setValue(mobileNo);
	 											   formWindow.down("#amount").setValue(billCurrency+" "+totalAmount);

	 											   formWindow.show();
	 											   Ext.apply(formWindow,{
	 												   data:null,
	 												   setData : function(data){
	 													   formWindow.data = data;
	 												   },
	 												   getData:function(){
	 													   return formWindow.data;
	 												   }
	 											   });
	 											   formWindow.setData(id);
	 											   formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
												   formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
	 											 /*  if(records[0].data.isonlinePaymentDocAvailable == false ) {
	 												   formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
	 												   formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
	 												   formWindow.down('#payNow').enable();
	 											   }else{
	 												   formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
	 												   formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
	 												   formWindow.down('#payNow').disable();
	 											   }*/
	 										   } else {
	 											   showWarningMessage(getCommonTranslation("ALERT"),getPersonModuleTranslation("CAN_NOT_COMMUNICATE_VIA_PAYTM"));
	 										   }
	 									   }
	 								   };
	 								   var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL;
	 								   Ext.Ajax.request({
	 									   type : "rest",
	 									   url : submitUrl,
	 									   jsonData : submitData,
	 									   method : "POST",
	 									   success : function(response, action) {

	 										   var onlinePaymentId = response.responseText;
	 										   XMLHttpRequestObject.open("POST",  grid.getPaymentPostUrl(), true);
	 										   XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	 										   XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId);
	 									   }
	 								   });
	 							   }
	 						   })
	 					   }else{
	 						   showWarningMessage(getPersonModuleTranslation("PAYMENT_PEOCESS"),getPersonModuleTranslation("AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT"));
	 					   }
	 				   }else{
	 					   showWarningMessage(getPersonModuleTranslation("PAYMENT_PEOCESS"), getCommonTranslation("PLEASE_SELECT_RECORD")); //Please select a record  
	 				   }
	 			   } 
	 		   },
	 		   'paymentsummarywin[itemId=paymentTechProcess] button[itemId=payNow]' :{
	 			   click:function(obj){
	 				   var $this = this;
	 				   var formWindow  = obj.up().up().up();
	 				   var record=null;
	 				   var getActiveTab = $this.getContentPanelActiveTab();
	 				   var tabPanel = getActiveTab.down("tabpanel");
	 				   var grid = tabPanel.activeTab;
	 				   if(grid != undefined) {
	 					   record = grid.getSelectionModel().getSelection()[0].data;
	 				   }
	 				   var XMLHttpRequestObject = false;  
	 				   if (window.XMLHttpRequest) {  
	 					   XMLHttpRequestObject = new XMLHttpRequest();  
	 					   XMLHttpRequestObject.overrideMimeType("text/xml");  
	 				   }  
	 				   else if (window.ActiveXObject) {  
	 					   XMLHttpRequestObject = new  
	 					   ActiveXObject("Microsoft.XMLHTTP");  
	 				   } 

	 				   if(XMLHttpRequestObject) {  
	 					   XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
	 					   XMLHttpRequestObject.onreadystatechange = function() {       
	 						   if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200) {  
	 							   var xmlDocument = XMLHttpRequestObject.responseXML;  
	 							   buildInfo=xmlDocument.getElementsByTagName("buildInfo") [0];  
	 							   paytmGatewayPostUrl = buildInfo.getElementsByTagName("techprocessPaymentPostUrl") [0].childNodes[0].nodeValue;
	 							   var w ='900',h ='500';
	 							   // Fixes dual-screen position                         Most browsers      Firefox
	 							   var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : screen.left;
	 							   var dualScreenTop = window.screenTop != undefined ? window.screenTop : screen.top;

	 							   var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
	 							   var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

	 							   var left = ((width / 2) - (w / 2)) + dualScreenLeft;
	 							   var top = ((height / 2) - (h / 2)) + dualScreenTop;
	 							   var url = paytmGatewayPostUrl+"?id="+formWindow.getData()+"&academyLocationIds="+$this.getCurrentAcademyLocation(); 
	 							   if(!isNullOrEmpty(record)) {
	 								   url = paytmGatewayPostUrl+"?id="+formWindow.getData()+"&academyLocationIds="+record.academyLocationId+"&merchantReference="+record.schoolTypeCode; 
	 							   }
	 							   var newWindow = window.open(url,'Online_Payment', 'scrollbars=yes, width=' + w + ', height=' + h + ', top=' + 120 + ', left=' + left+5);

	 							   // Puts focus on the newWindow
	 							   if (window.focus) {
	 								   newWindow.focus();
	 							   }

	 							   Ext.defer(function() {
	 								   formWindow.down('#payNow').setVisible(false);
	 								   formWindow.down('#cancelBtn').setVisible(false);
	 								   formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
	 								   formWindow.down('#onlinePaymentConditionMsg').setVisible(false);

	 								   formWindow.down('#okBtn').setVisible(true);
	 							   }, 150, this);
	 						   }  
	 					   }  
	 					   XMLHttpRequestObject.send(null);  
	 				   }
	 			   }  
	 		   },
	 		   'paymentsummarywin[itemId=paymentTechProcess] button[itemId=cancelBtn]' : {
	 			   click : function(obj) {
	 				   var $this = this;
	 				   var formWindow  = obj.up().up().up();
	 				   formWindow.close();
	 			   }
	 		   },
	 		   'paymentsummarywin[itemId=paymentTechProcess] button[itemId=okBtn]' : {
	 			   click : function(obj) {
	 				   var $this = this;
	 				   var getActiveTab = $this.getContentPanelActiveTab();
	 				   var tabPanel = getActiveTab.down("tabpanel");
	 				   var grid = tabPanel.activeTab;
	 				   grid.getSelectionModel().deselectAll();
	 				   var formWindow  = obj.up().up().up();
	 				   grid.getStore().reload();
	 				   formWindow.close();
	 			   }
	 		   },
	 		   'fundingandmonitoringgrid':{
	 			   afterrender:function(){
	 				   var stdProfile = this.getContentPanelActiveTab(),
	 				   grid=stdProfile.down('fundingandmonitoringgrid');
	 				   grid.store.getProxy().extraParams = {
	 					  studentId:stdProfile.getUserId()
	 				   };
	 				   grid.store.load();
	 			   }  
               },
	 		   'fundingandmonitoringgrid button[itemId=btnAdd]':{
	 			   click:function(){
	 				   this.getFundingAndMonitoringPopUp();
	 			   }
	 		   },
	 		   'fundingandmonitoringgrid button[itemId=btnEdit]':{
	 			   click:function(){
	 				   this.setDataOnFundingandMonitoringForm('edit');
	 			   }
	 		   },
	 		   'fundingandmonitoringgrid button[itemId=btnView]':{
	 			   click:function(){
	 				   this.setDataOnFundingandMonitoringForm('view');
	 			   }
	 		   },
	 		   'fundingandmonitoringgrid button[itemId=btnDelete]':{
	 			   click:function(){
	 				   var this$ = this;
	 				   var stdProfile = this.getContentPanelActiveTab(),
	 				   grid = stdProfile.down('fundingandmonitoringgrid');
	 				   if (grid.getSelectionModel().getCount() > 0) {
	 					   showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 						   if (btn == 'yes') {
	 							   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 							   var records = grid.getSelectionModel().getSelection();
	 							   var id = records[0].get("id");
	 							   Ext.Ajax.request({
	 								   method : "DELETE",
	 								   type : 'rest',
	 								   url : SERVERURL.PATH_DELETE_FUNDING_AND_MONITORING_DETAILS +'?id='+ id,
	 								   headers : {
	 									   'Content-Type' : 'application/json'
	 								   },
	 								   success : function(form,action) {
	 									   Ext.getBody().unmask();
	 									   grid.getStore().reload();
	 									   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
	 								   }
	 							   });
	 						   }
	 					   });
	 				   }else{
	 					   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	 				   }
	 			   }
	 		   },
	 		  'fundingandmonitoringdetailswin customcombobox[itemId=programItemId]':{
	 			  render:function(combo){
	 				  var $this = this,
	 				  stdProfile = this.getContentPanelActiveTab(),
	 				  form = stdProfile.down('fundingandmonitoringdetailswin'),
	 				  store = combo.getStore();
	 				  store.on('beforeload',function() {
	 					  store.getProxy().setExtraParam('academyLocationId', $this.getCurrentAcademyLocation());
	 					  store.getProxy().setExtraParam('studentId',stdProfile.getUserId());
	 				  }, this);
	 			  }
	 		  },
	 		  'fundingandmonitoringdetailswin button[itemId=fundMonitoringDetailSave]':{
	 			   click:function(button){
	 				   this.saveFundingandMonitoringDetails(button);
	 			   }
	 		   },
	 		  'fundingandmonitoringdetailswin button[itemId=fundMonitoringDetailCancel]':{
	 			   click:function(){
	 				   var win = this.getFundingandmonitoringdetailswin();
	 				   win.close();
	 			   }
	 		   },
	 		   'financialsupportgrid':{
	 			   afterrender:function(){
	 				   var stdProfile = this.getContentPanelActiveTab(),
	 				   grid=stdProfile.down('financialsupportgrid');
	 				   grid.store.getProxy().extraParams = {
	 					   studentId:stdProfile.getUserId()
	 				   };
	 				   grid.store.load();
	 			   }  
	 		   },
	 		  'financialsupportgrid button[itemId=btnAdd]':{
	 			   click:function(){
	 				   this.getFinancialSupportPopUp();
	 			   }
	 		   },
	 		   'financialsupportgrid button[itemId=btnEdit]':{
	 			   click:function(){
	 				   this.setDataOnFinancialSupportForm('edit');
	 			   }
	 		   },
	 		   'financialsupportgrid button[itemId=btnView]':{
	 			   click:function(){
	 				   this.setDataOnFinancialSupportForm('view');
	 			   }
	 		   },
	 		   'financialsupportgrid button[itemId=btnDelete]':{
	 			   click:function(){
	 				   var this$ = this;
	 				   var stdProfile = this.getContentPanelActiveTab(),
	 				   grid = stdProfile.down('financialsupportgrid');
	 				   if (grid.getSelectionModel().getCount() > 0) {
	 					   showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 						   if (btn == 'yes') {
	 							   Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 							   var records = grid.getSelectionModel().getSelection();
	 							   var id = records[0].get("id");
	 							   Ext.Ajax.request({
	 								   method : "DELETE",
	 								   type : 'rest',
	 								   url : SERVERURL.PATH_DELETE_FINANCIAL_SUPPORT_DETAILS +'?id='+ id,
	 								   headers : {
	 									   'Content-Type' : 'application/json'
	 								   },
	 								   success : function(form,action) {
	 									   Ext.getBody().unmask();
	 									   grid.getStore().reload();
	 									   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
	 								   }
	 							   });
	 						   }
	 					   });
	 				   }else{
	 					   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
	 				   }
	 			   }
	 		   },
	 		  'financialsupportdetailswin button[itemId=financialSupportSave]':{
	 			   click:function(button){
	 				   this.saveFinancialSupportDetails(button);
	 			   }
	 		   },
	 		  'financialsupportdetailswin button[itemId=financialSupportCancel]':{
	 			   click:function(){
	 				   var win = this.getFinancialsupportdetailswin();
	 				   win.close();
	 			   }
	 		   },
	 		  'financialsupportdetailswin customcombobox[itemId=financialSupportProgramId]':{
	 			  select:function(combo, records, eOpts){
	 				  var $this=this,
	 				  stdProfile = this.getContentPanelActiveTab(),
	 				  form = this.getFinancialsupportdetailswin(),
	 				  batch = form.down('#financialSupportBatchId'),
	 				  period = form.down('#financialSupportPeriodId'),
	 				  programId = records[0].get('programId'),
	 				  batchStore = batch.getStore();
	 				  batch.reset();
	 				  period.reset();
	 				  period.setDisabled(true);
	 				  batch.setDisabled(false);
	 				  batchStore.getProxy().extraParams = {					  
	 					  alId :$this.getCurrentAcademyLocation(),
	 					  studentId:stdProfile.getUserId(),
	 					  programId:programId
	 				  };
	 				  batchStore.load();
	 			  },
	 			  render:function(combo){
	 				  var $this = this,
	 				  stdProfile = this.getContentPanelActiveTab(),
	 				  form = this.getFinancialsupportdetailswin(),
	 				  store = combo.getStore();
	 				  store.on('beforeload',function() {
	 					  store.getProxy().setExtraParam('alId', $this.getCurrentAcademyLocation());
	 					  store.getProxy().setExtraParam('studentId',stdProfile.getUserId());
	 				  }, this);
	 			  }
	 		  },
	 		  'financialsupportdetailswin customcombobox[itemId=financialSupportBatchId]':{
	 			  select:function(combo, records, eOpts){
	 				  var $this=this,
	 				  stdProfile = this.getContentPanelActiveTab(),
	 				  form = this.getFinancialsupportdetailswin(),
	 				  program = form.down('#financialSupportProgramId');
	 				  period = form.down('#financialSupportPeriodId'),
	 				  batchId = records[0].get('batchId'),
	 				  periodStore = period.getStore();
	 				  period.reset();
	 				  period.setDisabled(false);
	 				  periodStore.getProxy().extraParams = {					  
	 					  alId :$this.getCurrentAcademyLocation(),
	 					  studentId:stdProfile.getUserId(),
	 					  programId:program.getValue(),
	 					  batchId:batchId
	 				  };
	 				  periodStore.load();
	 			  }
	 		 },
	 		 'proformainvoicegrid':{
	 			 afterrender:function(grid){
	 				 var stdProfile = this.getContentPanelActiveTab(),
	 				 grid=stdProfile.down('proformainvoicegrid');
	 				 grid.store.getProxy().extraParams = {
	 					 studentId:stdProfile.getUserId()
	 				 };
	 				 grid.store.load();
	 			 },
	 			 cellclick:function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
	 				 if (e.target.tagName == 'A') {
	 					 var documentId = record.data.encryptedDocId,
	 					 docController = this.getController('Academia.controller.document.DocumentController');
	 					 if (!isNullOrEmpty(documentId)) {
	 						docController.downloadDocumentFile(documentId);
	 					 }
	 				 }
	 			 }
	 		 }
    	});
    },
    loadBursaryapplicationstatusGrid : function(grid,url,modeOfEvent,permissionMap) {
    	var this$ = this;
    	var nationalId = null;
    	var personId = null;
    	var isApplicant = false;
    	var personProfile = this$.getContentPanelActiveTab();
    	
    	if(!isNullOrEmpty(personProfile)){
    		var person = personProfile.personInfo;
    		var personId = person.id;
    		var nationalId = person.nationalID;
    	}
    	if (grid.xtype == 'bursaryfunddingdetails') {
    		grid.bindStore(Ext.create('Academia.store.personinfo.common.NSFAS.BursaryFunddingDetailStore'));
		}
    	if (grid.xtype == 'bursaryapplicationdetails') {
    		//grid.bindStore(Ext.create('Academia.store.personinfo.common.NSFAS.BursaryApplicationDetailStore'));
		}
    	if (grid.xtype == 'bursaryapplicationstatus') {
    		//grid.bindStore(Ext.create('Academia.store.personinfo.common.NSFAS.BursaryApplicationStatusStore'));
		}
    	if(!isNullOrEmpty(nationalId)){
    		var store = grid.getStore();
    		if(grid.xtype == "bursaryapplicationdetails" || grid.xtype == "bursaryapplicationstatus"){
    			store.getProxy().extraParams = {					  
        			userPersonId :personId,
            		nationalId : nationalId,
            		isApplicant :isApplicant,
            		limit:5,
            		isRender:modeOfEvent
    			  };
    			this$.resetPageSetting(store);
        		
        		store.load();
    		}else{
    			store.getProxy().extraParams = {					  
        			userPersonId :personId,
            		nationalId : nationalId,
            		isApplicant :isApplicant,
            		limit:5,
            		isRender:modeOfEvent
            		
    			  };
    			if(!modeOfEvent) {
    				Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
            		store.load({
            			callback:function(rec,val,success){
            				if(success){
            					Ext.getBody().unmask();
            				}
            			}
            		});
    			}else{
    				store.load();
    			}
    			
    		}
    		if (modeOfEvent == false) {
    			store.getProxy().extraParams = {					  
        			userPersonId :personId,
            		nationalId : nationalId,
            		isApplicant :isApplicant,
            		limit:5,
            		isRender:true
    			  };
			}
    		
    	}else{
    		showWarningMessage(getPersonModuleTranslation('BURSARY_DETAILS'), getPersonModuleTranslation("PROVIDE_NATIONAL_ID"));
    	}
	},
	disableCheckStatusButtonByPrivilege:function(grid,permissionsMap){
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	    
		var checkStatusBtn =grid.down('#checkStatus');
		checkStatusBtn.setVisible(false);
		 Ext.each(permissionList,function(privilege){
			 if(privilege == "CHECK_STATUS"){
				 if(checkStatusBtn){
					 checkStatusBtn.setVisible(true);
				 }
			 }
		 });
	},
    loadPendingBillGrid : function(obj,records){
      	 var $this=this;
      	 var structure = this.getPendingbillstructure();
      	 var pendingBillGrid = structure.down('pendingbillsgridforstudentportal');
      	// var creditNoteGrid = structure.down('creditnotegrid');
      	 var pendingBillsFilter=$this.getPendingbillsfilter();
      	 var formValues = pendingBillsFilter.getValues();
      	 var billType=pendingBillsFilter.down("#billTypes");
      	 var billStatus=pendingBillsFilter.down("#billStatus");
      	 var portalId = $this.getCurrentLoggedPortalId();
      	 var logInUser = $this.getCurrentlyLoggedInUser();
      	 var studentId= null;
      	 var userType = null;           	 
      	 if(portalId == 3 || portalId == 7){
      		userType = 'STUDENT',
      		studentId =logInUser.id;
      	 }
      	 pendingBillGrid.config.searchFilterForm = pendingBillsFilter;
      	 
      	pendingBillGrid.getStore().getProxy().extraParams={
      		billedUserType:userType,
      		raiseBillType:billType.value,
      		billStatus:billStatus.value,      		
      		id:studentId,
      		whetherDeleted:false,
      		raiseBillCategory:'BILL_RECEIVABLE'
      	 }
      	
      	pendingBillGrid.getStore().load({ 
			   callback: function(record, operation, success) {
				   if (record.length > 0 && record[0].data.whetherDisplayTotal!=false) {
					   $this.toggleGridSummaryRow(pendingBillGrid,true);
				   }else{
					   $this.toggleGridSummaryRow(pendingBillGrid,false);
				   }
			   }
		   });
      	pendingBillGrid.getSelectionModel().deselectAll();
      	/*grid.bindStore(store);
      	store.load();*/
       },
       loadPendingCreditGrid : function(obj,records){
        	 var $this=this;
        	 var structure = this.getPendingbillstructure();
        	 var creditNoteGrid = structure.down('creditnotegridforstudentportal');
        	 var pendingCreditFilter=$this.getPendingcreditfilter();
        	 var formValues = pendingCreditFilter.getValues();
        	 var billType=pendingCreditFilter.down("#billTypes");
        	 var billStatus=pendingCreditFilter.down("#billStatus");
        	 var portalId = $this.getCurrentLoggedPortalId();
        	 var logInUser = $this.getCurrentlyLoggedInUser();
        	 var studentId= null;
        	 var userType = null;           	 
        	 if(portalId == 3 || portalId == 7){
        		userType = 'STUDENT',
        		studentId =logInUser.id;
        	 }
        	creditNoteGrid.getStore().getProxy().extraParams={
        		billedUserType:userType,
        		raiseBillType:billType.value,
        		billStatus:billStatus.value,      		
        		id:studentId,
        		whetherDeleted:false,
        		raiseBillCategory:'BILL_PAYABLE'
        	 }
        	creditNoteGrid.config.searchFilterForm =pendingCreditFilter;
        	creditNoteGrid.getStore().load({ 
  			   callback: function(record, operation, success) {
  				   if (record.length > 0 && record[0].data.whetherDisplayTotal!=false) {
  					   $this.toggleGridSummaryRow(creditNoteGrid,true);
  				   }else{
  					   $this.toggleGridSummaryRow(creditNoteGrid,false);
  				   }
  			   }
  		   });
        	creditNoteGrid.getSelectionModel().deselectAll();
        	/*grid.bindStore(store);
        	store.load();*/
         },
    
    exportScholarshipList : function(exportUrl,filetype,whetherAll) {
    	var searchResultGrid = this.getSearchResultGrid();
    	var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
    	var personProfile = this.getContentPanelActiveTab();
    	var userId = personProfile.getUserId();
    	var values = new Object();
    	var searchcriteria = new Array();
    	values.configCode = CONSTANTS.CB.ST_PORTAL_SCHOLARSHIP_LISTING_CONFIG_CODE;
    	var studentIdObj = this.getJsonObject('STUDENT_ID' , userId);
    	this.pushJsonObjectInArray(studentIdObj, searchcriteria);
    	values.searchCriterias = searchcriteria;
    	var jsonFormatFormData = values;
    	var searchcriteriaString="STUDENT_ID :"+userId;
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
    	var reportTitle=getCommonTranslation('SCHOLARSHIP_AWARDEE_LIST');
    	if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined 
    			&& searchResultGrid.store.getCurrentSortCriteria()!=null)
    		jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
    	searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,
    			searchcriteriaString,visibleColumns,reportTitle);
    },
    
    loadScholarshipListGrid: function() {
    	var $this= this;
    	var personProfile = $this.getContentPanelActiveTab();
    	var userId = personProfile.getUserId();
    	
    	var values = new Object();
        var searchcriteria = new Array();
    	/*var params = {
    			STUDENT_ID : userId,
    	};*/
        values.configCode = CONSTANTS.CB.ST_PORTAL_SCHOLARSHIP_LISTING_CONFIG_CODE;
        var studentIdObj = $this.getJsonObject('STUDENT_ID' , userId);
    	$this.pushJsonObjectInArray(studentIdObj, searchcriteria);

        values.searchCriterias = searchcriteria;
        var jsonFormatFormData = values;
        
        var resultGrid = personProfile.down('#STscholarshipListGrid');
    	var resultViewUrl = SERVERURL.SEARCHRESULTVIEWURL;
    	resultViewUrl = resultViewUrl.concat(CONSTANTS.CB.ST_PORTAL_SCHOLARSHIP_LISTING_CONFIG_CODE);
    	resultGrid.initialize(SERVERURL.EXECUTEBASICSEARCH, resultViewUrl, jsonFormatFormData);
    },
    
    getJsonObject: function(key, value, additionalValue) {
        if (!isNullOrEmpty(value) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (!isNullOrEmpty(value) && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }
    },
    
    pushJsonObjectInArray: function(object, array) {
        if (object) {
            array.push(object);
        }
    },
    onlinePaymentSTPortalGridCellClick: function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ){
    	if(cellIndex == 0 && e.getTarget().className == "x-grid-row-checker"){
    		if ((record.data.whetherActive == true && record.data.whetherChecked == true) 
    				||(record.data.whetherActive == false && record.data.whetherChecked == false)) {
    			grid.getSelectionModel().doDeselect(record);
    		}
    		if (record.data.whetherActive == true && record.data.whetherChecked == false) {
    			grid.getSelectionModel().doSelect(record,true);
    		}
    	}else{
    		return false;
    	}
    	if (record.data.whetherActive == false ) {
    		grid.getSelectionModel().allowSelect=false;
    	}
    },
	  disableMoreActionPivileges: function(gridReference, permissionsMap) {
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			buttonsToolBar = gridReference.query('toolbar')[0];
			var makePayment = gridReference.down('#btnView');//make payment
			var paytmPaymentButton = gridReference.down('#btnPaytmPayment');//make payment
			var bankField= gridReference.down('#bankItemId');
			var btnPaytmTechprocess =gridReference.down('#btnPaytmTechprocess');
            var printbtn=gridReference.down('#btnPrint');
			btnPaytmTechprocess.setVisible(false);
			makePayment.setVisible(false);
			paytmPaymentButton.setVisible(false);
			bankField.setVisible(false);
			
			if(!isNullOrEmpty(printbtn)){
                 printbtn.setVisible(false);
                  }
			
			Ext.each(permissionList, function(privilege) {
				if (privilege === 'MAKE_PAYMENT') {
					if(!isNullOrEmpty(makePayment)){
						makePayment.setVisible(true);
					}        		
				}
				
				 if (privilege === 'PRINT') {
                                   if(!isNullOrEmpty(printbtn)){
                                       printbtn.setVisible(true);
                                   } 
                         }
				if (privilege === 'MAKE_PAYMENT_VIA_PAYTM') {
					if(!isNullOrEmpty(paytmPaymentButton)){
						paytmPaymentButton.setVisible(true);
					}        		
				}if (privilege === 'BANK') {
					if(!isNullOrEmpty(bankField)){
						bankField.setVisible(true);
					}        		
				}if (privilege === 'MAKE_PAYMENT_VIA_TECH_PROCESS') {
					if(!isNullOrEmpty(btnPaytmTechprocess)){
						btnPaytmTechprocess.setVisible(true);
					}        		
				}
			});
		},
		
		loadStudenPaymentGridStore: function(gridItemId, url, params) {
			var this$ = this;
			var personProfile = this$.getContentPanelActiveTab();
			var grid = personProfile.down(gridItemId);
			// toggleReadOnlyFormItems(grid, true);
			/*if(this.getCurrentLoggedPortalId()==2 || grid.itemId == "pendingBillsGridId"){
				grid.columns[3].hidden = true;
			}*/
			if (grid) {
				var store = grid.getStore();
				store.getProxy().api.read = url;
				store.getProxy().extraParams = params;
                if(portalId == 3){
          			 setTimeout(function(){
          			 var gridColumns=grid.columns;
     	 				 var length = gridColumns.length;
     	 				 if(length != null && length != ""){
     	 					 for(var i = 0; i < length; i++){
     	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
     	 							 gridColumns[i].destroy();
     	 						 }
     	 					 }
     	 					store.load({ 
     	 						callback: function(record, operation, success) {
     	 							if (record.length > 0) {
     	 								if(record[0].data.whetherDisplayTotal==="true"){
     	 								this$.toggleGridSummaryRow(grid,true);
     	 								grid.down('#btnExportToPDF').setDisabled(false);
     	 	                         	grid.down('#btnExportToExcel').setDisabled(false);
     	 								}
     	 							}else{
     	 								this$.toggleGridSummaryRow(grid,false);
     	 								grid.down('#btnExportToPDF').setDisabled(true);
     	 	                         	grid.down('#btnExportToExcel').setDisabled(true);
     	 							}
     	 						}
     	 					});
     	 				} 
     	 				},800);
                   }
                else if(portalId == 7){
         			 setTimeout(function(){
         			 var gridColumns=grid.columns;
    	 				 var length = gridColumns.length;
    	 				 if(length != null && length != ""){
    	 					 for(var i = 0; i < length; i++){
    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
    	 							 gridColumns[i].destroy();
    	 						 }
    	 					 }
    	 					store.load({ 
    	 						callback: function(record, operation, success) {
    	 							if (record.length > 0) {
    	 								if(record[0].data.whetherDisplayTotal==="true"){
    	 								this$.toggleGridSummaryRow(grid,true);
    	 								grid.down('#btnExportToPDF').setDisabled(false);
    	 	                         	grid.down('#btnExportToExcel').setDisabled(false);
    	 								}
    	 							}else{
    	 								this$.toggleGridSummaryRow(grid,false);
    	 								grid.down('#btnExportToPDF').setDisabled(true);
    	 	                         	grid.down('#btnExportToExcel').setDisabled(true);
    	 							}
    	 						}
    	 					});
    	 				} 
    	 				},800);
                  }

                else{
				store.load({ 
					callback: function(record, operation, success) {
						if (record.length > 0) {
							this$.toggleGridSummaryRow(grid,true);
							grid.down('#btnExportToPDF').setDisabled(false);
                         	grid.down('#btnExportToExcel').setDisabled(false);
						}else{
							this$.toggleGridSummaryRow(grid,false);
							grid.down('#btnExportToPDF').setDisabled(true);
                         	grid.down('#btnExportToExcel').setDisabled(true);
						}
					}
				});
			}
            }
/*			if (grid) {
				var store = grid.getStore();
				store.getProxy().api.read = url;
				store.getProxy().extraParams = params;
				store.load({ 
					callback: function(record, operation, success) {
						if (record.length > 0) {
							this$.toggleGridSummaryRow(grid,true);
							grid.down('#btnExportToPDF').setDisabled(false);
                         	grid.down('#btnExportToExcel').setDisabled(false);
						}else{
							this$.toggleGridSummaryRow(grid,false);
							grid.down('#btnExportToPDF').setDisabled(true);
                         	grid.down('#btnExportToExcel').setDisabled(true);
						}
					}
				});
			}*/
		},
		disablePendingBillsGridActionPivileges: function(gridReference, permissionsMap) {
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			buttonsToolBar = gridReference.query('toolbar')[0];
			var printTaxCertificatePortalBtn = gridReference.down('#btnStudentPrintTaxCertificatePortal');
			printTaxCertificatePortalBtn.setVisible(false);
			Ext.each(permissionList, function(privilege) {
				 if (privilege === 'PRINT_TAX_CERTIFICATE') {
					if(!isNullOrEmpty(printTaxCertificatePortalBtn)){
						printTaxCertificatePortalBtn.setVisible(true);
					}        		
				}
			});
		},
		disablePrintVaucherGridActionPivileges: function(gridReference, permissionsMap) {
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			buttonsToolBar = gridReference.query('toolbar')[0];
			var printVaucherPortalBtn = gridReference.down('#btnStudentPrintConsolidateOutstandingVoucherPortal');
			printVaucherPortalBtn.setVisible(false);
			Ext.each(permissionList, function(privilege) {
				 if (privilege === 'PRINT_CONSOLIDATE_OUTSTANDING_VOUCHER') {
					if(!isNullOrEmpty(printVaucherPortalBtn)){
						printVaucherPortalBtn.setVisible(true);
					}        		
				}
			});
		},
		showStudentTaxCertificateWindowWin:function(){
        	var $this = this;
        	var formWindow = $this.getStudentprinttaxcertificateportal();
        	if (!formWindow) {
        		Ext.widget('studentprinttaxcertificateportal');
        		formWindow = $this.getStudentprinttaxcertificateportal();
        	}
        	formWindow.show();
        	var form = $this.getStudentprinttaxcertificateportal();
    		var  templateNameField = form.down("#mappedAccountingYear");
    		var store = templateNameField.getStore();
    		store.load();
        },
        exportPrintCertificateJRXMLPortal: function(fileType,grid) {
        	var studentId=0;
        	var admissionId=0;
        	var studenttemp=[];
        	var admissiontemp=[];

       	 var studentInfo=this.getCurrentlyLoggedInUserInfoForPortal();

        	user=this.getCurrentlyLoggedInUser();
        	// code to identify jasper
        	var form = this.getStudentprinttaxcertificateportal();
        	var academyLocationId = this.getCurrentAcademyLocation();

        	var accountYearType =form.down("#mappedAccountingYear").getValue()
        	var templateName="STUDENT_PRINT_TAX_CERTIFICATE";
        	//var code ="ID_CARD_BACK";
        	var accountYearName=form.down("#mappedAccountingYear").getRawValue();
        	var reportParams =new Object();
        	reportParams.userId=user.code;
        	reportParams.ids=String(studentInfo.student.id); // convert int into string
        	reportParams.accountingType=accountYearType;
        	reportParams.code=templateName;
        	reportParams.academyLocationId=academyLocationId;
        	reportParams.accountTypeName=accountYearName;
        	var reportTitle="Student print tax certificate";
        	var exportUrl = SERVERURL.STUDENT_PRINT_TAX_CERTIFICATEE;
        	this.exportJRXMLReport(templateName,reportParams,reportTitle,fileType,exportUrl);
        	this.getStudentprinttaxcertificateportal().close();

        },
        disableOnlinePaymentTabPivileges: function(structureReference, permissionsMap) {
        	var me = this;
        	var associatedAcadLocationIds = new Array();
        	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
        	var structureReferencePanel = structureReference.up('personinfostudentportal');
        	var panelItem = new Array();
        	var newcont=structureReferencePanel.items.items.length;
			var insertPosition=newcont-1;
        	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        	Ext.each(permissionList, function(privilege) {
        		if (privilege === 'APPLY_FOR_GRAYQUEST_LOAN') {
        			panelItem.push({
        					xtype:"panel",
        					layout:"hbox",
        					itemId : 'grayQuestPanel',
        					style:{"padding-left":"10px !important"},
        					width:600,
        					height:38,
        					defaults:{width:250},
        					items:[{
        						xtype:"displayfield",
        						name:"outstandingAmount",
        						labelWidth:180,
        						labelStyle:"font-weight:bold;",
        						itemId:"outstandingAmount",
        						style:"margin-top:7px !important",
        						fieldStyle:{"font-weight":"bold","font-size":"14px","margin-top":"5px !important","padding-top":"1px !important"},
        						fieldLabel:"Total Outstanding Amount",
        						width:"auto"
        					},{
        						xtype:"panel",
        						itemId:"applyGQButton",
        						html:'<button id="gq-button-payment" style="cursor: pointer;padding: 6px 12px;background-image: linear-gradient(rgb(255, 255, 255) 0%, rgb(204, 204, 204) 100%) !important;background-position-x: initial !important;background-position-y: initial !important;background-size: initial !important;background-repeat-x: initial !important;background-repeat-y: initial !important;background-attachment: initial !important;background-origin: initial !important;background-clip: initial !important;background-color: initial !important;border: 1px solid #ccc;border-radius: 4px;color: #666;font-weight: bold;">Apply For GrayQuest Loan</button>',
        						listeners:{
        							afterrender:function(pnl){
        								var grayqueststudentdashlet=pnl.up("#grayQuestPanel");
        								var stRecord=grayqueststudentdashlet.parentStudentDetails;
        								if(isNullOrEmpty(stRecord.feeAmount)||stRecord.feeAmount=="0"){
        									Ext.ComponentQuery.query("#applyGQButton")[0].setDisabled(true)
        								}
        								document.getElementById("gq-button-payment").onclick=function(g){
        									if(parseFloat(stRecord.feeAmount)<10000){
        										showWarningMessage(getCommonTranslation("ALERT"),getCommonTranslation("OUTSTANDING_AMOUNT_SHOULD_BE_GREATER_THEN_10000"));return false
        									}else{
        											GqErpSDK.setOptions({
        											env:stRecord.env,auth: {
        											client_id:stRecord.clientId,
        											client_secret_key:stRecord.clientSecretKey,
        											gq_api_key:stRecord.gqAPIKey,
        											},
        											student_id:stRecord.studentID,
        											customer_mobile:stRecord.customerMobileNumber,
        											fee_editable:true,
        											fee_amount:stRecord.feeAmount,
        											payable_amount:stRecord.feeAmount,
        											student_details: {
        												student_first_name:stRecord.studentFirstName,
        												student_middle_name:stRecord.studentMiddleName,
        												student_last_name: stRecord.studentLastName,
        												student_type:stRecord.studentType
        												},
        												customer_details: {
        													customer_first_name:stRecord.customerFirstName,
        													customer_middle_name:stRecord.customerMiddleName,
        													customer_last_name:stRecord.customerLastName,
        													customer_dob:stRecord.customerDOB,
        													customer_gender:stRecord.customerGender,
        													customer_email:stRecord.customerEmail,
        													customer_marital_status:stRecord.customerMaritalStatus,
        												}
        										});
        						 				GqErpSDK.render();
        									
        									  }
        									}
        								}
        							}
        					}]
        			})
        			structureReferencePanel.insert(insertPosition,panelItem);
        		}
        		if (privilege === 'BILLDETAILS') {
        			var tabName= getFeeAndPaymentCommonTranslation('BILL_DETAILS');
        			var contentXtype ='onlinepaymentbilllevelgridforportal';
        			var itemId='opbilllevelgridforSTportal';

        			var	newTab = structureReference.add({
        				xtype:contentXtype,
    					itemId:itemId,
        				closable: false,
        				title: tabName,
//        				items:[{
//        					xtype:contentXtype,
//        					itemId:itemId,
//        				}]
        			});
        			structureReference.setActiveTab(newTab);

        		}
        		if (privilege === 'FEEHEADDETAILS') {
        			var tabName= getFeeAndPaymentCommonTranslation('FEEHEAD_DETAILS');
        			var contentXtype ='onlinepaymentgridforportal';
        			var itemId='onlinepaymentgridforstudentportal';

        			var	newTab = structureReference.add({
        				xtype:contentXtype,
    					itemId:itemId,
        				closable: false,
        				title: tabName,
//        				items:[{
//        					xtype:contentXtype,
//        					itemId:itemId
//        				}]
        			});
        			structureReference.setActiveTab(newTab);
        		}        		
        	});
        },
        getCheckedBillsForStudent: function(selmodel, record, index, action,grid){
        	var $this = this;
        	var portalId = this.getCurrentLoggedPortalId();
        	if(action == 'select'){
        		if(selmodel.selected.length >= 1){
        			grid.down('#btnPrint').setDisabled(false);
        			if(portalId ==1 && grid.itemId == "pendingBillsGridForErp"){
        				grid.down('#stdbtnBillMakePaymentButton').setDisabled(false);
        			}
        			
        		}
        	} else {
        		if(selmodel.selected.length == 0){
        			grid.down('#btnPrint').setDisabled(true);
        			if(portalId ==1){
        					if(!isNullOrEmpty(grid.down('#stdbtnBillMakePaymentButton'))){
        						grid.down('#stdbtnBillMakePaymentButton').setDisabled(true);	
        					}
        			}
        			
        		}
        	}
        },
        getCheckedReceiptsForStudent: function(selmodel, record, index, action){
        	var grid = null;
        	var $this = this;
        	var grid = $this.getPaymentReceivedHistoryGrid();
        	if(action == 'select'){
        		if(selmodel.selected.length >= 1){
        			grid.down('#btnPrint').setDisabled(false);
        		}
        	} else {
        		if(selmodel.selected.length == 0){
        			grid.down('#btnPrint').setDisabled(true);
        		}
        	}
        },

        loadStudenPaymentBillsGridStore: function(grid, url, params) {
        	 var this$ = this;
          /*   var gridpanel=this.getDebitnoteandcreditnotepanel();
             var personProfile = this$.getContentPanelActiveTab();
             var grid;
             if(this.getCurrentLoggedPortalId()==1)
            	 {
              grid=gridpanel.down("#pendingbillsgridid");
            	 }
             if(this.getCurrentLoggedPortalId()==3)
            	 {
             	 var str=Ext.widget('pendingbillstructure');
             	 grid=str.down('pendingbillsgrid');
             	 
            	 }*/
     		// toggleReadOnlyFormItems(grid, true);
             if(this.getCurrentLoggedPortalId()==2){
             	grid.columns[3].hidden = true;
             }
           
           
            if (grid) {
                var store = grid.getStore();
                store.getProxy().api.read = url;
                store.getProxy().extraParams = params;
                if(portalId == 3){
          			 setTimeout(function(){
          			 var gridColumns=grid.columns;
     	 				 var length = gridColumns.length;
     	 				 if(length != null && length != ""){
     	 					 for(var i = 0; i < length; i++){
     	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
     	 							 gridColumns[i].destroy();
     	 						 }
     	 					 }
     	 					store.load({ 
     	                 	callback: function(record, operation, success) {
     	                 		if (record.length > 0) {
     	                 			for(var i in record){
     	                 				if (record[i].data.whetherDisplayTotal != false) {
     	                 					this$.toggleGridSummaryRow(grid,true); 
     	                 				}
     	                 			}
     	                 		}else{
     	                 			this$.toggleGridSummaryRow(grid,false);
     	                 		}
     	                 	}
     	                 });
     	 				} 
     	 				},800);
                   }
                else if(portalId == 7){
         			 setTimeout(function(){
         			 var gridColumns=grid.columns;
    	 				 var length = gridColumns.length;
    	 				 if(length != null && length != ""){
    	 					 for(var i = 0; i < length; i++){
    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
    	 							 gridColumns[i].destroy();
    	 						 }
    	 					 }
    	 					store.load({ 
    	                 	callback: function(record, operation, success) {
    	                 		if (record.length > 0) {
    	                 			for(var i in record){
    	                 				if (record[i].data.whetherDisplayTotal == true) {
    	                 					this$.toggleGridSummaryRow(grid,true); 
    	                 				}
    	                 			}
    	                 		}else{
    	                 			this$.toggleGridSummaryRow(grid,false);
    	                 		}
    	                 	}
    	                 });
    	 				} 
    	 				},800);
                  }
            	 else if(this.getCurrentLoggedPortalId()==1 || grid.itemId == "pendingBillsGridId"){

        			 store.load({ 
                     	callback: function(record, operation, success) {
                     		if (record.length > 0) {
                     			for(var i in record){
                     				this$.toggleGridSummaryRow(grid,true); 
                     			}
                     		}else{
                     			this$.toggleGridSummaryRow(grid,false);
                     		}
                     	}
                     });
        		 
            	 }
                else{
                store.load({ 
                	callback: function(record, operation, success) {
                		if (record.length > 0) {
                			for(var i in record){
                				if (record[i].data.whetherDisplayTotal != false) {
                					this$.toggleGridSummaryRow(grid,true); 
                				}
                			}
                		}else{
                			this$.toggleGridSummaryRow(grid,false);
                		}
                	}
                });
            }
            }
        },
        
        loadStudenCreditNoteGridStore: function(grid, url, params) {
            var this$ = this;
           /* var gridpanel=this.getDebitnoteandcreditnotepanel();
            var personProfile = this$.getContentPanelActiveTab();
            var grid;
            if(this.getCurrentLoggedPortalId()==1)
             grid=gridpanel.down("#creditnotegridid");
            if(this.getCurrentLoggedPortalId()==3)
            	{
            	 var str=Ext.widget('pendingbillstructure');
            	 grid=str.down('creditnotegrid');
            	 
            	}*/
    		// toggleReadOnlyFormItems(grid, true);
            if(this.getCurrentLoggedPortalId()==2 ){
            	grid.columns[3].hidden = true;
            }
             if (grid) {
                var store = grid.getStore();
                store.getProxy().api.read = url;
                store.getProxy().extraParams = params;
                if(portalId == 3){
          			 setTimeout(function(){
          			 var gridColumns=grid.columns;
     	 				 var length = gridColumns.length;
     	 				 if(length != null && length != ""){
     	 					 for(var i = 0; i < length; i++){
     	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
     	 							 gridColumns[i].destroy();
     	 						 }
     	 					 }
     	 					store.load({ 
     	                 	callback: function(record, operation, success) {
     	                 		if (record.length > 0) {
     	                 			for(var i in record){
     	                 				if (record[i].data.whetherDisplayTotal != false) {
     	                 					this$.toggleGridSummaryRow(grid,true); 
     	                 				}
     	                 			}
     	                 		}else{
     	                 			this$.toggleGridSummaryRow(grid,false);
     	                 		}
     	                 	}
     	                 });
     	 				} 
     	 				},800);
                   }
                else if(portalId == 7){
         			 setTimeout(function(){
         			 var gridColumns=grid.columns;
    	 				 var length = gridColumns.length;
    	 				 if(length != null && length != ""){
    	 					 for(var i = 0; i < length; i++){
    	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount' || gridColumns[i].dataIndex=='convertedBalanceAmount'){
    	 							 gridColumns[i].destroy();
    	 						 }
    	 					 }
    	 					store.load({ 
    	                 	callback: function(record, operation, success) {
    	                 		if (record.length > 0) {
    	                 			for(var i in record){
    	                 				if (record[i].data.whetherDisplayTotal == true) {
    	                 					this$.toggleGridSummaryRow(grid,true); 
    	                 				}
    	                 			}
    	                 		}else{
    	                 			this$.toggleGridSummaryRow(grid,false);
    	                 		}
    	                 	}
    	                 });
    	 				} 
    	 				},800);
                  }
            	 else if(this.getCurrentLoggedPortalId()==1 || grid.itemId == "pendingBillsGridId"){

        			 store.load({ 
                     	callback: function(record, operation, success) {
                     		if (record.length > 0) {
                     			for(var i in record){
                     				this$.toggleGridSummaryRow(grid,true); 
                     			}
                     		}else{
                     			this$.toggleGridSummaryRow(grid,false);
                     		}
                     	}
                     });
        		 
            	 }
                else{
                store.load({ 
                	callback: function(record, operation, success) {
                		if (record.length > 0) {
                			for(var i in record){
                				if (record[i].data.whetherDisplayTotal != false) {
                					this$.toggleGridSummaryRow(grid,true); 
                				}
                			}
                		}else{
                			this$.toggleGridSummaryRow(grid,false);
                		}
                	}
                });
            }
            }
        },
        loadStudenRefundHistoryGridStore: function(gridItemId, url, params) {
            var this$ = this;
            var personProfile = this$.getContentPanelActiveTab();
            var grid = personProfile.down(gridItemId);
    		// toggleReadOnlyFormItems(grid, true);
            if(this.getCurrentLoggedPortalId()==2 || grid.itemId == "pendingBillsGridId"){
            	grid.columns[3].hidden = true;
            }
            if (grid) {
                var store = grid.getStore();
                store.getProxy().api.read = url;
                store.getProxy().extraParams = params;
                if(portalId == 3){
       			 setTimeout(function(){
       			 var gridColumns=grid.columns;
  	 				 var length = gridColumns.length;
  	 				 if(length != null && length != ""){
  	 					 for(var i = 0; i < length; i++){
  	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
  	 							 gridColumns[i].destroy();
  	 						 }
  	 					 }
  	 					store.load({ 
  	                 	callback: function(record, operation, success) {
  	                 		if (record.length > 0) {
  	                 			for(var i in record){
  	                 				if (record[i].data.whetherDisplayTotal != false) {
  	                 					this$.toggleGridSummaryRow(grid,true); 
  	                 				}
  	                 			}
  	                 		}else{
  	                 			this$.toggleGridSummaryRow(grid,false);
  	                 		}
  	                 	}
  	                 });
  	 				} 
  	 				},800);
                }
                else  if(portalId == 7){
          			 setTimeout(function(){
               			 var gridColumns=grid.columns;
          	 				 var length = gridColumns.length;
          	 				 if(length != null && length != ""){
          	 					 for(var i = 0; i < length; i++){
          	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
          	 							 gridColumns[i].destroy();
          	 						 }
          	 					 }
          	 					store.load({ 
          	                 	callback: function(record, operation, success) {
          	                 		if (record.length > 0) {
          	                 			for(var i in record){
          	                 				if (record[i].data.whetherDisplayTotal != false) {
          	                 					this$.toggleGridSummaryRow(grid,true); 
          	                 				}
          	                 			}
          	                 		}else{
          	                 			this$.toggleGridSummaryRow(grid,false);
          	                 		}
          	                 	}
          	                 });
          	 				} 
          	 				},800);
                        }
            	 else if(this.getCurrentLoggedPortalId()==1 || grid.itemId == "pendingBillsGridId"){

        			 store.load({ 
                     	callback: function(record, operation, success) {
                     		if (record.length > 0) {
                     			for(var i in record){
                     				this$.toggleGridSummaryRow(grid,true); 
                     			}
                     		}else{
                     			this$.toggleGridSummaryRow(grid,false);
                     		}
                     	}
                     });
        		 
            	 }
                else{
                store.load({ 
                	callback: function(record, operation, success) {
                		if (record.length > 0) {
                			for(var i in record){
                				if (record[i].data.whetherDisplayTotal != false) {
                					this$.toggleGridSummaryRow(grid,true); 
                				}
                			}
                		}else{
                			this$.toggleGridSummaryRow(grid,false);
                		}
                	}
                });
                }
            }
        },
        loadStudenReceiptGridStore: function(gridItemId, url, params) {
            var this$ = this;
            var personProfile = this$.getContentPanelActiveTab();
            var grid = personProfile.down(gridItemId);
    		// toggleReadOnlyFormItems(grid, true);
            if(this.getCurrentLoggedPortalId()==2 || grid.itemId == "pendingBillsGridId"){
            	grid.columns[3].hidden = true;
            }
            if (grid) {
            	var store = grid.getStore();
                store.getProxy().api.read = url;
                store.getProxy().extraParams = params;
            	 if(portalId == 3){
        			 setTimeout(function(){
        			 var gridColumns=grid.columns;
   	 				 var length = gridColumns.length;
   	 				 if(length != null && length != ""){
   	 					 for(var i = 0; i < length; i++){
   	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   	 							 gridColumns[i].destroy();
   	 						 }
   	 					 }
   	 					store.load({ 
   	                 	callback: function(record, operation, success) {
   	                 		if (record.length > 0) {
   	                 			for(var i in record){
   	                 				if (record[i].data.whetherDisplayTotal != false) {
   	                 					this$.toggleGridSummaryRow(grid,true); 
   	                 				}
   	                 			}
   	                 		}else{
   	                 			this$.toggleGridSummaryRow(grid,false);
   	                 		}
   	                 	}
   	                 });
   	 				} 
   	 				},300);	 
        		 }
            	 else if(portalId == 7){
        			 setTimeout(function(){
        			 var gridColumns=grid.columns;
   	 				 var length = gridColumns.length;
   	 				 if(length != null && length != ""){
   	 					 for(var i = 0; i < length; i++){
   	 						 if(gridColumns[i].dataIndex=='currencyExchangeRate' || gridColumns[i].dataIndex=='convertedAmount'){
   	 							 gridColumns[i].destroy();
   	 						 }
   	 					 }
   	 					store.load({ 
   	                 	callback: function(record, operation, success) {
   	                 		if (record.length > 0) {
   	                 			for(var i in record){
   	                 				if (record[i].data.whetherDisplayTotal == true) {
   	                 					this$.toggleGridSummaryRow(grid,true); 
   	                 				}
   	                 			}
   	                 		}else{
   	                 			this$.toggleGridSummaryRow(grid,false);
   	                 		}
   	                 	}
   	                 });
   	 				} 
   	 				},300);	 
        		 }

            	 else if(this.getCurrentLoggedPortalId()==1 || grid.itemId == "pendingBillsGridId"){

        			 store.load({ 
                     	callback: function(record, operation, success) {
                     		if (record.length > 0) {
                     			for(var i in record){
                     				this$.toggleGridSummaryRow(grid,true); 
                     			}
                     		}else{
                     			this$.toggleGridSummaryRow(grid,false);
                     		}
                     	}
                     });
        		 
            	 }
            	 else{
        			 store.load({ 
                     	callback: function(record, operation, success) {
                     		if (record.length > 0) {
                     			for(var i in record){
                     				if (record[i].data.whetherDisplayTotal != false) {
                     					this$.toggleGridSummaryRow(grid,true); 
                     				}
                     			}
                     		}else{
                     			this$.toggleGridSummaryRow(grid,false);
                     		}
                     	}
                     });
        		 }
                
                
            }
        },
        stdDisablePendingBillMakePaymentPivileges: function(gridReference, permissionsMap) {
			var associatedAcadLocationIds = new Array();
			associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			buttonsToolBar = gridReference.query('toolbar')[0];
			var makePayment = gridReference.down('#stdbtnBillMakePaymentButton');//make payment
			makePayment.setVisible(false);
			Ext.each(permissionList, function(privilege) {
				if (privilege === 'MAKE_PAYMENT') {
					if(!isNullOrEmpty(makePayment)){
						makePayment.setVisible(true);
					}        		
				}
			});
		},
		
		disableBillCreditTabByPriviledge: function(structure,permissionsMap) {
		   	 var associatedAcadLocationIds = new Array();
			   	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
			   	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			   	 var billTab=false;
			   	 var creditTab=false;
			   	 for (var i = 0; i < permissionList.length; i++) {
			   		 if (permissionList[i] === "BILLS_TAB") {
			   			billTab=true;
			   		 }
			   		 if (permissionList[i] === "CREDIT_NOTES_TAB") {
			   			creditTab=true;
				   	 }
			   	 }
			   	 this.showBillsTab(billTab,creditTab, structure);
			    
		   },
		   showBillsTab: function(billTab,creditTab,structure){

			   var panelItem = new Array();
			   var $this = this;
			   var newcont=structure.items.items.length;
			   var insertPosition=newcont+1;
			   if(billTab==true && creditTab==true) {
				   panelItem.push({xtype:'tabpanel',
						plain: true,
						style:{overflow:'hidden !important',marginLeft:'0!important'},
						bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
						frame: false,
						border:false,
						items:[{
							xtype:'panel',
							title:getFeeAndPaymentCommonTranslation('BILLS'),
							items : [{
								xtype: 'pendingbillsfilter',
								itemId: 'pendingbillsfilter'
							},{
								xtype: 'pendingbillsgridforstudentportal',
								itemId: 'studentPortalPendingBillsGrid'
							}]
						},{
							xtype:'panel',
							title:getFeeAndPaymentCommonTranslation('CREDIT_NOTES'),
							items : [{
								xtype: 'pendingcreditfilter',
								itemId: 'pendingcreditfilter'
							},{
								xtype: 'creditnotegridforstudentportal',
								itemId: 'studentPortalCreditNoteGrid'
							}]
						}]});
			   }else if(billTab==true){
				   panelItem.push({
					   xtype:'tabpanel',
					   plain: true,
					   style:{overflow:'hidden !important',margin:'0!important'},
					   bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
					   frame: false,
					   border:false,
					   items:[{
						   xtype:'panel',
						   title:getFeeAndPaymentCommonTranslation('BILLS'),
						   items : [{
							   xtype: 'pendingbillsfilter',
							   itemId: 'pendingbillsfilter'
						   },{
							   xtype: 'pendingbillsgridforstudentportal',
							   itemId: 'studentPortalPendingBillsGrid'
						   }]
					   }]

				   });
			   }else if(creditTab==true){
				   panelItem.push({
					   xtype:'tabpanel',
					   plain: true,
					   style:{overflow:'hidden !important',margin:'0!important'},
					   bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
					   frame: false,
					   border:false,
					   items:[{
							xtype:'panel',
							title:getFeeAndPaymentCommonTranslation('CREDIT_NOTES'),
							items : [{
								xtype: 'pendingcreditfilter',
								itemId: 'pendingcreditfilter'
							},{
								xtype: 'creditnotegridforstudentportal',
								itemId: 'studentPortalCreditNoteGrid'
							}]
						}]

				   });
			   }
			   structure.insert(insertPosition,panelItem);
		   },
		
        disableOnlinePaymentAdminTabPivileges: function(structureReference, permissionsMap) {
        	var me = this;
        	var associatedAcadLocationIds = new Array();
        	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
        	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        	Ext.each(permissionList, function(privilege) {
        		if (privilege === 'BILLDETAILS') {
        			var tabName= getFeeAndPaymentCommonTranslation('BILL_DETAILS');
        			var contentXtype ='onlinepaymentbilllevelgridforportal';
        			var itemId='opbilllevelgridforSTportal';

        			var	newTab = structureReference.add({
        				xtype: contentXtype,
        				closable: false,
        				title: tabName,
        				itemId:itemId
        			});
        			 setTimeout(function(){
        				 structureReference.setActiveTab(newTab);
        			 },100);
        		}
        		if (privilege === 'FEEHEADDETAILS') {
        			var tabName= getFeeAndPaymentCommonTranslation('FEEHEAD_DETAILS');
        			var contentXtype ='onlinepaymentgridforportal';
        			var itemId='onlinepaymentgridforstudentportal';

        			var	newTab = structureReference.add({
        				xtype: contentXtype,
        				closable: false,
        				title: tabName,
        				itemId:itemId
        			});
        			structureReference.setActiveTab(newTab);
        		} 
        	});
        },
        
        getBillDetailsPaymentBankStudentPortal: function ($this,flagIsHostelFee,flagPaymentGatewayMasterIsHostelFee,flagPaymentGatewayMasterIsNotHostelFee,flagForHostelJSON,records,grid,bankField){
        	if(bankField.isVisible() == true) {					
        		if(!isNullOrEmpty(bankField.getValue())){
        			if(flagIsHostelFee){
        				var records = grid.selModel.getSelection();
        				var totalAmount=0;
        				var totalBalanceAmount=0;
        				if(flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee==0){
        					//error log
        					showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),
        							getPersonModuleTranslation('YOU_CANNOT_MAKE_PAYMENT_FOR_THE_HOSTEL_FEE_PLEASE_TRY_AGAIN_LATER'));
        				}else if(flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee>1){
        					//error log
        					showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),
        							getPersonModuleTranslation('YOU_CANNOT_MAKE_PAYMENT_FOR_THE_HOSTEL_FEE_PLEASE_TRY_AGAIN_LATER'));
        				}else if((flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee==1)||(!flagForHostelJSON)){
        					//true condition
        					for(var i in records){
        						var balanceAmounts = records[i].get('tempRemainingAmount');
        						var amounts = records[i].get('balanceAmount');
        						if(isNullOrEmpty(amounts)){
        							showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
        							return false;
        						}
        						totalBalanceAmount = totalBalanceAmount + balanceAmounts;
        						totalAmount = totalAmount + amounts;
        					}
        					if(totalBalanceAmount >=0 && totalAmount>0){ 
        						var onlineAmount=[];
        						for(var i in records){
        							onlineAmount.push({
        								"billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
        								"billId":records[i].data.billId,
        								"adjustedAmount":records[i].data.balanceAmount,
        								"balanceAmount": records[i].get('tempRemainingAmount')
        							});
        						}

        						var amount=totalAmount;
        						var orgModel = Academia.model.common.OrgSettingDateTimeModel;

        						var amountWithCharge = totalAmount * (grid.config.bankChargeApplicable==undefined?1:grid.config.bankChargeApplicable/100);
        						var transactionalFee;
        						if(amountWithCharge < grid.config.thresholdLimit ) {
        							var totalAmountToPay =  amountWithCharge + totalAmount;
        							transactionalFee = amountWithCharge
        						}
        						else {
        							var totalAmountToPay = (grid.config.thresholdLimit==undefined?0.0:grid.config.thresholdLimit) + totalAmount
        							transactionalFee = grid.config.thresholdLimit==undefined?null:grid.config.thresholdLimit
        						}
        						var submitData = {
        								"receiptAmount" : totalAmount,
        								"onlinePayments" : onlineAmount,
        								"transactionFees": transactionalFee
        						};
        						//var message = 'Are you sure, you want to make payment of ' + orgModel.get('currencyFormat') + ' ' +totalAmount+' ?';
        						var currency = records[0].data.currencyId;
        						var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);
        						var message = 'Are you sure, you want to make payment of ' + billCurrency + ' ' +totalAmountToPay+' ?';

        						var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL
        						showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
        							if (btn == 'yes') {
        								var XMLHttpRequestObject = false;  
        								if (window.XMLHttpRequest) {  
        									XMLHttpRequestObject = new XMLHttpRequest();  
        									XMLHttpRequestObject.overrideMimeType("text/xml");  
        								}  
        								else if (window.ActiveXObject) {  
        									XMLHttpRequestObject = new  
        									ActiveXObject("Microsoft.XMLHTTP");  
        								} 
        								XMLHttpRequestObject.withCredentials = false;
        								XMLHttpRequestObject.onreadystatechange = function() {
        									if (this.readyState == 4 && this.status == 200) {
        										var id = parseInt(XMLHttpRequestObject.responseText);
        										if(!isNaN(id)) {
        											var formWindow = Ext.widget('paymentsummarywin',{
        												itemId:'student'
        											});
        											var emailID = null;
        											var mobileNo = null; 
        											var printName = null;
        											if(portalId == 1){
        												emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
        												mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
        												printName = $this.getStudentDetailForErpPortal().student.person.printName
        											}else{
        												emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
        												mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber;
        												printName = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.printName
        											}
        											formWindow.down('#name').setValue(printName);
        											formWindow.down('#email').setValue(emailID);
        											formWindow.down('#mobileNo').setValue(mobileNo);
        											//formWindow.down('#amount').setValue(currencyRenderer(totalAmount,records.currencyId));
        											formWindow.down('#amount').setValue(billCurrency+' '+totalAmountToPay);
        											formWindow.show();
        											Ext.apply(formWindow,{
        												data:null,
        												setData : function(data){
        													formWindow.data = data;
        												},
        												getData:function(){
        													return formWindow.data;
        												}
        											});
        											formWindow.setData(id);
        											if(records[0].data.isonlinePaymentDocAvailable == false ) {
        												formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
        												formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
        												formWindow.down('#payNow').enable();
        											}else{
        												formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
        												formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
        												formWindow.down('#payNow').disable();
        											}
        										} else {
        											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
        										}
        									}
        								};
        								var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL;
        								Ext.Ajax.request({
        									type : 'rest',
        									url : submitUrl,
        									jsonData : submitData,
        									method : 'POST',
        									success : function(response, action) {
        										//onlinePaymentId
        										var onlinePaymentId = response.responseText;
        										XMLHttpRequestObject.open("POST",  grid.getPaymentPostUrl(), true);
        										XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
//      										XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId);
        										if(flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee==1){
        											XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId+"&isHostelFee="+1);
        										}else if(!flagForHostelJSON){
        											XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId+"&isHostelFee="+0);
        										}
        									}
        								});
        							}

        						})
        					}else{
        						showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
        					}
        				}
        			}else{
        				showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),
        						getPersonModuleTranslation('PLEASE_PAY_FOR_HOSTEL_FEE_SEPARATELY_IT_SHOULD_NOT_BE_COMBINED_WITH_OTHER_FEES'));
        			}
        		}else{
        			showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), getCommonTranslation('PLEASE_SELECT_BANK')); //Please select a record  
        		}
        	}else{
        		var records = grid.selModel.getSelection();
        		var totalAmount=0;
        		var totalBalanceAmount=0;
        		if(flagIsHostelFee){
        			if(flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee==0){
        				//error log
        				showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),
        						getPersonModuleTranslation('YOU_CANNOT_MAKE_PAYMENT_FOR_THE_HOSTEL_FEE_PLEASE_TRY_AGAIN_LATER'));
        			}else if(flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee>1){
        				//error log
        				showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),
        						getPersonModuleTranslation('YOU_CANNOT_MAKE_PAYMENT_FOR_THE_HOSTEL_FEE_PLEASE_TRY_AGAIN_LATER'));
        			}else if((flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee==1)||(!flagForHostelJSON)){
        				//true condition
        				for(var i in records){
        					var balanceAmounts = records[i].get('tempRemainingAmount');
        					var amounts = records[i].get('balanceAmount');
        					if(isNullOrEmpty(amounts)){
        						showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
        						return false;
        					}
        					totalBalanceAmount = totalBalanceAmount + balanceAmounts;
        					totalAmount = totalAmount + amounts;
        				}
        				if(totalBalanceAmount >=0 && totalAmount>0){ 
        					var onlineAmount=[];
        					for(var i in records){
        						onlineAmount.push({
        							"billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
        							"billId":records[i].data.billId,
        							"adjustedAmount":records[i].data.balanceAmount,
        							"balanceAmount": records[i].get('tempRemainingAmount')
        						});
        					}

        					var amount=totalAmount;
        					var orgModel = Academia.model.common.OrgSettingDateTimeModel;

        					var submitData = {
        							"receiptAmount" : totalAmount,
        							"onlinePayments" : onlineAmount,

        					};
        					//var message = 'Are you sure, you want to make payment of ' + orgModel.get('currencyFormat') + ' ' +totalAmount+' ?';
        					var currency = records[0].data.currencyId;
        					var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);
        					var message = 'Are you sure, you want to make payment of ' + billCurrency + ' ' +totalAmount+' ?';

        					var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL
        					showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
        						if (btn == 'yes') {
        							var XMLHttpRequestObject = false;  
        							if (window.XMLHttpRequest) {  
        								XMLHttpRequestObject = new XMLHttpRequest();  
        								XMLHttpRequestObject.overrideMimeType("text/xml");  
        							}  
        							else if (window.ActiveXObject) {  
        								XMLHttpRequestObject = new  
        								ActiveXObject("Microsoft.XMLHTTP");  
        							} 
        							XMLHttpRequestObject.withCredentials = false;
        							XMLHttpRequestObject.onreadystatechange = function() {
        								if (this.readyState == 4 && this.status == 200) {
        									var id = parseInt(XMLHttpRequestObject.responseText);
        									if(!isNaN(id)) {
        										var formWindow = Ext.widget('paymentsummarywin',{
        											itemId:'student'
        										});
        										var emailID = null;
        										var mobileNo = null; 
        										var printName = null;
        										if(portalId == 1){
        											emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
        											mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
        											printName = $this.getStudentDetailForErpPortal().student.person.printName
        										}else{
        											emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
        											mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber;
        											printName = $this.getCurrentlyLoggedInUserInfoForPortal().student.printName;
        										}
        										formWindow.down('#name').setValue(printName);
        										formWindow.down('#email').setValue(emailID);
        										formWindow.down('#mobileNo').setValue(mobileNo);
        										//formWindow.down('#amount').setValue(currencyRenderer(totalAmount,records.currencyId));
        										formWindow.down('#amount').setValue(billCurrency+' '+totalAmount);
        										formWindow.show();
        										Ext.apply(formWindow,{
        											data:null,
        											setData : function(data){
        												formWindow.data = data;
        											},
        											getData:function(){
        												return formWindow.data;
        											}
        										});
        										formWindow.setData(id);
        										if(records[0].data.isonlinePaymentDocAvailable == false ) {
        											formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
        											formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
        											formWindow.down('#payNow').enable();
        										}else{
        											formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
        											formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
        											formWindow.down('#payNow').disable();
        										}
        									} else {
        										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
        									}
        								}
        							};
        							var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL;
        							Ext.Ajax.request({
        								type : 'rest',
        								url : submitUrl,
        								jsonData : submitData,
        								method : 'POST',
        								success : function(response, action) {
        									//onlinePaymentId
        									var onlinePaymentId = response.responseText;
        									XMLHttpRequestObject.open("POST",  grid.getPaymentPostUrl(), true);
        									XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
//      									XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId);
        									if(flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee==1){
        										XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId+"&isHostelFee="+1);
        									}else if(!flagForHostelJSON){
        										XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId+"&isHostelFee="+0);
        									}
        								}
        							});
        						}

        					})
        				}else{
        					showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
        				}
        			}
        		}
        		else{
        			showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),
        					getPersonModuleTranslation('PLEASE_PAY_FOR_HOSTEL_FEE_SEPARATELY_IT_SHOULD_NOT_BE_COMBINED_WITH_OTHER_FEES'));
        		}
        	}
        },
        getFeeHeadDetailsPaymentBankStudentPortal: function ($this,flagIsHostelFee,flagPaymentGatewayMasterIsHostelFee,flagPaymentGatewayMasterIsNotHostelFee,flagForHostelJSON,gridRecords,grid,bankField){


        	if(bankField.isVisible() == true)
        	{
        		if(!isNullOrEmpty(bankField.getValue())) {
        			if(flagIsHostelFee){
        				grid.config.thresholdLimit	
        				grid.config.bankChargesApplicable
        				var records = grid.selModel.getSelection();
        				var totalAmount=0;
        				var totalBalanceAmount=0;
        				if(flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee==0){
        					//error log
        					showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),
        							getPersonModuleTranslation('YOU_CANNOT_MAKE_PAYMENT_FOR_THE_HOSTEL_FEE_PLEASE_TRY_AGAIN_LATER'));
        				}else if(flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee>1){
        					//error log
        					showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),
        							getPersonModuleTranslation('YOU_CANNOT_MAKE_PAYMENT_FOR_THE_HOSTEL_FEE_PLEASE_TRY_AGAIN_LATER'));
        				}else if((flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee==1)||(!flagForHostelJSON)){
        					//true condition
        					for(var i in records){
        						var balanceAmounts = records[i].get('tempRemainingAmount');
        						var amounts = records[i].get('totalBalanceAmount');
        						if(isNullOrEmpty(amounts)){
        							showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
        							return false;
        						}
        						totalBalanceAmount = totalBalanceAmount + balanceAmounts;
        						totalAmount = totalAmount + amounts;
        						//transactionFees = 
        					}
        					if(totalBalanceAmount >=0 && totalAmount>0){ 
        						var onlineAmount=[];
        						for(var i in records){
        							onlineAmount.push({
        								"billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
        								"billId":records[i].get('billHeaderId'),
        								"adjustedAmount":records[i].get('totalBalanceAmount'),
        								"balanceAmount": records[i].get('tempRemainingAmount')   
        							});
        						}

        						var amount=totalAmount;
        						var orgModel = Academia.model.common.OrgSettingDateTimeModel;
        						//var message = 'Are you sure, you want to make payment of ' + orgModel.get('currencyFormat') + ' ' +totalAmount+' ?';
        						var currency = records[0].data.currencyId;
        						var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);


        						//grid.config.bankChargesApplicable
        						var amountWithCharge = totalAmount * (grid.config.bankChargeApplicable==undefined?1:grid.config.bankChargeApplicable/100);
        						var transactionalFee;
        						if(amountWithCharge < grid.config.thresholdLimit ) {
        							var totalAmountToPay =  amountWithCharge + totalAmount;
        							transactionalFee = amountWithCharge
        						}
        						else {
        							var totalAmountToPay = (grid.config.thresholdLimit==undefined?0.0:grid.config.thresholdLimit) + totalAmount
        							transactionalFee = grid.config.thresholdLimit==undefined?null:grid.config.thresholdLimit
        						}
        						var submitData = {
        								"receiptAmount" : totalAmount,
        								"onlinePayments" : onlineAmount,
        								"transactionFees": transactionalFee
        						};
        						var message = 'Are you sure, you want to make payment of ' + billCurrency + ' ' +totalAmountToPay+' ?';
        						var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE
        						showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
        							if (btn == 'yes') {
        								var XMLHttpRequestObject = false;  
        								if (window.XMLHttpRequest) {  
        									XMLHttpRequestObject = new XMLHttpRequest();  
        									XMLHttpRequestObject.overrideMimeType("text/xml");  
        								}  
        								else if (window.ActiveXObject) {  
        									XMLHttpRequestObject = new  
        									ActiveXObject("Microsoft.XMLHTTP");  
        								} 
        								XMLHttpRequestObject.withCredentials = false;
        								XMLHttpRequestObject.onreadystatechange = function() {
        									if (this.readyState == 4 && this.status == 200) {
        										var id = parseInt(XMLHttpRequestObject.responseText);
        										if(!isNaN(id)) {
        											var formWindow = Ext.widget('paymentsummarywin',{
        												itemId:'student'
        											});
        											var emailID = null;
        											var mobileNo = null; 
        											if(portalId == 1){
        												emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
        												mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
        											}else{
        												emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
        												mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber
        											}

        											formWindow.down('#name').setValue(records[0].data.printName);
        											formWindow.down('#email').setValue(emailID);
        											formWindow.down('#mobileNo').setValue(mobileNo);
        											//formWindow.down('#amount').setValue(currencyRenderer(totalAmount,records.currencyId));
        											formWindow.down('#amount').setValue(billCurrency+' '+totalAmountToPay);

        											formWindow.show();
        											/*var summaryGrid = formWindow.down('grid');
									   summaryGrid.getStore().loadRawData([]);
									   summaryGrid.getStore().loadRawData(innerJsonArr);
									   var summaryWindMsg = formWindow.down('#summaryWindMsg');
									   summaryWindMsg.setVisible(true);
									   summaryWindMsg.setValue('&nbsp;<b>Total Amount To Be Paid : '+totalAmmount+" /-</b>");*/
        											Ext.apply(formWindow,{
        												data:null,
        												setData : function(data){
        													formWindow.data = data;
        												},
        												getData:function(){
        													return formWindow.data;
        												}
        											});
        											formWindow.setData(id);
        											if(records[0].data.isonlinePaymentDocAvailable == false ) {
        												formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
        												formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
        												formWindow.down('#payNow').enable();
        											}else{
        												formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
        												formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
        												formWindow.down('#payNow').disable();
        											}
        										} else {
        											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
        										}
        									}
        								};
        								var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE;
        								Ext.Ajax.request({
        									type : 'rest',
        									url : submitUrl,
        									jsonData : submitData,
        									method : 'POST',
        									success : function(response, action) {
        										//onlinePaymentId
        										var onlinePaymentId = response.responseText;
        										/* var json = {
												 "onlinePaymentId" : onlinePaymentId,
												 "studentName" : records[0].data.printName,
												 "batchName" : records[0].data.batchName,
												 "programName": records[0].data.programName,
												 "feeHeadName": records[0].data.feeHeadName
										 }*/
        										var json=null;
        										if(flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee==1){
        											json = {
        												"onlinePaymentId" : onlinePaymentId,
        												"studentName" : records[0].data.printName,
        												"batchName" : records[0].data.batchName,
        												"programName": records[0].data.programName,
        												"feeHeadName": records[0].data.feeHeadName,
        												"isHostelFee":1
        											}
        										}else if(!flagForHostelJSON){
        											json = {
        												"onlinePaymentId" : onlinePaymentId,
        												"studentName" : records[0].data.printName,
        												"batchName" : records[0].data.batchName,
        												"programName": records[0].data.programName,
        												"feeHeadName": records[0].data.feeHeadName,
        												"isHostelFee":0
        											}
        										}
        										XMLHttpRequestObject.open("POST",grid.getPaymentPostUrl(), true);
        										XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        										XMLHttpRequestObject.send(JSON.stringify(json));
        									}
        								});
        								/*
						var buildInfo="";
						var paymentUrl="";  
						var XMLHttpRequestObject = false;  
						if (window.XMLHttpRequest) {  
							XMLHttpRequestObject = new XMLHttpRequest();  
							XMLHttpRequestObject.overrideMimeType("text/xml");  
						}  
						else if (window.ActiveXObject) {  
							XMLHttpRequestObject = new  
							ActiveXObject("Microsoft.XMLHTTP");  
						}  
						if(XMLHttpRequestObject) {  
							XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
							XMLHttpRequestObject.onreadystatechange = function(){       
								if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200){  
									var xmlDocument = XMLHttpRequestObject.responseXML;  
									buildInfo =xmlDocument.getElementsByTagName("buildInfo") [0];  
									paymentUrl = buildInfo.getElementsByTagName("paymentUrl") [0].childNodes[0].nodeValue;
									Ext.getBody().mask('wait..', 'x-mask-loading');
									Ext.Ajax.request({
										type : 'rest',
										url : submitUrl,
										jsonData : submitData,
										method : 'POST',
										success : function(response, action) {
											//onlinePaymentId
											var onlinePaymentId = response.responseText;
											window.open(paymentUrl+"?onlinePaymentId="+onlinePaymentId,"Online_Payment","width=1000,height=600");
											Ext.getBody().unmask();
											var contentpanel = $this.getContentPanel();
											var tabName = getPersonModuleTranslation('ONLINE_PAYMENT');
											var getcontroller=$this.getController('menu.CoreERPNavigationController');
								    		   var getTab=getcontroller.getTab(tabName);
								    		   if(getTab!=null){
								    			   contentpanel.remove(getTab, true);
								    		   }
										}
									});
								}  
							} 
							XMLHttpRequestObject.send(null);  
						}
        								 */}
        						})
        					}else{
        						showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
        					}
        				}
        			}else{
        				showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),
        						getPersonModuleTranslation('PLEASE_PAY_FOR_HOSTEL_FEE_SEPARATELY_IT_SHOULD_NOT_BE_COMBINED_WITH_OTHER_FEES'));
        			}
        		}else{
        			showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), getCommonTranslation('PLEASE_SELECT_BANK')); 
        		}
        	}else
        	{
        		var records = grid.selModel.getSelection();
        		var totalAmount=0;
        		var totalBalanceAmount=0;
        		if(flagIsHostelFee){
        			if(flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee==0){
        				//error log
        				showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),
        						getPersonModuleTranslation('YOU_CANNOT_MAKE_PAYMENT_FOR_THE_HOSTEL_FEE_PLEASE_TRY_AGAIN_LATER'));
        			}else if(flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee>1){
        				//error log
        				showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),
        						getPersonModuleTranslation('YOU_CANNOT_MAKE_PAYMENT_FOR_THE_HOSTEL_FEE_PLEASE_TRY_AGAIN_LATER'));
        			}else if((flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee==1)||(!flagForHostelJSON)){
        				//true condition
        				for(var i in records){
        					var balanceAmounts = records[i].get('tempRemainingAmount');
        					var amounts = records[i].get('totalBalanceAmount');
        					if(isNullOrEmpty(amounts)){
        						showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
        						return false;
        					}
        					totalBalanceAmount = totalBalanceAmount + balanceAmounts;
        					totalAmount = totalAmount + amounts;
        					//transactionFees = 
        				}
        				if(totalBalanceAmount >=0 && totalAmount>0){ 
        					var onlineAmount=[];
        					for(var i in records){
        						onlineAmount.push({
        							"billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
        							"billId":records[i].get('billHeaderId'),
        							"adjustedAmount":records[i].get('totalBalanceAmount'),
        							"balanceAmount": records[i].get('tempRemainingAmount')   
        						});
        					}

        					var amount=totalAmount;
        					var orgModel = Academia.model.common.OrgSettingDateTimeModel;
        					//var message = 'Are you sure, you want to make payment of ' + orgModel.get('currencyFormat') + ' ' +totalAmount+' ?';
        					var currency = records[0].data.currencyId;
        					var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);
        					var submitData = {
        							"receiptAmount" : totalAmount,
        							"onlinePayments" : onlineAmount,
        					};
        					var message = 'Are you sure, you want to make payment of ' + billCurrency + ' ' +totalAmount+' ?';
        					var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE
        					showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
        						if (btn == 'yes') {
        							var XMLHttpRequestObject = false;  
        							if (window.XMLHttpRequest) {  
        								XMLHttpRequestObject = new XMLHttpRequest();  
        								XMLHttpRequestObject.overrideMimeType("text/xml");  
        							}  
        							else if (window.ActiveXObject) {  
        								XMLHttpRequestObject = new  
        								ActiveXObject("Microsoft.XMLHTTP");  
        							} 
        							XMLHttpRequestObject.withCredentials = false;
        							XMLHttpRequestObject.onreadystatechange = function() {
        								if (this.readyState == 4 && this.status == 200) {
        									var id = parseInt(XMLHttpRequestObject.responseText);
        									if(!isNaN(id)) {
        										var formWindow = Ext.widget('paymentsummarywin',{
        											itemId:'student'
        										});
        										var emailID = null;
        										var mobileNo = null; 
        										if(portalId == 1){
        											emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
        											mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
        										}else{
        											emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
        											mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber
        										}

        										formWindow.down('#name').setValue(records[0].data.printName);
        										formWindow.down('#email').setValue(emailID);
        										formWindow.down('#mobileNo').setValue(mobileNo);
        										//formWindow.down('#amount').setValue(currencyRenderer(totalAmount,records.currencyId));
        										formWindow.down('#amount').setValue(billCurrency+' '+totalAmount);

        										formWindow.show();
        										Ext.apply(formWindow,{
        											data:null,
        											setData : function(data){
        												formWindow.data = data;
        											},
        											getData:function(){
        												return formWindow.data;
        											}
        										});
        										formWindow.setData(id);
        										if(records[0].data.isonlinePaymentDocAvailable == false ) {
        											formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
        											formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
        											formWindow.down('#payNow').enable();
        										}else{
        											formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
        											formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
        											formWindow.down('#payNow').disable();
        										}
        									} else {
        										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
        									}
        								}
        							};
        							var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE;
        							Ext.Ajax.request({
        								type : 'rest',
        								url : submitUrl,
        								jsonData : submitData,
        								method : 'POST',
        								success : function(response, action) {
        									//onlinePaymentId
        									var onlinePaymentId = response.responseText;

        									/* var json = {
											 "onlinePaymentId" : onlinePaymentId,
											 "studentName" : records[0].data.printName,
											 "batchName" : records[0].data.batchName,
											 "programName": records[0].data.programName,
											 "feeHeadName": records[0].data.feeHeadName
									 }*/
        									var json=null;
        									if(flagForHostelJSON && flagPaymentGatewayMasterIsHostelFee==1){
        										json={
        											"onlinePaymentId" : onlinePaymentId,
        											"studentName" : records[0].data.printName,
        											"batchName" : records[0].data.batchName,
        											"programName": records[0].data.programName,
        											"feeHeadName": records[0].data.feeHeadName,
        											"isHostelFee":1
        										};
        									}else if(!flagForHostelJSON){
        										json={
        											"onlinePaymentId" : onlinePaymentId,
        											"studentName" : records[0].data.printName,
        											"batchName" : records[0].data.batchName,
        											"programName": records[0].data.programName,
        											"feeHeadName": records[0].data.feeHeadName,
        											"isHostelFee":0
        										};
        									}
        									XMLHttpRequestObject.open("POST", grid.getPaymentPostUrl(), true);
        									XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
        									XMLHttpRequestObject.send(JSON.stringify(json));
        								}
        							});
        						}
        					})
        				}else{
        					showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
        				}
        			}
        		}else{
        			showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),
        					getPersonModuleTranslation('PLEASE_PAY_FOR_HOSTEL_FEE_SEPARATELY_IT_SHOULD_NOT_BE_COMBINED_WITH_OTHER_FEES'));
        		}
        	}
        },
        redirectOnlinePaymentProcess: function(flagIsHostelFee,flagForHostelJSON,records) {
        	var $this = this;
			var grid = this.getOnlinepaymentbilllevelgridforportal();
			var personProfile = $this.getContentPanelActiveTab();
			var bankField = grid.down('#bankItemId');
			var userId = personProfile.getUserId();
			var thresholdValue;
			var bankChareApplicable;
			
			var flagPaymentGatewayMasterIsHostelFee=0;
			 var flagPaymentGatewayMasterIsNotHostelFee=0;
			 Ext.Ajax.request({
				 type : 'rest',
				 url : SERVERURL.PATH_FIND_ALL_PAYMENT_GATEWAY_MASTER,
				 method : 'GET',
				 success : function(response, action) {
					 var res= Ext.decode(response.responseText);
					 if(res.length>0){
						 for(var i=0;i<res.length;i++){
							 if(res[i].thirdPartyMerchantId){
								 flagPaymentGatewayMasterIsHostelFee++;
							 }else if(!res[i].thirdPartyMerchantId){
								 flagPaymentGatewayMasterIsNotHostelFee++;
							 }
						 }

						 $this.getBillDetailsPaymentBankStudentPortal($this,flagIsHostelFee,flagPaymentGatewayMasterIsHostelFee,flagPaymentGatewayMasterIsNotHostelFee,
								 flagForHostelJSON,records,grid,bankField);
					 }else{
						 if(bankField.isVisible() == true) {
							 if(!isNullOrEmpty(bankField.getValue())){
								 var records = grid.selModel.getSelection();
								 var totalAmount=0;
								 var totalBalanceAmount=0;
								 for(var i in records){
									 var balanceAmounts = records[i].get('tempRemainingAmount');
									 var amounts = records[i].get('balanceAmount');
									 if(isNullOrEmpty(amounts)){
										 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
										 return false;
									 }
									 totalBalanceAmount = totalBalanceAmount + balanceAmounts;
									 totalAmount = totalAmount + amounts;
								 }
								 if(totalBalanceAmount >=0 && totalAmount>0){
									 var onlineAmount=[];
									 for(var i in records){
										 onlineAmount.push({
											 "billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
											 "billId":records[i].data.billId,
											 "adjustedAmount":records[i].data.balanceAmount,
											 "balanceAmount": records[i].get('tempRemainingAmount')
										 });
									 }

									 var amount=totalAmount;
									 var orgModel = Academia.model.common.OrgSettingDateTimeModel;

									 var amountWithCharge = totalAmount * (grid.config.bankChargeApplicable==undefined?1:grid.config.bankChargeApplicable/100);
									 var transactionalFee;
									 if(amountWithCharge < grid.config.thresholdLimit ) {
										 var totalAmountToPay =  amountWithCharge + totalAmount;
										 transactionalFee = amountWithCharge
									 }
									 else {
										 var totalAmountToPay = (grid.config.thresholdLimit==undefined?0.0:grid.config.thresholdLimit) + totalAmount
										 transactionalFee = grid.config.thresholdLimit==undefined?null:grid.config.thresholdLimit
									 }
									 var submitData = {
											 "receiptAmount" : totalAmount,
											 "onlinePayments" : onlineAmount,
											 "transactionFees": transactionalFee
									 };
									 //var message = 'Are you sure, you want to make payment of ' + orgModel.get('currencyFormat') + ' ' +totalAmount+' ?';
									 var currency = records[0].data.currencyId;
									 var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);
									 var message = 'Are you sure, you want to make payment of ' + billCurrency + ' ' +totalAmountToPay+' ?';

									 var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL
									 showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
										 if (btn == 'yes') {
											 var XMLHttpRequestObject = false;  
											 if (window.XMLHttpRequest) {  
												 XMLHttpRequestObject = new XMLHttpRequest();  
												 XMLHttpRequestObject.overrideMimeType("text/xml");  
											 }  
											 else if (window.ActiveXObject) {  
												 XMLHttpRequestObject = new  
												 ActiveXObject("Microsoft.XMLHTTP");  
											 }
											 XMLHttpRequestObject.withCredentials = false;
											 XMLHttpRequestObject.onreadystatechange = function() {
												 if (this.readyState == 4 && this.status == 200) {
													 var id = parseInt(XMLHttpRequestObject.responseText);
													 if(!isNaN(id)) {
														 var formWindow = Ext.widget('paymentsummarywin',{
															 itemId:'student'
														 });
														 var emailID = null;
														 var mobileNo = null;
														 var printName = null;
														 if(portalId == 1){
															 emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
															 mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
															 printName = $this.getStudentDetailForErpPortal().student.person.printName
														 }else{
															 emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
															 mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber;
															 printName = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.printName
														 }
														 formWindow.down('#name').setValue(printName);
														 formWindow.down('#email').setValue(emailID);
														 formWindow.down('#mobileNo').setValue(mobileNo);
														 //formWindow.down('#amount').setValue(currencyRenderer(totalAmount,records.currencyId));
														 formWindow.down('#amount').setValue(billCurrency+' '+totalAmountToPay);
														 formWindow.show();
														 Ext.apply(formWindow,{
															 data:null,
															 setData : function(data){
																 formWindow.data = data;
															 },
															 getData:function(){
																 return formWindow.data;
															 }
														 });
														 formWindow.setData(id);
														 if(records[0].data.isonlinePaymentDocAvailable == false ) {
															 formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
															 formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
															 formWindow.down('#payNow').enable();
														 }else{
															 formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
															 formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
															 formWindow.down('#payNow').disable();
														 }
													 } else {
														 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
													 }
												 }
											 };
											 var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL;
											 Ext.Ajax.request({
												 type : 'rest',
												 url : submitUrl,
												 jsonData : submitData,
												 method : 'POST',
												 success : function(response, action) {
													 //onlinePaymentId
													 var onlinePaymentId = response.responseText;
													 XMLHttpRequestObject.open("POST",  grid.getPaymentPostUrl(), true);
													 XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
													 XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId);
												 }
											 });
										 }

									 })
								 }else{
									 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
								 }
							 }else{
								 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), getCommonTranslation('PLEASE_SELECT_BANK')); //Please select a record  
							 }
						 }else{
							 var records = grid.selModel.getSelection();
							 var totalAmount=0;
							 var totalBalanceAmount=0;
							 for(var i in records){
								 var balanceAmounts = records[i].get('tempRemainingAmount');
								 var amounts = records[i].get('balanceAmount');
								 if(isNullOrEmpty(amounts)){
									 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
									 return false;
								 }
								 totalBalanceAmount = totalBalanceAmount + balanceAmounts;
								 totalAmount = totalAmount + amounts;
							 }
							 if(totalBalanceAmount >=0 && totalAmount>0){
								 var onlineAmount=[];
								 for(var i in records){
									 onlineAmount.push({
										 "billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
										 "billId":records[i].data.billId,
										 "adjustedAmount":records[i].data.balanceAmount,
										 "balanceAmount": records[i].get('tempRemainingAmount')
									 });
								 }

								 var amount=totalAmount;
								 var orgModel = Academia.model.common.OrgSettingDateTimeModel;

								 var submitData = {
										 "receiptAmount" : totalAmount,
										 "onlinePayments" : onlineAmount,

								 };
								 //var message = 'Are you sure, you want to make payment of ' + orgModel.get('currencyFormat') + ' ' +totalAmount+' ?';
								 var currency = records[0].data.currencyId;
								 var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);
								 var message = 'Are you sure, you want to make payment of ' + billCurrency + ' ' +totalAmount+' ?';

								 var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL
								 showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
									 if (btn == 'yes') {
										 var XMLHttpRequestObject = false;  
										 if (window.XMLHttpRequest) {  
											 XMLHttpRequestObject = new XMLHttpRequest();  
											 XMLHttpRequestObject.overrideMimeType("text/xml");  
										 }  
										 else if (window.ActiveXObject) {  
											 XMLHttpRequestObject = new  
											 ActiveXObject("Microsoft.XMLHTTP");  
										 }
										 XMLHttpRequestObject.withCredentials = false;
										 XMLHttpRequestObject.onreadystatechange = function() {
											 if (this.readyState == 4 && this.status == 200) {
												 var id = parseInt(XMLHttpRequestObject.responseText);
												 if(!isNaN(id)) {
													 var formWindow = Ext.widget('paymentsummarywin',{
														 itemId:'student'
													 });
													 var emailID = null;
													 var mobileNo = null;
													 var printName = null;
													 if(portalId == 1){
														 emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
														 mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
														 printName = $this.getStudentDetailForErpPortal().student.person.printName
													 }else{
														 emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
														 mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber;
														 printName = $this.getCurrentlyLoggedInUserInfoForPortal().student.printName;
													 }
													 formWindow.down('#name').setValue(printName);
													 formWindow.down('#email').setValue(emailID);
													 formWindow.down('#mobileNo').setValue(mobileNo);
													 //formWindow.down('#amount').setValue(currencyRenderer(totalAmount,records.currencyId));
													 formWindow.down('#amount').setValue(billCurrency+' '+totalAmount);
													 formWindow.show();
													 Ext.apply(formWindow,{
														 data:null,
														 setData : function(data){
															 formWindow.data = data;
														 },
														 getData:function(){
															 return formWindow.data;
														 }
													 });
													 formWindow.setData(id);
													 if(records[0].data.isonlinePaymentDocAvailable == false ) {
														 formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
														 formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
														 formWindow.down('#payNow').enable();
													 }else{
														 formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
														 formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
														 formWindow.down('#payNow').disable();
													 }
												 } else {
													 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
												 }
											 }
										 };
										 var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE_AT_BILL_LEVEL;
										 Ext.Ajax.request({
											 type : 'rest',
											 url : submitUrl,
											 jsonData : submitData,
											 method : 'POST',
											 success : function(response, action) {
												 //onlinePaymentId
												 var onlinePaymentId = response.responseText;
												 XMLHttpRequestObject.open("POST",  grid.getPaymentPostUrl(), true);
												 XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
												 XMLHttpRequestObject.send("onlinePaymentId="+onlinePaymentId);
											 }
										 });
									 }

								 })
							 }else{
								 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
							 }
						 }
					 }
				 }
			 });
		
        },
        getFinancialSupportPopUp:function(){
        	var financialSupportWin = this.getFinancialsupportdetailswin();
        	if (!financialSupportWin) {
        		Ext.widget('financialsupportdetailswin');
        		financialSupportWin = this.getFinancialsupportdetailswin();
        	}
        	financialSupportWin.show();
        },
        getFundingAndMonitoringPopUp:function(){
        	var fundingandmonitoringdetailswin = this.getFundingandmonitoringdetailswin();
        	if (!fundingandmonitoringdetailswin) {
        		Ext.widget('fundingandmonitoringdetailswin');
        		fundingandmonitoringdetailswin = this.getFundingandmonitoringdetailswin();
        	}
        	fundingandmonitoringdetailswin.show();
        },
        saveFinancialSupportDetails:function(btn){
        	if (typeof btn.lastExecutionTime === 'undefined') {
        		btn.lastExecutionTime = 0;
        	}
        	var currentTime = new Date().getTime();
        	// Prevent function execution if called within the last 5+ seconds
        	if (currentTime - btn.lastExecutionTime < 5000) {
        		return false;
        	}
        	// Update last execution time
        	btn.lastExecutionTime = currentTime;
        	var json,submitUrl,$this = this,
        	stdProfile = this.getContentPanelActiveTab(),
        	form = this.getFinancialsupportdetailswin(),
        	grid = stdProfile.down('financialsupportgrid'),
        	formValues = form.down('form').getValues();
        	if(formValues.recordId){
        		submitUrl=SERVERURL.PATH_UPDATE_FINANCIAL_SUPPORT_DETAILS;
        		json= {
        				id:formValues.recordId,
        				student:$this.getIdValueJson(stdProfile.getUserId()),
        				program:$this.getIdValueJson(formValues.financialSupportProgram),
        				batch:$this.getIdValueJson(formValues.financialSupportBatch),
        				period:$this.getIdValueJson(formValues.financialSupportPeriod),
        				accessAndParticipationFlag:$this.getIdValueJson(formValues.accessAndParticipationFlag),
        				financialSupportAmount:formValues.financialSupportAmount,
        				financialSupportType:$this.getIdValueJson(formValues.financialSupportType)
        		};
        	}else{
        		submitUrl=SERVERURL.PATH_SAVE_FINANCIAL_SUPPORT_DETAILS;
        		json= {
        				program:$this.getIdValueJson(formValues.financialSupportProgram),
        				student:$this.getIdValueJson(stdProfile.getUserId()),
        				batch:$this.getIdValueJson(formValues.financialSupportBatch),
        				period:$this.getIdValueJson(formValues.financialSupportPeriod),
        				accessAndParticipationFlag:$this.getIdValueJson(formValues.accessAndParticipationFlag),
        				financialSupportAmount:formValues.financialSupportAmount,
        				financialSupportType:$this.getIdValueJson(formValues.financialSupportType)
        		};
        	}
        	var formData = Ext.encode(json);
        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');   	
        	Ext.Ajax.request({
        		type: 'rest',
        		url:submitUrl,
        		jsonData: formData,
        		method: 'POST',
        		success: function(response) {
        			if(response.responseText=="Already Exist"){
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('RECORD_WITH_MATCHING_DATA_ALREADY_EXISTS'));
        			}else if(response.responseText=="Success"){
        				if(formValues.recordId){
        					showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
        				}else{
        					showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_ADD_SUCCESS'));
        				}
        				grid.getStore().reload();
        				grid.getSelectionModel().deselectAll();
        				$this.getFinancialsupportdetailswin().close();	 
        			}
        			Ext.getBody().unmask();
        		},
        		failure:function(){
        			Ext.getBody().unmask();
        		}
        	});
        },
        saveFundingandMonitoringDetails:function(btn){
        	if (typeof btn.lastExecutionTime === 'undefined') {
        		btn.lastExecutionTime = 0;
        	}
        	var currentTime = new Date().getTime();
        	// Prevent function execution if called within the last 5+ seconds
        	if (currentTime - btn.lastExecutionTime < 5000) {
        		return false;
        	}
        	// Update last execution time
        	btn.lastExecutionTime = currentTime;
        	var json,submitUrl,$this = this,
        	stdProfile = this.getContentPanelActiveTab(),
        	form = this.getFundingandmonitoringdetailswin(),
        	grid = stdProfile.down('fundingandmonitoringgrid'),
        	formValues = form.down('form').getValues();
        	if(formValues.recordId){
        		submitUrl=SERVERURL.PATH_UPDATE_FUNDING_AND_MONITORING_DETAILS;
        		json= {
        				id:formValues.recordId,
        				student:$this.getIdValueJson(stdProfile.getUserId()),
        				program:$this.getIdValueJson(formValues.program),
        				fundingBody:$this.getIdValueJson(formValues.fundingBody),
        				nonRegulatedFeeFlag:$this.getIdValueJson(formValues.nonRegulatedFeeFlag),
        				fundingLength:$this.getIdValueJson(formValues.fundingLength),
        				fundingCompletion:$this.getIdValueJson(formValues.fundingCompletion),
        				equivalentOrLowerQualification:$this.getIdValueJson(formValues.equivalentOrLowerQualification)
        		};
        	}else{
        		submitUrl=SERVERURL.PATH_SAVE_FUNDING_AND_MONITORING_DETAILS;
        		json= {
        				student:$this.getIdValueJson(stdProfile.getUserId()),
        				program:$this.getIdValueJson(formValues.program),
        				fundingBody:$this.getIdValueJson(formValues.fundingBody),
        				nonRegulatedFeeFlag:$this.getIdValueJson(formValues.nonRegulatedFeeFlag),
        				fundingLength:$this.getIdValueJson(formValues.fundingLength),
        				fundingCompletion:$this.getIdValueJson(formValues.fundingCompletion),
        				equivalentOrLowerQualification:$this.getIdValueJson(formValues.equivalentOrLowerQualification)
        		};
        	}
        	var formData = Ext.encode(json);
        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');   	
        	Ext.Ajax.request({
        		type: 'rest',
        		url:submitUrl,
        		jsonData: formData,
        		method: 'POST',
        		success: function(response) {
        			if(response.responseText=="Already Exist"){
        				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('RECORD_WITH_MATCHING_DATA_ALREADY_EXISTS'));
        			}else if(response.responseText=="Success"){
        				if(formValues.recordId){
            				showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_UPDATE_SUCCESS'));
            			}else{
            				showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_ADD_SUCCESS'));
            			}
        				grid.getStore().reload();
            			grid.getSelectionModel().deselectAll();
            			$this.getFundingandmonitoringdetailswin().close();	 
        			}
        			Ext.getBody().unmask();
        		},
        		failure:function(){
        			Ext.getBody().unmask();
        		}
        	});
        },
        setDataOnFinancialSupportForm:function(mode){
        	var data,stdProfile = this.getContentPanelActiveTab(),
        	$this=this,
        	grid = stdProfile.down('financialsupportgrid');
        	if (grid.getSelectionModel().getCount() > 0) {
        		this.getFinancialSupportPopUp();
        		var form = this.getFinancialsupportdetailswin(),
        		recordId = form.down('#recordId'),
        		program=form.down('#financialSupportProgramId'),
        		financialSupportBatchId=form.down('#financialSupportBatchId'),
        		financialSupportPeriodId=form.down('#financialSupportPeriodId'),
        		accessAndParticipationFlagId=form.down('#accessAndParticipationFlagId'),
        		financialSupportAmountId=form.down('#financialSupportAmountId'),
        		financialSupportTypeId=form.down('#financialSupportTypeId'),
        		selectedRecord = grid.getSelectionModel().getSelection()[0];

        		if(selectedRecord){
        			var data = selectedRecord.data;
        			recordId.setValue(data.id);
        			financialSupportAmountId.setValue(data.financialSupportAmount);
        			program.getStore().getProxy().extraParams={
        				alId :$this.getCurrentAcademyLocation(),
        				studentId:stdProfile.getUserId(),
        			};
        			program.getStore().load({
        				callback: function(records, operation, success) {
        					program.setValue(data.programId);
        				}
        			});
        			financialSupportBatchId.getStore().getProxy().extraParams={
        				alId :$this.getCurrentAcademyLocation(),
        				studentId:stdProfile.getUserId(),
        				programId:data.programId
        			};
        			financialSupportBatchId.getStore().load({
        				callback: function(records, operation, success) {
        					financialSupportBatchId.setValue(data.batchId);
        					financialSupportBatchId.setDisabled(false);
        				}
        			});
        			financialSupportPeriodId.getStore().getProxy().extraParams={
        				alId :$this.getCurrentAcademyLocation(),
        				studentId:stdProfile.getUserId(),
        				programId:data.programId,
        				batchId:data.batchId
        			};
        			financialSupportPeriodId.getStore().load({
        				callback: function(records, operation, success) {
        					financialSupportPeriodId.setValue(data.periodId);
        					financialSupportPeriodId.setDisabled(false);
        				}
        			});
        			accessAndParticipationFlagId.getStore().load({
        				callback: function(records, operation, success) {
        					accessAndParticipationFlagId.setValue(data.accessAndParticipationFlagId);
        				}
        			});
        			financialSupportTypeId.getStore().load({
        				callback: function(records, operation, success) {
        					financialSupportTypeId.setValue(data.financialSupportTypeId);
        				}
        			});
        		}
        		if(mode=='view'){
        			form.down('#financialSupportSave').setVisible(false);
        			toggleReadOnlyFormItems(form.down('form').getForm(),true);
        		}
        	}else{
        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	}
        },
        setDataOnFundingandMonitoringForm:function(mode){
        	var data,stdProfile = this.getContentPanelActiveTab(),
        	grid = stdProfile.down('fundingandmonitoringgrid');
        	if (grid.getSelectionModel().getCount() > 0) {
        		this.getFundingAndMonitoringPopUp();
        		var form = this.getFundingandmonitoringdetailswin(),
        		recordId = form.down('#recordId'),
        		program=form.down('#programItemId'),
        		fundingBody=form.down('#fundingBodyItemId'),
        		nonRegulatedFeeFlag=form.down('#nonRegulatedFeeFlagItemId'),
        		fundingLength=form.down('#fundingLengthItemId'),
        		fundingCompletion=form.down('#fundingCompletionItemId'),
        		equivalentOrLowerQualification=form.down('#equivalentOrLowerQualificationItemId'),
        		selectedRecord = grid.getSelectionModel().getSelection()[0];

        		if(selectedRecord){
        			var data = selectedRecord.data;
        			recordId.setValue(data.id);
        			program.getStore().load({
        				callback: function(records, operation, success) {
        					program.setValue(data.programId);
        				}
        			});
        			fundingBody.getStore().load({
        				callback: function(records, operation, success) {
        					fundingBody.setValue(data.fundingBodyId);
        				}
        			});
        			nonRegulatedFeeFlag.getStore().load({
        				callback: function(records, operation, success) {
        					nonRegulatedFeeFlag.setValue(data.nonRegulatedFeeFlagId);
        				}
        			});
        			fundingLength.getStore().load({
        				callback: function(records, operation, success) {
        					fundingLength.setValue(data.fundingLengthId);
        				}
        			});
        			fundingCompletion.getStore().load({
        				callback: function(records, operation, success) {
        					fundingCompletion.setValue(data.fundingCompletionId);
        				}
        			});
        			equivalentOrLowerQualification.getStore().load({
        				callback: function(records, operation, success) {
        					equivalentOrLowerQualification.setValue(data.equivalentOrLowerQualificationId);
        				}
        			});
        		}
        		if(mode=='view'){
        			form.down('#fundMonitoringDetailSave').setVisible(false);
        			toggleReadOnlyFormItems(form.down('form').getForm(),true);
        		}
        	}else{
        		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
        	}
        },
        getIdValueJson: function(id, value,code) {
        	if (id) return {
        		id: id,
        		value: value,
        		code: code
        	};
        },
        redirectOnlinePaymentProcessFromHeadLevelGrid: function(flagIsHostelFee,flagForHostelJSON,gridRecords){
        	var $this = this;
			var grid = this.getOnlinePaymentGridForPortal();
			   var bankField = grid.down('#bankItemId');
			   var thresholdValue;
			   var bankChargeApplicable;
			 var personProfile = $this.getContentPanelActiveTab();
			 var userId = personProfile.getUserId();
			 
			 var flagPaymentGatewayMasterIsHostelFee=0;
			 var flagPaymentGatewayMasterIsNotHostelFee=0;
			 Ext.Ajax.request({
				 type : 'rest',
				 url : SERVERURL.PATH_FIND_ALL_PAYMENT_GATEWAY_MASTER,
				 method : 'GET',
				 success : function(response, action) {
					 var res= Ext.decode(response.responseText);
					 if(res.length>0){
						 for(var i=0;i<res.length;i++){
							 if(res[i].thirdPartyMerchantId){
								 flagPaymentGatewayMasterIsHostelFee++;
							 }else if(!res[i].thirdPartyMerchantId){
								 flagPaymentGatewayMasterIsNotHostelFee++;
							 }
						 }

						 $this.getFeeHeadDetailsPaymentBankStudentPortal($this,flagIsHostelFee,flagPaymentGatewayMasterIsHostelFee,flagPaymentGatewayMasterIsNotHostelFee,
								 flagForHostelJSON,gridRecords,grid,bankField);
					 }else{

						 if(bankField.isVisible() == true)
						 {
							 if(!isNullOrEmpty(bankField.getValue())) {
								 grid.config.thresholdLimit
								 grid.config.bankChargesApplicable
								 var records = grid.selModel.getSelection();
								 var totalAmount=0;
								 var totalBalanceAmount=0;
								 for(var i in records){
									 var balanceAmounts = records[i].get('tempRemainingAmount');
									 var amounts = records[i].get('totalBalanceAmount');
									 if(isNullOrEmpty(amounts)){
										 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
										 return false;
									 }
									 totalBalanceAmount = totalBalanceAmount + balanceAmounts;
									 totalAmount = totalAmount + amounts;
									 //transactionFees =
								 }
								 if(totalBalanceAmount >=0 && totalAmount>0){
									 var onlineAmount=[];
									 for(var i in records){
										 onlineAmount.push({
											 "billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
											 "billId":records[i].get('billHeaderId'),
											 "adjustedAmount":records[i].get('totalBalanceAmount'),
											 "balanceAmount": records[i].get('tempRemainingAmount')  
										 });
									 }

									 var amount=totalAmount;
									 var orgModel = Academia.model.common.OrgSettingDateTimeModel;
									 //var message = 'Are you sure, you want to make payment of ' + orgModel.get('currencyFormat') + ' ' +totalAmount+' ?';
									 var currency = records[0].data.currencyId;
									 var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);


									 //grid.config.bankChargesApplicable
									 var amountWithCharge = totalAmount * (grid.config.bankChargeApplicable==undefined?1:grid.config.bankChargeApplicable/100);
									 var transactionalFee;
									 if(amountWithCharge < grid.config.thresholdLimit ) {
										 var totalAmountToPay =  amountWithCharge + totalAmount;
										 transactionalFee = amountWithCharge
									 }
									 else {
										 var totalAmountToPay = (grid.config.thresholdLimit==undefined?0.0:grid.config.thresholdLimit) + totalAmount
										 transactionalFee = grid.config.thresholdLimit==undefined?null:grid.config.thresholdLimit
									 }
									 var submitData = {
											 "receiptAmount" : totalAmount,
											 "onlinePayments" : onlineAmount,
											 "transactionFees": transactionalFee
									 };
									 var message = 'Are you sure, you want to make payment of ' + billCurrency + ' ' +totalAmountToPay+' ?';
									 var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE
									 showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
										 if (btn == 'yes') {
											 var XMLHttpRequestObject = false;  
											 if (window.XMLHttpRequest) {  
												 XMLHttpRequestObject = new XMLHttpRequest();  
												 XMLHttpRequestObject.overrideMimeType("text/xml");  
											 }  
											 else if (window.ActiveXObject) {  
												 XMLHttpRequestObject = new  
												 ActiveXObject("Microsoft.XMLHTTP");  
											 }
											 XMLHttpRequestObject.withCredentials = false;
											 XMLHttpRequestObject.onreadystatechange = function() {
												 if (this.readyState == 4 && this.status == 200) {
													 var id = parseInt(XMLHttpRequestObject.responseText);
													 if(!isNaN(id)) {
														 var formWindow = Ext.widget('paymentsummarywin',{
															 itemId:'student'
														 });
														 var emailID = null;
														 var mobileNo = null;
														 if(portalId == 1){
															 emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
															 mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
														 }else{
															 emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
															 mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber
														 }

														 formWindow.down('#name').setValue(records[0].data.printName);
														 formWindow.down('#email').setValue(emailID);
														 formWindow.down('#mobileNo').setValue(mobileNo);
														 //formWindow.down('#amount').setValue(currencyRenderer(totalAmount,records.currencyId));
														 formWindow.down('#amount').setValue(billCurrency+' '+totalAmountToPay);

														 formWindow.show();
														 /*var summaryGrid = formWindow.down('grid');
					               summaryGrid.getStore().loadRawData([]);
					               summaryGrid.getStore().loadRawData(innerJsonArr);
					               var summaryWindMsg = formWindow.down('#summaryWindMsg');
					               summaryWindMsg.setVisible(true);
					               summaryWindMsg.setValue('&nbsp;<b>Total Amount To Be Paid : '+totalAmmount+" /-</b>");*/
														 Ext.apply(formWindow,{
															 data:null,
															 setData : function(data){
																 formWindow.data = data;
															 },
															 getData:function(){
																 return formWindow.data;
															 }
														 });
														 formWindow.setData(id);
														 if(records[0].data.isonlinePaymentDocAvailable == false ) {
															 formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
															 formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
															 formWindow.down('#payNow').enable();
														 }else{
															 formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
															 formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
															 formWindow.down('#payNow').disable();
														 }
													 } else {
														 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
													 }
												 }
											 };
											 var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE;
											 Ext.Ajax.request({
												 type : 'rest',
												 url : submitUrl,
												 jsonData : submitData,
												 method : 'POST',
												 success : function(response, action) {
													 //onlinePaymentId
													 var onlinePaymentId = response.responseText;
													 var json = {
															 "onlinePaymentId" : onlinePaymentId,
															 "studentName" : records[0].data.printName,
															 "batchName" : records[0].data.batchName,
															 "programName": records[0].data.programName,
															 "feeHeadName": records[0].data.feeHeadName
													 }
													 XMLHttpRequestObject.open("POST",grid.getPaymentPostUrl(), true);
													 XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
													 XMLHttpRequestObject.send(JSON.stringify(json));
												 }
											 });
											 /*
					 var buildInfo="";
					 var paymentUrl="";  
					 var XMLHttpRequestObject = false;  
					 if (window.XMLHttpRequest) {  
					 XMLHttpRequestObject = new XMLHttpRequest();  
					 XMLHttpRequestObject.overrideMimeType("text/xml");  
					 }  
					 else if (window.ActiveXObject) {  
					 XMLHttpRequestObject = new  
					 ActiveXObject("Microsoft.XMLHTTP");  
					 }  
					 if(XMLHttpRequestObject) {  
					 XMLHttpRequestObject.open("GET", "buildInfo.xml", true);  
					 XMLHttpRequestObject.onreadystatechange = function(){      
					 if (XMLHttpRequestObject.readyState == 4 && XMLHttpRequestObject.status == 200){  
					 var xmlDocument = XMLHttpRequestObject.responseXML;  
					 buildInfo =xmlDocument.getElementsByTagName("buildInfo") [0];  
					 paymentUrl = buildInfo.getElementsByTagName("paymentUrl") [0].childNodes[0].nodeValue;
					 Ext.getBody().mask('wait..', 'x-mask-loading');
					 Ext.Ajax.request({
					 type : 'rest',
					 url : submitUrl,
					 jsonData : submitData,
					 method : 'POST',
					 success : function(response, action) {
					 //onlinePaymentId
					 var onlinePaymentId = response.responseText;
					 window.open(paymentUrl+"?onlinePaymentId="+onlinePaymentId,"Online_Payment","width=1000,height=600");
					 Ext.getBody().unmask();
					 var contentpanel = $this.getContentPanel();
					 var tabName = getPersonModuleTranslation('ONLINE_PAYMENT');
					 var getcontroller=$this.getController('menu.CoreERPNavigationController');
					       var getTab=getcontroller.getTab(tabName);
					       if(getTab!=null){
					       contentpanel.remove(getTab, true);
					       }
					 }
					 });
					 }  
					 }
					 XMLHttpRequestObject.send(null);  
					 }
											  */}
									 })
								 }else{
									 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
								 }
							 }else{
								 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), getCommonTranslation('PLEASE_SELECT_BANK'));
							 }
						 }else
						 {
							 var records = grid.selModel.getSelection();
							 var totalAmount=0;
							 var totalBalanceAmount=0;
							 for(var i in records){
								 var balanceAmounts = records[i].get('tempRemainingAmount');
								 var amounts = records[i].get('totalBalanceAmount');
								 if(isNullOrEmpty(amounts)){
									 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
									 return false;
								 }
								 totalBalanceAmount = totalBalanceAmount + balanceAmounts;
								 totalAmount = totalAmount + amounts;
								 //transactionFees =
							 }
							 if(totalBalanceAmount >=0 && totalAmount>0){
								 var onlineAmount=[];
								 for(var i in records){
									 onlineAmount.push({
										 "billFeePlanRuleStageId":records[i].get('billFeePlanRuleStageId'),
										 "billId":records[i].get('billHeaderId'),
										 "adjustedAmount":records[i].get('totalBalanceAmount'),
										 "balanceAmount": records[i].get('tempRemainingAmount')  
									 });
								 }

								 var amount=totalAmount;
								 var orgModel = Academia.model.common.OrgSettingDateTimeModel;
								 //var message = 'Are you sure, you want to make payment of ' + orgModel.get('currencyFormat') + ' ' +totalAmount+' ?';
								 var currency = records[0].data.currencyId;
								 var billCurrency = Academia.utilities.currency.CurrencyManager.getCurrencyCodeByCurrencyId(currency);
								 var submitData = {
										 "receiptAmount" : totalAmount,
										 "onlinePayments" : onlineAmount,
								 };
								 var message = 'Are you sure, you want to make payment of ' + billCurrency + ' ' +totalAmount+' ?';
								 var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE
								 showConfirmMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'), message, function(btn, text) {
									 if (btn == 'yes') {
										 var XMLHttpRequestObject = false;  
										 if (window.XMLHttpRequest) {  
											 XMLHttpRequestObject = new XMLHttpRequest();  
											 XMLHttpRequestObject.overrideMimeType("text/xml");  
										 }  
										 else if (window.ActiveXObject) {  
											 XMLHttpRequestObject = new  
											 ActiveXObject("Microsoft.XMLHTTP");  
										 }
										 XMLHttpRequestObject.withCredentials = false;
										 XMLHttpRequestObject.onreadystatechange = function() {
											 if (this.readyState == 4 && this.status == 200) {
												 var id = parseInt(XMLHttpRequestObject.responseText);
												 if(!isNaN(id)) {
													 var formWindow = Ext.widget('paymentsummarywin',{
														 itemId:'student'
													 });
													 var emailID = null;
													 var mobileNo = null;
													 if(portalId == 1){
														 emailID = $this.getStudentDetailForErpPortal().student.person.emailId;
														 mobileNo = $this.getStudentDetailForErpPortal().student.person.mobileNumber;
													 }else{
														 emailID = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.emailId;
														 mobileNo = $this.getCurrentlyLoggedInUserInfoForPortal().student.person.mobileNumber
													 }

													 formWindow.down('#name').setValue(records[0].data.printName);
													 formWindow.down('#email').setValue(emailID);
													 formWindow.down('#mobileNo').setValue(mobileNo);
													 //formWindow.down('#amount').setValue(currencyRenderer(totalAmount,records.currencyId));
													 formWindow.down('#amount').setValue(billCurrency+' '+totalAmount);

													 formWindow.show();
													 Ext.apply(formWindow,{
														 data:null,
														 setData : function(data){
															 formWindow.data = data;
														 },
														 getData:function(){
															 return formWindow.data;
														 }
													 });
													 formWindow.setData(id);
													 if(records[0].data.isonlinePaymentDocAvailable == false ) {
														 formWindow.down('#onlinePaymentTermCondCheck').setVisible(false);
														 formWindow.down('#onlinePaymentConditionMsg').setVisible(false);
														 formWindow.down('#payNow').enable();
													 }else{
														 formWindow.down('#onlinePaymentTermCondCheck').setVisible(true);
														 formWindow.down('#onlinePaymentConditionMsg').setVisible(true);
														 formWindow.down('#payNow').disable();
													 }
												 } else {
													 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('Payment_PayU_Confirmation'));
												 }
											 }
										 };
										 var submitUrl = SERVERURL.ONLINE_PAYMENT_MASTER_CREATE;
										 Ext.Ajax.request({
											 type : 'rest',
											 url : submitUrl,
											 jsonData : submitData,
											 method : 'POST',
											 success : function(response, action) {
												 //onlinePaymentId
												 var onlinePaymentId = response.responseText;

												 var json = {
														 "onlinePaymentId" : onlinePaymentId,
														 "studentName" : records[0].data.printName,
														 "batchName" : records[0].data.batchName,
														 "programName": records[0].data.programName,
														 "feeHeadName": records[0].data.feeHeadName
												 }

												 XMLHttpRequestObject.open("POST", grid.getPaymentPostUrl(), true);
												 XMLHttpRequestObject.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
												 XMLHttpRequestObject.send(JSON.stringify(json));
											 }
										 });
									 }
								 })
							 }else{
								 showWarningMessage(getPersonModuleTranslation('PAYMENT_PEOCESS'),getPersonModuleTranslation('AMOUNT_SHOULD_BE_GREATER_THAN_BALANCE_AMOUNT'));
							 }

						 }

					 }
				 }
			 });
			 
        },

/*   // Below Same method was used already in this controller, and this code written in another same menthod,due to same method issue was coming so commentted it

                       disableMoreActionPivileges:function(grid,permissionsMap){
                           var associatedAcadLocationIds = new Array();
                           associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
                           var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
                           var printbtn=grid.down('#btnPrint');
                           if(!isNullOrEmpty(printbtn)){
                               printbtn.setVisible(false);
                           }
                           Ext.each(permissionList, function(privilege) {
                               if (privilege === 'PRINT') {
                                   if(!isNullOrEmpty(printbtn)){
                                       printbtn.setVisible(true);
                                   } 
                               }
                           });
                       },*/
});
