/**
 * This controller is used for student personal information actions.   
 */
Ext.define('Academia.controller.personinfo.student.StudentPersonalController', {
    extend: 'Academia.controller.personinfo.common.PersonInfoController',

    mixins: { 		
    	AddressController:'Academia.controller.organization.AddressController',
    	StudentListController : 'Academia.controller.personinfo.student.StudentListController'
    },
    models:['enquiry.closure.ClosureSubmitModel', 'enquiry.closure.ReopenSubmitModel', 
	         'enquiry.followup.FollowUpDetailModel','admission.applications.applicationFollowUp.ApplicationFollowUpDetailModel'],
    
    stores : [ 'enquiry.studentDetail.BloodGroupStore','coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
    	'student.managehold.StudentFinanceHoldGridStore','feeandpayment.finance.FinanceHoldTypeStore','personinfo.common.personalinfo.LivingArrangementGridStore','student.studentprofile.LivingArrangementAccommodationStore','admission.applications.applicationFollowUp.ApplicationFollowUpDetailStore','enquiry.closure.ClosureStore',
        'enquiry.followup.ClosureReasonStore', 'enquiry.EnqIntermediateType','enquiry.followup.ClosureReason',
	     'common.AcademyLocationNameSeparated', 'facilitiesresources.resourcemaster.ProgramGridStore',
	     'enquiry.AcademicBatchStore','enquiry.Priority','common.UsersWithDepartmentStore','enquiry.ReasonForFollowup','enquiry.FollowupActivityType','enquiry.FollowupActivityStatus',
	     'enquiry.ProgramBatchSeatTypeStore', 'enquiry.FollowUpUserWithDepartment','common.ProgramsByProgramCategoryWithALStore','student.studentprofile.StudentFollowUpAppointmentStore','personinfo.common.personalinfo.BankDetailsGridStore',
	     'student.studentquicksearch.EnrollmentStautsComboStore','personinfo.student.StudentForAcademicToicsStore', 'student.studentprofile.AcademicTopicUrlsStore', 'student.studentprofile.AcademicTopicDocumentsStore',
	     'personinfo.common.personalinfo.StudentMappedFlagDetailsStore','student.studentprofile.StudentMappedFlagListStore','admission.applicationFormSale.StudentProgramWiseContitionDetailStore','student.studentprofile.GraduationCermonyAddressStore',
	     'admission.applicationFormSale.AdmissionConditionByOfferTypeStore','student.studentprofile.GraduationCeremonyNameStore',
	     'student.studentprofile.StudentForExternalTransferCreditGridStore','student.studentprofile.StudentForTransferCreditProgramStore',
	     'student.studentprofile.StudentForTransferCreditBatchStore','student.studentprofile.StudentForInternalTransferCreditGridStore', 'common.AllActiveInactiveUser'],
        
    views:['personinfo.student.StudentProfile', 'personinfo.common.PersonInfoPanel', 'personinfo.common.PersonDetailsLinkPanel',
           'baselayout.header.UserInfo','login.AdminResetPasswordWindow',
           'personinfo.student.StudentConditionsForAdmission',  'personinfo.student.StudentForAcademictoics','personinfo.student.StudentForAcademicToicsStructure','personinfo.student.StudentForAcademicToicsGrid',
           'examinationdegreeremark.DegreeAuditReportProfileView',
           'personinfo.student.StudentConditionsDocumentList',
           'personinfo.common.ParentGuardianCardLayoutView',
           'personinfo.common.ParentGuardianCardTpl','personinfo.common.personalinfo.FeePayerDetailCardLayoutView',
           'personinfo.common.personalinfo.FeePayerDetailCardTpl','personinfo.common.personalinfo.FeePayerDetailAddCardTpl',
           'personinfo.common.personalinfo.CurrentGradePaymentTermsCardTpl','personinfo.common.personalinfo.NextAcademicYearPaymentTermCardTpl',
           'personinfo.common.personalinfo.StudentFeePayerInstallmentScheduleWin','personinfo.common.personalinfo.FeePayerInstallmentSchedulesGrid',
           'personinfo.common.personalinfo.FeePayerNextAcademicPaymentTermForm','personinfo.common.personalinfo.FeePayerPaymentTermSelectionGrid',
           'personinfo.common.personalinfo.FeePayerPaymentTermDocumentsView','personinfo.common.personalinfo.FeePayerCurrentPaymentTermEditForm',
           'personinfo.common.personalinfo.FeePayerCurrentPaymentTermEditGrid','personinfo.common.personalinfo.FeePayerNextInstallmentSchedulesGrid',
           'personinfo.common.personalinfo.StudentFeePayerNextInstallmentScheduleWin','personinfo.common.personalinfo.FeePayerNextPaymentTermViewForm',
           'personinfo.common.personalinfo.FeePayerNextPaymentTermViewGrid','personinfo.common.personalinfo.SSODetailsWin','baselayout.contentarea.ContentPanel',
           'feeandpayment.payment.ManageOfflinePaymentDetailForm','feeandpayment.payment.StudentRegistrationTabStructure','feeandpayment.payment.PaymentTermSectionList',
           'feeandpayment.payment.FeePayerDetailsFormParent','feeandpayment.payment.MedicalDetailsFormParent','feeandpayment.FnpPaymentPlanSettingsDocumentsView',
           'feeandpayment.payment.ManageDoumentsParentPortal','personinfo.common.pasthistory.MedicalDetailsForm','personinfo.common.personalinfo.FeePayerDetailForm',
           'personinfo.student.StudentProgramWiseConditionsForAdmission',
           'personinfo.student.StudentProgramWiseConditionsAdmissionAdmGrid',
           'personinfo.student.StudentPWConditionsAdminAdmDocumentGrid',
           'personinfo.student.StudentListOfApplicableConditionsAdmGrid','personinfo.common.personalinfo.StudentHoldsGrid','personinfo.common.personalinfo.ManageHoldsStructure',
           'personinfo.common.personalinfo.ManageHoldInnerTab','personinfo.common.personalinfo.FinanceHoldInnerTab','personinfo.common.personalinfo.StudentFinanceHoldsGrid',
           'personinfo.common.personalinfo.LivingArrangementGrid','personinfo.common.personalinfo.LivingArrangementDetailsForm','admission.applications.applicationFollowUp.ApplicationFollowUpStructure', 'admission.applications.applicationFollowUp.ApplicationFollowUpDetailGrid',
	        'admission.applications.applicationFollowUp.ApplicationFollowUpDetailForm','personinfo.BankDetails.BankDetailsWindow','document.DocumentFormWindow','document.DocumentFormWindow','personinfo.common.personalinfo.InsuranceForm',
	        'student.studentprofile.AcademicTopicDocumentsPopup', 'student.studentprofile.AcademicTopicUrlPopup',
	        'student.studentprofile.AcademicTopicDocumentsGrid', 'student.studentprofile.AcademicTopicUrlGrid','personinfo.common.personalinfo.FlagDetailsForm', 
	        'student.studentprofile.FlagListstudentGrid','personinfo.student.AdditionalAdmissionApproverForm','personinfo.student.StudentGraduationCeremonyStructure',
	        'personinfo.student.StudentGraduationCeremonyForm','personinfo.student.StudentForTransferCreditStructure','personinfo.student.StudentForTransferCreditFilter',
	        'personinfo.student.StudentForTransferCreditTab','personinfo.student.StudentForExternalTransferCreditGridStructure','personinfo.student.StudentForExternalTransferCreditGrid',
	        'personinfo.student.StudentForInternalTransferCreditGridStructure','personinfo.student.StudentForInternalTransferCreditGrid','personinfo.common.personalinfo.FeePayerGoogleAddressWin'],
    alias: "widget.studentpersonalcontroller",

    refs: [{
	    	ref: 'studentForTransferCreditStructure',
	        selector: 'studentForTransferCreditStructure'
    	},{ 
	    	ref: 'studentForTransferCreditFilter',
	        selector: 'studentForTransferCreditFilter'
        },{ 
	    	ref: 'studentForTransferCreditTab',
	        selector: 'studentForTransferCreditTab'
        },{
	    	ref: 'studentForExternalTransferCreditGridStructure',
	        selector: 'studentForExternalTransferCreditGridStructure'
    	},{ 
	    	ref: 'studentForExternalTransferCreditGrid',
	        selector: 'studentForExternalTransferCreditGrid'
        },{ 
	    	ref: 'studentForInternalTransferCreditGridStructure',
	        selector: 'studentForInternalTransferCreditGridStructure'
        },{ 
	    	ref: 'studentForInternalTransferCreditGrid',
	        selector: 'studentForInternalTransferCreditGrid'
        },{
    ref: 'personDetailsLinkPanel',
    selector: 'persondetailslinkpanel[itemId=studentPersonDetailsLinkPanel]'
    },{    	
    	ref: 'flagliststudentgrid',
        selector: 'flagliststudentgrid'
    }, {
        ref: 'personCommonWindow',
        selector: 'personcommonwindow'
    }, {
        ref: 'personalInformationForm',
        selector: 'personalinformationform[itemId=studentPersonalInformationForm]'
    }, {
        ref: 'personAddressDetails',
        selector: 'addressdetails[itemId=studentAddressDetails]'
    }, {
        ref: 'personAddressFormWindow',
        selector: 'addressformwindow[itemId=studentAddressWindow]'
    }, {
        ref: 'personAddressFieldsForm',
        selector: 'addressfieldsform[itemId=personAddressFieldsForm]'
    }, {
        ref: 'personParentGuardianForm',
        selector: 'parentguardianform[itemId=studentParentGuardianForm]'
    }, {
        ref: 'personSiblingForm',
        selector: 'siblingform[itemId=studentSiblingForm]'
    }, {
    	ref: 'userinfo',
        selector: 'userinfo'
    },{
        ref: 'personIdentityDetailsForm',
        selector: 'identitydetailsform[itemId=studentIdentityDetailsForm]'
    },{
        ref: 'personOtherinformationdetailsform',
        selector: 'otherinformationdetailsform[itemId=studentOtherinformationDetailsForm]'
    },{
    	ref : 'parentGuardianGrid',
    	selector : 'parentguardiangrid[itemId=studentParentGuardianGrid]'
    },{
    	ref : 'adminresetpasswordwindow',
    	selector : 'adminresetpasswordwindow[itemId=parentAdminResetPasswordWindow]'
    }, {
        ref: 'personFeePayerDetailForm',
        selector: 'feepayerdetailform[itemId=studentfeepayerdetailformItemId]'
    }, {
        ref: 'studentFeePayerDetailGrid',
        selector: 'feepayerdetailgrid[itemId=studentFeePayerDetailGridItemId]'
    }, {
        ref: 'studentfeepayerdetaildocumentwin',
        selector: 'studentfeepayerdetaildocumentwin'
    }, {
        ref: 'studentfeepayerdetaildocumentgrid',
        selector: 'studentfeepayerdetaildocumentgrid'
    },{
 	   ref : 'studentIdVerificationDetailWin',
 	   selector : 'idverificationdetailwin [itemId=studentIdVerificationDetailWinItemId]'
    },{
    	ref : 'studentProfileConditionsForAdmission',
    	selector : 'studentconditionsforadmission'
    },{
        ref: 'studentPortalConditionsForAdmission',
        selector: 'studentconditionsforadmission[itemId=studentconditionsforadmissionItemId]'
    },{
    	ref : 'studentProfileConditionsDocumentList',
    	selector : 'studentconditionsdocumentlist'
    },{
        ref: 'studentPortalConditionsDocumentList',
        selector: 'studentconditionsdocumentlist[itemId=studentconditionsdocumentlistItemId]'
    }, /*{
        ref: 'personHostelRequirementForm',
        selector: 'personhostelrequirementform[itemId=studentPersonHostelRequirementForm]'
    },*/ {
    	ref: 'parentguardiancardlayoutview',
    	selector : 'parentguardiancardlayoutview'
    }, {
    	ref: 'parentguardiancardtpl',
    	selector : 'parentguardiancardtpl'
    },{
        ref: 'studentpersonhostelrequirementform',
        selector: 'studentpersonhostelrequirementform[itemId=studentPersonHostelRequirementForm]'
    },{
    	ref: 'feepayerdetailcardlayoutview',
    	selector : 'feepayerdetailcardlayoutview'
    },{
    	ref: 'feepayerdetailcardtpl',
    	selector : 'feepayerdetailcardtpl'
    }, {
        ref: 'parentfeepayerdetailgrid',
        selector: 'feepayerdetailgrid[itemId=parentFeePayerDetailGridItemId]'
    }, {
        ref: 'feepayerdetailaddcardtpl',
        selector: 'feepayerdetailaddcardtpl'
    }, {
        ref: 'currentgradepaymenttermscardtpl',
        selector: 'currentgradepaymenttermscardtpl'
    },{
        ref: 'nextacademicyearpaymenttermcardtpl',
        selector: 'nextacademicyearpaymenttermcardtpl'
    },{
        ref: 'studentfeepayerinstallmentschedulewin',
        selector: 'studentfeepayerinstallmentschedulewin'
    },{
        ref: 'feepayerinstallmentschedulesgrid',
        selector: 'feepayerinstallmentschedulesgrid'
    },{
        ref: 'feepayernextacademicpaymenttermform',
        selector: 'feepayernextacademicpaymenttermform'
    },{
        ref: 'feepayercurrentpaymenttermeditform',
        selector: 'feepayercurrentpaymenttermeditform'
    },{
        ref: 'feepayercurrentpaymenttermeditgrid',
        selector: 'feepayercurrentpaymenttermeditgrid'
    },{
        ref: 'studentfeepayernextinstallmentschedulewin',
        selector: 'studentfeepayernextinstallmentschedulewin'
    },{
        ref: 'feepayernextinstallmentschedulesgrid',
        selector: 'feepayernextinstallmentschedulesgrid'
    },{
        ref: 'feepayernextpaymenttermviewform',
        selector: 'feepayernextpaymenttermviewform'
    },{
        ref: 'feepayerpaymenttermselectiongrid',
        selector: 'feepayerpaymenttermselectiongrid'
    }, {
        ref: 'studentssodetailsgrid',
        selector: 'ssodetailsgrid[itemId=studentssodetailsgridItemId]'
    },{
    	ref: 'ssodetailswin',
        selector: 'ssodetailswin'
    },{
   	 ref : 'contentpanel',
   	 selector : 'contentpanel'
    },{
    	ref : 'studentregistrationtabstructure',
      	selector : 'studentregistrationtabstructure'
    },{
   	 ref : 'paymenttermsectionlist',
   	 selector : 'paymenttermsectionlist'
    },{
    	 ref: 'parentFeePayerDetailForm',
         selector: 'feepayerdetailform[itemId=personfeepayerdetailformItemId]'
    },{
      	 ref : 'feepayerdetailsformparent',
      	 selector : 'feepayerdetailsformparent'
    },{
     	 ref : 'medicaldetailsformparent',
     	 selector : 'medicaldetailsform[itemId=medicaldetailsformparent]'
   },{
   	 ref : 'fnppaymentplansettingsdocumentsview',
   	 selector : 'fnppaymentplansettingsdocumentsview'
   },{
	  ref : 'managedoumentsparentportal',
	  selector : 'managedoumentsparentportal'
   },{
	   ref : 'studentprogramwiseconditionsadmissionadmgrid', 
	   selector : 'studentprogramwiseconditionsadmissionadmgrid'
   },{
	   ref : 'studentprogramwiseconditionsforadmission',
	   selector : 'studentprogramwiseconditionsforadmission'
   },{
	   ref : 'studentpwconditionsadminadmdocumentgrid',
	   selector : 'studentpwconditionsadminadmdocumentgrid'
   },{
	   ref : 'studentlistofapplicableconditionsadmgrid',
	   selector : 'studentlistofapplicableconditionsadmgrid'
   },{ ref : 'studentprofileprogressweightdashlet',
		  selector : 'studentprofileprogressweightdashlet'
   },{
	   ref : 'studentprofileprogressheightdashlet',
		  selector : 'studentprofileprogressheightdashlet'
	},{
        ref: 'studentapplyholdsform',
        selector: 'studentapplyholdsform'
    },{
        ref: 'studentremoveholdsform',
        selector: 'studentremoveholdsform'
    },{
    	ref:'studentholdsgrid',
    	selector:'studentholdsgrid'
    },{
    	ref:'manageholdinnertab',
    	selector:'manageholdinnertab'
    },{
    	ref:'financeholdinnertab',
    	selector:'financeholdinnertab'
    },{
    	ref:'studentfinanceholdsgrid',
    	selector:'studentfinanceholdsgrid'
    },{
        ref: 'livingarrangementgrid',
        selector: 'livingarrangementgrid[itemId=studentLivingArrangementGridItemId]'
    },{
        ref: 'livingarrangementdetailsform',
        selector: 'livingarrangementdetailsform'
    },{
		ref: 'applicationfollowupdetailform',
		selector: 'personinfopanel[itemId=studentPersonalInfoPanel] applicationfollowupdetailform form'
	}, {
		ref: 'applicationfollowupstructure',
		selector: 'personinfopanel[itemId=studentPersonalInfoPanel] applicationfollowupstructure'
	}, {
		ref: 'applicationfollowupdetailgrid',
		selector: 'personinfopanel[itemId=studentPersonalInfoPanel] applicationfollowupdetailgrid'
	}, {
		 ref: 'personinfopanel',
		 selector: 'personinfopanel'
	 },{
		 ref: 'studentbankdetailsgrid',
		 selector: 'studentbankdetailsgrid'
	 },{
    	ref:'flagdetailsform',
    	selector:'flagdetailsform'
    }, {
		 ref: 'passportgrid',
		 selector: 'passportgrid[itemId=studentPassportGrid]'
	 }, {
		 ref: 'studentpassportdetailsform',
		 selector: 'studentpassportdetailsform[itemId=studentPassportDetailsFormId]'
	 }, {
		 ref: 'studentpassportdocumentgrid',
		 selector: 'studentpassportdocumentgrid'
	 }, {
		 ref: 'studentpassporturlgrid',
		 selector: 'studentpassporturlgrid'
	 },{
		 ref: 'studentpassportdocumentlist',
		 selector: 'studentpassportdocumentlist'
	 }, {
		 ref: 'studentpassportdocumentlistgrid',
		 selector: 'studentpassportdocumentlistgrid'
	 }, {
		 ref: 'studentpassportdocurllist',
		 selector: 'studentpassportdocurllist'
	 }, {
		 ref: 'studentpassportdetaildocumenturllistgrid',
		 selector: 'studentpassportdetaildocumenturllistgrid'
	 }, {
		 ref: 'visadetailgrid',
		 selector: 'visadetailgrid[itemId=studentVisaGrid]'
	 },{
		 ref: 'bankdetailswindow',
		 selector: 'bankdetailswindow'
	 }, {
		 ref: 'passportgrid',
		 selector: 'passportgrid[itemId=studentPassportGrid]'
	 }, {
        ref: 'insuranceform',
        selector: 'insuranceform[itemId=studentInsuranceform]'
    },{
	        ref: 'visaform',
	        selector: 'visaform[itemId=studentVisaForm]'
	    }, {
		 ref: 'studentpassportdetailsform',
		 selector: 'studentpassportdetailsform[itemId=studentPassportDetailsFormId]'
	 }, {
		 ref: 'studentpassportdocumentgrid',
		 selector: 'studentpassportdocumentgrid'
	 }, {
		 ref: 'studentpassporturlgrid',
		 selector: 'studentpassporturlgrid'
	 },{
		 ref: 'studentpassportdocumentlist',
		 selector: 'studentpassportdocumentlist'
	 }, {
		 ref: 'studentpassportdocumentlistgrid',
		 selector: 'studentpassportdocumentlistgrid'
	 }, {
		 ref: 'studentpassportdocurllist',
		 selector: 'studentpassportdocurllist'
	 }, {
		 ref: 'studentpassportdetaildocumenturllistgrid',
		 selector: 'studentpassportdetaildocumenturllistgrid'
	 },{
        ref: 'visaform',
        selector: 'visaform[itemId=studentVisaForm]'
    }, {
		 ref: 'studentvisadocumentgrid',
		 selector: 'studentvisadocumentgrid'
	 },{
	        ref: 'documentformwindow',
	        selector: 'documentformwindow'
	    }, {
			 ref: 'studentpassportdocurllistgrid',
			 selector: 'studentpassportdocurllistgrid'
		 }, {
			 ref: 'studentvisadocumentlist',
			 selector: 'studenvisadocumentlist'
		 }, {
			 ref: 'studentvisadocumentlistgrid',
			 selector: 'studentvisadocumentlistgrid'
		 }, {
			 ref: 'studentvisadocurllist',
			 selector: 'studentvisadocurllist'
		 },
		 {	
			 ref: 'studentinsuranceurlgrid',
			 selector: 'studentinsuranceurlgrid'
		 }, {
			 ref: 'studentinsurancedocumentgrid',
			 selector: 'studentinsurancedocumentgrid'
		 },
		 {
			 ref: 'studentvisadetaildocumenturllistgrid',
			 selector: 'studentvisadetaildocumenturllistgrid'
		 }, {
			 ref: 'studentvisaurlgrid',
			 selector: 'studentvisaurlgrid'
		 },{
		 ref: 'studentbankdetailsgrid',
		 selector: 'studentbankdetailsgrid'
	 },{
    	ref:'flagdetailsform',
    	selector:'flagdetailsform'
    },{
			 ref: 'studentinsurancedetailsgrid',
			 selector: 'studentinsurancedetailsgrid[itemId=studentInsuranceDetailsGrid]'
		 },{
			 ref: 'studentinsurancedocumentlist',
			 selector: 'studentinsurancedocumentlist'
		 }, {
			 ref: 'studentinsurancedocumentlistgrid',
			 selector: 'studentinsurancedocumentlistgrid'
		 }, {
			 ref: 'studentinsurancedocurllist',
			 selector: 'studentinsurancedocurllist'
		 }, {
			 ref: 'studentinsurancedocurllistgrid',
			 selector: 'studentinsurancedocurllistgrid'
		 }, {
			 ref: 'permitgrid',
			 selector: 'permitgrid[itemId=studentPermitGrid]'
		 }, {
			 ref: 'permitdetailform',
			 selector: 'permitdetailform[itemId=studentPermitDetailFormId]'
		 }, {
			 ref: 'permitdocumentgrid',
			 selector: 'permitdocumentgrid'
		 }, {
			 ref: 'permiturldocumentgrid',
			 selector: 'permiturldocumentgrid'
		 },{
			 ref: 'permitdocumentlist',
			 selector: 'permitdocumentlist'
		 }, {
			 ref: 'permitdocumentlistgrid',
			 selector: 'permitdocumentlistgrid'
		 },{
			 ref: 'permiturldocumentlist',
			 selector: 'permiturldocumentlist'
		 }, {
			 ref: 'permiturldocumentlistgrid',
			 selector: 'permiturldocumentlistgrid'
		 }, {
			 ref: 'studentforacademictoics',
			 selector: 'studentforacademictoics'
		 }, {
			 ref: 'studentforacademictoicsgrid',
			 selector: 'studentforacademictoicsgrid'
		 }, {
			 ref: 'academictopicdocumentspopup',
			 selector: 'academictopicdocumentspopup'
		 }, {
			 ref: 'academictopicurlpopup',
			 selector: 'academictopicurlpopup'
		 }, {
			 ref: 'academictopicdocumentsgrid',
			 selector: 'academictopicdocumentsgrid'
		 }, {
			 ref: 'academictopicurlgrid',
			 selector: 'academictopicurlgrid'
		 }, {
			 ref: 'additionaladmissionapproverform',
			 selector: 'additionaladmissionapproverform'
		 },{
    		 ref:'studentGraduationCeremonyForm',
    		 selector:'studentGraduationCeremonyForm' 
    	 },{
    		 ref:'feepayergoogleaddresswin',
    		 selector:'feepayergoogleaddresswin[itemId=studentFeepayergoogleaddresswin]'
    	 }],
    config: {
    	//STUDENT_PERSONAL_DETAILS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PERSONAL_DETAILS_PRIVILEGES'),
    	STUDENT_PARENTS_GUARDIANS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PARENTS_GUARDIANS_PRIVILEGES'),
    	STUDENT_SIBLINGS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_SIBLINGS_PRIVILEGES'),
    	STUDENT_PERSONAL_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PERSONAL_DETAILS_PRIVILEGES'),
    	STUDENT_IDENTITY_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_IDENTITY_DETAILS_PRIVILEGES'),
    	STUDENT_ADDRESS_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_ADDRESS_DETAILS_PRIVILEGES'),
    	STUDENT_OTHER_INFORMATION_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_OTHER_INFORMATION_PRIVILEGES'),
    	STUDENT_SSO_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_SSO_DETAILS_PRIVILEGES'),
    	STUDENT_PORTAL_SSO_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_SSO_DETAILS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_PROFILE_SSO_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_PROFILE_SSO_DETAILS_PRIVILEGES'),
    	PARENT_PORTAL_SSO_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_SSO_DETAILS_PRIVILEGES'),
    	STUDENT_PARENT_SSO_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PARENT_SSO_DETAILS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_PROFILE_PARENT_SSO_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_PROFILE_PARENT_SSO_DETAILS_PRIVILEGES'),
    	STUDENT_FEE_PAYER_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_FEE_PAYER_DETAILS_PRIVILEGES'),
    	PARENT_PERSONAL_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PERSONAL_DETAILS_PRIVILEGES'),
    	PARENT_FEE_PAYER_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_FEE_PAYER_DETAILS_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_PERSONAL_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_PERSONAL_DETAILS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_PERSONAL_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_PERSONAL_DETAILS_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_ADDRESS_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_ADDRESS_DETAILS_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_ADDRESS_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_ADDRESS_DETAILS_PRIVILEGES'),
    	STUDENT_PORTAL_PERSONAL_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_PERSONAL_DETAILS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_PERSONAL_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_PERSONAL_DETAILS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_ADDRESS_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_ADDRESS_DETAILS_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_ADDRESS_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_ADDRESS_DETAILS_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_PARENTS_GUARDIANS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_PARENTS_GUARDIANS_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_PARENTS_GUARDIANS_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_SIBLINGS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_SIBLINGS_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_SIBLINGS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_SIBLINGS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_SIBLINGS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_SIBLINGS_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_IDENTITY_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_IDENTITY_DETAILS_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_IDENTITY_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_IDENTITY_DETAILS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_IDENTITY_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_IDENTITY_DETAILS_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_FEE_PAYER_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_FEE_PAYER_DETAILS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_FEE_PAYER_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_FEE_PAYER_DETAILS_PRIVILEGES'),
    	STUDENT_PORTAL_STUDENT_OTHER_INFORMATION_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_STUDENT_OTHER_INFORMATION_PRIVILEGES'),
    	PARENT_PORTAL_STUDENT_OTHER_INFORMATION_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_STUDENT_OTHER_INFORMATION_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_OTHER_INFORMATION_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_OTHER_INFORMATION_PRIVILEGES'),
    	STUDENT_HOSTEL_PERSONAL_REQUIREMENTS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_HOSTEL_PERSONAL_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_HOSTEL_PERSONAL_REQUIREMENTS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_HOSTEL_PERSONAL_PRIVILEGES'),
    	STUDENT_HOLDS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_HOLDS_PRIVILEGES'),
    	FACULTY_PORTAL_STUDENT_HOLDS_PERMISSIONS:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_STUDENT_HOLDS_PRIVILEGES'),
    	PARENT_CURRENT_GRADE_PAYMENT_TERM_PEMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_CURRENT_GRADE_PAYMENT_TERM_PRIVILEGES'),
        PARENT_DETAILS_VISITOR_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_DETAILS_VISITOR_PRIVILEGES'),
    	STUDENT_PORTAL_PARENT_DETAILS_VISITOR_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_PARENT_DETAILS_VISITOR_PRIVILEGES'),
    	PARENT_PORTAL_PARENT_DETAILS_VISITOR_PERMISSION:Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_PARENT_DETAILS_VISITOR_PRIVILEGES'),
    	STUDENTPORTAL_LIVING_ARRANGMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENTPORTAL_LIVING_ARRANGMENT_PRIVILEGES'),
    	STUDENT_LIVING_ARRANGMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_LIVING_ARRANGMENT_PRIVILEGES'),
    	FACULTY_LIVING_ARRANGMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_LIVING_ARRANGMENT_PRIVILEGES'),
    	PASSPORT_DETAIL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PASSPORT_DETAIL_PRIVILEGES'),
    	VISA_DETAIL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('VISA_DETAIL_PRIVILEGES'),
    	STUDENT_PORTAL_PASSPORT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_PASSPORT_PREVILEGES'),
    	PARENT_PORTAL_PASSPORT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_PASSPORT_PREVILEGES'),
    	FACULTY_PORTAL_PASSPORT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_PASSPORT_DETAIL_PRIVILEGES'),
        STUDENTPORTAL_LIVING_ARRANGMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENTPORTAL_LIVING_ARRANGMENT_PRIVILEGES'),
    	PARENT_PORTAL_VISA_DETAIL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_VISA_DETAIL_PRIVILEGES'),
    	FACULTY_PORTAL_VISA_DETAIL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_VISA_DETAIL_PRIVILEGES'),
    	STUDENT_PORTAL_VISA_DETAIL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_VISA_PREVILEGES'),
    	PERMIT_DETAIL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PERMIT_DETAIL_PRIVILEGES'),
    	INSURANCE_DETAILS_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('INSURANCE_DETAILS_PRIVILEGES'),
    	STUDENT_PORTAL_INSURANCE_DETAIL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_INSURANCE_PREVILEGES'),
  		STUDENT_PORTAL_PERMIT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PORTAL_PERMIT_PREVILEGES'),
    	PARENT_PORTAL_PERMIT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_PERMIT_PREVILEGES'),
    	FACULTY_PORTAL_PERMIT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_PERMIT_PRIVILEGES'),
    	PARENT_PORTAL_INSURANCE_DETAIL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PORTAL_INSURANCE_DETAIL_PRIVILEGES'),
    	FACULTY_PORTAL_INSURANCE_DETAIL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_INSURANCE_DETAIL_PRIVILEGES'),
    	PASSPORT_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PASSPORT_DOCUMENT_PRIVILEGES'),
   	    PASSPORT_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PASSPORT_URL_PRIVILEGES'),
   	    STUDENT_PASSPORT_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PASSPORT_DOCUMENT_PRIVILEGES'),
   	    STUDENT_PASSPORT_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PASSPORT_URL_PRIVILEGES'),
   	    FACULTY_PASSPORT_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PASSPORT_DOCUMENT_PRIVILEGES'),
   	    FACULTY_PASSPORT_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PASSPORT_URL_PRIVILEGES'),
   	    PARENT_PASSPORT_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PASSPORT_DOCUMENT_PRIVILEGES'),
   	    PARENT_PASSPORT_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PASSPORT_URL_PRIVILEGES'),
   	    VISA_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('VISA_DOCUMENT_PRIVILEGES'),
	    VISA_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('VISA_URL_PRIVILEGES'),
	    STUDENT_VISA_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_VISA_DOCUMENT_PRIVILEGES'),
	    STUDENT_VISA_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_VISA_URL_PRIVILEGES'),
	    FACULTY_VISA_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_VISA_DOCUMENT_PRIVILEGES'),
	    FACULTY_VISA_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_VISA_URL_PRIVILEGES'),
	    PARENT_VISA_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_VISA_DOCUMENT_PRIVILEGES'),
	    PARENT_VISA_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_VISA_URL_PRIVILEGES'),
	    PERMIT_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PERMIT_DOCUMENT_PRIVILEGES'),
	    PERMIT_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PERMIT_URL_PRIVILEGES'),
	    STUDENT_PERMIT_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PERMIT_DOCUMENT_PRIVILEGES'),
	    STUDENT_PERMIT_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_PERMIT_URL_PRIVILEGES'),
	    FACULTY_PERMIT_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PERMIT_DOCUMENT_PRIVILEGES'),
	    FACULTY_PERMIT_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PERMIT_URL_PRIVILEGES'),
	    PARENT_PERMIT_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PERMIT_DOCUMENT_PRIVILEGES'),
	    PARENT_PERMIT_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_PERMIT_URL_PRIVILEGES'),
	    INSURANCE_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('INSURANCE_DOCUMENT_PRIVILEGES'),
	    INSURANCE_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('INSURANCE_URL_PRIVILEGES'),
	    STUDENT_INSURANCE_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_INSURANCE_DOCUMENT_PRIVILEGES'),
	    STUDENT_INSURANCE_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_INSURANCE_URL_PRIVILEGES'),
	    FACULTY_INSURANCE_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_INSURANCE_DOCUMENT_PRIVILEGES'),
	    FACULTY_INSURANCE_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_INSURANCE_URL_PRIVILEGES'),
	    PARENT_INSURANCE_DOCUMENT_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_INSURANCE_DOCUMENT_PRIVILEGES'),
	    PARENT_INSURANCE_URL_PERMISSION : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PARENT_INSURANCE_URL_PRIVILEGES'),
	    STUDENT_BANK_DETAILS_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_BANK_DETAILS_PRIVILEGES'),
	    SP_FOR_GRADUATION_CEREMONY : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SP_FOR_GRADUATION_CEREMONY'),
	    STUDENT_LIST_OF_APPLICABLE_CONDITIONS_FOR_ADMISSION_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_LIST_OF_APPLICABLE_CONDITIONS_FOR_ADMISSION_PRIVILEGES'),
	    FACULTY_STUDENT_FLAG_LIST_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_STUDENT_FLAG_LIST_PRIVILEGES'),
	    SP_FOR_TRANSFER_CREDIT_LIST_PERMISSIONS : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SP_FOR_TRANSFER_CREDIT'),
		STUDENT_INTERNAL_TRANSFER_CREDIT : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_INTERNAL_TRANSFER_CREDIT'),
		STUDENT_EXTERNAL_TRANSFER_CREDIT : Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('STUDENT_EXTERNAL_TRANSFER_CREDIT'), 
		
    },
    
    init: function(application) {
    	this.passportMode;
    	this.visaMode;
        this.isAdd=true;
        this.feePayerEncryptedDocId;
        this.reRegfeePayerDataDFR;
        this.stdFeePayerFormMode;
        this.control({
			'studentpassportdetailsform':{
    			afterrender: function(form) {	
    				if(this.isAdd){
    					form.up().setTitle(getCommonTranslation('ADD_PASSPORT'));
    				}else{
    					form.up().setTitle(getCommonTranslation('EDIT_PASSPORT'));
    				}
    			}
    		},
    		
 
        	'personinfopanel[itemId=studentPersonalInfoPanel] applicationfollowupdetailgrid button[itemId=btnEdit]': {
				click:function(btn) {
					var  me =this,
					 cademyLocationId = me.getCurrentAcademyLocation(),
					 contantPanel = me.getContentPanel(),
					 studentProfile = contantPanel.getActiveTab(),
					 personinfopanel = studentProfile.down('personinfopanel'),
					 activeInnerTab = personinfopanel.getActiveTab(),
					 dataGrid = activeInnerTab.down('applicationfollowupdetailgrid'),
					selectedRec= dataGrid.getSelectionModel().getSelection()[0];
					if(selectedRec && selectedRec.get('status') == 'Closed'){
						showWarningMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getEnquiryTranslation('ALERT_FOLLOWUP_ALLOW_ONLY'));
					}else if(!selectedRec) {
						showWarningMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'flagdetailsform':{
				
    			afterrender: function(grid){
    				if(portalId == 3){
    				   this.doAccessControlValidation(grid, this.getSTUDENT_FLAG_LIST_PRIVILEGES());
    				}else if(portalId == 7){
    					this.doAccessControlValidation(grid, this.getPARENT_FLAG_LIST_PRIVILEGES());
    				}
    				var this$ = this;
    				var studentProfile = this$.getContentPanelActiveTab();
    	
    	            var userId = studentProfile.getUserId();
    	            
    	            var g=this.getFlagdetailsform();
    	            var s=g.getStore();
    	            s.getProxy().extraParams = {studentId:userId};
    	            s.load();
    			}
    			},
    			'flagliststudentgrid':{
    			afterrender: function(grid) {
    				if(portalId == 2) {
    					this.doAccessControlValidation(grid, this.getFACULTY_STUDENT_FLAG_LIST_PERMISSIONS());
    				}
    				else {
    					this.doAccessControlValidation(grid, this.getSTUDENT_FLAG_LIST_PRIVILEGES());
    				}
						var this$ = this;
    				var studentProfile = this$.getContentPanelActiveTab();
    	
    	            var userId = studentProfile.getUserId();
    	            
    	            var g=this.getFlagliststudentgrid();
    	            var s=g.getStore();
    	            s.getProxy().extraParams = {studentId:userId};
    	            s.load();
    			}
    		},
        	'personinfopanel[itemId=studentPersonalInfoPanel] applicationfollowupdetailform button[itemId=followdetail_submitbuttonId]': {
				click:function(btn) {
					btn.setDisabled(true);
					this.saveStudentFollowUpDetail(btn );
				}
			},
			'personinfopanel[itemId=studentPersonalInfoPanel] applicationfollowupdetailform':{
				afterrender:function(form){
					var me = this ,rec,
					 academyLocationId = me.getCurrentAcademyLocation(),
					 contantPanel = me.getContentPanel(),
					 studentProfile = contantPanel.getActiveTab(),
					 personinfopanel = studentProfile.down('personinfopanel'),
					 activeInnerTab = personinfopanel.getActiveTab(),
					currentUser = me.getCurrentlyLoggedInUser(),
					dataGrid = activeInnerTab.down('applicationfollowupdetailgrid'),
					form = activeInnerTab.down('applicationfollowupdetailform'),
					studentData = me.studentData,
					applicantFollowUpUser = form.down('#applicantFollowUpUser'),
					applicantEmailAdress = form.down('#applicantEmailAdress'),
					applicantFollowupactivityto = form.down('#applicantFollowupactivityto'),
					cellNo = form.down('#phoneCountryCode'),
					appointmentTypesCombo =dataGrid.down('#appointmentTypes'),
					actualApplicantFollowUpDate =form.down('#actualApplicantFollowUpDate'),
					applicantFollowupTime =form.down('#applicantFollowupTime'),
					studentProfileView = me.getTabReferenceByTabTitle(studentData.code),
					phoneCountryCode = form.down('#applicant_mobileno');
					applicantFollowUpUser.setValue(currentUser.value);
					if(studentData){
						applicantEmailAdress.setValue(studentData.emailId);
						applicantFollowupactivityto.setValue(studentData.printName);
						applicantFollowupactivityto.studentId = studentData.id;
						cellNo.setValue(studentData.person.mobileCountryCode);
						phoneCountryCode.setValue(parseInt(studentData.person.mobileNumber));
					}
					appointmentTypesCombo.setVisible(true);
					appointmentTypesCombo.getStore().getProxy().extraParams={
						studentId : studentData.id
        			};
					appointmentTypesCombo.getStore().removeAll();
					actualApplicantFollowUpDate.setValue(new Date());
					applicantFollowupTime.setValue(new Date());
					appointmentTypesCombo.getStore().load(function(){
						if(appointmentTypesCombo.getStore().count()){
							if(studentProfileView.appointmentId){
								rec = appointmentTypesCombo.getStore().findRecord('id',studentProfileView.appointmentId);
								appointmentTypesCombo.select(rec);
							}else{
								rec = appointmentTypesCombo.getStore().getAt(0);
								appointmentTypesCombo.select(rec);
							}
							
							appointmentTypesCombo.fireEvent('select',appointmentTypesCombo,[rec]);
						}
					});
					var  proxy = dataGrid.getStore().getProxy();
					var  newApi =  {read: SERVERURL.PATH_STUDENT_GRID_DATA_FOLLOWUP, update: SERVERURL.PATH_STUDENT_GRID_DATA_FOLLOWUP };
					Ext.apply(proxy.api,newApi);
				},
				validitychange:function(cmp,valid){
					var me =this,
					contantPanel = me.getContentPanel(),
					 studentProfile = contantPanel.getActiveTab(),
					 personinfopanel = studentProfile.down('personinfopanel'),
					 activeInnerTab = personinfopanel.getActiveTab(),
					currentUser = me.getCurrentlyLoggedInUser(),
					dataGrid = activeInnerTab.down('applicationfollowupdetailgrid'),
					formView = activeInnerTab.down('applicationfollowupdetailform');
					if(valid){
						appointmentTypesCombo =dataGrid.down('#appointmentTypes');
						if(!appointmentTypesCombo.getValue()){
							formView.down('#followdetail_submitbuttonId').setDisabled(true);
						}else{
							formView.down('#followdetail_submitbuttonId').setDisabled(false);
						}
					}
				}
			},'personinfopanel[itemId=studentPersonalInfoPanel] applicationfollowupdetailform checkboxfield[itemId=applicantWhetherNextFollowUpId]': {
            	change:function(checkbox, newValue, oldValue, eOpts){ 
            		var $this = this;
            		var contantPanel = $this.getContentPanel();
					var applicantprofile = contantPanel.getActiveTab();
					var personinfopanel = applicantprofile.down('personinfopanel');
					var activeInnerTab = personinfopanel.getActiveTab();
					var form = activeInnerTab.down('applicationfollowupdetailform');
            		var nextFollowUpDate = form.down('#applicantNextFollowUpDateId');
            		var userByAssignTo = form.down('#applicantUserByAssignToId');
            		nextFollowUpDate.reset();
            		userByAssignTo.reset();
            		if(newValue==true){
            			nextFollowUpDate.setVisible(true);
            			userByAssignTo.setVisible(true);
            			$this.setAllowBlank (nextFollowUpDate,false);
            			$this.setAllowBlank (userByAssignTo,false);
            			var userByAssignToStore = userByAssignTo.getStore();
            			var loggedUserId = this.getCurrentlyLoggedInUser().id;
            			Ext.defer(function() {
	            			userByAssignToStore.load({
		            			scope:this,
		            			callback: function(records, operation, success) {
			            			if(success){
			            				userByAssignTo.setValue(loggedUserId);
			            				Ext.defer(function(){
			                    			nextFollowUpDate.clearInvalid();
			                        		userByAssignTo.clearInvalid();
			                    		},100)
			            			}
		            			}
	            			});
            			});
            			userByAssignTo.validate();
            			nextFollowUpDate.validate();
                	}else if(newValue==false){
                		nextFollowUpDate.setVisible(false);
            			userByAssignTo.setVisible(false);
            			$this.setAllowBlank (nextFollowUpDate,true);
            			$this.setAllowBlank (userByAssignTo,true);
            			userByAssignTo.validate();
            			nextFollowUpDate.validate();
                	}
            		form.getForm().isValid();
            		Ext.defer(function(){
            			nextFollowUpDate.clearInvalid();
                		userByAssignTo.clearInvalid();
            		},100)
            		
				}
			
			}, // due to conflict code commented. same function 2 times.
			/*'personinfopanel[itemId=studentPersonalInfoPanel] applicationfollowupdetailgrid customcombobox[itemId=appointmentTypes]':{
				select:function(cmp,record){
					var me = this,
					cademyLocationId = me.getCurrentAcademyLocation(),
					 contantPanel = me.getContentPanel(),
					 studentProfile = contantPanel.getActiveTab(),
					 personinfopanel = studentProfile.down('personinfopanel'),
					 activeInnerTab = personinfopanel.getActiveTab(),
					 dataGrid = activeInnerTab.down('applicationfollowupdetailgrid'),
					selectedRec= dataGrid.getSelectionModel().getSelection()[0];
					if(selectedRec && selectedRec.get('status') == 'Closed'){
						showWarningMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getEnquiryTranslation('ALERT_FOLLOWUP_ALLOW_ONLY'));
					}else if(!selectedRec) {
						showWarningMessage(getEnquiryTranslation('FOLLOW_UP_DETAIL'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},*/
        	'personinfopanel[itemId=studentPersonalInfoPanel] applicationfollowupdetailform button[itemId=followdetail_submitbuttonId]': {
				click:function(btn) {
					btn.setDisabled(true);
					this.saveStudentFollowUpDetail(btn );
				}
			},
			'personinfopanel[itemId=studentPersonalInfoPanel] applicationfollowupdetailform':{
				afterrender:function(form){
					var me = this ,rec,
					 academyLocationId = me.getCurrentAcademyLocation(),
					 contantPanel = me.getContentPanel(),
					 studentProfile = contantPanel.getActiveTab(),
					 personinfopanel = studentProfile.down('personinfopanel'),
					 activeInnerTab = personinfopanel.getActiveTab(),
					currentUser = me.getCurrentlyLoggedInUser(),
					dataGrid = activeInnerTab.down('applicationfollowupdetailgrid'),
					form = activeInnerTab.down('applicationfollowupdetailform'),
					studentData = me.studentData,
					applicantFollowUpUser = form.down('#applicantFollowUpUser'),
					applicantEmailAdress = form.down('#applicantEmailAdress'),
					applicantFollowupactivityto = form.down('#applicantFollowupactivityto'),
					cellNo = form.down('#phoneCountryCode'),
					appointmentTypesCombo =dataGrid.down('#appointmentTypes'),
					actualApplicantFollowUpDate =form.down('#actualApplicantFollowUpDate'),
					applicantFollowupTime =form.down('#applicantFollowupTime'),
					studentProfileView = me.getTabReferenceByTabTitle(studentData.code),
					phoneCountryCode = form.down('#applicant_mobileno');
					form.down('#followupStatusUpdateTimeId').setVisible(false);
					form.down('#followupStatusUpdateTimeId').allowBlank = true;
					applicantFollowUpUser.setValue(currentUser.value);
					if(studentData){
						applicantEmailAdress.setValue(studentData.emailId);
						applicantFollowupactivityto.setValue(studentData.printName);
						applicantFollowupactivityto.studentId = studentData.id;
						cellNo.setValue(studentData.person.mobileCountryCode);
						phoneCountryCode.setValue(parseInt(studentData.person.mobileNumber));
					}
					appointmentTypesCombo.setVisible(true);
					var personProfile = me.getContentPanelActiveTab();
                	try{
                		appointmentTypesCombo.getStore().getProxy().extraParams={
    						studentId : personProfile.getUserId()
            			};
                	}catch(e){
					appointmentTypesCombo.getStore().getProxy().extraParams={
						studentId : studentData.id
        			};
                	}
					appointmentTypesCombo.getStore().removeAll();
					actualApplicantFollowUpDate.setValue(new Date());
					applicantFollowupTime.setValue(new Date());
					appointmentTypesCombo.getStore().load(function(){
						if(appointmentTypesCombo.getStore().count()){
							if(studentProfileView.appointmentId){
								rec = appointmentTypesCombo.getStore().findRecord('id',studentProfileView.appointmentId);
								appointmentTypesCombo.select(rec);
							}else{
								rec = appointmentTypesCombo.getStore().getAt(0);
								appointmentTypesCombo.select(rec);
							}
							
							appointmentTypesCombo.fireEvent('select',appointmentTypesCombo,[rec]);
						}
					});
					var  proxy = dataGrid.getStore().getProxy();
					var  newApi =  {read: SERVERURL.PATH_STUDENT_GRID_DATA_FOLLOWUP, update: SERVERURL.PATH_STUDENT_GRID_DATA_FOLLOWUP };
					Ext.apply(proxy.api,newApi);
				},
				validitychange:function(cmp,valid){
					var me =this,
					contantPanel = me.getContentPanel(),
					 studentProfile = contantPanel.getActiveTab(),
					 personinfopanel = studentProfile.down('personinfopanel'),
					 activeInnerTab = personinfopanel.getActiveTab(),
					currentUser = me.getCurrentlyLoggedInUser(),
					dataGrid = activeInnerTab.down('applicationfollowupdetailgrid'),
					formView = activeInnerTab.down('applicationfollowupdetailform');
					if(valid){
						appointmentTypesCombo =dataGrid.down('#appointmentTypes');
						if(!appointmentTypesCombo.getValue()){
							formView.down('#followdetail_submitbuttonId').setDisabled(true);
						}else{
							formView.down('#followdetail_submitbuttonId').setDisabled(false);
						}
					}
				}
			},'personinfopanel[itemId=studentPersonalInfoPanel] applicationfollowupdetailform checkboxfield[itemId=applicantWhetherNextFollowUpId]': {
            	change:function(checkbox, newValue, oldValue, eOpts){ 
            		var $this = this;
            		var contantPanel = $this.getContentPanel();
					var applicantprofile = contantPanel.getActiveTab();
					var personinfopanel = applicantprofile.down('personinfopanel');
					var activeInnerTab = personinfopanel.getActiveTab();
					var form = activeInnerTab.down('applicationfollowupdetailform');
            		var nextFollowUpDate = form.down('#applicantNextFollowUpDateId');
            		var userByAssignTo = form.down('#applicantUserByAssignToId');
            		nextFollowUpDate.reset();
            		userByAssignTo.reset();
            		if(newValue==true){
            			nextFollowUpDate.setVisible(true);
            			userByAssignTo.setVisible(true);
            			$this.setAllowBlank (nextFollowUpDate,false);
            			$this.setAllowBlank (userByAssignTo,false);
            			var userByAssignToStore = userByAssignTo.getStore();
            			var loggedUserId = this.getCurrentlyLoggedInUser().id;
            			Ext.defer(function() {
	            			userByAssignToStore.load({
		            			scope:this,
		            			callback: function(records, operation, success) {
			            			if(success){
			            				userByAssignTo.setValue(loggedUserId);
			            				Ext.defer(function(){
			                    			nextFollowUpDate.clearInvalid();
			                        		userByAssignTo.clearInvalid();
			                    		},100)
			            			}
		            			}
	            			});
            			});
            			userByAssignTo.validate();
            			nextFollowUpDate.validate();
                	}else if(newValue==false){
                		nextFollowUpDate.setVisible(false);
            			userByAssignTo.setVisible(false);
            			$this.setAllowBlank (nextFollowUpDate,true);
            			$this.setAllowBlank (userByAssignTo,true);
            			userByAssignTo.validate();
            			nextFollowUpDate.validate();
                	}
            		form.getForm().isValid();
            		Ext.defer(function(){
            			nextFollowUpDate.clearInvalid();
                		userByAssignTo.clearInvalid();
            		},100)
            		
				}
			
			},
			'personinfopanel[itemId=studentPersonalInfoPanel] applicationfollowupdetailgrid customcombobox[itemId=appointmentTypes]':{
				select:function(cmp,record){
					var me = this,
					cademyLocationId = me.getCurrentAcademyLocation(),
					 contantPanel = me.getContentPanel(),
					 studentProfile = contantPanel.getActiveTab(),
					 personinfopanel = studentProfile.down('personinfopanel'),
					 activeInnerTab = personinfopanel.getActiveTab(),
					 dataGrid = activeInnerTab.down('applicationfollowupdetailgrid'),
					 index=null,
					formView = activeInnerTab.down('applicationfollowupdetailform');
					dataGrid.getStore().getProxy().url = SERVERURL.PATH_STUDENT_GRID_DATA_FOLLOWUP;
					var personProfile = me.getContentPanelActiveTab();
                	try{
                		dataGrid.getStore().getProxy().extraParams={
    						studentId : personProfile.getUserId(),
    						appointmentId:record[0].get('id')
            			};
                	}catch(e){
					dataGrid.getStore().getProxy().extraParams={
						studentId : this.studentData.id,
						appointmentId:record[0].get('id')
        			};
                	}
					formView.isValid();
					dataGrid.getStore().removeAll();
					Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
					dataGrid.getStore().load(function(records){
						for(count = 0 ;count<records.length;count++){
							if(records[count].get('status')== 'Open' && index == null){
								index = count;
							}
							
						}
						if(dataGrid.getStore().count() && index != null){
							dataGrid.getSelectionModel().select([dataGrid.getStore().getAt(index)]);
						}else if(!dataGrid.getStore().count()){
								me.resetForm();
						}
						if(records.length){
							formView.getForm().findField('applicantWhetherNextFollowUp').setDisabled(false);
						}else{
							formView.getForm().findField('applicantWhetherNextFollowUp').setDisabled(true);
						}
						Ext.getBody().unmask();
					});
				}
			},
			'personinfopanel[itemId=studentPersonalInfoPanel] applicationfollowupdetailgrid':{
				selectionchange:function(cmp,selected){
					if(selected.length){
						this.loadSelectedRecord(selected[0]);
					}
				}
			},
        	'studentprofile': {
                render: function(){
                	this.getStudentProfileInformation();
                	this.getActiveMyDashboard();
                }
            },
            "studentprofile panel[itemId=studentProfileEastPanel]": {
            	afterrender: function(sidePanel){
            		var me = this,
            			storeRecords = [],
            			sidePanelSearchCombo = sidePanel.down('#personalDetailLinkSearchComboBox'),
            			sidePanelSearchStore = sidePanelSearchCombo.getStore(),
            			sidePanelItems,
            			upperTabTitle,
            			currentDataView,
            			currentItemIndex;

            		sidePanel.up('studentprofile').on('activate', function(){
            			setTimeout(function(){
                			sidePanelItems = sidePanel.down('persondetailslinkpanel').items.items,
                    		Ext.each(sidePanelItems, function(sidePanelItem){
                    			upperTabTitle = sidePanelItem.title;
                    			currentDataView = sidePanelItem.down('dataview');
                    			currentItemIndex = 0;
                    			                    			
                    			Ext.each(currentDataView.store.data.items, function(currentElement){
                    				storeRecords.push({
                    					displayPath: upperTabTitle,
                    					title: getPersonModuleTranslation(currentElement.get('tabPanelTitle')),
                    					parentPanelSelector: currentDataView.el.id,
                    					currentElementSelector: currentDataView.itemSelector,
                    					currentItemIndex: currentItemIndex,
                    					searchText: getPersonModuleTranslation(currentElement.get('tabPanelTitle')),
                    					tabPanelItemXtype: currentElement.data.tabPanelItemXtype
                    				});
                    				currentItemIndex = currentItemIndex + 1;
                    			});
                    		});
                    		
                    		sidePanelSearchStore.removeAll();
                    		sidePanelSearchStore.add(storeRecords);
                    		sidePanel.up('studentprofile').un('activate');
            			},100);
            		},this);
            	},
            	beforecollapse:function(obj, direction, animate, eOpts){
        			try{
            			if(event.target.classList.contains('x-form-text')){
            				return false;
            			}
        			}
        			catch(e){
        				if(Ext.ComponentQuery.query('#personalDetailLinkSearchComboBox')[0].hasFocus && Ext.ComponentQuery.query('#personalDetailLinkSearchComboBox')[0].allowCollapse==false){
        					return false;
        				}
        			}
            	}
            },
            
            "persondetailslinkpanel[itemId=studentPersonDetailsLinkPanel] dataview": {
                itemclick: function(view, record) {
                    var tabPanelTitle = record.get('tabPanelTitle');
                    var tabPanelItemId = record.get('tabPanelItemId');
                    var tabPanelItemXtype = record.get('tabPanelItemXtype');
                    var xtypeItemId = record.get('xtypeItemId');
                    var defaultPanel = record.get('defaultPanel');
                    var renderPanel= record.get('render');
                	
                    if (!isNullOrEmpty(renderPanel) && renderPanel) {
                    	this.addPersonTabPanel('STUDENT', tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
                    }
                }
            },
            'personalinformationform[itemId=studentPersonalInformationForm] textfield[itemId=nationalIDItemId]': {
            	 blur : function(obj){
            		 this$ = this;
            		 var personProfile = this$.getContentPanelActiveTab();
            		 var personalInformationForm = personProfile.down('#studentPersonalInformationForm');
            		 var newValue = Ext.ComponentQuery.query('textfield[itemId=nationalIDItemId]')[0];
            		 if(!isNullOrEmpty(newValue.value))
            		 {
            			 personalInformationForm.down("#verifyDetail").setDisabled(false);
            		 }else{
            			 personalInformationForm.down("#verifyDetail").setDisabled(true);
            		 }
            		 
            	 }
            },
            'personalinformationform[itemId=studentPersonalInformationForm] textfield[itemId=birthDateId] ':
            	{
            	 change : function(obj,record)
            	 {
            		 var $this = this;
                     var form = obj.up('personalinformationform');
                     var ageData =form.down("#ageId");
                      var currentYear = new Date(record);
                     var todayDate = new Date();
                      var calculateAge =todayDate.getFullYear()-currentYear.getFullYear();
                      if (form.down("#birthDateId").isValid()){
                     if (todayDate.getMonth() < currentYear.getMonth() || (todayDate.getMonth() === currentYear.getMonth() && todayDate.getDate() < currentYear.getDate())) {
                         calculateAge--;
                     }}
                      else
                          {
                              calculateAge = 0;
                          }
                      ageData.setValue(calculateAge);
                      
                      ageData.setReadOnly(true);
            	 }
            	},
            'personalinformationform[itemId=studentPersonalInformationForm]': {
            	render: function(obj){
            		var this$ = this;
            		obj.down('#boardNumberId').setVisible(true);
            		if(this.getCurrentLoggedPortalId()==3) {
            		    var isMidTerm = this.getCurrentlyLoggedInUserInfoForPortal().student.isMidtermJoinee; 
            		    obj.down('#isMidtermJoineeField').setVisible(isMidTerm);
            		    obj.down('#isAutomateExchange').setVisible(false);    
            			obj.down('#personCodeField').setReadOnly(true);
            			obj.down('#bloodGroupId').setReadOnly(true);
            			obj.down('#maritalStatusId').setReadOnly(true);
            			obj.down('#religionCombo').setReadOnly(true);
            			obj.down('#castCategoryCombo').setReadOnly(true);
            			obj.down('#personalIncomeId').setReadOnly(true);
            			obj.down('#dietPreferenceId').setReadOnly(true);
            			obj.down('#categoryId').setReadOnly(true);
            			obj.down('#accountingKeyId').setReadOnly(true);
            			obj.down('#validTill').setReadOnly(true);
            			obj.down('#accountingKeyId').setReadOnly(true);
            			//obj.down('#salutationId').setReadOnly(true);
            			obj.down('#salutationId').setReadOnly(true);
            			obj.down('#sadcCitizenship').setReadOnly(true);
            			obj.down('#nationalIDItemId').setReadOnly(true);
            			obj.down('#haveDisabilities').setReadOnly(true);
            			obj.down('#alternateEmailId').setReadOnly(true);
            			obj.down('#externalSysRefOne').setReadOnly(true);
            			
            			obj.down('#firstNameId').setReadOnly(true);
            			obj.down('#middleNameId').setReadOnly(true);
            			obj.down('#lastNameId').setReadOnly(true);
            			
            			obj.down('#printNameId').setReadOnly(true);
            			obj.down('#shortNameId').setReadOnly(true);
            			
            			obj.down('#genderCSM').setReadOnly(true);
            			obj.down('#birthDateId').setReadOnly(true);
            			
            			obj.down('#countryCombo').setReadOnly(true);
            			obj.down('#nationalityCombo').setReadOnly(true);
            			obj.down('#domicileCombo').setReadOnly(true);
            			
            			obj.down('#phoneCountryCode').setReadOnly(true);
            			obj.down('#phoneAreaCode').setReadOnly(true);
            			
            			obj.down('#phoneNoField').setReadOnly(true);
            			obj.down('#cellCountryCode').setReadOnly(true);
            			obj.down('#mobileNumber').setReadOnly(true);
            			obj.down('#emailId').setReadOnly(true);
            		
            			
            			obj.down('#stuSecondaryCitizenshipItemId').setReadOnly(true);
            			obj.down('#idTypeCombo').setReadOnly(true);
            			obj.down('#stuIsWheelCharRequiredItemId').setReadOnly(true);
            			obj.down('#stuPermanentResItemId').setReadOnly(true);
            			obj.down('#stuAsylumSeekerItemId').setReadOnly(true);
            			obj.down('#stuAreYouRefugeeItemId').setReadOnly(true);
            			obj.down('#stuIsStudyingInstitutionItemId').setReadOnly(true);
            			obj.down('#isEnrolledTertiaryItemId').setReadOnly(true);
            			
            			obj.down('#fieldOfInterestItemId').setReadOnly(true);
            			obj.down('#areaOfResearchItemId').setReadOnly(true);
            			obj.down('#isMilitarySponsoredItemId').setReadOnly(true);
            			obj.down('#isBursaryRequirementsItemId').setReadOnly(true);
            			obj.down('#pHDSponsorItemId').setReadOnly(true);
            		
            			/*** Bank details *****/
            			
            			obj.down('#beneficiaryName').setReadOnly(false);
            			obj.down('#beneficiaryNameOtherLanguageId').setReadOnly(false);
            			obj.down('#accountNumber').setReadOnly(false);
            			obj.down('#accountTypeId').setReadOnly(false);
            			
            			obj.down('#bankName').setReadOnly(false);
            			obj.down('#branchName').setReadOnly(false);
            			obj.down('#ifsCode').setReadOnly(false);
            			
            			obj.down('#bankNameValue').setReadOnly(false);
            			obj.down('#branchNameValue').setReadOnly(false);
            			obj.down('#ifscCodeValue').setReadOnly(false);
            			
            			obj.down('#haveDisabilities').setReadOnly(true);
            			obj.down('#homeLanguage').setReadOnly(true);
            			obj.down('#secondLanguage').setReadOnly(true);
            			obj.down('#advisorItemId').setReadOnly(true);
            			obj.down('#admissionDate').setReadOnly(true);
            			obj.down('#studentStatusItemId').setReadOnly(false);
            			obj.down('#firstNameOtherLnguageId').setReadOnly(true);
            			obj.down('#middleNameOtherLnguageId').setReadOnly(true);
            			obj.down('#lastNameOtherLnguageId').setReadOnly(true);
            			obj.down('#shortNameOtherLnguageId').setReadOnly(true);
            			obj.down('#printNameOtherLnguageId').setReadOnly(true);
            			obj.down('#applicantPersonRadioBtnUwcBefore').setReadOnly(true);
            			obj.down('#uwcBefore').setReadOnly(true);
            			obj.down('#applicantPersonRadioBtnRegisteredBeforeSA').setReadOnly(true);
            			obj.down('#registeredBeforeSA').setReadOnly(true);
            			obj.down('#applicantPersonRadioBtnPopiaAct').setReadOnly(true);
            			obj.down('#diplomaticStatusId').setReadOnly(true);
            			obj.down('#temporaryStudyId').setReadOnly(true);
            			obj.down('#workCriticalSkillsId').setReadOnly(true);
            			obj.down('#postgraduateNonResidentialStudentId').setReadOnly(true);
            			obj.down('#isLearnerSACitizenField').setReadOnly(true);
            			
            			
            			
            			//-----Code For Sunshine Only
            			obj.down('#stuCorrespondenceLanguageItemId').setReadOnly(false);
            			obj.down('#stuContactLanguageItemId').setReadOnly(false);
            			obj.down('#mobileNumber').setReadOnly(false);
            			
            		} 
            		
            		if(this.getCurrentLoggedPortalId()==3||this.getCurrentLoggedPortalId()==7)
            			{
            			obj.down('#examCenterVenue').setReadOnly(true);
            			}
            		if (this$.getCurrentLoggedPortalId() == 1 || this$.getCurrentLoggedPortalId() == 2) {
            			Ext.Ajax.request({
                			type: 'rest',
                			url: SERVERURL.PATH_FIND_WHETHER_EDITABLE,
                			params: {
                				tableName: 'students',
                				columnName: 'code'
                            },
                			method: 'GET',
                			success: function(res, action) {
                				var response = Ext.decode(res.responseText);
                				if(response == true || response == 'true'){
                					obj.down('#personCodeField').setReadOnly(false);
                				}
                			}
                        });
            		}
            		
            		if (this$.getCurrentLoggedPortalId() == 1) {
            		Ext.Ajax.request({
            			type: 'rest',
            			url: SERVERURL.PATH_FIND_WHETHER_EDITABLE,
            			params: {
            				tableName: 'admission',
            				columnName: 'code'
                        },
            			method: 'GET',
            			success: function(res, action) {
            				var response = Ext.decode(res.responseText);
            				if(response == true || response == 'true'){
            					obj.down('#admissionIdIteamId').setReadOnly(false);
            				}
            			}
                    });
            	}
            		if(this$.getCurrentLoggedPortalId() == 2){
            			obj.down('#advisorItemId').setReadOnly(true);
            			obj.down('#admissionDate').setReadOnly(true);
            		 if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
            			 obj.down('#emailId').setReadOnly(true);
            		 }
            		}
            		var form = obj.getForm();
            		//var haveDisabilities = form.findField('haveDisabilities');
            		
            		var haveDisabilitiesStore = form.findField('haveDisabilities').getStore();
        			haveDisabilitiesStore.getProxy().extraParams={
        				type:'HaveDisabilities'
        			};
        			var studentAttendanceGroupStore = form.findField('studentAttendanceGroup').getStore();
        			studentAttendanceGroupStore.getProxy().extraParams={
        				type:'studentGroup'
        			};
        			var homeLanguageStore = form.findField('homeLanguage').getStore();
        			homeLanguageStore.getProxy().extraParams={
        				type:'HomeLanguage'
        			};
        			
        			var sadcCitizenshipStore = form.findField('sadcCitizenship').getStore();
        			sadcCitizenshipStore.getProxy().extraParams={
        				type:'SADCCitizenship'
        			};
        			var secondLanguageStore = form.findField('secondLanguage').getStore();
        			secondLanguageStore.getProxy().extraParams={
        				type:'SecondLanguage'
        			};
        			
        			var fieldOfInterestStore = form.findField('fieldOfInterest').getStore();
        			fieldOfInterestStore.getProxy().extraParams={
        				type:'fieldOfInterest'
        			};
        			
        			var areaOfResearchStore = form.findField('areaOfResearch').getStore();
        			areaOfResearchStore.getProxy().extraParams={
        				type:'areaOfResearch'
        			};
        			
        			
        			obj.down('#bloodGroupId').getStore().load();
        			if(this.getCurrentLoggedPortalId() == 7){
        				obj.down('#advisorItemId').setReadOnly(true);
        				obj.down('#admissionDate').setReadOnly(true);
        				 if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
                			 obj.down('#emailId').setReadOnly(true);
                		 }
        				this.disableMoreActionPivileges(obj,this.getPARENT_PERSONAL_DETAILS_PERMISSIONS());
            		}else if(this.getCurrentLoggedPortalId() == 2){
        				this.disableMoreActionPivileges(obj,this.getFACULTY_PORTAL_STUDENT_PERSONAL_DETAILS_PERMISSIONS());
            		}else if(this.getCurrentLoggedPortalId() == 3){
        				this.disableMoreActionPivilegesStudent(obj,this.getSTUDENT_PORTAL_STUDENT_PERSONAL_DETAILS_PERMISSIONS());
            		}else{
            			this.disableMoreActionPivileges(obj,this.getSTUDENT_PERSONAL_DETAILS_PERMISSIONS());
            		}
        			
            	},
            	afterrender: function(obj){
            		var this$ = this;
            		obj.down('button#photoFileImage').setText('Snapshot');
            		var country = obj.down('#countryCombo');
            		if(this$.getCurrentLoggedPortalId() == 3 || this$.getCurrentLoggedPortalId() == 7) {
            			obj.down('#validTill').setVisible(false);
            		}
            		obj.down('#verifyDetail').setVisible(false);
            		
            		if(this$.getCurrentLoggedPortalId() == 1 || this$.getCurrentLoggedPortalId() == 2 || this$.getCurrentLoggedPortalId() == 3) {
            			if(country.allowBlank == false){
            				country.setFieldLabel(getPersonModuleTranslation('HOME_COUNTRY')+ ':<span class="required" style="color:red"> *</span>');
            			}else{
            			
            				country.setFieldLabel(getPersonModuleTranslation('HOME_COUNTRY'));
            			}
            		}
            		
            	}
            },
            
            'personalinformationform[itemId=studentPersonalInformationForm] nestedJsonCombo[itemId=bankNameValue]': {
            	 select: function(obj, newValue) {
                     var form = this.getPersonalInformationForm();
                     var ifscCodeValue = form.down('#ifscCodeValue');
                     ifscCodeValue.reset();      
                     var branchNameValue = form.down('#branchNameValue');
                     branchNameValue.reset();
                     branchNameValue.setDisabled(false);
                     ifscCodeValue.setDisabled(false);
                     var ifscCodeValue= form.down('#ifscCodeValue').getValue();
                     var bankValue=form.down('#bankNameValue').getValue();
                     var ifscCodeValue = form.down('#ifscCodeValue');
                     if(bankValue.length>0){
                    	 	ifscCodeValue.getStore().getProxy().extraParams = {
                        	 bankName:bankValue,
 							}
                    	 	ifscCodeValue.getStore().load();
                    	 	branchNameValue.getStore().getProxy().extraParams = {
                        	 bankName:bankValue,
                    	 	}
                    	 	branchNameValue.getStore().load();}
 	           		}    
             },
              
              'personalinformationform[itemId=studentPersonalInformationForm] nestedJsonCombo[itemId=branchNameValue]': {
            	  select: function(obj, newValue) {
                      var form = this.getPersonalInformationForm();
                      form.down('#ifscCodeValue').setValue(newValue[0].get('code'));
  	           }  
              },
              
              'personalinformationform[itemId=studentPersonalInformationForm] nestedJsonCombo[itemId=ifscCodeValue]': {
            	  select: function(obj, newValue) {
                      var form = this.getPersonalInformationForm();
                      form.down('#branchNameValue').setValue(newValue[0].get('value'));
  				}  
              },
                
            'personalinformationform[itemId=studentPersonalInformationForm] textfield[name=firstName]': {
            	render: function(firstNameField){
            		//this.shortNameOnchangeOfFirstName(firstNameField,'#studentPersonalInformationForm');
            	}
            },
            
            'personalinformationform[itemId=studentPersonalInformationForm] radiogroup#applicantPersonRadioBtnRegisteredBeforeSA':{
           	 change: function (obj, newValue, oldValue) {
        		 var $this = this;
        		    var form = obj.up('personalinformationform');
        		    var allIntakeYear = form.down('#allIntakeYearItemId');
        		    var registeredBeforeSA = form.down('#registeredBeforeSA');
        		    if (newValue.areYouRegisteredAtOtherSAU==true) {
        		    	registeredBeforeSA.setVisible(true);
        		    	registeredBeforeSA.allowBlank = false;
						registeredBeforeSA.setDisabled(false);
        		    	$this.handleRegisteredBeforeSAChange(form, allIntakeYear, true)
        		    } else {
        		    	allIntakeYear.setVisible(false);
        		    	allIntakeYear.allowBlank=true;
        		    	allIntakeYear.setValue(null);
        		    	registeredBeforeSA.setVisible(false);
						registeredBeforeSA.setDisabled(true);
        		    	registeredBeforeSA.allowBlank=true;
        		    	registeredBeforeSA.setValue('');
            			form.isValid();	
        		    }
        		    
        	 }
        	}, 
            
            'personalinformationform[itemId=studentPersonalInformationForm] radiogroup#applicantPersonRadioBtnUwcBefore':{
            	change:function(obj,newValue,oldValue){
            		var form = obj.up('personalinformationform');
            		var uwcBeforeItemId = form.down("#uwcBefore");
            		if (newValue.haveYouStudiedAtUWC==true) {
            			uwcBeforeItemId.setVisible(true);
            			uwcBeforeItemId.setFieldLabel('');
            			uwcBeforeItemId.labelSeparator = '';
            			uwcBeforeItemId.setFieldLabel(getEnquiryTranslation('STUDENT_ID_NUMBER')+ ':<span class="required" style="color:red"> *</span>');
            			uwcBeforeItemId.allowBlank = false;
            			form.isValid();
            		}
            		else
            		{
            			uwcBeforeItemId.setVisible(false);
            			uwcBeforeItemId.allowBlank=true;
            			uwcBeforeItemId.setValue('');
            			form.isValid();	
            		}
            	}
            },
            
            
            'personalinformationform[itemId=studentPersonalInformationForm] textfield[itemId=personCodeField]': {
                blur : function(obj){
                	var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	var personalInformationForm = personProfile.down('#studentPersonalInformationForm');
                	var studentId=personProfile.getUserId();
                	var oldValue = personalInformationForm.getCode();
                	var newValue = personalInformationForm.down('#personCodeField');
                	if(!isNullOrEmpty(newValue)){
                		if(!isNullOrEmpty(newValue.getValue())){
	                		if(newValue.getValue()!=oldValue){
	                			var editUrl = SERVERURL.STUDENT_UNIQUE_CHECK;
		                    	Ext.Ajax.request({
		                    		method: "GET",
		                    		type: 'rest',
		                    		url: editUrl,
		                    		params: {
		                    			code: newValue.getValue()
		                    		},
		                    		success: function(response, action) {
		                    			var resp = Ext.JSON.decode(response.responseText);
		                    			if(resp==false){
		                    				personalInformationForm.down('#personCodeField').setValue(oldValue);
		                    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STUDENT_ID_UNIQUE_ERROR_MSG'));
		                    			}
		                    		}
		                    	})
	                		}
                		}
                		else{
                			personalInformationForm.down('#personCodeField').setValue(oldValue);
                			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('STUDENT_ID_UNIQUE_ERROR_MSG'));
                		}
                	}
                }
            },
            'personalinformationform[itemId=studentPersonalInformationForm] textfield[itemId=admissionIdIteamId]': {
                blur : function(obj){
                	var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	var studentId =personProfile.getUserId();
                	var personalInformationForm = personProfile.down('#studentPersonalInformationForm');
                	var admissionCodeHiddenField = personalInformationForm.down('#admissionCodeIteamId');
                	var oldValue = admissionCodeHiddenField.getValue();
                	var newValue = personalInformationForm.down('#admissionIdIteamId');
                	if(!isNullOrEmpty(newValue)){
                		if(!isNullOrEmpty(newValue.getValue())){
	                		if(newValue.getValue()!=oldValue){
	                			var editUrl = SERVERURL.PATH_ADMISSION_NUMBER_CODE_UNIQUENESS;
		                    	Ext.Ajax.request({
		                    		method: "GET",
		                    		type: 'rest',
		                    		url: editUrl,
		                    		params: {
		                    			admissionCode: newValue.getValue(),
		                    			studentId: studentId
		                    		},
		                    		success: function(response, action) {
		                    			var resp = Ext.JSON.decode(response.responseText);
		                    			if(resp==false){
		                    				personalInformationForm.down('#admissionIdIteamId').setValue(oldValue);
		                    				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('ADMISSION_ID_UNIQUE_ERROR_MSG'));
		                    			}
		                    		}
		                    	})
	                		}
                		}
                		else{
                			personalInformationForm.down('#admissionIdIteamId').setValue(oldValue);
                		}
                	}
                }
            },
    		'personalinformationform[itemId=studentPersonalInformationForm] button[itemId=verifyDetail]': {
    			click: function(obj) {
    				//personType = obj.up().up().up().personType;
    					var $this = this;
    					var personalInformationForm = obj.up('personalinformationform');
    					if(personalInformationForm){
    						var data = personalInformationForm.getValues()
    					}
    					var nationalId = data.nationalID;
    					var Url = SERVERURL.VERIFY_NATIONAL_ID;
    					Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    					if(!isNullOrEmpty(nationalId)){
    						Ext.Ajax.request({
    							type: 'rest',
    							url: Url+'?identityNumber='+nationalId,
    							method: 'GET',
    							success : function(response, action){
    								Ext.getBody().unmask();
    								var responseData = Ext.JSON.decode(response.responseText);
    								 //var id = parseInt(XMLHttpRequestObject.responseText);
    								if(responseData.message!='Not Found' && responseData.citizenship!=null)
    								{
    								//var getIDWindow='';
    		    					//getIDWindow = $this.getStudentIdVerificationDetailWin();
    		    					//if (!getIDWindow) {
    									var getIDWindow =Ext.widget('idverificationdetailwin',{
  										   itemId:'studentIdVerificationDetailWinItemId'
  									   });
    		    						//getIDWindow = $this.getStudentIdVerificationDetailWin();
    		    					//}
    		    					getIDWindow.show();
    		    					//getFormWindow = formWindow.getForm();
    	    						getIDWindow.down('#userFirstName').setValue(data.firstName);
    	    						getIDWindow.down('#userLastName').setValue(data.lastName);
    	    						getIDWindow.down('#userGender').setValue(data.gender);
    	    						getIDWindow.down('#userDOB').setValue(dateRender(data.birthDate));
    								
    								var nationalityCombo =  personalInformationForm.down("#nationalityCombo");
    								var matched = '<span style="color:green">Matched</span>';
    								var notMatched = '<span style="color:red">Not Matched</span>';
    							
    								if(!isNullOrEmpty(nationalityCombo.getRawValue())){
    									getIDWindow.down('#userCitizenship').setValue(nationalityCombo.getRawValue());
    								}
    								if(responseData.citizenship.toUpperCase() == nationalityCombo.getRawValue().toUpperCase())
    								{
    									getIDWindow.down('#citizenshipStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#citizenshipStatus').setValue(notMatched);
    								}
    								if(responseData.firstNames.toUpperCase() == data.firstName.toUpperCase() && responseData.surname.toUpperCase() == data.lastName.toUpperCase() &&
    										responseData.gender.toUpperCase() == data.gender.toUpperCase() &&
    										dateRender(responseData.dateOfBirth) == data.birthDate && responseData.citizenship.toUpperCase() == nationalityCombo.getRawValue().toUpperCase())
    								{
    									getIDWindow.down('#verifiedNote').setValue(getPersonModuleTranslation('VERIFIED_NOTE'));

    								}else
    								{
    									getIDWindow.down('#verifiedNote').setValue(getPersonModuleTranslation('NOT_VERIFIED_NOTE'));
    								}
    								
    								getIDWindow.down('#dbFirstName').setValue(responseData.firstNames);
    								getIDWindow.down('#dbLastName').setValue(responseData.surname);
    								getIDWindow.down('#dbGender').setValue(responseData.gender);
    								getIDWindow.down('#dbDOB').setValue(dateRender(responseData.dateOfBirth));
    								getIDWindow.down('#dbCitizenship').setValue(responseData.citizenship);
    								if(responseData.firstNames.toUpperCase() == data.firstName.toUpperCase())
    								{
    									getIDWindow.down('#firstNameStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#firstNameStatus').setValue(notMatched);
    								}
    								if(responseData.surname.toUpperCase() == data.lastName.toUpperCase())
    								{
    									getIDWindow.down('#lastNameStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#lastNameStatus').setValue(notMatched);
    								}
    								if(responseData.gender.toUpperCase() == data.gender.toUpperCase())
    								{
    									getIDWindow.down('#genderStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#genderStatus').setValue(notMatched);
    								}
    								if(dateRender(responseData.dateOfBirth) == data.birthDate)
    								{
    									getIDWindow.down('#dobStatus').setValue(matched);
    								}else
    								{
    									getIDWindow.down('#dobStatus').setValue(notMatched);
    								}
    								
    							}else{
    								showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('GET_RECORD_NOT_FOUND'));
    							}

    							}
    						});
    					}
    			}		
    		},
    		'personalinformationform[itemId=studentPersonalInformationForm] button[itemId=stopBtn]': {
            	click: function(obj){
    				this.addMultipleLanguage(obj);
    			}          
            },
            'personalinformationform[itemId=studentPersonalInformationForm] button[itemId=languageDeleteButton1]':{
    			click : function(deleteButton) {
   				 	this.deleteLanguageCompentecny(deleteButton);
   			 	}
            },
            'personalinformationform[itemId=studentPersonalInformationForm] [itemId=employeeLanguage]': {
            	select: function(combo, record) {
                	var newValue = record[0].data.id;
                	var personProfile = this.getContentPanelActiveTab();
            		if(personProfile) {
	            		var form = personProfile.down('personalinformationform');
                    	this.onSelectionLanguage(combo, record,form);
            		}
            	}               
            },
    		'personalinformationform[itemId=studentPersonalInformationForm] customcombobox[itemId=cellCountryCode]': {
    			select: function(rowModel, record){
    				var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	var form = personProfile.down('#studentPersonalInformationForm');
                	var countryCodeField = form.down("#cellCountryCode");
                 	var mobileField = form.down("#mobileNumber");
                 	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
    			}
    		},
    		'personalinformationform[itemId=studentPersonalInformationForm] customcombobox[itemId=phoneCountryCode]': {
    			select: function(rowModel, record){
    				var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	var form = personProfile.down('#studentPersonalInformationForm');
                	var countryCodeField = form.down("#phoneCountryCode");
                 	var phoneNoField = form.down("#phoneNoField");
                 	this$.setMaximumMinimumDigitsForPhoneNoValidation(form,countryCodeField,phoneNoField,record);
    			}
    		},
    		'personalinformationform[itemId=studentPersonalInformationForm] numberfield[itemId=mobileNumber]': {
    			change: function(record){
    				var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	
                	try{
                    	if((portalId == 3 || portalId == 7) && personProfile.xtype == "dashboardhomepage"){
                    		var contentPanel = this$.getContentPanel();
                    		var personProfile = contentPanel.items.items[1];
                    	}
                	}
                	catch(e){
                		//
                	}
                	
                	var form = personProfile.down('#studentPersonalInformationForm');
                	var mobileField = form.down("#mobileNumber");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
    		},
    		'personalinformationform[itemId=studentPersonalInformationForm] numberfield[itemId=phoneNoField]': {
    			change: function(record){
    				var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	
                	try{
                    	if((portalId == 3 || portalId == 7) && personProfile.xtype == "dashboardhomepage"){
                    		var contentPanel = this$.getContentPanel();
                    		var personProfile = contentPanel.items.items[1];
                    	}
                	}
                	catch(e){
                		//
                	}
                	
                	var form = personProfile.down('#studentPersonalInformationForm');
                	var phoneNoField = form.down("#phoneNoField");
                	phoneNoField.isValid();
        			form.getForm().checkValidity();
                }
    		},
    		'personalinformationform[itemId=studentPersonalInformationForm] customcombobox[itemId=alternateCellCountryCode]': {
    			select: function(rowModel, record){
    				var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	
                	try{
                    	if((portalId == 3 || portalId == 7) && personProfile.xtype == "dashboardhomepage"){
                    		var contentPanel = this$.getContentPanel();
                    		var personProfile = contentPanel.items.items[1];
                    	}
                	}
                	catch(e){
                		//
                	}
                	
                	var form = personProfile.down('#studentPersonalInformationForm');
                	var countryCodeField = form.down("#alternateCellCountryCode");
                 	var mobileField = form.down("#alternateMobileNumber");
                 	this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
    			}
    		},
    		'personalinformationform[itemId=studentPersonalInformationForm] numberfield[itemId=alternateMobileNumber]': {
    			change: function(record){
    				var this$ = this;
                	var personProfile = this$.getContentPanelActiveTab();
                	
                	try{
                    	if((portalId == 3 || portalId == 7) && personProfile.xtype == "dashboardhomepage"){
                    		var contentPanel = this$.getContentPanel();
                    		var personProfile = contentPanel.items.items[1];
                    	}
                	}
                	catch(e){
                		//
                	}
                	
                	var form = personProfile.down('#studentPersonalInformationForm');
                	var mobileField = form.down("#alternateMobileNumber");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
    		},
            'idverificationdetailwin[itemId=studentIdVerificationDetailWinItemId] button[itemId=okBtn]':{
            	click: function(obj) {
            		var studentIdVerifiedForm = obj.up().up();
            		studentIdVerifiedForm.close();
            	}
            },
            
        	/**
        	 * Personal Information
        	 */
            'studentprofile personalinformationform[itemId=studentPersonalInformationForm]': {
                afterrender: function(form){
                	this.onRenderStudentPersonalInformationForm();
                }
            },
            
            'studentprofile personalinformationform[itemId=studentPersonalInformationForm] photouploadform[itemId=studentPhotoUploadForm] filefield[itemId=photoFileImage]': {
                change: function(photoFileImage, value, eOpts) {
//                    this.saveStudentPersonPhotoUpload(photoFileImage);
                	var $this=this;
                	value = value.replace('C:\\fakepath\\', '');
                	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                	photoFileImage.setRawValue(newValue);
                	 var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
              	    if ($this.isValidImageExtension(extension)) {
              	        var file = photoFileImage.fileInputEl.dom.files[0];
              	      
              	        if (file.size/1048576>=1) {
              	        	photoFileImage.reset();
              	            showWarningMessage(getPersonModuleTranslation('PERSONAL_DETAILS'), getCommonTranslation('FILE_SIZE_ONE_MB_ERROR_MSG'));
              	        }
              	    } else {
              	    	photoFileImage.reset();
              	        showWarningMessage(getPersonModuleTranslation('PERSONAL_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
              	    }
                }
            },
            'studentprofile personalinformationform[itemId=studentPersonalInformationForm] button[itemId=profilePhotoRemove]': {
                click: function(obj) {
					this.removeStudentProfilePhoto(obj);
                }
            },
            'studentprofile personalinformationform[itemId=studentPersonalInformationForm] button[itemId=personalInfoSaveButtonId]': {
                click: function(obj){
                	this.saveStudentPersonalInformation(obj);
                }
            },
            
            'studentprofile personalinformationform[itemId=studentPersonalInformationForm] textfield[name=firstName]': {
            	change: function(firstNameField){
            		var personProfile = this.getContentPanelActiveTab();
            		
            		try{
                    	if((portalId == 3 || portalId == 7) && personProfile.xtype == "dashboardhomepage"){
                    		var contentPanel = this$.getContentPanel();
                    		var personProfile = contentPanel.items.items[1];
                    	}
                	}
                	catch(e){
                		//
                	}
            		
            		var applicationStatus = personProfile.getApplicationInfo()['applicationStatus'];
            		this.shortNameOnchangeOfFirstName(firstNameField,'#studentPersonalInformationForm',applicationStatus);
            		this.setPrintNameValue(firstNameField);
            	}
            },
            'studentprofile personalinformationform[itemId=studentPersonalInformationForm] textfield[name=middleName]': {
            	change: function(textfield){
            		this.setPrintNameValue(textfield);
            	}
            },
            'studentprofile personalinformationform[itemId=studentPersonalInformationForm] textfield[name=lastName]': {
            	change: function(textfield){
            		this.setPrintNameValue(textfield);
            	}
            },
            'studentprofile personalinformationform[itemId=studentPersonalInformationForm] textfield[name=firstNameOtherLanguage]': {
            	change: function(firstNameField){
            		var personProfile = this.getContentPanelActiveTab();
            		
            		try{
                    	if((portalId == 3 || portalId == 7) && personProfile.xtype == "dashboardhomepage"){
                    		var contentPanel = this$.getContentPanel();
                    		var personProfile = contentPanel.items.items[1];
                    	}
                	}
                	catch(e){
                		//
                	}
            		
            		var applicationStatus = personProfile.getApplicationInfo()['applicationStatus'];
            		this.shortNameOtherLnguageOnchangeOfFirstName(firstNameField,'#studentPersonalInformationForm',applicationStatus);
            		this.setPrintNameOtherLnguageValue(firstNameField);
            	}
            },
            'studentprofile personalinformationform[itemId=studentPersonalInformationForm] textfield[name=middleNameOtherLanguage]': {
            	change: function(textfield){
            		this.setPrintNameOtherLnguageValue(textfield);
            	}
            },
            'studentprofile personalinformationform[itemId=studentPersonalInformationForm] textfield[name=lastNameOtherLanguage]': {
            	change: function(textfield){
            		this.setPrintNameOtherLnguageValue(textfield);
            	}
            },
            
            /**
        	 * Personal Information for student portal
        	 */
            'personinfostudentportal personalinformationform[itemId=studentPersonalInformationForm], stcpncstudentregistration personalinformationform[itemId=studentPersonalInformationForm]': {
                afterrender: function(form){
                	this.onRenderStudentPersonalInformationForm();
                }
            },
            'personinfostudentportal personalinformationform[itemId=studentPersonalInformationForm] combo, stcpncstudentregistration personalinformationform[itemId=studentPersonalInformationForm] combo': {
                render: function(combo) {
                	//var portalId = this.getCurrentLoggedPortalId();
                    //if(portalId != 3 && portalId != 7){
                    	if(combo.up('stcpncstudentregistration') && (combo.itemId=="currentOrLastSchoolAttended" || combo.itemId=="advisorItemId" || combo.itemId=="armsOfService"
                    		   || combo.itemId=="cellCountryCode" || combo.itemId=="alternateCellCountryCode" || combo.itemId=="phoneCountryCode" || combo.itemId=="countryCombo"
                    			   || combo.itemId=="emergencyMobileCountryCode" || combo.itemId=="readItemId" || combo.itemId=="writeItemId" || combo.itemId=="speakItemId")){
                    		//--not loading unnecessary store
                    	}
                    	else if(combo.getStore().isLoading() || combo.getStore().getCount()){
                    		// do nothing if store already loaded or store is loading
                    	}
                    	else{
                            combo.getStore().load();
                    	}
                    //}	
                }
            },
            'personinfostudentportal personalinformationform[itemId=studentPersonalInformationForm] combo, stcpncstudentregistration personalinformationform[itemId=studentPersonalInformationForm] nestedJsonCombo#sadcCitizenship': {
               afterrender: function(combo) {
            	   var portalId = this.getCurrentLoggedPortalId();
            	   var this$ = this;
            	   if(portalId != 3 && portalId != 7){
            		   	if(combo.getStore().isLoading() || combo.getStore().getCount()){
	                   		// do nothing if store already loaded or store is loading
	                   	}
	                   	else{
	                   		combo.getStore().load();
	                   	}
                   }
                    
                }
            },
            'personinfostudentportal personalinformationform[itemId=studentPersonalInformationForm] photouploadform[itemId=studentPhotoUploadForm] filefield[itemId=photoFileImage], stcpncstudentregistration personalinformationform[itemId=studentPersonalInformationForm] photouploadform[itemId=studentPhotoUploadForm] filefield[itemId=photoFileImage]': {
                change: function(photoFileImage, value, eOpts) {
                	value = value.replace('C:\\fakepath\\', '');
                	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                	photoFileImage.setRawValue(newValue);
                }
            },
            'personinfostudentportal personalinformationform[itemId=studentPersonalInformationForm] button[itemId=personalInfoSaveButtonId], stcpncstudentregistration personalinformationform[itemId=studentPersonalInformationForm] button[itemId=personalInfoSaveButtonId]': {
                click: function(obj){
                	this.saveStudentPersonalInformation(obj);
                }
            },
            'personinfostudentportal personalinformationform[itemId=studentPersonalInformationForm] button[itemId=profilePhotoRemove]': {
                click: function(obj) {
                	this.removeStudentProfilePhoto(obj);
                }
            },
            'personalinformationform[itemId=studentPersonalInformationForm] textfield[name=middleName]': {
            	change: function(textfield){
            		this.setPrintNameValue(textfield);
            	}
            },
            'personalinformationform[itemId=studentPersonalInformationForm] textfield[name=lastName]': {
            	change: function(textfield){
            		this.setPrintNameValue(textfield);
            	}
            },
            'personalinformationform[itemId=studentPersonalInformationForm] textfield[name=middleNameOtherLanguage]': {
            	change: function(textfield){
            		this.setPrintNameOtherLnguageValue(textfield);
            	}
            },
            'personalinformationform[itemId=studentPersonalInformationForm] textfield[name=lastNameOtherLanguage]': {
            	change: function(textfield){
            		this.setPrintNameOtherLnguageValue(textfield);
            	}
            },
            'personalinformationform[itemId=studentPersonalInformationForm] combo[itemId=currentEducationalInterventionsItemId]': {
                select: function(combo, records, eOpts) {
                    var code = records[0].data.code;
                    var form = combo.up('personalinformationform');
                    var specifyOtherItemId = form.down("#specifyOtherItemId");
                    if (code == 'OTHER') {
                        specifyOtherItemId.setVisible(true);
                        specifyOtherItemId.allowBlank = false;
                    } else {
                        specifyOtherItemId.setVisible(false);
                        specifyOtherItemId.allowBlank = true;
                    }
                    specifyOtherItemId.reset();
                    form.isValid();
                }
            },
             
             'personalinformationform[itemId=studentPersonalInformationForm] combo[itemId=armsOfService]': {
               	 select:function(obj1,records) {
               	  var musteringComboBox = obj1.up('form').down('customcombobox#mustering');
                  var armsOfServiceComboBox = obj1.up('form').down('customcombobox#armsOfService');
                	musteringComboBox.setDisabled(false);
                	musteringComboBox.reset();
                  
                  var armsOfServiceIdVal = records[0].get("id");
                  //var countryIdVal = armsOfServiceComboBox.getValue();
                  var musteringStore = musteringComboBox.getStore();
                  musteringStore.getProxy().extraParams = {
                	  armsOfServiceId: armsOfServiceIdVal
                  };
                  musteringStore.reload();
               	 }
               },
              
            
            /**
             * Address Details
             */
            'addressdetails[itemId=studentAddressDetails]': {
            	render: function(obj){
            		this.getPersonAddressDetailTemplateData('#studentAddressDetails', 'SELF_ADDRESS', SERVERURL.PERSON_GET_PERSON_ADDRESS_DETAILS);
            	}
            },
            
            "addressdetails[itemId=studentAddressDetails] combo[itemId=addressCombo]": {
                select: function(){
                	this.onSelectionPersonAddressTypeCombo('#studentAddressDetails', SERVERURL.PERSON_FIND_RELATED_PERSON_ID, SERVERURL.PERSON_GET_PERSON_ADDRESS_DETAILS);
                }
            },
            'addressformwindow[itemId=studentAddressWindow]': {
                render: function(obj){
                	obj.down('#otherAddressTypeItemId').show();
                	obj.down('#parentCountryRegionId').setDisabled(true);
                	obj.down('#cityId').setDisabled(true);
                	obj.down('#pincodeNewId').setDisabled(true);
                }
            },
            'addressformwindow[itemId=studentAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]': {             
            	afterrender: function(obj){
            		var country = this.getPersonAddressFieldsForm().down('#countryId');
            	    var me = this;        		
            		if(this.getCurrentLoggedPortalId() == 1 || this.getCurrentLoggedPortalId() == 2 || this.getCurrentLoggedPortalId() == 3) {
            			country.setFieldLabel(getPersonModuleTranslation('ADDRESS_COUNTRY'));
            		}
            		var getPinCodeUrl = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
            		Ext.Ajax.request({
                        type: 'rest',
                        url: getPinCodeUrl,
                        method: 'GET',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        success: function(res, action) {
                        	var data = res.responseText;
                        	if(!isNullOrEmpty(data)){
                        		me.getPersonAddressFieldsForm().down('#pincodeNewId').setVisible(true);
                        		me.getPersonAddressFieldsForm().down('#pincodeId').setVisible(false);
                        		me.getPersonAddressFieldsForm().down('#pincodeId').disable();
                        		if(me.getPersonAddressFieldsForm().down('#pincodeNewId').defaultVal){
                            		me.getPersonAddressFieldsForm().down('#pincodeNewId').setValue(me.getPersonAddressFieldsForm().down('#pincodeNewId').defaultVal);
                            	}
                        	}else{
                        		me.getPersonAddressFieldsForm().down('#pincodeNewId').setVisible(false);
                        		me.getPersonAddressFieldsForm().down('#pincodeNewId').disable();
                        		me.getPersonAddressFieldsForm().down('#pincodeId').setVisible(true);
                        		if(me.getPersonAddressFieldsForm().down('#pincodeId').defaultVal){
                            		me.getPersonAddressFieldsForm().down('#pincodeId').setValue(me.getPersonAddressFieldsForm().down('#pincodeId').defaultVal);
                            	}
                        	}
                        }
                    });
            		
            		// please do not uncomment this code 
            		/*if(this.getCurrentLoggedPortalId() == 3){
				      var form  = this.getPersonAddressFieldsForm();
			     	  Ext.defer(function(){
				      me.hideFields(form);
				      },500);
				    }*/
            	 }
            },
            'addressformwindow[itemId=studentAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  combo#genericFieldId1': {
                select: function(combo, record) {
                    this.onSelectionGenericField(combo, record, this.getPersonAddressFieldsForm());
                }
            },
            'addressformwindow[itemId=studentAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  combo#countryId': {
                select: function(combo, record) {
                	var newValue = record[0].data.id;
                	this.onChangeCountry(combo, newValue, this.getPersonAddressFieldsForm());
                    this.onSelectionCountry(combo, record, this.getPersonAddressFieldsForm());
                    var regionComboBox = combo.up('form').down('customcombobox#parentCountryRegionId');
                	regionComboBox.setDisabled(false);
                    var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	var phoneCountryCode = form.down("#phoneCountryCode");
                	var phoneNoField = form.down("#phoneNoField");
                	 setTimeout(function(){
                		var pincodeId = form.down("#pincodeId");
                     	pincodeId.reset();
                     	pincodeId.setDisabled(true);
                     	var pincodeNewId = form.down("#pincodeNewId");
                     	pincodeNewId.clearValue();
                     	pincodeNewId.setDisabled(true);
                 	},100);
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);

                }//,
				//V2D-96112
//                change: function(combo, newValue) {
//                    this.onChangeCountry(combo, newValue, this.getPersonAddressFieldsForm());
//                }
            },
            'addressformwindow[itemId=studentAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#parentCountryRegionId': {
            	select: function(obj1, record) {
            		var cityComboBox = obj1.up('form').down('customcombobox#cityId');
            		cityComboBox.setDisabled(false);
            		cityComboBox.reset();
            		var form = this.getPersonAddressFieldsForm();
            		var phoneCountryCode = form.down("#phoneCountryCode");
            		var phoneNoField = form.down("#phoneNoField");
            		setTimeout(function(){
            			var pincodeId = form.down("#pincodeId");
            			pincodeId.reset();
            			pincodeId.setDisabled(true);
            			var pincodeNewId = form.down("#pincodeNewId");
            			pincodeNewId.clearValue();
            			pincodeNewId.setDisabled(true);
            		},100);
            		this.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
            		var countryRegion1 = record[0].get("id");
            		var store = cityComboBox.getStore();
            		store.getProxy().extraParams = {
            			id: countryRegion1
            		};
            		store.reload();
            	},
                change: function(obj1, newValue) {
                    var cityComboBox = obj1.up('form').down('customcombobox#cityId');
                    if(!isNullOrEmpty(newValue)){                   
                    cityComboBox.setDisabled(false);
                    }else{
                        cityComboBox.setDisabled(true); 
                    }
               }
            },
            'addressformwindow[itemId=studentAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#cityId': {
                select: function(obj1, record) {
                	var me = this;
                	 var city = record[0].get("id");
                	 var getPinCodeUrl1 = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
                	Ext.Ajax.request({
                        type: 'rest',
                        url: getPinCodeUrl1,
                        method: 'GET',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        params: {
                            id: city
                        },
                        success: function(res, action) {
                        	var data = res.responseText;
                        	if(!isNullOrEmpty(data) && data !="[]"){
                        		obj1.up('form').down('customcombobox#pincodeNewId').setVisible(true);
                        		obj1.up('form').down('textfield#pincodeId').setVisible(false);
                        		obj1.up('form').down('textfield#pincodeId').disable();
                        		obj1.up('form').down('customcombobox#pincodeNewId').setDisabled(false);
                        		setTimeout(function(){
                        			obj1.up('form').down('customcombobox#pincodeNewId').reset();
                            		obj1.up('form').down('customcombobox#pincodeNewId').clearValue();
                            	},100);
                        		var form = me.getPersonAddressFieldsForm();
                            	var phoneCountryCode = form.down("#phoneCountryCode");
                            	var phoneNoField = form.down("#phoneNoField");
                            	me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
                                var store = obj1.up('form').down('customcombobox#pincodeNewId').getStore();
                                 store.getProxy().extraParams = {
                                     id: city
                                 };
                                 store.reload();
                        	}else{
                        		obj1.up('form').down('customcombobox#pincodeNewId').setVisible(false);
                        		obj1.up('form').down('customcombobox#pincodeNewId').disable();
                        		obj1.up('form').down('textfield#pincodeId').setVisible(true);
                        		obj1.up('form').down('textfield#pincodeId').setDisabled(false);
                        		obj1.up('form').down('textfield#pincodeId').reset();
                        		var form = me.getPersonAddressFieldsForm();
                            	var phoneCountryCode = form.down("#phoneCountryCode");
                            	var phoneNoField = form.down("#phoneNoField");
                            	me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
                        	}
                        }
                    });
                },
                change: function(obj1, newValue) {
                	var cityPinCodeTextBox = obj1.up('form').down('textfield#pincodeId');
                	var cityPinCodeComboBox = obj1.up('form').down('customcombobox#pincodeNewId');
                	if(!isNullOrEmpty(newValue)){                   
                		cityPinCodeComboBox.setDisabled(false);
                		cityPinCodeTextBox.setDisabled(false);
                	}else{
                		cityPinCodeTextBox.setDisabled(true);
                		cityPinCodeTextBox.reset();
                		cityPinCodeComboBox.setDisabled(true); 
                		cityPinCodeComboBox.clearValue();
                	}
                	var me = this;
                	if(!isNullOrEmpty(newValue) && isNumberValidate(newValue)){
                   		var city = newValue;
                   	}else{
                   		var city = '';
                   	}
                	var getPinCodeUrl1 = SERVERURL.PATH_FIND_ALL_PINCODES_BY_CITY_ID;
                	Ext.Ajax.request({
                		type: 'rest',
                		url: getPinCodeUrl1,
                		method: 'GET',
                		headers: {
                			'Content-Type': 'application/json'
                		},
                		params: {
                			id: city
                		},
                		success: function(res, action) {
                			var data = res.responseText;
                			if(!isNullOrEmpty(data) && data !="[]"){
                				obj1.up('form').down('customcombobox#pincodeNewId').setVisible(true);
                				obj1.up('form').down('textfield#pincodeId').setVisible(false);
                				obj1.up('form').down('customcombobox#pincodeNewId').setDisabled(false);
                				var form = me.getPersonAddressFieldsForm();
                				var phoneCountryCode = form.down("#phoneCountryCode");
                				var phoneNoField = form.down("#phoneNoField");
                				me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
                				var store = obj1.up('form').down('customcombobox#pincodeNewId').getStore();
                				store.getProxy().extraParams = {
                					id: city
                				};
                				store.reload();
                			}else{
                				obj1.up('form').down('customcombobox#pincodeNewId').setVisible(false);
                				obj1.up('form').down('textfield#pincodeId').setVisible(true);
                				obj1.up('form').down('textfield#pincodeId').setDisabled(false);
                				var form = me.getPersonAddressFieldsForm();
                				var phoneCountryCode = form.down("#phoneCountryCode");
                				var phoneNoField = form.down("#phoneNoField");
                				me.setMaximumMinimumDigitsForPhoneNoValidation(form, phoneCountryCode, phoneNoField, null);
                			}
                		}
                	});
                }
            },
            'addressformwindow[itemId=studentAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#cellCountryCode': {
                select: function(rowModel, record) {
                	var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, record);
                }
            },
            'addressformwindow[itemId=studentAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  customcombobox#phoneCountryCode': {
                select: function(rowModel, record) {
                	var form = this.getPersonAddressFieldsForm();
                	var countryCodeField = form.down("#phoneCountryCode");
                	var phoneNoField = form.down("#phoneNoField");
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, record);
                }
            },
            'addressformwindow[itemId=studentAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  numberfield#cellNo': {
                change: function(record) {
                	var form = this.getPersonAddressFieldsForm();
                	var mobileField = form.down("#cellNo");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'addressformwindow[itemId=studentAddressWindow] addressfieldsform[itemId=personAddressFieldsForm]  numberfield#phoneCountryCode': {
                change: function(record) {
                	var form = this.getPersonAddressFieldsForm();
                	var phoneNoField = form.down("#phoneCountryCode");
                	phoneNoField.isValid();
        			form.getForm().checkValidity();
                }
            },
            /*"addressdetails[itemId=studentAddressDetails] button#printPersonalAddress1": {
                click: function() {
                    var addressDisplayField = this.getPersonAddressDetails().down('displayfield#personAddressDisplayField1');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "addressdetails[itemId=studentAddressDetails] button#printPersonalAddress2": {
                click: function() {
                    var addressDisplayField = this.getPersonAddressDetails().down('displayfield#personAddressDisplayField2');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "addressdetails[itemId=studentAddressDetails] button#printPersonalAddress3": {
                click: function() {
                    var addressDisplayField = this.getPersonAddressDetails().down('displayfield#personAddressDisplayField3');
                    this.onPrintClick(addressDisplayField);
                }
            },
            "addressdetails[itemId=studentAddressDetails] button#printPersonalAddress4": {
                click: function() {
                    var addressDisplayField = this.getPersonAddressDetails().down('displayfield#personAddressDisplayField4');
                    this.onPrintClick(addressDisplayField);
                }
            },*/
            "addressdetails[itemId=studentAddressDetails] button#modifyPersonalAddress1": {
                click: function(btn) {
                	if(!preventMultipleCalls(btn)){
                		return false;
                	}
                    this.onModifyClick("displayfield#personAddressDisplayField1", "#studentAddressDetails", "studentAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                    this.setDefaultCountryNameMapWithAL(form);
                  //  this.onSelectionCountry(combo, record, form);
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                	if (form.down('#cityId').getValue()!= null && form.down('#cityId').getValue() > 0) {
                		form.down('#cityId').setDisabled(false);
					}
                	if (form.down('#parentCountryRegionId').getValue()!= null && form.down('#parentCountryRegionId').getValue() > 0) {
                		form.down('#parentCountryRegionId').setDisabled(false);
					}
                	if (form.down('#pincodeNewId').getValue()!= null && form.down('#pincodeNewId').getValue() > 0) {
                		form.down('#pincodeNewId').setDisabled(false);
					}
                }
            },
            "addressdetails[itemId=studentAddressDetails] button#modifyPersonalAddress2": {
                click: function() {
                    this.onModifyClick("displayfield#personAddressDisplayField2", "#studentAddressDetails", "studentAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                    this.setDefaultCountryNameMapWithAL(form);
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                	if (form.down('#cityId').getValue()!= null && form.down('#cityId').getValue() > 0) {
                		form.down('#cityId').setDisabled(false);
					}
                	if (form.down('#parentCountryRegionId').getValue()!= null && form.down('#parentCountryRegionId').getValue() > 0) {
                		form.down('#parentCountryRegionId').setDisabled(false);
					}
                	if (form.down('#pincodeNewId').getValue()!= null && form.down('#pincodeNewId').getValue() > 0) {
                		form.down('#pincodeNewId').setDisabled(false);
					}
                }
            },
            "addressdetails[itemId=studentAddressDetails] button#modifyPersonalAddress3": {
                click: function() {
                    this.onModifyClick("displayfield#personAddressDisplayField3", "#studentAddressDetails", "studentAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                    this.setDefaultCountryNameMapWithAL(form);
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                	if (form.down('#cityId').getValue()!= null && form.down('#cityId').getValue() > 0) {
                		form.down('#cityId').setDisabled(false);
					}
                	if (form.down('#parentCountryRegionId').getValue()!= null && form.down('#parentCountryRegionId').getValue() > 0) {
                		form.down('#parentCountryRegionId').setDisabled(false);
					}
                	if (form.down('#pincodeNewId').getValue()!= null && form.down('#pincodeNewId').getValue() > 0) {
                		form.down('#pincodeNewId').setDisabled(false);
					}
                }
            },
            "addressdetails[itemId=studentAddressDetails] button#modifyPersonalAddress4": {
                click: function(btn) {
                	if(!preventMultipleCalls(btn)){
                		return false;
                	}
                    this.onModifyClick("displayfield#personAddressDisplayField4", "#studentAddressDetails", "studentAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                    this.setDefaultCountryNameMapWithAL(form);
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                	if (form.down('#cityId').getValue()!= null && form.down('#cityId').getValue() > 0) {
                		form.down('#cityId').setDisabled(false);
					}
                	if (form.down('#parentCountryRegionId').getValue()!= null && form.down('#parentCountryRegionId').getValue() > 0) {
                		form.down('#parentCountryRegionId').setDisabled(false);
					}
                	if (form.down('#pincodeNewId').getValue()!= null && form.down('#pincodeNewId').getValue() > 0) {
                		form.down('#pincodeNewId').setDisabled(false);
					}
                }
            },
            "addressdetails[itemId=studentAddressDetails] button#modifyPersonalAddress5": {
                click: function(btn) {
                	if(!preventMultipleCalls(btn)){
                		return false;
                	}
                    this.onModifyClick("displayfield#personAddressDisplayField5", "#studentAddressDetails", "studentAddressWindow");
                    var form = this.getPersonAddressFieldsForm();
                    this.setDefaultCountryNameMapWithAL(form);
                	var countryCodeField = form.down("#cellCountryCode");
                	var mobileField = form.down("#cellNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form, countryCodeField, mobileField, null);
                	if (form.down('#cityId').getValue()!= null && form.down('#cityId').getValue() > 0) {
                		form.down('#cityId').setDisabled(false);
					}
                	if (form.down('#parentCountryRegionId').getValue()!= null && form.down('#parentCountryRegionId').getValue() > 0) {
                		form.down('#parentCountryRegionId').setDisabled(false);
					}
                	if (form.down('#pincodeNewId').getValue()!= null && form.down('#pincodeNewId').getValue() > 0) {
                		form.down('#pincodeNewId').setDisabled(false);
					}
                }
            },
            'addressformwindow[itemId=studentAddressWindow] button[itemId=submitButtonId]': {
                click: this.saveStudentAddressDetails
            },
            'addressformwindow[itemId=studentAddressWindow] button[itemId=cancelButtonId]': {
                click: function() {
                	this.getPersonAddressFormWindow().close();
                }
            },
            
            /**
             * Parent Guardian Details
             * 
             */

            'parentguardiangrid[itemId=studentParentGuardianGrid]': {
            	render: function(grid) {
            		var me = this;
                    this.loadGridStore('#studentParentGuardianGrid', SERVERURL.PARENT_AND_GUARDIAN_DETAILS);
                    
                    var itemIdPrivilegeNameArray = [{"#btnExportToPDFJasper" : "EXPORT" },{"#btnExportToExcelJasper" : "EXPORT" }];
                    if(portalId==1){
        				me.disableRadioGroupAndOtherPivileges(grid, me.getSTUDENT_PARENTS_GUARDIANS_PERMISSIONS(), itemIdPrivilegeNameArray);
        			} else if(portalId==2){
        				me.disableRadioGroupAndOtherPivileges(grid, me.getFACULTY_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS(), itemIdPrivilegeNameArray);
        			} else if(portalId==7){
            			me.disableRadioGroupAndOtherPivileges(grid, me.getPARENT_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS(), itemIdPrivilegeNameArray);
            		} else if(portalId==3) {
            				me.disableRadioGroupAndOtherPivileges(grid, me.getSTUDENT_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS(), itemIdPrivilegeNameArray);
            		}
                    

                    //-- New Card Layout for Parent Guardian Screen
                    var gridStore = grid.getStore();
                    var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Please wait..."});
            		myMask.show();
                    
                	var relationShipStore = Ext.getStore('common.RelationshipStore');
                	relationShipStore.clearFilter(true);
                	relationShipStore.filter({
                        filterFn: function(record) {
                            var flag = true;
                            if (record.get('name') == 'BROTHER' || record.get('name') == 'SISTER') {
                                flag = false;
                            } else {
                                flag = true;
                            }
                            return flag;
                        }
                    }, this);
            		gridStore.on('load', function(){
        				var parentguardiancardlayoutview = me.getContentPanel().getActiveTab().down('parentguardiancardlayoutview');
    					relationShipStore.load();
        				/*-----Reload Store on student portal due to issue: V2D-41219---*/
        				//start https://serosoft.atlassian.net/browse/V2D-154976			
        				if(portalId == 3 || portalId==1){ 
        					relationShipStore.load();
        				}
        				/*-------------------------------*/
            			
            			if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
            				var relationshipCheck=true;
            				//Remove Local Guardian for Velocity V2D-41695
            				relationShipStore.load({
            					callback: function(records, operation, success) {
            	    			   for(var i=0; i< relationShipStore.data.items.length;i++){
            	    				   if(relationShipStore.data.items[i].data.name == 'LOCAL_GUARDIAN'){
            	    					   relationShipStore.removeAt(i);
            	    				   } 
            	    			   }
            					}
            	    		   });
            			}
            			else{
            				var relationshipCheck=false;
            			}
            			var relationShipData = relationShipStore.data.items;
            			var relationShipName = '';
            			
            			if(Ext.isDefined(parentguardiancardlayoutview)){
                			parentguardiancardlayoutview.removeAll();
                			var user=me.getCurrentlyLoggedInUser();
                			if(user.code!="sysadmin"){
                				if(portalId == 3){
                					var parentCardPermissionMap= me.getSTUDENT_PORTAL_PARENT_DETAILS_VISITOR_PERMISSION();
                				}else if(portalId == 7){
                					var parentCardPermissionMap= me.getPARENT_PORTAL_PARENT_DETAILS_VISITOR_PERMISSION();
                				}else{
                					var parentCardPermissionMap= me.getPARENT_DETAILS_VISITOR_PERMISSION();
                				}
                    			var associatedAcadLocationIds = new Array();
                    	       	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
                    	       	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, parentCardPermissionMap);
                    	       	Ext.each(permissionList, function(privilege) {
                               		if (privilege === 'RELATIONSHIP_VISITOR1' || privilege === 'RELATIONSHIP_VISITOR2' || privilege === 'RELATIONSHIP_VISITOR3' || privilege === 'RELATIONSHIP_VISITOR4') {
                               			var index = relationShipStore.findExact('permissionKey',privilege)
                               			relationShipStore.removeAt(index);
                               		}
                               	});
                			}
                			Ext.each(relationShipData, function(currentRelationShipData){
                				if(!isNullOrEmpty(currentRelationShipData)){
                				var currentRelation = '';
                				var cardDataIndex = gridStore.find('relationship',currentRelationShipData.get('name'));
                				if(cardDataIndex>=0){
                					var isEmergencyContact = gridStore.getAt(cardDataIndex).data.isEmergencyContact;
                				}
                				if(cardDataIndex<0){
                					var panelItemsHidden = true;
                				}
                				else{
                					var panelItemsHidden = false;
                				}
                				
                				//
                				
                				var currentProfileTab = parentguardiancardlayoutview.up();
                				var registrationSetupParentDetails = currentProfileTab.registrationSetupParentDetails;
                				
                				var mandatorySpan = '';

                				if(relationshipCheck){
                					if(currentRelationShipData.get('name')=='FATHER'){
                						var currentRelation = getPersonModuleTranslation('PARENT_GUARDIAN1');
                					}else if(currentRelationShipData.get('name') == 'MOTHER'){
                						var currentRelation = getPersonModuleTranslation('PARENT_GUARDIAN2');
                					}else if(currentRelationShipData.get('name') == 'GUARDIAN'){
                						var currentRelation = getPersonModuleTranslation('PARENT_GUARDIAN3');
                					}
                					relationShipName = currentRelationShipData.get('name');
                				}else{
                					var currentRelation = getPersonModuleTranslation(currentRelationShipData.get('value'));
                					relationShipName = currentRelationShipData.get('name');
                				}
                				
                				Ext.each(registrationSetupParentDetails, function(currentSetupRecord){
                					if(currentSetupRecord.whetherMandatory == true){
                    					if(currentRelationShipData.get('name')=='FATHER' && currentSetupRecord.parentCode == "PG1"){
            								mandatorySpan = '<span style="color:red;">*</span>';
            							}
                    					else if(currentRelationShipData.get('name')=='MOTHER' && currentSetupRecord.parentCode == "PG2"){
            								mandatorySpan = '<span style="color:red;">*</span>';
            							}
                    					else if(currentRelationShipData.get('name')=='GUARDIAN' && currentSetupRecord.parentCode == "G"){
            								mandatorySpan = '<span style="color:red;">*</span>';
            							}
                    					else if(currentRelationShipData.get('name')=='LOCAL_GUARDIAN' && currentSetupRecord.parentCode == "LG"){
            								mandatorySpan = '<span style="color:red;">*</span>';
            							}
                					}
        						});
                				
                				var emergencyContact =''

                					if(isEmergencyContact == true){
                						emergencyContact = '<div align="right" class="emergencyContactIcon"></div>';	
                					}else{
                						emergencyContact ='';
                					}
                				parentguardiancardlayoutview.add({
                					xtype: 'parentguardiancardtpl',
                					title: '<div style="display:inline-block;float: left;height:22px">'+currentRelation + ' Details '+mandatorySpan+'</div>'+emergencyContact,
                					isPanelBlank: panelItemsHidden,
                					storeDataIndex: cardDataIndex,
                					relationshipName:relationShipName
                				});
                				}
                			});
            			}
            			
            			myMask.hide();
                    });
                },
                cellclick : function(obj,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
                	var me = this;
                	try{
                    	var grid = me.getParentGuardianGrid();
                	}
                	catch(e){
                		var grid = me.getContentPanel().getActiveTab().down('parentguardiangrid');
                	}
                	var buttonsToolBar = grid.query('toolbar')[0];
                	var btnCreateLogin = buttonsToolBar.query('#btnCreateLogin')[0];
                	var btnResetPassword=buttonsToolBar.query('#btnResetPswd')[0];
                	//console.log(record.get('parentUserCode'));
                	if(isNullOrEmpty(record.get('parentUserCode'))){
                		if(!isNullOrEmpty(record.get('isDeceased')) && record.get('isDeceased')==true) {
                			btnCreateLogin.setDisabled(true);
                		}
                		else{
                		btnCreateLogin.setDisabled(false);
                		}
                		btnResetPassword.setDisabled(true);
                	}
                	else{
                		btnCreateLogin.setDisabled(true);
                		btnResetPassword.setDisabled(false);
                	}
                },
                selectionchange: function( selectionModel, selected, eOpts ){
                	if(portalId==3 && selected.length>0){
                		var parentGrid = selectionModel.view.up('grid');
                		var editBtn = parentGrid.down('#btnEdit');
                		var deleteBtn = parentGrid.down('#btnDelete');
                		
                		var selectedRelation = selected[0].get('relationship');
                		if(selectedRelation=="FATHER" || selectedRelation=="GUARDIAN" || selectedRelation=="LOCAL_GUARDIAN" || selectedRelation=="MOTHER"){
                			editBtn.setDisabled(true);
                			deleteBtn.setDisabled(true);
                		}
                		else {
                			editBtn.setDisabled(false);
                			deleteBtn.setDisabled(false);
                		}
                	}
                }
            },
            'parentguardiancardtpl':{
            	afterrender: function(currentTpl){
            		var me = this;
            		
            		var btnCreateLogin = currentTpl.down('[itemId=createLogin_PG_ItemId]');
                	var btnResetPassword=currentTpl.down('[itemId=resetPassword_PG_ItemId]');
                	var editBtn = currentTpl.down('[itemId=edit_PG_ItemId]');
            		var deleteBtn = currentTpl.down('[itemId=delete_PG_ItemId]');
            		var btnSSO=currentTpl.down('[itemId=sso_PG_ItemId]');
            		
            		if(currentTpl.isPanelBlank){ //-- showing only add button in card tpl if record for relation is not available
            			currentTpl.down('[cls=pgCardLayoutUprPnl]').removeAll();
            			currentTpl.down('[cls=pgCardLayoutUprPnl]').el.dom.innerHTML = 'Details not added';
            			currentTpl.down('[cls=pgCardLayoutUprPnl]').el.dom.style.height = '30px !important';
            			currentTpl.down('[cls=pgCardLayoutBtnPnl]').el.dom.style.top = '30px !important';
            			
            			currentTpl.down('[itemId=edit_PG_ItemId]').hide();
            			currentTpl.down('[itemId=view_PG_ItemId]').hide();
            			currentTpl.down('[itemId=delete_PG_ItemId]').hide();
            			currentTpl.down('[itemId=createLogin_PG_ItemId]').hide();
            			currentTpl.down('[itemId=resetPassword_PG_ItemId]').hide();
            			currentTpl.down('[itemId=sso_PG_ItemId]').hide();
            			var itemIdPrivilegeNameArray = [{"#addDetails_PG_ItemId" : "CREATE" }];
            			if(portalId==1){
            				me.disableRadioGroupAndOtherPivileges(currentTpl, me.getSTUDENT_PARENTS_GUARDIANS_PERMISSIONS(), itemIdPrivilegeNameArray);
            			} else if(portalId==2){
            				me.disableRadioGroupAndOtherPivileges(currentTpl, me.getFACULTY_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS(), itemIdPrivilegeNameArray);
            			} else if(portalId==7){
                			me.disableRadioGroupAndOtherPivileges(currentTpl, me.getPARENT_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS(), itemIdPrivilegeNameArray);
                		} else if(portalId==3) {
                			if( currentTpl.relationshipName == 'FATHER' || currentTpl.relationshipName == 'MOTHER' || currentTpl.relationshipName == 'GUARDIAN' || currentTpl.relationshipName == 'LOCAL_GUARDIAN') {

                				//currentTpl.down('[itemId=addDetails_PG_ItemId]').hide();
                			} else {
                				me.disableRadioGroupAndOtherPivileges(currentTpl, me.getSTUDENT_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS(), itemIdPrivilegeNameArray);
                			}
                		}
            		}
            		else {
            			try{
                        	var gridStore = me.getContentPanel().getActiveTab().down('parentguardiangrid').getStore();
                    	}
                    	catch(e){
                        	var gridStore = me.getParentGuardianGrid().getStore();                    		
                    	}
            			var currentData = gridStore.getAt(currentTpl.storeDataIndex);
            			var currentPGName = currentData.get('relatedPerson').value;
            			var currentPGUserCode = currentData.get('parentUserCode');
            			var currentPGEmailId = currentData.get('relatedPersonEmailId');
            			var currentPGMobileNo = currentData.get('relatedPersonMobile');
            			var currentPGAltMobileNo = currentData.get('relatedPersonAlternateMobile');
            			var currentPGAltHasAccess = currentData.get('haveAccessToLearner');
            			if(currentData.get('isDeceased')!=undefined  && !isNullOrEmpty(currentData.get('isDeceased')) && currentData.get('isDeceased')==true && me.getCurrentLoggedPortalId() != 7 && me.getCurrentLoggedPortalId() != 3) {
            				NewPgName = currentPGName + getCommonTranslation('DECEASED') ;
            				currentTpl.down('[name=pgNameField]').setValue(NewPgName);
            			}
            			else {
            			currentTpl.down('[name=pgNameField]').setValue(currentPGName);
            			}
            			currentTpl.down('[name=pgUserCodeField]').setValue(currentPGUserCode);
            			currentTpl.down('[name=pgEmailField]').setValue(currentPGEmailId);
            			currentTpl.down('[name=pgMobileNoField]').setValue(currentPGMobileNo);
            			currentTpl.down('[name=pgAltMobileField]').setValue(currentPGAltMobileNo);
            			if(currentPGAltHasAccess == true)
            			{
            				currentPGAltHasAccess = 'Yes';
            			}else{
            				currentPGAltHasAccess='No';
            			}
            			currentTpl.down('[name=pgAltHasAccessField]').setValue(currentPGAltHasAccess);
            			
            			var relatedPersonHasAccessToStudent = currentData.get('relatedPersonHasAccessToStudent');
            			
            			//-- enable/disable createLogin/resetPassword button on the basis of parentUserCode
            			
            			if(portalId==1){
            			var itemIdPrivilegeNameArray = [{"#createLogin_PG_ItemId" : "CREATELOGIN" },{"#delete_PG_ItemId" : "DELETE" },{"#view_PG_ItemId" : "VIEW_DETAILS" },{"#edit_PG_ItemId" : "UPDATE" },{"#resetPassword_PG_ItemId" : "RESETPASSWORD" },{"#addDetails_PG_ItemId" : "CREATE" },{"#sso_PG_ItemId" : "SSOBUTTON" }];
            			me.disableRadioGroupAndOtherPivileges(currentTpl, me.getSTUDENT_PARENTS_GUARDIANS_PERMISSIONS(), itemIdPrivilegeNameArray);
            			} else if(portalId==2){
            				var itemIdPrivilegeNameArray = [{"#createLogin_PG_ItemId" : "CREATELOGIN" },{"#delete_PG_ItemId" : "DELETE" },{"#view_PG_ItemId" : "VIEW_DETAILS" },{"#edit_PG_ItemId" : "UPDATE" },{"#resetPassword_PG_ItemId" : "RESETPASSWORD" },{"#addDetails_PG_ItemId" : "CREATE" },{"#sso_PG_ItemId" : "SSOBUTTON" }];
            				me.disableRadioGroupAndOtherPivileges(currentTpl, me.getFACULTY_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS(), itemIdPrivilegeNameArray);
            			} else if(portalId==7){
            				var itemIdPrivilegeNameArray = [{"#createLogin_PG_ItemId" : "CREATELOGIN" },{"#delete_PG_ItemId" : "DELETE" },{"#view_PG_ItemId" : "VIEW_DETAILS" },{"#edit_PG_ItemId" : "UPDATE" },{"#resetPassword_PG_ItemId" : "RESETPASSWORD" },{"#addDetails_PG_ItemId" : "CREATE" },{"#sso_PG_ItemId" : "SSOBUTTON" }];
                			me.disableRadioGroupAndOtherPivileges(currentTpl, me.getPARENT_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS(), itemIdPrivilegeNameArray);
                		}
            			if(portalId==3){
                    		var selectedRelation = currentData.get('relationship');
                    		if(selectedRelation=="FATHER" || selectedRelation=="GUARDIAN" || selectedRelation=="LOCAL_GUARDIAN" || selectedRelation=="MOTHER"){
                    			//editBtn.setDisabled(true);   (V2D-411000)
                    			deleteBtn.setDisabled(true);
                    			
                    			//currentTpl.down('[itemId=edit_PG_ItemId]').hide();
                    			currentTpl.down('[itemId=delete_PG_ItemId]').hide();
                    			currentTpl.down('[itemId=createLogin_PG_ItemId]').hide();
                    			currentTpl.down('[itemId=resetPassword_PG_ItemId]').hide();
                    			currentTpl.down('[itemId=sso_PG_ItemId]').hide();
                    			
                    			var itemIdPrivilegeNameArray = [{"#view_PG_ItemId" : "VIEW_DETAILS" },{"#edit_PG_ItemId" : "UPDATE" },{"#addDetails_PG_ItemId" : "CREATE" }];
                        		me.disableRadioGroupAndOtherPivileges(currentTpl, me.getSTUDENT_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS(), itemIdPrivilegeNameArray);
                    		}
                    		else {
                    			editBtn.setDisabled(false);
                    			deleteBtn.setDisabled(false);
                    			
                    			var itemIdPrivilegeNameArray = [{"#createLogin_PG_ItemId" : "CREATELOGIN" },{"#delete_PG_ItemId" : "DELETE" },{"#view_PG_ItemId" : "VIEW_DETAILS" },{"#edit_PG_ItemId" : "UPDATE" },{"#resetPassword_PG_ItemId" : "RESETPASSWORD" },{"#addDetails_PG_ItemId" : "CREATE" }];
                    			me.disableRadioGroupAndOtherPivileges(currentTpl, me.getSTUDENT_PORTAL_STUDENT_PARENTS_GUARDIANS_PERMISSIONS(), itemIdPrivilegeNameArray);
                    		}
                    	}
            			
            			if(isNullOrEmpty(currentData.get('parentUserCode'))){
            				if( !isNullOrEmpty(relatedPersonHasAccessToStudent) && relatedPersonHasAccessToStudent == true ){
                        		if(!isNullOrEmpty(currentData.get('isDeceased')) && currentData.get('isDeceased')==true) {
                        			btnCreateLogin.setDisabled(true);
                        		}
                        		else {
                    			btnCreateLogin.setDisabled(false);
                        		}
                    			btnResetPassword.setDisabled(true);
                    			btnSSO.setDisabled(true);
                    		} else {
                    			btnCreateLogin.setDisabled(true);
                    			btnResetPassword.setDisabled(true);
                    			btnSSO.setDisabled(true);
                    		}
                    	}
                    	else{
                			btnCreateLogin.setDisabled(true);
                			btnResetPassword.setDisabled(false);
                			btnSSO.setDisabled(false);
                    	}
            			
            			//--setting userphoto on card tpl
            			if(!isNullOrEmpty(currentData.get('photoUrl')) && currentData.get('photoUrl') !=0){
            				if(currentData.get('isExternalPhotoUrl') == true){
            					var imageUrl=currentData.get('photoUrl');
            				}else{
            					var extensionArr = currentData.get('photoUrl').split(".");
                        		var imageUrl="resources/images/uploads"+extensionArr[extensionArr.length - 2]+"_icon."+extensionArr[extensionArr.length - 1];
            				}
                    		currentTpl.down('image').setSrc(imageUrl);
                           
            		}
            	    currentTpl.down('[itemId=addDetails_PG_ItemId]').hide();
            		currentTpl.doLayout();
            	}
            	}            
           },
            'parentguardiangrid[itemId=studentParentGuardianGrid] button[itemId=btnAdd]': {
            	click: function() {
            		var formWindow = this.getPersonCommonWindow();
            		localStorage.setItem('parentDataURL','');
            		var formWindow = this.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', 'studentParentGuardianForm',true);
            		if( formWindow != null ){
            			var form = formWindow.down('#studentParentGuardianForm');
                		var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            		    var countryCodeField = form.down("#mobileCountryCode");
                        var mobileField = form.down("#cellNo");
                        this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                        countryCodeField = form.down("#alternateMobileCountryCode");
                        mobileField = form.down("#alternateMobileNo");
                        this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                        if(form.down('#isDeceasedField')!=undefined){
            				if(this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 3)
                	   		{
            					form.down('#isDeceasedField').setVisible(false);
                	   		}
            			}
            		    
            		    /*
            		     var parentGuardianForm = this.getPersonParentGuardianForm();
        			if(parentGuardianForm.down('#applyUpdateToSiblings')!=undefined){
        				var applyUpdateToSiblings = parentGuardianForm.down('#applyUpdateToSiblings');
                		
        				if(this.getCurrentLoggedPortalId() == 7)
                		{
        					applyUpdateToSiblings.setVisible(false);
                		}else if(this.getCurrentLoggedPortalId() == 2){
                			
                		}else if(this.getCurrentLoggedPortalId() == 3){
                			applyUpdateToSiblings.setVisible(false);
                		}else{
                			
                		}
        			} 
            		     */
            		    
            		}
                }
            },
            'parentguardiancardtpl button[itemId=addDetails_PG_ItemId]': {
            	click: function() {
            		var formWindow = this.getPersonCommonWindow();
            		localStorage.setItem('parentDataURL','');
            		var formWindow = this.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', 'studentParentGuardianForm',true);
            		if( formWindow != null ){
            			var form = formWindow.down('#studentParentGuardianForm');
            			if(form.down('#isDeceasedField')!=undefined){
            				if(this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 3){
            					form.down('#isDeceasedField').setVisible(false);	
            				}
            			}
            			if(form.down('#applyUpdateToSiblings')!=undefined){
            				var applyUpdateToSiblings = form.down('#applyUpdateToSiblings');
                    		applyUpdateToSiblings.setVisible(false);	
            			}
                		var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            		    var countryCodeField = form.down("#mobileCountryCode");
                        var mobileField = form.down("#cellNo");
                        this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                        countryCodeField = form.down("#alternateMobileCountryCode");
                        mobileField = form.down("#alternateMobileNo");
                        this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
            		    
            		    // By Default Set bellow checkboxes as checked
            		    var isMobileAvalaibleForCommunicationField = form.down('#isMobUseForCommunicationField');
            		    var isPhoneAvalaibleForCommunicationField = form.down('#isPhoneUseForCommunicationField');
            		    var isAlternateMobileAvalaibleForCommunicationField = form.down('#isAlternateMobUseForCommunicationField');
            		    
            		    if( !isNullOrEmpty(isMobileAvalaibleForCommunicationField) ){
            		    	isMobileAvalaibleForCommunicationField.setValue(true);
            		    }
            		    if( !isNullOrEmpty(isPhoneAvalaibleForCommunicationField) ){
            		    	isPhoneAvalaibleForCommunicationField.setValue(true);
            		    }
            		    if( !isNullOrEmpty(isAlternateMobileAvalaibleForCommunicationField) ){
            		    	isAlternateMobileAvalaibleForCommunicationField.setValue(true);
            		    }
            		}
                }
            },
            'parentguardiangrid[itemId=studentParentGuardianGrid] button[itemId=btnEdit]': {
                click: function(){
                	localStorage.setItem('parentDataURL','');
                	this.editPersonParentGuardianFormWindow('#studentParentGuardianGrid', 'studentParentGuardianForm', SERVERURL.PERSON_RELATIONSHIP_FORM_DETAILS);
                	
                	var formWindow = this.getPersonCommonWindow();
            		var formWindow = this.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', 'studentParentGuardianForm',true);
            		if( formWindow != null ){
            			var form = formWindow.down('#studentParentGuardianForm');
            			var applyUpdateToSiblings = form.down('#applyUpdateToSiblings');
            			if(form.down('#isDeceasedField')!=undefined){
            				if(this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 3)
                	   		{
            					form.down('#isDeceasedField').setVisible(false);
                	   		}
            			}
            			if(form.down('#applyUpdateToSiblings')!=undefined){
            				if(this.getCurrentLoggedPortalId() == 7)
                	   		{
                				//parent portal
            					if( applyUpdateToSiblings.isVisible() ){
                	   				applyUpdateToSiblings.setVisible(true);
                	   			}
                	   		}else if(this.getCurrentLoggedPortalId() == 2){
                	   			//faculty portal
                	   			if( applyUpdateToSiblings.isVisible() ){
                	   				applyUpdateToSiblings.setVisible(true);
                	   			}
                	   		}else if(this.getCurrentLoggedPortalId() == 3){
                	   			//student portal
                	   			//applyUpdateToSiblings.setVisible(false);
                	   		}else{
                	   			//core ERP portal
                	   			if( applyUpdateToSiblings.isVisible() ){
                	   				applyUpdateToSiblings.setVisible(true);
                	   			}
                	   		}
            			}
            		}
                }
            },
            'parentguardiancardtpl button[itemId=edit_PG_ItemId]':{
            	click: function(btn){
            		var this$ = this;
            		//var gridItemId = '#studentParentGuardianGrid';
            		var formItemId = 'studentParentGuardianForm';
            		var relatedPersonUrl = SERVERURL.PERSON_RELATIONSHIP_FORM_DETAILS;
                    var personProfile = this$.getContentPanelActiveTab();
                    
            		localStorage.setItem('parentDataURL','');
            		
            		var formWindow = this$.getPersonCommonWindow();
                	this.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', formItemId);
                	var form = this$.getPersonParentGuardianForm();
                	
                	try{
                		var grid = this$.getContentPanel().getActiveTab().down('parentguardiangrid');
                	}
                	catch(e){
                		var grid = this$.getParentGuardianGrid();
                	}
                	var gridStore = grid.getStore();
        			var records = gridStore.getAt(btn.up('parentguardiancardtpl').storeDataIndex);
        			
                    if (!isEmpty(records)) {
                        var id = records.get("id");
                        var params = {
                            id: id
                        };
                        this$.sendGetAjaxRequest(relatedPersonUrl, 'GET', params, function(option, success, response) {
                        	if(success){
                        		var data = Ext.decode(response.responseText);
                                if (!isEmpty(data)) {

                                   	if(!(isNullOrEmpty(data.relatedPerson.birthDate)))
            						data.relatedPerson.birthDate = new Date(data.relatedPerson.birthDate);
                                   	if(!(isNullOrEmpty(data.relatedPerson.genderCSM)) && !isNullOrEmpty(data.relatedPerson.genderCSM.id)){
                                   		data.relatedPerson.gender = 	data.relatedPerson.genderCSM.id;
                            		}
                                	if(!(isNullOrEmpty(data.relatedPerson.maritalStatusId)) && !isNullOrEmpty(data.relatedPerson.maritalStatusId.id)){
                                   		data.relatedPerson.maritalStatus = 	data.relatedPerson.maritalStatusId.id;
                            		}
                                    form.getForm().setValues(data);
                                    var formDetails = new Object();
                                    formDetails["id"] = data["id"];
                                    formDetails["version"] = data["version"];

                                    if (!isEmpty(data['relatedPerson'])) {
                                        var relatedPerson = data['relatedPerson'];
                                        var relationship = data['relationship'];
                                        form.setRelatedPerson(relatedPerson);
										relatedPerson.employmentStatus = relatedPerson.employmentStatus.id;
										form.down('#employmentStatus').getStore().load({
											callback: function() {
												form.getForm().setValues(relatedPerson);
												form.down('#pg_hidden_field').setValue(formDetails["id"]);
											}
										});
                                    }
                                    form.getForm().setValues(formDetails);
                                    var haveAccessToLearner = form.down('#haveAccessToLearnerId');
                                    if(relatedPerson.haveAccessToLearner) {
                                    	haveAccessToLearner.items.items[0].setValue(true);
                                    	haveAccessToLearner.items.items[1].setValue(false);
                                    } else {
                                    	haveAccessToLearner.items.items[0].setValue(false);
                                    	haveAccessToLearner.items.items[1].setValue(true);
                                    }
                                    
                            		var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
                            		this$.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
                            		this$.getApplyToSiblingDetail(form,data);
                            		if(form.down('#isDeceasedField')!=undefined){
                        				if(this$.getCurrentLoggedPortalId() == 7 || this$.getCurrentLoggedPortalId() == 3)
                            	   		{
                        					form.down('#isDeceasedField').setVisible(false);
                            	   		}
                        			}
                            		var countryCodeField = form.down("#mobileCountryCode");
                                    var mobileField = form.down("#cellNo");
                                    this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                                    countryCodeField = form.down("#alternateMobileCountryCode");
                                    mobileField = form.down("#alternateMobileNo");
                                    this$.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                                    /** Other language setup*/
                                    var relationship = data['relationship'];
                                    if(relationship == "FATHER" || relationship == "MOTHER"){
                                    	this$.checkOtherLanguageFieldVisibility(form);
                                    }
                                }
                        	}
                            

                        });//SERVERURL.PERSON_RELATIONSHIP_FORM_DETAILS
                    } 
                	
                	return formWindow;
            	}
            },
            'parentguardiangrid[itemId=studentParentGuardianGrid] button[itemId=btnView]': {
                click: function(){
                	var me = this;
                	localStorage.setItem('parentDataURL','');
                	this.viewPersonParentGuardianFormWindow('#studentParentGuardianGrid', 'studentParentGuardianForm', SERVERURL.PERSON_RELATIONSHIP_FORM_DETAILS); 
                	setTimeout(function(){
                		var parentGuardianForm = me.getPersonParentGuardianForm();
                		parentGuardianForm.down('#photoFileImageParent').setDisabled(true);
                		parentGuardianForm.down('button[itemId=photoFileImageParent]').setDisabled(true);
                		if(form.down('#isDeceasedField')!=undefined){
            				if(this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 3)
                	   		{
            					form.down('#isDeceasedField').setVisible(false);
                	   		}
            			}
                		
                		if(parentGuardianForm.down('#applyUpdateToSiblings')!=undefined){
                			var applyUpdateToSiblings = parentGuardianForm.down('#applyUpdateToSiblings');
            				if(this.getCurrentLoggedPortalId() == 7)
                	   		{
                				//parent portal
            					if( applyUpdateToSiblings.isVisible() ){
                	   				applyUpdateToSiblings.setVisible(true);
                	   			}
                	   		}else if(this.getCurrentLoggedPortalId() == 2){
                	   			//faculty portal
                	   			if( applyUpdateToSiblings.isVisible() ){
                	   				applyUpdateToSiblings.setVisible(true);
                	   			}
                	   		}else if(this.getCurrentLoggedPortalId() == 3){
                	   			//student portal
                	   			//applyUpdateToSiblings.setVisible(false);
                	   		}else{
                	   			//core ERP portal
                	   			if( applyUpdateToSiblings.isVisible() ){
                	   				applyUpdateToSiblings.setVisible(true);
                	   			}
                	   		}
            			}
                		
                	},300);
                }
            },
            'parentguardiancardtpl button[itemId=view_PG_ItemId]':{
            	click: function(btn){
            		var this$ = this;
                	localStorage.setItem('parentDataURL','');
                	
                	var gridItemId = '#studentParentGuardianGrid';
                	var formItemId = 'studentParentGuardianForm';
                	var relatedPersonUrl = SERVERURL.PERSON_RELATIONSHIP_FORM_DETAILS;
                	
                    var personProfile = this$.getContentPanelActiveTab();
                    var grid = personProfile.down(gridItemId);
                    var formWindow = this$.getPersonCommonWindow();
                    this.showPersonCommonWindow(formWindow, 'PARENT_GUARDIAN', formItemId);
                    var form = this$.getPersonParentGuardianForm();
                    if(form.down('#isDeceasedField')!=undefined){
        				if(this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 3)
            	   		{
        					form.down('#isDeceasedField').setVisible(false);
            	   		}
        			}
                    
        			if(form.down('#applyUpdateToSiblings')!=undefined){
        				var applyUpdateToSiblings = form.down('#applyUpdateToSiblings');
        				applyUpdateToSiblings.addCls('disabledMparentfield');
        				if(this.getCurrentLoggedPortalId() == 7)
            	   		{
            				//parent portal
                		    if( applyUpdateToSiblings.isVisible() ){
            	   				applyUpdateToSiblings.setVisible(true);
            	   			}
            	   		}else if(this.getCurrentLoggedPortalId() == 2){
            	   			//faculty portal
            	   			if( applyUpdateToSiblings.isVisible() ){
            	   				applyUpdateToSiblings.setVisible(true);
            	   			}
            	   		}else if(this.getCurrentLoggedPortalId() == 3){
            	   			//student portal
            	   			applyUpdateToSiblings.setVisible(false);
            	   		}else{
            	   			//core ERP portal
            	   			if( applyUpdateToSiblings.isVisible() ){
            	   				applyUpdateToSiblings.setVisible(true);
            	   			}
            	   		}
        			}
                    	
                    var gridStore = grid.getStore();
        			var records = gridStore.getAt(btn.up('parentguardiancardtpl').storeDataIndex);
        			
                    if (!isEmpty(records)) {
                        var id = records.get("id");
                        var params = {
                            id: id
                        };
                        this$.sendGetAjaxRequest(relatedPersonUrl, 'GET', params, function(option, success, response) {
                        	if(success){
                        		var data = Ext.decode(response.responseText);
                                if (!isEmpty(data)) {

                                   	if(!(isNullOrEmpty(data.relatedPerson.birthDate)))
            						data.relatedPerson.birthDate = new Date(data.relatedPerson.birthDate);
                                   	if(!(isNullOrEmpty(data.relatedPerson.genderCSM)) && !isNullOrEmpty(data.relatedPerson.genderCSM.id)){
                                   		data.relatedPerson.gender = 	data.relatedPerson.genderCSM.id;
                            		}
                                   	if(!isNullOrEmpty(data.relatedPerson.idtype) && !isNullOrEmpty(data.relatedPerson.idtype.id)){
                                   		data.relatedPerson.idtype = data.relatedPerson.idtype.id;
                        			}
                                	if(!(isNullOrEmpty(data.relatedPerson.maritalStatusId)) && !isNullOrEmpty(data.relatedPerson.maritalStatusId.id)){
                                   		data.relatedPerson.maritalStatus = 	data.relatedPerson.maritalStatusId.id;
                            		}
                                   	this$.getPersonParentGuardianForm().getForm().setValues(data);
                                    var formDetails = new Object();
                                    formDetails["id"] = data["id"];
                                    formDetails["version"] = data["version"];
                                    
                                    if (!isEmpty(data['relatedPerson'])) {
                                        var relatedPerson = data['relatedPerson'];
                                        var relationship = data['relationship'];
                                        form.setRelatedPerson(relatedPerson);
                                        
                                        relatedPerson.employmentStatus = relatedPerson.employmentStatus.id;
										form.down('#employmentStatus').getStore().load({
											callback: function() {
												form.getForm().setValues(relatedPerson);
											}
										});
                                    }
                                    this$.getPersonParentGuardianForm().getForm().setValues(formDetails);
                                    var haveAccessToLearner = form.down('#haveAccessToLearnerId');
                                    if(relatedPerson.haveAccessToLearner) {
                                    	haveAccessToLearner.items.items[0].setValue(true);
                                    	haveAccessToLearner.items.items[1].setValue(false);
                                    } else {
                                    	haveAccessToLearner.items.items[0].setValue(false);
                                    	haveAccessToLearner.items.items[1].setValue(true);
                                    }
                                    
                            		var countryCodeFieldItemIDArray = ["#mobileCountryCode","#phoneCountryCode","#alternateMobileCountryCode"];
                            		this$.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
                            		this$.getApplyToSiblingDetail(form,data);
                            		if(form.down('#isDeceasedField')!=undefined){
                        				if(this$.getCurrentLoggedPortalId() == 7 || this$.getCurrentLoggedPortalId() == 3)
                            	   		{
                        					form.down('#isDeceasedField').setVisible(false);
                            	   		}
                        			}
                            		 /** Other language setup*/
                                    var relationship = data['relationship'];
                                    if(relationship == "FATHER" || relationship == "MOTHER"){
                                    	this$.checkOtherLanguageFieldVisibility(form);
                                    }
                                }
                        	}
                        });
                    }    
                    
                    if (this$.getPersonParentGuardianForm()) {
                    	this$.getPersonParentGuardianForm().down('#submitButtonId').setVisible(false);
            	        toggleReadOnlyFormItems(this$.getPersonParentGuardianForm().getForm(), true);
            	    }
                    
                    setTimeout(function(){
                		var parentGuardianForm = this$.getPersonParentGuardianForm();
                		parentGuardianForm.down('#photoFileImageParent').setDisabled(true);
                		parentGuardianForm.down('button[itemId=photoFileImageParent]').setDisabled(true);
                	},300);
            	}
            },
            'parentguardiangrid[itemId=studentParentGuardianGrid] button[itemId=btnDelete]': {
            	click: function(){
                	this.deletePersonParentGuardianRecord('#studentParentGuardianGrid', SERVERURL.PERSON_RELATIONSHIP_DELETE); 
                }
            },
            'parentguardiancardtpl button[itemId=delete_PG_ItemId]':{
            	click: function(btn){
            		var this$ = this;
            		var gridItemId = '#studentParentGuardianGrid';
            		var deleteUrl = SERVERURL.PERSON_RELATIONSHIP_DELETE;
            		
            		var personProfile = this$.getContentPanelActiveTab();
                    var grid = personProfile.down(gridItemId);
                    var gridStore = grid.getStore();
        			
                    showConfirmMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(mbtn, text) {
                        if (mbtn == 'yes') {
                        	var records = gridStore.getAt(btn.up('parentguardiancardtpl').storeDataIndex);
                        	var id = records.get("id");
                            Ext.Ajax.request({
                                type: 'rest',
                                url: deleteUrl,
                                method: 'DELETE',
                                headers: {
                                    'Content-Type': 'application/json'
                                },
                                params: {
                                    id: id
                                },
                                success: function(form, action) {
                                    grid.getStore().load();
                                    showSuccessMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getPersonModuleTranslation('PARENTS_GUARDIANS_DELETE_SUCCESS'));
                                }
                            });
                        }
                    });
            	}
            },
            'parentguardiangrid[itemId=studentParentGuardianGrid] button[itemId=btnCreateLogin]': {
            	click: this.createParentLogin
            },
            'parentguardiangrid[itemId=studentParentGuardianGrid] splitbutton[itemId=btnExportToPDFJasper] #exportPDFCurrentPage':{
           	 click : function(grid) {
           	 this.exportPDFParentGuardianReport();
           	 }
           },
           'parentguardiangrid[itemId=studentParentGuardianGrid] splitbutton[itemId=btnExportToExcelJasper] #exportExcelCurrentPage':{
           	click : function() {
              	 this.exportXLParentGuardianReport();
              	 }
           },
            'parentguardiancardtpl button[itemId=createLogin_PG_ItemId]':{
            	click: function(btn){
            		var this$ = this;
            		var gridItemId = '#studentParentGuardianGrid';
            		var personProfile = this$.getContentPanelActiveTab();
                    var grid = personProfile.down(gridItemId);
                    var gridStore = grid.getStore();
                    
                    var records = gridStore.getAt(btn.up('parentguardiancardtpl').storeDataIndex);
            		var submitData = {"person":{"id":records.get('relatedPerson').id}};
            		Ext.Ajax.request({type: 'rest',url:SERVERURL.CREATE_PARENT_LOGIN,jsonData : submitData,method : 'POST',success: function(res, action){
            			var mssg = res.responseText;
            			if(mssg==='PARENT_CREATED_SUCESSFULLY'){
            				showSuccessMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'),getPersonModuleTranslation('LOGIN_CREATED_SUCCES'));
            				gridStore.reload();
            				grid.getSelectionModel().deselectAll();
            			}
            		}});
            	}
            },
            'parentguardiangrid[itemId=studentParentGuardianGrid] button[itemId=btnResetPswd]': {
 	            click: function(obj) {
 	            	var me = this;
 	            	try{
                    	var grid = me.getParentGuardianGrid();
                	}
                	catch(e){
                		var grid = me.getContentPanel().getActiveTab().down('parentguardiangrid');
                	}
		        	if (grid.getSelectionModel().getCount() > 0) {
		        		if(grid.getSelectionModel().getCount() > 1){
		        			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
		        		}else{
		        			this.openResetPasswordWindow();
		        		}
		        		 
	        		} else {
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}  
 	            }
            },
            'parentguardiancardtpl button[itemId=resetPassword_PG_ItemId]':{
            	click: function(btn){
            		var this$ = this;
            		var gridItemId = '#studentParentGuardianGrid';
            		var personProfile = this$.getContentPanelActiveTab();
                    var grid = personProfile.down(gridItemId);
                    var gridStore = grid.getStore();
                    var records = gridStore.getAt(btn.up('parentguardiancardtpl').storeDataIndex);
                    
                    var resetPswrdWindowItemId ="parentAdminResetPasswordWindow";
                    var resetPswrdFormWindow = Ext.widget('adminresetpasswordwindow', {
                         itemId: resetPswrdWindowItemId,
                         storeDataIndex: btn.up('parentguardiancardtpl').storeDataIndex
                     });
                    resetPswrdFormWindow.show();
            	}
            },
            'adminresetpasswordwindow[itemId=parentAdminResetPasswordWindow]': {
                beforerender: function(formWindow) {
                	var form = formWindow.down('form');
                    var randomPassword=form.down("#passwordTypeItemId");
                	randomPassword.setVisible(false);
        	    	this.getController('Academia.controller.authentication.AuthenticationController').getPasswordPolicy(form);
                }
            },
            'adminresetpasswordwindow[itemId=parentAdminResetPasswordWindow] form #resetPassword' :{ 
				blur:this.getController('Academia.controller.authentication.AuthenticationController').checkPasswordValidity
			},
            
            'adminresetpasswordwindow[itemId=parentAdminResetPasswordWindow] button[itemId=submitBtn]':{
 	        	click:function(obj){
 	        		this.changePasswordByAdmin(obj);
 	        	}
 	        },
 	        'adminresetpasswordwindow[itemId=parentAdminResetPasswordWindow] button[itemId=cancelBtn]':{
 	        	click:function(obj){
 	        		obj.up('window').close();
 	        	}
 	        },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm] button[itemId=submitButtonId]': {
            	click: function(){
                	this.savePersonParentGuardian('STUDENT', '#studentParentGuardianGrid', SERVERURL.PERSON_RELATIONSHIP_ADD, SERVERURL.PERSON_RELATIONSHIP_UPDATE); 
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm] filefield[itemId=photoFileImageParent]': {
            	change: function(fileField, value, eOpts){
            		var $this = this;
                	value = value.replace('C:\\fakepath\\', '');
                	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                	fileField.setRawValue(newValue);
                	if (!isNullOrEmpty(newValue)) {
                		localStorage.setItem('parentDataURL','');
                	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                	    if ($this.isValidImageExtension(extension)) {
                	        var file = fileField.fileInputEl.dom.files[0];
                	        if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                	            fileField.reset();
                	            showWarningMessage(getPersonModuleTranslation('PARENT_GUARDIAN'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                	        }
                	    } else {
                	        fileField.reset();
                	        showWarningMessage(getPersonModuleTranslation('PARENT_GUARDIAN'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                	    }
                	}
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm] textfield[itemId=employeeIdField]': {
                change: function(){
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                	this.onChangeDisabledInnerParentGuardianForm(parentGuardianForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm] button[itemId=searchButtonId]': {
            	click: function(){
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                	this.validateEmployeeOrgId(parentGuardianForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm] checkboxfield[itemId=isEmployeeOrganisation]': {
                change: function(employeeOrg, checkValue, oldValue, eOpts) {
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                    this.onChangeEmployeeOrgField(parentGuardianForm, checkValue);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm]': {
            	render: function() {
            		var parentGuardianForm = this.getPersonParentGuardianForm();
                	this.onRenderHideInnerParentGuardianFormField(parentGuardianForm);
                	this.getPersonCommonWindow().doLayout();
                },
                afterrender: function() {
                	var parentGuardianForm = this.getPersonParentGuardianForm();
                	var personType=this.getContentPanelActiveTab().personType;

                		if(personType=="STUDENT" || this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 3){
                    		parentGuardianForm.down('#enableEmailCommunicationId').setVisible(true);
                    	}

                	var isAlumnusRadio=parentGuardianForm.down("#isAlumnusRadio").getValue();
                	 var schoolAttendedField = parentGuardianForm.down('#schoolAttended');
                	if(isAlumnusRadio==true){
                		parentGuardianForm.down("#schoolAttended").setVisible(true);
                	}else{
                		schoolAttendedField.allowBlank = true;
                		parentGuardianForm.down("#schoolAttended").setVisible(false);
                	}
                	if(parentGuardianForm.down('#isDeceasedField')!=undefined){
        				if(this.getCurrentLoggedPortalId() == 7 || this.getCurrentLoggedPortalId() == 3)
            	   		{
        					parentGuardianForm.down('#isDeceasedField').setVisible(false);
            	   		}
        			}
                	var firstNameOther = parentGuardianForm.down('#firstNameOtherLanguageId');
                	var middleNameOther = parentGuardianForm.down('#middleNameOtherLanguageId');
                	var lastNameOther = parentGuardianForm.down('#lastNameOtherLanguageId');
                	firstNameOther.setVisible(false);
                	middleNameOther.setVisible(false);
                	lastNameOther.setVisible(false);
                	firstNameOther.allowBlank = true;
                	middleNameOther.allowBlank = true;
                	lastNameOther.allowBlank = true;
                	
                //Please do not uncomment this code
                 var me = this;
            		 if(this.getCurrentLoggedPortalId() == 3){
				      var form  = this.getPersonParentGuardianForm();
			     	  Ext.defer(function(){
				      	me.hideFieldsForParentsGuardianForm(form);
				      },500);
				    }
                	
                	 Ext.Ajax.request({
             	   		type: 'rest',
             	   		async: false,
             	   		url: SERVERURL.COMMON_FORM_FIELD_INFO,
             	   		params: {
             	   			screenName: 'parentguardianform',
             	   			academyLocationId: this.getCurrentAcademyLocation(),
             	   			languageCode:'en'
             	   		},
             	   		method: 'GET',
             	   		success: function(res, action) {
             	   		}
             	   	});
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm] combo[itemId=relationShipField]': {
               render:function(combo, eOpts){
            	   this.loadRelationData(combo);
               },
               afterrender: function(combo, eOpts) {
            	   if(portalId == 3){
            		   var relationShipComboPermissionMap= this.getSTUDENT_PORTAL_PARENT_DETAILS_VISITOR_PERMISSION();
            	   }else if(portalId == 7){
            		   var relationShipComboPermissionMap= this.getPARENT_PORTAL_PARENT_DETAILS_VISITOR_PERMISSION();
            	   }else{
            		   var relationShipComboPermissionMap= this.getPARENT_DETAILS_VISITOR_PERMISSION();
            	   }
            	   this.onRenderParentGuardianRelationShipCombo(combo,relationShipComboPermissionMap);
               },
                select : function(combo, record) {
            		var parentGuardianForm = this.getPersonParentGuardianForm();
            		var firstNameOther = parentGuardianForm.down('#firstNameOtherLanguageId');
                	var middleNameOther = parentGuardianForm.down('#middleNameOtherLanguageId');
                	var lastNameOther = parentGuardianForm.down('#lastNameOtherLanguageId');
                	firstNameOther.setVisible(false);
                	middleNameOther.setVisible(false);
                	lastNameOther.setVisible(false);
                	firstNameOther.allowBlank = true;
                	middleNameOther.allowBlank = true;
                	lastNameOther.allowBlank = true;
                	this.onSelectRelationshipComboValue(combo, '#studentParentGuardianGrid', parentGuardianForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm] combo[itemId=mobileCountryCode]': {
            	select: function(rowModel, record){
                	var form = this.getPersonParentGuardianForm();
                	var countryCodeField = form.down("#mobileCountryCode");
                	var mobileField = form.down("#cellNo");
                	var alternateMobileField=form.down("#alternateMobileNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,alternateMobileField,record);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm] combo[itemId=phoneCountryCode]': {
            	select: function(rowModel, record){
                	var form = this.getPersonParentGuardianForm();
                	var countryCodeField = form.down("#phoneCountryCode");
                	var phoneNoField = form.down("#phoneNoField");
                	this.setMaximumMinimumDigitsForPhoneNoValidation(form, countryCodeField, phoneNoField, record);
                }
            },
            
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId= ] combo[itemId=alternateMobileCountryCode]': {
                select: function(rowModel, record){
                	var form = this.getPersonParentGuardianForm();
                	var countryCodeField = form.down("#alternateMobileCountryCode");
                	var mobileField = form.down("#alternateMobileNo");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm] numberfield[itemId=alternateMobileNo]': {
            	validitychange: function( obj1, isValid, eOpts )  {
    				var commonWin = this.getPersonCommonWindow();
            		var size = Ext.Element.getViewSize();
            		if(obj1.hasFocus){
            			//commonWin.body.dom.scrollTop = size.height;
            		}
    			},
    			change: function(record){
                	var form = this.getPersonParentGuardianForm();
                	var mobileField = form.down("#alternateMobileNo");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm] numberfield[itemId=cellNo]': {
            	validitychange: function( obj1, isValid, eOpts )  {
    				var commonWin = this.getPersonCommonWindow();
            		var size = Ext.Element.getViewSize();
            		if(obj1.hasFocus){
            		//	commonWin.body.dom.scrollTop = size.height-20;
            		}
    			},
    			change: function(record){
                	var form = this.getPersonParentGuardianForm();
                	var mobileField = form.down("#cellNo");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm] textfield[itemId=primaryeEmailId]': {
            	validitychange: function( obj1, isValid, eOpts )  {
    				var commonWin = this.getPersonCommonWindow();
            		var size = Ext.Element.getViewSize();
            		if(obj1.hasFocus){
            			//commonWin.body.dom.scrollTop = size.height-145;
            		}
    			}
            },
            'siblingdetailsgrid[itemId=studentSiblingDetailsGrid]':{
            	render: function(grid) {
            		this.loadGridStore('#studentSiblingDetailsGrid', SERVERURL.SIBLING_DETAILS);
            		if(this.getCurrentLoggedPortalId() == 7)
            		{
            			this.doAccessControlValidation(grid,this.getPARENT_PORTAL_STUDENT_SIBLINGS_PERMISSIONS());
            			var alinfomodel = Academia.model.authentication.ALInfoModel;
                        var checkSchool = alinfomodel.get('wheatherSchool');
                    	if(Ext.isDefined(Ext.ComponentQuery.query('siblingdetailsgrid'))){
                    		var getGrid = Ext.ComponentQuery.query('siblingdetailsgrid')[0];
                        	Ext.each(getGrid.columns, function(currentColumn){
                        		if(currentColumn.dataIndex=="siblingCode")
    						   {
    							   currentColumn.setVisible(true);
    						   }if(currentColumn.dataIndex=="siblingProgramName")
     						   {
     							   currentColumn.setVisible(true);
     						   }if(currentColumn.dataIndex=="siblingBatchName")
     						   {
     							   currentColumn.setVisible(true);
     						   }if(currentColumn.dataIndex=="siblingPeriodName")
     						   {
                        			if(checkSchool)
                        			{
                        				currentColumn.setVisible(false);
                                    }else
     							   currentColumn.setVisible(true);
     						   }if(currentColumn.dataIndex=="siblingSectionName")
     						   {
     							   currentColumn.setVisible(true);
     						   }if(currentColumn.dataIndex=="siblingStatus")
     						   {
     							   currentColumn.setVisible(false);
     							   
     						   }
    					   }
                        	);
                        	getGrid.getView().refresh();
                    	}
            		}else if(this.getCurrentLoggedPortalId() == 2){
            			this.doAccessControlValidation(grid,this.getFACULTY_PORTAL_STUDENT_SIBLINGS_PERMISSIONS());
            		}else if(this.getCurrentLoggedPortalId() == 3){
            			var studentData = this.getCurrentlyLoggedInUserInfoForPortal();
                       /* if (grid) {
                            var personId = studentData.student.person.id;
                            var store = grid.getStore();
                            store.getProxy().extraParams = {
                             personId: personId
                            };
                            store.load();
                        }*/
            			this.doAccessControlValidation(grid,this.getSTUDENT_PORTAL_STUDENT_SIBLINGS_PERMISSIONS());

            			var alinfomodel = Academia.model.authentication.ALInfoModel;
                        var checkSchool = alinfomodel.get('wheatherSchool');
                    	if(Ext.isDefined(Ext.ComponentQuery.query('siblingdetailsgrid'))){
                    		var getGrid = Ext.ComponentQuery.query('siblingdetailsgrid')[0];
                        	Ext.each(getGrid.columns, function(currentColumn){
                        		if(currentColumn.dataIndex=="siblingCode")
    						   {
    							   currentColumn.setVisible(true);
    						   }if(currentColumn.dataIndex=="siblingProgramName")
     						   {
     							   currentColumn.setVisible(true);
     						   }if(currentColumn.dataIndex=="siblingBatchName")
     						   {
     							   currentColumn.setVisible(true);
     						   }if(currentColumn.dataIndex=="siblingPeriodName")
     						   {
                        			if(checkSchool)
                        			{
                        				currentColumn.setVisible(false);
                                    }else
     							   currentColumn.setVisible(true);
     						   }if(currentColumn.dataIndex=="siblingSectionName")
     						   {
     							   currentColumn.setVisible(true);
     						   }if(currentColumn.dataIndex=="siblingStatus")
     						   {
     							   currentColumn.setVisible(false);
     						   }
    					   }
                        	);
                        	getGrid.getView().refresh();
                    	}
            		}else{
            			this.doAccessControlValidation(grid, this.getSTUDENT_SIBLINGS_PERMISSIONS());
            		}
            	}
            },
            'siblingdetailsgrid[itemId=studentSiblingDetailsGrid] button[itemId=btnAdd]': {
            	click: function() {
            		var formWindow = this.getPersonCommonWindow();
            		this.showPersonCommonWindow(formWindow, 'SIBLING', 'studentSiblingForm',true);
            	}
            },
            'siblingdetailsgrid[itemId=studentSiblingDetailsGrid] button[itemId=btnEdit]': {
            	click: function(){
            		this.editPersonSiblingFormWindow('#studentSiblingDetailsGrid', 'studentSiblingForm', SERVERURL.SIBLING_RELATIONSHIP_FORM_DETAILS); 
            	}
            },
            'siblingdetailsgrid[itemId=studentSiblingDetailsGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewPersonSiblingFormWindow('#studentSiblingDetailsGrid', 'studentSiblingForm', SERVERURL.SIBLING_RELATIONSHIP_FORM_DETAILS); 
            		this.viewOtherAcadmyLocationId('#studentSiblingDetailsGrid', 'studentSiblingForm');
            	}
            },
            'siblingdetailsgrid[itemId=studentSiblingDetailsGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deletePersonSiblingRecord('#studentSiblingDetailsGrid', SERVERURL.PERSON_RELATIONSHIP_DELETE);
            	}
            },
            /*'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=studentSiblingForm]': {
                render: function(siblingForm) {
                	this.getPersonCommonWindow().doLayout();
                }
            },*/
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=studentSiblingForm] combo[itemId=relationShipField]': {
                render: function(combo, eOpts) {
                    this.onRenderSiblingRelationShipCombo(combo);
                },
                select : function(combo, record) {
                	var siblingForm = this.getPersonSiblingForm();
                	this.onSelectSiblingRelationshipComboValue(combo, '#studentSiblingForm', siblingForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=studentSiblingForm] textfield[itemId=siblingStudentId]': {
            	change: function(siblingForm, newValue, oldValue, eOpts){
                	var siblingForm = this.getPersonSiblingForm();
                	
                	var newValue = siblingForm.down("#siblingStudentId");
                	if(!isNullOrEmpty(newValue.value))
                	{
                	 siblingForm.down("#searchButtonId").setDisabled(false);
                	}else{
                	 siblingForm.down("#searchButtonId").setDisabled(true);
                	}
                	
                	this.onChangeResetInnerSiblingForm(siblingForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=studentSiblingForm] textfield[itemId=siblingStudentId]': {
            	render: function(combo, eOpts){
            		combo.getStore().getProxy().extraParams = { 
               		 isMultiAccessAllowForSibiling:true
               		
   				  };
                	
                	
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=studentSiblingForm] button[itemId=searchButtonId]': {
                click: function(){
                	var siblingForm = this.getPersonSiblingForm();
                	this.validateSiblingStudentId(siblingForm);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=studentSiblingForm] button[itemId=submitButtonId]': {
                click: function(){
                	 this.savePersonSibling('STUDENT', '#studentSiblingDetailsGrid', SERVERURL.PERSON_RELATIONSHIP_ADD, SERVERURL.PERSON_RELATIONSHIP_UPDATE);
                }
            },
            'personcommonwindow[itemId=personCommonWindow] siblingform[itemId=studentSiblingForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
            
            
            /**
             *  Identity Details
             */
            'identitydetailsgrid[itemId=studentIdentityDetailsGrid]': {
            	render: function(grid) {
            		this.loadGridStore('#studentIdentityDetailsGrid', SERVERURL.IDENTITY_DETAIL_GRID);
            		
            		if(this.getCurrentLoggedPortalId() == 7)
            		{
            			this.doAccessControlValidation(grid,this.getPARENT_PORTAL_STUDENT_IDENTITY_DETAILS_PERMISSIONS());
            		}else if(this.getCurrentLoggedPortalId() == 2){
            			this.doAccessControlValidation(grid,this.getFACULTY_PORTAL_STUDENT_IDENTITY_DETAILS_PERMISSIONS());
            		}else if(this.getCurrentLoggedPortalId() == 3){
            			this.doAccessControlValidation(grid,this.getSTUDENT_PORTAL_STUDENT_IDENTITY_DETAILS_PERMISSIONS());
            		}else{
            			this.doAccessControlValidation(grid, this.getSTUDENT_IDENTITY_DETAILS_PERMISSIONS());
            			this.addDataGridConfigButton(grid,this.getSTUDENT_IDENTITY_DETAILS_PERMISSIONS());
            		}
            	},
            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {

            		var searchResultGrid =  grid.ownerCt;
            		var columnName=searchResultGrid.columnManager.columns[cellIndex].dataIndex;

            		if(columnName=='documents'){
            			if (e.target.tagName == 'A') {
            				var documentId = record.data.documents[0].id;
            				if (!isNullOrEmpty(documentId)) {
            					this.getDocumentController().downloadDocumentFile(documentId);
            				}
            			}
            		}
            	}
            },
            'identitydetailsgrid[itemId=studentIdentityDetailsGrid] button[itemId=btnAdd]': {
            	click: function() {
            		var formWindow = this.getPersonCommonWindow();
            		this.showPersonCommonWindow(formWindow, 'IDENTITY_DETAILS', 'studentIdentityDetailsForm', true);
            	}
            },
            'identitydetailsgrid[itemId=studentIdentityDetailsGrid] button[itemId=btnEdit]': {
            	click: function(){
            		this.editIdentityDetailFormWindow('IDENTITY_DETAILS', 'studentIdentityDetailsForm', '#studentIdentityDetailsGrid');
            	}
            },
            'identitydetailsgrid[itemId=studentIdentityDetailsGrid] button[itemId=btnView]': {
            	click: function(){
            		this.viewIdentityDetailFormWindow('IDENTITY_DETAILS', 'studentIdentityDetailsForm', '#studentIdentityDetailsGrid');
            		var formWindow = this.getPersonCommonWindow();
                    var identitydetailsform = formWindow.down('identitydetailsform');
                    if(identitydetailsform != null && identitydetailsform != undefined){
                    	var identityDetailsDocId = identitydetailsform.down("#identityDetailsDocId");
                    	if(identityDetailsDocId != null && identityDetailsDocId != undefined){
                    		identityDetailsDocId.setVisible(false);
                    	}
                    }
            	}
            },
            'identitydetailsgrid[itemId=studentIdentityDetailsGrid] button[itemId=btnDelete]': {
            	click: function(){
            		//this.deleteIdentityDetailRecord('#studentIdentityDetailsGrid', SERVERURL.IDENTITY_DETAIL_DELETE,'STUDENT');
            		this.deleteIdentityDetailOfApplicantAndStudentRecord('#studentIdentityDetailsGrid', SERVERURL.IDENTITY_DETAIL_DELETE,'STUDENT');
            	
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=studentIdentityDetailsForm] button[itemId=submitButtonId]': {
            	click: function(){
            		this.savePersonIdentity('#studentIdentityDetailsGrid', SERVERURL.IDENTITY_DETAIL_CREATE, SERVERURL.IDENTITY_DETAIL_UPDATE);
            	}
            },	
            'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=studentIdentityDetailsForm] button[itemId=cancelButtonId]': {
            	click: this.closePersonCommonWindow
            },
            'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=studentIdentityDetailsForm]':{
            	afterrender: function(win){
            		var me = this;
            		var actualFollowUpDate = win.down('#actualFollowUpDate');
            		if(portalId != 1){
            			actualFollowUpDate.setReadOnly(true);
            		}
            	}
            },
            'personcommonwindow[itemId=personCommonWindow] identitydetailsform[itemId=studentIdentityDetailsForm] filefield[itemId=identityDetailsDocId]': {
            	change: function(fileField, value, eOpts) {
            		var $this = this;
            		value = value.replace('C:\\fakepath\\', '');
                	var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                	fileField.setRawValue(newValue);
                	if (!isNullOrEmpty(newValue)) {
                	    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                	    if ($this.isValidFileExtension(extension)) {
                	        var file = fileField.fileInputEl.dom.files[0];
                	        if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                	            fileField.reset();
                	            showWarningMessage(getPersonModuleTranslation('IDENTITY_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG_fOR_ADD_CAMPAIGN_DOCUMENT'));
                	        }
                	    } else {
                	        fileField.reset();
                	        showWarningMessage(getPersonModuleTranslation('IDENTITY_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                	    }
                	}
            	}
            }, 
            
            /******************************** Other Information***********************************/
            'otherinformationdetailsform[itemId=studentOtherinformationDetailsForm]': {
                render: function(form){
                	var url = SERVERURL.FIND_BY_ID_STUDENT_OTHER_INFORMATION+'userId=';
                	this.onRenderOtherInformationForm(url);
                	var portalId = this.getCurrentLoggedPortalId();
            		if(portalId == 7)
            		{
            			this.disableOtherInformaionFormPivileges(form, this.getPARENT_PORTAL_STUDENT_OTHER_INFORMATION_PERMISSIONS());	
            		}else if(portalId == 2){
            			this.disableOtherInformaionFormPivileges(form, this.getFACULTY_PORTAL_STUDENT_OTHER_INFORMATION_PERMISSIONS());	
            		}else if(portalId == 3){
            			this.disableOtherInformaionFormPivileges(form, this.getSTUDENT_PORTAL_STUDENT_OTHER_INFORMATION_PERMISSIONS());	
            		}else{
            			this.disableOtherInformaionFormPivileges(form, this.getSTUDENT_OTHER_INFORMATION_DETAILS_PERMISSIONS());
            		}
                }
            },
            'otherinformationdetailsform[itemId=studentOtherinformationDetailsForm] button[itemId=submitButtonId]': {
                click: function(){
                	var getUrl = SERVERURL.FIND_BY_ID_STUDENT_OTHER_INFORMATION+'userId=';
                	this.saveOtherInformation(SERVERURL.SAVE_STUDENT_OTHER_INFORMATION,getUrl,'STUDENT');
                }
            },
            
            /**
             *  Passport Details
             */
            'passportgrid[itemId=studentPassportGrid]': {
            	render: function(grid) {
            		var $this = this;
            		$this.loadGridStore('#studentPassportGrid', SERVERURL.PATH_STUDENT_PASSPORT_DETAIL_GRID_DATA);
            			var portalId = this.getCurrentLoggedPortalId();
            			if (portalId == 3){
            					$this.doAccessControlValidation(grid, $this.getSTUDENT_PORTAL_PASSPORT_PERMISSION());
            					var structure = grid.up('personinfostudentportal');
            					$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
            				   
            			}else if (portalId == 7) {
            					$this.doAccessControlValidation(grid,$this.getPARENT_PORTAL_PASSPORT_PERMISSION());
            					var structure = grid.up('personinfostudentportal');
            					$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
            				
            			}else if (portalId == 2){
            				this.doAccessControlValidation(grid,this.getFACULTY_PORTAL_PASSPORT_PERMISSION());
            			}else{
            				$this.doAccessControlValidation(grid,$this.getPASSPORT_DETAIL_PERMISSION());
            				var studentProfilePanel = grid.up('studentprofile');
                			var structure = studentProfilePanel.down('[region=center]');
                			var  store = grid.getStore();
                            store.load({
                                   callback:function() {
                                       if(store.getCount()>5) {
                                           $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
                                       }            
                                   }
                               });
            			}
            		
            	},
            	afterrender:function(grid){
    				var me = this;
    				setTimeout(function(){
    					me.addDataGridConfigButton(grid,me.getPASSPORT_DETAIL_PERMISSION());
    				},1000);

    			},
    			selectionchange: function(column, selected,eOpts ){
            		var grid = column.view.up('grid');
                	if(selected.length > '1'){
            				grid.down('#btnAdd').setDisabled(true);
            				grid.down('#btnEdit').setDisabled(true);
            				grid.down('#btnView').setDisabled(true);
            				grid.down('#btnDelete').setDisabled(false);
            			}else{
            				grid.down('#btnAdd').setDisabled(false);
            				grid.down('#btnEdit').setDisabled(false);
            				grid.down('#btnView').setDisabled(false);
            				grid.down('#btnDelete').setDisabled(false);
            			}
                	}
            },
            
            'passportgrid[itemId=studentPassportGrid] button[itemId=btnAdd]': {
            	click: function() {
                    this.isAdd=true;
            		this.passportMode='ADD';
            		var formWindow = this.getPersonCommonWindow();
            		formWindow = this.showPersonCommonWindow(formWindow, 'PASSPORT_DETAILS', 'studentPassportDetailsFormId', true);
	        		  if( formWindow != null ){
	        			  var form = formWindow.down('#studentPassportDetailsFormId');
	        			  var fileModifiedDate = form.down('#fileModifiedDate');
	        			  fileModifiedDate.setReadOnly(true);
	        		}
            	}
            },
            'passportgrid[itemId=studentPassportGrid] button[itemId=btnEdit]': {
            	click: function(){
            		this.isAdd=false;
            		this.passportMode='EDIT';
            		this.editPassportDetailWindow('PASSPORT_DETAILS', 'studentPassportDetailsFormId', '#studentPassportGrid', false);
            		this.studentDocPassportContainerWindow();
            		this.studentUrlPassportContainerWindow();
            	}
            },
            'passportgrid[itemId=studentPassportGrid] button[itemId=btnView]': {
            	click: function(){
            		var $this = this;
            		$this.isAdd=false;
            		$this.passportMode='VIEW';
            		$this.viewStudentPassportDetail('PASSPORT_DETAILS', 'studentPassportDetailsFormId', '#studentPassportGrid');
            		$this.studentDocPassportContainerWindow();
            		$this.studentUrlPassportContainerWindow();
            		var form = this.getStudentpassportdetailsform();
            		form.isValid();
            	}
            },
            'passportgrid[itemId=studentPassportGrid] button[itemId=btnDelete]': {
            	click: function() {
            		this.deleteStudentPassportDetail('#studentPassportGrid', SERVERURL.PATH_STUDENT_PASSPORT_DETAIL_DELETE);
            	}
            },
            'studentpassportdetailsform[itemId=studentPassportDetailsFormId] checkboxfield#isPrimary' :{
	 			change:function(val)
	 			{
	 				var form= this.getStudentpassportdetailsform();
	 				var id = form.down("#Student_Passport_Details_hidden_field");
	 				var isPrimaryFiled=form.down('#isPrimary');
					var portalId = this.getCurrentLoggedPortalId();
					if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
						var studentPortalGrid  = this.getPassportgrid().getStore();
						if(this.passportMode=='ADD'){
							if(studentPortalGrid.data.items.length!=null){
								studentPortalGrid.data.items.forEach(function(itemObj){
  								if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)){
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
										isPrimaryFiled.setValue(false);
  								}
                        	 });
                        	}
						}else if(this.passportMode=='EDIT'){
							if(studentPortalGrid.data.items.length!=null){
								studentPortalGrid.data.items.forEach(function(itemObj){
	  								if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)&&(itemObj.data.id != Number(id.getValue()))){
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
											isPrimaryFiled.setValue(false);
	  								}
	                        	 });
	                        	}
						}
						
					}else{
						var contentPanelTab = this.getContentPanelActiveTab();
		 				var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
						var gridStore  = personInfoPanel.down('passportgrid').getStore();
						if(this.passportMode=='ADD'){
							if(gridStore.data.items.length!=null){
                        	gridStore.data.items.forEach(function(itemObj){
  								if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)){
										showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
										isPrimaryFiled.setValue(false);
  								}
                        	 });
                        	}
						}else if(this.passportMode=='EDIT'){
							if(gridStore.data.items.length!=null){
	                        	gridStore.data.items.forEach(function(itemObj){
	  								if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)&&(itemObj.data.id != Number(id.getValue()))){
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
											isPrimaryFiled.setValue(false);
	  								}
	                        	 });
	                        	}
						}
					}
						
                        
	 			}
	 		},
            'studentpassportdetailsform[itemId=studentPassportDetailsFormId] button#uploadPassportDocItemId' : {
	 			click : function() {
	 				this.getDocumentController().showDocumentFormWindow('Student_Passport_Details_hidden_field','DOCUMENT');
	 				setTimeout(function(){
			            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
 			            form.down('#documentNameField').allowBlank=true;
 			            form.down('#documentNameField').setFieldLabel(getPersonModuleTranslation('DOCUMENTS_NAME'));
                    		},100);     
	 			}
	 		},
	 		
	 		'studentpassportdetailsform[itemId=studentPassportDetailsFormId] button#uploadPassportUrlItemId' : {
	 			click : function() {
	 				this.getDocumentController().showDocumentFormWindow('Student_Passport_Details_hidden_field','DOCUMENT_URL');
 					var formWindow = this.getDocumentformwindow();
 					if (!formWindow) {
 						Ext.widget('documentformwindow');
 						formWindow = this.getDocumentformwindow();
 					}
 					formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
	 			}
	 		},
	 	    
	  	     'documentformwindow[itemId=Student_Passport_Details_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
		 	    	click : function() {
		 			var $this = this;
		 			var isTransient = true;
		 			var module = 'studentPassport';
		 			var entityId;
		 			var entityType = 'studentPassportDocument';

		 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
		 					function(success,response,isCallBackTransient) {
		 				fields : ['id','documentId','documentName','submissionDate','path','createdBy','status','studentPassport','serialNo']
		 						var documentModel = new Academia.model.personinfo.common.personalinfo.StudentPassportDocumentModel();
		 						documentModel.set("documentName",response.name);
		 						documentModel.set("path",response.path);
		 						documentModel.set("type",response.type);
		 						documentModel.set("documentName",response.name);
		 						documentModel.set("createdBy",$this.getIdValueJson(
		 										response.createdBy.id,response.createdBy.value));
		 						if(documentModel.data.path.length > 255){
		 							showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
		 						}else{
		 							var StudentPassportDocGrid = $this.getStudentpassportdocumentgrid();
			 						var store = StudentPassportDocGrid.getStore();
			 						store.add(documentModel);
			 						if (StudentPassportDocGrid.isHidden() && store.data.items.length > 0) {
			 							StudentPassportDocGrid.setVisible(true);
			 						}
			 						var formPassport= Ext.ComponentQuery.query('studentpassportdetailsform')[0];
			 						var fileModifiedDate = formPassport.down("#fileModifiedDate");
			 						if($this.passportMode=='ADD'){
			 								 fileModifiedDate.setValue(dateRender(new Date()));
			 		 				}else{
			 							    fileModifiedDate.setValue(dateRender(new Date()));
			 		 				}
			 						$this.getDocumentController().closeDocumentFormWindow();
			 						   showSuccessMessage(getCommonTranslation('PASSPORT'),getCommonTranslation('PASSPORT_DOCUMENT_ADD_SUCCESSFULLY'));
		 						}
		 					}, isTransient);
		 		}
		 	},
		 	'documentformwindow[itemId=Student_Passport_Details_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
		 		click : function() {
		 			this.getDocumentController()
		 			.closeDocumentFormWindow();
            	
		 		}
		 	},
		 	
		 	
		 	 'documentformwindow[itemId=Student_Passport_Details_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
		 	    	click : function() {
		 			var $this = this;
		            var form = Ext.ComponentQuery.query('simpleurlform')[0];
			            form.down('#documentFormSubmitButtonId').setDisabled(true);
			            var formPassport= Ext.ComponentQuery.query('studentpassportdetailsform')[0];
			            var fileModifiedDate = formPassport.down("#fileModifiedDate");

		 				fields : ['id','documentId','documentName','path']
		 						var documentModelUrl = new Academia.model.personinfo.common.personalinfo.StudentPassportUrlModel();
		 			            var documentName=form.down('#documentNameField').getValue();
		 			            var UrlName=form.down('#documentUrlField').getValue();

		 			           documentModelUrl.set("documentName",documentName);
		 			           documentModelUrl.set("path",UrlName);
		 						var StudentPassportUrlGrid = Ext.ComponentQuery.query('studentpassporturlgrid')[0];
		 						var store2= StudentPassportUrlGrid.getStore();
		 						store2.add(documentModelUrl);
		 						if (StudentPassportUrlGrid.isHidden() && store2.data.items.length > 0) {
		 							StudentPassportUrlGrid.setVisible(true);
    		            				}
		 						if($this.passportMode=='ADD'){
	 								 fileModifiedDate.setValue(dateRender(new Date()));
		 						}else{
	 							    fileModifiedDate.setValue(dateRender(new Date()));
		 						}
		 						$this.getDocumentController().closeDocumentFormWindow();
		 						   showSuccessMessage(getCommonTranslation('PASSPORT'),getCommonTranslation('PASSPORT_URL_ADD_SUCCESSFULLY'));
		 					
		 		}
		 	},
		 	'documentformwindow[itemId=Student_Passport_Details_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
		 		click : function() {
		 			this.getDocumentController()
		 			.closeDocumentFormWindow();
		 		}
		 	},

		 		'studentpassportdetailsform[itemId=studentPassportDetailsFormId] button#submitButtonId' : {
		 			click : function() {
		               this.saveStudentPassportDetail('#studentPassportGrid', SERVERURL.PATH_STUDENT_PASSPORT_DETAIL_ADD, SERVERURL.PATH_STUDENT_PASSPORT_DETAIL_UPDATE);
		 			}
		 		},
		 		
		 		'studentpassportdetailsform[itemId=studentPassportDetailsFormId] button#cancelButtonId' : {
  	            	click: this.closePersonCommonWindow
	 			},
 		
 		'passportgrid[itemId= studentPassportGrid]':{
				cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
					if(columnName == "copyOfPassport"){
						if(e.target.tagName=='A'){
							if(record.data.copyOfPassports.length == 1){
								var whetherFile = false;
								var documentId= record.data.copyOfPassports["0"].id;
								if(!isNullOrEmpty(documentId)){
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
										method: 'GET',
										callback : function(opt, success, response){
											if(response.responseText == 'true') {
												var csvForm = Ext.create('Ext.form.Panel'); 
												csvForm.getForm().submit({
													target: '_blank',
													method:'GET',
													params :{
														access_token : Ext.Ajax.defaultHeaders.access_token
													},
													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
													standardSubmit :true
												});
											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
											}
										}
									});
								}} else if(record.data.copyOfPassports.length > 1){
									var docWindow = this.getStudentpassportdocumentlist();
									var ID = record.data.id;
									if (!docWindow) {
										docWindow = Ext.widget('studentpassportdocumentlist',{
											itemId:'studentpassportdocumentlist'
										});
									}
									docWindow.show();
									var studentpassportdetaildocumentlistgrid = docWindow.down('#studentpassportdocumentlistgridItemId');
									 var store = studentpassportdetaildocumentlistgrid.getStore();
									  store.getProxy().extraParams = {
	             						  ID: record.data.id
	             					  };
	             					  store.load();
								}
						}
					}
					if(columnName == "copyOfPassportUrl"){
						if(e.target.tagName=='A'){
							if(record.data.copyOfPassportUrls.length == 1){
								
							} else if(record.data.copyOfPassportUrls.length > 1){    	
									var docWindow = this.getStudentpassportdocurllist();
	             					  var ID = record.data.id;
	             					  if (!docWindow) {
	             						  docWindow = Ext.widget('studentpassportdocurllist',{
	             							  itemId:'studentpassportdocurllist'
	             						  });
	             					  }
	             					
									docWindow.show();
									var studentpassportdetaildocumenturllistgrid = docWindow.down('#studentpassportdocurllistgridItemId');
									 var store = studentpassportdetaildocumenturllistgrid.getStore();
									  store.getProxy().extraParams = {
	             						  ID: record.data.id
	             					  };
	             					  store.load();
								}
						  }
						}
				}
			},
		    
	  	     'studentpassportdocumentgrid button#btnDelete' : {
	 			 click : function() {
	 				 var $this = this;
	 				 var grid=$this.getStudentpassportdocumentgrid();
	 				var form = Ext.ComponentQuery.query('studentpassportdetailsform')[0];
	 				 if (grid.getSelectionModel().getCount() > 0) {
	 					 Ext.MessageBox
	 					 .confirm(
	 							 getPersonModuleTranslation('STUDENT_PASSPORT_DOCUMENT'),
	 							 getCommonTranslation('STUDENT_PASSPORT_DELETE_CONFIRM_MESSAGE'),
	 							function(btn, text) {
	 								 if (btn == 'yes') {
	 									if(this.passportMode=='ADD'){
						 					 var fileModifiedDate = form.down("#fileModifiedDate");
												 fileModifiedDate.setValue(dateRender(new Date()));
						 				}else{
						 					var fileModifiedDate = form.down("#fileModifiedDate");
											    fileModifiedDate.setValue(dateRender(new Date()));
						 				}
	 									 var store = grid.getStore();
	 									 var record = grid.getSelectionModel().getSelection()[0];
	 									 var id = record.id;
	 									 if (isNullOrEmpty(id)) {
	 									 }else{
	 										 if (record) {
	 											 store.remove(record);
	 											 showSuccessMessage(
	 													 getPersonModuleTranslation('STUDENT_PASSPORT_DOCUMENT'),
	 													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	 										 }
	 									 }
                    	this.remainingFieldsOfFeePayerForDFR(form);
	 								 }
	 							 });
	 				 } else {
	 					 showWarningMessage(
	 							 getPersonModuleTranslation('STUDENT_PASSPORT_DOCUMENT'),
	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 				 }
	 			 }
	 		 },
	          
	 		 'studentpassporturlgrid button#btnDelete' : {
	 			 click : function() {
	 				 var $this = this;
					 var grid = Ext.ComponentQuery.query('studentpassporturlgrid')[0];
					 var form = Ext.ComponentQuery.query('studentpassportdetailsform')[0];
	 				 if (grid.getSelectionModel().getCount() > 0) {
	 					 Ext.MessageBox
	 					 .confirm(
	 							 getPersonModuleTranslation('STUDENT_PASSPORT_URL'),
	 							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	 							function(btn, text) {
	 								 if (btn == 'yes') {
	 									if(this.passportMode=='ADD'){
						 					 var fileModifiedDate = form.down("#fileModifiedDate");
												 fileModifiedDate.setValue(dateRender(new Date()));
						 				}else{
						 					var fileModifiedDate = form.down("#fileModifiedDate");
											    fileModifiedDate.setValue(dateRender(new Date()));
						 				}
	 									 var store = grid.getStore();
	 									 var record = grid.getSelectionModel().getSelection()[0];
	 									 var id = record.id;
	 									 if (isNullOrEmpty(id)) {
	 									 }else{
	 										 if (record) {
	 											 store.remove(record);
	 											 showSuccessMessage(
	 													 getPersonModuleTranslation('STUDENT_PASSPORT_URL'),
	 													 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	 										 }
	 									 }

	 								 }
	 							 });
	 				 } else {
	 					 showWarningMessage(
	 							 getPersonModuleTranslation('STUDENT_PASSPORT_URL'),
	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 				 }
	 			 }
	 		 },
			
	 		'studentpassportdocumentgrid' : {
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = $this.getStudentpassportdocumentgrid();
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') {
							 var documentId = record
							 .get("documentId");
							 if (!isNullOrEmpty(documentId)) {
								 $this.getDocumentController().downloadDocumentFile(documentId);
							 }
						 }

					 }
				 }
			 },
		'studentpassportdocumentlistgrid':{
				render: function(grid) {
					var this$ = this;
					var portalId = this$.getCurrentLoggedPortalId();
					if(portalId==3) {
						this$.doAccessControlValidation(grid, this$.getSTUDENT_PASSPORT_DOCUMENT_PERMISSION());
					} else if(portalId==7) {
						this$.doAccessControlValidation(grid, this$.getPARENT_PASSPORT_DOCUMENT_PERMISSION());
					} else if(portalId==2) {
						this$.doAccessControlValidation(grid, this$.getFACULTY_PASSPORT_DOCUMENT_PERMISSION());
					} else {
						this$.doAccessControlValidation(grid, this$.getPASSPORT_DOCUMENT_PERMISSION());
					}
	            	grid.down('#downloadDocumentItemId').setVisible(true);
				},
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName == "documentName"){
						if(e.target.tagName=='A'){
							var documentId=record.get('documentId');
							if(!isNullOrEmpty(documentId)){
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
									method: 'GET',
									callback : function(opt, success, response){
										if(response.responseText == 'true') {
											var csvForm = Ext.create('Ext.form.Panel'); 
											csvForm.getForm().submit({
												target: '_blank',
												method:'GET',
												params :{
													access_token : Ext.Ajax.defaultHeaders.access_token
												},
												headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
												url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
												standardSubmit :true
											});
											showSuccessMessage(getCommonTranslation('PASSPORT'),getCommonTranslation('DOWNLOAD_PASSPORT_DOCUMENT_ADD_SUCCESSFULLY'));
										} else {
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
										}
									}
								});
							}
						}
					}
				}
			},
			
			'studentpassportdocumentlistgrid button[itemId=downloadDocumentItemId]':{
				click:function(obj){
					var $this = this;
					var form = $this.getStudentpassportdocumentlist();
					var StudentPassportDetailActionGrid=form.down('#studentpassportdocumentlistgridItemId');
					if (StudentPassportDetailActionGrid.getSelectionModel().getCount() > 0) {
						var records = StudentPassportDetailActionGrid.getSelectionModel().getSelection();
						var dispatchZipName = "Student Passport Detail Document";
						var saveModel=[];  
						for(var i in records){
							if(!isNullOrEmpty(records[i].get('path'))) {
								saveModel.push(records[i].get('path'));
							}
							showConfirmMessage(getCommonTranslation('STUDENT_PASSPORT_DETAIL_DOCUMENTS'),
									getCommonTranslation('STUDENT_PASSPORT_DETAIL_DOCUMENTS_ALERT'),
									function(btn, text) {
								if (btn == 'yes') {
									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
									$this.getController('Academia.controller.document.DocumentController')
									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
									showSuccessMessage(getCommonTranslation('PASSPORT'),getCommonTranslation('DOWNLOAD_PASSPORT_DOCUMENT_SUCCESSFULLY'));
								}
								
							});

							
						}
					}
					else {
						$this.hideWindowMask();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
      	 },
      	 
	        'studentpassportdocgrid' : {
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = $this
					 .getStudentpassportdocgrid();
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') {
							 var documentId = record.get("documentId");
							 if (!isNullOrEmpty(documentId)) {
								 $this.getDocumentController().downloadDocumentFile(documentId);
							 }
						 }

					 }
				 }
			 },
			 'studentpassportdocurllistgrid':{
				 render: function(grid) {
					 var this$ = this; 
					 var portalId = this$.getCurrentLoggedPortalId();
					 if(portalId==3) {
						 this$.doAccessControlValidation(grid, this$.getSTUDENT_PASSPORT_URL_PERMISSION());
					 } else if(portalId==7) {
						 this$.doAccessControlValidation(grid, this$.getPARENT_PASSPORT_URL_PERMISSION());
					 } else if(portalId==2) {
						 this$.doAccessControlValidation(grid, this$.getFACULTY_PASSPORT_URL_PERMISSION());
					 } else {
						 this$.doAccessControlValidation(grid, this$.getPASSPORT_URL_PERMISSION());
					 }
				 }
			 },
			 'studentpassportdocurllistgrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = $this.getStudentpassportdocurllist();  
	 					var passportDetaillist= $this.getPassportgrid();
						var studentPassportUrlGrid = Ext.ComponentQuery.query('studentpassporturlgrid')[0];
	 					var studentPassportDetaillistgrid=form.down('#studentpassportdocurllistgridItemId');
	 					if (studentPassportDetaillistgrid.getSelectionModel().getCount() > 0) {
	 						var records = studentPassportDetaillistgrid.getSelectionModel().getSelection();
	 						var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
	 							showConfirmMessage(getCommonTranslation('STUDENT_PASSPORT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",
	 									type: 'rest',
	 									url : SERVERURL.PATH_STUDENT_PASSPORT_URL_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {

	 										Ext.getBody().unmask();
	 										showSuccessMessage(getCommonTranslation('STUDENT_PASSPORT'),getCommonTranslation('STUDENT_PASSPORT_DOCUMENT_SUCCESS_DELETE_MSG'));	 
	 										studentPassportDetaillistgrid.store.reload();
	 										passportDetaillist.store.reload();
	 										studentPassportDetaillistgrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },
	      
			 'studentpassportdocumentlistgrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = $this.getStudentpassportdocumentlist();  
	 					var passportDetaillist= $this.getPassportgrid();
						var studentPassportDocumentGrid = Ext.ComponentQuery.query('studentpassportdocumentgrid')[0];
	 					var studentPassportDetaillistgrid=form.down('#studentpassportdocumentlistgridItemId');
	 					if (studentPassportDetaillistgrid.getSelectionModel().getCount() > 0) {
	 						var records = studentPassportDetaillistgrid.getSelectionModel().getSelection();
	 						var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
	 							showConfirmMessage(getCommonTranslation('STUDENT_PASSPORT'),getCommonTranslation('STUDENT_PASSPORT_DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",
	 									type: 'rest',
	 									url : SERVERURL.PATH_STUDENT_PASSPORT_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {

	 										Ext.getBody().unmask();
	 										showSuccessMessage(getCommonTranslation('STUDENT_PASSPORT'),getCommonTranslation('STUDENT_PASSPORT_DOCUMENT_SUCCESS_DELETE_MSG'));	 
	 										studentPassportDetaillistgrid.store.reload();
	 										passportDetaillist.store.reload();
	 										studentPassportDetaillistgrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },
            
			 /**
             *  Visa Details
             */
            'visadetailgrid[itemId=studentVisaGrid]': {
            	render: function(grid) {
            		var $this = this;
            		$this.loadGridStore('#studentVisaGrid', SERVERURL.PATH_STUDENT_VISA_DETAIL_GRID_DATA);
            		var portalId = this.getCurrentLoggedPortalId();
            		if (portalId == 7) {
            			$this.doAccessControlValidation(grid,$this.getPARENT_PORTAL_VISA_DETAIL_PERMISSION());
            			var structure = grid.up('personinfostudentportal');
            			$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
            		}else if (portalId == 2){
            			$this.doAccessControlValidation(grid,$this.getFACULTY_PORTAL_VISA_DETAIL_PERMISSION());
            			var studentProfilePanel = grid.up('studentprofile');
            			var structure = studentProfilePanel.down('[region=center]');
            			$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
            		}else if (portalId == 3){
            			$this.doAccessControlValidation(grid,$this.getSTUDENT_PORTAL_VISA_DETAIL_PERMISSION());
    					var structure = grid.up('personinfostudentportal');
                        $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
            		}else{
            			$this.doAccessControlValidation(grid,$this.getVISA_DETAIL_PERMISSION());
        			var studentProfilePanel = grid.up('studentprofile');
             		var structure = studentProfilePanel.down('[region=center]');
             		var  store = grid.getStore();
                    store.load({
                           callback:function() {
                               if(store.getCount()>5) {
                                   $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
                               }            
                           }
                       });
            			
            		}
            	},
            	afterrender:function(grid){
    				var me = this;
    				var portalId = this.getCurrentLoggedPortalId();
            		if (portalId == 7) {
            			me.addDataGridConfigButton(grid,me.getPARENT_PORTAL_VISA_DETAIL_PERMISSION());
            		}else if (portalId == 2){
            			me.addDataGridConfigButton(grid,me.getFACULTY_PORTAL_VISA_DETAIL_PERMISSION());
            		}else if (portalId == 3){
            			me.addDataGridConfigButton(grid,me.getSTUDENT_PORTAL_VISA_DETAIL_PERMISSION());
            		}else{
    					me.addDataGridConfigButton(grid,me.getVISA_DETAIL_PERMISSION());
            		}
    			},
    			selectionchange: function(column, selected,eOpts ){
                    var grid = column.view.up('grid');
                    if(selected.length > '1'){
                            grid.down('#btnAdd').setDisabled(true);
                            grid.down('#btnEdit').setDisabled(true);
                            grid.down('#btnView').setDisabled(true);
                            grid.down('#btnDelete').setDisabled(false);
                        }else{
                            grid.down('#btnAdd').setDisabled(false);
                            grid.down('#btnEdit').setDisabled(false);
                            grid.down('#btnView').setDisabled(false);
                            grid.down('#btnDelete').setDisabled(false);
                        }
                    },
    			cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
					if(columnName == "visaUploadDocument"){
						if(e.target.tagName=='A'){
							if(record.data.studentVisaDocument.length == 1){
								var whetherFile = false;
								var documentId= record.data.studentVisaDocument["0"].id;
								if(!isNullOrEmpty(documentId)){
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
										method: 'GET',
										callback : function(opt, success, response){
											if(response.responseText == 'true') {
												var csvForm = Ext.create('Ext.form.Panel'); 
												csvForm.getForm().submit({
													target: '_blank',
													method:'GET',
													params :{
														access_token : Ext.Ajax.defaultHeaders.access_token
													},
													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
													standardSubmit :true
												});
											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
											}
										}
									});
								}} else if(record.data.studentVisaDocument.length > 1){
									var docWindow = this.getStudentvisadocumentlist();
									var ID = record.data.id;
									if (!docWindow) {
										docWindow = Ext.widget('studentvisadocumentlist',{
											itemId:'studentvisadocumentlist'
										});
									}
									docWindow.show();
									var studentvisadetaildocumentlistgrid = docWindow.down('#studentvisadocumentlistgridItemId');
									 var store = studentvisadetaildocumentlistgrid.getStore();
									  store.getProxy().extraParams = {
	             						  ID: record.data.id
	             					  };
	             					  store.load();
								}
						}
					}
					if(columnName == "visaUploadUrl"){
						if(e.target.tagName=='A'){
							if(record.data.studentVisaDocumentUrl.length == 1){
								
							} else if(record.data.studentVisaDocumentUrl.length > 1){    	
									var docWindow = this.getStudentvisadocurllist();
	             					  var ID = record.data.id;
	             					  	             					  
	             					 if (!docWindow) {
										docWindow = Ext.widget('studentvisadocurllist',{
											itemId:'studentvisadocurllist'
										});
	             					 }
									docWindow.show();
									
									var studentvisadetaildocumenturllistgrid = docWindow.down('#studentvisadocurllistgridItemId');
									 var store = studentvisadetaildocumenturllistgrid.getStore();
									  store.getProxy().extraParams = {
	             						  ID: record.data.id
	             					  };
	             					  store.load();
								}
						  }
						}
				}
            
            },
            
            'visadetailgrid[itemId=studentVisaGrid] button[itemId=btnAdd]': {
            	click: function() {
            		this.isAdd=true;
            		this.visaMode = 'ADD';
            		var formWindow = this.getPersonCommonWindow();
                    this.showPersonCommonWindow(formWindow, 'VISA_FORM', 'studentVisaForm',true);
                },
                
            },
            'visadetailgrid[itemId=studentVisaGrid] button[itemId=btnEdit]': {
            	click: function(){
            		this.isAdd=false;
            		this.visaMode='EDIT';
            		this.editVisaDetailWindow('VISA_FORM', 'studentVisaForm', '#studentVisaGrid', false);
            		this.studentDocVisaContainerWindow();
            		this.studentUrlVisaContainerWindow();
            		
            	}
            },
            'visadetailgrid[itemId=studentVisaGrid] button[itemId=btnView]': {
            	click: function(){
            		this.isAdd=false;
            		this.visaMode='VIEW';
            		this.viewStudentVisaDetail('VISA_FORM', 'studentVisaForm', '#studentVisaGrid', true);
            		this.studentDocVisaContainerWindow();
            		this.studentUrlVisaContainerWindow();
            		var form =  this.getVisaform();
            		form.isValid();
            	}
            },
            'visadetailgrid[itemId=studentVisaGrid] button[itemId=btnDelete]': {
            	click: function(){
            		this.deleteStudentVisaDetail('#studentVisaGrid', SERVERURL.PATH_STUDENT_VISA_DETAIL_DELETE);
            	}
            },
            'visaform[itemId=studentVisaForm]': {
            	afterrender: function(obj) {
                	var form = obj.getForm();
                	var visaTypeStore = form.findField('visaType').getStore();
                	visaTypeStore.getProxy().extraParams={
        				type:'Visa Type'
        			};
                	
                	var visaStatusStore = form.findField('visaStatus').getStore();
                	visaStatusStore.getProxy().extraParams={
        				type:'Visa Status'
        			};
                	
                	if(this.isAdd){
                		obj.up().setTitle(getCommonTranslation('ADD_VISA'));
    				}else{
    					obj.up().setTitle(getCommonTranslation('EDIT_VISA'));
    				}
                }
            },
            
            'visaform[itemId=studentVisaForm] button#visaUploadFileItemId': {
            	click : function() {
	 				this.getDocumentController().showDocumentFormWindow('visa_detail_hidden_field','DOCUMENT');
	 				setTimeout(function(){
			            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
 			            form.down('#documentNameField').allowBlank=true;
 			            form.down('#documentNameField').setFieldLabel(getPersonModuleTranslation('DOCUMENT_DETAILS'));
            		},100); 
	 			}
            },
            
            'visaform[itemId=studentVisaForm] button#visaUploadURLItemId': {
            	click : function() {
	 				this.getDocumentController().showDocumentFormWindow('visa_detail_hidden_field','DOCUMENT_URL');
	 				var formWindow = this.getDocumentformwindow();
 					if (!formWindow) {
 						Ext.widget('documentformwindow');
 						formWindow = this.getDocumentformwindow();
 					}
 					formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
	 			}
            },
            
            
            'documentformwindow[itemId=visa_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
	 	    	click : function() {
	 			var $this = this;
	 			var isTransient = true;
	 			var module = 'studentVisa';
	 			var entityId;
	 			var entityType = 'studentVisaDocument';
	 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
	 					function(success,response,isCallBackTransient) {
	 				fields : ['id','name','documentName','submissionDate','path','createdBy','status','documentIdCount']
	 						var documentModel = new Academia.model.personinfo.common.personalinfo.StudentVisaDocumentModel();
	 						documentModel.set("name",response.name);
	 						documentModel.set("path",response.path);
	 						documentModel.set("type",response.type);
	 						documentModel.set("documentName",response.name);
	 						documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
	 						if(documentModel.data.path.length > 255){
	                              showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
	                          }else {
			 						var StudentVisaDocGrid = $this.getStudentvisadocumentgrid();
			 						var store = StudentVisaDocGrid.getStore();
			 						store.add(documentModel);
			 						if (StudentVisaDocGrid.isHidden() && store.data.items.length > 0) {
			 							StudentVisaDocGrid.setVisible(true);
			 						}
			 						$this.getDocumentController().closeDocumentFormWindow();
			 						showSuccessMessage(getCommonTranslation('STUDENT_VISA'),getCommonTranslation('VISA_DOCUMENT_ADD_SUCCESSFULLY'));
	                          }
	 					}, isTransient);
		 		}
		 	},
		 	
		 	'documentformwindow[itemId=visa_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
		 		click : function() {
		 			this.getDocumentController()
		 			.closeDocumentFormWindow();
		 		}
		 	},
		 	
		 	'documentformwindow[itemId=visa_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
	 	    	click : function() {
	 			var $this = this;
	 			var form = Ext.ComponentQuery.query('simpleurlform')[0];
	            form.down('#documentFormSubmitButtonId').setDisabled(true);
	 				fields : ['id','documentId','documentName','path','createdBy']
	 						var documentModelUrl = new Academia.model.personinfo.common.personalinfo.StudentVisaUrlModel();
				            var form = Ext.ComponentQuery.query('simpleurlform')[0];

	 			            var documentName=form.down('#documentNameField').getValue();
	 			            var UrlName=form.down('#documentUrlField').getValue();
	 			            documentModelUrl.set("documentName",documentName);
	 			            documentModelUrl.set("path",UrlName);
	 			            
	 			           documentModelUrl.set("type",'DOCUMENT');
	 			           var userId = this.getCurrentlyLoggedInUser()
	 			           documentModelUrl.set("createdBy",$this.getIdValueJson(userId.id,userId.value));
	 			           
                    	  var StudentVisaUrlGrid = Ext.ComponentQuery.query('studentvisaurlgrid')[0];
                    	  var store2= StudentVisaUrlGrid.getStore();
                    	  store2.add(documentModelUrl);
                    	  if (StudentVisaUrlGrid.isHidden() && store2.data.items.length > 0) {
                    		  StudentVisaUrlGrid.setVisible(true);
                    	  }
                    	  $this.getDocumentController().closeDocumentFormWindow();
                    	  showSuccessMessage(getCommonTranslation('STUDENT_VISA'),getCommonTranslation('VISA_URL_ADD_SUCCESSFULLY'));
	 						
	 		}
	 	},
            
		 	'documentformwindow[itemId=visa_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
		 		click : function() {
		 			this.getDocumentController()
		 			.closeDocumentFormWindow();
		 		}
		 	},
		 	
		 	'visaform[itemId=studentVisaForm] button#submitButtonId' : {
	 			click : function() {
	               this.saveStudentVisaDetail('#studentVisaGrid', SERVERURL.PATH_STUDENT_VISA_DETAIL_ADD, SERVERURL.PATH_STUDENT_VISA_DETAIL_UPDATE);

	 			}
	 		},
	 		
	 		'visaform[itemId=studentVisaForm] button#cancelButtonId' : {
	            	click: this.closePersonCommonWindow
 			},
 			
 			'studentvisadocumentgrid button#btnDelete' : {
 	 			 click : function() {
 	 				 var $this = this;
 	 				 var grid=$this.getStudentvisadocumentgrid();
 	 				 if (grid.getSelectionModel().getCount() > 0) {
 	 					 Ext.MessageBox
 	 					 .confirm(
 	 							getCommonTranslation('STUDENT_VISA'),
 	 							 getCommonTranslation('STUDENT_VISA_DELETE_CONFIRM_MESSAGE'),
 	 							function(btn, text) {
 	 								 if (btn == 'yes') {
 	 									 var store = grid.getStore();
 	 									 var record = grid.getSelectionModel().getSelection()[0];
 	 									 var id = record.id;
 	 									 if (isNullOrEmpty(id)) {
 	 									 }else{
 	 										 if (record) {
 	 											 store.remove(record);
 	 											 showSuccessMessage(getCommonTranslation('STUDENT_VISA'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
 	 											 if(store.data.items.length == 0) {
 	 												grid.setVisible(false);
 	 					 						}
 	 										 }
 	 									 }

 	 								 }
 	 							 });
 	 				 } else {
 	 					 showWarningMessage(
 	 							getCommonTranslation('STUDENT_VISA'),
 	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
 	 				 }
 	 			 }
 	 		 },
 	 		 
 	 		'studentvisaurlgrid button#btnDelete' : {
	 			 click : function() {
	 				 var $this = this;
					 var grid = Ext.ComponentQuery.query('studentvisaurlgrid')[0];
	 				 if (grid.getSelectionModel().getCount() > 0) {
	 					 Ext.MessageBox
	 					 .confirm(
	 							 getPersonModuleTranslation('STUDENT_VISA_URL'),
	 							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	 							function(btn, text) {
	 								 if (btn == 'yes') {
	 									 var store = grid.getStore();
	 									 var record = grid.getSelectionModel().getSelection()[0];
	 									 var id = record.id;
	 									 if (isNullOrEmpty(id)) {
	 									 }else{
	 										 if (record) {
	 											 store.remove(record);
	 											 showSuccessMessage(
												 getPersonModuleTranslation('STUDENT_VISA_URL'),
												 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	 											 if(store.data.items.length == 0) {
	 												grid.setVisible(false);
	 					 						}
	 										 }
	 									 }
	 								 }
	 							 });
	 				 } else {
	 					 showWarningMessage(
	 							 getPersonModuleTranslation('STUDENT_PASSPORT_URL'),
	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 				 }
	 			 }
	 		 },
	 	
	 		 
	 		'studentvisadocumentgrid' : {
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = $this.getStudentvisadocumentgrid();
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') {
							 var documentId = record.get("ecrptydocumentId");
							 if (!isNullOrEmpty(documentId)) {
								 $this.getDocumentController().downloadDocumentFile(documentId);
							 }
						 }

					 }
				 }
			 },
	 		'studentvisaocumentlistgrid':{
				render: function(grid) {
				},
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName == "documentName"){
						if(e.target.tagName=='A'){
							var documentId=record.get('ecrptydocumentId');
							if(!isNullOrEmpty(documentId)){
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
									method: 'GET',
									callback : function(opt, success, response){
										if(response.responseText == 'true') {
											var csvForm = Ext.create('Ext.form.Panel'); 
											csvForm.getForm().submit({
												target: '_blank',
												method:'GET',
												params :{
													access_token : Ext.Ajax.defaultHeaders.access_token
												},
												headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
												url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
												standardSubmit :true
											});
										} else {
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
										}
									}
								});
							}
						}
					}
				}
			},
			
			'studentvisadocumentlistgrid button[itemId=downloadDocumentItemId]':{
				click:function(obj){
					var $this = this;
					var form = $this.getStudentvisadocumentlist();
//					var StudentVisaDetailActionGrid=form.down('#studentvisadocumentlistgridItemId');
					var StudentVisaDetailActionGrid=obj.up('grid');
					if (StudentVisaDetailActionGrid.getSelectionModel().getCount() > 0) {
						var records = StudentVisaDetailActionGrid.getSelectionModel().getSelection();
						var dispatchZipName = "Student Visa Detail Document";
						var saveModel=[];  
						for(var i in records){
							if(!isNullOrEmpty(records[i].get('path'))) {
								saveModel.push(records[i].get('path'));
							}
							showConfirmMessage(getCommonTranslation('STUDENT_VISA_DETAIL_DOCUMENTS'),
									getCommonTranslation('STUDENT_VISA_DETAIL_DOCUMENTS_ALERT'),
									function(btn, text) {
								if (btn == 'yes') {
									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
									$this.getController('Academia.controller.document.DocumentController')
									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
								}
							});
						}
					}
					else {
						$this.hideWindowMask();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
					//this.documentReportDocumentZip('student');
				}
     	 },
     	 
     	'studentvisadocumentlistgrid' : {
	     		render: function(grid) {
					var this$ = this;
					var portalId = this$.getCurrentLoggedPortalId();
					if(portalId==3) {
						this$.doAccessControlValidation(grid, this$.getSTUDENT_VISA_DOCUMENT_PERMISSION());
					} else if(portalId==7) {
						this$.doAccessControlValidation(grid, this$.getPARENT_VISA_DOCUMENT_PERMISSION());
					} else if(portalId==2) {
						this$.doAccessControlValidation(grid, this$.getFACULTY_VISA_DOCUMENT_PERMISSION());
					} else {
						this$.doAccessControlValidation(grid, this$.getVISA_DOCUMENT_PERMISSION());
					}
	            	grid.down('#downloadDocumentItemId').setVisible(true);
				},
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = grid.up('grid');
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') {
							 var documentId = record.get("ecrptydocumentId");
							 if (!isNullOrEmpty(documentId)) {
								 $this.getDocumentController().downloadDocumentFile(documentId);
							 }
						 }
					 }
				 }
			 },
			 
			 'visaform[itemId=studentVisaForm] checkboxfield#visaIsPrimaryItemId' :{
                 change:function(val)
                 {
                     var form= this.getVisaform();
                     var id = form.down("#visa_detail_hidden_field");
                     var isPrimaryFiled=form.down('#visaIsPrimaryItemId');
    	 				var gridStore  = this.getVisadetailgrid().getStore();
                        if(this.visaMode=='ADD'){
                            if(gridStore.data.items.length!=null){
                            gridStore.data.items.forEach(function(itemObj){
                                  if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)){
                                        showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
                                       isPrimaryFiled.setValue(false);
                                  }
                             });
                            }
                        }else if(this.visaMode=='EDIT'){
                            if(gridStore.data.items.length!=null){
                                gridStore.data.items.forEach(function(itemObj){
                                      if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)&&(itemObj.data.id != Number(id.getValue()))){
                                            showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
                                            isPrimaryFiled.setValue(false);
                                      }
                                 });
                                }
                        }
                        
                 }
             },
             'studentvisadocurllistgrid':{
            	 render: function(grid) {
 					var this$ = this;
 					var portalId = this$.getCurrentLoggedPortalId();
 					if(portalId==3) {
 						this$.doAccessControlValidation(grid, this$.getSTUDENT_VISA_URL_PERMISSION());
 					} else if(portalId==7) {
 						this$.doAccessControlValidation(grid, this$.getPARENT_VISA_URL_PERMISSION());
 					} else if(portalId==2) {
 						this$.doAccessControlValidation(grid, this$.getFACULTY_VISA_URL_PERMISSION());
 					} else {
 						this$.doAccessControlValidation(grid, this$.getVISA_URL_PERMISSION());
 					}
 				}
             },
             'studentvisadocurllistgrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = $this.getStudentvisadocurllist();  
	 					var studentVisaGrid= $this.getVisadetailgrid();
	 					var studentVisaUrlListgrid=form.down('#studentvisadocurllistgridItemId');
	 					if (studentVisaUrlListgrid.getSelectionModel().getCount() > 0) {
	 						var records = studentVisaUrlListgrid.getSelectionModel().getSelection();
	 						var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
	 							showConfirmMessage(getPersonModuleTranslation('STUDENT_VISA_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",
	 									type: 'rest',
	 									url : SERVERURL.PATH_STUDENT_VISA_URL_DELETE+'?fileDocumentIds='+ids.join(),
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {
	 										Ext.getBody().unmask();
	 										showSuccessMessage(getPersonModuleTranslation('STUDENT_VISA_URL'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
	 										studentVisaUrlListgrid.store.reload();
	 										studentVisaGrid.store.reload();
	 										studentVisaUrlListgrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },
	      
			 'studentvisadocumentlistgrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = this.getStudentvisadocumentlist();
						var studentVisalistgrid=obj.up('grid');
	 					var studentVisaGrid= $this.getVisadetailgrid();
	 					if (studentVisalistgrid.getSelectionModel().getCount() > 0) {
	 						var records = studentVisalistgrid.getSelectionModel().getSelection();
	 						var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
	 							showConfirmMessage(getCommonTranslation('STUDENT_VISA'),getCommonTranslation('STUDENT_VISA_DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",
	 									type: 'rest',
	 									url : SERVERURL.PATH_STUDENT_VISA_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {
	 										Ext.getBody().unmask();
	 										showSuccessMessage(getCommonTranslation('STUDENT_VISA'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
	 										studentVisalistgrid.store.reload();
	 										studentVisaGrid.store.reload();
	 										studentVisalistgrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },
	 	
	 	    	/**
	       	   *  Insurance Details
	        */
	       	 
	       	'studentinsurancedetailsgrid[itemId=studentInsuranceDetailsGrid]': {
	           	render: function(grid) {
	           		var $this = this;
	           		$this.loadGridStore('#studentInsuranceDetailsGrid', SERVERURL.PATH_STUDENT_INSURANCE_DETAIL_GRID_DATA);
	           		var portalId = this.getCurrentLoggedPortalId();
		           	 if (portalId == 3){
	         			$this.doAccessControlValidation(grid,$this.getSTUDENT_PORTAL_INSURANCE_DETAIL_PERMISSION());
	 					var structure = grid.up('personinfostudentportal');
	                     $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
		           	 }else if (portalId == 7){
		           		$this.doAccessControlValidation(grid,$this.getPARENT_PORTAL_INSURANCE_DETAIL_PERMISSION());
	 					var structure = grid.up('personinfostudentportal');
	                     $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
		           	 }else if (portalId == 2){
		           		$this.doAccessControlValidation(grid,$this.getFACULTY_PORTAL_INSURANCE_DETAIL_PERMISSION());
		           		var structure = grid.up('studentprofile');
	                     $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
		           	 }else{
		           		 $this.doAccessControlValidation(grid, this.getINSURANCE_DETAILS_PERMISSION())
		           		 var studentProfilePanel = grid.up('studentprofile');
		           		 var structure = studentProfilePanel.down('[region=center]');
		           	     var store = grid.getStore();
                         store.load({
                            callback:function() {
                                if(store.getCount()>5) {
                                    $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
                                }            
                            }
                        });
		           	 }
	           		
	           	},
	           	afterrender:function(grid){
	   				var me = this;
	   				var portalId = this.getCurrentLoggedPortalId();
	   				if (portalId == 3){
            			me.addDataGridConfigButton(grid,me.getSTUDENT_PORTAL_INSURANCE_DETAIL_PERMISSION());
            		}else if (portalId == 7) {
            			me.addDataGridConfigButton(grid,me.getPARENT_PORTAL_INSURANCE_DETAIL_PERMISSION());
            		}else if (portalId == 2){
            			me.addDataGridConfigButton(grid,me.getFACULTY_PORTAL_INSURANCE_DETAIL_PERMISSION());
            			
            		}else{
            			me.addDataGridConfigButton(grid,me.getINSURANCE_DETAILS_PERMISSION());
            		}
//	   				setTimeout(function(){
//	   				},1000);
	   			},
	   			
	   			selectionchange: function(column, selected,eOpts ){
	                   var grid = column.view.up('grid');
		                if(selected.length > '1'){
	                       grid.down('#btnAdd').setDisabled(true);
	                       grid.down('#btnEdit').setDisabled(true);
	                       grid.down('#btnView').setDisabled(true);
	                       grid.down('#btnDelete').setDisabled(false);
	                   }else{
	                       grid.down('#btnAdd').setDisabled(false);
	                       grid.down('#btnEdit').setDisabled(false);
	                       grid.down('#btnView').setDisabled(false);
	                       grid.down('#btnDelete').setDisabled(false);
	                   }
	               },
	               
	               cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
						var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
						if(columnName == "studentInsuranceDocuments"){
							if(e.target.tagName=='A'){
								if(record.data.studentInsuranceDocuments.length == 1){
									var whetherFile = false;
									var documentId= record.data.studentInsuranceDocuments["0"].id;
									if(!isNullOrEmpty(documentId)){
										Ext.Ajax.request({
											type: 'rest',
											url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
											method: 'GET',
											callback : function(opt, success, response){
												if(response.responseText == 'true') {
													var csvForm = Ext.create('Ext.form.Panel'); 
													csvForm.getForm().submit({
														target: '_blank',
														method:'GET',
														params :{
															access_token : Ext.Ajax.defaultHeaders.access_token
														},
														headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
														url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
														standardSubmit :true
													});
												} else {
													showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
												}
											}
										});
									}} else if(record.data.studentInsuranceDocuments.length > 1){
										var docWindow = this.getStudentinsurancedocumentlist();
										var ID = record.data.id;
										if (!docWindow) {
											docWindow = Ext.widget('studentinsurancedocumentlist',{
												itemId:'studentinsurancedocumentlist'
											});
										}
										docWindow.show();
										var studentinsurancedetaildocumentlistgrid = docWindow.down('#studentinsurancedocumentlistgridItemId');
										 var store = studentinsurancedetaildocumentlistgrid.getStore();
										  store.getProxy().extraParams = {
		             						  ID: record.data.id
		             					  };
		             					  store.load();
									}
							}
						}
						if(columnName == "studentInsuranceDocumentUrls"){
							if(e.target.tagName=='A'){
								if(record.data.studentInsuranceDocumentUrls.length == 1){
									
								} else if(record.data.studentInsuranceDocumentUrls.length > 1){    	
										var docWindow = this.getStudentinsurancedocurllist();
		             					  var ID = record.data.id;
		             					  if (!docWindow) {
		             						  docWindow = Ext.widget('studentinsurancedocurllist',{
		             							  itemId:'studentinsurancedocurllist'
		             						  });
		             					  }
		             					
										docWindow.show();
										var studentinsurancedocurllistgrid = docWindow.down('#studentinsurancedocurllistgridItemId');
										 var store = studentinsurancedocurllistgrid.getStore();
										  store.getProxy().extraParams = {
		             						  ID: record.data.id
		             					  };
		             					  store.load();
									}
							  }
							}
					}
	           },
	           'studentinsurancedetailsgrid[itemId=studentInsuranceDetailsGrid] button[itemId=btnAdd]': {
	            	click: function() {
	            		this.isAdd=true;
	            		this.visaMode = 'ADD';
	            		var formWindow = this.getPersonCommonWindow();
	                    this.showPersonCommonWindow(formWindow, 'INSURANCE_FORM', 'studentInsuranceform',true);
	                    var form = this.getInsuranceform();
				        var schoolInsuranceTypeField = form.getForm().findField('schoolInsuranceType');

				        if (!schoolInsuranceTypeField || schoolInsuranceTypeField.getValue() === null) {
				            form.getForm().findField('validFrom').setVisible(false);
				            form.getForm().findField('validTo').setVisible(false);
				            form.getForm().findField('nameOfInsuranceCompany').setVisible(false);
				            form.getForm().findField('policyNumber').setVisible(false);
				            form.getForm().findField('schoolInsuranceCardReceived').setVisible(false);
				            form.getForm().findField('receivedDate').setVisible(false);
				            form.getForm().findField('validFrom').allowBlank = true;
				            form.getForm().findField('validTo').allowBlank = true;
				            form.getForm().findField('nameOfInsuranceCompany').allowBlank = true;
				            form.getForm().findField('policyNumber').allowBlank = true;
				            form.getForm().findField('schoolInsuranceCardReceived').allowBlank = true;
				            form.getForm().findField('receivedDate').allowBlank = true;
				            if(form.isValid()){
				            	form.down('#submitButtonId').setDisabled(false);
				            }else{
				            	form.down('#submitButtonId').setDisabled(true);
				            }
				        }
				    }
				},
	            

	            'studentinsurancedetailsgrid[itemId=studentInsuranceDetailsGrid] button[itemId=btnEdit]': {
	            	click: function(){
	            		this.isAdd=false;
	            		this.visaMode='EDIT';
	            		this.editInsuranceDetailWindow('INSURANCE_FORM', 'studentInsuranceform', '#studentInsuranceDetailsGrid', false);
	            		this.studentDocInsuranceContainerWindow();
	            		this.studentUrlInsuranceContainerWindow();
	            		
	            	}
	            },
	            'studentinsurancedetailsgrid[itemId=studentInsuranceDetailsGrid] button[itemId=btnView]': {
	            	click: function(){
	            		this.isAdd=false;
	            		this.visaMode='VIEW';
	            		this.viewStudentInsuranceDetail('INSURANCE_FORM', 'studentInsuranceform', '#studentInsuranceDetailsGrid', true);
	            		this.studentDocInsuranceContainerWindow();
	            		this.studentUrlInsuranceContainerWindow();
	            		var form =  this.getInsuranceform();
	            		form.isValid();
	            	}
	            },
	            
	            'studentinsurancedetailsgrid[itemId=studentInsuranceDetailsGrid] button[itemId=btnDelete]': {
	            	click: function(){
	            		this.deleteStudentInsuranceDetail('#studentInsuranceDetailsGrid', SERVERURL.PATH_STUDENT_INSURANCE_DETAIL_DELETE);
	            	}
	            },
	            
	            getJsonStudentInsuranceData: function(form,grid,isUpdate) { 
	                var this$ = this;
	                var jsonFormFieldData = new Object();
	                var personObj = this$.getPersonObj();
	                var formData = form.getValues();
	                if (!isEmpty(formData)) {
	                    var person = new Object();
	                    person.id = personObj["id"];
	                    formData.person = person;
	                    delete formData.pageSize;
	                    delete formData.customData;
	                }
	                jsonFormFieldData = Ext.encode(formData);
	                return jsonFormFieldData;
	            },
	            'insuranceform[itemId=studentInsuranceform] nestedJsonCombo#schoolInsuranceTypeItemId':{
	           	 select: function(combo, record) {
	           		 	var form = combo.up('insuranceform');
	           		    var schoolInsuranceType = form.down('#schoolInsuranceTypeItemId');
	           		    var validFrom = form.down('#validFrom');
	    				var validTo = form.down('#validTo');
	    				var nameOfInsuranceCompany = form.down('#nameOfInsuranceCompany');
	    				var policyNumber = form.down('#policyNumber');
	    				var schoolInsuranceCardReceived = form.down('#schoolInsuranceCardReceived');
	    				var receivedDate = form.down('#receivedDate');
	    				var newValue = record[0].data.value;
	    				if(newValue=='Private Health Insurance'){
	    					this.loadDFRForSchoolInsuranceType(schoolInsuranceType);
	    					if(form.isValid()){
	     						form.down('#submitButtonId').setDisabled(false);
	     					}else{
	     						form.down('#submitButtonId').setDisabled(true);
	     					}
	    				}else{
	    					this.loadDFRForSchoolInsuranceType(schoolInsuranceType);
	    					if(form.isValid()){
	     						form.down('#submitButtonId').setDisabled(false);
	     					}else{
	     						form.down('#submitButtonId').setDisabled(true);
	     					}
	    				}
	    			 }
	    		 },
	            'insuranceform[itemId=studentInsuranceform] radiogroup#schoolInsuranceCardReceived':{
	    			 change:function(obj,newValue,oldValue){
	    				var form = this.getInsuranceform();
	    				var schoolInsuranceCardReceived = form.down('#schoolInsuranceCardReceived');
	    				var receivedDate = form.down('#receivedDate');
	    				var value = newValue.schoolInsuranceCardReceived;
	    				 if(value==true){
	    					 this.loadDFRForSchoolInsuranceCardReceived(schoolInsuranceCardReceived);
	    					 if(form.isValid()){
	    	 					form.down('#submitButtonId').setDisabled(false);
	    	 				 }else{
	    	 					form.down('#submitButtonId').setDisabled(true);
	    	 				 }
	    				 }else{
	    					 receivedDate.allowBlank = true;
	    	 				 receivedDate.setVisible(false);
	    	 				 receivedDate.reset();
	    	 				 if(form.isValid()){
	    	 					form.down('#submitButtonId').setDisabled(false);
	    	 				 }
	    				 }
	    			 }
	    		 },

	            'insuranceform[itemId=studentInsuranceform] button[itemId=insuranceUploadFileItemId]': {
	            	click : function() {
		 				this.getDocumentController().showDocumentFormWindow('insurance_detail_hidden_field','DOCUMENT');
		 				setTimeout(function(){
				            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
	 			            form.down('#documentNameField').allowBlank=true;
	 			            form.down('#documentNameField').setFieldLabel(getPersonModuleTranslation('DOCUMENT_DETAILS'));
	            		},100); 
		 			}
	            },
	            
	            'insuranceform[itemId=studentInsuranceform] button[itemId=insuranceUploadURLItemId]': {
	            	click : function() {
		 				this.getDocumentController().showDocumentFormWindow('insurance_detail_hidden_field','DOCUMENT_URL');
		 				var formWindow = this.getDocumentformwindow();
	 					if (!formWindow) {
	 						Ext.widget('documentformwindow');
	 						formWindow = this.getDocumentformwindow();
	 					}
	 					formWindow.setTitle(getPersonModuleTranslation('DOCUMENTS_URL'));
		 			}
	            },
	            
	            'documentformwindow[itemId=insurance_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
		 	    	click : function() {
		 			var $this = this;
		 			var isTransient = true;
		 			var module = 'studentInsurance';
		 			var entityId;
		 			var entityType = 'studentInsuranceDocument';
		 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
		 					function(success,response,isCallBackTransient) {
		 				fields : ['id','name','documentName','submissionDate','path','createdBy','status','documentIdCount']
		 						var documentModel = new Academia.model.personinfo.common.personalinfo.StudentInsuranceDocumentModel();
		 						documentModel.set("name",response.name);
		 						documentModel.set("path",response.path);
		 						documentModel.set("type",response.type);
		 						documentModel.set("documentName",response.name);
		 						documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
		 						if(documentModel.data.path.length > 255){
		                              showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
		                          }else {
		                        	var StudentInsuranceDocGrid = Ext.ComponentQuery.query('studentinsurancedocumentgrid')[0];
				 						var store = StudentInsuranceDocGrid.getStore();
				 						store.add(documentModel);
				 						if (StudentInsuranceDocGrid.isHidden() && store.data.items.length > 0) {
				 							StudentInsuranceDocGrid.setVisible(true);
				 						}
				 						$this.getDocumentController().closeDocumentFormWindow();
				 						showSuccessMessage(getCommonTranslation('INSURANCE_SUCCESS'),getCommonTranslation('INSURANCE_DOCUMENT_ADD_SUCCESSFULLY'));
		                          }
		 					}, isTransient);
			 		}
			 	},
			 	
			 	'documentformwindow[itemId=insurance_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
			 		click : function() {
			 			this.getDocumentController()
			 			.closeDocumentFormWindow();
			 		}
			 	},
			 	
			 	
			 	'documentformwindow[itemId=insurance_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
		 	    	click : function() {
		 			var $this = this;
		 			var form = Ext.ComponentQuery.query('simpleurlform')[0];
		            form.down('#documentFormSubmitButtonId').setDisabled(true);
		 				fields : ['id','documentId','documentName','path','createdBy']
		 						var documentModelUrl = new Academia.model.personinfo.common.personalinfo.StudentInsuranceUrlModel();
					            var form = Ext.ComponentQuery.query('simpleurlform')[0];

		 			            var documentName=form.down('#documentNameField').getValue();
		 			            var UrlName=form.down('#documentUrlField').getValue();
		 			            documentModelUrl.set("documentName",documentName);
		 			            documentModelUrl.set("path",UrlName);
		 			            
		 			            documentModelUrl.set("type",'DOCUMENT');
		 			           var userId = this.getCurrentlyLoggedInUser()
		 			           documentModelUrl.set("createdBy",$this.getIdValueJson(userId.id,userId.value));
		 			         //  var studentInsuranceUrlGrid = $this.getStudentinsuranceurlgrid();
	                    	  var StudentInsuranceUrlGrid = Ext.ComponentQuery.query('studentinsuranceurlgrid')[0];
	                    	  var store2= StudentInsuranceUrlGrid.getStore();
	                    	  store2.add(documentModelUrl);
	                    	  if (StudentInsuranceUrlGrid.isHidden() && store2.data.items.length > 0) {
	                    		  StudentInsuranceUrlGrid.setVisible(true);
	                    	  }
	                    	  $this.getDocumentController().closeDocumentFormWindow();
	                    	  showSuccessMessage(getCommonTranslation('INSURANCE_SUCCESS'),getCommonTranslation('INSURANCE_URL_ADD_SUCCESSFULLY'));
		 						
		 		}
		 	},
	            
			 	'documentformwindow[itemId=insurance_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
			 		click : function() {
			 			this.getDocumentController()
			 			.closeDocumentFormWindow();
			 		}
			 	},
	            
			 	'insuranceform[itemId=studentInsuranceform] button#submitButtonId' : {
		 			click : function() {
		               this.saveStudentInsuranceDetail('#studentInsuranceDetailsGrid', SERVERURL.PATH_STUDENT_INSURANCE_DETAIL_ADD, SERVERURL.PATH_STUDENT_INSURANCE_DETAIL_UPDATE);

		 			}
		 		},
		 		
		 		'insuranceform[itemId=studentInsuranceform] button#cancelButtonId' : {
		            	click: this.closePersonCommonWindow
	 			},
	 			
	 			'studentinsurancedocumentgrid button#btnDelete' : {
	 	 			 click : function() {
	 	 				 var $this = this;
	 	 				 var grid=$this.getStudentinsurancedocumentgrid();
	 	 				 if (grid.getSelectionModel().getCount() > 0) {
	 	 					 Ext.MessageBox
	 	 					 .confirm(
	 	 							getCommonTranslation('STUDENT_INSURANCE'),
	 	 							 getCommonTranslation('STUDENT_INSURANCE_DELETE_CONFIRM_MESSAGE'),
	 	 							function(btn, text) {
	 	 								 if (btn == 'yes') {
	 	 									 var store = grid.getStore();
	 	 									 var record = grid.getSelectionModel().getSelection()[0];
	 	 									 var id = record.id;
	 	 									 if (isNullOrEmpty(id)) {
	 	 									 }else{
	 	 										 if (record) {
	 	 											 store.remove(record);
	 	 											 showSuccessMessage(getCommonTranslation('STUDENT_INSURANCE'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
	 	 											 if(store.data.items.length == 0) {
	 	 												grid.setVisible(false);
	 	 					 						}
	 	 										 }
	 	 									 }

	 	 								 }
	 	 							 });
	 	 				 } else {
	 	 					 showWarningMessage(
	 	 							getCommonTranslation('STUDENT_INSURANCE'),
	 	 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 	 				 }
	 	 			 }
	 	 		 },
	 	 		 
	 	 		'studentinsuranceurlgrid button#btnDelete' : {
		 			 click : function() {
		 				 var $this = this;
						 var grid = Ext.ComponentQuery.query('studentinsuranceurlgrid')[0];
		 				 if (grid.getSelectionModel().getCount() > 0) {
		 					 Ext.MessageBox
		 					 .confirm(
		 							 getPersonModuleTranslation('STUDENT_INSURANCE_URL'),
		 							 getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
		 							function(btn, text) {
		 								 if (btn == 'yes') {
		 									 var store = grid.getStore();
		 									 var record = grid.getSelectionModel().getSelection()[0];
		 									 var id = record.id;
		 									 if (isNullOrEmpty(id)) {
		 									 }else{
		 										 if (record) {
		 											 store.remove(record);
		 											 showSuccessMessage(
													 getPersonModuleTranslation('STUDENT_INSURANCE_URL'),
													 getCommonTranslation('URL_SUCCESS_MSG'));
		 											 if(store.data.items.length == 0) {
		 												grid.setVisible(false);
		 					 						}
		 										 }
		 									 }
		 								 }
		 							 });
		 				 } else {
		 					 showWarningMessage(
		 							 getPersonModuleTranslation('STUDENT_INSURANCE_URL'),
		 							 getCommonTranslation('PLEASE_SELECT_RECORD')); 
		 				 }
		 			 }
		 		 },
		 		 
		 		'studentinsurancedocurllistgrid':{
					 render: function(grid) {
						 var this$ = this; 
						 var portalId = this$.getCurrentLoggedPortalId();
						 if(portalId==3) {
							 this$.doAccessControlValidation(grid, this$.getSTUDENT_INSURANCE_URL_PERMISSION());
						 } else if(portalId==7) {
							 this$.doAccessControlValidation(grid, this$.getPARENT_INSURANCE_URL_PERMISSION());
						 } else if(portalId==2) {
							 this$.doAccessControlValidation(grid, this$.getFACULTY_INSURANCE_URL_PERMISSION());
						 } else {
							 this$.doAccessControlValidation(grid, this$.getINSURANCE_URL_PERMISSION());
						 }
					 }
				 },
		 		'studentinsurancedocurllistgrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = $this.getStudentinsurancedocurllist();  
	 					var studentInsuranceGrid= $this.getStudentinsurancedetailsgrid();
	 					var studentInsuranceUrlListgrid=form.down('#studentinsurancedocurllistgridItemId');
	 					if (studentInsuranceUrlListgrid.getSelectionModel().getCount() > 0) {
	 						var records = studentInsuranceUrlListgrid.getSelectionModel().getSelection();
	 						var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
	 							showConfirmMessage(getPersonModuleTranslation('STUDENT_INSURANCE_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",
	 									type: 'rest',
	 									url : SERVERURL.PATH_STUDENT_INSURANCE_URL_DELETE+'?fileDocumentIds='+ids.join(),
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {

	 										Ext.getBody().unmask();
	 										showSuccessMessage(getPersonModuleTranslation('STUDENT_INSURANCE_URL'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
	 										studentInsuranceUrlListgrid.store.reload();
	 										studentInsuranceGrid.store.reload();
	 										studentInsuranceUrlListgrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },
	      
			 'studentinsurancedocumentlistgrid button[itemId=btnDelete]':{
	 				click:function(obj){
	 					var $this=this;
	 					var form = this.getStudentinsurancedocumentlist();
						var studentInsurancelistgrid=obj.up('grid');
	 					var studentInsuranceGrid= $this.getStudentinsurancedetailsgrid();
	 					if (studentInsurancelistgrid.getSelectionModel().getCount() > 0) {
	 						var records = studentInsurancelistgrid.getSelectionModel().getSelection();
	 						var ids=[];
	 						Ext.Array.each(records,function(value){
	 							ids.push(value.data.id);
	 						});
	 							showConfirmMessage(getCommonTranslation('STUDENT_INSURANCE'),getCommonTranslation('STUDENT_INSURANCE_DELETE_CONFIRM_MESSAGE'),function(btn,text){
	 							if (btn == 'yes'){
	 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	 								Ext.Ajax.request({
	 									method: "DELETE",
	 									type: 'rest',
	 									url : SERVERURL.PATH_STUDENT_INSURANCE_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
	 									headers: {
	 										'Content-Type': 'application/json'
	 									},
	 									success: function(form, action) {

	 										Ext.getBody().unmask();
	 										showSuccessMessage(getCommonTranslation('STUDENT_INSURANCE'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));	 
	 										studentInsurancelistgrid.store.reload();
	 										studentInsuranceGrid.store.reload();
	 										studentInsurancelistgrid.getSelectionModel().deselectAll(true);
	 									}
	 								});
	 							}
	 						});
	 					} else {
	 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 					}
	 				}
	       	 },
	            
/*            'insuranceform[itemId=studentInsuranceForm]': {
	            	afterrender: function(obj) {
	                	var form = obj.getForm();
	                	var visaTypeStore = form.findField('schoolInsuranceType').getStore();
	                	visaTypeStore.getProxy().extraParams={
	        				type:'SchoolInsuranceType'
	        			};
	                	
	                	
//	                	if(this.isAdd){
//	                		obj.up().setTitle(getCommonTranslation('ADD_VISA'));
//	    				}else{
//	    					obj.up().setTitle(getCommonTranslation('EDIT_VISA'));
//	    				}
	                }
	            },*/

	           'studentinsurancedocumentlistgrid':{
	        	   render: function(grid) {
						var this$ = this;
						var portalId = this$.getCurrentLoggedPortalId();
						if(portalId==3) {
							this$.doAccessControlValidation(grid, this$.getSTUDENT_INSURANCE_DOCUMENT_PERMISSION());
						} else if(portalId==7) {
							this$.doAccessControlValidation(grid, this$.getPARENT_INSURANCE_DOCUMENT_PERMISSION());
						} else if(portalId==2) {
							this$.doAccessControlValidation(grid, this$.getFACULTY_INSURANCE_DOCUMENT_PERMISSION());
						} else {
							this$.doAccessControlValidation(grid, this$.getINSURANCE_DOCUMENT_PERMISSION());
						}
		            	grid.down('#downloadDocumentItemId').setVisible(true);
					},
					cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
						var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
						if(columnName == "documentName"){
							if(e.target.tagName=='A'){
								var documentId=record.get('documentId');
								if(!isNullOrEmpty(documentId)){
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
										method: 'GET',
										callback : function(opt, success, response){
											if(response.responseText == 'true') {
												var csvForm = Ext.create('Ext.form.Panel'); 
												csvForm.getForm().submit({
													target: '_blank',
													method:'GET',
													params :{
														access_token : Ext.Ajax.defaultHeaders.access_token
													},
													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
													standardSubmit :true
												});
												showSuccessMessage(getCommonTranslation('INSURANCCE'),getCommonTranslation('DOWNLOAD_INSURANCE_DOCUMENT_SUCCESSFULLY'));
											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
											}
										}
									});
								}
							}
						}
					}
				},
				
				'studentinsurancedocumentlistgrid button[itemId=downloadDocumentItemId]':{
					click:function(obj){
						var $this = this;
//						var form = $this.getStudentinsurancedocumentlistgrid();
						var StudentInsuranceActionGrid=obj.up('grid');
						if (StudentInsuranceActionGrid.getSelectionModel().getCount() > 0) {
							var records = StudentInsuranceActionGrid.getSelectionModel().getSelection();
							var dispatchZipName = "Student Insurance Document";
							var saveModel=[];  
							for(var i in records){
								if(!isNullOrEmpty(records[i].get('path'))) {
									saveModel.push(records[i].get('path'));
								}
								showConfirmMessage(getCommonTranslation('STUDENT_INSURANCE_DETAILS_DOCUMENTS'),
										getCommonTranslation('STUDENT_INSURANCE_DETAILS_DOCUMENTS_ALERT'),
										function(btn, text) {
									if (btn == 'yes') {
										var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
										$this.getController('Academia.controller.document.DocumentController')
										.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
										showSuccessMessage(getCommonTranslation('INSURANCE'),getCommonTranslation('DOWNLOAD_INSURANCE_DOCUMENT_SUCCESSFULLY'));
									}
								});
							}
						}
						else {
							$this.hideWindowMask();
							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
						}
					}
	      	 },
	      	 
	      	 
	      	'studentinsurancedocumentgrid' : {
	 				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
	 					 var $this = this;
	 					 var documentGrid = grid.up('grid');
	 					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
	 					 if (columnName == "documentName") {
	 						 if (e.target.tagName == 'A') {
	 							 var documentId = record.get("documentId");
	 							 if (!isNullOrEmpty(documentId)) {
	 								 $this.getDocumentController().downloadDocumentFile(documentId);
	 							 }
	 						 }
	 					 }
	 				 }
	 			 },
	 	
            /**
             *  Fee Payer Detail
             */
            'feepayerdetailgrid[itemId=studentFeePayerDetailGridItemId]': {
            	render: function(grid) {
            		var $this = this;
            		grid.setTitle(getPersonModuleTranslation('LIST_OF_FEE_PAYERS'));
            		$this.loadGridStore('#studentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_GRID);
            		var portalId = $this.getCurrentLoggedPortalId();
            		if(portalId == 7)
            		{
            			$this.doAccessControlValidation(grid, $this.getPARENT_FEE_PAYER_DETAILS_PERMISSIONS());	
            		}else if(portalId == 2){
            			$this.doAccessControlValidation(grid, $this.getFACULTY_PORTAL_STUDENT_FEE_PAYER_DETAILS_PERMISSIONS());	
            		}else if(portalId == 3){
            			$this.doAccessControlValidation(grid, $this.getSTUDENT_PORTAL_STUDENT_FEE_PAYER_DETAILS_PERMISSIONS());	
            		}else{
            			$this.doAccessControlValidation(grid, $this.getSTUDENT_FEE_PAYER_DETAILS_PERMISSIONS());
            		}
            	},
                cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
                    if (e.target.tagName == 'A') {
                        var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
                        if (columnName == 'documentCount') {
                        	 var $this = this;
                             var grid = $this.getStudentFeePayerDetailGrid();

                             var formWindow = $this.getStudentfeepayerdetaildocumentwin();
                             if (!formWindow) {
                             	Ext.widget('studentfeepayerdetaildocumentwin');
                             	formWindow = $this.getStudentfeepayerdetaildocumentwin();
                             }
                             formWindow.show();
                             var documentGrid = $this.getStudentfeepayerdetaildocumentgrid();
                             documentGrid.getStore().getProxy().extraParams = {
                             	feePayerDetailId: record.data.id
                             };
                            // documentGrid.down('#btnDelete').setVisible(false);
                             documentGrid.getStore().load();
                        }
                    }
                },
                expand: function(obj){
                	document.getElementsByClassName('gridTotalDivCls '+obj.el.id)[0].innerHTML = "<span class='totalSpanCls'>"+getCommonTranslation('TOTAL_RECORDS')+": "+obj.getStore().data.length+" </span>";
                },
                collapse: function(obj) {
                	document.getElementsByClassName('gridTotalDivCls '+obj.el.id)[0].innerHTML = '';
                }
            },
            'studentfeepayerdetaildocumentgrid': {
                cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
                    var $this = this;
                    var documentGrid = $this.getStudentfeepayerdetaildocumentgrid();
                    var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

                    if (columnName == "documentName") {
                        if (e.target.tagName == 'A') {
                            var documentId = record.get("documentId");
                            if (!isNullOrEmpty(documentId)) {
                                $this.getDocumentController().downloadDocumentFile(documentId);
                            }
                        }
                    }
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId]': {
            	afterrender: function(formObj) { 
                	formObj.down('#parentCountryRegionId').setDisabled(true);
                	formObj.down('#cityId').setDisabled(true);
                	
                	
                	
                	var paymentModeItems =  formObj.down('#paymentModeItemId');
                	var payerTypeItemId =  formObj.down('#payerTypeItemId');
                	
                	
                	var isSameAsCurrentAddress = formObj.down('#isSameAsCurrentAddress');
                	isSameAsCurrentAddress.setBoxLabel(getPersonModuleTranslation('SAME_AS_STUDENT_CURRENT_ADRESS'));
                	
          		  var payerTypeItemId= formObj.down('#payerTypeItemId');
        		  var companyNameItemId= formObj.down('#companyNameItemId');
        		  var contactPersonItemId= formObj.down('#contactPersonItemId');
        		  var surnameItemId= formObj.down('#surnameItemId');
        		  var sponsorItemId= formObj.down('#sponsorItemId');
        		  var feepayerTypeOptions = payerTypeItemId.items.items;
        		  feepayerTypeOptions[2].hide();
        		  Ext.defer(function(){
        			  if(payerTypeItemId.getValue().payerType=="PERSON"){
            			  companyNameItemId.setVisible(false);
            			  contactPersonItemId.setVisible(false);
            			  surnameItemId.setVisible(false);
            			  sponsorItemId.setVisible(false);
            			  companyNameItemId.allowBlank=true;
            			  contactPersonItemId.allowBlank=true;
            			  sponsorItemId.allowBlank=true;
            			  surnameItemId.allowBlank=true;
            		  }else{
            			  sponsorItemId.setVisible(true);
            			  companyNameItemId.setVisible(true);
            			  contactPersonItemId.setVisible(true);
            			  surnameItemId.setVisible(true);
            			/*  companyNameItemId.allowBlank=false;
            			  contactPersonItemId.allowBlank=false;
            			  surnameItemId.allowBlank=false;*/
            		  }
        		  },500);
            		  
            		  
            		  if(portalId == 3){
            			  payerTypeItemId.items.items[2].hide();
            			  var academyLocationId = this.getCurrentAcademyLocation();
            			  var arrayAl = [32,33,34,35,36,37,38,39,41,8,9];

            			  for( var i in arrayAl){

            				  if(arrayAl[i]==academyLocationId){
            					  paymentModeItems.items.items[0].hide();
            					  paymentModeItems.setValue({paymentMode:'DEBIT_ORDER'});
            					  break;
            				  }
            			  }

                   }
            		  this.makeFieldAllowBlankAndMandatory(formObj);
            		  // please do not uncomment this code 
                     var me = this;
            		 if(this.getCurrentLoggedPortalId() == 3){
				      var form  = this.getPersonFeePayerDetailForm();
			     	  Ext.defer(function(){
				      	me.hideFieldsForFeePayerForm(form);
				      },500);
				    } 
            		this.addGoogleAddressBtn(formObj);
            	}
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] customcombobox[itemId=sponsorItemId]':{
           	 select: function(combo){
           		 var me = this;
           		 var form = combo.up('feepayerdetailform');
           		 
           		 //var feePayerField = form.down('#');
           		 var companyNameField = form.down('#companyNameItemId')
           		 var nameOfContactPersonField = form.down('#contactPersonItemId'); //
           		 var addressField = form.down('#addressTextArea'); // 
           		 var countryField = form.down('#countryId'); // 
           		 var regionField = form.down('#parentCountryRegionId'); //
           		 var cityFieldField = form.down('#cityId'); //
           		 var pinCodeField = form.down('#pincodeId'); //
           		 var phoneCountryCode = form.down('#workTelephoneCountryCodeItemId');
           		 var mobileCountryCode = form.down('#countryCodeItemId');
           		 var phoneNumberField = form.down('#workTelephoneItemId');
           		 var mobileNumberField = form.down('#mobileNumberItemId');
           		 var workEmailField = form.down('#emailWorkItemId');

           		 companyNameField.reset();

           		 var comboData =combo.getStore().findRecord('value', combo.getRawValue());
           		 if(!isNullOrEmpty(comboData) &&!isNullOrEmpty(comboData.get('sponsorName'))){
           			companyNameField.setValue(comboData.get('sponsorName'));
           		 }

           		 
           		 Ext.Ajax.request({
           			 type: 'rest',
           			 url: SERVERURL.FIND_CONTACT_BY_SPONSORID,
           			 params: {
           				 sponsorId: combo.getValue()
           			 },
           			 method: 'GET',
           			 success: function(res, action) {
           				 var response = Ext.decode(res.responseText);
           				 if(response){ 
           					 addressField.setValue(response.addressTextArea);
           					 nameOfContactPersonField.setValue(response.contactName);
           					 workEmailField.setValue(response.emailWork);
           					 pinCodeField.setValue(response.pincode);
           					 
           					 phoneCountryCode.getStore().load({
           						 callback: function(){
           							 phoneCountryCode.setValue(response.phoneCountryCode);
           						 }
           					 });
           					 
           					 mobileCountryCode.getStore().load({
           						 callback: function(){
           							 mobileCountryCode.setValue(response.countryCode);
           						 }
           					 });
           					 
           					 phoneNumberField.setValue(response.phoneNo);
           					 mobileNumberField.setValue(response.mobileNumber);
           					 
           					 countryField.getStore().load({
           						 callback: function(){
           							 countryField.setValue(response.countryId);
           							 regionField.getStore().getProxy().extraParams = {
           								 cid: response.countryId
           							 };
           							 regionField.getStore().load({
           								 callback: function(){
           									 regionField.setDisabled(false);
           									 regionField.setValue(response.parentCountryRegionId);
           								 }
           							 });
   									 
   									 cityFieldField.getStore().getProxy().extraParams = {
   										 countryId: response.countryId
           							 };
   									 cityFieldField.getStore().load({
           								 callback: function(){
           									 cityFieldField.setDisabled(false);
           									 cityFieldField.setValue(response.cityId);
           								 }
           							 });
           						 }
           					 });
           				 }else{
           					addressField.reset();
          					 nameOfContactPersonField.reset();
          					 workEmailField.reset();
          					 pinCodeField.reset();
          					phoneCountryCode.reset();
          					 mobileCountryCode.reset();
          					 phoneNumberField.reset();
           					 mobileNumberField.reset();
           					countryField.reset();
           					regionField.reset();
           				 cityFieldField.reset();
           				 }
           			 }
           		 });
           	 }
            },
            'feepayerdetailform[itemId=personfeepayerdetailformItemId]': {
            	afterrender: function(formObj) { 
                	formObj.down('#parentCountryRegionId').setDisabled(true);
                	formObj.down('#cityId').setDisabled(true);
                	var isSameAsCurrentAddress = formObj.down('#isSameAsCurrentAddress');
                	isSameAsCurrentAddress.setBoxLabel(getPersonModuleTranslation('SAME_AS_STUDENT_CURRENT_ADRESS'));
                	
          		  var payerTypeItemId= formObj.down('#payerTypeItemId');
        		  var companyNameItemId= formObj.down('#companyNameItemId');
        		  var contactPersonItemId= formObj.down('#contactPersonItemId');
        		  var surnameItemId= formObj.down('#surnameItemId');
        		  
        		  var companyNameOtherLang= formObj.down('#companyNameOtherLangItemId');
        		  var contactPersonOtherLang= formObj.down('#contactPersonOtherLangItemId');
        		  var surnameOtherLang= formObj.down('#surnameOtherLangItemId');
        		  
            		  if(payerTypeItemId.originalValue.payerType=="PERSON" || payerTypeItemId.lastValue.payerType=="PERSON"){
            			  companyNameItemId.setVisible(false);
            			  contactPersonItemId.setVisible(false);
            			  surnameItemId.setVisible(false);
            			  companyNameItemId.allowBlank=true;
            			  contactPersonItemId.allowBlank=true;
            			  surnameItemId.allowBlank=true;
            			  companyNameOtherLang.setVisible(false);
            			  contactPersonOtherLang.setVisible(false);
            			  surnameOtherLang.setVisible(false);
            			  companyNameOtherLang.allowBlank=true;
            			  contactPersonOtherLang.allowBlank=true;
            			  surnameOtherLang.allowBlank=true;
            		  }else{
            			  companyNameItemId.setVisible(true);
            			  contactPersonItemId.setVisible(true);
            			  surnameItemId.setVisible(true);
            			  companyNameItemId.allowBlank=false;
            			  contactPersonItemId.allowBlank=false;
            			  surnameItemId.allowBlank=false;
            			  companyNameOtherLang.setVisible(true);
            			  contactPersonOtherLang.setVisible(true);
            			  surnameOtherLang.setVisible(true);
            			  companyNameOtherLang.allowBlank=false;
            			  contactPersonOtherLang.allowBlank=false;
            			  surnameOtherLang.allowBlank=false;
            		  }
                
                }
            },
            'feepayerdetailsformparent': {
            	afterrender: function(formObj) {  
            		var $this = this;
            		var RegisterTab = this.getStudentregistrationtabstructure();
            		if(RegisterTab.isRegisterBtn){
            			var applicableForCurrentYearRadio = formObj.down('#applicableForCurrentYearItemId');
            			applicableForCurrentYearRadio.hide();
            		}
                	formObj.down('#parentCountryRegionId').setDisabled(true);
                	formObj.down('#cityId').setDisabled(true);
                	var isSameAsCurrentAddress = formObj.down('#isSameAsCurrentAddress');
                	//isSameAsCurrentAddress.setBoxLabel(getPersonModuleTranslation('SAME_AS_STUDENT_CURRENT_ADRESS')); AS now managed from DFR
                	setTimeout(function(){
                		formObj.down('#feePayerIDItemId').allowBlank=false;
                    	//formObj.down('#feePayerLatestPayslipItemId').allowBlank=false;
                    	formObj.down('#primaryFeePayerId').setValue(true);
                    	if(formObj.down('#feePayerProofOfAccountItemId')){
                    		formObj.down('#feePayerProofOfAccountItemId').allowBlank = true;
                    	}
                    	var payerTypeItemId= formObj.down('#payerTypeItemId');
                    	var companyNameItemId = formObj.down('#companyNameItemId');
                        var contactPersonItemId = formObj.down('#contactPersonItemId');
                        var surnameItemId = formObj.down('#surnameItemId');
                    	if(payerTypeItemId.originalValue.payerType=="CORPORATE" || payerTypeItemId.lastValue.payerType=="CORPORATE" || payerTypeItemId.getValue().payerType=="CORPORATE"){ //these 3 fields were creating issue in case of edit form with corporate
                    		companyNameItemId.setVisible(true);
                    		contactPersonItemId.setVisible(true);
                    		surnameItemId.setVisible(true);
                    	}
                    	$this.makeFieldAllowBlankAndMandatoryForReRegistration(formObj);
                	},600);
                	
                	/*this api is fetching data of registration setup labels*/
					Ext.Ajax.request({
						type : 'rest',
						async: false,
						method : 'GET',
						url : SERVERURL.PATH_FIND_STUDENT_FEE_REGISTRATION_NEW_SETUP,
						params: {
							academyLocationId: $this.getCurrentAcademyLocation()
						},
						success: function(response, action){
							var data = Ext.decode(response.responseText); 
							RegisterTab.configFieldsLabel=data;
							if(data && data.length>0 && !isNullOrEmpty(data[0].financeClause)){
								Ext.defer(function() {
									formObj.down('#debitOrderTextMsg').setText(data[0].financeClause);
								},500); 
							}
						}
					});
                }
            },
            'feepayerdetailgrid[itemId=studentFeePayerDetailGridItemId] button[itemId=btnAdd]': {
                click: function(btn) {
                	if(!preventMultipleCalls(btn)){
                		return false;
                	}
                	var this$ = this;
                	var personComContlr =Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
                	personType='STUDENT',
        		    tabPanelTitle= 'FPD_FEE_PAYER_DETAILS',
        	    	tabPanelItemId= 'studentfeepayerdetailform',
        	    	tabPanelItemXtype = 'feepayerdetailform',
        	    	xtypeItemId = 'studentfeepayerdetailformItemId',
        	    	defaultPanel= true,
        	    	menuColorCls =CONSTANTS.MENU_COLOR_EIGHT;
                	this.stdFeePayerFormMode='add';
                    personComContlr.addPersonTabPanel(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,'',menuColorCls);
        	    	var formWindowSpecific = this.getPersonFeePayerDetailForm();
        	    	var formScroll = formWindowSpecific.up('form');
        			if(!isNullOrEmpty(formScroll.getEl()))
        			{
        				var getElValue=formScroll.getEl();
        				var getFirstChild = getElValue.first();
        				getFirstChild.dom.style.overflowY="scroll";
        			}  
        	    	var employeeIdItemIds = formWindowSpecific.down("#employeeIdItemId");
                    employeeIdItemIds.allowBlank=true;
                    var corporateId = formWindowSpecific.down("#corporateId");
                    var companySponsorLetterItemId= formWindowSpecific.down("#companySponsorLetterItemId");
                    var payerTypeItemId= formWindowSpecific.down('#payerTypeItemId');
                                        
                    if( formWindowSpecific != null ){
                    	var salutationField = formWindowSpecific.down('#salutationItemId');
		                salutationField.getStore().load();
            			var form = formWindowSpecific;
            			var isPrimaryCheckBox = form.down('#primaryFeePayerId');
                    	var personProfile = this$.getContentPanelActiveTab();
                    	var personId;
                    	try{
                    		personId = personProfile.getPersonId();
                    	}catch(e){
                    		var personObj = this$.getPersonObj();
                           	personId = personObj["id"];
                    	}
            			
            			Ext.Ajax.request({
                 			type: 'rest',
                 			url: SERVERURL.PATH_FIND_PERSON_FEE_PAYER_EXISTS, 
                 			method: 'GET',
                 			params: {
                 				personId: personId
                             },
                 			success: function(res, action) {
                 				var response = Ext.decode(res.responseText);
                 				if(!isNullOrEmpty(isPrimaryCheckBox)){
                 					if(response != true && response != 'true'){
                 						isPrimaryCheckBox.setValue(true);
                 						isPrimaryCheckBox.setReadOnly(true);
                 					} 
                 				}
                 			}
                        });
                		var countryCodeFieldItemIDArray = ["#homeTelephoneCountryCodeItemId","#workTelephoneCountryCodeItemId","#countryCodeItemId"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            		    var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
                    	var mobileField = form.down("#homeTelephoneItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                    	countryCodeField = form.down("#workTelephoneCountryCodeItemId");
                    	mobileField = form.down("#workTelephoneItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                    	countryCodeField = form.down("#countryCodeItemId");
                    	mobileField = form.down("#mobileNumberItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                    	this.setDfrOnFeePayerDetailsForm(formWindowSpecific);
                    	this.remainingFieldsOfFeePayerForDFR(formWindowSpecific);
                    	if(payerTypeItemId.originalValue.payerType=="PERSON" || payerTypeItemId.lastValue.payerType=="PERSON"){
                        	corporateId.allowBlank=true;
                        	corporateId.setVisible(false);
                        	companySponsorLetterItemId.setVisible(false);
                        	companySponsorLetterItemId.allowBlank=true;	
                        }else if(payerTypeItemId.originalValue.payerType=="CORPORATE" || payerTypeItemId.lastValue.payerType == "CORPORATE"){
                        	//companySponsorLetterItemId.setVisible(true);
                        	companySponsorLetterItemId.allowBlank=false;	
                        } 
                    }
                }
            },
            'feepayerdetailgrid[itemId=studentFeePayerDetailGridItemId] button[itemId=btnEdit]': {
                click: function(btn) {
                	if(!preventMultipleCalls(btn)){
                		return false;
                	}
                	var personComContlr =Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController'),
                	personType='STUDENT',
        		    tabPanelTitle= 'FPD_FEE_PAYER_DETAILS',
        	    	tabPanelItemId= 'studentfeepayerdetailform',
        	    	tabPanelItemXtype = 'feepayerdetailform',
        	    	xtypeItemId = 'studentfeepayerdetailformItemId',
        	    	defaultPanel= true,
        	    	gridItemId ='#studentFeePayerDetailGridItemId',
        	    	menuColorCls =CONSTANTS.MENU_COLOR_EIGHT;
                	this.stdFeePayerFormMode='edit';
                    var form =this.editFeePayerDetailFormWindow(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,'',menuColorCls);
                                	
                	var corporateId = form.down("#corporateId");
                	var payerTypeItemId= form.down('#payerTypeItemId');
                	var companySponsorLetterItemId=form.down('#companySponsorLetterItemId');
                	var companySponsorLetterURL = form.down('#companySponsorLetterURL');
                         
                    if( form != null ){
                    	var isPrimaryCheckBox = form.down('#primaryFeePayerId');
                    	if(!isNullOrEmpty(isPrimaryCheckBox.getValue()) && (isPrimaryCheckBox.getValue()==true || isPrimaryCheckBox.getValue()=='true')) {
                    		isPrimaryCheckBox.setReadOnly(true);
                    	} else {
                    		isPrimaryCheckBox.setReadOnly(false);
                    	}
                		var countryCodeFieldItemIDArray = ["#homeTelephoneCountryCodeItemId","#workTelephoneCountryCodeItemId","#countryCodeItemId"];
            		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            		    var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
                    	var mobileField = form.down("#homeTelephoneItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                    	countryCodeField = form.down("#workTelephoneCountryCodeItemId");
                    	mobileField = form.down("#workTelephoneItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                    	countryCodeField = form.down("#countryCodeItemId");
                    	mobileField = form.down("#mobileNumberItemId");
                    	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                    	this.setDfrOnFeePayerDetailsForm();
                    	if(payerTypeItemId.lastValue.payerType=="PERSON"){
                    		corporateId.setVisible(false);
                        	corporateId.allowBlank=true;
                        	companySponsorLetterItemId.setVisible(false);
                        	companySponsorLetterURL.setVisible(false);
                        }else if(payerTypeItemId.lastValue.payerType == "CORPORATE"){
                        	 corporateId.setVisible(true);
                        	 corporateId.allowBlank=false;
                        }else{
                        	 corporateId.setVisible(false);
                        	 corporateId.allowBlank=true;
                        }
                    	var nationalAlternateIdItemId = form.down("#nationalAlternateIdItemId");
                    	if(payerTypeItemId.lastValue.payerType == "CORPORATE"){
                    		nationalAlternateIdItemId.setVisible(false);
                    		nationalAlternateIdItemId.allowBlank=true;
                       }
            		}
                }
            },
            'feepayerdetailgrid[itemId=studentFeePayerDetailGridItemId] button[itemId=btnView]': {
                click: function() {
                	 var personType='STUDENT',
        		    tabPanelTitle= 'FPD_FEE_PAYER_DETAILS',
        	    	tabPanelItemId= 'studentfeepayerdetailform',
        	    	tabPanelItemXtype = 'feepayerdetailform',
        	    	xtypeItemId = 'studentfeepayerdetailformItemId',
        	    	defaultPanel= true,
        	    	gridItemId ='#studentFeePayerDetailGridItemId',
                    menuColorCls =CONSTANTS.MENU_COLOR_EIGHT;
                	this.stdFeePayerFormMode='view';
                    this.viewFeePayerDetailFormWindow(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,gridItemId,'',menuColorCls);
                     var feepayerdetailform = this.getPersonFeePayerDetailForm();
                    
                    var corporateId = feepayerdetailform.down("#corporateId");
                	var payerTypeItemId= feepayerdetailform.down('#payerTypeItemId');
                	var companySponsorLetterItemId=feepayerdetailform.down('#companySponsorLetterItemId');
                	var companySponsorLetterURL = feepayerdetailform.down('#companySponsorLetterURL');
                	var value1 = payerTypeItemId.getValue()
                    if(value1.payerType=="PERSON"){
                    	corporateId.setVisible(false);	
                    	companySponsorLetterItemId.setVisible(false);
                    	companySponsorLetterURL.setVisible(false);
                    }else if(payerTypeItemId.lastValue.payerType == "CORPORATE"){
                    	 corporateId.setVisible(true);
                    	 corporateId.allowBlank =false;
                    	 //companySponsorLetterItemId.setVisible(true);
                    	 //companySponsorLetterItemId.allowBlank =true;
                    }else{
                    	 corporateId.setVisible(false);
                    }
                    
                    if(feepayerdetailform != null && feepayerdetailform != undefined){
                    	var feePayerIDItemId = feepayerdetailform.down("#feePayerIDItemId");
                    	if(feePayerIDItemId != null && feePayerIDItemId != undefined){
                    		feePayerIDItemId.setDisabled(true);
                    	}
                    	var feePayerProofOfAccountItemId = feepayerdetailform.down("#feePayerProofOfAccountItemId");
                    	if(feePayerProofOfAccountItemId != null && feePayerProofOfAccountItemId != undefined){
                    		feePayerProofOfAccountItemId.setDisabled(true);
                    	}
                    	
                    	var feePayerLatestPayslipItemId = feepayerdetailform.down("#feePayerLatestPayslipItemId");
                    	if(feePayerLatestPayslipItemId != null && feePayerLatestPayslipItemId != undefined){
                    		feePayerLatestPayslipItemId.setDisabled(true);
                    	}
                    	var companySponsorLetterItemId = feepayerdetailform.down("#companySponsorLetterItemId");
                    	var companySponsorLetterURL = feepayerdetailform.down('#companySponsorLetterURL');
                     	if(companySponsorLetterItemId != null && companySponsorLetterItemId != undefined){
                     		companySponsorLetterItemId.setDisabled(true);
                     	}
                    }
                    this.setDfrOnFeePayerDetailsForm();
                }
            },
            'feepayerdetailgrid[itemId=studentFeePayerDetailGridItemId] button[itemId=btnDelete]': {
                click: function() {
                    this.deleteFeePayerDetailRecord('#studentFeePayerDetailGridItemId', SERVERURL.FPD_FEE_PAYER_DETAIL_DELETE);
                }
            },
            'feepayerdetailform[itemId=personfeepayerdetailformItemId] button[itemId=submitButtonId]': {
                click: function() {
                	
                		this.savePersonFeePayerDetail('#parentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_CREATE, SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_UPDATE);
                	
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] button[itemId=submitButtonId]': {
                click: function(btn) {
                	btn.setDisabled(true);
                	if(this.getContentpanel().getActiveTab().xtype!='personinfostudentportal'){ /**
                	V2D-357247-Student portal -> Payment plan -> When adding a fee payer then after save 2 records is displaying.
                	*/
                		this.savePersonFeePayerDetail('#studentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_CREATE, SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_UPDATE);
                	}else{
                		btn.setDisabled(false);
                	}
                }
            },
            'feepayerdetailsformparent button[itemId=submitButtonId]': {
            	click: function(formObj) {                
            		if(portalId == 7){
                		this.savePersonFeePayerDetail('#parentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_CREATE, SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_UPDATE);
                	}
                }
            },
           
          /*  'feepayerdetailform[itemId=studentfeepayerdetailformItemId] button[itemId=cancelButtonId]': {
                click: this.closePersonCommonWindow
            },*/
            'feepayerdetailform[itemId=personfeepayerdetailformItemId] radiogroup[itemId=empOfTheOrgItemId]': {
            	afterrender: function(radio) {
                	var $this = this;
                	var form = radio.up('feepayerdetailform');
                	var empOfTheOrg = form.down("#empOfTheOrgItemId");
                	var employeeId = form.down("#employeeIdItemId");
                	var status = empOfTheOrg.getValue().employeeOfOrganization;
                	var checkEmployeeIdDfr = false;
                	

                	setTimeout(function(){
                		if(status==true) {
                			employeeId.setVisible(true);
                			employeeId.allowBlank=false;
                		}
                		else {
                			if(isNullOrEmpty(employeeId.getValue())){
                				employeeId.reset();
                    			employeeId.setVisible(false);	
                    			employeeId.allowBlank=true;
                			}
                			
                		}
                		checkEmployeeIdDfr = $this.checkEmployeeIdDfr(empOfTheOrg,employeeId);
               	 },1000);
                	
                	form.getForm().checkValidity();
                },
                change: function(radio, newValue, oldVaue) { 
                	var $this = this;
                	var form = radio.up('feepayerdetailform');
                	var empOfTheOrg = form.down("#empOfTheOrgItemId");
                	var employeeId = form.down("#employeeIdItemId");
                	var status = empOfTheOrg.getValue().employeeOfOrganization;
                	var checkEmployeeIdDfr = false;
                	checkEmployeeIdDfr = $this.checkEmployeeIdDfr(empOfTheOrg,employeeId);
                	if(checkEmployeeIdDfr==false) {
                		if(status==true) {
                			employeeId.setVisible(true);
                			employeeId.allowBlank=false;
                		}
                		else {
                			employeeId.reset();
                			employeeId.setVisible(false);
                			employeeId.allowBlank=true;
                		}
                	}
                	form.getForm().checkValidity();
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] radiogroup[itemId=empOfTheOrgItemId]': {
            	afterrender: function(radio) {
                	var $this = this;
                	var form = radio.up('feepayerdetailform');
                	var empOfTheOrg = form.down("#empOfTheOrgItemId");
                	var employeeId = form.down("#employeeIdItemId");
                	var status = empOfTheOrg.getValue().employeeOfOrganization;
                	var checkEmployeeIdDfr = false;
                	

                	setTimeout(function(){
                		if(status==true) {
                			employeeId.setVisible(true);
                			employeeId.allowBlank=false;
                		}
                		else {
                			if(isNullOrEmpty(employeeId.getValue())){
                				employeeId.reset();
                    			employeeId.setVisible(false);	
                    			employeeId.allowBlank=true;
                			}
                			
                		}
                		checkEmployeeIdDfr = $this.checkEmployeeIdDfr(empOfTheOrg,employeeId);
               	 },1000);
                	
                	form.getForm().checkValidity();
                },
                change: function(radio, newValue, oldVaue) { 
                	var $this = this;
                	var form = radio.up('feepayerdetailform');
                	var empOfTheOrg = form.down("#empOfTheOrgItemId");
                	var employeeId = form.down("#employeeIdItemId");
                	var status = empOfTheOrg.getValue().employeeOfOrganization;
                	var checkEmployeeIdDfr = false;
                	checkEmployeeIdDfr = $this.checkEmployeeIdDfr(empOfTheOrg,employeeId);
                	if(checkEmployeeIdDfr==false) {
                		if(status==true) {
                			employeeId.setVisible(true);
                			employeeId.allowBlank=false;
                		}
                		else {
                			employeeId.reset();
                			employeeId.setVisible(false);
                			employeeId.allowBlank=true;
                		}
                	}
                	form.getForm().checkValidity();
                }
            },
            'feepayerdetailform[itemId=personfeepayerdetailformItemId] textfield[itemId=employeeIdItemId]': {
            	change: function(record){
            		var form = this.getParentFeePayerDetailForm();
                	var employeeIdItemId = form.down("#employeeIdItemId");
                	employeeIdItemId.isValid();
        			form.getForm().checkValidity();
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] textfield[itemId=employeeIdItemId]': {
            	change: function(record){
            		var form = this.getPersonFeePayerDetailForm();
                	var employeeIdItemId = form.down("#employeeIdItemId");
                	employeeIdItemId.isValid();
        			form.getForm().checkValidity();
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] filefield[itemId=feePayerIDItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_ID_UPLOAD_VALID_FILE'));
                        }
                    }
                }
            },'feepayerdetailform[itemId=studentfeepayerdetailformItemId] filefield[itemId=feePayerProofOfAccountItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_PROOF_OF_ACCOUNT_UPLOAD_VALID_FILE'));
                        }
                    }
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] filefield[itemId=feePayerLatestPayslipItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_LATEST_PAYSLIP_UPLOAD_VALID_FILE'));
                        }
                    }
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] filefield[itemId=companySponsorLetterItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('COMPANY_SPONSOR_LETTER_UPLOAD_VALID_FILE'));
                        }
                    }
                }
            },
            'feepayerdetailform[itemId=personfeepayerdetailformItemId] filefield[itemId=feePayerIDItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_ID_UPLOAD_VALID_FILE'));
                        }
                    }
                }
            },
            'feepayerdetailform[itemId=personfeepayerdetailformItemId] filefield[itemId=feePayerProofOfAccountItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_PROOF_OF_ACCOUNT_UPLOAD_VALID_FILE'));
                        }
                    }
                }
            },
            'feepayerdetailform[itemId=personfeepayerdetailformItemId] filefield[itemId=feePayerLatestPayslipItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_LATEST_PAYSLIP_UPLOAD_VALID_FILE'));
                        }
                    }
                }
            },
            
            'feepayerdetailsformparent filefield[itemId=feePayerIDItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    $this.getFeepayerdetailsformparent().isValid();
					var feepayerdetailsformparentN = fileField.up('feepayerdetailsformparent');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_ID_UPLOAD_VALID_FILE'));
                        }
                    }
				feepayerdetailsformparentN.getForm().checkValidity();
                }
            },
            'feepayerdetailsformparent filefield[itemId=feePayerProofOfAccountItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    $this.getFeepayerdetailsformparent().isValid();
					var feepayerdetailsformparentN = fileField.up('feepayerdetailsformparent');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_PROOF_OF_ACCOUNT_UPLOAD_VALID_FILE'));
                        }
                    }
				feepayerdetailsformparentN.getForm().checkValidity();
                }
            },
            'feepayerdetailsformparent filefield[itemId=feePayerLatestPayslipItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    $this.getFeepayerdetailsformparent().isValid();
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_ID_UPLOAD_VALID_FILE'));
                        }
                    }
                }
            },
            'medicaldetailsform[itemId=medicaldetailsformparent]':{
            	afterrender: function(fileField, value, eOpts) {
            		var form=this.getMedicaldetailsformparent();
            		var me = this, fieldCmp, parentField, fieldLable,formFields = form.getForm();
            		Ext.Ajax.request({
            			type: 'rest',
            			async: false,
            			url: SERVERURL.COMMON_FORM_FIELD_INFO,
            			params: {
            				screenName: 'medicaldetailsform',
            				academyLocationId: this.getCurrentAcademyLocation(),
            				languageCode:'en'
            			},
            			method: 'GET',
            			success: function(res, action) {
            				var response = Ext.decode(res.responseText);
            				if(Object.keys(response).length > 0 ){
            					response.medicaldetailsform.forEach(function(rec){
            						fieldCmp = form.down('#'+rec.formFieldId);
            						if(!fieldCmp){
            							fieldCmp = formFields.findField(rec.formFieldName);
            						}
            						if(fieldCmp){
            							if(rec.isVisible){
            								me.setAllowBlank(fieldCmp, !rec.isMandatory);
            							}else{
            								me.setAllowBlank(fieldCmp, true);
            							}
            							fieldCmp.setVisible(rec.isVisible);
            							me.removeDoubleColon(fieldCmp,rec.formFieldLabel);
            							if(rec.formFieldId == 'familyPractionerContactNumberItemId'){
            								fieldCmp.setFieldLabel('');
            							}
            						}
            					});
            				}
            			}
            		});
            	}
            },
            'medicaldetailsform[itemId=medicaldetailsformparent] filefield[itemId=medicalAidDocumentItemId]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtension(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getPersonModuleTranslation('FPD_FEE_PAYER_ID_UPLOAD_VALID_FILE'));
                        }
                    }
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] radiogroup[itemId=paymentModeItemId]': {
                change: function(cb, nv, ov) {
                	var $this = this;
                	var form = cb.up('feepayerdetailform');
                	
                	var academyLocationId = this.getCurrentAcademyLocation();
                	
                	var debitOrderContainerItemId = form.down("#debitOrderContainerItemId");
                	
                	var debitFieldsArr = ['debitOrderDateItemId', 'accountNameItemId', 'accountTypeItemId', 
                		'bankItemId', 'accountNumberItemId', 'branchCodeItemId','debitOrderStartDate','debitOrderEndDate'];

                	if (nv.paymentMode == 'EFT') {
                		
                		Ext.Ajax.request({
	                		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	                		method: 'GET',
	                		async: false,
	                		params: {
	                			screenName: 'feepayerdetailform',
	                			academyLocationId:academyLocationId,
	                			languageCode:'en'
	                		},
	                		success: function(response) {
	                			debitOrderContainerItemId.setVisible(false);
	                			var json = JSON.parse(response.responseText);
	                			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
	                			fieldInfo.set("formFieldsInfo", json);
	                			//console.log(json);
	                			if( !isNullOrEmpty(json) ){
	                				if( !isNullOrEmpty(json.feepayerdetailform) ){
	                					var feePayerDetailDFRConfig = json.feepayerdetailform;
	                					for( i in feePayerDetailDFRConfig){
	                						var fieldConfig = feePayerDetailDFRConfig[i];
	                						//console.log(fieldConfig);
	                						if(debitFieldsArr.includes(fieldConfig.formFieldId) ){
	                							if(fieldConfig.isMandatory ){
	                								var currentField = form.down("#"+fieldConfig.formFieldId);
	                								$this.setAllowBlank(currentField, true);
	                								var currentFieldLabel = fieldConfig.formFieldLabel;
	                								currentField.setFieldLabel(currentFieldLabel);
	                							}
	                						}
	                					}
	                				}
	                			}
	                		}
	                	});
                		
                	} else {
                		Ext.Ajax.request({
	                		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	                		method: 'GET',
	                		async: false,
	                		params: {
	                			screenName: 'feepayerdetailform',
	                			academyLocationId:academyLocationId,
	                			languageCode:'en'
	                		},
	                		success: function(response) {
	                				debitOrderContainerItemId.setVisible(true);
	                			var json = JSON.parse(response.responseText);
	                			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
	                			fieldInfo.set("formFieldsInfo", json);
	                			//console.log(json);
	                			if( !isNullOrEmpty(json) ){
	                				if( !isNullOrEmpty(json.feepayerdetailform) ){
	                					var feePayerDetailDFRConfig = json.feepayerdetailform;
	                					for( i in feePayerDetailDFRConfig){
	                						var fieldConfig = feePayerDetailDFRConfig[i];
	                						console.log(fieldConfig);
	                						if( debitFieldsArr.includes(fieldConfig.formFieldId) ){
	                							if( fieldConfig.isMandatory){
	                								var currentField = form.down("#"+fieldConfig.formFieldId);
	                								var currentFieldLabel = fieldConfig.formFieldLabel;
	                								currentField.setFieldLabel(currentFieldLabel);
	                								$this.setAllowBlank(currentField, false);
	                							}
	                						}
	                					}
	                				}
	                			}
	                		}
	                	});
                	}
                	
                	//form.getForm().checkValidity();
                	
                },
                afterrender: function(radio){
                	
                	var academyLocationId = this.getCurrentAcademyLocation();
                	
                	var $this = this;
                	var form = radio.up('feepayerdetailform');
                	
                	var debitOrderContainerItemId = form.down("#debitOrderContainerItemId");
                	
                	var debitFieldsArr = ['#debitOrderDateItemId', '#accountNameItemId', '#accountTypeItemId', 
                		'#bankItemId', '#accountNumberItemId', '#branchCodeItemId','#debitOrderStartDate','#debitOrderEndDate'];
                	
                	
                	var task = new Ext.util.DelayedTask(function(){
                		if(radio.getValue().paymentMode=='EFT'){
                		for(i in debitFieldsArr){
                    		var field = form.down(debitFieldsArr[i]);
                    		$this.setAllowBlank(field, true);
                    	}
                		}
                	});
                	task.delay(1000);
                }
             },
             'feepayerdetailform[itemId=personfeepayerdetailformItemId] radiogroup[itemId=paymentModeItemId]': {
                 change: function(cb, nv, ov) {
                 	var $this = this;
                 	var form = cb.up('feepayerdetailform');
                 	
                 	var academyLocationId = this.getCurrentAcademyLocation();
                 	
                 	var debitOrderContainerItemId = form.down("#debitOrderContainerItemId");
                 	
                 	var debitFieldsArr = ['debitOrderDateItemId', 'accountNameItemId', 'accountTypeItemId', 
                 		'bankItemId', 'accountNumberItemId', 'branchCodeItemId','debitOrderStartDate','debitOrderEndDate'];

                 	if (nv.paymentMode == 'EFT') {
                 		
                 		Ext.Ajax.request({
 	                		url: SERVERURL.COMMON_FORM_FIELD_INFO,
 	                		method: 'GET',
 	                		async: false,
 	                		params: {
 	                			academyLocationId:academyLocationId,
 	                			languageCode:'en'
 	                		},
 	                		success: function(response) {
 	                			debitOrderContainerItemId.setVisible(false);
 	                			var json = JSON.parse(response.responseText);
 	                			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
 	                			fieldInfo.set("formFieldsInfo", json);
 	                			//console.log(json);
 	                			if( !isNullOrEmpty(json) ){
 	                				if( !isNullOrEmpty(json.feepayerdetailform) ){
 	                					var feePayerDetailDFRConfig = json.feepayerdetailform;
 	                					for( i in feePayerDetailDFRConfig){
 	                						var fieldConfig = feePayerDetailDFRConfig[i];
 	                						//console.log(fieldConfig);
 	                						if( debitFieldsArr.includes(fieldConfig.formFieldId) ){
 	                							//if( fieldConfig.isMandatory ){
 	                								var currentField = form.down("#"+fieldConfig.formFieldId);
 	                								$this.setAllowBlank(currentField, true);
 	                								var currentFieldLabel = fieldConfig.formFieldLabel;
 	                								currentField.setFieldLabel(currentFieldLabel);
 	                							//}
 	                						}
 	                					}
 	                				}
 	                			}
 	                		}
 	                	});
                 		
                 	} else {
                 		Ext.Ajax.request({
 	                		url: SERVERURL.COMMON_FORM_FIELD_INFO,
 	                		method: 'GET',
 	                		async: false,
 	                		params: {
 	                			academyLocationId:academyLocationId,
 	                			languageCode:'en'
 	                		},
 	                		success: function(response) {
 	                			debitOrderContainerItemId.setVisible(true);
 	                			var json = JSON.parse(response.responseText);
 	                			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
 	                			fieldInfo.set("formFieldsInfo", json);
 	                			//console.log(json);
 	                			if( !isNullOrEmpty(json) ){
 	                				if( !isNullOrEmpty(json.feepayerdetailform) ){
 	                					var feePayerDetailDFRConfig = json.feepayerdetailform;
 	                					for( i in feePayerDetailDFRConfig){
 	                						var fieldConfig = feePayerDetailDFRConfig[i];
 	                						console.log(fieldConfig);
 	                						if( debitFieldsArr.includes(fieldConfig.formFieldId) ){
 	                							if( fieldConfig.isMandatory ){
 	                								var currentField = form.down("#"+fieldConfig.formFieldId);
 	                								var currentFieldLabel = fieldConfig.formFieldLabel;
 	                								currentField.setFieldLabel(currentFieldLabel);
 	                								$this.setAllowBlank(currentField, false);
 	                							}
 	                						}
 	                					}
 	                				}
 	                			}
 	                		}
 	                	});
                 	}
                 	
                 	form.getForm().checkValidity();
                 	
                 },
                 afterrender: function(radio){
                 	
                 	var academyLocationId = this.getCurrentAcademyLocation();
                 	
                 	var $this = this;
                 	var form = radio.up('feepayerdetailform');
                 	
                 	var debitOrderContainerItemId = form.down("#debitOrderContainerItemId");
                 	
                 	var debitFieldsArr = ['#debitOrderDateItemId', '#accountNameItemId', '#accountTypeItemId', 
                 		'#bankItemId', '#accountNumberItemId', '#branchCodeItemId','#debitOrderStartDate','#debitOrderEndDate'];
                 
                 	var task = new Ext.util.DelayedTask(function(){
                 		if(radio.getValue().paymentMode=='EFT'){
                 		for(i in debitFieldsArr){
                     		var field = form.down(debitFieldsArr[i]);
                     		$this.setAllowBlank(field, true);
                     	}
                 		}
                 	});
                 	task.delay(1000);
                 }
              },
     //----------------- 
              'feepayerdetailsformparent radiogroup[itemId=paymentModeItemId]':{
            	  change: function(cb, nv, ov) {
            		  var $this = this;
            		  var form =$this.getFeepayerdetailsformparent();               	
            		  var academyLocationId = this.getCurrentAcademyLocation();

            		  if(!isNullOrEmpty(nv)){
            			  mode = nv;
            		  }else{
            			  mode = form.down('#paymentModeItemId') && form.down('#paymentModeItemId').getValue();
            		  }
            		  var debitOrderContainerItemId = form.down("#debitOrderContainerItemId");

            		  var debitFieldsArr = ['debitOrderDateItemId', 'accountNameItemId', 'accountTypeItemId', 
            			  'bankItemId', 'accountNumberItemId', 'branchCodeItemId','debitOrderStartDate','debitOrderEndDate'];
            		  if(debitOrderContainerItemId){
            			  if (mode.paymentMode == 'EFT') {
            				  debitOrderContainerItemId.setVisible(false);
            				  for(i in debitFieldsArr){
            					  var field = form.down('#'+debitFieldsArr[i]);
            					  $this.setAllowBlank(field, true);
            					  field.reset();
            				  }
            			  }else{
            				  debitOrderContainerItemId.setVisible(true);
            				  /*DFR code start from here*/  
            				  //$this.makeFieldAllowBlankAndMandatoryForReRegistration(form);     
            				  var response = $this.reRegfeePayerDataDFR;
            				  if( Object.keys(response).length > 0 ){
            					  response.feepayerdetailsformparent.forEach(function(rec){
            						  fieldCmp = form.down('#'+rec.formFieldId);
            						  if(!fieldCmp){
            							  fieldCmp = formFields.findField(rec.formFieldName);
            						  }
            						  if(fieldCmp){
            							  if(rec.formFieldId == 'debitOrderDateItemId'||rec.formFieldId == 'accountNameItemId'||rec.formFieldId == 'accountTypeItemId'||
            									  rec.formFieldId == 'bankItemId'||rec.formFieldId == 'accountNumberItemId'||rec.formFieldId == 'branchCodeItemId'){
            								  if(rec.isVisible){
            									  $this.setAllowBlank(fieldCmp, !rec.isMandatory);
            								  }else{
            									  $this.setAllowBlank(fieldCmp, true);
            								  }
            								  fieldCmp.setVisible(rec.isVisible);
            							  }
            							  $this.removeDoubleColon(fieldCmp,rec.formFieldLabel);
            						  }
            					  });
            				  }
            				  /*DFR code end here*/  
            			  }
            		  }
            		  form.getForm().checkValidity(); 
            		  /*if (mode.paymentMode == 'EFT') {
            			  Ext.Ajax.request({
            				  url: SERVERURL.COMMON_FORM_FIELD_INFO,
            				  method: 'GET',
            				  async: false,
            				  params: {
            					  academyLocationId:academyLocationId,
            					  languageCode:'en'
            				  },
            				  success: function(response) {
            					  debitOrderContainerItemId.setVisible(false);
            					  var json = JSON.parse(response.responseText);
            					  var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
            					  fieldInfo.set("formFieldsInfo", json);
            					  //console.log(json);
            					  if( !isNullOrEmpty(json) ){
            						  if( !isNullOrEmpty(json.feepayerdetailform) ){
            							  var feePayerDetailDFRConfig = json.feepayerdetailform;
            							  for( i in feePayerDetailDFRConfig){
            								  var fieldConfig = feePayerDetailDFRConfig[i];
            								  //console.log(fieldConfig);
            								  if( debitFieldsArr.includes(fieldConfig.formFieldId) ){
            									  //if( fieldConfig.isMandatory ){
            									  var currentField = form.down("#"+fieldConfig.formFieldId);
            									  $this.setAllowBlank(currentField, true);
            									  var currentFieldLabel = fieldConfig.formFieldLabel;
            									  currentField.setFieldLabel(currentFieldLabel);
            									  //}
            								  }
            							  }
            						  }
            					  }
            				  }
            			  });
            		  } else {
            			  Ext.Ajax.request({
            				  url: SERVERURL.COMMON_FORM_FIELD_INFO,
            				  method: 'GET',
            				  async: false,
            				  params: {
            					  academyLocationId:academyLocationId,
            					  languageCode:'en'
            				  },
            				  success: function(response) {

            					  debitOrderContainerItemId.setVisible(true);

            					  var json = JSON.parse(response.responseText);
            					  var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
            					  fieldInfo.set("formFieldsInfo", json);
            					  //console.log(json);
            					  if( !isNullOrEmpty(json) ){
            						  if( !isNullOrEmpty(json.feepayerdetailform) ){
            							  var feePayerDetailDFRConfig = json.feepayerdetailform;
            							  for( i in feePayerDetailDFRConfig){
            								  var fieldConfig = feePayerDetailDFRConfig[i];
            								  console.log(fieldConfig);
            								  if( debitFieldsArr.includes(fieldConfig.formFieldId) ){
            									  if( fieldConfig.isMandatory ){
            										  var currentField = form.down("#"+fieldConfig.formFieldId);
            										  var currentFieldLabel = fieldConfig.formFieldLabel;
            										  currentField.setFieldLabel(currentFieldLabel);
            										  $this.setAllowBlank(currentField, false);
            									  }
            								  }
            							  }

            							  if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='companyNameOtherLangItemId' && fieldConfig.isVisible==true){
            								  var companyNameOtherLang=form.down('#companyNameOtherLangItemId');
            								  companyNameOtherLang.setVisible(true);
            								  if(fieldConfig.isMandatory==true) {
            									  companyNameOtherLang.allowBlank=false;
            								  }
            							  }

            							  if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='contactPersonOtherLangItemId' && fieldConfig.isVisible==true){
            								  var contactPersonOtherLang=form.down('#contactPersonOtherLangItemId');
            								  contactPersonOtherLang.setVisible(true);
            								  if(fieldConfig.isMandatory==true) {
            									  contactPersonOtherLang.allowBlank=false;
            								  }

            								  if (nv.payerType == 'CORPORATE') {
            									  if(fieldConfig.formFieldInputType=='filefield' && fieldConfig.formFieldId=='companySponsorLetterItemId' && fieldConfig.isVisible==true){
            										  var currentField = form.down("#"+fieldConfig.formFieldId);
            										  //currentField.setVisible(true);
            									  }

            									  if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='surnameOtherLangItemId' && fieldConfig.isVisible==true){
            										  var surnameOtherLang=form.down('#surnameOtherLangItemId');
            										  surnameOtherLang.setVisible(true);
            										  if(fieldConfig.isMandatory==true) {
            											  surnameOtherLang.allowBlank=false;
            										  }
            									  }
            								  }
            							  }
            						  }
            					  }
            				  }
            			  });
            		  }
            		  form.getForm().checkValidity(); */               	
            	  },
            	 /* afterrender: function(radio){
            		  var academyLocationId = this.getCurrentAcademyLocation();

            		  var $this = this;
            		  //	var form = radio.up('feepayerdetailsformparent');
            		  var form =$this.getFeepayerdetailsformparent();

            		  var debitOrderContainerItemId = form.down("#debitOrderContainerItemId");

            		  var debitFieldsArr = ['#debitOrderDateItemId', '#accountNameItemId', '#accountTypeItemId', 
            			  '#bankItemId', '#accountNumberItemId', '#branchCodeItemId','#debitOrderStartDate','#debitOrderEndDate'];

            		  var task = new Ext.util.DelayedTask(function(){
            			  if(radio.getValue().paymentMode=='EFT'){
            				  for(i in debitFieldsArr){
            					  var field = form.down(debitFieldsArr[i]);
            					  $this.setAllowBlank(field, true);
            				  }
            			  }
            		  });
            		  task.delay(1000);
            	  }*/
              },
     //=================        
              'studentregistrationtabstructure button[itemId=finalCancelButtonId]':{
            	  click :  function(){
            		  var $this=this;
            		  $this.getContentPanel().getActiveTab().close();
            	  }
              },
              
              'studentregistrationtabstructure button[itemId=finalSubmitButtonId]':{
            	  click :  function(){
            		  var $this=this;
            		  var debitOrderDateCSM;
                  	  var structure = this.getStudentregistrationtabstructure();
                  	  var feePayerDetailtabstruc = structure.down("#feepayerdetailparenttabitemid");
                  	  var feePayerDetailForm = structure.down("#feepayerdetailsformparent");
                  	  var paymentTermGrid = structure.down('#feepayerpaymenttermselectiongridItemId');
                  	  var feePayerDetailValues = feePayerDetailForm.getForm().getValues();
					  
					  if(structure.isRegisterBtn){
							feePayerDetailValues.applicableForCurrentYear=true;
						}
					
                  	  var medicalDetailFormVales= structure.down('#medicaldetailsformparent');
                  	  var medicalDetailVales=medicalDetailFormVales.getForm().getValues();
					/** V2D-255561 start === Medical aid documennt uploaded  */
					if (!isNullOrEmpty(medicalDetailVales.documentId)) {
						var medicalAidDocument = {
                                             id: medicalDetailVales.documentId
                                         };
						medicalDetailVales.medicalAidDocument=medicalAidDocument;
						medicalDetailVales.documentId=null;
					}
					/** V2D-255561 end === Medical aid documennt uploaded  */
                  	  var path = feePayerDetailForm.down('#feePayerIDItemId').getValue();
                  	  var pathForSecondFile = feePayerDetailForm.down('#feePayerLatestPayslipItemId').getValue();
                  	  if(!isNullOrEmpty(feePayerDetailForm.down('#feePayerProofOfAccountItemId'))){
                  		 var pathForThirdFile = feePayerDetailForm.down('#feePayerProofOfAccountItemId').getValue();
                  	  }
                  	  var pathMedical = structure.down('#medicalDetailPath').getValue();
                  	  var userId = this.getCurrentlyLoggedInUser().id;
                  	  var personId= this.getPersonObj();
                  	  var finalSubmitBut= structure.down('#finalSubmitButtonId');
                  	  var parentFeePayerDetailGrid= $this.getParentfeepayerdetailgrid();
                  	var feePayerIDItemId = feePayerDetailForm.down('#feePayerIDItemId');
                  	var feePayerProofOfAccountItemId = feePayerDetailForm.down('#feePayerProofOfAccountItemId');
                    var feePayerID = feePayerIDItemId.getValue();
                    if(!isNullOrEmpty(feePayerProofOfAccountItemId)){
                       var feePayerProofOfAccountId = feePayerProofOfAccountItemId.getValue();
                    }
                    var feePayerLatestPayslipItemId = feePayerDetailForm.down('#feePayerLatestPayslipItemId');
                    var feePayerLatestPayslip = feePayerLatestPayslipItemId.getValue();
                  	   
                  	var debitOrderDateRegistrationItemId=feePayerDetailForm.down('#debitOrderDateItemId').getValue();
                  	var accountTypeItemId=feePayerDetailForm.down('#accountTypeItemId').getValue();
                  	var accountNumberItemId=feePayerDetailForm.down('#accountNumberItemId').getValue();
                  	var accountNameItemId=feePayerDetailForm.down('#accountNameItemId').getValue();
                  	var bankItemId=feePayerDetailForm.down('#bankItemId').getValue();
                  	var branchCodeItemId=feePayerDetailForm.down('#branchCodeItemId').getValue();
					var photoFornewsLetter =structure.down('#whetherAllowedPhotoForYearBookAndNewsletter').getValue().photoForYearBookAndNewsletter;
					var photoForSocialMedia =structure.down('#whetherAllowedPhotoForSocialMedia').getValue().photoForSocialMedia;
                  	
                  	/*var radioOne =structure.down('#nextYearSbilingItemId').getValue().isWheelChairRequired1;
                  	var radioTwo =structure.down('#currentYearBursaryAward').getValue().isWheelChairRequired2;
                  	var radioThird =structure.down('#nextYearBursaryAward').getValue().isWheelChairRequired3;
                  	var radioForth =structure.down('#isStudentChildOfAdvTechStaffRadio').getValue().isWheelChairRequired4;*/
                  	var whetherUpdated = structure.down('#whetherFeePayerDetailsUpdated').getValue();
                  	var feeDoc=null;	
                  	var doc =null;
                  	showConfirmMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('DO_YOU_WANT_TO_SAVE_THE_FEE_REGISTRATION'),function(btn,text){
                  		if (btn == 'yes') {
                  			if (!isNullOrEmpty(feePayerID) || !isNullOrEmpty(feePayerLatestPayslip) || !isNullOrEmpty(feePayerProofOfAccountId)) {
                  				feePayerDetailForm.getForm().submit({
                  					method: 'POST',
                  					url: SERVERURL.FPD_UPLOAD_FEE_PAYER_DOCUMENTS_TEMP,
//                					async: false,
                  					success: function(form1, action) {
                  						var responseData = Ext.decode(action.response.responseText);
                  						if(responseData.success) {
                  							var path = responseData.path;
                  							var pathForSecondFile = responseData.pathForSecondFile;
                  							var pathForThirdFile = responseData.pathForThirdFile;
                  							feePayerDetailForm.getForm().findField('feePayerIdUploadPath').setValue(path);
                  							feePayerDetailForm.getForm().findField('feePayerLatestPayslipUploadPath').setValue(pathForSecondFile);
											feePayerDetailForm.getForm().findField('feePayerProofOfAccountUploadPath').setValue(pathForThirdFile);
                  							user = {
                  									id: userId
                  							};

                  							if (!isNullOrEmpty(path)) {
                  								var fileName = feePayerDetailForm.getForm().findField('feePayerIdUploadPath').getValue().substring(path.lastIndexOf('/') + 1, path.length);
                  								doc = {
                  										path: feePayerDetailForm.getForm().findField('feePayerIdUploadPath').getValue(),
                  										name: feePayerDetailForm.getForm().findField('feePayerIdUploadPath').getValue(),
                  										type: 'DOCUMENT',
                  										createdBy: user
                  								};

                  							} 
                  							if (!isNullOrEmpty(pathForSecondFile)) {
                  								var fileName = feePayerDetailForm.getForm().findField('feePayerLatestPayslipUploadPath').getValue().substring(pathForSecondFile.lastIndexOf('/') + 1, pathForSecondFile.length);
                  								feeDoc = {
                  										path: feePayerDetailForm.getForm().findField('feePayerLatestPayslipUploadPath').getValue(),
                  										name: feePayerDetailForm.getForm().findField('feePayerLatestPayslipUploadPath').getValue(),
                  										type: 'DOCUMENT',
                  										createdBy: user
                  								};

                  							}
                  							if (!isNullOrEmpty(pathForThirdFile)) {
                  								var fileName = feePayerDetailForm.getForm().findField('feePayerProofOfAccountUploadPath').getValue().substring(pathForThirdFile.lastIndexOf('/') + 1, pathForThirdFile.length);
                  								feeDoc = {
                  										path: feePayerDetailForm.getForm().findField('feePayerProofOfAccountUploadPath').getValue(),
                  										name: feePayerDetailForm.getForm().findField('feePayerProofOfAccountUploadPath').getValue(),
                  										type: 'DOCUMENT',
                  										createdBy: user
                  								};

                  							}

                  							if(isNullOrEmpty(bankItemId)){
                  								delete feePayerDetailValues.bank;
                  							}



                  							if (!isNullOrEmpty(pathMedical)) {
                  								var fileName = pathMedical.substring(pathMedical.lastIndexOf('/') + 1, pathMedical.length);
                  								var medicalAidDocument = {
                  										path: pathMedical,
                  										name: fileName,
                  										type: 'DOCUMENT',
                  										createdBy: user
                  								};

                  							} 

                  							var salutation = null;
                  							if (!isNullOrEmpty(feePayerDetailValues.salutationId) && !isNullOrEmpty(feePayerDetailValues.salutationId.id)) {
                  								salutation = {
                  										id: feePayerDetailValues.salutationId.id
                  								};
                  							}
                  							feePayerDetailValues.salutation = salutation;
                  							delete  feePayerDetailValues.salutationId; 

                  							var paymentGridStore = paymentTermGrid.getStore();			
                  							var flag = false;
                  							paymentGridStore.data.items.forEach(function(itemObj){
                  								if(isNullOrEmpty(itemObj.data.totalAmount)){
                  									flag = true;
                  								}
                  							});
                  							if(flag != true){
                  								var userInfo =  Academia.model.authentication.PortalInfoModel
                  								var studentId = userInfo.data.student.id
                  								/**
													in case, when parent is adding fee payer detail at the time of registration 
													then by default system is registering for future classes 
													even if clicking Enroll now button
                  								 */
                  								if(structure.isRegisterBtn) {var getCardDetail = Ext.ComponentQuery.query('currentgradepaymenttermscardtpl')[0];
                                                var succeedingPBSTIdField;
                                                if (getCardDetail){
                                                succeedingPBSTIdField = parseInt(getCardDetail.down('[name=pbscId]').getValue());
                                                }
                                                else {
                                                    if (getResponseList.length>0){
                                                    succeedingPBSTIdField=getResponseList[0].programBatchSeatConfigId;
                                                }
                                                }
                                            }else{
                                                var getCardDetail = Ext.ComponentQuery.query('nextacademicyearpaymenttermcardtpl')[0];
                                                var succeedingPBSTIdField;
                                                if (getCardDetail){
                                                var succeedingPBSTIdField = parseInt(getCardDetail.down('#succeedingPBSTId').getValue());
                                                }
                                                else {
                                                    if (getResponseList.length>0){
                                                    succeedingPBSTIdField=getResponseList[1].programBatchSeatConfigId;
                                                }
                                                }
                                            }                  					
                  								feePayerDetailValues.bank={id:feePayerDetailValues.bank};
                  								if(!isNullOrEmpty(feePayerDetailValues.debitOrderDate)){
                  									debitOrderDateCSM = {
                  											id: feePayerDetailValues.debitOrderDate
                  									};

//                									feePayerDetailValues.debitOrderDate={id:feePayerDetailValues.debitOrderDateCSM};	
                  								}
                  								feePayerDetailValues.debitOrderDateCSM=debitOrderDateCSM;	
                  								delete feePayerDetailValues.debitOrderDate;
                  								if ( feePayerDetailValues.paymentMode == 'EFT' ){

                  									var paymentModProperties = ['accountName', 'accountNumber', 'branchCode', 
                  										'bank', 'accountType', 'debitOrderDate'];
             

                  									for( i in paymentModProperties ){
                  										var propertyName = paymentModProperties[i];
                  										if( propertyName in feePayerDetailValues ){
                  											delete feePayerDetailValues[propertyName];
                  										}
                  									}
                  								}
                  								feePayerDetailValues.feePayerId=doc;
                  								feePayerDetailValues.person=personId;
                  								feePayerDetailValues.feePayerLatestPayslip=feeDoc;
                  								medicalDetailVales.medicalAidDocument=medicalAidDocument;
                  								medicalDetailVales.person=personId;
                              					delete feePayerDetailValues.feePayerProofOfAccountUploadPath;

                  								//				delete feePayerDetailValues.whetherFeePayerDetailsUpdated;
                  								//  		var formValues = paymentTermForm.getValues();
                  								var putItems = [];
                  								paymentGridStore.data.items.forEach(function(itemObj){
                  									putItems.push({
                  										'feePlanId':itemObj.data.feePlanId,
                  										'feeRuleId':itemObj.data.feePlanRuleId,
                  										'studentId':studentId,
                  										'nextPBSId':succeedingPBSTIdField,
                  										'whetherStudentContinueInNAY':true,
                  										'wsFeePayerDetail':  feePayerDetailValues,
                  										'wsMedicalDetails':   medicalDetailVales,
                  										'forNextYearHaveSibiling':false ,
                  										'currentYearBursary':false,
                  										'nextYearBursary': false,
                  										'whetherFeePayerDetailsUpdated' : whetherUpdated,	
                  										'whetherAdvtechStaffChild': false,
                  										'whetherAllowedPhotoForYearBookAndNewsletter': photoFornewsLetter,
                  										'whetherAllowedPhotoForSocialMedia': photoForSocialMedia,
                                                        'operatingSystem':"windows"
                  									});
                  								});
                  								var submitData = Ext.encode(putItems);
                  								var submitUrl = SERVERURL.PATH_GRADE_PAYMENTTERMS_RESOURCE_CREATE;
                  								personId =personId.id;
                  								if(feePayerDetailValues.applicableForCurrentYear && feePayerDetailValues.isPrimaryFeePayer){                          		        		 
                  									Ext.Ajax.request({
                  										type: 'rest',
                  										async: false,
                  										url: SERVERURL.PATH_CHECK_ISPRIMARYFEEPAYER,
                  										params: {
                  											personId :personId,
                  											userType : "OTHER",

                  										},
                  										method: 'GET',
                  										success:function(res,data){
                  											if(res.responseText == "true" || res.responseText == true){             		        			     				
                  												showConfirmMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_CHANGE_THE_PRIMARY_FEE_PAYER?'), function(btn, text) {
                  													if (btn == 'yes') {
                  														Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                  														Ext.Ajax.request({
                  															type : 'rest',
                  															url : submitUrl,
                  															jsonData : submitData,
                  															method : 'POST',
                  															success : function(response, action) {
                  																var jdata = Ext.decode(response.responseText);
                  																if(jdata == "0"){
                  																	showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('REGISTRATION_ALREADY_DONE'));
                  																}else if(jdata == "1"){
                  																	showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM_SUCCESSFUL_MSG'));
                  																}
                  																Ext.getBody().unmask();
                  																if(parentFeePayerDetailGrid != undefined){
                  																	parentFeePayerDetailGrid.getStore().reload();
                  																	parentFeePayerDetailGrid.getSelectionModel().deselectAll();
                  																	//showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM_SUCCESSFUL_MSG'));
                  																	$this.loadGridStore('#parentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_GRID);
                  																}
                  																$this.getContentPanel().getActiveTab().close();

                  															}
                  														});
                  													}

                  												});
                  											}
                  											else{
                  												Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                  												Ext.Ajax.request({
                  													type : 'rest',
                  													url : submitUrl,
                  													jsonData : submitData,
                  													method : 'POST',
                  													success : function(response, action) {
                  														var jdata = Ext.decode(response.responseText);
                  														if(jdata == "0"){
                  															showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('REGISTRATION_ALREADY_DONE'));
                  														}else if(jdata == "1"){
                  															showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM_SUCCESSFUL_MSG'));
                  														}
                  														Ext.getBody().unmask();
                  														if(parentFeePayerDetailGrid != undefined){
                  															parentFeePayerDetailGrid.getStore().reload();
                  															parentFeePayerDetailGrid.getSelectionModel().deselectAll();
                  															//showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM_SUCCESSFUL_MSG'));
                  															$this.loadGridStore('#parentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_GRID);
                  														}
                  														$this.getContentPanel().getActiveTab().close();

                  													}
                  												});
                  											}
                  										}
                  									});

                  								}else{
                  									Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                  									Ext.Ajax.request({
                  										type : 'rest',
                  										url : submitUrl,
                  										jsonData : submitData,
                  										method : 'POST',
                  										success : function(response, action) {
                  											var jdata = Ext.decode(response.responseText);
                  											if(jdata == "0"){
                  												showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('REGISTRATION_ALREADY_DONE'));
                  											}else if(jdata == "1"){
                  												showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM_SUCCESSFUL_MSG'));
                  											}
                  											Ext.getBody().unmask();
                  											if(parentFeePayerDetailGrid != undefined){
                  												parentFeePayerDetailGrid.getStore().reload();
                  												parentFeePayerDetailGrid.getSelectionModel().deselectAll();
                  												//showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM_SUCCESSFUL_MSG'));
                  												$this.loadGridStore('#parentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_GRID);
                  											}
                  											$this.getContentPanel().getActiveTab().close();

                  										}
                  									});
                  								}
                  							}
                  						} 
                  					},
                  					failure: function(d, f, s) {
                  						console.log('hello');
                  					}
                  				});
                  			} else{
                  				if(isNullOrEmpty(bankItemId)){
                  					delete feePayerDetailValues.bank;
                  				}
                  				user = {
                  						id: userId
                  				};


                  				if (!isNullOrEmpty(pathMedical)) {
                  					var fileName = pathMedical.substring(pathMedical.lastIndexOf('/') + 1, pathMedical.length);
                  					var medicalAidDocument = {
                  							path: pathMedical,
                  							name: fileName,
                  							type: 'DOCUMENT',
                  							createdBy: user
                  					};

                  				} 

                  				var salutation = null;
                  				if (!isNullOrEmpty(feePayerDetailValues.salutationId) && !isNullOrEmpty(feePayerDetailValues.salutationId.id)) {
                  					salutation = {
                  							id: feePayerDetailValues.salutationId.id
                  					};
                  				}
                  				feePayerDetailValues.salutation = salutation;
                  				delete  feePayerDetailValues.salutationId; 

                  				var paymentGridStore = paymentTermGrid.getStore();			
                  				var flag = false;
                  				paymentGridStore.data.items.forEach(function(itemObj){
                  					if(isNullOrEmpty(itemObj.data.totalAmount)){
                  						flag = true;
                  					}
                  				});
                  				if(flag != true){
                  					var userInfo =  Academia.model.authentication.PortalInfoModel
                  					var studentId = userInfo.data.student.id
                  					
                    				var succeedingPBSTIdField;
                  					if($this.getStudentregistrationtabstructure().isRegisterBtn) {
                  						var getCardDetail = Ext.ComponentQuery.query('currentgradepaymenttermscardtpl')[0];
                  						if(getCardDetail != undefined){
                        					succeedingPBSTIdField = getCardDetail.down('[name=pbscId]').getValue();
                        				}else{
                        					succeedingPBSTIdField = getResponseList[0].programBatchSeatConfigId;
                        				}

                  					}else{
                  						var getCardDetail = Ext.ComponentQuery.query('nextacademicyearpaymenttermcardtpl')[0];
                  						if(getCardDetail != undefined){
                       					 succeedingPBSTIdField = getCardDetail.down('#succeedingPBSTId').getValue();
                       				}else{
                       					succeedingPBSTIdField = getResponseList[0].succeedingProgramBatchSeatConfigId;
                       				}

                  					}
                  					feePayerDetailValues.bank={id:feePayerDetailValues.bank};
                  					var debitOrderDateCSM=null;
                  					if(!isNullOrEmpty(feePayerDetailValues.debitOrderDate)){
                  						debitOrderDateCSM = {
                  								id: feePayerDetailValues.debitOrderDate
                  						};

//                						feePayerDetailValues.debitOrderDate={id:feePayerDetailValues.debitOrderDateCSM};	
                  					}
                  					feePayerDetailValues.debitOrderDateCSM=debitOrderDateCSM;	
                  					delete feePayerDetailValues.debitOrderDate;
                  					if ( feePayerDetailValues.paymentMode == 'EFT' ){

                  						var paymentModProperties = ['accountName', 'accountNumber', 'branchCode', 
                  							'bank', 'accountType', 'debitOrderDate'];

                  						for( i in paymentModProperties ){
                  							var propertyName = paymentModProperties[i];
                  							if( propertyName in feePayerDetailValues ){
                  								delete feePayerDetailValues[propertyName];
                  							}
                  						}
                  					}
                  					feePayerDetailValues.feePayerId=doc;
                  					feePayerDetailValues.person=personId;
                  					feePayerDetailValues.feePayerLatestPayslip=feeDoc;
                  					medicalDetailVales.medicalAidDocument=medicalAidDocument;
                  					medicalDetailVales.person=personId;
                  					delete feePayerDetailValues.feePayerProofOfAccountUploadPath;
                  					
                  					//				delete feePayerDetailValues.whetherFeePayerDetailsUpdated;
                  					//  		var formValues = paymentTermForm.getValues();
                  					
                  					var putItems = [];
                  					paymentGridStore.data.items.forEach(function(itemObj){
                  						putItems.push({
                  							'feePlanId':itemObj.data.feePlanId,
                  							'feeRuleId':itemObj.data.feePlanRuleId,
                  							'studentId':studentId,
                  							'nextPBSId':parseInt(succeedingPBSTIdField),
                  							'whetherStudentContinueInNAY':true,
                  							'wsFeePayerDetail':  feePayerDetailValues,
                  							'wsMedicalDetails':   medicalDetailVales,
                  							'forNextYearHaveSibiling':false ,
                  							'currentYearBursary':false,
                  							'nextYearBursary': false,
                  							'whetherFeePayerDetailsUpdated' : whetherUpdated,
                  							'whetherAdvtechStaffChild': false,
                  							'whetherAllowedPhotoForYearBookAndNewsletter': photoFornewsLetter,
                  							'whetherAllowedPhotoForSocialMedia': photoForSocialMedia,
                                            'operatingSystem':"windows"
                  						});
                  					});
                  					var submitData = Ext.encode(putItems);
                  					submitUrl = SERVERURL.PATH_GRADE_PAYMENTTERMS_RESOURCE_CREATE;

                  					if(feePayerDetailValues.applicableForCurrentYear && feePayerDetailValues.isPrimaryFeePayer){            		        			
                  						Ext.Ajax.request({
                  							type: 'rest',
                  							async: false,
                  							url: SERVERURL.PATH_CHECK_ISPRIMARYFEEPAYER,
                  							params: {
                  								personId :personId.id,
                  								userType : "OTHER",

                  							},
                  							method: 'GET',
                  							success:function(res,data){
                  								if(res.responseText == "true" || res.responseText == true){

                  									showConfirmMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_CHANGE_THE_PRIMARY_FEE_PAYER?'), function(btn, text) {
                  										if (btn == 'yes') {
                  											Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                  											Ext.Ajax.request({
                  												type : 'rest',
                  												url : submitUrl,
                  												jsonData : submitData,
                  												method : 'POST',
                  												success : function(response, action) {
                  													var jdata = Ext.decode(response.responseText);
                  													if(jdata == "0"){
                  														showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('REGISTRATION_ALREADY_DONE'));
                  													}else if(jdata == "1"){
                  														showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM_SUCCESSFUL_MSG'));
                  													}
                  													Ext.getBody().unmask();
                  													if(parentFeePayerDetailGrid != undefined){
                  														parentFeePayerDetailGrid.getStore().reload();
                  														parentFeePayerDetailGrid.getSelectionModel().deselectAll();
                  														//showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM_SUCCESSFUL_MSG'));
                  														$this.loadGridStore('#parentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_GRID);
                  													}
                  													$this.getContentPanel().getActiveTab().close();

                  												}
                  											});
                  										}
                  									});
                  								}else{
                  									Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                  									Ext.Ajax.request({
                  										type : 'rest',
                  										url : submitUrl,
                  										jsonData : submitData,
                  										method : 'POST',
                  										success : function(response, action) {
                  											var jdata = Ext.decode(response.responseText);
                  											if(jdata == "0"){
                  												showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('REGISTRATION_ALREADY_DONE'));
                  											}else if(jdata == "1"){
                  												showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM_SUCCESSFUL_MSG'));
                  											}
                  											Ext.getBody().unmask();
                  											if(parentFeePayerDetailGrid != undefined){
                  											  parentFeePayerDetailGrid.getStore().reload();
                  											  parentFeePayerDetailGrid.getSelectionModel().deselectAll();
                  											  //showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM_SUCCESSFUL_MSG'));
                  											  $this.loadGridStore('#parentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_GRID);
                  											}
                  											$this.getContentPanel().getActiveTab().close();

                  										}
                  									});
                  								}

                  							}
                  						});

                  					}
                  					else{
                  						Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
                  						Ext.Ajax.request({
                  							type : 'rest',
                  							url : submitUrl,
                  							jsonData : submitData,
                  							method : 'POST',
                  							success : function(response, action) {
                  								var jdata = Ext.decode(response.responseText);
                  								if(jdata == "0"){
                  									showWarningMessage(getCommonTranslation('ALERT'),getFeeAndPaymentCommonTranslation('REGISTRATION_ALREADY_DONE'));
                  								}else if(jdata == "1"){
                  									showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM_SUCCESSFUL_MSG'));
                  								}
                  								Ext.getBody().unmask();
                  								if(parentFeePayerDetailGrid != undefined){
                  									parentFeePayerDetailGrid.getStore().reload();
                      								parentFeePayerDetailGrid.getSelectionModel().deselectAll();
                      								//showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM_SUCCESSFUL_MSG'));
                      								$this.loadGridStore('#parentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_GRID);
                  								}
                  								$this.getContentPanel().getActiveTab().close();

                  							}
                  						});
                  					}

                  				}	

                  			}
                  		}
                  	});
                  	
            	  }
         		  
              },
              
              'studentregistrationtabstructure button[itemId=studentRegProcessNextButtonId]':{
            	  click :  function(){
            		  var $this=this;
            		  var personId = $this.getPersonObj();
            		  var structure = this.getStudentregistrationtabstructure();
            		  var feePayerDetailtabstruc = structure.down("#feepayerdetailparenttabitemid");
            		  var form = structure.down("#feepayerdetailsformparent");
            		 // form.down('#paymentModeItemId').fireEvent('change');
            		  //form.down('#empOfTheOrgItemId').fireEvent('change');
            		  
            		  var radioOne = structure.down("#nextYearSbilingItemId");
            		  var radioTwo = structure.down("#currentYearBursaryAward");
            		  var radioThree = structure.down("#nextYearBursaryAward");
            		  var radioFour = structure.down("#isStudentChildOfAdvTechStaffRadio");
            		  form.down('#submitButtonId').setVisible(false);
            		  form.down('#cancelButtonId').setVisible(false);
            		  form.down('#feePayerDetailNextButon').setVisible(true);
            		  var payerTypeItemId= form.down('#payerTypeItemId');
            		  var companyNameItemId= form.down('#companyNameItemId');
            		  var contactPersonItemId= form.down('#contactPersonItemId');
            		  var surnameItemId= form.down('#surnameItemId');
            		  var corporateItemId= form.down('#corporateId');
            		  var salutationItemId = form.down("#salutationItemId");
            		   salutationItemId.getStore().load();
            		
            		   form.down('#employeeIdItemId').setVisible(false);
            		  setTimeout(function(){
                		  if(payerTypeItemId.originalValue.payerType=="PERSON" || payerTypeItemId.lastValue.payerType=="PERSON"){
                			  companyNameItemId.setVisible(false);
                			  contactPersonItemId.setVisible(false);
                			  surnameItemId.setVisible(false);
                			  companyNameItemId.allowBlank=true;
                			  contactPersonItemId.allowBlank=true;
                			  surnameItemId.allowBlank=true;
                			  corporateItemId.allowBlank=true;
                			  corporateItemId.setVisible(false);
                		  }else{
                			  companyNameItemId.setVisible(true);
                			  contactPersonItemId.setVisible(true);
                			  surnameItemId.setVisible(true);
                			  //companyNameItemId.allowBlank=false;
                			  //contactPersonItemId.allowBlank=false;
                			  //surnameItemId.allowBlank=false;
                			 //corporateItemId.allowBlank=false;
                			  corporateItemId.setVisible(true);
                		  }
                		  if( payerTypeItemId.lastValue.payerType=="CORPORATE"){
                              corporateItemId.setVisible(true);
                          }
                		  if(structure.isRegisterBtn == true){
                			  if($this.getFeepayerdetailsformparent()){
                				  $this.getFeepayerdetailsformparent().down('#applicableForCurrentYearItemId').setVisible(false);
                			  }

                		  }

            		  },200);
            		 /* var radioFlag=null;
            		  if ((radioOne.items.items[0].getValue()==true || radioOne.items.items[1].getValue()==true) &&( radioTwo.items.items[0].getValue()==true 
            				  || radioTwo.items.items[1].getValue()==true)
            				  &&(radioThree.items.items[0].getValue()==true || radioThree.items.items[1].getValue()==true) 
            				  &&(radioFour.items.items[0].getValue()==true || radioFour.items.items[1].getValue()==true))
            		  	{
            			   radioFlag=false;

            			}else{
            				radioFlag=true;
            			}*/
            		  setTimeout(function(){
            			  //$this.remainingFieldsOfFeePayerForDFR(form);
	                	},100);
            		  
            		  submitUrl = SERVERURL.FIND_FIRST_FEE_PAYER_RECORD_PARENT;
            		  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
            		  Ext.Ajax.request({
            			  type : 'rest',
            			  url : submitUrl,
            			  method : 'GET',
            			  params : {
            				  personId : personId.id
            			  },	success : function(response, action) {
            				  Ext.getBody().unmask();
            				  if(!isNullOrEmpty(response.responseText)){
            					  var records = Ext.decode(response.responseText);
            					  if(!isNullOrEmpty(records.feePayerId)) {
            					  $this.feePayerEncryptedDocId=records.feePayerId.encryptedDocId;
            					  }
                				  if(!isNullOrEmpty(records)){
             					  structure.down("#whetherFeePayerDetailsUpdated").setValue(true);
             					  var payerTypeItemId = form.down("#payerTypeItemId");
             					  var paymentModeItemId = form.down('#paymentModeItemId');
             					      paymentModeItemId.setValue({paymentMode:records.paymentMode});
             					  payerTypeItemId.setReadOnly(true);
             					  var doesFeePayerConsentToCreditCheckItemId = form.down("#doesFeePayerConsentToCreditCheckItemId");
             					  if (!isNullOrEmpty(records) && !isNullOrEmpty(records.doesFeePayerConsentToCreditCheck)) {
             						  doesFeePayerConsentToCreditCheckItemId.setValue({
             							  doesFeePayerConsentToCreditCheck: records.doesFeePayerConsentToCreditCheck
             						  });
             					  }
             					  var salutationItemId = form.down("#salutationItemId");
             					  if (!isNullOrEmpty(records.salutation) && !isNullOrEmpty(records.salutation.id)) {
             						  salutationItemId.setValue(records.salutation.id);
             					  }

             					  var bankItemId = form.down("#bankItemId");
             					  var debitOrderDateRegistration = form.down("#debitOrderDateItemId");
             					  var empOfTheOrganizationField = form.down("#empOfTheOrgItemId");
             					  if (!isNullOrEmpty(records) && !isNullOrEmpty(records.employeeOfOrganization)) {
             						  empOfTheOrganizationField.setValue({
             							  employeeOfOrganization: records.employeeOfOrganization
             						  });
             					  }

             					  var branchCodeId = form.down("#branchCodeItemId");

             					  if (!isNullOrEmpty(records) && !isNullOrEmpty(records.bank)){
             						  bankItemId.getStore().load({
             							  callback: function(recordss, operation, success) {
             								  for(var i in recordss){
             									  if( !isNullOrEmpty(records.bank) ){
             										  if(recordss[i].data.id==records.bank.id){
             											  bankItemId.setValue(recordss[i].data.id);
             										  }
             									  }
             								  }
             							  }	   
             						  });

             						  var branchCodeStore = branchCodeId.getStore();
             						  branchCodeStore.getProxy().extraParams = {
             							  bankId: records.bank.id
             						  };
             						  branchCodeStore.load();
             					  }

             					  if (!isNullOrEmpty(records) && !isNullOrEmpty(records.debitOrderDateCSM)){
             						 debitOrderDateRegistration.getStore().load({
             							  callback: function(recordss, operation, success) {
             								  for(var i in recordss){
             									  if( !isNullOrEmpty(records.debitOrderDateCSM) ){
             										  if(recordss[i].data.id==records.debitOrderDateCSM.id){
             											 debitOrderDateRegistration.setValue(recordss[i].data.id);
             										  }
             									  }
             								  }
             							  }	   
             						  });

             					  }
             					  
             					  if(!isNullOrEmpty(records) && records.branchcode!=null){
             						  branchCodeId.setValue(records.branchcode);
             					  }

             					  var addressText = form.down('#addressTextArea');
             					  var country = form.down('#countryId');
             					  country.getStore().load();
             					  form.down('#homeTelephoneCountryCodeItemId').getStore().load();
             					  form.down('#workTelephoneCountryCodeItemId').getStore().load();
             					  form.down('#countryCodeItemId').getStore().load();
             					  var countryRegion = form.down('#parentCountryRegionId');
             					  var city = form.down('#cityId');
             					  var pincode = form.down('#pincodeId');

             					  if (!isNullOrEmpty(records) && !isNullOrEmpty(records.addressText)) {
             						  addressText.setValue(records.addressText);
             					  }
             					  if (!isNullOrEmpty(records) && !isNullOrEmpty(records.pincode)) {
             						  pincode.setValue(records.pincode);
             					  }
             					  if (!isNullOrEmpty(records) && !isNullOrEmpty(records.countryId)) {
             						  country.setValue(records.countryId);
             						  var countryRegionStore = countryRegion.getStore();
             						  countryRegionStore.getProxy().extraParams = {
             							  cid: records.countryId
             						  };
             						  countryRegionStore.load();                  
             					  }
             					  if (!isNullOrEmpty(records) && !isNullOrEmpty(records.parentCountryRegionId)) {

             						  countryRegion.setValue(records.parentCountryRegionId);            		
             						  var cityStore = city.getStore();

             						  cityStore.getProxy().extraParams = {
             							  countryId: records.countryId,
             							  countryRegionId: records.parentCountryRegionId
             						  };
             						  cityStore.load();
             					  }
             					  if (!isNullOrEmpty(records) && !isNullOrEmpty(records.cityId)) {
             						  city.setValue(records.cityId);
             					  }

             					  var feePayerIDItemId = form.down("#feePayerIDItemId");
             					  var feePayerLatestPayslipItemId = form.down("#feePayerLatestPayslipItemId");
             					  var feePayerProofOfAccountItemId = form.down('#feePayerProofOfAccountItemId');
             					  
             					 setTimeout(function(){
             						form.down('#debitOrderStartDate').setValue(dateRender(records.debitOrderStartDate))
            						 form.down('#debitOrderEndDate').setValue(dateRender(records.debitOrderEndDate))
            	                	},500);
             					  setTimeout(function(){
             						  $this.setAllowBlank(feePayerIDItemId, false);
                                      if(feePayerProofOfAccountItemId){
                                    	 //$this.setAllowBlank(feePayerProofOfAccountItemId, false);
                                      }
             						  form.isValid();
             	                	},500);
             					 // feePayerIDItemId.allowBlank = true;
             					  var applicableForCurrentYear = form.down('#applicableForCurrentYearItemId');
             					  applicableForCurrentYear.setVisible(true);
             					  //feePayerLatestPayslipItemId.allowBlank = false;
             					  feePayerIDItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_ID'));
             					  feePayerLatestPayslipItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_LATEST_PAYSLIP'));
             					  if(feePayerProofOfAccountItemId){ //as field is not there on parent portal
             						 feePayerProofOfAccountItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_PROOF_OF_ACCOUNT'));
             					  }
             					  form.getForm().setValues(records);
             					  form.down("#feePayerDetailNextButon").setDisabled(false);
             					  var availableDocumentLabelItemId = form.down('#availableDocumentLabelItemId');
          						 if(!isNullOrEmpty(records) && !isNullOrEmpty(records.feePayerId)) {
          							 if(!isNullOrEmpty(records.feePayerId.id)) {
          								 var documentIdItemId = form.down('#documentIdItemId');
          								 documentIdItemId.setValue(records.feePayerId.id);
          							 }
          							// availableDocumentLabelItemId.setVisible(true); 
          						 } else {
          							 availableDocumentLabelItemId.setVisible(false); 
          						 }
             				   
            				  }
            			  }
            				  else{
            					  structure.down("#whetherFeePayerDetailsUpdated").setValue(false);
            					  var countryCodeFieldItemIDArray = ["#homeTelephoneCountryCodeItemId","#workTelephoneCountryCodeItemId","#countryCodeItemId"];
                      		      $this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
            					  var feePayerIDItemId = form.down("#feePayerIDItemId");
            					  var feePayerLatestPayslipItemId = form.down("#feePayerLatestPayslipItemId");
            					  var employeeIdItemIds = form.down("#employeeIdItemId");
            					  setTimeout(function(){
            						  $this.setAllowBlank(feePayerIDItemId, false);
            						  $this.setAllowBlank(employeeIdItemIds, true);
            					  },500);

            				  }
            			  }
            		  });

          //  		  feePayerDetailtabstruc.down('#salutationItemId').getStore().load();
            		  var paymentTermGrid = structure.down('#feepayerpaymenttermselectiongridItemId');
            		  var applicableForCurrentYear = form.down('#applicableForCurrentYearItemId');
 					  applicableForCurrentYear.setVisible(true);
            		  var paymentGridStore = paymentTermGrid.getStore();			
            		  var flag = false;
            		  paymentGridStore.data.items.forEach(function(itemObj){
            		 // if(isNullOrEmpty(itemObj.data.totalAmount)  || radioFlag==true){
            				  if(isNullOrEmpty(itemObj.data.totalAmount)){
            				  flag = true;
            			  }
            		  });
            		  if(flag != true){            			  
            			  feePayerDetailtabstruc.setDisabled(false);
            			  structure.setActiveTab(feePayerDetailtabstruc);	
            		  }
            		  else{
            			  showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_FILL_IN_ALL_THE_REQUIRED_DETAILS'));
            		  }

            	  }
              },
           'studentregistrationtabstructure button[itemId=submitButtonIdNoReasonId]':{
      		  click :  function(){
           	  var $this=this;
           	  var structure = this.getStudentregistrationtabstructure();
           	  var feePayerDetailtabstruc = structure.down("#feepayerdetailparenttabitemid");
           	  var parentFeePayerDetailGrid= $this.getParentfeepayerdetailgrid();
    //   		var paymentTermForm = obj.up('form');
       		  var photoFornewsLetter =structure.down('#whetherAllowedPhotoForYearBookAndNewsletter').getValue().photoForYearBookAndNewsletter;
			  var photoForSocialMedia =structure.down('#whetherAllowedPhotoForSocialMedia').getValue().photoForSocialMedia;
	
 				var paymentTermGrid = structure.down('#feepayerpaymenttermselectiongridItemId');
 				var paymentGridStore = paymentTermGrid.getStore();			
 				
 						var userInfo =  Academia.model.authentication.PortalInfoModel
 		        		var studentId = userInfo.data.student.id
 						//var getCardDetail = Ext.ComponentQuery.query('nextacademicyearpaymenttermcardtpl')[0];
 						//var succeedingPBSTIdField = getCardDetail.down('#succeedingPBSTId');
 		        		var succeedingPBSTIdField='';
   						getResponseList.forEach(function(record){
   							//V2D-454188
   							//if(record.paymentTermName == "NEXT_PAYMENT_TERM"){
   								succeedingPBSTIdField=record.succeedingProgramBatchSeatConfigId;
   							//}
   						});
 		        		
 		        		var putItems = [];
 		        		paymentGridStore.data.items.forEach(function(itemObj){
 			        		putItems.push({
 			        				'feePlanId':itemObj.data.feePlanId,
 			        				'feeRuleId':itemObj.data.feePlanRuleId,
 			        				'studentId':studentId,
 			                	    'nextPBSId':succeedingPBSTIdField,
 			                	    'whetherStudentContinueInNAY':false,
 			                	    'parentFeedback':structure.down('#providFeedbackItemId').getValue(), 
 			                	    'parentReason':structure.down('#reasonForNoSelection').getValue(),
									'whetherAllowedPhotoForYearBookAndNewsletter': photoFornewsLetter,
									'whetherAllowedPhotoForSocialMedia': photoForSocialMedia,
									'operatingSystem':"windows"
 			        		});
 		        		});
 		        	   var submitData = Ext.encode(putItems);
 		        	  submitUrl = SERVERURL.PATH_GRADE_PAYMENTTERMS_RESOURCE_CREATE;
 		       		  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 		       	 	  Ext.Ajax.request({
 		       			  type : 'rest',
 		       			  url : submitUrl,
 		       			  jsonData : submitData,
 		       			  method : 'POST',
 		       			  success : function(response, action) {
 		       				  Ext.getBody().unmask();
 		       				  showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('THANKYOU_FOR_SUBMITTING_THE_DETAILS')); 
 		       				 $this.loadGridStore('#parentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_GRID);
// 		       				 obj.up('feepayernextacademicpaymenttermform').close();
 		       				 structure.close();
 		       				 if(parentFeePayerDetailGrid){
 		       					 parentFeePayerDetailGrid.getStore().reload();
 		       				 }
 		       				$this.getContentPanel().getActiveTab().close();
 		       			  }
 		       	 	  });
 					
 //========================================      	
      		  }
            },
            'studentregistrationtabstructure button[itemId=submitButtonTransferToOtherADVId]':{
        		  click :  function(){
             	  var $this=this;
             	  var structure = this.getStudentregistrationtabstructure();
             	  var parentFeePayerDetailGrid= $this.getParentfeepayerdetailgrid();
             	  var feePayerDetailtabstruc = structure.down("#feepayerdetailparenttabitemid");
        
   				var paymentTermGrid = structure.down('#feepayerpaymenttermselectiongridItemId');
   				var paymentGridStore = paymentTermGrid.getStore();			
   				var photoFornewsLetter =structure.down('#whetherAllowedPhotoForYearBookAndNewsletter').getValue().photoForYearBookAndNewsletter;
			  	var photoForSocialMedia =structure.down('#whetherAllowedPhotoForSocialMedia').getValue().photoForSocialMedia;
   						var userInfo =  Academia.model.authentication.PortalInfoModel
   		        		var studentId = userInfo.data.student.id
   						//var getCardDetail = Ext.ComponentQuery.query('nextacademicyearpaymenttermcardtpl')[0];
   						//var succeedingPBSTIdField = getCardDetail.down('#succeedingPBSTId');
   						var succeedingPBSTIdField='';
   						getResponseList.forEach(function(record){
   							//V2D-454188
   							//if(record.paymentTermName == "NEXT_PAYMENT_TERM"){
   								succeedingPBSTIdField=record.succeedingProgramBatchSeatConfigId;
   							//}
   						});
   		        		var putItems = [];
   		        		paymentGridStore.data.items.forEach(function(itemObj){
   			        		putItems.push({
   			        				'feePlanId':itemObj.data.feePlanId,
   			        				'feeRuleId':itemObj.data.feePlanRuleId,
   			        				'studentId':studentId,
   			                	    'nextPBSId':succeedingPBSTIdField,
   			                	    'whetherStudentContinueInNAY':false,
   			                	    'academyLocation':structure.down('#debitOrderDateItemId').getValue(),
									'whetherAllowedPhotoForYearBookAndNewsletter': photoFornewsLetter,
									'whetherAllowedPhotoForSocialMedia': photoForSocialMedia,
									'operatingSystem':"windows" 
   			        		});
   		        		});
   		        	   var submitData = Ext.encode(putItems);
   		        	  submitUrl = SERVERURL.PATH_GRADE_PAYMENTTERMS_RESOURCE_CREATE;
   		       		  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
   		       	 	  Ext.Ajax.request({
   		       			  type : 'rest',
   		       			  url : submitUrl,
   		       			  jsonData : submitData,
   		       			  method : 'POST',
   		       			  success : function(response, action) {
   		       				  Ext.getBody().unmask();
   		       				  showSuccessMessage(getCommonTranslation('STUDENT_RE_REGISTRATION'), getCommonTranslation('THANKYOU_FOR_SUBMITTING_THE_DETAILS'));
   		       				 $this.loadGridStore('#parentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_GRID);
//   		       				 obj.up('feepayernextacademicpaymenttermform').close();
                             if(parentFeePayerDetailGrid){
                            	 parentFeePayerDetailGrid.getStore().reload();
                             }
   		       				 structure.close();
   		       				$this.getContentPanel().getActiveTab().close();
   		       			  }
   		       	 	  });
   					
        		  }
              },
            
              'feepayerdetailsformparent button[itemId=feePayerDetailNextButon]':{
      		  click :  function(){
              	  var $this=this;
              	  var structure = this.getStudentregistrationtabstructure();
//                var feePayerDetailtabstruc = structure.down("feepayerdetailform");
              	  var feePayerDetailtabstruc = structure.down("#feepayerdetailsformparent");
              	  var payerType =  feePayerDetailtabstruc.down('#payerTypeItemId').getValue();
              	  if(payerType.payerType=='CORPORATE'){
              		  $this.setAllowBlank(feePayerDetailtabstruc.down('#feePayerIDItemId'), true);
              		  $this.setAllowBlank(feePayerDetailtabstruc.down('#feePayerLatestPayslipItemId'), true);
              	  }
              	  if(!feePayerDetailtabstruc.isValid()){
              		  showWarningMessage(getCommonTranslation('ALERT'),getCompletionModuleTranslation('FILL_MANDATORY_FIELDS'));
              		  return false;
              	  }
              	  var medicalDetailtabstruc = structure.down("#medicalDetailParentItemId");
              	  var medicalDetailForm=structure.down("#medicaldetailsformparent");
              	/* commented because in case of NO dfr un necessary * was coming and disturbing alignment of number field*/              	  
              	/*   setTimeout(function(){
              		  medicalDetailForm.down("#familyPractionerContactNumberItemId").labelSeparator = '';
                	  medicalDetailForm.down("#familyPractionerContactNumberItemId").setFieldLabel('<span class="required" style="color:red"> *</span>');
                	  medicalDetailForm.down('#medicalDetailNextButtonId').setDisabled(false);
                	  $this.removeStarFromDFR(medicalDetailForm);
              	  },300);
              	  */
              	  
              	  medicalDetailForm.down('#submitButtonId').setVisible(false);
              	  medicalDetailForm.down('#medicalDetailNextButtonId').setVisible(true);
              	  medicalDetailtabstruc.setDisabled(false); 
              	  structure.setActiveTab(medicalDetailtabstruc);
//                  medicalDetailForm.down('#medicalDetailNextButtonId').setDisabled(false);
              	  medicalDetailtabstruc.down('#bloodTypeItemId').getStore().load();   
              	  var personId = $this.getPersonObj();
            	  submitUrl = SERVERURL.MD_PERSON_MEDICAL_DETAIL_FIND_BY_PERSON_ID;
        		  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        		  Ext.Ajax.request({
        			  type : 'rest',
        			  url : submitUrl,
        			  method : 'GET',
        			  params : {
        				  personId : personId.id
        			  },	       			  success : function(response, action) {
        				  Ext.getBody().unmask();
        				  medicalDetailForm.down('#medicalDetailNextButtonId').setDisabled(false);
     					 
        				  if(!isNullOrEmpty(response.responseText)){
        					  var records = Ext.decode(response.responseText);
            				  if(!isNullOrEmpty(records)){
            					  medicalDetailForm.getForm().setValues(records);
            						 var availableDocumentLabelItemId = medicalDetailForm.down('#availableDocumentLabelItemId');
            						 if(!isNullOrEmpty(records) && !isNullOrEmpty(records.medicalAidDocument)) {
            							 if(!isNullOrEmpty(records.medicalAidDocument.id)) {
            								 var documentIdItemId = medicalDetailForm.down('#documentIdItemId');
            								 documentIdItemId.setValue(records.medicalAidDocument.id);
            							 }
            							 availableDocumentLabelItemId.setVisible(true); 
            						 } else {
            							 availableDocumentLabelItemId.setVisible(false); 
            						 }
            					 }  
        				   }
        				  else{
        					  var countryFieldItemIDArray = ["#familyPractionerCountryCodeItemId"];
        					  $this.setDefaultCountryCode(medicalDetailForm, countryFieldItemIDArray); 
        					  //medicalDetailForm.down('#familyPractionerCountryCodeItemId').reset(); // V2D-246504
        					  medicalDetailForm.down('#medicalDetailNextButtonId').setDisabled(false);
        					  /* var countryCodeFieldItemIDArray = ["#familyPractionerCountryCodeItemId"];
        						 $this.setDefaultCountryCode(medicalDetailForm, countryCodeFieldItemIDArray);
        					   */        					 }
        				  
//        				  ------------------
        			  }
        		  });
              	  
                  var academyLocationId = this.getCurrentAcademyLocation();
              	
                  var newMandatoryFields = ['familyPractionerNameItemId','familyPractionerCountryCodeItemId','familyPractionerContactNumberItemId'];
              	
                  Ext.Ajax.request({
              		url: SERVERURL.COMMON_FORM_FIELD_INFO,
              		method: 'GET',
              		async: false,
              		params: {
              			screenName: 'medicaldetailsform',
              			academyLocationId:academyLocationId,
              			languageCode:'en'
              		},
              		success: function(response) {/*
              			var json = JSON.parse(response.responseText);
              			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
              			fieldInfo.set("formFieldsInfo", json);
              			//console.log(json);
              			if( !isNullOrEmpty(json) ){
              				if( !isNullOrEmpty(json.medicaldetailsform) ){
              					var medicalDetailFormDFRConfig = json.medicaldetailsform;
              					for( i in medicalDetailFormDFRConfig){
              						var fieldConfig = medicalDetailFormDFRConfig[i];
              						//console.log(fieldConfig);
              						if( newMandatoryFields.includes(fieldConfig.formFieldId) ){
              							if( fieldConfig.isMandatory ){
              								var currentField = medicalDetailForm.down("#"+fieldConfig.formFieldId);
              								$this.setAllowBlank(currentField, false);
              								var currentFieldLabel = fieldConfig.formFieldLabel;
              								currentField.setFieldLabel(currentFieldLabel);
              							}
              						}
              					}
              				}
              			}
              		*/}
              	});

              medicalDetailForm.down('#medicalDetailNextButtonId').setDisabled(false);
         		  }
               },

               'medicaldetailsform[itemId=medicaldetailsformparent] textfield': {
            	   change: function(textfield, value, eOpts) {
            		   var $this = this;
            		   var formm = $this.getMedicaldetailsformparent();
            		   var nextbtn = formm.down('#medicalDetailNextButtonId');
            		   if(textfield.itemId !='familyPractionerCountryCodeItemId'){
            			   var form = this.getMedicaldetailsformparent();
            			  /* if(form.isValid()){
            				   nextbtn.setDisabled(false);
            			   }else{
            				   nextbtn.setDisabled(true);
            			   } As DFR has been created for medical form and next button need to keep enabled always*/

            		   }

            	   }
               },

               'medicaldetailsform[itemId=medicaldetailsformparent] textfield[itemId=membershipNumberItemId]': {
            	   change: function(textfield, value, eOpts) {
            		   var $this = this;
            		   var formm = $this.getMedicaldetailsformparent();
            		   var nextbtn = formm.down('#medicalDetailNextButtonId');
            		   if(textfield.itemId !='familyPractionerCountryCodeItemId'){
            			   var form = this.getMedicaldetailsformparent();
            			  /* if(form.isValid()){
            				   nextbtn.setDisabled(false);
            			   }else{
            				   nextbtn.setDisabled(true);
            			   }As DFR has been created for medical form and next button need to keep enabled always*/

            		   }

            	   }
               },
               'medicaldetailsform[itemId=medicaldetailsformparent] button[itemId=medicalDetailNextButtonId]':{
          		  click :  function(){
               	  var $this=this;
               	  var structure = $this.getStudentregistrationtabstructure();
              	  var medicaldetailsformparents = structure.down("medicaldetailsform");
               	  
              	  
  //            	var personProfile = this$.getContentPanelActiveTab();
//              	var form = personProfile.down('medicaldetailsform');//this$.getPersonMedicalDetailsForm();
              	var medicalAidDocumentItemId = medicaldetailsformparents.down('#medicalAidDocumentItemId');
              	var medicalAidDocumentPath = medicalAidDocumentItemId.getValue();
         		 var uplaodUrl = SERVERURL.DOCUMENT_FILE_ADD;
        		 if (!isNullOrEmpty(medicalAidDocumentPath)) {
        			 medicaldetailsformparents.getForm().submit({
        				 method: 'POST',
        				 url: uplaodUrl,
        				 success: function(form1, action) {
        					 //callback(true); 
        					 var responseData = Ext.decode(action.response.responseText);
        					 var path = responseData.path;
        					 structure.down("#medicalDetailPath").setValue(path);
        				 }
        			 });
        		 }
               	  
               	 /* if(!medicaldetailsformparents.isValid()){
            		  showWarningMessage(getCommonTranslation('ALERT'),getCompletionModuleTranslation('FILL_MANDATORY_FIELDS'));
            		  return false;
            	  }*/
               	  
               	  var documenttabstruc = structure.down("#documentDetailParentItemId");
               	  documenttabstruc.setDisabled(false);
               	  structure.setActiveTab(documenttabstruc);
          		  }
                },
                
              'studentregistrationtabstructure radiogroup[itemId=nextAcademicYearItemId]': {
    			change:function(cb, nv, ov){
    				
    				var form = this.getStudentregistrationtabstructure();
    				var providFeedbackItemId = form.down('#providFeedbackItemId');
    				var allowblankFalse = ':<span class="required" style="color:red"> *</span>';
    				providFeedbackItemId.labelSeparator = '';
    				providFeedbackItemId.setFieldLabel(getCommonTranslation('PROVIDE_FEEDBACK')+allowblankFalse);
    				
    				var debitOrderDateItemId = form.down('#debitOrderDateItemId');
    				debitOrderDateItemId.labelSeparator = '';
    				debitOrderDateItemId.setFieldLabel(getCommonTranslation('ADVTECT_SCHOOLS')+allowblankFalse);
    				
    				var feePlanField = form.down("#noFeedbackItemId");
    				var feePlanField1 =form.down("#anotherAdvtechItemId");
    				var refAdjustment = form.down("#reasonForNoSelectionItemId");
    				var paymentTermParentGrid=this.getFeepayerpaymenttermselectiongrid();
//    				var paymentTermParentGrid=this.getPaymenttermsectionlist(); //This one Not Needed..
    				var nextYearSibiling=form.down('#nextYearSbilingItemId');
    				var currentYearBursary=form.down('#currentYearBursaryAward')
    				var nextYearBursary=form.down('#nextYearBursaryAward')
    				var submitButtonIdNoReas=form.down('#submitButtonIdNoReason')
    				var submitButtonTransferToOther=form.down('#submitButtonTransferToOtherADV')
    			var submitButtonTransferToOther=form.down('#submitButtonTransferToOtherADV')
    				var regProcessNextButton=form.down('#studentRegProcessNextButtonId')
    				var secondTab= form.down('#feepayerdetailparenttabitemid')
    				var thirdTab= form.down('#medicalDetailParentItemId')
    				var fourthTab= form.down('#documentDetailParentItemId')
    				
    				var nextYearSibilingLable= form.down('#forNextYearSibilingTitleId')
    				var currentYearBursaryLable= form.down('#currentYearBursaryTitleId')
    				var nextYearBursaryLable= form.down('#nextYearBursaryTitleId')
    				
    				var isStudentChildOfAdvTech= form.down('#isStudentChildOfAdvTechStaff')
    				var isStudentChildOfAdvTechRadio= form.down('#isStudentChildOfAdvTechStaffRadio')
    				var aboveProvideFeedbackLabel= form.down('#aboveProvideFeedbackLabel')
    				
					var reqLabel= form.down('#req');
					var popiLabel= form.down('#popi');
					var popiDescriptionLabel= form.down('#popiDescription');
					//var serial1Label = form.down('#serial1');
					var whetherAllowedPhotoForYearBookAndNewsletter= form.down('#whetherAllowedPhotoForYearBookAndNewsletter');
					//var serial2Label= form.down('#serial2');
					var whetherAllowedPhotoForSocialMediaLabel= form.down('#whetherAllowedPhotoForSocialMedia');
    				
    				if(nv.radioButtonResponse == false) {
    					if(!isNullOrEmpty(feePlanField)){
        					feePlanField.setVisible(true);
        					feePlanField.allowBlank=false;
    					}
    					if(!isNullOrEmpty(feePlanField1)){
    						feePlanField1.setVisible(false);
    					}
    					if(!isNullOrEmpty(paymentTermParentGrid)){
    						paymentTermParentGrid.setVisible(false);
    					}
    					if(!isNullOrEmpty(nextYearSibiling)){
    						nextYearSibiling.setVisible(false);
    					}
    					if(!isNullOrEmpty(currentYearBursary)){
    						currentYearBursary.setVisible(false);
    					}
    					if(!isNullOrEmpty(nextYearBursary)){
    						nextYearBursary.setVisible(false);
    					}
    					if(!isNullOrEmpty(submitButtonIdNoReas)){
    						submitButtonIdNoReas.setVisible(true);
    					}
    					if(!isNullOrEmpty(regProcessNextButton)){
    						regProcessNextButton.setVisible(false);
    					}
    					if(!isNullOrEmpty(secondTab)){
    						secondTab.setDisabled(true);
    					}
    					if(!isNullOrEmpty(thirdTab)){
    						thirdTab.setDisabled(true);
    					}
    					if(!isNullOrEmpty(fourthTab)){
    						fourthTab.setDisabled(true);
    					}
    					if(!isNullOrEmpty(nextYearSibilingLable)){
    						nextYearSibilingLable.setVisible(false);
    					}
    					if(!isNullOrEmpty(currentYearBursaryLable)){
    						currentYearBursaryLable.setVisible(false);
    					}
    					if(!isNullOrEmpty(nextYearBursaryLable)){
    						nextYearBursaryLable.setVisible(false);
    					}
    					if(!isNullOrEmpty(submitButtonTransferToOther)){
    						submitButtonTransferToOther.setVisible(false);
    					}
    					if(!isNullOrEmpty(isStudentChildOfAdvTech)){
    						isStudentChildOfAdvTech.setVisible(false);
    					}
    					if(!isNullOrEmpty(isStudentChildOfAdvTechRadio)){
    						isStudentChildOfAdvTechRadio.setVisible(false);
    					}
    					if(!isNullOrEmpty(aboveProvideFeedbackLabel)){
    						aboveProvideFeedbackLabel.setVisible(true);
    					}
				
						if(!isNullOrEmpty(reqLabel)){
					    	reqLabel.setVisible(false);
					    	}
						if(!isNullOrEmpty(popiLabel)){
					    	popiLabel.setVisible(false);
					    	}
						if(!isNullOrEmpty(popiDescriptionLabel)){
					    	popiDescriptionLabel.setVisible(false);
					    	}
						/*if(!isNullOrEmpty(serial1Label)){
					    	serial1Label.setVisible(false);
					    	}*/
						if(!isNullOrEmpty(whetherAllowedPhotoForYearBookAndNewsletter)){
					    	whetherAllowedPhotoForYearBookAndNewsletter.setVisible(false);
					    	}
						/*if(!isNullOrEmpty(serial2Label)){
					    	serial2Label.setVisible(false);
					    	}*/
						if(!isNullOrEmpty(whetherAllowedPhotoForSocialMediaLabel)){
					    	whetherAllowedPhotoForSocialMediaLabel.setVisible(false);
					    	}
	
    				} else if(nv.radioButtonResponse == true){
    					if(!isNullOrEmpty(feePlanField)){
    						feePlanField.setVisible(false);
    						feePlanField.allowBlank=true;
    					}
    					if(!isNullOrEmpty(feePlanField1)){
    						feePlanField1.setVisible(false);
    					}
    					if(!isNullOrEmpty(paymentTermParentGrid)){
    						paymentTermParentGrid.setVisible(true);
    					}
    					if(!isNullOrEmpty(nextYearSibiling)){
    						nextYearSibiling.setVisible(true);
    					}
    					if(!isNullOrEmpty(currentYearBursary)){
    						currentYearBursary.setVisible(true);
    					}
    					if(!isNullOrEmpty(nextYearBursary)){
    						nextYearBursary.setVisible(true);
    					}
    					if(!isNullOrEmpty(submitButtonIdNoReas)){
    						submitButtonIdNoReas.setVisible(false);
    					}
    					if(!isNullOrEmpty(refAdjustment)){
    						refAdjustment.setVisible(false);
    					}
    					if(!isNullOrEmpty(regProcessNextButton)){
    						regProcessNextButton.setVisible(true);
    					}
//    					secondTab.setDisabled(false);
//    					thirdTab.setDisabled(false);
//    					fourthTab.setDisabled(false);
    					if(!isNullOrEmpty(nextYearSibilingLable)){
    						nextYearSibilingLable.setVisible(true);
    					}
    					if(!isNullOrEmpty(currentYearBursaryLable)){
    						currentYearBursaryLable.setVisible(true);
    					}
    					if(!isNullOrEmpty(nextYearBursaryLable)){
    						nextYearBursaryLable.setVisible(true);
    					}
    					if(!isNullOrEmpty(submitButtonTransferToOther)){
    						submitButtonTransferToOther.setVisible(false);
    					}
    					if(!isNullOrEmpty(isStudentChildOfAdvTech)){
    						isStudentChildOfAdvTech.setVisible(true);
    					}
    					if(!isNullOrEmpty(isStudentChildOfAdvTechRadio)){
    						isStudentChildOfAdvTechRadio.setVisible(true);
    					}
    					if(!isNullOrEmpty(aboveProvideFeedbackLabel)){
    						aboveProvideFeedbackLabel.setVisible(false);
    					}
	
						if(!isNullOrEmpty(reqLabel)){
					    	reqLabel.setVisible(true);
					    	}
						if(!isNullOrEmpty(popiLabel)){
					    	popiLabel.setVisible(true);
					    	}
						if(!isNullOrEmpty(popiDescriptionLabel)){
					    	popiDescriptionLabel.setVisible(true);
					    	}
						/*if(!isNullOrEmpty(serial1Label)){
					    	serial1Label.setVisible(true);
					    	}*/
						if(!isNullOrEmpty(whetherAllowedPhotoForYearBookAndNewsletter)){
					    	whetherAllowedPhotoForYearBookAndNewsletter.setVisible(true);
					    	}
						/*if(!isNullOrEmpty(serial2Label)){
					    	serial2Label.setVisible(true);
					    	}*/
						if(!isNullOrEmpty(whetherAllowedPhotoForSocialMediaLabel)){
					    	whetherAllowedPhotoForSocialMediaLabel.setVisible(true);
					    	}
    				}else if(nv.radioButtonResponse == 'transferToAnother'){
    					if(!isNullOrEmpty(feePlanField1)){
    						feePlanField1.setVisible(true);
    					}
    					if(!isNullOrEmpty(feePlanField)){
    						feePlanField.setVisible(false);
    						feePlanField.allowBlank=false;
    					}
    					if(!isNullOrEmpty(refAdjustment)){
    						refAdjustment.setVisible(false);
    					}
    					if(!isNullOrEmpty(submitButtonIdNoReas)){
    						submitButtonIdNoReas.setVisible(false);
    					}
    					if(!isNullOrEmpty(submitButtonTransferToOther)){
    						submitButtonTransferToOther.setVisible(true);
    					}
    					if(!isNullOrEmpty(paymentTermParentGrid)){
    						paymentTermParentGrid.setVisible(false);
    					}
    					if(!isNullOrEmpty(nextYearSibiling)){
    						nextYearSibiling.setVisible(false);
    					}
    					if(!isNullOrEmpty(currentYearBursary)){
    						currentYearBursary.setVisible(false);
    					}
    					if(!isNullOrEmpty(nextYearBursary)){
    						nextYearBursary.setVisible(false);
    					}
    					if(!isNullOrEmpty(submitButtonIdNoReas)){
    						submitButtonIdNoReas.setVisible(false);
    					}
    					if(!isNullOrEmpty(regProcessNextButton)){
    						regProcessNextButton.setVisible(false);
    					}
    					if(!isNullOrEmpty(secondTab)){
    						secondTab.setDisabled(true);
    					}
    					if(!isNullOrEmpty(thirdTab)){
    						thirdTab.setDisabled(true);
    					}
    					if(!isNullOrEmpty(fourthTab)){
    						fourthTab.setDisabled(true);
    					}
    					if(!isNullOrEmpty(nextYearSibilingLable)){
    						nextYearSibilingLable.setVisible(false);
    					}
    					if(!isNullOrEmpty(currentYearBursaryLable)){
    						currentYearBursaryLable.setVisible(false);
    					}
    					if(!isNullOrEmpty(nextYearBursaryLable)){
    						nextYearBursaryLable.setVisible(false);
    					}
    					if(!isNullOrEmpty(isStudentChildOfAdvTech)){
    						isStudentChildOfAdvTech.setVisible(false);
    					}
    					if(!isNullOrEmpty(isStudentChildOfAdvTechRadio)){
    						isStudentChildOfAdvTechRadio.setVisible(false);
    					}
    					if(!isNullOrEmpty(aboveProvideFeedbackLabel)){
    						aboveProvideFeedbackLabel.setVisible(false);
    					}
	
						if(!isNullOrEmpty(reqLabel)){
					    	reqLabel.setVisible(false);
					    	}
						if(!isNullOrEmpty(popiLabel)){
					    	popiLabel.setVisible(false);
					    	}
						if(!isNullOrEmpty(popiDescriptionLabel)){
					    	popiDescriptionLabel.setVisible(false);
					    	}
						/*if(!isNullOrEmpty(serial1Label)){
					    	serial1Label.setVisible(false);
					    	}*/
						if(!isNullOrEmpty(whetherAllowedPhotoForYearBookAndNewsletter)){
					    	whetherAllowedPhotoForYearBookAndNewsletter.setVisible(false);
					    	}
						/*if(!isNullOrEmpty(serial2Label)){
					    	serial2Label.setVisible(false);
					    	}*/
						if(!isNullOrEmpty(whetherAllowedPhotoForSocialMediaLabel)){
					    	whetherAllowedPhotoForSocialMediaLabel.setVisible(false);
					    	}
    				}
    				var debitOrderDate = form.down('#debitOrderDateItemId');
    				var providFeedback = form.down('#providFeedbackItemId');
    				var submitBtn = submitButtonTransferToOther.down('#submitButtonTransferToOtherADVId');
    				var submitBtnNo = form.down('#submitButtonIdNoReasonId')
    				
    				if(debitOrderDate.getValue() ){
    					submitBtn.enable(true)
    				}
    				
    				else{
    					submitBtn.disable(true)
    				}
    				if(providFeedback.getValue()){
    					submitBtnNo.enable(true)
    				}
    				else{
    					submitBtnNo.disable(true)
    				}
    				
    				/*var valid = form.isValid();
    		    	if(!valid) {
    		    		form.down('#SubmitBtn').setDisabled(true);
    		    	}*/
    			} 
    		 },
    //--------------------------
    		 'studentregistrationtabstructure combo[itemId=providFeedbackItemId]': {
                 change: function(combo, records, eOpts) {
                	 var stuRegistrationStruc = this.getStudentregistrationtabstructure();
                   // 	 stuRegistrationStruc = combo.up('panel[xtype=addscholarship]');

                     var refAdjustment = stuRegistrationStruc.down("#reasonForNoSelectionItemId");
                     if (combo.rawValue == 'Other') {
                         refAdjustment.setVisible(true);
                     } else {
                         refAdjustment.setVisible(false);
                     }
                     stuRegistrationStruc.down('#submitButtonIdNoReasonId').enable(true);
                	 
                 }
             },
             'studentregistrationtabstructure combo[itemId=debitOrderDateItemId]' :{
            	 change: function(combo){
            		 var stuRegistrationStruc = this.getStudentregistrationtabstructure();
            		 stuRegistrationStruc.down('#submitButtonTransferToOtherADVId').enable(true);
            		 if(combo.up('form')){
            			 var form = combo.up('form').getForm();
                		 form.checkValidity();
            		 }
            	 }
             },
             'studentregistrationtabstructure combo[itemId=accountTypeItemId]' :{
            	 change: function(combo){
            		 var form = combo.up('form').getForm();
            		 form.checkValidity();
            	 }
             },
             'studentregistrationtabstructure textfield[itemId=accountNumberItemId]' :{
            	 change: function(field){
            		 var form = field.up('form').getForm();
            		 form.checkValidity();
            	 }
             },
             'studentregistrationtabstructure textfield[itemId=accountNameItemId]' :{
            	 change: function(field){
            		 var form = field.up('form').getForm();
            		 form.checkValidity();
            	 }
             },
             
     //----------------------        
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] customcombobox[itemId=bankItemId]': {
            	render: function(combo) {
            		combo.getStore().load();
            	},
             select: function(combo, record) { 
            	 var branchCodeField = combo.up('form').down('customcombobox#branchCodeItemId');
            	 var branchCodeStore = branchCodeField.getStore();
	             var selectedBankId=record[0].data.id;             	
	             branchCodeStore.getProxy().extraParams = {
		            bankId: selectedBankId
	             };    	            
	             
	             branchCodeStore.load({
 					  callback: function(records, operation, success) {
 						  if (success) {
 							if(records.length == 1){
 								branchCodeField.setValue(records[0].data.id);
 							}
 						  }
            	}
 				  });
             }, 
             change: function(combo, newValue) {
             	var branchCodeField = combo.up('form').down('customcombobox#branchCodeItemId');
             	if(!isNullOrEmpty(newValue)){
             		branchCodeField.setDisabled(false);	
             	}else{
             		branchCodeField.setDisabled(true);
             	}      	
             }
             }, 
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] radiogroup[itemId=payerTypeItemId]': {
                change: function(cb, nv, ov) {
                	var $this = this;
                	var form = cb.up('feepayerdetailform');

                	var salutationItemId = form.down("#salutationItemId");
                	var firstNameItemId = form.down("#firstNameItemId");
                	var middleNameItemId = form.down("#middleNameItemId");
                	var lastNameItemId = form.down("#lastNameItemId");
                	var companyNameItemId = form.down("#companyNameItemId");
                	var contactPersonItemId = form.down("#contactPersonItemId");
                	var doesFeePayerConsentToCreditCheckLabelItemId = form.down("#doesFeePayerConsentToCreditCheckLabelItemId");
                	var doesFeePayerConsentToCreditCheckItemId = form.down("#doesFeePayerConsentToCreditCheckItemId");
                	var homeTelephoneCountryCodeItemId = form.down("#homeTelephoneCountryCodeItemId");
                	var homeTelephoneItemId = form.down("#homeTelephoneItemId");
                	var workTelephoneCountryCodeItemId = form.down("#workTelephoneCountryCodeItemId");
                	var workTelephoneItemId = form.down("#workTelephoneItemId");
                	var countryCodeItemId = form.down("#countryCodeItemId");
                	var mobileNumberItemId = form.down("#mobileNumberItemId");

                	var emailHomeItemId = form.down("#emailHomeItemId");
                	var emailWorkItemId = form.down("#emailWorkItemId");
                	var emailHomeUseForCommunicationItemId = form.down("#emailHomeUseForCommunicationItemId");
                	var emailWorkUseForCommunicationItemId = form.down("#emailWorkUseForCommunicationItemId");
                	var feePayerIDItemId = form.down("#feePayerIDItemId");
                	var feePayerProofOfAccountItemId = form.down("#feePayerProofOfAccountItemId");
                	var feePayerLatestPayslipItemId = form.down("#feePayerLatestPayslipItemId");
                	var companySponsorLetterItemId = form.down("#companySponsorLetterItemId");
                	var companySponsorLetterURL = form.down("#companySponsorLetterURL");
                	var nationalAlternateIdItemId = form.down("#nationalAlternateIdItemId");
                	var companyAddressContainerItemId = form.down("#companyAddressContainerItemId");
                	var empOfTheOrgContainerItemId = form.down("#empOfTheOrgContainerItemId");
                	var surnameItemId = form.down("#surnameItemId");
                	
                	var employeeIdItemId = form.down("#employeeIdItemId");
                	var nationalAlternateIdItemId = form.down("#nationalAlternateIdItemId");
                	var nationalAlternateIdContainer = form.down("#nationalAlternateIdContainer");
                	var homeTelephoneContainerItemId = form.down("#homeTelephoneContainerItemId");
                	
                	var emailHomeContainerItemId = form.down("#emailHomeContainerItemId");
                	var corporateItemId= form.down('#corporateId');
                	var occupationItemId = form.down("#occupationItemId");
                	var employerCompanyNameItemId = form.down("#employerCompanyNameItemId");
                	var employerEmailItemId = form.down("#employerEmailItemId");
                	var companyNameOtherLangItemId = form.down("#companyNameOtherLangItemId");
                	var contactPersonOtherLangItemId = form.down("#contactPersonOtherLangItemId");
                	var surnameOtherLangItemId = form.down("#surnameOtherLangItemId");
                	var firstNameOtherLangItemId = form.down("#firstNameOtherLangItemId");
                	var middleNameOtherLangItemId = form.down("#middleNameOtherLangItemId");
                	var lastNameOtherLangItemId = form.down("#lastNameOtherLangItemId");
                	var sponsorItemId = form.down('#sponsorItemId')
                	occupationItemId.setVisible(false);
                	employerCompanyNameItemId.setVisible(false); 
                	employerEmailItemId.setVisible(false); 
                	
                	if (nv.payerType == 'PERSON') {
                	    salutationItemId.setVisible(true);
                	    firstNameItemId.setVisible(true);
                	    middleNameItemId.setVisible(true);
                	    lastNameItemId.setVisible(true);
                	    companyNameItemId.setVisible(false);
                	    contactPersonItemId.setVisible(false);
                	    corporateItemId.setVisible(false);
                	   // doesFeePayerConsentToCreditCheckLabelItemId.setVisible(true);
                	   // doesFeePayerConsentToCreditCheckItemId.setVisible(true);
                	    
                	    //homeTelephoneCountryCodeItemId.setVisible(true);
                	    //homeTelephoneItemId.setVisible(true);
                	    homeTelephoneContainerItemId.setVisible(true);
                	    //countryCodeItemId.setVisible(true);
                	    //mobileNumberItemId.setVisible(true);
                	   
                	    // emailHomeItemId.setVisible(true);
                	   // emailHomeUseForCommunicationItemId.setVisible(true);
                	    
                	    emailHomeContainerItemId.setVisible(true);
                	    
                	    //emailWorkUseForCommunicationItemId.setVisible(true);
                	    feePayerIDItemId.setVisible(true);
                	    feePayerIDItemId.setDisabled(false);
                	    feePayerProofOfAccountItemId.setVisible(true);
                	    feePayerProofOfAccountItemId.setDisabled(false);
                	    feePayerLatestPayslipItemId.setVisible(true);
                	    feePayerLatestPayslipItemId.setDisabled(false);
                	    companySponsorLetterItemId.setVisible(false);
                    	companySponsorLetterItemId.allowBlank=true;	
                    	companySponsorLetterURL.setVisible(false);
                	    //emailWorkUseForCommunicationItemId.setFieldStyle('background-color: red;');
                	    
                	    empOfTheOrgContainerItemId.setVisible(true);
                	    surnameItemId.setVisible(false);
                	    //nationalAlternateIdItemId.setVisible(true);
                	    nationalAlternateIdContainer.setVisible(true);
                	    companyAddressContainerItemId.setVisible(false);

                	    this.setAllowBlank(surnameItemId, true);
                	    this.setAllowBlank(corporateItemId, true);
                	    
                	  //  salutationItemId.allowBlank = false;
                	    sponsorItemId.setVisible(false);
                	    this.setAllowBlank(sponsorItemId, true);
                	    
                	  //  firstNameItemId.allowBlank = false;
                	    this.setAllowBlank(firstNameItemId, false);
                	    
                	  //  lastNameItemId.allowBlank = false;
                	    this.setAllowBlank(lastNameItemId, false);
                	    
                	  //  companyNameItemId.allowBlank = true;
                	    this.setAllowBlank(companyNameItemId, true);
                	    
                	    //  contactPersonItemId.allowBlank = true;
                	    this.setAllowBlank(contactPersonItemId, true);
                	    
                	  //  doesFeePayerConsentToCreditCheckItemId.allowBlank = false;
                	    this.setAllowBlank(doesFeePayerConsentToCreditCheckItemId, false);
                	    
                	  //  feePayerIDItemId.allowBlank = false;
                	  //  this.setAllowBlank(feePayerIDItemId, false);
                	    this.setAllowBlank(feePayerIDItemId, false);
                	 //   this.setAllowBlank(employeeIdItemId, false);
                	 //   this.setAllowBlank(nationalAlternateIdItemId, false);
                	    
//                	    feePayerLatestPayslipItemId.allowBlank = false;

                	  //  homeTelephoneCountryCodeItemId.allowBlank = false;
                	  //  homeTelephoneItemId.allowBlank = false;
                	  //  countryCodeItemId.allowBlank = false;
                	  //  mobileNumberItemId.allowBlank = false;
                	  //  emailHomeItemId.allowBlank = false;
                	    this.setAllowBlank(emailHomeItemId, false);
                	    
                	  //  workTelephoneCountryCodeItemId.allowBlank = true;
                	  //  workTelephoneItemId.allowBlank = true;
                	  //  emailWorkItemId.allowBlank = true;
                	    this.setAllowBlank(emailWorkItemId, true);
                	    
                	    companyNameOtherLangItemId.allowBlank=true;	
                    	contactPersonOtherLangItemId.allowBlank=true;	
                    	surnameOtherLangItemId.allowBlank=true;	
                    	companyNameOtherLangItemId.setVisible(false);
                    	contactPersonOtherLangItemId.setVisible(false);	
                    	surnameOtherLangItemId.setVisible(false);	
                    	companyNameOtherLangItemId.reset();
                    	contactPersonOtherLangItemId.reset();
                    	surnameOtherLangItemId.reset();

                	    salutationItemId.reset();
                	    firstNameItemId.reset();
                	    middleNameItemId.reset();
                	    lastNameItemId.reset();
                	    companyNameItemId.reset();
                	    contactPersonItemId.reset();
                	    doesFeePayerConsentToCreditCheckItemId.reset();
                	    homeTelephoneCountryCodeItemId.reset();
                	    homeTelephoneItemId.reset();
                	    countryCodeItemId.reset();
                	    mobileNumberItemId.reset();
                	    emailHomeItemId.reset();
                	    emailHomeUseForCommunicationItemId.reset();
                	    emailWorkUseForCommunicationItemId.reset();
                	    workTelephoneCountryCodeItemId.reset();
                	    workTelephoneItemId.reset();
                	    feePayerIDItemId.reset();
                	    feePayerProofOfAccountItemId.reset();
                	    feePayerLatestPayslipItemId.reset();
                	    //corporateItemId.reset();
                	    
                        Ext.Ajax.request({
                  		  type: 'rest',
                  		  url: SERVERURL.DEFAULT_COUNTRY_CODE_BY_ACADEMY_LOCATION,
                  		  method: 'GET',
                  		  success: function(response, action) {
                  			  var MSSG = response.responseText;
                  			  var jdata = Ext.decode(response.responseText);
                  			  var defaultCountryId = -1;
                  			  if(!isNullOrEmpty(jdata.id)){
                  				  defaultCountryId = jdata.id; 
                  			  }
          					 var homeTelephoneCountryCode=form.down('#homeTelephoneCountryCodeItemId');
          					 if(isNullOrEmpty(homeTelephoneCountryCode.getValue())){
          					 homeTelephoneCountryCode.getStore().load({
              					  callback: function(records, operation, success) {
              						  if (success) {
              							  for(i in records){
              								  if(defaultCountryId == -1){
              									  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
              										  homeTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
                  								  } 
              								  }else{
              									  if(records[i].data.id == defaultCountryId){
              										  homeTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
                  								  }
              								  }
              							  }
              						  }
              					  }
              				  });
                  		  }
          					 
          					 var workTelephoneCountryCode=form.down('#workTelephoneCountryCodeItemId');
          					 if(isNullOrEmpty(workTelephoneCountryCode.getValue())){
          					 workTelephoneCountryCode.getStore().load({
              					  callback: function(records, operation, success) {
              						  if (success) {
              							  for(i in records){
              								  if(defaultCountryId == -1){
              									  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
              										  workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
                  								  } 
              								  }else{
              									  if(records[i].data.id == defaultCountryId){
              										  workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
                  								  }
              								  }
              							  }
              						  }
              					  }
              				  });
                  		  }
          					 
          					 var countryCode=form.down('#countryCodeItemId');
          					 if(isNullOrEmpty(countryCode.getValue())){
          					 countryCode.getStore().load({
              					  callback: function(records, operation, success) {
              						  if (success) {
              							  for(i in records){
              								  if(defaultCountryId == -1){
              									  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
              										  countryCode.setValue(records[i].data.isdCode);  									  
                  								  } 
              								  }else{
              									  if(records[i].data.id == defaultCountryId){
              										  countryCode.setValue(records[i].data.isdCode);  									  
                  								  }
              								  }
              							  }
              						  }
              					  }
              				  });
                  		   }
                  		  }
      				  });
                        
                        
                        var academyLocationId = this.getCurrentAcademyLocation();
                    	
                      
                        var newMandatoryFields = ['employeeIdItemId','nationalAlternateIdItemId'];
                    	
                        Ext.Ajax.request({
	                		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	                		method: 'GET',
	                		async: false,
	                		params: {
	                			screenName: 'feepayerdetailform',
	                			academyLocationId:academyLocationId,
	                			languageCode:'en'
	                		},
	                		success: function(response) {
	                			var json = JSON.parse(response.responseText);
	                			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
	                			fieldInfo.set("formFieldsInfo", json);
	                			//console.log(json);
	                			if( !isNullOrEmpty(json) ){
	                				if( !isNullOrEmpty(json.feepayerdetailform) ){
	                					var feePayerDetailDFRConfig = json.feepayerdetailform;
	                					for( i in feePayerDetailDFRConfig){
	                						var fieldConfig = feePayerDetailDFRConfig[i];
	                						//console.log(fieldConfig);
	                						if( newMandatoryFields.includes(fieldConfig.formFieldId) ){
	                							if( fieldConfig.isMandatory ){
	                								var currentField = form.down("#"+fieldConfig.formFieldId);
	                								$this.setAllowBlank(currentField, false);
	                								var currentFieldLabel = fieldConfig.formFieldLabel;
	                								currentField.setFieldLabel(currentFieldLabel);
	                							}
	                						}
	                						if (nv.payerType == 'PERSON') {
	                							if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='occupationItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                						}
		                						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='employerCompanyNameItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                						}
		                						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='employerEmailItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                						}
		                						if(fieldConfig.formFieldInputType=='filefield' && fieldConfig.formFieldId=='companySponsorLetterItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(false);
		                						}
		                						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='firstNameOtherLangItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                							if(fieldConfig.isMandatory==true) {
		                								currentField.allowBlank=false;
		                							} 
		                						}
		                						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='middleNameOtherLangItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                							if(fieldConfig.isMandatory==true) {
		                								currentField.allowBlank=false;
		                							}
		                						}
		                						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='lastNameOtherLangItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                							if(fieldConfig.isMandatory==true) {
		                								currentField.allowBlank=false;
		                							}
		                						}
		                						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='firstNameOtherLangItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                							if(fieldConfig.isMandatory==true) {
		                								currentField.allowBlank=false;
		                							}
		                						}
		                						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='middleNameOtherLangItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                							if(fieldConfig.isMandatory==true) {
		                								currentField.allowBlank=false;
		                							}
		                						}
		                						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='lastNameOtherLangItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                							if(fieldConfig.isMandatory==true) {
		                								currentField.allowBlank=false;
		                							}
		                						}
											}
	                						$this.removeDoubleColon(form.down("#"+fieldConfig.formFieldId),fieldConfig.formFieldLabel);
	                					}
	                				}else{
	                					if (nv.payerType == 'PERSON') {
	                						occupationItemId.setVisible(true);
		                                	employerCompanyNameItemId.setVisible(true); 
		                                	employerEmailItemId.setVisible(true); 
	                					}
	                				}
	                			}
	                		}
	                	});
                	    

                	    workTelephoneCountryCodeItemId.setFieldLabel(getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'));
                	    workTelephoneItemId.setFieldLabel(getPersonModuleTranslation('FPD_WORK_TELEPHONE'));
                	    emailWorkItemId.setFieldLabel(getPersonModuleTranslation('FPD_EMAIL_WORK'));
                	} else {
                	    salutationItemId.setVisible(false);
                	    firstNameItemId.setVisible(false);
                	    middleNameItemId.setVisible(false);
                	    lastNameItemId.setVisible(false);
                	    //companyNameItemId.setVisible(true);
                	    //contactPersonItemId.setVisible(true);
                	    occupationItemId.allowBlank = true;
                    	employerCompanyNameItemId.allowBlank = true;
                    	employerEmailItemId.allowBlank = true;
                    	
                    	firstNameOtherLangItemId.allowBlank=true;	
                    	middleNameOtherLangItemId.allowBlank=true;	
                    	lastNameOtherLangItemId.allowBlank=true;	
                    	firstNameOtherLangItemId.setVisible(false);
                    	middleNameOtherLangItemId.setVisible(false);	
                    	lastNameOtherLangItemId.setVisible(false);	
                    	firstNameOtherLangItemId.reset();
                    	middleNameOtherLangItemId.reset();
                    	lastNameOtherLangItemId.reset();
                    	
                	    /**for corporate id hide show**/
                	    var portalId = $this.getCurrentLoggedPortalId();
                   		if(portalId == 7)
                   		{
                   			$this.disableFeePayerCorporateId(corporateItemId, $this.getPARENT_FEE_PAYER_DETAILS_PERMISSIONS());	
                   		}else if(portalId == 3){
                   			$this.disableFeePayerCorporateId(corporateItemId, $this.getSTUDENT_PORTAL_STUDENT_FEE_PAYER_DETAILS_PERMISSIONS());	
                   		}else{
                   			$this.disableFeePayerCorporateId(corporateItemId, $this.getSTUDENT_FEE_PAYER_DETAILS_PERMISSIONS());
                   		}
                   		
                   	 var academyLocationId = this.getCurrentAcademyLocation();
                   	 var newMandatoryFields = ['corporateId'];
                     Ext.Ajax.request({
                 		url: SERVERURL.COMMON_FORM_FIELD_INFO,
                 		method: 'GET',
                 		async: false,
                 		params: {
                 			screenName: 'feepayerdetailform',
                 			academyLocationId:academyLocationId,
                 			languageCode:'en'
                 		},
                 		success: function(response) {
                 			var json = JSON.parse(response.responseText);
                 			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
                 			fieldInfo.set("formFieldsInfo", json);
                 			if( !isNullOrEmpty(json) ){
                 				if( !isNullOrEmpty(json.feepayerdetailform) ){
                 					var feePayerDetailFormDFRConfig = json.feepayerdetailform;
                 					for( i in feePayerDetailFormDFRConfig){
                 						var fieldConfig = feePayerDetailFormDFRConfig[i];
                 						if( newMandatoryFields.includes(fieldConfig.formFieldId) ){
                 							if(!fieldConfig.isVisible){
                 								var currentField = form.down("#"+fieldConfig.formFieldId);
                 								currentField.setVisible(false);
                 							}else if(fieldConfig.isVisible && fieldConfig.isMandatory){
                 								var currentField = form.down("#"+fieldConfig.formFieldId);
                 								 var editBtnNotMandField = ['firstNameItemId','salutationItemId','lastNameItemId','homeTelephoneCountryCodeItemId',
             		    			                'homeTelephoneItemId','emailHomeItemId'];
             								  if(!editBtnNotMandField.includes(fieldConfig.formFieldId)){
             									  $this.setAllowBlank(currentField, false);
             								  }
                 							}
                 						}
                 						if (nv.payerType == 'CORPORATE') {
                							if(fieldConfig.formFieldInputType=='filefield' && fieldConfig.formFieldId=='companySponsorLetterItemId' && fieldConfig.isVisible==true){
	                							var currentField = form.down("#"+fieldConfig.formFieldId);
	                							currentField.setVisible(true);
	                						}
                							if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='companyNameOtherLangItemId' && fieldConfig.isVisible==true){
                								var companyNameOtherLang=form.down('#companyNameOtherLangItemId');
                								companyNameOtherLang.setVisible(true);
                								if(fieldConfig.isMandatory==true) {
                									companyNameOtherLang.allowBlank=false;
	                							}
                							}

                							if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='contactPersonOtherLangItemId' && fieldConfig.isVisible==true){
                								var contactPersonOtherLang=form.down('#contactPersonOtherLangItemId');
                								contactPersonOtherLang.setVisible(true);
                								if(fieldConfig.isMandatory==true) {
                									contactPersonOtherLang.allowBlank=false;
	                							}
                							}

                							if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='surnameOtherLangItemId' && fieldConfig.isVisible==true){
                								var surnameOtherLang=form.down('#surnameOtherLangItemId');
                								surnameOtherLang.setVisible(true);
                								if(fieldConfig.isMandatory==true) {
                									surnameOtherLang.allowBlank=false;
	                							}
                							}
                							
                							if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='companyNameItemId' && fieldConfig.isVisible==true){
                								var companyNameItemId=form.down('#companyNameItemId');
                								companyNameItemId.setVisible(true);
                								if(fieldConfig.isMandatory==true) {
                									companyNameItemId.allowBlank=false;
	                							}
                							}

                							if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='contactPersonItemId' && fieldConfig.isVisible==true){
                								var contactPersonItemId=form.down('#contactPersonItemId');
                								contactPersonItemId.setVisible(true);
                								if(fieldConfig.isMandatory==true) {
                									contactPersonItemId.allowBlank=false;
	                							}
                							}

                							if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='surnameItemId' && fieldConfig.isVisible==true){
                								var surnameItemId=form.down('#surnameItemId');
                								surnameItemId.setVisible(true);
                								if(fieldConfig.isMandatory==true) {
                									surnameItemId.allowBlank=false;
	                							} 
                							}
                							if(fieldConfig.formFieldInputType=='customcombobox' && fieldConfig.formFieldId=='sponsorItemId' && fieldConfig.isVisible==true){
                								var sponsorItemId=form.down('#sponsorItemId');
                								sponsorItemId.setVisible(true);
                								if(fieldConfig.isMandatory==true) {
                									sponsorItemId.allowBlank=false;
	                							} 
                							}
										}
                 					}
                 				}
                 			}
                 		}
                 	});                  		
                   		
                	    //this.setAllowBlank(homeTelephoneCountryCodeItemId, true);
                	    this.setAllowBlank(employeeIdItemId, true);
                	    this.setAllowBlank(salutationItemId, true);
                	    this.setAllowBlank(middleNameItemId, true);
                  	    this.setAllowBlank(firstNameItemId, true);
                  	    this.setAllowBlank(lastNameItemId, true);
                  	    //this.setAllowBlank(companyNameItemId, true);
                  	    //this.setAllowBlank(contactPersonItemId, true);
                  	    this.setAllowBlank(doesFeePayerConsentToCreditCheckItemId, true);
                  	    this.setAllowBlank(feePayerIDItemId, true);
                  	    this.setAllowBlank(feePayerProofOfAccountItemId, true);
                  	    this.setAllowBlank(emailHomeItemId, true);
                  	    this.setAllowBlank(emailHomeItemId, true);
                  	    //this.setAllowBlank(homeTelephoneItemId, true);
                  
                	     
                	    homeTelephoneContainerItemId.setVisible(false);
                	    homeTelephoneCountryCodeItemId.allowBlank=true;
                	    homeTelephoneItemId.allowBlank=true;
                	    
                	    /*emailHomeItemId.setVisible(false);
                	    emailHomeUseForCommunicationItemId.setVisible(false);*/
                	    
                	    emailHomeContainerItemId.setVisible(false);
                	    
                	    feePayerIDItemId.setVisible(false);
                	    feePayerLatestPayslipItemId.setVisible(false);
                	    //companySponsorLetterItemId.setVisible(true);
                    	companySponsorLetterItemId.allowBlank=true;
                	    empOfTheOrgContainerItemId.setVisible(false);
                	    //surnameItemId.setVisible(true);
                	    //nationalAlternateIdItemId.setVisible(false);
                	    nationalAlternateIdContainer.setVisible(false);
                	    companyAddressContainerItemId.setVisible(true);
                	    
                	    emailWorkUseForCommunicationItemId.setFieldStyle('left: 0px;');

                	//    this.setAllowBlank(surnameItemId, true);
                	    
                	  //  salutationItemId.allowBlank = true;
                	    this.setAllowBlank(salutationItemId, true);
                	    
                	  //  firstNameItemId.allowBlank = true;
                	    this.setAllowBlank(firstNameItemId, true);
                	    
                	 //   lastNameItemId.allowBlank = true;
                	    this.setAllowBlank(lastNameItemId, true);
                	    
                	 //   companyNameItemId.allowBlank = false;
                	    //this.setAllowBlank(companyNameItemId, false);
                	    //companyNameItemId.labelEl.dom.innerHTML = getPersonModuleTranslation('FPD_NAME_OF_COMPANY')+':<span class="required" style="color:red"> *</span>';
                	    
                	    //  contactPersonItemId.allowBlank = true;
                	    //this.setAllowBlank(contactPersonItemId, false);
                	    //contactPersonItemId.labelEl.dom.innerHTML = getPersonModuleTranslation('FPD_NAME_OF_CONTACT_PERSON')+':<span class="required" style="color:red"> *</span>';
                	    
                	 //   doesFeePayerConsentToCreditCheckItemId.allowBlank = true;
                	    this.setAllowBlank(doesFeePayerConsentToCreditCheckItemId, true);
                	    
                	    this.setAllowBlank(feePayerProofOfAccountItemId, true);
                	    
                	 //   feePayerLatestPayslipItemId.allowBlank = true;
                	    this.setAllowBlank(feePayerLatestPayslipItemId, true);
                	    
                	    this.setAllowBlank(employeeIdItemId, true);
                	    this.setAllowBlank(nationalAlternateIdItemId, true);

                	  //  homeTelephoneCountryCodeItemId.allowBlank = true;
                	  //  homeTelephoneItemId.allowBlank = true;
                	  //  countryCodeItemId.allowBlank = true;
                	  //  mobileNumberItemId.allowBlank = true;
                	    
                	//    emailHomeItemId.allowBlank = true;
                	    this.setAllowBlank(emailHomeItemId, true);
                	  
                	    //$this.setAllowBlank(workTelephoneCountryCodeItemId,false);
                	    //workTelephoneCountryCodeItemId.allowBlank = false;
                	    //$this.setAllowBlank(workTelephoneItemId,false);
                	    //workTelephoneItemId.allowBlank = false;
                	 //   $this.setAllowBlank(companyNameItemId,false);
                	    //companyNameItemId.allowBlank = false;
                	    //$this.setAllowBlank(emailWorkItemId,false);
                	    
                	    //emailWorkItemId.allowBlank = false;
                	    this.setAllowBlank(emailWorkItemId, false);
                	    
                	   // corporateItemId.reset();
                	    salutationItemId.reset();
                	    firstNameItemId.reset();
                	    middleNameItemId.reset();
                	    lastNameItemId.reset();
                	    companyNameItemId.reset();
                	    contactPersonItemId.reset();
                	    doesFeePayerConsentToCreditCheckItemId.reset();
                	    homeTelephoneCountryCodeItemId.reset();
                	    homeTelephoneItemId.reset();
                	    //countryCodeItemId.reset();
                	    mobileNumberItemId.reset();
                	    emailHomeItemId.reset();
                	    emailHomeUseForCommunicationItemId.reset();
                	    emailWorkUseForCommunicationItemId.reset();
                	    workTelephoneCountryCodeItemId.reset();
                	    workTelephoneItemId.reset();
                	    feePayerIDItemId.reset();
                	    feePayerProofOfAccountItemId.reset();
                	    feePayerLatestPayslipItemId.reset();
                	    
                	    Ext.Ajax.request({
                	    	  type: 'rest',
                	    	  url: SERVERURL.DEFAULT_COUNTRY_CODE_BY_ACADEMY_LOCATION,
                	    	  method: 'GET',
                	    	  success: function(response, action) {
                	    		  var MSSG = response.responseText;
                	    		  var jdata = Ext.decode(response.responseText);
                	    		  var defaultCountryId = -1;
                	    		  if(!isNullOrEmpty(jdata.id)){
                	    			  defaultCountryId = jdata.id; 
                	    		  }
                	    		   
                	    		 var workTelephoneCountryCode=form.down('#workTelephoneCountryCodeItemId');
                	    		 if(isNullOrEmpty(workTelephoneCountryCode.getValue())){
                	    		 workTelephoneCountryCode.getStore().load({
                	    			  callback: function(records, operation, success) {
                	    				  if (success) {
                	    					  for(i in records){
                	    						  if(defaultCountryId == -1){
                	    							  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
                	    								  workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
                	    							  } 
                	    						  }else{
                	    							  if(records[i].data.id == defaultCountryId){
                	    								  workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
                	    							  }
                	    						  }
                	    					  }
                	    				  }
                	    			  }
                	    		  });
                	    	  }
                	    	 }
                	    });

                	    workTelephoneCountryCodeItemId.setFieldLabel(getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'));
                	    workTelephoneItemId.setFieldLabel(getPersonModuleTranslation('FPD_WORK_TELEPHONE'));
                	    emailWorkItemId.setFieldLabel(getPersonModuleTranslation('FPD_EMAIL_WORK'));
                	}
                	var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
                	var mobileField = form.down("#homeTelephoneItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                	countryCodeField = form.down("#workTelephoneCountryCodeItemId");
                	mobileField = form.down("#workTelephoneItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                	countryCodeField = form.down("#countryCodeItemId");
                	mobileField = form.down("#mobileNumberItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] customcombobox[itemId=homeTelephoneCountryCodeItemId]': {
            	select: function(rowModel, record){
            		var form = this.getPersonFeePayerDetailForm();
            		var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
                	var mobileField = form.down("#homeTelephoneItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                }
            },
            'feepayerdetailsformparent customcombobox[itemId=homeTelephoneCountryCodeItemId]': {
            	select: function(rowModel, record){
            		var form = this.getFeepayerdetailsformparent();
            		var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
                	var mobileField = form.down("#homeTelephoneItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] numberfield[itemId=homeTelephoneItemId]': {
            	change: function(record){
            		var form = this.getPersonFeePayerDetailForm();
                	var mobileField = form.down("#homeTelephoneItemId");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'feepayerdetailsformparent numberfield[itemId=homeTelephoneItemId]': {
            	change: function(record){
            		var form = this.getFeepayerdetailsformparent();
                	var mobileField = form.down("#homeTelephoneItemId");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] customcombobox[itemId=workTelephoneCountryCodeItemId]': {
            	select: function(rowModel, record){
            		var form = this.getPersonFeePayerDetailForm();
                	var countryCodeField = form.down("#workTelephoneCountryCodeItemId");
                	var mobileField = form.down("#workTelephoneItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                }
            },
            'feepayerdetailsformparent customcombobox[itemId=workTelephoneCountryCodeItemId]': {
            	select: function(rowModel, record){
            		var form = this.getFeepayerdetailsformparent();
                	var countryCodeField = form.down("#workTelephoneCountryCodeItemId");
                	var mobileField = form.down("#workTelephoneItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
                }
            },

            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] numberfield[itemId=workTelephoneItemId]': {
            	change: function(record){
            		var form = this.getPersonFeePayerDetailForm();
                	var mobileField = form.down("#workTelephoneItemId");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            
            'feepayerdetailsformparent numberfield[itemId=workTelephoneItemId]': {
            	change: function(record){
            		var form = this.getFeepayerdetailsformparent();
                	var mobileField = form.down("#workTelephoneItemId");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] customcombobox[itemId=countryCodeItemId]': {
            	select: function(rowModel, record){
            		var form = this.getPersonFeePayerDetailForm();
                	var countryCodeField = form.down("#countryCodeItemId");
                	var mobileField = form.down("#mobileNumberItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);                
                }
            },
            'feepayerdetailsformparent customcombobox[itemId=countryCodeItemId]': {
            	select: function(rowModel, record){
            		var form = this.getFeepayerdetailsformparent();
                	var countryCodeField = form.down("#countryCodeItemId");
                	var mobileField = form.down("#mobileNumberItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);                
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] numberfield[itemId=mobileNumberItemId]': {
            	change: function(record){
            		var form = this.getPersonFeePayerDetailForm();
                	var mobileField = form.down("#mobileNumberItemId");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'feepayerdetailsformparent numberfield[itemId=mobileNumberItemId]': {
            	change: function(record){
            		var form = this.getFeepayerdetailsformparent();
                	var mobileField = form.down("#mobileNumberItemId");
                	mobileField.isValid();
        			form.getForm().checkValidity();
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] combo#countryId': {
                select: function(combo, record) {
                	var regionComboBox = combo.up('form').down('customcombobox#parentCountryRegionId');                	
                	var cityComboBox = combo.up('form').down('customcombobox#cityId');
                	regionComboBox.reset();	
                    cityComboBox.reset();
                	regionComboBox.setDisabled(false);	
                    cityComboBox.setDisabled(true);
                    this.onCountryChange(combo, record, this.getPersonFeePayerDetailForm());
                    combo.up('form').getForm().checkValidity();
                }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] customcombobox#parentCountryRegionId': {
            	 select: function(obj1, record) {
                     var cityComboBox = obj1.up('form').down('customcombobox#cityId');
                     var countryComboBox = obj1.up('form').down('customcombobox#countryId');
                     cityComboBox.setDisabled(false);
                     cityComboBox.reset();
                     
                     var countryRegionIdVal = record[0].get("id");
                     var countryIdVal = countryComboBox.getValue();
                     var cityStore = cityComboBox.getStore();
                     cityStore.getProxy().extraParams = {
                    	 countryId: countryIdVal,
                    	 countryRegionId: countryRegionIdVal
                     };
                     cityStore.reload();
                     obj1.up('form').getForm().checkValidity();
                 }
            },
            'feepayerdetailform[itemId=studentfeepayerdetailformItemId] checkboxfield#isSameAsCurrentAddress': {
         	   change: function(obj,newValue,oldValue) {
          		   var form = obj.up('form');          		  
          		   
          		   if(newValue || newValue == true){             			   
          			  this.getPersonCurrentAddressDetail(form,SERVERURL.PERSON_CURRENT_ADDRESS,true);          			  
          		   } 
          		   else{
          			  this.getPersonCurrentAddressDetail(form,SERVERURL.PERSON_CURRENT_ADDRESS,false);               			 
          		   }
                 }
         	
         },
            'studentconditionsforadmission': {
            	
            	 render: function(form){
                 	//var url = SERVERURL.FIND_BY_ID_STUDENT_OTHER_INFORMATION+'userId=';
                 	 this.getRenderStudentConditionDocumentList();
                 	//this.disableOtherInformaionFormPivileges(form,this.getSTUDENT_OTHER_INFORMATION_DETAILS_PERMISSIONS());
                 }
            },
            'studentconditionsforadmission[itemId=studentconditionsforadmissionItemId]': {
            	
           	 render: function(form){
                	//var url = SERVERURL.FIND_BY_ID_STUDENT_OTHER_INFORMATION+'userId=';
                	 this.getRenderStudentPortalConditionDocumentList();
                	//this.disableOtherInformaionFormPivileges(form,this.getSTUDENT_OTHER_INFORMATION_DETAILS_PERMISSIONS());
                }
           },
           'studentpersonhostelrequirementform[itemId=studentPersonHostelRequirementForm]': {
               afterrender: function(obj) {
               	
               	var this$ = this;
               	var personProfile = this$.getContentPanelActiveTab();
               	
               	try{
                	if((portalId == 3 || portalId == 7) && personProfile.xtype == "dashboardhomepage"){
                		var contentPanel = this$.getContentPanel();
                		var personProfile = contentPanel.items.items[1];
                	}
            	}
            	catch(e){
            		//
            	}
               	
               	var personId;
               	var applicationId;
               	try{
               		personId = personProfile.getPersonId();
               		applicationId = personProfile.applicationId;
               	}catch(e){
               		personId = this$.getContentPanel().items.items[0].getPersonId();
               		applicationId = this$.getContentPanel().items.items[0].applicationId;
               	}
               	
               	var params = {
               			personId : personId
               	};
               	var submitUrl = SERVERURL.PATH_GET_STUDENT_HOSTEL_PERSONAL_INFO_BY_PERSONID;
               	
               	// Hide Hostel Fields
               	var hostelFieldsContainer1 = obj.down('#hostelFieldsContainer1');
         		var hostelFieldsContainer2 = obj.down('#hostelFieldsContainer2');
         		var hostelFieldsContainer3 = obj.down('#hostelFieldsContainer3');
         		var hostelPreferencePanel = obj.down('#hostelPreferencePanel');
         		var tempAccommondationId = obj.down('#tempAccommondationId');
         		var tempAccommondationValue = null;
         		try {
         			tempAccommondationValue = tempAccommondationId.getValue().tempAccommondationType;
         		}
         		catch(e) {
         			tempAccommondationValue = false;
         		}
 		   		hostelFieldsContainer1.setVisible(false);
 		   		hostelFieldsContainer2.setVisible(false);
 		   		hostelFieldsContainer3.setVisible(false);
 		   		hostelPreferencePanel.setVisible(false);
 		   		// Hide Custom Fields
       			this$.showHideStudentHostelCustomFieldData(obj,false);
               	
               	this$.sendGetAjaxRequest(submitUrl, 'GET', params, function(option, success, response) {
                   	if(success){
                   		if(!isNullOrEmpty(response.responseText)){
                   			var data = Ext.decode(response.responseText);
                   			var personInfo = personProfile.personInfo;
                           	var applicationDataObject = personProfile.applicationDataObject;
                           	
                           	var formObj = obj.up('form');
                           	if(!isNullOrEmpty(data)){
                           		if(portalId == 3 || portalId ==7){
                           			var form = personProfile.down('studentpersonhostelrequirementform').getForm();
                           		}else{
                           			var form = formObj.getForm();
                           		}
                           		var jData=Ext.JSON.decode(response.responseText);
   	                			form.setValues(jData);
   	                			if(!isNullOrEmpty(jData.tempAccommondationType)) {
   	                				tempAccommondationId.setValue({tempAccommondationType: jData.tempAccommondationType});
   	                			}
   	                			else {
   	                				tempAccommondationId.setValue({tempAccommondationType: tempAccommondationValue});
   	                			}
   	                			this$.loadStudentCustomFieldData(form,jData);
	   	              		   
	   	              		   	// Show Hide Hostel Fields
   	                			if( !isNullOrEmpty(jData.whetherHostelApplicable) ){
	   	              		   		hostelFieldsContainer1.setVisible(jData.whetherHostelApplicable);
	   	              		   		hostelFieldsContainer2.setVisible(jData.whetherHostelApplicable);
	   	              		   		if(!isNullOrEmpty(jData.studentHostelDetails)) {
	   	              		   			this$.setStudentHostelDetails(obj,jData);
	   	              		   		}
	   	              		   	} else{
	   	              		   		hostelFieldsContainer1.setVisible(false);
	   	              		   		hostelFieldsContainer2.setVisible(false);
	   	              		   		hostelFieldsContainer3.setVisible(false);
	   	              		   	}
   	                			
   	                			// Show Hide Custom Fields
   	                			if( !isNullOrEmpty(jData.whetherHostelApplicable) ){
   	                				this$.showHideStudentHostelCustomFieldData(obj,jData.whetherHostelApplicable);
   	                			} else{
   	                				this$.showHideStudentHostelCustomFieldData(obj,false);
   	                			}
   	                			
                           	}
                        }
                   	}
                   });
               	   //this$.checkStudentHostelRequirementDfr(obj);
               	 obj.getForm().checkValidity();
            	setTimeout(function(){
            		this$.stdAfterHostelFormRender(obj);
            		},300)
               }
           },
           'studentpersonhostelrequirementform[itemId=studentPersonHostelRequirementForm] button[itemId=submitButtonId]': {
               click: function(obj) {
               	this.saveStudentHostelPersonalRequirmentDetails(obj);
               }
           },
           'studentpersonhostelrequirementform[itemId=studentPersonHostelRequirementForm] customcombobox[name=stdAcademyLocationCombo]':{
           	afterrender: function(obj){
        		var me = this;
        		var localtionFieldStore = obj.store;
        		
        		localtionFieldStore.on('beforeload', function(){
        			var profile = me.getContentPanelActiveTab();
        			localtionFieldStore.getProxy().extraParams = {
        				academyLocationId: me.getCurrentAcademyLocation()
        			};
        		});
        		
        		obj.listConfig.listeners.beforeshow = function(picker){
        			if(picker.up){
            			var locationField = picker.up('combobox');
            			picker.minWidth = locationField.getSize().width;
                		var localtionFieldStore = locationField.store;
            			var allLocationFields = Ext.ComponentQuery.query('[name=stdAcademyLocationCombo]');
            			var allLocationArray = [];
            			Ext.each(allLocationFields, function(currentLocationField){
            				var currentVal = currentLocationField.getValue();
            				if(!isNullOrEmpty(currentVal) && locationField.itemId != currentLocationField.itemId){
            					allLocationArray.push(currentVal);
            				}
            			});
        				localtionFieldStore.clearFilter();
        				if(allLocationArray.length){
        					localtionFieldStore.filterBy(function(record, id){
            					return !Ext.Array.contains(allLocationArray, record.get('id'));
            				});
        				}
        			}
        		}
        		
        		localtionFieldStore.on('load', function(){
        			var allLocationFields = Ext.ComponentQuery.query('[name=stdAcademyLocationCombo]');
        			var allLocationArray = [];
        			Ext.each(allLocationFields, function(currentLocationField){
        				var currentVal = currentLocationField.getValue();
        				if(!isNullOrEmpty(currentVal) && obj.itemId != currentLocationField.itemId){
        					allLocationArray.push(currentVal);
        				}
        			});
    				localtionFieldStore.clearFilter();
    				if(allLocationArray.length){
    					localtionFieldStore.filterBy(function(record, id){
        					return !Ext.Array.contains(allLocationArray, record.get('id'));
        				});
    				}
        		});
        		localtionFieldStore.load();
        	},
        	select: function(obj, value){
        		var this$ = this;
        		var locationId = value[0].data.id;
        		if(portalId == 3 || portalId == 7){
        			var firstPreference = obj.nextSibling();
        		}else{
        			var  hostelActiveTab = this$.getContentPanel().getActiveTab().down('personinfopanel').getActiveTab();
            		var locationFields = hostelActiveTab.down('#stdAcademyLocationCombo');
            		var firstPreference = locationFields.nextSibling();
        		}
        		firstPreference.getStore().getProxy().extraParams = {
        			locationId: locationId
        		};
        		firstPreference.getStore().load();
        		
        		if (!isNullOrEmpty(firstPreference)) {
        			var secondPreference = firstPreference.nextSibling();
        			secondPreference.getStore().getProxy().extraParams = {
            			locationId: locationId
            		};
        			secondPreference.getStore().load();
        		}
        		if (!isNullOrEmpty(secondPreference)) {
        			var thirdPreference = secondPreference.nextSibling();
        			thirdPreference.getStore().getProxy().extraParams = {
        				locationId: locationId
            		};
        			thirdPreference.getStore().load();
        		}

        	}
        } ,
        'studentpersonhostelrequirementform[itemId=studentPersonHostelRequirementForm] [name=studentHostelDetails1]':{
        	afterrender: function(obj){
        		var me = this;
        		if(portalId == 3 || portalId == 7){
        			var localtionFieldStore = obj.store;
        			var locationFields = obj;
        		}else{
        			var  hostelActiveTab = me.getContentPanel().getActiveTab().down('personinfopanel').getActiveTab();
            		var locationFields = hostelActiveTab.down('#studentHostelDetailsId1');
            		var localtionFieldStore = locationFields.store;
        		}
        		
        		localtionFieldStore.on('beforeload', function(){
        			if(Ext.ComponentQuery.query('[itemId='+obj.itemId+']').length>0){
        				var alId = Ext.ComponentQuery.query('[itemId='+obj.itemId+']')[0].up('fieldcontainer').down('[name=stdAcademyLocationCombo]').getValue();
            			localtionFieldStore.getProxy().extraParams = {
            				locationId: alId
            			};
        			}
        		});
        		
        		locationFields.listConfig.listeners.beforeshow = function(picker){
        			if(picker.up){
        				setTimeout(function(){
            			var currentField = picker.up('combobox');
            			picker.minWidth = currentField.getSize().width;
                		var currentFieldStore = currentField.store;
                		var sform = me.getStudentpersonhostelrequirementform();
            			
                		var combo1 = currentField;
            			var combo2 = combo1.nextSibling();
            			var combo3 = combo2.nextSibling();

            			var allLocationArray = [];
            			if(!isNullOrEmpty(combo2.getValue())){
            				allLocationArray.push(combo2.getValue());
            			}
            			if(!isNullOrEmpty(combo3.getValue())){
            				allLocationArray.push(combo3.getValue());
            			}
            			
            			currentFieldStore.clearFilter();
            			
        				if(allLocationArray.length){
        					currentFieldStore.filterBy(function(record, id){
            					return !Ext.Array.contains(allLocationArray, record.get('hostelId'));
            				});
        				}
        				},50);
        			}
        		}
        		
        		localtionFieldStore.on('load', function(){
        			setTimeout(function(){
        				if(portalId == 3 || portalId == 7){
        					var combo1 = Ext.ComponentQuery.query('[itemId='+obj.itemId+']')[0];
        				}else{
        					var  hostelActiveTab = me.getContentPanel().getActiveTab().down('personinfopanel').getActiveTab();
        					var locationFields = hostelActiveTab.down('#studentHostelDetailsId1');
        					var combo1 = locationFields;
        				}

        				var combo2 = combo1.nextSibling();
        				var combo3 = combo2.nextSibling();
        				var allLocationArray = [];
        				if(!isNullOrEmpty(combo2.getValue())){
        					allLocationArray.push(combo2.getValue());
        				}
        				if(!isNullOrEmpty(combo3.getValue())){
        					allLocationArray.push(combo3.getValue());
        				}
        				localtionFieldStore.clearFilter();
        				if(allLocationArray.length){
        					localtionFieldStore.filterBy(function(record, id){
        						return !Ext.Array.contains(allLocationArray, record.get('hostelId'));
        					});
        				}
        			},50);
        		});
        	}
        },
        'studentpersonhostelrequirementform[itemId=studentPersonHostelRequirementForm] [name=studentHostelDetails2]':{
        	afterrender: function(obj){
        		var me = this;
        		if(portalId == 3 || portalId == 7){
        			var localtionFieldStore = obj.store;
        			var locationFields = obj;
        		}else{
        			var  hostelActiveTab = me.getContentPanel().getActiveTab().down('personinfopanel').getActiveTab();
            		var locationFields = hostelActiveTab.down('#studentHostelDetailsId2');
            		var localtionFieldStore = locationFields.store;
        		}
        		
        		localtionFieldStore.on('beforeload', function(){
        			if(Ext.ComponentQuery.query('[itemId='+obj.itemId+']').length>0){
        			var alId = Ext.ComponentQuery.query('[itemId='+obj.itemId+']')[0].up('fieldcontainer').down('[name=stdAcademyLocationCombo]').getValue();
        			localtionFieldStore.getProxy().extraParams = {
        				locationId: alId
        			};
        			}
        		});
        		
        		locationFields.listConfig.listeners.beforeshow = function(picker){
        			if(picker.up){
        				setTimeout(function(){
            			var currentField = picker.up('combobox');
            			picker.minWidth = currentField.getSize().width;
                		var currentFieldStore = currentField.store;
                		var sform = me.getStudentpersonhostelrequirementform();
            			
                		var combo2 = currentField;
                		var combo1 = combo2.previousSibling();
            			var combo3 = combo2.nextSibling();

            			var allLocationArray = [];
            			if(!isNullOrEmpty(combo1.getValue())){
            				allLocationArray.push(combo1.getValue());
            			}
            			if(!isNullOrEmpty(combo3.getValue())){
            				allLocationArray.push(combo3.getValue());
            			}
            			
            			currentFieldStore.clearFilter();
        				if(allLocationArray.length){
        					currentFieldStore.filterBy(function(record, id){
            					return !Ext.Array.contains(allLocationArray, record.get('hostelId'));
            				});
        				}
        				},50);
        			}
        		}
        		
        		localtionFieldStore.on('load', function(){
        			setTimeout(function(){
        				if(portalId == 3 || portalId == 7){
        					var combo2 = Ext.ComponentQuery.query('[itemId='+obj.itemId+']')[0];
        				}else{
        					var  hostelActiveTab = me.getContentPanel().getActiveTab().down('personinfopanel').getActiveTab();
        					var locationFields = hostelActiveTab.down('#studentHostelDetailsId2');
        					var combo2 =locationFields;
        				}

        				var combo1 = combo2.previousSibling();
        				var combo3 = combo2.nextSibling();
        				var allLocationArray = [];
        				if(!isNullOrEmpty(combo1.getValue())){
        					allLocationArray.push(combo1.getValue());
        				}
        				if(!isNullOrEmpty(combo3.getValue())){
        					allLocationArray.push(combo3.getValue());
        				}
        				localtionFieldStore.clearFilter();
        				if(allLocationArray.length){
        					localtionFieldStore.filterBy(function(record, id){
        						return !Ext.Array.contains(allLocationArray, record.get('hostelId'));
        					});
        				}
        			},50);
        		});
        	}
        },
        'studentpersonhostelrequirementform[itemId=studentPersonHostelRequirementForm] [name=studentHostelDetails3]':{
        	afterrender: function(obj){
        		var me = this;
        		if(portalId == 3 || portalId == 7){
        			var localtionFieldStore = obj.store;
        			var locationFields = obj;
        		}else{
        			var  hostelActiveTab = me.getContentPanel().getActiveTab().down('personinfopanel').getActiveTab();
            		var locationFields = hostelActiveTab.down('#studentHostelDetailsId3');
            		var localtionFieldStore = locationFields.store;
        		}
        		
        		localtionFieldStore.on('beforeload', function(){
        			if(Ext.ComponentQuery.query('[itemId='+obj.itemId+']').length>0){
        			var alId = Ext.ComponentQuery.query('[itemId='+obj.itemId+']')[0].up('fieldcontainer').down('[name=stdAcademyLocationCombo]').getValue();
        			localtionFieldStore.getProxy().extraParams = {
        				locationId: alId
        			};
        			}
        		});
        		
        		locationFields.listConfig.listeners.beforeshow = function(picker){
        			if(picker.up){
        				setTimeout(function(){
            			var currentField = picker.up('combobox');
            			picker.minWidth = currentField.getSize().width;
                		var currentFieldStore = currentField.store;
                		var sform = me.getStudentpersonhostelrequirementform();
                		var combo3 = currentField
            			var combo2 = combo3.previousSibling();
            			var combo1 = combo2.previousSibling();

            			var allLocationArray = [];
            			if(!isNullOrEmpty(combo1.getValue())){
            				allLocationArray.push(combo1.getValue());
            			}
            			if(!isNullOrEmpty(combo2.getValue())){
            				allLocationArray.push(combo2.getValue());
            			}
            			
            			currentFieldStore.clearFilter();
        				if(allLocationArray.length){
        					currentFieldStore.filterBy(function(record, id){
            					return !Ext.Array.contains(allLocationArray, record.get('hostelId'));
            				});
        				}
        				},50);
        			}
        		}
        		
        		localtionFieldStore.on('load', function(){
        			setTimeout(function(){
        				if(portalId == 3 || portalId == 7){
        					var combo3 = Ext.ComponentQuery.query('[itemId='+obj.itemId+']')[0];
        				}else{
        					var hostelActiveTab = me.getContentPanel().getActiveTab().down('personinfopanel').getActiveTab();
        					var locationFields = hostelActiveTab.down('#studentHostelDetailsId3');
        					var combo3 = locationFields;
        				}

        				var combo2 = combo3.previousSibling();
        				var combo1 = combo2.previousSibling();
        				var allLocationArray = [];
        				if(!isNullOrEmpty(combo2.getValue())){
        					allLocationArray.push(combo2.getValue());
        				}
        				if(!isNullOrEmpty(combo1.getValue())){
        					allLocationArray.push(combo1.getValue());
        				}
        				localtionFieldStore.clearFilter();
        				if(allLocationArray.length){
        					localtionFieldStore.filterBy(function(record, id){
        						return !Ext.Array.contains(allLocationArray, record.get('hostelId'));
        					});
        				}
        			},50);
        		});
        	}
        },
         'studentpersonhostelrequirementform[itemId=studentPersonHostelRequirementForm] checkboxfield[itemId=isHostelRequired]': {
        	   change: function(obj,newValue,oldValue) {
        		   var $this = this;
        		   setTimeout(function(){
        		   var form = obj.up('form');
        		   var hostelFieldsContainer1 = form.down('#hostelFieldsContainer1');
        		   var hostelFieldsContainer2 = form.down('#hostelFieldsContainer2');
        		   var hostelFieldsContainer3 = form.down('#hostelFieldsContainer3');
        		   var hostelPreferencePanel = form.down('#hostelPreferencePanel');
         		   var locationDropdown = form.down('#stdAcademyLocationCombo');
        		   
        		   if( newValue ){
        			   hostelFieldsContainer1.setVisible(true);
        			   hostelFieldsContainer2.setVisible(true);
        			   hostelFieldsContainer3.setVisible(true);
        			   hostelPreferencePanel.setVisible(true);
        			   // Show Custom Fields
        			   $this.showHideStudentHostelCustomFieldData(form,true);
        			   $this.stdLoadProgramLocationDropDown(locationDropdown);
        			   
        		   } else{
        			   hostelFieldsContainer1.setVisible(false);
        			   hostelFieldsContainer2.setVisible(false);
        			   hostelFieldsContainer3.setVisible(false);
        			   hostelPreferencePanel.setVisible(false);
        			   
        			   // Hide Custom Fields
        			   $this.showHideStudentHostelCustomFieldData(form,false);
        		   }
        		   //this.checkStudentHostelRequirementDfr(form);
        		   form.getForm().checkValidity();
        		   },100);
               }
           },
           'studentpersonhostelrequirementform[itemId=studentPersonHostelRequirementForm] nestedJsonCombo[itemId=studentHostelDetailsId1]': {
              	afterrender: function(combo){
              		var me = this;
              		combo.getStore().on('load',function(){
              			var sform = me.getStudentpersonhostelrequirementform();
              			var combo1 = sform.down('#studentHostelDetailsId1');
              			var combo2 = sform.down('#studentHostelDetailsId2');
              			var combo3 = sform.down('#studentHostelDetailsId3');

              			combo1.getStore().clearFilter();
              			if(!isNullOrEmpty(combo2.getValue()) && !isNullOrEmpty(combo3.getValue())){
              				combo1.getStore().filterBy(function(record, id){
              					return (record.get('id') != combo2.getValue() && record.get('id') != combo3.getValue());
              				});
              			}
              			else if(!isNullOrEmpty(combo2.getValue())){
              				combo1.getStore().filterBy(function(record, id){
              					return record.get('id') != combo2.getValue();
              				});
              			}
              			else if(!isNullOrEmpty(combo3.getValue())){
              				combo1.getStore().filterBy(function(record, id){
              					return record.get('id') != combo3.getValue();
              				});
              			}
              			combo1.lastQuery = null;
              		});

              	}
               },
               'studentpersonhostelrequirementform[itemId=studentPersonHostelRequirementForm] nestedJsonCombo[itemId=studentHostelDetailsId2]': {
              	 afterrender: function(combo){
              		 var me = this;
              		 combo.getStore().on('load',function(){
              			 var sform = me.getStudentpersonhostelrequirementform();
              			 var combo1 = sform.down('#studentHostelDetailsId1');
              			 var combo2 = sform.down('#studentHostelDetailsId2');
              			 var combo3 = sform.down('#studentHostelDetailsId3');

              			 combo2.getStore().clearFilter();
              			 if(!isNullOrEmpty(combo1.getValue()) && !isNullOrEmpty(combo3.getValue())){
              				 combo2.getStore().filterBy(function(record, id){
              					 return (record.get('id') != combo1.getValue() && record.get('id') != combo3.getValue());
              				 });
              			 }
              			 else if(!isNullOrEmpty(combo1.getValue())){
              				 combo2.getStore().filterBy(function(record, id){
              					 return record.get('id') != combo1.getValue();
              				 });
              			 }
              			 else if(!isNullOrEmpty(combo3.getValue())){
              				 combo2.getStore().filterBy(function(record, id){
              					 return record.get('id') != combo3.getValue();
              				 });
              			 }
              			 combo2.lastQuery = null;
              		 });
              	 }
               },
               'studentpersonhostelrequirementform[itemId=studentPersonHostelRequirementForm] nestedJsonCombo[itemId=studentHostelDetailsId3]': {
              	 afterrender: function(combo){
              		 var me = this;
              		 combo.getStore().on('load',function(){
              			 var sform = me.getStudentpersonhostelrequirementform();
              			 var combo1 = sform.down('#studentHostelDetailsId1');
              			 var combo2 = sform.down('#studentHostelDetailsId2');
              			 var combo3 = sform.down('#studentHostelDetailsId3');

              			 combo3.getStore().clearFilter();
              			 if(!isNullOrEmpty(combo1.getValue()) && !isNullOrEmpty(combo2.getValue())){
              				 combo3.getStore().filterBy(function(record, id){
              					 return (record.get('id') != combo1.getValue() && record.get('id') != combo2.getValue());
              				 });
              			 }
              			 else if(!isNullOrEmpty(combo1.getValue())){
              				 combo3.getStore().filterBy(function(record, id){
              					 return record.get('id') != combo1.getValue();
              				 });
              			 }
              			 else if(!isNullOrEmpty(combo2.getValue())){
              				 combo3.getStore().filterBy(function(record, id){
              					 return record.get('id') != combo2.getValue();
              				 });
              			 }
              			 combo3.lastQuery = null;
              		 });
              	 }
               },
           'feepayerdetailgrid[itemId=parentFeePayerDetailGridItemId]': {
        	   render: function(grid) {
        		   var $this = this;
        		   $this.loadGridStore('#parentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_GRID);
        		   var portalInfo = Academia.model.authentication.PortalInfoModel;
        		   var student = portalInfo.get('student');
        		   var personId = student.person.id;
        		   var store1 = Ext.create('Academia.store.personinfo.common.personalinfo.FeePayerDetailGridStore');
        		   grid.reconfigure(store1);
        		   grid.bindStore(store1);
        		   grid.down('custompagingtoolbar').bindStore(store1);
        		   store1.getProxy().extraParams = {
        			   personId:personId,
        		   };
        		   $this.resetPageSetting(store1);
        		 
        		   //-- New Card Layout for Fee Payer Detail Screen
        		   var gridStore = grid.getStore();
        		   gridStore.load();        		  
        		   var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Please wait..."});
        		   myMask.show();
        		   gridStore.on('load', function(){
        			   var feepayerdetailcardlayoutview = $this.getContentPanel().getActiveTab().down('#parentFeePayerDetailCardItemId1');
        			   if(Ext.isDefined(feepayerdetailcardlayoutview)){
        				   feepayerdetailcardlayoutview.removeAll();
        				   var feePayerGridData = gridStore.data.items;
        				   if(feePayerGridData.length>0){
        					   Ext.each(feePayerGridData, function(currentfeePayerData){
        						   var cardDataIndex = currentfeePayerData.index;
        						   var headerIndex = cardDataIndex+1;
        						   feepayerdetailcardlayoutview.add({
        							   xtype: 'feepayerdetailcardtpl',
        							   title: '<div style="display:inline-block;float: left;height:22px">Fee Payer '+headerIndex+'</div>',
        							   storeDataIndex: cardDataIndex,
        						   });
        					   });
        					   feepayerdetailcardlayoutview.add({
         						   xtype: 'feepayerdetailaddcardtpl',
         						   title: '<div style="display:inline-block;float: left;height:22px">'+getPersonModuleTranslation('ADD_FEE_PAYER_DETAILS')+'</div>',
         						   isPanelBlank: panelItemsHidden,
         					   });
        				   }else{
        					   var panelItemsHidden = true;
        					   feepayerdetailcardlayoutview.add({
        						   xtype: 'feepayerdetailaddcardtpl',
        						   title: '<div style="display:inline-block;float: left;height:22px">'+getPersonModuleTranslation('ADD_FEE_PAYER_DETAILS')+'</div>',
        					   });
        				   }

        			   }
        			   //----------------------------------------V2D-78965 ------------------------------------------------------
        			   //For Velocity : Activate The Card for Current Grade Payment Term to Parents on the Fee Payer Details Screen for Demo Only
        			   //For Velocity : Disabled The Card for Current Grade Payment Term to Parents on the Fee Payer Details Screen
        			   //---------------------------------------------------------------------------------------------------------
        			   var getStudentInfo = $this.getCurrentlyLoggedInUserInfoForPortal();
        			   var currentNextGradePaymentTermsCard = $this.getContentPanel().getActiveTab().down('#currentNextGradePaymentTermsCardItemId1');
        			   if(!isNullOrEmpty(getStudentInfo.student.id)){
        				   var getURL = SERVERURL.PATH_FINDLAYOUT_CURRENTANDNEXT_PAYMENTTERM;
            			   Ext.Ajax.request({
            				   type : 'rest',
            				   async: false,
            				   method : 'GET',
            				   url : getURL,
            				   params: {
            	        			studentId: getStudentInfo.student.id
            	        		},
            				   success: function(response, action) {
            					   getResponseList = Ext.decode(response.responseText); 
            					 
                    			   if(Ext.isDefined(currentNextGradePaymentTermsCard)){
                    				   currentNextGradePaymentTermsCard.removeAll();
                    				   
                    				   var whetherCurrentGradePaymentTermAvailable = getResponseList[0].whetherCurrentGradePaymentTermAvailable;
                    				   if(whetherCurrentGradePaymentTermAvailable) {
                    					   currentNextGradePaymentTermsCard.add({
                    						   xtype: 'currentgradepaymenttermscardtpl',
                    						   title: '<div style="display:inline-block;float: left;height:22px">'+getPersonModuleTranslation('CURRENT_GRADE_PAYMENT_TERM')+'</div>',
                    						   storeDataIndex: getResponseList,
                    					   });
                    				   }
                    				   
                    				  /* c*/
                    				   if(getResponseList.length>1){
                    					   var paymentTermStatus = getResponseList[1].paymentTermStatus;
                    					   if(paymentTermStatus=='AVAILABLE'){
                               					var panelItemsHidden = true;
                               				}
                               				else{
                               					var panelItemsHidden = false;
                               				}
                    					  
                    					   currentNextGradePaymentTermsCard.add({
                    						   xtype: 'nextacademicyearpaymenttermcardtpl',
                    						   title: '<div style="display:inline-block;float: left;height:22px">'+getPersonModuleTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM')+'</div>',
                    						   storeDataIndex: getResponseList,
                    						   isPanelBlank: panelItemsHidden
                    					   });  
                    					   var tabStructure1 = Ext.ComponentQuery.query("feepayerdetailcardlayoutview")[0];
   	        		            		   var getTabScroll = tabStructure1.up();
   	        		            		   var getformPosition = Ext.ComponentQuery.query("nextacademicyearpaymenttermcardtpl")[0].getPosition()[1];
   	        		            		   getTabScroll.body.setScrollTop(getformPosition);
                    				   }
                    			   }
            				   }
            			   }); 
        			   }
        			   myMask.hide();
        		   });

        	   }
           },
           'feepayerdetailcardtpl':{
        	   afterrender: function(currentTpl){
        		   var me = this;
        		   me.disableFeePayerCardLayoutButton(currentTpl, me.getPARENT_FEE_PAYER_DETAILS_PERMISSIONS());
        		   var editBtn = currentTpl.down('[itemId=edit_FP_ItemId]');
        		   var deleteBtn = currentTpl.down('[itemId=delete_FP_ItemId]');
        		   try{
        			   var gridStore = me.getContentPanel().getActiveTab().down('feepayerdetailgrid').getStore();
        		   }
        		   catch(e){
        			   var gridStore = me.getParentfeepayerdetailgrid().getStore();                    		
        		   }
        		   var currentData = gridStore.getAt(currentTpl.storeDataIndex);
        		   var currentFPDetailId = currentData.get('id');
        		   var currentFPType = currentData.get('payerType');
        		   var currentPGName = currentData.get('payerName');
        		   var currentFPEmailId = currentData.get('emailWork');
        		   var currentFPCountryCode = currentData.get('countryCode');
        		   var currentFPMobileNo = currentData.get('mobileNumber');
        		   var currentFPDocuments = currentData.get('documentCount');
        		   currentTpl.down('[name=feePayerDetail]').setValue(currentFPDetailId);
        		   currentTpl.down('[name=fpTypeField]').setValue(currentFPType);
        		   currentTpl.down('[name=fpNameField]').setValue(currentPGName);
        		   currentTpl.down('[name=fpEmailField]').setValue(currentFPEmailId);
        		   currentTpl.down('[name=fpMobileNoField]').setValue(currentFPCountryCode+' '+currentFPMobileNo);
        		   currentTpl.down('[name=fpDocumentsField]').setValue(currentFPDocuments);
        		   currentTpl.doLayout();
        	   }
           },
           'feepayerdetailaddcardtpl':{
        	   afterrender: function(currentTpl){
        		   var me = this;
        		   me.disableFeePayerAddCardLayout(currentTpl, me.getPARENT_FEE_PAYER_DETAILS_PERMISSIONS());  
        	   }
           },
           'feepayerdetailaddcardtpl button[itemId=addDetails_FP_ItemId]': {
               click: function() {
            	   var this$ = this;
            	   var personComContlr =Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController'),
            	   isFeePayer=true,
           	  	personType='PARENT',
           	    tabPanelTitle= 'FPD_FEE_PAYER_DETAILS',
           		tabPanelItemId= 'personfeepayerdetailformItemId',
           		tabPanelItemXtype = 'feepayerdetailform',
           		xtypeItemId = 'personfeepayerdetailformItemId',
           		defaultPanel= true,
           		menuColorCls =CONSTANTS.MENU_COLOR_EIGHT;
            	   if(Ext.ComponentQuery.query('feepayerdetailgrid')[0].getStore().getCount()){
            		   isFeePayer = false;
            	   }
           	 	
                  personComContlr.addPersonTabPanel(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,'',menuColorCls);
                var formWindowSpecific = this.getParentFeePayerDetailForm();
                var formScroll = formWindowSpecific.up('form');
                formWindowSpecific.isFeePayer=isFeePayer;
	      		if(!isNullOrEmpty(formScroll.getEl()))
	      		{
	      			var getElValue=formScroll.getEl();
	      			var getFirstChild = getElValue.first();
	      			getFirstChild.dom.style.overflowY="scroll";
	      		}
	      		
	      		var isPrimaryCheckBox = formWindowSpecific.down('#primaryFeePayerId');
            	var personProfile = this$.getContentPanelActiveTab();
            	var personObj = this$.getPersonObj();
               	var personId = personObj["id"];
    			
    			Ext.Ajax.request({
         			type: 'rest',
         			url: SERVERURL.PATH_FIND_PERSON_FEE_PAYER_EXISTS, 
         			method: 'GET',
         			params: {
         				personId: personId
                     },
         			success: function(res, action) {
         				var response = Ext.decode(res.responseText);
         				if(!isNullOrEmpty(isPrimaryCheckBox)){
         					if(response != true && response != 'true'){
         						isPrimaryCheckBox.setValue(true);
         						isPrimaryCheckBox.setReadOnly(true);
         					} 
         				}
         			}
                });
	               var corporateId = formWindowSpecific.down("#corporateId");
                   var payerTypeItemId= formWindowSpecific.down('#payerTypeItemId');
                   if(payerTypeItemId.originalValue.payerType=="PERSON" || payerTypeItemId.lastValue.payerType=="PERSON"){
                   	corporateId.allowBlank=true;
                   	corporateId.setVisible(false);	
                   }
                   
                   var corporateId = formWindowSpecific.down("#corporateId");
                   var payerTypeItemId= formWindowSpecific.down('#payerTypeItemId');
                   if(payerTypeItemId.originalValue.payerType=="PERSON" || payerTypeItemId.lastValue.payerType=="PERSON"){
                    corporateId.allowBlank=true;
                   }
                   corporateId.setVisible(false);
                   if( formWindowSpecific != null ){
           			var form = formWindowSpecific;
               		var countryCodeFieldItemIDArray = ["#homeTelephoneCountryCodeItemId","#workTelephoneCountryCodeItemId","#countryCodeItemId"];
           		    this.setDefaultCountryCode(form, countryCodeFieldItemIDArray);
           		    var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
	             	var mobileField = form.down("#homeTelephoneItemId");
	             	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
	             	countryCodeField = form.down("#workTelephoneCountryCodeItemId");
	             	mobileField = form.down("#workTelephoneItemId");
	             	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
	             	countryCodeField = form.down("#countryCodeItemId");
	             	mobileField = form.down("#mobileNumberItemId");
	             	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
	             	countryCodeField = form.down("#phoneCountryCode");
	             	phoneNoField = form.down("#phoneNoField");
	             	this.setMaximumMinimumDigitsForPhoneNoValidation(form,countryCodeField,phoneNoField,null);
	             	form.down('#salutationItemId').getStore().load();
	             	this.remainingFieldsOfFeePayerForDFR(form);
                   }
               }
           },
           'feepayerdetailcardtpl button[itemId=edit_FP_ItemId]': {
        	   click: function(btn){
        		   try{
        			   var gridStore = this.getContentPanel().getActiveTab().down('feepayerdetailgrid').getStore();
        		   }
        		   catch(e){
        			   var gridStore = this.getParentfeepayerdetailgrid().getStore();                 		
        		   }
        		  var records = gridStore.getAt(btn.up('feepayerdetailcardtpl').storeDataIndex); 
        		  var form =  this.editParentFeePayerDetailRecord(btn,records);
        		   var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
	               var mobileField = form.down("#homeTelephoneItemId");
	               this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
	               countryCodeField = form.down("#workTelephoneCountryCodeItemId");
	               mobileField = form.down("#workTelephoneItemId");
	               this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
	               countryCodeField = form.down("#countryCodeItemId");
	               mobileField = form.down("#mobileNumberItemId");
	               this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
	               countryCodeField = form.down("#phoneCountryCode");
	               mobileField = form.down("#mobileNumberItemId");
	               this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
	               var corporateId = form.down("#corporateId");
                   var payerTypeItemId= form.down('#payerTypeItemId');
                   if(payerTypeItemId.originalValue.payerType=="PERSON" || payerTypeItemId.lastValue.payerType=="PERSON"){
                    corporateId.allowBlank=true;
                    corporateId.setVisible(false);
                   }
                   var isPrimaryCheckBox = form.down('#primaryFeePayerId');
                   if(!isNullOrEmpty(isPrimaryCheckBox.getValue()) && (isPrimaryCheckBox.getValue()==true || isPrimaryCheckBox.getValue()=='true')) {
                	   isPrimaryCheckBox.setReadOnly(true);
                	   form.isFeePayer = true;
                   } else {
                	   isPrimaryCheckBox.setReadOnly(false);
                	   form.isFeePayer = false;
                   }
        	   }
           },
           'feepayerdetailcardtpl button[itemId=view_FP_ItemId]': {
        	   click: function(btn){
        		   var this$ = this;
        		   try{
        			   var gridStore = this.getContentPanel().getActiveTab().down('feepayerdetailgrid').getStore();
        		   }
        		   catch(e){
        			   var gridStore = this.getParentfeepayerdetailgrid().getStore();                 		
        		   }
        		  var records = gridStore.getAt(btn.up('feepayerdetailcardtpl').storeDataIndex); 
        		   var form =  this$.editParentFeePayerDetailRecord(btn,records);
        		    var feePayerIDItemId = form.down("#feePayerIDItemId");
        		    var feePayerProofOfAccountItemId = form.down("#feePayerProofOfAccountItemId");
                    var feePayerLatestPayslipItemId = form.down("#feePayerLatestPayslipItemId");
                    feePayerIDItemId.setDisabled(true);
                    feePayerLatestPayslipItemId.setDisabled(true);
                    feePayerProofOfAccountItemId.setDisabled(true);
        	        form.down('#submitButtonId').setVisible(false);
        	        var corporateId = form.down("#corporateId");
        	        var payerTypeItemId= form.down('#payerTypeItemId');
        	        if(payerTypeItemId.originalValue.payerType=="PERSON" || payerTypeItemId.lastValue.payerType=="PERSON"){
        	        	corporateId.allowBlank=true;
        	        	corporateId.setVisible(false);
        	        }
        	        form = form.getForm();
        	        toggleReadOnlyFormItems(form, true);
        	}
           },
           'feepayerdetailcardtpl button[itemId=delete_FP_ItemId]':{
           	click: function(btn){
        		var this$ = this;
        		var gridItemId = '#parentParentGuardianGrid';
        		var deleteUrl = SERVERURL.FPD_FEE_PAYER_DETAIL_DELETE;
        		
        		var personProfile = this$.getContentPanelActiveTab();
        		try{
        			 var grid= me.getContentPanel().getActiveTab().down('feepayerdetailgrid');
        	       	}
        	       	catch(e){
        	       		var grid = this$.getParentfeepayerdetailgrid();
        	       	}
                var gridStore = grid.getStore();
    			
                showConfirmMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(mbtn, text) {
                    if (mbtn == 'yes') {
                    	var records = gridStore.getAt(btn.up('feepayerdetailcardtpl').storeDataIndex);
                    	 if (!isNullOrEmpty(records.get("id"))) {
                    		 var id = records.get("id");
                         }
                        Ext.Ajax.request({
                            type: 'rest',
                            url: deleteUrl + id,
                            method: 'DELETE',
                            headers: {
                                'Content-Type': 'application/json'
                            },
                            success: function(form, action) {
                                grid.getStore().reload();
                                showSuccessMessage(getCommonTranslation('SUCCESS'), getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS_DELETE_SUCCESS'));
                            }
                        });
                    }
                });
        	}
        },
        'currentgradepaymenttermscardtpl':{
        	afterrender: function(currentTpl){
        		var me = this;
        		var showClickToEnter=true;
        		var currentData = currentTpl.storeDataIndex[0];
        		var registerNowBtn = currentTpl.down('[itemId=registerNowBtn]');
        		var viewBtn =currentTpl.down('[itemId=view_CGP_ItemId]'); 
        		var editBtn = currentTpl.down('[itemId=edit_CGP_ItemId]');
    			var regiterBtnPermisssion =false;
        		var permissionsMap =this.getPARENT_CURRENT_GRADE_PAYMENT_TERM_PEMISSION();
        		var associatedAcadLocationIds = new Array();
               	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
               	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
               		Ext.each(permissionList, function(privilege) {
                   		if (privilege === 'Enroll') {
                   			regiterBtnPermisssion =true;
                   		}
                   	});
        		if(currentData.isEditable == true && currentData.paymentTermStatus=='AVAILABLE' && currentData.whetherRegistrationDone == true){
        			editBtn.setVisible(true);
        		}
        		if(currentData.paymentTermStatus=='AVAILABLE' && currentData.whetherRegistrationDone == true){
        			viewBtn.setVisible(true);
        		}
        		if(currentData.whetherRegistrationDone == true){
        			registerNowBtn.setVisible(false);
        			
        		}else if(currentData.whetherRegistrationDone == false && (currentData.newRegisteredStudentEndDate >= Date.now() || currentData.endRegistrationDat >= Date.now()) && regiterBtnPermisssion) {
        			registerNowBtn.setVisible(true);
        		}
        		else {
        			 registerNowBtn.setVisible(false);
        		}
        		var currentGradeIntake = currentData.programName;
        		var currentGradeFeeTerm = currentData.feePlanRuleName;
        		var currentCurrencyCode = currentData.currencyCode;
        		var currentTotalAmount = currentData.totalAmount;
        		var currentInstallmentPerMonth = currentData.installmentAmount;
        		var currentFeeStageHeadConfigId = currentData.feeStageHeadConfigId;
        		var currentPaymentPeriod = currentData.paymentPeriod;
        		var currentProgramBatchSeatConfigId = currentData.programBatchSeatConfigId;
        		if(!isNullOrEmpty(currentGradeIntake)){
        			     			
        			currentTpl.down('[name=gradeIntake]').setValue(currentGradeIntake);
        		}
        		if(!isNullOrEmpty(currentGradeFeeTerm)){
        			if(currentData.whetherRegistrationDone == null || currentData.whetherRegistrationDone == false){
        				currentTpl.down('[name=gradeFeeTerm]').setValue(null);
        			} else{
        				currentTpl.down('[name=gradeFeeTerm]').setValue(currentGradeFeeTerm);
        			}  
        			
        		}
        		/*if(!isNullOrEmpty(currentCurrencyCode) && !isNullOrEmpty(currentTotalAmount)){
        			if(currentData.whetherRegistrationDone == null || currentData.whetherRegistrationDone == false){
        				currentTpl.down('[name=totalAmount]').setValue(null);
        			}else{
        				currentTpl.down('[name=totalAmount]').setValue(currentCurrencyCode+' '+currentTotalAmount);
        			}
        			
        		}
        		if(currentData.whetherRegistrationDone == null || currentData.whetherRegistrationDone == false){
        			currentTpl.down('[name=installmentSchedule]').setValue(null);
        		}else{
        			currentTpl.down('[name=installmentSchedule]').setValue('<a href ="#">View</a>');
        		}*/
        		
        		/*if(!isNullOrEmpty(currentCurrencyCode) && !isNullOrEmpty(currentInstallmentPerMonth)){
        			currentTpl.down('[name=installmentPerMonth]').setValue(currentCurrencyCode+' '+currentInstallmentPerMonth);
        		}*/
        		currentTpl.down('[name=feeStageHeadConfigId]').setValue(currentFeeStageHeadConfigId);
        		currentTpl.down('[name=paymentPeriod]').setValue(currentPaymentPeriod);
        		currentTpl.down('[name=pbscId]').setValue(currentProgramBatchSeatConfigId);
        		currentTpl.doLayout();
        	}
        },
        'nextacademicyearpaymenttermcardtpl':{
        	afterrender: function(currentTpl){
        		var me = this;
        		var currentData = currentTpl.storeDataIndex[1];
        		var editBtn =currentTpl.down('#editStudentRegBtn');
        		var userInfo =  Academia.model.authentication.PortalInfoModel
        		var whetherRegistrationDone = currentData.whetherRegistrationDone;
        		  var nextAcademicYearPaymentTermCardTpl = this.getNextacademicyearpaymenttermcardtpl();
				   var addRegistrationBtn = nextAcademicYearPaymentTermCardTpl.down('#addDetails_NAT_ItemId');
				   var registrationNotDoneLabel = nextAcademicYearPaymentTermCardTpl.down('#whetherRegistrationNotDoneItemId');
				   var registrationDoneLabel = nextAcademicYearPaymentTermCardTpl.down('#whetherRegistrationDoneItemId');
				   var nextAcademicTermCardDetailPanel = nextAcademicYearPaymentTermCardTpl.down('#nextAcademicTermCardDetailItemId');
				   var viewBtn = nextAcademicYearPaymentTermCardTpl.down('#view_NAT_ItemId');
       		    if(whetherRegistrationDone ==  true) {
					  addRegistrationBtn.setVisible(false);
					 // registrationNotDoneLabel.setVisible(false);
					  nextAcademicTermCardDetailPanel.removeCls('pgCardLayoutUprPnl');
					  nextAcademicYearPaymentTermCardTpl.down('#addDetailsPanelItemId').addCls('addDetailsPanelCls');
					 registrationDoneLabel.setVisible(true);
					 registrationDoneLabel.addCls('feePayRegistrationDonePnlCls');
					
				   }
       		      else if(whetherRegistrationDone == false) {
				   addRegistrationBtn.setVisible(true);
				   //registrationNotDoneLabel.setVisible(true);
				   registrationDoneLabel.setVisible(false);
				  
				   nextAcademicTermCardDetailPanel.removeCls('pgCardLayoutUprPnl');
				   
			     }
       		    else if(whetherRegistrationDone == null){
       		         addRegistrationBtn.setVisible(false);
				  // registrationNotDoneLabel.setVisible(false);
				  //registrationDoneLabel.setVisible(false);
       		       registrationDoneLabel.destroy();
       		       nextAcademicTermCardDetailPanel.setVisible(true);
       		       nextAcademicTermCardDetailPanel.el.setStyle('margin-top','-45px !important')
       		       viewBtn.show();
       		    }
        		if(currentTpl.isPanelBlank){ //-- showing only add button in card tpl if record for relation is not available
        			currentTpl.down('[itemId=nextAcademicTermCardDetailItemId]').removeAll();
        			currentTpl.down('[itemId=view_NAT_ItemId]').hide();
        			var succeedingPBSTId = currentData.succeedingProgramBatchSeatConfigId;
        			currentTpl.down('[name=succeedingPBSTId]').setValue(succeedingPBSTId);
        		}
        		else {
        	    currentTpl.down('[itemId=successMsg]').show();
        		currentTpl.down('[itemId=addDetails_NAT_ItemId]').hide();
        		var currentGradeIntake = currentData.programName;
        		var currentGradeFeeTerm = currentData.feePlanRuleName;
        		var currentCurrencyCode = currentData.currencyCode;
        		var currentTotalAmount = currentData.totalAmount;
        		var currentInstallmentPerMonth = currentData.installmentAmount;
        		var currentFeeStageHeadConfigId = currentData.feeStageHeadConfigId;
        		var currentPaymentPeriod = currentData.paymentPeriod;
        		var currentProgramBatchSeatConfigId = currentData.programBatchSeatConfigId;
        		if(!isNullOrEmpty(currentGradeIntake)){
        			currentTpl.down('[name=gradeIntake]').setValue(currentGradeIntake);
        		}
        		if(!isNullOrEmpty(currentGradeFeeTerm)){
        			currentTpl.down('[name=gradeFeeTerm]').setValue(currentGradeFeeTerm);
        		}
        		/*if(!isNullOrEmpty(currentCurrencyCode) && !isNullOrEmpty(currentTotalAmount)){
        			currentTpl.down('[name=totalAmount]').setValue(currentCurrencyCode+' '+currentTotalAmount);
        		}*/
        		/*if(!isNullOrEmpty(currentCurrencyCode) && !isNullOrEmpty(currentInstallmentPerMonth)){
        			currentTpl.down('[name=installmentPerMonth]').setValue(currentCurrencyCode+' '+currentInstallmentPerMonth);
        		}*/
        		
        		currentTpl.down('[name=feeStageHeadConfigId]').setValue(currentFeeStageHeadConfigId);
        		currentTpl.down('[name=paymentPeriod]').setValue(currentPaymentPeriod);
        		currentTpl.down('[name=pbscId]').setValue(currentProgramBatchSeatConfigId);
        		currentTpl.doLayout();       		
        		 
        		}
        		 
        	},
        	render:function(currentTpl){
        		var currentData = currentTpl.storeDataIndex[1];
        		var editBtn =currentTpl.down('#editStudentRegBtn');
        		var userInfo =  Academia.model.authentication.PortalInfoModel
        	
        		 Ext.Ajax.request({
                     type: 'rest',
                     url: SERVERURL.NEXT_ACADEMIC_YEAR_PAYMENT_TERM_CHANGING_DATE,
                     method: 'GET',
                     params : {
                    	 studentId: userInfo.data.student.id,
                    	 succeedingPBSTId :currentData.succeedingProgramBatchSeatConfigId
                     },
                     success: function(form, action) {                        
                        if(!isNullOrEmpty(form.responseText)){
                        	var CurrentDateTime = new Date().getTime();
                        	if(CurrentDateTime < form.responseText){
                        		editBtn.show();
                        	}else{
                        		editBtn.hide();
                        	}
                        }
                     }
                 }); 
        	}
        },
        'currentgradepaymenttermscardtpl button#registerNowBtn':{
        	click:function(){
        		$this = this;
            	  var contentpanel = $this.getContentpanel();
            	  var studentRegistrationStructure=Ext.widget("studentregistrationtabstructure",{
            		  isRegisterBtn :true
            	  });
            	  var tabName = getFeeAndPaymentCommonTranslation('REGISTRATION_DETAILS');
            	  var newTab = this.getTabReferenceByTabTitle(tabName);
            	  var getcontroller=$this.getController('menu.CoreERPNavigationController');
            	  var getTab=getcontroller.getTab(tabName);
            	  if(getTab!=null){
            		  contentpanel.remove(getTab, true);
            	  }
            	  openTab(contentPanel, tabName, studentRegistrationStructure, CONSTANTS.MENU_COLOR_TWO);
            	  contentPanel.setActiveTab(newTab);  
            	  studentRegistrationStructure.isRegisterBtn = true;

        	}
        },
        'currentgradepaymenttermscardtpl displayfield[name=installmentSchedule]': {
        	afterrender: function(component) {
        		var $this = this;
        		component.getEl().on('click', function(e) {
        			if (e.target.tagName == 'A') {
        				var getCardDetail = Ext.ComponentQuery.query('currentgradepaymenttermscardtpl')[0];
        				if(Ext.isDefined(getCardDetail)){
        					var feeStageHeadConfigId = getCardDetail.down('[name=feeStageHeadConfigId]');
        					var paymentPeriod = getCardDetail.down('[name=paymentPeriod]');
        					var formWindow = $this.getStudentfeepayerinstallmentschedulewin();
        					if (!formWindow) {
        						Ext.widget('studentfeepayerinstallmentschedulewin');
        						formWindow = $this.getStudentfeepayerinstallmentschedulewin();
        					}
        					formWindow.show();
        					if(!isNullOrEmpty(feeStageHeadConfigId.getValue()) && !isNullOrEmpty(paymentPeriod.getValue())){
        						var grid = $this.getFeepayerinstallmentschedulesgrid();
            					grid.getStore().getProxy().extraParams = {
            						skipMonths: '',
            						feeStageHeadConfigId:feeStageHeadConfigId.getValue(),
            						paymentPeriod:paymentPeriod.getValue(),
             						isParent:true
        						};
            					grid.getStore().load();
        					}
        				}
        			}
        		});
        	}
        },
        'feepayerdetailcardtpl displayfield[name=fpDocumentsField]': {
        	afterrender: function(component) {
        		var $this = this;
        		component.getEl().on('click', function(e) {
        			if (e.target.tagName == 'A') {
        				var getCardDetail = component.up('feepayerdetailcardtpl');
        				if(Ext.isDefined(getCardDetail)){
        					var feePayerDetail = getCardDetail.down('#feePayerDetail');
        					var formWindow = $this.getStudentfeepayerdetaildocumentwin();
        					if (!formWindow) {
        						Ext.widget('studentfeepayerdetaildocumentwin');
        						formWindow = $this.getStudentfeepayerdetaildocumentwin();
        					}
        					formWindow.show();
        					if(!isNullOrEmpty(feePayerDetail.getValue())){
        						var documentGrid = $this.getStudentfeepayerdetaildocumentgrid();
        						documentGrid.getStore().getProxy().extraParams = {
        							feePayerDetailId: feePayerDetail.getValue()
        						};
        						documentGrid.getStore().load();
        					}
        				}
        			}
        		});
        	}
        },
        'nextacademicyearpaymenttermcardtpl button[itemId=addDetails_NAT_ItemId]': {
            click: function() {
              $this = this;
          	  var contentpanel = $this.getContentpanel();
          	  var studentRegistrationStructure=Ext.widget("studentregistrationtabstructure");
          	  var tabName = getFeeAndPaymentCommonTranslation('REGISTRATION_DETAILS');
          	  var newTab = this.getTabReferenceByTabTitle(tabName);
          	  var getcontroller=$this.getController('menu.CoreERPNavigationController');
          	  var getTab=getcontroller.getTab(tabName);
          	  if(getTab!=null){
          		  contentpanel.remove(getTab, true);
          	  }
          	  openTab(contentPanel, tabName, studentRegistrationStructure, CONSTANTS.MENU_COLOR_TWO);
          	  contentPanel.setActiveTab(newTab);
          	  
//      			  receivingCurrencyStore.load({});	
            	
            
           /* var $this = this;
            var formWindow = $this.getFeepayernextacademicpaymenttermform();
            if (!formWindow) {
             	Ext.widget('feepayernextacademicpaymenttermform');
             	formWindow = $this.getFeepayernextacademicpaymenttermform();
             }
             formWindow.show(); */
             }
        },
        'feepayernextacademicpaymenttermform':{
			render:function(feepayernextacademicpaymenttermform){
				var $this = this;
				var userInfo =  Academia.model.authentication.PortalInfoModel
				var getCardDetail = Ext.ComponentQuery.query('nextacademicyearpaymenttermcardtpl')[0];
				var succeedingPBSTIdField = getCardDetail.down('#succeedingPBSTId');
				if(!isNullOrEmpty(succeedingPBSTIdField.getValue()))
				{
					var studentId = userInfo.data.student.id;
					if(!isNullOrEmpty(studentId))
					{
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_FIND_SPECIFICPERSON_FEERULESSTUDENT,
							params:{
								studentId: studentId,
								succeedingPBSTId :succeedingPBSTIdField.getValue()
							},
							method: 'GET',
							async: false,
							success: function(res, action) {
								getJsonList = Ext.decode(res.responseText); 
								var form = feepayernextacademicpaymenttermform.down('form');
								feepayernextacademicpaymenttermform.setTitle(getPersonModuleTranslation('PAYMENT_TERM_SELECTION_WINDOW_TITLE')+' '+getJsonList.nextAcademicYear);
								//feepayernextacademicpaymenttermform.down('#isWhetherStudentConTitleId').setText('<span style="color:red">New password is required.</span>')
								//feepayernextacademicpaymenttermform.down('#isWhetherStudentConTitleId').html = getPersonModuleTranslation('PAYMENT_TERM_SELECTION_WINDOW_TITLE')+' '+getJsonList.nextAcademicYear;
								feepayernextacademicpaymenttermform.down('#isWhetherStudentConTitleId').setText(getPersonModuleTranslation('IS_WHETHER_STUDENT_CONTINUE_RADIO_BUTTON_TITLE')+' '+getJsonList.nextAcademicYear);
								var dataModal = getJsonList.parentFeePlanSelectionModels;
								var store = $this.getStore('personinfo.common.personalinfo.FeePayerPaymentTermSelectionGridStore');
								if(store.getRange()){
									store.removeAll();	 
								}
								store.loadRawData(dataModal, true);
								var feeRecords = store.getRange();
								$this.addDocumentsImagesField(feepayernextacademicpaymenttermform,getJsonList);	
								form.isValid();
							}
						});
					}
					// this.getStudentDetailByParent();
				}
				
			}
        },
        'studentregistrationtabstructure':{
			render:function(feepayernextacademicpaymenttermform){
				var $this = this;
				var structure = this.getStudentregistrationtabstructure();
				var secondTab= structure.down('#feepayerdetailparenttabitemid')
				var thirdTab= structure.down('#medicalDetailParentItemId')
				var fourthTab= structure.down('#documentDetailParentItemId')
    			secondTab.setDisabled(true);
    			thirdTab.setDisabled(true);
    			fourthTab.setDisabled(true);
    			
    			if(feepayernextacademicpaymenttermform.isRegisterBtn) {
    				var isWhetherStudentConTitleId =  feepayernextacademicpaymenttermform.down('#isWhetherStudentConTitleId');
    				var nextAcademicYearItemId = feepayernextacademicpaymenttermform.down('#nextAcademicYearItemId');
    				isWhetherStudentConTitleId.hide();
    				nextAcademicYearItemId.hide();
    				var getCardDetail = Ext.ComponentQuery.query('currentgradepaymenttermscardtpl')[0];
    				var succeedingPBSTIdField;
    				if(getCardDetail != undefined){
    					succeedingPBSTIdField = getCardDetail.down('[name=pbscId]').getValue();
    				}else{
    					succeedingPBSTIdField = getResponseList[0].programBatchSeatConfigId;
    				}
    			}else{
					var getCardDetail = Ext.ComponentQuery.query('nextacademicyearpaymenttermcardtpl')[0];
					var succeedingPBSTIdField;
    				if(getCardDetail != undefined){
    					 succeedingPBSTIdField = getCardDetail.down('#succeedingPBSTId').getValue();
    				}else{
    					succeedingPBSTIdField = getResponseList[0].succeedingProgramBatchSeatConfigId;
    				}
				}
				var userInfo =  Academia.model.authentication.PortalInfoModel
				/*var getCardDetail = Ext.ComponentQuery.query('nextacademicyearpaymenttermcardtpl')[0];
				var succeedingPBSTIdField = getCardDetail.down('#succeedingPBSTId');
				*/if(!isNullOrEmpty(succeedingPBSTIdField))
				{
					var studentId = userInfo.data.student.id;
					if(!isNullOrEmpty(studentId))
					{
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.PATH_FIND_SPECIFICPERSON_FEERULESSTUDENT,
							params:{
								studentId: studentId,
								succeedingPBSTId :succeedingPBSTIdField
							},
							method: 'GET',
							async: false,
							success: function(res, action) {
								getJsonList = Ext.decode(res.responseText); 
								var form = feepayernextacademicpaymenttermform.down('form');
								var allowblankFalse = '<span class="required" style="color:red"> *</span>';
//From Here Title is Set
//								feepayernextacademicpaymenttermform.setTitle(getPersonModuleTranslation('PAYMENT_TERM_SELECTION_WINDOW_TITLE')+' '+getJsonList.nextAcademicYear);
								//feepayernextacademicpaymenttermform.down('#isWhetherStudentConTitleId').setText('<span style="color:red">New password is required.</span>')
								//feepayernextacademicpaymenttermform.down('#isWhetherStudentConTitleId').html = getPersonModuleTranslation('PAYMENT_TERM_SELECTION_WINDOW_TITLE')+' '+getJsonList.nextAcademicYear;
								feepayernextacademicpaymenttermform.down('#isWhetherStudentConTitleId').setText('Will '+ getJsonList.studentName+' be returning to ' +getJsonList.acadLocationName+ ' for the Next Academic Year?');
								
								/*setTimeout(function(){
									feepayernextacademicpaymenttermform.down('#forNextYearSibilingTitleId').setValue('For next year, will '+ getJsonList.studentName+' have a sibling in '+getJsonList.acadLocationName+' or another Advtech school?' + allowblankFalse);
									feepayernextacademicpaymenttermform.down('#currentYearBursaryTitleId').setValue('Was '+ getJsonList.studentName+' awarded a bursary by ' +getJsonList.acadLocationName+' for the Current Academic Year?' + allowblankFalse);
									feepayernextacademicpaymenttermform.down('#nextYearBursaryTitleId').setValue('Has '+ getJsonList.studentName+' applied or been awarded a bursary by '+getJsonList.acadLocationName+' for the Next Academic Year?' + allowblankFalse);
									feepayernextacademicpaymenttermform.down('#isStudentChildOfAdvTechStaff').setValue('Is '+ getJsonList.studentName+' the child of an Advtech staff member?' + allowblankFalse);
									},300);*/
								
								var dataModal = getJsonList.parentFeePlanSelectionModels;
								var store = $this.getStore('personinfo.common.personalinfo.FeePayerPaymentTermSelectionGridStore');
								if(store.getRange()){
									store.removeAll();	 
								}
								store.loadRawData(dataModal, true);
								var feeRecords = store.getRange();
								$this.addDocumentsImagesField(feepayernextacademicpaymenttermform,getJsonList);	
								form.isValid();
							}
						});
					}
					// this.getStudentDetailByParent();
				}
				$this.getDFRDataForReRegFeePayer();
			}
        },
        
        'feepayernextacademicpaymenttermform button[itemId=cancelButtonId]':{
        	click: function(obj) { 
        		obj.up('feepayernextacademicpaymenttermform').close();
        	}
        },
        'feepayernextacademicpaymenttermform button[itemId=submitButtonId]':{
        	click: function(obj) { 
        		var $this = this;
        		var paymentTermForm = obj.up('form');
        		
        		var whetherUpdate = paymentTermForm.getForm().findField('whetherUpdate');
				var whetherAccept = paymentTermForm.getForm().findField('whetherAccept');
				var paymentTermGrid = paymentTermForm.down('#feepayerpaymenttermselectiongridItemId');
				var paymentGridStore = paymentTermGrid.getStore();
				var flag = false;
				paymentGridStore.data.items.forEach(function(itemObj){
					if(isNullOrEmpty(itemObj.data.totalAmount)){
						flag = true;
					}
				});
					if((flag != true) && (whetherAccept.getValue() == true && whetherUpdate.getValue() == true)){
						var userInfo =  Academia.model.authentication.PortalInfoModel
		        		var studentId = userInfo.data.student.id
						var getCardDetail = Ext.ComponentQuery.query('nextacademicyearpaymenttermcardtpl')[0];
						var succeedingPBSTIdField = getCardDetail.down('#succeedingPBSTId');
		        		
		        		var gridStore = $this.getContentPanel().getActiveTab().down('feepayerdetailgrid').getStore();
		        		var formValues = paymentTermForm.getValues();
		        		var putItems = [];
		        		paymentGridStore.data.items.forEach(function(itemObj){
			        		putItems.push({
			        				'feePlanId':itemObj.data.feePlanId,
			        				'feeRuleId':itemObj.data.feePlanRuleId,
			        				'studentId':studentId,
			                	    'nextPBSId':parseInt(succeedingPBSTIdField.getValue()),
			                	    'whetherStudentContinueInNAY':formValues.isWhetherStudentCont,
                                    'operatingSystem':"windows"
			        		});
		        		});
		        		 var submitData = Ext.encode(putItems);
		        	  submitUrl = SERVERURL.PATH_GRADE_PAYMENTTERMS_RESOURCE_CREATE;
		       		  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		       	 	  Ext.Ajax.request({
		       			  type : 'rest',
		       			  url : submitUrl,
		       			  jsonData : submitData,
		       			  method : 'POST',
		       			  success : function(response, action) {
		       				  Ext.getBody().unmask();
		       				  showSuccessMessage(getPersonModuleTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM'), getPersonModuleTranslation('NEXT_ACADEMIC_YEAR_PAYMENT_TERM_SUCCESSFULLY_MSG'));
		       				 $this.loadGridStore('#parentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_GRID);
		       				 obj.up('feepayernextacademicpaymenttermform').close();
		       			  }
		       	 	  });
					}else{
						showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('PLEASE_SELECT_PAYMENT_TERM'));
					}
				
        		
        	}
        },
		 'feepayernextacademicpaymenttermform radiogroup#isWhetherStudentConItemId':{
 			 change:function(obj,newValue,oldValue){
 				var form = this.getFeepayernextacademicpaymenttermform();
 				var getFormFields = form.down('form').getForm();
 				var feepayerpaymenttermselectiongrid = form.down('#feepayerpaymenttermselectiongridItemId');
 				var feepayerpaymenttermdocumentsviewItemId = form.down('#feepayerpaymenttermdocumentsviewItemId');
 				 var value = newValue.isWhetherStudentCont;
 				 if(value==true){
 					toggleReadOnlyFormItems(getFormFields, false);
 					form.down('#whetherAccept').show();
 					form.down('#whetherUpdate').show();
 					feepayerpaymenttermselectiongrid.show();
 				 }else{
 					 toggleReadOnlyFormItems(getFormFields, true);
 					form.down('#isWhetherStudentConItemId').setReadOnly(false);
 					form.down('#whetherAccept').hide();
 					form.down('#whetherUpdate').hide();
 					feepayerpaymenttermselectiongrid.hide();
 					
 				 }
 			 }
 		 },
         'currentgradepaymenttermscardtpl button[itemId=edit_CGP_ItemId]': {
        	 click: function(btn) {
        		 this.editCurrentGradePaymentTermsCardRecord(btn);
        	 }
         },
         'nextacademicyearpaymenttermcardtpl displayfield[name=installmentSchedule]': {
         	afterrender: function(component) {
         		var $this = this;
         		component.getEl().on('click', function(e) {
         			if (e.target.tagName == 'A') {
         				var getCardDetail = Ext.ComponentQuery.query('nextacademicyearpaymenttermcardtpl')[0];
         				if(Ext.isDefined(getCardDetail)){
         					var feeStageHeadConfigId = getCardDetail.down('[name=feeStageHeadConfigId]');
         					var paymentPeriod = getCardDetail.down('[name=paymentPeriod]');
         					var formWindow = $this.getStudentfeepayernextinstallmentschedulewin();
         					if (!formWindow) {
         						Ext.widget('studentfeepayernextinstallmentschedulewin');
         						formWindow = $this.getStudentfeepayernextinstallmentschedulewin();
         					}
         					formWindow.show();
         					if(!isNullOrEmpty(feeStageHeadConfigId.getValue()) && !isNullOrEmpty(paymentPeriod.getValue())){
         						var grid = $this.getFeepayernextinstallmentschedulesgrid();
         						var dueDateColumn = grid.columns[1];
         						grid.getStore().getProxy().extraParams = {
             						skipMonths: '',
             						feeStageHeadConfigId:feeStageHeadConfigId.getValue(),
             						paymentPeriod:paymentPeriod.getValue(),
             						isParent:true
         						};
             				/* If Due date is Null then Hide Invoice Date Column*/
         						grid.getStore().load({
             						callback: function(records, operation, success) {
             							Ext.Array.each(records,function(record){
                 							if(isNullOrEmpty(record.data.dueDate)){
                 								dueDateColumn.hide();
                 							}             						
             								
             							})
             					}});
         					}
         				}
         			}
         		});
         	}
         },
         'feepayercurrentpaymenttermeditform button[itemId=cancelButtonId]':{
         	click: function(obj) { 
         		obj.up('feepayercurrentpaymenttermeditform').close();
         	}
         },
         'feepayercurrentpaymenttermeditform button[itemId=submitButtonId]':{
         	click: function(obj) { 
         		var $this = this;
         		var paymentTermForm = obj.up('form');
         		var userInfo =  Academia.model.authentication.PortalInfoModel
         		var studentId = userInfo.data.student.id
         		var getCardDetail = Ext.ComponentQuery.query('currentgradepaymenttermscardtpl')[0];
    			var currentPBSTIdField = getCardDetail.down('[name=pbscId]');
         		var paymentTermGrid = paymentTermForm.down('#feepayercurrentpaymenttermeditgridItemId');
         		var paymentGridStore = paymentTermGrid.getStore();
         		var formValues = paymentTermForm.getValues();
         		var putItems = [];
         		paymentGridStore.data.items.forEach(function(itemObj){
         			if(!isNullOrEmpty(itemObj.data.feeRuleIdOnlyForEditAndView)){
         				putItems.push({
 	        				'feePlanId':itemObj.data.feePlanId,
 	        				'feeRuleId':itemObj.data.feeRuleIdOnlyForEditAndView,
 	        				'studentId':studentId,
 	                	    'nextPBSId':parseInt(currentPBSTIdField.getValue()),
 	                	    'whetherStudentContinueInNAY':true,
                            'operatingSystem':"windows"
 	        		});
         			}else{
         				putItems.push({
 	        				'feePlanId':itemObj.data.feePlanId,
 	        				'feeRuleId':itemObj.data.feePlanRuleId,
 	        				'studentId':studentId,
 	                	    'nextPBSId':parseInt(currentPBSTIdField.getValue()),
 	                	    'whetherStudentContinueInNAY':true,
                            'operatingSystem':"windows"
 	        		});
         			}
 	        		
         		});
         		 var submitData = Ext.encode(putItems);
         	     submitUrl = SERVERURL.PATH_GRADE_PAYMENTTERMS_RESOURCE_UPDATE;
        		  Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
        	 	  Ext.Ajax.request({
        			  type : 'rest',
        			  url : submitUrl,
        			  jsonData : submitData,
        			  method : 'POST',
        			  success : function(response, action) {
        				  getJsonList = Ext.decode(response.responseText); 
        				  Ext.getBody().unmask();
        				  if(getJsonList==true){
        					  showSuccessMessage(getPersonModuleTranslation('CURRENT_GRADE_PAYMENT_TERM'), getPersonModuleTranslation('CURRENT_GRADE_PAYMENT_TERM_SUCCESSFULLY_MSG'));
        					  $this.loadGridStore('#parentFeePayerDetailGridItemId', SERVERURL.FPD_PERSON_FEE_PAYER_DETAIL_GRID);
        					  obj.up('feepayercurrentpaymenttermeditform').close(); 
        				  }else{
        					  showWarningMessage(getPersonModuleTranslation('CURRENT_GRADE_PAYMENT_TERM'), getPersonModuleTranslation('EDIT_NOT_PERFORMED_CURRENT_GRADE_PAYMENT_TERM'));
        					  obj.up('feepayercurrentpaymenttermeditform').close(); 
        				  }
        			  }
        	 	  });
         	}
         },
         'currentgradepaymenttermscardtpl button[itemId=view_CGP_ItemId]': {
        	 click: function(btn) {
        		 var btn = 'view';
        		 this.editCurrentGradePaymentTermsCardRecord(btn);
        	 }
         },
         'nextacademicyearpaymenttermcardtpl button[itemId=view_NAT_ItemId]': {
        	 click: function(btn) {
        		 this.ViewNextGradePaymentTermsCardRecord(btn,true);
        	 }
         },
         'nextacademicyearpaymenttermcardtpl button[itemId=editStudentRegBtn]': {
        	 click: function(btn) {
        		 this.ViewNextGradePaymentTermsCardRecord(btn,false);
        	 }
         },
         'feepayernextpaymenttermviewform button[itemId=cancelButtonId]': {
        	 click: function(obj) { 
          		obj.up('feepayernextpaymenttermviewform').close();
          	}
         },
         'feepayernextpaymenttermviewform button[itemId=submitButtonId]': {
        	 click: function(obj) { 
        		var form = this.getFeepayernextpaymenttermviewform();
        		var nextPaymentCard= Ext.ComponentQuery.query('nextacademicyearpaymenttermcardtpl')[0]
        		var grid = obj.up('feepayernextpaymenttermviewgrid');
          		var grid = this.getFeepayernextpaymenttermviewform().down('grid');
          		var dataCount = grid.getStore().getCount();
          		var gridStore =grid.getStore();
          		var medicalDetailId = form.down('#medicalDetailId').getValue();
          		var feePayerDetailId = form.down('#feePayerDetailId').getValue();
          		var applicableForCurrentYear = form.down('#applicableForCurrentYear').getValue();
          		if(dataCount > 0){
          			var userInfo =  Academia.model.authentication.PortalInfoModel
		        		var studentId = userInfo.data.student.id
						var getCardDetail = Ext.ComponentQuery.query('nextacademicyearpaymenttermcardtpl')[0];
						var succeedingPBSTIdField = getCardDetail.down('[name=pbscId]');
						
		        		var putItems = [];
		        		gridStore.data.items.forEach(function(itemObj){
			        		putItems.push({
			        				'feePlanId':itemObj.data.feePlanId,
			        				'feeRuleId':itemObj.data.feeRuleIdOnlyForEditAndView,
			        				'studentId':studentId,
			                	    'nextPBSId':parseInt(succeedingPBSTIdField.getValue())
			                	    		
			                	    
			        		});
		        		});
		        	   var submitData = Ext.encode(putItems);
          			Ext.Ajax.request({
                		  type: 'rest',
                		  url: SERVERURL.PATH_UPDATE_FEE_PLAN_RULE,
                		  method: 'POST',
                		  jsonData: submitData,
                		  success: function(response, action) {
                				Ext.Ajax.request({
                          		  type: 'rest',
                          		  url: SERVERURL.PATH_FINDLAYOUT_CURRENTANDNEXT_PAYMENTTERM,
                          		  method : 'GET',
                          		 params: {
             	        			studentId:studentId
             	        		},
                          		  success: function(response, action) {
                          			  form.close();
                      				showSuccessMessage(getPersonModuleTranslation('PAYMENT_TERMS_DETAILS'),getCommonTranslation('RECORD_UPDATE_SUCCESS'));
                      			
                          			var currentData = Ext.decode(response.responseText)[1]; 	
                          			var currentGradeIntake = currentData.programName;
                            		var currentGradeFeeTerm = currentData.feePlanRuleName;
                            		var currentCurrencyCode = currentData.currencyCode;
                            		var currentTotalAmount = currentData.totalAmount;
                            		var currentInstallmentPerMonth = currentData.installmentAmount;
                            		var currentFeeStageHeadConfigId = currentData.feeStageHeadConfigId;
                            		var currentPaymentPeriod = currentData.paymentPeriod;
                            		var currentProgramBatchSeatConfigId = currentData.programBatchSeatConfigId;
                            		if(!isNullOrEmpty(currentGradeIntake)){
                            			nextPaymentCard.down('[name=gradeIntake]').setValue(currentGradeIntake);
                            		}
                            		if(!isNullOrEmpty(currentGradeFeeTerm)){
                            			nextPaymentCard.down('[name=gradeFeeTerm]').setValue(currentGradeFeeTerm);
                            		}
                            		/*if(!isNullOrEmpty(currentCurrencyCode) && !isNullOrEmpty(currentTotalAmount)){
                            			nextPaymentCard.down('[name=totalAmount]').setValue(currentCurrencyCode+' '+currentTotalAmount);
                            		}*/
                            		/*if(!isNullOrEmpty(currentCurrencyCode) && !isNullOrEmpty(currentInstallmentPerMonth)){
                            			currentTpl.down('[name=installmentPerMonth]').setValue(currentCurrencyCode+' '+currentInstallmentPerMonth);
                            		}*/
                            		
                            		nextPaymentCard.down('[name=feeStageHeadConfigId]').setValue(currentFeeStageHeadConfigId);
                            		nextPaymentCard.down('[name=paymentPeriod]').setValue(currentPaymentPeriod);
                            		nextPaymentCard.down('[name=pbscId]').setValue(currentProgramBatchSeatConfigId);
                            		nextPaymentCard.doLayout();      
                          			  }
                          		 });
                		    }
                		 });
          		}
          			
          	}
         },
         'feepayerpaymenttermselectiongrid': {
        	 cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
                 var $this = this;
                 if (e.target.tagName == 'A') {
                     var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
                     if (columnName == "installmentSchedule") {
        				var getGridDetail = Ext.ComponentQuery.query('feepayerpaymenttermselectiongrid')[0];
        				if(Ext.isDefined(getGridDetail)){
        					var record = getGridDetail.getSelectionModel().getSelection()[0];
        					if(!isNullOrEmpty(record.data.feeStageHeadConfigId) && !isNullOrEmpty(record.data.paymentPeriod))
        						{
        						var feeStageHeadConfigId = record.data.feeStageHeadConfigId;
            					var paymentPeriod = record.data.paymentPeriod;
            					var formWindow = $this.getStudentfeepayerinstallmentschedulewin();
            					if (!formWindow) {
            						Ext.widget('studentfeepayerinstallmentschedulewin');
            						formWindow = $this.getStudentfeepayerinstallmentschedulewin();
            					}
            					if(paymentPeriod=="INSTALLMENTS"){
            						var grid=formWindow.down('feepayerinstallmentschedulesgrid');
            						var gridColumns= grid.columns;
            						var gridColumnsLength=grid.columns.length;
            						 if(gridColumnsLength > 0){
                   	 					 for(var i = 0; i < gridColumnsLength; i++){
                   	 						 if(gridColumns[i].dataIndex=='dueDate'){
                   	 							 gridColumns[i].destroy();
                   	 						 }
                   	 					 }
            						 }
            						formWindow.show();
            						
            						var grid = $this.getFeepayerinstallmentschedulesgrid();
                					grid.getStore().getProxy().extraParams = {
                						skipMonths: '',
                						feeStageHeadConfigId:feeStageHeadConfigId,
                						paymentPeriod:paymentPeriod,
                 						isParent:true
            						};
                					grid.getStore().load();
            						
            					}
            					else{
            						formWindow.show();
            						var grid = $this.getFeepayerinstallmentschedulesgrid();
                					grid.getStore().getProxy().extraParams = {
                						skipMonths: '',
                						feeStageHeadConfigId:feeStageHeadConfigId,
                						paymentPeriod:paymentPeriod,
                 						isParent:true
            						};
                					grid.getStore().load();
            					}
            					/*formWindow.show();
            						var grid = $this.getFeepayerinstallmentschedulesgrid();
                					grid.getStore().getProxy().extraParams = {
                						skipMonths: '',
                						feeStageHeadConfigId:feeStageHeadConfigId,
                						paymentPeriod:paymentPeriod,
                 						isParent:true
            						};
                					grid.getStore().load();*/
        					}else{
        						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
        					}
        				}
        			}
                 }
                 
             }
         },
         'personcommonwindow[itemId=personCommonWindow] parentguardianform[itemId=studentParentGuardianForm] radiogroup#isAlumnusRadio':{
        	 change: function(obj){
        		 var form = obj.up('parentguardianform');
         		this.onChangeIsAlumnus(form);
         	}
         },
         'studentprofile personalinformationform[itemId=studentPersonalInformationForm] profiledocuploadform[itemId=studentDocUploadForm] filefield[itemId=documentFileUpload]': {
             change: function(fileField, value, eOpts) {
                 if (!isNullOrEmpty(value)) {
                     var $this = this;
                     value = value.replace('C:\\fakepath\\', '');
                     var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                     fileField.setRawValue(newValue);
                     var file = fileField.fileInputEl.dom.files[0];
                     var form = fileField.up().up();
                     var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                     var docDetails = form.down('#docDetails');
                         if ($this.isValidFileExtension(extension)) {
                             if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                 fileField.reset();
                                 showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                             } 
                         } else {
                             fileField.reset();
                             showWarningMessage(getPersonModuleTranslation('DOCUMENTS_DETAILS'), getPersonModuleTranslation('UPLOAD_VALID_FILE_ERROR_MSG'));
                         }
                 }
             }
         } ,
         'personalinformationform[itemId=studentPersonalInformationForm] radiogroup#stuPermanentResItemId':{
        	 change:function(obj,newValue,oldValue){
        		 var  $this = this;
        		 var form = obj.up('personalinformationform');
        		 var value = newValue.isPermanentResident;
        		 $this.SAValueValidationOnPersonalForm(form,value);
        		 
        	 }
  		 },
         'personalinformationform[itemId=studentPersonalInformationForm] radiogroup#stuAsylumSeekerItemId':{
        	 change:function(obj,newValue,oldValue){
  				var form = obj.up('personalinformationform');
  				 var value = newValue.isAsylumSeeker;
  				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
  				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
  				var diplomaticStatusId = form.down("#diplomaticStatusId");
  				var temporaryStudyId = form.down("#temporaryStudyId");
  				var workCriticalSkillsId = form.down("#workCriticalSkillsId");
  				var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
  				 if(!isNullOrEmpty(value)){
  				 if(value==true){
  					stuAreYouRefugeeItemId.items.items[0].setValue(false);
  					stuAreYouRefugeeItemId.items.items[1].setValue(true);
  					stuAreYouRefugeeItemId.setDisabled(true);
  					
  					stuPermanentResItemId.items.items[0].setValue(false);
  					stuPermanentResItemId.items.items[1].setValue(true);
  					stuPermanentResItemId.setDisabled(true);
  		
  					diplomaticStatusId.setDisabled(true);
  					temporaryStudyId.setDisabled(true);
  					workCriticalSkillsId.setDisabled(true);
  					postgraduateNonResidentialStudentId.setDisabled(true);
  				 }else{
  					stuAreYouRefugeeItemId.setDisabled(false);
  					stuPermanentResItemId.setDisabled(false);
  					diplomaticStatusId.setDisabled(false);
  					temporaryStudyId.setDisabled(false);
  					workCriticalSkillsId.setDisabled(false);
  					postgraduateNonResidentialStudentId.setDisabled(false);
  				 }
  				 }
  			 }
  		 },
         'personalinformationform[itemId=studentPersonalInformationForm] radiogroup#stuAreYouRefugeeItemId':{
        	 change:function(obj,newValue,oldValue){    
				 var form = obj.up('personalinformationform');
 				 var value = newValue.areYouRefugee;
 				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
 				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
 				var diplomaticStatusId = form.down("#diplomaticStatusId");
 				var temporaryStudyId = form.down("#temporaryStudyId");
 				var workCriticalSkillsId = form.down("#workCriticalSkillsId");
 				var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
 				 if(!isNullOrEmpty(value)){
 				 if(value==true){
 					stuAsylumSeekerItemId.items.items[0].setValue(false);
 					stuAsylumSeekerItemId.items.items[1].setValue(true);
 					stuAsylumSeekerItemId.setDisabled(true);
 					
 					stuPermanentResItemId.items.items[0].setValue(false);
 					stuPermanentResItemId.items.items[1].setValue(true);
 					stuPermanentResItemId.setDisabled(true);
 					
 					diplomaticStatusId.setDisabled(true);
 					temporaryStudyId.setDisabled(true);
 					workCriticalSkillsId.setDisabled(true);
 					postgraduateNonResidentialStudentId.setDisabled(true);
 				 }else{
 					stuAsylumSeekerItemId.setDisabled(false);
 					stuPermanentResItemId.setDisabled(false);
 					diplomaticStatusId.setDisabled(false);
 					temporaryStudyId.setDisabled(false);
 					workCriticalSkillsId.setDisabled(false);
 					postgraduateNonResidentialStudentId.setDisabled(false);
 				 }
 				 }
 			 }
  		 },
  		'personalinformationform[itemId=studentPersonalInformationForm] radiogroup#diplomaticStatusId':{
 			 change:function(obj,newValue,oldValue){    
 				 var form = obj.up('personalinformationform');
  				 var value = newValue.diplomaticStatus;
  				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
  				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
  				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
  				var temporaryStudyId = form.down("#temporaryStudyId");
  				var workCriticalSkillsId = form.down("#workCriticalSkillsId");
  				var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
  				 if(!isNullOrEmpty(value)){
  				 if(value==true){
  					stuAsylumSeekerItemId.items.items[0].setValue(false);
  					stuAsylumSeekerItemId.items.items[1].setValue(true);
  					stuAsylumSeekerItemId.setDisabled(true);
  					
  					stuPermanentResItemId.items.items[0].setValue(false);
  					stuPermanentResItemId.items.items[1].setValue(true);
  					stuPermanentResItemId.setDisabled(true);
  					
  					stuAreYouRefugeeItemId.items.items[0].setValue(false);
  					stuAreYouRefugeeItemId.items.items[1].setValue(true);
  					stuAreYouRefugeeItemId.setDisabled(true);
  					
  					temporaryStudyId.setDisabled(true);
  					workCriticalSkillsId.setDisabled(true);
  					postgraduateNonResidentialStudentId.setDisabled(true);
  				 }else{
  					stuAsylumSeekerItemId.setDisabled(false);
  					stuPermanentResItemId.setDisabled(false);
  					stuAreYouRefugeeItemId.setDisabled(false);
  					temporaryStudyId.setDisabled(false);
  					workCriticalSkillsId.setDisabled(false);
  					postgraduateNonResidentialStudentId.setDisabled(false);
  				 }
  				 }
  			 }
  		 },
  		 'personalinformationform[itemId=studentPersonalInformationForm] radiogroup#temporaryStudyId':{
     			 change:function(obj,newValue,oldValue){    
     				 var form = obj.up('personalinformationform');
      				 var value = newValue.temporaryStudy;
      				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
      				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
      				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
      				 var diplomaticStatusId = form.down("#diplomaticStatusId");
      				 var workCriticalSkillsId = form.down("#workCriticalSkillsId");
      				 var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
      				 if(!isNullOrEmpty(value)){
      				 if(value==true){
      					stuAsylumSeekerItemId.items.items[0].setValue(false);
      					stuAsylumSeekerItemId.items.items[1].setValue(true);
      					stuAsylumSeekerItemId.setDisabled(true);
      					
      					stuPermanentResItemId.items.items[0].setValue(false);
      					stuPermanentResItemId.items.items[1].setValue(true);
      					stuPermanentResItemId.setDisabled(true);
      					
      					stuAreYouRefugeeItemId.items.items[0].setValue(false);
      					stuAreYouRefugeeItemId.items.items[1].setValue(true);
      					stuAreYouRefugeeItemId.setDisabled(true);
      					
      					diplomaticStatusId.setDisabled(true);
      					workCriticalSkillsId.setDisabled(true);
      					postgraduateNonResidentialStudentId.setDisabled(true);
      				 }else{
      					stuAsylumSeekerItemId.setDisabled(false);
      					stuPermanentResItemId.setDisabled(false);
      					stuAreYouRefugeeItemId.setDisabled(false);
      					diplomaticStatusId.setDisabled(false);
      					workCriticalSkillsId.setDisabled(false);
      					postgraduateNonResidentialStudentId.setDisabled(false);
      				 }
      				 }
      			 }
      		 },
      		 'personalinformationform[itemId=studentPersonalInformationForm] radiogroup#workCriticalSkillsId':{
         			 change:function(obj,newValue,oldValue){    
         				 var form = obj.up('personalinformationform');
          				 var value = newValue.workCriticalSkills;
          				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
          				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
          				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
          				 var diplomaticStatusId = form.down("#diplomaticStatusId");
          				 var temporaryStudyId = form.down("#temporaryStudyId");
          				 var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
          				 if(!isNullOrEmpty(value)){
          				 if(value==true){
          					stuAsylumSeekerItemId.items.items[0].setValue(false);
          					stuAsylumSeekerItemId.items.items[1].setValue(true);
          					stuAsylumSeekerItemId.setDisabled(true);
          					
          					stuPermanentResItemId.items.items[0].setValue(false);
          					stuPermanentResItemId.items.items[1].setValue(true);
          					stuPermanentResItemId.setDisabled(true);
          					
          					stuAreYouRefugeeItemId.items.items[0].setValue(false);
          					stuAreYouRefugeeItemId.items.items[1].setValue(true);
          					stuAreYouRefugeeItemId.setDisabled(true);
          					
          					diplomaticStatusId.setDisabled(true);
          					temporaryStudyId.setDisabled(true);
          					postgraduateNonResidentialStudentId.setDisabled(true);
          				 }else{
          					stuAsylumSeekerItemId.setDisabled(false);
          					stuPermanentResItemId.setDisabled(false);
          					stuAreYouRefugeeItemId.setDisabled(false);
          					diplomaticStatusId.setDisabled(false);
          					temporaryStudyId.setDisabled(false);
          					postgraduateNonResidentialStudentId.setDisabled(false);
          				 }
          				 }
          			 }
          		 },
          		 'personalinformationform[itemId=studentPersonalInformationForm] radiogroup#postgraduateNonResidentialStudentId':{
             			 change:function(obj,newValue,oldValue){    
             				 var form = obj.up('personalinformationform');
              				 var value = newValue.postgraduateNonResidentialStudent;
              				 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
              				 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
              				 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
              				 var diplomaticStatusId = form.down("#diplomaticStatusId");
              				 var workCriticalSkillsId = form.down("#workCriticalSkillsId");
              				 var temporaryStudyId = form.down("#temporaryStudyId");
              				 if(!isNullOrEmpty(value)){
              				 if(value==true){
              					stuAsylumSeekerItemId.items.items[0].setValue(false);
              					stuAsylumSeekerItemId.items.items[1].setValue(true);
              					stuAsylumSeekerItemId.setDisabled(true);
              					
              					stuPermanentResItemId.items.items[0].setValue(false);
              					stuPermanentResItemId.items.items[1].setValue(true);
              					stuPermanentResItemId.setDisabled(true);
              					
              					stuAreYouRefugeeItemId.items.items[0].setValue(false);
              					stuAreYouRefugeeItemId.items.items[1].setValue(true);
              					stuAreYouRefugeeItemId.setDisabled(true);
              					
              					diplomaticStatusId.setDisabled(true);
              					workCriticalSkillsId.setDisabled(true);
              					temporaryStudyId.setDisabled(true);
              				 }else{
              					stuAsylumSeekerItemId.setDisabled(false);
              					stuPermanentResItemId.setDisabled(false);
              					stuAreYouRefugeeItemId.setDisabled(false);
              					diplomaticStatusId.setDisabled(false);
              					workCriticalSkillsId.setDisabled(false);
              					temporaryStudyId.setDisabled(false);
              				 }
              				 }
              			 }
              		 },
       
         'studentprofile personalinformationform[itemId=studentPersonalInformationForm] nestedJsonCombo#nationalityCombo':{
        	 select: function(combo, record) {
        		 var form = combo.up('personalinformationform');
        		 var newValue = record[0].data.code;
        		 var stuSecondaryCitizenshipCombo = form.down("#stuSecondaryCitizenshipItemId");
        		 var stuSecondaryCitizenshipComboCode = stuSecondaryCitizenshipCombo.getStore().findRecord('value',stuSecondaryCitizenshipCombo.getRawValue());
        		 var stuSecondaryCitizenshipValue=null;
        		 if(!isNullOrEmpty(stuSecondaryCitizenshipComboCode)){
        			 stuSecondaryCitizenshipValue = stuSecondaryCitizenshipComboCode.data.code; 
        		 }
        		 var idTypeCombo = form.down("#idTypeCombo");
        		 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
        		 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
        		 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
        		 if(newValue=='South African' || stuSecondaryCitizenshipValue =='South African'){
        			 stuPermanentResItemId.items.items[0].setValue(false);
        			 stuPermanentResItemId.items.items[1].setValue(false);
        			 stuPermanentResItemId.setDisabled(true);
        			 stuAsylumSeekerItemId.items.items[0].setValue(false);
        			 stuAsylumSeekerItemId.items.items[1].setValue(false);
        			 stuAsylumSeekerItemId.setDisabled(true);
        			 stuAreYouRefugeeItemId.items.items[0].setValue(false);
        			 stuAreYouRefugeeItemId.items.items[1].setValue(false);
        			 stuAreYouRefugeeItemId.setDisabled(true);
        			 idTypeCombo.getStore().load({
        				 callback: function(records, operation, success) {
  						   for(var i in records){
  							   if(!isNullOrEmpty(records[i].data.idTypeCode)){
  								   if(records[i].data.idTypeCode=='NATIONAL_ID'){
  									 idTypeCombo.setValue(records[i].data.id);
  									   idTypeCombo.setReadOnly(true);
  									   return false;
  								   }else{
  									 idTypeCombo.setReadOnly(false); 
  									idTypeCombo.reset();
  								   } 
  							   }
  						   }
  					   }
        			 })
        		 }else{
        			 stuPermanentResItemId.setDisabled(false);
        			 stuAsylumSeekerItemId.setDisabled(false);
        			 stuAreYouRefugeeItemId.setDisabled(false);
        			 idTypeCombo.setReadOnly(false); 
					 idTypeCombo.reset();
        		 }
        	 }
  		 } ,
         'studentprofile personalinformationform[itemId=studentPersonalInformationForm] nestedJsonCombo#stuSecondaryCitizenshipItemId':{
        	 select: function(combo, record) {
        		 var form = combo.up('personalinformationform');
        		 var newValue = record[0].data.code;
        		 var nationalityCombo = form.down("#nationalityCombo");
        		 var nationalityComboCode = nationalityCombo.getStore().findRecord('value',nationalityCombo.getRawValue());
        		 var nationalityValue=null;
        		 if(!isNullOrEmpty(nationalityComboCode)){
        			  nationalityValue = nationalityComboCode.data.code; 
        		 }
        		 var idTypeCombo = form.down("#idTypeCombo");
        		 var stuPermanentResItemId = form.down("#stuPermanentResItemId");
        		 var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
        		 var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
        		 if(newValue=='South African' || nationalityValue == 'South African'){
        			 stuPermanentResItemId.items.items[0].setValue(false);
        			 stuPermanentResItemId.items.items[1].setValue(false);
        			 stuPermanentResItemId.setDisabled(true);
        			 stuAsylumSeekerItemId.items.items[0].setValue(false);
        			 stuAsylumSeekerItemId.items.items[1].setValue(false);
        			 stuAsylumSeekerItemId.setDisabled(true);
        			 stuAreYouRefugeeItemId.items.items[0].setValue(false);
        			 stuAreYouRefugeeItemId.items.items[1].setValue(false);
        			 stuAreYouRefugeeItemId.setDisabled(true);
        			 idTypeCombo.getStore().load({
        				 callback: function(records, operation, success) {
  						   for(var i in records){
  							   if(!isNullOrEmpty(records[i].data.idTypeCode)){
  								   if(records[i].data.idTypeCode=='NATIONAL_ID'){
  									 idTypeCombo.setValue(records[i].data.id);
  									   idTypeCombo.setReadOnly(true);
  									   return false;
  								   }else{
  									 idTypeCombo.setReadOnly(false); 
  									idTypeCombo.reset();
  								   } 
  							   }
  						   }
  					   }
        			 })
        		 }else{
        			 stuPermanentResItemId.setDisabled(false);
        			 stuAsylumSeekerItemId.setDisabled(false);
        			 stuAreYouRefugeeItemId.setDisabled(false);
        			 idTypeCombo.setReadOnly(false); 
					 idTypeCombo.reset();
        		 }
        	 }
      },
         
         'ssodetailsgrid[itemId=studentssodetailsgridItemId]': {
        	 render: function(grid) {
        		 var $this = this;
        		 var portalId = this.getCurrentLoggedPortalId();
        		 if (portalId == 7) {
        			 $this.loadSSOGridData('#studentssodetailsgridItemId',null,$this.getPARENT_PORTAL_SSO_DETAILS_PERMISSIONS());
        		 } else if (portalId == 2) {
        			 $this.loadSSOGridData('#studentssodetailsgridItemId',null,$this.getFACULTY_PORTAL_STUDENT_PROFILE_SSO_DETAILS_PERMISSIONS());
        		 } else if (portalId == 3) {
        			 $this.loadSSOGridData('#studentssodetailsgridItemId',null,$this.getSTUDENT_PORTAL_SSO_DETAILS_PERMISSIONS());
        		 } else {
        			 $this.loadSSOGridData('#studentssodetailsgridItemId',null,$this.getSTUDENT_SSO_DETAILS_PERMISSIONS());
        		 }
        	 },
        	 cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        		 var $this = this;
        		 var grid = this.getStudentssodetailsgrid();
        		 var columnName = grid.columnManager.columns[cellIndex].dataIndex;
        		 var portalId = this.getCurrentLoggedPortalId();
        		 if (e.target.tagName == 'DIV') {
        			 if (columnName == "addButton") {
        				 if (e.target.className == "addButtonClsForGridActionCls") {
        					 this.addNewRowInSSOGrid('#studentssodetailsgridItemId');
        				 }
        			 } else if (columnName == "deleteButton") {//
        				 if (e.target.className == "deleteButtonClsForGridActionCls") {
        					 if (portalId == 7) {
        						 this.deleteRowInSSOGrid('#studentssodetailsgridItemId',record,rowIndex,null,$this.getPARENT_PORTAL_SSO_DETAILS_PERMISSIONS());
        					 } else if (portalId == 2) {
        						 this.deleteRowInSSOGrid('#studentssodetailsgridItemId',record,rowIndex,null,$this.getFACULTY_PORTAL_STUDENT_PROFILE_SSO_DETAILS_PERMISSIONS());
        					 } else if (portalId == 3) {
        						 this.deleteRowInSSOGrid('#studentssodetailsgridItemId',record,rowIndex,null,$this.getSTUDENT_PORTAL_SSO_DETAILS_PERMISSIONS());
        					 } else {
        						 this.deleteRowInSSOGrid('#studentssodetailsgridItemId',record,rowIndex,null,$this.getSTUDENT_SSO_DETAILS_PERMISSIONS());
        					 }
        				 }
        			 }
        			 else{
        				 grid.down('#btnSaveItemId').setDisabled(false);
        			 }
        		 }
        	 }
         },
        'ssodetailsgrid[itemId=studentssodetailsgridItemId] button[itemId=btnSaveItemId]': {
        	click: function() {
        		this.saveSSOGridData('#studentssodetailsgridItemId');
    
        	} 
        },
        'ssodetailsgrid[itemId=studentssodetailsgridItemId] button[itemId=btnAddSSO]': {
        	click: function() {
        		this.addNewRowInSSOGrid('#studentssodetailsgridItemId');
        	}
        },
        'parentguardiancardtpl button[itemId=sso_PG_ItemId]':{
        	click: function(btn){
        		var this$ = this;
        		var gridItemId = '#studentParentGuardianGrid';
        		var personProfile = this$.getContentPanelActiveTab();
        		var grid = personProfile.down(gridItemId);
        		var gridStore = grid.getStore();
        		var storeDataIndex = btn.up('parentguardiancardtpl').storeDataIndex;
        		var records = gridStore.getAt(storeDataIndex);

        		var parentguardiangrid = this$.getContentPanel().getActiveTab().down('parentguardiangrid');
            	var gridRec=parentguardiangrid.getSelectionModel().getSelection()[0];
            	if(!Ext.isDefined(gridRec)){
            		var gridRec=parentguardiangrid.getStore().getAt(storeDataIndex);
            	}
            	
        		var ssodetailswinItemId ="ssodetailswinId";
        		var ssoDetailsWin = Ext.widget('ssodetailswin', {
        			itemId: ssodetailswinItemId,
        			storeDataIndex: storeDataIndex,
        			userId:gridRec.data.userId
        		});
        		ssoDetailsWin.show();
        		var portalId = this.getCurrentLoggedPortalId();
        		if (portalId == 2) {
        			this$.loadSSOGridData('#ssoDetailsGridWinItemId', ssoDetailsWin, this$.getFACULTY_PORTAL_STUDENT_PROFILE_PARENT_SSO_DETAILS_PERMISSIONS());
        		} else {
        			this$.loadSSOGridData('#ssoDetailsGridWinItemId', ssoDetailsWin, this$.getSTUDENT_PARENT_SSO_DETAILS_PERMISSIONS());
        		}
        	}
        },
        'ssodetailswin[itemId=ssodetailswinId] ssodetailsgrid[itemId=ssoDetailsGridWinItemId] button[itemId=btnAddSSO]': {
        	click: function() {
        		var ssodetailswin = this.getSsodetailswin();
        		this.addNewRowInSSOGrid('#ssoDetailsGridWinItemId',ssodetailswin);
        	}
        },
        'ssodetailswin[itemId=ssodetailswinId] ssodetailsgrid[itemId=ssoDetailsGridWinItemId]': {
        	cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
        		var $this = this;
        		var ssodetailswin = this.getSsodetailswin();
        		var grid = ssodetailswin.down('#ssoDetailsGridWinItemId');
        		var columnName = grid.columnManager.columns[cellIndex].dataIndex;
        		var portalId = this.getCurrentLoggedPortalId();
        		if (e.target.tagName == 'DIV') {
        			if (columnName == "addButton") {
        				if (e.target.className == "addButtonClsForGridActionCls") {
        					this.addNewRowInSSOGrid('#ssoDetailsGridWinItemId',ssodetailswin);
        				}
        			} else if (columnName == "deleteButton") {//
        				if (e.target.className == "deleteButtonClsForGridActionCls") {
        					if (portalId == 2) {
        						this.deleteRowInSSOGrid('#ssoDetailsGridWinItemId',record,rowIndex,ssodetailswin, $this.getFACULTY_PORTAL_STUDENT_PROFILE_PARENT_SSO_DETAILS_PERMISSIONS());
        					}
        					else{
        						this.deleteRowInSSOGrid('#ssoDetailsGridWinItemId',record,rowIndex,ssodetailswin, $this.getSTUDENT_PARENT_SSO_DETAILS_PERMISSIONS());
        					}
        				}
        			}
        			else{
        				grid.down('#btnSaveItemId').setDisabled(false);
        			}
        		}
        	}
        },
        'ssodetailswin[itemId=ssodetailswinId] ssodetailsgrid[itemId=ssoDetailsGridWinItemId] button[itemId=btnSaveItemId]': {
        	click: function() {
        		var ssodetailswin = this.getSsodetailswin();
        		this.saveSSOGridData('#ssoDetailsGridWinItemId',ssodetailswin);
        	} 
        },
        'medicaldetailsform[itemId=medicaldetailsformparent] displayfield[itemId=availableDocumentLabelItemId]': {
          	  render: function(component) {
          		  var $this = this;
          		  component.getEl().on('click', function(e) {
          			  if (e.target.tagName == "A" || e.target.tagName == "DIV" || e.target.tagName=="B") {
          				  var parentMedicalForm = $this.getMedicaldetailsformparent();
          				  if (parentMedicalForm) {
          					  var documentId = parentMedicalForm.down('#documentIdItemId').getValue();
          					  if (!isNullOrEmpty(documentId)) {
          						  $this.getDocumentController().downloadDocumentFile(documentId);
          					  }
          				  }
          			  }
          		  });
					var medFrom = $this.getMedicaldetailsformparent();
					medFrom.down('#medicalDetailNextButtonId').setDisabled(false);
          	  },
		afterrender:function(obj){
				var $this = this;
          	  }	
		    },
            'feepayerdetailsformparent displayfield[itemId=availableDocumentLabelItemId]': {
            	  render: function(component) {
            		  var $this = this;
            		  component.getEl().on('click', function(e) {
            			  if (e.target.tagName == "A"  || e.target.tagName == "DIV") {
            				  var parentFeePayerForm = $this.getFeepayerdetailsformparent();
            				  var encryptedDocId = $this.feePayerEncryptedDocId;
            				  if (parentFeePayerForm) {
            					//  var documentId = parentFeePayerForm.down('#documentIdItemId').getValue();
            					  if (!isNullOrEmpty(encryptedDocId)) {
            						  $this.getDocumentController().downloadDocumentFile(encryptedDocId);
            					  }
            				  }
            			  }
            		  });
            	  }
              },
              'feepayerdetailsformparent radiogroup[itemId=empOfTheOrgItemId]': {
            	/*afterrender: function(radio) {
                	var $this = this;
                	var form = radio.up('feepayerdetailsformparent');              	
                	
                	var empOfTheOrg = form.down("#empOfTheOrgItemId");
                	var employeeId = form.down("#employeeIdItemId");
                	var status = empOfTheOrg.getValue().employeeOfOrganization;
                	var checkEmployeeIdDfr = false;
                	checkEmployeeIdDfr = $this.checkEmployeeIdDfr(empOfTheOrg,employeeId);
               // 	if(checkEmployeeIdDfr==false) {
                	
                	 setTimeout(function(){
                		 var empOfTheOrg = form.down("#empOfTheOrgItemId");
                     	var employeeId = form.down("#employeeIdItemId");
                     	var status = empOfTheOrg.getValue().employeeOfOrganization;

                		 if(status==true) {
                 			employeeId.setVisible(true);
                 		}
                 		else {
                 			if(isNullOrEmpty(employeeId.getValue())){
                 			employeeId.reset();
                 			employeeId.setVisible(false);
                 			}
                 		}
                	 },300);
                	
                //	}
                	form.getForm().checkValidity();
                },*/
            	  change: function(radio, newValue, oldVaue) { 
            		  var $this = this;
            		  var form = $this.getFeepayerdetailsformparent();

            		  var empOfTheOrg = form.down("#empOfTheOrgItemId");
            		  var employeeId = form.down("#employeeIdItemId");
            		  var mode = null;
            		  if(!isNullOrEmpty(newValue)){
            			  mode = newValue;
            		  }else{
            			  mode = form.down('#empOfTheOrgItemId').getValue();
            		  }
            		  employeeId.reset();
            		  if(mode.employeeOfOrganization==false){
            			  employeeId.setVisible(false);
            			  $this.setAllowBlank(employeeId, true);
            			  //form.down('#feePayerDetailNextButon').setDisabled(false);
            		  }else{
            			  employeeId.setVisible(true);
            			  var response = $this.reRegfeePayerDataDFR;
            			  if( Object.keys(response).length > 0 ){
            				  response.feepayerdetailsformparent.forEach(function(rec){
            					  fieldCmp = form.down('#'+rec.formFieldId);
            					  if(!fieldCmp){
            						  fieldCmp = formFields.findField(rec.formFieldName);
            					  }
            					  if(fieldCmp){
            						  if(rec.formFieldId == 'employeeIdItemId'){
            							  if(rec.isVisible){
            								  $this.setAllowBlank(fieldCmp, !rec.isMandatory);
            							  }else{
            								  $this.setAllowBlank(fieldCmp, true);
            							  }
            							  fieldCmp.setVisible(rec.isVisible);
            						  }
            						  $this.removeDoubleColon(fieldCmp,rec.formFieldLabel);
            					  }
            				  });
            			  }
            		  }
            		  form.getForm().checkValidity();
            	  }
            },
            'feepayerdetailsformparent customcombobox[itemId=bankItemId]': {
            	render: function(combo) {
            		combo.getStore().load();
            	},
            	select: function(combo, record) { 
            		var branchCodeField = combo.up('form').down('customcombobox#branchCodeItemId');
            		var branchCodeStore = branchCodeField.getStore();
            		var selectedBankId=record[0].data.id;             	
            		branchCodeStore.getProxy().extraParams = {
            			bankId: selectedBankId
            		};    	            
                    form = combo.up('form').getForm();
            		branchCodeStore.load({
            			callback: function(records, operation, success) {
            				if (success) {
            					if(records.length == 1){
            						branchCodeField.setValue(records[0].data.id);
            						form.checkValidity();
            					}
            				}
            			}
            		});
            	}, 
            	change: function(combo, newValue) {
            		var branchCodeField = combo.up('form').down('customcombobox#branchCodeItemId');
            		if(!isNullOrEmpty(newValue)){
            			branchCodeField.setDisabled(false);	
            		}else{
            			branchCodeField.setDisabled(true);
            		}      	
            	}
            },
            'feepayerdetailsformparent combo#countryId': {
                select: function(combo, record) {
                	var newValue=record[0].data.id;
                	var regionComboBox = combo.up('form').down('customcombobox#parentCountryRegionId');                	
                	var cityComboBox = combo.up('form').down('customcombobox#cityId');
                    cityComboBox.setDisabled(false);
                    regionComboBox.setDisabled(false);
                    this.onCountryChange(combo, record, combo.up('form'));
                },
                change: function(combo, newValue) {
                	var regionComboBox = combo.up('form').down('customcombobox#parentCountryRegionId');
                	var cityComboBox = combo.up('form').down('customcombobox#cityId');
                	if(!isNullOrEmpty(newValue)){
                		regionComboBox.setDisabled(false);	
                		cityComboBox.setDisabled(false);
                	}else{
                		regionComboBox.setDisabled(true);
                		cityComboBox.setDisabled(true);
                	}
                }
            },
            'feepayerdetailsformparent customcombobox#parentCountryRegionId': {
            	 select: function(obj1, record) {
                     var cityComboBox = obj1.up('form').down('customcombobox#cityId');
                     var countryComboBox = obj1.up('form').down('customcombobox#countryId');
                     cityComboBox.setDisabled(false);
                     cityComboBox.reset();
                     
                     var countryRegionIdVal = record[0].get("id");
                     var countryIdVal = countryComboBox.getValue();
                     var cityStore = cityComboBox.getStore();
                     cityStore.getProxy().extraParams = {
                    	 countryId: countryIdVal,
                    	 countryRegionId: countryRegionIdVal
                     };
                     cityStore.reload();
                 },
                 change: function(obj1, newValue) {
                 	 var cityComboBox = obj1.up('form').down('customcombobox#cityId');
                 	 if(!isNullOrEmpty(newValue)){
                      cityComboBox.setDisabled(false);
                 	 }else{
                 		 cityComboBox.setDisabled(true); 
                 	 }
                 }
            },
            'feepayerdetailsformparent checkboxfield#isSameAsCurrentAddress': {
         	   change: function(obj,newValue,oldValue) {
          		   var form = obj.up('form');          		  
          		   
          		   if(newValue || newValue == true){             			   
          			  this.getPersonCurrentAddressDetail(form,SERVERURL.PERSON_CURRENT_ADDRESS,true);          			  
          		   } 
          		   else{
          			  this.getPersonCurrentAddressDetail(form,SERVERURL.PERSON_CURRENT_ADDRESS,false);               			 
          		   }
                 }
         	
         },
            'feepayerdetailsformparent radiogroup[itemId=payerTypeItemId]': {
                change: function(cb, nv, ov) {
                	var $this = this;
                	var form = cb.up('feepayerdetailsformparent');

                	var salutationItemId = form.down("#salutationItemId");
                	var firstNameItemId = form.down("#firstNameItemId");
                	var middleNameItemId = form.down("#middleNameItemId");
                	var lastNameItemId = form.down("#lastNameItemId");
                	var companyNameItemId = form.down("#companyNameItemId");
                	var contactPersonItemId = form.down("#contactPersonItemId");
                	var doesFeePayerConsentToCreditCheckLabelItemId = form.down("#doesFeePayerConsentToCreditCheckLabelItemId");
                	var doesFeePayerConsentToCreditCheckItemId = form.down("#doesFeePayerConsentToCreditCheckItemId");
                	var homeTelephoneCountryCodeItemId = form.down("#homeTelephoneCountryCodeItemId");
                	var homeTelephoneItemId = form.down("#homeTelephoneItemId");
                	var workTelephoneCountryCodeItemId = form.down("#workTelephoneCountryCodeItemId");
                	var workTelephoneItemId = form.down("#workTelephoneItemId");
                	var countryCodeItemId = form.down("#countryCodeItemId");
                	var mobileNumberItemId = form.down("#mobileNumberItemId");

                	var emailHomeItemId = form.down("#emailHomeItemId");
                	var emailWorkItemId = form.down("#emailWorkItemId");
                	var emailHomeUseForCommunicationItemId = form.down("#emailHomeUseForCommunicationItemId");
                	var emailWorkUseForCommunicationItemId = form.down("#emailWorkUseForCommunicationItemId");
                	var feePayerIDItemId = form.down("#feePayerIDItemId");
                	var feePayerLatestPayslipItemId = form.down("#feePayerLatestPayslipItemId");
                	var documentViewLinkItemId = form.down('#availableDocumentLabelItemId');
                	var feePayerProofOfAccountItemId = form.down("#feePayerProofOfAccountItemId");
                	var nationalAlternateIdItemId = form.down("#nationalAlternateIdItemId");
                	var companyAddressContainerItemId = form.down("#companyAddressContainerItemId");
                	var empOfTheOrgContainerItemId = form.down("#empOfTheOrgContainerItemId");
                	var surnameItemId = form.down("#surnameItemId");
                	
                	var corporateId = form.down("#corporateId");
                	var employeeIdItemId = form.down("#employeeIdItemId");
                	var nationalAlternateIdItemId = form.down("#nationalAlternateIdItemId");
                	var nationalAlternateIdContainer = form.down("#nationalAlternateIdContainer");
                	var homeTelephoneContainerItemId = form.down("#homeTelephoneContainerItemId");
                	
                	var emailHomeContainerItemId = form.down("#emailHomeContainerItemId");

                	if (nv.payerType == 'PERSON') {
                	    salutationItemId.setVisible(true);
                	    this.setAllowBlank(salutationItemId, false);
                	    firstNameItemId.setVisible(true);
                	    this.setAllowBlank(firstNameItemId, false);
                	    middleNameItemId.setVisible(true);
                	    lastNameItemId.setVisible(true);
                	    this.setAllowBlank(lastNameItemId, false);
                	    homeTelephoneContainerItemId.setVisible(true);
                	    //this.setAllowBlank(homeTelephoneContainerItemId, false);
                	    emailHomeContainerItemId.setVisible(true);
                	    
                	 //   corporateId.setVisible(false);

                	    this.setAllowBlank(emailHomeItemId, false);
                	    feePayerIDItemId.setVisible(true);
                	    this.setAllowBlank(feePayerIDItemId, false);
                	    feePayerLatestPayslipItemId.setVisible(true);
                	    documentViewLinkItemId.setVisible(true);
                	    
                	    empOfTheOrgContainerItemId.setVisible(true);
                	    nationalAlternateIdContainer.setVisible(true);

                	    companyNameItemId.setVisible(false);
                	    this.setAllowBlank(companyNameItemId, true);
                	    
                	    contactPersonItemId.setVisible(false);
                	    this.setAllowBlank(contactPersonItemId, true);
                	    surnameItemId.setVisible(false);
                	    corporateId.setVisible(false);
                	    
                	    companyAddressContainerItemId.setVisible(false);

                	    salutationItemId.reset();
                	    firstNameItemId.reset();
                	    middleNameItemId.reset();
                	    lastNameItemId.reset();
                	    companyNameItemId.reset();
                	    contactPersonItemId.reset();
                	    surnameItemId.reset();
                	    doesFeePayerConsentToCreditCheckItemId.reset();
                	    homeTelephoneCountryCodeItemId.reset();
                	    homeTelephoneItemId.reset();
                	    countryCodeItemId.reset();
                	    mobileNumberItemId.reset();
                	    emailHomeItemId.reset();
                	    emailHomeUseForCommunicationItemId.reset();
                	    emailWorkUseForCommunicationItemId.reset();
                	    workTelephoneCountryCodeItemId.reset();
                	    workTelephoneItemId.reset();
                	    feePayerIDItemId.reset();
                	    feePayerLatestPayslipItemId.reset();
                	    //feePayerProofOfAccountItemId.reset();
                	    
                        Ext.Ajax.request({
                  		  type: 'rest',
                  		  url: SERVERURL.DEFAULT_COUNTRY_CODE_BY_ACADEMY_LOCATION,
                  		  method: 'GET',
                  		  success: function(response, action) {
                  			  var MSSG = response.responseText;
                  			  var jdata = Ext.decode(response.responseText);
                  			  var defaultCountryId = -1;
                  			  if(!isNullOrEmpty(jdata.id)){
                  				  defaultCountryId = jdata.id; 
                  			  }
          					 var homeTelephoneCountryCode=form.down('#homeTelephoneCountryCodeItemId');
          					 if(isNullOrEmpty(homeTelephoneCountryCode.getValue())){
          					 homeTelephoneCountryCode.getStore().load({
              					  callback: function(records, operation, success) {
              						  if (success) {
              							  for(i in records){
              								  if(defaultCountryId == -1){
              									  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
              										  homeTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
                  								  } 
              								  }else{
              									  if(records[i].data.id == defaultCountryId){
              										  homeTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
                  								  }
              								  }
              							  }
              						  }
              					  }
              				  });
                  		  }
          					 
          					 var workTelephoneCountryCode=form.down('#workTelephoneCountryCodeItemId');
          					 if(isNullOrEmpty(workTelephoneCountryCode.getValue())){
          					 workTelephoneCountryCode.getStore().load({
              					  callback: function(records, operation, success) {
              						  if (success) {
              							  for(i in records){
              								  if(defaultCountryId == -1){
              									  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
              										  workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
                  								  } 
              								  }else{
              									  if(records[i].data.id == defaultCountryId){
              										  workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
                  								  }
              								  }
              							  }
              						  }
              					  }
              				  });
                  		  }
          					 
          					 var countryCode=form.down('#countryCodeItemId');
          					 if(isNullOrEmpty(countryCode.getValue())){
          					 countryCode.getStore().load({
              					  callback: function(records, operation, success) {
              						  if (success) {
              							  for(i in records){
              								  if(defaultCountryId == -1){
              									  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
              										  countryCode.setValue(records[i].data.isdCode);  									  
                  								  } 
              								  }else{
              									  if(records[i].data.id == defaultCountryId){
              										  countryCode.setValue(records[i].data.isdCode);  									  
                  								  }
              								  }
              							  }
              						  }
              					  }
              				  });
                  		   }
                  		  }
      				  });
                        
                        
                       /* var academyLocationId = this.getCurrentAcademyLocation();
                    	
                        var newMandatoryFields = ['employeeIdItemId','nationalAlternateIdItemId'];
                    	
                        Ext.Ajax.request({
	                		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	                		method: 'GET',
	                		async: false,
	                		params: {
	                			academyLocationId:academyLocationId,
	                			languageCode:'en'
	                		},
	                		success: function(response) {
	                			var json = JSON.parse(response.responseText);
	                			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
	                			fieldInfo.set("formFieldsInfo", json);
	                			//console.log(json);
	                			if( !isNullOrEmpty(json) ){
	                				if( !isNullOrEmpty(json.feepayerdetailform) ){
	                					var feePayerDetailDFRConfig = json.feepayerdetailform;
	                					for( i in feePayerDetailDFRConfig){
	                						var fieldConfig = feePayerDetailDFRConfig[i];
	                						//console.log(fieldConfig);
	                						if( newMandatoryFields.includes(fieldConfig.formFieldId) ){
	                							if( fieldConfig.isMandatory ){
	                								var currentField = form.down("#"+fieldConfig.formFieldId);
	                								$this.setAllowBlank(currentField, false);
	                								var currentFieldLabel = fieldConfig.formFieldLabel;
	                								currentField.setFieldLabel(currentFieldLabel);
	                							}
	                						}
	                					}
	                				}
	                			}
	                		}
	                	});*/
                	    

                	   /* workTelephoneCountryCodeItemId.setFieldLabel(getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'));
                	    workTelephoneItemId.setFieldLabel(getPersonModuleTranslation('FPD_WORK_TELEPHONE'));
                	    emailWorkItemId.setFieldLabel(getPersonModuleTranslation('FPD_EMAIL_WORK'));*/
                	} else {
                	    salutationItemId.setVisible(false);
                	    this.setAllowBlank(salutationItemId, true);
                	    firstNameItemId.setVisible(false);
                	    this.setAllowBlank(firstNameItemId, true);
                	    middleNameItemId.setVisible(false);
                	    lastNameItemId.setVisible(false);
                	    this.setAllowBlank(lastNameItemId, true);
                	    employeeIdItemId.setVisible(false);
                	    this.setAllowBlank(employeeIdItemId, true);
                	    nationalAlternateIdContainer.setVisible(false);
                	    this.setAllowBlank(nationalAlternateIdItemId, true);
                	    homeTelephoneContainerItemId.setVisible(false);
                	    this.setAllowBlank(homeTelephoneCountryCodeItemId, true);
                	    this.setAllowBlank(homeTelephoneItemId, true);
                	    emailHomeContainerItemId.setVisible(false);
                	    this.setAllowBlank(emailHomeContainerItemId, true);
                	    this.setAllowBlank(emailHomeItemId, true);
                	    empOfTheOrgContainerItemId.setVisible(false);
                	    feePayerIDItemId.setVisible(false);
                	    documentViewLinkItemId.setVisible(false);
                	    feePayerLatestPayslipItemId.setVisible(false);
                	    
                	    setTimeout(function(){
                	    	$this.setAllowBlank(feePayerIDItemId, true);
                	    	$this.setAllowBlank(feePayerLatestPayslipItemId, true);
                	    },300);
                	    
                	    companyNameItemId.setVisible(true);
                	    contactPersonItemId.setVisible(true);
                	    surnameItemId.setVisible(true);
                	    corporateId.setVisible(true);
                	    companyAddressContainerItemId.setVisible(true);
                	    
                	   /* if(feePayerProofOfAccountItemId != null){
                	    	feePayerProofOfAccountItemId.setVisible(false);
                    	    feePayerProofOfAccountItemId.setDisabled(true);
                    	    this.setAllowBlank(feePayerProofOfAccountItemId, true);
                    	    feePayerProofOfAccountItemId.reset();
                	    }*/
                	    
                	    emailWorkUseForCommunicationItemId.setFieldStyle('left: 0px;');

                	    this.setAllowBlank(doesFeePayerConsentToCreditCheckItemId, true);

                	    salutationItemId.reset();
                	    firstNameItemId.reset();
                	    middleNameItemId.reset();
                	    lastNameItemId.reset();
                	    companyNameItemId.reset();
                	    contactPersonItemId.reset();
                	    doesFeePayerConsentToCreditCheckItemId.reset();
                	    homeTelephoneCountryCodeItemId.reset();
                	    homeTelephoneItemId.reset();
                	    //countryCodeItemId.reset();
                	    mobileNumberItemId.reset();
                	    emailHomeItemId.reset();
                	    emailHomeUseForCommunicationItemId.reset();
                	    emailWorkUseForCommunicationItemId.reset();
                	    workTelephoneCountryCodeItemId.reset();
                	    workTelephoneItemId.reset();
                	    feePayerIDItemId.reset();
                	    feePayerLatestPayslipItemId.reset();
                	    
                	    Ext.Ajax.request({
                	    	  type: 'rest',
                	    	  url: SERVERURL.DEFAULT_COUNTRY_CODE_BY_ACADEMY_LOCATION,
                	    	  method: 'GET',
                	    	  success: function(response, action) {
                	    		  var MSSG = response.responseText;
                	    		  var jdata = Ext.decode(response.responseText);
                	    		  var defaultCountryId = -1;
                	    		  if(!isNullOrEmpty(jdata.id)){
                	    			  defaultCountryId = jdata.id; 
                	    		  }
                	    		   
                	    		 var workTelephoneCountryCode=form.down('#workTelephoneCountryCodeItemId');
                	    		 if(isNullOrEmpty(workTelephoneCountryCode.getValue())){
                	    		 workTelephoneCountryCode.getStore().load({
                	    			  callback: function(records, operation, success) {
                	    				  if (success) {
                	    					  for(i in records){
                	    						  if(defaultCountryId == -1){
                	    							  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
                	    								  workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
                	    							  } 
                	    						  }else{
                	    							  if(records[i].data.id == defaultCountryId){
                	    								  workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
                	    							  }
                	    						  }
                	    					  }
                	    				  }
                	    			  }
                	    		  });
                	    	  }
                	    	 }
                	    });

                	   /* workTelephoneCountryCodeItemId.setFieldLabel(getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'));
                	    workTelephoneItemId.setFieldLabel(getPersonModuleTranslation('FPD_WORK_TELEPHONE'));
                	    emailWorkItemId.setFieldLabel(getPersonModuleTranslation('FPD_EMAIL_WORK'));*/
                	}
                	this.makeFieldAllowBlankAndMandatoryForReRegistration(form);
                	var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
                	var mobileField = form.down("#homeTelephoneItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                	countryCodeField = form.down("#workTelephoneCountryCodeItemId");
                	mobileField = form.down("#workTelephoneItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                	countryCodeField = form.down("#countryCodeItemId");
                	mobileField = form.down("#mobileNumberItemId");
                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
                }
            },
			'personalinformationform[itemId=studentPersonalInformationForm] customcombobox#idTypeCombo':{
           	 	select: function(combo, record) {
					var personProfile = this.getContentPanelActiveTab(); 
        			var personalInformationForm = personProfile.down('personalinformationform');      
            		var identityExpiryDateItemId = personalInformationForm.down("#identityExpiryDateItemId");
            		var idNumberSecond = personalInformationForm.down("#idNumberSecond");
					if (!isNullOrEmpty(record[0].data.idTypeCode) && record[0].data.idTypeCode == 'NATIONAL_ID') {
						identityExpiryDateItemId.setVisible(false);
                        this.setAllowBlank(identityExpiryDateItemId,true);
                        idNumberSecond.setVisible(false);
                        idNumberSecond.reset();
                        idNumberSecond.allowBlank = true;
					} else {
						idNumberSecond.setVisible(true);
                        this.checkDFRForidentityExpiryDate(personalInformationForm);
                        this.checkDFRForIdNumberSecond(personalInformationForm);
					}
					personalInformationForm.isValid();
					identityExpiryDateItemId.reset();
					idNumberSecond.reset();
				}
			},
              'studentprogramwiseconditionsforadmission':{
              	render:function(){
              		var me=this;
              		me.getRenderStudentProgramWiseConditionsForAdmission();
              		},
               },
              
            'additionaladmissionapproverform[itemId=additionaladmissionapproverform] customcombobox#statusId':{
                	select: function(combo, record){
                		var me=this;
						var form = me.getContentPanel().getActiveTab().down('additionaladmissionapproverform');
			    		var status=form.down('#statusId').getValue();
			    		var reason=form.down('#reasonId');
			    		 var comment=form.down('#commentId');
			    		 if(status=='Approved'){
			    			 reason.setVisible(false);
			    			 comment.setVisible(false);
			    		 }else{
			    			 reason.setVisible(true);
			    			 comment.setVisible(true);
			    		 }
                	}
                }, 
                'additionaladmissionapproverform[itemId=additionaladmissionapproverform] customcombobox#thirdStatusId':{
                	select: function(combo, record){
                		var me=this;
						var form = me.getContentPanel().getActiveTab().down('additionaladmissionapproverform');
			    		 var thirdStatus=form.down('#thirdStatusId').getValue();
			    		var thirdReason=form.down('#thirdReasonId');
			    		 var  thirdComment=form.down('#thirdCommentId');
			    		 if(thirdStatus=='Approved'){
			    			 thirdReason.setVisible(false);
			    			 thirdComment.setVisible(false);
			    		 }else{
			    			 thirdReason.setVisible(true);
			    			 thirdComment.setVisible(true);
			    		 }
                	}
                },
               
              'studentprogramwiseconditionsadmissionadmgrid': {
            	  beforeselect: function(rowModel, record, index, eOpts) {
                      var me = this;
                      var studentProfile = me.getContentPanelActiveTab();
                      var grid  = me.getContentPanel().getActiveTab().down('#studentprogramwiseconditionsadmissionadmgrid');
          	    	  var form = me.getContentPanel().getActiveTab().down('studentprogramwiseconditionsforadmission');
                      var documentGrid =   me.getContentPanel().getActiveTab().down('studentpwconditionsadminadmdocumentgrid');
                      var conditionGrid = me.getContentPanel().getActiveTab().down('studentlistofapplicableconditionsadmgrid');
                      if(portalId==3){ 
                    	  form.down('#admPWCSubmitBtn').setVisible(false);
                      }
                      var studentId = studentProfile.getUserId();
                      form.getForm().reset();
            		  form.down('#admPWCSubmitBtn').setDisabled(true);
            		  documentGrid.getStore().removeAll();
            		  conditionGrid.getStore().removeAll();
                    	  if (!isEmpty(record.data)) {
                    		  if (!isNullOrEmpty(record.data.id)) {
                    			  var applicationProgramID = record.data.id;
                    			  var submitUrl = SERVERURL.PATH_FIND_APPLICATION_PROGRAMS_ADMISSION_DETAILS_BY_ID +"?applicationProgramID="+applicationProgramID;
                    			  if (!isNullOrEmpty(submitUrl)) {
                    				  Ext.Ajax.request({
                    					  type: 'rest',
                    					  url: submitUrl,
                    					  method: 'GET',
                    					  success: function(success) {
                    						  if(!isNullOrEmpty(success.responseText)) {
                    						  var data = Ext.decode(success.responseText);
                    						  var applicantpwconditionsadminadmdocumentgrid =   me.getContentPanel().getActiveTab().down('studentpwconditionsadminadmdocumentgrid');
                    						  applicantpwconditionsadminadmdocumentgrid.getStore().load({
                								  params: {
                									  applicationId: record.data.applicationId,
                									  applicationProgramId: data.applicationProgram.id
                								  }
                    						  });
                                    		  var applicantlistofapplicableconditionsadmgrid = me.getContentPanel().getActiveTab().down('studentlistofapplicableconditionsadmgrid');
                                    		  applicantlistofapplicableconditionsadmgrid.getStore().load({
            								  params: {
            									  applicationProgramID: data.applicationProgram.id
            								  },
            								  callback: function(record, operation, success) {
            				   					if (success) {
            				    					if(record.length>0) {
            				    						form.down('#admPWCSubmitBtn').setDisabled(false);
            				    					}
            				    				}
            								  }
                						  });
                                    		  form.down('#txtAdmAdditionalConditionItemId').setValue(data.additionalCondition);
                                    		  form.down('#admDateOfSatisfactionConditionItemId').setVisible(true);
                                    		  form.down('#admDateOfSatisfactionConditionItemId').setValue(dateRender(data.conditionSatisfactionDate));
                    					  }
                    				  	}
                    				  });

                    			  }
                    		  }
                    	  }
                    	  
                    	  
                 			var additionalApproverForm = me.getContentPanel().getActiveTab().down('additionaladmissionapproverform');
                 			var programBatchSeatConfigId=record.data.programBatchSeatConfigurationId;
 			    	    	me.additionalApproverMethod(additionalApproverForm,programBatchSeatConfigId);
                            
                  } 
              },
              'studentpwconditionsadminadmdocumentgrid button[itemId=btnUploadDocument]': {                
                  click: function(){
                  	this.uploadDocumentAdmApplicantFormWindow();                                                 	
                  }
              },
              'documentformwindow[itemId=studentConditionProgramDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentFormSubmitButtonId]': {
                  click: function(){
                  	this.saveStudentConditionalAdmProgramDocumentForm();
                  }
              },
              'documentformwindow[itemId=studentConditionProgramDocumentForm] extendeddocumentform[itemId=extendedDocumentForm] button[itemId=documentCancelButtonId]': {
            	  click: function(){
            		  var this$ = this;
            		this$.getAdmStudentProfileDocumentController().closeDocumentFormWindow();
            	  }
              },
		 	  'studentprogramwiseconditionsforadmission button[itemId=admPWCSubmitBtn]':{
			 			click: function(obj) {
			 				this.saveStdStudentProgramWiseCondition(obj);
			 			}
			},
			'studentlistofapplicableconditionsadmgrid button[itemId=btnDelete]': {
			    click: function() {
			        var this$ = this;
			        var personProfile = this$.getContentPanelActiveTab();
			        var grid = personProfile.down('#studentListofApplicableConditionsAdmgridItemId');
			        var selectionModel = grid.getSelectionModel();
			        var selectedRecords = selectionModel.getSelection();

			        if (selectedRecords.length > 0) {
			            showConfirmMessage(getAdmissionTranslation('LIST_OF_APPLICABLE_CONDITIONS'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
			                if (btn === 'yes') {
			                    var record = selectedRecords[0];
			                    var id = record.get("id");
			                    var isUnsaved = Ext.isEmpty(id); // Check if the record is unsaved

			                    if (isUnsaved) {
			                        grid.getStore().remove(record);
			                        this$.updateSequenceNumbers(grid.getStore());
			                        showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
			                    } else {
			                        Ext.Ajax.request({
			                            type: 'rest',
			                            url: SERVERURL.DELETE_STUDENT_LIST_OF_APPLICABLE_CONDITION,
			                            method: 'DELETE',
			                            headers: {
			                                'Content-Type': 'application/json'
			                            },
			                            params: {
			                                id: id
			                            },
			                            success: function(response) {
			                            	grid.getStore().remove(record);
			                            	this$.updateSequenceNumbers(grid.getStore());
			                                showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
			                            }
			                        });
			                    }
			                }
			            });
			        } else {
			            showWarningMessage(getAdmissionTranslation('LIST_OF_APPLICABLE_CONDITIONS'), getCommonTranslation('PLEASE_SELECT_RECORD'));
			        }
			    }
			},
			 'feepayerdetailform[itemId=personfeepayerdetailformItemId] customcombobox[itemId=bankItemId]': {
	            	render: function(combo) {
	            		combo.getStore().load();
	            	},
	             select: function(combo, record) { 
	            	 var branchCodeField = combo.up('form').down('customcombobox#branchCodeItemId');
	            	 var branchCodeStore = branchCodeField.getStore();
		             var selectedBankId=record[0].data.id;             	
		             branchCodeStore.getProxy().extraParams = {
			            bankId: selectedBankId
		             };    	            
		             
		             branchCodeStore.load({
	 					  callback: function(records, operation, success) {
	 						  if (success) {
	 							if(records.length == 1){
	 								branchCodeField.setValue(records[0].data.id);
	 							}
	 						  }
	            	}
	 				  });
	             }, 
	             change: function(combo, newValue) {
	             	var branchCodeField = combo.up('form').down('customcombobox#branchCodeItemId');
	             	if(!isNullOrEmpty(newValue)){
	             		branchCodeField.setDisabled(false);	
	             	}else{
	             		branchCodeField.setDisabled(true);
	             	}      	
	             }

	             }, 
	            'feepayerdetailform[itemId=personfeepayerdetailformItemId] radiogroup[itemId=payerTypeItemId]': {
	                change: function(cb, nv, ov) {
	                	var $this = this;
	                	var form = cb.up('feepayerdetailform');

	                	var salutationItemId = form.down("#salutationItemId");
	                	var firstNameItemId = form.down("#firstNameItemId");
	                	var middleNameItemId = form.down("#middleNameItemId");
	                	var lastNameItemId = form.down("#lastNameItemId");
	                	var companyNameItemId = form.down("#companyNameItemId");
	                	var contactPersonItemId = form.down("#contactPersonItemId");
	                	var doesFeePayerConsentToCreditCheckLabelItemId = form.down("#doesFeePayerConsentToCreditCheckLabelItemId");
	                	var doesFeePayerConsentToCreditCheckItemId = form.down("#doesFeePayerConsentToCreditCheckItemId");
	                	var homeTelephoneCountryCodeItemId = form.down("#homeTelephoneCountryCodeItemId");
	                	var homeTelephoneItemId = form.down("#homeTelephoneItemId");
	                	var workTelephoneCountryCodeItemId = form.down("#workTelephoneCountryCodeItemId");
	                	var workTelephoneItemId = form.down("#workTelephoneItemId");
	                	var countryCodeItemId = form.down("#countryCodeItemId");
	                	var mobileNumberItemId = form.down("#mobileNumberItemId");

	                	var emailHomeItemId = form.down("#emailHomeItemId");
	                	var emailWorkItemId = form.down("#emailWorkItemId");
	                	var emailHomeUseForCommunicationItemId = form.down("#emailHomeUseForCommunicationItemId");
	                	var emailWorkUseForCommunicationItemId = form.down("#emailWorkUseForCommunicationItemId");
	                	var feePayerIDItemId = form.down("#feePayerIDItemId");
	                	var feePayerLatestPayslipItemId = form.down("#feePayerLatestPayslipItemId");
	                	var feePayerProofOfAccountItemId = form.down("#feePayerProofOfAccountItemId");
	                	var nationalAlternateIdItemId = form.down("#nationalAlternateIdItemId");
	                	var companyAddressContainerItemId = form.down("#companyAddressContainerItemId");
	                	var empOfTheOrgContainerItemId = form.down("#empOfTheOrgContainerItemId");
	                	var surnameItemId = form.down("#surnameItemId");
	                	
	                	var employeeIdItemId = form.down("#employeeIdItemId");
	                	var nationalAlternateIdItemId = form.down("#nationalAlternateIdItemId");
	                	var nationalAlternateIdContainer = form.down("#nationalAlternateIdContainer");
	                	var homeTelephoneContainerItemId = form.down("#homeTelephoneContainerItemId");
	                	
	                	var emailHomeContainerItemId = form.down("#emailHomeContainerItemId");
	                	var corporateItemId= form.down('#corporateId');
	                	var firstNameOtherLangItemId = form.down("#firstNameOtherLangItemId");
	                	var middleNameOtherLangItemId = form.down("#middleNameOtherLangItemId");
	                	var lastNameOtherLangItemId = form.down("#lastNameOtherLangItemId");
	                	var companyNameOtherLangItemId = form.down("#companyNameOtherLangItemId");
	                	var contactPersonOtherLangItemId = form.down("#contactPersonOtherLangItemId");
	                	var surnameOtherLangItemId = form.down("#surnameOtherLangItemId");
	                	
	                	if (nv.payerType == 'PERSON') {
	                	    salutationItemId.setVisible(true);
	                	    firstNameItemId.setVisible(true);
	                	    middleNameItemId.setVisible(true);
	                	    lastNameItemId.setVisible(true);
	                	    companyNameItemId.setVisible(false);
	                	    contactPersonItemId.setVisible(false);
	                	    corporateItemId.setVisible(false);
	                	   // doesFeePayerConsentToCreditCheckLabelItemId.setVisible(true);
	                	   // doesFeePayerConsentToCreditCheckItemId.setVisible(true);
	                	    
	                	    //homeTelephoneCountryCodeItemId.setVisible(true);
	                	    //homeTelephoneItemId.setVisible(true);
	                	    homeTelephoneContainerItemId.setVisible(true);
	                	    //countryCodeItemId.setVisible(true);
	                	    //mobileNumberItemId.setVisible(true);
	                	   
	                	    // emailHomeItemId.setVisible(true);
	                	   // emailHomeUseForCommunicationItemId.setVisible(true);
	                	    
	                	    emailHomeContainerItemId.setVisible(true);
	                	    
	                	    //emailWorkUseForCommunicationItemId.setVisible(true);
	                	  /*  feePayerIDItemId.setVisible(true);
	                	    feePayerLatestPayslipItemId.setVisible(true);*/
	                	    
	                	    //emailWorkUseForCommunicationItemId.setFieldStyle('background-color: red;');
	                	    
	                	    empOfTheOrgContainerItemId.setVisible(true);
	                	    surnameItemId.setVisible(false);
	                	    //nationalAlternateIdItemId.setVisible(true);
	                	    nationalAlternateIdContainer.setVisible(true);
	                	    companyAddressContainerItemId.setVisible(false);

	                	  //  this.setAllowBlank(surnameItemId, true);
	                	    
	                	  //  salutationItemId.allowBlank = false;
	                	    this.setAllowBlank(salutationItemId, false);
	                	    
	                	  //  firstNameItemId.allowBlank = false;
	                	    this.setAllowBlank(firstNameItemId, false);
	                	    
	                	  //  lastNameItemId.allowBlank = false;
	                	    this.setAllowBlank(lastNameItemId, false);
	                	    
	                	  //  companyNameItemId.allowBlank = true;
	                	    this.setAllowBlank(companyNameItemId, true);
	                	    
	                	    //  contactPersonItemId.allowBlank = true;
	                	    this.setAllowBlank(contactPersonItemId, true);
	                	    
	                	  //  doesFeePayerConsentToCreditCheckItemId.allowBlank = false;
	                	    this.setAllowBlank(doesFeePayerConsentToCreditCheckItemId, false);
	                	    this.setAllowBlank(feePayerIDItemId, false);
	                	  //  feePayerIDItemId.allowBlank = false;
	                	 //   this.setAllowBlank(feePayerIDItemId, false);
	                	    
	                	 //   this.setAllowBlank(employeeIdItemId, false);
	                	 //   this.setAllowBlank(nationalAlternateIdItemId, false);
	                	    
//	                	    feePayerLatestPayslipItemId.allowBlank = false;

	                	  //  homeTelephoneCountryCodeItemId.allowBlank = false;
	                	  //  homeTelephoneItemId.allowBlank = false;
	                	  //  countryCodeItemId.allowBlank = false;
	                	  //  mobileNumberItemId.allowBlank = false;
	                	  //  emailHomeItemId.allowBlank = false;
	                	    this.setAllowBlank(emailHomeItemId, false);
	                	    
	                	  //  workTelephoneCountryCodeItemId.allowBlank = true;
	                	  //  workTelephoneItemId.allowBlank = true;
	                	  //  emailWorkItemId.allowBlank = true;
	                	    this.setAllowBlank(emailWorkItemId, true);

	                	    companyNameOtherLangItemId.allowBlank=true;	
	                    	contactPersonOtherLangItemId.allowBlank=true;	
	                    	surnameOtherLangItemId.allowBlank=true;	
	                    	companyNameOtherLangItemId.setVisible(false);
	                    	contactPersonOtherLangItemId.setVisible(false);	
	                    	surnameOtherLangItemId.setVisible(false);	
	                    	companyNameOtherLangItemId.reset();
	                    	contactPersonOtherLangItemId.reset();
	                    	surnameOtherLangItemId.reset();
	                	    
	                	    salutationItemId.reset();
	                	    firstNameItemId.reset();
	                	    middleNameItemId.reset();
	                	    lastNameItemId.reset();
	                	    companyNameItemId.reset();
	                	    contactPersonItemId.reset();
	                	    doesFeePayerConsentToCreditCheckItemId.reset();
	                	    homeTelephoneCountryCodeItemId.reset();
	                	    homeTelephoneItemId.reset();
	                	    countryCodeItemId.reset();
	                	    mobileNumberItemId.reset();
	                	    emailHomeItemId.reset();
	                	    emailHomeUseForCommunicationItemId.reset();
	                	    emailWorkUseForCommunicationItemId.reset();
	                	    workTelephoneCountryCodeItemId.reset();
	                	    workTelephoneItemId.reset();
	                	    feePayerIDItemId.reset();
	                	    feePayerLatestPayslipItemId.reset();
	                	    feePayerProofOfAccountItemId.reset();
	                	    //corporateItemId.reset();
	                	    
	                        Ext.Ajax.request({
	                  		  type: 'rest',
	                  		  url: SERVERURL.DEFAULT_COUNTRY_CODE_BY_ACADEMY_LOCATION,
	                  		  method: 'GET',
	                  		  success: function(response, action) {
	                  			  var MSSG = response.responseText;
	                  			  var jdata = Ext.decode(response.responseText);
	                  			  var defaultCountryId = -1;
	                  			  if(!isNullOrEmpty(jdata.id)){
	                  				  defaultCountryId = jdata.id; 
	                  			  }
	          					 var homeTelephoneCountryCode=form.down('#homeTelephoneCountryCodeItemId');
	          					 if(isNullOrEmpty(homeTelephoneCountryCode.getValue())){
	          					 homeTelephoneCountryCode.getStore().load({
	              					  callback: function(records, operation, success) {
	              						  if (success) {
	              							  for(i in records){
	              								  if(defaultCountryId == -1){
	              									  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
	              										  homeTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
	                  								  } 
	              								  }else{
	              									  if(records[i].data.id == defaultCountryId){
	              										  homeTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
	                  								  }
	              								  }
	              							  }
	              						  }
	              					  }
	              				  });
	                  		  }
	          					 
	          					 var workTelephoneCountryCode=form.down('#workTelephoneCountryCodeItemId');
	          					 if(isNullOrEmpty(workTelephoneCountryCode.getValue())){
	          					 workTelephoneCountryCode.getStore().load({
	              					  callback: function(records, operation, success) {
	              						  if (success) {
	              							  for(i in records){
	              								  if(defaultCountryId == -1){
	              									  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
	              										  workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
	                  								  } 
	              								  }else{
	              									  if(records[i].data.id == defaultCountryId){
	              										  workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
	                  								  }
	              								  }
	              							  }
	              						  }
	              					  }
	              				  });
	                  		  }
	          					 
	          					 var countryCode=form.down('#countryCodeItemId');
	          					 if(isNullOrEmpty(countryCode.getValue())){
	          					 countryCode.getStore().load({
	              					  callback: function(records, operation, success) {
	              						  if (success) {
	              							  for(i in records){
	              								  if(defaultCountryId == -1){
	              									  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
	              										  countryCode.setValue(records[i].data.isdCode);  									  
	                  								  } 
	              								  }else{
	              									  if(records[i].data.id == defaultCountryId){
	              										  countryCode.setValue(records[i].data.isdCode);  									  
	                  								  }
	              								  }
	              							  }
	              						  }
	              					  }
	              				  });
	                  		   }
	                  		  }
	      				  });
	                        
	                        
	                        var academyLocationId = this.getCurrentAcademyLocation();
	                    	
	                    	//var debitOrderContainerItemId = form.down("#debitOrderContainerItemId");
	                    	
	                    	/*var newMandatoryFields = ['employeeIdItemId', 'surnameItemId', 'nationalAlternateIdItemId', 
	                    		'companyAddressItemId'];*/
	                        
	                        var newMandatoryFields = ['employeeIdItemId','nationalAlternateIdItemId'];
	                    	
	                        Ext.Ajax.request({
		                		url: SERVERURL.COMMON_FORM_FIELD_INFO,
		                		method: 'GET',
		                		async: false,
		                		params: {
		                			academyLocationId:academyLocationId,
		                			languageCode:'en'
		                		},
		                		success: function(response) {
		                			var json = JSON.parse(response.responseText);
		                			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
		                			fieldInfo.set("formFieldsInfo", json);
		                			//console.log(json);
		                			if( !isNullOrEmpty(json) ){
		                				if( !isNullOrEmpty(json.feepayerdetailform) ){
		                					var feePayerDetailDFRConfig = json.feepayerdetailform;
		                					for( i in feePayerDetailDFRConfig){
		                						var fieldConfig = feePayerDetailDFRConfig[i];
		                						//console.log(fieldConfig);
		                						if( newMandatoryFields.includes(fieldConfig.formFieldId) ){
		                							if( fieldConfig.isMandatory ){
		                								var currentField = form.down("#"+fieldConfig.formFieldId);
		                								$this.setAllowBlank(currentField, false);
		                								var currentFieldLabel = fieldConfig.formFieldLabel;
		                								currentField.setFieldLabel(currentFieldLabel);
		                							}
		                						}

		                						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='firstNameOtherLangItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                							if(fieldConfig.isMandatory==true) {
		                								currentField.allowBlank=false;
		                							}
		                						} 
		                						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='middleNameOtherLangItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                							if(fieldConfig.isMandatory==true) {
		                								currentField.allowBlank=false;
		                							}
		                						}
		                						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='lastNameOtherLangItemId' && fieldConfig.isVisible==true){
		                							var currentField = form.down("#"+fieldConfig.formFieldId);
		                							currentField.setVisible(true);
		                							if(fieldConfig.isMandatory==true) {
		                								currentField.allowBlank=false;
		                							}
		                						}
		                						$this.removeDoubleColon(form.down("#"+fieldConfig.formFieldId),fieldConfig.formFieldLabel);
		                					}
		                				}
		                			}
		                		}
		                	});
	                	    

	                	    workTelephoneCountryCodeItemId.setFieldLabel(getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'));
	                	    workTelephoneItemId.setFieldLabel(getPersonModuleTranslation('FPD_WORK_TELEPHONE'));
	                	    emailWorkItemId.setFieldLabel(getPersonModuleTranslation('FPD_EMAIL_WORK'));
	                	} else {
	                	    salutationItemId.setVisible(false);
	                	    firstNameItemId.setVisible(false);
	                	    middleNameItemId.setVisible(false);
	                	    lastNameItemId.setVisible(false);
	                	    companyNameItemId.setVisible(true);
	                	    contactPersonItemId.setVisible(true);
	                	    
	                	    firstNameOtherLangItemId.allowBlank=true;	
	                    	middleNameOtherLangItemId.allowBlank=true;	
	                    	lastNameOtherLangItemId.allowBlank=true;	
	                    	firstNameOtherLangItemId.setVisible(false);
	                    	middleNameOtherLangItemId.setVisible(false);	
	                    	lastNameOtherLangItemId.setVisible(false);	
	                    	firstNameOtherLangItemId.reset();
	                    	middleNameOtherLangItemId.reset();
	                    	lastNameOtherLangItemId.reset();
	                	    
	                	    /**for corporate id hide show**/
	                	    var portalId = $this.getCurrentLoggedPortalId();
	                   		if(portalId == 7)
	                   		{
	                   			$this.disableFeePayerCorporateId(corporateItemId, $this.getPARENT_FEE_PAYER_DETAILS_PERMISSIONS());	
	                   		}else if(portalId == 3){
	                   			$this.disableFeePayerCorporateId(corporateItemId, $this.getSTUDENT_PORTAL_STUDENT_FEE_PAYER_DETAILS_PERMISSIONS());	
	                   		}else{
	                   			$this.disableFeePayerCorporateId(corporateItemId, $this.getSTUDENT_FEE_PAYER_DETAILS_PERMISSIONS());
	                   		}
	                   		
	                   	 var academyLocationId = this.getCurrentAcademyLocation();
	                   	 var newMandatoryFields = ['corporateId'];
	                     Ext.Ajax.request({
	                 		url: SERVERURL.COMMON_FORM_FIELD_INFO,
	                 		method: 'GET',
	                 		async: false,
	                 		params: {
	                 			screenName: 'feepayerdetailform',
	                 			academyLocationId:academyLocationId,
	                 			languageCode:'en'
	                 		},
	                 		success: function(response) {
	                 			var json = JSON.parse(response.responseText);
	                 			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
	                 			fieldInfo.set("formFieldsInfo", json);
	                 			if( !isNullOrEmpty(json) ){
	                 				if( !isNullOrEmpty(json.feepayerdetailform) ){
	                 					var feePayerDetailFormDFRConfig = json.feepayerdetailform;
	                 					for( i in feePayerDetailFormDFRConfig){
	                 						var fieldConfig = feePayerDetailFormDFRConfig[i];
	                 						if( newMandatoryFields.includes(fieldConfig.formFieldId) ){
	                 							if(!fieldConfig.isVisible){
	                 								var currentField = form.down("#"+fieldConfig.formFieldId);
	                 								currentField.setVisible(false);
	                 							}
	                 						}
	                 						
	                 						if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='companyNameOtherLangItemId' && fieldConfig.isVisible==true){
                								var companyNameOtherLang=form.down('#companyNameOtherLangItemId');
                								companyNameOtherLang.setVisible(true);
                								if(fieldConfig.isMandatory==true) {
                									companyNameOtherLang.allowBlank=false;
	                							}
                							}

                							if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='contactPersonOtherLangItemId' && fieldConfig.isVisible==true){
                								var contactPersonOtherLang=form.down('#contactPersonOtherLangItemId');
                								contactPersonOtherLang.setVisible(true);
                								if(fieldConfig.isMandatory==true) {
                									contactPersonOtherLang.allowBlank=false;
	                							}
                							}

                							if(fieldConfig.formFieldInputType=='textfield' && fieldConfig.formFieldId=='surnameOtherLangItemId' && fieldConfig.isVisible==true){
                								var surnameOtherLang=form.down('#surnameOtherLangItemId');
                								surnameOtherLang.setVisible(true);
                								if(fieldConfig.isMandatory==true) {
                									surnameOtherLang.allowBlank=false;
	                							}
                							}
	                 					}
	                 				}
	                 			}
	                 		}
	                 	});                  		
	                   		
	                	    this.setAllowBlank(homeTelephoneCountryCodeItemId, true);
	                	    this.setAllowBlank(employeeIdItemId, true);
	                	    this.setAllowBlank(salutationItemId, true);
	                	    this.setAllowBlank(middleNameItemId, true);
	                  	    this.setAllowBlank(firstNameItemId, true);
	                  	    this.setAllowBlank(lastNameItemId, true);
	                  	    this.setAllowBlank(companyNameItemId, true);
	                  	    this.setAllowBlank(contactPersonItemId, true);
	                  	    this.setAllowBlank(doesFeePayerConsentToCreditCheckItemId, true);
	                  	    this.setAllowBlank(feePayerIDItemId, true);
	                  	    this.setAllowBlank(feePayerProofOfAccountItemId, true)
	                  	    this.setAllowBlank(emailHomeItemId, true);
	                  	    this.setAllowBlank(emailHomeItemId, true);
	                  	    this.setAllowBlank(homeTelephoneItemId, true);
	                  
	                	    
	                	    homeTelephoneContainerItemId.setVisible(false);
	                	    
	                	    emailHomeContainerItemId.setVisible(false);
	                	    
	                	    feePayerIDItemId.setVisible(false);
	                	    feePayerIDItemId.setDisabled(true);
	                	    feePayerProofOfAccountItemId.setVisible(false);
	                	    feePayerProofOfAccountItemId.setDisabled(true)
	                	    feePayerLatestPayslipItemId.setVisible(false);
	                	    
	                	    empOfTheOrgContainerItemId.setVisible(false);
	                	    surnameItemId.setVisible(true);
	                	    nationalAlternateIdContainer.setVisible(false);
	                	    companyAddressContainerItemId.setVisible(true);
	                	    
	                	    emailWorkUseForCommunicationItemId.setFieldStyle('left: 0px;');

	                	    this.setAllowBlank(salutationItemId, true);
   
	                	    
	                	    this.setAllowBlank(firstNameItemId, true);
	                	    this.setAllowBlank(lastNameItemId, true);
	                	    
	                	     this.setAllowBlank(companyNameItemId, false);
	                	    
	                	     this.setAllowBlank(contactPersonItemId, false);
	                	    this.setAllowBlank(doesFeePayerConsentToCreditCheckItemId, true);
	                	     this.setAllowBlank(feePayerLatestPayslipItemId, true);
	                	    this.setAllowBlank(feePayerProofOfAccountItemId, true);
	                	    this.setAllowBlank(employeeIdItemId, true);
	                	    this.setAllowBlank(nationalAlternateIdItemId, true);
                           this.setAllowBlank(emailHomeItemId, true);
	                	  
	                	    this.setAllowBlank(emailWorkItemId, false);
	                	    
	                	    salutationItemId.reset();
	                	    firstNameItemId.reset();
	                	    middleNameItemId.reset();
	                	    lastNameItemId.reset();
	                	    companyNameItemId.reset();
	                	    contactPersonItemId.reset();
	                	    doesFeePayerConsentToCreditCheckItemId.reset();
	                	    homeTelephoneCountryCodeItemId.reset();
	                	    homeTelephoneItemId.reset();
	                	    //countryCodeItemId.reset();
	                	    mobileNumberItemId.reset();
	                	    emailHomeItemId.reset();
	                	    emailHomeUseForCommunicationItemId.reset();
	                	    emailWorkUseForCommunicationItemId.reset();
	                	    workTelephoneCountryCodeItemId.reset();
	                	    workTelephoneItemId.reset();
	                	    feePayerIDItemId.reset();
	                	    feePayerLatestPayslipItemId.reset();
	                	    feePayerProofOfAccountItemId.reset();
	                	    Ext.Ajax.request({
	                	    	  type: 'rest',
	                	    	  url: SERVERURL.DEFAULT_COUNTRY_CODE_BY_ACADEMY_LOCATION,
	                	    	  method: 'GET',
	                	    	  success: function(response, action) {
	                	    		  var MSSG = response.responseText;
	                	    		  var jdata = Ext.decode(response.responseText);
	                	    		  var defaultCountryId = -1;
	                	    		  if(!isNullOrEmpty(jdata.id)){
	                	    			  defaultCountryId = jdata.id; 
	                	    		  }
	                	    		   
	                	    		 var workTelephoneCountryCode=form.down('#workTelephoneCountryCodeItemId');
	                	    		 if(isNullOrEmpty(workTelephoneCountryCode.getValue())){
	                	    		 workTelephoneCountryCode.getStore().load({
	                	    			  callback: function(records, operation, success) {
	                	    				  if (success) {
	                	    					  for(i in records){
	                	    						  if(defaultCountryId == -1){
	                	    							  if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
	                	    								  workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
	                	    							  } 
	                	    						  }else{
	                	    							  if(records[i].data.id == defaultCountryId){
	                	    								  workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
	                	    							  }
	                	    						  }
	                	    					  }
	                	    				  }
	                	    			  }
	                	    		  });
	                	    	  }
	                	    	 }
	                	    });

	                	    workTelephoneCountryCodeItemId.setFieldLabel(getPersonModuleTranslation('ADDRESS_COUNTRY_CODE'));
	                	    workTelephoneItemId.setFieldLabel(getPersonModuleTranslation('FPD_WORK_TELEPHONE'));
	                	    emailWorkItemId.setFieldLabel(getPersonModuleTranslation('FPD_EMAIL_WORK'));
	                	}
	                	var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
	                	var mobileField = form.down("#homeTelephoneItemId");
	                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
	                	countryCodeField = form.down("#workTelephoneCountryCodeItemId");
	                	mobileField = form.down("#workTelephoneItemId");
	                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
	                	countryCodeField = form.down("#countryCodeItemId");
	                	mobileField = form.down("#mobileNumberItemId");
	                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,null);
	                }
	            },
	            'feepayerdetailform[itemId=personfeepayerdetailformItemId] customcombobox[itemId=homeTelephoneCountryCodeItemId]': {
	            	select: function(rowModel, record){
	            		var form = this.getParentFeePayerDetailForm();
	            		var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
	                	var mobileField = form.down("#homeTelephoneItemId");
	                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
	                }
	            },
	            
	            'feepayerdetailform[itemId=personfeepayerdetailformItemId] numberfield[itemId=homeTelephoneItemId]': {
	            	change: function(record){
	            		var form = this.getParentFeePayerDetailForm();
	                	var mobileField = form.down("#homeTelephoneItemId");
	                	mobileField.isValid();
	        			form.getForm().checkValidity();
	                }
	            },
	            
	            'feepayerdetailform[itemId=personfeepayerdetailformItemId] customcombobox[itemId=workTelephoneCountryCodeItemId]': {
	            	select: function(rowModel, record){
	            		var form = this.getParentFeePayerDetailForm();
	                	var countryCodeField = form.down("#workTelephoneCountryCodeItemId");
	                	var mobileField = form.down("#workTelephoneItemId");
	                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
	                }
	            },
	            'feepayerdetailform[itemId=personfeepayerdetailformItemId] combo#countryId': {
	                select: function(combo, record) {
	                	var newValue=record[0].data.id;
	                	var regionComboBox = combo.up('form').down('customcombobox#parentCountryRegionId'); 
	                	var cityComboBox = combo.up('form').down('customcombobox#cityId');
	                	cityComboBox.reset();
	                	regionComboBox.reset();
	                    cityComboBox.setDisabled(true);
	                    regionComboBox.setDisabled(false);
	                    this.onCountryChange(combo, record, this.getParentFeePayerDetailForm());
	                    combo.up('form').getForm().checkValidity();
	                }
	            },
	            'feepayerdetailform[itemId=personfeepayerdetailformItemId] customcombobox#parentCountryRegionId': {
	            	 select: function(obj1, record) {
	                     var cityComboBox = obj1.up('form').down('customcombobox#cityId');
	                     var countryComboBox = obj1.up('form').down('customcombobox#countryId');
	                     cityComboBox.setDisabled(false);
	                     cityComboBox.reset();
	                     
	                     var countryRegionIdVal = record[0].get("id");
	                     var countryIdVal = countryComboBox.getValue();
	                     var cityStore = cityComboBox.getStore();
	                     cityStore.getProxy().extraParams = {
	                    	 countryId: countryIdVal,
	                    	 countryRegionId: countryRegionIdVal
	                     };
	                     cityStore.reload();
	                     obj1.up('form').getForm().checkValidity();
	                 }
	            },
	            'feepayerdetailform[itemId=personfeepayerdetailformItemId] checkboxfield#isSameAsCurrentAddress': {
	         	   change: function(obj,newValue,oldValue) {
	          		   var form = obj.up('form');          		  
	          		   
	          		   if(newValue || newValue == true){             			   
	          			  this.getPersonCurrentAddressDetail(form,SERVERURL.PERSON_CURRENT_ADDRESS,true);          			  
	          		   } 
	          		   else{
	          			  this.getPersonCurrentAddressDetail(form,SERVERURL.PERSON_CURRENT_ADDRESS,false);               			 
	          		   }
			}
	       },
	       'manageholdsstructure':{
	    	 afterrender:function(structure){
	    		 this.hideTabsBasedOnPermission(structure)
	    	 }  
	       },
	       'financeholdinnertab button[itemId=resetButtonId]':{
	       		click: function(btn) {
	       		 var form = btn.up('financeholdinnertab');
       			 var holdType = form.down('#holdType');
	       			holdType.reset();
	       			
	       		 }
	       	   },
	    	   'financeholdinnertab customcombobox[itemId=holdType]':{
		   			  render:function(combo){
		  				  $this = this;
		  				  var store = combo.getStore(); 
		  				  store.on('load', function(){
		  						  var filterItemIds = ['EXAM_ENROLLMENT'];
		  						  var storeItems = store.getRange();
		  						  for(var i = 0; i<storeItems.length; i++){     
		  							  if(Ext.Array.contains(filterItemIds, storeItems[i].get('id')))
		  								  store.remove(store.getById(storeItems[i].get('id')));            
		  						  }  
		  				  });

		  			  }
		  		  },
	       	  'financeholdinnertab button#searchButtonId':{
	       		  click: function(btn) {
	       			  var form = btn.up('financeholdinnertab');
	       			  var grid = form.down('studentfinanceholdsgrid');
	       			  var holdType = form.down('#holdType').getValue();
	       			  var personProfile = this.getContentPanelActiveTab();
	       			  var store = grid.getStore();
	       			 
	       				  store.getProxy().extraParams = {
	       					  financeHoldType: holdType,
	       					  studentId:personProfile.getUserId()
	       				  };
	       			  this.resetPageSetting(store);
	       			  grid.config.searchFilterForm =form;
	       			  store.load();
	       		  }
	       	  },
	       'manageholdinnertab button[itemId=resetButtonId]':{
       		click: function(btn) {
       			var structure = btn.up('manageholdinnertab');
       			var applyHoldAt = structure.down('#applyHoldAt');
       			var holdSubCatStatus = structure.down('#holdStatus');
       		//	holdAndFinanceHoldRadio.reset();
       			applyHoldAt.reset();
       			holdSubCatStatus.reset();
       		 }
       	   },
       	  'manageholdinnertab button#searchButtonId':{
       		  click: function(btn) {
       			  var structure = btn.up('manageholdinnertab');
       			  var grid = structure.down('studentholdsgrid');
       			  var applyHoldAt = structure.down('#applyHoldAt').getValue();
       			  var status = structure.down('#holdStatus').getValue();
       			  var personProfile = this.getContentPanelActiveTab();
       			  var store = grid.getStore();
       			  if(isNullOrEmpty(status)){
       				  store.getProxy().extraParams = {
       					  applyHoldAt: applyHoldAt,
       					  studentId:personProfile.getUserId()
       				  };
       			  }else{
       				  store.getProxy().extraParams = {
       					  applyHoldAt: applyHoldAt,
       					  isRemovedData:status,
       					  studentId:personProfile.getUserId()
       				  };
       			  }
       			  grid.config.searchFilterForm =structure;
       			  this.resetPageSetting(store);
       			  store.load();
       		  }
       	  },
       	 'manageholdinnertab customcombobox[itemId=applyHoldAt]':{
			  render:function(combo){
				  $this = this;
				  var store = combo.getStore(); 
				  store.on('load', function(){
						  var filterItemIds = ['EXAM_ENROLLMENT'];
						  var storeItems = store.getRange();
						  for(var i = 0; i<storeItems.length; i++){     
							  if(Ext.Array.contains(filterItemIds, storeItems[i].get('id')))
								  store.remove(store.getById(storeItems[i].get('id')));            
						  }  
				  });

			  }
		  },
		  'studentfinanceholdsgrid':{
			  afterrender:function(grid){
				  var studentProfilePanel = grid.up('studentprofile');
          		  var structure = studentProfilePanel.down('panel')
          		  this.getGridHeaderFreeze(grid,structure,true)
                  
			  }
		  },
		  
			 'studentholdsgrid[itemId=studentholdsDetailsgrid]': {
	            	render: function(grid) {
	            		var this$ = this;
	            		this.doAccessControlValidation(grid, this.getSTUDENT_HOLDS_PERMISSIONS());
	            		this.doAccessControlValidationOfStudentHolds(grid, this.getSTUDENT_HOLDS_PERMISSIONS(),'HOLDS');
	            		var studentProfilePanel = grid.up('studentprofile');
	            		var structure = studentProfilePanel.down('panel')
	            		this.getGridHeaderFreeze(grid,structure,true)
	                    var personProfile = this$.getContentPanelActiveTab();
	            		
	            		try{
	                    	if((portalId == 3 || portalId == 7) && personProfile.xtype == "dashboardhomepage"){
	                    		var contentPanel = this$.getContentPanel();
	                    		var personProfile = contentPanel.items.items[1];
	                    	}
	                	}
	                	catch(e){
	                		//
	                	}
	            		
	            		
	                    var personObj = this$.getPersonObj();
	                    var grid = personProfile.down('#studentholdsDetailsgrid');
	                    if (grid) {
	                        var studentId = personObj["id"];
	                        var store = grid.getStore();
	                        store.getProxy().api.read = SERVERURL.PATH_STUDENT_APPLY_HOLD_CATEGORY_GRID;
	                        store.getProxy().extraParams = {
	                        	studentId: personProfile.getUserId(),
	                        	applyHoldAt: ''
	                        };
	                        this.resetPageSetting(store)
	                        store.load();
	                    }
	            		
	            	
	            	},
	            	 cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
               			var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
               			var personProfile = this.getContentPanelActiveTab();
		                    var grid1 = personProfile.down("#studentholdsDetailsgrid");

               			if(record.data.isRemoval==true){
               			grid1.down("#removeHold").setDisabled(true);
               		
               			}else{
               				grid1.down("#removeHold").setDisabled(false);
               				
               			}}
	            },
	            'studentholdsgrid[itemId=studentholdsDetailsgrid] button[itemId=removeHold]': {
	            	click: function() {
	            		var formWindow = this.getPersonCommonWindow();
	            		this.StudentRemovalWin(formWindow, 'REMOVE_HOLDS', 'studentremoveholdsform','#studentholdsDetailsgrid', true);
	            	}
	            },
	            
	            'studentholdsgrid[itemId=studentholdsDetailsgrid] button[itemId=applyHold]': {
	            	click: function() {
	            		var this$=this;
	            		var formWindow = this.getPersonCommonWindow();
	            		this.showPersonCommonWindow(formWindow, 'APPLY_HOLDS', 'studentapplyholdsform', true);
	            		var form = this$.getStudentapplyholdsform();
	            		var holdCatStudent=	form.down("#holdCatStudent");
	            		var personProfile = this$.getContentPanelActiveTab();
	                  var seatConfigId=	personProfile.getProgramBatchSeatTypeConfigId()
	            	var holdCatStudentStore =holdCatStudent.getStore();
	                  holdCatStudentStore.getProxy().extraParams = {
	            		 seatConfigId:seatConfigId,
   				   };
	            	 
	            	 holdCatStudentStore.load();
	                 }
	         	
	         },
	         'studentapplyholdsform combo#subHoldCatStudent': {
	                select: function(combo, record) {
	                	var form = this.getStudentapplyholdsform();
	            		this.setApplyHoldAtOnApplyHoldWindow(form);
	                }
	         },
	         'studentholdsgrid[itemId=studentholdsDetailsgrid] button[itemId=deleteHold]': {
	            	click: function(btn) {
	            		var grid = btn.up('grid');
	                	var records = grid.getSelectionModel().getSelection();
	                	var empAvailIds=[];
	                    if(!isNullOrEmpty(records) && records.length > 0) {
	                        for( var i=0; i<records.length; i++ ) {
	                           if(!isNullOrEmpty(records[i].data.id)){
	                           empAvailIds.push(records[i].data.id);
	                        }
	                     }
	                    }
	                    var Ids = empAvailIds.join(',');
	                	if (grid.getSelectionModel().getCount() > 0) {
	                		showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	                			if (btn == 'yes') {
	                				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                				Ext.Ajax.request({
	                					method : "GET",
	                					type : 'rest',
	                					url : SERVERURL.PATH_STUDENT_APPLY_HOLD_CATEGORY_DELETE +'?studentHoldIds='+ Ids,
	                					headers : {
	                						'Content-Type' : 'application/json'
	                					},
	                					params: {
	                						studentHoldIds: Ids
	            						},
	                					success : function(form,action) {
	                						Ext.getBody().unmask();
	                						grid.getStore().reload();
	                						showSuccessMessage(getCommonTranslation('MANAGE_HOLD'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
	                					}
	                				});
	                			}
	                		});
	                	}else{
	            			 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	            		}
	            	}
	            },
	         	            //},
	            'personcommonwindow[itemId=personCommonWindow] studentapplyholdsform  combo[itemId=applyById]':{
     			   render: function(obj){
     				   var this$=this;
     				   var store = obj.getStore();
     				   store.getProxy().extraParams = {
     					   academyLocationIds:this.getCurrentAcademyLocation()
     				   };
     				   //store.load();
     				  var formWindow = this$.getPersonCommonWindow();
     			       var form = formWindow.down('studentapplyholdsform');
     				   var userId=this.getCurrentlyLoggedInUser();
     				   var applyById = form.down("#applyById");
     				  applyById.store.load({
     					   callback : function(operation,success) {
     						   if (success) {
     							  applyById.setValue(userId.id);
    			    				}
    			    			} 
    			    		});
     			   }
     		   }, 
     		   'personcommonwindow[itemId=personCommonWindow] studentapplyholdsform button[itemId=cancelButtonId]': {
               	click: this.closePersonCommonWindow
               },
               'personcommonwindow[itemId=personCommonWindow] studentapplyholdsform button[itemId=submitButtonId]': {
               	click: function(){
               		this.saveStudentApplyHold('#studentholdsDetailsgrid', SERVERURL.PATH_STUDENT_APPLY_HOLD_CATEGORY_SAVE, SERVERURL.PATH_STUDENT_APPLY_HOLD_CATEGORY_UPDATE);
               	}
               },
               'personcommonwindow[itemId=personCommonWindow] studentremoveholdsform  combo[itemId=removalById]':{
     			   render: function(obj){
     				   var this$=this;
     				   var store = obj.getStore();
     				   store.getProxy().extraParams = {
     					   academyLocationIds:this.getCurrentAcademyLocation()
     				   };
     				  // store.load();
     				  var formWindow = this$.getPersonCommonWindow();
     			       var form = formWindow.down('studentremoveholdsform');
     				   var userId=this.getCurrentlyLoggedInUser();
     				   var removalById = form.down("#removalById");
     				  removalById.store.load({
     					   callback : function(operation,success) {
     						   if (success) {
     							  removalById.setValue(userId.id);
    			    				}
    			    			} 
	         
        });
     			   }
     		   }, 
     		  'personcommonwindow[itemId=personCommonWindow] studentremoveholdsform button[itemId=cancelButtonId]': {
                 	click: this.closePersonCommonWindow
    },
                 'personcommonwindow[itemId=personCommonWindow] studentremoveholdsform button[itemId=submitButtonId]': {
                    	click: function(){
                    		this.saveStudentRemoveHold('#studentholdsDetailsgrid', SERVERURL.PATH_STUDENT_APPLY_HOLD_CATEGORY_UPDATE);
                    	}
                    },
                    'personcommonwindow[itemId=personCommonWindow] studentapplyholdsform combo[itemId=holdCatStudent]': {
                      	 select:function(obj1,records) {
                      	 var subHoldCatStudent = obj1.up('form').down('customcombobox#subHoldCatStudent');
                      	 var applyHoldAtProfile = obj1.up('form').down('#applyHoldAtProfile');
                              subHoldCatStudent.reset();
                              applyHoldAtProfile.reset();
                              subHoldCatStudent.setDisabled(false);
                         var armsOfServiceIdVal = records[0].get("id");
                         var subHoldCatStudentStore = subHoldCatStudent.getStore();
                         subHoldCatStudentStore.getProxy().extraParams = {
                        	 holdCategoryId: armsOfServiceIdVal
                         };
                         subHoldCatStudentStore.load();
                      	 }
                      },
			'personalinformationform[itemId=studentPersonalInformationForm] button[itemId=validateID]': {
				click: function(obj) {
					var $this = this;
					var personalInformationForm = obj.up('personalinformationform');
					if(personalInformationForm){
						var data = personalInformationForm.getValues()
					}
					var idTypeCodeValue = personalInformationForm.down('#idTypeCombo').getStore().findRecord('id',data.idtype);
					if(!isNullOrEmpty(data.nationality)){
						 var index = personalInformationForm.down('#nationalityCombo').getStore().findExact('id',data.nationality.id);
						  if(index !== -1){
							   var nationalityCodeValue = personalInformationForm.down('#nationalityCombo').getStore().getAt(personalInformationForm.down('#nationalityCombo').getStore().findExact('id',data.nationality.id));
						  } 
						
					}
					if(!isNullOrEmpty(data.secondaryCitizenship)){
						 var index = personalInformationForm.down('#stuSecondaryCitizenshipItemId').getStore().findExact('id',data.secondaryCitizenship.id);
						  if(index !== -1){
							   var secondaryCitizenshipValue = personalInformationForm.down('#stuSecondaryCitizenshipItemId').getStore().getAt(personalInformationForm.down('#stuSecondaryCitizenshipItemId').getStore().findExact('id',data.secondaryCitizenship.id));
						  } 
					}
					if(!isNullOrEmpty(idTypeCodeValue) && idTypeCodeValue.data.idTypeCode == 'NATIONAL_ID'){
						var nationalId = data.nationalID;
						var birthDate = data.birthDate;
						var gender = data.genderCSM;
						var message = '';
						if(!isNullOrEmpty(nationalId)){
							if(nationalId.length > 13 || nationalId.length<13){
								message = message+getCommonTranslation('NATIONALID_SHOULDBE_13DIGITS')+'<br>';
							}
							if(!isNumberValidate(nationalId)){
								message = message+getCommonTranslation('NATIONALID_CANBE_ONLYDIGITS')+'<br>';
							}
							if(nationalId.length > 5 && !isNullOrEmpty(birthDate)){
								var splitDOB = birthDate.split('-');
								var dobYear = splitDOB[0].substr(-2);
								var dobMonth = splitDOB[1];
								var dobDay = splitDOB[2];
								var dateOfBirth = dobYear+dobMonth+dobDay;
								var firstSixDigit = nationalId.substr(0,6);
								if(firstSixDigit != dateOfBirth){
									message = message+getCommonTranslation('INVALID_DOB_ID_NUMBER_PROVIDED')+'<br>';
								}
							}
                  
							if(nationalId.length > 9 && !isNullOrEmpty(gender)){
								var sevenToTenDigit = nationalId.substr(6,4);
								if((gender.id == 2 && (sevenToTenDigit>=0 && sevenToTenDigit<=4999)) || (gender.id == 1 && (sevenToTenDigit>=5000 && sevenToTenDigit<=9999))){
								
								}else{
									message = message+getCommonTranslation('INVALID_GENDER_IDNUMBER_PROVIDED')+'<br>';
								}
							}
							var eleventhDigit = nationalId.substr(10,1);
							if(nationalId.length > 10 && eleventhDigit == 0 && ((isNullOrEmpty(nationalityCodeValue) && secondaryCitizenshipValue.data.code != 'South African')||(isNullOrEmpty(secondaryCitizenshipValue) && nationalityCodeValue.data.code != 'South African') || ((!isNullOrEmpty(nationalityCodeValue) && nationalityCodeValue.data.code != 'South African') && (!isNullOrEmpty(secondaryCitizenshipValue) && secondaryCitizenshipValue.data.code != 'South African')))){
								message = message+getCommonTranslation('INVALID_CITIZENSHIP_IDNUMBER_PROVIDED')+'<br>';
							}else if(nationalId.length > 10 && eleventhDigit == 1 && data.isPermanentResident != true ){
								message = message+getCommonTranslation('INVALID_PERMANENT_RESIDENT_DETAILS')+'<br>';
							}else if(nationalId.length > 10 && eleventhDigit>1){
								message = message+getCommonTranslation('INVALID_DETAILS_ID_NUMBER_PROVIDED')+'<br>';
							}
							if(message !='')
							{
								showNotificationMessage(getCommonTranslation('ITENDITY_NO_NATIONALID_VALIDATION'), message);
							}else{
								showOkWithSuccessMessage(getCommonTranslation('ITENDITY_NO_NATIONALID_VALIDATION'), getCommonTranslation('NATIONALID_IS_VALID'));
							}
						}	
					}
				}		
			} ,
            'livingarrangementgrid button[itemId=btnAdd]': {
            	click: function(){
            		this.addLivingArrangementRecord('Add');
            	}
            },
            'livingarrangementgrid button[itemId=btnView]': {
            	click: function(){
            	    this.viewLivingArrangementDetails('View');
            	}
            },
    		'livingarrangementdetailsform button[itemId=submitBtn]':{
    			click: function(){
    				this.saveLivingArrangement(true)
    			}
    		},
    		'livingarrangementgrid button[itemId=btnEdit]':{
    			click: function(){
    				this.editLivingArrangementDetails('Edit');
    			}
			},
    		'livingarrangementgrid[itemId=studentLivingArrangementGridItemId]': {
    			render: function(grid) {
    				var me = this;
    				if(portalId==3){
    					me.doAccessControlValidation(grid,me.getSTUDENTPORTAL_LIVING_ARRANGMENT_PERMISSION());
    				}else if(portalId==1){
    					me.doAccessControlValidation(grid,me.getSTUDENT_LIVING_ARRANGMENT_PERMISSION());	
    				}
        			grid.getSelectionModel().deselectAll();
    				this.loadGridStore('#studentLivingArrangementGridItemId', SERVERURL.FIND_LIVING_ARRANGEMENT_GRID,grid);
    			},
 				cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
 					var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
 					if(columnName == "leaseAgreement"){
 						if(e.target.tagName=='A'){
 							var path = record.data.leaseAgreement;
	    				if(!isNullOrEmpty(path)) {
		    	       		var csvForm = Ext.create('Ext.form.Panel'); 
		    	       		csvForm.getForm().submit({
		    	       			target: '_blank',
		    	       			method:'POST',
		    	       			params :{
		    	       				access_token : Ext.Ajax.defaultHeaders.access_token,
		    	       				path: path
		    	       			},
		    	       			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		    	       			url: SERVERURL.PATH_FILE_DOWNLOAD_API,
		    	       			standardSubmit :true
		    	       		});
		    				}}
 					}
 				}
 			
    		},
            'livingarrangementdetailsform filefield[itemId=leaseAgreement]': {
                change: function(fileField, value, eOpts) {
                	var $this = this;
                    value = value.replace('C:\\fakepath\\', '');
                    var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                    fileField.setRawValue(newValue);
                    if (!isNullOrEmpty(newValue)) {
                        var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                        if ($this.isValidFileExtensionPDFWord(extension)) {
                            var file = fileField.fileInputEl.dom.files[0];
                            if (file.size / 1048576 > CONSTANTS.UPLOAD_FILE_SIZE_LIMIT) {
                                fileField.reset();
                                showWarningMessage(getCommonTranslation('LEASE_AGREEMENT'), getPersonModuleTranslation('FILE_SIZE_ERROR_MSG'));
                            }
                        } else {
                            fileField.reset();
                            showWarningMessage(getCommonTranslation('LEASE_AGREEMENT'), getCommonTranslation('LEASE_AGREEMENT_UPLOAD_VALID_FILE'));
                        }
                        var form = $this.getLivingarrangementdetailsform();
      					form.down('#availableLivingDocItemId').setValue("");
                    }
                }
            },
            'livingarrangementgrid[itemId=studentLivingArrangementGridItemId] button[itemId=btnDelete]': {
            	click: function(){
          		var this$ = this;
                var personProfile = this$.getContentPanelActiveTab();
                var grid = personProfile.down('#studentLivingArrangementGridItemId');
                if (grid.getSelectionModel().getCount() > 0) {
                    showConfirmMessage(getCommonTranslation('LIVING_ARRANGEMENT_ACTION'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                        if (btn == 'yes') {
                            if (grid.getSelectionModel().getCount() > 0) {
                                var records = grid.getSelectionModel().getSelection();
                                for (var count = 0; count < records.length; count++) {
                                    var id = "";
                                    if (!isNullOrEmpty(records[count].get("id"))) {
                                        id = records[count].get("id");
                                    }
                                    Ext.Ajax.request({
                                        type: 'rest',
                                        url: SERVERURL.LIVING_ARRANGEMENT_DELETE,
                                        method: 'DELETE',
                                        headers: {
                                            'Content-Type': 'application/json'
                                        },
                                        params: {
                                        	id: id
                                        },
                                        success: function(form, action) {
                                            grid.getStore().reload();
                                            showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('LIVING_ARRANGEMENT_DELETE_SUCCESS'));
                                        }
                                    });
                                }
                            }
                        }
                    });
                } else {
                    showWarningMessage(getPersonModuleTranslation('LIVING_ARRANGEMENT_ACTION'), getCommonTranslation('PLEASE_SELECT_RECORD'));
                	}
            	}
            },
            'livingarrangementdetailsform customcombobox#accommodationProviderId':{
            	select:function(obj,records) {
            		var this$ = this;
            		if(portalId == 3){
    					var form = this$.getLivingarrangementdetailsform();
    				}else{
    					var studentProfile = this$.getContentPanelActiveTab();
    					var personinfopanel = studentProfile.down('personinfopanel');
    					var form = personinfopanel.down('livingarrangementdetailsform');
    				}
            		var providerName = form.down('#providerNameId');
            		providerName.reset();
            		var providerContactdetails = form.down('#providerContactdetailsId');
            		providerContactdetails.reset();
            		var providerAddress = form.down('#providerAddressId');
            		providerAddress.reset();
            		if(records[0].data.accommodProviderName == 'Other'){
            			providerName.setReadOnly(false);
            			providerContactdetails.setReadOnly(false);
            			providerAddress.setReadOnly(false);
            		}else{
            			providerName.setValue(records[0].data.contactPerson);
            			providerContactdetails.setValue(records[0].data.mobileNo);
            			providerAddress.setValue(records[0].data.address);
            			providerName.setReadOnly(true);
            			providerContactdetails.setReadOnly(true);
            			providerAddress.setReadOnly(true);
            		}
            		
            		if(records[0].data.isIntellimaliRegistered != true)
            		{
            			form.down("#directPaymentId").setDisabled(true);
            			form.down("#directPaymentId").setValue({isDirectPayment:false});
            		}else{
            			form.down("#directPaymentId").setDisabled(false);
            		}
            		
            		var leaseAgreement = form.down('#leaseAgreement');
            		leaseAgreement.reset();
                	}
            },
            'livingarrangementdetailsform customcombobox#livingArrangementId':{
            	change:function(obj,records) {
              		var this$ = this;
              		if(portalId == 3){
    					var form = this$.getLivingarrangementdetailsform();
    				}else{
    					var studentProfile = this$.getContentPanelActiveTab();
    					var personinfopanel = studentProfile.down('personinfopanel');
    					var form = personinfopanel.down('livingarrangementdetailsform');
    				}
              		if(obj.getValue()=='PRIVATE_ACCOMMODATION'){
              			form.down('#roomAllocationId').setVisible(true);
              			form.down('#roomAllocationId').allowBlank = false;
              			form.down('#roomAllocationId').labelSeparator = '';
              			form.down('#roomAllocationId').setFieldLabel(getCommonTranslation('ROOM_ALLOCATION')+':<span class="required" style="color:red"> *</span>');
              			form.down('#address').setVisible(true);
              			form.down('#address').allowBlank = false;
              			form.down('#address').labelSeparator = '';
              			form.down('#address').setFieldLabel(getCommonTranslation('ADDRESS')+':<span class="required" style="color:red"> *</span>');
              			form.down('#accommodationProviderContainer').setVisible(true);
              			form.down('#accommodationProviderId').setVisible(true);
              			form.down('#accommodationProviderId').allowBlank = false;
              			form.down('#accommodationProviderId').labelSeparator = '';
              			form.down('#accommodationProviderId').setFieldLabel(getCommonTranslation('ACCOMMODATION_PROVIDER')+':<span class="required" style="color:red"> *</span>');
              			form.down('#providerNameId').setVisible(true);
              			form.down('#providerNameId').allowBlank = false;
              			form.down('#providerNameId').labelSeparator = '';
              			form.down('#providerNameId').setFieldLabel(getCommonTranslation('PROVIDER_NAME')+':<span class="required" style="color:red"> *</span>');
              			form.down('#providerContactdetailsId').setVisible(true);
              			form.down('#providerContactdetailsId').allowBlank = false;
              			form.down('#providerContactdetailsId').labelSeparator = '';
              			form.down('#providerContactdetailsId').setFieldLabel(getCommonTranslation('PROVIDER_CONTACT_DETAILS')+':<span class="required" style="color:red"> *</span>');
              			form.down('#providerAddressContainer').setVisible(true);
              			form.down('#providerAddressId').setVisible(true);
              			form.down('#providerAddressId').allowBlank = false;
              			form.down('#providerAddressId').labelSeparator = '';
              			form.down('#providerAddressId').setFieldLabel(getCommonTranslation('PROVIDER_ADDRESS')+':<span class="required" style="color:red"> *</span>');
              			form.down('#paymentContainer').setVisible(true);
              			form.down('#costId').setVisible(true);
              			form.down('#costId').allowBlank = false;
              			form.down('#costId').labelSeparator = '';
              			form.down('#costId').setFieldLabel(getCommonTranslation('COST')+':<span class="required" style="color:red"> *</span>');
              			form.down('#directPaymentId').setVisible(true);
              			form.down('#fileContainer').setVisible(true);
              			form.down('#leaseAgreement').setVisible(true);
              			form.down('#leaseAgreement').allowBlank = false;
              			form.down('#leaseAgreement').labelSeparator = '';
              			form.down('#leaseAgreement').setFieldLabel(getCommonTranslation('LEASE_AGREEMENT')+':<span class="required" style="color:red"> *</span>');
                  		
              			form.getForm().checkValidity();
              		}else if(obj.getValue()=='HOME'){
              			form.down('#roomAllocationId').setVisible(false);
              			form.down('#roomAllocationId').allowBlank = true;
              			form.down('#accommodationProviderId').setVisible(false);
              			form.down('#accommodationProviderId').allowBlank = true;
              			form.down('#providerNameId').setVisible(false);
              			form.down('#providerNameId').allowBlank = true;
              			form.down('#providerContactdetailsId').setVisible(false);
              			form.down('#providerContactdetailsId').allowBlank = true;
              			form.down('#accommodationProviderContainer').setVisible(false);
              			form.down('#providerAddressId').setVisible(false);
              			form.down('#providerAddressId').allowBlank = true;
              			form.down('#providerAddressContainer').setVisible(false);
              			form.down('#costId').setVisible(false);
              			form.down('#costId').allowBlank = true;
              			form.down('#costId').setFieldLabel(getCommonTranslation('COST'));
              			form.down('#directPaymentId').setVisible(false);
              			form.down('#paymentContainer').setVisible(false);
              			form.down('#leaseAgreement').setVisible(false);
              			form.down('#leaseAgreement').allowBlank= true;
              			form.down('#leaseAgreement').setFieldLabel(getCommonTranslation('LEASE_AGREEMENT'));
              			form.down('#fileContainer').setVisible(false);
              			form.down('#address').setVisible(true);
                  		form.down('#address').allowBlank = false;
                  		form.down('#address').labelSeparator = '';
              			form.down('#address').setFieldLabel(getCommonTranslation('ADDRESS')+':<span class="required" style="color:red"> *</span>');
              			
              			form.getForm().checkValidity();
                  		}
              		else {
              			form.down('#roomAllocationId').setVisible(true);
              			form.down('#roomAllocationId').allowBlank = false;
              			form.down('#roomAllocationId').labelSeparator = '';
              			form.down('#roomAllocationId').setFieldLabel(getCommonTranslation('ROOM_ALLOCATION')+':<span class="required" style="color:red"> *</span>');
              			form.down('#accommodationProviderContainer').setVisible(true);
              			form.down('#providerNameId').setVisible(true);
              			form.down('#providerNameId').allowBlank = false;
              			form.down('#providerNameId').labelSeparator = '';
              			form.down('#providerNameId').setFieldLabel(getCommonTranslation('PROVIDER_NAME')+':<span class="required" style="color:red"> *</span>');
              			form.down('#accommodationProviderId').setVisible(false);
              			form.down('#accommodationProviderId').allowBlank = true;
              			form.down('#leaseAgreement').setVisible(false);
              			form.down('#leaseAgreement').allowBlank= true;
              			form.down('#leaseAgreement').setFieldLabel(getCommonTranslation('LEASE_AGREEMENT'));
              			form.down('#costId').setVisible(false);
              			form.down('#costId').allowBlank = true;
              			form.down('#costId').setFieldLabel(getCommonTranslation('COST'));
              			form.down('#address').setVisible(false);
              			form.down('#address').allowBlank = true;
              			form.down('#address').setFieldLabel(getCommonTranslation('ADDRESS'));
              			form.down('#providerContactdetailsId').setVisible(false);
              			form.down('#providerContactdetailsId').allowBlank = true;
              			form.down('#providerAddressId').setVisible(false);
              			form.down('#providerAddressId').allowBlank = true;
              			form.down('#directPaymentId').setVisible(false);
              			form.getForm().checkValidity();
              		}
                	}
            },
            'studentbankdetailsgrid': {
    			render: function(grid) {
    				var me = this;
        			me.doAccessControlValidation(grid,me.getSTUDENT_BANK_DETAILS_PERMISSIONS());
        			var contantPanel = this.getContentPanel();
        			var studentProfile = contantPanel.getActiveTab();
        			var studentId = this.studentData.id;
        			var store = grid.getStore();
        			store.proxy.extraParams = {
        			  studentId : studentId
 					};
                  	store.load();	
    			}
    		},
    		'studentbankdetailsgrid button[itemId=btnAdd]':{
    			click:function(){
    				this.showBankDetailWin();
    			}
    		},
    		'studentbankdetailsgrid button[itemId=btnEdit]':{
    			click:function(){
    				var grid = this.getStudentbankdetailsgrid();
    				if (grid.getSelectionModel().getCount() > 0) {
    					this.showBankDetailWin();
    					this.editBankDetailsForm(grid);
    				}else{
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
    				}

    			}
    		},
    		'studentbankdetailsgrid button[itemId=btnView]':{
    			click:function(){
    				var grid = this.getStudentbankdetailsgrid();
    				if (grid.getSelectionModel().getCount() > 0) {
    					this.showBankDetailWin();
    					this.editBankDetailsForm(grid);
    					var bankDetailsWin = this.getBankdetailswindow();
    					var form = bankDetailsWin.down('form');
    					this.toggleReadOnlyFormItems(form.getForm(), true);
    					bankDetailsWin.down('#SubmitBtn').setVisible(false);
    				}else{
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
    				}

    			}
    		},
    		'studentbankdetailsgrid button[itemId=btnDelete]':{
    			click:function(){
    				var grid = this.getStudentbankdetailsgrid();
    				if (grid.getSelectionModel().getCount() > 0) {
    					showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
    						if (btn == 'yes') {
    							Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
    							var records = grid.getSelectionModel().getSelection();
    							var id = records[0].get("id");
    							Ext.Ajax.request({
    								method : "DELETE",
    								type : 'rest',
    								url : SERVERURL.PATH_DELETE_STUDENT_BANK_DETAILS +'?id='+ id,
    								headers : {
    									'Content-Type' : 'application/json'
    								},
    								params: {
    									id: id
    								},
    								success : function(form,action) {
    									Ext.getBody().unmask();
    									grid.getStore().reload();
    									showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
    								}
    							});
    						}
    					});
    				}else{
    					showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    				}

    			}
    		},
    		'bankdetailswindow button[itemId=SubmitBtn]':{
    			click:function(btn){
    				this.saveBankDetailPopUpForm();
    				btn.setDisabled(true);
    				
    			}
    		},
    		'bankdetailswindow button[itemId=CancelBtn]':{
    			click:function(){
    				var bankDetailsWin = this.getBankdetailswindow();
    				bankDetailsWin.close();
    			}
    		},
    		'bankdetailswindow customcombobox[itemId=bankDrawnOnMasterId]': {
    			change: function(obj, newValue) {
    				var bankDetailsWin = this.getBankdetailswindow();
    				var ifscCodeId = bankDetailsWin.down('#ifscCodeId');
    				var branchNameId = bankDetailsWin.down('#branchNameId');
    				branchNameId.setDisabled(false);
    				ifscCodeId.setDisabled(false);
    				var ifscCodeValue= bankDetailsWin.down('#ifscCodeId').getValue();
    				var bankIdValue=bankDetailsWin.down('#bankDrawnOnMasterId').getValue();
    				var ifscCodeId = bankDetailsWin.down('#ifscCodeId');
    				if(bankIdValue>0){
    					ifscCodeId.getStore().getProxy().extraParams = {
    						bankNameId:bankIdValue,

    					}
    					ifscCodeId.getStore().load();
    					branchNameId.getStore().getProxy().extraParams = {
    						bankNameId:bankIdValue,
    					}
    					branchNameId.getStore().load();}
    			},
    			select:function(){
    				var bankDetailsWin = this.getBankdetailswindow();
    				var ifscCodeId = bankDetailsWin.down('#ifscCodeId');
    				ifscCodeId.reset();      
    				var branchNameId = bankDetailsWin.down('#branchNameId');
    				branchNameId.reset();
    			}
    		},
    		'bankdetailswindow customcombobox[itemId=branchNameId]': {
    			select: function(obj, newValue) {
    				var bankDetailsWin = this.getBankdetailswindow();
    				var ifscCodeId = bankDetailsWin.down('#ifscCodeId'); 
    				var branchNameId = bankDetailsWin.down('#branchNameId').getValue();
    				var ifscCodeValue= bankDetailsWin.down('#ifscCodeId').getValue();
    				var bankIdValue=bankDetailsWin.down('#bankDrawnOnMasterId').getValue();
    				ifscCodeId.getStore().load({
    					params: {
    						bankNameId:bankIdValue,
    						branchNameId:branchNameId
    					},
    					callback: function(records, opt, success){
    						if (success) { 
    							ifscCodeId.setValue(records[0].data.id);    
    						}
    					}    
    				});

    			}  
    		},
    		'bankdetailswindow customcombobox[itemId=ifscCodeId]': {
    			select: function(obj, newValue) {
    				var form = this.getBankdetailswindow();
    				var bankIdValue=form.down('#bankDrawnOnMasterId').getValue();
    				var branchNameId = form.down('#branchNameId');
    				var ifscValue = form.down('#ifscCodeId').getValue();
    				var ifscCodeId = form.down('#ifscCodeId');
    				var branchNameValue = form.down('#branchNameId').getValue();
    				if(ifscValue>0){ 
    					branchNameId.getStore().load({
    						params: {
    							bankNameId:bankIdValue,
    							ifscCode:ifscValue
    						},
    						callback: function(records, opt, success){
    							if (success) { 
    								branchNameId.setValue(records[0].data.id);    
    							}
    						}    
    					});

    				}  
    			}  
    		},      
	            'feepayerdetailform[itemId=personfeepayerdetailformItemId] customcombobox[itemId=homeTelephoneCountryCodeItemId]': {
	            	select: function(rowModel, record){
	            		var form = this.getParentFeePayerDetailForm();
	            		var countryCodeField = form.down("#homeTelephoneCountryCodeItemId");
	                	var mobileField = form.down("#homeTelephoneItemId");
	                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
	                }
	            },
	            
	            'feepayerdetailform[itemId=personfeepayerdetailformItemId] numberfield[itemId=homeTelephoneItemId]': {
	            	change: function(record){
	            		var form = this.getParentFeePayerDetailForm();
	                	var mobileField = form.down("#homeTelephoneItemId");
	                	mobileField.isValid();
	        			form.getForm().checkValidity();
	                }
	            },
	            
	            'feepayerdetailform[itemId=personfeepayerdetailformItemId] customcombobox[itemId=workTelephoneCountryCodeItemId]': {
	            	select: function(rowModel, record){
	            		var form = this.getParentFeePayerDetailForm();
	                	var countryCodeField = form.down("#workTelephoneCountryCodeItemId");
	                	var mobileField = form.down("#workTelephoneItemId");
	                	this.setMaximumMinimumDigitsForMobileNoValidation(form,countryCodeField,mobileField,record);
	                }
	            },
	            'feepayerdetailform[itemId=personfeepayerdetailformItemId] combo#countryId': {
	                select: function(combo, record) {
	                	var newValue=record[0].data.id;
	                	var regionComboBox = combo.up('form').down('customcombobox#parentCountryRegionId'); 
	                	var cityComboBox = combo.up('form').down('customcombobox#cityId');
	                	cityComboBox.reset();
	                	regionComboBox.reset();
	                    cityComboBox.setDisabled(true);
	                    regionComboBox.setDisabled(false);
	                    this.onCountryChange(combo, record, this.getParentFeePayerDetailForm());
	                    combo.up('form').getForm().checkValidity();
	                }
	            },
	            'feepayerdetailform[itemId=personfeepayerdetailformItemId] customcombobox#parentCountryRegionId': {
	            	 select: function(obj1, record) {
	                     var cityComboBox = obj1.up('form').down('customcombobox#cityId');
	                     var countryComboBox = obj1.up('form').down('customcombobox#countryId');
	                     cityComboBox.setDisabled(false);
	                     cityComboBox.reset();
	                     
	                     var countryRegionIdVal = record[0].get("id");
	                     var countryIdVal = countryComboBox.getValue();
	                     var cityStore = cityComboBox.getStore();
	                     cityStore.getProxy().extraParams = {
	                    	 countryId: countryIdVal,
	                    	 countryRegionId: countryRegionIdVal
	                     };
	                     cityStore.reload();
	                     obj1.up('form').getForm().checkValidity();
	                 }
	            },
	            'feepayerdetailform[itemId=personfeepayerdetailformItemId] checkboxfield#isSameAsCurrentAddress': {
	         	   change: function(obj,newValue,oldValue) {
	          		   var form = obj.up('form');          		  
	          		   
	          		   if(newValue || newValue == true){             			   
	          			  this.getPersonCurrentAddressDetail(form,SERVERURL.PERSON_CURRENT_ADDRESS,true);          			  
	          		   } 
	          		   else{
	          			  this.getPersonCurrentAddressDetail(form,SERVERURL.PERSON_CURRENT_ADDRESS,false);               			 
	          		   }
			}
	       },
	       'manageholdsstructure':{
	    	 afterrender:function(structure){
	    		 this.hideTabsBasedOnPermission(structure)
	    	 }  
	       },
	       'financeholdinnertab button[itemId=resetButtonId]':{
	       		click: function(btn) {
	       		 var form = btn.up('financeholdinnertab');
       			 var holdType = form.down('#holdType');
	       			holdType.reset();
	       			
	       		 }
	       	   },
	    	   'financeholdinnertab customcombobox[itemId=holdType]':{
		   			  render:function(combo){
		  				  $this = this;
		  				  var store = combo.getStore(); 
		  				  store.on('load', function(){
		  						  var filterItemIds = ['EXAM_ENROLLMENT'];
		  						  var storeItems = store.getRange();
		  						  for(var i = 0; i<storeItems.length; i++){     
		  							  if(Ext.Array.contains(filterItemIds, storeItems[i].get('id')))
		  								  store.remove(store.getById(storeItems[i].get('id')));            
		  						  }  
		  				  });

		  			  }
		  		  },
	       	  'financeholdinnertab button#searchButtonId':{
	       		  click: function(btn) {
	       			  var form = btn.up('financeholdinnertab');
	       			  var grid = form.down('studentfinanceholdsgrid');
	       			  var holdType = form.down('#holdType').getValue();
	       			  var personProfile = this.getContentPanelActiveTab();
	       			  var store = grid.getStore();
	       			 
	       				  store.getProxy().extraParams = {
	       					  financeHoldType: holdType,
	       					  studentId:personProfile.getUserId()
	       				  };
	       			  this.resetPageSetting(store);
	       			  grid.config.searchFilterForm =form;
	       			  store.load();
	       		  }
	       	  },
	       'manageholdinnertab button[itemId=resetButtonId]':{
       		click: function(btn) {
       			var structure = btn.up('manageholdinnertab');
       			var applyHoldAt = structure.down('#applyHoldAt');
       			var holdSubCatStatus = structure.down('#holdStatus');
       		//	holdAndFinanceHoldRadio.reset();
       			applyHoldAt.reset();
       			holdSubCatStatus.reset();
       		 }
       	   },
       	  'manageholdinnertab button#searchButtonId':{
       		  click: function(btn) {
       			  var structure = btn.up('manageholdinnertab');
       			  var grid = structure.down('studentholdsgrid');
       			  var applyHoldAt = structure.down('#applyHoldAt').getValue();
       			  var status = structure.down('#holdStatus').getValue();
       			  var personProfile = this.getContentPanelActiveTab();
       			  var store = grid.getStore();
       			  if(isNullOrEmpty(status)){
       				  store.getProxy().extraParams = {
       					  applyHoldAt: applyHoldAt,
       					  studentId:personProfile.getUserId()
       				  };
       			  }else{
       				  store.getProxy().extraParams = {
       					  applyHoldAt: applyHoldAt,
       					  isRemovedData:status,
       					  studentId:personProfile.getUserId()
       				  };
       			  }
       			  grid.config.searchFilterForm =structure;
       			  this.resetPageSetting(store);
       			  store.load();
       		  }
       	  },
       	 'manageholdinnertab customcombobox[itemId=applyHoldAt]':{
			  render:function(combo){
				  $this = this;
				  var store = combo.getStore(); 
				  store.on('load', function(){
						  var filterItemIds = ['EXAM_ENROLLMENT'];
						  var storeItems = store.getRange();
						  for(var i = 0; i<storeItems.length; i++){     
							  if(Ext.Array.contains(filterItemIds, storeItems[i].get('id')))
								  store.remove(store.getById(storeItems[i].get('id')));            
						  }  
				  });

			  }
		  },
		  'studentfinanceholdsgrid':{
			  afterrender:function(grid){
				  var studentProfilePanel = grid.up('studentprofile');
          		  var structure = studentProfilePanel.down('panel')
          		  this.getGridHeaderFreeze(grid,structure,true)
                  
			  }
		  },
		  
			 'studentholdsgrid[itemId=studentholdsDetailsgrid]': {
	            	render: function(grid) {
	            		var this$ = this;
	            		this.doAccessControlValidation(grid, this.getSTUDENT_HOLDS_PERMISSIONS());
	            		this.doAccessControlValidationOfStudentHolds(grid, this.getSTUDENT_HOLDS_PERMISSIONS(),'HOLDS');
	            		var studentProfilePanel = grid.up('studentprofile');
	            		var structure = studentProfilePanel.down('panel')
	            		this.getGridHeaderFreeze(grid,structure,true)
	                    var personProfile = this$.getContentPanelActiveTab();
	            		
	            		try{
	                    	if((portalId == 3 || portalId == 7) && personProfile.xtype == "dashboardhomepage"){
	                    		var contentPanel = this$.getContentPanel();
	                    		var personProfile = contentPanel.items.items[1];
	                    	}
	                	}
	                	catch(e){
	                		//
	                	}
	            		
	            		
	                    var personObj = this$.getPersonObj();
	                    var grid = personProfile.down('#studentholdsDetailsgrid');
	                    if (grid) {
	                        var studentId = personObj["id"];
	                        var store = grid.getStore();
	                        store.getProxy().api.read = SERVERURL.PATH_STUDENT_APPLY_HOLD_CATEGORY_GRID;
	                        store.getProxy().extraParams = {
	                        	studentId: personProfile.getUserId(),
	                        	applyHoldAt: ''
	                        };
	                        this.resetPageSetting(store)
	                        store.load();
	                    }
	            		
	            	
	            	},
	            	 cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
               			var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
               			var personProfile = this.getContentPanelActiveTab();
		                    var grid1 = personProfile.down("#studentholdsDetailsgrid");

               			if(record.data.isRemoval==true){
               			grid1.down("#removeHold").setDisabled(true);
               		
               			}else{
               				grid1.down("#removeHold").setDisabled(false);
               				
               			}}
	            },
	            'studentholdsgrid[itemId=studentholdsDetailsgrid] button[itemId=removeHold]': {
	            	click: function() {
	            		var formWindow = this.getPersonCommonWindow();
	            		this.StudentRemovalWin(formWindow, 'REMOVE_HOLDS', 'studentremoveholdsform','#studentholdsDetailsgrid', true);
	            	}
	            },
	            
	            'studentholdsgrid[itemId=studentholdsDetailsgrid] button[itemId=applyHold]': {
	            	click: function() {
	            		var this$=this;
	            		var formWindow = this.getPersonCommonWindow();
	            		this.showPersonCommonWindow(formWindow, 'APPLY_HOLDS', 'studentapplyholdsform', true);
	            		var form = this$.getStudentapplyholdsform();
	            		var holdCatStudent=	form.down("#holdCatStudent");
	            		var personProfile = this$.getContentPanelActiveTab();
                        var admissionId = personProfile.admissionId;
                        var seatConfigId = personProfile.getProgramBatchSeatTypeConfigId();

                        if (!seatConfigId) {
                            Ext.Ajax.request({
                                method: 'GET',
                                type: 'rest',
                                url: SERVERURL.FIND_PROG_BATCH_SEAT_CONFIG_ID_BY_ADMISSION_ID,
                                params: {
                                    admissionId: admissionId
                                },
                                success: function(response) {
                                    Ext.getBody().unmask();

                                    var respObj = Ext.decode(response.responseText);

                                    if (respObj) {
                                        seatConfigId = respObj;

                                        // Save back to active tab (optional but recommended)
                                        personProfile.setProgramBatchSeatTypeConfigId(seatConfigId);

                                            var holdCatStudentStore = holdCatStudent.getStore();
                                            holdCatStudentStore.getProxy().extraParams = {
                                                seatConfigId: seatConfigId
                                            };
                                            holdCatStudentStore.load();

                                    }
                                }
                            });
                        } else {
	            	            var holdCatStudentStore =holdCatStudent.getStore();
	                            holdCatStudentStore.getProxy().extraParams = {
                                seatConfigId: seatConfigId
   				                };
	            	        holdCatStudentStore.load();
	                    }
                    }
	         },
	         'studentapplyholdsform combo#subHoldCatStudent': {
	                select: function(combo, record) {
	                	var form = this.getStudentapplyholdsform();
	            		this.setApplyHoldAtOnApplyHoldWindow(form);
	                }
	         },
	         'studentholdsgrid[itemId=studentholdsDetailsgrid] button[itemId=deleteHold]': {
	            	click: function(btn) {
	            		var grid = btn.up('grid');
	                	var records = grid.getSelectionModel().getSelection();
	                	var empAvailIds=[];
	                    if(!isNullOrEmpty(records) && records.length > 0) {
	                        for( var i=0; i<records.length; i++ ) {
	                           if(!isNullOrEmpty(records[i].data.id)){
	                           empAvailIds.push(records[i].data.id);
	                        }
	                     }
	                    }
	                    var Ids = empAvailIds.join(',');
	                	if (grid.getSelectionModel().getCount() > 0) {
	                		showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
	                			if (btn == 'yes') {
	                				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	                				Ext.Ajax.request({
	                					method : "GET",
	                					type : 'rest',
	                					url : SERVERURL.PATH_STUDENT_APPLY_HOLD_CATEGORY_DELETE +'?studentHoldIds='+ Ids,
	                					headers : {
	                						'Content-Type' : 'application/json'
	                					},
	                					/*params: {
	                						studentHoldIds: Ids //deu to nonse issue
	            						},*/
	                					success : function(form,action) {
	                						Ext.getBody().unmask();
	                						grid.getStore().reload();
	                						showSuccessMessage(getCommonTranslation('MANAGE_HOLD'), getCommonTranslation('RECORD_DELETE_SUCCESS'));
	                					}
	                				});
	                			}
	                		});
	                	}else{
	            			 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
	            		}
	            	}
	            },
	         	            //},
	            'personcommonwindow[itemId=personCommonWindow] studentapplyholdsform  combo[itemId=applyById]':{
     			   render: function(obj){
     				   var this$=this;
     				   var store = obj.getStore();
     				   store.getProxy().extraParams = {
     					   academyLocationIds:this.getCurrentAcademyLocation()
     				   };
     				   //store.load();
     				  var formWindow = this$.getPersonCommonWindow();
     			       var form = formWindow.down('studentapplyholdsform');
     				   var userId=this.getCurrentlyLoggedInUser();
     				   var applyById = form.down("#applyById");
     				  applyById.store.load({
     					   callback : function(operation,success) {
     						   if (success) {
     							  applyById.setValue(userId.id);
    			    				}
    			    			} 
    			    		});
     			   }
     		   }, 
     		   'personcommonwindow[itemId=personCommonWindow] studentapplyholdsform button[itemId=cancelButtonId]': {
               	click: this.closePersonCommonWindow
               },
               'personcommonwindow[itemId=personCommonWindow] studentapplyholdsform button[itemId=submitButtonId]': {
               	click: function(){
               		this.saveStudentApplyHold('#studentholdsDetailsgrid', SERVERURL.PATH_STUDENT_APPLY_HOLD_CATEGORY_SAVE, SERVERURL.PATH_STUDENT_APPLY_HOLD_CATEGORY_UPDATE);
               	}
               },
               'personcommonwindow[itemId=personCommonWindow] studentremoveholdsform  combo[itemId=removalById]':{
     			   render: function(obj){
     				   var this$=this;
     				   var store = obj.getStore();
     				   store.getProxy().extraParams = {
     					   academyLocationIds:this.getCurrentAcademyLocation()
     				   };
     				   //store.load();
     				  var formWindow = this$.getPersonCommonWindow();
     			       var form = formWindow.down('studentremoveholdsform');
     				   var userId=this.getCurrentlyLoggedInUser();
     				   var removalById = form.down("#removalById");
     				  removalById.store.load({
     					   callback : function(operation,success) {
     						   if (success) {
     							  removalById.setValue(userId.id);
    			    				}
    			    			} 
	         
        });
     			   }
     		   }, 
     		  'personcommonwindow[itemId=personCommonWindow] studentremoveholdsform button[itemId=cancelButtonId]': {
                 	click: this.closePersonCommonWindow
    },
                 'personcommonwindow[itemId=personCommonWindow] studentremoveholdsform button[itemId=submitButtonId]': {
                    	click: function(){
                    		this.saveStudentRemoveHold('#studentholdsDetailsgrid', SERVERURL.PATH_STUDENT_APPLY_HOLD_CATEGORY_UPDATE);
                    	}
                    },
                    'personcommonwindow[itemId=personCommonWindow] studentapplyholdsform combo[itemId=holdCatStudent]': {
                      	 select:function(obj1,records) {
                      	 var subHoldCatStudent = obj1.up('form').down('customcombobox#subHoldCatStudent');
                      	 var applyHoldAtProfile = obj1.up('form').down('#applyHoldAtProfile');
                              subHoldCatStudent.reset();
                              applyHoldAtProfile.reset();
                              subHoldCatStudent.setDisabled(false);
                         var armsOfServiceIdVal = records[0].get("id");
                         var subHoldCatStudentStore = subHoldCatStudent.getStore();
                         subHoldCatStudentStore.getProxy().extraParams = {
                        	 holdCategoryId: armsOfServiceIdVal
                         };
                         subHoldCatStudentStore.load();
                      	 }
                      },
			'personalinformationform[itemId=studentPersonalInformationForm] button[itemId=validateID]': {
				click: function(obj) {
					var $this = this;
					var personalInformationForm = obj.up('personalinformationform');
					if(personalInformationForm){
						var data = personalInformationForm.getValues()
					}
					var idTypeCodeValue = personalInformationForm.down('#idTypeCombo').getStore().findRecord('id',data.idtype);
					if(!isNullOrEmpty(data.nationality)){
						 var index = personalInformationForm.down('#nationalityCombo').getStore().findExact('id',data.nationality.id);
						  if(index !== -1){
							   var nationalityCodeValue = personalInformationForm.down('#nationalityCombo').getStore().getAt(personalInformationForm.down('#nationalityCombo').getStore().findExact('id',data.nationality.id));
						  } 
						
					}
					if(!isNullOrEmpty(data.secondaryCitizenship)){
						 var index = personalInformationForm.down('#stuSecondaryCitizenshipItemId').getStore().findExact('id',data.secondaryCitizenship.id);
						  if(index !== -1){
							   var secondaryCitizenshipValue = personalInformationForm.down('#stuSecondaryCitizenshipItemId').getStore().getAt(personalInformationForm.down('#stuSecondaryCitizenshipItemId').getStore().findExact('id',data.secondaryCitizenship.id));
						  } 
					}
					
					var uwcUrl = SERVERURL.PATH_GET_FIND_BY_RELEVANT_TO;
					Ext.Ajax.request({
						type: 'rest',
						url: uwcUrl + '?relavantToFormType=' + "DIRECT_ADMISSION",
						method: 'GET',
						success: function(response, action) {
							Ext.getBody().unmask();
							if (!isNullOrEmpty(response.responseText) && (response.responseText) != "") {
								var responseData = Ext.JSON.decode(response.responseText);
								if (responseData != null) {
									$this.checkUwcNationalIdValidation(responseData, data, nationalityCodeValue, idTypeCodeValue);
								}
							}
							else {
					if(!isNullOrEmpty(idTypeCodeValue) && idTypeCodeValue.data.idTypeCode == 'NATIONAL_ID'){
						var nationalId = data.nationalID;
						var birthDate = data.birthDate;
						var gender = data.genderCSM;
						var message = '';
						if(!isNullOrEmpty(nationalId)){
							if(nationalId.length > 13 || nationalId.length<13){
								message = message+getCommonTranslation('NATIONALID_SHOULDBE_13DIGITS')+'<br>';
							}
							if(!isNumberValidate(nationalId)){
								message = message+getCommonTranslation('NATIONALID_CANBE_ONLYDIGITS')+'<br>';
							}
							if(nationalId.length > 5 && !isNullOrEmpty(birthDate)){
								var splitDOB = birthDate.split('-');
								var dobYear = splitDOB[0].substr(-2);
								var dobMonth = splitDOB[1];
								var dobDay = splitDOB[2];
								var dateOfBirth = dobYear+dobMonth+dobDay;
								var firstSixDigit = nationalId.substr(0,6);
								if(firstSixDigit != dateOfBirth){
									message = message+getCommonTranslation('INVALID_DOB_ID_NUMBER_PROVIDED')+'<br>';
								}
							}
                  
							if(nationalId.length > 9 && !isNullOrEmpty(gender)){
								var sevenToTenDigit = nationalId.substr(6,4);
								if((gender.id == 2 && (sevenToTenDigit>=0 && sevenToTenDigit<=4999)) || (gender.id == 1 && (sevenToTenDigit>=5000 && sevenToTenDigit<=9999))){
								
								}else{
									message = message+getCommonTranslation('INVALID_GENDER_IDNUMBER_PROVIDED')+'<br>';
								}
							}
							var eleventhDigit = nationalId.substr(10,1);
							if(nationalId.length > 10 && eleventhDigit == 0 && ((isNullOrEmpty(nationalityCodeValue) && secondaryCitizenshipValue.data.code != 'South African')||(isNullOrEmpty(secondaryCitizenshipValue) && nationalityCodeValue.data.code != 'South African') || ((!isNullOrEmpty(nationalityCodeValue) && nationalityCodeValue.data.code != 'South African') && (!isNullOrEmpty(secondaryCitizenshipValue) && secondaryCitizenshipValue.data.code != 'South African')))){
								message = message+getCommonTranslation('INVALID_CITIZENSHIP_IDNUMBER_PROVIDED')+'<br>';
							}else if(nationalId.length > 10 && eleventhDigit == 1 && data.isPermanentResident != true ){
								message = message+getCommonTranslation('INVALID_PERMANENT_RESIDENT_DETAILS')+'<br>';
							}else if(nationalId.length > 10 && eleventhDigit>1){
								message = message+getCommonTranslation('INVALID_DETAILS_ID_NUMBER_PROVIDED')+'<br>';
							}
							if(message !='')
							{
								showNotificationMessage(getCommonTranslation('ITENDITY_NO_NATIONALID_VALIDATION'), message);
							}else{
								showOkWithSuccessMessage(getCommonTranslation('ITENDITY_NO_NATIONALID_VALIDATION'), getCommonTranslation('NATIONALID_IS_VALID'));
							}
						}	
					}
				}	
			   }
			  });	
			 }
			} ,
            
            'permitgrid[itemId=studentPermitGrid]': {
            	render: function(grid) {
            		var $this = this;
            		$this.loadGridStore('#studentPermitGrid', SERVERURL.PATH_PERMIT_DETAIL_GRID_DATA);
            		var portalId = this.getCurrentLoggedPortalId();
        			if (portalId == 3){
        					$this.doAccessControlValidation(grid, $this.getSTUDENT_PORTAL_PERMIT_PERMISSION());
        					var structure = grid.up('personinfostudentportal');
        					$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
        				   
        			}else if (portalId == 7) {
        					$this.doAccessControlValidation(grid,$this.getPARENT_PORTAL_PERMIT_PERMISSION());
        					var structure = grid.up('personinfostudentportal');
        					$this.getGridHeaderFreezeStudentProfile(grid,structure,true);
        				
        			}else if (portalId == 2){
        				this.doAccessControlValidation(grid,this.getFACULTY_PORTAL_PERMIT_PERMISSION());
        			}else{
        				$this.doAccessControlValidation(grid, $this.getPERMIT_DETAIL_PERMISSION());
            		    var studentProfilePanel = grid.up('studentprofile');
                	    var structure = studentProfilePanel.down('[region=center]');
                	    var  store = grid.getStore();
                        store.load({
                               callback:function() {
                                   if(store.getCount()>5) {
                                       $this.getGridHeaderFreezeStudentProfile(grid,structure,true);
                                   }            
                               }
                           });
                	
        			}
            		
            	},
            	afterrender:function(grid){
    				var me = this;
    				me.addDataGridConfigButton(grid,me.getPERMIT_DETAIL_PERMISSION());
    			},
    			selectionchange: function(column, selected,eOpts ){
            		var grid = column.view.up('grid');
                	if(selected.length > 1){
                		grid.down('#btnAdd').setDisabled(true);
                		grid.down('#btnEdit').setDisabled(true);
                		grid.down('#btnView').setDisabled(true);
                	}else if(selected.length==1){
//                		grid.down('#btnAdd').setDisabled(true);
                		grid.down('#btnEdit').setDisabled(false);
                		grid.down('#btnView').setDisabled(false);
                	}else{
                		grid.down('#btnAdd').setDisabled(false);
                		grid.down('#btnEdit').setDisabled(false);
                		grid.down('#btnView').setDisabled(false);
                	}
    			},
    			cellclick : function(grid, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts) {
	 				var columnName = grid.ownerCt.columnManager.columns[ColIdx].dataIndex;
	 				if(columnName == "permitDetailDocuments"){
	 					if(e.target.tagName=='A'){
	 						if(record.data.permitDetailDocuments.length == 1){
	 							var whetherFile = false;
								var documentId= record.data.permitDetailDocuments["0"].id;
								if(!isNullOrEmpty(documentId)){
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
										method: 'GET',
										callback : function(opt, success, response){
											if(response.responseText == 'true') {
												var csvForm = Ext.create('Ext.form.Panel'); 
												csvForm.getForm().submit({
													target: '_blank',
													method:'GET',
													params :{
														access_token : Ext.Ajax.defaultHeaders.access_token
													},
													headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
													url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
													standardSubmit :true
												});
											} else {
												showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
											}
										}
									});
								}
	 						}
	 						else if(record.data.permitDetailDocuments.length > 1){
	 							var docWindow = this.getPermitdocumentlist();
	 							var ID = record.data.id;
	 							if (!docWindow) {
	 								docWindow = Ext.widget('permitdocumentlist',{
	 									itemId:'permitdocumentlist'
	 								});
	 							}
	 							docWindow.show();
	 							var permitdocumentlistgrid = docWindow.down('#permitdocumentlistgridItemId');
	 							var store = permitdocumentlistgrid.getStore();
	 							store.getProxy().extraParams = {
	 								ID: record.data.id
	 							};
	 							store.load();
	 						}
	 					}
	 				}
	 				if(columnName == "permitDetailUrlDocuments"){
	 					if(e.target.tagName=='A'){
	 						if(record.data.permitDetailUrlDocuments.length > 1){    	
	 							var docWindow = this.getPermiturldocumentlist();
	 							var ID = record.data.id;
	 							if (!docWindow) {
	 								docWindow = Ext.widget('permiturldocumentlist',{
	 									itemId:'permiturldocumentlist'
	 								});
	 							}
	 							docWindow.show();
	 							var permiturldocumentlistgrid = docWindow.down('#permiturldocumentlistgridItemId');
	 							var store = permiturldocumentlistgrid.getStore();
	 							store.getProxy().extraParams = {
	 								ID: record.data.id
	 							};
	 							store.load();
	 						}
	 					}
	 				}
	 			}
            },
            'permitgrid[itemId=studentPermitGrid] button[itemId=btnAdd]': {
            	click: function() {
            		var $this = this;
            		var formWindow = $this.getPersonCommonWindow();
            		$this.showPersonCommonWindow(formWindow, 'PERMIT_DETAILS', 'studentPermitDetailFormId', true);
            	}
            },
            'permitgrid[itemId=studentPermitGrid] button[itemId=btnEdit]': {
            	click: function() {
            		var $this = this;
            		$this.editPermitDetail('PERMIT_DETAILS', 'studentPermitDetailFormId', '#studentPermitGrid', false);
            		$this.loadPermitDocumentWindow();
            		$this.loadPermitDocumentUrlWindow();
            	}
            },
            'permitgrid[itemId=studentPermitGrid] button[itemId=btnView]': {
            	click: function() {
            		var $this = this;
            		$this.viewPermitDetail('PERMIT_DETAILS', 'studentPermitDetailFormId', '#studentPermitGrid');
            		$this.loadPermitDocumentWindow();
            		$this.loadPermitDocumentUrlWindow();
            		var form = $this.getPermitdetailform();
            		form.isValid();
            	}
            },
            'permitgrid[itemId=studentPermitGrid] button[itemId=btnDelete]': {
            	click: function() {
            		var $this = this;
            		$this.deletePermitDetail('#studentPermitGrid', SERVERURL.PATH_PERMIT_DETAIL_DELETE, 'PERMIT_DETAIL_DELETE_SUCCESSFULLY');
            	}
            },
            'permitdetailform[itemId=studentPermitDetailFormId] checkboxfield[itemId=isPrimaryItemId]' : {
                change:function(val) {
                    var form= this.getPermitdetailform();
                    var id = form.down("#permit_detail_hidden_field");
                    var isPrimaryFiled=form.down('#isPrimaryItemId');
   	 				var gridStore  = this.getPermitgrid().getStore();
   	 				if(isNullOrEmpty(id)){
   	 					if(gridStore.data.items.length!=null){
   	 						gridStore.data.items.forEach(function(itemObj){
   	 							if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)){
   	 								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
   	 								isPrimaryFiled.setValue(false);
   	 							}
   	 						});
   	 					}
   	 				}else{
   	 					if(gridStore.data.items.length!=null){
   	 						gridStore.data.items.forEach(function(itemObj){
   	 							if(!isNullOrEmpty(itemObj.data.isPrimary)&&(itemObj.data.isPrimary==true)&&(itemObj.data.id != Number(id.getValue()))){
   	 								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PRIMARY_RECORD_ALREADY_EXIST'));
   	 								isPrimaryFiled.setValue(false);
   	 							}
   	 						});
   	 					}
   	 				}
                }
            },
            'permitdetailform[itemId=studentPermitDetailFormId] button[itemId=uploadPermitDocItemId]': {
            	click : function() {
	 				this.getDocumentController().showDocumentFormWindow('permit_detail_hidden_field','DOCUMENT');
	 				setTimeout(function(){
			            var form = Ext.ComponentQuery.query('simpledocumentform')[0];
 			            form.down('#documentNameField').allowBlank=true;
 			            form.down('#documentNameField').setFieldLabel(getCommonTranslation('DOCUMENT_NAME'));
            		},100); 
	 			}
            },
            'permitdetailform[itemId=studentPermitDetailFormId] button[itemId=uploadPermitUrlItemId]': {
            	click : function() {
	 				this.getDocumentController().showDocumentFormWindow('permit_detail_hidden_field','DOCUMENT_URL');
	 				var formWindow = this.getDocumentformwindow();
 					if (!formWindow) {
 						Ext.widget('documentformwindow');
 						formWindow = this.getDocumentformwindow();
 					}
 					formWindow.setTitle(getCommonTranslation('URL_DETAILS'));
	 			}
            },
            'documentformwindow[itemId=permit_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
	 	    	click : function() {
	 			var $this = this;
	 			var isTransient = true;
	 			var module = 'studentPermit';
	 			var entityId;
	 			var entityType = 'studentPermitDocument';
	 			$this.getDocumentController().saveDocumentForm(entityId,module,entityType,'DOCUMENT',
	 					function(success,response,isCallBackTransient) {
	 				fields : ['id','name','documentName','submissionDate','path','createdBy','status','documentIdCount']
	 						var documentModel = new Academia.model.personinfo.common.personalinfo.PermitDocumentGridModel();
	 						documentModel.set("name",response.name);
	 						documentModel.set("path",response.path);
	 						documentModel.set("type",response.type);
	 						documentModel.set("documentName",response.name);
	 						documentModel.set("createdBy",$this.getIdValueJson(response.createdBy.id,response.createdBy.value));
	 						if(documentModel.data.path.length > 255){
	                              showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FILE_NAME_CHARACTER_LIMIT_EXCEED'));
	                          }else {
			 						var StudentPermitDocGrid = $this.getPermitdocumentgrid();
			 						var store = StudentPermitDocGrid.getStore();
			 						store.add(documentModel);
			 						if (StudentPermitDocGrid.isHidden() && store.data.items.length > 0) {
			 							StudentPermitDocGrid.setVisible(true);
			 						}
			 						$this.getDocumentController().closeDocumentFormWindow();
			 						showSuccessMessage(getCommonTranslation('PERMIT_DOCUMENT'),getCommonTranslation('PERMIT_DOCUMENT_ADD_SUCCESSFULLY'));
	                          }
	 					}, isTransient);
	 	    	}
		 	},
		 	
		 	'documentformwindow[itemId=permit_detail_hidden_field] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
		 		click : function() {
		 			this.getDocumentController().closeDocumentFormWindow();
		 		}
		 	},
		 	'documentformwindow[itemId=permit_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentFormSubmitButtonId' : {
	 	    	click : function() {
		 			var $this = this;
		 			var form = Ext.ComponentQuery.query('simpleurlform')[0];
		            form.down('#documentFormSubmitButtonId').setDisabled(true);
		            fields : ['id','documentId','documentName','path','createdBy']
		            var documentModelUrl = new Academia.model.personinfo.common.personalinfo.PermitUrlDocumentGridModel();
		            var form = Ext.ComponentQuery.query('simpleurlform')[0];
	
		            var documentName=form.down('#documentNameField').getValue();
		            var UrlName=form.down('#documentUrlField').getValue();
		            documentModelUrl.set("documentName",documentName);
		            documentModelUrl.set("path",UrlName);
		            
		            documentModelUrl.set("type",'DOCUMENT');
		            var userId = this.getCurrentlyLoggedInUser()
		            documentModelUrl.set("createdBy",$this.getIdValueJson(userId.id,userId.value));
		            
		            var StudentPermitUrlGrid = Ext.ComponentQuery.query('permiturldocumentgrid')[0];
		            var store2= StudentPermitUrlGrid.getStore();
		            store2.add(documentModelUrl);
		            if (StudentPermitUrlGrid.isHidden() && store2.data.items.length > 0) {
		            	StudentPermitUrlGrid.setVisible(true);
		            }
		            $this.getDocumentController().closeDocumentFormWindow();
		            showSuccessMessage(getCommonTranslation('PERMIT_URL'),getCommonTranslation('PERMIT_URL_ADD_SUCCESSFULLY'));
	 	    	}
		 	},
            
		 	'documentformwindow[itemId=permit_detail_hidden_field] simpleurlform[itemId=simpleUrlForm] button#documentCancelButtonId' : {
		 		click : function() {
		 			this.getDocumentController().closeDocumentFormWindow();
		 		}
		 	},
		 	'permitdetailform[itemId=studentPermitDetailFormId] button[itemId=submitButtonId]' : {
	 			click : function() {
	               this.savePermitDetail('#studentPermitGrid', SERVERURL.PATH_PERMIT_DETAIL_ADD, SERVERURL.PATH_PERMIT_DETAIL_UPDATE, 'STUDENT');
	 			}
	 		},
	 		'permitdetailform[itemId=studentPermitDetailFormId] button[itemId=cancelButtonId]' : {
	 			click: this.closePersonCommonWindow
 			},
 			'permitdocumentgrid' : {
				 cellclick : function(grid, td,cellIndex, record, tr,rowIndex, e, eOpts) {
					 var $this = this;
					 var documentGrid = $this.getPermitdocumentgrid();
					 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;
					 if (columnName == "documentName") {
						 if (e.target.tagName == 'A') {
							 var documentId = record.get("documentId");
							 if (!isNullOrEmpty(documentId)) {
								 $this.getDocumentController().downloadDocumentFile(documentId);
							 }
						 }
					 }
				 }
			 },
 			'permitdocumentgrid button[itemId=btnDelete]' : {
 	 			 click : function() {
 	 				 var $this = this;
 	 				 var grid=$this.getPermitdocumentgrid();
 	 				 if (grid.getSelectionModel().getCount() > 0) {
 	 					 Ext.MessageBox.confirm(getCommonTranslation('PERMIT_DOCUMENT'),getCommonTranslation('PERMIT_DETAIL_DELETE_CONFIRM_MSG'),
 	 							 function(btn, text) {
 	 						 		if (btn == 'yes') {
 	 						 			var store = grid.getStore();
 	 						 			var record = grid.getSelectionModel().getSelection()[0];
 	 						 			var id = record.id;
 	 						 			if (isNullOrEmpty(id)) {
 	 						 			}else if(record) {
 	 						 				store.remove(record);
 	 						 				showSuccessMessage(getCommonTranslation('PERMIT_DOCUMENT'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
 	 						 				if(store.data.items.length == 0) {
 	 						 					grid.setVisible(false);
 	 						 				}	
 	 						 			}
 	 						 		}
 	 					 });
 	 				 } else {
 	 					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
 	 				 }
 	 			 }
 			},
 	 		'permiturldocumentgrid button[itemId=btnDelete]' : {
	 			 click : function() {
	 				 var $this = this;
					 var grid = Ext.ComponentQuery.query('permiturldocumentgrid')[0];
	 				 if (grid.getSelectionModel().getCount() > 0) {
	 					 Ext.MessageBox.confirm(getCommonTranslation('PERMIT_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	 							 function(btn, text) {
	 						 		if (btn == 'yes') {
	 						 			var store = grid.getStore();
	 						 			var record = grid.getSelectionModel().getSelection()[0];
	 						 			var id = record.id;
	 						 			if (isNullOrEmpty(id)) {
	 						 			}else if(record) {
	 						 				store.remove(record);
	 						 				showSuccessMessage(getCommonTranslation('PERMIT_URL'),getCommonTranslation('URL_SUCCESS_MSG'));
	 						 				if(store.data.items.length == 0) {
	 						 					grid.setVisible(false);
	 						 				}
	 						 			}
	 						 		}
	 					 });
	 				 } else {
	 					 showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
	 				 }
	 			 }
 	 		},
	 		'permitdocumentlistgrid':{
	 			render: function(grid) {
					var this$ = this;
					var portalId = this$.getCurrentLoggedPortalId();
					if(portalId==3) {
						this$.doAccessControlValidation(grid, this$.getSTUDENT_PERMIT_DOCUMENT_PERMISSION());
					} else if(portalId==7) {
						this$.doAccessControlValidation(grid, this$.getPARENT_PERMIT_DOCUMENT_PERMISSION());
					} else if(portalId==2) {
						this$.doAccessControlValidation(grid, this$.getFACULTY_PERMIT_DOCUMENT_PERMISSION());
					} else {
						this$.doAccessControlValidation(grid, this$.getPERMIT_DOCUMENT_PERMISSION());
					}
	            	grid.down('#downloadDocumentItemId').setVisible(true);
				},
				cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName == "documentName"){
						if(e.target.tagName=='A'){
							var documentId=record.get('documentId');
							if(!isNullOrEmpty(documentId)){
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
									method: 'GET',
									callback : function(opt, success, response){
										if(response.responseText == 'true') {
											var csvForm = Ext.create('Ext.form.Panel'); 
											csvForm.getForm().submit({
												target: '_blank',
												method:'GET',
												params :{
													access_token : Ext.Ajax.defaultHeaders.access_token
												},
												headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
												url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
												standardSubmit :true
											});
										} else {
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
										}
									}
								});
							}
						}
					}
				}
			},
			'permitdocumentlistgrid button[itemId=downloadDocumentItemId]':{
				click:function(obj){
					var $this = this;
					var form = $this.getPermitdocumentlist();
					var permitDetailActionGrid=form.down('#permitdocumentlistgridItemId');
					if (permitDetailActionGrid.getSelectionModel().getCount() > 0) {
						var records = permitDetailActionGrid.getSelectionModel().getSelection();
						var dispatchZipName = "Student Permit Detail Document";
						var saveModel=[];  
						for(var i in records){
							if(!isNullOrEmpty(records[i].get('path'))) {
								saveModel.push(records[i].get('path'));
							}
							showConfirmMessage(getCommonTranslation('PERMIT_DOCUMENT'),
									getCommonTranslation('PERMIT_DETAIL_DOCUMENT_DOWNLOAD_ALERT'),
									function(btn, text) {
								if (btn == 'yes') {
									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
									$this.getController('Academia.controller.document.DocumentController')
									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
								}
							});
						}
					}
					else {
						$this.hideWindowMask();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
			},
			'permiturldocumentlistgrid':{
				 render: function(grid) {
					 var this$ = this; 
					 var portalId = this$.getCurrentLoggedPortalId();
					 if(portalId==3) {
						 this$.doAccessControlValidation(grid, this$.getSTUDENT_PERMIT_URL_PERMISSION());
					 } else if(portalId==7) {
						 this$.doAccessControlValidation(grid, this$.getPARENT_PERMIT_URL_PERMISSION());
					 } else if(portalId==2) {
						 this$.doAccessControlValidation(grid, this$.getFACULTY_PERMIT_URL_PERMISSION());
					 } else {
						 this$.doAccessControlValidation(grid, this$.getPERMIT_URL_PERMISSION());
					 }
				 }
			 },
			'permiturldocumentlistgrid button[itemId=btnDelete]':{
				click:function(obj){
					var $this = this;
 					var form = $this.getPermiturldocumentlist();  
 					var permitDetailGrid = $this.getPermitgrid();
 					var permitUrlDocumentListGrid = form.down('#permiturldocumentlistgridItemId');
 					if (permitUrlDocumentListGrid.getSelectionModel().getCount() > 0) {
 						var records = permitUrlDocumentListGrid.getSelectionModel().getSelection();
 						var ids=[];
 						Ext.Array.each(records,function(value){
 							ids.push(value.data.id);
 						});
 						showConfirmMessage(getCommonTranslation('PERMIT_URL'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),function(btn,text){
 							if (btn == 'yes'){
 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 								Ext.Ajax.request({
 									method: "DELETE",
 									type: 'rest',
 									url : SERVERURL.PATH_PERMIT_DETAIL_URL_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
 									headers: {
 										'Content-Type': 'application/json'
 									},
 									success: function(form, action) {
 										Ext.getBody().unmask();
 										showSuccessMessage(getCommonTranslation('PERMIT_URL'),getCommonTranslation('URL_SUCCESS_MSG'));
 										permitUrlDocumentListGrid.getSelectionModel().deselectAll(true);
 										permitUrlDocumentListGrid.store.reload();
 										permitDetailGrid.store.reload();
 									}
 								});
 							}
 						});
 					} else {
 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
 					}
				}
			},
			'permitdocumentlistgrid button[itemId=btnDelete]':{
				click:function(obj){
					var $this = this;
 					var form = $this.getPermitdocumentlist();  
 					var permitDetailGrid = $this.getPermitgrid();
 					var permitDocumentListGrid = form.down('#permitdocumentlistgridItemId');
 					if (permitDocumentListGrid.getSelectionModel().getCount() > 0) {
 						var records = permitDocumentListGrid.getSelectionModel().getSelection();
 						var ids=[];
 						Ext.Array.each(records,function(value){
 							ids.push(value.data.id);
 						});
 						showConfirmMessage(getCommonTranslation('PERMIT_DOCUMENT'),getCommonTranslation('PERMIT_DETAIL_DELETE_CONFIRM_MSG'),function(btn,text){
 							if (btn == 'yes'){
 								Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
 								Ext.Ajax.request({
 									method: "DELETE",
 									type: 'rest',
 									url : SERVERURL.PATH_PERMIT_DETAIL_DOCUMENT_DELETE+'?fileDocumentIds='+ids.join(),
 									headers: {
 										'Content-Type': 'application/json'
 									},
 									success: function(form, action) {
 										Ext.getBody().unmask();
 										showSuccessMessage(getCommonTranslation('PERMIT_DOCUMENT'),getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
 										permitDocumentListGrid.getSelectionModel().deselectAll(true);
 										permitDocumentListGrid.store.reload();
 										permitDetailGrid.store.reload();
 									}
 								});
 							}
 						});
 					} else {
 						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD')); 
 					}
				}
			},
			'studentforacademictoics customcombobox[itemId=academictopic]': {
				select: function(cmp) {
					var form=cmp.up('form').getForm();
    			    var academicsubtopic =form.findField('academicsubtopic');    
    			    academicsubtopic.setDisabled(false);
					cmp.nextSibling().getStore().getProxy().extraParams = {
						academicTopicId: cmp.getValue()
					};
					cmp.nextSibling().getStore().load();
				}
			},
			'studentforacademictoics button[itemId=searchBtn]': {
				click: function(cmp) {
					var grid = this.getStudentforacademictoicsgrid();
					var form = cmp.up('form').getForm();
					var values = form.getValues();
					var personProfile = this.getContentPanelActiveTab();
					var studentId = personProfile.getUserId();
					grid.getStore().getProxy().extraParams ={
						acadmicTypeId:values.academicTopicId,
						academicSubTypeId:values.academicsubtopic,
						studentId: studentId,
						isPublished: true
					};
					grid.getStore().load();
				}
			},
			 'studentforacademictoics button[itemId=resetBtn]': {
				   click: function(obj) {
					   var form=obj.up('form').getForm();
					   var academictopic =form.findField('academicTopicId'); 
						academictopic.reset();
						var academicsubtopic =form.findField('academicsubtopic'); 
						academicsubtopic.setDisabled(true);
						academicsubtopic.reset();
						
				   }
			 },
			'studentforacademictoicsgrid': {
				cellclick: this.onAcademicTopicsCellclick
			},
			'academictopicdocumentsgrid button[itemId=downloadDocumentItemId]':{
				click:function(obj){
					var $this = this;
					var form = $this.getAcademictopicdocumentspopup();
					var academicDetailActionGrid=form.down('#academictopicdocumentsgridItemId');
					if (academicDetailActionGrid.getSelectionModel().getCount() > 0) {
						var records = academicDetailActionGrid.getSelectionModel().getSelection();
						var dispatchZipName = "Academic Topic Document";
						var saveModel=[];  
						for(var i in records){
							if(!isNullOrEmpty(records[i].get('path'))) {
								saveModel.push(records[i].get('path'));
							}
							showConfirmMessage(getCommonTranslation('ACADEMIC_TOPIC_DOCUMENTS'),
									getCommonTranslation('ACADEMIC_TOPIC_DOCUMENTS_DOWNLOAD_ALERT'),
									function(btn, text) {
								if (btn == 'yes') {
									var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
									$this.getController('Academia.controller.document.DocumentController')
									.downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
									showSuccessMessage(getCommonTranslation('ACADEMIC'),getCommonTranslation('ACADEMIC_TOPIC_DOCUMENT_DOWNLOAD_SUCCESSFULLY'));
								}
								
							});

							
						}
					}
					else {
						$this.hideWindowMask();
						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
					}
				}
      	 },
	       	/*'academictopicdocumentsgrid': {
		 		cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
					var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
					if(columnName == "name"){
						if(e.target.tagName=='A'){
							var documentId=record.get('encryptedDocId');
							if(!isNullOrEmpty(documentId)){
								Ext.Ajax.request({
									type: 'rest',
									url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
									//params: {documentId:documentId},
									method: 'GET',
									callback : function(opt, success, response){
										if(response.responseText == 'true') {
											var csvForm = Ext.create('Ext.form.Panel'); 
											csvForm.getForm().submit({
												target: '_blank',
												method:'GET',
												params :{
													access_token : Ext.Ajax.defaultHeaders.access_token
												},
												headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
												url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
												standardSubmit :true
											});
											showSuccessMessage(getCommonTranslation('ACADEMICS_TOPIC'),getCommonTranslation('ACADEMIC_TOPIC_DOCUMENT_DOWNLOAD_SUCCESSFULLY'));
										} else {
											showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
										}
									}
								});
							}
						}
					}
				}
		 	},*/
		 	'studentforacademictoicsstructure': {
		 		afterrender: function(cmp) {
					var grid = this.getStudentforacademictoicsgrid();
					var form = cmp.down('studentforacademictoics').getForm();
					var values = form.getValues();
					var personProfile = this.getContentPanelActiveTab();
					var studentId = personProfile.getUserId();
					grid.getStore().getProxy().extraParams ={
						acadmicTypeId:values.academicTopicId,
						academicSubTypeId:values.academicsubtopic,
						studentId: studentId,
						isPublished: true
					};
					grid.getStore().sorters.removeAll();
					grid.getStore().load();
					
				}
		 	},
		 	'studentGraduationCeremonyForm':{ 
		 		afterrender:function(form){
		 			var me = this,
		 			defferedToMarch  = form.down('#defferedToMarch'),
		 			associatedAcadLocationIds = new Array();
                	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
            		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, me.getSP_FOR_GRADUATION_CEREMONY());
            		defferedToMarch.setVisible(false);
            		Ext.each(permissionList, function(privilege) {
                		if (privilege === 'DEFFERED_TO_MARCH') {
                			defferedToMarch.setVisible(true);
                    	}
                	});
            		var ceremonyCombo = form.down('#ceremonyName');
            		ceremonyCombo.getStore().load({
        				callback:function(records, operation, success) {
        					if(ceremonyCombo.getStore().getCount()) {
        						Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        						ceremonyCombo.setValue(records[0].data.id)
        						ceremonyCombo.fireEvent('select',ceremonyCombo);
        					}					
        				}
        			});
		 		}
		 	},
		 	
		 	'studentGraduationCeremonyForm button[itemId=submitButtonId]':{
		 		click:function(){
		 			var me = this;
		 			var	form = this.getStudentGraduationCeremonyForm(),
		 			formVal=form.getValues();
		 			if(formVal.attendGraduationCermony == true){
		 			var param={
		 					"reason":null,
		 					"personAddressId":null,
		 					"graduationCeremonyReasonEnum":"DEFAULT",
		 					"otherAddress":"",
		 					 "ceremony":{
		 						 id:formVal.ceremonyName
		 					 },
		 					 "isAttending":'YES'
		 			}
		 			}else{
		 				var param={
			 					"reason":formVal.remark,
			 					"personAddressId":formVal.addressId,
			 					"graduationCeremonyReasonEnum":formVal.choicesId,
			 					"otherAddress":formVal.addressManually,
			 					 "ceremony":{
			 						 id:formVal.ceremonyName
			 					 },
			 					"isAttending":formVal.attendGraduationCermony ==false?'NO':formVal.attendGraduationCermony
			 			}
		 			}
		 			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
		 			Ext.defer(function(){
		 				var submitData = Ext.encode(param);
			 			Ext.Ajax.request({
			 	    		type : 'rest',
			 	    		async: false,
			 	    		 jsonData : submitData,
			 	    		method : 'POST',
			 	    		url : SERVERURL.PATH_SAVE_GRADUATION_CEREMONY_REASON_STUDENT ,
			 	    		success: function(response, action) {
					    		Ext.getBody().unmask();
			 	    			showSuccessMessage(getMegaMenuTranslation('SP_GRADUATION_CEREMONY'),getCommonTranslation('SUCCESS'));
			 	    					me.getContentPanelActiveTab().close(); 
			 	    			}
			 	    		
			 	    	});
		 			},200);
		    		
		 			
		 		}
		 	},
		 	
		 	'studentGraduationCeremonyForm button[itemId=cancelButtonId]':{
		 		click:function(btn){
		 			btn.up('form').getForm().reset();
		 			var	form = this.getStudentGraduationCeremonyForm(),
		 			addressManually =form.down('#addressManually'),
		 			ceremonyCombo = form.down('#ceremonyName'),
	    			 addressId = form.down('#addressId');
            		
		 			addressId.reset();
		 			addressManually.reset();
		 			addressId.setDisabled(true);
	 				addressId.setVisible(false);
	 				addressManually.setDisabled(true);
	 				addressManually.setVisible(false);
	 				ceremonyCombo.getStore().load({
        				callback:function(records, operation, success) {
        					if(ceremonyCombo.getStore().getCount()) {
        						Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        						ceremonyCombo.setValue(records[0].data.id)
        						ceremonyCombo.fireEvent('select',ceremonyCombo);
        					}					
        				}
        			});
		 		}
		 	},
		 	
		 	'studentGraduationCeremonyForm radiogroup[itemId=attendGraduationCermonyId]':{
		 		change:function(cmp){
		 			var	form = this.getStudentGraduationCeremonyForm(),
	    			 addressId = form.down('#addressId'),
	    			remark = form.down('#remark'),
	    			attendGraduationCermonyId =form.down('#attendGraduationCermonyId'),
	    			submitButtonId =form.down('#submitButtonId'),
	    			addressManually =form.down('#addressManually'),
	    			choicesId =form.down('#choicesId');
		 			addressId.reset();
	 				remark.reset();
	 				choicesId.reset();
	 				addressManually.reset();
		 			if(cmp.getValue().attendGraduationCermony){
		 				addressId.setDisabled(true);
		 				remark.setDisabled(true);
		 				choicesId.setDisabled(true);
		 				addressManually.setDisabled(true);
		 				addressManually.setVisible(false);
		 				addressId.setVisible(false);
		 				remark.setVisible(false);
		 				choicesId.setVisible(false);
		 			}else{
		 				addressId.setDisabled(true);
		 				remark.setDisabled(false);
		 				choicesId.setDisabled(false);
		 				remark.setVisible(true);
		 				choicesId.setVisible(true);
		 			}
		 			
		 		}
		 	},
		 	'studentGraduationCeremonyForm customcombobox[itemId=choicesId]':{
		 		change:function(cmp){
		 			var	form = this.getStudentGraduationCeremonyForm(),
		 			 addressId = form.down('#addressId')
	    			 addressManually = form.down('#addressManually');
		 			if(cmp.getValue() == "COURIER_DEGREE_CERTIFICATE"){
		 				addressId.setDisabled(false);
		 				addressId.setVisible(true);
		 				addressId.allowBlank=false; 
		 				addressManually.setDisabled(false);
		 				addressManually.setVisible(true);
		 				addressManually.allowBlank=false;
		 			}else{
		 				addressId.setDisabled(true);
		 				addressId.setVisible(false);
		 				addressId.allowBlank=true; 

		 				addressManually.setDisabled(true);
		 				addressManually.setVisible(false);
		 				addressManually.allowBlank=true; 
		 			}
		 		}
		 		
		 	},
		 	'studentGraduationCeremonyForm customcombobox[itemId=addressId]':{
	 		select:function(cmp){
	 			var	form = this.getStudentGraduationCeremonyForm(),
	 			addressManually = form.down('#addressManually');
	 			if(!cmp.getValue()){
	 				addressManually.setDisabled(false);
	 				addressManually.setVisible(true);
	 			}else{
	 				addressManually.setDisabled(true);
	 				addressManually.setVisible(false);
	 			}
	 		}
	 		
	 	},
	 	'studentGraduationCeremonyForm customcombobox[itemId=ceremonyName]':{
	 		select:function(cmp){
	 			var me= this,isDatePassed=false,
	 			form = me.getStudentGraduationCeremonyForm(),
	 			savebtn = form.down('#submitButtonId'),
	 			cancelButtonId = form.down('#cancelButtonId'),
	 			dateAbsentiaPassed = form.down('#dateAbsentiaPassed'),
	 			selectedRec= cmp.lastSelection[0];
	 			if(selectedRec.data.lastDateOfAbsentia){
	 				isDatePassed =	isCurrentDatePassed(selectedRec.data.lastDateOfAbsentia);
	 			}
	 			if(!isDatePassed && selectedRec.data.status){
	 				dateAbsentiaPassed.setVisible(false);
	 				savebtn.setVisible(true);
	 				cancelButtonId.setVisible(true);
	 				form.getForm().getFields().items.forEach(function(rec){
	 					rec.setReadOnly(false);
	 				});
	 			}else{
	 				dateAbsentiaPassed.setVisible(true);
	 				savebtn.setVisible(false);
	 				cancelButtonId.setVisible(false);
	 				form.getForm().getFields().items.forEach(function(rec){
	 					rec.setReadOnly(true);
	 				});
	 			}
	 			cmp.setReadOnly(false);
	 			Ext.Ajax.request({
	 	    		type : 'rest',
	 	    		async: false,
	 	    		method : 'GET',
	 	    		params:{
	 	    			ceremonyId:cmp.getValue()
	 	    		},
	 	    		url : SERVERURL.PATH_FETCH_STUDENT_CEREMONY_DATA,
	 	    		success: function(response, action) {
	 	    			Ext.getBody().unmask();
	 	    			var addressId = form.down('#addressId'),
	 	    			addressManually = form.down('#addressManually'),
	 	    			remark = form.down('#remark'),
	 	    			attendGraduationCermonyId =form.down('#attendGraduationCermonyId'),
	 	    			choicesId =form.down('#choicesId');
	 	    			if (response.responseText) {
		 	    			var	dashboardList = Ext.decode(response.responseText); 
		 	    			if(dashboardList.isAttending == 'NO'){
		 	    				attendGraduationCermonyId.setValue({
		 	    					attendGraduationCermony:false
		 	    				});
		 	    				addressId.getStore().load({
		 	        				callback:function(records, operation, success) {
		 	        					if(dashboardList.graduationCeremonyReasonEnum == 'COURIER_DEGREE_CERTIFICATE'){
		 	        						if(dashboardList.personAddressId){
		 	        							addressId.setValue(dashboardList.personAddressId);
		 	        						}else{
		 	        							var rec = addressId.getStore().findRecord('code','OTHER');
		 	        							addressId.setValue(rec);
		 	        						}
		 	        						addressManually.setValue(dashboardList.otherAddress);
		 	        						addressManually.setVisible(true);
		 	        						addressManually.setDisabled(false);
		 	        					}
		 	        								
		 	        				}
		 	        			});
		 	    				remark.setValue(dashboardList.reason);
		 	    				choicesId.setValue(dashboardList.graduationCeremonyReasonEnum);
		 	    			}else{
		 	    				if(dashboardList.isAttending =='YES'){
		 	    					attendGraduationCermonyId.setValue({
			 	    					attendGraduationCermony:true
			 	    				});
		 	    				}else{
		 	    					attendGraduationCermonyId.setValue({
			 	    					attendGraduationCermony:'DEFFERED_TO_MARCH'
			 	    				});
		 	    				}
		 	    			}
		 	    			
	 	    			}else{
	 	    				attendGraduationCermonyId.setValue({
	 	    					attendGraduationCermony:true
	 	    				});
	 	    			}
	 	    		}
	 	    	});
	 		}
	 	},
	 	/*Deadpool:Start*/
	 	 'studentForTransferCreditTab':{ 				
				render:function(tab){
					var me = this;
					me.disableForStudentPortalTransferCreditInternalTab(tab, me.getSP_FOR_TRANSFER_CREDIT_LIST_PERMISSIONS())
				}
			},
	 	'studentForTransferCreditFilter': {
			    afterrender: function(form) {
			        var me = this;
			        var studentId = me.getContentPanelActiveTab().getUserId();

			        var programField = form.down('#stcrdProgramItemId');
			        var batchField = form.down('#stcrdBatchItemId');

			        if (!programField || !batchField) {
			            return;
			        }

			        var programStore = programField.getStore();
			        programStore.getProxy().extraParams = {
			            studentId: studentId
			        };

			        programStore.load({
			            callback: function(records, success) {
			                if (!success || records.length === 0) return;

			                var selectedProgram = records.length === 1 ? records[0] : Ext.Array.findBy(records, function(rec) {
			                    return !!rec.get('value');
			                });

			                if (selectedProgram) {
			                    var programId = selectedProgram.get('id');
			                    programField.setValue(programId);

			                    var batchStore = batchField.getStore();

			                    if (!batchStore) return;

			                    batchStore.getProxy().extraParams = {
			                        programId: programId,
			                        studentId: studentId
			                    };

			                    batchStore.load({
			                        callback: function(batchRecords, batchSuccess) {
			                            if (batchSuccess && batchRecords.length > 0) {
			                                batchField.setValue(batchRecords[0].get('id'));
			                            }
			                        }
			                    });
			                }
			            }
			        });
			    }
			},
 	        'studentForTransferCreditFilter customcombobox[itemId=stcrdProgramItemId]': {
	            	select: function(cmp){ 
						var me = this
						var studentId = me.getContentPanelActiveTab().getUserId();
						form = me.getStudentForTransferCreditFilter()
						var program = form.down('#stcrdProgramItemId')	
						var batch = form.down('#stcrdBatchItemId')	
						batch.getStore().getProxy().extraParams = {
							            programId: program.getValue(),
							            studentId: studentId
							        };
			 						batch.getStore().load({
			 		   					 callback:function(records, success){
			 		   						 if(success){
			 		   							batch.getStore().getProxy().extraParams = {
					 		   						programId: program.getValue(),
					 		   						studentId: studentId
				 		   						};
			 		   						    batch.setValue(records[0].get('id'));
			 		   						 }
			 		   					 }
			 		   				 })
					}	            
	            },
	           'studentForTransferCreditFilter button[itemId=submitBtn]': {
	                click: function(cmp){
	                	var me = this;
	                	var mainTab = me.getContentPanelActiveTab();
	                	var innerActiveTab = mainTab.down('tabpanel');
	                	innerActiveTab = innerActiveTab.getActiveTab();
	                	if(!isNullOrEmpty(innerActiveTab)){
	 	                	var studentId = me.getContentPanelActiveTab().getUserId();
	 	                	var form = me.getStudentForTransferCreditFilter();
	                		if (innerActiveTab.down('#studentForExternalTransferCreditGridItemId')) {
	                			var grid = me.getStudentForExternalTransferCreditGrid(),
		 	                	 program = form.down('#stcrdProgramItemId')	
		 						 batch = form.down('#stcrdBatchItemId')
		 	                	grid.getStore().getProxy().extraParams = {
		 	                		batchId:batch.getValue(),
		 	                		programId: program.getValue(),
	 		   						studentId: studentId,
		 						}
		 	                	grid.getStore().load();
	                		}
	                		if (innerActiveTab.down('#studentForInternalTransferCreditGridItemId')) { 
	                			var grid = me.getStudentForInternalTransferCreditGrid(),  
		 	                	 program = form.down('#stcrdProgramItemId')	
		 						 batch = form.down('#stcrdBatchItemId')
		 	                	grid.getStore().getProxy().extraParams = {
		 	                		batchId:batch.getValue(),
		 	                		programId: program.getValue(),
	 		   						studentId: studentId,
		 						}
		 	                	grid.getStore().load();
	                		}
	                	}
	                }
	            },	            
	            'studentForExternalTransferCreditGrid': { 
	            	afterrender:function(grid){
						var me = this; 
						me.addDataGridConfigButton(grid,me.getSTUDENT_EXTERNAL_TRANSFER_CREDIT());
					},
 				   viewready: this.onStudentGridViewReady,
 				  selectionchange: function(column, selected,eOpts){ 
	 					  	var me  = this;
						    var grid = me.getStudentForExternalTransferCreditGrid();
							var gridStructure = me.getStudentForExternalTransferCreditGridStructure();
							var btnSubmit = gridStructure.down('#btnSubmitItemId');
	 					    var btnReset = gridStructure.down('#btnResetItemId');
	 					   if (selected.length > 0) {
						        btnSubmit.setDisabled(false);
						        btnReset.setDisabled(false);  
						    } else {
						        btnSubmit.setDisabled(true);
						        btnReset.setDisabled(true);
						    }
 				  }
	            },	            
	            'studentForInternalTransferCreditGrid': { 
	            	afterrender:function(grid){
						var me = this;   
						me.addDataGridConfigButton(grid,me.getSTUDENT_INTERNAL_TRANSFER_CREDIT());
					},
 				   viewready: this.onStudentGridViewReadyToInternal,
 				  selectionchange: function(column, selected,eOpts){ 
					  	var me  = this;
					    var grid = me.getStudentForInternalTransferCreditGrid();
						var gridStructure = me.getStudentForInternalTransferCreditGridStructure();
						var btnSubmit = gridStructure.down('#btnSubmitItemId');
					    var btnReset = gridStructure.down('#btnResetItemId');
					   if (selected.length > 0) {
					        btnSubmit.setDisabled(false);
					        btnReset.setDisabled(false);  
					    } else {
					        btnSubmit.setDisabled(true);
					        btnReset.setDisabled(true);
					    }
			  }
	            },
				 'studentForTransferCreditFilter button[itemId=resetBtn]': {
	 	            	click: function(cmp){
	 	            		var me = this
	 	            		var activePannel = me.getContentPanelActiveTab();
	 	            		var studentId = activePannel.getUserId();
	 	            		var form = cmp.up('studentForTransferCreditFilter')
	 	            		var programField = form.down('#stcrdProgramItemId');
	 				        var batchField = form.down('#stcrdBatchItemId');
		 				       programField.reset();
		 				       batchField.reset();
	 				       var programStore = programField.getStore();
	 				        programStore.getProxy().extraParams = {
	 				            studentId: studentId
	 				        };
	 				       programStore.load({
	 				            callback: function(records, success) {
	 				                if (!success || records.length === 0) return;

	 				                var selectedProgram = records.length === 1 ? records[0] : Ext.Array.findBy(records, function(rec) {
	 				                    return !!rec.get('value');
	 				                });

	 				                if (selectedProgram) {
	 				                    var programId = selectedProgram.get('id');
	 				                    programField.setValue(programId);

	 				                    var batchStore = batchField.getStore();

	 				                    if (!batchStore) return;

	 				                    batchStore.getProxy().extraParams = {
	 				                        programId: programId,
	 				                        studentId: studentId
	 				                    };

	 				                    batchStore.load({
	 				                        callback: function(batchRecords, batchSuccess) {
	 				                            if (batchSuccess && batchRecords.length > 0) {
	 				                                batchField.setValue(batchRecords[0].get('id'));
	 				                            }
	 				                        }
	 				                    });
	 				                }
	 				            }
	 				        });
	 	            	}
	 	            
	            },
         		'studentForExternalTransferCreditGridStructure button[itemId=btnResetItemId]':{
         			click: function(btn){
         				var me = this;
         				var grid = me.getStudentForExternalTransferCreditGrid();
         				if (grid && grid.getSelectionModel) {
         					 var selectedRecords = grid.getSelectionModel().getSelection();
                             Ext.each(selectedRecords, function(record) {
                                 record.reject();
                             });
         		            grid.getSelectionModel().deselectAll();	 	            		            
         		        }
         			}
         		},
         		'studentForInternalTransferCreditGridStructure button[itemId=btnResetItemId]':{
         			click: function(btn){
         				var me = this;
         				var grid = me.getStudentForInternalTransferCreditGrid();
         				if (grid && grid.getSelectionModel) {	 	            					
         					var selectedRecords = grid.getSelectionModel().getSelection();
                             Ext.each(selectedRecords, function(record) {
                                 record.reject();
                             });	 	                                
         		            grid.getSelectionModel().deselectAll();
         		        }
         			}
         		},
         		'studentForExternalTransferCreditGridStructure button[itemId=btnSubmitItemId]': {
         		    click: function (obj) {
         		   var me = this;
         		  var admissionId = Academia.model.authentication.PortalInfoModel.data.admissionDetails[0].id;
         		   var grid = me.getStudentForExternalTransferCreditGrid();
         		  var studentId = me.getContentPanelActiveTab().getUserId();
         		  //var admissionId = me.getContentPanelActiveTab().getAdmissionId();
         		  //var admissionId = userInfo.get('id');
         		  var personId = me.getContentPanelActiveTab().getPersonId();

         		  if (grid.getSelectionModel().getCount() > 0) {
         		      var selectedRecords = grid.getSelectionModel().getSelection();
         		      var finalData = [];

         		     var hasEmptyRequiredField = false;
    		          Ext.Array.each(selectedRecords, function (rec) {

    		              if (isNullOrEmpty(rec.get('equivalentCourseName')) || isNullOrEmpty(rec.get('equivalentCourseCode'))) {
    		                  hasEmptyRequiredField = true;
    		                  return false;
    		              }
    		          });

    		          if (hasEmptyRequiredField) {
    		        	 showWarningMessage(getExaminationTranslation('REQUIRED_FIELDS'), getExaminationTranslation('EQUIVALENT_COURSE_NAME_AND_COURSE_CODE_ARE_REQUIRED_TO_SELECTED_RECORDS'));
    		        	 return;
    		          }
         		   
         		      Ext.Array.forEach(selectedRecords, function (rec) {
         		          var data = rec.data;
         		          var mappedData = {
         		              id: isNullOrEmpty(data.id) ? null : data.id,
         		              admissionId: isNullOrEmpty(admissionId) ? null : admissionId,
         		              courseId: isNullOrEmpty(data.courseId) ? null : data.courseId,
         		              programId: isNullOrEmpty(data.programId) ? null : data.programId,
         		              batchId: isNullOrEmpty(data.batchId) ? null : data.batchId,
         		              periodId: isNullOrEmpty(data.periodId) ? null : data.periodId,
         		              courseVariantId: isNullOrEmpty(data.courseVariantId) ? null : data.courseVariantId,
         		              courseCode: isNullOrEmpty(data.courseCode) ? null : data.courseCode,
         		              courseName: isNullOrEmpty(data.courseName) ? null : data.courseName,
         		              marksGrade: isNullOrEmpty(data.marksGrade) ? null : data.marksGrade,
         		              programName: isNullOrEmpty(data.programName) ? null : data.programName,
         		              batchName: isNullOrEmpty(data.batchName) ? null : data.batchName,
         		              programPeriodName: isNullOrEmpty(data.programPeriodName) ? null : data.programPeriodName,
         		              equivalentCourseCode: isNullOrEmpty(data.equivalentCourseCode) ? null : data.equivalentCourseCode,
         		              equivalentCourseName: isNullOrEmpty(data.equivalentCourseName) ? null : data.equivalentCourseName,
         		              institueName: isNullOrEmpty(data.institueName) ? null : data.institueName,
         		              equivalentCourseCredit: isNullOrEmpty(data.equivalentCourseCredit) ? null : data.equivalentCourseCredit,
         		              obtainedMarksGrade: isNullOrEmpty(data.obtainedMarksGrade) ? null : data.obtainedMarksGrade,
         		            //  remark: isNullOrEmpty(data.remark) ? null : data.remark,
							  studentRemark: isNullOrEmpty(data.studentRemark) ? null : data.studentRemark,
							  facultyRemark: isNullOrEmpty(data.facultyRemark) ? null : data.facultyRemark,
							  completionDate: isNullOrEmpty(data.completionDate) ? null : data.completionDate,
         		              transferResultStatus: isNullOrEmpty(data.transferResultStatus) ? null : data.transferResultStatus,
         		              isEquivalenceCheck: data.isEquivalenceCheck || false,
         		              isTransferCreditFromStudentPortal: data.isTransferCreditFromStudentPortal || false,
         		              courseCredit: isNullOrEmpty(data.courseCredit) ? null : data.courseCredit,
         		              applicantTransferCreditStatus: isNullOrEmpty(data.applicantTransferCreditStatus) ? 'PENDING' : data.applicantTransferCreditStatus,
         		              //examTransferCreditType: isNullOrEmpty(data.examTransferCreditType) ? null : data.examTransferCreditType,
         		              examTransferCreditType: "EXTERNAL_TRANSFER_CREDIT",
         		              gradeTypeList: isNullOrEmpty(data.gradeTypeList) ? null : data.gradeTypeList,
         		              documentId: isNullOrEmpty(data.documentId) ? null : data.documentId,
         		              gradePoint: isNullOrEmpty(data.gradePoint) ? null : data.gradePoint,
         		              courseGradeType: isNullOrEmpty(data.courseGradeType) ? null : data.courseGradeType,
         		              transferType: "EXTERNAL_TRANSFER_CREDIT"
         		          };
         		          finalData.push(mappedData);
         		      });

         		      Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
         		      Ext.Ajax.request({
         		          url: SERVERURL.PATH_STUDENT_TRANSFER_SAVE_DATA,
         		          method: 'POST',
         		          jsonData: finalData,
         		          success: function () {
         		              Ext.getBody().unmask();
         		              showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
         		              grid.getStore().load();
         		              grid.getSelectionModel().deselectAll();
         		          },
         		          failure: function () {
         		              Ext.getBody().unmask();
         		          }
         		      });
         		  } else {
         		      Ext.getBody().unmask();
         		  }
         		    }
         		},
         		'studentForInternalTransferCreditGridStructure button[itemId=btnSubmitItemId]': {
         		    click: function (obj) {
         		    	var me = this
         		        var grid = me.getStudentForInternalTransferCreditGrid();
         		        var studentId = me.getContentPanelActiveTab().getUserId();
         		        var admissionId = Academia.model.authentication.PortalInfoModel.data.admissionDetails[0].id;
         		        //var admissionId = me.getContentPanelActiveTab().getAdmissionId();
         		        var personId = me.getContentPanelActiveTab().getPersonId();
         		        if (grid.getSelectionModel().getCount() > 0) {
         		            var selectedRecords = grid.getSelectionModel().getSelection();
         		            var finalData = [];
         		           var form = me.getStudentForTransferCreditFilter();
                           var batch = form.down('#stcrdBatchItemId');
                           var batchId = batch.getValue();
						   var periodId=batch.getStore().data.items[0].data.personId;

         		           //var hasEmptyRequiredField = false;
         		         /* Ext.Array.each(selectedRecords, function (rec) {

         		              if (isNullOrEmpty(rec.get('equivalentCourseName')) && isNullOrEmpty(rec.get('equivalentCourseCode'))) {
         		                  hasEmptyRequiredField = true;
         		                  return false;
         		              }
         		          });*/

         		         /* if (hasEmptyRequiredField) {
         		        	 showWarningMessage(getExaminationTranslation('REQUIRED_FIELDS'), getExaminationTranslation('EQUIVALENT_COURSE_NAME_AND_COURSE_CODE_ARE_REQUIRED_TO_SELECTED_RECORDS'));
         					 return;
         		          }*/
         		          
         		            Ext.Array.forEach(selectedRecords, function (rec) {
         		                var data = rec.data;
         		                var mappedData = {
         		                    id: isNullOrEmpty(data.id) ? null : data.id,
         		                    admissionId: isNullOrEmpty(admissionId) ? null : admissionId,
         		                		   
         		                		    courseId: isNullOrEmpty(data.courseId) ? null : data.courseId,
         		                		    programId: isNullOrEmpty(data.programId) ? null : data.programId,
         		                		    //batchId: isNullOrEmpty(data.batchId) ? null : data.batchId,
         		                		    batchId: isNullOrEmpty(batchId) ? null : batchId,
         		                		  //  periodId: isNullOrEmpty(data.periodId) ? null : data.periodId,
										    periodId: isNullOrEmpty(periodId) ? null : periodId,
         		                		    courseVariantId: isNullOrEmpty(data.courseVariantId) ? null : data.courseVariantId,
         		                		    courseCode: isNullOrEmpty(data.courseCode) ? null : data.courseCode,
         		                		    courseName: isNullOrEmpty(data.courseName) ? null : data.courseName,
         		                		    marksGrade: isNullOrEmpty(data.marksGrade) ? null : data.marksGrade,
         		                		    programName: isNullOrEmpty(data.programName) ? null : data.programName,
         		                		    batchName: isNullOrEmpty(data.batchName) ? null : data.batchName,
         		                		    programPeriodName: isNullOrEmpty(data.programPeriodName) ? null : data.programPeriodName,
         		                		    //currentGrade: isNullOrEmpty(data.currentGrade) ? null : data.currentGrade,
         		                		    equivalentCourseCode: isNullOrEmpty(data.equivalentCourseCode) ? null : data.equivalentCourseCode,
         		                		    equivalentCourseName: isNullOrEmpty(data.equivalentCourseName) ? null : data.equivalentCourseName,
         		                		    institueName: isNullOrEmpty(data.institueName) ? null : data.institueName,
         		                		    equivalentCourseCredit: isNullOrEmpty(data.equivalentCourseCredit) ? null : data.equivalentCourseCredit,
         		                		    obtainedMarksGrade: isNullOrEmpty(data.obtainedMarksGrade) ? null : data.obtainedMarksGrade,
         		                		    //gradeType: isNullOrEmpty(data.gradeType) ? null : data.gradeType,
         		                		    //remark: isNullOrEmpty(data.remark) ? null : data.remark,
         		                		    studentRemark: isNullOrEmpty(data.studentRemark) ? null : data.studentRemark,
         		                		    		
         		                		    transferResultStatus: isNullOrEmpty(data.transferResultStatus) ? null : data.transferResultStatus,

         		                		    isEquivalenceCheck: data.isEquivalenceCheck || false,
         		                		    isTransferCreditFromStudentPortal: data.isTransferCreditFromStudentPortal || false,

         		                		    courseCredit: isNullOrEmpty(data.courseCredit) ? null : data.courseCredit,
         		                		    //currentMarks: isNullOrEmpty(data.currentMarks) ? null : data.currentMarks,
         		                		    applicantTransferCreditStatus: isNullOrEmpty(data.applicantTransferCreditStatus) ? 'PENDING' : data.applicantTransferCreditStatus,
         		                		    examTransferCreditType: isNullOrEmpty(data.examTransferCreditType) ? null : data.examTransferCreditType,
         		                		    gradeTypeList: isNullOrEmpty(data.gradeTypeList) ? null : data.gradeTypeList,
         		                		    documentId: isNullOrEmpty(data.documentId) ? null : data.documentId,
         		                		    gradePoint: isNullOrEmpty(data.gradePoint) ? null : data.gradePoint,
    	 	            		            courseGradeType: isNullOrEmpty(data.courseGradeType) ? null : data.courseGradeType,
         		                		    transferType: "INTERNAL_TRANSFER_CREDIT",
         		                };

         		                finalData.push(mappedData);
         		            });
         		           Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
         		            Ext.Ajax.request({
         		                url: SERVERURL.PATH_STUDENT_TRANSFER_SAVE_DATA,
         		                method: 'POST',
         		                jsonData: finalData,
         		                success: function () {
         		                	Ext.getBody().unmask();
									showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('RECORD_SAVED_SUCCESSFULLY'));
									grid.getStore().load();
									grid.getSelectionModel().deselectAll();
         		                },
         		                failure: function () {
         		                	Ext.getBody().unmask();
         		                }
         		            });

         		        } else {
         		        	Ext.getBody().unmask();
         		        }
         		    }
         		},
         		'feepayerdetailform[itemId=studentfeepayerdetailformItemId] button[itemId=googleAddressBtnId]':{
         			click:function(){
         				this.openGoogleAddressWin();
         			}
         		},
         		'feepayergoogleaddresswin[itemId=studentFeepayergoogleaddresswin]':{
         			afterrender:function(form){
                        this.applyDFROnFeePayerGoogleAddressForm(form);
                        if(this.stdFeePayerFormMode=='view'){
                        	form.down('#googleAddressBtnSave').setVisible(false);
                        }
         			}
         		},
         		'feepayergoogleaddresswin[itemId=studentFeepayergoogleaddresswin] button[itemId=googleAddressBtnSave]':{
         			click:function(){
         				var win = this.getFeepayergoogleaddresswin(),
         			    feePayerForm = this.getContentPanelActiveTab().down('feepayerdetailform'),
         				form = win.down('form'),
         				formValues = form.getValues();
         				feePayerForm.down('#googleAddressId').setValue(formValues.googleAddress);
         				feePayerForm.down('#googleAddressCountryId').setValue(formValues.googleAddressCountry);
         				feePayerForm.down('#googleAddressCountryRegionId').setValue(formValues.googleAddressCountryRegion);
         				feePayerForm.down('#googleAddressCityId').setValue(formValues.googleAddressCity);
         				feePayerForm.down('#googleAddressPincodeId').setValue(formValues.googlePincode);
         				showSuccessMessage(getPersonModuleTranslation('FPD_FEE_PAYER_DETAILS'), getCommonTranslation('GOOGLE_ADDRESS_SAVED_TEMPORARILY'));
         				win.close();
         			}
         		},
         		'feepayergoogleaddresswin[itemId=studentFeepayergoogleaddresswin] button[itemId=googleAddressBtnCancel]':{
         			click:function(){
         				var win = this.getFeepayergoogleaddresswin();
         				win.close();
         			}
         		},
         		'feepayergoogleaddresswin[itemId=studentFeepayergoogleaddresswin] checkboxfield[itemId=isSameAsStudentGoogleAddressId]':{
         			change:function(obj,newValue,oldValue){
         				var personId =this.getContentPanelActiveTab().personId,
         				jsonData = {},
         				win = this.getFeepayergoogleaddresswin();
         				if(newValue){
         					Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
         					Ext.Ajax.request({
         						url: SERVERURL.PATH_APPLICANT_OR_STUDENT_CURRENT_GOOGLE_ADDRESS,
         						method: 'GET',
         						params:{
         							personId : personId
         						},
         						success: function (response, action) {
         							var data = response.responseText && Ext.decode(response.responseText);
         							win.down('#googleAddressId').setValue(data.addressText);
         							win.down('#googleAddressCountryId').setValue(data.countryText);
         							win.down('#googleAddressCountryRegionId').setValue(data.provinceText);
         							win.down('#googleAddressCityId').setValue(data.cityText);
         							win.down('#googlePincodeId').setValue(data.postalCodeText);
         							Ext.getBody().unmask();
         						},
         						failure: function () {
         							Ext.getBody().unmask();
         						}
         					});
         				}
         			}
         		}
        });
    },
    disableForStudentPortalTransferCreditInternalTab: function(structure,permissionsMap){
		var associatedAcadLocationIds = new Array();
	   	 associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	   	 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	   	 var StudentPortalForTransferCreditInternalTab=false;
	   	 
	   	for (var i = 0; i < permissionList.length; i++) {
	   		 if (permissionList[i] === "INTERNAL_TRANSFER_CREDIT_TAB") {
	   			StudentPortalForTransferCreditInternalTab=true;
	   		 }
	   	 }
	   	 this.StudentPortalForShowTransferCreditInternalTab(StudentPortalForTransferCreditInternalTab, structure);	   	  	 
	},
	StudentPortalForShowTransferCreditInternalTab: function(StudentPortalForTransferCreditInternalTab,structure){
	   	 var panelItem = new Array();
	   	 var $this = this;
	   	 var newcont=structure.items.items.length;
	   	 var insertPosition=newcont+1;
	   	 if(StudentPortalForTransferCreditInternalTab==true) {
	   		 panelItem.push({
	 			xtype:'tabpanel',
				 plain: true,
				 style:{overflow:'hidden !important',margin:'0!important'},
				 bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
				 frame: false,
				 border:false,
					items : [{
						title: getCommonTranslation('EXTERNAL_TRANSFER_CREDIT'),
						layout:'vbox',
						defaults: {
							width:'100%'
						},
						items:[{
						    xtype:'studentForExternalTransferCreditGridStructure'
						}]			
					},{
						title :getCommonTranslation('INTERNAL_TRANSFER_CREDIT'),
						layout:'vbox',
						defaults: {
							width:'100%'
						},
		   				 items:[{
		   					 xtype: 'studentForInternalTransferCreditGridStructure',
		   					 itemId: ''
		   				 }]
		   			 }]
			 
		});
	   	 }else{
	   		 panelItem.push({
	 			xtype:'tabpanel',
				 plain: true,
				 style:{overflow:'hidden !important',margin:'0!important'},
				 bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
				 frame: false,
				 border:false,
					items : [{
						title: getCommonTranslation('EXTERNAL_TRANSFER_CREDIT'),
						layout:'vbox',
						defaults: {
							width:'100%'
						},
						items:[{
							xtype:'studentForExternalTransferCreditGridStructure'
						}]			
					}]			 
		});
	   	 }
	   	 structure.insert(insertPosition,panelItem);
	  },
    onStudentGridViewReadyToInternal: function (view) {

	    view.el.on('change', function (e, t) {
	    	var me = this;
	    	var grid  = me.getStudentForInternalTransferCreditGrid()
	        var input = t;
	        var file = input.files[0];

	        if (!file) return;
			
			var allowedTypes = ['application/pdf', 'image/png', 'image/jpeg'];
										    var maxSizeMB = 5;
										    var maxSizeBytes = maxSizeMB * 1024 * 1024;

										    if (!allowedTypes.includes(file.type)) {
												showWarningMessage(getCommonTranslation('ALERT'),'Invalid file type. Only PDF, PNG, and JPEG are allowed');
										     // fileInput.value = ''; // Reset input  
										      return false;
										    }

										    if (file.size > maxSizeBytes) {
												showWarningMessage(getCommonTranslation('ALERT'),'File size exceeds 5MB limit'); 
										     // fileInput.value = ''; // Reset input 
										      return false; 
										    }    

	        var formData = new FormData();
	        
	        formData.append('file', file);
	        
	        var userInfo = Academia.model.authentication.UserInfoModel;
	       	 var access_token = userInfo.get("accessToken");
	        
	       	var url = SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_UPLOAD_DOC+'?access_token='+access_token;
	       	 
	       	 var xhr = new XMLHttpRequest();
	       	 xhr.open('POST', url);
	       	 xhr.onload = function () {
	       	     if (xhr.status >= 200 && xhr.status < 300) {
	       	         var response = JSON.parse(xhr.responseText);
	       	      var response = JSON.parse(xhr.responseText);
                  var documentId = response;

                  var rowEl = Ext.get(input).up('tr.x-grid-row');
                  if (!rowEl) return;

                  var allRows = view.el.query('tr.x-grid-row');
                  var rowIndex = -1;
                  for (var i = 0; i < allRows.length; i++) {
                      if (allRows[i] === rowEl.dom) {
                          rowIndex = i;
                          break;
                      }
                  }

                  if (rowIndex !== -1) {
                      var record = grid.getStore().getAt(rowIndex);
                      if (record) {
                          var cleanedValue = input.value.replace('C:\\fakepath\\', '').replace(/ +/g, " ").split(' ').join('_');
                          record.set('documentId', documentId);
                          record.set('document', cleanedValue);
                          record.commit();
                          showSuccessMessage(getCommonTranslation('SUCCESS'), getExaminationTranslation('DOCUMENT_SUCCESSFULLY_UPLOADED'));
                      }
                  }
                  else {
                      showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_SAVE'));
                  }
	       	     }
	       	 };
	       	 xhr.send(formData);

	    }, this, {
	        delegate: 'input.grid-upload-input',
	        capture: true
	    });
	    
	    view.el.on('click', function (e, t) {
	        //var target = Ext.get(t).down('.download-icon-v2');
	        var target = Ext.get(t)

	        if (target && target.hasCls('download-icon-v2') && !target.hasCls('disabled')) {
	            var docPath = target.getAttribute('data-doc-path');
	            if (!docPath) {
	                return;
	            }

	            var userInfo = Academia.model.authentication.UserInfoModel;
	            var access_token = userInfo.get("accessToken");

	            
	            var form = document.createElement('form');
	            form.method = 'POST';
	            form.action = SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_DOWNLOAD_DOC;
	            form.target = '_blank'; 

	            var tokenInput = document.createElement('input');
	            tokenInput.type = 'hidden';
	            tokenInput.name = 'access_token';
	            tokenInput.value = access_token;
	            form.appendChild(tokenInput);

	            var docIdInput = document.createElement('input');
	            docIdInput.type = 'hidden';
	            docIdInput.name = 'docId';
	            docIdInput.value = docPath;
	            form.appendChild(docIdInput);
	            
	            document.body.appendChild(form);
	            form.submit();
	            document.body.removeChild(form);
	            showSuccessMessage(getCommonTranslation('SUCCESS'), getExaminationTranslation('DOCUMENT_SUCCESSFULLY_DOWNLOADED'));
	        }
	    }, this, { delegate: '.download-icon-v2' });
   
	},
	onStudentGridViewReady: function (view) {

	    view.el.on('change', function (e, t) {
	    	var me = this;
	    	var grid  = me.getStudentForExternalTransferCreditGrid()
	        var input = t;
	        var file = input.files[0];

	        if (!file) return;
			
			var allowedTypes = ['application/pdf', 'image/png', 'image/jpeg'];
										    var maxSizeMB = 5;
										    var maxSizeBytes = maxSizeMB * 1024 * 1024;

										    if (!allowedTypes.includes(file.type)) {
												showWarningMessage(getCommonTranslation('ALERT'),'Invalid file type. Only PDF, PNG, and JPEG are allowed');
										     // fileInput.value = ''; // Reset input  
										      return false;
										    }

										    if (file.size > maxSizeBytes) {
												showWarningMessage(getCommonTranslation('ALERT'),'File size exceeds 5MB limit'); 
										     // fileInput.value = ''; // Reset input 
										      return false; 
										    } 

	        var formData = new FormData();
	        
	        formData.append('file', file);
	        
	        var userInfo = Academia.model.authentication.UserInfoModel;
	       	 var access_token = userInfo.get("accessToken");
	        
	       	var url = SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_UPLOAD_DOC+'?access_token='+access_token;
	       	 
	       	 var xhr = new XMLHttpRequest();
	       	 xhr.open('POST', url);
	       	 xhr.onload = function () {
	       	     if (xhr.status >= 200 && xhr.status < 300) {
	       	         var response = JSON.parse(xhr.responseText);
	       	      var response = JSON.parse(xhr.responseText);
                  var documentId = response;

                  var rowEl = Ext.get(input).up('tr.x-grid-row');
                  if (!rowEl) return;

                  var allRows = view.el.query('tr.x-grid-row');
                  var rowIndex = -1;
                  for (var i = 0; i < allRows.length; i++) {
                      if (allRows[i] === rowEl.dom) {
                          rowIndex = i;
                          break;
                      }
                  }

                  if (rowIndex !== -1) {
                      var record = grid.getStore().getAt(rowIndex);
                      if (record) {
                          var cleanedValue = input.value.replace('C:\\fakepath\\', '').replace(/ +/g, " ").split(' ').join('_');
                          record.set('documentId', documentId);
                          record.set('document', cleanedValue);
                          record.commit();
                          showSuccessMessage(getCommonTranslation('SUCCESS'), getExaminationTranslation('DOCUMENT_SUCCESSFULLY_UPLOADED'));
                      }
                  }
                  else {
                      showErrorMessage(getCommonTranslation('ERROR'), getCommonTranslation('FAILED_TO_SAVE'));
                  }
	       	     }
	       	 };
	       	 xhr.send(formData);

	    }, this, {
	        delegate: 'input.grid-upload-input',
	        capture: true
	    });
	    
	    view.el.on('click', function (e, t) {
	        //var target = Ext.get(t).down('.download-icon-v2');
	        var target = Ext.get(t)

	        if (target && target.hasCls('download-icon-v2') && !target.hasCls('disabled')) {
	            var docPath = target.getAttribute('data-doc-path');
	            if (!docPath) {
	                return;
	            }

	            var userInfo = Academia.model.authentication.UserInfoModel;
	            var access_token = userInfo.get("accessToken");

	            
	            var form = document.createElement('form');
	            form.method = 'POST';
	            form.action = SERVERURL.PATH_STUDENT_TRANSFER_CREDIT_DOWNLOAD_DOC;
	            form.target = '_blank'; 

	            var tokenInput = document.createElement('input');
	            tokenInput.type = 'hidden';
	            tokenInput.name = 'access_token';
	            tokenInput.value = access_token;
	            form.appendChild(tokenInput);

	            var docIdInput = document.createElement('input');
	            docIdInput.type = 'hidden';
	            docIdInput.name = 'docId';
	            docIdInput.value = docPath;
	            form.appendChild(docIdInput);
	            
	            document.body.appendChild(form);
	            form.submit();
	            document.body.removeChild(form);
	            showSuccessMessage(getCommonTranslation('SUCCESS'), getExaminationTranslation('DOCUMENT_SUCCESSFULLY_DOWNLOADED'));
	        }
	    }, this, { delegate: '.download-icon-v2' });
   
	},
    studentDocPassportContainerWindow: function(){
    	var StudentDocGrid = Ext.ComponentQuery.query('studentpassportdocumentgrid');
        
        var $this = this;
        var store = StudentDocGrid[0].store;
        
        var portalId = this.getCurrentLoggedPortalId();  	
        if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
        	var personInfoPanel  = this.getPassportgrid();
    		var selectedRec = personInfoPanel.getSelectionModel();
            	store.getProxy().extraParams = {
    			  ID: selectedRec.getSelection()[0].data.id
    			};
            	var studentDocPassportGrid = this.getStudentpassportdocumentgrid();
    			store.load({
    				callback:function() {
    					if(store.getCount()) {
    						if (studentDocPassportGrid.isHidden()) {
    							studentDocPassportGrid.setVisible(true);
    						}
    					}					
    				}
    			});
        	
        }else{
        	var contentPanelTab = this.getContentPanelActiveTab();
        	var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
    		var a  = personInfoPanel.down('passportgrid');
    		var selectedRec = a.getSelectionModel();
            	store.getProxy().extraParams = {
    			  ID: selectedRec.getSelection()[0].data.id
    			};
            	var studentDocPassportGrid = this.getStudentpassportdocumentgrid();
    			store.load({
    				callback:function() {
    					if(store.getCount()) {
    						if (studentDocPassportGrid.isHidden()) {
    							studentDocPassportGrid.setVisible(true);
    						}
    					}					
    				}
    			});
        }
        
		
       },	
    
    studentUrlPassportContainerWindow: function(){
    	var StudentUrlGrid = Ext.ComponentQuery.query('studentpassporturlgrid');
        
        var $this = this;
        var store = StudentUrlGrid[0].store;
        var portalId = this.getCurrentLoggedPortalId();  	
        if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
        	var personInfoPanel  = this.getPassportgrid();
            var selectedRec = personInfoPanel.getSelectionModel();
            	store.getProxy().extraParams = {
    			  ID: selectedRec.getSelection()[0].data.id
    			};
            	var studentUrlPassportGrid = this.getStudentpassporturlgrid();
    			store.load({
    				callback:function() {
    					if(store.getCount()) {
    						if (studentUrlPassportGrid.isHidden()) {
    							studentUrlPassportGrid.setVisible(true);
    						}	  											
    					}
    				}
    			});
        	
        }else{
        	var contentPanelTab = this.getContentPanelActiveTab();
    		var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
    		var a  = personInfoPanel.down('passportgrid'); 	
            var selectedRec = a.getSelectionModel();
            	store.getProxy().extraParams = {
    			  ID: selectedRec.getSelection()[0].data.id
    			};
            	var studentUrlPassportGrid = this.getStudentpassporturlgrid();
    			store.load({
    				callback:function() {
    					if(store.getCount()) {
    						if (studentUrlPassportGrid.isHidden()) {
    							studentUrlPassportGrid.setVisible(true);
    						}	  											
    					}
    				}
    			});
        	
        }
    },
    
    /* visa */
    
    studentDocVisaContainerWindow: function(){
    	var $this = this;
    	var StudentDocGrid = Ext.ComponentQuery.query('studentvisadocumentgrid');
        var store = StudentDocGrid[0].store;
     	
        var portalId = $this.getCurrentLoggedPortalId(); 
        if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
        	var personInfoPanel  = $this.getVisadetailgrid();
    		var selectedRec = personInfoPanel.getSelectionModel();
    		if (portalId == 2){
	            store.getProxy().extraParams = {
	            	ID: selectedRec.getSelection()[0].data.id
	    		};
    		} else {
    			store.getProxy().extraParams = {
	            	ID: selectedRec.getSelection()[0].data.id
	    		};
    		}
            var studentDocVisaGrid = $this.getStudentvisadocumentgrid();
            store.load({
            	callback: function(){
            		if(store.getCount()) {
            			if (studentDocVisaGrid.isHidden()) {
            				studentDocVisaGrid.setVisible(true);
            			}	
            		}
            	}
            });
        }else{
        	var contentPanelTab = $this.getContentPanelActiveTab();
        	var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
        	var a = personInfoPanel.down('visadetailgrid');
			var selectedRec = a.getSelectionModel();
        	store.getProxy().extraParams = {
			  ID: selectedRec.getSelection()[0].data.id
			};
	  					
			var studentDocVisaGrid = $this.getStudentvisadocumentgrid();
			store.load({
    			callback: function(){
    				if(store.getCount()) {
    					if (studentDocVisaGrid.isHidden()) {
    						studentDocVisaGrid.setVisible(true);
    					}	
    				}
    			}
    		});
        }
    },	
    
    studentUrlVisaContainerWindow: function(){
    	var $this = this;
    	var StudentUrlGrid = Ext.ComponentQuery.query('studentvisaurlgrid');
        var store = StudentUrlGrid[0].store;

        var portalId = $this.getCurrentLoggedPortalId(); 
        if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
        	var personInfoPanel  = $this.getVisadetailgrid();
    		var selectedRec = personInfoPanel.getSelectionModel();
    		if (portalId == 2){
	            store.getProxy().extraParams = {
	            	ID: selectedRec.getSelection()[0].data.id
	    		};
    		} else {
    			store.getProxy().extraParams = {
	            	ID: selectedRec.getSelection()[0].data.id
	    		};
    		}
    		var studentUrlVisaGrid = $this.getStudentvisaurlgrid();
			store.load({
    			callback: function(){
    				if(store.getCount()) {
    					if (studentUrlVisaGrid.isHidden()) {
    						studentUrlVisaGrid.setVisible(true);
    					}
    				}
    			}
    		});
        }else{
	        var contentPanelTab = $this.getContentPanelActiveTab();
			var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
			var a  = personInfoPanel.down('visadetailgrid'); 	
	        var selectedRec = a.getSelectionModel();
        	store.getProxy().extraParams = {
			  ID: selectedRec.getSelection()[0].data.id
			};
        	var studentUrlVisaGrid = $this.getStudentvisaurlgrid();
			store.load({
    			callback: function(){
    				if(store.getCount()) {
    					if (studentUrlVisaGrid.isHidden()) {
    						studentUrlVisaGrid.setVisible(true);
    					}
    				}
    			}
    		});
        }
				  					
    },
    
    
    	/*for Insurance*/
    
    studentDocInsuranceContainerWindow: function(){
    	var $this = this;
    	var StudentDocGrid = Ext.ComponentQuery.query('studentinsurancedocumentgrid');
        var store = StudentDocGrid[0].store;
     	
        var portalId = $this.getCurrentLoggedPortalId(); 
        if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
        	var personInfoPanel  = $this.getStudentinsurancedetailsgrid();
    		var selectedRec = personInfoPanel.getSelectionModel();
    		if (portalId == 2){
	            store.getProxy().extraParams = {
	            	ID: selectedRec.getSelection()[0].data.id
	    		};
    		} else {
    			store.getProxy().extraParams = {
	            	ID: selectedRec.getSelection()[0].data.id
	    		};
    		}
            var studentDocInsuranceGrid = $this.getStudentinsurancedocumentgrid();
            store.load({
            	callback: function(){
            		if(store.getCount()) {
            			if (studentDocInsuranceGrid.isHidden()) {
            				studentDocInsuranceGrid.setVisible(true);
            			}	
            		}
            	}
            });
        }else{
        	var contentPanelTab = $this.getContentPanelActiveTab();
        	var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
        	var a = personInfoPanel.down('studentinsurancedetailsgrid');
			var selectedRec = a.getSelectionModel();
        	store.getProxy().extraParams = {
			  ID: selectedRec.getSelection()[0].data.id
			};
	  					
			var studentDocInsuranceGrid = $this.getStudentinsurancedocumentgrid();
			store.load({
    			callback: function(){
    				if(store.getCount()) {
    					if (studentDocInsuranceGrid.isHidden()) {
    						studentDocInsuranceGrid.setVisible(true);
    					}	
    				}
    			}
    		});
        }
    },	
    
    studentUrlInsuranceContainerWindow: function(){
    	var $this = this;
    	var StudentUrlGrid = Ext.ComponentQuery.query('studentinsuranceurlgrid');
        var store = StudentUrlGrid[0].store;

        var portalId = $this.getCurrentLoggedPortalId(); 
        if (portalId == 3 || portalId == 2 ||  portalId == 7 ){
        	var personInfoPanel  = $this.getStudentinsurancedetailsgrid();
    		var selectedRec = personInfoPanel.getSelectionModel();
    		if (portalId == 2){
	            store.getProxy().extraParams = {
	            	ID: selectedRec.getSelection()[0].data.id
	    		};
    		} else {
    			store.getProxy().extraParams = {
	            	ID: selectedRec.getSelection()[0].data.id
	    		};
    		}
    		var studentInsuranceUrlgrid = $this.getStudentinsuranceurlgrid();
			store.load({
    			callback: function(){
    				if(store.getCount()) {
    					if (studentInsuranceUrlgrid.isHidden()) {
    						studentInsuranceUrlgrid.setVisible(true);
    					}
    				}
    			}
    		});
        }else{
	        var contentPanelTab = $this.getContentPanelActiveTab();
			var personInfoPanel = contentPanelTab.down('personinfopanel').getActiveTab();
			var a  = personInfoPanel.down('studentinsurancedetailsgrid'); 	
	        var selectedRec = a.getSelectionModel();
        	store.getProxy().extraParams = {
			  ID: selectedRec.getSelection()[0].data.id
			};
        	var studentUrlInsuranceGrid = $this.getStudentinsuranceurlgrid();
			store.load({
    			callback: function(){
    				if(store.getCount()) {
    					if (studentUrlInsuranceGrid.isHidden()) {
    						studentUrlInsuranceGrid.setVisible(true);
    					}
    				}
    			}
    		});
        }
				  					
    },
    
    
    
    viewOtherAcadmyLocationId:function (gridItemId,form){
     var this$ = this;
   	 var personProfile = this$.getContentPanelActiveTab();
   	 var grid = personProfile.down(gridItemId);
     var selectedRecord=grid.getSelectionModel();
     var academyLocation=selectedRecord.selectionStart.data.academyLocationIds;
     var formWindow = this$.getPersonCommonWindow();
       var form = formWindow.down('siblingform');
    	var siblingStudentId = form.down('#siblingStudentId');
    	siblingStudentId.getStore().getProxy().extraParams ={ 
    			academyLocationIds: academyLocation
        };
   	
   	},
    showHideStudentHostelCustomFieldData: function(form, isVisible){
    	if( !isNullOrEmpty(form.customFieldNameData) && isArray(form.customFieldNameData) ){
		   if( form.customFieldNameData.length > 0 ){
			   for( index in form.customFieldNameData ){
				   var fieldName = form.customFieldNameData[index];
				   if( !isNullOrEmpty(form.getForm().findField(fieldName)) ){
					   form.getForm().findField(fieldName).setVisible(isVisible);
				   }
			   }
		   }
	   }
    },
    
    loadStudentCustomFieldData: function(form, jData){
    	if(!isNullOrEmpty(jData.customData)){
			if(!isNullOrEmpty(jData.customData[0])){
				var customDataItem = jData.customData[0];
				if(!isNullOrEmpty(customDataItem)){
					for (var property in customDataItem) {
			    		if(property.startsWith("C") || property.startsWith("c") ){
			    			if(!isNullOrEmpty(form.findField(property)) ){
			    				if( form.findField(property).xtype == 'datefield' ){
			    					form.findField(property).setValue(dateRender(customDataItem[property]));
			    				} else {
			    					form.findField(property).setValue(customDataItem[property]);
			    				}
			    			}
			    		}
			    		if(property.startsWith("id") || property.startsWith("version") ){
			    			if(property.startsWith("id")){
			    				form.findField('customHiddenId').setValue(customDataItem[property]);
			    			}
			    			if(property.startsWith("version")){
			    				form.findField('customHiddenVersion').setValue(customDataItem[property]);
			    			}
			    		}
					}
				}
			}
		}
    },
    /**
     * Active my dashboard tab for student 
     * @author Rajkumar.patidar 
     */
    getActiveMyDashboard : function(){
    	var this$ = this;
    	var userInfo = Academia.model.authentication.UserInfoModel;
		var userId = userInfo.get('userId');
		var portalId = userInfo.get("portalId");
    	
    	var dashboardList =[], url=SERVERURL.USER_ACCESSIBLE_DASHLETS;
    	url = url.concat('?userId='+userId);
    	url = url.concat('&portalId='+portalId); 
    	url = url.concat('&dashboardType=STUDENT_PROFILE'); 

    },

    
    viewOtherAcadmyLocationId:function (gridItemId,form){
     var this$ = this;
   	 var personProfile = this$.getContentPanelActiveTab();
   	 var grid = personProfile.down(gridItemId);
     var selectedRecord=grid.getSelectionModel();
     var academyLocation=selectedRecord.selectionStart.data.academyLocationIds;
     var formWindow = this$.getPersonCommonWindow();
       var form = formWindow.down('siblingform');
    	var siblingStudentId = form.down('#siblingStudentId');
    	siblingStudentId.getStore().getProxy().extraParams ={ 
    			academyLocationIds: academyLocation
        };
   	
   	},
    showHideStudentHostelCustomFieldData: function(form, isVisible){
    	if( !isNullOrEmpty(form.customFieldNameData) && isArray(form.customFieldNameData) ){
		   if( form.customFieldNameData.length > 0 ){
			   for( index in form.customFieldNameData ){
				   var fieldName = form.customFieldNameData[index];
				   if( !isNullOrEmpty(form.getForm().findField(fieldName)) ){
					   form.getForm().findField(fieldName).setVisible(isVisible);
				   }
			   }
		   }
	   }
    },
    
    loadStudentCustomFieldData: function(form, jData){
    	if(!isNullOrEmpty(jData.customData)){
			if(!isNullOrEmpty(jData.customData[0])){
				var customDataItem = jData.customData[0];
				if(!isNullOrEmpty(customDataItem)){
					for (var property in customDataItem) {
			    		if(property.startsWith("C") || property.startsWith("c") ){
			    			if(!isNullOrEmpty(form.findField(property)) ){
			    				if( form.findField(property).xtype == 'datefield' ){
			    					form.findField(property).setValue(dateRender(customDataItem[property]));
			    				} else {
			    					form.findField(property).setValue(customDataItem[property]);
			    				}
			    			}
			    		}
			    		if(property.startsWith("id") || property.startsWith("version") ){
			    			if(property.startsWith("id")){
			    				form.findField('customHiddenId').setValue(customDataItem[property]);
			    			}
			    			if(property.startsWith("version")){
			    				form.findField('customHiddenVersion').setValue(customDataItem[property]);
			    			}
			    		}
					}
				}
			}
		}
    },
    /**
     * Active my dashboard tab for student 
     * @author Rajkumar.patidar 
     */
    getActiveMyDashboard : function(){
    	var this$ = this;
    	var userInfo = Academia.model.authentication.UserInfoModel;
		var userId = userInfo.get('userId');
		var portalId = userInfo.get("portalId");
    	
    	var dashboardList =[], url=SERVERURL.USER_ACCESSIBLE_DASHLETS;
    	url = url.concat('?userId='+userId);
    	url = url.concat('&portalId='+portalId); 
    	url = url.concat('&dashboardType=STUDENT_PROFILE'); 

    	Ext.Ajax.request({
    		type : 'rest',
    		async: false,
    		method : 'GET',
    		url : url,
    		success: function(response, action) {
    			dashboardList = Ext.decode(response.responseText); 
    			if (!isNullOrEmpty(dashboardList) && dashboardList.length > 0) {
    				var studentProfile = this$.getContentPanelActiveTab();
    		    	var personInfoPanel = studentProfile.down('personinfopanel');
    		    	var tabName = getCommonTranslation('MY_DASHBOARD');
    		    	var contentXtype ='personinfodashboardhomepage';

    		    	var	newTab = personInfoPanel.add({
    		    		xtype: contentXtype,
    		    		closable: false,
    		    		title: tabName
    		    	});
    		    	personInfoPanel.setActiveTab(newTab);
    		    	Ext.getBody().unmask();
    			} else {
    				var tabPanelTitle = 'STUDENT_PERSONAL_DETAILS';
    		        var tabPanelItemId = 'studentPersonalDetails';
    		        var tabPanelItemXtype = 'personalinformationform';
    		        var xtypeItemId = 'studentPersonalInformationForm';
    		        var defaultPanel = true;
    		        var renderPanel= true;
    		    	
    		        if (!isNullOrEmpty(renderPanel) && renderPanel) {
    		        	this$.addPersonTabPanel('STUDENT', tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel);
    		        }
    			}
    		}
    	});
    },
    
    
    /**
     * Get Student Profile Information
     * */
    getStudentProfileInformation: function() {
    	var this$ = this;
    	var studentProfile = this$.getContentPanelActiveTab();
    	var studentProfileView = studentProfile.down('#studentProfileView');
    	if(!isNullOrEmpty(studentProfileView)){
    		studentProfileView.refresh();
    	}
    	var userId = studentProfile.getUserId();
    	var admissionId = studentProfile.getAdmissionId();
    	if (!isNullOrEmpty(userId)) {
    		Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
    		var studentProfileUrl = SERVERURL.PATH_FIND_STUDENT_DETAILS_BY_STUDENT_ID_AND_ADMISSION_ID ;
    		Ext.Ajax.request({
    			type: 'rest',
    			params :{
    			id : userId,
    			admissionId : admissionId
    			},
    			url: studentProfileUrl,
    			method: 'GET',
    			success: function(res, action) {
    				var data = Ext.decode(res.responseText);
    				if(!isEmpty(data)){
    					this$.studentData = data;
    					//var tpl = studentProfileView.tpl;
    					var studentStatus = data.status ;
    					var isTemporaryInactive = data.temporaryInActive;
    					if(isTemporaryInactive){
    						isTemporaryInactive = getCommonTranslation('TEMPORARY_INACTIVE');
    					}else{
    						if(studentStatus === true){
    							studentStatus = getCommonTranslation('ACTIVE');
    						}else{
    							studentStatus = getCommonTranslation('INACTIVE');
    						}
    					}
    					data.person.status = studentStatus;
    					data.person.personId = data.code;
    					data.person.isInvalidDocument = data.isInvalidDocument;
    					data.person.isTemporaryInactive = isTemporaryInactive;
    					data.person.activeHoldsCount=data.activeHoldsCount;
    					studentProfile.setPersonInfo(data.person);
    					if(this$.getCurrentLoggedPortalId() != 3 && this$.getCurrentLoggedPortalId() != 7){
    						var store = studentProfileView.getStore();
    						if(!isNullOrEmpty(store)){
    							var templateDataArray=new Array();
        						templateDataArray.push(data.person);
        						store.loadData(templateDataArray);
    						}
    						//tpl.overwrite(studentProfileView.el.dom, data.person);
    					}
    				}
    			},
                failure: function(res, action) {
                	Ext.getBody().unmask();
                }
            });
    		var portalId = this$.getCurrentLoggedPortalId();
            this$.setUploadedPhotoToPersonProfile(SERVERURL.PERSON_IMAGE_DOWNLOAD,"STUDENT");

        }
    },
    
    /*saveStudentPersonPhotoUpload : function(photoFileImage){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	var studentPhotoUploadForm = personProfile.down('#studentPhotoUploadForm');
    	this$.savePersonPhotoUpload(studentPhotoUploadForm, personProfile.getPersonId(), SERVERURL.PERSON_IMAGE_UPLOAD, SERVERURL.PERSON_IMAGE_DOWNLOAD, function(success,photoUrl){
    		if(success){
    			this$.onRenderStudentPersonalInformationForm(photoUrl);
    		}
    		
    	});
    	
    },*/
    
    /**
     * On render faculty personal information form
     * call to personal information
     */
    onRenderStudentPersonalInformationForm : function(photoUrl){
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	
    	try{
        	if((portalId == 3 || portalId == 7) && personProfile.xtype == "dashboardhomepage"){
        		var contentPanel = this$.getContentPanel();
        		var personProfile = contentPanel.items.items[1];
        	}
        	if(portalId != 1 && personProfile.xtype != 'studentprofile') {
        		personProfile.down('#ethnicityItemId').setVisible(false);
        		personProfile.down('#ethnicityItemId').setDisabled(true);
        		personProfile.down('#genderIdentityItemId').setVisible(false);
        		personProfile.down('#genderIdentityItemId').setDisabled(true);
        		personProfile.down('#sexualOrientationItemId').setVisible(false);
        		personProfile.down('#sexualOrientationItemId').setDisabled(true);
        		personProfile.down('#termTimeAccommodationTypeItemId').setVisible(false);
        		personProfile.down('#termTimeAccommodationTypeItemId').setDisabled(true);
        		personProfile.down('#careLeaverItemId').setVisible(false);
        		personProfile.down('#careLeaverItemId').setDisabled(true);
        		personProfile.down('#ucasSchemeCodeItemId').setVisible(false);
        		personProfile.down('#ucasSchemeCodeItemId').setDisabled(true);
        	} 
    	}
    	catch(e){
    		//
    	}
    	
    	
    	if(!isNullOrEmpty(photoUrl)){
    		personProfile.personInfo.photoUrl=photoUrl;
    		}
    	var userId = personProfile.getUserId();
    	var form = personProfile.down('#studentPersonalInformationForm');
    	var admissionId = personProfile.getAdmissionId();
        if (!isNullOrEmpty(userId)) {
        	Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        	this$.hideUnhideDropdowns(form);
        	setTimeout(function(){
        		var url = SERVERURL.PATH_FIND_STUDENT_DETAILS_BY_STUDENT_ID_AND_ADMISSION_ID ;
        		var params = {
        				id : userId , 
        				admissionId : admissionId
        		};
        		this$.sendGetAjaxRequest(url, 'GET', params, function(option, success, response) {
        			if(success){
        				var data = Ext.decode(response.responseText);
        				if(!isEmpty(data)){
        					this$.setValueToPersonalInformationForm(data,userId);
        				}
        			}
        		});
        	},300);
        	
        }
        
        var url = SERVERURL.PATH_GRID_DATA_LOCK_PERSONAL_DETAIL_HOLD;
        var params = {
            studentId: userId,
            applyHoldAt: ''
        };

        this$.sendGetAjaxRequest(url, 'GET', params, function(option, success, response) {
            if (success) {
                var data = Ext.decode(response.responseText);
                if (!isEmpty(data) && data.length > 0) {
                    data.forEach(function(row) {
                        if (row.appliedHoldAt === "LOCK_PERSONAL_DETAILS" && (row.isRemoval === false || row.isRemoval === null)) {
                        	var fieldset = form.down('#personalFormField');
                        	if (fieldset) {
                        	    var tabTitle = getPersonModuleTranslation('PERSONAL_FORM_DETAILS');
                        	    var redMessage = getPersonModuleTranslation('LOCK_APPLIED_ON_PERSONAL_DETAILS_UPDATE');

                        	    var formattedTitle = tabTitle + " <span style='color: red; font-size: 0.7em;'> " + redMessage + "</span>";
                        	    fieldset.setTitle(formattedTitle);  // Updates title directly on the fieldset
                        	}
                        	this$.sendGetAjaxRequest(SERVERURL.PATH_STUDENT_PERSONAL_DETAIL_LOCK_FIND_ALL, 'GET', {}, function(option, success, response) {
                        	    if (success) {
                        	        var data = Ext.decode(response.responseText);
                        	        if (!isEmpty(data) && Array.isArray(data)) {
                        	            // Map fieldNames to their respective component itemIds
                        	            var fieldMap = {
                        	                shortNameOtherLanguage: '#shortNameOtherLnguageId',
                        	                shortName: '#shortNameId',
                        	                secondary_citizenship: '#stuSecondaryCitizenshipItemId',
                        	                secondLanguage: '#secondLanguage',
                        	                salutationId: '#salutationId',
                        	                sadcCitizenship: '#sadcCitizenship',
                        	                religionId: '#religionCombo',
                        	                printNameOtherLanguage: '#printNameOtherLnguageId',
                        	                printName: '#printNameId',
                        	                postNumber: '#postNumberId',
                        	                birth_place_language: '#birthPlaceOtherLanguageItemId',
                        	                birth_place: '#birthPlaceItemId',
                        	                phoneNo: '#phoneNoField',
                        	                phoneCountryCode: '#phoneCountryCode',
                        	                phoneAreaCode: '#phoneAreaCode',
                        	                pHDSponsor: '#pHDSponsorItemId',
                        	                nationalityId: '#nationalityCombo',
                        	                nationalID: '#nationalIDItemId',
                        	                naadStudent: '#naadStudent',
                        	                motivation: '#motivation',
                        	                mobileNumber: '#mobileNumber',
                        	                mobileCountryCode: '#cellCountryCode',
                        	                middleNameOtherLanguage: '#middleNameOtherLnguageId',
                        	                middleName: '#middleNameId',
                        	                maritalStatus: '#maritalStatusId',
                        	                lastNameOtherLanguage: '#lastNameOtherLnguageId',
                        	                lastName: '#lastNameId',
                        	                correspondence_language: '#stuCorrespondenceLanguageItemId',
                        	                initials: '#initialsId',
                        	                ifscCode: '#ifscCodeValue',
                        	                identityExpiryDate: '#identityExpiryDateItemId',
                        	                idTypeId: '#idTypeCombo',
                        	                idNumberSecond: '#idNumberSecond',
                        	                hpcsaRegNo: '#hpcsaRegNoId',
                        	                homeLanguage: '#homeLanguage',
                        	                genderId: '#genderCSM',
                        	                firstNameOtherLanguage: '#firstNameOtherLnguageId',
                        	                firstName: '#firstNameId',
                        	                externalSysRefThree: '#externalSysRefThree',
                        	                externalSysRefTwo: '#externalSysRefTwo',
                        	                externalSysRefOne: '#externalSysRefOne',
                        	                emailId: '#emailId',
                        	                domicileId: '#domicileCombo',
                        	                haveDisabilities: '#haveDisabilities',
                        	                birthDate: '#birthDateId',
                        	                countryId: '#countryCombo',
                        	                alternateEmailId: '#alternateEmailId',
                        	                alternateMobileCountryCode: '#alternateCellCountryCode',
                        	                alternateMobileNo: '#alternateMobileNumber',
                        	                bloodGroup: '#bloodGroupId',
                        	                castCategoryId: '#castCategoryCombo',
                        	                category: '#categoryId'
                        	            };

                        	            // Iterate over the data and set fields to read-only dynamically
                        	            data.forEach(function(record) {
                        	                var componentId = fieldMap[record.fieldNames];
                        	                if (componentId) {
                        	                    var component = form.down(componentId);
                        	                    if (component) {
                        	                        component.setReadOnly(record.isLocked);
                        	                    }
                        	                }
                        	            });
                        	        }
                        	    }
                        	});

                        }
                    });
                }
            }
        });
    },

setPersonDataToFinalObject :function(data,personData){
    	for (var key in personData) {
            if(isNullOrEmpty(personData[key])){            	
            	data[key]="";            	               
            }else{
            	data[key] = personData[key];   
            }    		
        }
    	return data;
    },
    
    /**
     * Set value to personal info
     */
    setValueToPersonalInformationForm : function(data,userId){
    	var accountingKey = data.accountingKey;
    	var admissionDate=data.person.studentDateOfAdmission;
    	var admissionId=data.admissionId;
    	var admissionCode =data.admissionCode;
    	var this$ = this;
    	var personProfile = this$.getContentPanelActiveTab();
    	
    	try{
        	if((portalId == 3 || portalId == 7) && personProfile.xtype == "dashboardhomepage"){
        		var contentPanel = this$.getContentPanel();
        		var personProfile = contentPanel.items.items[1];
        	}
    	}
    	catch(e){
    		//
    	}
    	
    	var personalInformationForm = personProfile.down('#studentPersonalInformationForm');
    	var haveDisabilities = personalInformationForm.down('#haveDisabilities');
    	var religionCombo = personalInformationForm.down('#religionCombo');
    	var advisorId = personalInformationForm.down('#advisorItemId');
    	var idTypeField = personalInformationForm.down("#idTypeCombo");
    	var bloodGroupId = personalInformationForm.down("#bloodGroupId");
    	
    	var maritalStatusCombo =personalInformationForm.down('#maritalStatusId');
    	var examCenterVenueId= personalInformationForm.down("#examCenterVenue");
    	var advisorIdStore=advisorId.getStore();
    	var haveDisabilitiesStore = haveDisabilities.getStore();
    	var currentEducationalInterventions = personalInformationForm.getForm().findField('currentEducationalInterventions');                			
		var educationalInterventionsStore = currentEducationalInterventions.getStore();
        if(!isNullOrEmpty(personalInformationForm)){
        	
        	if(data.person)
        	// Check SA Validations
        	var applicantPersonRadioBtnRegisteredBeforeSA = personalInformationForm.down('#applicantPersonRadioBtnRegisteredBeforeSA');
            var allIntakeYear = personalInformationForm.down('#allIntakeYearItemId');
        	var registeredBeforeSA = personalInformationForm.down('#registeredBeforeSA');
            if(data.person && data.person.areYouRegisteredAtOtherSAU) {
            	applicantPersonRadioBtnRegisteredBeforeSA.setValue({ areYouRegisteredAtOtherSAU: true });
            	registeredBeforeSA.setVisible(true);
            	registeredBeforeSA.allowBlank = false;
            	this.handleRegisteredBeforeSAChange(personalInformationForm, allIntakeYear, true);
            	allIntakeYear.getStore().load({
					callback: function(records, operation, success) {
						for(var i in records){
							if(data.person.allIntakeYear !== null){
								if(records[i].data.id==data.person.allIntakeYear.id){
									allIntakeYear.setValue(records[i].data.id);
								}
							}
						}
					}
				});
            	
            	registeredBeforeSA.setValue(data.person.studentNoAtOtherSAU);                            	
            } else {
            	allIntakeYear.setVisible(false);
            	registeredBeforeSA.setVisible(false);
            	allIntakeYear.allowBlank = true;
            	registeredBeforeSA.allowBlank = true;
            	allIntakeYear.setValue(null);
            	registeredBeforeSA.setValue("");
            }
        	personalInformationForm.down('#stuPermanentResItemId').items.items[0].setValue(false);
        	personalInformationForm.down('#stuPermanentResItemId').items.items[1].setValue(false);
    		
        	personalInformationForm.down('#stuAsylumSeekerItemId').items.items[0].setValue(false);
        	personalInformationForm.down('#stuAsylumSeekerItemId').items.items[1].setValue(false);
    		
        	personalInformationForm.down('#stuAreYouRefugeeItemId').items.items[0].setValue(false);
        	personalInformationForm.down('#stuAreYouRefugeeItemId').items.items[1].setValue(false);
        	
        	personalInformationForm.down('#applicantDocUploadForm').setVisible(false);
        	personalInformationForm.down('#applicantDownloadURL').setVisible(false);
        	personalInformationForm.down('#imageMarketingCheckbox').setVisible(false);
        	personalInformationForm.down('#consentedCommunicationChannel').setVisible(false);
        	personalInformationForm.down('#consentStatementAccepted').setVisible(false);
        	
        	var uploadDocField =  personalInformationForm.down('#studentDocUploadForm');
        	var uploadDocURL =  personalInformationForm.down('#studentDownloadURL');
        	this.loadDFRForIDTypeVisibility(idTypeField, uploadDocField, uploadDocURL);
        	personalInformationForm.down('#studentDownloadURL').setVisible(false);
        	if(uploadDocField.isVisible()) {
        		personalInformationForm.down('#studentDownloadURL').setVisible(true);
//        		personalInformationForm.down('#studentDownloadURL').setValue(personData.supportDocument);
        	}
        	var personData = this$.getStudentPersonalInfoFormValue(data.person);
            
        	if(!isNullOrEmpty(personData.nationality)){
        		if(personData.nationality.code == 'South African'){
        			personalInformationForm.down('#stuPermanentResItemId').setDisabled(true);	
        			personalInformationForm.down('#stuAsylumSeekerItemId').setDisabled(true);	
        			personalInformationForm.down('#stuAreYouRefugeeItemId').setDisabled(true);	
        		}
        	}
        	
        	if(!isNullOrEmpty(personData.secondaryCitizenship)){
        		if(personData.secondaryCitizenship.code == 'South African'){
        			personalInformationForm.down('#stuPermanentResItemId').setDisabled(true);	
        			personalInformationForm.down('#stuAsylumSeekerItemId').setDisabled(true);	
        			personalInformationForm.down('#stuAreYouRefugeeItemId').setDisabled(true);	
        		}
        	}
        	
        	data = this$.setPersonDataToFinalObject(data, personData);
        	if(!isNullOrEmpty(personData.supportDocument)){
        		personalInformationForm.down('#studentDownloadURL').setValue(personData.supportDocument);
        	}
        	var shortNameElm = personalInformationForm.down('#shortNameId');
        	Ext.apply(personalInformationForm,{
        		code:null,
     		  setCode : function(code){
     			 personalInformationForm.code = code;
     		  },
     		  getCode:function(){
     			  return personalInformationForm.code;
     		  }
     	  });
        	personalInformationForm.setCode(data.code)
            personalInformationForm.getForm().setValues(data);        	
        	//V2D-52640
        	if(!isNullOrEmpty(data.studentBirthDate)){
        		personalInformationForm.down("#birthDateId").setValue(data.studentBirthDate);
        	}
        	if(!isNullOrEmpty(data.unconditionalOfferSentDate)){
        		personalInformationForm.down("#unconditionalOfferSentDate").setValue(dateRender(data.unconditionalOfferSentDate));
        	} 
        	if(!isNullOrEmpty(data.emergencyMobileCountryCode)){
				personalInformationForm.down('#emergencyMobileCountryCode').getStore().load({
					callback: function(){
						personalInformationForm.down('#emergencyMobileCountryCode').setValue(data.emergencyMobileCountryCode);
					}
				});
			}
        	var emplang = this$.getEmployeeLanguageValue(personData);
        	personalInformationForm.down("#admissionDate").setValue(admissionDate);
        	personalInformationForm.down("#admissionIdIteamId").setValue(admissionCode);
        	personalInformationForm.down("#admissionCodeIteamId").setValue(admissionCode);
        	// set genderCSM value
        	if (!isNullOrEmpty(personData.genderCSM) && !isNullOrEmpty(personData.genderCSM.id)) {
        		personalInformationForm.down("#genderCSM").setValue(personData.genderCSM.id);
			}
        	if(!isNullOrEmpty(personData.maritalStatusId) && !isNullOrEmpty(personData.maritalStatusId.id)){
        		personalInformationForm.down("#maritalStatusId").setValue(personData.maritalStatusId.id);
			}
        	else {
        		personalInformationForm.down("#maritalStatusId").setValue(null);
			}
        	
        	if(!isNullOrEmpty(personData.dietPreference) && !isNullOrEmpty(personData.dietPreference.id)){
        		personalInformationForm.down("#dietPreferenceId").store.load({
        			callback: function(){
                		personalInformationForm.down("#dietPreferenceId").setValue(personData.dietPreference.id);
        			}
        		});
			}
        	else {
        		personalInformationForm.down("#dietPreferenceId").setValue(null);
			}
        	var idNumberSecond = personalInformationForm.down("#idNumberSecond");
        	if(!isNullOrEmpty(personData.idtype) && !isNullOrEmpty(personData.idtype.id)){
       		personalInformationForm.down("#idTypeCombo").setValue(personData.idtype.id);
			if (personData.idtype.idTypeCode == 'NATIONAL_ID') {
					idNumberSecond.setVisible(false);
					idNumberSecond.setValue(null);
					idNumberSecond.allowBlank = true;
					personalInformationForm.down("#identityExpiryDateItemId").setVisible(false);
                    this$.setAllowBlank(personalInformationForm.down("#identityExpiryDateItemId"),true);
				} else {
					idNumberSecond.setVisible(true);
					this$.checkDFRForIdNumberSecond(personalInformationForm);
					this$.checkDFRForidentityExpiryDate(personalInformationForm);
					if(!isNullOrEmpty(personData.idNumberSecond)){
						idNumberSecond.setValue(personData.idNumberSecond);
					}
				}
			}else{
					idNumberSecond.setVisible(false);
			}
        	if(!isNullOrEmpty(personData.identityExpiryDate)){
        		personalInformationForm.down("#identityExpiryDateItemId").setValue(dateRender(personData.identityExpiryDate));
			}
        	
        	/*V2D-500627*/
        	if(!isNullOrEmpty(data.ethnicityCSM)){
				personalInformationForm.down('#ethnicityItemId').getStore().load({
					callback: function(){
						personalInformationForm.down('#ethnicityItemId').setValue(data.ethnicityCSM.id);
					}
				});
			}
        	
        	if(!isNullOrEmpty(data.genderIdentityCSM)){
				personalInformationForm.down('#genderIdentityItemId').getStore().load({
					callback: function(){
						personalInformationForm.down('#genderIdentityItemId').setValue(data.genderIdentityCSM.id);
					}
				});
			}
        	
        	if(!isNullOrEmpty(data.sexualOrientationCSM)){
				personalInformationForm.down('#sexualOrientationItemId').getStore().load({
					callback: function(){
						personalInformationForm.down('#sexualOrientationItemId').setValue(data.sexualOrientationCSM.id);
					}
				});
			}
        	
        	if(!isNullOrEmpty(data.termTimeAccomodationTypeCSM)){
				personalInformationForm.down('#termTimeAccommodationTypeItemId').getStore().load({
					callback: function(){
						personalInformationForm.down('#termTimeAccommodationTypeItemId').setValue(data.termTimeAccomodationTypeCSM.id);
					}
				});
			}
        	
        	if(!isNullOrEmpty(data.careLeaverCSM)){
				personalInformationForm.down('#careLeaverItemId').getStore().load({
					callback: function(){
						personalInformationForm.down('#careLeaverItemId').setValue(data.careLeaverCSM.id);
					}
				});
			}
        	
        	if(!isNullOrEmpty(data.uCASSchemeCode)) {
        		personalInformationForm.down('#ucasSchemeCodeItemId').setValue(data.uCASSchemeCode);
        	}
        	
        	/*V2D-500627*/
        	
        	
        	var editUrl = SERVERURL.PATH_FIND_DATES_BY_STUDENT_ID;
			Ext.Ajax.request({
        		method: "GET",
        		type: 'rest',
        		url: editUrl,
        		params: {
        			studentId: userId
        		},
        		success: function(response, action) {
        			var resp = Ext.JSON.decode(response.responseText);
        			if(resp[0] !=null){
        				//personalInformationForm.down("#admissionDate").setMinValue(resp[0].programPeriodStart);
        				//personalInformationForm.down("#admissionDate").setMaxValue(resp[0].enrollmentDate);
        			}
        		}
        	})
        	
        	 if(personData.isWheelChairRequired == true){
            	 personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(true);
            	 personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(false);
     	   }else
     	   {
     		  personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[0].setValue(false);
         	  personalInformationForm.down("#stuIsWheelCharRequiredItemId").items.items[1].setValue(true);
     	   }
           
			if(personData.isPermanentResident == true){
				personalInformationForm.down("#stuPermanentResItemId").items.items[0].setValue(true);
				personalInformationForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
			}else if(personData.isPermanentResident == false){
				personalInformationForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
				personalInformationForm.down("#stuPermanentResItemId").items.items[1].setValue(true);
			}else{
				personalInformationForm.down("#stuPermanentResItemId").items.items[0].setValue(false);
				personalInformationForm.down("#stuPermanentResItemId").items.items[1].setValue(false);
			}	

           if(personData.areYouRefugee == true){
          	 personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(true);
          	 personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
			}else if (personData.areYouRefugee == false){
    		  personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
       	     personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(true);
			}else{
				personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[0].setValue(false);
				personalInformationForm.down("#stuAreYouRefugeeItemId").items.items[1].setValue(false);
    	    }
           
           if(personData.isAsylumSeeker == true){
          	 personalInformationForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(true);
          	 personalInformationForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
			}else if(personData.isAsylumSeeker == false){
    		  personalInformationForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
       	      personalInformationForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(true);
			}else{
				personalInformationForm.down("#stuAsylumSeekerItemId").items.items[0].setValue(false);
				personalInformationForm.down("#stuAsylumSeekerItemId").items.items[1].setValue(false);
    	   }
           
           if(personData.isTertiaryInstitution == true){
            	 personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(true);
            	 personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(false);
      	   }else
      	   {
      		  personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[0].setValue(false);
         	  personalInformationForm.down("#stuIsStudyingInstitutionItemId").items.items[1].setValue(true);
      	   }
           if(personData.isEnrolledTertiaryInstitute == true){
          	 personalInformationForm.down("#isEnrolledTertiaryItemId").items.items[0].setValue(true);
          	 personalInformationForm.down("#isEnrolledTertiaryItemId").items.items[1].setValue(false);
    	   }else
    	   {
    		  personalInformationForm.down("#isEnrolledTertiaryItemId").items.items[0].setValue(false);
    		  personalInformationForm.down("#isEnrolledTertiaryItemId").items.items[1].setValue(true);
    	   }
           
           if(personData.isMilitarySponsored == true){
        	   personalInformationForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(true);
        	   personalInformationForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(false);
           }
           if(personData.isMilitarySponsored == false){
        	   personalInformationForm.down("#isMilitarySponsoredItemId").items.items[0].setValue(false);
        	   personalInformationForm.down("#isMilitarySponsoredItemId").items.items[1].setValue(true);
           }

           if(personData.isBursaryRequirements == true){
        	   personalInformationForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(true);
        	   personalInformationForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(false);
           }
           if(personData.isBursaryRequirements == false){
        	   personalInformationForm.down("#isBursaryRequirementsItemId").items.items[0].setValue(false);
        	   personalInformationForm.down("#isBursaryRequirementsItemId").items.items[1].setValue(true);
           }
           if(personData.diplomaticStatus == true){
				personalInformationForm.down("#diplomaticStatusId").items.items[0].setValue(true);
				personalInformationForm.down("#diplomaticStatusId").items.items[1].setValue(false);
			}else
			{
				personalInformationForm.down("#diplomaticStatusId").items.items[0].setValue(false);
				personalInformationForm.down("#diplomaticStatusId").items.items[1].setValue(true);
			}

			if(personData.temporaryStudy == true){
				personalInformationForm.down("#temporaryStudyId").items.items[0].setValue(true);
				personalInformationForm.down("#temporaryStudyId").items.items[1].setValue(false);
			}else
			{
				personalInformationForm.down("#temporaryStudyId").items.items[0].setValue(false);
				personalInformationForm.down("#temporaryStudyId").items.items[1].setValue(true);
			}
			
			if(personData.workCriticalSkills == true){
				personalInformationForm.down("#workCriticalSkillsId").items.items[0].setValue(true);
				personalInformationForm.down("#workCriticalSkillsId").items.items[1].setValue(false);
			}else
			{
				personalInformationForm.down("#workCriticalSkillsId").items.items[0].setValue(false);
				personalInformationForm.down("#workCriticalSkillsId").items.items[1].setValue(true);
			}
			
			if(personData.postgraduateNonResidentialStudent == true){
				personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(true);
				personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(false);
			}else
			{
				personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[0].setValue(false);
				personalInformationForm.down("#postgraduateNonResidentialStudentId").items.items[1].setValue(true);
			}
			if(personData.isAutomateExchange == true){
              	 personalInformationForm.down("#isAutomateExchange").items.items[0].setValue(true);
              	 personalInformationForm.down("#isAutomateExchange").items.items[1].setValue(false);
            }else{
        		 personalInformationForm.down("#isAutomateExchange").items.items[0].setValue(false);
           	     personalInformationForm.down("#isAutomateExchange").items.items[1].setValue(true);
            }
           if(personData.pHDSponsor == 'DOD'){
        	   personalInformationForm.down("#pHDSponsorItemId").items.items[0].setValue(true);
        	   personalInformationForm.down("#pHDSponsorItemId").items.items[1].setValue(false);
           }
           if(personData.pHDSponsor == 'MYSELF'){
        	   personalInformationForm.down("#pHDSponsorItemId").items.items[0].setValue(false);
        	   personalInformationForm.down("#pHDSponsorItemId").items.items[1].setValue(true);
           }
        	
           if(personData.isAdult == true){
             	 personalInformationForm.down("#applicantPersonRadioBtnPopiaAct").items.items[0].setValue(true);
             	 personalInformationForm.down("#applicantPersonRadioBtnPopiaAct").items.items[1].setValue(false);
      	   }else if(personData.isAdult == false)
      	   {
      		  personalInformationForm.down("#applicantPersonRadioBtnPopiaAct").items.items[0].setValue(false);
          	  personalInformationForm.down("#applicantPersonRadioBtnPopiaAct").items.items[1].setValue(true);
      	   }
           
           if(personData.whetherRPLApplicant == true){
           	 personalInformationForm.down("#whetherRPLApplicant").items.items[0].setValue(true);
           	 personalInformationForm.down("#whetherRPLApplicant").items.items[1].setValue(false);
    	   }else if(personData.whetherRPLApplicant == false)
    	   {
    		  personalInformationForm.down("#whetherRPLApplicant").items.items[0].setValue(false);
        	  personalInformationForm.down("#whetherRPLApplicant").items.items[1].setValue(true);
    	   }
           
			if(!isNullOrEmpty(personData.nationalID))
        	{
        		personalInformationForm.down("#verifyDetail").setDisabled(false);
        	}else
        	{
        		personalInformationForm.down("#verifyDetail").setDisabled(true);

        	}
        	
        	if(!isNullOrEmpty(accountingKey)){
        		personalInformationForm.down("#accountingKeyId").setValue(accountingKey);
        	}
        	
            personalInformationForm.down("#validTill").setValue(data.studentValidTill);
            if (!isNullOrEmpty(data.person) && !isNullOrEmpty(data.person.currentEducationalInterventions) &&
            		!isNullOrEmpty(data.person.currentEducationalInterventions.code) &&
            		data.person.currentEducationalInterventions.code == 'OTHER') {
            	var specifyOtherItemId = personalInformationForm.down("#specifyOtherItemId");
            	specifyOtherItemId.setVisible(true);
            	specifyOtherItemId.allowBlank = false;
            	personalInformationForm.isValid();
            }
            // V2D-146115 : Removed 
            /*var isRegistrationContractItemId = personalInformationForm.down("#isRegistrationContractItemId");
            var isRegistrationContractContainerItemId = personalInformationForm.down("#isRegistrationContractContainerItemId");
            if (!isNullOrEmpty(data.person) && !isNullOrEmpty(data.person.isRegistrationContract) && data.person.isRegistrationContract) {
                isRegistrationContractItemId.setVisible(true);
                isRegistrationContractContainerItemId.setVisible(true);
            } else {
                isRegistrationContractItemId.setVisible(false);
                isRegistrationContractContainerItemId.setVisible(false);
            }*/
            var studentAttendanceGroupField =  personalInformationForm.down('#studentAttendanceGroup')
            var studentAttendanceGroup= [];
			   if(data.studentAttendanceGroup.length > 0){
				   for (var i in data.studentAttendanceGroup){
					   studentAttendanceGroup.push(data.studentAttendanceGroup[i].attendanceGroup.id);
				   }
			   }
			   studentAttendanceGroupField.setValue(studentAttendanceGroup);
			   
			var countryCodeFieldItemIDArray = [];
			if(isNullOrEmpty(personData.phoneCountryCode)) {
				countryCodeFieldItemIDArray.push("#phoneCountryCode");
			} else {
				personalInformationForm.down('#phoneCountryCode').getStore().load({
		             callback: function(records, operation, success) {
		                 if (success) {
		                	 personalInformationForm.down('#phoneCountryCode').setValue(personData.phoneCountryCode);
		                 }
		             }
				});
			}
			if(isNullOrEmpty(personData.mobileCountryCode)) {
				countryCodeFieldItemIDArray.push("#cellCountryCode");
			} else {
				personalInformationForm.down('#cellCountryCode').getStore().load({
		             callback: function(records, operation, success) {
		                 if (success) {
		                	 personalInformationForm.down('#cellCountryCode').setValue(personData.mobileCountryCode);
		                 }
		             }
				});
			}
			if(isNullOrEmpty(personData.alternateMobileCountryCode)) {
				countryCodeFieldItemIDArray.push("#alternateCellCountryCode");
			} else {
				personalInformationForm.down('#alternateCellCountryCode').getStore().load({
		             callback: function(records, operation, success) {
		                 if (success) {
		                	 personalInformationForm.down('#alternateCellCountryCode').setValue(personData.alternateMobileCountryCode);
		                 }
		             }
				});
			}
			if(!isNullOrEmpty(countryCodeFieldItemIDArray) && countryCodeFieldItemIDArray.length>0) {
				this.setDefaultCountryCode(personalInformationForm, countryCodeFieldItemIDArray);
			}

		    
		    if(this.getCurrentLoggedPortalId()!=3) {
		           var countryCodeField = personalInformationForm.down("#cellCountryCode");
		           var mobileField = personalInformationForm.down("#mobileNumber");
		           this.setMaximumMinimumDigitsForMobileNoValidation(personalInformationForm,countryCodeField,mobileField,null);
		           var countryCodeField = personalInformationForm.down("#phoneCountryCode");
		           var phoneNoField = personalInformationForm.down("#phoneNoField");
		           this.setMaximumMinimumDigitsForPhoneNoValidation(personalInformationForm,countryCodeField,phoneNoField,null);
		           var countryCodeField = personalInformationForm.down("#alternateCellCountryCode");
		           var mobileField = personalInformationForm.down("#alternateMobileNumber");
		           this.setMaximumMinimumDigitsForMobileNoValidation(personalInformationForm,countryCodeField,mobileField,null);
			   }
		    
		    if(personData.haveDisabilities == null) {
    			haveDisabilitiesStore.load({
    				callback: function(records, operation, success) {
    					if (success) {
    						var haveDisabilitiesArray= [];
    						if(records.length > 0){
    							personData.personDisability.forEach(function(persondisabilityObj){
    								var result = records.filter(function (obj) {
    									  return obj.data.id === persondisabilityObj.haveDisabilities.id;
    									})[0];
    								haveDisabilitiesArray.push(result);
    							});
    							haveDisabilities.setValue(haveDisabilitiesArray);
    						}
    					}
    				}
    	        });
			}
		    
		    bloodGroupId.getStore().load({
					  callback: function(record, operation, success) {
						  if (success) {
							  for(var i in record) {
								  if(personData.bloodGroup!=null) {
		    					  	if(record[i].data.id ==personData.bloodGroup) {
		    					  	bloodGroupId.setValue(record[i].data.id);
		    					 	}
	    					 	 }
								  else {
									bloodGroupId.setValue(null);
								  }
							 }
						  }
					  }
				  });
		    
		    examCenterVenueId.getStore().load({
				  callback: function(record, operation, success) {
					  if (success) {
						  for(var i in record) {
							  if(personData.examCenterVenue!=null) {
	    					  	if(record[i].data.id ==personData.examCenterVenue) {
	    					  		examCenterVenueId.setValue(record[i].data.id);
	    					 	}
  					 	 }
							  else {
								  examCenterVenueId.setValue(null);
							  }
						 }
					  }
				  }
			  });
	    
		    
		    if(!isNullOrEmpty(personData.religion)) {
		    religionCombo.getStore().load({
	            callback: function(records, operation, success) {
	                if (success) {
	                    for(var i in records){
	                        if(records[i].data.id == personData.religion.id){
	                        religionCombo.setValue(personData.religion.id);
	                        }
	                    }
	                }
	            }
	        });
		   }
		  if(!isNullOrEmpty(personData.idtype)) {
		   idTypeField.getStore().load({
	             callback: function(records, operation, success) {
	                 if (success) {
	                	 if(!isNullOrEmpty(personData.idtype) && !isNullOrEmpty(personData.idtype.id)){
	                     for(var i in records){
	                         if(records[i].data.id == personData.idtype.id){
	                        	 idTypeField.setValue(personData.idtype.id);
	                         }
	                     }
	                     }
	                 }
	             }
	         });
		   }
		   if(!isNullOrEmpty(personData.dietPreference)) {
			    religionCombo.getStore().load({
		            callback: function(records, operation, success) {
		                if (success) {
		                    for(var i in records){
		                        if(records[i].data.id == personData.dietPreference.id){
		                        religionCombo.setValue(personData.dietPreference.id);
		                        }
		                    }
		                }
		            }
		        });
			   }
			   
			if(!isNullOrEmpty(personData.religion)) {
		    			    religionCombo.getStore().load({
		    		            callback: function(records, operation, success) {
		    		                if (success) {
		    		                    for(var i in records){
		    		                        if(records[i].data.id == personData.religion.id){
		    		                        religionCombo.setValue(personData.religion.id);
		    		                        }
		    		                    }
		    		                }
		    		            }
		    		        });
		    }   
		  if(!isNullOrEmpty(personData.maritalStatusId)) {
			  maritalStatusCombo.getStore().load({
			  	callback: function(records, operation, success) {
			  	   if (success) {
			  	     for(var i in records){
			  	     if(records[i].data.id == personData.maritalStatusId){
			  	        maritalStatusCombo.setValue(personData.maritalStatusId);
			  	       }
			  	      }
			  	     }
			  	    }
			 });
			}
		    if(!isNullOrEmpty(personalInformationForm.down("#armsOfService"))){
            	var armsOfService = personalInformationForm.down("#armsOfService");
            	armsOfService.getStore().load({
            		callback: function(records, operation, success) {
            			if (success) {
            				for(i in records){
            					if(personData.armsOfService!==null){
            						if(records[i].data.id==personData.armsOfService.id){
            							var armsOfServiceId =  armsOfService.setValue(records[i].data.id);
            							var mustering = personalInformationForm.getForm().findField('mustering');
            							mustering.setDisabled(false);
            							var musteringStore = mustering.getStore();
            							musteringStore.getProxy().extraParams={
            								armsOfServiceId:records[i].data.id
            							};
            							musteringStore.load({
            								callback: function(records, operation, success) {
            									for(i in records){
            										if(personData.mustering!==null){
            											if(records[i].data.id==personData.mustering.id){
            												mustering.setValue(records[i].data.id);
            											}
            										}
            		
            									}

            								}

            							})
            						}
            					}
            				}

            			}
            		}

            	})
            }  
		    var mustering = personalInformationForm.getForm().findField('mustering');
    		this$.loadDFRForMusteringDFR(mustering);
		    
		    if(personData.currentEducationalInterventions == null) {
		    	educationalInterventionsStore.load({
    				callback: function(records, operation, success) {
    					if (success) {
    						var educationalInterventionsArray= [];
    						if(records.length > 0){
    							personData.personEducationInterventions.forEach(function(eduInterventionObj){
    								var result = records.filter(function (obj) {
    									  return obj.data.id === eduInterventionObj.educationInterventions.id;
    									})[0];
    								educationalInterventionsArray.push(result);
    							});
    							currentEducationalInterventions.setValue(educationalInterventionsArray);
    						}
    					}
    				}
    	        });
			}
		    advisorIdStore.load({
		    	callback: function(records, operation, success) {
	    			   for(var i=0; i< advisorIdStore.data.items.length;i++){
	    				   if(advisorIdStore.data.items[i].data.id == data.advisorId.id){
	    					   advisorId.setValue(advisorIdStore.data.items[i].data.id);
	    					   break;
	    				   } 
	    			   }
					}
	        });
		    

		    var currentOrLastSchoolAttendedCombo = personalInformationForm.getForm().findField('currentOrLastSchoolAttended');
            if( !isNullOrEmpty(currentOrLastSchoolAttendedCombo) ) {
            	currentOrLastSchoolAttendedCombo.allowBlank = true;
            	currentOrLastSchoolAttendedCombo.setVisible(false);
    	    }
            
            if((portalId == 3 || portalId == 7)){
            	personalInformationForm.getForm().findField('isAutomateExchange').setVisible(false);
            }
    	    
            this$.isRadioButtonTrue(data.person);

		    var isStudentStatusCSMVisible = true;
		    Ext.Ajax.request({
		    	type: 'rest',
		    	async: false,
		    	url: SERVERURL.COMMON_FORM_FIELD_INFO,
		    	params: {
		    		screenName: 'personalinformationform',
		    		academyLocationId: this.getCurrentAcademyLocation(),
		    		languageCode:'en'
		    	},
		    	method: 'GET',
		    	success: function(res, action) {
		    		var response = Ext.decode(res.responseText);
		    		console.log(response);
		    		if( Object.keys(response).length > 0 ){
		    			var records=response.personalinformationform;
		    			for(i in records) {
		    				if(records[i].formFieldId == 'studentStatusItemId' && records[i].isVisible == true){
		    					isStudentStatusCSMVisible = true;
		    				}
		    				if(records[i].formFieldId == 'studentStatusItemId' && records[i].isVisible == false){
		    					isStudentStatusCSMVisible = false;
		    				}
		    			}
		    		}

		    		var studentStatusCombo = personalInformationForm.getForm().findField('studentStatus');
		    		if( !isNullOrEmpty(studentStatusCombo) ) {

		    			if( isStudentStatusCSMVisible == true ){
		    				studentStatusCombo.setVisible(true);
		    			}

		    			if( !isNullOrEmpty(personData.studentStatus)) {
		    				var studentStatusComboStore = studentStatusCombo.getStore();
		    				studentStatusComboStore.load({
		    					callback: function(records, operation, success) {
		    						for(var i=0; i< studentStatusComboStore.data.items.length;i++){
		    							if(studentStatusComboStore.data.items[i].data.id == data.studentStatus.id){
		    								studentStatusCombo.setValue(studentStatusComboStore.data.items[i].data.id);
		    								break;
		    							} 
		    						}
		    					}
		    				});
		    			}
		    		}
		    	}

		    });
		    
        }
        Ext.defer(function() {
        	personalInformationForm.down("#printNameId").setValue(data.printName);
			}, 100, this);
        var task = new Ext.util.DelayedTask(function(){
        	shortNameElm.setValue(data.shortName);
        	Ext.getBody().unmask();
    	});
    	task.delay(200);
    	
    	var checkboxDropdownId = personProfile.down('#checkboxDropdown').getValue();
    	if(!isNullOrEmpty(checkboxDropdownId) && checkboxDropdownId){
    		Ext.defer(function() {
            	if(!isNullOrEmpty(personData) && !isNullOrEmpty(personData.bankDetail) && !isNullOrEmpty(personData.bankDetail.bankName)){
            		personProfile.down('#bankNameValue').getStore().load(function(records, operation, success){
            			if(success){
            				for(i in records){
            					if(records[i].data.value==personData.bankDetail.bankName){
            						personProfile.down('#bankNameValue').setValue(personData.bankDetail.bankName);
            						personProfile.down('#branchNameValue').setDisabled(false);
            		        		personProfile.down('#ifscCodeValue').setDisabled(false);
            		        		personProfile.down('#branchNameValue').getStore().getProxy().extraParams = {
                                   	 bankName:personData.bankDetail.bankName
         							}
            		        		personProfile.down('#branchNameValue').getStore().load(function(records, operation, success){
            		        			if(success && !isNullOrEmpty(personData.bankDetail.branchName)){
            		        				for(i in records){
            		        					if(records[i].data.value==personData.bankDetail.branchName){
            		        						personProfile.down('#branchNameValue').setValue(personData.bankDetail.branchName);
            		        					}
            		        				}
            		        			}
        	            				personProfile.down('#ifscCodeValue').getStore().getProxy().extraParams = {
        	                            bankName:personData.bankDetail.bankName
        	     						}
        				            	personProfile.down('#ifscCodeValue').getStore().load(function(records, operation, success){
        				            		if(success && !isNullOrEmpty(personData.bankDetail.ifsCode)){
        			        		        	for(i in records){
        			        		        		if(records[i].data.code==personData.bankDetail.ifsCode){
        				            					personProfile.down('#ifscCodeValue').setValue(personData.bankDetail.ifsCode);
        			        		        					}
        			        		        					}
        			        		        				}
        				            				});
        	            			});
            					}
            				}
            			}
            		});
            	}
            }, 500, this);	
    	}
    	
    },
       exportPDFParentGuardianReport : function(){
          	var this$ = this;
          	var personProfile = this$.getContentPanelActiveTab();
          	var personId;
          	var applicationId;
          	var portalId = this$.getCurrentLoggedPortalId();
          	try{
          		personId = personProfile.getPersonId();
          		applicationId = personProfile.applicationId;
          	}catch(e){
          		personId = this$.getContentPanel().items.items[0].getPersonId();
          		applicationId = this$.getContentPanel().items.items[0].applicationId;
          	}
   		var code = 'PARENT_GUARDIAN_REPORT_PDF';
   		var reportParams =new Object();
   		reportParams.personId = personId;
   		reportParams.headerName = 'Parent Guardian  Report';
   		var reportTitle="Parent Guardian  Report";
   		if(portalId==6){
   			this.exportJRXMLReport(code,reportParams,reportTitle,'.pdf',SERVERURL.PARENT_AND_GUARDIAN_DETAILS_PDF_REPORT_APPLICANT);
   		}else{
   			this.exportJRXMLReport(code,reportParams,reportTitle,'.pdf',SERVERURL.PARENT_AND_GUARDIAN_DETAILS_PDF_REPORT);
   		}
   	},
   	exportXLParentGuardianReport : function(){
   		var this$ = this;
      	var personProfile = this$.getContentPanelActiveTab();
      	var personId;
      	var applicationId;
      	var portalId = this$.getCurrentLoggedPortalId();
      	try{
      		personId = personProfile.getPersonId();
      		applicationId = personProfile.applicationId;
      	}catch(e){
      		personId = this$.getContentPanel().items.items[0].getPersonId();
      		applicationId = this$.getContentPanel().items.items[0].applicationId;
      	}
		var code = 'PARENT_GUARDIAN_REPORT_EXCEL';
		var reportParams =new Object();
		reportParams.personId = personId;
		reportParams.headerName = 'Parent Guardian  Report';
		var reportTitle="Parent Guardian  Report";
		if(portalId==6){
			this.exportJRXMLReport(code,reportParams,reportTitle,'.vnd.ms-excel',SERVERURL.PARENT_AND_GUARDIAN_DETAILS_EXCEL_REPORT_APPLICANT);
		}else{
			this.exportJRXMLReport(code,reportParams,reportTitle,'.vnd.ms-excel',SERVERURL.PARENT_AND_GUARDIAN_DETAILS_EXCEL_REPORT);
		}
		
	},
	editParentFeePayerDetailRecord: function(btn,records){
   		var this$ = this;
   	    var personComContlr =Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
	  	personType='PARENT',
	    tabPanelTitle= 'FPD_FEE_PAYER_DETAILS',
		tabPanelItemId= 'personfeepayerdetailformItemId',
		tabPanelItemXtype = 'feepayerdetailform',
		xtypeItemId = 'personfeepayerdetailformItemId',
		defaultPanel= true,
		menuColorCls =CONSTANTS.MENU_COLOR_SEVEN;
		
       personComContlr.addPersonTabPanel(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,'',menuColorCls);
      	var form = this$.getParentFeePayerDetailForm();
          var formScroll = form.up('form');
          
		if(!isNullOrEmpty(formScroll.getEl()))
		{
			var getElValue=formScroll.getEl();
			var getFirstChild = getElValue.first();
			getFirstChild.dom.style.overflowY="scroll";
		} 
		if(records){
			form.isPrimaryFeePayer=records.data.isPrimaryFeePayer;
		}
		
           if (!isEmpty(records)) {
               var payerTypeItemId = form.down("#payerTypeItemId");
               payerTypeItemId.setReadOnly(true);
               var doesFeePayerConsentToCreditCheckItemId = form.down("#doesFeePayerConsentToCreditCheckItemId");
               if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.doesFeePayerConsentToCreditCheck)) {
               	doesFeePayerConsentToCreditCheckItemId.setValue({
               		doesFeePayerConsentToCreditCheck: records.data.doesFeePayerConsentToCreditCheck
               	});
               }
               var salutationItemId = form.down("#salutationItemId");
               if (!isNullOrEmpty(records.data.salutation) && !isNullOrEmpty(records.data.salutation.id)) {
               	salutationItemId.getStore().load({
					   callback: function(recordss, operation, success) {
						   for(var i in recordss){
							   if( !isNullOrEmpty(records.data.salutation) ){
								   if(recordss[i].data.id==records.data.salutation.id){
									 salutationItemId.setValue(recordss[i].data.id);
								   }
							   }
						   }
					   }	   
				   });
             }
               
               var bankItemId = form.down("#bankItemId");
               /*if (!isNullOrEmpty(records.data.bank) && !isNullOrEmpty(records.data.bank.id)) {
               	bankItemId.setValue(records.data.bank.id);
               }*/
            
               var debitOrderDateItemId = form.down("#debitOrderDateItemId");
               debitOrderDateItemId.getStore().load({
				   callback: function(recordss, operation, success) {
					   for(var i in recordss){
						   if(!isNullOrEmpty(records.data.debitOrderDateCSM)){
							   if(recordss[i].data.id==records.data.debitOrderDateCSM.id){
								   debitOrderDateItemId.setValue(recordss[i].data.id);
							   } 
						   }
					   }
				   }	   
			   });
/*               if (!isNullOrEmpty(records.data.debitOrderDateCSM) && !isNullOrEmpty(records.data.debitOrderDateCSM.id)) {
            	   debitOrderDateItemId.setValue(records.data.debitOrderDateCSM.id);
            	   
               
               }
*/               
               
               
               var empOfTheOrganizationField = form.down("#empOfTheOrgItemId");
               if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.employeeOfOrganization)) {
               	empOfTheOrganizationField.setValue({
               		employeeOfOrganization: records.data.employeeOfOrganization
               	});
               }
               
               var branchCodeId = form.down("#branchCodeItemId");
               
               if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.bank)){
               bankItemId.getStore().load({
					   callback: function(recordss, operation, success) {
						   for(var i in recordss){
							   if(!isNullOrEmpty(records.data.bank)){
								   if(recordss[i].data.id==records.data.bank.id){
									   bankItemId.setValue(recordss[i].data.id);
								   } 
							   }
						   }
					   }	   
				   });
               var branchCodeStore = branchCodeId.getStore();
               branchCodeStore.getProxy().extraParams = {
                   bankId: records.data.bank.id
               };
               branchCodeStore.load();
               }
               
            if(!isNullOrEmpty(records.data) && records.data.branchcode!=null){
               		branchCodeId.setValue(records.data.branchcode);
             }
               
            var addressText = form.down('#addressTextArea');
           	var country = form.down('#countryId');
           	var countryRegion = form.down('#parentCountryRegionId');
           	var city = form.down('#cityId');
           	var pincode = form.down('#pincodeId');
           	
           	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.addressText)) {
           		  addressText.setValue(records.data.addressText);
               }
           	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.pincode)) {
           		pincode.setValue(records.data.pincode);
             }
           	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.countryId)) {
           		country.setValue(records.data.countryId);
           		countryRegion.setDisabled(false);
           		var countryRegionStore = countryRegion.getStore();
                   countryRegionStore.getProxy().extraParams = {
                       cid: records.data.countryId
                   };
                   countryRegionStore.load();                  
             }
           	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.parentCountryRegionId)) {
           	
           		countryRegion.setValue(records.data.parentCountryRegionId);      
           		city.setDisabled(false);
           		  var cityStore = city.getStore();
                                          
                     cityStore.getProxy().extraParams = {
                    	 countryId: records.data.countryId,
                    	 countryRegionId: records.data.parentCountryRegionId
                     };
                     cityStore.load();
             }
           	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.cityId)) {
           		city.setValue(records.data.cityId);
             }
           	
               var feePayerIDItemId = form.down("#feePayerIDItemId");
               var feePayerLatestPayslipItemId = form.down("#feePayerLatestPayslipItemId");
               var feePayerProofOfAccountItemId = form.down("#feePayerProofOfAccountItemId");
               
               if (records.data.feePayerId && records.data.feePayerId.encryptedDocId){
            	   this.setAllowBlank(feePayerIDItemId,true);
               }
               else {
            	   this.setAllowBlank(feePayerIDItemId,false);
               }
               if (records.data.feePayerLatestPayslip && records.data.feePayerLatestPayslip.encryptedDocId){
            	   this.setAllowBlank(feePayerLatestPayslipItemId,true);
                   }
                   else {
                	   this.setAllowBlank(feePayerLatestPayslipItemId,false);
                   }
               feePayerProofOfAccountItemId.allowBlank = true;
               feePayerIDItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_ID'));
			   feePayerLatestPayslipItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_LATEST_PAYSLIP'));
			   feePayerProofOfAccountItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_PROOF_OF_ACCOUNT'));
               form.loadRecord(records);
               if(!isNullOrEmpty(records.data.debitOrderStartDate)){
           		var debitOrderStartDate = form.down("#debitOrderStartDate");
           		debitOrderStartDate.setValue(dateRender(records.data.debitOrderStartDate));
             	}
	           	if(!isNullOrEmpty(records.data.debitOrderEndDate)){
	           		var debitOrderEndDate = form.down("#debitOrderEndDate")
	               	debitOrderEndDate.setValue(dateRender(records.data.debitOrderEndDate));
	           	}
	           	var companySponsorLetterItemId = form.down("#companySponsorLetterItemId");
	           	var feePayerURL = form.down('#feePayerURL');
            	var feePayerLatestPayslipURL = form.down('#feePayerLatestPayslipURL');
            	var feePayerProofOfAccountURL = form.down('#feePayerProofOfAccountURL');
            	var companySponsorLetterURL = form.down('#companySponsorLetterURL');
            	if (!isNullOrEmpty(records.data.feePayerId)) {
					feePayerURL.setValue(records.data.feePayerId.path);
				}
            	if(feePayerIDItemId.isVisible()){
					feePayerURL.setVisible(true);	
				}
            	if (!isNullOrEmpty(records.data.feePayerLatestPayslip)) {
					feePayerLatestPayslipURL.setValue(records.data.feePayerLatestPayslip.path);
				}
            	if(feePayerLatestPayslipItemId.isVisible()){
					feePayerLatestPayslipURL.setVisible(true);
				}
            	if (!isNullOrEmpty(records.data.feePayerProofOfAccountUploadPath)) {
					feePayerProofOfAccountURL.setValue(records.data.feePayerProofOfAccountUploadPath.path);
					form.getForm().findField('feePayerProofOfAccountUploadPath').setValue('');
				}
            	if(feePayerProofOfAccountItemId.isVisible()){
					feePayerProofOfAccountURL.setVisible(true);
				}
            	if (!isNullOrEmpty(records.data.companySponsorLetter)) {
					companySponsorLetterURL.setValue(records.data.companySponsorLetter.path);
				}
            	if(companySponsorLetterItemId.isVisible()){
					companySponsorLetterURL.setVisible(true);
				}
               return form;
           } 
       	
      	return formWindow;
	},
	addDocumentsImagesField:function(obj,getJsonList) {
		var $this = this;
		var feepayerpaymenttermdocumentsview =obj.down('#feepayerpaymenttermdocumentsviewItemId');
		var fieldContainer=feepayerpaymenttermdocumentsview.down('panel');
		var belowDocumentCheckboxesview =obj.down('#belowDocumentCheckboxes');
		var belowDocumentfieldContainer=belowDocumentCheckboxesview.down('panel');
		
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.PATH_FEEPLAN_DOCUMENTBY_FEEPLANID +'?feePlanId='+getJsonList.feePlanIdOfProgramType,
			method: 'GET',
			success: function(res, action) {
				var data = Ext.decode(res.responseText);
				if(!isEmpty(data)){
					for(var i = 0; i<data.rows.length;i++) {
					fieldContainer.add({
							xtype: 'panel',
							layout: 'vbox',
							//cls:'studentChangeImageBoxBorder',
							items : [{
								xtype: 'image',
								width: 70,
								height: 70,
								cls:'feePayerPaymentTermDocumentPDFIcon',
								title:data.rows[i].documentName,
								documentId: data.rows[i].documentId,
								listeners: { 
									el: {
										click: function(obj) {
											var documentId = Ext.getCmp(this.id).documentId;
											if (!isNullOrEmpty(documentId)) {
												$this.getDownloadFileForSelectPaymentTermDocument(documentId);
											}
										} 
									} 
								}
							},{
								xtype: 'panel',
								width: 1200,
								items : [{
								xtype: 'label',
								style:{'margin-left':'0px !important','margin-top':'7px', 'max-width': '1500px', 'margin-bottom':'1px'},
								html: data.rows[i].documentName
								}]
							}]
					});
					belowDocumentCheckboxesview.add({
						xtype: 'fieldcontainer',
						layout: 'hbox',
						//cls:'studentChangeImageBoxBorder',
						items : [{
				            xtype: 'checkbox',
				            style: {'margin-left': '5px'},
				            width: 130,
				            labelAlign: 'right',
				            itemId:'img'+data.rows[i].documentId,
				            allowBlank:false,
				            name: 'img'+data.rows[i].documentId,
				        	listeners: {
				            	change: function(checkbox, newValue, oldValue, eOpts) {
				            		var stc =  checkbox.up('studentregistrationtabstructure');
				            		var formItems = stc.down('#belowDocumentCheckboxes');
				            		var flag = true;
				            		if(formItems.items.items.length>0){
				            			Ext.each(formItems.items.items, function(itemObj){
				            				if(itemObj.down('checkbox').getValue() == true){
				            					flag = true;
				            				}else{
				            					flag = false;
				            					return false;
				            				}
				            			});
				            		}
				//            		var  checkFirst = stc.down('#whetherReadDocuments').getValue();
				            		var  checkSecond = stc.down('#whetherMedicalConfirmation').getValue();
				            		var  checkThird = stc.down('#whetherFeePayerDetailConfirm').getValue();
				            		var  finalSubmitBtn = stc.down('#finalSubmitButtonId');
				            		if (checkSecond && checkThird && flag) {
				            			finalSubmitBtn.setDisabled(false);
				            		} else {
				            			finalSubmitBtn.setDisabled(true);
				            		}
				            	}
				            }
						},{
							xtype: 'label',
							width: 1350,
							style:{'margin-left':'-115px !important', 'margin-top':'8px'},
							html: data.rows[i].documentName
						}]
				});
				}	
				}else{
					fieldContainer.add({
							xtype: 'label',
							width: 100,
							height: 100,
							text:getCommonTranslation('NO_RECORDS_FOUND'),
						});
				}
			}
		});
		obj.doLayout();
	},
    getDownloadFileForSelectPaymentTermDocument : function(documentId){
       	if(!isNullOrEmpty(documentId)){
       		var csvForm = Ext.create('Ext.form.Panel'); 
       		csvForm.getForm().submit({
       			target: '_blank',
       			method:'GET',
       			params :{
       				access_token : Ext.Ajax.defaultHeaders.access_token
       			},
       			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
       			url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
       			standardSubmit :true
       		});
       	}
       },
       editCurrentGradePaymentTermsCardRecord: function(btn){
    	   var $this = this;
    	   showClickToEnter = true;
    	   var formWindow = $this.getFeepayercurrentpaymenttermeditform();
           if (!formWindow) {
            	Ext.widget('feepayercurrentpaymenttermeditform');
            	formWindow = $this.getFeepayercurrentpaymenttermeditform();
            }
            formWindow.show();
            var userInfo =  Academia.model.authentication.PortalInfoModel
			var getCardDetail = Ext.ComponentQuery.query('currentgradepaymenttermscardtpl')[0];
			var currentPBSTIdField = getCardDetail.down('[name=pbscId]');
			if(!isNullOrEmpty(currentPBSTIdField.getValue()))
			{
				var studentId = userInfo.data.student.id;
				if(!isNullOrEmpty(studentId))
				{
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.PATH_FINDPAYMENT_TERMSETTINGS_FOR_CURRENTYEAR,
						params:{
							studentId: studentId,
							pbscId :currentPBSTIdField.getValue()
						},
						method: 'GET',
						async: false,
						success: function(res, action) {
							getJsonList = Ext.decode(res.responseText); 
							formWindow.down('#currentPTEGrade').setValue(getJsonList.gradeName);
							formWindow.down('#currentPTEIntake').setValue(getJsonList.nextAcademicYear);
							var dataModal = getJsonList.parentFeePlanSelectionModels;
							var store = $this.getStore('personinfo.common.personalinfo.FeePayerCurrentPaymentTermEditGridStore');
							if(store.getRange()){
								store.removeAll();	 
							}
							store.loadRawData(dataModal, true);
							if(btn == 'view'){
								var gridCurrentPaymentTerm = formWindow.down('#feepayercurrentpaymenttermeditgridItemId');
								//gridCurrentPaymentTerm.columns[4].getEditor().setReadOnly(true);
								gridCurrentPaymentTerm.columns[2].getEditor().setReadOnly(true);
								formWindow.down('#submitButtonId').setVisible(false);
								showClickToEnter=false;
							}
						}
					});
				}
			}
       },
       ViewNextGradePaymentTermsCardRecord: function(btn,isView){
    	   var $this = this;
    	   var formWindow = $this.getFeepayernextpaymenttermviewform();
           if (!formWindow) {
            	Ext.widget('feepayernextpaymenttermviewform');
            	formWindow = $this.getFeepayernextpaymenttermviewform();
            }
            formWindow.show();
            formWindow.isView = isView;
            var submitBtn = formWindow.down('#submitButtonId');
            if(isView){
            	submitBtn.hide();
            }else{
            	submitBtn.show();
            }
            var userInfo =  Academia.model.authentication.PortalInfoModel
			var getCardDetail = Ext.ComponentQuery.query('nextacademicyearpaymenttermcardtpl')[0];
			var currentPBSTIdField = getCardDetail.down('[name=pbscId]');
			if(!isNullOrEmpty(currentPBSTIdField.getValue()))
			{
				var studentId = userInfo.data.student.id;
				if(!isNullOrEmpty(studentId))
				{
					Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.PATH_FINDPAYMENTTERM_SETTINGSFOR_NEXTYEAR,
						params:{
							studentId: studentId,
							nextPBSId :currentPBSTIdField.getValue()
						},
						method: 'GET',
						async: false,
						success: function(res, action) {
							getJsonList = Ext.decode(res.responseText); 
							formWindow.down('#currentPTEGrade').setValue(getJsonList.gradeName);
							formWindow.down('#currentPTEIntake').setValue(getJsonList.nextAcademicYear);
							formWindow.down('#feePayerDetailId').setValue(getJsonList.feePayerDetailId);
							formWindow.down('#medicalDetailId').setValue(getJsonList.medicalDetailId);
							formWindow.down('#applicableForCurrentYear').setValue(getJsonList.applicableForCurrentYear);
							
							var dataModal = getJsonList.parentFeePlanSelectionModels;
							var store = $this.getStore('personinfo.common.personalinfo.FeePayerNextPaymentTermViewGridStore');
							if(store.getRange()){
								store.removeAll();	 
							}
							store.loadRawData(dataModal, true);
						}
					});
				}
			}
      },
       /*****START:Applied Permisssion on fee payer card layout*******/ 
       disableFeePayerCardLayoutButton : function(cardLayout,permissionsMap){
       	var associatedAcadLocationIds = new Array();
       	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
       	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
       	var editBtn = cardLayout.down('#edit_FP_ItemId');
    	var viewBtn = cardLayout.down('#view_FP_ItemId');
    	var deleteBtn = cardLayout.down('#delete_FP_ItemId');
       	editBtn.setVisible(false);
       	viewBtn.setVisible(false);
       	deleteBtn.setVisible(false);
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'UPDATE') {
       			editBtn.setVisible(true);    		
       		}
       		if (privilege === 'VIEW') {
       			viewBtn.setVisible(true);    		
       		}
       		if (privilege === 'DELETE') {
       			deleteBtn.setVisible(true);    		
       		}
       	}
       	);
       },
       /*****START:Applied Permisssion on fee payer card layout*******/ 
       disableFeePayerAddCardLayout : function(cardLayout,permissionsMap){
       	var associatedAcadLocationIds = new Array();
       	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
       	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
       	cardLayout.hide();
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'CREATE') {
       			cardLayout.show();	
       		}
       	}
       	);
       },
       
       /*****Applied Permisssion on fee payer corporate id*******/ 
       disableFeePayerCorporateId : function(corporateItemId,permissionsMap){
       	var associatedAcadLocationIds = new Array();
       	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
       	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
       		Ext.each(permissionList, function(privilege) {
           		if (privilege === 'CORPORATE_ID') {
           			corporateItemId.setVisible(true);	
           		}else{
               		corporateItemId.setVisible(false);	
               	}
          	});
       },
       
       onChangeIsAlumnus : function(parentGuardianForm){
    	   var $this = this;
    	   var getForm =   parentGuardianForm.getForm();
    	   var isAlumnusValue = getForm.findField('isAlumnus').getValue();
    	   var schoolAttendedField = parentGuardianForm.down('#schoolAttended');
    	   if(isAlumnusValue){
    		   $this.loadDFRForParentGuardianOnChange(schoolAttendedField);
    	   }
    	   else{
    		   schoolAttendedField.setVisible(false);
    		   schoolAttendedField.allowBlank = true; 
    		   parentGuardianForm.down('#submitButtonId').setDisabled(false);
    	   }
       },
       checkEmployeeIdDfr: function(empOfTheOrg,employeeId){
    	  	var $this = this;
    	  	var result = false;
    	  	var status = 0;
    	  	var radioGroupStatus = empOfTheOrg.getValue().employeeOfOrganization;
    		Ext.Ajax.request({
    			type: 'rest',
    			async: false,
    			url: SERVERURL.COMMON_FORM_FIELD_INFO,
    			params: {
    				screenName: 'feepayerdetailform',
    				academyLocationId: this.getCurrentAcademyLocation(),
    				languageCode:'en'
    			},
    			method: 'GET',
    			success: function(res, action) {
    				var response = Ext.decode(res.responseText);
    				if( Object.keys(response).length > 0 ){
    					var records=response.feepayerdetailform;
    					for(i in records){
    						if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='employeeIdItemId' && records[i].isMandatory==true){
    							employeeId.allowBlank = false;
    							status = 1;
    							result = true;
    						}else{
    							if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='employeeIdItemId' && records[i].isMandatory==false){
    								employeeId.allowBlank = true;
    								result = true;
    							}
    						}
    						if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='employeeIdItemId' && records[i].isVisible==true){
    							employeeId.setVisible(true);
    							result = true;
    							if(radioGroupStatus==true) {
    								employeeId.setVisible(true);
    							}
    							else {
    								employeeId.reset();
    								employeeId.setVisible(false);
    								if(status==1) {
    									employeeId.allowBlank = true;
    								}
    							}
    						}else{
    							if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='employeeIdItemId' && records[i].isVisible==false){
    								employeeId.reset();
    								employeeId.allowBlank = true;
    								employeeId.setVisible(false);
    								result = true;
    							}
    						}
    					}
    				}else{
    					return result;
    				}
    			}
    			
    		});
    		return result;
    	},
    	checkStudentHostelRequirementDfr: function(form){
    	  	var $this = this;
    	  	var isHostelRequired = form.down('#isHostelRequired');
    	  	var dietaryRequirementsItemId = form.down('#dietaryRequirementsItemId');
    	  	var foodAllergiesItemId = form.down('#foodAllergiesItemId');
    	  	var sleepingDisorderItemId = form.down('#sleepingDisorderItemId');
    	  	var anyMedicalNeedsOrSomethingItemId = form.down('#anyMedicalNeedsOrSomethingItemId');
    	  	var studentHostelDetailsId = form.down('#studentHostelDetailsId');
    	  	var hostelStatus = isHostelRequired.getValue();
    		Ext.Ajax.request({
    			type: 'rest',
    			async: false,
    			url: SERVERURL.COMMON_FORM_FIELD_INFO,
    			params: {
    				screenName: 'studentpersonhostelrequirementform',
    				academyLocationId: this.getCurrentAcademyLocation(),
    				languageCode:'en'
    			},
    			method: 'GET',
    			success: function(res, action) {
    				var response = Ext.decode(res.responseText);
    				if( Object.keys(response).length > 0 ){
    					var records=response.studentpersonhostelrequirementform;
    					for(i in records){
    						if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='dietaryRequirementsItemId' && records[i].isMandatory==true && records[i].isVisible==true){
    							if(hostelStatus) {
    								dietaryRequirementsItemId.allowBlank = false;
    							}
    							else {
    								dietaryRequirementsItemId.allowBlank = true;
    							}
    						}else if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='foodAllergiesItemId' && records[i].isMandatory==true && records[i].isVisible==true){
    							if(hostelStatus) {
    								foodAllergiesItemId.allowBlank = false;
    							}
    							else {
    								foodAllergiesItemId.allowBlank = true;
    							}
    						}else if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='sleepingDisorderItemId' && records[i].isMandatory==true && records[i].isVisible==true){
    							if(hostelStatus) {
    								sleepingDisorderItemId.allowBlank = false;
    							}
    							else {
    								sleepingDisorderItemId.allowBlank = true;
    							}
    						}else if(records[i].formFieldInputType=='textfield' && records[i].formFieldId=='anyMedicalNeedsOrSomethingItemId' && records[i].isMandatory==true && records[i].isVisible==true){
    							if(hostelStatus) {
    								anyMedicalNeedsOrSomethingItemId.allowBlank = false;
    							}
    							else {
    								anyMedicalNeedsOrSomethingItemId.allowBlank = true;
    							}
    						}else if(records[i].formFieldInputType=='multiselectcombofield' && records[i].formFieldId=='studentHostelDetailsId' && records[i].isMandatory==true && records[i].isVisible==true){
    							if(hostelStatus) {
    								studentHostelDetailsId.allowBlank = false;
    							}
    							else {
    								studentHostelDetailsId.allowBlank = true;
    							}
    						}else{
    							
    						}
    					}
    				}
    			}
    		});
    	},
    	removeStarFromDFR: function(form){
    	  	var $this = this;
    	  	var structure = $this.getStudentregistrationtabstructure();
        	var medicalDetailForm=structure.down("#medicaldetailsformparent");
            var familyPractionerContactNumberItemId = medicalDetailForm.down("#familyPractionerContactNumberItemId");
    		Ext.Ajax.request({
    			type: 'rest',
    			async: false,
    			url: SERVERURL.COMMON_FORM_FIELD_INFO,
    			params: {
    				screenName: 'medicaldetailsform',
    				academyLocationId: this.getCurrentAcademyLocation(),
    				languageCode:'en'
    			},
    			method: 'GET',
    			success: function(res, action) {
    				var response = Ext.decode(res.responseText);
    				if( Object.keys(response).length > 0 ){
    					var records=response.medicaldetailsform;
    					for(i in records){
    						if(records[i].formFieldInputType=='numberfield' && records[i].formFieldId=='familyPractionerContactNumberItemId' && records[i].isMandatory==true && records[i].isVisible==true){
    							medicalDetailForm.down("#familyPractionerContactNumberItemId").setFieldLabel("");
    						}
    						
    					}
    				}
    			}
    		});
    	},
    	remainingFieldsOfFeePayerForDFR: function(form){
    	  	var $this = this;
    	  	
       // 	var feePayerDetailForm=structure.down("#feepayerdetailform");
        	var academyLocationId = this.getCurrentAcademyLocation();
        	var newMandatoryFields = ['homeTelephoneCountryCodeItemId','homeTelephoneItemId','countryCodeItemId','mobileNumberItemId',
        		'workTelephoneCountryCodeItemId','workTelephoneItemId'];
        	var homeTelephoneContainerItemId = form.down('#homeTelephoneContainerItemId');
        	var workTelephoneContainerItemId = form.down('#workTelephoneContainerItemId');
        	var mobileNoFldItemId = form.down('#mobileNoFldItemId');
        	
            Ext.Ajax.request({
        		url: SERVERURL.COMMON_FORM_FIELD_INFO,
        		method: 'GET',
        		async: false,
        		params: {
        			screenName: 'feepayerdetailform',
        			academyLocationId:academyLocationId,
        			languageCode:'en'
        		},
        		success: function(response) {
        			var json = JSON.parse(response.responseText);
        			var fieldInfo = Academia.model.authentication.FormFieldInfoModel;
        			fieldInfo.set("formFieldsInfo", json);
        			//console.log(json);
        			if( !isNullOrEmpty(json) ){
        				if( !isNullOrEmpty(json.feepayerdetailform) ){
        					var feePayerDetailDFRConfig = json.feepayerdetailform;
        					for( i in feePayerDetailDFRConfig){
        						var fieldConfig = feePayerDetailDFRConfig[i];
        						//console.log(fieldConfig);
        						if( newMandatoryFields.includes(fieldConfig.formFieldId) ){
        							if( fieldConfig.isMandatory ){
        								var currentField = form.down("#"+fieldConfig.formFieldId);
        								$this.setAllowBlank(currentField, false);
        								var currentFieldLabel = fieldConfig.formFieldLabel;
        								currentField.setFieldLabel(currentFieldLabel);
        										
        								if(fieldConfig.formFieldId=="homeTelephoneCountryCodeItemId" || fieldConfig.formFieldId=="homeTelephoneItemId"){
        									homeTelephoneContainerItemId.labelSeparator = '';
            								homeTelephoneContainerItemId.setFieldLabel(getPersonModuleTranslation('FPD_HOME_TELEPHONE')+':' +'<span class="required" style="color:red"> *</span>');
			
        								}
        								if(fieldConfig.formFieldId=="workTelephoneCountryCodeItemId" || fieldConfig.formFieldId=="workTelephoneItemId"){
            								workTelephoneContainerItemId.labelSeparator = '';
            								workTelephoneContainerItemId.setFieldLabel(getPersonModuleTranslation('FPD_WORK_TELEPHONE')+':' +'<span class="required" style="color:red"> *</span>');
			
        								}
								
        								if(fieldConfig.formFieldId=="countryCodeItemId" || fieldConfig.formFieldId=="mobileNumberItemId"){
            								mobileNoFldItemId.labelSeparator = '';
            								mobileNoFldItemId.setFieldLabel(getPersonModuleTranslation('MOBILE_NUMBER')+':' +'<span class="required" style="color:red"> *</span>');
			
        								}

        								
        							}
        						}
        					}
        				}
        			}
        		}
        	});
    	},
    	 /*
         *  Need to set value in form
         */
        getStudentPersonalInfoFormValue: function(personData) {
            var this$ = this;
            if(!isEmpty(personData)){
            	personData.personId = personData.id;
            	personData.personVersion = personData.version;
            	this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'id', 'bankDetailsId');
                this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'version', 'bankDetailsVersion');
                this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'bankName', 'bankName');
                this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'accountNumber', 'accountNumber');
                this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'branchName', 'branchName');
                this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'ifsCode', 'ifsCode');
                this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'beneficiaryName', 'beneficiaryName');
                this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'beneficiaryNameOtherLanguage', 'beneficiaryNameOtherLanguage');
                this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'accountTypeId', 'accountTypeId');
                
                //this$.getPersonalInfoJsonValue(personData, 'bankDetail', 'accountingKey', 'accountTypeId');
                
                this$.getPersonalInfoJsonValue(personData, 'physicalCharacteristics', 'id', 'phyId');
                this$.getPersonalInfoJsonValue(personData, 'physicalCharacteristics', 'version', 'phyVersion');
                this$.getPersonalInfoJsonValue(personData, 'physicalCharacteristics', 'height', 'height');
                this$.getPersonalInfoJsonValue(personData, 'physicalCharacteristics', 'weight', 'weight');
                this$.getPersonalInfoJsonValue(personData, 'physicalCharacteristics', 'hairColor', 'hairColor');
                this$.getPersonalInfoJsonValue(personData, 'physicalCharacteristics', 'eyeColor', 'eyeColor'); 
                delete personData.id;
                delete personData.version;
            }
            
            
            return personData;
        },
isRadioButtonTrue: function(personData){
        var form = this.getPersonalInformationForm();
       var stuAsylumSeekerItemId = form.down("#stuAsylumSeekerItemId");
  	   var stuAreYouRefugeeItemId = form.down("#stuAreYouRefugeeItemId");
  	   var diplomaticStatusId = form.down("#diplomaticStatusId");
  	   var temporaryStudyId = form.down("#temporaryStudyId");
  	   var workCriticalSkillsId = form.down("#workCriticalSkillsId");
  	   var postgraduateNonResidentialStudentId = form.down("#postgraduateNonResidentialStudentId");
	   var stuPermanentResItemId = form.down("#stuPermanentResItemId");
 
	   if(!isEmpty(personData)){
    	if(personData.isPermanentResident == true)		
    		{
    		    stuAsylumSeekerItemId.setDisabled(true);
    		    stuAreYouRefugeeItemId.setDisabled(true);
				diplomaticStatusId.setDisabled(true);
				temporaryStudyId.setDisabled(true);
				workCriticalSkillsId.setDisabled(true);
				postgraduateNonResidentialStudentId.setDisabled(true);
    		}
    	if(personData.areYouRefugee == true)		
		{
		    stuAsylumSeekerItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
			diplomaticStatusId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(personData.isAsylumSeeker == true)		
		{
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
			diplomaticStatusId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(personData.diplomaticStatus == true)		
		{
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
		    stuAsylumSeekerItemId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(personData.temporaryStudy == true)		
		{
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
		    stuAsylumSeekerItemId.setDisabled(true);
		    diplomaticStatusId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(personData.workCriticalSkills == true)		
		{
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
		    stuAsylumSeekerItemId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			diplomaticStatusId.setDisabled(true);
			postgraduateNonResidentialStudentId.setDisabled(true);
		}
    	if(personData.postgraduateNonResidentialStudent == true)		
		{
    		stuAreYouRefugeeItemId.setDisabled(true);
		    stuPermanentResItemId.setDisabled(true);
		    stuAsylumSeekerItemId.setDisabled(true);
			temporaryStudyId.setDisabled(true);
			workCriticalSkillsId.setDisabled(true);
			diplomaticStatusId.setDisabled(true);
		}
	   }
    },
 	setPersonDataToFinalObject :function(data,personData){
    	for (var key in personData) {
            if(isNullOrEmpty(personData[key])){            	
            	data[key]="";            	               
            }else{
            	data[key] = personData[key];   
            }    		
        }
    	return data;
    },
		saveStudentPersonalInformation: function(obj, callBackFn) {
        var this$ = this;
        var isUpdate = false;
       // var admissionCode=null;
        var formWindow = obj.up('personalinformationform');
        var personProfile = this$.getContentPanelActiveTab();
//        console.log('personProfile',personProfile);
        var personInfo = personProfile.getPersonInfo();
//      console.log('personInfo',personInfo);personalinformationform
        var personalInformationForm = personProfile.down('#studentPersonalInformationForm');
        formWindow.down('#personalInfoSaveButtonId').setDisabled(true);
        Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
        var jsonFormatFormData = personalInformationForm.getValues();
        
        delete jsonFormatFormData.admissionCodeField;
        delete jsonFormatFormData.age;
        //jsonFormatFormData.admissionCode = admissionCode;
        if(isNullOrEmpty(jsonFormatFormData.genderCSM)){
        	jsonFormatFormData.genderCSM = null;
        }
        else {
        	jsonFormatFormData.genderCSM = jsonFormatFormData.genderCSM;
        }
        
        /* New */
        if(!isNullOrEmpty(jsonFormatFormData.ethnicity)) {
        	jsonFormatFormData.ethnicityCSM = {
        			id: jsonFormatFormData.ethnicity
        	};
        } 
        delete jsonFormatFormData.ethnicity;

        if(!isNullOrEmpty(jsonFormatFormData.genderIdentity)) {
        	jsonFormatFormData.genderIdentityCSM = {
        			id: jsonFormatFormData.genderIdentity
        	};
        }
        delete jsonFormatFormData.genderIdentity;
        
        if(!isNullOrEmpty(jsonFormatFormData.sexualOrientation)) {
        	jsonFormatFormData.sexualOrientationCSM = {
        			id: jsonFormatFormData.sexualOrientation
        	};
        } 
        delete jsonFormatFormData.sexualOrientation;
        
        if(!isNullOrEmpty(jsonFormatFormData.termTimeAccommodationType)) {
        	jsonFormatFormData.termTimeAccomodationTypeCSM = {
        			id: jsonFormatFormData.termTimeAccommodationType
        	};
        }
        delete jsonFormatFormData.termTimeAccommodationType;
        
        if(!isNullOrEmpty(jsonFormatFormData.careLeaver)) {
        	jsonFormatFormData.careLeaverCSM = {
        			id: jsonFormatFormData.careLeaver
        	};
        }
        delete jsonFormatFormData.careLeaver;
        
        if(!isNullOrEmpty(jsonFormatFormData.ucasSchemeCode)) {
        	jsonFormatFormData.uCASSchemeCode = jsonFormatFormData.ucasSchemeCode;
        }
        delete jsonFormatFormData.ucasSchemeCode;
        
        /*new*/
        
        if(!jsonFormatFormData.areYouRegisteredAtOtherSAU) {
        	if(isNullOrEmpty(jsonFormatFormData.studentNoAtOtherSAU)) {
        		var registeredBeforeSAItemId = personalInformationForm.down("#registeredBeforeSA");
        		registeredBeforeSAItemId.allowBlank = true;
        		delete jsonFormatFormData.studentNoAtOtherSAU;
        	}
        	if(isNullOrEmpty(jsonFormatFormData.allIntakeYear)) {
        		var allIntakeYearItemId = personalInformationForm.down('#allIntakeYearItemId');
        		allIntakeYearItemId.allowBlank = true;
        		delete jsonFormatFormData.allIntakeYear;
        	}
        } else {
        	if(!isNullOrEmpty(jsonFormatFormData.allIntakeYear)) {
        		var allIntakeYearItem = personalInformationForm.down('#allIntakeYearItemId');
        		if(allIntakeYearItem) {
        			jsonFormatFormData.allIntakeYear = {
            				'id': allIntakeYearItem.getValue()
            		}
        		}
        	}
        } 
        
        if(isNullOrEmpty(jsonFormatFormData.allIntakeYear)) {
    		var allIntakeYearItemId = personalInformationForm.down('#allIntakeYearItemId');
    		allIntakeYearItemId.allowBlank = true;
    		delete jsonFormatFormData.allIntakeYear;
    	}
        
        if(isNullOrEmpty(jsonFormatFormData.studentNoAtOtherSAU)) {
        	var registeredBeforeSAItemId = personalInformationForm.down("#registeredBeforeSA");
    		registeredBeforeSAItemId.allowBlank = true;
    		delete jsonFormatFormData.studentNoAtOtherSAU;
    	}
        
        if(isNullOrEmpty(jsonFormatFormData.currentOrLastSchoolAttendedCombo)||isNullOrEmpty(jsonFormatFormData.currentOrLastSchoolAttendedCombo.id)){
        	delete jsonFormatFormData.currentOrLastSchoolAttendedCombo;
        }
        
        if(isNullOrEmpty(jsonFormatFormData.currentOrLastSchoolAttended)||isNullOrEmpty(jsonFormatFormData.currentOrLastSchoolAttended.id)){
        	delete jsonFormatFormData.currentOrLastSchoolAttended;
        }
        
        if(isNullOrEmpty(jsonFormatFormData.sadcCitizenship)||isNullOrEmpty(jsonFormatFormData.sadcCitizenship.id)){
        	delete jsonFormatFormData.sadcCitizenship;
        }
        
        var checkboxDropdownId = personalInformationForm.down('#checkboxDropdown').getValue();
    	if(!isNullOrEmpty(checkboxDropdownId) && checkboxDropdownId==="true"){
    		
        	jsonFormatFormData.bankName = personProfile.down("#bankNameValue").getValue();
        	jsonFormatFormData.branchName = personProfile.down("#branchNameValue").getValue();
        	jsonFormatFormData.ifsCode = personProfile.down("#ifscCodeValue").getValue();
    	}
    	delete jsonFormatFormData.bankNameValue;
		delete jsonFormatFormData.branchNameValue;
		delete jsonFormatFormData.ifscCodeValue;
		delete jsonFormatFormData.checkboxDropdown;
        
        var maritalStatusId = null;
        if(!isNullOrEmpty(jsonFormatFormData.maritalStatus)){
        	maritalStatusId = {
                    id: jsonFormatFormData.maritalStatus
                };
        }
        jsonFormatFormData.maritalStatusId = maritalStatusId;
        jsonFormatFormData.maritalStatus = null;
        
        var dietPreferenceId = null;
        if(!isNullOrEmpty(jsonFormatFormData.dietPreference)){
        	dietPreferenceId = {
                    id: jsonFormatFormData.dietPreference
                };
        }
        jsonFormatFormData.dietPreference = dietPreferenceId;
        
        var idTypeId=null;
        if (!isNullOrEmpty(jsonFormatFormData.idtype)) {        	
        	idTypeId = {
                id: jsonFormatFormData.idtype
            };
        }
        jsonFormatFormData.idtype = idTypeId;
        
        
        var studentStatusCSM=null;
        if (!isNullOrEmpty(jsonFormatFormData.studentStatus)) {        	
        	studentStatusCSM = {
                id: jsonFormatFormData.studentStatus
            };
        }
        jsonFormatFormData.studentStatus = studentStatusCSM;
        
        if(isNullOrEmpty(jsonFormatFormData.secondaryCitizenship.id)){
        	jsonFormatFormData.secondaryCitizenship=null;
        }
        
        if(isNullOrEmpty(jsonFormatFormData.mobileNumber)){
        	jsonFormatFormData.mobileCountryCode=null;
        }
        if(isNullOrEmpty(jsonFormatFormData.phoneNo)){
        	jsonFormatFormData.phoneCountryCode=null;
        	jsonFormatFormData.phoneAreaCode=null;
        }
        if(isNullOrEmpty(jsonFormatFormData.armsOfService)){
        	delete jsonFormatFormData.armsOfService;
        }
        else {
        	var armsOfService;
        	armsOfService = {
                    id: jsonFormatFormData.armsOfService
                };
        	jsonFormatFormData.armsOfService = armsOfService;
        }
        if(isNullOrEmpty(jsonFormatFormData.mustering)){
        	delete jsonFormatFormData.mustering;
        }
        else {
        	var mustering;
        	mustering = {
                    id: jsonFormatFormData.mustering
            };
        	jsonFormatFormData.mustering = mustering;
        }
        
        if(isNullOrEmpty(jsonFormatFormData.examCenterVenue)){
        	delete jsonFormatFormData.examCenterVenue;
        }
        
        if(isNullOrEmpty(jsonFormatFormData.homeLanguage) || isNullOrEmpty(jsonFormatFormData.homeLanguage.id)){
        	delete jsonFormatFormData.homeLanguage;
        }
        if(this.validatePhone(jsonFormatFormData)){
        	if(!isNullOrEmpty(jsonFormatFormData.country)){
        	if(isNullOrEmpty(jsonFormatFormData.country.id)){
        		jsonFormatFormData.country=null;
        	}
        	}
        	if(!isNullOrEmpty(jsonFormatFormData.nationality) && isNullOrEmpty(jsonFormatFormData.nationality.id)){
        		jsonFormatFormData.nationality=null;
        	}
        	var studentPhotoUploadForm = personProfile.down('#studentPhotoUploadForm');
        	var photoFileImage = studentPhotoUploadForm.down('#photoFileImage');
        	var fileUploadPath = photoFileImage.getValue();
			
			var successMsg = true;
			if (personalInformationForm) {
				var data = personalInformationForm.getValues()
			}
			var idTypeCodeValue = personalInformationForm.down('#idTypeCombo').getStore().findRecord('id', data.idtype);
			if (!isNullOrEmpty(data.nationality)) {
				var index = personalInformationForm.down('#nationalityCombo').getStore().findExact('id', data.nationality.id);
				if (index !== -1) {
					var nationalityCodeValue = personalInformationForm.down('#nationalityCombo').getStore().getAt(personalInformationForm.down('#nationalityCombo').getStore().findExact('id', data.nationality.id));
				}

			}

			var uwcUrl = SERVERURL.PATH_GET_FIND_BY_RELEVANT_TO;
			Ext.Ajax.request({
				type: 'rest',
				url: uwcUrl + '?relavantToFormType=' + "DIRECT_ADMISSION",
				method: 'GET',
				success: function(response, action) {
					Ext.getBody().unmask();
					if (!isNullOrEmpty(response.responseText) && (response.responseText) != "") {
						var responseData = Ext.JSON.decode(response.responseText);
						if (responseData != null) {
							successMsg = this$.checkUwcNationalIdValidation(responseData, data, nationalityCodeValue, idTypeCodeValue);
							if (successMsg) {
								if (!isNullOrEmpty(fileUploadPath)) {
									this$.savePhotoUploadForm(studentPhotoUploadForm, personProfile.getPersonId(), SERVERURL.PERSON_IMAGE_UPLOAD, SERVERURL.PERSON_IMAGE_DOWNLOAD, function(success, photoUrl, version) {
										if (success) {
											if (!isNullOrEmpty(photoUrl)) {
												jsonFormatFormData.personVersion = version;
												personProfile.personInfo.photoUrl = photoUrl;
											}
											this$.savePersonInformationForm(obj, jsonFormatFormData, photoUrl, null, isUpdate, SERVERURL.PERSON_IMAGE_DOWNLOAD, callBackFn);
										}

									});
								} else {
									var photoUrl = personInfo.photoUrl;
									this$.savePersonInformationForm(obj, jsonFormatFormData, photoUrl, null, isUpdate, SERVERURL.PERSON_IMAGE_DOWNLOAD, callBackFn);
								}
							}else{
								var formWindow = obj.up('personalinformationform');
					        	formWindow.down('#personalInfoSaveButtonId').setDisabled(false);    	
							}
						}
					}
					else {
						if (!isNullOrEmpty(fileUploadPath)) {
							this$.savePhotoUploadForm(studentPhotoUploadForm, personProfile.getPersonId(), SERVERURL.PERSON_IMAGE_UPLOAD, SERVERURL.PERSON_IMAGE_DOWNLOAD, function(success, photoUrl, version) {
								if (success) {
									if (!isNullOrEmpty(photoUrl)) {
										jsonFormatFormData.personVersion = version;
										personProfile.personInfo.photoUrl = photoUrl;
									}
									this$.savePersonInformationForm(obj, jsonFormatFormData, photoUrl, null, isUpdate, SERVERURL.PERSON_IMAGE_DOWNLOAD, callBackFn);
								}
							});
						} else {
							var photoUrl = personInfo.photoUrl;
							this$.savePersonInformationForm(obj, jsonFormatFormData, photoUrl, null, isUpdate, SERVERURL.PERSON_IMAGE_DOWNLOAD, callBackFn);
						}
					}
				}
			});      
        }
        else{
        	var formWindow = obj.up('personalinformationform');
        	formWindow.down('#personalInfoSaveButtonId').setDisabled(false);    	
        } 
    },

	savePersonInformationForm: function(obj, jsonFormatFormData, photoUrl,documentUrl, isUpdate, downloadUrl, callBackFn){
    	var this$ = this;
    	var formWindow = obj.up('personalinformationform');
    	var personProfile = this$.getContentPanelActiveTab();
    	var personInfo = personProfile.getPersonInfo();
    	//jsonFormatFormData.photoUrl = photoUrl;
    	var disabilityJsonArry = [];
    	var eduInterventionsJsonArry = [];
     	if(!isNullOrEmpty(jsonFormatFormData.haveDisabilities) && !isNullOrEmpty(jsonFormatFormData.haveDisabilities[0])){
     		Ext.each(jsonFormatFormData.haveDisabilities, function(currentDisability){
             	var haveDisabilities = '';
             	var studentPerson = '';
             	var mainObj = '';
             	var disabilityId = '';
             	try{
             		disabilityId = currentDisability.data.id;
             	}
             	catch(e){
             		disabilityId = currentDisability.id;
             	}
             	if(!isNullOrEmpty(disabilityId)){
            		mainObj = {
            				"haveDisabilities" : {
            					"id" : disabilityId
          				},
         				"studentPerson" : {
          					"id": personProfile.getPersonInfo().id
          				}		
            		}
             		if(portalId==3 && !isNullOrEmpty(personProfile.getPersonInfo().person) && !isNullOrEmpty(personProfile.getPersonInfo().person.id)){
                        mainObj = {
                                "haveDisabilities" : {
                                    "id" : disabilityId
                                },
                                "studentPerson" : {
                                    "id": personProfile.getPersonInfo().person.id
                                }        
                        }
                    }else{
                        mainObj = {
                                "haveDisabilities" : {
                                    "id" : disabilityId
                                },
                                "studentPerson" : {
                                    "id": personProfile.getPersonInfo().id
                                }        
                        }
                    }
             		disabilityJsonArry.push(mainObj);
             	}
             });	
     	}
     	if(!isNullOrEmpty(jsonFormatFormData.currentEducationalInterventions)){
     		Ext.each(jsonFormatFormData.currentEducationalInterventions, function(currentEduInterventions){
             	var educationInterventions = '';
             	var studentPerson = '';
             	var mainObj = '';
             	var EduInterventionsId = '';
             	try{
             		EduInterventionsId = currentEduInterventions.data.id;
             	}
             	catch(e){
             		EduInterventionsId = currentEduInterventions.id;
             	}
             	if(!isNullOrEmpty(EduInterventionsId)){
             		mainObj = {
             				"educationInterventions" : {
             					"id" : EduInterventionsId
             				},
             				"studentPerson" : {
             					"id": personProfile.getPersonInfo().id
             				}		
             		}
             		eduInterventionsJsonArry.push(mainObj);
             	}
             });	
     	}
     	var departmentArray = [];
     	var duplicateIdMap = new Ext.util.HashMap();
     	if (!isNullOrEmpty(formWindow.down('#serviceStopPanelId').items.items)
    			&& formWindow.down('#serviceStopPanelId').items.items.length > 1) {
        	courseDepartmentCombo = this.getIdValueJson(jsonFormatFormData.employeeLanguage[0], jsonFormatFormData.employeeLanguage[0]);
        	

        	for (var i = 0; i < formWindow.down('#serviceStopPanelId').items.items.length; i++) {
        		var newData = {
    					"multiLanguage" : this.getIdValueJson(jsonFormatFormData.employeeLanguage[i],jsonFormatFormData.employeeLanguage[i]),
    					"read" :  this.getIdValueJson(jsonFormatFormData.read[i],jsonFormatFormData.read[i]),
    					"speak" : this.getIdValueJson(jsonFormatFormData.speak[i],jsonFormatFormData.speak[i]),
    					"write" :this.getIdValueJson(jsonFormatFormData.write[i],jsonFormatFormData.write[i]),
    					"person":this.getIdValueJson(jsonFormatFormData.id,jsonFormatFormData.id),
    					"id":jsonFormatFormData.langId[i]
    			};
        		if(!isNullOrEmpty(newData.multiLanguage)){
        			delete newData.multiLanguage.value
        		}
        		if(duplicateIdMap.containsKey(jsonFormatFormData.employeeLanguage[i])){
        			duplicateIdFlag=true;
        			break;
        		}
        		duplicateIdMap.add(jsonFormatFormData.employeeLanguage[i], i);
        		departmentArray.push(newData);
        		}
    		
        }else if(!isNullOrEmpty(formWindow.down('#serviceStopPanelId').items.items)
    			&& formWindow.down('#serviceStopPanelId').items.items.length == 1){
        	courseDepartmentCombo = this.getIdValueJson(jsonFormatFormData.employeeLanguage, jsonFormatFormData.employeeLanguage);

        	var newData = {
        			"multiLanguage" : this.getIdValueJson(jsonFormatFormData.employeeLanguage,jsonFormatFormData.employeeLanguage),
					"read" :  this.getIdValueJson(jsonFormatFormData.read,jsonFormatFormData.read),
					"speak" : this.getIdValueJson(jsonFormatFormData.speak,jsonFormatFormData.speak),
					"write" :this.getIdValueJson(jsonFormatFormData.write,jsonFormatFormData.write),
					"person":this.getIdValueJson(jsonFormatFormData.id,jsonFormatFormData.id),
					"id":jsonFormatFormData.langId,
					
			};
        	if(!isNullOrEmpty(newData.multiLanguage)){
        		delete newData.multiLanguage.value
        	}
        	departmentArray.push(newData);
        }
     	jsonFormatFormData.languageCompetency = departmentArray;
     	
     	delete jsonFormatFormData.langId;
     	delete jsonFormatFormData.read;
     	delete jsonFormatFormData.write;
     	delete jsonFormatFormData.speak; 
     	delete jsonFormatFormData.employeeLanguage;
     	delete jsonFormatFormData.photo_url;
     	
     	delete jsonFormatFormData.hiddenImage;

     	jsonFormatFormData.personDisability = disabilityJsonArry;
     	jsonFormatFormData.personEducationInterventions = eduInterventionsJsonArry;
     	jsonFormatFormData.advisorId = this.getIdValueJson(jsonFormatFormData.advisorId);
        jsonFormatFormData = this$.setStudentJsonfromatData(jsonFormatFormData, photoUrl, isUpdate);
        jsonFormatFormData.printName = jsonFormatFormData.person.printName;
        jsonFormatFormData.admissionID=personProfile.admissionId;
        jsonFormatFormData = Ext.encode(jsonFormatFormData);
    	this.sendSaveAjaxRequest(SERVERURL.STUDENT_PERSONAL_INFORMATION_UPDATE, 'PUT', jsonFormatFormData, function(option, success, response) {
        	if(success){
        		var title;
            	if(portalId==3){
            		title=getPersonModuleTranslation('PERSONAL_DETAILS');
            	}else{
            		title=getPersonModuleTranslation('STUDENT_PERSONAL_DETAILS');
            	}
            	var studentDocUploadForm = personProfile.down('#studentDocUploadForm');
            	var documentFileUpload = studentDocUploadForm.down('#documentFileUpload');
            	var docFileUploadPath = documentFileUpload.getValue();
            	if(!isNullOrEmpty(docFileUploadPath)){
            		this$.saveStudentProfileDocumentUploadForm(studentDocUploadForm, personProfile.getPersonId(), SERVERURL.PATH_UPLOAD_PERSON_DOC, SERVERURL.PATH_DOWNLOAD_PERSON_DOC, function(success,documentUrl,version){
            		if(success){
            			personProfile.down('#studentDownloadURL').setValue(documentUrl);
            		}
            	});
            	}

        		Ext.getBody().unmask();
        		formWindow.down('#personalInfoSaveButtonId').setDisabled(false);
        		showSuccessMessage(title, getPersonModuleTranslation('STUDENT_PERSONAL_SUBMIT_SUCCESS'));
        		this$.setUploadedPhotoToPersonProfile(downloadUrl);
        		this$.onRenderStudentPersonalInformationForm();
                this$.getStudentProfileInformation();
                // for reload search result grid.
                var controller = this$.getController('Academia.controller.personinfo.student.StudentListController');
                if(!isNullOrEmpty(controller.getStudentQuickSearchForm()) && !isNullOrEmpty(controller.getSearchResultGrid())){
                	controller.loadGridAndSearchUsers();
                }
                
                if((portalId==3 || portalId==7) && Ext.isDefined(callBackFn)){
            		callBackFn();
            		Ext.getBody().unmask();
            	}
    		}
        	else{
        		formWindow.down('#personalInfoSaveButtonId').setDisabled(false);
        	}
    	});
    	
    },
    
    setStudentJsonfromatData: function(jsonObj, personInfo) {
        var this$ = this;

        var data = new Object();
        data.id = jsonObj.id;
        data.version = jsonObj.version;
        data.firstName = jsonObj.firstName;
        var studentAttendanceGroup =[];
        if(jsonObj.studentAttendanceGroup !=undefined && jsonObj.studentAttendanceGroup.length > 0){
			for(var i in jsonObj.studentAttendanceGroup){
				var sagId = "";
				if(Ext.isObject(jsonObj.studentAttendanceGroup[0])){
					cvId = jsonObj.studentAttendanceGroup[i].get("id");
				}else{
					cvId = jsonObj.studentAttendanceGroup[i];
				}
				studentAttendanceGroup.push({
					  "id":null,
	  				  "student":this.getIdValueJson(jsonObj.id),
	  				  "attendanceGroup" : this.getIdValueJson(cvId)
	  			  });
			}
		}
        data.studentAttendanceGroup=studentAttendanceGroup;
        try{
        	data.code = this$.getContentPanelActiveTab().down('textfield[itemId=personCodeField]').getValue();
        }
        catch(e){
            data.code = Ext.ComponentQuery.query('textfield[itemId=personCodeField]')[0].getValue();
        }
        data.lastName = jsonObj.lastName;
        data.shortName = jsonObj.shortName;
        data.isMidtermJoinee = jsonObj.isMidtermJoinee;
        if(personInfo != undefined)
        data.calender = personInfo.calender;
        
        data.accountingKey = jsonObj.accountingKey;
        
        var middleName = jsonObj.middleName;
        if (!isNullOrEmpty(middleName)) {
        	data.middleName = middleName;
        }
        
        var category = jsonObj.category;
        if (isNullOrEmpty(category)) {
        	jsonObj.category = null;
        }
        
        var maritalStatus = jsonObj.maritalStatus;
        if (isNullOrEmpty(maritalStatus)) {
            jsonObj.maritalStatus = null;
        }
        var bloodGroup = jsonObj.bloodGroup;
        if (isNullOrEmpty(bloodGroup)) {
            jsonObj.bloodGroup = null;
        }
        var religion = jsonObj.religion;
        if (isEmpty(religion) || isNullOrEmpty(religion.id)) {
            jsonObj.religion = null;
        }
        var domicile = jsonObj.domicile;
        if (isEmpty(domicile) || isNullOrEmpty(domicile.id)) {
            jsonObj.domicile = null;
        }
        var castCategory = jsonObj.castCategory;
        if (isEmpty(castCategory) || isNullOrEmpty(castCategory.id)) {
            jsonObj.castCategory = null;
        }
        var salutation = jsonObj.salutation;
        if (isEmpty(salutation) || isNullOrEmpty(salutation.id)) {
            jsonObj.salutation = null;
        }
        var bankDetail = new Object();
        this$.setJsonfield(jsonObj, bankDetail, "id", "bankDetailsId");
        this$.setJsonfield(jsonObj, bankDetail, "version", "bankDetailsVersion");
        this$.setJsonfield(jsonObj, bankDetail, "bankName", "bankName");
        this$.setJsonfield(jsonObj, bankDetail, "accountNumber", "accountNumber");
        this$.setJsonfield(jsonObj, bankDetail, "branchName", "branchName");
        this$.setJsonfield(jsonObj, bankDetail, "ifsCode", "ifsCode");
        this$.setJsonfield(jsonObj, bankDetail, "beneficiaryName", "beneficiaryName");
        this$.setJsonfield(jsonObj, bankDetail, "beneficiaryNameOtherLanguage", "beneficiaryNameOtherLanguage");
        this$.setJsonfield(jsonObj, bankDetail, "accountTypeId", "accountTypeId");
        /*bankDetail.person = {
                id: jsonObj.personId
    	};*/
        
        jsonObj["bankDetail"] = bankDetail;
        
        
        var wsApplPhyChars = new Object();
        this$.setJsonfield(jsonObj, wsApplPhyChars, "id", "phyId");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "version", "phyVersion");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "height", "height");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "weight", "weight");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "hairColor", "hairColor");
        this$.setJsonfield(jsonObj, wsApplPhyChars, "eyeColor", "eyeColor");                
        if(isNullOrEmpty(wsApplPhyChars.id) && isNullOrEmpty(wsApplPhyChars.version) && isNullOrEmpty(wsApplPhyChars.height) 
        		&& isNullOrEmpty(wsApplPhyChars.weight) && isNullOrEmpty(wsApplPhyChars.hairColor) && isNullOrEmpty(wsApplPhyChars.eyeColor)){
        	jsonObj["physicalCharacteristics"] = null;
        }else{
        	jsonObj["physicalCharacteristics"] = wsApplPhyChars;
        }
        
        jsonObj.id = jsonObj.personId;
        jsonObj.version = jsonObj.personVersion;
        
        delete jsonObj.code;
        delete jsonObj.personId;
        delete jsonObj.personVersion;
        delete jsonObj.isMidtermJoinee;
        delete jsonObj.isEmployeeOfOrganization;
      //TODO: Remove this custom data part deletion once customdata is applied to student
      //  delete jsonObj.customData;
        delete jsonObj.accountingKey;
        delete jsonObj.studentAttendanceGroup;
        delete jsonObj.haveDisabilities;
        delete jsonObj.currentEducationalInterventions;
        data.person = jsonObj;
        return data;
    },
    
    /*
     *  save the address details
     */
    saveStudentAddressDetails: function(btn) {
    	if(!preventMultipleCalls(btn)){
    		return false;
    	}
        var this$ = this;
        var studentProfile = this$.getContentPanelActiveTab();
        var personInfo = studentProfile.getPersonInfo();
        var addRefWin=this.getPersonAddressFormWindow();
        var saveBtn = addRefWin.down('#submitButtonId');
        saveBtn.setDisabled(true);
        var formAddressData = addRefWin.getFormAddressData();
        var addressCombo = studentProfile.down('#addressCombo');
        var type = addressCombo.getValue();
        var form = this.getPersonAddressFieldsForm().getForm();
        if (form.isValid()) {

            var values = form.getValues();
            	var addressDetails = studentProfile.down('#studentAddressDetails');
                var personId = addressDetails.getAddressPersonId();
                if(!isNullOrEmpty(personId)){
                	var person = {
                    		id : personId
                    };
                	var address = new Academia.model.organization.Address();
                	var submitUrl;
                    var successMessage;
                    var id = form.findField('id').getSubmitValue();
                    form.updateRecord(address);
                    var jsonObj = new Object();
                    address.set('country', this$.mixins.AddressController.getIdValueJson(values.country));
                    address.set('parentCountryRegion', this$.mixins.AddressController.getIdValueJson(values.parentCountryRegion));
                    address.set('countryRegion', this$.mixins.AddressController.getIdValueJson(values.countryRegion));
                    address.set('city',this$.mixins.AddressController.getIdValueJson(values.city));
                    address.set('addressType', this$.mixins.AddressController.getIdValueJson(values.addressType));
                    address.set('pincodeNew', this$.mixins.AddressController.getIdValueJson(values.pincodeNew));
                    
                    if(!isNullOrEmpty(values.parentCountryRegionIdText)){
                    	address.set('parentCountryRegionIdText', values.parentCountryRegionIdText);
                        address.set('countryIdText', values.countryIdText);
                        address.set('cityIdText', values.cityIdText);
                        delete address.data.country;
                        delete address.data.countryRegion;
                        delete address.data.city;
                    }
                    if(form.findField('pincodeNew').isHidden()){
                    	delete address.data.pincodeNew;
                    }else if(form.findField('pincode').isHidden()){
                    	address.data.pincode = '';
                    }
                    jsonObj.address = address.data;

                    jsonObj.id = formAddressData["id"];
                    jsonObj.version = formAddressData["version"];
                    jsonObj.person = person;
                    jsonObj.isDeleted = personInfo["isDeleted"];
                    jsonObj.addressType = this$.mixins.AddressController.getIdValueJson(values.addressType);
                    jsonObj.isPrimary = values.isPrimary;
                    jsonObj.type = type;
                    jsonObj.address.customData = values.customData;

                    var formData = Ext.encode(jsonObj);
                    if (isNullOrEmpty(id)) {
                        submitUrl = SERVERURL.PERSON_ADDRESS_ADD;
                        successMessage = getCommonTranslation('ADDRESS_ADD_SUCCESS');
                    } else {
                        submitUrl = SERVERURL.PERSON_ADDRESS_UPDATE;
                        successMessage = getCommonTranslation('ADDRESS_UPDATE_SUCCESS');
                    }
                    
                    var otherAddressTypeIds=[];
                    var otherAddressVals = form.findField('otherAddressTypeId').getValue();
    				if(otherAddressVals != undefined && otherAddressVals.length > 0){
    					if(!isNaN(otherAddressVals[0])){
    						if(otherAddressVals[0] !=""){
    							otherAddressTypeIds.push(otherAddressVals[0].data.id);	
    						}
    					}
    					else{
    						for(var i in otherAddressVals){
    							otherAddressTypeIds.push(otherAddressVals[i].data.id);
    						}
    					}
    				}
    				
                    submitUrl = submitUrl+'?otherAddressTypes='+otherAddressTypeIds.join();
                    this$.applyWindowMask();
                    
                    //Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
                    
                    Ext.Ajax.request({
                        type: 'rest',
                        url: SERVERURL.PERSON_IS_ADDRESS_EXIST + '?personId=' +personId +'&otherAddressTypes='+ otherAddressTypeIds.join() ,
                        method: 'GET',
                        success: function(form, action) {
                        	var response = Ext.decode(form.responseText);
                        	if(response.length>0){
                        		this$.hideWindowMask();
                        		var message = getCommonTranslation('COPY_ADDRESS_CNFRM_MSG');
                        		showConfirmMessage(getCommonTranslation('WARNING'),message, function(btn, text) {
        	                        if (btn == 'yes') {
        	                        	this$.applyWindowMask();
        	                        	Ext.Ajax.request({
        	                                type: 'rest',
        	                                url: submitUrl,
        	                                jsonData: formData,
        	                                method: 'POST',
        	                                success: function(form, action) {
        	                                	this$.hideWindowMask();
        	                                	this$.getPersonAddressFormWindow().close();
        	                                    showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
        	                                    //this$.getFacultyAddressDetailTemplateData();
        	                                    this$.onSelectionPersonAddressTypeCombo('#studentAddressDetails', SERVERURL.PERSON_FIND_RELATED_PERSON_ID, SERVERURL.PERSON_GET_PERSON_ADDRESS_DETAILS);
        	                                }
        	                            });
        	                        	
        	                        } else {
        	                        	saveBtn.setDisabled(false);
        	                        }
                        		});
                        		
                        	} else {
	                    		Ext.Ajax.request({
	                                type: 'rest',
	                                url: submitUrl,
	                                jsonData: formData,
	                                method: 'POST',
	                                success: function(form, action) {
	                                	this$.hideWindowMask();
	                                	this$.getPersonAddressFormWindow().close();
	                                    showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
	                                    //this$.getFacultyAddressDetailTemplateData();
	                                    this$.onSelectionPersonAddressTypeCombo('#studentAddressDetails', SERVERURL.PERSON_FIND_RELATED_PERSON_ID, SERVERURL.PERSON_GET_PERSON_ADDRESS_DETAILS);
	                                }
	                            });
	                    	}
                        }
                    });
                    
                    /*Ext.Ajax.request({
                        type: 'rest',
                        url: submitUrl,
                        jsonData: formData,
                        method: 'POST',
                        success: function(form, action) {
                        	Ext.getBody().unmask();
                            showSuccessMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), successMessage);
                            this$.getPersonAddressFormWindow().close();
                            this$.onSelectionPersonAddressTypeCombo('#studentAddressDetails', SERVERURL.PERSON_FIND_RELATED_PERSON_ID, SERVERURL.PERSON_GET_PERSON_ADDRESS_DETAILS);
                        }
                    });*/
                }else{
                	showWarningMessage(getCommonTranslation('ADDRESS_MSG_BOX_TITLE'), getPersonModuleTranslation('RELATED_PERSON_NOT_PRESENT'));
                }
        }
    },
    setPrintNameValue:function(textfield){
    	var form = textfield.up('form');
    	var getForm=form.getForm();
    	var firstName = getForm.findField('firstName').getValue();
    	var middleName = getForm.findField('middleName').getValue();
    	var lastName = getForm.findField('lastName').getValue();
    	
    	var printName=null;
    	if(isNullOrEmpty(middleName)){
    		if(!isNullOrEmpty(lastName)){
    			printName =firstName+" "+lastName;
    		}else{
    			printName =firstName;
    		}
    	}else{
    		if(!isNullOrEmpty(lastName)){
    			printName =firstName+" "+middleName+" "+lastName ;
    		}else{
    			printName =firstName+" "+middleName ;
    		}
    	}
    	printName=printName.trim();
    	
    	
    	Ext.Ajax.request({
    		type: 'rest',
    		async: false,
    		url: SERVERURL.FILE_PRIORITY,
    		params: {
    			type:'ShortName'
    		},
    		method: 'GET',
    		success: function(res, action) {
    			var response = Ext.decode(res.responseText);
    			if(response.length == 0){
    				var task = new Ext.util.DelayedTask(function(){
    		    		getForm.findField('printName').setValue(printName.replace(/ +/g, " "));
    		    		getForm.findField('shortName').setValue(firstName.replace(/ +/g, " "));
    		    	});
    		    	task.delay(50);
    			}else{
    				var task = new Ext.util.DelayedTask(function(){
    		    		getForm.findField('printName').setValue(printName.replace(/ +/g, " "));
    		    	});
    		    	task.delay(50);
    			}
    		}
    	});
    },
    
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
		var this$ = this;
    	var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	
    	var saveBtn = gridReference.down('#personalInfoSaveButtonId');
    	saveBtn.setVisible(false);
    	
    	var verifyDetailsBtn = gridReference.down('#verifyDetail');
    	verifyDetailsBtn.setVisible(false);
    	
    	var validateIDBtn = gridReference.down('#validateID');
    	validateIDBtn.setVisible(false);
    	
    	var snapShotBtn = gridReference.down('button#photoFileImage');
    	snapShotBtn.setVisible(false);
    	
    	var photoUploadBtn = gridReference.down('#studentPhotoUploadForm');
    	photoUploadBtn.setVisible(false);
    	
    	var profilePhotoRemoveBtn = gridReference.down('button#profilePhotoRemove');
    	profilePhotoRemoveBtn.setVisible(false);

		var hasSaveButtonPrivilege = false;
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'SAVEBUTTON') {
    			if(!isNullOrEmpty(saveBtn)){
					hasSaveButtonPrivilege = true;
    				saveBtn.setVisible(true);
    			}        		
    		}
    		if (privilege === 'VALIDATE_ID_BUTTON') {
    			if(!isNullOrEmpty(validateIDBtn)){
    				validateIDBtn.setVisible(true);
    			}        		
    		}
    		if (privilege === 'VERIFY_DETAILS_BUTTON') {
    			if(!isNullOrEmpty(verifyDetailsBtn)){
    				//V2D-149774
    				//verifyDetailsBtn.setVisible(true);
    			}        		
    		}
    		/*if (privilege === 'SNAPSHOT') {
    			if(!isNullOrEmpty(snapShotBtn)){
    				snapShotBtn.setVisible(true);
    			}        		
    		}
    		if (privilege === 'PHOTO_UPLOAD') {
    			if(!isNullOrEmpty(photoUploadBtn)){
    				photoUploadBtn.setVisible(true);
    			}        		
    		}
    		if (privilege === 'REMOVEBUTTON') {
    			if(!isNullOrEmpty(profilePhotoRemoveBtn)){
    				profilePhotoRemoveBtn.setVisible(true);
    			}        		
    		}*/
    	});
				if (!hasSaveButtonPrivilege) {
		           if (gridReference && gridReference.getForm) {
						setTimeout(function(){
		              		toggleReadOnlyFormItems(gridReference.getForm(), true);
							Ext.ComponentQuery.query('#studentPersonalInformationForm')[0].isReadOnlyForm = true;
						},2000);
		           }
		       }
    },
    
    disableOtherInformaionFormPivileges: function(formReference,permissionsMap) {
    	var associatedAcadLocationIds = new Array();
    	//associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		associatedAcadLocationIds.push(Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue());
    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
    	
    	var saveBtn = formReference.down('#submitButtonId');
    	saveBtn.setVisible(false);
    	
    	Ext.each(permissionList, function(privilege) {
    		if (privilege === 'SAVE') {
    			if(!isNullOrEmpty(saveBtn)){
    				saveBtn.setVisible(true);
    			}        		
    		}
    		
    	});
    },
    /**
     * user create for parent portal
     */
    createParentLogin : function(){
    	var $this = this;
    	try{
        	var grid = $this.getParentGuardianGrid();
    	}
    	catch(e){
    		var grid = $this.getContentPanel().getActiveTab().down('parentguardiangrid');
    	}
    	var store = grid.getStore();
    	if (grid.getSelectionModel().getCount() > 0) {
    		var records = grid.getSelectionModel().getSelection()[0];
    		var submitData = {"person":{"id":records.get('relatedPerson').id}};
    		Ext.Ajax.request({type: 'rest',url:SERVERURL.CREATE_PARENT_LOGIN,jsonData : submitData,method : 'POST',success: function(res, action){
    			var mssg = res.responseText;
    			if(mssg==='PARENT_CREATED_SUCESSFULLY'){
    				showSuccessMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'),getPersonModuleTranslation('LOGIN_CREATED_SUCCES'));
    				store.reload();
    				grid.getSelectionModel().deselectAll();
    			}
    		}});
    	}else{
    		showWarningMessage(getPersonModuleTranslation('PARENT_GUARDIAN_DETAILS'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record
    	}
    },
    
  //******************Disable reset password button**********************************
    permissioncreateLoginPivileges: function(gridReference,permissionsMap) {
    	var me=this;
    	setTimeout(function(){
        	var associatedAcadLocationIds = new Array();
        	associatedAcadLocationIds.push(me.getCurrentAcademyLocation());
    		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
        	buttonsToolBar = gridReference.query('toolbar')[0];
        	var createLoginButton = gridReference.down('#btnCreateLogin');
        	var btnResetPswd = gridReference.down('#btnResetPswd');
        	var pfdButton = gridReference.down('#btnExportToPDFJasper');
        	var excelButton = gridReference.down('#btnExportToExcelJasper');
        	
        	createLoginButton.setVisible(false);
        	btnResetPswd.setVisible(false);
        	pfdButton.setVisible(false);
        	excelButton.setVisible(false);
        	Ext.each(permissionList, function(privilege) {
        		if (privilege === 'CREATELOGIN') {
            		if(!isNullOrEmpty(createLoginButton)){
            			createLoginButton.setVisible(true);
            		}        		
            	}
        		if (privilege === 'RESETPASSWORD') {
            		if(!isNullOrEmpty(btnResetPswd)){
            			btnResetPswd.setVisible(true);
            		}        		
            	}
        		if (privilege === 'EXPORT') {
            		if(!isNullOrEmpty(pfdButton)){
            			pfdButton.setVisible(true);
            	    	excelButton.setVisible(true);
            		}        		
            	}
        		
        	});
    	},100);
    },
    
    /**
     * Open passwordRest window for admin 
     */
    openResetPasswordWindow:function(){
        var resetPswrdWindowItemId ="parentAdminResetPasswordWindow";
        var resetPswrdFormWindow = Ext.widget('adminresetpasswordwindow', {
             itemId: resetPswrdWindowItemId
         });
        resetPswrdFormWindow.show();
 	    
    },

    changePasswordByAdmin:function(button){
    	var $this = this;
    	var grid = $this.getContentPanel().getActiveTab().down('parentguardiangrid');
    	var gridRec=grid.getSelectionModel().getSelection()[0];
    	var window=button.up('window');
    	if(!Ext.isDefined(gridRec)){
    		var gridRec=grid.getStore().getAt(window.storeDataIndex);
    	}
    	var form=button.up('form').getForm();
    	var formValues=form.getValues();
    	var data={
    			"userId":gridRec.data.userId,
    			"newPassword":$this.encryptPassword(formValues.confirmedPassword),
    			 "isResetPassword":true
    	};
    	var pswrdurl = SERVERURL.CHANGE_PASSWORD_BY_ADMIN;
    	showConfirmMessage(getCommonTranslation('ALERT'),getCommonTranslation('DO_YOU_WANT_TO_CONFIRM_CHANGE_PASSWORD_MSG'),
    			function(btn, text) {
    		if (btn == 'yes'){
    			$this.applyWindowMask(); 
    			Ext.Ajax.request({
    				method: "POST",
    				type: 'rest',
    				url:pswrdurl,
    				jsonData:data,
    				success: function(response) {
    					$this.hideWindowMask();
    					var mssg = response.responseText;
    					if (mssg == "SUCCESS") {
    						window.close();
    						showSuccessMessage(getCommonTranslation('RESET_PASSWORD'),getCommonTranslation('ADMIN_PASSWORD_CHANGE_MSG'));
    						grid.getSelectionModel().deselectAll();
    					}else if(mssg == "USER_LOCKED"){
    						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_LOCKED_MSG'));
    					}else if(mssg.includes("PASSWORD_IN_USE")){
    						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PASSWORD_IN_USE'));
    					}else{
    						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('USER_NOT_FOUND_MSG'));
    					}
    				}
    			});
    		}
    	});
    },    
    	getAllPermissions: function(gridReference,permissionsMap) {
	    	var associatedAcadLocationIds = new Array();
	    	associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
	    	
	    	$this$ = Academia.app.getController('Academia.controller.personinfo.student.StudentPastHistoryController');
	    	$this$$ = Academia.app.getController('Academia.controller.personinfo.student.StudentPaymentRefundController');
	    	$this$$$ = Academia.app.getController('Academia.controller.personinfo.student.StudentCourseExecutionController');
	    	DocumentController = Academia.app.getController('Academia.controller.personinfo.student.StudentDocumentController');
	    	ServiceController = Academia.app.getController('Academia.controller.personinfo.student.StudentServiceController');
	    	DisciplinaryController = Academia.app.getController('Academia.controller.personinfo.student.StudentDisciplinaryController');
	    	studentCourseExcController = Academia.app.getController('Academia.controller.personinfo.student.StudentCourseExecutionController');
	    	$this$$$$ = Academia.app.getController('Academia.controller.personinfo.student.StudentServiceController');
	    	
//	    	var returnJson =[];
	    	var returnJson = new Ext.util.HashMap();
	    	
	    	var viewPermission = this.getSTUDENT_IDENTITY_DETAILS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewPermission);
	    	Ext.each(permissionList, function(privilege) {
	    		
	    		
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isIdentity", true);
	    			/*returnJson.push({
	    				"isIdentity":true
	    			});*/ 
	    			return;
	    		}
	    	});
	    	var viewParentAndGuardianDetails = this.getSTUDENT_PARENTS_GUARDIANS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewParentAndGuardianDetails);
	    	Ext.each(permissionList, function(privilege) {
	    		
	    		
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isParentAndGuardian", true);
	    		}
	    	});
	    	var viewSiblingsDetails = this.getSTUDENT_SIBLINGS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewSiblingsDetails);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isSiblings", true);
	    		}
	    	});
	    	var viewPersonalDetails = this.getSTUDENT_PERSONAL_DETAILS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewPersonalDetails);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isPersonalDetails", true);
	    		}
	    	});
	    	
	    	var viewOtherInformation = this.getSTUDENT_OTHER_INFORMATION_DETAILS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewOtherInformation);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isStudentOtherInformation", true);
	    		}
	    	});
	    	
	    	var viewAddressDetails = this.getSTUDENT_ADDRESS_DETAILS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewAddressDetails);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isAddress", true);
	    		}
	    	});
	    	var viewEducationDetails = $this$.getSTUDENT_EDUCATION_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewEducationDetails);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isEducation", true);
	    		}
	    	});
	      	var viewWorkExperienceDetails = $this$.getSTUDENT_WORK_EXPERIENCE_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewWorkExperienceDetails);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isWorkExp", true);
	    		}
	    	});
	    	var viewMedicalDetails = $this$.getSTUDENT_MEDICAL_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewMedicalDetails);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isMedical", true);
	    		}
	    	});
	    	var viewVaccinationDetails = $this$.getSTUDENT_VACCINATION_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewVaccinationDetails);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isVaccination", true);
	    		}
	    	});
	     	var viewExtraCurricularActivity = $this$.getSTUDENT_EXTRA_CURRICULAR_ACTIVITY_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewExtraCurricularActivity);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isExtraCurricular", true);
	    		}
	    	});
	    	var viewResearchDetails = $this$.getSTUDENT_RESEARCH_DETAILS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewResearchDetails);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isResearch", true);
	    		}
	    	});
	    	var viewSeminarDetails = $this$.getSTUDENT_SEMINAR_DETAILS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewSeminarDetails);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isSeminar", true);
	    		}
	    	});
	    	var viewTrainingDetails = $this$.getSTUDENT_TRAINING_DETAILS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewTrainingDetails);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isTraining", true);
	    		}
	    	});
	    	var viewPatentDetails = $this$.getSTUDENT_PATENT_DETAILS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewPatentDetails);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isPatent", true);
	    		}
	    	});
	    	var viewCompetitiveDetails = $this$.getSTUDENT_COMPETITIVE_EXAM_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewCompetitiveDetails);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isCompetitive", true);
	    		}
	    	});
	    	var viewPhysicalCharacteristics = $this$.getSTUDENT_PHYSICAL_CHARACTERISTICS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewPhysicalCharacteristics);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isPhysicalChar", true);
	    		}
	    	});
	    	var viewHostalPermissions = $this$.getSTUDENT_HOSTEL_DETAILS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewHostalPermissions);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isHostal", true);
	    		}
	    	});
	    	var viewScholorshipPermissions = $this$$.getSTUDENT_SCHOLARSHIP_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewScholorshipPermissions);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isScholarShip", true);
	    		}
	    	});
	    	var viewBillingPermission = $this$$.getSTUDENT_PENDING_BILLS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewBillingPermission);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isBilling", true);
	    		}
	    	});

	    	var viewReceipt = $this$$.getSTUDENT_PAYMENT_RECIEVED_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewReceipt);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW') {
	    			returnJson.add("isReceipt", true);
	    		}
	    	});
	    	
	    	var viewStudentPNCs = $this$$$.getCOURSE_MASTER_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewStudentPNCs);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW'){
	    			returnJson.add("isPNC", true);
	    		}
	    		
	    	});

	    	var viewRefund = $this$$.getSTUDENT_REFUNDS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewRefund);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW'){
	    			returnJson.add("isRefund", true);
	    		}
	    		
	    	});
	    	
	    	var viewDocuments = DocumentController.getSTUDENT_DOCUMENTS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewDocuments);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW'){
	    			returnJson.add("idDocument", true);
	    		}
	    		
	    	});
	    	
	    	var viewServiceOptInOptOut = ServiceController.getSTUDENT_SERVICE_OPT_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewServiceOptInOptOut);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW'){
	    			returnJson.add("isService", true);
	    		}
	    		
	    	});
	    	
	    	var viewDisciplinaryAction = DisciplinaryController.getSTUDENT_DISCIPLINARY_ACTIONS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewDisciplinaryAction);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW'){
	    			returnJson.add("isDisciplinaryAction", true);
	    		}
	    		
	    	});
	    	
	    	var viewPositiveActivity = DisciplinaryController.getSTUDENT_POSITIVE_INCIDENTS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewPositiveActivity);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW'){
	    			returnJson.add("isPositiveIncident", true);
	    		}
	    		
	    	});
	    	
	    	var viewNegativeActivity = DisciplinaryController.getSTUDENT_NEGATIVE_INCIDENTS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewNegativeActivity);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW'){
	    			returnJson.add("isNegativeIncident", true);
	    		}
	    		
	    	});
	    	
	    	var viewAcademicHistory = studentCourseExcController.getSTUDENT_VIEW_ACADEMIC_HISTORY_PERMISSION();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewAcademicHistory);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW'){
	    			returnJson.add("isAcademicHistory", true);
	    		}
	    		
	    	});
	    	
	    	var viewAcademicTopic = studentCourseExcController.getSTUDENT_ACADEMICS_TOPIC_PERMISSION();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewAcademicTopic);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW'){
	    			returnJson.add("isStudentAcademicTopics", true);
	    		}
	    		
	    	});
	    	
	    	var viewFeePayerDetail=this.getSTUDENT_FEE_PAYER_DETAILS_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewFeePayerDetail);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW'){
	    			returnJson.add("isFeePayerDetail", true);
	    		}
	    	});
	    	
	    	var viewCommunityOptIn=$this$$$$.getSTUDENT_COMMUNITIES_OPT_PERMISSIONS();
	    	var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, viewCommunityOptIn);
	    	Ext.each(permissionList, function(privilege) {
	    		if (privilege === 'VIEW'){
	    			returnJson.add("isCommunityOptIn", true);
	    		}
	    	});
	    	
    	return returnJson;
    },
    doAccessControlValidationOfStudentHolds: function(grid, privilegesMap, type) {
		var associatedAcadLocationIds = new Array();
		associatedAcadLocationIds.push(this.getCurrentAcademyLocation());
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, privilegesMap);

		if( type == 'HOLDS' ){
			var removeHold =  grid.down('#removeHold').setVisible(false);
			var applyHold =  grid.down('#applyHold').setVisible(false);
			var deleteHold =  grid.down('#deleteHold').setVisible(false);
		}
	   applyHold.setVisible(false);
		removeHold.setVisible(false);
		deleteHold.setVisible(false);
		var portalId = this.getCurrentLoggedPortalId();
		Ext.each(permissionList, function(privilege) {
			if(portalId == 1){
				if(privilege == 'APPLY_HOLD'){
					applyHold.setVisible(true);
				}
				if(privilege == 'REMOVE_HOLD'){
					removeHold.setVisible(true);
				}
				if(privilege == 'DELETE_HOLD'){
					deleteHold.setVisible(true);
				}
			
			}

		});
	},
    getRenderStudentConditionDocumentList : function(){
       	var $this = this;
       	var functionArguments = arguments;
       	var studentProfile = $this.getContentPanelActiveTab();
    	var studentConditionsForm = studentProfile.down('#studentconditionsforadmissionFormId');
    	var grid = studentConditionsForm.down('studentconditionsdocumentlist');
           var studentProfile = $this.getContentPanelActiveTab();
           if (studentProfile && portalId !=3) {
        	   if(!isNullOrEmpty(studentProfile.userId)){
        		   var url = SERVERURL.FIND_CONDITION_BY_STUDENT_ID;
        		   Ext.Ajax.request({
        			   type: 'rest',
        			   url: url+'?studentId='+studentProfile.userId,
        			   method: 'GET',
        			   success: function(form, action) {
        				   if(!isNullOrEmpty(form.responseText))
        				   {
        					   responseResult = Ext.decode(form.responseText);
        					   //if(typeof functionArguments[0]!="string"){
        					   studentConditionsForm.down('#conditionApplicableId').setValue(responseResult.condition);
        					   studentConditionsForm.down('#Id').setValue(responseResult.id);
        					   grid.getStore().removeAll();
        					   grid.getStore().add(responseResult.requiredDocuments);
        					   //}
        					   /*else if(functionArguments[0]=="onlyGrid"){
        					   grid.getStore().removeAll();
        					   grid.getStore().add(responseResult.requiredDocuments);
        				   }*/
        				   }
        			   }
        		   });
				   grid.down('button[itemId=btnUploadDocument]').hide();
				   grid.up('form').down('button[itemId=btnSave]').hide();
				   studentConditionsForm.down('#conditionApplicableId').setReadOnly(true);

        	   }
           }             
       },
       getRenderStudentPortalConditionDocumentList : function(){
    	   var $this = this;
    	   var functionArguments = arguments;
    	   var studentProfile = $this.getContentPanelActiveTab();
    	   var studentConditionsForm = studentProfile.down('#studentconditionsforadmissionFormId');
    	   var grid = studentConditionsForm.down('studentconditionsdocumentlist');
    	   if (studentProfile) {
    		   if(!isNullOrEmpty(studentProfile.userId)){
    			   var url = SERVERURL.FIND_CONDITION_BY_STUDENT_ID;
    			   Ext.Ajax.request({
    				   type: 'rest',
    				   url: url+'?studentId='+studentProfile.userId,
    				   method: 'GET',
    				   success: function(form, action) {
    					   if(!isNullOrEmpty(form.responseText))
    					   {
    						   var responseResult = Ext.decode(form.responseText);
    						   
    						   studentConditionsForm.down('#conditionApplicableId').setValue(responseResult.condition);
    						  
    						   studentConditionsForm.down('#Id').setValue(responseResult.id);
    						   var grid = Ext.ComponentQuery.query('studentconditionsdocumentlist')[0];
    						   grid.getStore().removeAll();
    						   grid.getStore().add(responseResult.requiredDocuments);
    					   }
    					   studentConditionsForm.down('#conditionApplicableId').setReadOnly(true);
    				   }
    			   });				   
    			   var grid = Ext.ComponentQuery.query('studentconditionsdocumentlist')[0];
				   grid.down('button[itemId=btnUploadDocument]').hide();
				   grid.up('form').down('button[itemId=btnSave]').hide();
				   
    		   }
    	   }             
       },
       
       
       setDefaultCountryCodeStudent:function(){
    	   var formWindow = this.getPersonCommonWindow();
    	   var form = formWindow.down('feepayerdetailform');
    	   Ext.Ajax.request({
    		   type: 'rest',
    		   url: SERVERURL.DEFAULT_COUNTRY_CODE_BY_ACADEMY_LOCATION,
    		   method: 'GET',
    		   success: function(response, action) {
    			   var MSSG = response.responseText;
    			   var jdata = Ext.decode(response.responseText);
    			   var defaultCountryId = -1;
    			   if(!isNullOrEmpty(jdata.id)){
    				   defaultCountryId = jdata.id; 
    			   }
    			   var homeTelephoneCountryCode=form.down('#homeTelephoneCountryCodeItemId');
    			   if(isNullOrEmpty(homeTelephoneCountryCode.getValue())){
    				   homeTelephoneCountryCode.getStore().load({
    					   callback: function(records, operation, success) {
    						   if (success) {
    							   for(i in records){
    								   if(defaultCountryId == -1){
    									   if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
    										   homeTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
    									   } 
    								   }else{
    									   if(records[i].data.id == defaultCountryId){
    										   homeTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
    									   }
    								   }
    							   }
    						   }
    					   }
    				   });
    			   }

    			   var workTelephoneCountryCode=form.down('#workTelephoneCountryCodeItemId');
    			   if(isNullOrEmpty(workTelephoneCountryCode.getValue())){
    				   workTelephoneCountryCode.getStore().load({
    					   callback: function(records, operation, success) {
    						   if (success) {
    							   for(i in records){
    								   if(defaultCountryId == -1){
    									   if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
    										   workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
    									   } 
    								   }else{
    									   if(records[i].data.id == defaultCountryId){
    										   workTelephoneCountryCode.setValue(records[i].data.isdCode);  									  
    									   }
    								   }
    							   }
    						   }
    					   }
    				   });
    			   }

    			   var countryCode=form.down('#countryCodeItemId');
    			   if(isNullOrEmpty(countryCode.getValue())){
    				   countryCode.getStore().load({
    					   callback: function(records, operation, success) {
    						   if (success) {
    							   for(i in records){
    								   if(defaultCountryId == -1){
    									   if(records[i].data.whetherDefault || records[i].data.whetherDefault=='true'){
    										   countryCode.setValue(records[i].data.isdCode);  									  
    									   } 
    								   }else{
    									   if(records[i].data.id == defaultCountryId){
    										   countryCode.setValue(records[i].data.isdCode);  									  
    									   }
    								   }
    							   }
    						   }
    					   }
    				   });
    			   }
    		   }
    	   });
       },    
       getStudentAddressPrivilege : function() {
    	   var addressDetails = this.getPersonAddressDetails();
    	   if(portalId == 7){
    		   var permissionList = this.getPARENT_PORTAL_STUDENT_ADDRESS_DETAILS_PERMISSIONS();
    		   this.disableStudentDisplyAddressPrivilege(addressDetails, permissionList);
    	   }else if(portalId == 3){
    		   var permissionList = this.getSTUDENT_PORTAL_STUDENT_ADDRESS_DETAILS_PERMISSIONS();
    		   //this.disableStudentDisplyAddressPrivilege(addressDetails, permissionList);
    	   }else if(portalId == 2){
    		   var permissionList = this.getFACULTY_PORTAL_STUDENT_ADDRESS_DETAILS_PERMISSIONS();
    		   this.disableStudentDisplyAddressPrivilege(addressDetails, permissionList);
    	   }else if(portalId == 1){
    		   var permissionList = this.getSTUDENT_ADDRESS_DETAILS_PERMISSIONS();
    		   this.disableStudentDisplyAddressPrivilege(addressDetails, permissionList);
    	   }
    	   
    	   if(portalId != 3){
    		   this.getProfileAddressPrivileges(addressDetails, permissionList);
    	   }
       },
       loadRelationData: function(component){
    	   if(Ext.app.checkVelocity || Ext.app.checkVelocity == "true"){
    		   if(isNullOrEmpty(component)){
    			   var relationship = Ext.getStore('common.RelationshipStore');
    		   }
    		   else {
        		   var relationship=component.getStore();
    		   }
    		   var comboData = [{
    			   name: 'BROTHER',
    			   value: getPersonModuleTranslation('BROTHER'),
    			   displayValue: getPersonModuleTranslation('BROTHER')
    		   }, {
    			   name: 'SISTER',
    			   value: getPersonModuleTranslation('SISTER'),
    			   displayValue: getPersonModuleTranslation('SISTER')
    		   }, {
    			   name: 'FATHER',
    			   value: getPersonModuleTranslation('PARENT_GUARDIAN1'),
    			   displayValue: getPersonModuleTranslation('PARENT_GUARDIAN1')
    		   }, {
    			   name: 'MOTHER',
    			   value: getPersonModuleTranslation('PARENT_GUARDIAN2'),
    			   displayValue: getPersonModuleTranslation('PARENT_GUARDIAN2')
    		   }, {
    			   name: 'GUARDIAN',
    			   value: getPersonModuleTranslation('PARENT_GUARDIAN3'),
    			   displayValue: getPersonModuleTranslation('PARENT_GUARDIAN3')
    		   }];

    		   relationship.loadData(comboData);

    		   relationship.on('load', function(){
    			   for(var i=0; i< relationship.data.items.length;i++){
    				   if(relationship.data.items[i].data.name == 'LOCAL_GUARDIAN'){
    					   relationship.removeAt(i);
    				   } 
    			   }
    		   });
    	  }
       },
       getApplyToSiblingDetail:function(form,data){
    	   var applyUpdateToSiblings = form.down('#applyUpdateToSiblings');
    	   //applyUpdateToSiblings.setVisible(true);
    	   
    	   var relationShipCombo = form.down('#relationShipField');
    	   if( relationShipCombo != undefined ){
    		   relationShipCombo.setReadOnly(true);
    	   }
    	   
    	   if(this.getCurrentLoggedPortalId() == 7)
	   		{
				//parent portal
    		   if( applyUpdateToSiblings.isVisible() ){
	   				applyUpdateToSiblings.setVisible(true);
	   			}
	   		}else if(this.getCurrentLoggedPortalId() == 2){
	   			//faculty portal
	   			if( applyUpdateToSiblings.isVisible() ){
	   				applyUpdateToSiblings.setVisible(true);
	   			}
	   		}else if(this.getCurrentLoggedPortalId() == 3){
	   			//student portal
	   			applyUpdateToSiblings.setVisible(false);
	   		}else{
	   			//core ERP portal
	   			if( applyUpdateToSiblings.isVisible() ){
	   				applyUpdateToSiblings.setVisible(true);
	   			}
	   		}
    	   
    	   applyUpdateToSiblings.reset();
    	   var applyUpdateToSiblingsStore = applyUpdateToSiblings.getStore();
    	   if(!isNullOrEmpty(data.relatedPerson.id))
    	   {
    		   var parentPersonId = data.relatedPerson.id
    	   }
    	   if(!isNullOrEmpty(data.relatedPerson.firstName))
    	   {
    		   var firstName = data.relatedPerson.firstName
    	   }
    	   if(!isNullOrEmpty(data.relatedPerson.lastName))
    	   {
    		   var lastName = data.relatedPerson.lastName
    	   }
    	   if(!isNullOrEmpty(data.relatedPerson.middleName))
    	   {
    		   var middleName = data.relatedPerson.middleName
    	   }
    	   if(!isNullOrEmpty(data.relatedPerson.emailId))
    	   {
    		   var emailId = data.relatedPerson.emailId
    	   }
    	   if(!isNullOrEmpty(data.person.id))
    	   {
    		   var studentPersonId = data.person.id
    	   }
    	   applyUpdateToSiblingsStore.getProxy().extraParams = {
    		   parentPersonId: parentPersonId,
    		   parentFirstName:firstName,
    		   parentLastName:lastName,
    		   parentMiddleName:middleName,
    		   parentEmailId:emailId,
    		   studentPersonId: studentPersonId
    	   };
    	   var siblingModel = applyUpdateToSiblingsStore.getRange();
    	  
    	   applyUpdateToSiblingsStore.load({
    		   callback: function(records, operation, success) {
    			   if (success) {
    				   var siblingAssociationArray= [];
    				   var siblingAssociationUpdateIds= [];
    				   var siblingAssociationUpdateStudentIds= [];
    				   if(records.length > 0){
    					   for(var i in data.siblingAssociationDetails){
        					   siblingAssociationArray.push(data.siblingAssociationDetails[i].student.id);
        					   siblingAssociationUpdateIds.push(data.siblingAssociationDetails[i].id);
        					   siblingAssociationUpdateStudentIds.push(data.siblingAssociationDetails[i].student.id);
        					   var recordData = applyUpdateToSiblingsStore.findRecord('id',data.siblingAssociationDetails[i].student.id);
        					   if( !isNullOrEmpty(recordData) ){
        						   recordData.set("ids",siblingAssociationUpdateIds);
            					   recordData.set("studentId",siblingAssociationUpdateStudentIds);
        					   }
        					   
        				   } 
        				   applyUpdateToSiblings.setValue(siblingAssociationArray);
    					   
    				   }else{
    					   data.siblingAssociationDetails = [];
    				   }
    				  
    			   }
    		   }
    	   });
       },
       exportPDFParentGuardianReport : function(){
          	var this$ = this;
          	var personProfile = this$.getContentPanelActiveTab();
          	var personId;
          	var applicationId;
          	var portalId = this$.getCurrentLoggedPortalId();
          	try{
          		personId = personProfile.getPersonId();
          		applicationId = personProfile.applicationId;
          	}catch(e){
          		personId = this$.getContentPanel().items.items[0].getPersonId();
          		applicationId = this$.getContentPanel().items.items[0].applicationId;
          	}
   		var code = 'PARENT_GUARDIAN_REPORT_PDF';
   		var reportParams =new Object();
   		reportParams.personId = personId;
   		reportParams.headerName = 'Parent Guardian  Report';
   		var reportTitle="Parent Guardian  Report";
   		if(portalId==6){
   			this.exportJRXMLReport(code,reportParams,reportTitle,'.pdf',SERVERURL.PARENT_AND_GUARDIAN_DETAILS_PDF_REPORT_APPLICANT);
   		}else{
   			this.exportJRXMLReport(code,reportParams,reportTitle,'.pdf',SERVERURL.PARENT_AND_GUARDIAN_DETAILS_PDF_REPORT);
   		}
   	},
   	exportXLParentGuardianReport : function(){
   		var this$ = this;
      	var personProfile = this$.getContentPanelActiveTab();
      	var personId;
      	var applicationId;
      	var portalId = this$.getCurrentLoggedPortalId();
      	try{
      		personId = personProfile.getPersonId();
      		applicationId = personProfile.applicationId;
      	}catch(e){
      		personId = this$.getContentPanel().items.items[0].getPersonId();
      		applicationId = this$.getContentPanel().items.items[0].applicationId;
      	}
		var code = 'PARENT_GUARDIAN_REPORT_EXCEL';
		var reportParams =new Object();
		reportParams.personId = personId;
		reportParams.headerName = 'Parent Guardian  Report';
		var reportTitle="Parent Guardian  Report";
		if(portalId==6){
			this.exportJRXMLReport(code,reportParams,reportTitle,'.vnd.ms-excel',SERVERURL.PARENT_AND_GUARDIAN_DETAILS_EXCEL_REPORT_APPLICANT);
		}else{
			this.exportJRXMLReport(code,reportParams,reportTitle,'.vnd.ms-excel',SERVERURL.PARENT_AND_GUARDIAN_DETAILS_EXCEL_REPORT);
		}
		
	},
	editParentFeePayerDetailRecord: function(btn,records){
   		var this$ = this;
   	    var personComContlr =Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
	  	personType='PARENT',
	    tabPanelTitle= 'FPD_FEE_PAYER_DETAILS',
		tabPanelItemId= 'personfeepayerdetailformItemId',
		tabPanelItemXtype = 'feepayerdetailform',
		xtypeItemId = 'personfeepayerdetailformItemId',
		defaultPanel= true,
		menuColorCls =CONSTANTS.MENU_COLOR_SEVEN;
		
       personComContlr.addPersonTabPanel(personType, tabPanelItemId, tabPanelTitle, tabPanelItemXtype, xtypeItemId, defaultPanel,'',menuColorCls);
      	var form = this$.getParentFeePayerDetailForm();
          var formScroll = form.up('form');
          
		if(!isNullOrEmpty(formScroll.getEl()))
		{
			var getElValue=formScroll.getEl();
			var getFirstChild = getElValue.first();
			getFirstChild.dom.style.overflowY="scroll";
		} 	
		if(records){
			form.isPrimaryFeePayer=records.data.isPrimaryFeePayer;
		}
           if (!isEmpty(records)) {
               var payerTypeItemId = form.down("#payerTypeItemId");
               payerTypeItemId.setReadOnly(true);
               var doesFeePayerConsentToCreditCheckItemId = form.down("#doesFeePayerConsentToCreditCheckItemId");
               if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.doesFeePayerConsentToCreditCheck)) {
               	doesFeePayerConsentToCreditCheckItemId.setValue({
               		doesFeePayerConsentToCreditCheck: records.data.doesFeePayerConsentToCreditCheck
               	});
               }
               var salutationItemId = form.down("#salutationItemId");
               if (!isNullOrEmpty(records.data.salutation) && !isNullOrEmpty(records.data.salutation.id)) {
               	salutationItemId.getStore().load({
					   callback: function(recordss, operation, success) {
						   for(var i in recordss){
							   if( !isNullOrEmpty(records.data.salutation) ){
								   if(recordss[i].data.id==records.data.salutation.id){
									 salutationItemId.setValue(recordss[i].data.id);
								   }
							   }
						   }
					   }	   
				   });
             }
               
               var bankItemId = form.down("#bankItemId");
               /*if (!isNullOrEmpty(records.data.bank) && !isNullOrEmpty(records.data.bank.id)) {
               	bankItemId.setValue(records.data.bank.id);
               }*/
            
               var debitOrderDateItemId = form.down("#debitOrderDateItemId");
               debitOrderDateItemId.getStore().load({
				   callback: function(recordss, operation, success) {
					   for(var i in recordss){
						   if(!isNullOrEmpty(records.data.debitOrderDateCSM)){
							   if(recordss[i].data.id==records.data.debitOrderDateCSM.id){
								   debitOrderDateItemId.setValue(recordss[i].data.id);
							   } 
						   }
					   }
				   }	   
			   });
/*               if (!isNullOrEmpty(records.data.debitOrderDateCSM) && !isNullOrEmpty(records.data.debitOrderDateCSM.id)) {
            	   debitOrderDateItemId.setValue(records.data.debitOrderDateCSM.id);
            	   
               
               }
*/               
               
               
               var empOfTheOrganizationField = form.down("#empOfTheOrgItemId");
               if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.employeeOfOrganization)) {
               	empOfTheOrganizationField.setValue({
               		employeeOfOrganization: records.data.employeeOfOrganization
               	});
               }
               
               var branchCodeId = form.down("#branchCodeItemId");
               
               if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.bank)){
               bankItemId.getStore().load({
					   callback: function(recordss, operation, success) {
						   for(var i in recordss){
							   if(!isNullOrEmpty(records.data.bank)){
								   if(recordss[i].data.id==records.data.bank.id){
									   bankItemId.setValue(recordss[i].data.id);
								   } 
							   }
						   }
					   }	   
				   });
               var branchCodeStore = branchCodeId.getStore();
               branchCodeStore.getProxy().extraParams = {
                   bankId: records.data.bank.id
               };
               branchCodeStore.load();
               }
               
            if(!isNullOrEmpty(records.data) && records.data.branchcode!=null){
               		branchCodeId.setValue(records.data.branchcode);
             }
               
            var addressText = form.down('#addressTextArea');
           	var country = form.down('#countryId');
           	var countryRegion = form.down('#parentCountryRegionId');
           	var city = form.down('#cityId');
           	var pincode = form.down('#pincodeId');
           	
           	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.addressText)) {
           		  addressText.setValue(records.data.addressText);
               }
           	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.pincode)) {
           		pincode.setValue(records.data.pincode);
             }
           	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.countryId)) {
           		country.store.load();
           		country.setValue(records.data.countryId);
           		countryRegion.setDisabled(false);
           		var countryRegionStore = countryRegion.getStore();
                   countryRegionStore.getProxy().extraParams = {
                       cid: records.data.countryId
                   };
                   countryRegionStore.load();                  
             }
           	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.parentCountryRegionId)) {
           	
           		countryRegion.setValue(records.data.parentCountryRegionId);      
           		city.setDisabled(false);
           		  var cityStore = city.getStore();
                                          
                     cityStore.getProxy().extraParams = {
                    	 countryId: records.data.countryId,
                    	 countryRegionId: records.data.parentCountryRegionId
                     };
                     cityStore.load();
             }
           	if (!isNullOrEmpty(records.data) && !isNullOrEmpty(records.data.cityId)) {
           		city.setValue(records.data.cityId);
             }
           	
               var feePayerIDItemId = form.down("#feePayerIDItemId");
               var feePayerLatestPayslipItemId = form.down("#feePayerLatestPayslipItemId");
               var feePayerProofOfAccountItemId = form.down("#feePayerProofOfAccountItemId");
               feePayerIDItemId.allowBlank = true;
               feePayerLatestPayslipItemId.allowBlank = true;
               feePayerIDItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_ID'));
				   feePayerLatestPayslipItemId.setFieldLabel(getPersonModuleTranslation('FPD_FEE_PAYER_LATEST_PAYSLIP'));
               form.loadRecord(records);
               if(!isNullOrEmpty(records.data.debitOrderStartDate)){
           		var debitOrderStartDate = form.down("#debitOrderStartDate");
           		debitOrderStartDate.setValue(dateRender(records.data.debitOrderStartDate));
             	}
	           	if(!isNullOrEmpty(records.data.debitOrderEndDate)){
	           		var debitOrderEndDate = form.down("#debitOrderEndDate")
	               	debitOrderEndDate.setValue(dateRender(records.data.debitOrderEndDate));
	           	}
	           	var homeTelephoneCountryCodeItem