/**
 * @author Dharmendra.Prajapati
 */
Ext.define('Academia.controller.portal.FacultyPortalController', {
	extend: 'Academia.controller.base.BaseController',
	views: ['facultyPortal.PersonInfoFacultyPortal'],
	refs: [{
		ref: 'contentPanel',
		selector: 'contentpanel'
	},{
		ref: 'personInfoFacultyPortal',
		selector: 'personinfofacultyportal'
	}],
	init: function(application) {
		this.control({
			'personinfofacultyportal': {
				afterrender: this.getPersonInfoFacultyPortalRender 
			}
		});
	},
	/**
	 * @author Dharmendra.Prajapati
	 */

	getPersonInfoFacultyPortalRender : function(tb){
		var $this=this;
		var programBatchSeatTypeConfigId=0;
		var userInfo = Academia.model.authentication.UserInfoModel;
		$this.applyConfigToPersonTab(tb);
		/*if(tb.contentXtype=='feeplangrid'){
			 programBatchSeatTypeConfigId  = $this.getProgramBatchSeatTypeConfig(userInfo);
		}*/
		try{
			var personInfo = contentPanel.getPersonInfo();
			}
			catch(ee){
			var contentPanel = $this.getContentPanel();
			var personInfo = contentPanel.getPersonInfo();
			}
		tb.setPersonInfo(personInfo);
		tb.setUserId(userInfo.get("userId"));
		tb.setPersonId(userInfo.get("personId"));
		tb.setAdmissionId(null);
		tb.setProgramBatchSeatTypeConfigId(programBatchSeatTypeConfigId);
		tb.insert(0,{
			xtype: tb.contentXtype,
			itemId: tb.contentXtypeItemId,
			personType:'FACULTY'
		});
		var that = this;
		setTimeout(function(){
			var contentPanel = that.getContentPanel(); //get hold of the content panel where we are adding all the tabs
			contentPanel.items.findBy(function(tab) {
				if(tab!=undefined){
					if(tab.title == 'Portal'){
						contentPanel.remove(tab,true);
					}
				}
			});
		}, 20);

		tb.items.items[0].setTitle(false);
		tb.items.items[0].closable=false;
		
		if(tb.items.items[0].viewType=='gridview'){
			tb.items.items[0].setTitle(tb.title);
		}
	},
	getloggedInFacultyDetails : function(){
		var this$ = this;
		var userInfo = Academia.model.authentication.UserInfoModel;
		var studentProfile = this$.getContentPanel();
		Ext.apply(studentProfile, {
			personInfo: null,
			setPersonInfo: function(personInfo) {
				studentProfile.personInfo = personInfo;
			},
			getPersonInfo: function() {
				return studentProfile.personInfo;
			}
		});
		var userId = userInfo.get("userId");
		if (!isNullOrEmpty(userId)) {
			Ext.getBody().mask(getCommonTranslation('LOADING_MASK'), 'x-mask-loading');
			var studentProfileUrl = SERVERURL.FACULTY_PERSONAL_INFORMATION_BY_ID + userId;
			Ext.Ajax.request({
				type: 'rest',
				url: studentProfileUrl,
				method: 'GET',
				success: function(res, action) {
					Ext.getBody().unmask();
					var data = Ext.decode(res.responseText);
					if(!isEmpty(data)){
						studentProfile.setPersonInfo(data.person);
						
						try{
                            if(portalId == '2'){
                            	userInfo.set("code", data.code);
                            }
                        }
                        catch(e){
                            //
                        }
					}
				},
				failure: function(res, action) {
					Ext.getBody().unmask();
				}
			});
		}
	},
/*	getProgramBatchSeatTypeConfig : function(){
		var portalInfo = Academia.model.authentication.PortalInfoModel;
        var admissionDetails = portalInfo.get('admissionDetails')[0];
        var batchId = admissionDetails.batch.id;
		Ext.Ajax.request({
			type: 'rest',
			async: false,
			url: SERVERURL.FIND_PROGRAMBATCHSEATCONFIG_BY_BATCH_ID+'?batchId='+batchId,
			method: 'GET',
			success: function(res, action) {
				var jsonData = Ext.decode(res.responseText);
				var myArray=[];
				for(var i in jsonData){
					myArray.push(jsonData[i].id);
				}
				programBatchSeatTypeConfigId = myArray.join();
			}
		});
		return programBatchSeatTypeConfigId;
	},*/
	getLoadStudentDetail : function(){
		var userInfo = Academia.model.authentication.UserInfoModel;
		var studentId = userInfo.get("userId");
		Ext.Ajax.request({
			type: 'rest',
			url: SERVERURL.BATCH_ID_BY_STUDENT_ID+'?studentId='+studentId,
			method: 'GET',
			async: false,
			success: function(res, action) {
				var data = Ext.decode(res.responseText);
				var portalInfo = Academia.model.authentication.PortalInfoModel;
				portalInfo.set('admissionDetails',data[0].admissionDetails);
				portalInfo.set('student',data[0].student);
				portalInfo.set('userAacademyLocations',data[0].userAacademyLocations);
			}
		});
	},
	applyConfigToPersonTab : function(newTab){

		Ext.apply(newTab,{
			personId: null,
			userId: null,
			admissionId: null,
			personInfo: {},
			setPersonId: function(personId) {
				newTab.personId = personId;
			},
			getPersonId: function() {
				return newTab.personId;
			},
			setUserId: function(userId) {
				newTab.userId = userId;
			},
			getUserId: function() {
				return newTab.userId;
			},
			setPersonInfo: function(personInfo) {
				newTab.personInfo = personInfo;
			},
			getPersonInfo: function() {
				return newTab.personInfo;
			},
			setAdmissionId: function(admissionId) {
				newTab.admissionId = admissionId;
			},
			getAdmissionId: function() {
				return newTab.admissionId;
			},
			setProgramBatchSeatTypeConfigId: function(programBatchSeatTypeConfigId) {
				newTab.programBatchSeatTypeConfigId = programBatchSeatTypeConfigId;
			},
			getProgramBatchSeatTypeConfigId: function() {
				return newTab.programBatchSeatTypeConfigId;
			}
		});
	}
});
