/**
 * @Author Phool Singh  Gour
 */
Ext.define('Academia.controller.program.lessonplanning.LessonPlanningController', {
	extend: 'Academia.controller.base.BaseController',

	stores: ['common.AcademicTermStore', 'attendance.AssignedCoursesFacultyStore','attendance.VariantMappedToPlan','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'
		,'attendance.AllProgramMappedByCourse','common.BatchesByProgramId','attendance.AssignedCoursesFacultyStore','course.coursevariants.CourseVariantStore',
		'common.AssignedProgramStore','enquiry.AcademicBatchForSectionGroupStore','program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
		'lessonplan.LessonPlanTermStore','lessonplan.LessonPlanUnitTitleStore','lessonplan.LessonPlanDurationStore','lessonplan.LessonPlanObjectiveStore',
		'lessonplan.LessonPlanGridStore','course.coursevariants.NewCourseVariantStore',
		'common.ActiveUserStore','lessonplan.LessonPlanTopicStore','lessonplan.LessonPlanCourseVariantListStore',
		'lessonplan.LessonPlanObjectiveDetailtListStore','lessonplan.CourseByAcademicTermLessonPlan','lessonplan.LessonPlanDocumentStore','lessonplan.CoursesByAcademicTermForLessonPlanStore',
		'attendance.AttendanceFacultyList', 'attendance.LessonPlanFacultyStore','course.AssignedPeriodCoursesFacultyStore','lessonplan.CourseVariantOfLessonPlan','course.CourseCategoryStore','common.AcademyLocationNameSeparated'],

		models: ['lessonplan.LessonPlanModel','lessonplan.LessonPlanGridModel','lessonplan.CopyLessonPlanModel'],

		views: ['program.lessonplanning.LessonPlanningFilter','program.lessonplanning.LessonPlanningStructure',
			'program.lessonplanning.LessonPlanningGrid','program.lessonplanning.LessonPlanningCopyWindow',
			'program.lessonplanning.CreateEditLessonPlanningDetails','program.lessonplanning.NoOfLessonPlanCourseVariant',
			'program.lessonplanning.NoOfLessonPlanObjectiveDetails','program.lessonplanning.LessonPlanningDocumentGrid',
			'program.lessonplanning.LessonPlanDocumentList','program.lessonplanning.LessonPlanDocumentGridDownload','program.lessonplanning.LessonPlanningDetailsForm',
			'program.lessonplanning.LessonPlanningCopyWindowForm','program.lessonplanning.LessonplanBulkCopyWindow'],
			config: {
				LESSON_PLANNING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LESSON_PLANNING_PRIVILEGES'),
				LESSON_PLANNING_FACULTY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('LESSON_PLANNING_FACULTY_PRIVILEGES'),
			},	

			refs: [{
				ref: 'lessonplanningfilter',
				selector: 'lessonplanningfilter'
			},{
				ref: 'lessonplanninggrid',
				selector: 'lessonplanninggrid'
			},{
				ref: 'lessonplanningcopywindow',
				selector: 'lessonplanningcopywindow'
			},{
				ref: 'lessonPlanningCopyWindow',
				selector: 'lessonplanningcopywindow form'
			},{
				ref: 'lessonplanningstructure',
				selector: 'lessonplanningstructure'
			},{
				ref: 'contentPanel',
				selector: 'contentPanel'
			},{
				ref: 'tcsearchstudent',
				selector: 'tcsearchstudent'
			},{
				ref: 'tcstudentflyout',
				selector: 'tcstudentflyout'
			},{
				ref: 'createeditlessonplanningdetails',
				selector: 'createeditlessonplanningdetails'
			},
			{
				ref: 'nooflessonplancoursevariant',
				selector: 'nooflessonplancoursevariant'
			},
			{
				ref: 'nooflessonplanobjectivedetails',
				selector: 'nooflessonplanobjectivedetails'
			},
			{
				ref:'lessonplanningdocumentgrid',
				selector:'lessonplanningdocumentgrid'
			},
			{
				ref:'lessonplandocumentlist',
				selector:'lessonplandocumentlist'
			},
			{
				ref:'lessonplandocumentgriddownload',
				selector:'lessonplandocumentgriddownload'
			},
			{
				ref:'lessonplanningdetailsform',
				selector:'lessonplanningdetailsform'
			},{
				ref: 'lessonplanningcopywindowform',
				selector: 'lessonplanningcopywindowform'
			},
			{
				ref : 'lessonplanbulkcopywindow',
				selector : 'lessonplanbulkcopywindow'
			}],
			init: function(application) {
				this.control({
					/*'createeditlessonplanningdetails button[itemId=lessionPlanSubmitButtonId]': {
                				 click: function() {
                					 this.addLessonPlanData();
                				 }
                			 },*/
					/*'createeditlessonplanningdetails customcombobox[itemId=comboAcademicTerm]': {
                   				 select: function(obj, record) {
                   					var academicTermId = record[0].get("id");
                   					var form = this.getCreateeditlessonplanningdetails();
                   					var coursefield = form.down('#courseItemId');
                   					coursefield.setDisabled(false);
                   					var portalId = this.getCurrentLoggedPortalId();
                 					 var facultyId = null;
                        			if(portalId == 2) {
                        				facultyId=this.getCurrentlyLoggedInUser().id;
                        			}
                   					var academyLocationId = this.getCurrentAcademyLocation();
                   					var courseStore = this.getStore('course.AssignedPeriodCoursesFacultyStore');
                   					courseStore.getProxy().extraParams = {
             	 						academicTermId: academicTermId,
             	 						academyLocationId: academyLocationId,
             	 						facultyId:facultyId
             	 					};
                   					courseStore.load();
                   				 }
                   			 },*/
					/*'createeditlessonplanningdetails customcombobox[itemId=courseItemId]': {
                   				 select: function(obj, record) { 
                   					 var courseId=record[0].data.courseId;
                   					 var form = this.getCreateeditlessonplanningdetails();
                   					 courseVariant=form.down('#courseVariantId');
                   					 courseVariant.setDisabled(false);
                   					 courseVariant.reset();
                   					 var faculty = form.down("#facultyId");
                   					 faculty.reset();
                   					 var store = this.getStore('course.coursevariants.CourseVariantStore');
                   					 store.getProxy().extraParams = {
                   						 courseId: courseId,
                   						 isCurrentPeriod : true
                   					 };
                   					 store.load();
                   				 }
                   			 },*/
					/*'createeditlessonplanningdetails multiselectcombofield[itemId=courseVariantId]': {
                   			blur : function(obj, record) {
                   			   var form = this.getCreateeditlessonplanningdetails();
                   			   var faculty = form.down("#facultyId");
                   			   var facultyStore = faculty.getStore();
                   			   var portalId = this.getCurrentLoggedPortalId();
                   			   var loggedInFacultyId = null;
                   			   if(portalId == 2) {
                   				loggedInFacultyId=this.getCurrentlyLoggedInUser().id;
                   			   }
                   			   unitTitle=form.down('#unitTitleId');
                   			   unitTitle.setDisabled(false);
                   			   topic=form.down('#topicId');
                   			   topic.setDisabled(false);
                   			   term=form.down('#termId');
                   			   term.setDisabled(false);
                   			   duration=form.down('#durationId');
                   			   duration.setDisabled(false);
                   			   aim=form.down('#aimId');
                   			   aim.setDisabled(false);
                   			   prerequisite=form.down('#prerequisiteId');
                   			   prerequisite.setDisabled(false);
                   			   if(isNullOrEmpty(form.down('#hiddenLessionPlanIdItemId').getValue())){
                       			   objective=form.down('#objectiveId');
                       			   objective.setDisabled(false);
                       			  isSubObjective=form.down('#isSubObjectiveID');
                       			   isSubObjective.setDisabled(false);
                       			   objDescription=form.down('#objDescription');
                       			   objDescription.setDisabled(false);
                   			   }
                   			   faculty.setDisabled(false);
                   			   var course = form.down("#courseItemId");
                   			   var courseVariantId = obj.up('form').down('#courseVariantId').getValue();
	                   			var courseVariantIds; 
	                   		    var cvIds=[];
	    	     				if(courseVariantId !=undefined && courseVariantId.length > 0 && courseVariantId[0] != ""){
	    	     					for(var i in courseVariantId){
	    	     						if(Ext.isObject(courseVariantId[0])){
	    	     							cvIds.push(courseVariantId[i].get("id"));
	    	     						}else{
	    	     							cvIds.push(courseVariantId[i]);
	    	     						}
	    	     					}
	    	     				} 
	    	     				courseVariantIds = cvIds.join();
                   			    facultyStore.getProxy().extraParams = {
                   				   courseVariantIds:courseVariantIds,
                   				   courseId:course.getValue()
                   			    };
                   			    facultyStore.load({
            					   callback: function(record, operation, success) {
            						   if (success) {
            							   if (record.length == 1) {
            								   faculty.setValue(record[0].data.facultyId);
            							   }
            							   else{
            								   faculty.setValue(loggedInFacultyId);
                                  			}
            						   }

            					   }
                   			   });
                   			   //form.isValid();
                   			   },
                   		   },*/
					/*'createeditlessonplanningdetails customcombobox[itemId=objectiveId]': {
               				 select: function(obj, record) { 
               					 var form = this.getCreateeditlessonplanningdetails();
               					 addObjective=form.down('#lessionPlanSubmitAddAndNewButtonId');
               					 addObjective.setDisabled(false);
               				 }
               			 },*/

					'lessonplanninggrid button[itemId=btnAdd]': {
						click: function() {
							this.openNewCmpTab();
						}
					},
					'lessonplanninggrid button[itemId=btnAdd]': {
						click: function() {
							this.showLessonplanningcopywindow();
						}
					},
					'lessonplanninggrid button[itemId=btnDelete]':{
						click: this.deleteLessonPlanRecord
					},
					
					'lessonplanninggrid button[itemId=lessonPlanningBulkCopyBtn]':{
		    			 click: function() {
		    				 var this$ = this;
		    					var formWindow = this$.getLessonplanbulkcopywindow();
		    					if (!formWindow) {
		    						Ext.widget('lessonplanbulkcopywindow');
		    						formWindow = this$.getLessonplanbulkcopywindow();
		    					}

		    					formWindow.show();
		    			 }

		    		 },

					/*'lessonplanninggrid splitbutton[itemId=btnMoreOperations]':{
	                			   menushow: function( btn, menu, eOpts ){
	                				   var moreActionPermissionList = btn.permissions;
	                				   var gridReference = btn.up('grid');

	                				   setTimeout(function(){
		                				   Ext.each(moreActionPermissionList, function(privilege) {
		    		                		   if (privilege === 'VALIDATE') {
		    		                			   gridReference.down('#moreActionValidateBtn').setVisible(true);
		    		                		   }
		    		                		   else if (privilege === 'PUBLISH') {
		    		                			   gridReference.down('#moreActionPublishBtn').setVisible(true);
		    		                		   }
		    		                		   else if (privilege === 'UNVALIDATE') {
		    		                			   gridReference.down('#moreActionUnValidateBtn').setVisible(true);
		    		                		   }
		    		                		   else if (privilege === 'UNPUBLISH') {
		    		                			   gridReference.down('#moreActionUnPublishBtn').setVisible(true);
		    		                		   }
		    		                	   });
	                				   },300);
	                			   }
	                		   },*/

					/*'lessonplanninggrid button[itemId=btnEdit]':{
	                			   click: Ext.bind(this.editLessonPlanRecord, this, [false])
	                		   },

	                		   'lessonplanninggrid button[itemId=btnView]':{
	                			   click: Ext.bind(this.editLessonPlanRecord, this, [true])
	                		   },*/
		    		 'lessonplanninggrid button[itemId=courseDescriptorReportsId]':{
		    			 afterrender: this.renderCourseDescriptorReportMenusBtn
		    		 },
					'lessonplanninggrid':{
						cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
							var $this=this;
							var grid = $this.getLessonplanninggrid();
							if(e.target.tagName=="A"){
								var columnName=grid.columnManager.columns[ColIdx].dataIndex;
								if(columnName=='courseVariantCount' &&  record.data.courseVariantCount > 0){ // checked

									var store=$this.getStore('lessonplan.LessonPlanCourseVariantListStore'); 
									var submitURL=SERVERURL.LESSON_PLAN_COURSE_VARIANT_LIST;
									store.getProxy().api.read=submitURL;
									store.getProxy().extraParams = {
										id: record.data.id
									};
									store.load();

									var formWindow = $this.getNooflessonplancoursevariant();
									if (!formWindow) {
										var formWindow = Ext.widget('nooflessonplancoursevariant');
									}
									formWindow.show();
								}
								if(columnName=='objectiveCount' &&  record.data.objectiveCount > 0){ 

									var store=$this.getStore('lessonplan.LessonPlanObjectiveDetailtListStore'); 
									var submitURL=SERVERURL.LESSON_PLAN_OBJECTIVE_LIST;
									store.getProxy().api.read=submitURL;
									store.getProxy().extraParams = {
										id: record.data.id
									};
									store.load();
									var formWindow = $this.getNooflessonplanobjectivedetails();
									if (!formWindow) {
										var formWindow = Ext.widget('nooflessonplanobjectivedetails');
									}
									formWindow.show();

								}

								if(columnName=='documentCount' && record.data.documentCount > 0){
									this.linkNoOfLessonPlanDocuments(grid, RowIdx, record);
								}

								if(columnName == 'facultyArray' && record.data.facultyArray.length > 1){
									this.openLessonPlanFacultyWin(grid, RowIdx, record);
								}
							}
						},
						render: function(grid) {
							grid.getStore().removeAll();
							grid.getStore().getProxy().extraParams = {
								academicTermId: 0
							};
							grid.getStore().reload();
							if(this.getCurrentLoggedPortalId() == 2){
								this.doAccessControlValidation(grid, this.getLESSON_PLANNING_FACULTY_PERMISSIONS());
								this.disableMoreButtonPivileges(grid, this.getLESSON_PLANNING_FACULTY_PERMISSIONS()); 
								this.addDataGridConfigButton(grid,this.getLESSON_PLANNING_FACULTY_PERMISSIONS());
							}else{
								this.doAccessControlValidation(grid, this.getLESSON_PLANNING_PERMISSIONS());
								this.disableMoreButtonPivileges(grid, this.getLESSON_PLANNING_PERMISSIONS());
								this.addDataGridConfigButton(grid,this.getLESSON_PLANNING_PERMISSIONS());
							}
						},
						selectionchange:function(view,record){
							var grid = this.getLessonplanninggrid()
							var lessonPlanningValidateBtn =grid.down('#lessonPlanningValidateBtn');
							var lessonPlanningPublisBtn =grid.down('#btnPublishId');
							var lessonPlanningExportBtn =grid.down('#exportLessonPlanReportsId');
							var lessonPlanningCourseDescriptorBtn =grid.down('#courseDescriptorReportsId');
							var lessonPlanningAssessmentMapBtn =grid.down('#assessmentMapReportsId');
							var lessonPlanbtnEdit = grid.down('#btnEdit');
							var lessonPlanbtnView =  grid.down('#btnView');
							var lessonPlanbtnDelete =  grid.down('#btnDelete');
							var btnMoreOperations = grid.down('#btnMoreOperations');
							var lessonPlanningBulkCopyBtn = grid.down('#lessonPlanningBulkCopyBtn');

							if(record.length > 0){
								lessonPlanningValidateBtn.enable();
								lessonPlanningPublisBtn.enable();
								lessonPlanbtnDelete.enable();
								lessonPlanningCourseDescriptorBtn.enable(); 
								lessonPlanningAssessmentMapBtn.enable(); 
								if(record.length == 1){
									lessonPlanbtnEdit.enable();
									lessonPlanbtnView.enable();
									lessonPlanningExportBtn.enable(); 
								}else{
									lessonPlanbtnEdit.disable();  
									lessonPlanbtnView.disable();
									lessonPlanningExportBtn.disable(); 
								}
								if(record.length > 1){
									lessonPlanningBulkCopyBtn.enable();
								}else{
									lessonPlanningBulkCopyBtn.disable();
								}
							}else{
								lessonPlanbtnEdit.disable();  
								lessonPlanbtnView.disable();
								lessonPlanningValidateBtn.disable();
								lessonPlanningPublisBtn.disable();
								lessonPlanningExportBtn.disable();
								lessonPlanbtnDelete.disable();
								lessonPlanningCourseDescriptorBtn.disable(); 
								lessonPlanningAssessmentMapBtn.disable(); 
								lessonPlanningBulkCopyBtn.disable();
							}

							if(portalId == 1){
								if(record.length == 1){
									btnMoreOperations.enable();

									var whethePublished = (record[0].data.whethePublished == "Not Published") ? false : true;
									var whetherValidated = (record[0].data.whetherValidated == "Not Validated") ? false : true;

									var moreActionPublishBtn = grid.down('#moreActionPublishBtn');
									var moreActionValidateBtn = grid.down('#moreActionValidateBtn');
									var moreActionUnPublishBtn = grid.down('#moreActionUnPublishBtn');
									var moreActionUnValidateBtn = grid.down('#moreActionUnValidateBtn');

									if(!whethePublished && !whetherValidated){
										(moreActionPublishBtn) ? moreActionPublishBtn.disable() : ''; 
										(moreActionValidateBtn) ? moreActionValidateBtn.enable() : '';
										(moreActionUnPublishBtn) ? moreActionUnPublishBtn.disable() : ''; 
										(moreActionUnValidateBtn) ? moreActionUnValidateBtn.disable() : ''; 
									}
									else if(!whethePublished && whetherValidated){
										(moreActionPublishBtn) ? moreActionPublishBtn.enable() : '';
										(moreActionValidateBtn) ? moreActionValidateBtn.disable() : ''; 
										(moreActionUnPublishBtn) ?  moreActionUnPublishBtn.disable() : ''; 
										(moreActionUnValidateBtn) ? moreActionUnValidateBtn.enable() : '';
									}
									else if(whethePublished && whetherValidated){
										(moreActionPublishBtn) ? moreActionPublishBtn.disable() : ''; 
										(moreActionValidateBtn) ? moreActionValidateBtn.disable() : ''; 
										(moreActionUnPublishBtn) ? moreActionUnPublishBtn.enable() : '';
										(moreActionUnValidateBtn) ? moreActionUnValidateBtn.enable() : '';
									}
								}
								else{
									btnMoreOperations.disable();
								}
							}
						}
					},
					'lessonplanninggrid [itemId=excelExportLessionPlansBtn]':{
						click:function(){ 
							this.generateLessonPlanReport();

						}
					},	

					'lessonplanninggrid [itemId=pdfExportLessionPlansBtn]':{
						click:function(){ 
							this.generatePDFLessonPlanReport();

						}
					},	
					
					'lessonplanninggrid [itemId=excelAssessmentMapReportBtn]':{
						click:function(){ 
							this.generateLessonPlanAMReport();

						}
					},	

					'lessonplanninggrid [itemId=pdfAssessmentMapReportBtn]':{
						click:function(){ 
							this.generatePDFLessonPlanAMReport();

						}
					},
					
					'lessonplanninggrid [itemId=excelSommetCourseDescriptorReportBtn]':{
						click:function(btn){ 
							this.generateLessonPlanCDReport(btn);

						}
					},	
					'lessonplanninggrid [itemId=excelLRCMCourseDescriptorReportBtn]':{
						click:function(btn){ 
							this.generateLessonPlanCDReport(btn);

						}
					},	
					'lessonplanninggrid [itemId=excelLRMCourseDescriptorReportBtn]':{
						click:function(btn){ 
							this.generateLessonPlanCDReport(btn);

						}
					},	

					'lessonplanninggrid [itemId=pdfSommetCourseDescriptorReportBtn]':{
						click:function(btn){ 
							this.generatePDFLessonPlanCDReport(btn);

						}
					},
					'lessonplanninggrid [itemId=pdfLRMCourseDescriptorReportBtn]':{
						click:function(btn){ 
							this.generatePDFLessonPlanCDReport(btn);

						}
					},
					'lessonplanninggrid [itemId=pdfLRCMCourseDescriptorReportBtn]':{
						click:function(btn){ 
							this.generatePDFLessonPlanCDReport(btn);

						}
					},

					'lessonplanningcopywindow button[itemId=btnCancel]' : {
						click:function(){
							this.getLessonplanningcopywindow().close();
						}
					},
					'lessonplanningcopywindow button[itemId=btnContinue]' : {
						click:function(){
							this.openNewCmpTab();
							this.getLessonplanningcopywindow().close();
						}
					},
					'lessonplanningcopywindow button[itemId=btnSubmit]' : {
						click : function() {
							this.lessonPlanningCopySave();
						}
					},
					'lessonplanbulkcopywindow button[itemId=btnCopy]' : {
						click : function() {
							this.lessonPlanningBulkCopySave();
						}
					},
					
					'lessonplanningfilter': {
							afterrender: function(obj) {
						        var fieldInfo = Academia.model.authentication.FormFieldInfoModel,
						            formFieldsInfo = fieldInfo.get("formFieldsInfo") || {},
						            formfields = formFieldsInfo['lessonplanningfilter'] || [],
						            hiddenFields = {};

						        Ext.Array.each(formfields, function(field) {
						            hiddenFields[field.formFieldName] = {
						                hidden: !field.isVisible
						            };
						        });

						        if (hiddenFields['courseItemId'] && hiddenFields['courseItemId']['hidden']) {
						            obj.down("#courseVariantId").setVisible(false);
						        }

						        if (hiddenFields['program_Id'] && hiddenFields['program_Id']['hidden']) {
						            obj.down("#sectionGroupBatchId").setVisible(false);
						            obj.down("#period_Id").setVisible(false);
						        }

						        if (hiddenFields['sectionGroupBatchId'] && hiddenFields['sectionGroupBatchId']['hidden']) {
						            obj.down("#period_Id").setVisible(false);
						        }

						        if (
						            hiddenFields['termId'] && hiddenFields['termId']['hidden'] &&
						            hiddenFields['unittitleId'] && hiddenFields['unittitleId']['hidden'] &&
						            hiddenFields['facultyId'] && hiddenFields['facultyId']['hidden'] &&
						            hiddenFields['objectiveId'] && hiddenFields['objectiveId']['hidden'] &&
						            hiddenFields['durationId'] && hiddenFields['durationId']['hidden']
						        ) {
						            obj.down("fieldset").setVisible(false);
						        }

						        obj.getForm().getFields().each(function(field) {
						            field.on('change', function() {
						                var form = obj.getForm(),
						                    searchBtn = obj.down('#lessonPlanSearchBtn'),
						                    disable = false;

						                form.getFields().each(function(f) {
						                    if (f.allowBlank === false && Ext.isEmpty(f.getValue())) {
						                        disable = true;
						                        return false; 
						                    }
						                });

						                if (searchBtn) {
						                    searchBtn.setDisabled(disable);
						                }
						            });
						        });
						    }
					},
					
					'lessonplanningfilter multiselectcombofield#multiselectAcademyLocationId': {
						render: function(obj) {
                            var form = this.getLessonplanningfilter().getForm();
                            var userId = this.getCurrentlyLoggedInUser().id;
                            var academyLocationfield = form.findField('multiselectAcademyLocation');
                            var multiselectAcademyLocation=this.getCurrentAcademyLocation();
                            var store = obj.getStore();
                            
                            store.getProxy().extraParams = {
                                id: userId
                            };
                            store.load({
                                callback: function(record){
                                    academyLocationfield.setValue(multiselectAcademyLocation);
                                }
                            });
                        },
                          change: function(ob, rec) {
                            var filter = this.getLessonplanningfilter();
                            var form = filter.getForm();
                            var academyLocationId = ob.up('form').down('#multiselectAcademyLocationId').getValue();
                            var alIds = [];
                            var academyLocationIds;
                            if (academyLocationId != undefined && academyLocationId.length > 0 && academyLocationId[0] != "") {
                                for (var i in academyLocationId) {
                                    if (Ext.isObject(academyLocationId[0])) {
                                        alIds.push(academyLocationId[i].get("id"));
                                    } else {
                                        alIds.push(academyLocationId[i]);
                                    }
                                }
                                academyLocationIds = alIds.join();
                            } else {
                                alIds.push(this.getCurrentAcademyLocation());
                                academyLocationIds = alIds.join();
                            }
                               var academicTerm = ob.up('form').down('#academicTerm');
		            	    	academicTerm.reset();
		            		   var academicTermStore = academicTerm.getStore();
		            		  academicTermStore.getProxy().extraParams = {
		            		            academyLocationIds  : academyLocationIds
                                 };
		            		        academicTermStore.load();
		            		       var searchBtn = filter.down('#lessonPlanSearchBtn');
		            		       
		            		       if(form.isValid()==false)
		            		       {
		            		    	   searchBtn.setDisabled(true);
		            		       }
		            		       else
		            		       {
		            		    	   searchBtn.setDisabled(false);
		            		       }
                              },
					},
					'lessonplanningfilter button[itemId=lessonPlanResetBtn]' : {
						click : function(){
							var form = this.getLessonplanningfilter();
							var multiSelectAL = form.down('#multiselectAcademyLocationId');
							var searchBtn = form.down('#lessonPlanSearchBtn');
							searchBtn.setDisabled(true);
							var courseCategoryId = form.down('#courseCategory');
							courseCategoryId.setDisabled(true);
							var courseItemId = form.down('#courseItemId');
							courseItemId.setDisabled(true);
							var courseProgramId = form.down('#program_Id');
							courseProgramId.setDisabled(true);
							var termId = form.down('#termId');
							termId.setDisabled(true);
							var unittitleId = form.down('#unittitleId');
							unittitleId.setDisabled(true);
							var facultyId = form.down('#facultyId');
							facultyId.setDisabled(true);
							var objectiveId = form.down('#objectiveId');
							objectiveId.setDisabled(true);
							var durationId = form.down('#durationId');
							durationId.setDisabled(true);
							var courseVariantId = form.down('#courseVariantId');
							courseVariantId.setDisabled(true);
							var sectionGroupBatchId = form.down('#sectionGroupBatchId');
							sectionGroupBatchId.setDisabled(true);
							var period_Id = form.down('#period_Id');
							period_Id.setDisabled(true);
							form.getForm().reset();
							multiSelectAL.setValue(null);
							 var multiselectAcademyLocation=this.getCurrentAcademyLocation();
	                            var store = multiSelectAL.getStore();

	                            store.getProxy().extraParams = {
	                                id: userId
	                            };
	                            store.load({
	                                callback: function(record){
	                                	multiSelectAL.setValue(multiselectAcademyLocation);
	                                }
	                            });
						}
					},
					'lessonplanningfilter button[itemId=lessonPlanSearchBtn]' : {
						click : this.loadGridAndSearchLessonPlan
					},

					'lessonplanningfilter customcombobox[itemId=academicTerm]': {
						select: function(obj, record) {
							var academicTermId = record[0].get("id");
							var form = this.getLessonplanningfilter();
							var searchBtn = form.down('#lessonPlanSearchBtn');
							//searchBtn.setDisabled(false);
							var courseCategory = form.down('#courseCategory');
							courseCategory.reset();
							courseCategory.setDisabled(false);
							var courseItemId = form.down('#courseItemId');
							courseItemId.reset();
							courseItemId.setDisabled(false);
							var courseProgramId = form.down('#program_Id');
							courseProgramId.reset();
							courseProgramId.setDisabled(false);
							var termId = form.down('#termId');
							termId.setDisabled(false);
							var unittitleId = form.down('#unittitleId');
							unittitleId.setDisabled(false);
							var faculty = form.down('#facultyId');
							faculty.setDisabled(false);
							var objectiveId = form.down('#objectiveId');
							objectiveId.setDisabled(false);
							var durationId = form.down('#durationId');
							durationId.setDisabled(false);
							var courseVariant=form.down('#courseVariantId');
							var batch=form.down('#sectionGroupBatchId');
							var period=form.down('#period_Id');
							courseVariant.reset();
							batch.reset();
							period.reset();
							faculty.reset();
							courseVariant.setDisabled(true);
							batch.setDisabled(true);
							period.setDisabled(true);
							var loggedInfacultyId = null;
							var portalId = this.getCurrentLoggedPortalId();
							  var academyLocationId = form.down('#multiselectAcademyLocationId').getValue();
	                            var alIds = [];
	                            var academyLocationIds;
	                            if (academyLocationId != undefined && academyLocationId.length > 0 && academyLocationId[0] != "") {
	                                for (var i in academyLocationId) {
	                                    if (Ext.isObject(academyLocationId[0])) {
	                                        alIds.push(academyLocationId[i].get("id"));
	                                    } else {
	                                        alIds.push(academyLocationId[i]);
	                                    }
	                                }
	                                academyLocationIds = alIds.join();
	                            } else {
	                                alIds.push(this.getCurrentAcademyLocation());
	                                academyLocationIds = alIds.join();
	                            }
							var facultyStore=faculty.getStore();
							if(portalId == 2) {
								loggedInfacultyId=this.getCurrentlyLoggedInUser().id;
								facultyStore.getProxy().extraParams = {
									facultyId:loggedInfacultyId
								};
								facultyStore.load({
									callback: function(record1, operation, success) {
										if (success) {
											faculty.setValue(loggedInfacultyId);
										}
									}
								})
							}else{
								facultyStore.getProxy().extraParams = {};
								facultyStore.load();
							}

							var courseStore = courseItemId.getStore();
							courseStore.getProxy().extraParams = {
								academicTermId: academicTermId,
								academyLocationIds: academyLocationIds,
								facultyId :loggedInfacultyId
							};
							courseStore.load();

							var programStore = courseProgramId.getStore();
							programStore.getProxy().extraParams = {
								academicTermId: academicTermId,
								academyLocationIds:academyLocationIds,
								facultyId :loggedInfacultyId,
								courseId:0

							};
							programStore.load();
							var termStore = termId.getStore();
							termStore.load();
						}
					},
					'lessonplanningfilter customcombobox[itemId=courseCategory]': {
						select: function(obj, record) {
							var courseCategoryId = record[0].get("id");
							var form = this.getLessonplanningfilter();
							var academicTermId = form.down('#academicTerm').getValue();
							var courseItemId = form.down('#courseItemId');
							var loggedInfacultyId = null;
							var portalId = this.getCurrentLoggedPortalId();
							var academyLocationId = this.getCurrentAcademyLocation();
							var courseStore = courseItemId.getStore();
							if(portalId == 2) {
								loggedInfacultyId=this.getCurrentlyLoggedInUser().id;
							}
							courseStore.getProxy().extraParams = {
								academicTermId: academicTermId,
								academyLocationId: academyLocationId,
								facultyId :loggedInfacultyId,
								courseCategoryId:courseCategoryId
							};
							courseStore.load();
						}
					},
					'lessonplanningfilter customcombobox[itemId=courseItemId]': {
						select: function(obj, record) {
							var form = this.getLessonplanningfilter();
							var academicTermId = form.down("#academicTerm").getValue();
							var courseVariantId = form.down('#courseVariantId');
							var facultyFilterField = form.down('#facultyId');
							courseVariantId.setDisabled(false);
							var courseId=record[0].data.courseId;
							var store = courseVariantId.getStore();
							store.getProxy().extraParams = {
								courseId: courseId,
								academicTermId:academicTermId,
								isCurrentPeriod : true
							};
							var facultyStore=facultyFilterField.getStore();
							facultyStore.getProxy().extraParams = {};
							facultyStore.getProxy().extraParams = {
								courseId: courseId
							};
							store.load();
							facultyStore.load();
						}
					},
					'lessonplanningfilter customcombobox[itemId=courseVariantId]': {
						select: function(obj, record) {
							var form = this.getLessonplanningfilter();
							var facultyFilterField = form.down('#facultyId');
							var facultyStore = facultyFilterField.getStore();
							var courseId = form.down('#courseItemId').getValue();
							var courseVarientId=record[0].data.id;
							facultyStore.getProxy().extraParams = {};
							facultyStore.getProxy().extraParams = {
								courseId:courseId,
								courseVariantId: courseVarientId
							};
							facultyStore.load();
						}
					},
					'lessonplanningfilter customcombobox#program_Id' : {
						select : function(obj, record) {
							var programId = record[0].get("id");
							var form = this.getLessonplanningfilter();
							var sectionGroupBatchId = form.down('#sectionGroupBatchId');
							sectionGroupBatchId.setDisabled(false);
							var batchComboBox = this.getLessonplanningfilter().down('customcombobox#sectionGroupBatchId');
							batchComboBox.clearValue();
							//	batchComboBox.setDisabled(false);
							var batchStore = batchComboBox.getStore();
							batchStore.getProxy().extraParams = {
								id: programId
							};
							batchStore.load();
						}
					},
					'lessonplanningfilter customcombobox#sectionGroupBatchId' : {
						select : function(obj, record) {
							var batch_Id = record[0].get("id");
							var form = this.getLessonplanningfilter();
							var period_Id = form.down('#period_Id');
							period_Id.setDisabled(false);
							var academicTermId = this.getLessonplanningfilter().down("#academicTerm").getValue();
							var periodComboBox = this.getLessonplanningfilter().down('customcombobox#period_Id');
							periodComboBox.clearValue();
							var periodStore = periodComboBox.getStore();
							periodStore.getProxy().extraParams = {
								id: batch_Id,
								academicTermId : academicTermId
							};
							periodStore.load();
						}
					},
					'lessonplanningfilter customcombobox#period_Id' : {
						select : function(obj, record) {
							var period_Id = record[0].get("id");
							var store = this.getStore('attendance.SectionAndFacultyByPeriodID');
							store.getProxy().extraParams = {
								periodId:period_Id
							};
							store.load();
						}
					},
					/*'lessonplanningfilter customcombobox#termId' : {
                			select : function(obj, record) {
                				var planId = record[0].get("id");
                				var form = this.getLessonplanningfilter();
                				var unitTitle=form.down('#unittitleId');
                				var store = unitTitle.getStore();
                				store.getProxy().extraParams = {
                					planId:planId
                				};
                				store.load();
                			}
                		},*/
					'lessonplanningcopywindow customcombobox[itemId=fromAcademicTermId]': {
						select: function(obj, record) {
							var academicTermId = record[0].get("id");
							var alinfomodel = Academia.model.authentication.ALInfoModel;
							var wheatherSchool = alinfomodel.get('wheatherSchool');
							var form = this.getLessonplanningcopywindow();
							var academyLocationId = form.down('#fromAcademyLocationId').getValue();
							var courseItemId = form.down('#courseItemId');
							var courseVariantId = form.down('#courseVariantId');
							var unittitleId = form.down('#unittitleId');
							var topics = form.down('#topics');
							var termId = form.down('#termId');
							courseItemId.setDisabled(false);
							var portalId = this.getCurrentLoggedPortalId();
							var facultyId = null;
							if(portalId == 2) {
								facultyId=this.getCurrentlyLoggedInUser().id;
							}
							courseItemId.reset();
							courseVariantId.reset();
							unittitleId.reset();
							topics.reset();
							termId.reset();
							var courseStore = this.getStore('lessonplan.CoursesByAcademicTermForLessonPlanStore');
							courseStore.getProxy().extraParams = {
								academicTermId: academicTermId,
								academyLocationId: academyLocationId,
								facultyId: facultyId,
								wheatherSchool : wheatherSchool
							};
							courseStore.load();

						}
					},

					'lessonplanningcopywindow customcombobox[itemId=courseItemId]': {
						select: function(obj, record) {
							var form = this.getLessonplanningcopywindow();
							var courseVariantId = form.down('#courseVariantId');
							var fromAcademicTermCombo = form.down('#fromAcademicTermId');
							var unitTitleCombo = form.down('#unittitleId');
							var academicTermId = fromAcademicTermCombo.getValue();
							var academyLocationId = form.down('#fromAcademyLocationId').getValue();
							var newtopics= form.down('#newtopics');
							var texttermId=form.down('#texttermId');
							var courseId=record[0].data.courseId;
							courseVariantId.setDisabled(false);
							unitTitleCombo.setDisabled(false);
							var unitTitleStore = unitTitleCombo.getStore();
							var store = courseVariantId.getStore();
							store.getProxy().extraParams = {
								courseId: courseId,
								academicTermId:academicTermId,
								isCurrentPeriod : true,
								academyLocationId: academyLocationId
							};
							store.load();
							
							unitTitleStore.getProxy().extraParams = {
								courseId: courseId,
								academicTermId:academicTermId,
								academyLocationId: academyLocationId
							};
							unitTitleStore.load();
							form.down('#topics').reset();
							form.down('#termId').reset();
							newtopics.reset();
							texttermId.reset();
						}
					},
					'lessonplanningcopywindow customcombobox[itemId=courseVariantId]': {
						select: function(obj, record) {
							var form = this.getLessonplanningcopywindow();
							var unittitleId = form.down('#unittitleId');
							var topics = form.down('#topics');
							var term = form.down('#termId');
							var newtopics= form.down('#newtopics');
							var texttermId=form.down('#texttermId');
							unittitleId.setDisabled(false);
							var courseVariantId=record[0].data.id;
							var store = this.getStore('lessonplan.LessonPlanUnitTitleStore');
							var topicStore = topics.getStore();
							var termStore = term.getStore();
							topics.reset();
							topics.clearValue();
							term.reset();
							topics.clearValue();
							topics.setDisabled(true);
							term.setDisabled(true);
							
							store.getProxy().extraParams = {
								courseVariantId: courseVariantId

							};
							store.load({
								callback: function(record, operation, success) {
									if (success) {
										if (record.length == 1) {
											unittitleId.setValue(record[0].data.id);
											topics.setDisabled(false);
											topicStore.getProxy().extraParams = {
												planId: record[0].data.id

											};
											topicStore.load({
												callback:function(record, operation, success){
													if(success){
														if(record.length==1){
															term.setDisabled(false);
															topics.setValue(record[0].data.id);
															if(!newtopics.isDisabled() && topics.getDisplayValue()!=undefined ){
																newtopics.setValue(topics.getDisplayValue());
															}
															termStore.getProxy().extraParams = {
																planId: record[0].data.id

															};
															termStore.load({
																callback:function(record, operation, success){
																	if(success){
																		if(record.length==1){
																			term.setValue(record[0].data.id);
																			if(!texttermId.isDisabled() && term.getDisplayValue()!=undefined ){
																				texttermId.setValue(term.getDisplayValue());
																				}
																		}
																	}
																}
															});

														}
													}
												}
											});


										}
									}
								}

							});
						}
					},

					'lessonplanningcopywindow customcombobox[itemId=unittitleId]': {
						select: function(obj, record) {
							var planId=record[0].data.id;
							var form = this.getLessonplanningcopywindow();
							var courseVariantId = form.down('#courseVariantId').getValue();
							var topics = form.down('#topics');
							var term = form.down('#termId');
							var newtopics= form.down('#newtopics');
							var texttermId=form.down('#texttermId');
							var unittitle = form.down('#unittitleId').valueModels[0].raw.value;
							topics.setDisabled(false);
							topics.reset();
							topics.clearValue();
							term.reset();
							topics.clearValue();
							var store = this.getStore('lessonplan.LessonPlanTopicStore');
							var termStore = term.getStore();

							store.getProxy().extraParams = {
								planId: record[0].data.id
							};
							store.load({
								callback:function(record, operation, success){
									if(success){
										if(record.length==1){
											term.setDisabled(false);
											topics.setValue(record[0].data.id);
											if(!newtopics.isDisabled() && topics.getDisplayValue()!=undefined ){
												newtopics.setValue(topics.getDisplayValue());
											}
											termStore.getProxy().extraParams = {
												planId: record[0].data.id

											};
											termStore.load({
												callback:function(record, operation, success){
													if(success){
														if(record.length==1){
															term.setValue(record[0].data.id);
															if(!texttermId.isDisabled() && term.getDisplayValue()!=undefined ){
																texttermId.setValue(term.getDisplayValue());
																}
														}
													}
												}
											});

										}
									}
								}
							});
						}
					},
					'lessonplanningcopywindow customcombobox[itemId=topics]': {
						select: function(obj, record) {
							var form = this.getLessonplanningcopywindow();
							var planId=record[0].data.id;
							var courseVariantId = form.down('#courseVariantId').getValue();
							var termId = form.down('#termId');
							var topic = form.down('#topics').valueModels[0].raw.value;
							termId.setDisabled(false);
							termId.clearValue();
							var store = this.getStore('lessonplan.LessonPlanTermStore');
							store.getProxy().extraParams = {
								planId:planId

							};
							store.load();
						}
					},
					'lessonplanningcopywindow customcombobox[itemId=toAcademicTermId]': {
						select: function(obj, record) {
							var academicTermId = record[0].get("id");
							var form = this.getLessonplanningcopywindow();
							var newcourseId = form.down('#newcourseId');
							newcourseId.reset();
							newcourseId.setDisabled(false);
							var newcourseVariant = form.down('#newcourseVariantId');
							newcourseVariant.reset();
							var academyLocationId = this.getCurrentAcademyLocation();
							var facultyId = null;
							if(portalId == 2) {
								facultyId=this.getCurrentlyLoggedInUser().id;
							}
							var courseStore = newcourseId.getStore();
							courseStore.getProxy().extraParams = {
								academicTermId: academicTermId,
								academyLocationId: academyLocationId,
								facultyId :facultyId
							};
							courseStore.load();

						}
					},
					/* 'lessonplanningcopywindow customcombobox[itemId=newcourseId]': {
              				 select: function(obj, record) {
              					 var courseId=record[0].data.courseId;
              					var form = this.getLessonplanningcopywindow();
               					var newcourseVariantId = form.down('#newcourseVariantId');
               					newcourseVariantId.setDisabled(false);
               					form.down('#facultyId').reset();
              					 var store = this.getStore('course.coursevariants.NewCourseVariantStore');
          	        		     store.getProxy().extraParams = {
          	        			   courseId: courseId,
          	        			   isCurrentPeriod : true
          	        		   };
        	 					store.load();
              				 }
              			 },
              			 /*'createeditlessonplanningdetails radiogroup[itemId=isSubObjectiveID]': {
              				change: function(elm, newValue, oldValue, eOpts) {
              					 this.lessionPlanSubObjectiveChange(elm, newValue, oldValue, eOpts);
              				 }
              			 },*/
					/*'createeditlessonplanningdetails radiogroup[itemId=isSubObjectiveRadioItemId]': {
              				change: function(elm, newValue, oldValue, eOpts) {
              					 this.lessionPlanSubObjectiveEditChange(elm, newValue, oldValue, eOpts);
              				 }
              			 },*/


					/* 'createeditlessonplanningdetails button[action=addButtonLessionPlan]':{
              				 click: function(addButton) {
              					 this.addMoreDetailedLessionPlan(addButton);
              				 }
              			 },
              			'createeditlessonplanningdetails button[action=addButtonLessionPlan1]':{
             				 click: function(addButton) {
             					 this.addMoreDetailedLessionPlanNew(addButton);
             				 }
             			 },*/
					/*'createeditlessonplanningdetails button[itemId=btnCancelLessonPlan]': {
              				 click: this.closeLessonPlanDetailTab
              			 },*/

					/*'createeditlessonplanningdetails button[itemId=lessionPlanDetailedDeleteBtn1]':{
              				 click : function(deleteButton) {
              					 this.deleteMoreDetailedLessionPlan(deleteButton)
              				 }
		        		 },*/
					'lessonplanningcopywindow customcombobox[itemId=newcourseId]': {
						select: function(obj, record) {
							var loggedInAcademyLocationId = this.getCurrentAcademyLocation();
							var courseId=record[0].data.courseId;
							var form = this.getLessonplanningcopywindow();
							var newtopics = form.down('#newtopics');
							var texttermId = form.down('#texttermId');

							var newcourseVariantId = form.down('#newcourseVariantId');
							var academicTermId = form.down('#toAcademicTermId').getValue();
							var facultyCombo = form.down('#facultyId');
							var topicValue=form.down('#topics').getDisplayValue();
							var termValue=form.down('#termId').getDisplayValue();
							
							newcourseVariantId.setDisabled(false);
							facultyCombo.setDisabled(false);
							newcourseVariantId.reset();
							facultyCombo.reset();
							var facultyStore = facultyCombo.getStore();
							
							var store = newcourseVariantId.getStore();
							
							facultyStore.getProxy().extraParams = {
								id:loggedInAcademyLocationId
							};
							
							facultyStore.load();
							
							store.getProxy().extraParams = {
								courseId: courseId,
								academicTermId : academicTermId,
								isCurrentPeriod : true
							};
							store.load({
								callback: function(record, operation, success) {
									if (success) {
										if (record.length == 1) {
											newcourseVariantId.setValue(record[0].data.id);
										}
										newtopics.setDisabled(false);
										texttermId.setDisabled(false);
										if(!form.down('#newtopics').isDisabled() && topicValue!=undefined ){
											newtopics.setValue(topicValue);
										}
										if(!form.down('#texttermId').isDisabled() && termValue!=undefined ){
										texttermId.setValue(termValue);
										}
									}
								}

							});
						}
					},
					'lessonplanningcopywindow multiselectcombofield[itemId=newcourseVariantId]': {
						blur: function(obj, record) {
							var form = this.getLessonplanningcopywindow();
							var newtopics = form.down('#newtopics');
							newtopics.setDisabled(false);
							var texttermId = form.down('#texttermId');
							texttermId.setDisabled(false);
							var faculty = form.down("#facultyId");
							faculty.setDisabled(false);
							var topicValue=form.down('#topics').getDisplayValue();
							var termValue=form.down('#termId').getDisplayValue();
							if(!form.down('#newtopics').isDisabled() && topicValue!=undefined ){
								newtopics.setValue(topicValue);
							}
							if(!form.down('#texttermId').isDisabled() && termValue!=undefined ){
							texttermId.setValue(termValue);
							}
							// form.down('#btnSubmit').setDisabled(false);
							var portalId = this.getCurrentLoggedPortalId();
							var facultyId = null;
							if(portalId == 2) {
								facultyId=this.getCurrentlyLoggedInUser().id;
								form.down("#facultyId").setValue(facultyId);
							}
						}
					},
					'lessonplanningcopywindow customcombobox[itemId=facultyId]': {
						select: function(obj, record) {
							var courseId=record[0].data.courseId;
							var form = this.getLessonplanningcopywindow();
							var newtopics = form.down('#newtopics');
							newtopics.setDisabled(false);
							var texttermId = form.down('#texttermId');
							texttermId.setDisabled(false);
							var topicValue=form.down('#topics').getDisplayValue();
							var termValue=form.down('#termId').getDisplayValue();
							if(!form.down('#newtopics').isDisabled() && topicValue!=undefined ){
								newtopics.setValue(topicValue);
							}
							if(!form.down('#texttermId').isDisabled() && termValue!=undefined ){
							texttermId.setValue(termValue);
							}
						}
					},
					
					'lessonplanningcopywindow customcombobox[itemId=fromAcademyLocationId]': {
						render: function(obj) {
                            var form = this.getLessonplanningcopywindow()
                            var userId = this.getCurrentlyLoggedInUser().id;
                            var academyLocationfield = form.down('#fromAcademyLocationId');
                            var academyLocation=this.getCurrentAcademyLocation();
                            var store = obj.getStore();

                            store.getProxy().extraParams = {
                                id: userId
                            };
                            store.load({
                                callback: function(record){
                                    academyLocationfield.setValue(academyLocation);
                                }
                            });
                        },
                        change: function(ob, rec) {
                            var filter = this.getLessonplanningcopywindow();
                            var academyLocationId = ob.up('form').down('#fromAcademyLocationId').getValue();
                            var fromAcademicTerm = ob.up('form').down('#fromAcademicTermId');
                            var course = ob.up('form').down('#courseItemId');
                            var courseVariant = ob.up('form').down('#courseVariantId');
                            var unitTitle = ob.up('form').down('#unittitleId');
                            var topics = ob.up('form').down('#topics');
                            var term = ob.up('form').down('#termId');
                            fromAcademicTerm.reset();
                            course.reset();
                            courseVariant.reset();
                            unitTitle.reset();
                            topics.reset();
                            term.reset();
                            course.setDisabled(true);
                            courseVariant.setDisabled(true);
                            unitTitle.setDisabled(true);
                            topics.setDisabled(true);
                            term.setDisabled(true);
	            		   var fromAcademicTermStore = fromAcademicTerm.getStore();
	            		   fromAcademicTermStore.getProxy().extraParams = {
	            			  academyLocationId  : academyLocationId
                             };
	            		   fromAcademicTermStore.load();

                        }
                        
					},
					'lessonplanningcopywindow customcombobox[itemId=toAcademyLocationId]': {
						render: function(obj) {
                            var form = this.getLessonplanningcopywindow()
                            var userId = this.getCurrentlyLoggedInUser().id;
                            var academyLocationfield = form.down('#toAcademyLocationId');
                            var academyLocation=this.getCurrentAcademyLocation();
                            var store = obj.getStore();
                            
                            store.getProxy().extraParams = {
                                id: userId
                            };
                            store.load({
                                callback: function(record){
                                    academyLocationfield.setValue(academyLocation);
                                }
                            }); 
                        },
                        
					},
					/*'createeditlessonplanningdetails button[itemId=lessionPlanSubmitAddAndNewButtonId]' : {
               			 click : this.objectionFieldAdd
               		 },
               		'createeditlessonplanningdetails button[itemId=lessionPlanSubmitAddAndNewButtonId1]' : {
              			 click : this.objectionFieldAddNew
              		 },*/
					/*'createeditlessonplanningdetails customcombobox[name=objectiveId]' : {
               			 change : function(combo, newValue, oldValue, eOpts){
               				 this.onChagneObjectiveCombo(combo, newValue, oldValue, eOpts)
               			 },
               			 focus: function(combo, e, eOpts) {
          					 combo.lastQuery = null;
          				 },
          				 afterrender: function( combo, eOpts ) {
          					 var me = this;
          					 combo.getStore().on('beforeload', function(){
          						 this.getProxy().extraParams = {
          							 ids: me.getAllSelectedIds(combo)
          						 };
          					 });
          				 } 
               		 },*/
					/*'createeditlessonplanningdetails customcombobox[itemId=objectiveComboItemId]' : {
               			 focus: function(combo, e, eOpts) {
               				 if(combo.name!="objectiveId"){
                   				 combo.lastQuery = null;
               				 }
               			 },
               			 afterrender: function( combo, eOpts ) {
               				 var me = this;
               				 if(combo.name!="objectiveId"){
               					 combo.getStore().on('beforeload', function(){
               						this.getProxy().extraParams = {
               							ids: me.getAllSelectedIds(combo)
               						 };
               					 });
               				 }
               			 }
               		 },*/
					/*'createeditlessonplanningdetails customcombobox[name=subOjective]' : {
               			 focus: function(combo, e, eOpts) {
               				combo.lastQuery = null;
               			 },
               			 afterrender: function( combo, eOpts ) {
               				 var me = this;
               				 combo.getStore().on('beforeload', function(){
           						this.getProxy().extraParams = {
           							ids: me.getAllSelectedIds(combo)
           						 };
           					 });
               			 }
               		 },*/
					/*'createeditlessonplanningdetails customcombobox[itemId=subOjectiveItemId]' : {
               			 focus: function(combo, e, eOpts) {
               				 if(combo.name!="subOjective"){
                   				 combo.lastQuery = null;
               				 }
               			 },
               			 afterrender: function( combo, eOpts ) {
               				 var me = this;
               				 if(combo.name!="subOjective"){
               					 combo.getStore().on('beforeload', function(){
               						this.getProxy().extraParams = {
               							ids: me.getAllSelectedIds(combo)
               						 };
               					 });
               				 }
               			 }
               		 },*/
					/*'createeditlessonplanningdetails button#lessionPlanUploadDocs' : {
               			 click : function() {
               				 this
               				 .getDocumentController()
               				 .showDocumentFormWindow(
               						 'creatEditLessonPlanDetailItemId',
               				 'DOCUMENT');
               			 }
               		 },*/
					/*'documentformwindow[itemId=creatEditLessonPlanDetailItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentFormSubmitButtonId' : {
               			 click : function() {
               				 var $this = this;
               				 var isTransient = true;
               				 var module = 'lessonPlanning';
               				 var entityId;
               				 var entityType = 'lessonPlanningDocument';

               				 $this
               				 .getDocumentController()
               				 .saveDocumentForm(
               						 entityId,
               						 module,
               						 entityType,
               						 'DOCUMENT',
               						 function(success,
               								 response,
               								 isCallBackTransient) {
               							 var documentModel = new Academia.model.course.CourseDocument();
               							 documentModel
               							 .set(
               									 "documentName",
               									 response.name);
               							 documentModel
               							 .set(
               									 "path",
               									 response.path);
               							 documentModel
               							 .set(
               									 "type",
               									 response.type);
               							 documentModel
               							 .set(
               									 "documentName",
               									 response.name);
               							 documentModel.set("createdBy", $this.getIdValueJson(response.createdBy.id, response.createdBy.value));
               							 var lessonPlanDocGrid = $this
               							 .getLessonplanningdocumentgrid();
               							 var store = lessonPlanDocGrid
               							 .getStore();
               							 store
               							 .add(documentModel);
               							 if (lessonPlanDocGrid.isHidden() && store.data.items.length > 0) {
               								 lessonPlanDocGrid.setVisible(true);
               							 }
               							 $this.getDocumentController().closeDocumentFormWindow();
               							 showSuccessMessage(getProgramandcourseTranslation('Lesson Planning'),getProgramandcourseTranslation('Document added successfully'));

               						 }, isTransient);
               			 }
               		 },*/
					/*'lessonplanningdocumentgrid': {
               			 cellclick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts) {
               				 var $this = this;
               				 var documentGrid = $this.getLessonplanningdocumentgrid();
               				 var columnName = documentGrid.columnManager.columns[cellIndex].dataIndex;

               				 if (columnName == "documentName") {
               					 if (e.target.tagName == 'A') {
               						 var documentId = record.get("documentId");
               						 if (!isNullOrEmpty(documentId)) {
               							 $this.getDocumentController().downloadDocumentFile(documentId);
               						 }
               					 }
               				 }
               			 }
               		 },*/
					/*'documentformwindow[itemId=creatEditLessonPlanDetailItemId] simpledocumentform[itemId=simpleDocumentForm] button#documentCancelButtonId' : {
               			 click : function() {
               				 this.getDocumentController()
               				 .closeDocumentFormWindow();
               			 }
               		 },*/
					/*'lessonplanningdocumentgrid button#btnDelete' : {
               			 click : function() {
               				 var $this = this;
               				 var grid = $this
               				 .getLessonplanningdocumentgrid();
               				 if (grid.getSelectionModel().getCount() > 0) {
               					 Ext.MessageBox
               					 .confirm(getProgramandcourseTranslation('Lesson Planning'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
               							 function(btn,text) {
               						 if (btn == 'yes') {
               							 var store = grid.getStore();
               							 Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
               							 var record = grid.getSelectionModel().getSelection()[0];
               							 var id = record.get("id");
               							 if (!isNullOrEmpty(id)) {
               								 Ext.Ajax
               								 .request({
               									 method : "DELETE",
               									 type : 'rest',
               									 url : SERVERURL.LESSON_PLAN_DOCUMENT_DELETE
               									 + '?id='
               									 + id,
               									 headers : {
               										 'Content-Type' : 'application/json'
               									 },
               									 success : function(
               											 form,
               											 action) {
               										 Ext.getBody().unmask();
               										 store.reload();
               										 showSuccessMessage(
               												 getProgramandcourseTranslation('Lesson Plan'),
               												 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
               									 }
               								 });
               							 }else{
               								 if (record) {
               									 store.remove(record);
               									 showSuccessMessage(
               											 getProgramandcourseTranslation('Lesson Plan'),
               											 getCommonTranslation('DOCUMENT_SUCCESS_MSG'));
               								 }
               								 Ext.getBody().unmask();
               							 }

               						 }
               					 });
               				 } else {
               					 showWarningMessage(
               							 getProgramandcourseTranslation('Lesson Plan'),
               							 getCommonTranslation('PLEASE_SELECT_RECORD')); // Please
               					 // select
               					 // a
               					 // record
               				 }
               			 }
               		 },*/
					/*'lessonplandocumentgriddownload button[itemId=downloadDocumentItemId]':{
          				click:function(obj){
          					this.downloadAllLessonDocumentFormsZip();
          				}
          			}*/

				});
			},
			/*downloadAllLessonDocumentFormsZip:function(){
		       		    	var $this=this;
		       		    	var grid=$this.getLessonplandocumentgriddownload();
		       		    	var records = grid.getStore().data.items;
		       		    	var saveModel=[];  
		       		    	var dispatchZipName = "Lesson PLan Documnet";
		       		    	for(var i in records){
		       		    		if(!isNullOrEmpty(records[i].get('path'))) {
		       		    			saveModel.push(records[i].get('path'));
		       		    		}
		       		    	}
		       		    	showConfirmMessage(getProgramandcourseTranslation('LESSON_PLAN_DOCUMENTS'),getProgramandcourseTranslation('LESSON_PLAN_DOCUMENTS_ALERT'),function(btn, text) {
		       		    		if (btn == 'yes') {
		       		    			var directoryType = CONSTANTS.DIRECTORY_TYPE_JASPER;
		       		    			$this.getDocumentController().downloadMultipleDocumentFile(saveModel, dispatchZipName, directoryType);
		       		    		}});

		       		    },*/
		       		    
		    'lessonplanningcopywindowform' : {
				render: function(obj){
					var me = this;
					var form = me.getLessonplanningcopywindow();	
					var fromAcademicTermId = form.down('#fromAcademicTermId');
					var fromAcademicTermIdStore = fromAcademicTermId.getStore();
					fromAcademicTermIdStore.load();
				}
			},
		       		    
			showLessonplanningcopywindow: function() {
				var formWindow = this.getLessonplanningcopywindow();
				if (!formWindow) {
					Ext.widget('lessonplanningcopywindow');
					formWindow = this.getLessonplanningcopywindow();
				}
				formWindow.show();
				var fromAcademicTermId = formWindow.down('#fromAcademicTermId');
				var fromAcademicTermIdStore = fromAcademicTermId.getStore();
				fromAcademicTermIdStore.load();
			},

			openNewCmpTab: function() {
				var me = this;
				var contentpanel = me.getContentPanel();
				//var lessongrid = Ext.widget('createeditlessonplanningdetails');
				var lessongrid = Ext.widget('lessonplanningdetailsform');
				var tabName = getCommonTranslation('LESSON_PLAN_DETAILS');
				var getcontroller=this.getController('menu.CoreERPNavigationController');
				var getTab=getcontroller.getTab(tabName);
				if(getTab!=null){
					contentpanel.remove(getTab, true);
				}
				openTab(contentpanel, tabName, lessongrid,CONSTANTS.MENU_COLOR_THREE);
				//var form = me.getCreateeditlessonplanningdetails();
				var form = me.getLessonplanningdetailsform();
				var faculty = form.down('#lessonPlanFacultyItemId');
				faculty.getStore().getProxy().extraParams = {};
				var facultyId = null;
				if (me.getCurrentLoggedPortalId() == 2) {
					facultyId = this.getCurrentlyLoggedInUser().id;
					faculty.getStore().load({
						callback: function(record1, operation, success) {
							if (success) {
								faculty.setValue(facultyId);
							}
						}
					})
				}
			},

			lessonPlanningCopySave:function() {
				var $this = this;
				$this.applyWindowMask();
				var grid = $this.getLessonplanninggrid();

				var form = $this.getLessonplanningcopywindow();
				var fromAcademicTermId = form.down('#fromAcademicTermId').getValue();
				var courseId = form.down('#courseItemId').getValue();
				var courseVariantId = form.down('#courseVariantId').getValue();
				var unitTitle = form.down('#unittitleId').getValue();
				var topics = form.down('#topics').getValue();
				var term = form.down('#termId').getValue();
				var toAcademicTermId = form.down('#toAcademicTermId').getValue();
				var newcourseId = form.down('#newcourseId').getValue();
				var newcourseVariantId = form.down('#newcourseVariantId').getValue();
				var facultyId = form.down('#facultyId').getValue();
				var newtopics = form.down('#newtopics').getValue();
				var newterm = form.down('#texttermId').getValue();
				
				var lessonPlanStaffIds = [];
				if(facultyId && typeof facultyId == "number"){
					facultyId = [facultyId];
				}
     			if(facultyId && facultyId.length){
     				 var filteredFaculty = Ext.Array.filter(facultyId, function(item){
     			        return item && item !== " ";
     			    });
     			    if(!filteredFaculty.length){
     			        return;
     			    }
     				var staffIds = '';
     				if(typeof filteredFaculty[0] == "object"){
     					staffIds = Ext.Array.pluck(Ext.Array.pluck(filteredFaculty,'data'),'id');
     				}
     				else{
     			        if (Ext.isArray(filteredFaculty)){
     			            staffIds = filteredFaculty;
     			        }else if (Ext.isString(filteredFaculty)){
     			            staffIds = filteredFaculty.split(',');
     			        }
     			    }
     				
     				if(staffIds.length && !isNullOrEmpty(staffIds[0])){
     					Ext.each(staffIds, function(currentStaffId){
     						lessonPlanStaffIds.push({
     							"id":null,
     						//	"lessonPlan":null,
     							"staff" : $this.getIdValueJson(currentStaffId)
     						});
     					});
     				}
     			}

				var lessonPlan = new Academia.model.lessonplan.CopyLessonPlanModel();

				lessonPlan.set("fromAcademicTerm",this.getIdValueJson(fromAcademicTermId));
				lessonPlan.set("course",this.getIdValueJson(courseId));
				lessonPlan.set("courseVariant",this.getIdValueJson(courseVariantId));
				lessonPlan.set("unitTitle",unitTitle);
				lessonPlan.set("topics",topics);
				lessonPlan.set("term",term);
				lessonPlan.set("toAcademicTerm",this.getIdValueJson(toAcademicTermId));
				lessonPlan.set("newCourse",this.getIdValueJson(newcourseId));
				lessonPlan.set("lessonPlanStaffs",lessonPlanStaffIds);
				lessonPlan.set("newtopics",newtopics);
				lessonPlan.set("newterm",newterm);

				if(newcourseVariantId && typeof newcourseVariantId == "number"){
					newcourseVariantId = [newcourseVariantId];
				}
				var courseVariants = newcourseVariantId;
				var lessonPlanCourseVariants =[];
				if(courseVariants !=undefined && courseVariants.length > 0 && courseVariants[0] != ""){
					for(var i in courseVariants){
						var cvId = "";
						if(Ext.isObject(courseVariants[0])){
							cvId = courseVariants[i].get("id");
						}else{
							cvId = courseVariants[i];
						}
						lessonPlanCourseVariants.push({
							"id":null,
							"lessonPlan":null,
							"courseVariant" : this.getIdValueJson(cvId)
						});
					}
				}
				lessonPlan.set("lessonPlanCourseVariants",lessonPlanCourseVariants);
				var loggedInAcademyLocationId = this.getCurrentAcademyLocation();
				lessonPlan.set("academyLocationId",loggedInAcademyLocationId);
				lessonPlan.set("isbypassCheck",false);
				var formData = Ext.encode(lessonPlan.data);
				Ext.Ajax.request({
					type : 'rest',
					url : SERVERURL.LESSON_PLAN_COPY,
					timeout: 9000000,// 15 min
					method : 'POST',
					jsonData : formData,
					success : function(form, action) {
						if(form.responseText == 'SUCCESS'){
							$this.hideWindowMask();
							showSuccessMessage(getCommonTranslation('Lesson'),getCommonTranslation('Lesson Plan Copied Successfully'));
							$this.getLessonplanningcopywindow().close();
							grid.getSelectionModel().deselectAll(true);
							grid.getStore().load();
						}
						
							else if(form.responseText == 'REFERENCE_PROGRAM_MSG')
							{lessonPlan.set("isbypassCheck",true);
							$this.getLessonplanningcopywindow().close();
							$this.hideWindowMask();
							var formData = Ext.encode(lessonPlan.data);
							 showConfirmMessage(getProgramandcourseTranslation('COPY_LESSON_PLANNING'),getProgramandcourseTranslation('REFERENCE_PROGRAM_MSG'),function(btn,text){
								 if (btn == 'yes') {
									 Ext.Ajax.request({
										 type : 'rest',
										 url : SERVERURL.LESSON_PLAN_COPY,
										 timeout: 9000000,// 15 min
										 method : 'POST',
										 jsonData : formData,
										 success : function(form, action) {
											 if(form.responseText == 'SUCCESS'){
												 $this.hideWindowMask();
												 showSuccessMessage(getCommonTranslation('Lesson'),getCommonTranslation('Lesson Plan Copied Successfully'));
												 grid.getSelectionModel().deselectAll(true);
												 grid.getStore().load();
											 }
											 else{
												 showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); 
											 }
										 }
									 });
								 }
                    		 });
						
							}
						else{
							$this.hideWindowMask();
							showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); 
						}
					}
				});
			},
			
			lessonPlanningBulkCopySave:function() {
				 var $this = this;
				 var grid = this.getLessonplanninggrid();
				 if (grid.getSelectionModel().getCount() > 0) {
					 var records = grid.getSelectionModel().getSelection();
				 }
				var form= this.getLessonplanbulkcopywindow();
				 var academicLocation = form.down('#academicLocationId').getValue();
					var academicTerm = form.down('#academicTermId').getValue();
					
					//var lessonPlan = new Academia.model.lessonplan.CopyLessonPlanModel();
					
					//lessonPlan.set("academyLocationId",academicLocation);
					//lessonPlan.set("academicTermId",academicTerm);
					//var formData = Ext.encode(lessonPlan.data);
					var lessonPlanIds = Ext.Array.pluck(Ext.Array.pluck(records,'data'),'id').join();
					Ext.Ajax.request({
						type : 'rest',
						url : SERVERURL.BULK_LESSON_PLAN_COPY+'?lessonPlanIds='+ lessonPlanIds+ '&academyLocationId=' + academicLocation + '&academicTermId=' + academicTerm,
						timeout: 9000000,// 15 min
						method : 'POST',
					//	jsonData : formData,
						success : function(form, action) {
							if(form.responseText == 'SUCCESS'){
								$this.hideWindowMask();
								showSuccessMessage(getProgramandcourseTranslation('LESSON_PLAN'),getProgramandcourseTranslation('BULK_LESSON_PLAN_COPIED_SUCCESSFULLY'));
								$this.getLessonplanbulkcopywindow().close();
							}else if (form.responseText.includes("PARTIALY_SUCCESS")) {
							    // If it contains PARTIALLY_SUCCESS, remove it
							    var newResponseText = form.responseText.replace("PARTIALY_SUCCESS", "").trim();
							    var responseText = newResponseText.split("Course Lesson plan already available").join(getProgramandcourseTranslation('COURSE_LESSON_PLAN_ALREADY_AVAILABLE'));
							    var responseTextFinal = responseText.split("Course not mapped in academic term").join(getProgramandcourseTranslation('COURSE_NOT_MAPPED_IN_ACAEMIC_TERM'));
							    showWarningMessage(getCommonTranslation('ALERT'),responseTextFinal);
							    $this.getLessonplanbulkcopywindow().close();
							}else{
								$this.hideWindowMask();
								showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); 
								$this.getLessonplanbulkcopywindow().close();
							}
						}
					});
			},

			/*resetLessonplanningfilter : function(){
             		     var form = this.getLessonplanningfilter();
             			form.getForm().reset();

             		},*/
			loadGridAndSearchLessonPlan : function(){
				var $this = this;
				
				var academyLocationId = this.getCurrentAcademyLocation();
				var getForm = $this.getLessonplanningfilter();
				getForm.down('#lessonPlanSearchBtn').setDisabled(true);
				var form = getForm.getForm();
				var academicLocationField=form.findField("multiselectAcademyLocation").getValue();
				  var academicLocation=[];
                  var academicLocationIds;
                  if(typeof academicLocationField == "number"){
                      academicLocation.push(academicLocationField);
              academicLocationIds=academicLocation.join();
                     
                    }


                    if(academicLocationField !=undefined && academicLocationField.length > 0){
                                    for(var i in academicLocationField){
                                        if(Ext.isObject(academicLocationField[0].data)==1){
                                            academicLocation.push(academicLocationField[i].data.id);
                                        }else{
                                            academicLocation.push(academicLocationField[i].data.id);
                                        }
                                    }
                                    academicLocationIds = academicLocation.join();
                                }
				var grid = $this.getLessonplanninggrid();

				var lessonPlanningCourseDescriptorBtn =grid.down('#courseDescriptorReportsId');
				var lessonPlanningAssessmentMapBtn =grid.down('#assessmentMapReportsId');
				
				lessonPlanningCourseDescriptorBtn.setDisabled(true);
				lessonPlanningAssessmentMapBtn.setDisabled(true);
				
				var values = form.getValues();
				var portalId = this.getCurrentLoggedPortalId();
				var facultyId = null;
				if(portalId == 2) {
					facultyId=this.getCurrentlyLoggedInUser().id;
				}else
				{
					var facultyId = values.facultyId;
				}
				var academicTermId = values.academicTerm;
				var courseId = values.courseItemId;
				var courseVariantId = values.courseVariantId;
				var programId = values.program_Id;
				var batchId = values.sectionGroupBatchId;
				var periodId = values.period_Id;
				var term = values.termId;
				var unittitle = values.unittitleId;
				var objectiveId = values.objectiveId;
				var durationId = values.durationId;
				var courseCategoryId=values.courseCategory;
				var store = grid.getStore();
				store.getProxy().api.read=SERVERURL.LESSON_PLAN;
				store.getProxy().extraParams = {	
					academicTermId :academicTermId,
					courseId : courseId,
					courseVariantId : courseVariantId,
					programId : programId,
					batchId : batchId,
					periodId : periodId,
					term : term,
					unittitle :unittitle,
					facultyId : facultyId,
					objectiveId : objectiveId,
					durationId : durationId,
					academyLocationId:academicLocationIds,
					sort:null,
					courseCategoryId:courseCategoryId
				};
				store.getProxy().timeout=300000;
				this.resetPageSetting(store);
				store.load({
					   callback: function(record, operation, success) {
						   getForm.down('#lessonPlanSearchBtn').setDisabled(false);   
					   }
				   });
				grid.getSelectionModel().deselectAll(true);
				grid.config.searchFilterForm = $this.getLessonplanningfilter();
			},
			/*addLessonPlanData:function(){

             			var $this = this;
             			var form = $this.getCreateeditlessonplanningdetails().getForm();
             			var formValues = form.getValues();

             			var lessonPlan = new Academia.model.lessonplan.LessonPlanModel();
             			lessonPlan.set("id",formValues.id);
             			lessonPlan.set("academicTerm",this.getIdValueJson(formValues.academicTerm));
             			lessonPlan.set("course",this.getIdValueJson(formValues.courseItemId));
             			lessonPlan.set("staff",this.getIdValueJson(formValues.facultyId));
             			lessonPlan.set("unitTitle",formValues.unitTitle);
             			lessonPlan.set("topics",formValues.topics);
             			lessonPlan.set("aim",formValues.aim);
             			lessonPlan.set("term",formValues.term);
             			lessonPlan.set("dateOfPlan",formValues.dateOfPlanning);
             			lessonPlan.set("preRequisites",formValues.prerequisite);
             			lessonPlan.set("lessonPlanDuration",this.getIdValueJson(formValues.durationId));
             		//	lessonPlan.set("objDesc",formValues.objDesc);
             			var courseVariants = formValues.courseVariantId;
             			var lessonPlanCourseVariants =[];
             			if(courseVariants !=undefined && courseVariants.length > 0 && courseVariants[0] != ""){
             				for(var i in courseVariants){
             					var cvId = "";
             					if(Ext.isObject(courseVariants[0])){
             						cvId = courseVariants[i].get("id");
             					}else{
             						cvId = courseVariants[i];
             					}
             					lessonPlanCourseVariants.push({
             						"id":null,
             						"lessonPlan":this.getIdValueJson(formValues.id),
             						"courseVariant" : this.getIdValueJson(cvId)
             					});
             				}
             			}

             			var objectivePnl = $this.getCreateeditlessonplanningdetails().down('#objectivePnl'),
             			objectiveItems = objectivePnl.items;
             			if(objectiveItems.length>0){
             				var lessonPlanObjectives =[];

             				for(var i=0; i<objectiveItems.length; i++){

             					//subObjectivesLessionPlan
             					try{
             						var remark= objectiveItems.items[i].down('#objDescription').value;
             					}
             					catch(e){
             						try{
                 						var remark= objectiveItems.items[i].down('#objDescription'+i).value;
                 					}
                 					catch(e){
                 						var remark= objectiveItems.items[i].down('#objDescriptionItemId').value;
                 					}
             					}

             					try{
                 					var objective= objectiveItems.items[i].down('#objectiveId').getValue();
             					}
             					catch(e){
             						try{
                     					var objective= objectiveItems.items[i].down('#objectiveId'+i).getValue();
                 					}
                 					catch(e){
                     					var objective= objectiveItems.items[i].down('#objectiveComboItemId').getValue();
                 					}
             					}

             					try{
                 					isSubObjective = objectiveItems.items[i].down('#isSubObjectiveID').getValue();
             					}
             					catch(e){
             						try{
                     					isSubObjective = objectiveItems.items[i].down('#isSubObjectiveID'+i).getValue();
                 					}
                 					catch(e){
                     					isSubObjective = objectiveItems.items[i].down('#isSubObjectiveRadioItemId').getValue();
                 					}
             					}
             					isSubObjective = isSubObjective[Object.keys(isSubObjective)];

             					if(!isNullOrEmpty(isSubObjective) && isSubObjective == true){
             						var subObjectivesLessionPlan = [];
             						try{
             							if(i != 0){
             								var subObjectivePnl = objectivePnl.down('#subObjectivePnl'+i);
             							}
             							else{
             								var subObjectivePnl = objectivePnl.down('#subObjectivePnl');
             							}
             						}
             						catch(e){
             							var subObjectivePnl = objectivePnl.down('#subObjectivePnlItemId');
             						}
             						if(isNullOrEmpty(subObjectivePnl)){
             							try{
             								var subObjectivePnl = Ext.ComponentQuery.query('[name=objDesc'+i+']')[0].up('#objectiveContainerPanelItemId'+i).down('#subObjectivePnlItemId');
             							}
             							catch(e){
                 							var subObjectivePnl = objectivePnl.down('#subObjectivePnlItemId');
             							}
             						}
             						for(var j=0; j<subObjectivePnl.items.length; j++){
             							try{
                 							var subOjectiveVal= subObjectivePnl.items.items[j].down('customcombobox[name=subOjective]').getValue();
             							}
             							catch(e){
             								var subObjField = subObjectivePnl.items.items[j].down('#subOjectiveItemId');
                 							if(subObjField.getStore().find('value',subObjField.getValue())>=0){
                 								var subObjIndex = subObjField.getStore().find('value',subObjField.getValue());
                 								var subOjectiveVal= subObjField.getStore().getAt(subObjIndex).get('id');
                 							}
                 							else {
                 								var subOjectiveVal = subObjField.getValue();
                 							}
             							}

             							try{
                 							var subObjectiveDescVal= subObjectivePnl.items.items[j].down('textareafield[name=subObjectiveDesc]').getValue();
             							}
             							catch(e){
             								var subObjectiveDescVal= subObjectivePnl.items.items[j].down('#subObjectiveDescItemId').getValue();
             							}

             							var data ={
             								"remark": subObjectiveDescVal,
             								"subObjective": {
             									"id": subOjectiveVal,
             									"value" : subObjectiveDescVal
             								}
             							};
             							subObjectivesLessionPlan.push(data);

             						}
             						lessonPlanObjectives.push({
             							"lessonPlan": {
             								"id": formValues.id,
             								"value": "null"
             							},
             							"remark": remark,
             							"isSubObjectiveRequired": isSubObjective,
             							"id": null,
             							"objective": this.getIdValueJson(objective),
             							"lessonPlanSubObjectives":subObjectivesLessionPlan
             						})
             					}
             					else{
             						lessonPlanObjectives.push({
             							"lessonPlan": {
             								"id": formValues.id,
             								"value": "null"
             							},
             							"remark": remark,
             							"isSubObjectiveRequired": isSubObjective,
             							"id": null,
             							"objective": this.getIdValueJson(objective)
             						})
             					}
             				}
             			}

             			lessonPlan.set("lessonPlanObjectives",lessonPlanObjectives);
             			lessonPlan.set("lessonPlanCourseVariants",lessonPlanCourseVariants);
             		 	var docStore = $this.getStore('lessonplan.LessonPlanDocumentStore');
	                	   var docArray = [];
	                	   if (docStore.data.items != null
	                			   && docStore.data.items.length > 0) {
	                		   Ext.each(docStore.data.items, function(val) {
	                			   var type=null;
	                			   if(isNullOrEmpty(val.data.id) && isNullOrEmpty(val.data.documentId)){
	                			   if(isNullOrEmpty(val.data.type)){
	                				   type="DOCUMENT";
	                			   }else{
	                				   type=val.data.type;
	                			   }
	                			   var newData = {
	                					   "name" : val.data.documentName,
	                					   "path" : val.data.path,
	                					   "type" : type,
	                					   "createdBy" : $this.getIdValueJson(
	                							   val.data.createdBy.id,
	                							   val.data.createdBy.value),
	                					   "submissionDate" : Ext.Date.format(new Date(), CONSTANTS.DATE_FORMAT)            			  
	                					   };
	                			   docArray.push(newData);
	                			   }
	                		   });
	                	   }
	                	   lessonPlan.documents=docArray;
	                	   lessonPlan.document=  docArray[docArray.length-1];
	                	   lessonPlan.set("lessonPlanDocuments",docArray);
	                	   var formData = Ext.encode(lessonPlan.data);
	                	   if (isNullOrEmpty(formValues.id)) {
								var URL = SERVERURL.LESSON_PLAN_SAVE;
							} else {
								var URL = SERVERURL.LESSON_PLAN_UPDATE;
							}

             			Ext.Ajax.request({
             				type : 'rest',
             				url : URL,
             				timeout: 9000000,// 15 min
             				method : 'POST',
             				jsonData : formData,
             				success : function(form, action) {
             					if(form.responseText == 'SUCCESS'){
             						$this.hideWindowMask();
             						showSuccessMessage(getCommonTranslation('Lesson'),getCommonTranslation('Lesson Plan added successfully'));
            					}else if(form.responseText == "UPDATESECCUSS"){
            						$this.hideWindowMask();
             						showSuccessMessage(getCommonTranslation('Lesson'),getCommonTranslation('Lesson Plan Updated successfully'));             					
            					}
             					else{
             						$this.hideWindowMask();
             						showErrorMessage(getCommonTranslation('FAILURE'), getCommonTranslation('ERROR_MSG')); 
             					}
             				}
             			});
             			 this.closeLessonPlanDetailTab();
},*/
			deleteLessonPlanRecord:function(){
				var $this=this;
				var grid = $this.getLessonplanninggrid();
				if (grid.getSelectionModel().getCount() > 0) {
					var store = grid.getStore();
					//Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
					var record = grid.getSelectionModel().getSelection();
					if(record[0].data.isValidationRequired && record[0].data.whethePublished=='Published' && record[0].data.whetherValidated=='Validated'){
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PUBLISHED_AND_VALIDATED_LESSON_PLAN_CAN_NOT_BE_DELETED')); 
						//Ext.getBody().unmask();
						//grid.getStore().reload();
					}else{
						showConfirmMessage(
								getProgramandcourseTranslation('LESSON_PLANNING'),
								getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
								function(btn, text) {
									if (btn == 'yes') {
										Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
										var records = grid.getSelectionModel().getSelection();
										var ids = Ext.Array.pluck(Ext.Array.pluck(records,'data'),'id').join();
										Ext.Ajax.request({
											method : "DELETE",
											type : 'rest',
											url : SERVERURL.LESSON_PLAN_DELETE+'?ids='+ ids,
											headers : {
												'Content-Type' : 'application/json'
											},
											success : function(form,action) {
												Ext.getBody().unmask();
												grid.getStore().reload();
												showSuccessMessage(getProgramandcourseTranslation('LESSON_PLAN'),getProgramandcourseTranslation('LESSON_PLAN_DELETED_SUCCESSFULLY'));
											}

										});
									}
								});
					}		   
				} /*else if(grid.getSelectionModel().getCount() > 1){
	                	 		  showWarningMessage(getProgramandcourseTranslation('LESSON_PLAN'),getCommonTranslation('PLEASE_SELECT_ONLY_SINGLE_RECORD'));
	                 	   }*/ else {
	                 		   showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); 
	                 	   }
			},
			/*editLessonPlanRecord : function(isView){
	                	   var this$ = this;
	                	   var grid = this$.getLessonplanninggrid();
	                	   if (grid.getSelectionModel().getCount() > 0)
	                	   {
	                		   this$.openLessonPlanningEditWindow();
	                		   var editFormPanel = this$.getCreateeditlessonplanningdetails();
	                		   var editForm = editFormPanel.getForm();
	                		   var selectedRecord = grid.getSelectionModel().getSelection()[0];
	                		   if (!isNullOrEmpty(selectedRecord)) {
	                			   if (isView) {
	                				   editFormPanel.down('#lessionPlanSubmitAddAndNewButtonId').setVisible(false);
	                				   editFormPanel.down('#lessionPlanSubmitAddAndNewButtonId1').setVisible(false);
	                				   editFormPanel.down('#lessionPlanSubmitButtonId').setVisible(false);
	                				   editFormPanel.down('#lessionPlanUploadDocs').setVisible(false);
	                				   var course= editFormPanel.down('#courseItemId');
	                				   course.setDisabled(false);
	                				   var courseVariant= editFormPanel.down('#courseVariantId');
	                				   courseVariant.setDisabled(false);
	                				   var faculty= editFormPanel.down('#facultyId');
	                				   faculty.setDisabled(false);
	                				   unitTitle=editFormPanel.down('#unitTitleId');
	                      			   unitTitle.setDisabled(false);
	                      			   topic=editFormPanel.down('#topicId');
	                      			   topic.setDisabled(false);
	                      			   term=editFormPanel.down('#termId');
	                      			   term.setDisabled(false);
	                      			   duration=editFormPanel.down('#durationId');
	                      			   duration.setDisabled(false);
	                      			   aim=editFormPanel.down('#aimId');
	                      			   aim.setDisabled(false);
	                      			   prerequisite=editFormPanel.down('#prerequisiteId');
	                      			   prerequisite.setDisabled(false);
	                      			   objective=editFormPanel.down('#objectiveId');
	                      			   objective.setDisabled(false);
	                      			   isSubObjective=editFormPanel.down('#isSubObjectiveID');
	                      			   isSubObjective.setDisabled(false);
	                      			   objDescription=editFormPanel.down('#objDescription');
	                      			   objDescription.setDisabled(false);
	                				   toggleReadOnlyFormItems(editForm, true);
	                			   }
	                			   else {
	                				   editFormPanel.down('#lessionPlanSubmitAddAndNewButtonId').setVisible(false);
	                				   editFormPanel.down('#lessionPlanSubmitAddAndNewButtonId1').setVisible(true);
	                				   var course= editFormPanel.down('#courseItemId');
	                				   course.setDisabled(false);
	                				   var courseVariant= editFormPanel.down('#courseVariantId');
	                				   courseVariant.setDisabled(false);
	                				   var faculty= editFormPanel.down('#facultyId');
	                				   faculty.setDisabled(false);
	                				   unitTitle=editFormPanel.down('#unitTitleId');
	                      			   unitTitle.setDisabled(false);
	                      			   topic=editFormPanel.down('#topicId');
	                      			   topic.setDisabled(false);
	                      			   term=editFormPanel.down('#termId');
	                      			   term.setDisabled(false);
	                      			   duration=editFormPanel.down('#durationId');
	                      			   duration.setDisabled(false);
	                      			   aim=editFormPanel.down('#aimId');
	                      			   aim.setDisabled(false);
	                      			   prerequisite=editFormPanel.down('#prerequisiteId');
	                      			   prerequisite.setDisabled(false);
	                      			   objective=editFormPanel.down('#objectiveId');
	                      			   objective.setDisabled(false);
	                      			   isSubObjective=editFormPanel.down('#isSubObjectiveID');
	                      			   isSubObjective.setDisabled(false);
	                      			   objDescription=editFormPanel.down('#objDescription');
	                      			   objDescription.setDisabled(false);
	                			   }
	                		   }
	                		   Ext.Ajax.request({
	                			   type: 'rest',
	                			   url: SERVERURL.LESSON_PLAN_FINDBYID,
	                			   method: 'GET',
	                			   params:{
	                				   id:selectedRecord.get('id')
	                			   },
	                			   success: function(response, action) {
	                				   var data = response.responseText;
	                				   if(!isNullOrEmpty(data)) {
	                					   //-- decoding data from json to object
	                					   var jsonData=Ext.decode(data);

	                					   //-- getting CourseVarientId
	                					   var cvid =[];
	                					   if(jsonData.lessonPlanCourseVariants.length > 0){
	                						   for (var k in jsonData.lessonPlanCourseVariants){
	                							   cvid.push(jsonData.lessonPlanCourseVariants[k].courseVariant.id);
	                						   }
	                					   }
	                					   //--

	                					   //-- form fields
	                					   var formFieldId = editForm.findField('id');
	                					   var formFieldIdAcademicTerm=editForm.findField('academicTerm');
	                					   var formFieldIdCourse=editForm.findField('courseItemId');
	                					   var formFieldFaculty=editForm.findField('facultyId');
	                					   var formFieldDuration=editForm.findField('durationId');
	                					   var formFieldUnitTitle = editForm.findField('unitTitle');
	                					   var formFieldTerm = editForm.findField('term');
	                					   var formFieldTopics = editForm.findField('topics');
	                					   var formFieldAim = editForm.findField('aim');
	                					   var formFieldPrerequisite = editForm.findField('prerequisite');
	                					   var formFieldDateOfPlanning = editForm.findField('dateOfPlanning');
	                					   var formFieldCourseVariant=editForm.findField('courseVariantId');
	                					   var documentGrid = this$.getLessonplanningdocumentgrid();

	                					   //-- form field stores
	                					   var academicTermStore = formFieldIdAcademicTerm.getStore();
	                					   var courseStore = formFieldIdCourse.getStore();
	                					   var facultyStore = formFieldFaculty.getStore();
	                					   var durationStore = formFieldDuration.getStore();
	                					   var courseVariantStore = formFieldCourseVariant.getStore();
	                					   var documentStore=documentGrid.getStore();

	                					   //-- setting values in form fields
	                					   formFieldId.setValue(selectedRecord.get('id'));
	                					   formFieldUnitTitle.setValue(jsonData.unitTitle);
	                					   formFieldTerm.setValue(jsonData.term);
	                					   formFieldTopics.setValue(jsonData.topics);
	                					   formFieldAim.setValue(jsonData.aim);
	                					   formFieldPrerequisite.setValue(jsonData.preRequisites);
	                					   formFieldDateOfPlanning.setRawValue(dateRender(jsonData.dateOfPlan));
	                					   academicTermStore.load({
	                						   callback: function(record, operation, success) {
	                							   if (success) {
	                								   formFieldIdAcademicTerm.setValue(jsonData.academicTerm.id);
	                							   }
	                						   }
	                					   });
	                					   academyLocationIds=this$.getCurrentAcademyLocation();
	                					   courseStore.getProxy().extraParams = {
	                						   //limit:-1,
	                						   academicTermId:jsonData.academicTerm.id,
	                						   academyLocationId:academyLocationIds,
	                						   facultyId :null
	                    					};
	                					   courseStore.load({
	                						   params:{
	                							   'limit': -1,
	                							   "academicTermId" :jsonData.academicTerm.id,
	                							   "facultyId":null
	                						   },
                							   callback: function(record, operation, success) {
                								   if (success) {

                										   formFieldIdCourse.setValue(jsonData.course.id);   


                								   }
                							   }
	                					   });
	                					   facultyStore.getProxy().extraParams = {
	                						   //limit:-1,
	                						   'courseVariantId': cvid[0],
                							   "courseId" :jsonData.course.id
	                    					};
	                					   facultyStore.load({
	                						   callback: function(record, operation, success) {
	                							   if (success) {
	                								   formFieldFaculty.setValue(jsonData.staff.id);
	                							   }
	                						   }
	                					   });
	                					   durationStore.load({
	                						   callback: function(record, operation, success) {
	                							   if (success) {
	                								   formFieldDuration.setValue(jsonData.lessonPlanDuration.id);
	                							   }
	                						   }
	                					   });
	                					   courseVariantStore.load({
	                						   params:{
	                							   'limit': -1,
	                							   "courseId" :jsonData.course.id
	                						   },
                							   callback: function(records, operation, success) {
                								   if (success) {
                									   var cvs =[];
                									   if(jsonData.lessonPlanCourseVariants.length > 0){
                										   for (var k in jsonData.lessonPlanCourseVariants){
                											   cvs.push(jsonData.lessonPlanCourseVariants[k].courseVariant.id);
                										   }
                									   }
                									   formFieldCourseVariant.setValue(cvs);
                								   }
                							   }
	                					   });
	                                       documentStore.getProxy().extraParams = {
	                                           ID: selectedRecord.get('id')
	                                       };
	                                       documentStore.load();
	                					   documentGrid.setVisible(true);

	                					   //-- remove all pre-objectives from main objective panel
		                				   var objectivePnl = editFormPanel.down('#objectivePnl');
		                				   objectivePnl.removeAll();

		                				   //-- loading data for objective combo store
	                					   var objectiveStore = Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore');
	                					   objectiveStore.removeAll();
	                					   objectiveStore.load({
	                						   callback: function(record, operation, success) {
	                							   if (success) {
	                								   var currentRecordInc = 0;
	                								   this$.addLessionPlanObjectives(objectivePnl, jsonData.lessonPlanObjectives, currentRecordInc, objectiveStore, jsonData, isView); // adding through recursion
	                							   }
	                						   }
	                					   });
	                				   }
	                			   }
	                		   });
	                	   }
	                   },*/

			/*addLessionPlanObjectives: function(objectivePnl, lessonPlanObjectives, currentRecordInc, objectiveStore, jsonData, isView){
	                	   var me = this;
	                	   if(currentRecordInc<lessonPlanObjectives.length) {
	                		   var objectiveContainer = me.generateNewObjectiveContainerCode(currentRecordInc, objectiveStore);
	                		   objectivePnl.add(objectiveContainer);

	                		   setTimeout(function(){
	                			   var newAddedObj = objectivePnl.down('#objectiveContainerPanelItemId'+currentRecordInc);
	                			   newAddedObj.down('#objectiveComboItemId').setValue(jsonData.lessonPlanObjectives[currentRecordInc].objective.id);
	                			   newAddedObj.down('#objDescriptionItemId').setValue(jsonData.lessonPlanObjectives[currentRecordInc].remark);

	                			   var isSubObjective=newAddedObj.down('#isSubObjectiveRadioItemId');
	                			   if (jsonData.lessonPlanObjectives[currentRecordInc].isSubObjectiveRequired)
	    						   {
	                				   isSubObjective.items.items[0].setValue(true);
	    							   isSubObjective.items.items[1].setValue(false);

	    							   setTimeout(function(){
	    								   //--first subobjective will be added automatically on change event
	    								   var subOjectiveIdField = newAddedObj.down('[name=subObjective0]');
	                					   var subObjectiveDescIdField = newAddedObj.down('[name=subObjectiveDesc0]');
	                					   //subOjectiveIdField.setRawValue(lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives[0].subObjective.value);
	                					   subOjectiveIdField.setValue(lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives[0].subObjective.id);
	                					   subObjectiveDescIdField.setValue(lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives[0].remark);

	                					   //--continue adding more subobjectives from second subobjective
	    								   var subObjectivePnl = newAddedObj.down('#subObjectivePnlItemId');
	    								   var currentRecordSubInc = 1;
	    								   me.addLessonPlanSubObjectives(subObjectivePnl, lessonPlanObjectives[currentRecordInc].lessonPlanSubObjectives, currentRecordSubInc, isView);

	    								   me.checkAndValidateForm(objectivePnl.up('form')); //validating fields and setting button enable/disable manually

	    								   if(isView){
	    	                				   toggleReadOnlyFormItems(objectivePnl.up('form').getForm(), true);
	    	                			   }

	    	                			   //--increasing currentRecordInc value and calling this function again
	    	                			   currentRecordInc = currentRecordInc+1;
	    	                			   me.addLessionPlanObjectives(objectivePnl, lessonPlanObjectives, currentRecordInc, objectiveStore, jsonData, isView);

	    							   },300);

	    						   } else {
	    							   isSubObjective.items.items[0].setValue(false);
	    							   isSubObjective.items.items[1].setValue(true);

	    							   me.checkAndValidateForm(objectivePnl.up('form')); //validating fields and setting button enable/disable manually

		                			   //--increasing currentRecordInc value and calling this function again
		                			   currentRecordInc = currentRecordInc+1;
		                			   me.addLessionPlanObjectives(objectivePnl, lessonPlanObjectives, currentRecordInc, objectiveStore, jsonData, isView);
	    						   }
	                		   },300);
						   }
	                   },
	                   addLessonPlanSubObjectives: function(subObjectivePnl, lessonPlanSubObjectives, currentRecordSubInc, isView){
	                	   var me = this;
	                	   if(currentRecordSubInc<lessonPlanSubObjectives.length)
						   {
	                		   var addButton = subObjectivePnl.down('[action=addButtonLessionPlan1]');
	                		   var subObjectiveContainer = me.generateNewSubObjectiveContainerCode(currentRecordSubInc,lessonPlanSubObjectives[currentRecordSubInc].subObjective.id,lessonPlanSubObjectives[currentRecordSubInc].remark);

	                		   var panelItem = new Array();
							   panelItem.push(subObjectiveContainer);
							   subObjectivePnl.add(panelItem);

							   setTimeout(function(){
								   me.hideShowDetails(addButton,subObjectivePnl);
								   subObjectivePnl.doLayout();
								   me.checkAndValidateForm(subObjectivePnl.up('form')); //validating fields and setting button enable/disable manually

								   if(isView){
	                				   toggleReadOnlyFormItems(subObjectivePnl.up('form').getForm(), true);
	                			   }

								   currentRecordSubInc = currentRecordSubInc+1;
								   me.addLessonPlanSubObjectives(subObjectivePnl, lessonPlanSubObjectives, currentRecordSubInc, isView);
							   },300);
						   }
	                   },
	                   generateNewObjectiveContainerCode: function(newInc, objectiveStore){
	                	   var objectiveContainer = {
	                			   xtype:'panel',
	                			   itemId: 'objectiveContainerPanelItemId'+newInc,
	                			   collapsible : true,
	                			   collapsed: false,
	                			   style:{
	                				   marginBottom:'10px',
	                				   marginLeft:'0px',
	                				   marginTop:'0px'
	                			   },
	                			   title: 'Objective',	    	
	                			   items:[{
	                				   xtype: 'fieldcontainer',
	                				   width:'100%',
	                				   layout: {
	                					   type: 'hbox'
	                				   },
	                				   defaults :{
	                					   width: 226,
	                					   labelAlign:'top'
	                				   },
	                				   standardSubmit: false,
	                				   plugins:"formlabelrequired", 
	                				   items: [
	                					   {
	                						   xtype: 'customcombobox',
	                						   fieldLabel:getCommonTranslation('Objective') ,
	                						   name:'objectiveId'+newInc,
	                						   itemId: 'objectiveComboItemId', //objectiveId,
	                						   store:Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore'),
	                						   displayField:'value',
	                						   valueField: 'id',
	                						   forceSelection:false,
	                						   emptyText:getCommonTranslation('SELECT_TEXT'),
	                						   allowBlank: false
	                					   },
	                					   {
	                						   xtype : 'radiogroup',
	                						   fieldLabel : getCommonTranslation('IS_SUB_OBJECTIVE'),
	                						   name:'isSubObjective'+newInc,
	                						   itemId:'isSubObjectiveRadioItemId', //isSubObjectiveID
	                						   defaults: {
	                							   flex: 1
	                						   },
	                						   layout: 'hbox',
	                						   items: [{
	                								   boxLabel  :getCommonTranslation('YES') ,
	                								   name      : 'isSubObjective'+newInc,
	                								   inputValue: true
	                							   }, {
	                								   boxLabel  : getCommonTranslation('NO'),
	                								   name      : 'isSubObjective'+newInc,
	                								   inputValue: false,
	                								   checked:true
	                							   }
	                							]
	                					   }]
	                			   },
	                			   {
	                				   xtype: 'fieldcontainer',
	                				   width:'100%',
	                				   layout: {
	                					   type: 'hbox'
	                				   },
	                				   defaults :{
	                					   labelAlign:'top'
	                				   },
	                				   items: [
	                					   {
	                						   xtype: 'textareafield',
	                						   name: 'objDesc'+newInc,
	                						   flex:1,
	                						   itemId:'objDescriptionItemId', //objDescription	                
	                						   allowBlank: true,
	                						   maxLength: 10000
	                					   }]
	                			   },
	                			   {
	                				   xtype:'panel',
	                				   itemId:'subObjectivePnlItemId',

	                				   width:'100%',
	                				   hidden:true,
	                				   style:{
	                					   marginLeft:'0px',
	                					   marginTop:'0px'
	                				   },
	                				   items:[]
	                			   }]
	                	   };
	                	   return objectiveContainer;
	                   },*/
			/*generateNewSubObjectiveContainerCode: function(newSubInc,subObjectiveValue,subObjectiveDescValue){
	                	   var subObjectiveContainer = {
	                			   xtype:'panel',
	                			   width:'100%',
	                			   layout : {
	                				   type : 'vbox'
	                			   },
	                			   style:{
	                				   marginLeft:'0px',
	                				   marginTop:'0px'
	                			   },
	                			   items:[{
	                				   xtype : 'fieldcontainer',
	                				   defaults : {
	                					   labelAlign : 'top',
	                					   width:226
	                				   },
	                				   layout : {
	                					   type : 'hbox'
	                				   },
	                				   standardSubmit: false,
	                				   plugins:"formlabelrequired", 
	                				   items:[{
	                					   xtype: 'customcombobox',
	                					   name: 'subObjective'+newSubInc,
	                					   itemId: 'subOjectiveItemId', //subOjectiveId
	                					   fieldLabel: getProgramandcourseTranslation('Sub Objective'),
	                					   store:Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore'),
	                					   displayField:'value',
	                					   valueField:'id',
	                					   value:subObjectiveValue,
	                					   typeAhead:true,
	                					   forceSelection:false,
	                					   allowBlank: false/
	                				   }]
	                			   },{
	                				   xtype:'fieldcontainer',
	                				   width:'100%',
	                				   layout:{
	                					   type:'hbox'
	                				   },
	                				   items:[{
	                					   xtype: 'textareafield',
	                					   name: 'subObjectiveDesc'+newSubInc,
	                					   flex:2,
	                					   itemId:'subObjectiveDescItemId', //subObjectiveDescId
	                					   value:subObjectiveDescValue,
	                					   allowBlank: true,
	                					   maxLength: 10000
	                				   },{
	                					   xtype: 'button',
	                					   glyph: ICONGLYPH.DELETEGLYPH,
	                					   itemId: 'lessionPlanDetailedDeleteBtn1',
	                					   width: 'auto',
	                					   cls: 'CustomBodyBtnReject',
	                					   action: 'deleteButtonLessionPlanAction',
	                					   tooltip: getCommonTranslation('DELETETOOLTIP')
	                				   },{
	                					   xtype : 'button',
	                					   itemId: 'lessionPlandetailedBtn1',
	                					   width: 'auto',
	                					   cls: 'CustomBodyBtnSettings',
	                					   action: 'addButtonLessionPlan1',
	                					   text: getCommonTranslation('ADDBUTTONTEXT'),
	                					   tooltip: getCommonTranslation('ADD')
	                				   }]
	                			   }]
	                	   };
	                	   return subObjectiveContainer;
	                   },*/
			/*lessionPlanSubObjectiveEditChange:function(elm, newValue, oldValue, eOpts ){
	                	   var me = this;
	                	   var form = this.getCreateeditlessonplanningdetails(),
	                	   subObjectivePnl = elm.up('panel').down('#subObjectivePnlItemId');

	                	   var val = newValue[Object.keys(newValue)[0]];
	                	   if(!isNullOrEmpty(newValue) && val == true){
	                		   var panelItem = new Array();
	                		   var subObjectiveContainer = me.generateNewSubObjectiveContainerCode(0,null,'');
	                		   panelItem.push(subObjectiveContainer);
	                		   subObjectivePnl.add(panelItem);
	                		   subObjectivePnl.show();
	                	   }
	                	   else{
	                		   subObjectivePnl.removeAll();
	                		   subObjectivePnl.hide();
	                	   }
	                	   me.checkAndValidateForm(subObjectivePnl.up('form')); //validating fields and setting button enable/disable manually
	                   },*/
			/*objectionFieldAddNew:function(){
	                	   var $this = this;
	                	   var form = this.getCreateeditlessonplanningdetails();
	                	   var timeContiner = this.getCreateeditlessonplanningdetails().down('#objectivePnl');
	                	   var timeFieldsCount = timeContiner.items.length;
	                	   var panelItem = new Array();

	                	   var objectiveStore = Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore');
	                	   var objectiveContainer = $this.generateNewObjectiveContainerCode(timeFieldsCount, objectiveStore);
	                	   objectiveContainer.width = '97%';

	                	   panelItem.push({
	                		   xtype:'panel',
	                		   width:'100%',
	                		   layout:{
	                			   type:'hbox'
	                		   },
	                		   style:{
	                			   marginBottom:'0px',
	                			   left:'0px',
	                			   marginLeft:'0px',
	                			   marginTop:'0px'
	                		   },
	                		   items:[objectiveContainer,{
	                			   xtype : 'button',
	                			   itemId: 'timeBtnDelete1'+timeFieldsCount,
	                			   width:'3%',
	                			   glyph: ICONGLYPH.DELETEGLYPH,
	                			   cls: 'CustomBodyBtnReject',
	                			   margin:'10px 0 0 0',
	                			   action: 'deleteButtonLessionPlanAction',
	                			   tooltip: getCommonTranslation('DELETETOOLTIP'),
	                			   listeners:{
	                				   click:function(obj){
	                					   var container = obj.up('panel');
	                					   timeContiner.remove(container);
	                					   timeContiner.doLayout();
	                					   $this.checkAndValidateForm(timeContiner.up('form'));
	                				   }
	                			   }
	                		   }]
	                	   });

	                	   timeContiner.items.each(function(item, index, items) {
	                		   try{
	                			   if(item.getCollapsed() == false){
	                				   item.toggleCollapse(true);	 
	                			   }	
	                		   }
	                		   catch(e){
	                			   var pnlItem = item.items.items[0];
	                			   if(pnlItem.getCollapsed() == false){
	                				   pnlItem.toggleCollapse(true);	 
	                			   }	 	 
	                		   }
	                	   });
	                	   timeContiner.add(panelItem);
	                	   timeContiner.doLayout();
	                	   //this.hideShowSubjectMarksElement(timeContiner);

	                   },*/
			/*addMoreDetailedLessionPlanNew:function(addButton){
	                	   var $this = this;	 	            	
	                	   var detailedForm = $this.getCreateeditlessonplanningdetails();
	                	   var panelContiner = addButton.up('panel').up();
	                	   var currentRecordSubInc = panelContiner.items.length;

	                	   var subObjectiveContainer = $this.generateNewSubObjectiveContainerCode(currentRecordSubInc,null,'');

	                	   var panelItem = new Array();
	                	   panelItem.push(subObjectiveContainer);
	                	   panelContiner.add(panelItem);
	                	   $this.checkAndValidateForm(panelContiner.up('form'));
	                	   this.hideShowDetails(addButton,panelContiner);
	                	   panelContiner.doLayout();

	                   },*/
			/*checkAndValidateForm: function(form){
	                	   if(form.isValid()){
	                		   form.down('#lessionPlanSubmitButtonId').setDisabled(false);
	                	   }
	                	   else {
	                		   form.down('#lessionPlanSubmitButtonId').setDisabled(true);
	                	   }
	                   },*/
			getDownloadFileForLessonPlanDocument : function(documentId){

				if(!isNullOrEmpty(documentId)){
					var csvForm = Ext.create('Ext.form.Panel'); 
					csvForm.getForm().submit({
						target: '_blank',
						method:'GET',
						params :{
							access_token : Ext.Ajax.defaultHeaders.access_token
						},
						headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
						url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
						standardSubmit :true
					});
				}
			},

			openLessonPlanFacultyWin: function(view, rowIndex, record){
				var me = this;

				var storeData = record.data.facultyArray;
				var newStoreData = [];
				Ext.each(storeData, function(currentFac){
					newStoreData.push([currentFac]);
				});

				var newStore = Ext.create('Ext.data.ArrayStore', {
					fields: ["facultyName"],
					data: newStoreData
				});

				var lessonplanFacultyWin = Ext.create('Ext.window.Window', {
					alias: 'widget.lessonplanfacultywin',
					itemId: 'lessonplanFacultyWin',
					modal: true,
					resizable: false,
					autoScroll: true,
					frame: true,
					width: 630,
					minHeight: 290,
					height: 290,
					maxHeight : 370,
					title: getCommonTranslation('FACULTY_LIST'),
					items: [{
						xtype: 'grid',
						itemId: 'lessonplanFacultyGrid',
						store: newStore,
						style: {
							left: '0px !important',
							margin: '10px 0px !important'
						},
						margin:'10 0',
						border: true,
						autoScroll: true,
						viewConfig: {
							stripeRows: true
						},
						columns: [{
							header: getCommonTranslation('FACULTY_CODE'),
							dataIndex: 'facultyName',
							sortable: true,
							flex: .2
						}]
					}]
				});

				lessonplanFacultyWin.show();
			},

			linkNoOfLessonPlanDocuments: function(view, rowIndex, record) {
				var store=this.getStore('lessonplan.LessonPlanDocumentStore'); 
				var submitURL=SERVERURL.LESSON_PLAN_DOCUMENT_FIND_BY_ID;
				store.getProxy().api.read=submitURL;
				store.getProxy().extraParams = {
					ID: record.data.id
				};
				store.load();
				var formWindow = this.getLessonplandocumentlist();
				var ID = record.data.id;
				if (!formWindow) {

					var formWindow = Ext.widget('lessonplandocumentlist');
					/*formWindow.setHeight(180);
		                		  formWindow.setWidth(500);*/

					/*Ext.widget('lessonplandocumentlist');
		       		    		docWindow = this.getLessonplandocumentlist();*/
				}
				formWindow.show();
				formWindow.down('#courseName').setValue(record.data.courseCodeName);
				formWindow.down('#courseVariantName').setValue(record.data.courseVariantCode);
				/*var grid = this.getLessonplanningdocumentgrid();
		       		    	var store = grid.getStore();
		       		    	store.getProxy().extraParams = {
		       		    		ID: ID
		       		    	};
		       		    	store.load();
				 */		       		    },

				 addLessonRecordRecord:function(){
					 var contentPanel = this.getContentPanel(); //get hold of the content panel where we are adding all the tabs
					 var structure = Ext.widget('createeditlessonplanningdetails');
					 var tabName = getCommonTranslation('LESSON_PLAN_DETAILS');
					 /**
					  * This is to remove tab from content panel and open same tab again
					  */

					 var getcontroller=this.getController('menu.CoreERPNavigationController');
					 var getTab=getcontroller.getTab(tabName);
					 if(getTab!=null){
						 contentPanel.remove(getTab, true);
					 }
					 openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
					 // var documentStore=this.getStore('coursesessiondiary.CourseSessionDiaryDocument');
					 // documentStore.removeAll();
				 },

				 /*openLessonPlanningEditWindow: function(){
	                	   var contentPanel = this.getContentPanel();
	                	   var structure = Ext.widget('createeditlessonplanningdetails');
	                	   var tabName = getCommonTranslation('LESSON_PLAN_DETAILS');
	                	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	                	   var getTab=getcontroller.getTab(tabName);
	                	   if(getTab!=null){
	                		   contentPanel.remove(getTab, true);
	                	   }
	                	   openTab(contentPanel, tabName, structure,CONSTANTS.MENU_COLOR_THREE);
	                   },*/

				 /*lessionPlanSubObjectiveChange:function(elm, newValue, oldValue, eOpts ){
	                	 var form = this.getCreateeditlessonplanningdetails(),
	                	 subObjectivePnl = form.down('#subObjectivePnl');

	                	 if(!isNullOrEmpty(newValue) && newValue.isSubObjective == true){
	                		 subObjectivePnl.show();
	                	 }
	                	 else{
	                		 subObjectivePnl.hide();
	                	 }
	                 },*/

				 /**
				  * add dynamic fields in form 
				  */
				 /*addMoreDetailedLessionPlan:function(addButton){

	                	 var $this = this;	 	            	
	                	 var detailedForm = $this.getCreateeditlessonplanningdetails();            	
	                	 //var panelContiner = detailedForm.down('#subObjectivePnl');
	                	 var panelContiner = addButton.up('panel').up();

	                	 var panelItem = new Array();
	                	 panelItem.push({
	                		 xtype:'panel',
	                		 width:'100%',
	                		 layout : {
	                			 type : 'vbox'
	                		 },
	                		 style:{
	     	    				marginLeft:'0px',
	     	    				marginTop:'0px'
	     	    			},
	                		 items:[{
	                			 xtype : 'fieldcontainer',
	                			 defaults : {
	                				 labelAlign : 'top',
	                				 width:226
	                			 },
	                			 layout : {
	                				 type : 'hbox'
	                			 },
	                			 items:[{
	                				 xtype: 'customcombobox',
	                				 name: 'subOjective',
	                				 itemId: 'subOjectiveId',
	                				 fieldLabel: getProgramandcourseTranslation('Sub Objective'),
	                				 store:Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore'),
	                				 displayField:'value',
	                				 valueField:'id',
	                				 //allowBlank:false,
	                				 typeAhead:true,
	                				 forceSelection:false
	                			 }]
	                		 },{
	                			 xtype:'fieldcontainer',
	                			 width:'100%',
	                			 layout:{
	                				 type:'hbox'
	                			 },
	                			 items:[{
	                				 xtype: 'textareafield',
	                				 name: 'subObjectiveDesc',
	                				 //width:'100%',
	                				 flex:2,
	                				 //fieldLabel:getCommonTranslation('sub_Objective_Desc'),
	                				 itemId:'subObjectiveDescId',	                
	                				 allowBlank: true,
	                				 maxLength: 10000
	                			 },{
	                				 xtype: 'button',
	                				 glyph: ICONGLYPH.DELETEGLYPH,
	                				 itemId: 'lessionPlanDetailedDeleteBtn1',
	                				 width: 'auto',
	                				 cls: 'CustomBodyBtnReject',
	                				 action: 'deleteButtonLessionPlanAction',
	                				 tooltip: getCommonTranslation('DELETETOOLTIP'),
	                				 listeners:{
	                					 click:function(obj){
	                						 //var container = obj.up('fieldcontainer');

	                						 //$this.getMastertimetableDetailedwindow().getForm().isValid();
	                						 //$this.getMastertimetableDetailedwindow().down('#SubmitBtn').setDisabled(false);
	                					 }
	                				 }
	                			 },{
	                				 xtype : 'button',
	                				 itemId: 'lessionPlandetailedBtn1',
	                				 width: 'auto',
	                				 cls: 'CustomBodyBtnSettings',
	                				 action: 'addButtonLessionPlan',
	                				 text: getCommonTranslation('ADDBUTTONTEXT'),
	                				 tooltip: getCommonTranslation('ADD')
	                			 }]
	                		 }]
	                	 });

	                	 panelContiner.add(panelItem);
	                	 this.hideShowDetails(addButton,panelContiner);
	                	 panelContiner.doLayout();

	                 },*/

				 deleteMoreDetailedLessionPlan: function(deleteButton) {
					 var this$ = this;
					 var form = this.getCreateeditlessonplanningdetails();
					 //var timeSlotPanel = form.down('#subObjectivePnl');
					 var timeSlotPanel = deleteButton.up('panel').up();

					 var container = deleteButton.up('panel');

					 if (container != null && timeSlotPanel != null) {
						 if (timeSlotPanel.items.length > 1) {
							 timeSlotPanel.remove(container);
							 //this$.hideShowDetails(timeSlotPanel);
							 var lastPnl = timeSlotPanel.items.items[timeSlotPanel.items.length - 1];
							 lastPnl.down('button[cls=CustomBodyBtnSettings]').show();
						 }
					 }
					 try{
						 this$.checkAndValidateForm(timeSlotPanel.up('form'));
					 }
					 catch(e){
						 console.log('');
					 }
				 },
				 hideShowDetails: function(addButton, detailedPanel) {
					 var this$ = this;
					 var form = this.getCreateeditlessonplanningdetails();
					 addButton.hide();
				 },
				 loadCourseVariant : function(lessonPlanId){

					 if(!isNullOrEmpty(lessonPlanId)){
						 var csvForm = Ext.create('Ext.form.Panel'); 
						 csvForm.getForm().submit({
							 target: '_blank',
							 method:'GET',
							 params :{
								 access_token : Ext.Ajax.defaultHeaders.access_token
							 },
							 headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
							 url: SERVERURL.LESSON_PLAN_COURSE_VARIANT_LIST + lessonPlanId,
							 standardSubmit :true
						 });
					 }
				 },

				 getIdValueJson: function(id, value,code) {
					 if (id) return {
						 id: id,
						 value: value,
						 code: code
					 };
				 },
				 lessionPlanSubObjectiveChange:function(elm, newValue, oldValue, eOpts ){
					 var form = this.getCreateeditlessonplanningdetails(),
					 //subObjectivePnl = form.down('#subObjectivePnl');
					 subObjectivePnl = elm.up().up().down('#subObjectivePnl');
					 if(isNullOrEmpty(subObjectivePnl)){
						 subObjectivePnl = elm.up().up().down('#subObjectivePnl'+elm.name.split('isSubObjective')[1]);
					 }

					 var val = newValue[Object.keys(newValue)[0]];
					 if(!isNullOrEmpty(newValue) && val == true){
						 var panelItem = new Array();
						 panelItem.push({
							 xtype:'panel',
							 width:'100%',
							 layout : {
								 type : 'vbox'
							 },
							 style:{
								 marginLeft:'0px',
								 marginTop:'0px'
							 },
							 items:[{
								 xtype : 'fieldcontainer',
								 defaults : {
									 labelAlign : 'top',
									 width:226
								 },
								 layout : {
									 type : 'hbox'
								 },
								 items:[{
									 xtype: 'customcombobox',
									 name: 'subOjective',
									 itemId: 'subOjectiveId',
									 fieldLabel: getProgramandcourseTranslation('SUB_OBJECTIVE'),
									 displayField:'value',
									 valueField: 'id',
									 store:Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore'),
									 //allowBlank:false,
									 typeAhead:true,
									 forceSelection:false
								 }]
							 },{
								 xtype:'fieldcontainer',
								 width:'100%',
								 layout:{
									 type:'hbox'
								 },
								 items:[{
									 xtype: 'textareafield',
									 name: 'subObjectiveDesc',
									 //width:'100%',
									 flex:2,
									 //fieldLabel:getCommonTranslation('sub_Objective_Desc'),
									 itemId:'subObjectiveDescId',	                
									 allowBlank: true,
									 maxLength: 10000
								 },{
									 xtype: 'button',
									 itemId: 'lessionPlandetailedBtn',
									 width: 'auto',
									 cls: 'CustomBodyBtnSettings',
									 width: 'auto',
									 action: 'addButtonLessionPlan',
									 text: getCommonTranslation('ADDBUTTONTEXT'),
									 tooltip: getCommonTranslation('ADD'),
									 style:{
										 marginTop:'30px'
									 },
									 listeners:{
										 click:function(obj){
											 //var form = obj.up('form');
											 //form.down('#SubmitBtn').setDisabled(true);
										 }
									 }
								 }]
							 }]
						 });
						 subObjectivePnl.add(panelItem);
						 subObjectivePnl.show();
					 }
					 else{
						 subObjectivePnl.removeAll();
						 subObjectivePnl.hide();
					 }
				 },
				 objectionFieldAdd:function(){
					 var $this = this;
					 var form = this.getCreateeditlessonplanningdetails();
					 var timeContiner = this.getCreateeditlessonplanningdetails().down('#objectivePnl');
					 var timeFieldsCount = timeContiner.items.length;
					 var panelItem = new Array();

					 panelItem.push({
						 xtype:'panel',
						 width:'100%',
						 layout:{
							 type:'hbox'
						 },
						 style:{
							 marginBottom:'0px',
							 left:'0px',
							 marginLeft:'0px',
							 marginTop:'0px'
						 },
						 items:[{
							 xtype:'panel',
							 width:'97%',
							 collapsible : true,
							 collapsed: false,
							 style:{
								 marginBottom:'10px',
								 marginLeft:'0px',
								 marginTop:'0px'
							 },
							 title: 'Objective',
							 items:[{
								 xtype: 'fieldcontainer',
								 width:'100%',
								 layout: {
									 type: 'hbox'
								 },
								 defaults :{
									 width: 226,
									 labelAlign:'top'
								 },
								 items: [
									 {
										 xtype: 'customcombobox',
										 fieldLabel:getCommonTranslation('Objective') ,
										 name:'objectiveId',
										 itemId: 'objectiveId'+timeFieldsCount,
										 store:Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore'),
										 displayField:'value',
										 valueField: 'id',
										 forceSelection:false,
										 // emptyText:getCommonTranslation('SELECT_TEXT'),
										 allowBlank: false
									 },
									 {
										 xtype      : 'radiogroup',
										 fieldLabel : getCommonTranslation('IS_SUB_OBJECTIVE'),
										 itemId:'isSubObjectiveID' + timeFieldsCount,
										 name:'isSubObjective',
										 defaults: {
											 flex: 1
										 },
										 layout: 'hbox',
										 items: [
											 {
												 boxLabel  :getCommonTranslation('YES') ,
												 name      : 'isSubObjective' + timeFieldsCount,
												 inputValue: true
											 }, {
												 boxLabel  : getCommonTranslation('NO'),
												 name      : 'isSubObjective' + timeFieldsCount,
												 inputValue: false,
												 checked:true
											 }
											 ],
											 listeners:{
												 change: function(elm, newValue, oldValue, eOpts){

													 //var form = this.getCreateeditlessonplanningdetails(),
													 //subObjectivePnl = form.down('#subObjectivePnl');
													 subObjectivePnl = elm.up().up().down('#subObjectivePnl'+ timeFieldsCount);
													 subObjectivePnl.removeAll();

													 var val = newValue[Object.keys(newValue)[0]];
													 if(!isNullOrEmpty(newValue) && val == true){
														 var panelItem = new Array();
														 panelItem.push({
															 xtype:'panel',
															 width:'100%',
															 layout : {
																 type : 'vbox'
															 },
															 style:{
																 marginLeft:'0px',
																 marginTop:'0px'
															 },
															 items:[{
																 xtype : 'fieldcontainer',
																 defaults : {
																	 labelAlign : 'top',
																	 width:226
																 },
																 layout : {
																	 type : 'hbox'
																 },
																 standardSubmit: false,
																 plugins:"formlabelrequired", 
																 items:[{
																	 xtype: 'customcombobox',
																	 name: 'subOjective',
																	 itemId: 'subOjectiveId'+ timeFieldsCount,
																	 fieldLabel: getProgramandcourseTranslation('SUB_OBJECTIVE'),
																	 displayField:'value',
																	 valueField: 'id',
																	 store:Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore'),
																	 allowBlank:false,
																	 typeAhead:true,
																	 forceSelection:false
																 }]
															 },{
																 xtype:'fieldcontainer',
																 width:'100%',
																 layout:{
																	 type:'hbox'
																 },
																 items:[{
																	 xtype: 'textareafield',
																	 name: 'subObjectiveDesc',
																	 //width:'100%',
																	 flex:2,
																	 //fieldLabel:getCommonTranslation('sub_Objective_Desc'),
																	 itemId:'subObjectiveDescId'+ timeFieldsCount,	                
																	 allowBlank: true,
																	 maxLength: 10000
																 },{
																	 xtype: 'button',
																	 itemId: 'lessionPlandetailedBtnAddNew'+ timeFieldsCount,
																	 width: 'auto',
																	 cls: 'CustomBodyBtnSettings',
																	 width: 'auto',
																	 action: 'addButtonLessionPlan',
																	 text: getCommonTranslation('ADDBUTTONTEXT'),
																	 tooltip: getCommonTranslation('ADD'),
																	 style:{
																		 marginTop:'30px'
																	 },
																	 listeners:{
																		 click:function(obj){

																			 //var form = obj.up('form');
																			 //form.down('#SubmitBtn').setDisabled(true);
																		 }
																	 }
																 }]
															 }]
														 });
														 subObjectivePnl.add(panelItem);
														 subObjectivePnl.show();
														 subObjectivePnl.doLayout();
													 }
													 else{
														 subObjectivePnl.removeAll();
														 subObjectivePnl.hide();
													 }

												 }
											 }

									 }]
							 },
							 {
								 xtype: 'fieldcontainer',
								 width:'100%',
								 layout: {
									 type: 'hbox'
								 },
								 defaults :{
									 //width: 226,
									 labelAlign:'top'
								 },
								 items: [
									 {
										 xtype: 'textareafield',
										 name: 'objDesc',
										 flex:1,
										 //fieldLabel:getCommonTranslation('PRE-REQUISITE'),
										 itemId:'objDescription'+timeFieldsCount,	                
										 allowBlank: true,
										 maxLength: 10000
									 }]
							 },
							 {
								 xtype:'panel',
								 itemId:'subObjectivePnl'+timeFieldsCount,
								 layout : 'vbox',
								 width:'100%',
								 hidden:true,
								 style:{
									 marginLeft:'0px',
									 marginTop:'0px'
								 },
								 items:[]
							 }]
						 },{
							 xtype : 'button',
							 itemId: 'timeBtnDelete1'+timeFieldsCount,
							 width:'3%',
							 glyph: ICONGLYPH.DELETEGLYPH,
							 cls: 'CustomBodyBtnReject',
							 margin:'10px 0 0 0',
							 action: 'deleteButtonLessionPlanAction',
							 tooltip: getCommonTranslation('DELETETOOLTIP'),
							 listeners:{
								 click:function(obj){
									 var container = obj.up('panel');
									 timeContiner.remove(container);
								 }
							 }
						 }]
					 });

					 timeContiner.items.each(function(item, index, items) {
						 if(index == 0){
							 if(item.getCollapsed() == false){
								 item.toggleCollapse(true);	 
							 }	
						 }
						 else{
							 var pnlItem = item.items.items[0];
							 if(pnlItem.getCollapsed() == false){
								 pnlItem.toggleCollapse(true);	 
							 }	 	 
						 }

					 });
					 timeContiner.doLayout();
					 timeContiner.add(panelItem);
					 //this.hideShowSubjectMarksElement(timeContiner);

				 },
				 onChagneObjectiveCombo:function(combo, newValue, oldValue, eOpts){
					 var pnlTitle = combo.up('panel'),
					 store = combo.getStore(),
					 rec = store.getById(combo.getValue()),
					 titleText = rec.data.value;
					 pnlTitle.setTitle(titleText);
				 },
				 /*getDocumentController : function() {
	                	 var this$ = this;
	                	 return this$
	                	 .getController('Academia.controller.document.DocumentController');
	                 },*/
				 /*closeLessonPlanDetailTab:function(){
	                	   var tabName = getCommonTranslation('LESSON_PLAN_DETAILS');
	                	   var contentpanel = this.getContentPanel();
	                	   var getcontroller=this.getController('menu.CoreERPNavigationController');
	                	   var getTab=getcontroller.getTab(tabName);
	                	   if(getTab!=null){
	                		   contentpanel.remove(getTab, true);
	                	   }
	                   },*/
				 /*getAllSelectedIds: function(combo){
	                	   console.log(combo);
	                	   var ids = [];
	                	   //-- Getting objective fields data by name
	                	   Ext.each(Ext.ComponentQuery.query('[name=objectiveId]'), function(currentObj){
	                		   if(combo.getValue()!=currentObj.getValue() && !isNullOrEmpty(currentObj.getValue())){
	                			   ids.push(currentObj.getValue());
	                		   }
	                	   });

	                	   //-- Getting objective fields data by itemId
	                	   Ext.each(Ext.ComponentQuery.query('#objectiveComboItemId'), function(currentObj){
	                		   if(currentObj.name!="objectiveId" && combo.getValue()!=currentObj.getValue() && !isNullOrEmpty(currentObj.getValue())){
	                			   ids.push(currentObj.getValue());
	                		   }
	                	   });

	                	   //-- Getting sub-objective fields data by name
	                	   Ext.each(Ext.ComponentQuery.query('[name=subOjective]'), function(currentObj){
	                		   if(combo.getValue()!=currentObj.getValue() && !isNullOrEmpty(currentObj.getValue())){
	                			   ids.push(currentObj.getValue());
	                		   }
	                	   });

	                	   //-- Getting sub-objective fields data by itemId
	                	   Ext.each(Ext.ComponentQuery.query('#subOjectiveItemId'), function(currentObj){
	                		   if(currentObj.name!="subOjective" && combo.getValue()!=currentObj.getValue() && !isNullOrEmpty(currentObj.getValue())){
	                			   ids.push(currentObj.getValue());
	                		   }
	                	   });

	                	   return ids.join();

	                   }*/
				 generateLessonPlanReport: function() {
					 var $this = this;
					 var code = "LessonPlanReportModel";
					 var grid = this.getLessonplanninggrid();
					 if (grid.getSelectionModel().getCount() > 0) {
						 var records = grid.getSelectionModel().getSelection()[0];
						 var lessonPlanId = records.data.id;
						 var academyLocationId = this.getCurrentAcademyLocation();
						 var reportParams = new Object();
						 reportParams.LESSON_PLAN_ID = lessonPlanId;
						 reportParams.LESSON_PLAN_Label = getCommonTranslation('LESSON_PLAN');
						 reportParams.ACADEMY_LOCATION_ID=academyLocationId;
						 var exportUrl = SERVERURL.PATH_GENERATE_LESSON_PLAN_REPORT;
						 reportParams.headerName = getProgramandcourseTranslation('LESSON_PLAN_REPORT');
						 $this.exportJRXMLReport(code, reportParams, 'Lesson Plan Report', '.vnd.ms-excel', exportUrl);
					 } else {
						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					 }
				 },

				 generatePDFLessonPlanReport: function() {
					 var $this = this;
					 var code = "LESSON_PLAN_REPORT_MODEL_PDF";
					 var grid = this.getLessonplanninggrid();
					 if (grid.getSelectionModel().getCount() > 0) {
						 var records = grid.getSelectionModel().getSelection()[0];
						 var lessonPlanId = records.data.id;
						 var academyLocationId = this.getCurrentAcademyLocation();
						 var reportParams = new Object();
						 reportParams.LESSON_PLAN_ID = lessonPlanId;
						 reportParams.LESSON_PLAN_Label = getCommonTranslation('LESSON_PLAN');
						 reportParams.ACADEMY_LOCATION_ID=academyLocationId;
						 var exportUrl = SERVERURL.PATH_LESSON_PLAN_REPORT_PDF_DOWNLOAD;
						 reportParams.headerName = getProgramandcourseTranslation('LESSON_PLAN_REPORT');
						 $this.exportJRXMLReport(code, reportParams, 'Lesson Plan Report', '.pdf', exportUrl);
					 } else {
						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					 }
				 },
				 
				 generateLessonPlanAMReport: function() {
					 var $this = this;
					 var code = "ASSESSMENT_MAP_REPORT_LESSON_PLAN_EXCEL";
					 var grid = this.getLessonplanninggrid();
					 if (grid.getSelectionModel().getCount() > 0) {
						 var records = grid.getSelectionModel().getSelection();
						 var lessonPlanId = Ext.Array.pluck(Ext.Array.pluck(records,'data'),'id').join();
						 var academyLocationId = this.getCurrentAcademyLocation();
						 var reportParams = new Object();
						 reportParams.LESSON_PLAN_ID = lessonPlanId;
						 reportParams.LESSON_PLAN_Label = getCommonTranslation('LESSON_PLAN');
						 reportParams.ACADEMY_LOCATION_ID=academyLocationId;
						 var exportUrl = SERVERURL.PATH_GENERATE_ASSESSMENT_REPORT_EXCEL;
						 reportParams.headerName = getCommonTranslation('ASSESSMENT_MAP_REPORT');
						 $this.exportJRXMLReport(code, reportParams, 'Assessment Map Report', '.vnd.ms-excel', exportUrl);
					 } else {
						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					 }
				 },

				 generatePDFLessonPlanAMReport: function() {
					 var $this = this;
					 var code = "ASSESSMENT_MAP_REPORT_LESSON_PLAN_PDF";
					 var grid = this.getLessonplanninggrid();
					 if (grid.getSelectionModel().getCount() > 0) {
						 var records = grid.getSelectionModel().getSelection();
						 var lessonPlanId = Ext.Array.pluck(Ext.Array.pluck(records,'data'),'id').join();
						 var academyLocationId = this.getCurrentAcademyLocation();
						 var reportParams = new Object();
						 reportParams.LESSON_PLAN_ID = lessonPlanId;
						 reportParams.LESSON_PLAN_Label = getCommonTranslation('LESSON_PLAN');
						 reportParams.ACADEMY_LOCATION_ID=academyLocationId;
						 var exportUrl = SERVERURL.PATH_GENERATE_COURSE_DESCRIPTOR_REPORT_PDF;
						 reportParams.headerName = getCommonTranslation('ASSESSMENT_MAP_REPORT');
						 $this.exportJRXMLReport(code, reportParams, 'Assessment Map Report', '.pdf', exportUrl);
					 } else {
						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					 }
				 },
				 
				 generateLessonPlanCDReport: function(btn) {
					 var $this = this;
					 var code = btn.value;
					 var grid = this.getLessonplanninggrid();
					 if (grid.getSelectionModel().getCount() > 0) {
						 var records = grid.getSelectionModel().getSelection();
						 var lessonPlanId = Ext.Array.pluck(Ext.Array.pluck(records,'data'),'id').join();
						 var academyLocationId = this.getCurrentAcademyLocation();
						 var reportParams = new Object();
						 reportParams.LESSON_PLAN_ID = lessonPlanId;
						 reportParams.LESSON_PLAN_Label = getCommonTranslation('LESSON_PLAN');
						 reportParams.ACADEMY_LOCATION_ID=academyLocationId;
						 var exportUrl = SERVERURL.PATH_GENERATE_COURSE_DESCRIPTOR_REPORT_WORD;
						 reportParams.headerName = getCommonTranslation('COURSE_DESCRIPTOR_REPORT');
						 $this.exportJRXMLReport(code, reportParams, 'Course Descriptor Report', '.docx', exportUrl);
					 } else {
						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					 }
				 },

				 generatePDFLessonPlanCDReport: function(btn) {
					 var $this = this;
					 var code = btn.value;
					 var grid = this.getLessonplanninggrid();
					 if (grid.getSelectionModel().getCount() > 0) {
						 var records = grid.getSelectionModel().getSelection();
						 var lessonPlanId = Ext.Array.pluck(Ext.Array.pluck(records,'data'),'id').join();
						 var academyLocationId = this.getCurrentAcademyLocation();
						 var reportParams = new Object();
						 reportParams.LESSON_PLAN_ID = lessonPlanId;
						 reportParams.LESSON_PLAN_Label = getCommonTranslation('LESSON_PLAN');
						 reportParams.ACADEMY_LOCATION_ID=academyLocationId;
						 var exportUrl = SERVERURL.PATH_GENERATE_COURSE_DESCRIPTOR_REPORT_PDF;
						 reportParams.headerName = getCommonTranslation('COURSE_DESCRIPTOR_REPORT');
						 $this.exportJRXMLReport(code, reportParams, 'Course Descriptor Report', '.pdf', exportUrl);
					 } else {
						 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD'));
					 }
				 },
				 
				 disableIsValidationOrRestrictMultiple: function(formReference,permissionsMap) {
					 var associatedAcadLocationIds = new Array();
					 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
					 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					 formReference.down('#isValidationRequiredId').setVisible(false);
					 formReference.down('#isRestrictMultipleLPOfaCourseId').setVisible(false);
					 Ext.each(permissionList, function(privilege) {
						 if (privilege === 'IS_VALIDATION_REQUIRED') {
							 formReference.down('#isValidationRequiredId').setVisible(true);
						 }
						 if(privilege === 'RESTRICT_MULTIPLE_LP'){
							 formReference.down('#isRestrictMultipleLPOfaCourseId').setVisible(true);
						 }
					 });
				 },
				 disableMoreButtonPivileges: function(gridReference,permissionsMap) {
					 var associatedAcadLocationIds = new Array();
					 associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
					 var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
					 gridReference.down('#exportLessonPlanReportsId').setVisible(false);
					 gridReference.down('#assessmentMapReportsId').setVisible(false);
					 gridReference.down('#courseDescriptorReportsId').setVisible(false);
					 try{
						 gridReference.down('#lessonPlanningValidateBtn').setVisible(false);
						 gridReference.down('#btnPublishId').setVisible(false);
						 gridReference.down('#btnMoreOperations').setVisible(false);
					 }
					 catch(e){
						 //
					 }
					 var moreActionPermissionList = [];
					 Ext.each(permissionList, function(privilege) {
						 if (privilege === 'EXPORT_REPORTS') {
							 gridReference.down('#exportLessonPlanReportsId').setVisible(true);
						 }
						 else if (privilege === 'COURSE_DESCRIPTOR_REPORT') {
							 gridReference.down('#courseDescriptorReportsId').setVisible(true);
						 }
						 else if (privilege === 'ASSESSMENT_MAP_REPORT') {
							 gridReference.down('#assessmentMapReportsId').setVisible(true);
						 }
						 else if (privilege === 'VALIDATE') {
							 if(portalId == 2) {
								 gridReference.down('#lessonPlanningValidateBtn').setVisible(true);
							 }
							 else{
								 moreActionPermissionList.push('VALIDATE');
							 }
						 }
						 else if (privilege === 'PUBLISH') {
							 if(portalId == 2) {
								 gridReference.down('#btnPublishId').setVisible(true);
							 }
							 else{
								 moreActionPermissionList.push('PUBLISH');
							 }
						 }
						 else if (privilege === 'UNVALIDATE') {
							 moreActionPermissionList.push('UNVALIDATE');
						 }
						 else if (privilege === 'UNPUBLISH') {
							 moreActionPermissionList.push('UNPUBLISH');
						 }else if (privilege === 'BULK_COPY') {
							 gridReference.down('#lessonPlanningBulkCopyBtn').setVisible(true);
						 }
					 });

					 if(portalId == 1 && moreActionPermissionList.length){
						 gridReference.down('#btnMoreOperations').setVisible(true);
						 gridReference.down('#btnMoreOperations').permissions = moreActionPermissionList;
					 }
					 else{
						 gridReference.down('#btnMoreOperations').setVisible(false);
					 }
				 },
				 
				 renderCourseDescriptorReportMenusBtn: function(courseDescriptorReportsIdBtn){
					 var me = this;
					 var academyLocationId=me.getCurrentAcademyLocation();
					 Ext.Ajax.request({
						 type : 'rest',
						 url : SERVERURL.TEMPLATE_NAME_BY_CODE,
						 method: 'GET',
						 params: {
							 academyLocationId:academyLocationId,
							 reportType:'Lesson Plan'
						 },
						 success: function(response) {
							 var responseData = Ext.decode(response.responseText);

							 Ext.Array.each(responseData, function(item) {
								 var buttonItemId = "";
								 if(item.value == "SOMMET_COURSE_DESCRIPTOR_WORD"){
									 item.code=getProgramandcourseTranslation('SOMMET_COURSE_DESCRIPTOR_WORD');
									 var buttonItemId = "excelSommetCourseDescriptorReportBtn";
								 }
								 if(item.value == "LRCM_COURSE_DESCRIPTOR_WORD"){
									 item.code=getProgramandcourseTranslation('LRCM_COURSE_DESCRIPTOR_WORD');
									 var buttonItemId = "excelLRCMCourseDescriptorReportBtn";
								 }
								 if(item.value == "LRM_COURSE_DESCRIPTOR_WORD"){
									 item.code=getProgramandcourseTranslation('LRM_COURSE_DESCRIPTOR_WORD');
									 var buttonItemId = "excelLRMCourseDescriptorReportBtn";
								 }
								 if(item.value == "SOMMET_COURSE_DESCRIPTOR_PDF"){
									 item.code=getProgramandcourseTranslation('SOMMET_COURSE_DESCRIPTOR_PDF');
									 //item.code=getCommonTranslation("sommet pdf");
									 var buttonItemId = "pdfSommetCourseDescriptorReportBtn";
								 }
								 if(item.value == "LRM_COURSE_DESCRIPTOR_PDF"){
									 item.code=getProgramandcourseTranslation('LRM_COURSE_DESCRIPTOR_PDF');
									 var buttonItemId = "pdfLRMCourseDescriptorReportBtn";
								 }
								 if(item.value == "LRCM_COURSE_DESCRIPTOR_PDF"){
									 item.code=getProgramandcourseTranslation('LRCM_COURSE_DESCRIPTOR_PDF');
									 var buttonItemId = "pdfLRCMCourseDescriptorReportBtn";
								 }
								 courseDescriptorReportsIdBtn.menu.add({
									 text: item.code,
									 itemId: buttonItemId,
									 value:item.value
								 });
							 });

						 },
						 failure: function() {
							 Ext.Msg.alert('Error', 'Failed to load report options.');
						 }
					 });
					 
					 /*if(word){
						 buttonMenus.push({
							 text: 'Word',
							 itemId: 'excelCourseDescriptorReportBtn'
						 })
					 }
					 
					 if(Pdf){
						 buttonMenus.push({
							 text: 'Pdf',
							 itemId: 'pdfCourseDescriptorReportBtn'
						 })
					 }*/
				 }


});