Ext.define('Academia.controller.program.periodTerm.PeriodTermController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['program.programDetails.programBatches.periodTerm.PeriodTermGridStore'],
	model: ['common.IdValueDataModel','program.programDetails.programBatches.periodTerm.PeriodTermModel'],
	views: ['baselayout.contentarea.ContentPanel',
	        'program.programDetails.programBatchDetails.periods.ProgramPeriodsGrid',
	        'program.programDetails.programBatchDetails.periodTerm.ProgramPeriodTermGrid',
	        'program.programDetails.programBatchDetails.periodTerm.ProgramPeriodTermForm'
	        ],
	        config:{
	        	PERIOD_TERM_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('PERIOD_TERM_PRIVILEGES')  
	        },	        
	        refs: [{
	        	ref : 'programbatchdetailsinnertabpanelstructure',
	        	selector : 'programbatchdetailsinnertabpanelstructure'
	        },{
	        	ref: 'programperiodsgrid',
	        	selector: 'programperiodsgrid'
	        },{
	        	ref: 'contentPanel',
	        	selector: 'contentPanel'
	        },{
	        	ref: 'programperiodtermgrid',
	        	selector: 'programperiodtermgrid'
	        }, {
	        	ref: 'programperiodtermform',
	        	selector: 'programperiodtermform'
	        }],
	        init: function(application) {
	        	this.control({
	        		'programperiodtermgrid':{
	        			afterrender: function(grid) {
	        				this.doAccessControlValidation(grid, this.getPERIOD_TERM_PERMISSIONS());
	        			}
	        		},
	        		'programperiodtermgrid button[itemId=btnAdd]':{
	        			click : function(){
	        				this.addProgramTerm()
	        			}
	        		},
	        		'programperiodtermgrid button[itemId=btnEdit]':{
	        			click : function() {
	        				this.editProgramTerm(false)
	        			}
	        		},
	        		'programperiodtermgrid button[itemId=btnView]':{
	        			click : function() {
	        				this.editProgramTerm(true)
	        			}
	        		},
	        		'programperiodtermgrid button[itemId=btnDelete]':{
	        			click : function() {
	        				this.deletePeriodTermDefinition()
	        			}
	        		},
	        		'programperiodtermform button[itemId=addProgramTermCancelBtn]':{
	        			click:this.closeProgramTermWindow 
	        		},
	        		'programperiodtermform button[itemId=programPeriodsTermFormSubmit]':{
	        			click:this.saveProgramTermFormWindow 
	        		}
	        	});
	        },
	        programPeriodsTermGridFormWindow:function(){
	        	var $this = this;
	        	var grid = $this.getProgramperiodsgrid();
	        	if (grid.getSelectionModel().getCount() > 0) {
	        		var record = grid.getSelectionModel().getSelection();
	        		$this.showProgramPeriodsTermGrid(record[0]);
	        	}else{
	        		showWarningMessage(getCommonTranslation('ALERT'),
	        				getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	}
	        },
	        showProgramPeriodsTermGrid: function(record) {
	        	var $this = this;
	        	var contentpanel = $this.getProgrambatchdetailsinnertabpanelstructure();
	        	var periodTermGrid = Ext.widget('programperiodtermgrid');
	        	var tabName = getProgramandcourseTranslation('PROGRAM_TERMS');

	        	var getcontroller=$this.getController('menu.CoreERPNavigationController');
	        	var getTab=getcontroller.getTab(tabName);
	        	if(getTab!=null){
	        		contentpanel.remove(getTab, true);
	        	}
	        	var tabDetail = contentpanel.items.items;
	        	for(var i in tabDetail){
	        		if(tabDetail[i].title==tabName){
	        			tabDetail[i].close();
	        		}
	        	}
	        	openTab(contentpanel, tabName, periodTermGrid,CONSTANTS.MENU_COLOR_THREE);
	        	$this.loadPeriodTermOfSelectedPeriod(record.data.id, periodTermGrid);
	        },

	        loadPeriodTermOfSelectedPeriod : function(periodId, periodTermGrid) {
	        	periodTermGrid.down('#periodItemId').setValue(periodId);
	        	var periodTermStore = periodTermGrid.getStore();
	        	periodTermStore.getProxy().extraParams = {	
	        		periodId : periodId
	        	};
	        	periodTermStore.load();
	        },

	        addProgramTerm : function() {
	        	var this$ = this;
	        	var termGrid = this.getProgramperiodtermgrid();
	        	var periodId = termGrid.down('#periodItemId').getValue();
	        	var frmWin = this.getProgramperiodtermform();
	        	var submitUrl = SERVERURL.PERIOD_TERM_DEFINITION_SEQUENCE;
	        	Ext.Ajax.request({
	        		type : 'rest',
	        		url : submitUrl,
	        		params : {
	        			periodId : periodId
	        		},
	        		method : 'GET',
	        		success : function(form, action) {
	        			var res = 	Ext.JSON.decode(form.responseText);
	        			var nextDate = 60 * 60 * 24 * 1000;
	        			this$.showWindow(frmWin);
	        			var formWindow = this$.getProgramperiodtermform();
	        			formWindow.down('#termSequenceNoItemId').setValue(res.sequence);
	        			if(!isNullOrEmpty(res.endDate)){
	        				formWindow.down('#termStartDate').setMinValue(dateRender(res.endDate+nextDate));
	        			} else {
	        				formWindow.down('#termStartDate').setMinValue(dateRender(res.periodStartDate));
	        			}
	        			formWindow.down('#termStartDate').setMaxValue(dateRender(res.periodEndDate));
	        			formWindow.down('#termTillDate').setMaxValue(dateRender(res.periodEndDate));
	        			formWindow.down('#periodId').setValue(periodId);
	        		}
	        	});
	        },

	        editProgramTerm : function(isView) {
	        	var this$ = this;
	        	var termGrid = this.getProgramperiodtermgrid();
	        	var periodId = termGrid.down('#periodItemId').getValue();
	        	var frmWin = this.getProgramperiodtermform();
	        	if(termGrid.getSelectionModel().getCount() == 1) {
	        		var record = termGrid.getSelectionModel().getSelection()[0];
	        		if (record != "" && record != null && record != undefined) {
	        			var id = record.data.id;
	        			var currentSequence = record.data.sequence;
	        			var submitUrl = SERVERURL.PATH_GET_PERIOD_TERM_DATE_VALIDATION;
	        			Ext.Ajax.request({
	        				type : 'rest',
	        				url : submitUrl,
	        				params : {
	        					periodId : periodId,
	        					currentSequence : currentSequence
	        				},
	        				method : 'GET',
	        				success : function(form, action) {
	        					var res = 	Ext.JSON.decode(form.responseText);
	        					this$.showWindow(frmWin);
	        					var nextDate = 60 * 60 * 24 * 1000;
	        					var formWindow = this$.getProgramperiodtermform();
	        					var form = formWindow.down('form');
	        					form.getForm().findField('id').setValue(res.id);
	        					form.getForm().findField('periodId').setValue(res.periodId);
	        					form.getForm().findField('termSequenceNo').setValue(res.sequence);
	        					form.getForm().findField('programPeriodTermName').setValue(res.programTerm);
	        					form.getForm().findField('printName').setValue(res.printName);
	        					form.getForm().findField('termStartDate').setValue(dateRender(res.startDate));
	        					form.getForm().findField('termTillDate').setValue(dateRender(res.endDate));
	        					if(!isNullOrEmpty(res.previousEndDate)) {
	        						formWindow.down('#termStartDate').setMinValue(dateRender(res.previousEndDate+nextDate));
	        						formWindow.down('#termStartDate').setMaxValue(dateRender(res.previousEndDate-nextDate));
	        					} else {
	        						formWindow.down('#termStartDate').setMinValue(dateRender(res.periodStartDate));
	        						formWindow.down('#termStartDate').setMaxValue(dateRender(res.periodEndDate));
	        					}
	        					if(!isNullOrEmpty(res.nextTermStartDate)) {
	        						formWindow.down('#termTillDate').setMaxValue(dateRender(res.nextTermStartDate-nextDate));
	        					} else {
	        						formWindow.down('#termTillDate').setMaxValue(dateRender(res.periodEndDate));
	        					}
	        					if(isView) {
	        						if (!isNullOrEmpty(form.getForm())) {
	        							formWindow.down('#programPeriodsTermFormSubmit').setVisible(false);
	        							toggleReadOnlyFormItems(form.getForm(), true);
	        						}
	        					}
	        				}
	        			});
	        		}else {
	        			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
	        		}
	        	} else if (termGrid.getSelectionModel().getCount() > 1) {
	        		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_ONLY_SINGLE_RECORD')); //Please select a record.
	        	}else{
	        		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
	        	}
	        },
	        showWindow : function(frmWin) {
	        	var this$ = this;
	        	if (!frmWin) {
	        		Ext.widget('programperiodtermform');
	        		frmWin = this$.getProgramperiodtermform();
	        	}
	        	frmWin.show();
	        },
	        deletePeriodTermDefinition : function() {
	        	var this$ = this;
	        	var this$ = this;
	        	var termGrid = this.getProgramperiodtermgrid();
	        	if(termGrid.getSelectionModel().getCount() > 0) {
	        		showConfirmMessage(getProgramandcourseTranslation('PROGRAM_TERM'),getCommonTranslation('DELETE_CONFIRM_MESSAGE'),
	        				function(btn, text) {
	        			if (btn == 'yes'){
	        				Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        				var ids;
	        				var selectedRecords = new Array();
	        				var records = termGrid.getSelectionModel().getSelection();
	        				if(records !=undefined && records.length > 0){
	        					for(var i=0;i<records.length;i++){
	        						selectedRecords.push(records[i].data.id);
	        					}
	        				}
	        				ids = selectedRecords.join();
	        				var submitUrl = SERVERURL.PERIOD_TERM_DEFINITION_DELETE;
	        				Ext.Ajax.request({
	        					method : "DELETE",
	        					type : 'rest',
	        					url : submitUrl+ '?ids='+ ids,
	        					headers : {
	        						'Content-Type' : 'application/json'
	        					},
	        					success : function(res,form,action) {
	        						Ext.getBody().unmask();
	        						if(res.responseText=="success"){
	        							showSuccessMessage(getProgramandcourseTranslation('PROGRAM_TERM'),getProgramandcourseTranslation('PERIOD_TERM_DELETED_MSG'));
	        							termGrid.getStore().reload();
	        						} else {
	        							showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DEPENDENT_RECORD_EXISTS'));
	        						}
	        					}
	        				});
	        			}
	        		});
	        	} else {
	        		showWarningMessage(getCommonTranslation('ALERT'),
	        				getCommonTranslation('PLEASE_SELECT_RECORD'));
	        	}
	        },

	        saveProgramTermFormWindow : function() {
	        	var this$ = this;
	        	var formWindow = this$.getProgramperiodtermform();
	        	var grid = this$.getProgramperiodtermgrid();
	        	var form = formWindow.down('form');
	        	var value = form.getValues();
	        	var id = value.id;
	        	var periodId = value.periodId;
	        	var programPeriod  =  new Academia.model.program.programDetails.programBatches.periodTerm.PeriodTermModel();
	        	programPeriod.set("id", id);
	        	programPeriod.set("period", this$.getIdValueJson(periodId));
	        	programPeriod.set("sequence", value.termSequenceNo);
	        	programPeriod.set("programTerm", value.programPeriodTermName);
	        	programPeriod.set("printName", value.printName);
	        	programPeriod.set("startDate", value.termStartDate);
	        	programPeriod.set("endDate", value.termTillDate);

	        	var submitUrl;
	        	if (!isNullOrEmpty(id)) {
	        		programPeriod.set("id", id);
	        		submitUrl = SERVERURL.PERIOD_TERM_DEFINITION_UPDATE;
	        	} else {
	        		submitUrl = SERVERURL.PERIOD_TERM_DEFINITION_SAVE;
	        	}
	        	var formData = Ext.encode(programPeriod.data);
	        	Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	        	Ext.Ajax.request({
	        		type : 'rest',
	        		url : submitUrl,
	        		jsonData : formData,
	        		method : 'POST',
	        		success : function(form, action) {
	        			Ext.getBody().unmask();
	        			grid.getStore().reload();
	        			grid.getSelectionModel().deselectAll(true);
	        			showSuccessMessage(getProgramandcourseTranslation('PROGRAM_TERM'),getProgramandcourseTranslation('PERIOD_TERM_SUCCESS_MSG'));
	        			this$.closeProgramTermWindow();
	        		}
	        	});
	        },
	        getIdValueJson : function(id, value, code) {
	        	if (id)
	        		return {
	        		id : id,
	        		value : value,
	        		code : code
	        	};
	        },

	        closeProgramTermWindow : function(){
	        	var frmWin = this.getProgramperiodtermform();
	        	frmWin.close();
	        }
});