/**
 * 
 * @author Raghavendra.Soni 
 * 
 */
Ext.define('Academia.controller.reports.completion.CompletionReportController', {
	extend: 'Academia.controller.base.BaseController',
	stores: [
		'reports.completion.CompletionReportTreeStore',
		'reports.completion.PassoutReportGridStore'
	],
    views: [
    	'reports.completion.CompletionReportStructure',
    	'reports.completion.CompletionReportSearch',
    	'reports.completion.PassOutDetialsReportStructure',
    	'reports.completion.PassOutDetialsReportGrid'
    ],
    refs: [{
        ref: 'contentPanel',
        selector: 'contentpanel'
    }, {
        ref: 'completionreportstructure',
        selector: 'completionreportstructure'
    },{
        ref: 'completionreportsearch',
        selector: 'completionreportsearch'
    },{
    	ref: 'passoutdetialsreportstructure',
    	selector: 'passoutdetialsreportstructure'
    },{
    	ref: 'passoutdetialsreportgrid',
    	selector: 'passoutdetialsreportgrid'
    }],
    config: {
    },
    init: function(application) {
        this.control({
        	'completionreportstructure treepanel[itemId=completionReportTreePanelItemId]':{
        		itemclick : this.getOpenReportStructure
        	},  
        	'completionreportsearch combo[itemId=academyLocationFilter_ItemId]':{
        		select: function(combo){
        			var me = this;
        			
        			var form = combo.up('completionreportsearch');
        			var academyLocationField = form.down('#academyLocationFilter_ItemId');
        			var programField = form.down('#programId_ItemId');
        			var batchField = form.down('#batchId_ItemId');
        			
        			programField.reset();
        			batchField.reset();
        			
        			batchField.setDisabled(true);
        			
        			var academyLocationId = academyLocationField.getValue();
        			
        			var programStore = programField.getStore();
        			programStore.getProxy().extraParams={
        				academyLocationIds : academyLocationId
        			}
        			
   				 	programStore.load({
   				 		callback: function(records, operation, success) {
   				 			if (success) {
   				 				if(records.length == 1){
   				 					programId = records[0].get('id');
   				 					var programIds = [programId];
   				 					programField.setValue(programIds);
   				 					batchField.setDisabled(false);
   				 					var batchStore = batchField.getStore();
   				 					batchStore.getProxy().extraParams={
   				 						id : programId
   				 					}
   				 					batchStore.load({
   				 						callback: function(records, operation, success) {
   				 							if (success) {
   				 								if(records.length == 1){
   				 									batchId = records[0].get('id');
   				 									var batchIds = [batchId];
   				 									batchField.setValue(batchIds);
   				 								}
   				 							}
   				 						}
   				 					});
   				 				}
   				 			}
   				 		}
   				 	});
        		}
        	},
        	'completionreportsearch combo[itemId=programId_ItemId]':{
        		select: function(combo){
        			var me = this;
        			
        			var form = combo.up('completionreportsearch');
        			var academyLocationField = form.down('#academyLocationFilter_ItemId');
        			var programField = form.down('#programId_ItemId');
        			var batchField = form.down('#batchId_ItemId');
        			
        			batchField.reset();
        			batchField.setDisabled(true);
        			
        			var academyLocationId = academyLocationField.getValue();
        			var programId = programField.getValue();
        			
        			var batchStore = batchField.getStore();
					batchStore.getProxy().extraParams={
						id : programId
					}
					batchField.setDisabled(false);
					batchStore.load({
						callback: function(records, operation, success) {
							if (success) {
								if(records.length == 1){
									batchId = records[0].get('id');
									var batchIds = [batchId];
									batchField.setValue(batchIds);
								}
							}
						}
					});
        		}
        	},
        	'completionreportsearch button[itemId=quickSearchId_ItemId]':{
        		click: function(btn){
        			var me = this;

        			var form = btn.up('completionreportsearch');
        			var structure = form.up('completionreportstructure');
        			var tabPanel = structure.down('#completionReportTabpanelIds');

        			var academyLocationField = form.down('#academyLocationFilter_ItemId');
        			var programField = form.down('#programId_ItemId');
        			var batchField = form.down('#batchId_ItemId');

        			var academyLocationId = academyLocationField.getValue();
        			var programId = programField.getValue();
        			var batchId = batchField.getValue();

        			if(!isNullOrEmpty(tabPanel.getActiveTab()) && tabPanel.getActiveTab().down().xtype=="passoutdetialsreportstructure"){

        				var grid = tabPanel.getActiveTab().down('grid');
        				var gridStore = grid.getStore();

        				gridStore.getProxy().extraParams = {
        					academyLocationId : academyLocationId,
        					programId : programId,
        					batchId	: batchId
        				};

        				gridStore.loadPage(1);      				

        			}
        		}
        	},
        	'completionreportsearch button[itemId=resetBtn_ItemId]':{
        		click: function(btn){
        			var me = this;
        			var form = btn.up('completionreportsearch');
        			form.getForm().reset()
        		}
        	},
        	'passoutdetialsreportgrid':{
        		afterrender: function(grid){
        			var me = this;
        			setTimeout(function(){
        				var gridStore = grid.getStore();
        				gridStore.removeAll();
            			
            			var form = me.getCompletionreportsearch();
            			var structure = form.up('completionreportstructure');
            			var tabPanel = structure.down('#completionReportTabpanelIds');
            			
            			var academyLocationField = form.down('#academyLocationFilter_ItemId');
            			var programField = form.down('#programId_ItemId');
            			var batchField = form.down('#batchId_ItemId');
            			
            			var academyLocationId = academyLocationField.getValue();
            			var programId = programField.getValue();
            			var batchId = batchField.getValue();
            			
            			if(!isNullOrEmpty(tabPanel.getActiveTab()) && tabPanel.getActiveTab().down().xtype=="passoutdetialsreportstructure" && form.isValid()){

            				gridStore.getProxy().extraParams = {
            					academyLocationId : academyLocationId,
            					programId : programId,
            					batchId	: batchId
            				};

            				gridStore.loadPage(1);      				
            			}
        			},500);
        		}
        	}
        });
    }, 
    getOpenReportStructure : function(treePanel, record, item,index, e, eOpts){
 	   var $this = this;
 	   var containpanel = $this.getCompletionreportstructure();
 	   var treePanel = containpanel.down('#completionReportTreePanelItemId');
 	   var tabDetail = record.data;
 	   var structure = Ext.widget(tabDetail.reportXtype);
 	   var tabstructure = containpanel.down('#completionReportTabpanelIds');

 	   if (!isNullOrEmpty(tabDetail.text)
 			   && !isNullOrEmpty(tabDetail.reportXtype)
 			   && !isNullOrEmpty(tabDetail.reportXtypeItemId)) {
 		   treePanel.toggleCollapse();
 		   openTab(tabstructure, tabDetail.text,structure);
 		   treePanel.getSelectionModel().deselectAll();
 	   }
    },
});
