/**
 * Akshay Sharma
 */
Ext.define('Academia.controller.resourceutilization.ResourceUtilizationController', {
	extend: 'Academia.controller.base.BaseController',
	stores: ['facilitiesresources.resourcebooking.AcademyLocationListByUserStore','resourceutilization.ResourcesStore',
	         'program.programDetails.programBatches.courseParameter.FacultyCombo','resourceutilization.ResourceUtilizationGridStore',
	         'facilitiesresources.resourcebooking.ResourceBookingPurposeStore','eventmeetingminutes.EMMMinuteReportsEventNameStore',
	         'transport.serviceRoute.WeekDays',
	         'resourceutilization.ActiveUserStore','resourceutilization.EventparticipantGridStore'],
    model: ['resourceutilization.ResourceUtilizationGridModel'
           ],
	views: ['resourceutilization.ResourceUtilizationStructure','resourceutilization.ResourceUtilizationSearch',
	                 'resourceutilization.ResourceUtilizationGrid','resourceutilization.EventParticipantWindow',
	                 'resourceutilization.EventParticipantGrid'
	       ],
	config: {
		RESOURCE_UTILIZATION_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('RESOURCE_UTILIZATION_PRIVILEGES'),
		},
		refs: [{
			ref: 'resourceutilizationstructure',
			selector: 'resourceutilizationstructure'
		},{
			ref: 'resourceutilizationsearch',
			selector: 'resourceutilizationsearch'
		},{
			ref: 'resourceutilizationgrid',
			selector: 'resourceutilizationgrid'
		},{
			ref: 'eventparticipantwindow',
			selector: 'eventparticipantwindow'
		},{
			ref: 'eventparticipantgrid',
			selector: 'eventparticipantgrid'
		},{
			ref: 'contentPanel',
			selector: 'contentPanel'
		}],
		init: function(application) {
			this.control({
				'resourceutilizationsearch button[itemId=searchBtn]':{
					click: function() {
						var $this = this;
						var searchForm = $this.getResourceutilizationsearch();
						var selectedValue = searchForm.down('#selectionTypeId').getValue();
						var val = selectedValue.resourceViewType;
						this.loadResourceRecord(val);
					}
				},
				'resourceutilizationgrid':{
					render : function(grid){
						this.doAccessControlValidation(grid, this.getRESOURCE_UTILIZATION_PRIVILEGES());
					},
					cellclick:function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
						var columnName = View.ownerCt.columnManager.columns[ColIdx].dataIndex;
						if (e.target.tagName == 'A') {
							this.openParticipantWindow(columnName, record);
						}
					}
				},
				'resourceutilizationsearch button[itemId=resetBtn]':{
					click: function() {
						var $this = this;
						var searchForm = $this.getResourceutilizationsearch().getForm();
						searchForm.reset();
						var roomCombo = searchForm.findField('room');
						var roomComboStore = searchForm.findField('room').getStore();
						var facultyComboStore = searchForm.findField('faculty').getStore();
						var ALComboStore = searchForm.findField('academyLocation').getStore();
						var academyLocationId = this.getCurrentAcademyLocation();
						var alIds=[];
						var academyLocationIds; 
						alIds.push(academyLocationId);
						academyLocationIds = alIds.join();
						roomComboStore.getProxy().extraParams = {
							name:'',
							academyLocationIds : academyLocationIds,
							onlyClassRoom : true
						};
						roomComboStore.load();

						facultyComboStore.getProxy().extraParams = {
							nameOrCode : '',
							restrictToFacultyRole : true,
							academyLocationIds : academyLocationIds,
						};
						facultyComboStore.load();
						
						ALComboStore.load({
							   callback: function(records, operation, success) {
								   if (success) {
									   searchForm.findField('academyLocation').setValue(academyLocationId);
								   }
							   }
						});
					}
				},
				'resourceutilizationsearch customcombobox[itemId=roomId]':{
					render: function() {
						var $this = this;
						var searchForm = $this.getResourceutilizationsearch().getForm();
						var roomCombo = searchForm.findField('room');
						var roomComboStore = searchForm.findField('room').getStore();
						var facultyComboStore = searchForm.findField('faculty').getStore();
						var eventComboStore = searchForm.findField('eventName').getStore();
						var ALComboStore = searchForm.findField('academyLocation').getStore();
						var academyLocationId = this.getCurrentAcademyLocation();
						var alIds=[];
						var academyLocationIds; 
						alIds.push(academyLocationId);
						academyLocationIds = alIds.join();
						roomComboStore.getProxy().extraParams = {
							name:'',
							academyLocationIds : academyLocationIds,
							onlyClassRoom : true
						};
						roomComboStore.load();

						facultyComboStore.getProxy().extraParams = {
							nameOrCode : '',
							restrictToFacultyRole : true,
							academyLocationIds : academyLocationIds,
						};
						facultyComboStore.load();

						eventComboStore.getProxy().extraParams = {
							name : '',
							academyLocationIds : academyLocationIds,
						};
						eventComboStore.load();
						
						ALComboStore.load({
							   callback: function(records, operation, success) {
								   if (success) {
									   searchForm.findField('academyLocation').setValue(academyLocationId);
								   }
							   }
						});
					}
				},
				'resourceutilizationsearch multiselectcombofield[itemId=academyLocationId]':{
					blur: function() {
						var $this = this;
						var searchForm = $this.getResourceutilizationsearch().getForm();
						var roomCombo = searchForm.findField('room');
						var roomComboStore = searchForm.findField('room').getStore();
						var facultyComboStore = searchForm.findField('faculty').getStore();
						var eventComboStore = searchForm.findField('eventName').getStore();
						var userComboStore = searchForm.findField('userName').getStore();
						roomCombo.clearValue();
						searchForm.findField('faculty').clearValue();
						var academyLocationId = searchForm.findField('academyLocation').getValue();
						var alIds=[];
						var academyLocationIds; 
						if(academyLocationId !=undefined && academyLocationId.length > 0 && academyLocationId[0] != ""){
							for(var i in academyLocationId){
								if(Ext.isObject(academyLocationId[0])){
									alIds.push(academyLocationId[i].get("id"));
								}else{
									alIds.push(academyLocationId[i]);
								}
							}
							academyLocationIds = alIds.join();
						} else {
							alIds.push(this.getCurrentAcademyLocation());
							academyLocationIds = alIds.join();
						}
						if(searchForm.getValues().resourceViewType == 'masterTimetable' || searchForm.getValues().resourceViewType == 'detailedTimeTalbe'){
							roomComboStore.getProxy().extraParams = {
								name:'',
								academyLocationIds : academyLocationIds,
								onlyClassRoom : true
							};
							roomComboStore.load();
						} else {
							roomComboStore.getProxy().extraParams = {
								name:'',
								academyLocationIds : academyLocationIds,
								onlyClassRoom : false
							};
							roomComboStore.load();
						}


						facultyComboStore.getProxy().extraParams = {
							nameOrCode : '',
							restrictToFacultyRole : true,
							academyLocationIds : academyLocationIds,
						};
						facultyComboStore.load();

						eventComboStore.getProxy().extraParams = {
							name : '',
							academyLocationIds : academyLocationIds,
						};
						eventComboStore.load();

						userComboStore.getProxy().extraParams = {
							name : '',
							academyLocationIds : academyLocationIds,
						};
						userComboStore.load();
					}
				},
				'resourceutilizationsearch radiogroup[itemId=selectionTypeId]':{
					change: function() {
						var $this = this;
						var searchForm = $this.getResourceutilizationsearch();
						var academyLocationId = this.getCurrentAcademyLocation();
						var grid = $this.getResourceutilizationgrid();
						this.resetPageSetting(grid.getStore());
						var store = grid.getStore();
						var searchBtn = searchForm.down('#searchBtn');
						var submitURL = null;
						searchForm.down('#academyLocationId').reset();
						var ALComboStore = searchForm.down('#academyLocationId').getStore();
						ALComboStore.load({
							   callback: function(records, operation, success) {
								   if (success) {
									  searchForm.down('#academyLocationId').setValue(academyLocationId);
								   }
							   }
						});
						var selectedValue = searchForm.down('#selectionTypeId').getValue();
						var val = selectedValue.resourceViewType;
						if(val == 'detailedTimetable') {
							
							grid.down('[dataIndex=eventPurpose]').setVisible(false);
							grid.down('[dataIndex=eventName]').setVisible(false);
							grid.down('[dataIndex=eventFromDate]').setVisible(false);
							grid.down('[dataIndex=eventToDate]').setVisible(false);
							//grid.down('[dataIndex=roomName]').setVisible(true);
							grid.down('#roomMasterItemId').setVisible(true);
							grid.down('[dataIndex=facultyCode]').setVisible(false);
							grid.down('[dataIndex=facultyName]').setVisible(true);
							grid.down('[dataIndex=courseCode]').setVisible(true);
							grid.down('[dataIndex=courseName]').setVisible(true);
							grid.down('[dataIndex=courseVariantName]').setVisible(true);
							grid.down('[dataIndex=academyLocationName]').setVisible(false);
							grid.down('[dataIndex=programName]').setVisible(false);
							grid.down('[dataIndex=batchName]').setVisible(false);
							grid.down('[dataIndex=periodName]').setVisible(false);
							grid.down('[dataIndex=sectionName]').setVisible(true);
							grid.down('[dataIndex=date]').setVisible(true);
							grid.down('[dataIndex=day]').setVisible(true);
							grid.down('[dataIndex=startTime]').setVisible(true);
							grid.down('[dataIndex=endTime]').setVisible(true);
							//grid.down('[dataIndex=roomName]').setVisible(false);
							grid.down('#roomResourceEventItemId').setVisible(false);
							grid.down('[dataIndex=bookedByCode]').setVisible(false);
							grid.down('[dataIndex=bookedBy]').setVisible(false);
							grid.down('[dataIndex=noOfParticipants]').setVisible(false);
							
//							grid.columns[0].setVisible(false);//eventPurpose
//							grid.columns[1].setVisible(false);//eventName
//							grid.columns[2].setVisible(false);//eventFromDate
//							grid.columns[3].setVisible(false);//eventToDate
//							grid.columns[4].setVisible(true);//roomName
//							grid.columns[5].setVisible(true);//facultyName
//							grid.columns[6].setVisible(true);//courseCode
//							grid.columns[7].setVisible(true);//courseName
//							grid.columns[8].setVisible(true);//courseVariantName
//							grid.columns[9].setVisible(false)//academyLocationName
//							grid.columns[10].setVisible(false);//programName
//							grid.columns[11].setVisible(false);//batchName
//							grid.columns[12].setVisible(false);//periodName
//							grid.columns[13].setVisible(true);//sectionName
//							grid.columns[14].setVisible(true);//date
//							grid.columns[15].setVisible(true);//day
//							grid.columns[16].setVisible(true);//startTime
//							grid.columns[17].setVisible(true);//endTime
//							grid.columns[18].setVisible(false);//roomName
//							grid.columns[19].setVisible(false);//bookedBy
//							grid.columns[20].setVisible(false);//noOfParticipants

							searchForm.down('#roomId').setVisible(true);
							searchForm.down('#roomId').clearValue();
							searchForm.down('#facultyId').setVisible(true);
							searchForm.down('#facultyId').clearValue();
							searchForm.down('#bookingPurposeItemId').setVisible(false);
							searchForm.down('#eventName').setVisible(false);
							searchForm.down('#resourcesItemId').setVisible(false);
							searchForm.down('#weekDayId').setVisible(false);
							searchForm.down('#weekDayId').clearValue();
							searchForm.down('#fromDate_Id').reset();
							searchForm.down('#fromDate_Id').setVisible(true);
							searchForm.down('#toDate_Id').reset();
							searchForm.down('#toDate_Id').setVisible(true);
							searchForm.down('#fromTime').reset();
							searchForm.down('#fromTime').setVisible(true);
							searchForm.down('#toTime').reset();
							searchForm.down('#toTime').setVisible(true);
							searchForm.down('#userNameItemId').setVisible(false);
							searchForm.down('#eventDateItemId').setVisible(false);
							searchForm.down('#eventTimeItemId').setVisible(false);
							submitURL=SERVERURL.PATH_GET_RESOURCE_UTILIZATION_REPORT;
							var roomCombo = searchForm.down('#roomId');
							var roomComboStore = searchForm.down('#roomId').getStore();
							var facultyComboStore = searchForm.down('#facultyId').getStore();
							var alIds=[];
							var academyLocationIds; 
							alIds.push(academyLocationId);
							academyLocationIds = alIds.join();
							roomComboStore.getProxy().extraParams = {
								name:'',
								academyLocationIds : academyLocationIds,
								onlyClassRoom : true
							};
							roomComboStore.load();

							facultyComboStore.getProxy().extraParams = {
								nameOrCode : '',
								restrictToFacultyRole : true,
								academyLocationIds : academyLocationIds,
							};
							facultyComboStore.load();

						} else if(val == 'event'){
							
							grid.down('[dataIndex=eventPurpose]').setVisible(true);
							grid.down('[dataIndex=eventName]').setVisible(true);
							grid.down('[dataIndex=eventFromDate]').setVisible(true);
							grid.down('[dataIndex=eventToDate]').setVisible(true);
							grid.down('[dataIndex=enrolledCount]').setVisible(false);
							//grid.down('[dataIndex=roomName]').setVisible(false);
							grid.down('#roomMasterItemId').setVisible(false);
							grid.down('[dataIndex=facultyCode]').setVisible(false);
							grid.down('[dataIndex=facultyName]').setVisible(false);
							grid.down('[dataIndex=courseCode]').setVisible(false);
							grid.down('[dataIndex=courseName]').setVisible(false);
							grid.down('[dataIndex=courseVariantName]').setVisible(false);
							grid.down('[dataIndex=academyLocationName]').setVisible(false);
							grid.down('[dataIndex=programName]').setVisible(false);
							grid.down('[dataIndex=batchName]').setVisible(false);
							grid.down('[dataIndex=periodName]').setVisible(false);
							grid.down('[dataIndex=sectionName]').setVisible(false);
							grid.down('[dataIndex=date]').setVisible(false);
							grid.down('[dataIndex=day]').setVisible(true);
							grid.down('[dataIndex=startTime]').setVisible(true);
							grid.down('[dataIndex=endTime]').setVisible(true);
							grid.down('[dataIndex=bookedByCode]').setVisible(false);
							grid.down('[dataIndex=bookedBy]').setVisible(true);
							grid.down('#roomResourceEventItemId').setVisible(true);
							
//							grid.columns[0].setVisible(true);
//							grid.columns[1].setVisible(true);
//							grid.columns[2].setVisible(true);
//							grid.columns[3].setVisible(true);
//							grid.columns[4].setVisible(false);
//							grid.columns[5].setVisible(false);
//							grid.columns[6].setVisible(false);
//							grid.columns[7].setVisible(false);
//							grid.columns[8].setVisible(false);
//							grid.columns[9].setVisible(false);
//							grid.columns[10].setVisible(false);
//							grid.columns[11].setVisible(false);
//							grid.columns[12].setVisible(false);
//							grid.columns[13].setVisible(false);
//							grid.columns[14].setVisible(false);
//							grid.columns[15].setVisible(true);
//							grid.columns[16].setVisible(true);
//							grid.columns[17].setVisible(true);
//							grid.columns[18].setVisible(true);
//							grid.columns[19].setVisible(true);

							searchForm.down('#bookingPurposeItemId').setVisible(true);
							searchForm.down('#bookingPurposeItemId').clearValue();
							searchForm.down('#eventName').setVisible(true);
							searchForm.down('#eventName').clearValue();
							searchForm.down('#resourcesItemId').setVisible(true);
							searchForm.down('#resourcesItemId').clearValue();
							searchForm.down('#roomId').setVisible(false);
							searchForm.down('#roomId').clearValue();
							searchForm.down('#facultyId').setVisible(false);
							searchForm.down('#weekDayId').setVisible(false);
							searchForm.down('#fromDate_Id').reset();
							searchForm.down('#fromDate_Id').setVisible(true);
							searchForm.down('#toDate_Id').reset();
							searchForm.down('#toDate_Id').setVisible(true);
							searchForm.down('#fromTime').reset();
							searchForm.down('#fromTime').setVisible(true);
							searchForm.down('#toTime').reset();
							searchForm.down('#toTime').setVisible(true);
							searchForm.down('#userNameItemId').setVisible(true);
							searchForm.down('#eventDateItemId').setVisible(true);
							searchForm.down('#eventTimeItemId').setVisible(true);
							submitURL=SERVERURL.PATH_GET_RESOURCE_UTILIZATION_EVENT_REPORT;
							var roomCombo = searchForm.down('#resourcesItemId');
							var roomComboStore = searchForm.down('#resourcesItemId').getStore();
							var eventComboStore = searchForm.down('#eventName').getStore();
							var userComboStore = searchForm.down('#roomId').getStore();
							var alIds=[];
							var academyLocationIds; 
							alIds.push(academyLocationId);
							academyLocationIds = alIds.join();
							roomComboStore.getProxy().extraParams = {
								name:'',
								academyLocationIds : academyLocationIds,
								onlyClassRoom : false
							};
							roomComboStore.load();

							eventComboStore.getProxy().extraParams = {
								name : '',
								academyLocationIds : academyLocationIds,
							};
							eventComboStore.load();

							userComboStore.getProxy().extraParams = {
								name : '',
								academyLocationIds : academyLocationIds,
							};
							userComboStore.load();
						} else {
							grid.down('[dataIndex=eventPurpose]').setVisible(false);
							grid.down('[dataIndex=eventName]').setVisible(false);
							grid.down('[dataIndex=eventFromDate]').setVisible(false);
							grid.down('[dataIndex=eventToDate]').setVisible(false);
							//grid.down('[dataIndex=roomName]').setVisible(true);
							grid.down('#roomMasterItemId').setVisible(true);
							grid.down('[dataIndex=facultyCode]').setVisible(false);
							grid.down('[dataIndex=facultyName]').setVisible(true);
							grid.down('[dataIndex=courseCode]').setVisible(true);
							grid.down('[dataIndex=courseName]').setVisible(true);
							grid.down('[dataIndex=courseVariantName]').setVisible(true);
							grid.down('[dataIndex=academyLocationName]').setVisible(false);
							grid.down('[dataIndex=programName]').setVisible(false);
							grid.down('[dataIndex=batchName]').setVisible(false);
							grid.down('[dataIndex=periodName]').setVisible(false);
							grid.down('[dataIndex=sectionName]').setVisible(true);
							grid.down('[dataIndex=date]').setVisible(false);
							grid.down('[dataIndex=day]').setVisible(true);
							grid.down('[dataIndex=startTime]').setVisible(true);
							grid.down('[dataIndex=endTime]').setVisible(true);
							//grid.down('[dataIndex=roomName]').setVisible(false);
							grid.down('#roomResourceEventItemId').setVisible(false);
							grid.down('[dataIndex=bookedByCode]').setVisible(false);
							grid.down('[dataIndex=bookedBy]').setVisible(false);
							grid.down('[dataIndex=noOfParticipants]').setVisible(false);
							
//							grid.columns[0].setVisible(false);//eventPurpose
//							grid.columns[1].setVisible(false);//eventName
//							grid.columns[2].setVisible(false);//eventFromDate
//							grid.columns[3].setVisible(false);//eventToDate
//							grid.columns[4].setVisible(true);//roomName
//							grid.columns[5].setVisible(true);//facultyName
//							grid.columns[6].setVisible(true);//courseCode
//							grid.columns[7].setVisible(true);//courseName
//							grid.columns[8].setVisible(true);//courseVariantName
//							grid.columns[9].setVisible(false)//academyLocationName
//							grid.columns[10].setVisible(false);//programName
//							grid.columns[11].setVisible(false);//batchName
//							grid.columns[12].setVisible(false);//periodName
//							grid.columns[13].setVisible(true);//sectionName
//							grid.columns[14].setVisible(true);//date
//							grid.columns[15].setVisible(true);//day
//							grid.columns[16].setVisible(true);//startTime
//							grid.columns[17].setVisible(true);//endTime
//							grid.columns[18].setVisible(false);//roomName
//							grid.columns[19].setVisible(false);//bookedBy
//							grid.columns[20].setVisible(false);//noOfParticipants

							searchForm.down('#roomId').setVisible(true);
							searchForm.down('#roomId').clearValue();
							searchForm.down('#facultyId').setVisible(true);
							searchForm.down('#facultyId').clearValue();
							searchForm.down('#bookingPurposeItemId').setVisible(false);
							searchForm.down('#eventName').setVisible(false);
							searchForm.down('#resourcesItemId').setVisible(false);
							searchForm.down('#weekDayId').setVisible(true);
							searchForm.down('#weekDayId').clearValue();
							searchForm.down('#fromDate_Id').reset();
							searchForm.down('#fromDate_Id').setVisible(false);
							searchForm.down('#toDate_Id').reset();
							searchForm.down('#toDate_Id').setVisible(false);
							searchForm.down('#fromTime').reset();
							searchForm.down('#fromTime').setVisible(true);
							searchForm.down('#toTime').reset();
							searchForm.down('#toTime').setVisible(true);
							searchForm.down('#userNameItemId').setVisible(false);
							searchForm.down('#eventDateItemId').setVisible(false);
							searchForm.down('#eventTimeItemId').setVisible(false);
							submitURL=SERVERURL.FIND_MASTER_TIME_TABLE_SESSION_PBSC;
							var roomCombo = searchForm.down('#roomId');
							var roomComboStore = searchForm.down('#roomId').getStore();
							var facultyComboStore = searchForm.down('#facultyId').getStore();
							var alIds=[];
							var academyLocationIds; 
							alIds.push(academyLocationId);
							academyLocationIds = alIds.join();
							roomComboStore.getProxy().extraParams = {
								name:'',
								academyLocationIds : academyLocationIds,
								onlyClassRoom : true
							};
							roomComboStore.load();
							facultyComboStore.getProxy().extraParams = {
								nameOrCode : '',
								restrictToFacultyRole : true,
								academyLocationIds : academyLocationIds,
							};
							facultyComboStore.load();
						}
						searchBtn.fireEvent('click');
					}
				},
				'eventparticipantwindow':{
					afterrender : function(){
						var eventGrid = this.getResourceutilizationgrid();
						var records = eventGrid.getSelectionModel().getSelection();
						var formWindow = this.getEventparticipantwindow();
						formWindow.down('#eventPurposeNameItemId').setValue(records[0].get('eventPurpose'));
						formWindow.down('#eventNameItemId').setValue(records[0].get('eventName'));
					}
				}
			});
		},
		loadResourceRecord : function(val) {

			var $this=this;
	    	var form = $this.getResourceutilizationsearch();
	    	form.down('#searchBtn').setDisabled(true);
			var grid = this.getResourceutilizationgrid();
			var searchForm = this.getResourceutilizationsearch().getForm();
			var alId = this.getCurrentAcademyLocation();
			var values = searchForm.getValues();
			var store = grid.getStore();
			var roomId = values.room;
			if(isNullOrEmpty(roomId)){
				roomId = values.resources;
			}
			var facultyId = values.faculty;
			var facultyIds=[];
			var facultyUserIds; 
			if(facultyId !=undefined && facultyId.length > 0){
				for(var i in facultyId){
					if(Ext.isObject(facultyId[i])){
						facultyIds.push(facultyId[i].get("id"));
					}else{
						facultyIds.push(facultyId[i]);
					}
				}
				facultyUserIds = facultyIds.join();
			} else {
				facultyIds.push(facultyId);
				facultyUserIds = facultyIds.join();
			}
			var fromDate = values.fromDate;
			var toDate = values.toDate;
			var fromTime = values.fromTime;
			var toTime = values.toTime;
			var day = values.weekDay;
			var userId = values.userName;
			var eventName = values.eventName;
			var bookingPurposeId = values.bookingPurpose;
			var academyLocationId = values.academyLocation;
			var alIds=[];
			var academyLocationIds; 
			if(academyLocationId !=undefined && academyLocationId.length > 0){
				for(var i in academyLocationId){
					if(Ext.isObject(academyLocationId[0])){
						alIds.push(academyLocationId[i].get("id"));
					}else{
						alIds.push(academyLocationId[i]);
					}
				}
				academyLocationIds = alIds.join();
			} else {
				alIds.push(alId);
				academyLocationIds = alIds.join();
			}
			var pbs = '2';
			var submitURL = null;
			if(val == 'detailedTimetable'){
				submitURL=SERVERURL.PATH_GET_RESOURCE_UTILIZATION_REPORT;
			}else if(val == 'event'){
				submitURL=SERVERURL.PATH_GET_RESOURCE_UTILIZATION_EVENT_REPORT;
			}else {
				submitURL=SERVERURL.FIND_MASTER_TIME_TABLE_SESSION_PBSC;
			}
			store.getProxy().api.read=submitURL;
			store.getProxy().extraParams = {
				roomId:roomId,
				facultyId:facultyUserIds,
				academyLocationIds : academyLocationIds,
				startDate:fromDate,
				endDate:toDate,
				fromTime:fromTime,
				toTime:toTime,
				pbs : '2',
				day: day,
				userId : userId,
				eventName : eventName,
				bookingPurposeId : bookingPurposeId
			};
			this.resetPageSetting(store);
			store.load({
				   callback: function(records, operation, success) {
					   form.down('#searchBtn').setDisabled(false);
				   }
			});

			grid.config.searchFilterForm = form;
		},
		openParticipantWindow : function(a, b){
			var formWindow = this.getEventparticipantwindow();
			if (!formWindow) {
				Ext.widget('eventparticipantwindow');
				formWindow = this.getEventparticipantwindow();
			}
			formWindow.show();

			var participantGridStore = this.getEventparticipantgrid().getStore();
			participantGridStore.getProxy().extraParams = {
				resourceBookingId : b.get('id')
			};
			this.resetPageSetting(participantGridStore);
			participantGridStore.load();
		}
});
