//TODO: [AKR] Code Cleanup

Ext.define('Academia.controller.scholarship.ScholarshipListingController', {
    extend: 'Academia.controller.base.BaseController',
    

    views: ['Academia.view.scholarship.scholarshiplisting.ScholarshipListing',
            'Academia.view.scholarship.scholarshiplisting.ScholarshipListingScreen',
            'Academia.view.scholarship.scholarshiplisting.ScholarshipListingSearchForm',
			'Academia.view.scholarship.scholarshiplisting.AddAwardee',
            'Academia.view.criteriabuilder.grid.SearchResultGrid',
            'Academia.view.scholarship.scholarshiplisting.ViewAwardeesDisbursementWindow',
            'Academia.view.scholarship.scholarshiplisting.ViewAwardeesGrid',
            'Academia.view.scholarship.scholarshiplisting.ViewAwardees',
			'Academia.view.scholarship.scholarshiplisting.ScholarshipAwardeeUploadeDownloadForm',
			'Academia.view.scholarship.scholarshiplisting.ScholarshipUploadForm',
			'Academia.view.scholarship.scholarshiplisting.ScholarshipDownloadForm',
			'Academia.view.scholarship.scholarshiplisting.ScholarshipUploadListGrid',
			'Academia.view.UploadOptionRadioGroup',
			'Academia.view.scholarship.scholarshiplisting.ScholarshipStudentAwardeeListGrid',
			'Academia.view.scholarship.scholarshiplisting.ScholarshipApplicantAwardeeListGrid',
			'Academia.view.scholarship.scholarshiplisting.ScholarshipCancelConfirmationWindow'
            ],

    stores: ['securitysetup.unlockUser.acadamyStore', 'scholarships.AmountTypes', 'scholarships.Status',
             'scholarships.ScholarshipTypes', 'scholarships.DisbursmentModes', 'scholarships.ApplicationModes','scholarships.ViewAwardeesDisbursementStore','scholarships.Organizations',
             'scholarships.ViewAwardeesGridStore','scholarships.ViewAwardeeStatusComboStore',
             'scholarships.AddAwardeeScholarshipComboStore',
             'scholarships.AddAwardeeProgramComboStore', 'scholarships.Acadamys','scholarships.Locations',
             'scholarships.SelectionTypes','common.UserAccessibleAcademys','organization.academylocations.LocationStore',
             'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch','feeandpayment.managebill.ScholarshipSmartSearch',
			 'scholarships.AddAwardeeScholarshipComboStore','scholarships.AddAwardeeScholarshipComboStoreForAcademyLocationStore',
			 'common.AcademyLocationNameSeparated','importutility.ModuleName',
			 'importutility.ImportSponsorshipStore','user.UserAcademyLocationStore','scholarships.ScholarshipCategoryStore','scholarships.ScholarshipCategoryStore','scholarships.ScholarshipAwardeeStore',
			 'scholarships.ScholarshipAcountingYearStore','feeandpayment.managebill.ScholarshipByAccountingYearStore','facilitiesresources.resourcemaster.ProgramListGridStore','scholarships.ScholarshipProgramStore',
			 'feeandpayment.managebill.ScholarshipByAwardeeAccountingYearStore','scholarships.ScholarshipAwardeeCategory','scholarships.SchlCancellationReasonStore','feeandpayment.managebill.ScholarshipAwardeeListStore'
             ],

    config: {
    	/*
	   	 * CODE FOR setting up the featurePrivileges from FeaturePrivilegeManager which sets the privileges for the passed parameter screen.
	   	 */
    	/**
         * @cfg {Array} SCHOLARSHIP_LISTING_PERMISSIONS array (required)
         * The array of permissions to use for Access control wise enabling and disabling buttons.
         * @accessor
         */
	   	SCHOLARSHIP_LISTING_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SCHOLARSHIP_LISTING_PRIVILEGES'),
	   	SCHOLARSHIP_AWARDEE_PRIVILEGES: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SCHOLARSHIP_AWARDEE_PRIVILEGES')
    },
    
    refs: [{
    	ref: 'contentPanel',
        selector: 'contentPanel'
   	},{
        ref: 'scholarshiplisting',
        selector: 'scholarshiplisting'
   	},{
        ref: 'scholarshipListForm',
        selector: 'scholarshiplisting form[itemId=scholarshipList]'
    },{
   		ref:'addAwardeeWindow',
   		selector:'addawardee'
   	},{
   		ref:'viewAwardeesDisbursementWindow',
   		selector:'viewawardeesdisbursementwindow'
   	},{
        ref: 'searchResultGrid',
        selector: 'scholarshiplistingscreen [itemId=scholarshipListGrid]'
    },{
    	 ref: 'refAddAwardee',
         selector: 'addawardeeform form[itemId=addAwardeeForm]'
    },{
    	ref:'viewAwardeesGrid',
   		selector:'viewawardeesgrid'
    },{
    	ref:'summaryForm',
    	selector:'viewawardees form[itemId=summaryForm]'
    },{
    	ref:'scholarshipListingSearchForm',
    	selector:'scholarshiplistingsearchform'
    },{
		ref: 'studentSearchField',
		selector: 'addawardee livesearchcombo[name=studentId]'
	 }/*,{
		ref: 'scholarshipAwardeeUploadeDownloadForm',
		selector: 'scholarshipawardeeuploadedownloadform'
	 }*/,{
		ref: 'scholarshipUploadForm',
		selector: 'scholarshipuploadform'
	 },{
		ref: 'scholarshipDownloadForm',
		selector: 'scholarshipdownloadform'
	 },{
		ref: 'scholarshipUploadListGrid',
		selector: 'scholarshipuploadlistgrid'
	 },{
			ref: 'uploadoptionradiogroup',
			selector: 'uploadoptionradiogroup'
	},{
		ref:'scholarshipApplicantAwardeeListGrid',
		selector:'scholarshipApplicantAwardeeListGrid'
	},{
		ref:'scholarshipStudentAwardeeListGrid',
		selector:'scholarshipStudentAwardeeListGrid'
	},{
		ref:'scholarshipCancelConfirmationWindow',
		selector:'scholarshipCancelConfirmationWindow'
	}


],
    init: function(application) {
    	
    	this.AWARDEE_LIMIT_CHECK = "2"; //To check response from server side to indicate maximum awardee limit has reached.
    	this.transactionInprogress=false;  // To check whether api is already in pending
    	this.control({
    		'scholarshiplisting' : {
        		tabchange: function(view,newTab,oldtab){
        			var master=this.getScholarshiplisting();
        			var advancesearch = master.down('advancedsearchquerybuilder');
        			var combo1 = advancesearch.down('#loadSavedSearchComboId');
        			combo1.setVisible(false);
        		}
        	},
            'scholarshiplistingscreen button[itemId=ScholarshipListSearchBtn]': {
                click: this.loadGridAndSearchUsers
            },
            'scholarshiplistingscreen button[itemId=ClearSearchBtn]': {
                click: this.clearSearchForm
            },
            'scholarshiplistingscreen':{
            	afterrender : function(structure){
            		var form = structure.down('scholarshiplistingsearchform');
            		if(this.getCurrentLoggedPortalId() == 3 || this.getCurrentLoggedPortalId() == 7){
            			structure.setAutoScroll(false);
            			//form.down("#scholList_scholId").setVisible(false); //not using at any place
//            			form.down("#scholList_scholName").setVisible(false);
            			//form.down("#scholList_studId").setValue(this.getCurrentlyLoggedInUserInfoForPortal().student.code);
            			//form.down("#scholList_studId").setVisible(false);
            		}
            	}
            },
           /* 'scholarshiplisting grid[itemId=scholarshipListGrid]': {
	   			render : function(grid) {
	   				this.gridRenderFunction(grid);
	   			}	   				   		
            },*/
            'scholarshiplistingscreen [itemId=scholarshipListGrid]': {
            	afterrender : function(grid){
            		this.gridRenderFunction(grid);
            		this.genericCBGridAccessControlValidation(grid, this.getSCHOLARSHIP_LISTING_PERMISSIONS());	
            		this.disableMoreActionPivileges(grid,this.getSCHOLARSHIP_LISTING_PERMISSIONS());
            	}
            },
            'scholarshiplistingscreen searchresultgrid button[itemId=searchResultGridBtnAdd]':{
            	click:function(cmp){
            		this.showAwardeeWindow();
            	}
            },
            'scholarshiplistingscreen searchresultgrid button[itemId=searchResultGridBtnEdit]':{
            	//click:Ext.bind(this.editAwardee, this, [false])
            	click: function(grid) {
            		this.editAwardee(grid, false);
            	}
            	
            },
            'scholarshiplistingscreen searchresultgrid button[itemId=searchResultGridBtnView]':{
            	//click:Ext.bind(this.editAwardee, this, [true])
            	click: function(grid) {
            		this.editAwardee(grid, true);
            	}
            },
       		'scholarshipawardeeuploadedownloadform radiogroup[itemId=importDownloadgroupId]':{
	   			   change: function(cb, nv, ov){
                		var $this = this;
                 		var downloadTemplateForm = this.getScholarshipDownloadForm();
                 		var uploadTemplateForm = this.getScholarshipUploadForm();
                 		var grid = this.getScholarshipUploadListGrid();
                 		if(nv.downloadUploadTemplate == 'forDownloadTemplate'){
                 			uploadTemplateForm.hide();
                 			downloadTemplateForm.show();
                 			grid.setVisible(false);
                 		}else{
              //   			$this.doAccessControlValidationForLoader(uploadTemplateForm,this.getCORE_ERP_LOADER_PERMISSIONS());
                        	var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
                        	uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
                        		isUploadAll: false
                        	});
                 			downloadTemplateForm.hide();
                 			uploadTemplateForm.show();
                 			grid.setVisible(true);
                 		}
                 	}
       		 },
			'scholarshipdownloadform':{
            	afterrender : function(structure){
				
            	}
            },
            
            'scholarshipStudentAwardeeListGrid button[itemId=btnDelete]':{
            	click: function(btn){
            		var $this = this;
            		this.popUpStudentScholarshipAwardeesList();
            	}
            },
            'scholarshipApplicantAwardeeListGrid button[itemId=btnDelete]':{
            	click: function(btn){
            		var $this = this;
            		this.popUpStudentScholarshipAwardeesList();
            	}
            },
            'scholarshipCancelConfirmationWindow button[itemId=cancelButtonId]': {
				 click: function(btn) {
					 btn.up('window').close();
				 }
			 }, 
			 'scholarshipCancelConfirmationWindow button[itemId=submitButtonId]': {
				 click: function(btn) {
					 this.deleteScholarshipAwardeesList();
				 }
			 }, 
            //click---->cancel,save---->method
		
            
            
			'scholarshipdownloadform  customcombobox#academyLocation':{
					select:function(){
						var form = this.getScholarshipDownloadForm();
				var scholarStore = form.down('#scholarshipCmp').getStore();
				
				var academyLocationIds = form.down('#academyLocation');
				scholarStore.removeAll();
					scholarStore.getProxy().extraParams = {
						academyLocationIds : academyLocationIds.value
					};
					scholarStore.load();	
					}
				},
				'scholarshipdownloadform  button#downoladBtnId':{
					click:function(obj){
						{
     				   var $this = this;
     				   var form =$this.getScholarshipDownloadForm().getForm();
     				   var value = form.getValues();
     				   
     				   var templateUrl = null;
     				   
     				   templateUrl = SERVERURL.PATH_DOWNLOAD_FILE_SCHOLAR_AWARDEE
     				   
     				   var csvForm = Ext.create('Ext.form.Panel'); 
     				   csvForm.getForm().submit({
     					   target: '_blank',
     					   method:'POST',
     					   params :{
     						   access_token : Ext.Ajax.defaultHeaders.access_token,
     						   academyLocationId :value.academyLocation,
     						   scholarshipId :value.scholarshipId  
     					   },
     					   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
     					   url: templateUrl,
     					   standardSubmit :true
     				   });
     			   }
					}
				},
				'scholarshipdownloadform  button#resetBtn':{
					click:function(){
						this.getScholarshipDownloadForm().getForm().reset();
   				 		var downloadbtn = this.getScholarshipDownloadForm().down("#downoladBtnId");
						downloadbtn.setDisabled(true);	
					}
				},
				
				'scholarshipuploadform button[itemId=uploadId]':{
      			   click:function(obj){
      				   var $this=this;
      				   var importWin=$this.getScholarshipUploadForm()
      				   var grdStore;
      				   var form=$this.getScholarshipUploadForm();
      				   submitUrl = SERVERURL.IMPORT_UTILITY_MASTER_CREATE;
      				   $this.getHashOfFile(form);
      				   setTimeout(function() {
          				   form.getForm().submit({
          					   method : 'POST',
          					   url : submitUrl,
          					   success : function(form, action){
          						   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SUCCESS'));
          					   },
          					   failure: function(form, action) {
       		   						showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_CONTENT_MISMATCH'));
          					   }
          				   });
      				   },1000);

      				   Ext.defer(function() {
      					   var grid = $this.getScholarshipUploadListGrid();
      					   var form = $this.getUploadoptionradiogroup();
      					   var isUploadAll = form.items.items[0].getValue().isUploadAll;
      					   $this.onChangeUploadOptionRadioGroup(isUploadAll, grid,'IMPORT_BULK_SCHOLARSHIP_UPLOAD');
      				   }, 2000, this);
      			   }  
      		   },
				
				'scholarshipuploadform button[itemId=resetBtn]':{
  			   click:function(obj){
  				   var $this = this;
  				   var form =$this.getScholarshipUploadForm().getForm();
  				   form.findField('file').reset();
  				   var uploadoptionradiogroupform  = $this.getUploadoptionradiogroup();
  				   uploadoptionradiogroupform.down("#uploadgroupItemId").setValue({
  					   isUploadAll: false
  				   });
  				   form.isValid();
  			   },
  			   render :function(obj){
  				   var $this = this;
  				   var form =$this.getScholarshipUploadForm().getForm();
  				   var combo = form.findField('importUtilityMasterId');
  				   combo.getStore().load({
  					   callback: function(records, operation, success) {
  						   for(var i in records){
  							   if(records[i].data.value=='Bulk Scholarship Awardee'){
  								   combo.setValue(records[i].data.id);
  								   combo.setReadOnly(true);
  							   }
  						   }
  					   }	   
  				   });
  			   }  
  		   },
			'scholarshipuploadlistgrid':{
			   render:function(obj){
				   var $this = this;
				   var grid = $this.getScholarshipUploadListGrid();
				   var form = this.getUploadoptionradiogroup();
				   var isUploadAll = form.items.items[0].getValue().isUploadAll;
				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_SCHOLARSHIP_UPLOAD');
			   },
			   cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
				   if (e.target.tagName == 'A') {
					   var fileType = null;
					   if(cellIndex == 1){
						   fileType = 'successFile';
					   }else if(cellIndex == 6){
						   fileType = 'errorFile';
					   }else if(cellIndex == 7){
						   fileType = 'logFile';
					   }
					   var documentId = record.get("id");
					   if (!isNullOrEmpty(documentId)) {
						   this.getDownloadFile(documentId,fileType);
					   }
				   }
			   }
		   },	
			'scholarshipuploadform uploadoptionradiogroup[itemId=scholarshipUploadOptionRadioGroupItemId] radiogroup[itemId=uploadgroupItemId]':{
  			   change: function( radioGroup, newValue, oldValue, eOpts){
  				   var grid =this.getScholarshipUploadListGrid();
  				   var form =this.getUploadoptionradiogroup();
  				   var isUploadAll = newValue.isUploadAll;
  				   this.onChangeUploadOptionRadioGroup(isUploadAll,grid, 'IMPORT_BULK_SCHOLARSHIP_UPLOAD');
  			   }   
  		   },
			'scholarshipuploadlistgrid button[itemId=btnForce]':{
			   click: function(obj) {
				   var grid = this.getScholarshipUploadListGrid();
				   if (grid.getSelectionModel().getCount() > 0) {
					   if(grid.getSelectionModel().getCount() > 1){
						   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_SINGLE_RECORD'));
					   }else{
						   var this$ = this;
						   var id = grid.getSelectionModel().selectionStart.data.id;
						   console.log(id);
						   var urlAppend="?jobName="+id;
						   var submitURL = SERVERURL.IMPORT_UTIL_MANUAL_TRIGGER+urlAppend;
						   Ext.Ajax.request({
							   url: submitURL,
							   method: 'GET',
							   success: function(response) {
								   if(response.responseText==="JOB_STATUS_NOT_PENDING"){
									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('IMPORT_UTIL_UNABLE_TO_FORCE_RUN'));
								   }else if(response.responseText==="SIMILAR_NATURE_JOB_ALREADY_RUNNING"){
									   //console.log("Manual trigger hit");
									   showWarningMessage(getCommonTranslation('IMPORT_UTILITY'), getCommonTranslation('SIMILAR_NATURE_JOB_ALREADY_RUNNING'));
								   }else if(response.responseText==="SUCCESS"){
									   //console.log("Manual trigger hit");
									   showSuccessMessage(getCommonTranslation('IMPORT_UTILITY')	,getCommonTranslation('SUCCESS'));
									   grid.getStore().reload();
								   }
							   }
						   });
					   }
				   } else {
					   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_SELECT_RECORD'));
				   }  
			   }
		   },

            'scholarshiplistingscreen searchresultgrid button[itemId=searchResultGridBtnDelete]':{
            	click:this.deleteAwardee
            },
            'scholarshiplistingscreen searchresultgrid #spBtnMoreActions menuitem[itemId=viewAwardees]': {
                click: function(){        
                	var me=this;
                    var grid = me.getSearchResultGrid();        
                    if (grid.getSelectionModel().getCount() > 0) {                       
                        var records = grid.getSelectionModel().getSelection()[0];  
                        var scholarshipId=records.get('SCHOLARSHIP_ID');
                        var scholarshipName=records.get('SCHOLARSHIP_NAME');
                        if (!isNullOrEmpty(scholarshipId)) { 
		                	var contentpanel = me.getContentPanel();                	                	
		    		        var viewAwardeesPanel = Ext.widget('viewawardees');
		    		        var tabName = getCommonTranslation('VIEW_AWARDEES');  //View no. of Awardees            		        
		    		        openTab(contentpanel, tabName, viewAwardeesPanel, CONSTANTS.MENU_COLOR_TEN);    		        
		    		        me.getViewAwardeesGrid().down('#scholarship_Id').setValue(scholarshipId);		    		        
		    		        var statusCombo=me.getViewAwardeesGrid().down('#cmbStatus'); 
		    		        statusCombo.getStore().load({    		        		
		                     	    callback: function(records, operation, success) {
		                     	    	statusCombo.setValue('CURRENT'); //Current
		                     	    	me.getViewAwardeesGrid().getStore().getProxy().extraParams = {
		                     	    		scholarshipId:scholarshipId,
    		                            	status:statusCombo.getValue()
		                                };
		                     	    	me.getViewAwardeesGrid().getStore().load();
		                    	    }
		    		        });    		            		       		    		        		    		        
		    		        Ext.Ajax.request({
		    			        type: 'rest',
		    			        url: SERVERURL.SCHOLARSHIP_AWARDEE_FIND_AWARDEE_SUMMARY, //URL-rest/scholarshipAwardee/findScholarshipAwardeeSummary
		    			        method: 'GET',
		    			        params: {
		                        	scholarshipId:scholarshipId
		    			        },
		    			        success: function(res, action) {
		    			        	var data=Ext.decode(res.responseText);    			        	
		    			        	var summaryFormContainer=me.getSummaryForm().up('panel'); //Getting Summary Form Panel    			        	
		    			        	summaryFormContainer.setTitle(getCommonTranslation('SUMMARY_FOR')+"  "+scholarshipName);
		    			        	console.log(data)
		    			        	var summaryFormDisp=summaryFormContainer.down('form').items.items[1];
		    			        	message = "<div style='padding: 10px;'>"+"<span style='font-size : 100%;'> "+
		    			        	getCommonTranslation('TOTAL_NO_AWARDEES')+" "+data.totalAwardeesCount+ "<br>" + "<br>"+
		    				 	    getCommonTranslation('NO_AWARDEES_AWARDED_MORE') + "&nbsp;"+ data.noOfVacantSeats +" </span</br></br></div>";
		    			        	summaryFormDisp.setValue(message);
		    			        }
		    			    });
                        }    
                    } else {
                    	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
                    }     
                }
            },
            'viewawardeesgrid': {            	
            	cellclick: function(view, cell, cellIndex, record, row, rowIndex, e){
            		var cellDataIndex = view.getGridColumns()[cellIndex].dataIndex;
	               	 if (cellDataIndex == "disbursementId") {
	                    	var window = this.getViewAwardeesDisbursementWindow();
	                    	if (!window) {
	                			window = Ext.widget('viewawardeesdisbursementwindow');
		           	     	}
	                    	if(record.get('disMode')=='ACD'){
		           	     	window.show();
	                    	}else{
	                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('ONLY_ACAD'));
	                            
	                        } 	
	                    }
            	}
            },
            'viewawardeesdisbursementwindow grid[itemId=viewDisbursementGrid]':{
            	render: function(grid){
            		this.loadScholarshipDisbursementGridData(grid);    
            	}
            },
            'viewawardeesgrid combo[itemId=cmbStatus]': {
            	select:function(cmp){
            		var me=this;
            		var cmbStatusValue=cmp.getValue();
            		var scholarshipId=me.getViewAwardeesGrid().down('#scholarship_Id').getValue();            		
            		if(!isNullOrEmpty(cmbStatusValue) && !isNullOrEmpty(scholarshipId)){
            			me.getViewAwardeesGrid().getStore().getProxy().extraParams = {
            				scholarshipId:scholarshipId,
                        	status:cmbStatusValue
                        };
             	    	me.getViewAwardeesGrid().getStore().load();
            		}            		
            	}
            },
            'addawardee button[itemId=cancelAwardeeBtn]':{
            	click:function(){
            		this.getAddAwardeeWindow().close();
            	}
            },
            'addawardee button[itemId=addAwardeeBtn]':{
            	click:this.saveAwardee
            },
            'addawardee combo[itemId=scholarshipCmp]':{
            	select:function(combo, records, eOpts){
            		var me=this;
            		var amountType=records[0].get('scholarshipAmountType');
            		var amount=records[0].get('amount');
        			var scholarshipAmount=me.getAddAwardeeWindow().down('#scholarshipAmount');   
            		var searchStudentCombo=me.getAddAwardeeWindow().down('#studentCmp');
            		
        			var store = searchStudentCombo.getStore();
        			store.getProxy().api.read = SERVERURL.SCHOLARSHIP_SEARCH_USERS;
     			   store.getProxy().extraParams = {
     				   scholarshipId: combo.getValue()
                    };
     			   //store.load();
     			  searchStudentCombo.setDisabled(false);
        			var paymentType=records[0].get('paymentType');
        			var validFrom=me.getAddAwardeeWindow().down('#validFrom');
        			var validUpto=me.getAddAwardeeWindow().down('#validUpto');
        			
            		if(!isNullOrEmpty(amountType) && amountType==='FIX'){
            			scholarshipAmount.setValue(amount);
            			scholarshipAmount.setReadOnly(true);
            		}else{
            			scholarshipAmount.setValue(0);
            			scholarshipAmount.setReadOnly(false);
            		}  
            		
            		if(!isNullOrEmpty(paymentType) && paymentType=='OT' ){
            			validFrom.setVisible(false);
            			validUpto.setVisible(false);
            		}else{
            			validFrom.setVisible(true);
            			validUpto.setVisible(true);
            		}
            	}
            },            
            'addawardee combo[itemId=programId]':{
            	select:function(combo, records, eOpts){
            		var me=this;
            		var admissionId=records[0].get('code');
            		/*var courseCombo = me.getAddAwardeeWindow().down('#courseVariantId')
            		courseCombo.getStore().load({
            			 params:{
        					  admissionId: admissionId 
            			 }
            		});*/
            		if(!isNullOrEmpty(admissionId)){
            			me.getAddAwardeeWindow().down('#hidden_admissionId').setValue(admissionId);
            		}            		
            	}
            },
            'addawardee form[itemId=addAwardeeForm] livesearchcombo[itemId=studentCmp]':{
            	select:function(combo, records, eOpts){
            		var studentId = combo.getValue();
            		//var studentId = this.getStudentId();
         		   var programCombo=this.getAddAwardeeWindow().down('#programId');
         		   if(programCombo){
         			  programCombo.getStore().load({
         				   params:{
         					  studentId:studentId
         				   }
         			   });
         		   }        		           		   
         	   }
            },
            /******************** Applying Business Rules ****************/
            'addawardee datefield[itemId=validFrom]':{
            	select:function(field,value,eOpts){            		            		
            		var scholarshipCombo=this.getAddAwardeeWindow().down('#scholarshipCmp');
            		var awardedOnDate=this.getAddAwardeeWindow().down('#awardedOn');
            		var validUpto=this.getAddAwardeeWindow().down('#validUpto');
            		
            		var scholarshipValue=scholarshipCombo.getValue();
            		var awardedOnDateValue=awardedOnDate.getValue();
            		if(!isNullOrEmpty(scholarshipValue)){
            			var scholarshipRecord=scholarshipCombo.getStore().getById(scholarshipValue);
            			var amountType=scholarshipRecord.get('scholarshipAmountType');
            			var validityInMonth=scholarshipRecord.get('validityInMonth');
            			var paymentType =scholarshipRecord.get('paymentType');
            			
            			if(!isNullOrEmpty(paymentType) && paymentType==='IRL'){
            			if(!isNullOrEmpty(amountType) && amountType==='FIX'){
            				var date=value;
            				if(! isNullOrEmpty(validityInMonth)) {
            					date.setMonth(date.getMonth()+validityInMonth);
            					validUpto.setValue(date);
            					validUpto.setReadOnly(true);
            				}
            			}else{
            				validUpto.setReadOnly(false);
            				if(!isNullOrEmpty(awardedOnDateValue)){
            					/**
                        		 * @author Ravi Choudhary
                        		 * to manage organization date format
                        		 */
                        		var date;
//                        		var orgModel = Academia.model.common.OrgSettingDateTimeModel;
//                        	    var currentDateFormat = orgModel.get('dateFormat');
//                        		if(currentDateFormat ==="DMY_DESH") {
                        			date = this.getDateFromDMYdate(awardedOnDateValue);
//                        		} else if(currentDateFormat ==="DMY_SLASH") {
//                        			date = this.getDateFromDMYdate(awardedOnDateValue, 'd/m/Y')
//                        		}
                				date.setMonth(date.getMonth()+validityInMonth);
                				validUpto.setMinValue(date);
            				}            				
            			}
            			}
            		}
            	}
            },  
            'addawardee datefield[itemId=awardedOn]':{
            	select:function(obj,value,eOpts){  
            		var form=obj.up('form').getForm();
            		var scholarship=form.findField('scholarshipId');
//            		var scholarshipData = scholarship.valueModels[0].data;
//            		var paymentType =scholarshipData.paymentType;
            		var paymentType =scholarship.store.data.items["0"].data.paymentType;
            		var validFrom=form.findField('validFrom');
            		var validUpto=form.findField('validUpto');
            		var awardedOn=form.findField('awardedOn');
            		/**
            		 * @author Ravi Choudhary
            		 * to manage organization date format
            		 */
            		var date = new Date(awardedOn.getValue()); 
            		if(isNullOrEmpty(date)) {
//            			var orgModel = Academia.model.common.OrgSettingDateTimeModel;
//            			var currentDateFormat = orgModel.get('dateFormat');
//            			if(currentDateFormat ==="DMY_DESH") {
            				date = this.getDateFromDMYdate(awardedOn);
//            			} else if(currentDateFormat ==="DMY_SLASH") {
//            				date = this.getDateFromDMYdate(awardedOn, 'd/m/Y');
//            			}
            		}
//            		var date =new Date(awardedOn.getValue()); 
            		var validFromNew = Ext.Date.add(date, Ext.Date.DAY, -1);
            		var validUptoNew = Ext.Date.add(date, Ext.Date.DAY, 1);
            		if(paymentType=='OT'){
            			validFrom.setValue(validFromNew);
            			validUpto.setValue(validUptoNew);
            			validFrom.setReadOnly(true);
            			validUpto.setReadOnly(true);
            		}else{
            			validFrom.setValue(dateRender(date));
            			var validityInMonth=scholarship.store.data.items["0"].data.validityInMonth;
            			var validUptoNew = Ext.Date.add(date, Ext.Date.MONTH, validityInMonth);
            			validUpto.setValue(validUptoNew);
            			validFrom.setReadOnly(true);
            			validUpto.setReadOnly(true);
            		}
            		
            	}
            },
            'addawardee combo':{
            	render:function(cmp){
            		if(cmp.itemId != 'studentCmp' ){
            			cmp.getStore().load();
            		}
            	}
            },
            'scholarshiplistingsearchform combo':{
            	render:function(cmp){
//            		cmp.getStore().load();
            	}
            },
           /* 'scholarshiplisting combo[itemId=ACADAMY]':{
         	   render:function(cmp){        		   
         		   var academyList = Academia.utilities.accessControl.AccessControlManager.getAllocatedAcademies();           		   
            		   cmp.getStore().loadData(academyList); 		   
         	   }
            },
            'scholarshiplisting combo[itemId=LOCATION]':{    
         	   render:function(cmp){        		   
         		   var locationList = Academia.utilities.accessControl.AccessControlManager.getAllocatedLocations();           		   
            		   cmp.getStore().loadData(locationList); 		   
         	   }
            },*/
           /* 'scholarshiplistingsearchform textfield[itemId=scholList_scholId]':{
            	change:function(cmp,newValue){
            		var me=this;
            		if(!isNullOrEmpty(newValue) && newValue.length>0){
            			me.enableDisableSearchComponents(me,cmp,true);
            		}else{
            			me.enableDisableSearchComponents(me,cmp,false);
            		}            		
            	}
            },
            'scholarshiplistingsearchform textfield[itemId=scholList_scholName]':{
            	change:function(cmp,newValue){
            		var me=this;
            		if(!isNullOrEmpty(newValue) && newValue.length>0){
            			me.enableDisableSearchComponents(me,cmp,true);
            		}else{
            			me.enableDisableSearchComponents(me,cmp,false);
            		}            		
            	}
            },
            'scholarshiplistingsearchform textfield[itemId=scholList_studId]':{
            	change:function(cmp,newValue){
            		var me=this;
            		if(!isNullOrEmpty(newValue) && newValue.length>0){
            			me.enableDisableSearchComponents(me,cmp,true);
            		}else{
            			me.enableDisableSearchComponents(me,cmp,false);
            		}            		
            	}
            },
            'scholarshiplistingsearchform textfield[itemId=scholList_organisation]':{
            	change:function(cmp,newValue){
            		var me=this;
            		if(!isNullOrEmpty(newValue) && newValue.length>0){
            			me.enableDisableSearchComponents(me,cmp,true);
            		}else{
            			me.enableDisableSearchComponents(me,cmp,false);
            		}            		
            	}
            },*/
            'scholarshiplistingsearchform  combo[itemId=scholList_selectionType]':{
            	render:function(combo){
            		combo.getStore().load({
            			callback: function(records, operation, success) {                            
            				var model = new Academia.model.common.IdValueDataModel();
                            model.set('id','');
                            model.set('value', 'All');
                            combo.getStore().add(model);
                        }
            		});            		            		
            	}
            },      'scholarshiplistingsearchform  combo[itemId=scholList_amountType]':{
            	render:function(combo){
            		combo.getStore().load({
            			/*callback: function(records, operation, success) {                            
            				var model = new Academia.model.common.IdValueDataModel();
                            model.set('id','');
                            model.set('value', 'All');
                            combo.getStore().add(model);
                        }*/
            		});            		            		
            	}
            },      'scholarshiplistingsearchform  combo[itemId=scholList_scholType]':{
            	render:function(combo){
            		combo.getStore().load({
            			/*callback: function(records, operation, success) {                            
            				var model = new Academia.model.common.IdValueDataModel();
                            model.set('id','');
                            model.set('value', 'All');
                            combo.getStore().add(model);
                        }*/
            		});            		            		
            	},
              	 select:function(combo, records, eOpts){
            		 var scholarshipType=records[0].data.id;
                  	var organizationCombo=this.getScholarshipListingSearchForm().down('#scholList_organisation');
                  	if(organizationCombo){
                  		organizationCombo.getStore().load({
         				   params:{
         					  organizationType:scholarshipType
         				   },
               			/*callback: function(records, operation, success) {                            
            				var model = new Academia.model.common.IdValueDataModel();
                            model.set('id','');
                            model.set('value', 'All');
                            organizationCombo.getStore().add(model);
                        }*/
            		
         			   });
         		   }   
                  	
                  } 
            },      'scholarshiplistingsearchform  combo[itemId=scholList_disbursmentMode]':{
            	render:function(combo){
            		combo.getStore().load({
/*            			callback: function(records, operation, success) {                            
            				var model = new Academia.model.common.IdValueDataModel();
                            model.set('id','');
                            model.set('value', 'All');
                            combo.getStore().add(model);
                        }*/
            		});            		            		
            	}
            },      'scholarshiplistingsearchform  combo[itemId=scholList_selectionType]':{
            	render:function(combo){
            		combo.getStore().load({
            			/*callback: function(records, operation, success) {                            
            				var model = new Academia.model.common.IdValueDataModel();
                            model.set('id','');
                            model.set('value', 'All');
                            combo.getStore().add(model);
                        }*/
            		});            		            		
            	}
            },   'scholarshiplistingsearchform  combo[itemId=scholList_organisation]':{
            	render:function(combo){
            		combo.getStore().load({
            			/*callback: function(records, operation, success) {                            
            				var model = new Academia.model.common.IdValueDataModel();
                            model.set('id','');
                            model.set('value', 'All');
                            combo.getStore().add(model);
                        }*/
            		});            		            		
            	}
            },
           
 	        'searchresultgrid[itemId=scholarshipListGrid] splitbutton[itemId=exportToPdfBtn] #exportAll': {
 	            click: function() {
 	                this.exportScholarshipList(SERVERURL.PDFEXPORT,'pdf',true);
 	            }
 	        },
 	        'searchresultgrid[itemId=scholarshipListGrid] splitbutton[itemId=exportToXcelBtn] #exportCurrentPage': {
 	            click: function() {
 	                this.exportScholarshipList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
 	            }
 	        },
 	        'searchresultgrid[itemId=scholarshipListGrid] splitbutton[itemId=exportToXcelBtn] #exportAll': {
 	            click: function() {
 	                this.exportScholarshipList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',true);
 	            }
 	        } ,
 	        'scholarshiplistingsearchform customcombobox[itemId=accountingYear]': {
 	            select: function(cmp) {
 	                var me = this.getScholarshiplistingsearchform(),
 	               scholarshipCombo = me.down('#scholarshipId');
 	               scholarshipCombo.getStore().getProxy().extraParams = {
 	            	  accountingYearIds: cmp.getValue()
 	               };
 	              scholarshipCombo.getStore().load();
 	                
 	            }
 	        },
            'scholarshiplistingsearchform customcombobox[itemId=requesterType]':{
            	select:function(cmp){
            		var me = this,grid,
            		searchForm = me.getScholarshipListingSearchForm();
            		searchForm.scrollBy(0,1);
            		searchForm.scrollBy(0,-1);
            		if(cmp.getValue() == 'Student'){
            			searchForm.down('#applicantId').reset();
            			searchForm.down('#studentId').setVisible(true);
            			searchForm.down('#stdStatus').setVisible(true);
            			searchForm.down('#applicantId').setVisible(false);
            			me.getScholarshipStudentAwardeeListGrid().setVisible(true);
            			me.getScholarshipApplicantAwardeeListGrid().setVisible(false);
            			me.getScholarshipStudentAwardeeListGrid().getStore().removeAll();
            			grid= me.getScholarshipStudentAwardeeListGrid();
            		}else{
            			me.getScholarshipApplicantAwardeeListGrid().getStore().removeAll();
            			me.getScholarshipApplicantAwardeeListGrid().setVisible(true);
            			me.getScholarshipStudentAwardeeListGrid().setVisible(false);
            			searchForm.down('#studentId').reset();
            			searchForm.down('#applicantId').setVisible(true);
            			searchForm.down('#studentId').setVisible(false);
            			searchForm.down('#stdStatus').setVisible(false);
            			grid= me.getScholarshipApplicantAwardeeListGrid();
            		}
            		var item0 = grid.dockedItems.items[0];
	                var item1 = grid.dockedItems.items[1];
	                var item3 = grid.dockedItems.items[3];
	                item0.removeCls('sticky-header-active-title');
	                item1.removeCls('sticky-header-active-buttons');
	                item3.removeCls('sticky-header-active-columns');
	                item0.addCls('x-docked');
	                item1.addCls('x-docked');
	                item3.addCls('x-docked');
            	}
            },
            'scholarshiplistingsearchform customcombobox[itemId=studentId]':{
            	select:function(combo, records, eOpts){
            		var studentId = combo.getValue();
            		var academyLocationId;
            		//var studentId = this.getStudentId();
         		   var programCombo=this.getScholarshipListingSearchForm().down('#programId');
         		  var acdaamylocation=this.getScholarshipListingSearchForm().down('#scholarshipAcademyLocationId');
         		 var applicantId=this.getScholarshipListingSearchForm().down('#applicantId');
         		 var locationId = acdaamylocation.getValue();
         		if(locationId && locationId.length == 1 && !Ext.isEmpty(locationId[0])){
       			 academyLocationId=Ext.pluck(Ext.pluck(locationId, 'data'), 'id').join(',')
          		 }else if(locationId && locationId.length >1){
          			  academyLocationId=Ext.pluck(Ext.pluck(locationId, 'data'), 'id').join(',')
          		 }
         		   if(programCombo){
         			  programCombo.reset();
         			  programCombo.getStore().getProxy().extraParams ={
     					  studentId:studentId,
      					 applicationId:applicantId.getValue(),
      					academyLocationIds:academyLocationId
      				   };
         			  programCombo.getStore().load();
         		   }        		           		   
         	   }
            },'scholarshiplistingsearchform customcombobox[itemId=applicantId]':{
            	select:function(combo, records, eOpts){
            		var applicantId = combo.getValue();
            		var academyLocationId;
            		//var studentId = this.getStudentId();
         		   var programCombo=this.getScholarshipListingSearchForm().down('#programId');
         		  var studentId=this.getScholarshipListingSearchForm().down('#studentId');
         		  var acdaamylocation=this.getScholarshipListingSearchForm().down('#scholarshipAcademyLocationId');
         		 var locationId = acdaamylocation.getValue();
         		 if(locationId && locationId.length == 1 && !Ext.isEmpty(locationId[0])){
        			 academyLocationId=Ext.pluck(Ext.pluck(locationId, 'data'), 'id').join(',')
           		 }else if(locationId && locationId.length >1){
           			  academyLocationId=Ext.pluck(Ext.pluck(locationId, 'data'), 'id').join(',')
           		 }
         		   if(programCombo){
         			  programCombo.reset();
         			  programCombo.getStore().getProxy().extraParams ={
     					  studentId:studentId.getValue(),
      					 applicationId:applicantId,
      					academyLocationIds:academyLocationId
      				   };
         			  programCombo.getStore().load();
         		   }        		           		   
         	   }
            },
            'scholarshiplistingsearchform multiselectcombofield[itemId=scholarshipAcademyLocationId]':{
            	change:function(combo, records, eOpts){
            		var studentNameCombo= this.getScholarshipListingSearchForm().down('#studentId');
            		var academyLocationId;
            		   var programCombo=this.getScholarshipListingSearchForm().down('#programId');
         		  var acdaamylocation=this.getScholarshipListingSearchForm().down('#scholarshipAcademyLocationId');
         		  var studentId=this.getScholarshipListingSearchForm().down('#studentId');
         		 var applicantId=this.getScholarshipListingSearchForm().down('#applicantId');
         		var locationId = acdaamylocation.getValue();
         		var academyLocationId=[];
         		Ext.each(locationId, function(value) {
                    if (value instanceof Object) {
                    	academyLocationId.push(value.get('id'));
                    } else {
                    	academyLocationId.push(value);
                    }
                });
        		 
        		 var studentNameComboStore = studentNameCombo.getStore();
           	   studentNameComboStore.getProxy().extraParams = {
           		   academyLocationIds: academyLocationId.join()
           	   };
         		   if(programCombo){
         			  programCombo.reset();
         			  programCombo.getStore().getProxy().extraParams ={
     					  studentId:studentId.getValue(),
      					 applicationId:applicantId.getValue(),
      					academyLocationIds:academyLocationId.join()
      				   };
         			  programCombo.getStore().load();
         		   }        		           		   
         	   }
            },
            'scholarshipApplicantAwardeeListGrid':{
            	selectionchange:function(cmp,record){
            		var  gridView = this.getScholarshipApplicantAwardeeListGrid();
            		var isDisabledDeleteButton=true;
            		var awardedRecordCount=0;
            			if(record.length){
            				record.forEach(function(cmp){
            					if(cmp.get('status') == 'AWARD_ACTIVATION_PENDING'){
            						isDisabledDeleteButton=false;
            					}
            					if(cmp.get('status') == 'SCHOLARSHIP_ACTIVATED'){
            						isDisabledDeleteButton=false;
            						awardedRecordCount++;
            					}
            				});
            				if(awardedRecordCount>1){
            					isDisabledDeleteButton=true;
            				}
            				gridView.down('#btnDelete').setDisabled(isDisabledDeleteButton);
            				gridView.down('#transferScholarshipApplicant').setDisabled(true);
            			}else{
            				gridView.down('#btnDelete').setDisabled(true);
            				gridView.down('#transferScholarshipApplicant').setDisabled(false);
            			}
            		
            	},afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						me.addDataGridConfigButton(grid,me.getSCHOLARSHIP_AWARDEE_PRIVILEGES());
						 me.doAccessControlValidation(grid, me.getSCHOLARSHIP_AWARDEE_PRIVILEGES());
					},500);
				}
            },
            'scholarshipStudentAwardeeListGrid':{
            	selectionchange:function(cmp,record){
            		var gridView = this.getScholarshipStudentAwardeeListGrid();
            		var isDisabledDeleteButton=true;
            		var isDisabledActivateSchl=true;
            		var awardedRecordCount=0;
            		if(!this.transactionInprogress){
            			if(record.length){
            				record.forEach(function(cmp){
            					if(cmp.get('status') == 'AWARD_ACTIVATION_PENDING'){
            						isDisabledActivateSchl=false;
            						isDisabledDeleteButton=false;
            					}
            					if(cmp.get('status') == 'SCHOLARSHIP_ACTIVATED'){
            						isDisabledDeleteButton=false;
            						awardedRecordCount++;
            					}
            				});
            				if(awardedRecordCount>1){
            					isDisabledDeleteButton=true;
            				}
            				gridView.down('#btnDelete').setDisabled(isDisabledDeleteButton);
            				gridView.down('#activateScholarshipStudent').setDisabled(isDisabledActivateSchl);
            			}else{
            				gridView.down('#btnDelete').setDisabled(true);
            				gridView.down('#activateScholarshipStudent').setDisabled(true);
            			}
            		}else{
         			   showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PREVIOUS_REQUEST_ALREADY_IN_PROGRESS'));
            		}
            	},
            	afterrender:function(grid){
					var me = this;
					setTimeout(function(){
						 me.doAccessControlValidation(grid, me.getSCHOLARSHIP_AWARDEE_PRIVILEGES());
						me.addDataGridConfigButton(grid,me.getSCHOLARSHIP_AWARDEE_PRIVILEGES());
					},500);
				}
            },'scholarshiplistingsearchform multiselectcombofield[itemId=accountingYear]':{
            	change:function(combo, records, eOpts){
            		var accountYears;
            		   var scholarshipId=this.getScholarshipListingSearchForm().down('#scholarshipId');
         		var accountYearId = combo.getValue();
         		 if(accountYearId && accountYearId.length == 1 && !Ext.isEmpty(accountYearId[0])){
        			 try{
        				 accountYears=Ext.pluck(Ext.pluck(accountYearId, 'data'), 'id').join(',')
        			 }catch(e){
        				 accountYears=accountYearId.join(',')
        			 }
        			 
           		 }else if(accountYearId && accountYearId.length >1){
           			 try{
        				 accountYears=Ext.pluck(Ext.pluck(accountYearId, 'data'), 'id').join(',')
        			 }catch(e){
        				 accountYears=accountYearId.join(',')
        			 }
           		 }
         		   if(scholarshipId){
         			  scholarshipId.getStore().getProxy().extraParams ={
         				 accountingYearIds:accountYears
         		   }
         			 scholarshipId.reset();
         			 scholarshipId.getStore().load();
         	   }
            	}
            },
            'scholarshipApplicantAwardeeListGrid button[itemId=transferScholarshipApplicant]':{
            	    click:function(){
            		var this$ = this;
            		Ext.Ajax.request({
            			            method: "POST",
            			            type: 'rest',
            			            url: SERVERURL.PATH_SCHOLARSHIP_TRANSFER,
            			success : function(res, action) {
							   showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('APPLICANT_SCHOLARSHIP_INFORMATION_SUCCESSFULLY_TRANSFERRED_INTO_THE_STUDENT_ACCOUNT'));
            			}
            		               	
            		});    
            	}	
            },
            'scholarshipStudentAwardeeListGrid button[itemId=activateScholarshipStudent]':{
            	    click:this.activateScholarshipForStudent
            },
            'scholarshiplistingsearchform customcombobox[itemId=studentId]' : {
      			afterrender : function(combo) {
      				var isactive,form =  combo.up('form'),$this=this,
      				statusCombo = form.down('#stdStatus'),
      				store = combo.getStore();
      				store.on('beforeload',function() {
      					if($this.getContentPanel() && $this.getContentPanel().activeTab && $this.getContentPanel().activeTab.title==getMegaMenuTranslation("SS_SCHOLARSHIP_LISTING")){
      						if(statusCombo.getValue()==="ACTIVE"){
      							isactive=true;
      						}else if(statusCombo.getValue()==="INACTIVE"){
      							isactive=false;
      						}else{
      							isactive='All'; 
      						}
      						store.getProxy().extraParams.status = isactive;
      					}
      				}, this);
      			}
      		},
      		'scholarshiplistingsearchform customcombobox[itemId=stdStatus]' : {
      			select : function(combo) {
      				var form =  combo.up('form');
      				form.down('#studentId').reset();
      				
      			}
      		},
    	});
    },
    
    /**** Export function *******/
    
    exportScholarshipList : function(exportUrl,filetype,whetherAll) {
//    	var quickSearchForm=this.getScholarshipListForm();
    	var quickSearchForm = this.getScholarshipListingSearchForm();
    	var searchResultGrid = this.getSearchResultGrid();
    	var pagingtoolbaroptions = this.getSearchResultGrid().down('pagingtoolbar').getStore().lastOptions;
    	var searchCriteriaString=this.createSearchCriteriaString(quickSearchForm);
    	var jsonFormatFormData=this.createJsonFormat(quickSearchForm);
    	var visibleColumns=this.getVisibleColumns(searchResultGrid);
        var reportTitle=getCommonTranslation('SCHOLARSHIP_LIST');
		if(!isEmpty(searchResultGrid.store.getCurrentSortCriteria()) &&searchResultGrid.store.getCurrentSortCriteria()!=undefined && searchResultGrid.store.getCurrentSortCriteria()!=null)
			jsonFormatFormData.sortCriterias=searchResultGrid.store.getCurrentSortCriteria();
		searchResultGrid.exportData(exportUrl, filetype, jsonFormatFormData, pagingtoolbaroptions,whetherAll,searchCriteriaString,visibleColumns,reportTitle);
	},
	createSearchCriteriaString: function(searchForm) {
    	var me=this;
        var formValues = new Array();
        formValues = searchForm.getValues();        
        var searchCriteriaString="";
        for (var key in formValues) {
        	var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        searchCriteriaString=searchCriteriaString+keyValueJsonObject.paramCode+"  : "+searchForm.getForm().findField(key).getRawValue() + " ,";
            }
        }
        searchCriteriaString=searchCriteriaString.substring(0, searchCriteriaString.length-1);
        return searchCriteriaString;
    },
    
    showAwardeeWindow:function(){
    	var window = this.getAddAwardeeWindow();
		 if (!window) {
	            window = Ext.widget('addawardee');
	     }
	     window.show();	     
    },
    
    loadGridAndSearchUsers: function(btn) {
    	var me = this,academyLocationIds,accountingYearId,programId,studentStatus,
    	searchForm = me.getScholarshipListingSearchForm(),
    	serachFormVal=searchForm.getValues();
    	 btn.setDisabled(true);
    	 if(serachFormVal.scholarshipAcademyLocationId && serachFormVal.scholarshipAcademyLocationId.length == 1 && !Ext.isEmpty(serachFormVal.scholarshipAcademyLocationId[0])){
   			academyLocationIds=Ext.pluck(Ext.pluck(serachFormVal.scholarshipAcademyLocationId, 'data'), 'id').join(',')
   		 }else if(serachFormVal.scholarshipAcademyLocationId  && serachFormVal.scholarshipAcademyLocationId.length >1){
   			academyLocationIds=Ext.pluck(Ext.pluck(serachFormVal.scholarshipAcademyLocationId, 'data'), 'id').join(',')
   		 }
    	 if(serachFormVal.accountingYear && serachFormVal.accountingYear.length == 1 && !Ext.isEmpty(serachFormVal.accountingYear[0])){
    		 accountingYearId=Ext.pluck(Ext.pluck(serachFormVal.accountingYear, 'data'), 'id').join(',')
		 }else if(serachFormVal.accountingYear  && serachFormVal.accountingYear.length >1 ){
			 accountingYearId=Ext.pluck(Ext.pluck(serachFormVal.accountingYear, 'data'), 'id').join(',')
		 }
    	 if(serachFormVal.programId && serachFormVal.programId.length == 1 && !Ext.isEmpty(serachFormVal.programId[0])){
    		 programId=Ext.pluck(Ext.pluck(serachFormVal.programId, 'data'), 'id').join(',')
		 }else if(serachFormVal.programId && serachFormVal.programId.length >1 ){
			 programId=Ext.pluck(Ext.pluck(serachFormVal.programId, 'data'), 'id').join(',')
		 }
    	 if(serachFormVal.stdStatus==="ACTIVE"){
  		   studentStatus=true;
  	   }else if(serachFormVal.stdStatus==="INACTIVE"){
  		   studentStatus=false;
  	   }else{
  		   studentStatus='All'; 
  	   }
    	 if(serachFormVal.requesterType == "Student"){
  		   gridView = me.getScholarshipStudentAwardeeListGrid();
  		   delete serachFormVal.applicantId; 
  		   gridView.getStore().getProxy().extraParams = {
  			 academyLocationIds:academyLocationIds,
  			applicableFor:serachFormVal.requesterType	,
  			accountingYearId:accountingYearId,
  			scholarshipId:serachFormVal.scholarshipId,
  			scholarshipCategory:serachFormVal.scholarshipCategoryId,
  			studentId:serachFormVal.studentId,
  			programId:programId,
  			amountType:serachFormVal.AMOUNT_TYPE,
  			disbursementMode:serachFormVal.DISBURSEMENT_MODE,
  			bursaryStatus:serachFormVal.scholarshipStatus,
  			studentStatus:studentStatus
  	       };
  	   }else{
  		   gridView = me.getScholarshipApplicantAwardeeListGrid();
  		   delete serachFormVal.studentId;
  		 
  		 gridView.getStore().getProxy().extraParams = {
  			 		academyLocationIds:academyLocationIds,
  		  			applicableFor:serachFormVal.requesterType	,
  		  			accountingYearId:accountingYearId,
  		  			scholarshipId:serachFormVal.scholarshipId,
  		  			scholarshipCategory:serachFormVal.scholarshipCategoryId,
  		  			applicantId:serachFormVal.applicantId,
  		  			programId:programId,
  		  			amountType:serachFormVal.AMOUNT_TYPE,
  		  			disbursementMode:serachFormVal.DISBURSEMENT_MODE,
  		  			bursaryStatus:serachFormVal.scholarshipStatus
  	       };
  	   }
    	 gridView.getSelectionModel().deselectAll();
  	   gridView.getStore().load(function(){
  		   btn.setDisabled(false);
  	   })
    },
    
    createJsonFormat: function(scholsearchviewForm) {
    	//var me=this;
        var formValues = new Array();
        var values = new Object();
        var searchcriteria = new Array();

        values.configCode = CONSTANTS.CB.SCHOLARSHIP_LIST_BASIC_CONFIGCODE;

        formValues = scholsearchviewForm.getValues();
        /*for (var key in formValues) {
            var value = formValues[key];            
            if(!isNullOrEmpty(value) && value !=='All' && key !== 'selectedNameField'){
                var keyValueJsonObject = me.getJsonObject( key , value);
    	        me.pushJsonObjectInArray(keyValueJsonObject,searchcriteria);
            }
        }*/

        var SCHOLARSHIP_ID = this.getJsonObject('SCHOLARSHIP_ID', formValues.SCHOLARSHIP_ID);
        this.pushJsonObjectInArray(SCHOLARSHIP_ID,searchcriteria);

       /* var SCHOLARSHIP_NAME = this.getJsonObject('SCHOLARSHIP_NAME',formValues.SCHOLARSHIP_NAME);
        this.pushJsonObjectInArray(SCHOLARSHIP_NAME,searchcriteria);*/

        var STUDENT_ID = this.getJsonObject('STUDENT_ID',formValues.STUDENT_ID);
        this.pushJsonObjectInArray(STUDENT_ID, searchcriteria);
        
        var LOCATION_NAME = this.getJsonObject('LOCATION_NAME',this.getCurrentAcademyLocation());
        this.pushJsonObjectInArray(LOCATION_NAME, searchcriteria);
        
        if(formValues.ORGANIZATION_NAME!=='All'){
	        var ORGANIZATION_NAME = this.getJsonObject('ORGANIZATION_NAME',formValues.ORGANIZATION_NAME);
	        this.pushJsonObjectInArray(ORGANIZATION_NAME, searchcriteria);
        }

        if (formValues.AMOUNT_TYPE !=='All'){
        var SCHOLARSHIP_AMOUNT_TYPE = this.getJsonObject('AMOUNT_TYPE',
        formValues.AMOUNT_TYPE);
        this.pushJsonObjectInArray(SCHOLARSHIP_AMOUNT_TYPE,searchcriteria);
        }
        
        if (formValues.SCHOLARSHIP_STATUS !=='All'){
        	 var status=null;
        	if(formValues.SCHOLARSHIP_STATUS=='Active') {
        		status=true;
        	} else if(formValues.SCHOLARSHIP_STATUS=='Inactive'){
        		status = false;
        	}
	       var SCHOLARSHIP_STATUS = this.getJsonObject('SCHOLARSHIP_STATUS', status);
	        this.pushJsonObjectInArray(SCHOLARSHIP_STATUS,searchcriteria);
        }
        /*var IS_CURRENT_SECTION= this.getJsonObject('IS_CURRENT_SECTION', true);
        this.pushJsonObjectInArray(IS_CURRENT_SECTION,searchcriteria);
        
        var IS_CURRENT_PERIOD= this.getJsonObject('IS_CURRENT_PERIOD', true);
        this.pushJsonObjectInArray(IS_CURRENT_PERIOD,searchcriteria);*/
        
        if (formValues.SCHOLARSHIP_TYPE !=='All'){
	        var SCHOLARSHIP_TYPE = this.getJsonObject('SCHOLARSHIP_TYPE',
	        formValues.SCHOLARSHIP_TYPE);
	        this.pushJsonObjectInArray(SCHOLARSHIP_TYPE,searchcriteria);
        }
        
        if (formValues.DISBURSEMENT_MODE !=='All'){
	        var DISBURSEMENT_MODE = this.getJsonObject('DISBURSEMENT_MODE',
	        formValues.DISBURSEMENT_MODE);
	        this.pushJsonObjectInArray(DISBURSEMENT_MODE,searchcriteria);
        }

        if (formValues.SELECTION_TYPE !=='All'){
	        var SELECTION_TYPE = this.getJsonObject('SELECTION_TYPE', formValues.SELECTION_TYPE);
	        this.pushJsonObjectInArray(SELECTION_TYPE,searchcriteria);
        }

        if (formValues.ACADEMY_NAME !== 'All') {
            var ACADEMY_IDS = this.getJsonObjectFromArray('ACADEMY_NAME', formValues.ACADEMY_NAME);
            this.pushJsonObjectInArray(ACADEMY_IDS, searchcriteria);
        }

        if (formValues.LOCATION_NAME !== 'All') {
            var LOCATION_IDS = this.getJsonObjectFromArray('LOCATION_NAME', formValues.LOCATION_NAME);
            this.pushJsonObjectInArray(LOCATION_IDS, searchcriteria);
        }

        values.searchCriterias = searchcriteria;
        return values;
    },
    
    /**
     * Method to get the json Objects from the selected fields of the 
     * Search form
     * @author Akshay.Kalbhor
     */
    getJsonObject: function(key, rawvalue, additionalValue) {
    	var value = rawvalue;
    	if(rawvalue !== true && rawvalue !== false) {
    		rawvalue = rawvalue.toString();
    		value = rawvalue.trim();	
    	}
    	
        if (value != '' && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        } else if (value != '' && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value, additionalValue]
            };
        }else if ((value ===true || value===false) && additionalValue == undefined) {
            return {
                "paramCode": key,
                "paramValues": [value]
            };
        }else if ((value ===true || value===false) && additionalValue != undefined) {
            return {
                "paramCode": key,
                "paramValues": [value,additionalValue]
            };
        }
    },
    
    /**
     * Method to get the array of selected ids from the array of objects
     * @author Akshay.Kalbhor 
     */
    getJsonObjectFromArray: function(key, array) {
    	var idArray = new Array();
    	Ext.each(array, function(arrayObj) {
    		if(arrayObj != "All" && arrayObj != "" && arrayObj instanceof Object) {
    			idArray.push(arrayObj.getId());	
    		} else if(arrayObj != "All" && arrayObj != ""){
    			idArray.push(arrayObj);
    		}
    	});
    	
    	return {
            "paramCode": key,
            "paramValues": idArray
        };
    },
    
    pushJsonObjectInArray: function(object, array) {
        if (object && !isNullOrEmpty(object.paramValues[0])) {
            array.push(object);
        }
    },
    
    gridRenderFunction: function(grid) {
    	grid.addButtonToolbar();
    	var moreActionButton={
    			xtype : 'splitbutton',
    			itemId:'spBtnMoreActions',
    			text : getCommonTranslation('MOREACTIONS'),//More Actions
    			menu:[{
    				text:getCommonTranslation('VIEW_AWARDEES'),//View no. of Awardees
    				itemId:'viewAwardees'
    			}],
    			listeners: { click: function() { this.showMenu(); } }
    	};
    	//grid.down('#functionButtonsToolbar').add(moreActionButton);
    	grid.down('#functionButtonsToolbar').insert(4,moreActionButton);
    },
   
    /**
     *
     * method to do the validation if the user has access to the records edit/delete functionality,
     * calls AccessControlManager's checkFeaturePrivelages() which returns a list of permissions.
     * @param {Object} the reference of the grid.
     */
    //TODO: moved in base controller, remove it
   /* doAccessControlValidation: function(grid) {
		selectedRecord = grid.getSelectionModel().getSelection()[0];
		
		//Change the name of the grid according to your implementation
		searchResultGrid = this.getSearchResultGrid();
		var associatedAcadLocations = new Array();
		var associatedAcadLocationIds = new Array();
		var permissionsMap = new Ext.util.HashMap();
		permissionsMap = this.getSCHOLARSHIP_LISTING_PERMISSIONS(); 

		//Change the name of the key that you recieve from server side according to your implementation
		associatedAcadLocations = selectedRecord.raw.SCHOL_M_KEY;
		Ext.each(associatedAcadLocations, function(acadLocation) {
			associatedAcadLocationIds.push(acadLocation.ACADEMY_LOCATION_ID);
		});
		permissionsMap = this.getSCHOLARSHIP_LISTING_PERMISSIONS();
	
		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
		searchResultGrid.disableButtonsByPivileges(permissionList);
	},*/
	
	/**
	 * method to show student details on search
	 */

	'refAddAwardee #viewComponent': {

    render: function(component) {

    //  var me = this;              

      component.getEl().on('click', function(e) {                                                           

                 var viewDetailsFormWindow=Ext.widget('viewdetailsform');                                                      

                 viewDetailsFormWindow.show();

      });

    	}
	},
	
	/*
     * This function is used for to show awardee details Dialog box with values of selected record after clicking on edit button   
     */
    editAwardee: function(gridButton, isView) {
        var me = this;        
        var grid = me.getSearchResultGrid();        
        if (grid.getSelectionModel().getCount() > 0) {                       
            var record = grid.getSelectionModel().getSelection()[0];      
            if (!isNullOrEmpty(record.get('ID'))) {            	                                               
                Ext.Ajax.request({
                    type: 'rest',                    
                    url:  SERVERURL.SCHOLARSHIP_AWARDEE_FINDBY_ID,    //URL-:rest/scholarshipAwardee/findById													 
                    method: 'GET',                    
                    params: {
                        id:record.get('ID')
                    },
                    success: function(form, action) {                    	
                    	var formDataObject = eval("(" + form.responseText + ")");
                    	me.showAwardeeWindow();
                    	var addAwardeeWindow = me.getAddAwardeeWindow();
                        var addAwardeeForm = addAwardeeWindow.down('#addAwardeeForm');
                        formDataObject.admissionId=formDataObject.admissionId.toString();
                        if(!isNullOrEmpty(formDataObject.appliedOn))
                        	formDataObject.appliedOn = new Date(formDataObject.appliedOn);
                        if(!isNullOrEmpty(formDataObject.awardedOn))
                        	formDataObject.awardedOn = new Date(formDataObject.awardedOn);
                        if(!isNullOrEmpty(formDataObject.validFrom))
                        	formDataObject.validFrom = new Date(formDataObject.validFrom);
                        if(!isNullOrEmpty(formDataObject.validUpto))
                        	formDataObject.validUpto = new Date(formDataObject.validUpto);
                        addAwardeeForm.getForm().setValues(formDataObject);
                        /* [ISSUE # 37524]Check if currency object is not null and set the value , Commented as The currency field is not in hotgloo/srs*/
                       /* if(!isNullOrEmpty(formDataObject.currency)) {
                        	var currencyField = addAwardeeWindow.down('#currencyCmb');
                        	currencyField.setValue(formDataObject.currency.value)
                        	currencyField.id = formDataObject.currency.id;
                        }*/
                        
                        var scholarshipCombo = addAwardeeWindow.down('combo#scholarshipCmp');
                        scholarshipCombo.setReadOnly(true);
                        
                        var studentLiveSearchCombo = addAwardeeWindow.down('combo#studentCmp');
            			var model = Ext.create('Academia.model.common.IdValueCodeDataModel');
            			model.set('id', formDataObject.studentId);
            			model.set('value', record.raw.STUDENT_NAME);
            			studentLiveSearchCombo.setValue(model);
            			studentLiveSearchCombo.setDisabled(false);
                        studentLiveSearchCombo.setReadOnly(true);
                        /*
                         * set the program Combo uneditable
                         */
                        if(!isNullOrEmpty(formDataObject.studentId)){
                        	var programCombo=addAwardeeWindow.down('#programId');
                        	programCombo.getStore().load({
                        		params:{
                        			studentId:formDataObject.studentId
                        		},
                        	    callback: function(records, operation, success) {
                        	    	programCombo.setValue(formDataObject.programId);
                        	    	programCombo.setReadOnly(true);
                        	    }
                        	});
                        }
                        /*
                         * Code to disable the amount field for editing based on the scholarship type 
                         */
                        if(formDataObject.amountType === "FIX") {
                        	var scholarshipAmount = addAwardeeWindow.down('numberfield#scholarshipAmount');
                        	scholarshipAmount.setReadOnly(true);
                        }
                        /*
                         * TODO: Bring the scholarship Amount Type id from CB XML of scholarshipListing and
                         * if Scholarship Type is Adhoc then set the amount field editable
                         * if scholarship Type is Fixed then set the amount field non-editable
                         */
                        //if(record.raw.)
                    	if(isView){                   
                        	addAwardeeWindow.down('#addAwardeeBtn').setVisible(false);
                            me.toggleReadOnlyFormItems(addAwardeeForm.getForm(), true);
                        }
                    }
                });                                
            }
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }
    },
    
	/**
     * This function is used for to delete Awardee after clicking on delete button   
     */
    deleteAwardee: function() {   
    	var me=this;        
        var grid=me.getSearchResultGrid();              
        if (grid.getSelectionModel().getCount() > 0) {           	        		            	
                showConfirmMessage(getCommonTranslation('DELETE_AWARDEE'), getCommonTranslation('DELETE_CONFIRM_MESSAGE'), function(btn, text) {
                    if (btn == 'yes') {
                        if (grid.getSelectionModel().getCount() > 0) {
                        	var records = grid.getSelectionModel().getSelection();
                            for (var count = 0; count < records.length; count++) {
                                var id = "";
                                if (!isNullOrEmpty(records[count].get("ID"))) {
                                    id = records[count].get("ID");
                                }
                                Ext.Ajax.request({
                                    type: 'rest',
                                    url:  SERVERURL.SCHOLARSHIP_AWARDEE_DELETE,    //URL-:rest/scholarshipAwardee/delete													 
                                    method: 'DELETE',
                                    headers: {
                                        'Content-Type': 'application/json'
                                    },
                                    params: {
                                        id: id
                                    },
                                    success: function(form, action) {
                                    	grid.getStore().reload();
                                    	showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_AWARDEE_MSG')); //Awardee deleted successfully.
                                    }
                                });
                            }
                        }
                    }
                }
            );
        } else {
        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('PLEASE_SELECT_RECORD')); //Please select a record.
        }        
    },
    
    /*
     * This function is used for to save awardee Details after clicking on save button    
     */
    saveAwardee: function() {
    	var this$ = this; 
    	var awardeeLimitCheck=this.AWARDEE_LIMIT_CHECK;
        var addAwardeeWindow = this.getAddAwardeeWindow();
        var searchResultGrid = this.getSearchResultGrid();
        var addAwardeeForm = addAwardeeWindow.down('#addAwardeeForm');        
        var checkDateValid=this.checkDateValidations();
        if(checkDateValid){
        	var submitUrl, isUpdate = false;
            var awardeeHiddenIdField = addAwardeeForm.down('#awardee_hidden_id');
            if (isNullOrEmpty(awardeeHiddenIdField.getSubmitValue())) {        	
                submitUrl = SERVERURL.SCHOLARSHIP_AWARDEE_CREATE, //URL-/rest/scholarshipAwardee/create
                isUpdate = false;
            } else {        
                submitUrl = SERVERURL.SCHOLARSHIP_AWARDEE_UPDATE, //URL-/rest/scholarshipAwardee/update
                isUpdate = true;
            }
            var formValues = addAwardeeForm.getValues();
            formValues.studentId = formValues.studentId.id;
            delete formValues.studentName;
            var jsonFormatFormData = Ext.encode(formValues);   
            this$.applyWindowMask(); 
            
            Ext.Ajax.request({
                type: 'rest',
                url: submitUrl,
                jsonData: jsonFormatFormData,
                method: 'POST',
                callback: function(action,success,response) {
                	this$.hideWindowMask();
                	//var responseObject = eval("(" + response.responseText + ")"); //make object of response text
                	var data=Ext.decode(response.responseText);
                	addAwardeeWindow.close();
                	if(success){
	                	if(response.responseText===awardeeLimitCheck){
	                		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('MAXIMUM_AWARDEE_LIMIT_MSG')); //Maximum awardee limit has reached
	                	}else{
	                		this$.loadGridAndSearchUsers();
	                		searchResultGrid.getStore().reload();
	                        searchResultGrid.getSelectionModel().deselectAll();                
	                        if (isUpdate) {
	                            showSuccessMessage(getCommonTranslation('UPDATE_AWARDEE'), getCommonTranslation('UPDATE_AWARDEE_MSG')); //Awardee updated successfully												
	                        } else {
	                        	showSuccessMessage(getCommonTranslation('ADD_AWARDEE'), getCommonTranslation('ADD_AWARDEE_MSG')); //Awardee added successfully												
	                        }
	                	}
                	} else {
                		if(!isNullOrEmpty(data)&&data[0].key==="scholarship_awardee_not_associated_with_sch_programs"){
                    		showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SCHOLARSHIP_AWARDEE_NOT_ASSOCIATED_WITH_SCH_PROGRAMM')); //scholarship_awardee_not_associated_with_sch_programs
                		}
                		
                	}
                },
                failure: function(form, action) {
                	this$.hideWindowMask();
                	addAwardeeWindow.close();
                   // searchResultGrid.getStore().reload();                																	
                }
            });
        }        															
    },
    
    /*
     * This function is used for to enable or disable form fields after clicking on edit button    
     */
    enableDisableFields:function(me){
    	 var addAwardeeWindow = me.getAddAwardeeWindow();
         var addAwardeeForm = addAwardeeWindow.down('#addAwardeeForm');
         addAwardeeForm.getForm().getFields().each(function(field) {    	
             if(field.itemId==='scholarshipCmp'||
            		 field.itemId==='studentCmp'||
            		 field.itemId==='programId'){
            	 field.setReadOnly(true);
             }        	 
         });         
    },
    
    /*
     * This function is used for to enable or disable search form fields     
     */
   /* enableDisableSearchComponents:function(me,cmp,isDisabled){
   	var  = me.getScholarshipListingSearchForm();        
    	 scholarshipListingSearchForm.getForm().getFields().each(function(field) {    	
            if(field.itemId!==cmp.itemId){
           	 	field.setDisabled(isDisabled);
            }        	 
        });         
   	
   	console.log(scholarshipListingSearchForm )
   	var scholarshipListForm =  scholarshipListingSearchForm.down('form#scholarshipList');
   	scholarshipListForm.down('textfield#scholList_scholId').setDisabled(isDisabled);
   	//scholarshipListForm.down('textfield#scholList_scholName').setDisabled(isDisabled);
   	scholarshipListForm.down('textfield#scholList_studId').setDisabled(isDisabled);
   	scholarshipListForm.down('combo#scholList_disbursmentMode').setDisabled(isDisabled);
   	scholarshipListForm.down('combo#scholList_amountType').setDisabled(isDisabled);
   	scholarshipListForm.down('combo#scholList_status').setDisabled(isDisabled);
   	scholarshipListForm.down('combo#scholList_scholType').setDisabled(isDisabled);
   	scholarshipListForm.down('combo#scholList_organisation').setDisabled(isDisabled);
   	scholarshipListForm.down('combo#scholList_selectionType').setDisabled(isDisabled);
   	scholarshipListForm.down('multiselectcombofield#ACADAMY').setDisabled(isDisabled);
   	scholarshipListForm.down('multiselectcombofield#LOCATION').setDisabled(isDisabled);
    	
    	
    	
    	var scholarshipListingSearchForm = this.getScholarshipListingSearchForm();
    	var scholarshipListForm =  scholarshipListingSearchForm.down('form#scholarshipList');
    	var scholarshipId = scholarshipListForm.down('textfield#scholList_scholId');
       	var scholarshipName = scholarshipListForm.down('textfield#scholList_scholName');
       	var studentId = scholarshipListForm.down('textfield#scholList_studId');
       	var disbursementMode = scholarshipListForm.down('combo#scholList_disbursmentMode');
       	var amountType = scholarshipListForm.down('combo#scholList_amountType');
       	var scholarshipStatus = scholarshipListForm.down('combo#scholList_status');
       	var scholarshipType = scholarshipListForm.down('combo#scholList_scholType');
       	var organization = scholarshipListForm.down('combo#scholList_organisation');
       	var selectionType = scholarshipListForm.down('combo#scholList_selectionType');
       	var academy = scholarshipListForm.down('multiselectcombofield#ACADAMY');
       	var location = scholarshipListForm.down('multiselectcombofield#LOCATION');
       	
    	var scholarshipListForm =  scholarshipListingSearchForm.down('form#scholarshipList');
        var refScholarshipId = searchFormRef.down("#scholMaster_scholId");
        var refScholarshipName = searchFormRef.down("#scholMaster_scholName");
        var statusCombo = searchFormRef.down("#scholMaster_status");
        var amountType = searchFormRef.down("#scholMaster_amountType");
        var scholType = searchFormRef.down("#scholMaster_scholType");
        var refOrganization = searchFormRef.down("#scholMaster_organisation");
        var refDisbursementMode = searchFormRef.down("#scholMaster_disbursmentMode");
        var academyCombo = searchFormRef.down('#academyCombo');
        var locationCombo = searchFormRef.down('#locationCombo');
        //var searchRef = this.getScholarshipForm();

        if (cmp.itemId === 'scholList_scholId') {
        	scholarshipName.disable(true);
        } else if (cmp.itemId === 'scholList_scholName') {
        	scholarshipId.disable(true);
        }

         Common fields to be disabled irrespective of the fields 
        studentId.disable(true);
        disbursementMode.disable(true);
        amountType.disable(true);
        scholarshipStatus.disable(true);
        scholarshipType.setDisabled(true);
        organization.setDisabled(true);
        selectionType.disable(true);
        academy.setDisabled(true);
        location.setDisabled(true);

        if (scholarshipId.value === "" && scholarshipName.value === "") {
        	scholarshipId.enable(true);
        	scholarshipName.enable(true);
            studentId.enable(true);
            disbursementMode.enable(true);
            amountType.enable(true);
            scholarshipStatus.enable(true);
            scholarshipType.enable(true);
            organization.enable(true);
            selectionType.enable(true);
            academy.enable(true);
            location.enable(true);
        }
   },*/
   /**
    * This method is used to clear fields on basic search Form
    * @param button which is reference of buttton
    */
   clearSearchForm : function(button){
	   var searchForm = button.up('form');
       form = searchForm.getForm();
	    form.getFields().each(function(field) {
      		field.reset();	
       });
	    searchForm.down('#requesterType').fireEvent('select',searchForm.down('#requesterType'));
	   var programId =  searchForm.down('#programId');
	   programId.getStore().removeAll();
	   programId.getStore().getProxy().extraParams ={
			  studentId:'',
			 applicationId:'',
			academyLocationIds:''
		   };
	   programId.getStore().load();
   },
   
   loadScholarshipDisbursementGridData: function(grid){
	   
	   var me=this;
	   var viewAwardeeGrid = me.getViewAwardeesGrid();
	   var scholarshipId = viewAwardeeGrid.down('#scholarship_Id').getValue();       
	   if (viewAwardeeGrid.getSelectionModel().getCount() > 0) {                       
		   var record = viewAwardeeGrid.getSelectionModel().getSelection()[0];
		   var studentId = record.get('studentId');
		   if(!isNullOrEmpty(scholarshipId)){     
			   var store = grid.getStore();
			   store.getProxy().extraParams = {
				   scholarshipId: scholarshipId,
				   studentId: studentId
               };
			   store.load({
				   callback: function(records,option,success){
                	   if(records.length > 0){
                		   var disbursementDetailsForm = me.getViewAwardeesDisbursementWindow().down('#disbursementDetailsForm');
                		   var noOfDisbursement = records[0].get('noOfDisbursement');
                		   var pendingDisbursement = records[0].get('pendingDisbursement');
                		   disbursementDetailsForm.down('#noOfDisbursement').setValue(noOfDisbursement);
                		   disbursementDetailsForm.down('#pendingDisbursement').setValue(pendingDisbursement);
                		   
                	   }
                	   
				   }
			   });
			   store.on('beforeload', function(store, operation) {
	                store.proxy.extraParams = {
	                		scholarshipId: scholarshipId,
	 					   studentId: studentId
	                };
			   });
		   }	
	   }
		 
   },
    
   /******************** Applying Business Rules ****************/
    checkDateValidations:function(){
    	
    	var addAwardeeWindow = this.getAddAwardeeWindow();
		var appliedOnDate= addAwardeeWindow.down('#appliedOn').getValue();
		var awardedOnDate= addAwardeeWindow.down('#awardedOn').getValue();
		var validFromDate= addAwardeeWindow.down('#validFrom').getValue();
		var validUptoDate= addAwardeeWindow.down('#validUpto').getValue();
		
		if(appliedOnDate>awardedOnDate||appliedOnDate>=validFromDate||appliedOnDate>validUptoDate){
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('GRETER_APPLIED_DATE_MSG')); //Please select valid applied date it should not be greter than award date,valid from and valid till date. 
			return false;
		}else if(awardedOnDate<validFromDate||awardedOnDate>validUptoDate){
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('GRETER_AWARD_DATE_MSG')); //Please select valid award date it should not be greter than valid from and valid till date.
			return false;            			
		}else if(awardedOnDate<appliedOnDate){
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('LOWER_AWARD_DATE_MSG')); //Please select valid award date it should not be lower than applied date.
			return false;
		}else if(validFromDate>validUptoDate){
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('GRETER_VALID_FROM_DATE_MSG')); //Please select valid from date it should not be greter than valid till date.
			return false;            			
		}else if(validFromDate>awardedOnDate){
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('LOWER_VALID_FROM_DATE_MSG')); //Please select valid from date it should not be lower than applied date and award date.
			return false;
		}else if(validUptoDate<appliedOnDate||validUptoDate<awardedOnDate||validUptoDate<validFromDate){
			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('LOWER_VALID_TILL_DATE_MSG')); //Please select valid till date it should not be lower than applied date,award date and valid from date.
			return false;
		}
		
		return true;
    },
    /**
     * @author Pravin.Surve
     * This function is to enable more action button
     */
    disableMoreActionPivileges: function(gridReference,permissionsMap) {
       	var associatedAcadLocationIds = new Array();
   		associatedAcadLocationIds.push(this.getCurrentAcademyLocation()); 
   		var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
   		var grid = this.getSearchResultGrid();
   		var button = grid.down("#spBtnMoreActions");//itemId of split button
       	
   		button.setVisible(false);
       	 
       	Ext.each(permissionList, function(privilege) {
       		if (privilege === 'MOREACTIONS') {
           		if(!isNullOrEmpty(button)){
           			button.setVisible(true);//enable more action button
           		}        		
           	}
       	});
       },
	getDownloadFile : function(documentId,fileType){

		   if(!isNullOrEmpty(documentId)){
			   var csvForm = Ext.create('Ext.form.Panel'); 
			   csvForm.getForm().submit({
				   target: '_blank',
				   method:'POST',
				   params :{
					   access_token : Ext.Ajax.defaultHeaders.access_token
				   },
				   headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
				   url: SERVERURL.IMPORT_UTILIY_DOWNLOAD_URL +'?id='+ documentId +'&fileType='+ fileType,
				   standardSubmit :true
			   });
		   }
	   },
	   popUpStudentScholarshipAwardeesList : function(){
		   var this$ = this;
		   var grid;
		   if(this.getScholarshipStudentAwardeeListGrid().isVisible()){
			   grid=this.getScholarshipStudentAwardeeListGrid();
		   }else{
			   grid=this.getScholarshipApplicantAwardeeListGrid();
		   }
		   var window = this$.getScholarshipCancelConfirmationWindow();
		   var records=grid.getSelectionModel().getSelection();						        
		   var id=records[0].get("id")
		   var status=records[0].get("status")
		   if(!window){
			   window = Ext.widget('scholarshipCancelConfirmationWindow');
		   }
		   window.show();
		   var cancellationReason=window.down('#cancellationReason');
		   var reasonForCancelScholarship = window.down('#reasonForCancelScholarship');
		   var remark = window.down('#remark');
		   if(status=='SCHOLARSHIP_ACTIVATED'){
			   cancellationReason.setVisible(true);
			   remark.setVisible(true);
			   reasonForCancelScholarship.allowBlank=true;
			   reasonForCancelScholarship.setVisible(false);
			   window.setTitle(getCommonTranslation('AWARD_CANCELLATION'));
		   }else{
			   cancellationReason.allowBlank=true;
		   }
	   },
	   deleteScholarshipAwardeesList:function(){       
		   var currentVisibleGrid;
		   var formWindow = this.getScholarshipCancelConfirmationWindow();
		   var reasonForCancelScholarship = formWindow.down("#reasonForCancelScholarship").getValue();
		   var cancellationReason = formWindow.down("#cancellationReason");
		   var remark = formWindow.down("#remark").getValue();
		   var cancellationReasonValue = cancellationReason.getDisplayValue();
		   var studentGrid = this.getScholarshipStudentAwardeeListGrid();
		   var applicantGrid = this.getScholarshipApplicantAwardeeListGrid();
		   if(!studentGrid.isHidden()){
			   currentVisibleGrid = studentGrid;
		   }else{
			   currentVisibleGrid = applicantGrid;
		   }
		   var records = currentVisibleGrid.getSelectionModel().getSelection();
		   var empAvailIds=[]; 
		   if(currentVisibleGrid.getSelectionModel().getCount() > 0) {
			   for( var i=0; i<records.length; i++ ) {
				   if(!isNullOrEmpty(records[i].data.id)){
					   empAvailIds.push(records[i].data.id);
				   }
			   }
			   var Ids = empAvailIds.join(',');
			   if(cancellationReason.isHidden()){
				   Ext.Ajax.request({
					   method : "DELETE",
					   type : 'rest',
					   headers : {
						   'Content-Type' : 'application/json'
					   },
					   url : SERVERURL.PATH_FIND_SCHOLARSHIP_AWARDE_LIST_DELETE+'?ids='+Ids+'&reasonForCancellation='+reasonForCancelScholarship,
					   success : function(form,action) {
						   Ext.getBody().unmask();
						   currentVisibleGrid.getStore().reload();
						   formWindow.close();
						   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_AWARDEE_MSG'));
					   }
				   });
			   }else{
				   Ext.Ajax.request({
					   method : "GET",
					   type : 'rest',
					   url : SERVERURL.PATH_DELETE_AWARDED_SCHOLARSHIP_REQUEST,
					   headers : {
						   'Content-Type' : 'application/json'
					   },
					   params: {
						   id:Ids,
						   reasonForCancellation : remark,
						   billCancellationReason:cancellationReasonValue,
						   billId:records[0].data.billId,
						   scholarshipId:records[0].data.scholarshipId,
						   finacialYearId:records[0].data.financialYearId,
						   raiseRequestFinancialYearId:records[0].data.raiseRequestFinancialYearId,
						   nominationId:records[0].data.nominationId,
						   raiseRequestId:records[0].data.scholarshipRaiseReqId,
						   scholarshipAwardedAmount:records[0].data.amount,
					   },
					   success : function(form,action) {
						   Ext.getBody().unmask();
						   currentVisibleGrid.getStore().reload();
						   formWindow.close();
						   showSuccessMessage(getCommonTranslation('SUCCESS'), getCommonTranslation('DELETE_AWARDEE_MSG'));
					   }
				   });
			   }
		   }
	   },
       	activateScholarshipForStudent:function(btn){
       		var $this = this;
       		var $btn=btn;
       		btn.setDisabled(true);
       		this.transactionInprogress=true;
       		var me = this,recObj,
       		paramArray=[],
       		validation_One=[],
       		validation_Two=[],
       		validation_Three=[],
            validation_Inactive_Scholarship=[],
            validation_ScholarshipInProcess=[],
       		programBatchArray=[],
       		exclusiveScholarshipArray=[],
       		studentGrid = me.getScholarshipStudentAwardeeListGrid(),
       		studentRec= studentGrid.getSelectionModel().getSelection();
       		var allowInactiveStudent=false;
       		var studentsIds = [];
       		var ownerLoggedIn;
       		var notOwnerLoggedIn;
       		var ownerIds = [];
       		var schloarshipIds = []
       		var isOwner = []
       		var isNotOwner = []
       		
       		if(studentRec && studentRec.length){
       			studentRec.forEach(function(rec){
       				
       				var ownerList = rec.data.scholarshipOwners;       				
       				if(ownerList){ 
       					ownerList.forEach(function(item){       						
       						if(item.ownerId){
       							ownerIds.push(item.ownerId)       						
	       						ownerIds.forEach(function(ownerId){
	       							if(ownerId==$this.getCurrentlyLoggedInUser().id){
	       								//ownerLoggedIn=ownerId
	       								isOwner.push(ownerId)
	       							}
	       							else{
	       								//notOwnerLoggedIn=ownerId
	       								isNotOwner.push(ownerId)
	       							}	
	       							
	       						})
       						} 
       						if(item.ownerId !== $this.getCurrentlyLoggedInUser().id){        							
       							schloarshipIds.push(item.scholarshipCode)
							}
       					})
       				}
       				recObj={
       	       				scholarshipCategory:rec.data.scholarshipCategory,
       	       			    scholarshipRaiseReqId:rec.data.scholarshipRaiseReqId,
       	       	       		nominationId:rec.data.nominationId,
       	       	       		id :rec.data.id,
       	       	       		scholarshipId:rec.data.scholarshipId,
       	       	            scholarshipCode:rec.data.scholarshipCode,
       	       	       		studentId:rec.data.studentId,
       	       	       		status:rec.data.status,
       	       	       		amount:rec.data.amount,
       	       	       		programId:rec.data.programId,
       	       	       		batchId:rec.data.batchId,
       	       	       		studentName:rec.data.studentName,
       	       	       		studentCode:rec.data.studentCode,
       	       	            scholarshipName:rec.data.scholarshipName,
       	       	            financialYearId:rec.data.financialYearId
       	       		};
       				paramArray.push(recObj);
       				if(!rec.data.studentStatus){
       					studentsIds.push(rec.data.studentCode);
       				}		
       				if(rec.data.whetherAllowInactiveStudents && !rec.data.studentStatus){  // if schl setup is allowInactive true and student status is also inactive
       					allowInactiveStudent=true;
       				}
       			})
       		
       			var jsonRec= Ext.encode(paramArray);
       			studentsIds = Ext.Array.unique(studentsIds);
       			var studentsIdsArr =  studentsIds.toString(" ").replaceAll(",",", ");
       			if (isNotOwner.length != 0) {            			
           			schloarshipIds = Ext.Array.unique(schloarshipIds);
           			var schloarshipIdsArr =  schloarshipIds.toString(" ").replaceAll(",",", ");
           			
     		          showConfirmMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATE'), getCommonTranslation('SCHOLARSHIP_OWNERSHIP_CHECK_FOR_ACTIVATE_V1') + " " + schloarshipIdsArr + ". " + getCommonTranslation('SCHOLARSHIP_OWNERSHIP_CHECK_FOR_ACTIVATE_V2'), function(btnYes, text) {
     		        	  if (btnYes == 'yes') {
     		        		  if(allowInactiveStudent && studentsIds && studentsIds.length>0){
     		        			  showConfirmMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATE'),studentsIdsArr+" "+ getCommonTranslation('STUDENTS_ARE_INACTIVE_DO_YOU_STILL_WANT_TO_PROCEED'),function(btn,text){
     		        				  if (btn == 'yes') {
     			       		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
     			       		Ext.Ajax.request({
     							method : "POST",
     							type : 'rest',
     							url : SERVERURL.PATH_ACTIVE_SCHOLARSHIP_GENERATE_CREDITNOTE_AND_CHECK_VALIDATION,
     							jsonData:jsonRec,
     							 timeout: 600000, 
     							callback: function(action,success,response) {
     								var data =Ext.decode(response.responseText);
     								$btn.setDisabled(false);
     								$this.transactionInprogress=false;
     							/*	if(data && data.length==0){
     									studentGrid.getStore().removeAll();
     									studentGrid.getStore().load();
     									 showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SCHOLARSHIP_ACTIVATED_SUCCESSFULLY'));
     								}*/ var flag=false;
     								if(data && data.length){
     									data.forEach(function(rec){
     										if(rec.isValidationFound==true && rec.messageForinsuffientAmount){
     											validation_One.push(rec.scholarshipName+' '+rec.scholarshipCode);
     											flag=true;
     										}
     										if(rec.isValidationFound==true && rec.messageForMaxperStudentAmount){
     											validation_Two.push(rec.studentName+' '+rec.studentCode);
     											flag=true;
     										}
     										if(rec.isValidationFound==true&& rec.messageForNoOFAwardees){
     											validation_Three.push(rec.scholarshipName+' '+rec.scholarshipCode);
     											flag=true;
     										}
     										if (rec.isValidationFound==true &&rec.messageForProgramBatch) {
     		                                    programBatchArray.push(rec.studentName + " " + rec.studentCode);
     		                                    flag=true;
     		                                }
     										if (rec.isValidationFound==true && !isNullOrEmpty(rec.messageForExclusiveScholarship)) {
     											exclusiveScholarshipArray.push(rec.studentName+' '+rec.studentCode);
     											flag=true;
     		                                }
                                            if (rec.isValidationFound==true && !isNullOrEmpty(rec.messageForInactiveScholarship)) {
     											validation_Inactive_Scholarship.push(rec.scholarshipCode);
     											flag=true;
     		                                }
                                            if (rec.isValidationFound==true && !isNullOrEmpty(rec.messageForScholarshipInProcess)) {
                                            	validation_ScholarshipInProcess.push(rec.studentName+' '+rec.studentCode);
     											flag=true;
     		                                }
     										
     										
     									});
     									if(validation_One && validation_One.length){
     										showWarningMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL'), getCommonTranslation('VALIDATIONALERT1')+' '+validation_One.join());
     									}
     									if(validation_Two && validation_Two.length){
     										showWarningMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL'), getCommonTranslation('VALIDATIONALERT2')+' '+validation_Two.join());
     									}
     									if(validation_Three && validation_Three.length){
     										showWarningMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL'), getCommonTranslation('VALIDATIONALERT3')+' '+validation_Three.join());
     									}
     									if (programBatchArray && programBatchArray.length) {
     		                                showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), getCommonTranslation('VALIDATIONALERT4') + " " + programBatchArray.join()+" "+ getCommonTranslation('VALIDATIONALERT5'))
     		                            }
     									if (exclusiveScholarshipArray && exclusiveScholarshipArray.length && exclusiveScholarshipArray.length>0) {
     										showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), getErrorTranslation('SELECTED_SCHOLARSHIP_IS_EXCLUSIVE_TO_OTHERS_CAN_NOT_BE_PROCESSED') + " " + exclusiveScholarshipArray.join());
     		                            }
     									if (validation_Inactive_Scholarship && validation_Inactive_Scholarship.length && validation_Inactive_Scholarship.length>0) {
     										showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), validation_Inactive_Scholarship.join() + " " + getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
     		                            }
     									if (validation_ScholarshipInProcess && validation_ScholarshipInProcess.length && validation_ScholarshipInProcess.length>0) {
     										showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), getCommonTranslation('SCHOLARSHIP_ALREADY_EXECUTED_FOR_THIS_STUDENT')+ " " + validation_ScholarshipInProcess.join());
     		                            }
     									Ext.getBody().unmask();
     									studentGrid.getStore().load();
     									
     								}
     								if(flag==false && (!data[0].key || !data[0].key=='Scholarship Already Activated') && success==true){
     									studentGrid.getStore().removeAll();
     									studentGrid.getStore().load();
     									showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SCHOLARSHIP_ACTIVATED_SUCCESSFULLY'));
     								}	
     								}
     						});
     		        	}else{
     		        		$btn.setDisabled(false);
     		        		$this.transactionInprogress=false;
     		        	}
	        			 });
	        		 }else{

  			       		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
  			       		Ext.Ajax.request({
  							method : "POST",
  							type : 'rest',
  							url : SERVERURL.PATH_ACTIVE_SCHOLARSHIP_GENERATE_CREDITNOTE_AND_CHECK_VALIDATION,
  							jsonData:jsonRec,
  							 timeout: 600000, 
  							callback: function(action,success,response) {
  								var data =Ext.decode(response.responseText);
  								$btn.setDisabled(false);
  								$this.transactionInprogress=false;
  							/*	if(data && data.length==0){
  									studentGrid.getStore().removeAll();
  									studentGrid.getStore().load();
  									 showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SCHOLARSHIP_ACTIVATED_SUCCESSFULLY'));
  								}*/ var flag=false;
  								if(data && data.length){
  									data.forEach(function(rec){
  										if(rec.isValidationFound==true && rec.messageForinsuffientAmount){
  											validation_One.push(rec.scholarshipName+' '+rec.scholarshipCode);
  											flag=true;
  										}
  										if(rec.isValidationFound==true && rec.messageForMaxperStudentAmount){
  											validation_Two.push(rec.studentName+' '+rec.studentCode);
  											flag=true;
  										}
  										if(rec.isValidationFound==true&& rec.messageForNoOFAwardees){
  											validation_Three.push(rec.scholarshipName+' '+rec.scholarshipCode);
  											flag=true;
  										}
  										if (rec.isValidationFound==true &&rec.messageForProgramBatch) {
  		                                    programBatchArray.push(rec.studentName + " " + rec.studentCode);
  		                                    flag=true;
  		                                }
  										if (rec.isValidationFound==true && !isNullOrEmpty(rec.messageForExclusiveScholarship)) {
  											exclusiveScholarshipArray.push(rec.studentName+' '+rec.studentCode);
  											flag=true;
  		                                }
                                         if (rec.isValidationFound==true && !isNullOrEmpty(rec.messageForInactiveScholarship)) {
  											validation_Inactive_Scholarship.push(rec.scholarshipCode);
  											flag=true;
  		                                }
                                         if (rec.isValidationFound==true && !isNullOrEmpty(rec.messageForScholarshipInProcess)) {
                                         	validation_ScholarshipInProcess.push(rec.studentName+' '+rec.studentCode);
  											flag=true;
  		                                }
  										
  									});
  									if(validation_One && validation_One.length){
  										showWarningMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL'), getCommonTranslation('VALIDATIONALERT1')+' '+validation_One.join());
  									}
  									if(validation_Two && validation_Two.length){
  										showWarningMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL'), getCommonTranslation('VALIDATIONALERT2')+' '+validation_Two.join());
  									}
  									if(validation_Three && validation_Three.length){
  										showWarningMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL'), getCommonTranslation('VALIDATIONALERT3')+' '+validation_Three.join());
  									}
  									if (programBatchArray && programBatchArray.length) {
  		                                showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), getCommonTranslation('VALIDATIONALERT4') + " " + programBatchArray.join()+" "+ getCommonTranslation('VALIDATIONALERT5'))
  		                            }
  									if (exclusiveScholarshipArray && exclusiveScholarshipArray.length && exclusiveScholarshipArray.length>0) {
  										showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), getErrorTranslation('SELECTED_SCHOLARSHIP_IS_EXCLUSIVE_TO_OTHERS_CAN_NOT_BE_PROCESSED') + " " + exclusiveScholarshipArray.join());
  		                            }
  									if (validation_Inactive_Scholarship && validation_Inactive_Scholarship.length && validation_Inactive_Scholarship.length>0) {
  										showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), validation_Inactive_Scholarship.join() + " " + getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
  		                            }
  									if (validation_ScholarshipInProcess && validation_ScholarshipInProcess.length && validation_ScholarshipInProcess.length>0) {
 										showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), getCommonTranslation('SCHOLARSHIP_ALREADY_EXECUTED_FOR_THIS_STUDENT')+ " " + validation_ScholarshipInProcess.join());
 		                            }
  									Ext.getBody().unmask();
  									studentGrid.getStore().load();
  									
  								}
  								if(flag==false && (!data[0].key || !data[0].key=='Scholarship Already Activated') && success==true){
  									studentGrid.getStore().removeAll();
  									studentGrid.getStore().load();
  									showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SCHOLARSHIP_ACTIVATED_SUCCESSFULLY'));
  								}	
  								}
  						});
	        		 } 
     		        	 }
     		        	 else{
    							$btn.setDisabled(false);
    							$this.transactionInprogress=false;

     		        	 }
       		          });
       		      }
       			else if(!isNullOrEmpty(isOwner)){  
       			if(allowInactiveStudent && studentsIds && studentsIds.length>0){
       				showConfirmMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATE'),studentsIdsArr+" "+ getCommonTranslation('STUDENTS_ARE_INACTIVE_DO_YOU_STILL_WANT_TO_PROCEED'),function(btn,text){
       				   if (btn == 'yes') { 
		       		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
		       		Ext.Ajax.request({
						method : "POST",
						type : 'rest',
						url : SERVERURL.PATH_ACTIVE_SCHOLARSHIP_GENERATE_CREDITNOTE_AND_CHECK_VALIDATION,
						jsonData:jsonRec,
						 timeout: 600000, 
						callback: function(action,success,response) {
							var data =Ext.decode(response.responseText);
							$btn.setDisabled(false);
							$this.transactionInprogress=false;
						/*	if(data && data.length==0){
								studentGrid.getStore().removeAll();
								studentGrid.getStore().load();
								 showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SCHOLARSHIP_ACTIVATED_SUCCESSFULLY'));
							}*/ var flag=false;
							if(data && data.length){
								data.forEach(function(rec){
									if(rec.isValidationFound==true && rec.messageForinsuffientAmount){
										validation_One.push(rec.scholarshipName+' '+rec.scholarshipCode);
										flag=true;
									}
									if(rec.isValidationFound==true && rec.messageForMaxperStudentAmount){
										validation_Two.push(rec.studentName+' '+rec.studentCode);
										flag=true;
									}
									if(rec.isValidationFound==true&& rec.messageForNoOFAwardees){
										validation_Three.push(rec.scholarshipName+' '+rec.scholarshipCode);
										flag=true;
									}
									if (rec.isValidationFound==true &&rec.messageForProgramBatch) {
	                                    programBatchArray.push(rec.studentName + " " + rec.studentCode);
	                                    flag=true;
	                                }
									if (rec.isValidationFound==true && !isNullOrEmpty(rec.messageForExclusiveScholarship)) {
										exclusiveScholarshipArray.push(rec.studentName+' '+rec.studentCode);
										flag=true;
	                                }
                                    if (rec.isValidationFound==true && !isNullOrEmpty(rec.messageForInactiveScholarship)) {
     											validation_Inactive_Scholarship.push(rec.scholarshipCode);
     											flag=true;
     		                        }
                                    if (rec.isValidationFound==true && !isNullOrEmpty(rec.messageForScholarshipInProcess)) {
                                    	validation_ScholarshipInProcess.push(rec.studentName+' '+rec.studentCode);
											flag=true;
		                            }
									
								});
								if(validation_One && validation_One.length){
									showWarningMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL'), getCommonTranslation('VALIDATIONALERT1')+' '+validation_One.join());
								}
								if(validation_Two && validation_Two.length){
									showWarningMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL'), getCommonTranslation('VALIDATIONALERT2')+' '+validation_Two.join());
								}
								if(validation_Three && validation_Three.length){
									showWarningMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL'), getCommonTranslation('VALIDATIONALERT3')+' '+validation_Three.join());
								}
								if (programBatchArray && programBatchArray.length) {
	                                showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), getCommonTranslation('VALIDATIONALERT4') + " " + programBatchArray.join()+" "+ getCommonTranslation('VALIDATIONALERT5'))
	                            }
								if (exclusiveScholarshipArray && exclusiveScholarshipArray.length && exclusiveScholarshipArray.length>0) {
	                                showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), getErrorTranslation('SELECTED_SCHOLARSHIP_IS_EXCLUSIVE_TO_OTHERS_CAN_NOT_BE_PROCESSED') + " " + exclusiveScholarshipArray.join());
	                            }
     							if (validation_Inactive_Scholarship && validation_Inactive_Scholarship.length && validation_Inactive_Scholarship.length>0) {
     							 	showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), validation_Inactive_Scholarship.join() + " " + getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
     		                     }
     							if (validation_ScholarshipInProcess && validation_ScholarshipInProcess.length && validation_ScholarshipInProcess.length>0) {
										showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), getCommonTranslation('SCHOLARSHIP_ALREADY_EXECUTED_FOR_THIS_STUDENT')+ " " + validation_ScholarshipInProcess.join());
		                            }
								Ext.getBody().unmask();
								studentGrid.getStore().load();
								
							}
							if(flag==false && (!data[0].key || !data[0].key=='Scholarship Already Activated') && success==true){
								studentGrid.getStore().removeAll();
								studentGrid.getStore().load();
								showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SCHOLARSHIP_ACTIVATED_SUCCESSFULLY'));
							}	
							}
					});
       			}else{
       				$btn.setDisabled(false);
       				$this.transactionInprogress=false;
       			} 
				});
			}else{
	       		Ext.getBody().mask(getCommonTranslation('SUBMITTING_FORM'), 'x-mask-loading');
	       		Ext.Ajax.request({
					method : "POST",
					type : 'rest',
					url : SERVERURL.PATH_ACTIVE_SCHOLARSHIP_GENERATE_CREDITNOTE_AND_CHECK_VALIDATION,
					jsonData:jsonRec,
					 timeout: 600000, 
					callback: function(action,success,response) {
						var data =Ext.decode(response.responseText);
						$btn.setDisabled(false);
						$this.transactionInprogress=false;
					/*	if(data && data.length==0){
							studentGrid.getStore().removeAll();
							studentGrid.getStore().load();
							 showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SCHOLARSHIP_ACTIVATED_SUCCESSFULLY'));
						}*/ var flag=false;
						if(data && data.length){
							data.forEach(function(rec){
								if(rec.isValidationFound==true && rec.messageForinsuffientAmount){
									validation_One.push(rec.scholarshipName+' '+rec.scholarshipCode);
									flag=true;
								}
								if(rec.isValidationFound==true && rec.messageForMaxperStudentAmount){
									validation_Two.push(rec.studentName+' '+rec.studentCode);
									flag=true;
								}
								if(rec.isValidationFound==true&& rec.messageForNoOFAwardees){
									validation_Three.push(rec.scholarshipName+' '+rec.scholarshipCode);
									flag=true;
								}
								if (rec.isValidationFound==true &&rec.messageForProgramBatch) {
                                    programBatchArray.push(rec.studentName + " " + rec.studentCode);
                                    flag=true;
                                }
								if (rec.isValidationFound==true && !isNullOrEmpty(rec.messageForExclusiveScholarship)) {
									exclusiveScholarshipArray.push(rec.studentName+' '+rec.studentCode);
									flag=true;
                                }
                                if (rec.isValidationFound==true && !isNullOrEmpty(rec.messageForInactiveScholarship)) {
 											validation_Inactive_Scholarship.push(rec.scholarshipCode);
 											flag=true;
 		                        }
                                if (rec.isValidationFound==true && !isNullOrEmpty(rec.messageForScholarshipInProcess)) {
                                	validation_ScholarshipInProcess.push(rec.studentName+' '+rec.studentCode);
										flag=true;
	                            }
								
								
							});
							if(validation_One && validation_One.length){
								showWarningMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL'), getCommonTranslation('VALIDATIONALERT1')+' '+validation_One.join());
							}
							if(validation_Two && validation_Two.length){
								showWarningMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL'), getCommonTranslation('VALIDATIONALERT2')+' '+validation_Two.join());
							}
							if(validation_Three && validation_Three.length){
								showWarningMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL'), getCommonTranslation('VALIDATIONALERT3')+' '+validation_Three.join());
							}
							if (programBatchArray && programBatchArray.length) {
                                showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), getCommonTranslation('VALIDATIONALERT4') + " " + programBatchArray.join()+" "+ getCommonTranslation('VALIDATIONALERT5'))
                            }
							if (exclusiveScholarshipArray && exclusiveScholarshipArray.length && exclusiveScholarshipArray.length>0) {
                                showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), getErrorTranslation('SELECTED_SCHOLARSHIP_IS_EXCLUSIVE_TO_OTHERS_CAN_NOT_BE_PROCESSED') + " " + exclusiveScholarshipArray.join());
                            }
 							if (validation_Inactive_Scholarship && validation_Inactive_Scholarship.length && validation_Inactive_Scholarship.length>0) {
 							 	showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), validation_Inactive_Scholarship.join() + " " + getCommonTranslation('SCHOLARSHIP_STATUS_IS_INACTIVE'));
 		                     }
 							if (validation_ScholarshipInProcess && validation_ScholarshipInProcess.length && validation_ScholarshipInProcess.length>0) {
									showWarningMessage(getCommonTranslation("SCHOLARSHIP_ACTIVATION_UNSUCCESSFUL"), getCommonTranslation('SCHOLARSHIP_ALREADY_EXECUTED_FOR_THIS_STUDENT')+ " " + validation_ScholarshipInProcess.join());
	                            }
							Ext.getBody().unmask();
							studentGrid.getStore().load();
							
						}
						if(flag==false && (!data[0].key || !data[0].key=='Scholarship Already Activated') && success==true){
							studentGrid.getStore().removeAll();
							studentGrid.getStore().load();
							showSuccessMessage(getCommonTranslation('SUCCESS'),getCommonTranslation('SCHOLARSHIP_ACTIVATED_SUCCESSFULLY'));
						}	
						}
				});
   			
			}
       		} 
   		      else {
  		          showWarningMessage(getCommonTranslation('SCHOLARSHIP_ACTIVATE'), getCommonTranslation('PLEASE_SELECT_RECORD'));
   		      }
	       		
       		}
       		
       	}
	   
});

