/**
 * @author Sandeep.Ladvikar
 * This controller is use for Service request settings
 */
Ext.define('Academia.controller.servicerequest.ServiceRequestSetting', {
    extend: 'Academia.controller.base.BaseController',
    models: [ 'servicerequest.servicerequestsettings.RequestSetting', 
             'servicerequest.servicerequestsettings.Document'],
    stores: ['servicerequest.servicerequestsettings.ComplaintGridStore', 'servicerequest.servicerequestsettings.ServiceTypes', 
             'servicerequest.servicerequestsettings.DocumentSelector',  
             'servicerequest.servicerequestsettings.DefaultAssignees', 'servicerequest.servicerequestsettings.CertificateCategories', 
             'servicerequest.servicerequestsettings.RequestSettingGridStore', 'servicerequest.servicerequestsettings.FreeFormCategories', 
             'servicerequest.servicerequestsettings.BillingPreferences', 'servicerequest.servicerequestsettings.Documents', 
             'servicerequest.servicerequestsettings.feeRelatedCertificateCategories', 'servicerequest.servicerequestsettings.RequestStatusStore',
             'feeandpayment.FeePlan','feeandpayment.managebill.BillSequence',
             'feeandpayment.managebill.FeePlanStage','servicerequest.servicerequestsettings.AssigneeApproverGridStore',
             'servicerequest.servicerequestsettings.QuickSearchNameApprover',
             'servicerequest.servicerequestsettings.RequestAssignedUserStore','servicerequest.servicerequestsettings.HostelLeaveCategories',
             'servicerequest.servicerequestsettings.RequestAssignedUserStore',
             'servicerequest.servicerequestsettings.AssigneeApproverHostelGridStore',
             'servicerequest.servicerequestsettings.AssigneeApproverProgramLevelGridStore'],

    views: ['servicerequest.servicerequestsettings.ComplaintGrid', 'servicerequest.servicerequestsettings.RequestSettingPanel',
            'servicerequest.servicerequestsettings.StudentRequestsPanel', 'servicerequest.servicerequestsettings.RequestSettingGrid', 
            'servicerequest.servicerequestsettings.FeeRequestSettings', 'servicerequest.servicerequestsettings.RequestSettingForm', 
            'servicerequest.servicerequestsettings.RequestSettingFormWindow', 'servicerequest.servicerequestsettings.ComplaintFormWindow',
            'servicerequest.servicerequestsettings.DocumentsEditableGrid', 'servicerequest.servicerequestsettings.DocumentGridWindow',
            'servicerequest.servicerequestsettings.DocumentsGrid','common.NestedJsonCombo',
            'servicerequest.servicerequestsettings.StudentRequestSettingFormWindow',
            'servicerequest.servicerequestsettings.StudentRequestSettingForm',
            'servicerequest.servicerequestsettings.AssigneeApproverEditableGrid',
            'servicerequest.servicerequestsettings.DefaultAssigneeApproverGridWindow',
            'servicerequest.servicerequestsettings.DefaultAssigneeApproverGrid','servicerequest.servicerequestsettings.StudentHostelRequestFormWindow',
            'servicerequest.servicerequestsettings.StudentHostelRequestSettingForm','servicerequest.servicerequestsettings.AssigneeApproverEditableGridForHostel',
            'servicerequest.servicerequestsettings.DefaultAssigneeApproverGridHostelWindow',
            'servicerequest.servicerequestsettings.DefaultAssigneeApproverHostelGrid','servicerequest.servicerequestsettings.AssigneeApproverEditableProgramLevelGrid'],

    refs: [{
        ref: 'requestsettingpanel',
        selector: 'requestsettingpanel'
    }, {
        ref: 'complaintgrid',
        selector: 'complaintgrid'
    }, {
        ref: 'complaintformwindow',
        selector: 'complaintformwindow'
    }, {
        ref: 'requestSettingGrid',
        selector: 'requestsettinggrid'
    }, {
        ref: 'studentRequestPanel',
        selector: 'studentrequestpanel'
    }, {
        ref: 'requestSettingFormWindow',
        selector: 'requestsettingformwindow'
    }, {
        ref: 'feeRequestSettings',
        selector: 'feerequestsettings'
    }, {
        ref: 'documentGridWindow',
        selector: 'documentgridwindow'
    },{
    	ref: 'studentrequestsettingformwindow',
        selector: 'studentrequestsettingformwindow'
    },{
    	ref: 'studentrequestsettingform',
        selector: 'studentrequestsettingform'
    },{
    	ref: 'documentseditable',
        selector: 'documentseditable'
    },{
    	ref: 'defaultassigneeapprovergridwindow',
        selector: 'defaultassigneeapprovergridwindow'
    },{
    	ref: 'defaultassigneeapprovergrid',
        selector: 'defaultassigneeapprovergrid'
    },{
    	ref: 'studenthostelrequestsettingform',
        selector: 'studenthostelrequestsettingform'
    },{
    	ref: 'studenthostelrequestformwindow',
        selector: 'studenthostelrequestformwindow'
    },{
    	ref: 'defaultassigneeapprovergridhostelwindow',
        selector: 'defaultassigneeapprovergridhostelwindow'
    },{
    	ref: 'defaultassigneeapproverhostelgrid',
        selector: 'defaultassigneeapproverhostelgrid'
    },{
    	ref: 'assigneeapprovereditableprogramlevelgrid',
        selector: 'assigneeapprovereditableprogramlevelgrid'
    }],
    config: {
        SERVICE_REQUEST_SETTINGS_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('SERVICE_REQUEST_SETTINGS'),
        serviceRequestGroup: null,
        serviceType: null,
        isAdded: null
    },
    init: function() {
        this.control({
            'requestsettingpanel #serviceTypeCombo': {
                select: function(combo, records) {
                    var me = this;
                    me.showRequestSettingPanels(combo, records[0].get('value'));
                }
            },
            'complaintgrid': {
                render: function(grid) {
                    //if grid loading is required to be done then do it before the call to doAccessControlValidation();
                    this.doAccessControlValidation(grid, this.getSERVICE_REQUEST_SETTINGS_PERMISSIONS());
                },
                beforerender: function(grid) {
                	var store = grid.getStore();
                    var academyLocationId = this.getCurrentAcademyLocation();
                    store.getProxy().extraParams = {
                    	academyLocationId: academyLocationId
        			};
                }
            },
            'complaintgrid #btnEdit': {
                click: function(button) {
                    this.editComplaint(button);
                }
            },
            'complaintgrid #btnView': {
                click: function(button) {
                    this.viewComplaintSetting(button);
                }
            },
            'complaintformwindow #btnSaveComplaintDetails': {
                click: function(button) {
                    this.saveComplaintSettings(button);
                }
            },
            'complaintformwindow #cancelButtonId': {
                click: function(button) {
                    var window = button.up('window');
                    window.close();
                }
            },
            'studentrequestpanel': {
                tabchange:function(tabPanel, newCard, oldCard, eOpts ){
                	 var grid = newCard.down('grid');
                    grid.columnManager.headerCt.removeCls('gridFixHeader');
                    grid.dockedItems.items[0].removeCls('gridFixHeader');
                    grid.dockedItems.items[1].removeCls('gridFixHeader');
                    grid.dockedItems.items[2].removeCls('gridFixHeader');
                }
            },
            'studentrequestpanel panel': {
                activate: function(tab) {
                	tab.config.isSave = false;
                    this.onActiveTab(tab);
                }
            },
            'studentrequestpanel combo': {
                change: function(combo, newValue) {
                    var grid = combo.up('panel').down('grid');
                    var store = grid.getStore();
                    if(newValue == 'Readmission'){
                    	store.getProxy().extraParams={
                        	category :'READMISSION_REQUEST'
                        }
                    }else if(newValue == 'LEAVE'){
                    	store.getProxy().extraParams={
                        	category :newValue
                        }
                    }else if(newValue == 'ADDITIONAL_COURSE'){
                    	store.getProxy().extraParams={
                        	category :'ADDITIONAL_COURSE'
                        }
                    }
                    
                    this.loadStoreOnChangeComboValue(combo, store);
                    delete store.getProxy().extraParams.category;
                }
            },
            'feerequestsettings combo': {
                change: function(combo, newValue) {
                    var grid = combo.up('panel').down('grid');
                    var store = grid.getStore();
                    this.loadStoreOnChangeFeeRelatedComboValue(combo, store);
                }
            },
            'requestsettinggrid button#btnEdit': {
                click: function(button) {
                    this.openRequestSettingFormWindow(button);
                }
            },
            'requestsettinggrid button#btnView': {
                click: function(button) {
                    this.viewSettings(button);
                }
            },
            'requestsettingform checkbox': {
                change: function(checkbox, newValue, oldValue) {
                    this.toggleFormItemsOncheckbox(checkbox, newValue);
                }
            },
            
            'studentrequestsettingform checkbox': {
                change: function(checkbox, newValue, oldValue) {
                    this.toggleFormItemsOncheckboxStudent(checkbox, newValue);
                }
            },
            'studenthostelrequestsettingform checkbox' :{
                change: function(checkbox, newValue, oldValue) {
                    this.toggleFormItemsOncheckboxHostel(checkbox, newValue);
                }
            },
            
            'requestsettingform combo#comboFeePlanType':{
            	render:function(combo){
            		combo.getStore().load();
            	},
            	select:this.loadSelectionStageCombo
            },
            
            'requestsettingform combo#comboStage':{
            	select:this.loadFeeHeadCombo
            },
            
            'studentrequestsettingform combo#comboFeePlanType':{
            	render:function(combo){
            		combo.getStore().load();
            	},
            	select:this.loadSelectionStageCombo
            },
            
            'studentrequestsettingform combo#comboStage':{
            	select:this.loadFeeHeadCombo
            },
            
            /*'requestsettingform itemselector#documentSelector': {
            	render: function(selector) {
            		var serviceType = this.getRequestsettingpanel().down('#serviceTypeCombo').getValue(),
            		store = selector.getStore();
            		if(serviceType === 'EMPLOYEE_REQUEST'){
            			store.getProxy().extraParams = {
            				isApplicableForEmployee: true
            			};
            		}
            		else{
            			store.getProxy().extraParams = {
            				isApplicableForStudent: true
            			};
            		}
            		store.removeAll();
            		store.load({
            			callback:function(){
            				selector.bindStore(store);
            			}
            		});
            	},
                change: function(selector, newValue, oldValue) {
                    this.addCertificateToGrid(selector, newValue, oldValue, this.getIsAdded());
                }
            },*/
            /*'requestsettingform itemselector#documentSelector button': {
                click: function(button) {
                    var iconCls = button.iconCls;
                    var cls = iconCls.substr(20);
                    if (cls === 'add') {
                        this.setIsAdded(true);
                    } else if (cls === 'remove') {
                        this.setIsAdded(false);
                    }
                }
            },*/
            'requestsettingform #btnSaveRequestDetails': {
                click: function(button) {
                    this.saveRequestSettings(button);
                }
            },
            'requestsettingform #cancelButtonId': {
                click: function(button) {
                    var window = button.up('window');
                    window.close();
                }
            },
            'studentrequestsettingform #cancelButtonId': {
                click: function(button) {
                    var window = button.up('window');
                    window.close();
                }
            },
            'studenthostelrequestsettingform #cancelButtonId': {
            	 click: function(button) {
                     var window = button.up('window');
                     window.close();
                 }
            },
            'requestsettinggrid': {
                viewDocumentClicked: function(dataIndex, record) {
                    this.openDocumentGridWindow(record);
                },
                viewDefaultAssigneeClicked: function(dataIndex, record) {
                    this.openDefaultAssigneeGridWindow(dataIndex, record);
                },
                viewDefaultAssigneeHostelClicked: function(dataIndex, record) {
                    this.openDefaultAssigneeGridWindowForHostel(dataIndex, record);
                },
            	render: function(grid) {
                    this.doAccessControlValidation(grid, this.getSERVICE_REQUEST_SETTINGS_PERMISSIONS());
                }
            },
            'documentseditable#documentsEditableGridItemId':{
            	render: function(grid) {
            		var documentArray = new Array();
            		var serviceType = this.getRequestsettingpanel().down('#serviceTypeCombo').getValue(),
            		store = grid.getStore();
            		//var requestsettinggridRecord = this.getRequestsettingpanel().down('grid').getSelectionModel().getSelection()[0];
            		var reqTabPnl = this.getRequestsettingpanel().down('tabpanel');
            		var requestsettinggridRecord = '';
            		if(!isNullOrEmpty(reqTabPnl)){
            			 requestsettinggridRecord = this.getRequestsettingpanel().down('tabpanel').getActiveTab().down('grid').getSelectionModel().getSelection()[0];	
            		}
            		else{
            			requestsettinggridRecord = this.getRequestsettingpanel().down('grid').getSelectionModel().getSelection()[0];
            		}
            		
            		var documents = requestsettinggridRecord.get('documentRules');
            		if (!isEmpty(documents)) {
            			
            			Ext.each(documents, function(document) {
            				/*if(!isNullOrEmpty(document.document)){
            					var obj = {
        								type: "DOCUMENT",
        								name: document.document.name,
        								path:document.document.path
        						};
            				}*/
            				var obj = {
            						idRule:document.id,
            						id:document.documentType.id,
            						rule:document.rule,
            						ruleDescription:document.ruleDescription
            				}
            				if(!isNullOrEmpty(document.document)){
            					var obj = {
                						idRule:document.id,
                						id:document.documentType.id,
                						rule:document.rule,
                						ruleDescription:document.ruleDescription,
                						referenceDocument : document.document.name,
                						refDocumentId : document.document.id,
                						refDocumentPath : document.document.path,
                						refDocumentType : document.document.type,
                						encryptedDocId: document.document.encryptedDocId
                				}
            				}
            				
            				documentArray.push(obj);
            			});
            		}
            		
            		if(serviceType === 'EMPLOYEE_REQUEST'){
            			store.getProxy().extraParams = {
            				isApplicableForEmployee: true
            			};
            		}
            		else{
            			store.getProxy().extraParams = {
            				isApplicableForStudent: true
            			};
            		}
            		store.removeAll();
            		store.load({
            			callback:function(){
            				if(documentArray.length>0){
            					documentArray.forEach(function(docArry){
            						var idVal = docArry.id;
            						var recrd = store.findRecord('id',idVal);
            						recrd.set('idRule',docArry.idRule);
            						recrd.set('rule',docArry.rule);
            						recrd.set('ruleDescription',docArry.ruleDescription);
            						recrd.set('referenceDocument',docArry.referenceDocument);
            						recrd.set('refDocumentId',docArry.refDocumentId);
            						recrd.set('refDocumentPath',docArry.refDocumentPath);
            						recrd.set('refDocumentType',docArry.refDocumentType);
            						recrd.set('encryptedDocId', docArry.encryptedDocId);
            						recrd.commit();
            						var index = store.getById(idVal);
            						var index = store.find('id',idVal);
            						grid.getSelectionModel().select(index,true);
            						grid.up('window').body.dom.scrollTop = 0;
            					});
            				}
            				grid.bindStore(store);
            			}
            		});
            	},
            	selectionchange: function(column, selected,eOpts ){
            		var grid = this.getDocumentseditable();
            		var filefieldServiceReqSettingId = grid.down('#filefieldServiceReqSettingId');
            		if(selected.length== 1){ // enable
            			filefieldServiceReqSettingId.setDisabled(false);
            		}else{  // disable
            			filefieldServiceReqSettingId.setDisabled(true);
            		}
            	},
            	cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
 	        		var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
 	        		var $this =this;
 	        		if(columnName == "referenceDocument"){
 	        			if (e.target.tagName == 'A') {
 	        				
 	        				var whetherFile = false;
 	        				if(!isNullOrEmpty(record.data.encryptedDocId)){
 	        					var documentId = record.data.encryptedDocId;
 	            				if (!isNullOrEmpty(documentId)) {
 	            					$this.getDocumentController().downloadDocumentFile(documentId);
 	            				}
 	        				}
 	        				
 	        			} else if(e.target.tagName == 'BUTTON'){
 	        				var store = grid.getStore();
 	        				//var record = grid.getSelectionModel().getSelection()[0];
 	        				record.set('referenceDocument',null);
 	        				record.set('refDocumentPath',null);
 	        				record.set('refDocumentId',null);
 	        				record.commit();
 	        			}
 	        		}
            	}
            },
            'documentseditable filefield[itemId=filefieldServiceReqSettingId]': {
            	change: this.uploadReferenceDocumentFile
            },
            'studentrequestsettingform assigneeapprovereditablegrid#assigneeapprovereditablegridItemId':{
            	render: function(grid) {
            		var programGroupArray = new Array();
            		var serviceType = this.getRequestsettingpanel().down('#serviceTypeCombo').getValue(),
            		store = grid.getStore();
            		store.removeAll();
            		var reqTabPnl = this.getRequestsettingpanel().down('tabpanel');
            		var requestsettinggridRecord = '';
            		if(!isNullOrEmpty(reqTabPnl)){
            			 requestsettinggridRecord = this.getRequestsettingpanel().down('tabpanel').getActiveTab().down('grid').getSelectionModel().getSelection()[0];	
            		}
            		else{
            			requestsettinggridRecord = this.getRequestsettingpanel().down('grid').getSelectionModel().getSelection()[0];
            		}
            		var academyLocationId = this.getCurrentAcademyLocation();
            		var programGroupList = requestsettinggridRecord.get('serviceRequestProgramGroupConfig');
            		grid.config.programGroupList = null;
            		if (!isEmpty(programGroupList)) {
            			grid.config.programGroupList = programGroupList;
            		}
                    store.load({
                        params: {
                            academyLocationId: academyLocationId
                        }
                    });
            	}
            },
            'studentrequestsettingform assigneeapprovereditableprogramlevelgrid#assigneeapprovereditableprogramlevelgridItemId':{
            	render: function(grid) {
            		var programGroupArray = new Array();
            		var serviceType = this.getRequestsettingpanel().down('#serviceTypeCombo').getValue(),
            		store = grid.getStore();
            		store.removeAll();
            		var reqTabPnl = this.getRequestsettingpanel().down('tabpanel');
            		var requestsettinggridRecord = '';
            		if(!isNullOrEmpty(reqTabPnl)){
            			 requestsettinggridRecord = this.getRequestsettingpanel().down('tabpanel').getActiveTab().down('grid').getSelectionModel().getSelection()[0];	
            		}
            		else{
            			requestsettinggridRecord = this.getRequestsettingpanel().down('grid').getSelectionModel().getSelection()[0];
            		}
            		var academyLocationId = this.getCurrentAcademyLocation();
            		var programGroupList = requestsettinggridRecord.get('serviceRequestProgramGroupConfig');
            		grid.config.programGroupList = null;
            		if (!isEmpty(programGroupList)) {
            			grid.config.programGroupList = programGroupList;
            		}
                    store.load({
                        params: {
                            academyLocationId: academyLocationId
                        }
                    });
            	}
            },
            'studenthostelrequestsettingform assigneeapprovereditablegridforhostel#assigneeapprovereditablegridforhostelItemId':{
            	render: function(grid) {
            		var programGroupArray = new Array();
            		var serviceType = this.getRequestsettingpanel().down('#serviceTypeCombo').getValue(),
            		store = grid.getStore();
            		store.removeAll();
            		var reqTabPnl = this.getRequestsettingpanel().down('tabpanel');
            		var requestsettinggridRecord = '';
            		if(!isNullOrEmpty(reqTabPnl)){
            			 requestsettinggridRecord = this.getRequestsettingpanel().down('tabpanel').getActiveTab().down('grid').getSelectionModel().getSelection()[0];	
            		}
            		else{
            			requestsettinggridRecord = this.getRequestsettingpanel().down('grid').getSelectionModel().getSelection()[0];
            		}
            		var academyLocationId = this.getCurrentAcademyLocation();
            		var hostelList = requestsettinggridRecord.get('hostelServiceRequestSetting');
            		grid.config.hostelList = null;
            		if (!isEmpty(hostelList)) {
            			grid.config.hostelList = hostelList;
            		}
                    store.load({
                        params: {
                            academyLocationId: academyLocationId
                        }
                    });
            	}
            },
            'studentrequestsettingform #btnSaveRequestDetails': {
                click: function(button) {
                    this.saveRequestSettingsStudent(button);
                }
            },
            'studenthostelrequestsettingform #btnSaveRequestDetails': {
                click: function(button) {
                    this.saveRequestSettingsHostel(button);
                }
            },
            'studentrequestsettingform radiogroup[itemId=programGroupRadioGrp]':{
	 			  change: function( radio, newValue, oldValue, eOpts) {
	 				  this.changeProgramLevelRadioGroup(radio, newValue, oldValue);
	 			  }
	 		  },
	 		  
	 		  'studentrequestsettingform checkbox[itemId=isStudentAdivsor]':{
	 			 change: function(checkbox, newValue, oldValue) {
	 				  var itemId = checkbox.getItemId();
	 			        var form = checkbox.up('form');
	 			        var autoApprove = form.down('#autoApprove');
	 			        var programGroupGrid = form.down('#assigneeapprovereditablegridItemId');
	 			        var programLevelGrid = form.down('#assigneeapprovereditableprogramlevelgridItemId');
	 			        var radio = form.down('#programGroupRadioGrp');
	 			        var radioValue = radio.getValue().isProgramLevel;
	 			        if (itemId === 'isStudentAdivsor') {
	 			        	if (newValue) {
	 			        		autoApprove.setDisabled(true);
	 			        		autoApprove.setValue(true);
	 			        		if(radioValue){
	 			        			programLevelGrid.down('[dataIndex=assigneeId]').hide();
	 			        			programLevelGrid.down('[dataIndex=defaultAssigneeAuto]').show();
	 			        		}
	 			        		else{
	 			        			programGroupGrid.down('[dataIndex=assigneeId]').hide();
	 			            		programGroupGrid.down('[dataIndex=defaultAssigneeAuto]').show();
	 			        		}
	 			        	}else{
	 			        		autoApprove.setDisabled(false);
	 			        		autoApprove.setValue(false);
	 			        		if(radioValue){
	 			        			programLevelGrid.down('[dataIndex=defaultAssigneeAuto]').hide();
	 			        			programLevelGrid.down('[dataIndex=assigneeId]').show();
	 			        		}
	 			        		else{
	 			        			programGroupGrid.down('[dataIndex=defaultAssigneeAuto]').hide();
	 			            		programGroupGrid.down('[dataIndex=assigneeId]').show();
	 			        		}
	 			        	}
	 			        }
	                }
	 		  },
			  'studenthostelrequestsettingform checkbox[itemId=isStudentAdivsorHostel]':{
		 			 change: function(checkbox, newValue, oldValue) {
		 				  var itemId = checkbox.getItemId();
		 			        var form = checkbox.up('form');
		 			        var autoApprove = form.down('#autoApprove');
		 			        var grid = form.down('#assigneeapprovereditablegridforhostelItemId');
		 			        if (itemId === 'isStudentAdivsorHostel') {
		 			        	if (newValue) {
		 			        		autoApprove.setDisabled(true);
		 			        		autoApprove.setValue(true);
		 			        		
		 			        		grid.down('[dataIndex=assigneeId]').hide();
		 			        		grid.down('[dataIndex=defaultAssigneeAuto]').show();
		 			        	}else{
		 			        		autoApprove.setDisabled(false);
		 			        		autoApprove.setValue(false);
		 			        		
		 			        		grid.down('[dataIndex=defaultAssigneeAuto]').hide();
		 			        		grid.down('[dataIndex=assigneeId]').show();
		 			        	}
		 			        }
		                }
		 		  },
		 		'studentrequestsettingform':{
		 			render:function(form){
		 				var serviceRequestGroup = this.getServiceRequestGroup();
		 				var drool = form.down('#droolId');
		 				var whetherDuplicateRequest = form.down('#isAllowDuplicate');
		 				var autoAssignee = form.down('#isAutoAssigneeId');
		 				var comboBillingPreference = form.down('#comboBillingPreference');
		 				if(serviceRequestGroup == 'OTHER'){
		 					autoAssignee.setVisible(true);
		 					var store = comboBillingPreference.getStore(); 
		 					  store.on('load', function(){
		 						  try{
		 							 store.remove(store.getById(3));  
		 						  }catch(e){
		 							  
		 						  }
		 						 
		 					  });
		 				}else
		 				if(serviceRequestGroup == 'FREE_FORM'){
		 					drool.setVisible(true);
		 					whetherDuplicateRequest.setVisible(true);
		 					autoAssignee.setVisible(true);
		 				}else{
		 					  var store = comboBillingPreference.getStore(); 
		 					  store.on('load', function(){
		 						  try{
		 							 store.remove(store.getById(3));  
		 						  }catch(e){
		 							  
		 						  }
		 						 
		 					  });
		 				}
					  var task = new Ext.util.DelayedTask(function(){
                             var feeHeadCombo = form.down('#comboFeeHead');
                             var minimumAmount = form.down('#minimumAmount');

                             Ext.Ajax.request({
                                 type: 'rest',
                                 url: SERVERURL.PATH_FIND_ALL_FEEHEAD_AMMOUNT_BY_FEEPLANRULE_ID,
                                 method: 'GET',
                                  params: {
                                      feePlanRuleId:feeHeadCombo.getValue(),
                                   },
                                 success: function(response) {
                                     var data  = Ext.decode(response.responseText);
                                     minimumAmount.setMinValue(1);
                                     minimumAmount.setMaxValue(data.feeAmount);
                                 }
                             });

                         });

                         task.delay(2500);
		 			}
		 		}  
        });
    },

    /**
     * This method is use to show panels for the service type seleccted
     * @param combo Service type combo object
     * @param value Selected value 
     */
    showRequestSettingPanels: function(combo, value) {
        var me = this;
        switch (value) {
        case 'COMPLAINT':
            {
                var grid = Ext.widget('complaintgrid');
                me.addComponent(combo, grid);
                me.loadComplaintGrid(grid);
                break;
            }
        case 'STUDENT_REQUEST':
            {
                var panel = Ext.widget('studentrequestpanel');
                if(panel.items.items[1].title==getServiceRequestTranslation('OTHER_REQUEST')){
                    panel.items.items[1].setTitle(getServiceRequestTranslation('STUDENT_TRANSFER_REQUEST'))
                }
                me.addComponent(combo, panel);
                me.setServiceType('STUDENT_REQUEST');
				var combo = panel.down("#CERTIFICATE").down("#comboCertificateCategory");
				combo.store.clearFilter(true);
				break;
            }
        case 'EMPLOYEE_REQUEST':
            {
                var panel = Ext.widget('studentrequestpanel');
            	var examPanel = panel.down('#EXAM_RELATED');
				panel.remove(examPanel);
				var otherPanel = panel.down('#OTHER');
				panel.remove(otherPanel);
                me.addComponent(combo, panel);
				var combo = panel.down("#CERTIFICATE").down("#comboCertificateCategory");
                combo.store.filter({
                    filterFn: function(record) {
                        var flag = true;
                        if (record.get('value') == 'PROGRAM') {
                            flag = false;
                        } else {
                            flag = true;
                        }
                        return flag;
                    }
                }, this);
                
                me.setServiceType('FACULTY_REQUEST');
                break;
            }
        case 'FEE_RELATED_REQUEST':
            {
                var panel = Ext.widget('feerequestsettings');
                me.addComponent(combo, panel);
                var store = panel.down('grid').getStore();
                store.removeAll();
                me.setServiceType('FEE_RELATED_REQUEST');
                break;
            }
        case 'TERMINATION_REQUEST':
            {
                var panel = Ext.widget('requestsettinggrid');
                me.addComponent(combo, panel);
                var store = panel.getStore();
                store.removeAll();
                me.setServiceType('TERMINATION_REQUEST');
                me.setServiceRequestGroup(null);
                this.loadStoreForOtherTabs(store);
                break;
            }
        case 'TRANSFER_REQUEST':
            {
                var panel = Ext.widget('requestsettinggrid');
                var store = panel.getStore();
                store.removeAll();
                me.addComponent(combo, panel);
                me.setServiceType('TRANSFER_REQUEST');
                me.setServiceRequestGroup(null);
                this.loadStoreForOtherTabs(store);
                break;
            }
        case 'WITHDRAWAL_REQUEST':
            {
                var panel = Ext.widget('requestsettinggrid');
                var store = panel.getStore();
                store.removeAll();
                me.addComponent(combo, panel);
                me.setServiceType('WITHDRAWAL_REQUEST');
                this.loadStoreForOtherTabs(store);
                break;
            }
        case 'DEBRAMENT_REQUEST':
        {
	            var panel = Ext.widget('requestsettinggrid');
	            var store = panel.getStore();
	            store.removeAll();
	            me.addComponent(combo, panel);
	            me.setServiceType('DEBRAMENT_REQUEST');
	            me.setServiceRequestGroup(null);
	            this.loadStoreForOtherTabs(store);
	            break;
        }
        }
    },

    /**
     * This method is use to add the component in the parent panel.
     * @param combo Service type combo object
     * @param component Component to be add in the panel
     */
    addComponent: function(combo, component) {
        var parentPanel = combo.up('panel');
        var sibling = combo.up('fieldset').nextSibling();
        if (null != sibling) {
            parentPanel.remove(sibling);
        }
        parentPanel.add(component);
    },

    /**
     * This method is use to load the store of the grid. 
     * @param grid Instance of grid whose store to be load.
     */
    loadComplaintGrid: function(grid) {
        var store = grid.getStore();
        var academyLocationId = this.getCurrentAcademyLocation();
        store.load({
            params: {
                academyLocationId: academyLocationId
            }
        });
    },

    /**
     * This method is use to open the popup for edit complaint.
     * @param button 
     */
    editComplaint: function(button) {
        var grid = button.up('grid');
        if (grid.getSelectionModel().getCount() == 1) {
            var record = grid.getSelectionModel().getSelection()[0];
            var window = Ext.widget('complaintformwindow');
            var form = window.down('form');
            
            var refDefaultAssignee =  form.down('#defaultAssignee');
            var refDefaultApprover = form.down('#defaultApprover');
            
            var serviceRequestSettingStatus = form.down('#serviceRequestSettingStatus');
            serviceRequestSettingStatus.getStore().load();
            
            var assigneeStore = refDefaultAssignee.getStore();
            var approverStore = refDefaultApprover.getStore();
            
            var defaultAssignee = record.raw.defaultAssignee;
            var defaultApprover = record.raw.defaultApprover;
            if(!isNullOrEmpty(defaultAssignee)){
                assigneeStore.load({
            	callback : function(){
            		refDefaultAssignee.setValue(defaultAssignee.id);
            	}
            });
            }
             if(!isNullOrEmpty(defaultApprover)){
                approverStore.load({
            	callback : function(){
            		refDefaultApprover.setValue(defaultApprover.id);
            	}
            });
             }
            
            delete record.data.defaultAssignee ;
            delete record.data.defaultApprover;
            
            form.loadRecord(record);
            var complaintType = record.get('complaintType');
            var academyLocation = record.get('academyLocation');
            if (isNullOrEmpty(academyLocation)) {
                 academyLocation = this.getCurrentAcademyLocation();
            }
            form.down('hidden[name=academyLocation]').setValue(academyLocation);
            form.down('displayfield[name=complaintTypeField]').setValue(complaintType.value);
            form.down('hidden[name=complaintType]').setValue(Ext.encode(complaintType));
            form.down('hidden[name=version]').setValue(record.data.version);
            window.show();
        } else {
        	showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST_SETTING'), getCommonTranslation('PLEASE_SELECT_RECORD'));
        }
    },

    /**
     * This method is use to save the updated settings
     * @param button form button clicked to save the data
     */
    saveComplaintSettings: function(button) {
        var form = button.up('form');
        var values = form.getValues();
        var me = this;
        var methodType;
        values.complaintType = Ext.decode(values.complaintType);
        values.academyLocationId = values.academyLocation;
        console.log(values.requestStatusIds)
        values.requestStatusIds = this.getStatusArray(values.requestStatusIds);
        delete values.academyLocation;
        if (isNullOrEmpty(values.id)) {
            methodType = 'POST';
        } else {
            methodType = 'PUT';
        }
        var submitData = Ext.encode(values);
        me.applyWindowMask(); 
        this.sendSaveAjaxRequest(SERVERURL.COMPLAINT_SAVE, methodType, submitData, function(success) {
        	me.hideWindowMask();
            if (success) {
                var window = button.up('window');
                showSuccessMessage(getServiceRequestTranslation('GRIEVANCE_REQUEST'),getServiceRequestTranslation('SAVEDSUCCESSFULLY'));
                window.close();
                var grid = me.getComplaintgrid();
                me.loadComplaintGrid(grid);
                grid.getSelectionModel().deselectAll(true);
            }
        });
    },

    /**
     * This method is use to view the complaint settings
     * 
     */
    viewComplaintSetting: function(button) {
        this.editComplaint(button);
        var window = this.getComplaintformwindow();
        if (window) {
//            window.setTitle(getServiceRequestTranslation('VIEW_COMPLAINT_SETTINGS'));
        	 window.setTitle(getServiceRequestTranslation('VIEW_GRIEVANCE_SETTINGS'));
            var form = window.down('form');
            toggleReadOnlyFormItems(form.getForm(), true);
            form.down('#btnSaveComplaintDetails').setVisible(false);
        }
    },

    /**
     * This method is called when the tab gets activated and is use to set the 
     * service Request category config.
     * @param tab activated tab
     */
    onActiveTab: function(tab) {
        var serviceRequestGroup = tab.getItemId();
        this.setServiceRequestGroup(serviceRequestGroup);
        var store = tab.down('grid').getStore();
       
        store.removeAll();
        if (serviceRequestGroup === 'TRANSFER' || serviceRequestGroup === 'PERSONAL_DATA_CHANGE' || serviceRequestGroup === 'EXAM_RELATED') {
            var criteriaJson = this.createGridCriteria(this.getServiceType(), serviceRequestGroup);
            var store = tab.down('grid').getStore();
            this.loadServiceRequestSettingsStore(store, SERVERURL.OTHER_REQUEST_GRID, criteriaJson);
        }
         else{
        	if(serviceRequestGroup === 'OTHER'){
        		if(!tab.config.isSave){
        			tab.down('customcombobox').config.suspendChangeEvent = true;
            		tab.down('customcombobox').clearValue();
            		tab.down('customcombobox').config.suspendChangeEvent = false;
        		}
        		else{
        			var criteriaJson = this.createGridCriteria(this.getServiceType(), serviceRequestGroup);
                    var store = tab.down('grid').getStore();
                    this.loadServiceRequestSettingsStore(store, SERVERURL.OTHER_REQUEST_GRID, criteriaJson);
                    tab.config.isSave = false;
        		}
        	}
        	else{
        		tab.down('customcombobox').clearValue();
        	}

        }		
    },

    loadStoreForOtherTabs: function(store) {
	 var criteriaJson = null;
	     if(this.getServiceType()=='DEBRAMENT_REQUEST'){
		criteriaJson = this.createGridCriteria(this.getServiceType(), 'DEBARMENT');
	}else if(this.getServiceType()=='TERMINATION_REQUEST'){
		criteriaJson = this.createGridCriteria(this.getServiceType(), 'TERMINATION');
	}else{
		criteriaJson = this.createGridCriteria(this.getServiceType(), 'TRANSFER');
	}
        this.loadServiceRequestSettingsStore(store, SERVERURL.OTHER_REQUEST_GRID, criteriaJson);
    },

    /**
     * This method is use to create the criteria according to the parameters for loading the grid 
     * @param serviceType
     * @param serviceRequestGroup
     * @param certificateCategory
     * @param freeFromCategory
     */

    createGridCriteria: function(serviceType, serviceRequestGroup, certificateCategory, freeFromCategory) {
        var criteria = new Object();

        criteria.academyLocationId = this.getCurrentAcademyLocation();
        criteria.serviceRequestCategory = serviceType;
        criteria.serviceRequestGroup = serviceRequestGroup;

        if (!isNullOrEmpty(certificateCategory)) {
            criteria.certificateRequestCategory = certificateCategory;
        }
        if (!isNullOrEmpty(freeFromCategory)) {
            criteria.freeFormRequestCategoryId = freeFromCategory;
        }
        return criteria;
    },

    /**
     * This method is use to load the service request settings grid.
     * @param store
     * @param url
     * @param criteria
     */
    loadServiceRequestSettingsStore: function(store, url, criteria) {
    	var tab = this.getActiveTabfromContentPanel();
        store.getProxy().api.read = url;
        store.sorters.clear();
        store.config.criteria = criteria;
        if(criteria.serviceRequestGroup == "OTHER"){
        	var catValue = tab.down('#comboCategory').getValue();
        	if(catValue == 'Readmission'){
            	store.getProxy().extraParams={
                	category :'READMISSION_REQUEST'
                }
            }else if(catValue == 'LEAVE'){
            	store.getProxy().extraParams={
                	category :catValue
                }
            }else if(catValue == 'ADDITIONAL_COURSE'){
            	store.getProxy().extraParams={
                	category : 'ADDITIONAL_COURSE'
                }
            }
        }
        store.load({
            params: criteria
        });
        delete store.getProxy().extraParams.category;
    },

    /**
     * 
     */
    toggleFormItemsOncheckbox: function(checkbox, newValue) {
    	var $this = this;
        var itemId = checkbox.getItemId();
        var form = checkbox.up('form');
        var defaultApprover = form.down('#defaultApprover');
        //var documentSelector = form.down('#documentSelector');
        var documentGrid = form.down('grid');
        var billingPreference = form.down('#comboBillingPreference');
        var feePlanType = form.down('#comboFeePlanType');
        var stage = form.down('#comboStage');
        var feeHead = form.down('#comboFeeHead');
       

        if (itemId === 'autoApprove') {
            if (newValue) {
                defaultApprover.setVisible(false);
                defaultApprover.setDisabled(true);
                defaultApprover.clearValue();
                $this.setAllowBlank(defaultApprover,true);
            } else {
                defaultApprover.setVisible(true);
                defaultApprover.setDisabled(false);
                $this.setAllowBlank(defaultApprover,false);
            }
            form.isValid();
            form.getForm().clearInvalid();
        }
        if (itemId === 'documentsApplicable') {
            if (newValue) {
                //documentSelector.setVisible(true);
                //documentSelector.setDisabled(false);
                documentGrid.setVisible(true);
                documentGrid.setDisabled(false);
                $this.setIsAdded(true);
            } else {
                //documentSelector.setVisible(false);
                //documentSelector.setDisabled(true);
                documentGrid.setVisible(false);
                documentGrid.setDisabled(true);
            }
        }
        if (itemId === 'feeApplicable') {
            if (newValue) {
                billingPreference.setVisible(true);
                billingPreference.setDisabled(false);
                feePlanType.setVisible(true);
                feePlanType.setDisabled(false);
                stage.setVisible(true);
                stage.setDisabled(false);
		         feeHead.setVisible(true);
		         feeHead.setDisabled(false);   
		         
		         var feePlanTypeStore = feePlanType.getStore();
		         feePlanTypeStore.getProxy().extraParams = {
		        	 feePlanTypeId: 3
		         };
		         feePlanTypeStore.load();
		         
		         billingPreference.allowBlank = false;
		         feePlanType.allowBlank = false;
		         stage.allowBlank = false;
		         feeHead.allowBlank = false;
            } else {
                billingPreference.setVisible(false);
                billingPreference.setDisabled(true);
                billingPreference.reset();
                feePlanType.setVisible(false);
                feePlanType.setDisabled(true);
                feePlanType.reset();
                stage.setVisible(false);
                stage.setDisabled(true);
                stage.reset();
                feeHead.setVisible(false);
                feeHead.setDisabled(true);
                feeHead.reset();
                
                billingPreference.allowBlank = true;
                feePlanType.allowBlank = true;
                stage.allowBlank = true;
                feeHead.allowBlank = true;
            }
            form.isValid();
            form.getForm().clearInvalid();
        }
    },
    
    /**
     * 
     */
    toggleFormItemsOncheckboxStudent: function(checkbox, newValue) {
    	var $this = this;
        var itemId = checkbox.getItemId();
        var form = checkbox.up('form');
       // var defaultApprover = form.down('#defaultApprover');
       // var documentSelector = form.down('#documentSelector');
        var documentGrid = form.down('grid');
        var billingPreference = form.down('#comboBillingPreference');
        var feePlanType = form.down('#comboFeePlanType');
        var stage = form.down('#comboStage');
        var feeHead = form.down('#comboFeeHead');
        var programGroupGrid = form.down('#assigneeapprovereditablegridItemId');
        var programLevelGrid = form.down('#assigneeapprovereditableprogramlevelgridItemId');
        var radio = form.down('#programGroupRadioGrp');
        var radioValue = radio.getValue().isProgramLevel;
        var allowAmountUpdate = form.down('#isAllowAmountUpdate');
        var minimumAmount = form.down('#minimumAmount');
        var serviceRequestGroup = this.getServiceRequestGroup();

        if (itemId === 'autoApprove') {
            /*if (newValue) {
                defaultApprover.setVisible(false);
                defaultApprover.setDisabled(true);
                form.down('#defaultApprover').clearValue();
            } else {
                defaultApprover.setVisible(true);
                defaultApprover.setDisabled(false);
            }*/
        	if (newValue) {
        		if(radioValue){
        			programLevelGrid.down('[dataIndex=approverId]').hide();
        			programLevelGrid.down('[dataIndex=approverIdAuto]').show();
        		}
        		else{
        			programGroupGrid.down('[dataIndex=approverId]').hide();
            		programGroupGrid.down('[dataIndex=approverIdAuto]').show();
        		}
        	}else{
        		if(radioValue){
        			programLevelGrid.down('[dataIndex=approverIdAuto]').hide();
        			programLevelGrid.down('[dataIndex=approverId]').show();
        		}
        		else{
        			programGroupGrid.down('[dataIndex=approverIdAuto]').hide();
            		programGroupGrid.down('[dataIndex=approverId]').show();
        		}
        	}
        }
        if (itemId === 'documentsApplicable') {
            if (newValue) {
                //documentSelector.setVisible(true);
                //documentSelector.setDisabled(false);
                documentGrid.setVisible(true);
                documentGrid.setDisabled(false);
                $this.setIsAdded(true);
            } else {
                //documentSelector.setVisible(false);
                //documentSelector.setDisabled(true);
                documentGrid.setVisible(false);
                documentGrid.setDisabled(true);
            }
        }
        if (itemId === 'feeApplicable') {
            if (newValue) {
                billingPreference.setVisible(true);
                billingPreference.setDisabled(false);
                feePlanType.setVisible(true);
                feePlanType.setDisabled(false);
                stage.setVisible(true);
                stage.setDisabled(false);
		         feeHead.setVisible(true);
		         feeHead.setDisabled(false);   
		         
		         var feePlanTypeStore = feePlanType.getStore();
		         feePlanTypeStore.getProxy().extraParams = {
		        	 feePlanTypeId: 3
		         };
		         feePlanTypeStore.load();
		         
		         billingPreference.allowBlank = false;
		         feePlanType.allowBlank = false;
		         stage.allowBlank = false;
		         feeHead.allowBlank = false;
		         if(serviceRequestGroup=='FREE_FORM'){
		        	 allowAmountUpdate.setVisible(true);
			         if(allowAmountUpdate.getValue()==true){
			        	 minimumAmount.setVisible(true);
			         }
		         }
            } else {
                billingPreference.setVisible(false);
                billingPreference.setDisabled(true);
                billingPreference.reset();
                feePlanType.setVisible(false);
                feePlanType.setDisabled(true);
                feePlanType.reset();
                stage.setVisible(false);
                stage.setDisabled(true);
                stage.reset();
                feeHead.setVisible(false);
                feeHead.setDisabled(true);
                feeHead.reset();
                
                billingPreference.allowBlank = true;
                feePlanType.allowBlank = true;
                stage.allowBlank = true;
                feeHead.allowBlank = true;
                if(serviceRequestGroup=='FREE_FORM'){
                	 allowAmountUpdate.setVisible(false);
                     minimumAmount.setVisible(false);
                }
            }
            form.isValid();
            form.getForm().clearInvalid();
        }
        if (itemId === 'isAutoAssigneeId') {
        	if (newValue) {
        		if(radioValue){
        			programLevelGrid.down('[dataIndex=assigneeId]').hide();
        			programLevelGrid.down('[dataIndex=assigneeIdAuto]').show();
        		}
        		else{
        			programGroupGrid.down('[dataIndex=assigneeId]').hide();
            		programGroupGrid.down('[dataIndex=assigneeIdAuto]').show();
        		}
        	}else{
        		if(radioValue){
        			programLevelGrid.down('[dataIndex=assigneeIdAuto]').hide();
        			programLevelGrid.down('[dataIndex=assigneeId]').show();
        		}
        		else{
        			programGroupGrid.down('[dataIndex=assigneeIdAuto]').hide();
            		programGroupGrid.down('[dataIndex=assigneeId]').show();
        		}
        	}
        }
        if (itemId === 'isAllowAmountUpdate' && serviceRequestGroup=='FREE_FORM') {
        	 if (newValue) {
        		 minimumAmount.setVisible(true);
        	 }else{
        		 minimumAmount.reset();
        		 minimumAmount.setVisible(false);
        	 }
        }

    },
    toggleFormItemsOncheckboxHostel: function(checkbox, newValue) {
    	var $this = this;
        var itemId = checkbox.getItemId();
        var form = checkbox.up('form');
       // var defaultApprover = form.down('#defaultApprover');
       // var documentSelector = form.down('#documentSelector');
        var documentGrid = form.down('grid');
        var billingPreference = form.down('#comboBillingPreference');
        var feePlanType = form.down('#comboFeePlanType');
        var stage = form.down('#comboStage');
        var feeHead = form.down('#comboFeeHead');
        var programGroupGrid = form.down('#assigneeapprovereditablegridforhostelItemId');
       

        if (itemId === 'autoApprove') {
            /*if (newValue) {
                defaultApprover.setVisible(false);
                defaultApprover.setDisabled(true);
                form.down('#defaultApprover').clearValue();
            } else {
                defaultApprover.setVisible(true);
                defaultApprover.setDisabled(false);
            }*/
        	if (newValue) {
        		programGroupGrid.down('[dataIndex=approverId]').hide();
        		programGroupGrid.down('[dataIndex=approverIdAuto]').show();
        		//programGroupGrid.down('[dataIndex=approverIdAuto]').setDisabled(true);
        	}else{
        		programGroupGrid.down('[dataIndex=approverIdAuto]').hide();
        		programGroupGrid.down('[dataIndex=approverId]').show();
        	}
        }
        if (itemId === 'documentsApplicable') {
            if (newValue) {
                //documentSelector.setVisible(true);
                //documentSelector.setDisabled(false);
                documentGrid.setVisible(true);
                documentGrid.setDisabled(false);
                $this.setIsAdded(true);
            } else {
                //documentSelector.setVisible(false);
                //documentSelector.setDisabled(true);
                documentGrid.setVisible(false);
                documentGrid.setDisabled(true);
            }
        }
       /* if (itemId === 'feeApplicable') {
            if (newValue) {
                billingPreference.setVisible(true);
                billingPreference.setDisabled(false);
                feePlanType.setVisible(true);
                feePlanType.setDisabled(false);
                stage.setVisible(true);
                stage.setDisabled(false);
		         feeHead.setVisible(true);
		         feeHead.setDisabled(false);   
		         
		         var feePlanTypeStore = feePlanType.getStore();
		         feePlanTypeStore.getProxy().extraParams = {
		        	 feePlanTypeId: 3
		         };
		         feePlanTypeStore.load();
		         
		         billingPreference.allowBlank = false;
		         feePlanType.allowBlank = false;
		         stage.allowBlank = false;
		         feeHead.allowBlank = false;
            } else {
                billingPreference.setVisible(false);
                billingPreference.setDisabled(true);
                billingPreference.reset();
                feePlanType.setVisible(false);
                feePlanType.setDisabled(true);
                feePlanType.reset();
                stage.setVisible(false);
                stage.setDisabled(true);
                stage.reset();
                feeHead.setVisible(false);
                feeHead.setDisabled(true);
                feeHead.reset();
                
                billingPreference.allowBlank = true;
                feePlanType.allowBlank = true;
                stage.allowBlank = true;
                feeHead.allowBlank = true;
            }
            form.isValid();
            form.getForm().clearInvalid();
        }*/

    },

    /**
     * This method is use to load the requesy type grid according to the value selected in the combo
     * @param combo
     * @param value
     */
    loadStoreOnChangeComboValue: function(combo, store) {
        var serviceType = this.getServiceType();
        var serviceRequestGroup = this.getServiceRequestGroup();
        var criteria = '';
        var url = '';
        var value = combo.getValue();
        if (combo.itemId === 'comboCertificateCategory') {
            criteria = this.createGridCriteria(serviceType, serviceRequestGroup, value);
            url = SERVERURL.CERTIFICATE_REQUEST_GRID;
            this.loadServiceRequestSettingsStore(store, url, criteria);
        } else if (combo.itemId === 'comboFreeFormCategory') {
            criteria = this.createGridCriteria(serviceType, serviceRequestGroup, null, value);
            url = SERVERURL.FREE_FORM_REQUEST_GRID;
            this.loadServiceRequestSettingsStore(store, url, criteria);
        } if (combo.itemId === 'comboCategory' && !combo.config.suspendChangeEvent) {
            criteria = this.createGridCriteria(serviceType, serviceRequestGroup, null);
            url = SERVERURL.OTHER_REQUEST_GRID;
            if(!combo.config.suspendChangeEvent){
             this.loadServiceRequestSettingsStore(store, url, criteria);
            }
        }

        
    },

    /**
     * This method is used to load fee related grid according to the value selected in the fee related category combo
     * @param combo
     * @param value
     */

    loadStoreOnChangeFeeRelatedComboValue: function(combo, store) {
        var serviceType = this.getServiceType();
        //var serviceRequestGroup = this.getServiceRequestGroup();
        var criteria;
        var url;
        var value = combo.getValue();
        criteria = this.createFeeRelatedGridCriteria(serviceType, value);
        url = SERVERURL.FEE_RELATED_GRID;
        this.loadServiceRequestSettingsStore(store, url, criteria);
    },
    /**
     * This method is use to create the criteria according to the parameters for loading the grid 
     * @param serviceType
     * @param feeRelatedCategory
     * 
     */
    createFeeRelatedGridCriteria: function(serviceType, feeRelatedCategory) {
        var criteria = new Object();

        criteria.academyLocationId = this.getCurrentAcademyLocation();
        criteria.serviceRequestCategory = serviceType;

        if (!isNullOrEmpty(feeRelatedCategory)) {
            criteria.feeRelatedCategory = feeRelatedCategory;
        }
        return criteria;
    },
    /**
     * This method is use to open the popoup form for add and edit request Settings
     * @param button
     */
    openRequestSettingFormWindow: function(button) {
    	var requestGrid = button.up('grid');
    	if (requestGrid.getSelectionModel().getCount() == 1) {

    		var record = requestGrid.getSelectionModel().getSelection()[0];
    		var window = '';
    		
    		var serviceType = this.getServiceType();
            var serviceRequestGroup = this.getServiceRequestGroup();
            
            if (serviceType === 'FACULTY_REQUEST'){
            	window = Ext.widget('requestsettingformwindow');
            }
            else{
            	if(serviceRequestGroup=='OTHER' && record.data.requestType.code == "HLR"){
            		window = Ext.widget('studenthostelrequestformwindow');
            	}else{
            		window = Ext.widget('studentrequestsettingformwindow');
            	}
            	
            	if(serviceType == 'DEBRAMENT_REQUEST'){
            		window.down('#sectionRequestCanBeRaisedItemId').setVisible(false);
            	}
            	if( serviceType == 'TERMINATION_REQUEST' || serviceType == 'TRANSFER_REQUEST'){
            		
            		window.down('#programGroupRadioGrp').setVisible(false);
    				window.down('#programGroupLblFieldItemId').setVisible(false);
            	}
            	if(serviceType == 'TERMINATION_REQUEST' || serviceType == 'TRANSFER_REQUEST'){
            		window.down('#sectionRequestCanBeRaisedItemId').setVisible(false);
            	}
            }

            var form = window.down('form');
            if(serviceRequestGroup=='OTHER' && record.data.requestType.code == "LR"){
            	var isStudentAdivsor = form.down('#isStudentAdivsor');
            	isStudentAdivsor.setVisible(true);
            }
            
            if(serviceRequestGroup=='OTHER' && record.data.requestType.code == "HLR"){
            	var isStudentAdivsorHostel = form.down('#isStudentAdivsorHostel');
            	isStudentAdivsorHostel.setVisible(true);
            }
            
            if(serviceRequestGroup=='TRANSFER' && (record.data.requestType.code == "ES" || record.data.requestType.code == "LOA")){
            	var isFeeApplicable = form.down('#feeApplicable');
            	isFeeApplicable.setVisible(false);
            }
            
            if(serviceRequestGroup=='TRANSFER' && (record.data.requestType.code == "CT" || record.data.requestType.code == "PT" || record.data.requestType.code == "ST" || record.data.requestType.code == "STDTRAN")){
            	var whetherHoldApplicable = form.down('#whetherHoldApplicable');
            	whetherHoldApplicable.setVisible(true);
            	if(!isNullOrEmpty(record.data.whetherHoldApplicable)){
            		whetherHoldApplicable.setValue(record.data.whetherHoldApplicable);
        		}
            }
            
            /* To add instruction box on general and certificate req */
            
            var instructions = form.down('#instructionsItemId');
            if(!isNullOrEmpty(instructions)){
            	if(serviceRequestGroup=='FREE_FORM'){
                	instructions.setVisible(true);
                }
                if(serviceRequestGroup=='CERTIFICATE'){
                	instructions.setVisible(true);
                }
            }
            
            /* ---------------------------------------------------- */
            
            /* To Add offered Module and enrolled module on general req*/
            
            var enrolledModules = form.down('#isEnrolledModule');
            var offeredModules = form.down('#isOfferedModule');
            if(!isNullOrEmpty(enrolledModules) && !isNullOrEmpty(offeredModules)){
            	if(serviceRequestGroup=='FREE_FORM'){
            		offeredModules.setVisible(true);
            		enrolledModules.setVisible(true);
            		if(!isNullOrEmpty(record.data.isEnrolledModule)){
            			enrolledModules.setValue(record.data.isEnrolledModule);
            		}
            		if(!isNullOrEmpty(record.data.isOfferedModule)){
            			offeredModules.setValue(record.data.isOfferedModule);
            		}
            	}
            }
            
            /*--------------------------------------------------------*/
            
    		window.show();

    		var serviceRequestSettingStatus = form.down('#serviceRequestSettingStatus');
            serviceRequestSettingStatus.getStore().load();
            
            if(serviceRequestGroup=='OTHER' && record.data.requestType.code == "HLR"){
            	 var academyLocationId=this.getCurrentAcademyLocation();
            	 var hostelForm = form.down('#assigneeapprovereditablegridforhostelItemId');
                 var hostelStore = hostelForm.getStore();
                 
                 hostelStore.getProxy().extraParams = {
     				academyLocationId:academyLocationId
     	    	};
                 hostelStore.load();
                 
            }
           
    		if (serviceType === 'FACULTY_REQUEST'){
    			var refDefaultAssignee =  form.down('#defaultAssignee');
    			var refDefaultApprover = form.down('#defaultApprover');

    			var assigneeStore = refDefaultAssignee.getStore();
    			var approverStore = refDefaultApprover.getStore();

    			var defaultAssignee = record.raw.defaultAssignee;
    			var defaultApprover = record.raw.defaultApprover;
    			var academyLocationId = this.getCurrentAcademyLocation();
				assigneeStore.getProxy().extraParams = {
					academyLocationId:academyLocationId
    	    	};
				approverStore.getProxy().extraParams = {
					academyLocationId:academyLocationId
    	    	};
    			if(!isNullOrEmpty(defaultAssignee)){
    				assigneeStore.load({
    					callback : function(){
    						refDefaultAssignee.setValue(defaultAssignee.id);
    					}
    				});
    			}
    			if(!isNullOrEmpty(defaultApprover)){
    				approverStore.load({
    					callback : function(){
    						refDefaultApprover.setValue(defaultApprover.id);
    					}
    				});
    			}

    			delete record.data.defaultAssignee ;
    			delete record.data.defaultApprover;
    		}
    		if (serviceType === 'STUDENT_REQUEST'){
    			var assigneeStore = Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchNameForHostel');
    			var approverStore = Ext.create('Academia.store.servicerequest.servicerequestsettings.QuickSearchNameApproverForHostel');
    			if(!isNullOrEmpty(form.down('assigneeapprovereditableprogramlevelgrid'))){
    				var column = form.down('assigneeapprovereditableprogramlevelgrid').down('gridcolumn[dataIndex=approverId]');
        			var editor = column.getEditor();
        			editor.getStore().load();
        			
        			var column2 = form.down('assigneeapprovereditableprogramlevelgrid').down('gridcolumn[dataIndex=assigneeId]');
        			var editor1 = column2.getEditor();
        			editor1.getStore().load();
    			}
    			/*var refDefaultAssignee =  form.down('#defaultAssignee');
    			var refDefaultApprover = form.down('#defaultApprover');

    			var assigneeStore = refDefaultAssignee.getStore();
    			var approverStore = refDefaultApprover.getStore();*/

    			var defaultAssignee = record.raw.defaultAssignee;
    			var defaultApprover = record.raw.defaultApprover;
    			
				assigneeStore.getProxy().extraParams = {
					academyLocationId:academyLocationId
    	    	};
				approverStore.getProxy().extraParams = {
					academyLocationId:academyLocationId
    	    	};
    			if(refDefaultAssignee && !isNullOrEmpty(defaultAssignee)){
    				assigneeStore.load({
    					callback : function(){
    						refDefaultAssignee.setValue(defaultAssignee.id);
    					}
    				});
    			}
    			if(refDefaultApprover && !isNullOrEmpty(defaultApprover)){
    				approverStore.load({
    					callback : function(){
    						refDefaultApprover.setValue(defaultApprover.id);
    					}
    				});
    			}

    			delete record.data.defaultAssignee ;
    			delete record.data.defaultApprover;
    			
    			if( serviceRequestGroup == "EXAM_RELATED" ){
    				window.down('#programGroupRadioGrp').setVisible(false);
    				window.down('#programGroupLblFieldItemId').setVisible(false);
    			}
    		}


    		//var refDefaultAssignee =  form.down('#defaultAssignee');
    		//var refDefaultApprover = form.down('#defaultApprover');

    		//var assigneeStore = refDefaultAssignee.getStore();
    		//var approverStore = refDefaultApprover.getStore();

    		//var defaultAssignee = record.raw.defaultAssignee;
    		//var defaultApprover = record.raw.defaultApprover;
    		/*if(!isNullOrEmpty(defaultAssignee)){
    			assigneeStore.load({
    				callback : function(){
    					refDefaultAssignee.setValue(defaultAssignee.id);
    				}
    			});
    		}*/
    		/*if(!isNullOrEmpty(defaultApprover)){
    			approverStore.load({
    				callback : function(){
    					refDefaultApprover.setValue(defaultApprover.id);
    				}
    			});
    		}*/

    		//delete record.data.defaultAssignee ;
    		//delete record.data.defaultApprover;

    		form.loadRecord(record);
    		if( serviceRequestGroup == "FREE_FORM" ){
    			if(isNullOrEmpty(record.data.isAllowDuplicate)){
    				var isAllowDuplicate = form.down('#isAllowDuplicate');
    				if(isAllowDuplicate!=null)
    					isAllowDuplicate.setValue(true);
    			}
    		}
    		requestGrid.getSelectionModel().deselectAll();
    		var grid = form.down('grid');
    		var gridStore = grid.getStore();
    		gridStore.removeAll();
    		var id = record.get('id');
    		/*var documents = record.get('documentRules');
    		if (!isNullOrEmpty(id) && !isEmpty(documents)) {
    			var documentArray = new Array();
    			Ext.each(documents, function(document) {
    				documentArray.push(document.documentType.id);
    			});
    			//var itemSelector = form.down('#documentSelector');
    			//itemSelector.clearListeners();
    			//this.setIsAdded(null);
    			//itemSelector.setValue(documentArray);
    			gridStore.removeAll();
    			gridStore.loadData(documents);
    		}*/

    		var requestType = record.get('requestType');
    		var academyLocation = record.get('academyLocation');
    		if (isNullOrEmpty(academyLocation)) {
    			var academyLocationId = this.getCurrentAcademyLocation();
    			academyLocation = {
    					id: academyLocationId
    			};
    		}

    		form.down('hidden[name=academyLocation]').setValue(Ext.encode(academyLocation));
    		form.down('displayfield[name=requestTypeField]').setValue(requestType.value);
    		form.down('hidden[name=requestType]').setValue(Ext.encode(requestType));
    		
    		var requestRaisedCheckbox = window.down('#sectionRequestCanBeRaisedItemId');
    		
    		if(requestRaisedCheckbox.isVisible()){
    			if(record.get('requestRaisedFromPortal') == 3 || record.get('requestRaisedFromPortal') == 2){
    				requestRaisedCheckbox.down('[name=requestRaisedFromPortal]').setValue(true);
            	}
    			else{
    				if(isNullOrEmpty(id)){
    					requestRaisedCheckbox.down('[name=requestRaisedFromPortal]').setValue(true);
    				}
    				else{
    					requestRaisedCheckbox.down('[name=requestRaisedFromPortal]').setValue(false);
    				}
    			}
    		}
    		
    		if(!isNullOrEmpty(id)){
    			var programGroupRadioGrp = window.down('#programGroupRadioGrp')
    			if(!isNullOrEmpty(programGroupRadioGrp)){
    			   programGroupRadioGrp.setValue({isProgramLevel:record.get('isProgramLevel')});
    			   programGroupRadioGrp.setDisabled(true);
    			}
    			
    		}
    		
    		var feePlan = record.get('feePlan');
    		var feePlanRule = record.get('feePlanRule');
    		var feePlanRuleStage = record.get('feePlanRuleStage');

    		if(!isNullOrEmpty(feePlan)){
    			var feeplanfield = form.down('#comboFeePlanType');
    			feeplanfield.getStore().load({
    				callback : function(){
    					feeplanfield.setValue(feePlan.id);
    					if(!isNullOrEmpty(feePlanRule)){
    		    			var feeplanrulefield = form.down('#comboStage');
    		    			var store = feeplanrulefield.getStore();
    		    	    	store.getProxy().extraParams = {
    		    	    		feePlanId:feePlan.id
    		    	    	};
    		    			
    		    	    	store.load({
    		    				callback : function(){
    		    					feeplanrulefield.setValue(feePlanRule.id);
    		    					if(!isNullOrEmpty(feePlanRuleStage)){
    		    		    			var feeplanrulestagefield = form.down('#comboFeeHead');
    		    		    			var store = feeplanrulestagefield.getStore();
    		    		    	    	store.getProxy().extraParams = {
    		    		    	    		feePlanRuleId:feePlanRule.id
    		    		    	    	};
    		    		    	    	store.load({
    		    		    				callback : function(){
    		    		    					feeplanrulestagefield.setValue(feePlanRuleStage.id);
    		    		    				}
    		    		    			});
    		    		    		}
    		    				}
    		    			});
    		    		}
    				}
    			});
    		}
    	} else {
    		showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST_SETTING'), getCommonTranslation('PLEASE_SELECT_RECORD'));
    	}
    },

    /**
     * This method is use to add the selected certificate to the grid
     * @param selector
     * @param newValue
     * @param oldValue
     * @param is Add
     */
    addCertificateToGrid: function(selector, newValue, oldValue, isAdd) {
        var selectorStore = selector.getStore();
        var grid = selector.up('form').down('grid');
        var gridStore = grid.getStore();
        //gridStore.removeAll();
        var selected;
        if (isNullOrEmpty(oldValue)) {
            oldValue = new Array();
        }

        if (!isNullOrEmpty(isAdd)) {

            if (!isNullOrEmpty(oldValue) && !isAdd) {
                selected = this.getRemovedItems(newValue, oldValue);
                this.removeFromDocumentGrid(gridStore, selected);
            } else {
                selected = this.getAddedItems(newValue, oldValue);
                gridStore.each(function(record) {
                    var doc = record.get('documentType');
                    if (!isNullOrEmpty(doc)) {
                        var id = doc.id;
                        if (Ext.Array.contains(selected, id)) {
                            Ext.Array.remove(selected, id);
                        }
                    }
                });
                Ext.each(selected, function(documentId) {
                    var obj = selectorStore.getById(documentId);
                    var object = {
                    		documentType: {
                            id: documentId,
                            value: obj.get('value')
                        }
                    };
                    gridStore.add(new Academia.model.servicerequest.servicerequestsettings.Document(object));
                });
            }
        }

    },
    getAddedItems: function(newValue, oldValue) {
        Ext.each(oldValue, function(value) {
            Ext.Array.remove(newValue, value);
        });
        return newValue;
    },

    getRemovedItems: function(newValue, oldValue) {
        Ext.each(newValue, function(value) {
            Ext.Array.remove(oldValue, value);
        });
        return oldValue;
    },

    removeFromDocumentGrid: function(store, selected) {
        var count = store.getCount();
        for (var i = 0; i < count; i++) {
            var record = store.getAt(i);
            var document = record.get('documentType');
            Ext.each(selected, function(value) {
                if (document.id == value) {
                    store.remove(record);
                }
            });
        }
    },

    /**
     * This method is use to save request Setting
     */
    saveRequestSettings: function(button) {
    	var this$ = this;
    	var form = button.up('form');
    	var values = form.getValues();
    	if(!isNullOrEmpty(values.feeStageMaster)) {
    	    values.feePlanRuleStage = {id:values.feeStageMaster};
    	}
    	delete values.feeHead;
    	delete values.feePlanType;
    	delete values.feePlan;
    	delete values.feePlanRule;
    	delete values.feeStageMaster;
    	
    	values.isAutoApprove = form.down('#autoApprove').getValue();
    	
    	var me = this;
    	var submitUrl = SERVERURL.REQUEST_SETTING;
    	var serviceRequestGroup = me.getServiceRequestGroup();
    	var serviceType = me.getServiceType();
    	values.requestStatusIds = this.getStatusArray(values.requestStatusIds);
    	delete values.status;
    	if (serviceRequestGroup === 'CERTIFICATE') {
    		submitUrl = SERVERURL.CERTIFICATE_REQUEST_SETTING;
    	} else if (serviceRequestGroup === 'FREE_FORM') {
    		submitUrl = SERVERURL.FREE_FORM_REQUEST_SETTING;
    	}
    	if (serviceType === 'FEE_RELATED_REQUEST') {
    		submitUrl = SERVERURL.FEE_RELATED_REQUEST;
    		values.serviceRequestGroup = 'TRANSFER';
    	}
    	/*if (serviceRequestGroup === 'OTHER') {
    		submitUrl = SERVERURL.OTHER_REQUEST_GRID;
    	}*/
    	delete values.rule;
    	delete values.ruleDescription;
    	delete values.documents;
    	delete values.module;
    	var methodType;
    	values.requestType = Ext.decode(values.requestType);
    	values.academyLocation = Ext.decode(values.academyLocation);
    	values.serviceRequestCategory = this.getServiceType(values.status);
    	if (isNullOrEmpty(values.id)) {
    		methodType = 'POST';
    	} else {
    		methodType = 'PUT';
    	}
    	//var documentStore = form.down('grid').getStore();
    	//var documentsArray = this.getDocumentArray(documentStore);
    	//values.documentRules = documentsArray;
    	
    	var documentsArray = [];
    	var programGroupCountCheck = [];
    	var docList = form.down('#documentsEditableGridItemId').getSelectionModel().getSelection();
    	if(docList.length>0){
			docList.forEach(function(doc){
				var documentRuleObj = {};
				documentRuleObj.id = doc.data.idRule;
				documentRuleObj.documentType ={
						id:doc.data.id,
						value:doc.data.value
				};
				
				if(!isNullOrEmpty(doc.data.referenceDocument)){
					documentRuleObj.document = {
							type: "DOCUMENT",
							name: doc.data.referenceDocument,
							path:doc.data.refDocumentPath
					};
				}
				if(!isNullOrEmpty(doc.data.refDocumentId)){
					documentRuleObj.document = {
							id:doc.data.refDocumentId,
							type: "DOCUMENT",
							name: doc.data.referenceDocument,
							path:doc.data.refDocumentPath
					};
				}
				
				documentRuleObj.rule = doc.data.rule;
				documentRuleObj.ruleDescription = doc.data.ruleDescription;

				documentsArray.push(documentRuleObj);
			});
		}
    	values.documentRules = documentsArray;
    	
    	if(values.requestRaisedFromPortal){
    		values.requestRaisedFromPortal = 2;
    	}
    	else{
    		values.requestRaisedFromPortal = 1; // Core ERP only
    	}
    	
    	values.defaultAssignee = {
    			id:values.defaultAssignee
    	};
    	
    	if(values.defaultApprover && !isNullOrEmpty(values.defaultApprover)){
    		values.defaultApprover = {
        			id:values.defaultApprover
        	};
    	}
    	
    	values.serviceRequestProgramGroupConfig = null;
    	if(values.whetherDocumentRequired){
    		if(documentsArray.length >0){
    			var submitData = Ext.encode(values);
    			this$.applyWindowMask(); 
    			this.sendSaveAjaxRequest(submitUrl, methodType, submitData, function(success) {
    				this$.hideWindowMask();
    				if (success) {
    					var window = button.up('window');
    					showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'),getServiceRequestTranslation('SAVEDSUCCESSFULLY'));
    					window.close();
    					var grid = me.getRequestSettingGrid();
    					grid.getStore().reload();
    					me.loadSettingGridOnSuccess();
    				}
    			});
    		} else {
    			showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST_SETTING'), getServiceRequestTranslation('PLEASE_SELECT_DOCUMENTS'));
    		}
    	} else {
    		var submitData = Ext.encode(values);
    		this$.applyWindowMask(); 
    		this.sendSaveAjaxRequest(submitUrl, methodType, submitData, function(success) {
    			this$.hideWindowMask();
    			if (success) {
    				var window = button.up('window');
    				showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'),getServiceRequestTranslation('SAVEDSUCCESSFULLY'));
    				window.close();
    				var grid = me.getRequestSettingGrid();
    				grid.getStore().reload();
    				me.loadSettingGridOnSuccess();
    			}
    		});
    	}
    	if((values.whetherDocumentRequired && documentsArray.length >0) || !(values.whetherDocumentRequired)) {

    	} 

    },

    getStatusArray: function(statuses) {
        var statusArray = new Array();
        var id = '';
        Ext.each(statuses, function(status) {
            if (status instanceof Object) {
                id = status.get('id');
                statusArray.push(id);
            } else {
                statusArray = Ext.Array.slice(statuses, 0);
            }
        });
        return statusArray;
    },

    /**
     * This method is use to reload the setting grid after saving the settings.
     */
    loadSettingGridOnSuccess: function() {
        var serviceType = this.getServiceType();
        var serviceRequestGroup = this.getServiceRequestGroup();
        var grid = this.getRequestSettingGrid();
        var store = grid.getStore();
        if (serviceType === 'FEE_RELATED_REQUEST') {
            var feePanel = this.getFeeRequestSettings();
            var feeCombo = feePanel.down('customcombobox');
            this.loadStoreOnChangeFeeRelatedComboValue(feeCombo, store);
        } else if (serviceType === 'STUDENT_REQUEST' || serviceType === 'FACULTY_REQUEST') {
            var panel = this.getStudentRequestPanel();
            if (serviceRequestGroup === 'CERTIFICATE' || serviceRequestGroup === 'FREE_FORM') {
                var tab = panel.getActiveTab();
                var combo = tab.down('customcombobox');
                this.loadStoreOnChangeComboValue(combo, store);
            } else {
                var tab = panel.getActiveTab();
                tab.config.isSave = true;
                this.onActiveTab(tab);
            }
        } else {
            this.loadStoreForOtherTabs(store);
        }
        grid.getSelectionModel().deselectAll(true);

    },

    /**
     * This method is use to get the array of the documents from the store.
     * @param documentStore store object of the document grid.
     */
    getDocumentArray: function(documentStore) {
        var documentsArray = new Array();
        for (var count = 0; count < documentStore.data.length; count++) {
            var record = documentStore.getAt(count);
            var documentObject = new Object();
            documentObject.id = record.get('id');
            documentObject.documentType = record.get('documentType');
            documentObject.rule = record.get('rule');
            documentObject.ruleDescription = record.get('ruleDescription');
            documentsArray.push(documentObject);
        }
        return documentsArray;
    },

    /**
     * This method is use to view the setting in read only mode.
     * @param button View setting button object
     */
    viewSettings: function(button) {
        this.openRequestSettingFormWindow(button);
        var serviceType = this.getServiceType();
        var serviceRequestGroup = this.getServiceRequestGroup();
        var window = this.getStudentrequestsettingformwindow();
        if (serviceType === 'FACULTY_REQUEST'){
        	window = this.getRequestSettingFormWindow();
        }
        if(serviceRequestGroup == 'OTHER'){
        	window = this.getStudenthostelrequestformwindow();
        	if(isNullOrEmpty(window)){
        		window = this.getStudentrequestsettingformwindow();
        	}
        }
        if (window) {
            window.setTitle(getServiceRequestTranslation('VIEW_REQUEST_SETTINGS'));
            var form = window.down('form');
            var grid = form.down('grid');
            grid.setDisabled(true);
            if (serviceType === 'STUDENT_REQUEST' || serviceType === 'DEBRAMENT_REQUEST' || serviceType === 'WITHDRAWAL_REQUEST' || serviceType === 'TRANSFER_REQUEST' || serviceType === 'TERMINATION_REQUEST' || serviceType === 'FEE_RELATED_REQUEST'){
            	var assigneeApproverGrid = form.down('#assigneeapprovereditablegridItemId');
            	var programLevelGrid = form.down('#assigneeapprovereditableprogramlevelgridItemId');
            	 if(serviceRequestGroup == 'OTHER'){
                 	var assigneeApproverGrid = form.down('#assigneeapprovereditablegridforhostelItemId');
                 	if(!isNullOrEmpty(assigneeApproverGrid)){
                 		assigneeApproverGrid.setDisabled(true);
                 	}else{
                 		assigneeApproverGrid = form.down('#assigneeapprovereditablegridItemId');
                 	}
                 }
            	if(!isNullOrEmpty(assigneeApproverGrid)){
            		assigneeApproverGrid.setDisabled(true);
            	}
            	if(!isNullOrEmpty(programLevelGrid)){
            		programLevelGrid.setDisabled(true);
            	}
            }
           
            this.toggleReadOnlyFormItems(form.getForm(), true);
            form.down('#btnSaveRequestDetails').setVisible(false);
        }
    },

    /**
     * This method is use to open the document grid on clicking on link.
     * @param record row of the grid selected
     */
    openDocumentGridWindow: function(record) {
        var documentRules = record.data.documentRules;
        var documentWindow = Ext.widget('documentgridwindow');
        if (documentWindow) {
            documentWindow.setTitle(getServiceRequestTranslation('VIEW_DOCUMENTS'));
            var store = documentWindow.down('grid').getStore();
            store.loadData(documentRules);
        }
        documentWindow.show();
    },
    
    loadSelectionStageCombo:function(combo){
    	var form = combo.up('form');
    	var selectionCombo = form.down('#comboStage');
    	var minimumAmount = form.down('#minimumAmount');
    	selectionCombo.clearValue();
    	minimumAmount.reset();
    	var store = selectionCombo.getStore();
    	store.getProxy().extraParams = {
    		feePlanId:combo.getValue()
    	};
    	store.load();
    },
    
    loadFeeHeadCombo:function(combo) {
    	var form = combo.up('form');
    	var feeHeadCombo = form.down('#comboFeeHead');
    	var minimumAmount = form.down('#minimumAmount');
    	feeHeadCombo.clearValue();
    	var store = feeHeadCombo.getStore();
    	store.getProxy().extraParams = {
    		feePlanRuleId:combo.getValue()
    	};
    	store.load();
    	Ext.Ajax.request({
    		type: 'rest',
    		url: SERVERURL.PATH_FIND_ALL_FEEHEAD_AMMOUNT_BY_FEEPLANRULE_ID,
    		method: 'GET',
    		 params: {
    			 feePlanRuleId:combo.getValue(),
			  },
    		success: function(response) {
    			var data  = Ext.decode(response.responseText);
    			minimumAmount.setMinValue(1);
            	minimumAmount.setMaxValue(data.feeAmount);
    		}
    	});
    },
    getIdValueJson: function(id, value) {
		if (id) return {
			id: id,
			value: value
		};
	},
	saveRequestSettingsStudent: function(button){
		var this$ = this;
		var form = button.up('form');
		var values = form.getValues();
		var isAllowAmountUpdate = form.down('#isAllowAmountUpdate');
		if(!isAllowAmountUpdate.isVisible()){
			values.isAllowAmountUpdate = false;
		}
		if (isNullOrEmpty(values.isAutoFollowUp)) {
			values.isAutoFollowUp = false	
			}
		if(!isNullOrEmpty(values.feeStageMaster)) {
			values.feePlanRuleStage = {id:values.feeStageMaster};
		}
		delete values.feeHead;
		delete values.feePlanType;
		delete values.feePlan;
		delete values.feePlanRule;
		delete values.feeStageMaster;
		delete values.customData;
		values.isAutoApprove = form.down('#autoApprove').getValue();
		values.isAutoAssignee = form.down('#isAutoAssigneeId').getValue();
		values.isStudentAdivsor = form.down('#isStudentAdivsor').getValue();
		var me = this;
		var submitUrl = SERVERURL.REQUEST_SETTING;
		var serviceRequestGroup = me.getServiceRequestGroup();
		var serviceType = me.getServiceType();
		values.requestStatusIds = this.getStatusArray(values.requestStatusIds);
		delete values.status;
		if (serviceRequestGroup === 'CERTIFICATE') {
			submitUrl = SERVERURL.CERTIFICATE_REQUEST_SETTING;
		} else if (serviceRequestGroup === 'FREE_FORM') {
			submitUrl = SERVERURL.FREE_FORM_REQUEST_SETTING;
		}
		if (serviceType === 'FEE_RELATED_REQUEST') {
			submitUrl = SERVERURL.FEE_RELATED_REQUEST;
			values.serviceRequestGroup = 'TRANSFER';
		}
		delete values.rule;
		delete values.ruleDescription;
		delete values.documents;
		delete values.module;
		var methodType;
		values.requestType = Ext.decode(values.requestType);
		values.academyLocation = Ext.decode(values.academyLocation);
		values.serviceRequestCategory = this.getServiceType(values.status);
		if (isNullOrEmpty(values.id)) {
			methodType = 'POST';
		} else {
			methodType = 'PUT';
		}
		var documentsArray = [];
		var programGroupDetailsArray = [];
		var programGroupCountCheck = [];
		var assigneeRecordArray = [];
		var approverRecordArray = [];
		var docList = form.down('#documentsEditableGridItemId').getSelectionModel().getSelection();
		if(docList.length>0){
			docList.forEach(function(doc){
				var documentRuleObj = {};
				documentRuleObj.id = doc.data.idRule;
				documentRuleObj.documentType ={
						id:doc.data.id,
						value:doc.data.value
				};
				
				if(!isNullOrEmpty(doc.data.referenceDocument)){
					documentRuleObj.document = {
							type: "DOCUMENT",
							name: doc.data.referenceDocument,
							path:doc.data.refDocumentPath
					};
				}
				if(!isNullOrEmpty(doc.data.refDocumentId)){
					documentRuleObj.document = {
							id:doc.data.refDocumentId,
							type: "DOCUMENT",
							name: doc.data.referenceDocument,
							path:doc.data.refDocumentPath
					};
				}
				
				documentRuleObj.rule = doc.data.rule;
				documentRuleObj.ruleDescription = doc.data.ruleDescription;

				documentsArray.push(documentRuleObj);
			});
		}
		values.documentRules = documentsArray;

		if(values.requestRaisedFromPortal){
			values.requestRaisedFromPortal = 3;
		}
		else{
			values.requestRaisedFromPortal = 1; // Core ERP only
		}
		var assigneeApproverList = form.down('#assigneeapprovereditablegridItemId');
		var assigneeApproverListStore = assigneeApproverList.getStore();

		var isProgramLevel = form.down('#programGroupRadioGrp').getValue().isProgramLevel;
		
		if(isProgramLevel){
			assigneeApproverList = form.down('#assigneeapprovereditableprogramlevelgridItemId');
			assigneeApproverListStore = assigneeApproverList.getStore();
		}
		
		if(assigneeApproverListStore.data.length>0){
			if(values.isAutoApprove){
				if(isProgramLevel){
					assigneeApproverListStore.data.items.forEach(function(objAssignee){
						var programGroupDetailsObj = {};
						var programGroupDetails = {};
						programGroupDetailsObj.id= objAssignee.data.id;
						programGroupDetailsObj.program = {
								id:objAssignee.data.programId,
								value:objAssignee.data.programName
						};
						if(!isNullOrEmpty(objAssignee.data.assigneeId)){
							programGroupDetailsObj.defaultAssignee = {
									id:objAssignee.data.assigneeId
							};
						}
						else{
							if(!values.isStudentAdivsor){
							  programGroupCountCheck.push(objAssignee.data.groupName);
							}
						}

						programGroupDetailsArray.push(programGroupDetailsObj);
					});


				}else{
					assigneeApproverListStore.data.items.forEach(function(objAssignee){
						var programGroupDetailsObj = {};
						var programGroupDetails = {};
						programGroupDetails.programGroup = {
								id:objAssignee.data.id,
								value:objAssignee.data.value
						};
						programGroupDetailsObj.id= objAssignee.data.programDetailsId;
						programGroupDetailsObj.programGroupDetails = programGroupDetails;
						if(!isNullOrEmpty(objAssignee.data.assigneeId)){
							programGroupDetailsObj.defaultAssignee = {
									id:objAssignee.data.assigneeId
							};
						}
						else{
							if(!values.isStudentAdivsor){
							 programGroupCountCheck.push(objAssignee.data.value);
							}
						}

						programGroupDetailsArray.push(programGroupDetailsObj);
					});
				}
			}
			else{
				if(isProgramLevel){
					assigneeApproverListStore.data.items.forEach(function(objAssignee){
						var programGroupDetailsObj = {};
						var programGroupDetails = {};
						programGroupDetailsObj.id= objAssignee.data.id;
						programGroupDetailsObj.program = {
								id:objAssignee.data.programId,
								value:objAssignee.data.programName
						};
						if(!isNullOrEmpty(objAssignee.data.assigneeId)){
							programGroupDetailsObj.defaultAssignee = {
									id:objAssignee.data.assigneeId
							};
							assigneeRecordArray.push(objAssignee.data.assigneeId);
						}
						else{
							if(!values.isStudentAdivsor){
							 programGroupCountCheck.push(objAssignee.data.groupName);
							}
						}

						if(!isNullOrEmpty(objAssignee.data.approverId)){
							programGroupDetailsObj.defaultApprover = {
									id:objAssignee.data.approverId
							};
							 approverRecordArray.push(objAssignee.data.approverId);
						}
						else{
							if(!values.isStudentAdivsor){
							 programGroupCountCheck.push(objAssignee.data.groupName);
							}
						}

						programGroupDetailsArray.push(programGroupDetailsObj);
					});
				}else{
					assigneeApproverListStore.data.items.forEach(function(objAssignee){
						var programGroupDetailsObj = {};
						var programGroupDetails = {};
						programGroupDetails.programGroup = {
								id:objAssignee.data.id,
								value:objAssignee.data.value
						};
						programGroupDetailsObj.id= objAssignee.data.programDetailsId;
						programGroupDetailsObj.programGroupDetails = programGroupDetails;
						if(!isNullOrEmpty(objAssignee.data.assigneeId)){
							programGroupDetailsObj.defaultAssignee = {
									id:objAssignee.data.assigneeId
							};
							 assigneeRecordArray.push(objAssignee.data.assigneeId);
						}
						else{
							if(!values.isStudentAdivsor){
							 programGroupCountCheck.push(objAssignee.data.value);
							}
						}

						if(!isNullOrEmpty(objAssignee.data.approverId)){
							programGroupDetailsObj.defaultApprover = {
									id:objAssignee.data.approverId
							};
							 approverRecordArray.push(objAssignee.data.approverId);
						}
						else{
							if(!values.isStudentAdivsor){
							 programGroupCountCheck.push(objAssignee.data.value);
							}
						}

						programGroupDetailsArray.push(programGroupDetailsObj);
					});
				}
			}
			values.serviceRequestProgramGroupConfig = programGroupDetailsArray;
			delete values.defaultApprover;
			delete values.defaultAssignee;
			
			var programMsg = getServiceRequestTranslation('SERVICE_REQ_PROGRAM_LEVEL_MSG');
			
			if(!isNullOrEmpty(isProgramLevel) && isProgramLevel == true){
				programMsg = getServiceRequestTranslation('SERVICE_REQ_PROGRAM_GROUP_MSG');
			}
			
			
			/**************start code here for allow to save if atleast one record is filled in grid*****************/
			var allowToSave =false;
			if(assigneeApproverListStore.data.length>0){
				if(values.isAutoApprove){
					allowToSave=true;
				}
				if(values.isAutoAssignee){
					if(approverRecordArray.length == assigneeApproverListStore.data.length){
						allowToSave=true;
					}
				}else if(values.isAutoApprove){
					if(assigneeRecordArray.length == assigneeApproverListStore.data.length){
						allowToSave=true;
					}
				}
				
				if(!values.isAutoAssignee && !values.isAutoApprove){
					assigneeApproverListStore.data.items.forEach(function(objAssignee){
						
						if(!isNullOrEmpty(objAssignee.data.assigneeId)){
							if(isNullOrEmpty(objAssignee.data.approverId)){
								allowToSave=false;
							}else{
								allowToSave=true;
							}
						}else if(!isNullOrEmpty(objAssignee.data.approverId)){
							if(isNullOrEmpty(objAssignee.data.assigneeId)){
								allowToSave=false;
							}else{
								allowToSave=true;
							}
						}
						if(objAssignee.data.assigneeId == getExaminationTranslation('CLICK_TO_ENTER') || objAssignee.data.approverId == getExaminationTranslation('CLICK_TO_ENTER')){
							allowToSave=false;
						}
					});
				}
				
				else if(!values.isAutoAssignee && values.isAutoApprove){
					var items = assigneeApproverListStore.data.items;
					 allowToSave = true;

					for (var i = 0; i < items.length; i++) {
					    var objAssignee = items[i];

					    if (isNullOrEmpty(objAssignee.data.assigneeId) || 
					        objAssignee.data.assigneeId == getExaminationTranslation('CLICK_TO_ENTER')) {
					        allowToSave = false;
					        break;
					    }
					}
				}
			}		
			
			/**************End code here for allow to save if atleast one record is filled in grid*****************/
			
			if(programGroupCountCheck.length>0  && !allowToSave){
				showWarningMessage(getServiceRequestTranslation('ASSIGNEE_APPROVER_DETAILS'), getServiceRequestTranslation('PLEASE_SELECT_THE_DEFAULT_ASSIGNEE_APPROVER_FOR_ALL_THE_PROGRAM_GROUPS'));
			}else if(!allowToSave){
				showWarningMessage(getServiceRequestTranslation('ASSIGNEE_APPROVER_DETAILS'), getServiceRequestTranslation('PLEASE_SELECT_THE_DEFAULT_ASSIGNEE_APPROVER_FOR_ALL_THE_PROGRAM_GROUPS'));
			}else{
				if(values.whetherDocumentRequired){
					if(documentsArray.length >0){
						var submitData = Ext.encode(values);
						if(isNullOrEmpty(values.id)){
							showConfirmMessage(getServiceRequestTranslation('ASSIGNEE_APPROVER_DETAILS'), programMsg,
				    				function(btn, text) {
								if (btn == 'yes') {
									this$.applyWindowMask(); 
									this$.sendSaveAjaxRequest(submitUrl, methodType, submitData, function(success) {
										this$.hideWindowMask();
										if (success) {
											var window = button.up('window');
											showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'),getServiceRequestTranslation('SAVEDSUCCESSFULLY'));
											window.close();
											var grid = me.getRequestSettingGrid();
											//grid.getStore().reload();
											me.loadSettingGridOnSuccess();
										}
									});
								}
				    		});
						} else{
							this$.applyWindowMask(); 
							this$.sendSaveAjaxRequest(submitUrl, methodType, submitData, function(success) {
								this$.hideWindowMask();
								if (success) {
									var window = button.up('window');
									showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'),getServiceRequestTranslation('SAVEDSUCCESSFULLY'));
									window.close();
									var grid = me.getRequestSettingGrid();
									//grid.getStore().reload();
									me.loadSettingGridOnSuccess();
								}
							});
						}
					} else {
						showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST_SETTING'), getServiceRequestTranslation('PLEASE_SELECT_DOCUMENTS'));
					}
				} else {
					var submitData = Ext.encode(values);
					if(isNullOrEmpty(values.id)){
						showConfirmMessage(getServiceRequestTranslation('ASSIGNEE_APPROVER_DETAILS'), programMsg,
			    				function(btn, text) {
							if (btn == 'yes') {
								this$.applyWindowMask(); 
								this$.sendSaveAjaxRequest(submitUrl, methodType, submitData, function(success) {
									this$.hideWindowMask();
									if (success) {
										var window = button.up('window');
										showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'),getServiceRequestTranslation('SAVEDSUCCESSFULLY'));
										window.close();
										var grid = me.getRequestSettingGrid();
										//grid.getStore().reload();
										me.loadSettingGridOnSuccess();
									}
								});
							}
			    		});
					} else{
						this$.applyWindowMask(); 
						this$.sendSaveAjaxRequest(submitUrl, methodType, submitData, function(request, success, response) {
							this$.hideWindowMask();
							var flag =true;
							try{
								var resp = Ext.decode(response.responseText);
								if((!isNullOrEmpty(resp)) && (resp=='Service Request exist with Current Configuration'))
									flag=false;
							}
							catch(e){
								
							}
							
							if (flag && success) {
								var window = button.up('window');
								showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'),getServiceRequestTranslation('SAVEDSUCCESSFULLY'));
								window.close();
								var grid = me.getRequestSettingGrid();
								//grid.getStore().reload();
								me.loadSettingGridOnSuccess();
							}
							
							
						
							
						});
					}
				}
			}
		}
		else{
			showWarningMessage(getServiceRequestTranslation('ASSIGNEE_APPROVER_DETAILS'), getServiceRequestTranslation('NO_PROGRAM_GROUPS_MAPPED_WITH_SERVICE_REQUEST_SETTING'));
		}
	},
	openDefaultAssigneeGridWindow: function(dataIndex, record) {
		var defaultAssigneeApproverArray = [];
        var serviceRequestProgramGroupConfig = record.data.serviceRequestProgramGroupConfig;
        var isProgramLevel = record.data.isProgramLevel;
        var defaultAssigneeWindow = Ext.widget('defaultassigneeapprovergridwindow');
        if (defaultAssigneeWindow) {
        	if(dataIndex == "defaultAssignee"){
        		defaultAssigneeWindow.setTitle(getServiceRequestTranslation('DEFAULT_ASSIGNEE'));
        	}
        	else if(dataIndex == "defaultApprover"){
        		defaultAssigneeWindow.setTitle(getServiceRequestTranslation('DEFAULT_APPROVER'));
        	}
        	
            var store = defaultAssigneeWindow.down('grid').getStore();
            if(serviceRequestProgramGroupConfig.length>0){
            	serviceRequestProgramGroupConfig.forEach(function(obj){
            		var defaultAssigneeGridObj = {};
            		if(isProgramLevel){
            			defaultAssigneeGridObj.programId = obj.programGroupDetails.programGroup.value;
            			defaultAssigneeGridObj.programName = obj.program.value;
            			if(!isNullOrEmpty(obj.defaultAssignee)){
                		   defaultAssigneeGridObj.assigneeId = obj.defaultAssignee.code + ' / ' + obj.defaultAssignee.value;
            			}else if(record.data.isAutoAssignee){
            				defaultAssigneeGridObj.assigneeId = 'Auto';
            			}else{
            				if(!isNullOrEmpty(record.data.isStudentAdivsor) && record.data.isStudentAdivsor){
            					defaultAssigneeGridObj.assigneeId = getServiceRequestTranslation('STUDENTS_ASSIGNEE');
            				}
                		}
                		if(!isNullOrEmpty(obj.defaultApprover)){
                			defaultAssigneeGridObj.approverId = obj.defaultApprover.code + ' / ' + obj.defaultApprover.value;
                		}else if(record.data.isAutoApprove){
            				defaultAssigneeGridObj.approverId = 'Auto';
            			}
                		else{
                			if(!isNullOrEmpty(record.data.isStudentAdivsor) && record.data.isStudentAdivsor){
                				defaultAssigneeGridObj.approverId = 'Auto';
                			}
                		}
            		}
            		else{
            			defaultAssigneeGridObj.programId = obj.programGroupDetails.programGroup.value;
            			if(!isNullOrEmpty(obj.defaultAssignee)){
                		  defaultAssigneeGridObj.assigneeId = obj.defaultAssignee.code + ' / ' + obj.defaultAssignee.value;
            			}else if(record.data.isAutoAssignee){
            				defaultAssigneeGridObj.assigneeId = 'Auto';
            			}else{
            				if(!isNullOrEmpty(record.data.isStudentAdivsor) && record.data.isStudentAdivsor){
            					defaultAssigneeGridObj.assigneeId = getServiceRequestTranslation('STUDENTS_ASSIGNEE');
            				}
                		}
                		if(!isNullOrEmpty(obj.defaultApprover)){
                			defaultAssigneeGridObj.approverId = obj.defaultApprover.code + ' / ' + obj.defaultApprover.value;
                		}
                		else{
                			if(!isNullOrEmpty(record.data.isStudentAdivsor) && record.data.isStudentAdivsor){
                				defaultAssigneeGridObj.approverId = 'Auto';
                			}
                		}
            		}
            		
            		defaultAssigneeApproverArray.push(defaultAssigneeGridObj);
            	});
            }
            store.loadData(defaultAssigneeApproverArray);
        }
        defaultAssigneeWindow.show();
        if(isProgramLevel){
        	defaultAssigneeWindow.down('defaultassigneeapprovergrid').down('[dataIndex=programName]').show();
        }else{
        	defaultAssigneeWindow.down('defaultassigneeapprovergrid').down('[dataIndex=programName]').hide();
        }
    },
    
    openDefaultAssigneeGridWindowForHostel: function(dataIndex, record) {
		var defaultAssigneeApproverArray = [];
        var hostelServiceRequestSetting = record.data.hostelServiceRequestSetting;
        var defaultAssigneeWindow = Ext.widget('defaultassigneeapprovergridhostelwindow');
        if (defaultAssigneeWindow) {
        	if(dataIndex == "defaultAssignee"){
        		defaultAssigneeWindow.setTitle(getServiceRequestTranslation('DEFAULT_ASSIGNEE'));
        	}
        	else if(dataIndex == "defaultApprover"){
        		defaultAssigneeWindow.setTitle(getServiceRequestTranslation('DEFAULT_APPROVER'));
        	}
        	
            var store = defaultAssigneeWindow.down('grid').getStore();
            if(hostelServiceRequestSetting.length>0){
            	hostelServiceRequestSetting.forEach(function(obj){
            		var defaultAssigneeGridObj = {};
            		defaultAssigneeGridObj.hostelId = obj.hostel.hostelId;
            		defaultAssigneeGridObj.resourceName = obj.hostel.resourceName;
            		if(!isNullOrEmpty(obj.defaultAssignee)){
            		   defaultAssigneeGridObj.assigneeId = obj.defaultAssignee.code + ' / ' + obj.defaultAssignee.value;
            		}else{
            			defaultAssigneeGridObj.assigneeId = getServiceRequestTranslation('STUDENTS_ASSIGNEE');
            		}
            		if(!isNullOrEmpty(obj.defaultApprover)){
            			defaultAssigneeGridObj.approverId = obj.defaultApprover.code + ' / ' + obj.defaultApprover.value;
            		}
            		else{
            			defaultAssigneeGridObj.approverId = 'Auto';
            		}
            		defaultAssigneeApproverArray.push(defaultAssigneeGridObj);
            	});
            }
            store.loadData(defaultAssigneeApproverArray);
        }
        defaultAssigneeWindow.show();
    },
    
    saveRequestSettingsHostel: function(button){
		var this$ = this;
		var form = button.up('form');
		var values = form.getValues();
		if(!isNullOrEmpty(values.feeStageMaster)) {
			values.feePlanRuleStage = {id:values.feeStageMaster};
		}
		delete values.feeHead;
		delete values.feePlanType;
		delete values.feePlan;
		delete values.feePlanRule;
		delete values.feeStageMaster;

		values.isAutoApprove = form.down('#autoApprove').getValue();
		values.isStudentAdivsor=values.isStudentAdivsor;
		//values.isStudentAdivsor = form.down('#isStudentAdivsorHostel').getValue();
		delete values.isStudentAdivsorHostel;
		var me = this;
		var submitUrl = SERVERURL.REQUEST_SETTING;
		var serviceRequestGroup = me.getServiceRequestGroup();
		var serviceType = me.getServiceType();
		values.requestStatusIds = this.getStatusArray(values.requestStatusIds);
		delete values.status;
	
		delete values.rule;
		delete values.ruleDescription;
		delete values.documents;
		delete values.module;
		var methodType;
		values.requestType = Ext.decode(values.requestType);
		values.academyLocation = Ext.decode(values.academyLocation);
		values.serviceRequestCategory = this.getServiceType(values.status);
		if (isNullOrEmpty(values.id)) {
			methodType = 'POST';
		} else {
			methodType = 'PUT';
		}
		var documentsArray = [];
		var hostelDetailsArray = [];
		var hostelCountCheck = [];
		var docList = form.down('#documentsEditableGridItemId').getSelectionModel().getSelection();
		if(docList.length>0){
			docList.forEach(function(doc){
				var documentRuleObj = {};
				documentRuleObj.id = doc.data.idRule;
				documentRuleObj.documentType ={
						id:doc.data.id,
						value:doc.data.value
				};
				
				if(!isNullOrEmpty(doc.data.referenceDocument)){
					documentRuleObj.document = {
							type: "DOCUMENT",
							name: doc.data.referenceDocument,
							path:doc.data.refDocumentPath
					};
				}
				if(!isNullOrEmpty(doc.data.refDocumentId)){
					documentRuleObj.document = {
							id:doc.data.refDocumentId,
							type: "DOCUMENT",
							name: doc.data.referenceDocument,
							path:doc.data.refDocumentPath
					};
				}
				
				documentRuleObj.rule = doc.data.rule;
				documentRuleObj.ruleDescription = doc.data.ruleDescription;

				documentsArray.push(documentRuleObj);
			});
		}
		values.documentRules = documentsArray;

		if(values.requestRaisedFromPortal){
			values.requestRaisedFromPortal = 3;
		}
		else{
			values.requestRaisedFromPortal = 1; // Core ERP only
		}
		var assigneeApproverList = form.down('#assigneeapprovereditablegridforhostelItemId');
		var assigneeApproverListStore = assigneeApproverList.getStore();

		if(assigneeApproverListStore.data.length>0){
			if(values.isAutoApprove){
				assigneeApproverListStore.data.items.forEach(function(objAssignee){
					var hostelDetailsObj = {};
					var hostel = {};
					hostel = {
							id:objAssignee.data.id,
					};
					hostelDetailsObj.id= objAssignee.data.programDetailsId;
					hostelDetailsObj.hostel = hostel;
					if(!isNullOrEmpty(objAssignee.data.assigneeId)){
						hostelDetailsObj.defaultAssignee = {
								id:objAssignee.data.assigneeId
						};
					}
					else{
						if(!values.isStudentAdivsor){
						   hostelCountCheck.push(objAssignee.data.value);
						}
					}

					hostelDetailsArray.push(hostelDetailsObj);
				});
			}
			else{
				assigneeApproverListStore.data.items.forEach(function(objAssignee){
					var hostelDetailsObj = {};
					var hostel = {};
					hostel = {
							id:objAssignee.data.id,
					};
					hostelDetailsObj.id= objAssignee.data.programDetailsId;
					hostelDetailsObj.hostel = hostel;
					if(!isNullOrEmpty(objAssignee.data.assigneeId)){
						hostelDetailsObj.defaultAssignee = {
								id:objAssignee.data.assigneeId
						};
					}
					else{
						if(!values.isStudentAdivsor){
						  hostelCountCheck.push(objAssignee.data.value);
						}
					}

					if(!isNullOrEmpty(objAssignee.data.approverId)){
						hostelDetailsObj.defaultApprover = {
								id:objAssignee.data.approverId
						};
					}
					else{
						if(!values.isStudentAdivsor){
						  hostelCountCheck.push(objAssignee.data.value);
						}
					}

					hostelDetailsArray.push(hostelDetailsObj);
				});
			}
			values.hostelServiceRequestSetting = hostelDetailsArray;
			delete values.defaultApprover;
			delete values.defaultAssignee;

			if(hostelCountCheck.length>0){
				showWarningMessage(getServiceRequestTranslation('ASSIGNEE_APPROVER_DETAILS'), getServiceRequestTranslation('PLEASE_SELECT_THE_DEFAULT_ASSIGNEE_APPROVER_FOR_ALL_HOSTEL'));
			}
			else{
				if(values.whetherDocumentRequired){
					if(documentsArray.length >0){
						var submitData = Ext.encode(values);
						this$.applyWindowMask(); 
						this.sendSaveAjaxRequest(submitUrl, methodType, submitData, function(success) {
							this$.hideWindowMask();
							if (success) {
								var window = button.up('window');
								showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'),getServiceRequestTranslation('SAVEDSUCCESSFULLY'));
								window.close();
								var grid = me.getRequestSettingGrid();
								//grid.getStore().reload();
								me.loadSettingGridOnSuccess();
							}
						});
					} else {
						showWarningMessage(getServiceRequestTranslation('SERVICE_REQUEST_SETTING'), getServiceRequestTranslation('PLEASE_SELECT_DOCUMENTS'));
					}
				} else {
					var submitData = Ext.encode(values);
					this$.applyWindowMask(); 
					this.sendSaveAjaxRequest(submitUrl, methodType, submitData, function(success) {
						this$.hideWindowMask();
						if (success) {
							var window = button.up('window');
							showSuccessMessage(getServiceRequestTranslation('SERVICE_REQUEST'),getServiceRequestTranslation('SAVEDSUCCESSFULLY'));
							window.close();
							var grid = me.getRequestSettingGrid();
							//grid.getStore().reload();
							me.loadSettingGridOnSuccess();
						}
					});
				}
			}
		}
		else{
			showWarningMessage(getServiceRequestTranslation('ASSIGNEE_APPROVER_DETAILS'), getServiceRequestTranslation('NO_HOSTEL_MAPPED_WITH_SERVICE_REQUEST_SETTING'));
		}
	},
	uploadReferenceDocumentFile : function(fileField, value, eOpts){
		var grid = this.getDocumentseditable();
		var store = grid.getStore();
		var record = grid.getSelectionModel().getSelection()[0];
		value = value.replace('C:\\fakepath\\', '');
		var newValue = value.replace(/ +/g, " ").split(' ').join('_');
		var file = fileField.fileInputEl.dom.files[0];
		var type = fileField.fileInputEl.dom.files[0].type;
		var toolbar = grid.down('toolbar');
		var form = toolbar.down('form');
		form.down('#moduleId').setValue("serviceRequestSettingDocument");
		if(!isNullOrEmpty(form)){
			form.getForm().submit({
				method : 'POST',
				url : SERVERURL.DOCUMENT_FILE_ADD,
				success : function(form1, action){
					var responseData = Ext.decode(action.response.responseText);
					var path = responseData.path;
					record.set('referenceDocument',value);
					record.set('refDocumentPath',path);
					record.set('refDocumentType',type);
					fileField.reset();
				},
				failure:function(){
					console.log('hello');
				}
			});
		}
		
		/*store.add({
			file:file,
			name: file.name,
			size: file.size,
			status: 'Ready'
		});*/
	},
	getDocumentController : function() {
		var this$ = this;
		return this$.getController('Academia.controller.document.DocumentController');
	},
	changeProgramLevelRadioGroup : function(radio,newValue, oldValue){
    	var $this = this;
    	var form = radio.up('form');
    	var radioValue = radio.getValue().isProgramLevel;

    	var programGroupGrid = form.down('#assigneeapprovereditablegridItemId');
    	var programLevelGrid = form.down('#assigneeapprovereditableprogramlevelgridItemId');
    	var autoApprove = form.down('#autoApprove').getValue();
    	var autoAssignee = form.down('#isAutoAssigneeId').getValue();
    	var isStudentAdvisor = form.down('#isStudentAdivsor').getValue();
    	var userId= $this.getCurrentlyLoggedInUser().id;
    	if(radioValue==false){
    		
    		var academyLocationId = this.getCurrentAcademyLocation();

    		programLevelGrid.setVisible(false);
            programGroupGrid.setVisible(true);
            
            if (autoApprove) {
            	programGroupGrid.down('[dataIndex=approverId]').hide();
            	programGroupGrid.down('[dataIndex=approverIdAuto]').show();
        		
        	}else{
        		programGroupGrid.down('[dataIndex=approverIdAuto]').hide();
        		programGroupGrid.down('[dataIndex=approverId]').show();
        	}
            
            if(isStudentAdvisor){
            	programGroupGrid.down('[dataIndex=assigneeId]').hide();
            	programGroupGrid.down('[dataIndex=defaultAssigneeAuto]').show();
            }else if(autoAssignee){
            	programLevelGrid.down('[dataIndex=assigneeId]').hide();
            	programLevelGrid.down('[dataIndex=assigneeIdAuto]').show();
        	}else{
            	programGroupGrid.down('[dataIndex=defaultAssigneeAuto]').hide();
            	programLevelGrid.down('[dataIndex=assigneeIdAuto]').hide();
        		programGroupGrid.down('[dataIndex=assigneeId]').show();
            }
    	}
    	else if(radioValue==true){
    		var store = programLevelGrid.getStore();
            store.load();
            programGroupGrid.setVisible(false);
            programLevelGrid.setVisible(true);
            if (autoApprove) {
            	programLevelGrid.down('[dataIndex=approverId]').hide();
            	programLevelGrid.down('[dataIndex=approverIdAuto]').show();
        		
        	}else{
        		programLevelGrid.down('[dataIndex=approverIdAuto]').hide();
        		programLevelGrid.down('[dataIndex=approverId]').show();
        	}
            
            if(isStudentAdvisor){
            	programLevelGrid.down('[dataIndex=assigneeId]').hide();
            	programLevelGrid.down('[dataIndex=defaultAssigneeAuto]').show();
            }else if(autoAssignee){
            	programLevelGrid.down('[dataIndex=assigneeId]').hide();
            	programLevelGrid.down('[dataIndex=assigneeIdAuto]').show();
        	}else{
            	programLevelGrid.down('[dataIndex=defaultAssigneeAuto]').hide();
            	programLevelGrid.down('[dataIndex=assigneeIdAuto]').hide();
            	programLevelGrid.down('[dataIndex=assigneeId]').show();
            }
    	}
    }
});