/**
 * @author Dharmendra.Prajapati
 */

Ext.define('Academia.model.hostel.managehostel.hostel.ManageHostelGrid', {
	extend : 'Academia.model.AbstractDataModel',
	fields : ['resourceId','hostelId','hostelCode','hostelName','noOfBuilings','hostelBuildingId','roomTypeId','hostelFloorId','hostelRoomId',
	          'buildingCode','buildingName','floorNo','roomNo','roomType','noOfFloors','noOfRooms','noOfBeds','warden',
	          'manager','status','ownership','phoneNo','contactNo','emailId','remarks', 'startDate', 'closureDate','subWarden','restrictionType','hostelLevel','hostelType','clusterCode','hostelCategory',
	          {
				  name    : 'hostelCodeName', 
		          convert : function (v, rec) {
		             return rec.get('hostelCode') + ' / ' + rec.get('hostelName');
		          }
	          }, {
				  name    : 'wardenPrintName', 
		          convert : function (v, rec) {
		        	  if(!isNullOrEmpty(rec.get('warden')) && !isNullOrEmpty(rec.get('warden').value)) {
		        		  return rec.get('warden').value;
		        	  } 
		        	  return '';
		          }
	          }, {
				  name    : 'managerPrintName', 
		          convert : function (v, rec) {
		        	  if(!isNullOrEmpty(rec.get('manager')) && !isNullOrEmpty(rec.get('manager').value)) {
		        		  return rec.get('manager').value;
		        	  } 
		        	  return '';
		          }
	          }]	
});
