Ext.define('Academia.store.admission.applicationFormSale.SaleRefComboStore', {
    extend: 'Ext.data.Store',
    model: 'Academia.model.admission.applicationFormSale.SaleRefModel',
    autoLoad: false,
    proxy: {
        type: 'rest',
        api: {
            read: SERVERURL.APPLICATION_FORM_SALE_REFERENCES //URL-:rest/applicationForm/findApplicationFormReferences
        },
        reader: {
            type: 'json'
        }
    },
    listeners: {
        load: {
            element: 'el',
            fn: function(store, records, successful, eOpts) {
                var me = this;
                for (var count = 0; count < records.length; count++) {
                    var record = records[count];
                    var concatValue = "";
                    concatValue = me.concatValue(concatValue, record, 'code');
                    concatValue = me.concatValue(concatValue, record, 'firstName');
                    concatValue = me.concatValue(concatValue, record, 'middleName');
                    concatValue = me.concatValue(concatValue, record, 'lastName');
                    concatValue=concatValue.trim();
                    records[count].set('value', concatValue);
                }
                store.commitChanges();
            }
        }
    },
    concatValue: function(concatValue, record, key) {
        var value = record.get(key);
        if (!isNullOrEmpty(value)) {
            concatValue = concatValue.concat(value+" ");
            return concatValue;
        } else {
            return concatValue;
        }
    }
});