/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.store.common.PreReqNotMetReportStore', {
    extend: 'Ext.data.Store',
    fields: [
    	"admissionId",
    	"studentId",
    	"studentName",
    	{
    		name: "studentIdName",
    		convert : function (v, rec) {
	           return rec.get('studentId') + ' / ' + rec.get('studentName');
	        }
    	},
    	"suNumber",
    	"programCode",
    	"programName",
    	"batchName",
    	"periodName",
    	"academyLocationName",
    	"courseAndMarksMap",
    	{
    		name: "courseAndMarksMapString",
    		convert : function (v, rec) {
    			var returnString = '';
    			Ext.each(rec.get('courseAndMarksMap'), function(currentCourseAndMarksMap){
    				var i = 0;
    				Ext.each(Object.keys(currentCourseAndMarksMap), function(currentRec){

        				var moduleName = Object.keys(currentCourseAndMarksMap)[i];
        				var moduleMarks = Object.values(currentCourseAndMarksMap)[i];
        				
        				i = i+1;
        				returnString = isNullOrEmpty(returnString) ? moduleName+":"+moduleMarks : returnString+","+moduleName+":"+moduleMarks;
    				});
    			});
    			return returnString;
	        }
    	},
    	"preRequisiteJson",
    	"courseCodetoDeenroll"
    ],
    autoLoad: false,
    proxy: {
        type: 'rest',
        api: {
            read: SERVERURL.PATH_GET_PRE_REQUISITE_REPORT_FOR_ENROLLED_STUDENT
        },
        method: 'GET',
        reader: {
            type: 'json',
            root: 'rows',
            totalProperty: 'records'
        }
    }

});