/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.store.common.StudentAndCourseByPeriodIdStore', {
    extend: 'Ext.data.Store',
    fields: [
    	'courseId',
        'courseCode',
    	'coursePrintName',
        'studentId',
    	'suNumber',
    	'userId',
    	'studentName',
    	{
    		name: 'courseCodeName',
    		convert : function (v, rec) {
    			return rec.get('courseCode')+"/"+rec.get('coursePrintName');
            }
    	},
    	{
    		name: 'studentIdName',
    		convert : function (v, rec) {
    			return rec.get('studentId')+"/"+rec.get('studentName');
            }
    	}
    ],
    autoLoad: false,
    proxy: {
        type: 'rest',
        api: {
            read: SERVERURL.FIND_STUDENT_AND_COURSES_BY_PERIODID
        },
        method: 'GET',
        reader: {
            type: 'json'
        }
    }

});