/**
 * This store is used for student fee and payment dashboard report tree panel
 * @author Bhanu Pratap Singh
 * @author Rajkumar Patidar
 */
Ext.define('Academia.store.enquiry.EnquiryReportTreeStore', {
	extend : 'Ext.data.TreeStore',
	fields: ['reportXtype', 'reportXtypeItemId', 'text','permissionKey'],
	root: {
        success: true,
		    children: [{
		    	text: getCommonTranslation('FOLLOWUP_SCHEDULED'),
		    	reportXtype: 'followupscheduledstructure',
		    	reportXtypeItemId: 'followupscheduledstructure',
		    	permissionKey: 'ENQ_FOLLOWUP_SCHEDULED',
		    	expanded: true,
		        leaf: false
		    },{
		    	text: getCommonTranslation('PENDING_ENQUIRIES'),
		    	reportXtype: 'pendingenquiriesstructure',
		    	permissionKey: 'ENQ_PENDING_ENQUIRIES',
		    	reportXtypeItemId: 'pendingenquiriesstructure',
		        leaf: false,
		        expanded: true
		    },{
		    	text: getCommonTranslation('COUNT_OF_ENQUIRIES'),
		    	reportXtype: 'countofenquiriesstructure',
		    	permissionKey: 'ENQ_COUNT_OF_ENQUIRIES',
		    	reportXtypeItemId: 'countofenquiriesstructure',
		        leaf: false,
		        expanded: true
		    },{
		    	text: getEnquiryTranslation('CLOSUR_RATE'),
		    	reportXtype: 'closurratestructure',
		    	permissionKey: 'ENQ_CLOSUR_RATE',
		    	reportXtypeItemId: 'closurratestructure',
		        leaf: false,
		        expanded: true
		    },{
		    	text: getCommonTranslation('CLOSURE_REASON'),
		    	reportXtype: 'closurereasonstructure',
		    	permissionKey: 'ENQ_CLOSURE_REASON',
		    	reportXtypeItemId: 'closurereasonstructure',
		        leaf: false,
		        expanded: true
		    },{
		    	text: getEnquiryTranslation('ENQUIRY_SUMMARY'),
		    	reportXtype: 'enquirysummarystructure',
		    	permissionKey: 'ENQ_ENQUIRY_SUMMARY',
		    	reportXtypeItemId: 'enquirysummarystructureid',
		        leaf: false,
		        expanded: true
		    }]
    //}]
	}
});

