/**
 * Author Pankaj Sisodiya
 */
Ext.define('Academia.store.manageCeremony.CeremonyStudentMappedStore', {
    extend: 'Ext.data.Store',
    fields : ['id','studentCode','studentName','addressText','primaryeEmailId','cellNo','enrolledProgramName','personId','scholarShipAmount','admissionId',
		'studentStatus','programBatchPeriodConfigurationId',
	          {
				name    : 'valueCode', 
	          convert : function (v, rec) {
	             return rec.get('studentCode') + ' / ' + rec.get('studentName');
	          }
	      }],	
    autoLoad: false,
    proxy: {
        type: 'rest',
        api: {
            read: SERVERURL.FIND_ENROLLED_STUDENT_BY_CEREMONY_ID
        },
        method: 'GET',
        reader: {
            type: 'json',
            root: 'rows',
            totalProperty: 'records'
        }
    }

});