/**
 * @author trupti.paoneker
 *   
 */
Ext.define('Academia.store.othermasters.currencymaster.CurrencyNameStore', {
    extend: 'Ext.data.Store',
    autoLoad: false,
    model : 'Academia.model.common.IdValueDataModel',
    sorters: [{
	    sorterFn: function(o1, o2) {
	        var value1 = o1.get('value');
	        var value2 = o2.get('value');

	        if (!isNullOrEmpty(value1) && !isNullOrEmpty(value2)) {
	            if (value1.toLowerCase() === value2.toLowerCase()) {
	                return 0;
	            } else {
	                return value1.toLowerCase() > value2.toLowerCase() ? 1 : -1;
	            }
	        }
	        return 0;
	    }
	}],
    proxy: {
		type: 'ajax',
		api: {
			read: 'data/currency/CurrencyName.json'
		},
		reader: {
			type: 'json',
			root: 'name',
			successProperty: 'success'
		}
	}
});

