/**
 * @Author Amit g
 */
Ext.define('Academia.store.personinfo.common.pasthistory.ApplicantHealthInformationDetailStore', {
    extend: 'Ext.data.Store',
    fields: [
    	'medicalConditions',
    	{
    		name: 'MedicalConditionsNameVal',
    		convert: function( v, record ) {
    	    	if( !isNullOrEmpty(record.get( 'medicalConditions' )) && record.get( 'medicalConditions' ).length){
    	    		return Ext.Array.pluck(record.get( 'medicalConditions' ),'value').join();
    	    	}
    	    	return "";
    	    }
    	}, 
    	'medication',
    	{
    		name: 'medicationNameVal',
    		convert: function( v, record ) {
    	    	if( !isNullOrEmpty(record.get( 'medication' )) && record.get( 'medication' ).length){
    	    		return Ext.Array.pluck(record.get( 'medication' ),'value').join();
    	    	}
    	    	return "";
    	    }
    	},
    	
    	'allergies', 
    	{
    		name: 'allergiesNameVal',
    		convert: function( v, record ) {
    	    	if( !isNullOrEmpty(record.get( 'allergies' )) && record.get( 'allergies' ).length){
    	    		return Ext.Array.pluck(record.get( 'allergies' ),'value').join();
    	    	}
    	    	return "";
    	    }
    	},
    	
    	'learningDifficulties',
    	{
    		name: 'learningDifficultiesNameVal',
    		convert: function( v, record ) {
    	    	if( !isNullOrEmpty(record.get( 'learningDifficulties' )) && record.get( 'learningDifficulties' ).length){
    	    		return Ext.Array.pluck(record.get( 'learningDifficulties' ),'value').join();
    	    	}
    	    	return "";
    	    }
    	},
    	'medicalConditionOther',
    	'medicationOther', 
    	'allergiesOther',
    	'learningDifficultiesOther',
    	'applicantHealthDocument',
    	'applicantHealthDocumentUrl',
    	'auditId'
    ],
    autoLoad: false,
    proxy: {
        type: 'rest',
        method: 'GET',
        api: {
            read: SERVERURL.PATH_APPLICANT_HEALTH_INFORMATION_GRID_DATA
        },
        reader: {
            type: 'json',
            root: 'rows',
            totalProperty: 'records'
        }
    }
});
