/**
 * @Author Suraj Chouhan
 */
Ext.define('Academia.store.personinfo.common.personalinfo.VisaDetailStore', {
    extend: 'Ext.data.Store',
    fields: ['visaType','countryOfIssue', 'visaStatus', 'visaAppliedDate', 'visaIssuedDate', 'visaCollectedDate','visaExpiryDate','dateOfCountryEntryAllowance','visaCancellationDate','reasonForAVisaBeingRefused','visaIsPrimary', 'studentVisaDocument', 'studentVisaDocumentUrl', 'auditId', 'dateOfentryAllowance', 'reasonVisaRefused', 'isPrimary','studentDateOfentryAllowance','studentVisaExpiryDate','studentVisaAppliedDate','studentVisaIssuedDate','studentVisaCollectedDate','studentVisaCancellationDate', {
    	name:'visaTypeValue',
    	convert: function(v, rec) {
        	if(rec.data.visaType && !isNullOrEmpty(rec.data.visaType.value)){
        		return rec.data.visaType.value;
        	}
        	else{
        		return "";
        	}
        }
    },{
    	name:'countryOfIssueValue',
    	convert: function(v, rec) {
        	if(rec.data.countryOfIssue && !isNullOrEmpty(rec.data.countryOfIssue.value)){
        		return rec.data.countryOfIssue.value;
        	}
        	else{
        		return "";
        	}
        }
    },{
    	name:'visaStatusValue',
    	convert: function(v, rec) {
        	if(rec.data.visaStatus && !isNullOrEmpty(rec.data.visaStatus.value)){
        		return rec.data.visaStatus.value;
        	}
        	else{
        		return "";
        	}
        }
    }],
    autoLoad: false,
    proxy: {
        type: 'rest',
        method: 'GET',
        api: {
            read: SERVERURL.PATH_STUDENT_VISA_DETAIL_GRID_DATA
        },
        reader: {
            type: 'json',
            root: 'rows',
            totalProperty: 'records'
        }
    }
});
