/**
 * This store is used for student request dashboard report tree panel
 * @author Sachin.Bangar
 */
Ext.define('Academia.store.reports.servicerequest.StudentRequestReportTreeStore', {
	extend : 'Ext.data.TreeStore',
	fields: ['reportXtype', 'reportXtypeItemId', 'text'],
	root: {
        success: true,
        children: [{
        	text: getServiceRequestTranslation('STUDENT_REQUEST'),
        	reportXtype: '',
        	reportXtypeItemId: '',
            leaf: false,
            expanded: true,
            children: [{
            	text: getServiceRequestTranslation('UNASSIGNED_REQUESTS'),
            	reportXtype: 'unassignedrequestreportquicksearchview',
            	reportXtypeItemId: 'studentUnassignedRequestReport',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('FOLLOW_UP_SCHEDULED'),
            	reportXtype: 'followupscheduledreportquicksearchview',
            	reportXtypeItemId: 'studentFollowUpScheduledReport',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('REQUEST_CLOSURE_RATE'),
            	reportXtype: 'studentrequestclosurerateview',
            	reportXtypeItemId: 'studentRequestClosureRateView',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('COUNT_OF_REQUEST'),
            	reportXtype: 'studentcountofrequestview',
            	reportXtypeItemId: 'studentCountOfRequestView',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('SERVICE_LEVEL_GRAPH'),
            	reportXtype: 'studentservicelevelview',
            	reportXtypeItemId: 'studentServiceLevelView',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('CLOSURE_REASON'),
            	reportXtype: 'studentclosurereasonview',
            	reportXtypeItemId: 'studentClosureReasonView',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('SERVICE_DETAIL_REPORT'),
            	reportXtype: 'serviceDetailReportview',
            	reportXtypeItemId: 'serviceDetailReportview',
                leaf: true
            }, {
            	text: getServiceRequestTranslation('STUDENT_MEMBERSHIP_REQUEST_REPORT'),
            	reportXtype: 'studentMembershipRequestReportStructure',
            	reportXtypeItemId: 'studentMembershipRequestReportStructure',
                leaf: true
            }]
        },{
        	text: getServiceRequestTranslation('STUDENT_EXITS'),
        	reportXtype: '',
        	reportXtypeItemId: '',
            leaf: false,
            expanded: true,
            children: [{
            	text: getServiceRequestTranslation('EXITS'),
            	reportXtype: 'studentexitview',
            	reportXtypeItemId: 'studentExitViewId',
                leaf: true
            }]
        }]
    }
});