/**
 * 
 * @author Rohit Thadani
 * 
 */
Ext.define('Academia.store.student.studentenrollmentreport.StudentProjectedPromotionReportStore', {
	extend : 'Ext.data.Store',
	model : 'Academia.model.student.studentenrollmentreport.StudentEnrollmentReportDetailModel',
	autoLoad : false,
	sorters: [{
	    sorterFn: function(o1, o2) {
	                
        	var nameValue1 = o1.get('firstName');
        	var nameValue2 = o2.get('firstName');
        	if (!isNullOrEmpty(nameValue1) && !isNullOrEmpty(nameValue2)) {
        		if (nameValue1.toLowerCase() === nameValue2.toLowerCase()) {
        			
        			var lastNameValue1 = o1.get('lastName');
	            	var lastNameValue2 = o2.get('lastName');
	            	if (!isNullOrEmpty(lastNameValue1) && !isNullOrEmpty(lastNameValue2)) {
	            		if (lastNameValue1.toLowerCase() === lastNameValue2.toLowerCase()) {
	            			return 0;
	            		} else{
	            			return lastNameValue1.toLowerCase() > lastNameValue2.toLowerCase() ? 1 : -1;
	            		}
	            	}
        			
        		} else{
        			return nameValue1.toLowerCase() > nameValue2.toLowerCase() ? 1 : -1;
        		}
        	}
        	
        	return 0;
	    }
	}],
	proxy : {
		type : 'rest',
		api:{
			read:SERVERURL.PATH_STUDENT_PROJECTED_PROMOTIONS_REPORT
		},
		reader: {
			type: 'json',
			root: 'rows',
			totalProperty: 'records'
		}
	},
	/*data : [
		{programName: 'dummy',   batchName: 'dummy', leftStudents: 29, currentStudents: 29, leavingStudents: 29, repeatStudents: 29, startingStudents: 29, totalEnrollments: 29},
    ]*/
});

