/**
 * class for maintaning the feature privileges for the particular screen.
 */
Ext.define('Academia.utilities.accessControl.FeaturePrivilegeManager',{
	singleton: true,
	config: {
		featurePrivilegesMap : null
	},
	constructor: function(config) {
		this.initConfig(config);
		featurePrivilegesMap = new Ext.util.HashMap();
		/**
		 * Constants to be used: 
		 * [CREATE, UPDATE, VIEW, DELETE, EXPORT] 
		 */
		
		scholarshipFeaturePrivileges = new Ext.util.HashMap();
		scholarshipFeaturePrivileges.add(FPCONSTANTS.PC_M11_D_SCHOLARSHIP_EXPORT, "EXPORT");
		scholarshipFeaturePrivileges.add(FPCONSTANTS.PC_M11_R_SPONSORSHIP_EXPORT, "EXPORT");
		scholarshipFeaturePrivileges.add(FPCONSTANTS.PC_M11_D_SCHOLARSHIP_VIEW, "VIEW");
		scholarshipFeaturePrivileges.add(FPCONSTANTS.PC_M11_R_SPONSORSHIP_VIEW, "VIEW");
		featurePrivilegesMap.add("SCHOLARSHIP", scholarshipFeaturePrivileges);
		
		serviceRequestSettingsPrivileges = new Ext.util.HashMap();
		serviceRequestSettingsPrivileges.add(FPCONSTANTS.PC_M12_F_SERVICEREQUESTSETTINGS_UPDATE, "UPDATE");
		/*serviceRequestSettingsPrivileges.add(FPCONSTANTS.PC_M12_F_SERVICEREQUESTSETTINGS_CREATE, "CREATE");*/
		serviceRequestSettingsPrivileges.add(FPCONSTANTS.PC_M12_F_SERVICEREQUESTSETTINGS_VIEW, "VIEW");
		featurePrivilegesMap.add("SERVICE_REQUEST_SETTINGS", serviceRequestSettingsPrivileges);
		
		campaigntabPrivileges = new Ext.util.HashMap();
		campaigntabPrivileges.add(FPCONSTANTS.PC_M1_F_CAMPAIGNTAB_EXPORT, "EXPORT");
		campaigntabPrivileges.add(FPCONSTANTS.PC_M1_F_CAMPAIGNTAB_EXPORT_REPORTS, "EXPORT_REPORTS");
		featurePrivilegesMap.add("CAMPAIGN_TAB_PRIVILEGES", campaigntabPrivileges);
	   
		//campaignPrivileges = new Ext.util.HashMap();
		//campaignPrivileges.add(FPCONSTANTS.PC_M1_F_CAMPAIGN_EXPORT_UPDATE, "UPDATE");
	//	featurePrivilegesMap.add("CAMPAIGN_PRIVILEGES", campaignPrivileges);
	   

		campaignPrivileges=new Ext.util.HashMap();
		campaignPrivileges.add(FPCONSTANTS.PC_M1_F_VIEWCAMPAIGN_VIEW,"VIEW");
		campaignPrivileges.add(FPCONSTANTS.PC_M1_F_VIEWCAMPAIGN_EDIT, "EDIT");
		campaignPrivileges.add(FPCONSTANTS.PC_M1_F_VIEWCAMPAIGN_CREATE, "CREATE");
		campaignPrivileges.add(FPCONSTANTS.PC_M1_F_VIEWCAMPAIGN_DELETE,"DELETE");
		campaignPrivileges.add(FPCONSTANTS.PC_M1_F_VIEWCAMPAIGN_EXPORT,"EXPORT");
		campaignPrivileges.add(FPCONSTANTS.PC_M1_F_CAMPAIGN_UPDATE, "UPDATE");
		campaignPrivileges.add(FPCONSTANTS.PC_M1_F_CAMPAIGN_CREATE, "CREATE");
		campaignPrivileges.add(FPCONSTANTS.PC_M1_F_CAMPAIGN_DELETE, "DELETE");
		campaignPrivileges.add(FPCONSTANTS.PC_M1_F_CAMPAIGN_VIEW, "VIEW");
		campaignPrivileges.add(FPCONSTANTS.PC_M1_F_CAMPAIGN_EXPORT, "EXPORT");
		featurePrivilegesMap.add("CAMPAIGN_PRIVILEGES", campaignPrivileges);
		
		
		tertiaryManageCampaignPrivileges=new Ext.util.HashMap();
		tertiaryManageCampaignPrivileges.add(FPCONSTANTS.PC_M1_F_VIEWTERTIARYCAMPAIGN_VIEW,"VIEW");
		tertiaryManageCampaignPrivileges.add(FPCONSTANTS.PC_M1_F_VIEWTERTIARYCAMPAIGN_EDIT,"EDIT");
		tertiaryManageCampaignPrivileges.add(FPCONSTANTS.PC_M1_F_VIEWTERTIARYCAMPAIGN_CREATE,"CREATE");
		tertiaryManageCampaignPrivileges.add(FPCONSTANTS.PC_M1_F_VIEWTERTIARYCAMPAIGN_EXPORT,"EXPORT");
		tertiaryManageCampaignPrivileges.add(FPCONSTANTS.PC_M1_F_VIEWTERTIARYCAMPAIGN_DELETE,"DELETE");
		tertiaryManageCampaignPrivileges.add(FPCONSTANTS.PC_M1_F_VIEWTERTIARYCAMPAIGN_CAPTURE_LEAD,"CAPTURE_LEAD");
		tertiaryManageCampaignPrivileges.add(FPCONSTANTS.PC_M1_F_TERTIARYCAMPAIGN_GRID_CONFIG,"GRID_CONFIGURATION");
		
		
		featurePrivilegesMap.add("TERTIARY_MANAGE_CAMPAIGN_PRIVILEGES", tertiaryManageCampaignPrivileges);
		
		
		captureLeadManageCampaignPrivileges=new Ext.util.HashMap();
		captureLeadManageCampaignPrivileges.add(FPCONSTANTS.PC_M1_F_BUZZ_CAPUTRE_LEAD_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CAPTURELEAD_MANAGE_CAMPAIGN_PRIVILEGES", captureLeadManageCampaignPrivileges);
		
		
		trackEnquiryPrivileges=new Ext.util.HashMap();
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_VIEW,"VIEW");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_CREATE, "CREATE");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_DELETE, "DELETE");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_UPDATE, "UPDATE");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_EXPORT, "EXPORT");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_MOREACTIONS, "MOREACTIONS");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_VIEWDOCUMENTS, "VIEWDOCUMENTS");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_SENDMESSAGE, "SENDMESSAGE");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_CHECKDUPLICATENAME,"CHECKDUPLICATENAME");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_CHECKDUPLICATEEMAIL,"CHECKDUPLICATEEMAIL");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_CHECKDUPLICATEMOBILE,"CHECKDUPLICATEMOBILE");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_CHECKDUPLICATEPHONE,"CHECKDUPLICATEPHONE");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_VIEW_ALL_ENQUIRIES, "VIEW_ALL_ENQUIRIES");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_VIEW_MY_ENQUIRIES, "VIEW_MY_ENQUIRIES");
		trackEnquiryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_SENDSURVEY,"SENDSURVEY");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_EXPORT_REPORT,"EXPORTREPORTS");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_FOLLOWUP_DETAIL,"FOLLOWUPDETAILS");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_SENDREMINDER,"SENDREMINDER");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_MAKE_ACTIVE,"MAKE_ACTIVE");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_REASSIGNENQUIRY,"REASSIGNENQUIRY");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_ADMISSION_GRID_CONFIG,"GRID_CONFIGURATION");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_ADM_CLOSE_DUPLICATE_ENQ,"ADM_CLOSE_DUPLICATE_ENQ");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_POPIA_OPTION, "POPIA_OPTION");
		trackEnquiryPrivileges.add(FPCONSTANTS.PC_M2_F_STRACKENQUIRY_CHANGE_LINKED_APPLICATION, "CHANGE_LINKED_APPLICATION");
		featurePrivilegesMap.add("TRACKENQUIRY_PRIVILEGES", trackEnquiryPrivileges);
		
		followupscheduledPrivileges=new Ext.util.HashMap();
		followupscheduledPrivileges.add(FPCONSTANTS.PC_M2_F_FOLLOWUPSCHEDULED_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FOLLOWUPSCHEDULED_PRIVILEGES", followupscheduledPrivileges);
		
		duplicatedetailsPrivileges=new Ext.util.HashMap();
		duplicatedetailsPrivileges.add(FPCONSTANTS.PC_M2_F_DUPLICATEDETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("DUPLICATEDETAILS_PRIVILEGES", duplicatedetailsPrivileges);
		
		enquiryPrivileges=new Ext.util.HashMap();
		enquiryPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRYASSGNHRS_VIEW,"VIEW");
		enquiryPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRYASSGNHRS_UPDATE, "UPDATE");
		enquiryPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRYASSGNHRS_CREATE, "CREATE");
		enquiryPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRYASSGNHRS_DELETE, "DELETE");
		featurePrivilegesMap.add("ENQUIRY_PRIVILEGES", enquiryPrivileges);
		
		enquiryExamDetailPrivileges=new Ext.util.HashMap();
		enquiryExamDetailPrivileges.add(FPCONSTANTS.PC_M2_F_EXAMDETAIL_VIEW,"VIEW");
		enquiryExamDetailPrivileges.add(FPCONSTANTS.PC_M2_F_EXAMDETAIL_CREATE,"CREATE");
		enquiryExamDetailPrivileges.add(FPCONSTANTS.PC_M2_F_EXAMDETAIL_UPDATE,"UPDATE");
		enquiryExamDetailPrivileges.add(FPCONSTANTS.PC_M2_F_EXAMDETAIL_DELETE,"DELETE");
		enquiryExamDetailPrivileges.add(FPCONSTANTS.PC_M2_F_EXAMDETAIL_EXPORT,"EXPORT");
		featurePrivilegesMap.add("ENQUIRY_EXAM_DETAIL_PRIVILEGES", enquiryExamDetailPrivileges);
		
		enquiryAdmissionDetailPrivileges=new Ext.util.HashMap();
		enquiryAdmissionDetailPrivileges.add(FPCONSTANTS.PC_M2_F_ADMISSION_REQUIRMENT_DETAILS_VIEW,"VIEW");
		enquiryAdmissionDetailPrivileges.add(FPCONSTANTS.PC_M2_F_ADMISSION_REQUIRMENT_DETAILS_CREATE,"CREATE");
		enquiryAdmissionDetailPrivileges.add(FPCONSTANTS.PC_M2_F_ADMISSION_REQUIRMENT_DETAILS_UPDATE,"UPDATE");
		enquiryAdmissionDetailPrivileges.add(FPCONSTANTS.PC_M2_F_ADMISSION_REQUIRMENT_DETAILS_DELETE,"DELETE");
		enquiryAdmissionDetailPrivileges.add(FPCONSTANTS.PC_M2_F_ADMISSION_REQUIRMENT_DETAILS_EXPORT,"EXPORT");
		enquiryAdmissionDetailPrivileges.add(FPCONSTANTS.PC_M2_F_ADMISSION_REQUIRMENT_DETAILS_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("ENQUIRY_ADMISSION_DETAIL_PRIVILEGES", enquiryAdmissionDetailPrivileges);
		
		studentDetailPrivileges=new Ext.util.HashMap();
		studentDetailPrivileges.add(FPCONSTANTS.PC_M2_F_RAISEENQUIRY_VIEW,"VIEW");
		studentDetailPrivileges.add(FPCONSTANTS.PC_M2_F_RAISEENQUIRY_UPDATE, "UPDATE");
		studentDetailPrivileges.add(FPCONSTANTS.PC_M2_F_RAISEENQUIRY_CREATE, "CREATE");
		featurePrivilegesMap.add("STUDENT_DETAIL_PRIVILEGES", studentDetailPrivileges);
		
		programsPrivileges = new Ext.util.HashMap();
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_VIEW, "VIEW");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_CREATE, "CREATE");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_UPDATE, "UPDATE");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_DELETE, "DELETE");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_EXPORT, "EXPORT");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_BULK_PROGRAM, "BULK_PROGRAM");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_BULK_PARAMETERIZATION, "BULK_PARAMETERIZATION");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_BULK_FACULTY_MAPPING, "BULK_FACULTY_MAPPING");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_PROGRAM_TERM_MAPPING, "PROGRAM_TERM_MAPPING");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_BULK_TRANSFER, "BULK_TRANSFER");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_GRID_CONFIG,"GRID_CONFIGURATION");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_CATALOGUE_CONTENT,"CATALOGUE_CONTENT");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_PROGRAM_OTHER_DETAILS,"PROGRAM_OTHER_DETAILS");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_APPROVE,"APPROVE");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_REJECT,"REJECT");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_MOREACTION,"MOREACTION");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_PROGRAM_INITIATIVE,"PROGRAM_INITIATIVE");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_PROGRAM_ROLE,"PROGRAM_ROLES");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_CURRICULUM_ACCREDITATION,"CURRICULUM_ACCREDITATION");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_PROGRAM_SUBJECT,"PROGRAM_SUBJECTS");
		programsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMMASTER_DOWNLOAD_HESA_DATA,"DOWNLOAD_HESA_DATA");
		featurePrivilegesMap.add("PROGRAM_PRIVILEGES", programsPrivileges);
		
		catalogueContentPrivileges = new Ext.util.HashMap();
		catalogueContentPrivileges.add(FPCONSTANTS.PC_M4_F_CATALOGUE_CONTENT_VIEW, "VIEW");
		catalogueContentPrivileges.add(FPCONSTANTS.PC_M4_F_CATALOGUE_CONTENT_CREATE, "CREATE");
		catalogueContentPrivileges.add(FPCONSTANTS.PC_M4_F_CATALOGUE_CONTENT_UPDATE, "UPDATE");
		catalogueContentPrivileges.add(FPCONSTANTS.PC_M4_F_CATALOGUE_CONTENT_DELETE, "DELETE");
		catalogueContentPrivileges.add(FPCONSTANTS.PC_M4_F_CATALOGUE_CONTENT_EXPORT, "EXPORT");
		
		featurePrivilegesMap.add("CATALOGUE_CONTENT_PRIVILEGES", catalogueContentPrivileges);
	   
		programsAdvanceSearchPrivileges = new Ext.util.HashMap();
		programsAdvanceSearchPrivileges.add(FPCONSTANTS.PC_M4_R_PROGRAMADVANCEREPORT_VIEW, "VIEW");
		featurePrivilegesMap.add("PROGRAM_ADVANCE_SEARCH_PRIVILEGES", programsAdvanceSearchPrivileges);
		
		batchPrivileges = new Ext.util.HashMap();
		batchPrivileges.add(FPCONSTANTS.PC_M4_F_BATCH_VIEW, "VIEW");
		batchPrivileges.add(FPCONSTANTS.PC_M4_F_BATCH_CREATE, "CREATE");
		batchPrivileges.add(FPCONSTANTS.PC_M4_F_BATCH_UPDATE, "UPDATE");
		batchPrivileges.add(FPCONSTANTS.PC_M4_F_BATCH_DELETE, "DELETE");
		batchPrivileges.add(FPCONSTANTS.PC_M4_F_BATCH_EXPORT, "EXPORT");
		batchPrivileges.add(FPCONSTANTS.PC_M4_F_BATCH_COPY_BATCH, "COPY_BATCH");
		batchPrivileges.add(FPCONSTANTS.PC_M4_F_BATCH_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("BATCH_PRIVILEGES", batchPrivileges);
		
		homeworkAssignmentPrivileges = new Ext.util.HashMap();
		homeworkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_VIEW, "VIEW");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_CREATE, "CREATE");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_UPDATE, "UPDATE");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_DELETE, "DELETE");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_EXPORT, "EXPORT");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_UPLOAD_DOCUMENT,"UPLOAD_DOCUMENT");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_DOWNLOAD_ALL,"DOWNLOAD_ALL");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_BULK_DOCUMENT_DOWNLOAD,"BULK_DOCUMENT_DOWNLOAD");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_EXPORT_REPORT,"EXPORT_REPORT");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_SUBMISSION_DETAILS,"SUBMISSION_DETAILS");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_ASSESSMENT_DETAILS,"ASSESSMENT_DETAILS");
		
		homeworkAssignmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_HOMEWORK_ASSIGNMENTS_VIEW, "VIEW");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_HOMEWORK_ASSIGNMENTS_CREATE, "CREATE");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_HOMEWORK_ASSIGNMENTS_UPDATE, "UPDATE");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_HOMEWORK_ASSIGNMENTS_DELETE, "DELETE");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_HOMEWORK_ASSIGNMENTS_EXPORT, "EXPORT");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_HOMEWORK_ASSIGNMENTS_EXPORT_REPORT,"EXPORT_REPORT");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_HOMEWORK_ASSIGNMENTS_UPLOAD_DOCUMENT, "UPLOAD_DOCUMENT");
		featurePrivilegesMap.add("HOMEWORK_ASSIGNMENT_PRIVILEGES", homeworkAssignmentPrivileges);
		
		studentPortalHomeworkAssignmentPrivileges = new Ext.util.HashMap();
		studentPortalHomeworkAssignmentPrivileges.add(FPCONSTANTS.SP_M4_F_HOMEWORKASSIGNMENTS_VIEW, "VIEW");
		studentPortalHomeworkAssignmentPrivileges.add(FPCONSTANTS.SP_M4_F_HOMEWORKASSIGNMENTS_UPLOAD_DOCUMENT, "UPLOAD_DOCUMENT");
		studentPortalHomeworkAssignmentPrivileges.add(FPCONSTANTS.SP_M4_F_HOMEWORKASSIGNMENTS_EXPORT, "EXPORT");
		studentPortalHomeworkAssignmentPrivileges.add(FPCONSTANTS.SP_M4_F_HOMEWORKASSIGNMENTS_DOWNLOAD_ALL, "DOWNLOAD_ALL");
		studentPortalHomeworkAssignmentPrivileges.add(FPCONSTANTS.SP_M4_F_HOMEWORKASSIGNMENTS_SUBMISSION_DETAILS, "SUBMISSION_DETAILS");
		studentPortalHomeworkAssignmentPrivileges.add(FPCONSTANTS.SP_M4_F_HOMEWORKASSIGNMENTS_ASSESSMENT_DETAILS, "ASSESSMENT_DETAILS");
		studentPortalHomeworkAssignmentPrivileges.add(FPCONSTANTS.SP_M4_F_HOMEWORKASSIGNMENTS_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_HOMEWORK_ASSIGNMENT_PRIVILEGES", studentPortalHomeworkAssignmentPrivileges);
		/*homeworkAssignmentPrivileges.add(FPCONSTANTS.SP_M4_F_HOMEWORKASSIGNMENTS_CREATE, "CREATE");
		homeworkAssignmentPrivileges.add(FPCONSTANTS.SP_M4_F_HOMEWORKASSIGNMENTS_UPDATE, "UPDATE");*/
		
		
		
		programCourseGroupsPrivileges = new Ext.util.HashMap();
		programCourseGroupsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEGROUP_CREATE, "CREATE");
		programCourseGroupsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEGROUP_DELETE, "DELETE");
		programCourseGroupsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEGROUP_EXPORT, "EXPORT");
		programCourseGroupsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEGROUP_LINK, "LINK");
		programCourseGroupsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEGROUP_SAVE, "SAVE");
		programCourseGroupsPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEGROUP_DATA_GRID, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("PROGRAM_COURSE_GROUPS_PRIVILEGES", programCourseGroupsPrivileges);
		
		
		courseReportPrivileges = new Ext.util.HashMap();
		courseReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSEREPORT_VIEW, "VIEW");
		courseReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSEREPORT_EXPORT, "EXPORT");
		courseReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSEREPORT_COURSE_GROUP_ASSOCIATED, "COURSE_GROUP_ASSOCIATED");
		courseReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSEREPORT_COURSE_COMPONENT_ASSOCIATED, "COURSE_COMPONENT_ASSOCIATED");
		courseReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSEREPORT_READING_MATERIAL_ASSOCIATED, "READING_MATERIAL_ASSOCIATED");
		courseReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSEREPORT_COURSE_VARIANTS_ASSOCIATED, "COURSE_VARIANTS_ASSOCIATED");
		courseReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSEREPORT_COURSE_TOPICS_CREATED, "COURSE_TOPICS_CREATED");
		courseReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSEREPORT_COURSE_ASSESSMENT, "COURSE_ASSESSMENT");
		courseReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSEREPORT_DATA_GRID, "GRID_CONFIGURATION");
		courseReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSEREPORT_COURSE_GROUP_REPORT, "COURSE_GROUP_REPORT");
		featurePrivilegesMap.add("COURSE_REPORT_PRIVILEGES", courseReportPrivileges);
		
		courseGroupAssociatedReportPrivileges = new Ext.util.HashMap();
		courseGroupAssociatedReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSE_GROUP_ASSOCIATED_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("COURSE_GROUP_ASSOCIATED_REPORT_PRIVILEGES", courseGroupAssociatedReportPrivileges);
		
		courseComponentAssociatedReportPrivileges = new Ext.util.HashMap();
		courseComponentAssociatedReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSE_COMPONENT_ASSOCIATED_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("COURSE_COMPONENT_ASSOCIATED_REPORT_PRIVILEGES", courseComponentAssociatedReportPrivileges);
		
		readingMaterialAssociatedReportPrivileges = new Ext.util.HashMap();
		readingMaterialAssociatedReportPrivileges.add(FPCONSTANTS.PC_M4_R_READING_MATERIAL_ASSOCIATED_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("READING_MATERIAL_ASSOCIATED_REPORT_PRIVILEGES", readingMaterialAssociatedReportPrivileges);
		
		courseVarientsAssociatedReportPrivileges = new Ext.util.HashMap();
		courseVarientsAssociatedReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSE_VARIENTS_ASSOCIATED_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("COURSE_VARIENTS_ASSOCIATED_REPORT_PRIVILEGES", courseVarientsAssociatedReportPrivileges);
		
		topicsCreatedReportPrivileges = new Ext.util.HashMap();
		topicsCreatedReportPrivileges.add(FPCONSTANTS.PC_M4_R_TOPICS_CREATED_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("TOPICS_CREATED_REPORT_PRIVILEGES", topicsCreatedReportPrivileges);
		
		courseAssessmentReportPrivileges = new Ext.util.HashMap();
		courseAssessmentReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSE_ASSESSMENT_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("COURSE_ASSESSMENT_REPORT_PRIVILEGES", courseAssessmentReportPrivileges);
		
		courseCreditGradeReportPrivileges = new Ext.util.HashMap();
		courseCreditGradeReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSEREPORT_COURSE_CREDIT_GRADE_REPORT, "COURSE_CREDIT_GRADE_REPORT");
		courseCreditGradeReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSEREPORT_COURSE_CREDIT_GRADE_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("COURSE_CREDIT_GRADE_REPORT_PRIVILEGES", courseCreditGradeReportPrivileges);
		
		
		/******************************** Attendance Report ****************************/
		attendanceNewReportPrivileges = new Ext.util.HashMap();
		attendanceNewReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_REPORT_VIEW, "VIEW");
		attendanceNewReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("ATTENDANCEREPORT_PRIVILEGES", attendanceNewReportPrivileges);
		
		/*****************Attendance Summary Report**************************/
		attendanceSummaryReportPrivileges = new Ext.util.HashMap();
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_VIEW, "VIEW");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_SENDSURVEY, "SENDSURVEY");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_EXPORT, "EXPORT");
		/*attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_EXPORT_REPORT, "EXPORT_REPORT");*/
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_SENDMESSAGE, "SENDMESSAGE");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_PROGRAM_WISE, "PROGRAM_WISE");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_COURSE_WISE, "COURSE_WISE");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_SESSION_WISE, "SESSION_WISE");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_ADHOC_MESSAGE, "ADHOC_MESSAGE");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_MESSAGE_TEMPLATE, "MESSAGE_TEMPLATE");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_ATTENDANCE_REGISTER_BLANK, "ATTENDANCE_REGISTER_BLANK");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_ATTENDANCE_REGISTER, "ATTENDANCE_REGISTER");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_PROGRAM_AND_COURSE_WISE_REPORT, "PROGRAM_AND_COURSE_WISE_REPORT");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_COURSEWISE_ATTENDANCE_REPORT, "COURSEWISE_ATTENDANCE_REPORT");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_PRINT_CERTIFICATE, "PRINT_CERTIFICATE");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_PROGRAM_BATCH_SECTION, "PROGRAM_BATCH_SECTION");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_SECTION_GROUP, "SECTION_GROUP");
		attendanceSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_SUMMARY_REPORT_GRID_CONFIG, "GRID_CONFIGURATION");

		featurePrivilegesMap.add("ATTENDANCE_SUMMARY_REPORT_PRIVILEGES", attendanceSummaryReportPrivileges);
		/*************************************************************
		 * /*****************Attendance Report**************************/
		courseTrackerPrivileges = new Ext.util.HashMap();
		courseTrackerPrivileges.add(FPCONSTANTS.PC_M4_COURSETRACKER_EXPORT,"EXPORT");
		featurePrivilegesMap.add("COURSE_TRACKER_PRIVILEGES", courseTrackerPrivileges);
		/************************************************************
		 */
		
		followupDetailPrivileges = new Ext.util.HashMap();
		followupDetailPrivileges.add(FPCONSTANTS.PC_M2_F_FOLLOWUPDETAIL_UPDATE, "UPDATE");
		followupDetailPrivileges.add(FPCONSTANTS.PC_M2_F_FOLLOWUPDETAIL_EXPORT, "EXPORT");
		followupDetailPrivileges.add(FPCONSTANTS.PC_M2_F_FOLLOWUPDETAIL_GRID_CONFIG, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("FOLLOWUP_DETAIL_PRIVILEGES", followupDetailPrivileges);
		
		closureDetailPrivileges = new Ext.util.HashMap();
		closureDetailPrivileges.add(FPCONSTANTS.PC_M2_F_CLOSUREDETAIL_UPDATE, "UPDATE");
		closureDetailPrivileges.add(FPCONSTANTS.PC_M2_F_CLOSUREDETAIL_EXPORT, "EXPORT");
		featurePrivilegesMap.add("CLOSURE_DETAIL_PRIVILEGES", closureDetailPrivileges);
		
		
		summaryReportPrivileges = new Ext.util.HashMap();
		summaryReportPrivileges.add(FPCONSTANTS.PC_M2_F_SUMMARYREPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("SUMMARY_REPORT_PRIVILEGES", summaryReportPrivileges);
		
		
		enquiryAssgnHRSPrivileges = new Ext.util.HashMap();
		enquiryAssgnHRSPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRYASSGNHRS_VIEW, "VIEW");
		enquiryAssgnHRSPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRYASSGNHRS_CREATE, "CREATE");
		enquiryAssgnHRSPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRYASSGNHRS_UPDATE, "UPDATE");
		enquiryAssgnHRSPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRYASSGNHRS_DELETE, "DELETE");
		featurePrivilegesMap.add("ENQUIRY_PRIVILEGES", enquiryAssgnHRSPrivileges);
		
		coursePrivileges = new Ext.util.HashMap();
		coursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSEMASTER_VIEW, "VIEW");
		coursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSEMASTER_CREATE, "CREATE");
		coursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSEMASTER_UPDATE, "UPDATE");
		coursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSEMASTER_DELETE, "DELETE");
		coursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSEMASTER_EXPORT, "EXPORT");
		coursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSEMASTER_BULK_COURSES, "BULK_COURSES");
		coursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSE_COMPONENT, "COURSE_COMPONENT");
		//coursePrivileges.add(FPCONSTANTS.PF_M4_F_COURSEMASTER_VIEW, "VIEW");
		
		//coursePrivileges.add(FPCONSTANTS.SP_M4_F_COURSEMASTER_VIEW, "VIEW");
		//coursePrivileges.add(FPCONSTANTS.SP_M4_F_COURSEMASTER_EXPORT, "EXPORT");
		//coursePrivileges.add(FPCONSTANTS.SP_COURSE_EXECUTION,"VIEW");
		//coursePrivileges.add(FPCONSTANTS.SP_M4_F_COURSEMASTER_DOWNLOADMARKSHEETS, "DOWNLOADMARKSHEETS");
		
		//coursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSEMASTER_DOWNLOADMARKSHEETS, "DOWNLOADMARKSHEETS");
		//coursePrivileges.add(FPCONSTANTS.PS_M4_F_COURSEMASTER_VIEW,"VIEW");
		coursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSEMASTER_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("COURSE_PRIVILEGES", coursePrivileges);
		
		/*coursePrivileges.add(FPCONSTANTS.SP_M4_F_COURSEMASTER_VIEW, "VIEW");
		coursePrivileges.add(FPCONSTANTS.SP_M4_F_COURSEMASTER_EXPORT, "EXPORT");
		coursePrivileges.add(FPCONSTANTS.SP_M4_F_COURSEMASTER__DOWNLOADMARKSHEETS, "DOWNLOADMARKSHEETS");
		featurePrivilegesMap.add("STUDENT_COURSE_PRIVILEGES", coursePrivileges);*/
		
		myCoursePrivileges = new Ext.util.HashMap();
		myCoursePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MYCOURSE_VIEW,"VIEW");
		myCoursePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MYCOURSE_EXPORT,"EXPORT");
		myCoursePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MYCOURSE_DOWNLOADMARKSHEETS,"DOWNLOADMARKSHEETS");
		myCoursePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MYCOURSE_DOWNLOADUNOFFICIALTRANSCRIPT,"DOWNLOADUNOFFICIALTRANSCRIPT");
		myCoursePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MYCOURSE_COURSEWISERADIOBUTTON,"COURSEWISERADIOBUTTON");
		myCoursePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MYCOURSE_PERIODWISERADIOBUTTON,"PERIODWISERADIOBUTTON");
		myCoursePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MYCOURSE_REQUESTEXAMCANCELLATIONBUTTON,"REQUESTEXAMCANCELLATIONBUTTON");
		myCoursePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MYCOURSE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		myCoursePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MYCOURSE_SAVE,"SAVE");
		featurePrivilegesMap.add("MYCOURSE_PRIVILEGES", myCoursePrivileges);
		
		fpcommunicationhistoryPrivileges = new Ext.util.HashMap();
		fpcommunicationhistoryPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_COMMUNICATION_HISTORY_VIEW,"VIEW");
		featurePrivilegesMap.add("FP_STUDENT_COMMUNICATION_HISTORY_VIEW_PRIVILEGES", fpcommunicationhistoryPrivileges);
		
		
		seatTypePrivileges = new Ext.util.HashMap();
		seatTypePrivileges.add(FPCONSTANTS.PC_M4_F_BATCHDETAILS_VIEW, "VIEW");
		seatTypePrivileges.add(FPCONSTANTS.PC_M4_F_BATCHDETAILS_CREATE, "CREATE");
		seatTypePrivileges.add(FPCONSTANTS.PC_M4_F_BATCHDETAILS_UPDATE, "UPDATE");
		seatTypePrivileges.add(FPCONSTANTS.PC_M4_F_BATCHDETAILS_EXPORT, "EXPORT");
		seatTypePrivileges.add(FPCONSTANTS.PC_M4_F_BATCHDETAILS_LINK, "LINK");
		seatTypePrivileges.add(FPCONSTANTS.PC_M4_F_BATCHDETAILS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		//seatTypePrivileges.add(FPCONSTANTS.PC_M4_F_COURSEMASTER_UPDATE, "UPDATE");
		//seatTypePrivileges.add(FPCONSTANTS.PC_M4_F_BATCH_DELETE, "DELETE");
		//seatTypePrivileges.add(FPCONSTANTS.PC_M4_F_BATCH_DELETE, "EXPORT");
		featurePrivilegesMap.add("SEATTYPE_PRIVILEGES", seatTypePrivileges);
		
		periodPrivileges = new Ext.util.HashMap();
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_VIEW, "VIEW");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_CREATE, "CREATE");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_UPDATE, "UPDATE");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_DELETE, "DELETE");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_EXPORT, "EXPORT");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_LINK, "LINK");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_DEFINE_PROGRAM_TERM, "DEFINE_PROGRAM_TERM");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_SET_AS_CURRENT_PERIOD, "SET_AS_CURRENT_PERIOD");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_GRID_CONFIG, "GRID_CONFIGURATION");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_PERIOD_ACTIVITY_DATES, "PERIOD_ACTIVITY_DATES");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_SERVICE_REQUEST_SETUP_DATES, "SERVICE_REQUEST_SETUP_DATES");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_COURSE_AND_CREDIT_RADIO_BUTTON, "COURSE_AND_CREDIT_RADIO_BUTTON");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_PROMOTION_ANY_BUTTON, "ANY_BUTTON");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_PROMOTION_DELETE_BUTTON, "DELETE_BUTTON");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_APPLICABLE_FOR, "APPLICABLE_FOR");
		featurePrivilegesMap.add("PERIOD_PRIVILEGES", periodPrivileges);
		
		periodPrivileges = new Ext.util.HashMap();
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_TERM_VIEW, "VIEW");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_TERM_CREATE, "CREATE");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_TERM_UPDATE, "UPDATE");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_TERM_DELETE, "DELETE");
		periodPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_TERM_EXPORT, "EXPORT");
		featurePrivilegesMap.add("PERIOD_TERM_PRIVILEGES", periodPrivileges);
		

		createSequencePrivileges = new Ext.util.HashMap();
		createSequencePrivileges.add(FPCONSTANTS.PC_M5_F_CreateAndAssignSequence_DELETE, "DELETE");
		createSequencePrivileges.add(FPCONSTANTS.PC_M5_F_CreateAndAssignSequence_CREATE, "CREATE");
		createSequencePrivileges.add(FPCONSTANTS.PC_M5_F_CreateAndAssignSequence_UPDATE, "UPDATE");
		createSequencePrivileges.add(FPCONSTANTS.PC_M5_F_CreateAndAssignSequence_EXPORT, "EXPORT");
		featurePrivilegesMap.add("CREATESEQUENCE_PRIVILEGES", createSequencePrivileges);
		
		periodBreakPrivileges = new Ext.util.HashMap();
		periodBreakPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_BREAK_DELETE, "DELETE");
		periodBreakPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_BREAK_CREATE, "CREATE");
		periodBreakPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_BREAK_UPDATE, "UPDATE");
		periodBreakPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_BREAK_VIEW, "VIEW");
		periodBreakPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_BREAK_EXPORT, "EXPORT");
		periodBreakPrivileges.add(FPCONSTANTS.PC_M4_F_PERIOD_BREAK_LINK, "LINK");
		featurePrivilegesMap.add("PERIODBREAK_PRIVILEGES", periodBreakPrivileges);
		
		programCoursePrivileges = new Ext.util.HashMap();
		programCoursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSE_VIEW, "VIEW");
		programCoursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSE_CREATE, "CREATE");
		programCoursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSE_UPDATE, "UPDATE");
		programCoursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSE_DELETE, "DELETE");
		programCoursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSE_EXPORT, "EXPORT");
		programCoursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSE_LINK, "LINK");
		programCoursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSE_MAP_PERIOD, "MAP_PERIOD");
		programCoursePrivileges.add(FPCONSTANTS.PC_M4_F_COURSE_GRID_CONFIG, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("PROGRAMCOURSE_PRIVILEGES", programCoursePrivileges);
		
		programCourseSpecializationPrivileges = new Ext.util.HashMap();
		programCourseSpecializationPrivileges.add(FPCONSTANTS.PC_M4_F_BATCHCOURSESPECIALIZATION_VIEW, "VIEW");
		programCourseSpecializationPrivileges.add(FPCONSTANTS.PC_M4_F_BATCHCOURSESPECIALIZATION_CREATE, "CREATE");
		programCourseSpecializationPrivileges.add(FPCONSTANTS.PC_M4_F_BATCHCOURSESPECIALIZATION_UPDATE, "UPDATE");
		programCourseSpecializationPrivileges.add(FPCONSTANTS.PC_M4_F_BATCHCOURSESPECIALIZATION_DELETE, "DELETE");
		programCourseSpecializationPrivileges.add(FPCONSTANTS.PC_M4_F_BATCHCOURSESPECIALIZATION_EXPORT, "EXPORT");
		programCourseSpecializationPrivileges.add(FPCONSTANTS.PC_M4_F_BATCHCOURSESPECIALIZATION_LINK, "LINK");
		featurePrivilegesMap.add("PROGRAMCOURSESPECIALIZATION_PRIVILEGES", programCourseSpecializationPrivileges);
		
		assignExamCenterPrivileges = new Ext.util.HashMap();
		assignExamCenterPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNEXAMCENTER_VIEW, "VIEW");
		assignExamCenterPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNEXAMCENTER_CREATE, "CREATE");
		assignExamCenterPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNEXAMCENTER_UPDATE, "UPDATE");
		assignExamCenterPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNEXAMCENTER_DELETE, "DELETE");
		assignExamCenterPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNEXAMCENTER_EXPORT, "EXPORT");
		assignExamCenterPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNEXAMCENTER_LINK, "LINK");
		featurePrivilegesMap.add("ASSIGNEXAMCENTER_PRIVILEGES", assignExamCenterPrivileges);
		
		courseFeeDefinitionCenterPrivileges = new Ext.util.HashMap();
		courseFeeDefinitionCenterPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEFEEDEFINITIONCENTER_LINK, "LINK");
		courseFeeDefinitionCenterPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEFEEDEFINITIONCENTER_CREATE, "CREATE");
		courseFeeDefinitionCenterPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEFEEDEFINITIONCENTER_UPDATE, "UPDATE");
		courseFeeDefinitionCenterPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEFEEDEFINITIONCENTER_ENABLE, "ENABLE");
		courseFeeDefinitionCenterPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEFEEDEFINITIONCENTER_SEAT_TYPE_MAPPING, "SEAT_TYPE_MAPPING");
		featurePrivilegesMap.add("COURSEFEEDEFINITIONCENTER_PRIVILEGES", courseFeeDefinitionCenterPrivileges);
		
		relatedCoursePrivileges = new Ext.util.HashMap();
		relatedCoursePrivileges.add(FPCONSTANTS.PC_M4_F_RELATEDCOURSE_VIEW, "VIEW");
		relatedCoursePrivileges.add(FPCONSTANTS.PC_M4_F_RELATEDCOURSE_CREATE, "CREATE");
		relatedCoursePrivileges.add(FPCONSTANTS.PC_M4_F_RELATEDCOURSE_UPDATE, "UPDATE");
		relatedCoursePrivileges.add(FPCONSTANTS.PC_M4_F_RELATEDCOURSE_DELETE, "DELETE");
		relatedCoursePrivileges.add(FPCONSTANTS.PC_M4_F_RELATEDCOURSE_LINK, "LINK");
		featurePrivilegesMap.add("RELATEDCOURSE_PRIVILEGES", relatedCoursePrivileges);
		
		courseVariantsPrivileges = new Ext.util.HashMap();
		courseVariantsPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEVARIANTS_VIEW, "VIEW");
		//courseVariantsPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEVARIANTS_CREATE, "CREATE");
		courseVariantsPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEVARIANTS_UPDATE, "UPDATE");
		courseVariantsPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEVARIANTS_DELETE, "DELETE");
		featurePrivilegesMap.add("COURSEVARIANTS_PRIVILEGES", courseVariantsPrivileges);
		
		
		linkAcademyLocationPrivileges = new Ext.util.HashMap();
		linkAcademyLocationPrivileges.add(FPCONSTANTS.PC_M4_F_LINKACADEMYLOCATION_CREATE, "CREATE");
		featurePrivilegesMap.add("LINKACADEMYLOCATION_PRIVILEGES", linkAcademyLocationPrivileges);
		
		courseComponentPrivileges = new Ext.util.HashMap();
		courseComponentPrivileges.add(FPCONSTANTS.PC_M4_F_COURSECOMPONENTS_VIEW, "VIEW");
		courseComponentPrivileges.add(FPCONSTANTS.PC_M4_F_COURSECOMPONENTS_CREATE, "CREATE");
		courseComponentPrivileges.add(FPCONSTANTS.PC_M4_F_COURSECOMPONENTS_UPDATE, "UPDATE");
		courseComponentPrivileges.add(FPCONSTANTS.PC_M4_F_COURSECOMPONENTS_DELETE, "DELETE");
		featurePrivilegesMap.add("COURSECOMPONENT_PRIVILEGES", courseComponentPrivileges);
		
		courseGroupPrivileges = new Ext.util.HashMap();
		courseGroupPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEGROUP_VIEW, "VIEW");
		courseGroupPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEGROUP_CREATE, "CREATE");
		courseGroupPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEGROUP_UPDATE, "UPDATE");
	    courseGroupPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEGROUP_DELETE, "DELETE");
	    courseGroupPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEGROUP_EXPORT, "EXPORT");
	    courseGroupPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEGROUP_DETAIL_BLOCK_GROUP, "BLOCK_GROUP");
	    featurePrivilegesMap.add("COURSEGROUP_PRIVILEGES", courseGroupPrivileges);
		
		courseTopicPrivileges = new Ext.util.HashMap();
		courseTopicPrivileges.add(FPCONSTANTS.PC_M4_F_COURSETOPIC_VIEW, "VIEW");
		courseTopicPrivileges.add(FPCONSTANTS.PC_M4_F_COURSETOPIC_CREATE, "CREATE");
		courseTopicPrivileges.add(FPCONSTANTS.PC_M4_F_COURSETOPIC_UPDATE, "UPDATE");
		courseTopicPrivileges.add(FPCONSTANTS.PC_M4_F_COURSETOPIC_DELETE, "DELETE");
		courseTopicPrivileges.add(FPCONSTANTS.PC_M4_F_COURSETOPIC_UPLOADFILE, "UPLOADFILE");
		courseTopicPrivileges.add(FPCONSTANTS.PC_M4_F_COURSETOPIC_EXPORT, "EXPORT");
		featurePrivilegesMap.add("COURSETOPIC_PRIVILEGES", courseTopicPrivileges);
		
		courseTopicDocPrivileges = new Ext.util.HashMap();
		courseTopicDocPrivileges.add(FPCONSTANTS.PC_M4_F_COURSETOPICDOC_DELETE, "DELETE");
		courseTopicDocPrivileges.add(FPCONSTANTS.PC_M4_F_COURSETOPICDOC_DOWNLOAD, "DOWNLOAD");
		featurePrivilegesMap.add("COURSETOPICDOC_PRIVILEGES", courseTopicDocPrivileges);
		
		courseSpecializationPrivileges = new Ext.util.HashMap();
		courseSpecializationPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESPECIALIZATION_VIEW, "VIEW");
		courseSpecializationPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESPECIALIZATION_CREATE, "CREATE");
		courseSpecializationPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESPECIALIZATION_UPDATE, "UPDATE");
		courseSpecializationPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESPECIALIZATION_DELETE, "DELETE");
		courseSpecializationPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESPECIALIZATION_EXPORT, "EXPORT");
		courseSpecializationPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESPECIALIZATION_AUTO_APPROVE_SPECIALIZATION, "AUTO_APPROVE_SPECIALIZATION");
		featurePrivilegesMap.add("COURSESPECIALIZATION_PRIVILEGES", courseSpecializationPrivileges);
		
		courseEquivalencePrivileges = new Ext.util.HashMap();
		courseEquivalencePrivileges.add(FPCONSTANTS.PC_M4_F_COURSEEQUIVALENCE_VIEW, "VIEW");
		courseEquivalencePrivileges.add(FPCONSTANTS.PC_M4_F_COURSEEQUIVALENCE_CREATE, "CREATE");
		courseEquivalencePrivileges.add(FPCONSTANTS.PC_M4_F_COURSEEQUIVALENCE_UPDATE, "UPDATE");
		courseEquivalencePrivileges.add(FPCONSTANTS.PC_M4_F_COURSEEQUIVALENCE_DELETE, "DELETE");
		featurePrivilegesMap.add("COURSEEQUIVALENCE_PRIVILEGES", courseEquivalencePrivileges);
		
		homeWorkAssignmentPrivileges = new Ext.util.HashMap();
		homeWorkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_VIEW, "VIEW");
		homeWorkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_CREATE, "CREATE");
		homeWorkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_UPDATE, "UPDATE");
		homeWorkAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_DELETE, "DELETE");
		featurePrivilegesMap.add("HOMEWORKASSIGNMENT_PRIVILEGES", homeWorkAssignmentPrivileges);
		
		
		examinationCenterPrivileges = new Ext.util.HashMap();
		examinationCenterPrivileges.add(FPCONSTANTS.PC_M5_F_ExaminationCenter_VIEW, "VIEW");
		examinationCenterPrivileges.add(FPCONSTANTS.PC_M5_F_ExaminationCenter_CREATE, "CREATE");
		examinationCenterPrivileges.add(FPCONSTANTS.PC_M5_F_ExaminationCenter_UPDATE, "UPDATE");
		examinationCenterPrivileges.add(FPCONSTANTS.PC_M5_F_ExaminationCenter_DELETE, "DELETE");
		examinationCenterPrivileges.add(FPCONSTANTS.PC_M5_F_ExaminationCenter_EXPORT, "EXPORT");
		examinationCenterPrivileges.add(FPCONSTANTS.PC_M5_F_ExaminationCenter_MOREACTION, "MOREACTIONS");
		examinationCenterPrivileges.add(FPCONSTANTS.PC_M5_F_ExaminationCenter_ENABLE, "ENABLE");
		examinationCenterPrivileges.add(FPCONSTANTS.PF_M5_F_ExaminationCenter_VIEW, "VIEW");
		examinationCenterPrivileges.add(FPCONSTANTS.SP_M5_F_EXAMINATIONCENTER_VIEW, "VIEW");
		examinationCenterPrivileges.add(FPCONSTANTS.SP_M5_F_EXAMINATIONCENTER_EXPORT, "EXPORT");
		examinationCenterPrivileges.add(FPCONSTANTS.PP_M5_F_EXAMINATIONCENTER_VIEW, "VIEW");
		examinationCenterPrivileges.add(FPCONSTANTS.PP_M5_F_EXAMINATIONCENTER_EXPORT, "EXPORT");
		featurePrivilegesMap.add("EXAMINATIONCENTER_PRIVILEGES", examinationCenterPrivileges);
		
		gradeMasterPrivileges = new Ext.util.HashMap();
		gradeMasterPrivileges.add(FPCONSTANTS.PC_M5_F_GradeMaster_VIEW, "VIEW");
		gradeMasterPrivileges.add(FPCONSTANTS.PC_M5_F_GradeMaster_CREATE, "CREATE");
		gradeMasterPrivileges.add(FPCONSTANTS.PC_M5_F_GradeMaster_UPDATE, "UPDATE");
		gradeMasterPrivileges.add(FPCONSTANTS.PC_M5_F_GradeMaster_DELETE, "DELETE");
		gradeMasterPrivileges.add(FPCONSTANTS.PC_M5_F_GradeMaster_EXPORT, "EXPORT");
		gradeMasterPrivileges.add(FPCONSTANTS.PF_M5_F_GradeMaster_VIEW, "VIEW");
		gradeMasterPrivileges.add(FPCONSTANTS.PF_M5_F_GradeMaster_CREATE, "CREATE");
		gradeMasterPrivileges.add(FPCONSTANTS.PF_M5_F_GradeMaster_UPDATE, "UPDATE");
		gradeMasterPrivileges.add(FPCONSTANTS.PF_M5_F_GradeMaster_DELETE, "DELETE");
		gradeMasterPrivileges.add(FPCONSTANTS.PF_M5_F_GradeMaster_EXPORT, "EXPORT");
		gradeMasterPrivileges.add(FPCONSTANTS.PF_M5_F_GradeMaster_EDITABLE_GRADE, "EDITABLE_GRADE");
		featurePrivilegesMap.add("GRADEMASTER_PRIVILEGES", gradeMasterPrivileges);
		
		calculateResultsPrivileges = new Ext.util.HashMap();
		calculateResultsPrivileges.add(FPCONSTANTS.PC_M5_D_EXAM_CALCULATE_RESULTS_VIEW, "VIEW");
		/*calculateResultsPrivileges.add(FPCONSTANTS.PC_M5_D_EXAM_CALCULATE_RESULTS_CREATE, "CREATE");
		calculateResultsPrivileges.add(FPCONSTANTS.PC_M5_D_EXAM_CALCULATE_RESULTS_UPDATE, "UPDATE");
		calculateResultsPrivileges.add(FPCONSTANTS.PC_M5_D_EXAM_CALCULATE_RESULTS_DELETE, "DELETE");
		calculateResultsPrivileges.add(FPCONSTANTS.PC_M5_D_EXAM_CALCULATE_RESULTS_EXPORT, "EXPORT");*/
		featurePrivilegesMap.add("CALCULATE_RESULTS_PRIVILEGES", calculateResultsPrivileges);
		
		/*feePlanPrivileges = new Ext.util.HashMap();
		feePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_VIEW, "VIEW");
		feePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_CREATE, "CREATE");
		feePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_UPDATE, "UPDATE");
		feePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_DELETE, "DELETE");
		feePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_MOREACTIONS, "MOREACTIONS");
		feePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_APPLICABLEFOR, "APPLICABLEFOR");
		feePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_VIEWUNMAPPED, "VIEWUNMAPPED");
		feePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_VIEWCOVERAGE, "VIEWCOVERAGE");
		feePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_APPROVE, "APPROVE");
		featurePrivilegesMap.add("FEEPLAN_PRIVILEGES", feePlanPrivileges);
		
		feePlanSequencePrivileges = new Ext.util.HashMap();
		feePlanSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_VIEW, "VIEW");
		feePlanSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_CREATE, "CREATE");
		feePlanSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_UPDATE, "UPDATE");
		feePlanSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_DELETE, "DELETE");
		feePlanSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_MOREACTIONS, "MOREACTIONS");
		feePlanSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_PERSONCOVERED, "PERSONCOVERED");
		feePlanSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_CONFIGUREFEEHEAD, "CONFIGUREFEEHEAD");
		featurePrivilegesMap.add("FEEPLANSEQUENCE_PRIVILEGES", feePlanSequencePrivileges);
		*/
		programBatchSectionPrivileges = new Ext.util.HashMap();
		programBatchSectionPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMBATCHSECTION_VIEW, "VIEW");
		programBatchSectionPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMBATCHSECTION_CREATE, "CREATE");
		programBatchSectionPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMBATCHSECTION_UPDATE, "UPDATE");
		programBatchSectionPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMBATCHSECTION_DELETE, "DELETE");
		programBatchSectionPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMBATCHSECTION_EXPORT, "EXPORT");
		programBatchSectionPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMBATCHSECTION_ENROLLMENT_DATE, "CHANGE_ENROLLMENT_DATE");
		programBatchSectionPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMBATCHSECTION_STUDENT_PHOTO_REPORT, "STUDENT_PHOTO_REPORT");
		programBatchSectionPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMBATCHSECTION_STUDENT_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("PROGRAM_BATCHSECTION_PRIVILEGES", programBatchSectionPrivileges);
		
		courseSectionPrivileges = new Ext.util.HashMap();
		courseSectionPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTION_VIEW, "VIEW");
		courseSectionPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTION_CREATE, "CREATE");
		courseSectionPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTION_UPDATE, "UPDATE");
		courseSectionPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTION_DELETE, "DELETE");
		courseSectionPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTION_EXPORT, "EXPORT");
		courseSectionPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTION_ASSIGN_SECTION, "ASSIGN_SECTION");
		courseSectionPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTION_MOREACTIONS, "MOREACTIONS");
		courseSectionPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTION_VIEWPASTRECORD, "VIEWPASTRECORD");
		courseSectionPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTION_BULK_SECTION_TRANSFER, "BULK_SECTION_TRANSFER");
		courseSectionPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTION_BULK_SECTION_CREATION, "BULK_SECTION_CREATION");
		courseSectionPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTION_GRID_CONFIG, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("COURSE_SECTION_PRIVILEGES", courseSectionPrivileges);
		
		manageCourseSectionSummaryViewPrivileges = new Ext.util.HashMap();
		manageCourseSectionSummaryViewPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTIONMANAGEMENTSUMMARYVIEW_ADD_SECTION, "ADD_SECTION");
		manageCourseSectionSummaryViewPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTIONMANAGEMENTSUMMARYVIEW_MAP_PROGRAM_PERIOD, "MAP_PROGRAM_PERIOD");
		manageCourseSectionSummaryViewPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTIONMANAGEMENTSUMMARYVIEW_EXPORT, "EXPORT");
		featurePrivilegesMap.add("MANAGE_COURSE_SECTION_SUMMARY_VIEW_PRIVILEGES", manageCourseSectionSummaryViewPrivileges);
		
		manageCourseSectionDetailedViewPrivileges = new Ext.util.HashMap();
		manageCourseSectionDetailedViewPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTIONMANAGEMENTDETAILEDVIEW_MAP_PROGRAM_PERIOD, "MAP_PROGRAM_PERIOD");
		manageCourseSectionDetailedViewPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTIONMANAGEMENTDETAILEDVIEW_UPDATE, "UPDATE");
		manageCourseSectionDetailedViewPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTIONMANAGEMENTDETAILEDVIEW_DELETE, "DELETE");
		manageCourseSectionDetailedViewPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTIONMANAGEMENTDETAILEDVIEW_EXPORT, "EXPORT");
		manageCourseSectionDetailedViewPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTIONMANAGEMENTDETAILEDVIEW_ADD_FACULTY, "ADD_FACULTY");
		manageCourseSectionDetailedViewPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTIONMANAGEMENTDETAILEDVIEW_GRID_CONFIG,"GRID_CONFIGURATION");
		manageCourseSectionDetailedViewPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTIONMANAGEMENTDETAILEDVIEW_STUDENT_ENROLLMENT,"STUDENT_ENROLLMENT");
		manageCourseSectionDetailedViewPrivileges.add(FPCONSTANTS.PC_M4_F_COURSESECTIONMANAGEMENTDETAILEDVIEW_COURSE_ENROLLMENT,"COURSE_ENROLLMENT");
		featurePrivilegesMap.add("MANAGE_COURSE_SECTION_DETAILED_VIEW_PRIVILEGES", manageCourseSectionDetailedViewPrivileges);
		
		sectionGroupPrivileges = new Ext.util.HashMap();
		sectionGroupPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONGROUP_VIEW, "VIEW");
		sectionGroupPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONGROUP_CREATE, "CREATE");
		sectionGroupPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONGROUP_UPDATE, "UPDATE");
		sectionGroupPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONGROUP_DELETE, "DELETE");
		sectionGroupPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONGROUP_EXPORT, "EXPORT");
		sectionGroupPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONGROUP_MAP_PROGRAM_PERIOD, "MAP_PROGRAM_PERIOD");
		sectionGroupPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONGROUP_MAP_COURSE_VARIANTS, "MAP_COURSE_VARIANTS");
		sectionGroupPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONGROUP_UNMAP_PROGRAM_PERIOD, "UNMAP_PROGRAM_PERIOD");
		sectionGroupPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONGROUP_UNMAP_COURSE_VARIANTS, "UNMAP_COURSE_VARIANTS");
		sectionGroupPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONGROUP_READY_TO_ENROLL, "READY_TO_ENROLL");
		sectionGroupPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONGROUP_PENDING_FOR_ENROLLMENT, "PENDING_FOR_ENROLLMENT");
		sectionGroupPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONGROUP_GRID_CONFIG, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("SECTION_GROUP_PRIVILEGES", sectionGroupPrivileges);
		
/*		facultyTopicAssignmentPrivileges = new Ext.util.HashMap();
		facultyTopicAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_FACULTYTOPICSASSIGNMENTS_CREATE, "CREATE");
		facultyTopicAssignmentPrivileges.add(FPCONSTANTS.PC_M4_F_FACULTYTOPICSASSIGNMENTS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("FACULTY_TOPICASSIGNMENT_PRIVILEGES", facultyTopicAssignmentPrivileges);
		*/
		facultyTopicAssignmentDetailsPrivileges = new Ext.util.HashMap();
		facultyTopicAssignmentDetailsPrivileges.add(FPCONSTANTS.PC_M4_F_FACULTYTOPICSASSIGNMENTSDETAILS_CREATE, "CREATE");
		featurePrivilegesMap.add("FACULTY_TOPICASSIGNMENTDETAILS_PRIVILEGES", facultyTopicAssignmentDetailsPrivileges);
		
		feeDoMappingPrivileges = new Ext.util.HashMap();
		feeDoMappingPrivileges.add(FPCONSTANTS.PC_M6_F_FEEDOMAPPING_VIEW, "VIEW");
		feeDoMappingPrivileges.add(FPCONSTANTS.PC_M6_F_FEEDOMAPPING_CREATE, "CREATE");
		feeDoMappingPrivileges.add(FPCONSTANTS.PC_M6_F_FEEDOMAPPING_UPDATE, "UPDATE");
		feeDoMappingPrivileges.add(FPCONSTANTS.PC_M6_F_FEEDOMAPPING_DELETE, "DELETE");
		featurePrivilegesMap.add("FEE_DOMAPPING_PRIVILEGES", feeDoMappingPrivileges);

		courseReadingPrivileges = new Ext.util.HashMap();
		courseReadingPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEREADING_VIEW, "VIEW");
		courseReadingPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEREADING_CREATE, "CREATE");
		courseReadingPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEREADING_UPDATE, "UPDATE");
		courseReadingPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEREADING_DELETE, "DELETE");
		courseReadingPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEREADING_EXPORT, "EXPORT");
		courseReadingPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEREADING_MOREACTIONS, "MOREACTIONS");
		courseReadingPrivileges.add(FPCONSTANTS.PC_M4_F_COURSEREADING_ASSIGN, "ASSIGN");
		courseReadingPrivileges.add(FPCONSTANTS.PF_M4_F_COURSEREADING_VIEW, "VIEW");
		courseReadingPrivileges.add(FPCONSTANTS.PF_M4_F_COURSEREADING_CREATE, "CREATE");
		courseReadingPrivileges.add(FPCONSTANTS.PF_M4_F_COURSEREADING_UPDATE, "UPDATE");
		courseReadingPrivileges.add(FPCONSTANTS.PF_M4_F_COURSEREADING_DELETE, "DELETE");
		courseReadingPrivileges.add(FPCONSTANTS.SP_M4_F_COURSEREADING_VIEW, "VIEW");
		courseReadingPrivileges.add(FPCONSTANTS.PP_M4_F_COURSEREADING_VIEW, "VIEW");
		courseReadingPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_READING_MATERIALS_VIEW, "VIEW");
		courseReadingPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_READING_MATERIALS_CREATE, "CREATE");
		courseReadingPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_READING_MATERIALS_UPDATE, "UPDATE");
		courseReadingPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_READING_MATERIALS_DELETE, "DELETE");
		courseReadingPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_READING_MATERIALS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("COURSEREADING_PRIVILEGES", courseReadingPrivileges);
		
		homeworkAssignmentDetailPrivileges = new Ext.util.HashMap();
		homeworkAssignmentDetailPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_VIEW, "VIEW");
		homeworkAssignmentDetailPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNMENTSDETAILS_MOREACTIONS, "MOREACTIONS");
		homeworkAssignmentDetailPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNMENTSDETAILS_UPDATE, "UPDATE");
		homeworkAssignmentDetailPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNMENTSDETAILS_DELETE, "DELETE");
		homeworkAssignmentDetailPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNMENTSDETAILS_CREATE, "CREATE");
		homeworkAssignmentDetailPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNMENTSDETAILS_UPLOADFILE, "UPLOADFILE");
		homeworkAssignmentDetailPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNMENTSDETAILS_EXPORT, "EXPORT");
		homeworkAssignmentDetailPrivileges.add(FPCONSTANTS.PF_M4_F_ASSIGNMENTSDETAILS_UPDATE, "UPDATE");
		featurePrivilegesMap.add("HOMEWORK_ASSIGNMENT_DETAIL_PRIVILEGES", homeworkAssignmentDetailPrivileges);
		
		homeworkAssignmentDetailFormPrivileges = new Ext.util.HashMap();
		homeworkAssignmentDetailFormPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNMENTSDETAILSFORM_CONFIGURE_NOTIFICATIONS, "CONFIGURE_NOTIFICATIONS");
		featurePrivilegesMap.add("HOMEWORK_ASSIGNMENT_DETAIL_FORM_PRIVILEGES", homeworkAssignmentDetailFormPrivileges);
		
		studyMaterialDistributionDetailsPrivileges = new Ext.util.HashMap();
		studyMaterialDistributionDetailsPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTIONDETAILS_COPY, "COPY");
		studyMaterialDistributionDetailsPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTIONDETAILS_DELETE, "DELETE");
		studyMaterialDistributionDetailsPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTIONDETAILS_UPDATE, "UPDATE");
		studyMaterialDistributionDetailsPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTIONDETAILS_CREATE, "CREATE");
		studyMaterialDistributionDetailsPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTIONDETAILS_EXPORT, "EXPORT");
		studyMaterialDistributionDetailsPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTIONDETAILS_MOREACTIONS, "MOREACTIONS");
		studyMaterialDistributionDetailsPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTIONDETAILS_VIEW, "VIEW");
		studyMaterialDistributionDetailsPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTIONDETAILS_ASSIGN, "ASSIGN");
		featurePrivilegesMap.add("STUDY_MATERIAL_DISTRIBUTION_PRIVILEGES", studyMaterialDistributionDetailsPrivileges);
		
		homeworkAssignmentSubmissionDetailPrivileges = new Ext.util.HashMap();
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PC_M4_F_HOMEWORKASSIGNMENTS_VIEW, "VIEW");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PC_M4_F_SUBMISSIONDETAILS_UPDATE, "UPDATE");
		//homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNMENTSDETAILS_DELETE, "DELETE");
		//homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PC_M4_F_ASSIGNMENTSDETAILS_CREATE, "CREATE");
		//homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PC_M4_F_SUBMISSIONDETAILS_MOREACTION, "MOREACTIONS");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PC_M4_F_SUBMISSIONDETAILS_UPLOAD_DOCUMENT, "UPLOAD_DOCUMENT");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PC_M4_F_SUBMISSIONDETAILS_EXPORT, "EXPORT");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PC_M4_F_SUBMISSIONDETAILS_RESUBMIT, "RESUBMIT");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PC_M4_F_SUBMISSIONDETAILS_GRID_CONFIGURATION, "GRID_CONFIGURATION");

		/*homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PF_M4_F_SUBMISSIONDETAILS_UPDATE, "UPDATE");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PS_M4_F_HOMEWORKASSIGNMENTS_VIEW, "VIEW");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PS_M4_F_SUBMISSIONDETAILS_UPDATE, "UPDATE");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PS_M4_F_SUBMISSIONDETAILS_CREATE, "CREATE");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PS_M4_F_SUBMISSIONDETAILS_MOREACTIONS, "MOREACTIONS");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PS_M4_F_SUBMISSIONDETAILS_UPLOADFILE, "UPLOADFILE");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.PS_M4_F_SUBMISSIONDETAILS_UPDATE, "UPDATE");
		*/
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SUBMISSION_DETAILS_VIEW, "VIEW");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SUBMISSION_DETAILS_EXPORT, "EXPORT");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SUBMISSION_DETAILS_UPDATE, "UPDATE");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SUBMISSION_DETAILS_UPLOAD_DOCUMENT, "UPLOAD_DOCUMENT");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SUBMISSION_DETAILS_RESUBMIT, "RESUBMIT");
		homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SUBMISSION_DETAILS_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		//homeworkAssignmentSubmissionDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SUBMISSION_DETAILS_MOREACTIONS, "MOREACTIONS");
		
		featurePrivilegesMap.add("HOMEWORK_ASSIGNMENT_SUBMISSION_DETAIL_PRIVILEGES", homeworkAssignmentSubmissionDetailPrivileges);
		
		
		homeworkAssignmentEvaluationDetailPrivileges = new Ext.util.HashMap();
		homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.PC_M4_F_EVALUATIONDETAILS_VIEW, "VIEW");
		homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.PC_M4_F_EVALUATIONDETAILS_UPDATE, "UPDATE");
		homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.PC_M4_F_EVALUATIONDETAILS_DELETE, "DELETE");
		//homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.PC_M4_F_EVALUATIONDETAILS_CREATE, "CREATE");
		//homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.PC_M4_F_EVALUATIONDETAILS_MOREACTION, "MOREACTIONS");
		//homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.PC_M4_F_EVALUATIONDETAILS_UPLOAD_DOCUMENT, "UPLOAD_DOCUMENT");
		homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.PC_M4_F_EVALUATIONDETAILS_EXPORT, "EXPORT");
		homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.PC_M4_F_EVALUATIONDETAILS_ENTER_REMARK, "ENTER_REMARK");
		homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.PC_M4_F_EVALUATIONDETAILS_SET_DEFAULT_MARKS, "SET_DEFAULT_MARKS");
		homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.PC_M4_F_EVALUATIONDETAILS_SET_DEFAULT_GRADE, "SET_DEFAULT_GRADE");
		
		featurePrivilegesMap.add("HOMEWORK_ASSIGNMENT_EVALUATION_DETAIL_PRIVILEGES", homeworkAssignmentEvaluationDetailPrivileges);
		/*homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.PF_M4_F_EVALUATIONDETAILS_UPDATE, "UPDATE");
		homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.PS_M4_F_EVALUATIONDETAILS_VIEW,"VIEW");
		*/
		homeworkAssignmentFPEvaluationDetailPrivileges = new Ext.util.HashMap();
		homeworkAssignmentFPEvaluationDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EVALUATION_DETAILS_VIEW, "VIEW");
		homeworkAssignmentFPEvaluationDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EVALUATION_DETAILS_EXPORT, "EXPORT");
		homeworkAssignmentFPEvaluationDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EVALUATION_DETAILS_UPDATE, "UPDATE");
		homeworkAssignmentFPEvaluationDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EVALUATION_DETAILS_DELETE, "DELETE");
		homeworkAssignmentFPEvaluationDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EVALUATION_DETAILS_ENTER_REMARK, "ENTER_REMARK");
		homeworkAssignmentFPEvaluationDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EVALUATION_SET_DEFAULT_MARKS, "SET_DEFAULT_MARKS");
		homeworkAssignmentFPEvaluationDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EVALUATION_SET_DEFAULT_GRADE, "SET_DEFAULT_GRADE");
		//homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EVALUATION_DETAILS_UPLOAD_DOCUMENT, "UPLOAD_DOCUMENT");
		//homeworkAssignmentEvaluationDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EVALUATION_DETAILS_MOREACTIONS, "MOREACTIONS");
		
		
		featurePrivilegesMap.add("HOMEWORK_ASSIGNMENT_FACULTY_PORTAL_EVALUATION_DETAIL_PRIVILEGES", homeworkAssignmentFPEvaluationDetailPrivileges);
		
		studyMaterialCourseReadingPrivileges = new Ext.util.HashMap();
		studyMaterialCourseReadingPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATRIALDISTRIBUTION_COURSEREADING_DELETE, "DELETE");
		studyMaterialCourseReadingPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATRIALDISTRIBUTION_COURSEREADING_UPDATE, "UPDATE");
		studyMaterialCourseReadingPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATRIALDISTRIBUTION_COURSEREADING_CREATE, "CREATE");
		studyMaterialCourseReadingPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATRIALDISTRIBUTION_COURSEREADING_VIEW, "VIEW");
		featurePrivilegesMap.add("STUDY_MATERIAL_COURSE_READING_PRIVILEGES", studyMaterialCourseReadingPrivileges);
		
		
		//*************Manage Bill***************
		
		PNCFeeAndStudentBillPrivileges = new Ext.util.HashMap();
		PNCFeeAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEESTUDENT_DELETE, "DELETE");
		PNCFeeAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEESTUDENT_UPDATE, "UPDATE");
		PNCFeeAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEESTUDENT_CREATE, "CREATE");
		PNCFeeAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEESTUDENT_VIEW, "VIEW");
		PNCFeeAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEESTUDENT_PRINT, "PRINT");
		PNCFeeAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEESTUDENT_EXPORT, "EXPORT");
		PNCFeeAndStudentBillPrivileges.add(FPCONSTANTS.PF_M6_F_PNCFEESTUDENT_VIEW, "VIEW");
		PNCFeeAndStudentBillPrivileges.add(FPCONSTANTS.PF_M6_F_PNCFEESTUDENT_PRINT, "PRINT");
		featurePrivilegesMap.add("PNCFEE_STUDENT_BILL_PRIVILEGES", PNCFeeAndStudentBillPrivileges);
		
		PNCFeeAndApplicantBillPrivileges = new Ext.util.HashMap();
		PNCFeeAndApplicantBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEEAPPLICANT_DELETE, "DELETE");
		PNCFeeAndApplicantBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEEAPPLICANT_UPDATE, "UPDATE");
		PNCFeeAndApplicantBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEEAPPLICANT_CREATE, "CREATE");
		PNCFeeAndApplicantBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEEAPPLICANT_VIEW, "VIEW");
		PNCFeeAndApplicantBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEEAPPLICANT_PRINT, "PRINT");
		PNCFeeAndApplicantBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEEAPPLICANT_EXPORT, "EXPORT");
		PNCFeeAndApplicantBillPrivileges.add(FPCONSTANTS.PF_M6_F_PNCFEEAPPLICANT_VIEW, "VIEW");
		PNCFeeAndApplicantBillPrivileges.add(FPCONSTANTS.PF_M6_F_PNCFEEAPPLICANT_PRINT, "PRINT");
		featurePrivilegesMap.add("PNCFEE_APPLICANT_BILL_PRIVILEGES", PNCFeeAndApplicantBillPrivileges);
		
		PNCFeeAndSponsorBillPrivileges = new Ext.util.HashMap();
		PNCFeeAndSponsorBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEESPONSOR_DELETE, "DELETE");
		PNCFeeAndSponsorBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEESPONSOR_UPDATE, "UPDATE");
		PNCFeeAndSponsorBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEESPONSOR_CREATE, "CREATE");
		PNCFeeAndSponsorBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEESPONSOR_VIEW, "VIEW");
		PNCFeeAndSponsorBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEESPONSOR_PRINT, "PRINT");
		PNCFeeAndSponsorBillPrivileges.add(FPCONSTANTS.PC_M6_F_PNCFEESPONSOR_EXPORT, "EXPORT");
		PNCFeeAndSponsorBillPrivileges.add(FPCONSTANTS.PF_M6_F_PNCFEESPONSOR_VIEW, "VIEW");
		PNCFeeAndSponsorBillPrivileges.add(FPCONSTANTS.PF_M6_F_PNCFEESPONSOR_PRINT, "PRINT");
		featurePrivilegesMap.add("PNCFEE_SPONSOR_BILL_PRIVILEGES", PNCFeeAndSponsorBillPrivileges);
		
		SPAndUserBillPrivileges = new Ext.util.HashMap();
		SPAndUserBillPrivileges.add(FPCONSTANTS.PC_M6_F_SPUSER_DELETE, "DELETE");
		SPAndUserBillPrivileges.add(FPCONSTANTS.PC_M6_F_SPUSER_UPDATE, "UPDATE");
		SPAndUserBillPrivileges.add(FPCONSTANTS.PC_M6_F_SPUSER_CREATE, "CREATE");
		SPAndUserBillPrivileges.add(FPCONSTANTS.PC_M6_F_SPUSER_VIEW, "VIEW");
		SPAndUserBillPrivileges.add(FPCONSTANTS.PC_M6_F_SPUSER_PRINT, "PRINT");
		SPAndUserBillPrivileges.add(FPCONSTANTS.PC_M6_F_SPUSER_EXPORT, "EXPORT");
		SPAndUserBillPrivileges.add(FPCONSTANTS.PF_M6_F_SPUSER_VIEW, "VIEW");
		SPAndUserBillPrivileges.add(FPCONSTANTS.PF_M6_F_SPUSER_PRINT, "PRINT");
		featurePrivilegesMap.add("SP_USER_BILL_PRIVILEGES", SPAndUserBillPrivileges);
		
		ServiceProvidedAndStudentBillPrivileges = new Ext.util.HashMap();
		ServiceProvidedAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICEPROVIDED_STUDENT_VIEW, "VIEW");
		ServiceProvidedAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICEPROVIDED_STUDENT_CREATE, "CREATE");
		ServiceProvidedAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICEPROVIDED_STUDENT_UPDATE, "UPDATE");
		ServiceProvidedAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICEPROVIDED_STUDENT_DELETE, "DELETE");
		ServiceProvidedAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICEPROVIDED_STUDENT_PRINT, "PRINT");
		ServiceProvidedAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICEPROVIDED_STUDENT_EXPORT, "EXPORT");
		//SPAndUserBillPrivileges.add(FPCONSTANTS.PF_M6_F_SERVICEPROVIDED_STUDENT_VIEW, "VIEW");
		//SPAndUserBillPrivileges.add(FPCONSTANTS.PF_M6_F_SERVICEPROVIDED_STUDENT_PRINT, "PRINT");
		featurePrivilegesMap.add("SERVICEPROVIDED_STUDENT_BILL_PRIVILEGES", ServiceProvidedAndStudentBillPrivileges);
		
		ServiceProvidedAndSponsorBillPrivileges = new Ext.util.HashMap();
		ServiceProvidedAndSponsorBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICEPROVIDED_SPONSOR_VIEW, "VIEW");
		ServiceProvidedAndSponsorBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICEPROVIDED_SPONSOR_CREATE, "CREATE");
		ServiceProvidedAndSponsorBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICEPROVIDED_SPONSOR_UPDATE, "UPDATE");
		ServiceProvidedAndSponsorBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICEPROVIDED_SPONSOR_DELETE, "DELETE");
		ServiceProvidedAndSponsorBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICEPROVIDED_SPONSOR_PRINT, "PRINT");
		ServiceProvidedAndSponsorBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICEPROVIDED_SPONSOR_EXPORT, "EXPORT");
		//SPAndUserBillPrivileges.add(FPCONSTANTS.PF_M6_F_SERVICEPROVIDED_SPONSOR_VIEW, "VIEW");
		//SPAndUserBillPrivileges.add(FPCONSTANTS.PF_M6_F_SERVICEPROVIDED_SPONSOR_PRINT, "PRINT");
		featurePrivilegesMap.add("SERVICEPROVIDED_SPONSOR_BILL_PRIVILEGES", ServiceProvidedAndSponsorBillPrivileges);
		
		ScholarshipAndStudentBillPrivileges = new Ext.util.HashMap();
		ScholarshipAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPSTUDENT_DELETE, "DELETE");
		ScholarshipAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPSTUDENT_UPDATE, "UPDATE");
		ScholarshipAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPSTUDENT_CREATE, "CREATE");
		ScholarshipAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPSTUDENT_VIEW, "VIEW");
		ScholarshipAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPSTUDENT_PRINT, "PRINT");
		ScholarshipAndStudentBillPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPSTUDENT_EXPORT, "EXPORT");
		ScholarshipAndStudentBillPrivileges.add(FPCONSTANTS.PF_M6_F_SCHOLARSHIPSTUDENT_VIEW, "VIEW");
		ScholarshipAndStudentBillPrivileges.add(FPCONSTANTS.PF_M6_F_SCHOLARSHIPSTUDENT_PRINT, "PRINT");
		featurePrivilegesMap.add("SCHOLARSHIP_STUDENT_BILL_PRIVILEGES", ScholarshipAndStudentBillPrivileges);
		
		ServiceReceivedAndUserBillPrivileges = new Ext.util.HashMap();
		ServiceReceivedAndUserBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICERECEIVEDUSER_DELETE, "DELETE");
		ServiceReceivedAndUserBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICERECEIVEDUSER_UPDATE, "UPDATE");
		ServiceReceivedAndUserBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICERECEIVEDUSER_CREATE, "CREATE");
		ServiceReceivedAndUserBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICERECEIVEDUSER_VIEW, "VIEW");
		ServiceReceivedAndUserBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICERECEIVEDUSER_PRINT, "PRINT");
		ServiceReceivedAndUserBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICERECEIVEDUSER_EXPORT, "EXPORT");
		ServiceReceivedAndUserBillPrivileges.add(FPCONSTANTS.PF_M6_F_SERVICERECEIVEDUSER_VIEW, "VIEW");
		ServiceReceivedAndUserBillPrivileges.add(FPCONSTANTS.PF_M6_F_SERVICERECEIVEDUSER_PRINT, "PRINT");
		featurePrivilegesMap.add("SERVICERECEIVED_USER_BILL_PRIVILEGES", ServiceReceivedAndUserBillPrivileges);
		
		DependentBillsAndThirdPartyBillPrivileges = new Ext.util.HashMap();
		DependentBillsAndThirdPartyBillPrivileges.add(FPCONSTANTS.PC_M6_F_DEPENDENTBILLSTHIRDPARTY_DELETE, "DELETE");
		DependentBillsAndThirdPartyBillPrivileges.add(FPCONSTANTS.PC_M6_F_DEPENDENTBILLSTHIRDPARTY_UPDATE, "UPDATE");
		DependentBillsAndThirdPartyBillPrivileges.add(FPCONSTANTS.PC_M6_F_DEPENDENTBILLSTHIRDPARTY_CREATE, "CREATE");
		DependentBillsAndThirdPartyBillPrivileges.add(FPCONSTANTS.PC_M6_F_DEPENDENTBILLSTHIRDPARTY_VIEW, "VIEW");
		DependentBillsAndThirdPartyBillPrivileges.add(FPCONSTANTS.PC_M6_F_DEPENDENTBILLSTHIRDPARTY_PRINT, "PRINT");
		DependentBillsAndThirdPartyBillPrivileges.add(FPCONSTANTS.PC_M6_F_DEPENDENTBILLSTHIRDPARTY_EXPORT, "EXPORT");
		DependentBillsAndThirdPartyBillPrivileges.add(FPCONSTANTS.PF_M6_F_DEPENDENTBILLSTHIRDPARTY_VIEW, "VIEW");
		DependentBillsAndThirdPartyBillPrivileges.add(FPCONSTANTS.PF_M6_F_DEPENDENTBILLSTHIRDPARTY_PRINT, "PRINT");
		featurePrivilegesMap.add("DEPENDENTBILLS_THIRDPARTY_BILL_PRIVILEGES", DependentBillsAndThirdPartyBillPrivileges);
		
		PAndCFeeBillPrivileges = new Ext.util.HashMap();
		//PAndCFeeBillPrivileges.add(FPCONSTANTS.PC_M6_F_PANDCFEE_DELETE, "DELETE");
		//PAndCFeeBillPrivileges.add(FPCONSTANTS.PC_M6_F_PANDCFEE_UPDATE, "UPDATE");
		PAndCFeeBillPrivileges.add(FPCONSTANTS.PC_M6_F_PANDCFEE_CREATE, "CREATE");
		PAndCFeeBillPrivileges.add(FPCONSTANTS.PC_M6_F_PANDCFEE_VIEW, "VIEW");
		PAndCFeeBillPrivileges.add(FPCONSTANTS.PC_M6_F_PANDCFEE_EXPORT, "EXPORT");
		PAndCFeeBillPrivileges.add(FPCONSTANTS.PC_M6_F_PANDCFEE_MOREACTIONS, "MOREACTIONS");
		//PAndCFeeBillPrivileges.add(FPCONSTANTS.PC_M6_F_PANDCFEE_MANAGESESSION, "MANAGESESSION");
		PAndCFeeBillPrivileges.add(FPCONSTANTS.PC_M6_F_PANDCFEE_DISCOUNTENTRY, "DISCOUNTENTRY");
		//PAndCFeeBillPrivileges.add(FPCONSTANTS.PC_M6_F_PANDCFEE_VIEWCALCULATEDFH, "VIEWCALCULATEDFH");
		PAndCFeeBillPrivileges.add(FPCONSTANTS.PF_M6_F_PANDCFEE_VIEW, "VIEW");
		PAndCFeeBillPrivileges.add(FPCONSTANTS.PF_M6_F_PANDCFEE_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		
		//PAndCFeeBillPrivileges.add(FPCONSTANTS.PS_M6_F_PANDCFEE_VIEW, "VIEW");
		featurePrivilegesMap.add("PANDCFEE_BILL_PRIVILEGES", PAndCFeeBillPrivileges);
		
		ScholarshipBillPrivileges = new Ext.util.HashMap();
//		ScholarshipBillPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIP_DELETE, "DELETE");
//		ScholarshipBillPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIP_UPDATE, "UPDATE");
		ScholarshipBillPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIP_CREATE, "CREATE");
		ScholarshipBillPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIP_VIEW, "VIEW");
		ScholarshipBillPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIP_EXPORT, "EXPORT");
		featurePrivilegesMap.add("SCHOLARSHIP_BILL_PRIVILEGES", ScholarshipBillPrivileges);
		
		ServiceReceivedBillPrivileges = new Ext.util.HashMap();
//		ServiceReceivedBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICERECEIVED_DELETE, "DELETE");
//		ServiceReceivedBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICERECEIVED_UPDATE, "UPDATE");
		ServiceReceivedBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICERECEIVED_CREATE, "CREATE");
		ServiceReceivedBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICERECEIVED_VIEW, "VIEW");
		ServiceReceivedBillPrivileges.add(FPCONSTANTS.PC_M6_F_SERVICERECEIVED_EXPORT, "EXPORT");
		featurePrivilegesMap.add("SERVICERECEIVED_BILL_PRIVILEGES", ServiceReceivedBillPrivileges);
		
		DependentBillPrivileges = new Ext.util.HashMap();
		//DependentBillPrivileges.add(FPCONSTANTS.PC_M6_F_DEPENDENTBILL_DELETE, "DELETE");
		//DependentBillPrivileges.add(FPCONSTANTS.PC_M6_F_DEPENDENTBILL_UPDATE, "UPDATE");
		//DependentBillPrivileges.add(FPCONSTANTS.PC_M6_F_DEPENDENTBILL_CREATE, "CREATE");
		//DependentBillPrivileges.add(FPCONSTANTS.PC_M6_F_DEPENDENTBILL_VIEW, "VIEW");
		DependentBillPrivileges.add(FPCONSTANTS.PC_M6_F_DEPENDENTBILL_PRINT, "PRINT");
		DependentBillPrivileges.add(FPCONSTANTS.PC_M6_F_DEPENDENTBILL_EXPORT, "EXPORT");
		featurePrivilegesMap.add("DEPENDENT_BILL_PRIVILEGES", DependentBillPrivileges);
		
		DiscountBillPrivileges = new Ext.util.HashMap();
//		DiscountBillPrivileges.add(FPCONSTANTS.PC_M6_F_DISCOUNTBILL_DELETE, "DELETE");
//		DiscountBillPrivileges.add(FPCONSTANTS.PC_M6_F_DISCOUNTBILL_UPDATE, "UPDATE");
		DiscountBillPrivileges.add(FPCONSTANTS.PC_M6_F_DISCOUNTBILL_CREATE, "CREATE");
		DiscountBillPrivileges.add(FPCONSTANTS.PC_M6_F_DISCOUNTBILL_VIEW, "VIEW");
		DiscountBillPrivileges.add(FPCONSTANTS.PC_M6_F_DISCOUNTBILL_EXPORT, "EXPORT");
		featurePrivilegesMap.add("DISCOUNT_BILL_PRIVILEGES", DiscountBillPrivileges);
		
		DiscountEntryPrivileges = new Ext.util.HashMap();
		DiscountEntryPrivileges.add(FPCONSTANTS.PC_M6_F_DISCOUNTENTRY_DELETE, "DELETE");
		DiscountEntryPrivileges.add(FPCONSTANTS.PC_M6_F_DISCOUNTENTRY_UPDATE, "UPDATE");
		DiscountEntryPrivileges.add(FPCONSTANTS.PC_M6_F_DISCOUNTENTRY_CREATE, "CREATE");
		DiscountEntryPrivileges.add(FPCONSTANTS.PC_M6_F_DISCOUNTENTRY_VIEW, "VIEW");
		featurePrivilegesMap.add("DISCOUNT_ENTRY_PRIVILEGES", DiscountEntryPrivileges);
		
		ManageBillPrivileges = new Ext.util.HashMap();
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_CANCEL, "CANCEL");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_EDIT, "EDIT");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_CREATE, "CREATE");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_VIEW, "VIEW");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_PRINT, "PRINT");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_EXPORT, "EXPORT");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_SEND_INVOICE, "SEND_INVOICE");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_MAKE_PAYMENT, "MAKE_PAYMENT");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_CHANGE_BILL_DUE_DATE, "CHANGE_BILL_DUE_DATE");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_SEND_PAYMENT_LINK, "SEND_PAYMENT_LINK");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_FLAG_UNFLAG, "FLAG_UNFLAG");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_SHARE_BILL_ON_WHATSAPP, "SHARE_BILL_ON_WHATSAPP");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_TOTAL_BALANCE, "TOTAL_BALANCE");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_BILLING_START_DATE, "BILLING_START_DATE");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_BILLING_END_DATE, "BILLING_END_DATE");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_ATTENDANCE_START_DATE, "ATTENDANCE_START_DATE");
		ManageBillPrivileges.add(FPCONSTANTS.PC_M6_F_CreateBILL_SCHOOL_LEAVING_DATE, "SCHOOL_LEAVING_DATE");
		featurePrivilegesMap.add("MANAGE_BILL_PRIVILEGES", ManageBillPrivileges);
		
		
		//*************Manage bill loader check box***************
		 
		 manageBillLoaderInactiveStudentPrivileges = new Ext.util.HashMap();
		 manageBillLoaderInactiveStudentPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_BILL_FOR_INACTIVE_STUDENT,"INACTIVE_STUDENT");
         featurePrivilegesMap.add("MANAGE_BILL_FOR_INACTIVE_STUDENT_PRIVILEGES", manageBillLoaderInactiveStudentPrivileges);
		
		//*************Manage Receipt***************
		
		studentReceiptPrivileges = new Ext.util.HashMap();
		studentReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_STUDENTRECEIPT_DELETE, "DELETE");
		studentReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_STUDENTRECEIPT_UPDATE, "UPDATE");
		studentReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_STUDENTRECEIPT_CREATE, "CREATE");
		studentReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_STUDENTRECEIPT_VIEW, "VIEW");
		studentReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_STUDENTRECEIPT_EXPORT, "EXPORT");
		studentReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_STUDENTRECEIPT_PRINT, "PRINT");
		studentReceiptPrivileges.add(FPCONSTANTS.PF_M6_F_STUDENTRECEIPT_VIEW, "VIEW");
		studentReceiptPrivileges.add(FPCONSTANTS.PF_M6_F_STUDENTRECEIPT_PRINT, "PRINT");
		
		studentReceiptPrivileges.add(FPCONSTANTS.PS_M6_F_STUDENTRECEIPT_VIEW, "VIEW");
		featurePrivilegesMap.add("STUDENT_RECEIPT_PRIVILEGES", studentReceiptPrivileges);
		
		applicantReceiptPrivileges = new Ext.util.HashMap();
		applicantReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_APPLICANTRECEIPT_DELETE, "DELETE");
		applicantReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_APPLICANTRECEIPT_UPDATE, "UPDATE");
		applicantReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_APPLICANTRECEIPT_CREATE, "CREATE");
		applicantReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_APPLICANTRECEIPT_VIEW, "VIEW");
		applicantReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_APPLICANTRECEIPT_EXPORT, "EXPORT");
		applicantReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_APPLICANTRECEIPT_PRINT, "PRINT");
		applicantReceiptPrivileges.add(FPCONSTANTS.PF_M6_F_APPLICANTRECEIPT_VIEW, "VIEW");
		featurePrivilegesMap.add("APPLICANT_RECEIPT_PRIVILEGES", applicantReceiptPrivileges);
		
		scholarshipReceiptPrivileges = new Ext.util.HashMap();
		scholarshipReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPRECEIPT_DELETE, "DELETE");
		scholarshipReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPRECEIPT_UPDATE, "UPDATE");
		scholarshipReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPRECEIPT_CREATE, "CREATE");
		scholarshipReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPRECEIPT_VIEW, "VIEW");
		scholarshipReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPRECEIPT_EXPORT, "EXPORT");
		scholarshipReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPRECEIPT_PRINT, "PRINT");
		scholarshipReceiptPrivileges.add(FPCONSTANTS.PF_M6_F_SCHOLARSHIPRECEIPT_VIEW, "VIEW");
		featurePrivilegesMap.add("SCHOLARSHIP_STUDENT_RECEIPT_PRIVILEGES", scholarshipReceiptPrivileges);
		
		sponsorReceiptPrivileges = new Ext.util.HashMap();
		sponsorReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_SPONSORRECEIPT_DELETE, "DELETE");
		sponsorReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_SPONSORRECEIPT_UPDATE, "UPDATE");
		sponsorReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_SPONSORRECEIPT_CREATE, "CREATE");
		sponsorReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_SPONSORRECEIPT_VIEW, "VIEW");
		sponsorReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_SPONSORRECEIPT_EXPORT, "EXPORT");
		sponsorReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_SPONSORRECEIPT_PRINT, "PRINT");
		sponsorReceiptPrivileges.add(FPCONSTANTS.PF_M6_F_SPONSORRECEIPT_VIEW, "VIEW");
	//	sponsorReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_SPONSORRECEIPT_GRID_CONFIGURATION, "GRID CONFIGURATION");
		featurePrivilegesMap.add("SPONSOR_RECEIPT_PRIVILEGES", sponsorReceiptPrivileges);
		
		thirdPartyReceiptPrivileges = new Ext.util.HashMap();
		thirdPartyReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_THIRDPARTYRECEIPT_DELETE, "DELETE");
		thirdPartyReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_THIRDPARTYRECEIPT_UPDATE, "UPDATE");
		thirdPartyReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_THIRDPARTYRECEIPT_CREATE, "CREATE");
		thirdPartyReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_THIRDPARTYRECEIPT_VIEW, "VIEW");
		thirdPartyReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_THIRDPARTYRECEIPT_EXPORT, "EXPORT");
		thirdPartyReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_THIRDPARTYRECEIPT_PRINT, "PRINT");
		thirdPartyReceiptPrivileges.add(FPCONSTANTS.PF_M6_F_THIRDPARTYRECEIPT_VIEW, "VIEW");
		featurePrivilegesMap.add("THIRDPARTY_RECEIPT_PRIVILEGES", thirdPartyReceiptPrivileges);
		
		userReceiptPrivileges = new Ext.util.HashMap();
		userReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_USERRECEIPT_DELETE, "DELETE");
		userReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_USERRECEIPT_UPDATE, "UPDATE");
		userReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_USERRECEIPT_CREATE, "CREATE");
		userReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_USERRECEIPT_VIEW, "VIEW");
		userReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_USERRECEIPT_EXPORT, "EXPORT");
		userReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_USERRECEIPT_PRINT, "PRINT");
		userReceiptPrivileges.add(FPCONSTANTS.PF_M6_F_USERRECEIPT_VIEW, "VIEW");
		featurePrivilegesMap.add("USER_RECEIPT_PRIVILEGES", userReceiptPrivileges);
		
		/*importReceiptPrivileges = new Ext.util.HashMap();
		importReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_IMPORTRECEIPT_UPLOADFILE, "UPLOADFILE");
		importReceiptPrivileges.add(FPCONSTANTS.PC_M6_F_IMPORTRECEIPT_DOWNLOAD, "DOWNLOAD");
		featurePrivilegesMap.add("IMPORT_RECEIPT_PRIVILEGES", importReceiptPrivileges);
		*/
		
		ManageReceiptsPrivileges = new Ext.util.HashMap();
		ManageReceiptsPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGERECEIPT_CANCEL, "CANCEL");
		ManageReceiptsPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGERECEIPT_EDIT, "EDIT");
		ManageReceiptsPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGERECEIPT_CREATE, "CREATE");
		ManageReceiptsPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGERECEIPT_VIEW, "VIEW");
		ManageReceiptsPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGERECEIPT_PRINT, "PRINT");
		ManageReceiptsPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGERECEIPT_EXPORT, "EXPORT");
		ManageReceiptsPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGERECEIPT_MAP_ACADEMY_LOCATION, "MAP_ACADEMY_LOCATIONS");
		ManageReceiptsPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGERECEIPT_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		ManageReceiptsPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGERECEIPT_TOTAL_BALANCE, "TOTAL_BALANCE");
		featurePrivilegesMap.add("MANAGE_RECEIPTS_PRIVILEGES", ManageReceiptsPrivileges);
		
		//*************Manage Payment***************
		
		cancelSettlementsPrivileges = new Ext.util.HashMap();
		cancelSettlementsPrivileges.add(FPCONSTANTS.PC_M6_D_CANCELSETTLEMENTS_CANCELSETTLEMENTS, "CANCELSETTLEMENTS");
		featurePrivilegesMap.add("CANCELSETTLEMENTS_PRIVILEGES", cancelSettlementsPrivileges);
		
		saveButtonPrivileges = new Ext.util.HashMap();
		saveButtonPrivileges.add(FPCONSTANTS.PC_M6_D_SAVEBUTTON_SAVE, "SAVE");
		featurePrivilegesMap.add("SAVEBUTTON_PRIVILEGES", saveButtonPrivileges);
		
		printButtonPrivileges = new Ext.util.HashMap();
		printButtonPrivileges.add(FPCONSTANTS.PC_M6_F_ADJUSTMENT_PRINT, "PRINT");
		printButtonPrivileges.add(FPCONSTANTS.PC_M6_F_ADJUSTMENT_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		printButtonPrivileges.add(FPCONSTANTS.PC_M6_F_ADJUSTMENT_TOTAL_BALANCE, "TOTAL_BALANCE");
		featurePrivilegesMap.add("PRINTBUTTON_PRIVILEGES", printButtonPrivileges);
		
		manageSettlementPrivileges = new Ext.util.HashMap();
		manageSettlementPrivileges.add(FPCONSTANTS.FP_M6_F_MANAGESETTLEMENT_MAP_ACADEMY_LOCATION, "MAP_ACADEMY_LOCATIONS");
		manageSettlementPrivileges.add(FPCONSTANTS.FP_M6_F_MANAGESETTLEMENT_SETTLE_WITH_CHECKBOX, "SETTLE_WITH_CHECKBOX");
		featurePrivilegesMap.add("MAP_ACADEMY_LOCATIONS_PRIVILEGES", manageSettlementPrivileges);
		
		userPaymentPrivileges = new Ext.util.HashMap();
		userPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_SPANDUSERPAYMENT_CREATE, "CREATE");
		userPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_SPANDUSERPAYMENT_VIEW, "VIEW");
		userPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_SPANDUSERPAYMENT_DELETE, "DELETE");
		userPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_SPANDUSERPAYMENT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("USER_PAYMENT_PRIVILEGES", userPaymentPrivileges);
		
		applicantPaymentPrivileges = new Ext.util.HashMap();
		applicantPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_PCORSPANDAPPLICANTPAYMENT_CREATE, "CREATE");
		applicantPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_PCORSPANDAPPLICANTPAYMENT_VIEW, "VIEW");
		applicantPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_PCORSPANDAPPLICANTPAYMENT_DELETE, "DELETE");
		applicantPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_PCORSPANDAPPLICANTPAYMENT_EXPORT, "EXPORT");
		applicantPaymentPrivileges.add(FPCONSTANTS.PF_M6_F_PCORSPANDAPPLICANTPAYMENT_VIEW, "VIEW");
		applicantPaymentPrivileges.add(FPCONSTANTS.PF_M6_F_PCORSPANDAPPLICANTPAYMENT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("APPLICANT_FEE_PAYMENT_PRIVILEGES", applicantPaymentPrivileges);
		
		studentPaymentPrivileges = new Ext.util.HashMap();
		studentPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_PCORSPANDSTUDENTPAYMENT_CREATE, "CREATE");
		studentPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_PCORSPANDSTUDENTPAYMENT_VIEW, "VIEW");
		studentPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_PCORSPANDSTUDENTPAYMENT_DELETE, "DELETE");
		studentPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_PCORSPANDSTUDENTPAYMENT_EXPORT, "EXPORT");
		studentPaymentPrivileges.add(FPCONSTANTS.PF_M6_F_PCORSPANDSTUDENTPAYMENT_VIEW, "VIEW");
		studentPaymentPrivileges.add(FPCONSTANTS.PF_M6_F_PCORSPANDSTUDENTPAYMENT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("STUDENT_PAYMENT_PRIVILEGES", studentPaymentPrivileges);
		
		sponsorPaymentPrivileges = new Ext.util.HashMap();
		sponsorPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_PCORSPANDSPONSORPAYMENT_CREATE, "CREATE");
		sponsorPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_PCORSPANDSPONSORPAYMENT_VIEW, "VIEW");
		sponsorPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_PCORSPANDSPONSORPAYMENT_DELETE, "DELETE");
		sponsorPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_PCORSPANDSPONSORPAYMENT_EXPORT, "EXPORT");
		sponsorPaymentPrivileges.add(FPCONSTANTS.PF_M6_F_PCORSPANDSPONSORPAYMENT_VIEW, "VIEW");
		sponsorPaymentPrivileges.add(FPCONSTANTS.PF_M6_F_PCORSPANDSPONSORPAYMENT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("SPONSOR_PAYMENT_PRIVILEGES", sponsorPaymentPrivileges);
		
		managePaymentPrivileges = new Ext.util.HashMap();
		managePaymentPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_MAYMENT_FOR_INACTIVE_STUDENT,"INACTIVE_STUDENT");
			featurePrivilegesMap.add("MANAGE_PAYMENT_FOR_INACTIVE_STUDENT", managePaymentPrivileges);
		
		thirdPartyPaymentPrivileges = new Ext.util.HashMap();
		thirdPartyPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_DFHANDTHIRDPARTYPAYMENT_CREATE, "CREATE");
		thirdPartyPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_DFHANDTHIRDPARTYPAYMENT_VIEW, "VIEW");
		thirdPartyPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_DFHANDTHIRDPARTYPAYMENT_DELETE, "DELETE");
		thirdPartyPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_DFHANDTHIRDPARTYPAYMENT_EXPORT, "EXPORT");
		thirdPartyPaymentPrivileges.add(FPCONSTANTS.PF_M6_F_DFHANDTHIRDPARTYPAYMENT_VIEW, "VIEW");
		thirdPartyPaymentPrivileges.add(FPCONSTANTS.PF_M6_F_DFHANDTHIRDPARTYPAYMENT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("THIRDPARTY_PAYMENT_PRIVILEGES", thirdPartyPaymentPrivileges);
		
		srAndUserPaymentPrivileges = new Ext.util.HashMap();
		srAndUserPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_SRANDUSERPAYMENT_CREATE, "CREATE");
		srAndUserPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_SRANDUSERPAYMENT_VIEW, "VIEW");
		srAndUserPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_SRANDUSERPAYMENT_DELETE, "DELETE");
		srAndUserPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_SRANDUSERPAYMENT_EXPORT, "EXPORT");
		srAndUserPaymentPrivileges.add(FPCONSTANTS.PF_M6_F_SRANDUSERPAYMENT_VIEW, "VIEW");
		srAndUserPaymentPrivileges.add(FPCONSTANTS.PF_M6_F_SRANDUSERPAYMENT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("SRANDUSER_PAYMENT_PRIVILEGES", srAndUserPaymentPrivileges);
		
		scholarshipAndStudentPaymentPrivileges = new Ext.util.HashMap();
		scholarshipAndStudentPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPANDSTUDENTPAYMENT_CREATE, "CREATE");
		scholarshipAndStudentPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPANDSTUDENTPAYMENT_VIEW, "VIEW");
		scholarshipAndStudentPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPANDSTUDENTPAYMENT_DELETE, "DELETE");
		scholarshipAndStudentPaymentPrivileges.add(FPCONSTANTS.PC_M6_F_SCHOLARSHIPANDSTUDENTPAYMENT_EXPORT, "EXPORT");
		scholarshipAndStudentPaymentPrivileges.add(FPCONSTANTS.PF_M6_F_SCHOLARSHIPANDSTUDENTPAYMENT_VIEW, "VIEW");
		scholarshipAndStudentPaymentPrivileges.add(FPCONSTANTS.PF_M6_F_SCHOLARSHIPANDSTUDENTPAYMENT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("SCHOLARSHIPANDSTUDENT_PAYMENT_PRIVILEGES", scholarshipAndStudentPaymentPrivileges);
		
		evaluationGroupPrivileges = new Ext.util.HashMap();
		evaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUP_DELETE, "DELETE");
		evaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUP_UPDATE, "UPDATE");
		evaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUP_CREATE, "CREATE");
		evaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUP_VIEW, "VIEW");
		evaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUP_EXPORT, "EXPORT");	
		evaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUP_DEFINE_RULES, "DEFINE_RULES");
		evaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUP_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		evaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUP_IMPORT_BULK, "IMPORT_BULK");
		evaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUP_ASSESSMENT_GROUP_DETAIL, "ASSESSMENT_GROUP_DETAIL");
		evaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUP_ASSESSMENT_EVENTS_COVERED, "ASSESSMENT_EVENTS_COVERED");
		evaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUP_ASSESSMENT_EXPORTREPORTS, "EXPORTREPORTS");
		
		
		
		featurePrivilegesMap.add("EVALUATION_GROUP_PRIVILEGES", evaluationGroupPrivileges);
		
		evaluationGroupDetailSeqCoveredPrivileges = new Ext.util.HashMap();
		evaluationGroupDetailSeqCoveredPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUPDETAILSEQCOVERED_DELETE, "DELETE");
		evaluationGroupDetailSeqCoveredPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUPDETAILSEQCOVERED_UPDATE, "UPDATE");
		evaluationGroupDetailSeqCoveredPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUPDETAILSEQCOVERED_CREATE, "CREATE");
		//evaluationGroupDetailSeqCoveredPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUPDETAILSEQCOVERED_VIEW, "VIEW");
		evaluationGroupDetailSeqCoveredPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUPDETAILSEQCOVERED_EXPORT, "EXPORT");
		evaluationGroupDetailSeqCoveredPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUPDETAILSEQCOVERED_AUTOEXAM, "AUTOEXAM");
		featurePrivilegesMap.add("EVALUATION_GROUP_DETAIL_SEQ_COVERED_PRIVILEGES", evaluationGroupDetailSeqCoveredPrivileges);
		
		centerunavailableDetailPrivileges = new Ext.util.HashMap();
		centerunavailableDetailPrivileges.add(FPCONSTANTS.PC_M5_F_CENTERUNAVAILABLEDETAIL_EXPORT, "EXPORT");
		featurePrivilegesMap.add("CENTER_UNAVAILABLE_DETAIL_PRIVILEGES", centerunavailableDetailPrivileges);
		
		attendanceentryPrivileges = new Ext.util.HashMap();
		//attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_CREATE,"CREATE");
		//attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_UPDATE,"UPDATE");
		//attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_ADDEDITTOPICDETAILS,"ADDEDITTOPICDETAILS");
		attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_VIEW,"VIEW");
		attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_IMPORTATTENDANCE,"IMPORTATTENDANCE");
		attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_IMPORTCOURSELEVELATTENDANCE,"IMPORTCOURSELEVELATTENDANCE");
		attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_PROGRAM_WISE,"PROGRAM_WISE");
		attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_COURSE_WISE,"COURSE_WISE");
		attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_SESSION_WISE,"SESSION_WISE");
		attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_SERVICE_WISE,"SERVICE_WISE");
		attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_GENERATE_QR_PROGRAM_WISE,"GENERATE_QR_PROGRAM_WISE");
		attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_GENERATE_QR_COURSE_WISE,"GENERATE_QR_COURSE_WISE");
		attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_GENERATE_QR_SESSION_WISE,"GENERATE_QR_SESSION_WISE");
		//attendanceentryPrivileges.add(FPCONSTANTS.PF_M4_F_ATTENDANCEENTRY_VIEW,"VIEW");
		//attendanceentryPrivileges.add(FPCONSTANTS.PF_M4_F_ATTENDANCEENTRY_CREATE,"CREATE");
		//attendanceentryPrivileges.add(FPCONSTANTS.PF_M4_F_ATTENDANCEENTRY_UPDATE,"UPDATE");
		attendanceentryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ATTENDANCE_EXPORT,"EXPORT");
		//attendanceentryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ATTENDANCE_CREATE,"CREATE");
		//attendanceentryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ATTENDANCE_UPDATE,"UPDATE");
		//attendanceentryPrivileges.add(FPCONSTANTS.PS_M4_F_ATTENDANCEENTRY_VIEW,"VIEW");
		//attendanceentryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ATTENDANCE_ADDEDITTOPICDETAILS,"ADDEDITTOPICDETAILS");
		attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_GRID_CONFIG,"GRID_CONFIGURATION");
		attendanceentryPrivileges.add(FPCONSTANTS.PC_M4_F_ATTENDANCEENTRY_IMPORT_SERVICE_LEVEL_ATTENDANCE,"IMPORT_SERVICE_LEVEL_ATTENDANCE");
		featurePrivilegesMap.add("ATTENDANCE_ENTRY_PRIVILEGES", attendanceentryPrivileges);
		
		attendanceentryFacultyPoratalPrivileges = new Ext.util.HashMap();
		//attendanceentryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ATTENDANCE_VIEW,"VIEW");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_MARK_ATTENDANCE_IMPORTATTENDANCE,"IMPORTATTENDANCE");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_MARK_ATTENDANCE_IMPORTCOURSELEVELATTENDANCE,"IMPORTCOURSELEVELATTENDANCE");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_MARK_ATTENDANCE_PROGRAM_WISE,"PROGRAM_WISE");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_MARK_ATTENDANCE_COURSE_WISE,"COURSE_WISE");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_MARK_ATTENDANCE_SESSION_WISE,"SESSION_WISE");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_MARK_ATTENDANCE_VIEW,"VIEW");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_MARK_ATTENDANCE_CREATE,"CREATE");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_MARK_ATTENDANCE_UPDATE,"UPDATE");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_MARK_ATTENDANCE_EXPORT,"EXPORT");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_MARK_ATTENDANCE_GENERATE_QR_PROGRAM_WISE, "GENERATE_QR_PROGRAM_WISE");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_MARK_ATTENDANCE_GENERATE_QR_COURSE_WISE, "GENERATE_QR_COURSE_WISE");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_MARK_ATTENDANCE_GENERATE_QR_SESSION_WISE, "GENERATE_QR_SESSION_WISE");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_MARK_ATTENDANCE_SERVICE_WISE,"SERVICE_WISE");
		attendanceentryFacultyPoratalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ATTENDANCE_GRID_CONFIG,"GRID_CONFIGURATION");
		
		featurePrivilegesMap.add("ATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES", attendanceentryFacultyPoratalPrivileges);
		
		courseCoveragePlanPrivileges = new Ext.util.HashMap();
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_PROGRAM_BATCH_SECTION,"PROGRAM_BATCH_SECTION");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_COURSE_SECTION,"COURSE_SECTION");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_CREATE,"CREATE");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_UPDATE,"UPDATE");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_DELETE,"DELETE");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_EXPORT,"EXPORT");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_ASSIGNFACULTY,"ASSIGNFACULTY");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_REMOVEFACULTY,"REMOVEFACULTY");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_SUBSTITUTE_SESSION,"SUBSTITUTE_SESSION");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_GRID_CONFIG,"GRID_CONFIGURATION");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_EXPORT_REPORT,"EXPORT_REPORT");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_RESOURCE_UTILIZATION_REPORT,"RESOURCE_UTILIZATION_REPORT");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_RESOURCRE_AVAILABILITY_REPORT,"RESOURCRE_AVAILABILITY_REPORT");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_SUBSTITUTE_SESSION_AL_LEVEL,"SUBSTITUTE_SESSION_AL_LEVEL");
		courseCoveragePlanPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSECOVERAGEPLAN_SUBSTITUTE_SESSION_ORGANIZATION,"SUBSTITUTE_SESSION_ORGANIZATION");
		featurePrivilegesMap.add("COURSE_COVERAGE_PLAN_PRIVILEGES", courseCoveragePlanPrivileges);
		
		evaluationGroupDocumentPrivileges = new Ext.util.HashMap();
		evaluationGroupDocumentPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUPDOCUMENTS_VIEW,"VIEW");
		evaluationGroupDocumentPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUPDOCUMENTS_CREATE,"CREATE");
		evaluationGroupDocumentPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUPDOCUMENTS_UPDATE,"UPDATE");
		evaluationGroupDocumentPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUPDOCUMENTS_DELETE,"DELETE");
		evaluationGroupDocumentPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONGROUPDOCUMENTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EVALUATION_GROUP_DOCUMENT_PRIVILEGES", evaluationGroupDocumentPrivileges);
		
		
		createTimeTablePrivileges = new Ext.util.HashMap();
		createTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_CREATETIMETABLE_MOREACTIONS,"MOREACTIONS");
		createTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_CREATETIMETABLE_ADDCOVERAGEDETAILS,"ADDCOVERAGEDETAILS");
		createTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_CREATETIMETABLE_ADDNEWSESSION,"ADDNEWSESSION");
		createTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_CREATETIMETABLE_EXPORT,"EXPORT");
		createTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_CREATETIMETABLE_EXPORT,"EXPORT");
		createTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_CREATETIMETABLE_EXPORT,"EXPORT");
		
		featurePrivilegesMap.add("CREATE_TIME_TABLE_PRIVILEGES", createTimeTablePrivileges);
		
		masterTimeTablePrivileges = new Ext.util.HashMap();
		masterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_MASTERTIMETABLE_VIEW,"VIEW");
		masterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_MASTERTIMETABLE_PROGRAM_BATCH_SECTION,"PROGRAM_BATCH_SECTION");
		masterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_MASTERTIMETABLE_COURSE_SECTION,"COURSE_SECTION");
		masterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_MASTERTIMETABLE_CREATEVIEW,"CREATEVIEW");
		//masterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_MASTERTIMETABLE_GENERATE,"GENERATE");
		masterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_TIMETABLE_IMPORT_BULK_TIMETABLE,"BULK_TIMETABLE");
		masterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_MASTERTIMETABLE_PRINT,"PRINT");
		masterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_MASTERTIMETABLE_EXPORT_TO_PNG,"EXPORT_TO_PNG");
		masterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_TIMETABLE_IMPORT_ASC_TIMETABLE,"IMPORT_ASC_TIMETABLE");
		masterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_MASTERTIMETABLE_ADD,"ADD");
		masterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_MASTERTIMETABLE_DELETE,"DELETE");
		masterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_MASTERTIMETABLE_ALL_FACULTIES,"ALL_FACULTIES");
		featurePrivilegesMap.add("MASTER_TIME_TABLE_PRIVILEGES", masterTimeTablePrivileges);
		
		importMasterTimeTablePrivileges = new Ext.util.HashMap();
		importMasterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_IMPORT_MASTERTIMETABLE_PROGRAM_BATCH_SECTION,"PROGRAM_BATCH_SECTION");
		importMasterTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_IMPORT_MASTERTIMETABLE_COURSE_SECTION,"COURSE_SECTION");
		featurePrivilegesMap.add("IMPORT_MASTER_TIME_TABLE_PRIVILEGES", importMasterTimeTablePrivileges);
		
		extendTimeTablePrivileges = new Ext.util.HashMap();
		extendTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_EXTENDTIMETABLE_PROGRAM_BATCH_SECTION,"PROGRAM_BATCH_SECTION");
		extendTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_EXTENDTIMETABLE_COURSE_SECTION,"COURSE_SECTION");
		extendTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_EXTENDTIMETABLE_ACADEMIC_TERM,"ACADEMIC_TERM");
		extendTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_EXTENDTIMETABLE_VIEW_SCHEDULES,"VIEW_SCHEDULES");
		extendTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_EXTENDTIMETABLE_GENERATE,"GENERATE");
		extendTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_EXTENDTIMETABLE_IMPORT_EXTENDED_TIME_TABLE,"IMPORT_EXTENDED_TIME_TABLE");
		featurePrivilegesMap.add("EXTEND_TIME_TABLE_PRIVILEGES", extendTimeTablePrivileges);
		
		createApplyForEvaluationGroupPrivileges = new Ext.util.HashMap();
		//createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_VIEW,"VIEW");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_CREATE,"CREATE");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_UPDATE,"UPDATE");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_MOREACTIONS,"MOREACTION");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_APPROVE,"APPROVE");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_WITHDRAWN,"WITHDRAWN");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_EXPORT,"EXPORT");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_HALLTICKETGENERATION,"HALLTICKETGENERATION");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_EXPORT_REPORTS,"EXPORT_REPORTS");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		
		
		//createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_PRINTHALLTICKET,"PRINTHALLTICKET");
		//createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_NOTIFY,"NOTIFY");
		//createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_DOWNLOADAPPLICATION,"DOWNLOADAPPLICATION");
		//createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_DELETE,"DELETE");

		//createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PF_M5_F_APPLYFOREVALUATIONGROUP_VIEW,"VIEW");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PF_M5_F_APPLYFOREVALUATIONGROUP_CREATE,"CREATE");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PF_M5_F_APPLYFOREVALUATIONGROUP_UPDATE,"UPDATE");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PF_M5_F_APPLYFOREVALUATIONGROUP_MOREACTION,"MOREACTION");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PF_M5_F_APPLYFOREVALUATIONGROUP_APPROVE,"APPROVE");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PF_M5_F_APPLYFOREVALUATIONGROUP_WITHDRAWN,"WITHDRAWN");
		//createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PF_M5_F_APPLYFOREVALUATIONGROUP_HALLTICKETGENERATION,"HALLTICKETGENERATION");
		//createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PF_M5_F_APPLYFOREVALUATIONGROUP_PRINTHALLTICKET,"PRINTHALLTICKET");
		//createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PF_M5_F_APPLYFOREVALUATIONGROUP_NOTIFY,"NOTIFY");
		//createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PF_M5_F_APPLYFOREVALUATIONGROUP_DOWNLOADAPPLICATION,"DOWNLOADAPPLICATION");
		//createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PF_M5_F_APPLYFOREVALUATIONGROUP_DELETE,"DELETE");
		
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.SP_M5_F_APPLYFOREVALUATION_VIEW,"VIEW");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.SP_M5_F_APPLYFOREVALUATION_EXPORT,"EXPORT");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.SP_M5_F_APPLYFOREVALUATION_MAKE_PAYMENT,"MAKE_PAYMENT");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.SP_M5_F_APPLYFOREVALUATIONGROUP_DOWNLOAD_FORM,"DOWNLOAD_FORM");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_DOWNLOAD_HALL_TICKETS,"DOWNLOAD_HALL_TICKETS");
		createApplyForEvaluationGroupPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_DOWNLOAD_FORM,"DOWNLOAD_FORM");
		
		featurePrivilegesMap.add("APPLY_FOR_EVALUATION_GROUP_PRIVILEGES", createApplyForEvaluationGroupPrivileges);
		
		createApplyForEvaluationGroupDocumentSubmitPrivileges = new Ext.util.HashMap();
		//createApplyForEvaluationGroupDocumentSubmitPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_DOCUMENTSUBMIT_VIEW,"VIEW");
		createApplyForEvaluationGroupDocumentSubmitPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_DOCUMENTSUBMIT_CREATE,"CREATE");
		//createApplyForEvaluationGroupDocumentSubmitPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_DOCUMENTSUBMIT_UPDATE,"UPDATE");
		//createApplyForEvaluationGroupDocumentSubmitPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_DOCUMENTSUBMIT_DELETE,"DELETE");
		createApplyForEvaluationGroupDocumentSubmitPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_DOCUMENTSUBMIT_EXPORT,"EXPORT");
		
		createApplyForEvaluationGroupDocumentSubmitPrivileges.add(FPCONSTANTS.SP_M5_F_APPLYFOREVALUATION_DOCUMENT_SUBMITTED_VIEW,"VIEW");
		createApplyForEvaluationGroupDocumentSubmitPrivileges.add(FPCONSTANTS.SP_M5_F_APPLYFOREVALUATION_DOCUMENT_SUBMITTED_CREATE,"CREATE");
		createApplyForEvaluationGroupDocumentSubmitPrivileges.add(FPCONSTANTS.SP_M5_F_APPLYFOREVALUATION_DOCUMENT_SUBMITTED_UPDATE,"UPDATE");
		createApplyForEvaluationGroupDocumentSubmitPrivileges.add(FPCONSTANTS.PP_M5_F_APPLYFOREVALUATION_DOCUMENT_SUBMITTED_VIEW,"VIEW");
		createApplyForEvaluationGroupDocumentSubmitPrivileges.add(FPCONSTANTS.PP_M5_F_APPLYFOREVALUATION_DOCUMENT_SUBMITTED_CREATE,"CREATE");
		createApplyForEvaluationGroupDocumentSubmitPrivileges.add(FPCONSTANTS.PP_M5_F_APPLYFOREVALUATION_DOCUMENT_SUBMITTED_UPDATE,"UPDATE");
		featurePrivilegesMap.add("APPLY_FOR_EVALUATION_GROUP_DOCUMENT_SUBMIT_PRIVILEGES", createApplyForEvaluationGroupDocumentSubmitPrivileges);
		
		createApplyForEvaluationGroupCenterAllocationPrivileges = new Ext.util.HashMap();
		//createApplyForEvaluationGroupCenterAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_CENTERALLOCATION_VIEW,"VIEW");
		createApplyForEvaluationGroupCenterAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_CENTERALLOCATION_CREATE,"CREATE");
		//createApplyForEvaluationGroupCenterAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_CENTERALLOCATION_UPDATE,"UPDATE");
		createApplyForEvaluationGroupCenterAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_CENTERALLOCATION_DELETE,"DELETE");
		createApplyForEvaluationGroupCenterAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_CENTERALLOCATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPLY_FOR_EVALUATION_GROUP_CENTER_ALLOCATION_PRIVILEGES", createApplyForEvaluationGroupCenterAllocationPrivileges);
		
		createManageFeePlanPrivileges = new Ext.util.HashMap();
		createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_VIEW,"VIEW");
		createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_EXPORT,"EXPORT");
		createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_DELETE,"DELETE");
		createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_CREATE,"CREATE");
		createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_UPDATE,"UPDATE");
		createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_MOREACTIONS,"MOREACTION");
		createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_APPLICABLEFOR,"APPLICABLEFOR");
		//createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_VIEWUNMAPPED,"VIEWUNMAPPED");
		//createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_VIEWCOVERAGE,"VIEWCOVERAGE");
		createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_APPROVE,"APPROVE");
		createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_FEEUPLOAD,"FEEUPLOAD");
		createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_ASSOCIATESTUDENT,"ASSOCIATESTUDENT");
		createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_PRINT,"PRINT");
		createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_EXPORT_REPORTS,"EXPORT_REPORTS");
		createManageFeePlanPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEFEEPLAN_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		
		featurePrivilegesMap.add("MANAGE_FEE_PLAN_PRIVILEGES", createManageFeePlanPrivileges);
		
		createFeeSequencePrivileges = new Ext.util.HashMap();
		createFeeSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_VIEW,"VIEW");
		//createFeeSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_EXPORT,"EXPORT");
		createFeeSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_DELETE,"DELETE");
		createFeeSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_CREATE,"CREATE");
		createFeeSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_UPDATE,"UPDATE");
		createFeeSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_MOREACTIONS,"MOREACTION");
		createFeeSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_PERSONCOVERED,"PERSONCOVERED");
		createFeeSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_CONFIGUREFEEHEAD,"CONFIGUREFEEHEAD");
		createFeeSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		createFeeSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_COURSE_WISE_EXAM_FEE,"COURSE_WISE_EXAM_FEE");
		createFeeSequencePrivileges.add(FPCONSTANTS.PC_M6_F_FEESEQUENCE_BILLING_APPLICABLE_ON_CHECK_IN,"BILLING_APPLICABLE_ON_CHECK_IN");
		featurePrivilegesMap.add("FEE_SEQUENCE_PRIVILEGES", createFeeSequencePrivileges);

		studentcourseenrollmentPrivileges = new Ext.util.HashMap();
		/*studentcourseenrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENTCOURSEENROLLMENT_CREATE,"CREATE");
		studentcourseenrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENTCOURSEENROLLMENT_UPDATE,"UPDATE");*/
		studentcourseenrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENTCOURSEENROLLMENT_APPROVE,"APPROVE");
		studentcourseenrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENTCOURSEENROLLMENT_EXPORT,"EXPORT");
		studentcourseenrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENTCOURSEENROLLMENT_STUDENTENROLLMENT,"STUDENTENROLLMENT");
		studentcourseenrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENTCOURSEENROLLMENT_COURSEENROLLMENT,"COURSEENROLLMENT");
		studentcourseenrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENTCOURSEENROLLMENT_BULK_ENROLLMENT,"BULK_ENROLLMENT");
		studentcourseenrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENTCOURSEENROLLMENT_PROGRAM_BATCH_SECTION,"PROGRAM_BATCH_SECTION");
		studentcourseenrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENTCOURSEENROLLMENT_COURSE_SECTION,"COURSE_SECTION");
		studentcourseenrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENTCOURSEENROLLMENT_IMPORT_LEGACY_STUDENT_COURSE_ENROLLMENT,"IMPORT_LEGACY_STUDENT_COURSE_ENROLLMENT");
		studentcourseenrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENTCOURSEENROLLMENT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_COURSE_ENROLLMENT_PRIVILEGES_PRIVILEGES", studentcourseenrollmentPrivileges);

		createFeePersonCoveredPrivileges = new Ext.util.HashMap();
		createFeePersonCoveredPrivileges.add(FPCONSTANTS.PC_M6_F_FEEPERSONCOVERED_VIEW,"VIEW");
		//createFeePersonCoveredPrivileges.add(FPCONSTANTS.PC_M6_F_FEEPERSONCOVERED_EXPORT,"EXPORT");
		createFeePersonCoveredPrivileges.add(FPCONSTANTS.PC_M6_F_FEEPERSONCOVERED_DELETE,"DELETE");
		createFeePersonCoveredPrivileges.add(FPCONSTANTS.PC_M6_F_FEEPERSONCOVERED_CREATE,"CREATE");
		createFeePersonCoveredPrivileges.add(FPCONSTANTS.PC_M6_F_FEEPERSONCOVERED_UPDATE,"UPDATE");
		createFeePersonCoveredPrivileges.add(FPCONSTANTS.PC_M6_F_FEEPERSONCOVERED_CHANGEFEERULE,"CHANGEFEERULE");
		featurePrivilegesMap.add("FEE_PERSON_COVERED_PRIVILEGES", createFeePersonCoveredPrivileges);
		
		
		createConfigureFeeHeadPrivileges = new Ext.util.HashMap();
		createConfigureFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_CONFIGUREFEEHEAD_VIEW,"VIEW");
		//createFeeSequencePrivileges.add(FPCONSTANTS.PC_M6_F_CONFIGUREFEEHEAD_EXPORT,"EXPORT");
		createConfigureFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_CONFIGUREFEEHEAD_DELETE,"DELETE");
		createConfigureFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_CONFIGUREFEEHEAD_CREATE,"CREATE");
		createConfigureFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_CONFIGUREFEEHEAD_UPDATE,"UPDATE");
		createConfigureFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_CONFIGUREFEEHEAD_MOREACTIONS,"MOREACTION");
		createConfigureFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_CONFIGUREFEEHEAD_MANAGEDISCOUNT,"MANAGEDISCOUNT");
		createConfigureFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_CONFIGUREFEEHEAD_SCHEDULEPAYMENT,"SCHEDULEPAYMENT");
		createConfigureFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_CONFIGUREFEEHEAD_MANAGEDEPENDENTFEEHEAD,"MANAGEDEPENDENTFEEHEAD");
		createConfigureFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_CONFIGUREFEEHEAD_REFUNDDROOL,"REFUNDDROOL");
		createConfigureFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_CONFIGUREFEEHEAD_MANAGEFINESCHEDULE,"MANAGE_FINE_SCHEDULE");
		featurePrivilegesMap.add("CONFIGURE_FEE_HEAD_PRIVILEGES", createConfigureFeeHeadPrivileges);
		
		
		createManageDiscountPrivileges = new Ext.util.HashMap();
		createManageDiscountPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEDISCOUNT_VIEW,"VIEW");
		//createManageDiscountPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEDISCOUNT_EXPORT,"EXPORT");
		createManageDiscountPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEDISCOUNT_DELETE,"DELETE");
		createManageDiscountPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEDISCOUNT_CREATE,"CREATE");
		createManageDiscountPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEDISCOUNT_UPDATE,"UPDATE");
		featurePrivilegesMap.add("MANAGE_DISCOUNT_PRIVILEGES", createManageDiscountPrivileges);
		
		createDoMappingPrivileges = new Ext.util.HashMap();
		createDoMappingPrivileges.add(FPCONSTANTS.PC_M6_F_FEEDOMAPPING_VIEW,"VIEW");
		createDoMappingPrivileges.add(FPCONSTANTS.PC_M6_F_FEEDOMAPPING_DELETE,"DELETE");
		createDoMappingPrivileges.add(FPCONSTANTS.PC_M6_F_FEEDOMAPPING_CREATE,"CREATE");
		createDoMappingPrivileges.add(FPCONSTANTS.PC_M6_F_FEEDOMAPPING_UPDATE,"UPDATE");
		//createDoMappingPrivileges.add(FPCONSTANTS.PC_M6_F_FEEDOMAPPING_EXPORT,"EXPORT");
		featurePrivilegesMap.add("DO_MAPPING_PRIVILEGES", createDoMappingPrivileges);
		
		
		createManageDependentFeeHeadPrivileges = new Ext.util.HashMap();
		createManageDependentFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEDEPENDENTFEEHEAD_VIEW,"VIEW");
		//createManageDependentFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEDEPENDENTFEEHEAD_EXPORT,"EXPORT");
		createManageDependentFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEDEPENDENTFEEHEAD_DELETE,"DELETE");
		createManageDependentFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEDEPENDENTFEEHEAD_CREATE,"CREATE");
		createManageDependentFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEDEPENDENTFEEHEAD_UPDATE,"UPDATE");
		featurePrivilegesMap.add("MANAGE_DEPENDENT_FEE_HEAD_PRIVILEGES", createManageDependentFeeHeadPrivileges);
		
		createAssignSequencePrivileges = new Ext.util.HashMap();
		//createAssignSequencePrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGNSEQUENCE_VIEW,"VIEW");
		createAssignSequencePrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGNSEQUENCE_EXPORT,"EXPORT");
		createAssignSequencePrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGNSEQUENCE_DELETE,"DELETE");
		createAssignSequencePrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGNSEQUENCE_CREATE,"CREATE");
		createAssignSequencePrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGNSEQUENCE_UPDATE,"UPDATE");
		featurePrivilegesMap.add("ASSIGN_SEQUENCE_PRIVILEGES", createAssignSequencePrivileges);
		
		
		programCourseParameterAssignCoursesPrivileges = new Ext.util.HashMap();
		programCourseParameterAssignCoursesPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEPARAMETER_ASSIGNCOURSE_CREATE,"CREATE");
		programCourseParameterAssignCoursesPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEPARAMETER_ASSIGNCOURSE_UPDATE,"UPDATE");
		programCourseParameterAssignCoursesPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEPARAMETER_ASSIGNCOURSE_DELETE,"DELETE");
		programCourseParameterAssignCoursesPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEPARAMETER_ASSIGNCOURSE_ADDFACULTY,"ADDFACULTY");
		programCourseParameterAssignCoursesPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEPARAMETER_ASSIGNCOURSE_EXPORT,"EXPORT");
		programCourseParameterAssignCoursesPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEPARAMETER_ASSIGNCOURSE_LINK,"LINK");
		programCourseParameterAssignCoursesPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEPARAMETER_ASSIGNCOURSE_GRADE_IMPROVEMENT,"GRADEIMPROVEMENT");
		programCourseParameterAssignCoursesPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEPARAMETER_ASSIGNCOURSE_UPDATE_COURSE_PARAMETER,"UPDATECOURSEPARAMETER");
		featurePrivilegesMap.add("PROGRAM_COURSE_PARAMETER_ASSIGN_COURSE_PRIVILEGES", programCourseParameterAssignCoursesPrivileges);
		
		createGradeMasterGroupPrivileges = new Ext.util.HashMap();
		//createGradeMasterGroupPrivileges.add(FPCONSTANTS.PC_M5_F_GRADEMASTERGROUP_VIEW,"VIEW");
		//createGradeMasterGroupPrivileges.add(FPCONSTANTS.PC_M5_F_GRADEMASTERGROUP_EXPORT,"EXPORT");
		createGradeMasterGroupPrivileges.add(FPCONSTANTS.PC_M5_F_GRADEMASTERGROUP_DELETE,"DELETE");
		createGradeMasterGroupPrivileges.add(FPCONSTANTS.PC_M5_F_GRADEMASTERGROUP_CREATE,"CREATE");
		createGradeMasterGroupPrivileges.add(FPCONSTANTS.PC_M5_F_GRADEMASTERGROUP_UPDATE,"UPDATE");
		createGradeMasterGroupPrivileges.add(FPCONSTANTS.PC_M5_F_GRADEMASTERGROUP_ADDMOREDETAIL,"ADDMOREDETAIL");		
		featurePrivilegesMap.add("GRADE_MASTER_GROUP_PRIVILEGES", createGradeMasterGroupPrivileges);
		
		createEvaluationPlanPrivileges = new Ext.util.HashMap();
		createEvaluationPlanPrivileges.add(FPCONSTANTS.PC_M5_F_EvaluationPlan_VIEW,"VIEW");
		//createEvaluationPlanPrivileges.add(FPCONSTANTS.PC_M5_F_EvaluationPlan_EXPORT,"EXPORT");
		createEvaluationPlanPrivileges.add(FPCONSTANTS.PC_M5_F_EvaluationPlan_DELETE,"DELETE");
		createEvaluationPlanPrivileges.add(FPCONSTANTS.PC_M5_F_EvaluationPlan_CREATE,"CREATE");
		createEvaluationPlanPrivileges.add(FPCONSTANTS.PC_M5_F_EvaluationPlan_UPDATE,"UPDATE");
		createEvaluationPlanPrivileges.add(FPCONSTANTS.PC_M5_F_EvaluationPlan_EXPORT,"EXPORT");
		createEvaluationPlanPrivileges.add(FPCONSTANTS.PC_M5_F_EvaluationPlan_EXPORTREPORTS,"EXPORTREPORTS");
		createEvaluationPlanPrivileges.add(FPCONSTANTS.PC_M5_F_EvaluationPlan_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		//createEvaluationPlanPrivileges.add(FPCONSTANTS.PF_M5_F_EvaluationPlan_VIEW,"VIEW");
		
		createEvaluationPlanPrivileges.add(FPCONSTANTS.SP_M5_F_EVALUATIONPLAN_VIEW,"VIEW");
		createEvaluationPlanPrivileges.add(FPCONSTANTS.SP_M5_F_EVALUATIONPLAN_EXPORT,"EXPORT");
		createEvaluationPlanPrivileges.add(FPCONSTANTS.PP_M5_F_EVALUATIONPLAN_VIEW,"VIEW");
		createEvaluationPlanPrivileges.add(FPCONSTANTS.PP_M5_F_EVALUATIONPLAN_EXPORT,"EXPORT");
		createEvaluationPlanPrivileges.add(FPCONSTANTS.PC_M5_F_COVERAGEPLAN_MAP_UNMAP,"MAP_UNMAP");
		createEvaluationPlanPrivileges.add(FPCONSTANTS.PC_M5_F_COVERAGEPLAN_IMPORT_MAP_UNMAP,"IMPORT_MAP_UNMAP");
		featurePrivilegesMap.add("EVALUATION_PLAN_PRIVILEGES", createEvaluationPlanPrivileges);
		
		createEvaluationPlanApplyRulePrivileges = new Ext.util.HashMap();
		//createEvaluationPlanApplyRulePrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONPLAN_APPLY_RULE_VIEW,"VIEW");
		createEvaluationPlanApplyRulePrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONPLAN_APPLY_RULE_DELETE,"DELETE");
		createEvaluationPlanApplyRulePrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONPLAN_APPLY_RULE_CREATE,"CREATE");
		//createEvaluationPlanApplyRulePrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONPLAN_APPLY_RULE_UPDATE,"UPDATE");
		createEvaluationPlanApplyRulePrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONPLAN_APPLY_RULE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EVALUATION_PLAN_APPLY_RULE_PRIVILEGES", createEvaluationPlanApplyRulePrivileges);
		
		createCoveragePlanPrivileges1 = new Ext.util.HashMap();
		createCoveragePlanPrivileges1.add(FPCONSTANTS.PC_M5_F_COVERAGEPLAN_CREATE,"CREATE");
		createCoveragePlanPrivileges1.add(FPCONSTANTS.PC_M5_F_COVERAGEPLAN_UPDATE,"UPDATE");
		createCoveragePlanPrivileges1.add(FPCONSTANTS.PC_M5_F_COVERAGEPLAN_DELETE,"DELETE");
		createCoveragePlanPrivileges1.add(FPCONSTANTS.PC_M5_F_COVERAGEPLAN_EXPORT,"EXPORT");
		createCoveragePlanPrivileges1.add(FPCONSTANTS.PC_M4_F_COVERAGEPLAN_SAVE,"SAVE");
		
		featurePrivilegesMap.add("COVERAGE_PLAN_PRIVILEGES", createCoveragePlanPrivileges1);
		
		createTransferMarkToGradePrivileges = new Ext.util.HashMap();
		createTransferMarkToGradePrivileges.add(FPCONSTANTS.PC_M5_F_TRANSFERMARKTOGRADE_VIEW,"VIEW");
		createTransferMarkToGradePrivileges.add(FPCONSTANTS.PC_M5_F_TRANSFERMARKTOGRADE_CREATE,"CREATE");
		createTransferMarkToGradePrivileges.add(FPCONSTANTS.PC_M5_F_TRANSFERMARKTOGRADE_UPDATE,"UPDATE");
		createTransferMarkToGradePrivileges.add(FPCONSTANTS.PC_M5_F_TRANSFERMARKTOGRADE_EXPORT,"EXPORT");
		createTransferMarkToGradePrivileges.add(FPCONSTANTS.PC_M5_F_TRANSFERMARKTOGRADE_APPROVE,"APPROVE");
		createTransferMarkToGradePrivileges.add(FPCONSTANTS.PC_M5_F_TRANSFERMARKTOGRADE_MOREACTION,"MOREACTION");
		createTransferMarkToGradePrivileges.add(FPCONSTANTS.PC_M5_F_TRANSFERMARKTOGRADE_SAVE,"SAVE");
		createTransferMarkToGradePrivileges.add(FPCONSTANTS.PF_M5_F_TRANSFERMARKTOGRADE_VIEW,"VIEW");
		createTransferMarkToGradePrivileges.add(FPCONSTANTS.PF_M5_F_TRANSFERMARKTOGRADE_CREATE,"CREATE");
		createTransferMarkToGradePrivileges.add(FPCONSTANTS.PF_M5_F_TRANSFERMARKTOGRADE_UPDATE,"UPDATE");
		createTransferMarkToGradePrivileges.add(FPCONSTANTS.PC_M5_F_TRANSFERMARKTOGRADE_GRADE_DISTRIBUTION_EXPORT,"GRADE_DISTRIBUTION_EXPORT");
		createTransferMarkToGradePrivileges.add(FPCONSTANTS.PC_M5_F_TRANSFERMARKTOGRADE_RESET_GRADE_STATUS,"RESET_GRADE_STATUS");
		
		featurePrivilegesMap.add("TRANSFER_MARK_TO_GRADE_PRIVILEGES", createTransferMarkToGradePrivileges);
		
		createExaminationResultsPrivileges = new Ext.util.HashMap();
		//createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_VIEW,"VIEW");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_CREATE,"CREATE");
		//createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_UPDATE,"UPDATE");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_EXPORT,"EXPORT");
		//createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_MOREACTIONS,"MOREACTIONS");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_APPROVE,"APPROVE");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_SENTFORAPPROVE,"SENTFORAPPROVE");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_GENERATE_FOILS,"GENERATEFOILS");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PF_M5_F_EXAMINATIONRESULTS_VIEW,"VIEW");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PF_M5_F_EXAMINATIONRESULTS_CREATE,"CREATE");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PF_M5_F_EXAMINATIONRESULTS_UPDATE,"UPDATE");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_IMPORT_BULK_MARKS,"IMPORT_BULK_MARKS");
		
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_GRID_EDIT_BTN,"GRID_EDIT_BTN")
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_GRID_VIEW_BTN,"GRID_VIEW_BTN")
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_SAVE,"SAVE");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_GRID_MARK_ATTENDANCE_BTN,"MARK_ATTENDANCE_BTN");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_ANONYMOUS_ASSESSMENT_EVENT,"ANONYMOUS_ASSESSMENT_EVENT");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_DELETE,"DELETE");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_SET_DEFAULT_MARKS,"SET_DEFAULT_MARKS");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_SET_DEFAULT_GRADE,"SET_DEFAULT_GRADE");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_ENTER_REMARK,"ENTER_REMARK");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_PUBLISH_MARKS_GRADE,"PUBLISH_MARKS_GRADE");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_IMPORT_EXTERNAL_EXAM,"IMPORT_EXTERNAL_EXAM");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_IMPORT_LEGACY_MARKS,"IMPORT_LEGACY_MARKS");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_IMPORT_EXAM_ATTENDANCE,"IMPORT_EXAM_ATTENDANCE");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_IMPORT_MARKS_WITH_MODERATION_MARKS,"IMPORT_MARKS_WITH_MODERATION_MARKS");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_UNPUBLISH_MARKS_GRADE,"UNPUBLISH_MARKS_GRADE");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_IMPORT_MARKS_REMARKS,"IMPORT_MARKS_REMARKS");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_HOST_FACULTY,"MARK_ENTRY_AS_HOST_FACULTY");
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_CHECK_HISTORY,"CHECK_HISTORY");
		/*createExaminationResultsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_VIEW,"VIEW");
		createExaminationResultsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_EXPORT,"EXPORT");
		createExaminationResultsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_UPDATE,"UPDATE");
		//createExaminationResultsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_MOREACTIONS,"MOREACTIONS");
		createExaminationResultsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_APPROVE,"APPROVE");
		createExaminationResultsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_SAVEBUTTON,"SAVEBUTTON");
		createExaminationResultsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_SUBMIT,"SUBMIT");
		//createExaminationResultsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_SENTFORAPPROVE,"SENTFORAPPROVE");
		createExaminationResultsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_IMPORT_BULK_MARKS,"IMPORT_BULK_MARKS");*/
		
		createExaminationResultsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATIONRESULTS_IMPORT_HOMEWORK_ASSIGNMENT_MARK_REMARK,"IMPORT_HOMEWORK_ASSIGNMENT_MARK_REMARK");
		featurePrivilegesMap.add("EXAMINATION_RESULTS_PRIVILEGES", createExaminationResultsPrivileges);
		
		createCenterUnavailabilityPrivileges = new Ext.util.HashMap();
		//createCenterUnavailabilityPrivileges.add(FPCONSTANTS.PC_M5_F_CENTERUNAVAILABILITY_VIEW,"VIEW");
		createCenterUnavailabilityPrivileges.add(FPCONSTANTS.PC_M5_F_CENTERUNAVAILABILITY_CREATE,"CREATE");
		createCenterUnavailabilityPrivileges.add(FPCONSTANTS.PC_M5_F_CENTERUNAVAILABILITY_UPDATE,"UPDATE");
		createCenterUnavailabilityPrivileges.add(FPCONSTANTS.PC_M5_F_CENTERUNAVAILABILITY_DELETE,"DELETE");
		createCenterUnavailabilityPrivileges.add(FPCONSTANTS.PC_M5_F_CENTERUNAVAILABILITY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CENTER_UNAVAILABILITY_PRIVILEGES", createCenterUnavailabilityPrivileges);
		
		/********************************SETUP MODULE*************************************/
		
		/************** Manage Document Type ************/
		manageTemplateTypePrivileges = new Ext.util.HashMap();
		manageTemplateTypePrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_TEMPLATE_CREATE,"CREATE");
		manageTemplateTypePrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_TEMPLATE_VIEW,"VIEW");
		manageTemplateTypePrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_TEMPLATE_EXPORT,"EXPORT");
		manageTemplateTypePrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_TEMPLATE_UPDATE,"UPDATE");
		manageTemplateTypePrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_TEMPLATE_DELETE,"DELETE");
		featurePrivilegesMap.add("MANAGE_DOCUMENT_TYPE_PRIVILEGES", manageTemplateTypePrivileges);
		
		/************** Manage Document Master ************/
		documentMasterPrivileges = new Ext.util.HashMap();
		documentMasterPrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_MASTER_CREATE,"CREATE");
		documentMasterPrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_MASTER_VIEW,"VIEW");
		documentMasterPrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_MASTER_UPDATE,"UPDATE");
		documentMasterPrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_MASTER_DELETE,"DELETE");
		featurePrivilegesMap.add("DOCUMENT_MASTER_PRIVILEGES", documentMasterPrivileges);
		
		/************** Manage Calendar Master ************/
		calendarMasterPrivileges = new Ext.util.HashMap();
		calendarMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CALENDARS_CREATE,"CREATE");
		calendarMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CALENDARS_VIEW,"VIEW");
		calendarMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CALENDARS_VIEW_CALENDAR,"VIEW_CALENDAR");
		calendarMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CALENDARS_UPDATE,"UPDATE");
		calendarMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CALENDARS_DELETE,"DELETE");
		calendarMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CALENDARS_MOREACTIONS,"MOREACTIONS");
		calendarMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CALENDARS_ENTITY_LIST,"ENTITY_LIST");
		calendarMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CALENDARS_MAP_ACADEMY_LOCATIONS,"MAP_ACADEMY_LOCATIONS");
		featurePrivilegesMap.add("CALENDAR_MASTER_PRIVILEGES", calendarMasterPrivileges);
		
		
		/************** Manage Template ************/
		manageTemplatePrivileges = new Ext.util.HashMap();
		manageTemplatePrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_MANAGE_TEMPLATE_CREATE,"CREATE");
		manageTemplatePrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_MANAGE_TEMPLATE_VIEW,"VIEW");
		manageTemplatePrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_MANAGE_TEMPLATE_EXPORT,"EXPORT");
		manageTemplatePrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_MANAGE_TEMPLATE_UPDATE,"UPDATE");
		manageTemplatePrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_MANAGE_TEMPLATE_DELETE,"DELETE");
		manageTemplatePrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_MANAGE_TEMPLATE_DEFAULTTEMPLATE,"DEFAULTTEMPLATE");
		featurePrivilegesMap.add("MANAGE_TEMPLATE_PRIVILEGES", manageTemplatePrivileges);
		
		/************** Document Template  Mapping************/
		documentTemplateMappingPrivileges = new Ext.util.HashMap();
		documentTemplateMappingPrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_TEMPLATE_MAPPING_CREATE,"CREATE");
		documentTemplateMappingPrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_TEMPLATE_MAPPING_VIEW,"VIEW");
		documentTemplateMappingPrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_TEMPLATE_MAPPING_EXPORT,"EXPORT");
		documentTemplateMappingPrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_TEMPLATE_MAPPING_UPDATE,"UPDATE");
		documentTemplateMappingPrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_TEMPLATE_MAPPING_DELETE,"DELETE");
		documentTemplateMappingPrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_TEMPLATE_MAPPING_APPLICABLEFOR,"APPLICABLEFOR");
		featurePrivilegesMap.add("DOCUMENT_TEMPLATE_MAPPING_PRIVILEGES", documentTemplateMappingPrivileges);
		
		/************** Document Group  Master************/
		documentGroupMasterPrivileges = new Ext.util.HashMap();
		documentGroupMasterPrivileges.add(FPCONSTANTS.PC_M12_F_DOCUMENT_GROUP_MASTER_VIEW,"VIEW");
		featurePrivilegesMap.add("DOCUMENT_GROUP_MAPPING_PRIVILEGES", documentGroupMasterPrivileges);
		
		/************** Messaging Template ************/
		messagingTemplatePrivileges = new Ext.util.HashMap();
		messagingTemplatePrivileges.add(FPCONSTANTS.PC_M12_F_MESSAGING_TEMPLATE_CREATE,"CREATE");
		messagingTemplatePrivileges.add(FPCONSTANTS.PC_M12_F_MESSAGING_TEMPLATE_VIEW,"VIEW");
		messagingTemplatePrivileges.add(FPCONSTANTS.PC_M12_F_MESSAGING_TEMPLATE_REVIEW,"REVIEW");
		messagingTemplatePrivileges.add(FPCONSTANTS.PC_M12_F_MESSAGING_TEMPLATE_UPDATE,"UPDATE");
		messagingTemplatePrivileges.add(FPCONSTANTS.PC_M12_F_MESSAGING_TEMPLATE_DELETE,"DELETE");
		messagingTemplatePrivileges.add(FPCONSTANTS.PC_M12_F_MESSAGING_TEMPLATE_ENABLE,"ENABLE");
		featurePrivilegesMap.add("MESSAGING_TEMPLATE_PRIVILEGES", messagingTemplatePrivileges);
		
		/************** System Message Event ************/
		systemMessageEventPrivileges = new Ext.util.HashMap();
		systemMessageEventPrivileges.add(FPCONSTANTS.PC_M12_F_MESSAGING_SYSTEM_EVENT_CREATE,"CREATE");
		systemMessageEventPrivileges.add(FPCONSTANTS.PC_M12_F_MESSAGING_SYSTEM_EVENT_UPDATE,"UPDATE");
		systemMessageEventPrivileges.add(FPCONSTANTS.PC_M12_F_MESSAGING_SYSTEM_EVENT_MOREACTIONS,"MOREACTIONS");
		systemMessageEventPrivileges.add(FPCONSTANTS.PC_M12_F_MESSAGING_SYSTEM_EVENT_VIEW,"VIEW");
		featurePrivilegesMap.add("SYSTEM_MESSAGE_EVENT_PRIVILEGES", systemMessageEventPrivileges);
		
		/************** System Message Event Report ************/
		systemMessageEventReportPrivileges = new Ext.util.HashMap();
		systemMessageEventReportPrivileges.add(FPCONSTANTS.PC_M12_R_SYSTEM_MSG_EVENT_REPORT_VIEW,"VIEW");
		systemMessageEventReportPrivileges.add(FPCONSTANTS.PC_M12_R_SYSTEM_MSG_EVENT_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("SYSTEM_MESSAGE_EVENT_REPORT_PRIVILEGES", systemMessageEventReportPrivileges);
		
		/**************Adhoc Messaging  ************/
		adhocMessagingPrivileges = new Ext.util.HashMap();
		adhocMessagingPrivileges.add(FPCONSTANTS.PC_M12_F_ADHOC_MESSAGE_CREATE,"CREATE");
		adhocMessagingPrivileges.add(FPCONSTANTS.PC_M12_F_ADHOC_MESSAGE_VIEW,"VIEW");
		adhocMessagingPrivileges.add(FPCONSTANTS.PC_M12_F_ADHOC_MESSAGE_REVIEW,"REVIEW");
		adhocMessagingPrivileges.add(FPCONSTANTS.PC_M12_F_ADHOC_MESSAGE_UPDATE,"UPDATE");
		adhocMessagingPrivileges.add(FPCONSTANTS.PC_M12_F_ADHOC_MESSAGE_DELETE,"DELETE");
		adhocMessagingPrivileges.add(FPCONSTANTS.PC_M12_F_ADHOC_MESSAGE_EXPORT,"EXPORT");
		adhocMessagingPrivileges.add(FPCONSTANTS.PC_M12_F_ADHOC_MESSAGE_CANCEL,"CANCEL_ADHOC_MESSAGE");
		featurePrivilegesMap.add("ADHOC_MESSAGING_PRIVILEGES", adhocMessagingPrivileges);
		
		/**************Adhoc Messaging Report ************/
		adhocMessagingReportPrivileges = new Ext.util.HashMap();
		adhocMessagingReportPrivileges.add(FPCONSTANTS.PC_M12_R_ADHOC_MSG_REPORT_VIEW,"VIEW");
		adhocMessagingReportPrivileges.add(FPCONSTANTS.PC_M12_R_ADHOC_MSG_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("ADHOC_MESSAGING_REPORT_PRIVILEGES", adhocMessagingReportPrivileges);
		
		/**************Message Sent Report ************/
		messageSentReportPrivileges = new Ext.util.HashMap();
		messageSentReportPrivileges.add(FPCONSTANTS.PC_M12_R_MESSAGE_SENT_REPORT_VIEW,"VIEW");
		messageSentReportPrivileges.add(FPCONSTANTS.PC_M12_R_MESSAGE_SENT_REPORT_EXPORT_REPORTS,"EXPORT_REPORTS");
		messageSentReportPrivileges.add(FPCONSTANTS.PC_M12_R_MESSAGE_SENT_REPORT_UNBLOCK,"UNBLOCK");
		
		featurePrivilegesMap.add("PC_M12_R_MESSAGE_SENT_REPORT_PRIVILEGES", messageSentReportPrivileges);
		
				/************** for attendance master setting ************/
		attendanceSettingPrivileges = new Ext.util.HashMap();
		attendanceSettingPrivileges.add(FPCONSTANTS.PC_M12_F_ATTENDANCESETTING_CREATE,"CREATE");
		attendanceSettingPrivileges.add(FPCONSTANTS.PC_M12_F_ATTENDANCESETTING_UPDATE,"UPDATE");
		attendanceSettingPrivileges.add(FPCONSTANTS.PC_M12_F_ATTENDANCESETTING_DELETE,"DELETE");
		featurePrivilegesMap.add("ATTENDANCE_SETTINGS_PRIVILEGES", attendanceSettingPrivileges);
		
		feeLedgerMasterPrivileges = new Ext.util.HashMap();
		feeLedgerMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FEESLEDGERMASTER_VIEW,"VIEW");
		feeLedgerMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FEESLEDGERMASTER_CREATE,"CREATE");
		feeLedgerMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FEESLEDGERMASTER_UPDATE,"UPDATE");
		feeLedgerMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FEESLEDGERMASTER_DELETE,"DELETE");
		featurePrivilegesMap.add("FEES_LEDGER_MASTER_PRIVILEGES", feeLedgerMasterPrivileges);
		
		dataSettingsPrivileges = new Ext.util.HashMap();
		dataSettingsPrivileges.add(FPCONSTANTS.PC_M12_F_DATASETTINGS_VIEW,"VIEW");
		featurePrivilegesMap.add("DATASETTINGS_PRIVILEGES", dataSettingsPrivileges);
		
		
		/************************** For Facilities & Master *********************************/
		
		/****** For Facilities Master***********/
		facilitiesMasterPrivileges = new Ext.util.HashMap();
		facilitiesMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_FACILITIES_VIEW,"VIEW");
		facilitiesMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_FACILITIES_MOREACTIONS,"MOREACTIONS");
		facilitiesMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_FACILITIES_UPDATE,"UPDATE");
		facilitiesMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_FACILITIES_DELETE,"DELETE");
		facilitiesMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_FACILITIES_EXPORT_REPORTS,"EXPORT_REPORTS");
		facilitiesMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_FACILITIES_RESET,"RESET");
		featurePrivilegesMap.add("FACILITIES_RESOURCES_FACILITIES_PRIVILEGES", facilitiesMasterPrivileges);
		
		/****** For Hostel Master***********/
		hostelMasterPrivileges = new Ext.util.HashMap();
		hostelMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDMASTER_HOSTEL_CREATE,"CREATE");
		hostelMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDMASTER_HOSTEL_VIEW,"VIEW");
		hostelMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDMASTER_HOSTEL_UPDATE,"UPDATE");
		hostelMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDMASTER_HOSTEL_DELETE,"DELETE");
		hostelMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDMASTER_HOSTEL_RESET,"RESET");
		featurePrivilegesMap.add("FACILITIES_MASTER_HOSTEL_PRIVILEGES", hostelMasterPrivileges);
		
		/****** For Equipment Master***********/
		equipmentMasterPrivileges = new Ext.util.HashMap();
		equipmentMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_EQUIPMENT_VIEW,"VIEW");
		equipmentMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_EQUIPMENT_CREATE,"CREATE");
		equipmentMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_EQUIPMENT_UPDATE,"UPDATE");
		equipmentMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_EQUIPMENT_DELETE,"DELETE");
		equipmentMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_EQUIPMENT_RESET,"RESET");

		featurePrivilegesMap.add("FACILITIES_RESOURCES_EQUIPMENT_PRIVILEGES", equipmentMasterPrivileges);
		
		/****** For External Resource Master***********/
		externalResourceMasterPrivileges = new Ext.util.HashMap();
		externalResourceMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_EXTERNALRES_VIEW,"VIEW");
		externalResourceMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_EXTERNALRES_MOREACTIONS,"MOREACTIONS");
		externalResourceMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_EXTERNALRES_UPDATE,"UPDATE");
		externalResourceMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_EXTERNALRES_DELETE,"DELETE");
		externalResourceMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDRESOURCES_EXTERNALRES_RESET, "RESET");
		featurePrivilegesMap.add("FACILITIES_RESOURCES_EXTERNALRES_PRIVILEGES", externalResourceMasterPrivileges);
		/****************For Import Facility and Master **************/
		importFacilityAndMasterPrivileges = new Ext.util.HashMap();
		importFacilityAndMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDMASTER_VIEW,"VIEW");
		importFacilityAndMasterPrivileges.add(FPCONSTANTS.PC_M12_F_FACILITIESANDMASTER_BULK_IMPORT,"IMPORT_F_N_M");
		featurePrivilegesMap.add("IMPORT_FACILITY_AND_MASTER_PRIVILEGES",importFacilityAndMasterPrivileges);
		
		/****** For Standard Master***********/
		standardMasterPrivileges = new Ext.util.HashMap();
		standardMasterPrivileges.add(FPCONSTANTS.PC_M12_F_STANDARDMASTER_VIEW,"VIEW");
		standardMasterPrivileges.add(FPCONSTANTS.PC_M12_F_STANDARDMASTER_CREATE,"CREATE");
		standardMasterPrivileges.add(FPCONSTANTS.PC_M12_F_STANDARDMASTER_UPDATE,"UPDATE");
		standardMasterPrivileges.add(FPCONSTANTS.PC_M12_F_STANDARDMASTER_DELETE,"DELETE");
		standardMasterPrivileges.add(FPCONSTANTS.PC_M12_F_STANDARDMASTER_Export,"Export");
		featurePrivilegesMap.add("STANDARD_MASTER_PRIVILEGES", standardMasterPrivileges);
		
		/****** For Create Survey***********/
		createSurveyPrivileges = new Ext.util.HashMap();
		createSurveyPrivileges.add(FPCONSTANTS.PC_M12_F_CREATESURVEY_VIEW,"VIEW");
		createSurveyPrivileges.add(FPCONSTANTS.PC_M12_F_CREATESURVEY_CREATE,"CREATE");
		createSurveyPrivileges.add(FPCONSTANTS.PC_M12_F_CREATESURVEY_UPDATE,"UPDATE");
		createSurveyPrivileges.add(FPCONSTANTS.PC_M12_F_CREATESURVEY_GRID_VIEW_BTN,"GRID_VIEW_BTN");
		createSurveyPrivileges.add(FPCONSTANTS.PC_M12_F_CREATESURVEY_DELETE,"DELETE");
		createSurveyPrivileges.add(FPCONSTANTS.PC_M12_F_CREATESURVEY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CREATE_SURVEY_PRIVILEGES", createSurveyPrivileges);
		
		/****** For Send Survey***********/
		sendSurveyPrivileges = new Ext.util.HashMap();
		sendSurveyPrivileges.add(FPCONSTANTS.PC_M12_F_SENDSURVEY_VIEW,"VIEW");
		sendSurveyPrivileges.add(FPCONSTANTS.PC_M12_F_SENDSURVEY_CREATE_NEW_SURVEY,"CREATE_NEW_SURVEY");
		sendSurveyPrivileges.add(FPCONSTANTS.PC_M12_F_SENDSURVEY_ACTIVATE_SURVEY,"ACTIVATE_SURVEY");
		sendSurveyPrivileges.add(FPCONSTANTS.PC_M12_F_SENDSURVEY_GET_PARTICIPANTS,"GET_PARTICIPANTS");
		sendSurveyPrivileges.add(FPCONSTANTS.PC_M12_F_SENDSURVEY_SENDSURVEY,"SENDSURVEY");
		sendSurveyPrivileges.add(FPCONSTANTS.PC_M12_F_SENDSURVEY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("SEND_SURVEY_PRIVILEGES", sendSurveyPrivileges);
		
		/****** For Survey Report Master***********/
		surveyReportPrivileges = new Ext.util.HashMap();
		surveyReportPrivileges.add(FPCONSTANTS.PC_M12_F_SURVEYREPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("SURVEY_REPORT_PRIVILEGES", surveyReportPrivileges);
		
		/****** For Bank Master***********/
		bankMasterPrivileges = new Ext.util.HashMap();
		bankMasterPrivileges.add(FPCONSTANTS.PC_M12_F_BANKMASTER_VIEW,"VIEW");
		bankMasterPrivileges.add(FPCONSTANTS.PC_M12_F_BANKMASTER_CREATE,"CREATE");
		bankMasterPrivileges.add(FPCONSTANTS.PC_M12_F_BANKMASTER_UPDATE,"UPDATE");
		featurePrivilegesMap.add("BANK_MASTER_PRIVILEGES", bankMasterPrivileges);
		
		/****** For Certificate Master***********/
		certificateMasterPrivileges = new Ext.util.HashMap();
		certificateMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CERTIFICATEMASTER_VIEW,"VIEW");
		certificateMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CERTIFICATEMASTER_CREATE,"CREATE");
		certificateMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CERTIFICATEMASTER_UPDATE,"UPDATE");
		featurePrivilegesMap.add("CERTIFICATE_MASTER_PRIVILEGES", certificateMasterPrivileges);
		
		/****** For Currency Master***********/
	    currencyMasterPrivileges = new Ext.util.HashMap();
	    currencyMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CURRENCYMASTER_CURRENCYSETUPTAB, "CURRENCYSETUPTAB");
	    currencyMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CURRENCYMASTER_SETUPEXCHANGERATECM, "SETUPEXCHANGERATECM");
	    currencyMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CURRENCYMASTER_ASSOCIATEINVOICECM,"ASSOCIATEINVOICECM");
		featurePrivilegesMap.add("CURRENCY_MASTER_PRIVILEGES", currencyMasterPrivileges);
		
		/****** For Exchange Rate Currency Master***********/
		exchangeRateCurrencyMasterPrivileges = new Ext.util.HashMap();
		exchangeRateCurrencyMasterPrivileges.add(FPCONSTANTS.PC_M12_F_EXCHANGERATECURRENCYMASTER_VIEW,"VIEW");
		exchangeRateCurrencyMasterPrivileges.add(FPCONSTANTS.PC_M12_F_EXCHANGERATECURRENCYMASTER_CREATE,"CREATE");
		exchangeRateCurrencyMasterPrivileges.add(FPCONSTANTS.PC_M12_F_EXCHANGERATECURRENCYMASTER_UPDATE,"UPDATE");
		exchangeRateCurrencyMasterPrivileges.add(FPCONSTANTS.PC_M12_F_EXCHANGERATECURRENCYMASTER_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXCHANGE_RATECURRENCY_MASTER_PRIVILEGES", exchangeRateCurrencyMasterPrivileges);
		
		/****** For Associate Invoice Currency Master***********/
		associateInvoicecurrencyMasterPrivileges = new Ext.util.HashMap();
		associateInvoicecurrencyMasterPrivileges.add(FPCONSTANTS.PC_M12_F_ASSOCIATEINVOICECURRENCYMASTER_VIEW,"VIEW");
		associateInvoicecurrencyMasterPrivileges.add(FPCONSTANTS.PC_M12_F_ASSOCIATEINVOICECURRENCYMASTER_CREATE,"CREATE");
		associateInvoicecurrencyMasterPrivileges.add(FPCONSTANTS.PC_M12_F_ASSOCIATEINVOICECURRENCYMASTER_UPDATE,"UPDATE");
		associateInvoicecurrencyMasterPrivileges.add(FPCONSTANTS.PC_M12_F_ASSOCIATEINVOICECURRENCYMASTER_EXPORT,"EXPORT");
		featurePrivilegesMap.add("ASSOCIATEINVOICE_CURRENCY_MASTER_PRIVILEGES", associateInvoicecurrencyMasterPrivileges);
		
		/****** For Community Master***********/
		communityMasterPrivileges = new Ext.util.HashMap();
		communityMasterPrivileges.add(FPCONSTANTS.PC_M12_F_COMMUNITIESMASTER_VIEW,"VIEW");
		communityMasterPrivileges.add(FPCONSTANTS.PC_M12_F_COMMUNITIESMASTER_CREATE,"CREATE");
		communityMasterPrivileges.add(FPCONSTANTS.PC_M12_F_COMMUNITIESMASTER_DELETE,"DELETE");
		featurePrivilegesMap.add("COMMUNITY_MASTER_PRIVILEGES", communityMasterPrivileges);
		
		/****** For Deficit Credit Master***********/
		deficitCreditMasterPrivileges = new Ext.util.HashMap();
		deficitCreditMasterPrivileges.add(FPCONSTANTS.PC_M12_F_DEFICITMASTER_VIEW,"VIEW");
		deficitCreditMasterPrivileges.add(FPCONSTANTS.PC_M12_F_DEFICITMASTER_CREATE,"CREATE");
		deficitCreditMasterPrivileges.add(FPCONSTANTS.PC_M12_F_DEFICITMASTER_UPDATE,"UPDATE");
		deficitCreditMasterPrivileges.add(FPCONSTANTS.PC_M12_F_DEFICITMASTER_DELETE,"DELETE");
		featurePrivilegesMap.add("DEFICIT_CREDIT_MASTER_PRIVILEGES", deficitCreditMasterPrivileges);
		
		/****** For Service Master***********/
		serviceMasterPrivileges = new Ext.util.HashMap();
		serviceMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SERVICEMASTER_VIEW,"VIEW");
		serviceMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SERVICEMASTER_CREATE,"CREATE");
		serviceMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SERVICEMASTER_UPDATE,"UPDATE");
		serviceMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SERVICEMASTER_DELETE,"DELETE");
		serviceMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SERVICEMASTER_APPLY_TO, "APPLY_TO");
		featurePrivilegesMap.add("SERVICE_MASTER_PRIVILEGES", serviceMasterPrivileges);
		
		/****** For Request Status Master***********/
		requestStatusMasterPrivileges = new Ext.util.HashMap();
		requestStatusMasterPrivileges.add(FPCONSTANTS.PC_M12_F_REQUEST_STATUS_MASTER_VIEW,"VIEW");
		requestStatusMasterPrivileges.add(FPCONSTANTS.PC_M12_F_REQUEST_STATUS_MASTER_CREATE,"CREATE");
		requestStatusMasterPrivileges.add(FPCONSTANTS.PC_M12_F_REQUEST_STATUS_MASTER_UPDATE,"UPDATE");
		requestStatusMasterPrivileges.add(FPCONSTANTS.PC_M12_F_REQUEST_STATUS_MASTER_DELETE,"DELETE");
		featurePrivilegesMap.add("REQUEST_STATUS_MASTER_PRIVILEGES", requestStatusMasterPrivileges);
		
		/****** For Organization Structure***********/
		organizationStructurePrivileges = new Ext.util.HashMap();
		organizationStructurePrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_VIEW,"VIEW");
		organizationStructurePrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_CREATE,"CREATE");
		organizationStructurePrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_UPDATE,"UPDATE");
		organizationStructurePrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_DELETE,"DELETE");
		featurePrivilegesMap.add("ORGANIZATION_STRUCTURE_PRIVILEGES", organizationStructurePrivileges);
		
		/****** For Organization Department***********/
		organizationDepartmentPrivileges = new Ext.util.HashMap();
		organizationDepartmentPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATION_DEPARMENT_VIEW,"VIEW");
		organizationDepartmentPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATION_DEPARMENT_CREATE,"CREATE");
		organizationDepartmentPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATION_DEPARMENT_UPDATE,"UPDATE");
		organizationDepartmentPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATION_DEPARMENT_DELETE,"DELETE");
		organizationDepartmentPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATION_DEPARMENT_MOREACTIONS,"MOREACTIONS");
		organizationDepartmentPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATION_DEPARMENT_COPY,"COPY");
		featurePrivilegesMap.add("ORGANIZATION_DEPARTMENT_PRIVILEGES", organizationDepartmentPrivileges);
		
		/****** For Organization Sub Department***********/
		organizationSubDepartmentPrivileges = new Ext.util.HashMap();
		organizationSubDepartmentPrivileges.add(FPCONSTANTS.PC_M12_F_SUB_DEPARMENT_VIEW,"VIEW");
		organizationSubDepartmentPrivileges.add(FPCONSTANTS.PC_M12_F_SUB_DEPARMENT_UPDATE,"CREATE");
		organizationSubDepartmentPrivileges.add(FPCONSTANTS.PC_M12_F_SUB_DEPARMENT_CREATE,"UPDATE");
		organizationSubDepartmentPrivileges.add(FPCONSTANTS.PC_M12_F_SUB_DEPARMENT_DELETE,"DELETE");
		featurePrivilegesMap.add("ORGANIZATION_SUB_DEPARTMENT_PRIVILEGES", organizationSubDepartmentPrivileges);
		
		/****** For Custom Field***********/
		customFieldPrivileges = new Ext.util.HashMap();
		customFieldPrivileges.add(FPCONSTANTS.PC_M12_F_CUSTOMFIELDS_VIEW,"VIEW");
		customFieldPrivileges.add(FPCONSTANTS.PC_M12_F_CUSTOMFIELDS_CREATE,"CREATE");
		customFieldPrivileges.add(FPCONSTANTS.PC_M12_F_CUSTOMFIELDS_UPDATE,"UPDATE");
		customFieldPrivileges.add(FPCONSTANTS.PC_M12_F_CUSTOMFIELDS_DELETE,"DELETE");
		featurePrivilegesMap.add("CUSTOM_FIELDS_PRIVILEGES", customFieldPrivileges);
		
		/****** For Custom Category***********/
		customCategoryPrivileges = new Ext.util.HashMap();
		customCategoryPrivileges.add(FPCONSTANTS.PC_M12_F_CUSTOMCATEGORIES_VIEW,"VIEW");
		customCategoryPrivileges.add(FPCONSTANTS.PC_M12_F_CUSTOMCATEGORIES_CREATE,"CREATE");
		customCategoryPrivileges.add(FPCONSTANTS.PC_M12_F_CUSTOMCATEGORIES_UPDATE,"UPDATE");
		customCategoryPrivileges.add(FPCONSTANTS.PC_M12_F_CUSTOMCATEGORIES_DELETE,"DELETE");
		featurePrivilegesMap.add("CUSTOM_CATEGORIES_PRIVILEGES", customCategoryPrivileges);
		
		/****** For Completion Setting***********/
		completionSettingPrivileges = new Ext.util.HashMap();
		completionSettingPrivileges.add(FPCONSTANTS.PC_M12_F_COMPLETIONSETTINGS_VIEW,"VIEW");
		completionSettingPrivileges.add(FPCONSTANTS.PC_M12_F_COMPLETIONSETTINGS_CREATE,"CREATE");
		completionSettingPrivileges.add(FPCONSTANTS.PC_M12_F_COMPLETIONSETTINGS_UPDATE,"UPDATE");
		completionSettingPrivileges.add(FPCONSTANTS.PC_M12_F_COMPLETIONSETTINGS_DELETE,"DELETE");
		completionSettingPrivileges.add(FPCONSTANTS.PC_M12_F_COMPLETIONSETTINGS_MAPCHECKLIST,"MAPCHECKLIST");
		completionSettingPrivileges.add(FPCONSTANTS.PC_M12_F_COMPLETIONSETTINGS_MAPCERTIFICATE,"MAPCERTIFICATE");
		featurePrivilegesMap.add("COMPLETION_SETTING_PRIVILEGES", completionSettingPrivileges);
		
		/****** For Login page setup***********/
		availabilitySettingPrivileges = new Ext.util.HashMap();
		availabilitySettingPrivileges.add(FPCONSTANTS.PC_M12_F_AVAILABILITY_SETTING_VIEW,"VIEW");
		featurePrivilegesMap.add("AVAILABILITY_SETTING_PRIVILEGES", availabilitySettingPrivileges);
		
		/****** For Login page setup***********/
		loginPageSetupPrivileges = new Ext.util.HashMap();
		loginPageSetupPrivileges.add(FPCONSTANTS.PC_M12_F_LOGIN_PAGE_SETUP_VIEW,"VIEW");
		featurePrivilegesMap.add("LOGIN_PAGE_SETUP_PRIVILEGES", loginPageSetupPrivileges);
		
		/****** For Sponsor Companies***********/
		sponsorshipMasterPrivileges = new Ext.util.HashMap();
		sponsorshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORCOMPANY_VIEW,"VIEW");
		sponsorshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORCOMPANY_CREATE,"CREATE");
		sponsorshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORCOMPANY_UPDATE,"UPDATE");
		sponsorshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORCOMPANY_DELETE,"DELETE");
		sponsorshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORCOMPANY_EXPORT,"EXPORT");
		sponsorshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORCOMPANY_MOREACTIONS,"MOREACTIONS");
		sponsorshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORCOMPANY_MANAGE_QUOTATION,"MANAGE_QUOTATION");
		featurePrivilegesMap.add("SPONSOR_COMPANIES_PRIVILEGES", sponsorshipMasterPrivileges);
		

		/****** For Sponsor Master Contract Person***********/
		sponsorshipMasterConPerPrivileges = new Ext.util.HashMap();
		sponsorshipMasterConPerPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORMASTERCONTRACTPERSON_VIEW,"VIEW");
		sponsorshipMasterConPerPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORMASTERCONTRACTPERSON_CREATE,"CREATE");
		sponsorshipMasterConPerPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORMASTERCONTRACTPERSON_UPDATE,"UPDATE");
		sponsorshipMasterConPerPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORMASTERCONTRACTPERSON_DELETE,"DELETE");
		featurePrivilegesMap.add("SPONSOR_CONTRACT_PERSON_PRIVILEGES", sponsorshipMasterConPerPrivileges);
		
		/****** For Sponsor Master Contract Person Form***********/
		sponsorshipMasterContactFormPerPrivileges = new Ext.util.HashMap();
		sponsorshipMasterContactFormPerPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORMASTERCONTACTPERSONFORM_COUNTRY,"COUNTRY");
		sponsorshipMasterContactFormPerPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORMASTERCONTACTPERSONFORM_CITY,"CITY");
		sponsorshipMasterContactFormPerPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORMASTERCONTACTPERSONFORM_POSTAL_CODE,"POSTAL_CODE");
		sponsorshipMasterContactFormPerPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORMASTERCONTACTPERSONFORM_GENERIC_FIELD1,"GENERIC_FIELD1");
		featurePrivilegesMap.add("SPONSOR_CONTRACT_PERSON_FORM_PRIVILEGES", sponsorshipMasterContactFormPerPrivileges);
	
		/****** For Sponsor Billing Report***********/
		sponsorshipBillingReportPrivileges = new Ext.util.HashMap();
		sponsorshipBillingReportPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORSHIP_BILLING_REPORT_VIEW,"VIEW");
		sponsorshipBillingReportPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORSHIP_BILLING_REPORT_EXPORT,"EXPORT");
		sponsorshipBillingReportPrivileges.add(FPCONSTANTS.PC_M12_F_SPONSORSHIP_BILLING_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("SPONSOR_BILLING_REPORT_PRIVILEGES", sponsorshipBillingReportPrivileges);
		
		/****** For Scholarship Master***********/
		scholarshipMasterPrivileges = new Ext.util.HashMap();
		scholarshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SCHOLARSHIPMASTER_VIEW,"VIEW");
		scholarshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SCHOLARSHIPMASTER_CREATE,"CREATE");
		scholarshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SCHOLARSHIPMASTER_UPDATE,"UPDATE");
		scholarshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SCHOLARSHIPMASTER_DELETE,"DELETE");
		scholarshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SCHOLARSHIPMASTER_EXPORT,"EXPORT");
		scholarshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SCHOLARSHIPMASTER_MOREACTIONS,"MOREACTIONS");
		scholarshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SCHOLARSHIPMASTER_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		scholarshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_SCHOLARSHIPMASTER_APPLY_TO,"APPLY_TO");
		featurePrivilegesMap.add("SCHOLARSHIP_MASTER_PRIVILEGES", scholarshipMasterPrivileges);
		
		/****** For Organization Academy***********/
		organizationStructureAcademyPrivileges = new Ext.util.HashMap();
		organizationStructureAcademyPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ACADEMY_VIEW,"VIEW");
		organizationStructureAcademyPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ACADEMY_CREATE,"CREATE");
		organizationStructureAcademyPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ACADEMY_UPDATE,"UPDATE");
		organizationStructureAcademyPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ACADEMY_DELETE,"DELETE");
		featurePrivilegesMap.add("ORGANIZATION_STRUCTURE_ACADEMY_PRIVILEGES", organizationStructureAcademyPrivileges);
		
		/****** For Organization Location***********/
		organizationStructureLocationPrivileges = new Ext.util.HashMap();
		organizationStructureLocationPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_LOCATION_VIEW,"VIEW");
		organizationStructureLocationPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_LOCATION_CREATE,"CREATE");
		organizationStructureLocationPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_LOCATION_UPDATE,"UPDATE");
		organizationStructureLocationPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_LOCATION_DELETE,"DELETE");
		featurePrivilegesMap.add("ORGANIZATION_STRUCTURE_LOCATION_PRIVILEGES", organizationStructureLocationPrivileges);
		
		/****** For Organization Academy-Location***********/
		organizationStructureAcademyLocationPrivileges = new Ext.util.HashMap();
		organizationStructureAcademyLocationPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ACADEMY_LOCATION_VIEW,"VIEW");
		organizationStructureAcademyLocationPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ACADEMY_LOCATION_CREATE,"CREATE");
		organizationStructureAcademyLocationPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ACADEMY_LOCATION_UPDATE,"UPDATE");
		organizationStructureAcademyLocationPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ACADEMY_LOCATION_DELETE,"DELETE");
		organizationStructureAcademyLocationPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ACADEMY_LOCATION_ADD_OTHER_INFORMATION,"ADD_OTHER_INFORMATION");
		featurePrivilegesMap.add("ORGANIZATION_STRUCTURE_ACADMY_LOCATION_PRIVILEGES", organizationStructureAcademyLocationPrivileges);
		
		/****** For Organization Address***********/
		organizationStructureAddressPrivileges = new Ext.util.HashMap();
		organizationStructureAddressPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ADDRESS_VIEW,"VIEW");
		organizationStructureAddressPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ADDRESS_CREATE,"CREATE");
		organizationStructureAddressPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ADDRESS_UPDATE,"UPDATE");
		organizationStructureAddressPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ADDRESS_PRINT,"PRINT");
		organizationStructureAddressPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_ADDRESS_PRINT_ALL,"PRINT_ALL");
		featurePrivilegesMap.add("ORGANIZATION_STRUCTURE_ADDRESS_PRIVILEGES", organizationStructureAddressPrivileges);
		
		/****** For Organization Management Accounting***********/
		organizationStructureManagementAccountingPrivileges = new Ext.util.HashMap();
		organizationStructureManagementAccountingPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_MANAGEMENT_ACCOUNTING_VIEW,"VIEW");
		organizationStructureManagementAccountingPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_MANAGEMENT_ACCOUNTING_CREATE,"CREATE");
		organizationStructureManagementAccountingPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_MANAGEMENT_ACCOUNTING_UPDATE,"UPDATE");
		organizationStructureManagementAccountingPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_MANAGEMENT_ACCOUNTING_DELETE,"DELETE");
		featurePrivilegesMap.add("ORGANIZATION_STRUCTURE_MANAGEMENT_ACCOUNTING_PRIVILEGES", organizationStructureManagementAccountingPrivileges);
		
		/****** For Organization Statutory Accounting***********/
		organizationStructureStatutoryAccountingPrivileges = new Ext.util.HashMap();
		organizationStructureStatutoryAccountingPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_STATUTORY_ACCOUNTING_VIEW,"VIEW");
		organizationStructureStatutoryAccountingPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_STATUTORY_ACCOUNTING_CREATE,"CREATE");
		organizationStructureStatutoryAccountingPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_STATUTORY_ACCOUNTING_UPDATE,"UPDATE");
		organizationStructureStatutoryAccountingPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_STATUTORY_ACCOUNTING_MOREACTIONS,"MOREACTIONS");
		featurePrivilegesMap.add("ORGANIZATION_STRUCTURE_STATUTORY_ACCOUNTING_PRIVILEGES", organizationStructureStatutoryAccountingPrivileges);
		
		/****** For Organization Supervision***********/
		organizationStructureSupervisionPrivileges = new Ext.util.HashMap();
		organizationStructureSupervisionPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_SUPERVISION_VIEW,"VIEW");
		organizationStructureSupervisionPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_SUPERVISION_CREATE,"CREATE");
		organizationStructureSupervisionPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_SUPERVISION_UPDATE,"UPDATE");
		organizationStructureSupervisionPrivileges.add(FPCONSTANTS.PC_M12_F_ORGANIZATIONSTRUCTURE_SUPERVISION_MOREACTIONS,"MOREACTIONS");
		featurePrivilegesMap.add("ORGANIZATION_STRUCTURE_SUPERVISION_PRIVILEGES", organizationStructureSupervisionPrivileges);
		

		/****** For Intellimali ***********/
		scholarshipMasterPrivileges = new Ext.util.HashMap();
		scholarshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_INTELLIMALI_VIEW,"VIEW");
		scholarshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_INTELLIMALI_CREATE,"CREATE");
		scholarshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_INTELLIMALI_EDIT,"EDIT");
		scholarshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_INTELLIMALI_DELETE,"DELETE");
		scholarshipMasterPrivileges.add(FPCONSTANTS.PC_M12_F_INTELLIMALI_EXPORT,"EXPORT");
		featurePrivilegesMap.add("INTELLIMALI_PRIVILEGES", scholarshipMasterPrivileges);
		
		/* For Poet Master */
		poetMasterMasterPrivileges = new Ext.util.HashMap();
		poetMasterMasterPrivileges.add(FPCONSTANTS.PC_M12_F_POET_MASTER_VIEW,"VIEW");
		poetMasterMasterPrivileges.add(FPCONSTANTS.PC_M12_F_POET_MASTER_CREATE,"CREATE");
		poetMasterMasterPrivileges.add(FPCONSTANTS.PC_M12_F_POET_MASTER_EDIT,"EDIT");
		poetMasterMasterPrivileges.add(FPCONSTANTS.PC_M12_F_POET_MASTER_DELETE,"DELETE");
		poetMasterMasterPrivileges.add(FPCONSTANTS.PC_M12_F_POET_MASTER_EXPORT,"EXPORT");
		poetMasterMasterPrivileges.add(FPCONSTANTS.PC_M12_F_POET_MASTER_ADD_TASK_DETAILS,"ADD_TASK_DETAILS");
		poetMasterMasterPrivileges.add(FPCONSTANTS.PC_M12_F_POET_MASTER_ADD_CONTRACT_DETAILS,"ADD_CONTRACT_DETAILS");
		poetMasterMasterPrivileges.add(FPCONSTANTS.PC_M12_F_POET_MASTER_ADD_CONTRACT_SUB_DETAILS,"ADD_CONTRACT_SUB_DETAILS");
		featurePrivilegesMap.add("POETMASTER_PRIVILEGES", poetMasterMasterPrivileges); 
		
		
		
		/******************Student Module Starts*******************************************************/
		/****** For Student List***********/
		studentListPrivileges = new Ext.util.HashMap();
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_VIEW,"VIEW");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_EXPORT,"EXPORT");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_RESETPASSWORD,"RESETPASSWORD");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_MOREACTION,"MOREACTION");
		//studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_PRINT,"PRINT");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_RAISEREQUEST,"RAISEREQUEST");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_RAISE_FLAG,"RAISE_FLAG"); //{03/01/23 @manas,V2D-332439}
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_THESIS_NOMINATION,"THESIS_NOMINATION");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_SENDMESSAGE,"SENDMESSAGE");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_PRINTMULTIPLEIDCARD,"PRINTMULTIPLEIDCARD");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_SENDSURVRY,"SENDSURVEY");
		//studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_EXPORT_REPORTS,"EXPORT_REPORTS");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_MAP_COMMITTEE,"ADD_COMMITTEE");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_IMPORT_BULK_STUDENT_UPDATE,"IMPORT_BULK_STUDENT_UPDATE");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_IMPORT_BULK_STUDENT_RELATIONSHIP,"IMPORT_BULK_STUDENT_RELATIONSHIP");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_IMPORT_BULK_STUDENT_ACADEMIC_TOPIC,"IMPORT_BULK_STUDENT_ACADEMIC_TOPIC");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_IMPORT_BULK_STUDENT_PAST_HISTORY,"IMPORT_EDUCATION_HISTORY");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_PRINT_CERTIFICATE,"PRINT_CERTIFICATE");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_PRINT_ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY,"PRINT_ATTESTATION_STATEMENT_OF_STUDENT_JOURNEY");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_BULK_DOCUMENT_DOWNLOAD_STATUS,"BULK_DOCUMENT_DOWNLOAD_STATUS");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_BULK_APPLICATION_DOCUMENT_DOWNLOAD,"BULK_APPLICATION_DOCUMENT_DOWNLOAD");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_IMPORT_AGGREGATIONS,"IMPORT_AGGREGATIONS");	
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_PRINT_PROFILE,"PRINT_PROFILE");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_DELETE,"DELETE_LIST");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_PRINT_DOCUMENTS,"PRINT_DOCUMENTS");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_MAKE_ACTIVE,"MAKE_ACTIVE");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_PRINT_LABELS,"PRINT_LABELS");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_OFFER_LETTER_DETAILS,"OFFER_LETTER_DETAILS");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_PRINT_TAX_CERTIFICATE,"PRINT_TAX_CERTIFICATE");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_ENROLLMENT,"ENROLLMENT");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_GRADUATION,"GRADUATION");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_STUDENT_DETAILS_REPORT,"STUDENT_DETAILS_REPORT");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_STUDENT_DETAILS_REPORT_FOR_SCHOOL,"STUDENT_DETAILS_REPORT_FOR_SCHOOL");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_STUDENT_ACADEMIC_TOPIC_DETAILS_REPORT,"STUDENT_ACADEMIC_TOPIC_DETAILS_REPORT");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_ENROLLED_COURSES_FORM,"ENROLLED_COURSES_FORM");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_STUDENT_COURSE_ENROLLMENT_FORM,"STUDENT_COURSE_ENROLLMENT_FORM");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_PRINT_TRANSFER_CARD,"PRINT_TRANSFER_CARD");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_ADD_LIBRARY,"ADD_LIBRARY");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_ADD_PATRON_CATEGORY,"ADD_PATRON_CATEGORY");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_CREATE_USER_ALFRESCO,"CREATE_STUDENT_IN_ALFRESCO");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_GRID_CONFIG,"GRID_CONFIGURATION");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_DOCUMENT_REQUEST,"DOCUMENT_REQUEST");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_SEND_CERTIFICATE_TO_PROFILE_DMS,"SEND_CERTIFICATE_TO_PROFILE_DMS");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_STUDENT_STATUS,"STUDENT_STATUS_CSM");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_ADD_TO_VOTER_POOL,"ADD_TO_VOTER_POOL");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_APPLY_HOLD,"APPLY_HOLD");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_APPLY_FOR_HOSTEL,"APPLY_FOR_HOSTEL");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_PROGRAM_TRANSFER,"PROGRAM_TRANSFER");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_APPLY_FOR_EXAM_CONCESSION,"APPLY_FOR_EXAM_CONCESSION");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_BULK_RESET_PASSWORD,"BULK_RESET_PASSWORD");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_SAMHS_ATTENDANCE_REPORT,"SAMHS_ATTENDANCE_REPORT");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_INACTIVE_STUDENT,"INACTIVE_STUDENT");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_RETAIN_STUDENT_DATA,"RETAIN_STUDENT_DATA");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_RETAIN_ACADEMIC_DATA,"RETAIN_ACADEMIC_DATA");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_SEND_MESSAGE_TO_ALL,"SEND_MESSAGE_TO_ALL");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_RETAIN_FEE_AND_PAYMENT_DATA,"RETAIN_FEE_AND_PAYMENT_DATA");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_RETAIN_SERVICE_OPTED,"RETAIN_SERVICE_OPTED");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_PRINT_PROFILE_AND_CONTRACT_DETAILS,"PRINT_PROFILE_AND_CONTRACT_DETAILS");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_GENERATE_EMAIL,"GENERATE_EMAIL");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_PANDADOC_BTN,"PANDADOC_BTN");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_MAKEALUMNI_BTN,"MAKEALUMNI_BTN");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_CHANGE_PRIMARY_LOCATION,"CHANGE_PRIMARY_LOCATION");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST__RAISE_SCHOLARSHIP_REQUEST,"RAISE_SCHOLARSHIP_REQUEST");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_CHANGE_SEAT_TYPE,"CHANGE_SEAT_TYPE");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_PROGRAM_COMPLETION_DETAILS,"PROGRAM_COMPLETION_DETAILS");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_RETAIN_EXAMINATION_DATA, "RETAIN_EXAMINATION_DATA");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_IMPORT_STUDENT_STATUS, "IMPORT_STUDENT_STATUS");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_IMPORT_IDENTITY_DOCUMENT,"IMPORT_IDENTITY_DOCUMENT");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_STUDENT_PROFILE_IMAGE_ICON,"STUDENT_PROFILE_IMAGE_ICON");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_IMPORT_STUDENT_POST_GRADUATION,"IMPORT_STUDENT_POST_GRADUATION");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_APPLY_FOR_HOSTEL_WAITING_LIST,"APPLY_FOR_HOSTEL_WAITING_LIST");
		studentListPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTLIST_CHANGE_ATTENDANCE_START_DATE,"CHANGE_ATTENDANCE_START_DATE");

		featurePrivilegesMap.add("STUDENT_LIST_PRIVILEGES", studentListPrivileges);
		
		/****** For Student Profile ***********/
		studentProfilePrivileges = new Ext.util.HashMap();
		studentProfilePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PROFILE_TO_VISITED_RECORD_VIEW, "VIEW");
		featurePrivilegesMap.add("STUDENT_PROFILE_PERMISSION", studentProfilePrivileges);

		
		/****** For Student Personal Details***********/
		studentPersonalDetailsPrivileges = new Ext.util.HashMap();
		studentPersonalDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PERSONAL_DETAILS_VIEW,"VIEW");
		studentPersonalDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PERSONAL_DETAILS_SAVEBUTTON,"SAVEBUTTON");
		studentPersonalDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PERSONAL_DETAILS_VERIFY_DETAILS_BUTTON,"VERIFY_DETAILS_BUTTON");
		studentPersonalDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PERSONAL_DETAILS_SNAPSHOT_BUTTON,"SNAPSHOT");
		studentPersonalDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PERSONAL_DETAILS_PHOTOUPLOAD_BUTTON,"PHOTO_UPLOAD");
		studentPersonalDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PERSONAL_DETAILS_REMOVE_BUTTON,"REMOVEBUTTON");
		studentPersonalDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PERSONAL_DETAILS_VALIDATE_ID_BUTTON,"VALIDATE_ID_BUTTON");
		featurePrivilegesMap.add("STUDENT_PERSONAL_DETAILS_PRIVILEGES", studentPersonalDetailsPrivileges);
		
		/****** for student flag view*******/
		studentflaglistPrivileges = new Ext.util.HashMap();
		studentflaglistPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_FLAG_LIST_VIEW,"VIEW");
		studentflaglistPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_FLAG_LIST_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_FLAG_LIST_PRIVILEGES",studentflaglistPrivileges);
		
		
		studentAddressDetailsPrivileges = new Ext.util.HashMap();
		studentAddressDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ADDRESSES_VIEW,"VIEW");
		studentAddressDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ADDRESSES_CREATE,"CREATE");
		studentAddressDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ADDRESSES_UPDATE,"UPDATE");
		studentAddressDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ADDRESSES_PRINT,"PRINT");
		studentAddressDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ADDRESSES_GOOGLE_ADDRESS,"GOOGLE_ADDRESS");
		featurePrivilegesMap.add("STUDENT_ADDRESS_DETAILS_PRIVILEGES", studentAddressDetailsPrivileges);
		
		/*studentPersonalDetailsPortalPrivileges = new Ext.util.HashMap();
		studentPersonalDetailsPortalPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PERSONAL_DETAILS_VIEW,"VIEW");
		studentPersonalDetailsPortalPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PERSONAL_DETAILS_SAVEBUTTON,"SAVEBUTTON");
		featurePrivilegesMap.add("STUDENT_PERSONAL_DETAILS_PORTAL_PRIVILEGES", studentPersonalDetailsPortalPrivileges);*/
		
		
		/****** For Student Parents & Guardians***********/
		studentParentsGuardiansPrivileges = new Ext.util.HashMap();
		studentParentsGuardiansPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PARENTS_GUARDIANS_VIEW,"VIEW");
		studentParentsGuardiansPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PARENTS_GUARDIANS_CREATE,"CREATE");
		studentParentsGuardiansPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PARENTS_GUARDIANS_UPDATE,"UPDATE");
		studentParentsGuardiansPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PARENTS_GUARDIANS_DELETE,"DELETE");
		studentParentsGuardiansPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PARENTS_GUARDIANS_EXPORT,"EXPORT");
		studentParentsGuardiansPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PARENTS_GUARDIANS_CREATELOGIN,"CREATELOGIN");
		studentParentsGuardiansPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PARENTS_GUARDIANS_RESETPASSWORD,"RESETPASSWORD");
		studentParentsGuardiansPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PARENTS_GUARDIANS_VIEW_DETAILS,"VIEW_DETAILS");
		studentParentsGuardiansPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PARENTS_GUARDIANS_SSOBUTTON,"SSOBUTTON");
		featurePrivilegesMap.add("STUDENT_PARENTS_GUARDIANS_PRIVILEGES", studentParentsGuardiansPrivileges);
		
		/** For Student Fee Payer Details */
		
		studentFeePayerDetailPrivileges = new Ext.util.HashMap();
		studentFeePayerDetailPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_FEE_PAYER_DETAILS_VIEW,"VIEW");
		studentFeePayerDetailPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_FEE_PAYER_DETAILS_CREATE,"CREATE");
		studentFeePayerDetailPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_FEE_PAYER_DETAILS_UPDATE,"UPDATE");
		studentFeePayerDetailPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_FEE_PAYER_DETAILS_DELETE,"DELETE");
		studentFeePayerDetailPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_FEE_PAYER_DETAILS_CORPORATE_ID,"CORPORATE_ID");
		studentFeePayerDetailPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_FEE_PAYER_DETAILS_GOOGLE_ADDRESS,"GOOGLE_ADDRESS");
		featurePrivilegesMap.add("STUDENT_FEE_PAYER_DETAILS_PRIVILEGES", studentFeePayerDetailPrivileges);
		
		/****** For Student Manage Appointment***********/
		
		/****** For Student Siblings***********/
		studentSiblingsPrivileges = new Ext.util.HashMap();
		studentSiblingsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SIBLING_VIEW,"VIEW");
		studentSiblingsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SIBLING_CREATE,"CREATE");
		studentSiblingsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SIBLING_UPDATE,"UPDATE");
		studentSiblingsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SIBLING_DELETE,"DELETE");
		studentSiblingsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SIBLING_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_SIBLINGS_PRIVILEGES", studentSiblingsPrivileges);
		
		studentIdentityDetailsPrivileges = new Ext.util.HashMap();
		studentIdentityDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_IDENTITY_DETAILS_VIEW,"VIEW");
		studentIdentityDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_IDENTITY_DETAILS_CREATE,"CREATE");
		studentIdentityDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_IDENTITY_DETAILS_UPDATE,"UPDATE");
		studentIdentityDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_IDENTITY_DETAILS_DELETE,"DELETE");
		studentIdentityDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_IDENTITY_DETAILS_EXPORT,"EXPORT");
		studentIdentityDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_IDENTITY_DETAILS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_IDENTITY_DETAILS_PRIVILEGES", studentIdentityDetailsPrivileges);
		
		/****** For Student Education***********/
		studentEducationPrivileges = new Ext.util.HashMap();
		studentEducationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_EDUCATION_VIEW,"VIEW");
		studentEducationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_EDUCATION_CREATE,"CREATE");
		studentEducationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_EDUCATION_UPDATE,"UPDATE");
		studentEducationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_EDUCATION_DELETE,"DELETE");
		studentEducationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_EDUCATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_EDUCATION_PRIVILEGES", studentEducationPrivileges);
		
		/****** For Student Work Experience***********/
		studentWorkExperiencePrivileges = new Ext.util.HashMap();
		studentWorkExperiencePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_WORK_EXPERIENCE_VIEW,"VIEW");
		studentWorkExperiencePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_WORK_EXPERIENCE_CREATE,"CREATE");
		studentWorkExperiencePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_WORK_EXPERIENCE_UPDATE,"UPDATE");
		studentWorkExperiencePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_WORK_EXPERIENCE_DELETE,"DELETE");
		studentWorkExperiencePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_WORK_EXPERIENCE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_WORK_EXPERIENCE_PRIVILEGES", studentWorkExperiencePrivileges);
		
		/****** For Student Medical***********/
		studentMedicalPrivileges = new Ext.util.HashMap();
		studentMedicalPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MEDICAL_VIEW,"VIEW");
		studentMedicalPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MEDICAL_CREATE,"CREATE");
		studentMedicalPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MEDICAL_UPDATE,"UPDATE");
		studentMedicalPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MEDICAL_DELETE,"DELETE");
		studentMedicalPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MEDICAL_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_MEDICAL_PRIVILEGES", studentMedicalPrivileges);
		
		/****** For Student Physical characteristics***********/
		studentPhysicalCharacteristicPrivileges = new Ext.util.HashMap();
		studentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_VIEW,"VIEW");
		studentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_EXPORT,"EXPORT");
		studentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_CREATE,"CREATE");
		studentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_UPDATE,"UPDATE");
		studentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_DELETE,"DELETE");
		featurePrivilegesMap.add("STUDENT_PHYSICAL_CHARACTERISTICS_PRIVILEGES", studentPhysicalCharacteristicPrivileges);
		
		/****** For Student Vaccination***********/
		studentVaccinationPrivileges = new Ext.util.HashMap();
		studentVaccinationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_VACCINATION_VIEW,"VIEW");
		studentVaccinationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_VACCINATION_CREATE,"CREATE");
		studentVaccinationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_VACCINATION_UPDATE,"UPDATE");
		studentVaccinationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_VACCINATION_DELETE,"DELETE");
		studentVaccinationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_VACCINATION_EXPORT,"EXPORT");
		studentVaccinationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_VACCINATION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_VACCINATION_PRIVILEGES", studentVaccinationPrivileges);
		
		/****** For Student Extra Curricular Activity***********/
		studentExtraCurricularActivityPrivileges = new Ext.util.HashMap();
		studentExtraCurricularActivityPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_VIEW,"VIEW");
		studentExtraCurricularActivityPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_CREATE,"CREATE");
		studentExtraCurricularActivityPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_UPDATE,"UPDATE");
		studentExtraCurricularActivityPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_DELETE,"DELETE");
		studentExtraCurricularActivityPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_EXPORT,"EXPORT");
		studentExtraCurricularActivityPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_ADD_STUDENTS,"EXTRACURRICULAR_ADD_STUDENTS");
		featurePrivilegesMap.add("STUDENT_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES", studentExtraCurricularActivityPrivileges);
		
		/********* For Student Competitive Exam ***************/
		
		studentCompetitiveExamPrivileges = new Ext.util.HashMap();
		studentCompetitiveExamPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMPETITIVE_EXAM_VIEW,"VIEW");
		studentCompetitiveExamPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMPETITIVE_EXAM_CREATE,"CREATE");
		studentCompetitiveExamPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMPETITIVE_EXAM_UPDATE,"UPDATE");
		studentCompetitiveExamPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMPETITIVE_EXAM_DELETE,"DELETE");
		studentCompetitiveExamPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMPETITIVE_EXAM_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_COMPETITIVE_EXAM_PRIVILEGES", studentCompetitiveExamPrivileges);
		
		/** For Student Medical Detail */
		studentMedicalDetailPrivileges = new Ext.util.HashMap();
		studentMedicalDetailPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MEDICAL_DETAIL_VIEW,"VIEW");
		studentMedicalDetailPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MEDICAL_DETAIL_SAVE,"SAVE");
		featurePrivilegesMap.add("STUDENT_MEDICAL_DETAIL_PRIVILEGES", studentMedicalDetailPrivileges);
		
		/****** For Student Research Details ***********/
		studentResearchDetailsPrivileges = new Ext.util.HashMap();
		studentResearchDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_RESEARCH_DETAILS_VIEW,"VIEW");
		studentResearchDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_RESEARCH_DETAILS_CREATE,"CREATE");
		studentResearchDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_RESEARCH_DETAILS_UPDATE,"UPDATE");
		studentResearchDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_RESEARCH_DETAILS_DELETE,"DELETE");
		studentResearchDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_RESEARCH_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_RESEARCH_DETAILS_PRIVILEGES", studentResearchDetailsPrivileges);
		
		/****** For Student Research Details ***********/
		studentSeminarDetailsPrivileges = new Ext.util.HashMap();
		studentSeminarDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SEMINAR_DETAILS_VIEW,"VIEW");
		studentSeminarDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SEMINAR_DETAILS_CREATE,"CREATE");
		studentSeminarDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SEMINAR_DETAILS_UPDATE,"UPDATE");
		studentSeminarDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SEMINAR_DETAILS_DELETE,"DELETE");
		studentSeminarDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SEMINAR_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_SEMINAR_DETAILS_PRIVILEGES", studentSeminarDetailsPrivileges);
		
		/****** For Student Hostel Details Details ***********/
		studentHostelDetailsPrivileges = new Ext.util.HashMap();
		studentHostelDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_HOSTEL_DETAILS_VIEW,"VIEW");
		studentHostelDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_HOSTEL_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_HOSTEL_DETAILS_PRIVILEGES", studentHostelDetailsPrivileges);
		
		/****** For Student Transport Details ***********/
		studentTransportDetailsPrivileges = new Ext.util.HashMap();
		studentTransportDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_TRANSPORT_DETAILS_VIEW,"VIEW");
		studentTransportDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_TRANSPORT_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_TRANSPORT_DETAILS_PRIVILEGES", studentTransportDetailsPrivileges);
		
		/****** For Student Research Details ***********/
		facultyResearchDetailsPrivileges = new Ext.util.HashMap();
		facultyResearchDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_RESEARCH_DETAILS_VIEW,"VIEW");
		facultyResearchDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_RESEARCH_DETAILS_EXPORT,"EXPORT");
		facultyResearchDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_RESEARCH_DETAILS_CREATE,"CREATE");
		facultyResearchDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_RESEARCH_DETAILS_UPDATE,"UPDATE");
		facultyResearchDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_RESEARCH_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_RESEARCH_DETAILS_PRIVILEGES", facultyResearchDetailsPrivileges);
		
		facultyProfileResearchDetailsPrivileges = new Ext.util.HashMap();
		facultyProfileResearchDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_RESEARCH_DETAILS_VIEW,"VIEW");
		facultyProfileResearchDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_RESEARCH_DETAILS_CREATE,"CREATE");
		facultyProfileResearchDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_RESEARCH_DETAILS_UPDATE,"UPDATE");
		facultyProfileResearchDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_RESEARCH_DETAILS_DELETE,"DELETE");
		facultyProfileResearchDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_RESEARCH_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_RESEARCH_DETAILS_PRIVILEGES", facultyProfileResearchDetailsPrivileges);
		
		/****** For Student Research Details ***********/
		
		
		/****** For Faculty Patent Details ***********/
		facultyPatentDetailsPrivileges = new Ext.util.HashMap();
		facultyPatentDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PATENT_DETAILS_VIEW,"VIEW");
		facultyPatentDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PATENT_DETAILS_EXPORT,"EXPORT");
		facultyPatentDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PATENT_DETAILS_CREATE,"CREATE");
		facultyPatentDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PATENT_DETAILS_UPDATE,"UPDATE");
		facultyPatentDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PATENT_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_PATENT_DETAILS_PRIVILEGES", facultyPatentDetailsPrivileges);
		
		facultyProfilePatentDetailsPrivileges = new Ext.util.HashMap();
		facultyProfilePatentDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PATENT_DETAILS_VIEW,"VIEW");
		facultyProfilePatentDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PATENT_DETAILS_CREATE,"CREATE");
		facultyProfilePatentDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PATENT_DETAILS_UPDATE,"UPDATE");
		facultyProfilePatentDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PATENT_DETAILS_DELETE,"DELETE");
		facultyProfilePatentDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PATENT_DETAILS_EXPORT,"EXPORT");
		facultyProfilePatentDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PATENT_DETAILS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_PROFILE_PATENT_DETAILS_PRIVILEGES", facultyProfilePatentDetailsPrivileges);
		
		/****** For Student Patent***********/
		studentPatentPrivileges = new Ext.util.HashMap();
		studentPatentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PATENT_DETAILS_VIEW,"VIEW");
		studentPatentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PATENT_DETAILS_CREATE,"CREATE");
		studentPatentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PATENT_DETAILS_UPDATE,"UPDATE");
		studentPatentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PATENT_DETAILS_DELETE,"DELETE");
		studentPatentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PATENT_DETAILS_EXPORT,"EXPORT");
		studentPatentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PATENT_DETAILS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_PATENT_PRIVILEGES", studentPatentPrivileges);
		
		/****** For Student Training***********/
		studentTrainingPrivileges = new Ext.util.HashMap();
		studentTrainingPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_TRAINING_VIEW,"VIEW");
		studentTrainingPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_TRAINING_CREATE,"CREATE");
		studentTrainingPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_TRAINING_UPDATE,"UPDATE");
		studentTrainingPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_TRAINING_DELETE,"DELETE");
		studentTrainingPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_TRAINING_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_TRAINING_PRIVILEGES", studentTrainingPrivileges);
		
		/****** For Student Attendance***********/
		studentAttendancePrivileges = new Ext.util.HashMap();
		studentAttendancePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ATTENDANCE_VIEW,"VIEW");
		studentAttendancePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ATTENDANCE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_ATTENDANCE_DETAILS_PRIVILEGES", studentAttendancePrivileges);
		
		studentProfileAttendanceReportPrivileges = new Ext.util.HashMap();
		studentProfileAttendanceReportPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ATTENDANCE_PROGRAM_WISE, "PROGRAM_WISE");
		studentProfileAttendanceReportPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ATTENDANCE_COURSE_WISE, "COURSE_WISE");
		studentProfileAttendanceReportPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ATTENDANCE_SESSION_WISE, "SESSION_WISE");
		featurePrivilegesMap.add("STUDENT_PROFILE_ATTENDANCE_PRIVILEGES", studentProfileAttendanceReportPrivileges);
		
		parentPortalStudentAttendancePrivileges = new Ext.util.HashMap();
		parentPortalStudentAttendancePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ATTENDANCE_VIEW,"VIEW");
		parentPortalStudentAttendancePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ATTENDANCE_EXPORT,"EXPORT");
		parentPortalStudentAttendancePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ATTENDANCE_PROGRAM_WISE, "PROGRAM_WISE");
		parentPortalStudentAttendancePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ATTENDANCE_COURSE_WISE, "COURSE_WISE");
		parentPortalStudentAttendancePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ATTENDANCE_SESSION_WISE, "SESSION_WISE");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_ATTENDANCE_DETAILS_PRIVILEGES", parentPortalStudentAttendancePrivileges);

		parentPortalHomeWorkAssignmentsPrivileges = new Ext.util.HashMap();
		parentPortalHomeWorkAssignmentsPrivileges.add(FPCONSTANTS.PP_M4_F_HOMEWORKASSIGNMENTS_UPLOADDOCUMENT,"UPLOAD_DOCUMENT");
		parentPortalHomeWorkAssignmentsPrivileges.add(FPCONSTANTS.PP_M4_F_HOMEWORKASSIGNMENTS_EXPORT,"EXPORT");
		parentPortalHomeWorkAssignmentsPrivileges.add(FPCONSTANTS.PP_M4_F_HOMEWORKASSIGNMENTS_VIEW,"VIEW");
		parentPortalHomeWorkAssignmentsPrivileges.add(FPCONSTANTS.PP_M4_F_HOMEWORKASSIGNMENTS_DOWNLOAD_ALL,"DOWNLOAD_ALL");
		parentPortalHomeWorkAssignmentsPrivileges.add(FPCONSTANTS.PP_M4_F_HOMEWORKASSIGNMENTS_SUBMISSION_DETAILS,"SUBMISSION_DETAILS");
		parentPortalHomeWorkAssignmentsPrivileges.add(FPCONSTANTS.PP_M4_F_HOMEWORKASSIGNMENTS_ASSESSMENT_DETAILS,"ASSESSMENT_DETAILS");
		featurePrivilegesMap.add("PARENT_PORTAL_HOME_WORK_ASSIGNMENTS_PRIVILEGES", parentPortalHomeWorkAssignmentsPrivileges);		
		
		parentPortalStudentExamTimetablePrivileges = new Ext.util.HashMap();
		parentPortalStudentExamTimetablePrivileges.add(FPCONSTANTS.PP_M1_F_STUDENT_EXAM_TIMETABLE_VIEW,"VIEW");
		parentPortalStudentExamTimetablePrivileges.add(FPCONSTANTS.PP_M1_F_STUDENT_EXAM_TIMETABLE_PRINTTIMETABLE,"PRINTTIMETABLE");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_EXAM_TIME_TABLE_PRIVILEGES", parentPortalStudentExamTimetablePrivileges);
		
		parentPortalStudentMyExaminationPrivileges = new Ext.util.HashMap();
		parentPortalStudentMyExaminationPrivileges.add(FPCONSTANTS.PP_M1_F_STUDENT_MY_EXAMINATION_VIEW,"VIEW");
		parentPortalStudentMyExaminationPrivileges.add(FPCONSTANTS.PP_M1_F_STUDENT_MY_EXAMINATION_EXPORT,"EXPORT");
		parentPortalStudentMyExaminationPrivileges.add(FPCONSTANTS.PP_M1_F_STUDENT_MY_EXAMINATION_MAKE_PAYMENT,"MAKE_PAYMENT");
		parentPortalStudentMyExaminationPrivileges.add(FPCONSTANTS.PP_M1_F_STUDENT_MY_EXAMINATION_DOWNLOAD_FORM,"DOWNLOAD_FORM");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_MY_EXAMINATION_PRIVILEGES", parentPortalStudentMyExaminationPrivileges);
		
		parentPortalCourseRegistrationPrivileges = new Ext.util.HashMap();
		parentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.PP_M4_F_COURSE_REGISTRATION_VIEW,"VIEW");
		parentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.PP_M4_F_COURSE_REGISTRATION_EXPORT,"EXPORT");
		parentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.PP_M4_F_COURSE_REGISTRATION_ENROLL,"ENROLL");
		parentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.PP_M4_F_COURSE_REGISTRATION_UNENROLL,"UNENROLL");
		parentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.PP_M4_F_COURSE_REGISTRATION_DELETEENROLL,"DELETEENROLL");
		parentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.PP_M4_F_COURSE_REGISTRATION_BULK_ENROL,"BULK_ENROL");
		parentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.PP_M4_F_COURSE_REGISTRATION_DETAILED_TIMETABLE,"DETAILED_TIMETABLE");
		parentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.PP_M4_F_COURSE_REGISTRATION_PAYMENT_DETAILS,"PAYMENT_DETAILS");
		featurePrivilegesMap.add("PARENT_PORTAL_COURSE_REGISTRATION_PRIVILEGES", parentPortalCourseRegistrationPrivileges);
		
		/****** For Student Committee */
		studentPortalCommitteePrivileges = new Ext.util.HashMap();
		studentPortalCommitteePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_MY_COMMITTEE_DETAILS_VIEW,"VIEW");
		studentPortalCommitteePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_MY_COMMITTEE_DETAILS_EXPORT,"EXPORT");
		studentPortalCommitteePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_MY_COMMITTEE_DETAILS_PARTICIPANT_HYPERLINK,"PARTICIPANT_HYPERLINK");
		featurePrivilegesMap.add("STUDENT_PORTAL_COMMITTEE_PRIVILEGES", studentPortalCommitteePrivileges);
		
		/****** For Student Committee Schedules */
		studentPortalCommitteeSchedulePrivileges = new Ext.util.HashMap();
		studentPortalCommitteeSchedulePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_MY_COMMITTEE_SCHEDULES_DETAILS_VIEW,"VIEW");
		studentPortalCommitteeSchedulePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_MY_COMMITTEE_SCHEDULES_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_COMMITTEE_SCHEULE_PRIVILEGES", studentPortalCommitteeSchedulePrivileges);
		
		/****** For Student portal Election */
		studentPortalElectionsPrivileges = new Ext.util.HashMap();
		studentPortalElectionsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ELECTIONS_VIEW,"VIEW");
		studentPortalElectionsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ELECTIONS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_ELECTIONS_PRIVILEGES", studentPortalElectionsPrivileges);
		
		/****** For Parent Committee */
		parentPortalCommitteePrivileges = new Ext.util.HashMap();
		parentPortalCommitteePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_MY_COMMITTEE_DETAILS_VIEW,"VIEW");
		parentPortalCommitteePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_MY_COMMITTEE_DETAILS_EXPORT,"EXPORT");
		parentPortalCommitteePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_MY_COMMITTEE_DETAILS_PARTICIPANT_HYPERLINK,"PARTICIPANT_HYPERLINK");
		featurePrivilegesMap.add("PARENT_PORTAL_COMMITTEE_PRIVILEGES", parentPortalCommitteePrivileges);
		
		/****** For Parent Committee Schedules */
		parentPortalCommitteeSchedulePrivileges = new Ext.util.HashMap();
		parentPortalCommitteeSchedulePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_MY_COMMITTEE_SCHEDULES_DETAILS_VIEW,"VIEW");
		parentPortalCommitteeSchedulePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_MY_COMMITTEE_SCHEDULES_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_COMMITTEE_SCHEULE_PRIVILEGES", parentPortalCommitteeSchedulePrivileges);
		
		/****** For Student Schedule***********/
		studentSchedulePrivileges = new Ext.util.HashMap();
		studentSchedulePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SCHEDULE_DETAILS_VIEW,"VIEW");
		studentSchedulePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SCHEDULE_DETAILS_PRINT,"PRINT");
		studentSchedulePrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SCHEDULE_DETAILS_EXPORT_TO_PNG,"EXPORT_TO_PNG");
		featurePrivilegesMap.add("STUDENT_SCHEDULE_DETAILS_PRIVILEGES", studentSchedulePrivileges);
		
		/****** For Student Schedule***********/
		studentOnlinePaymentsPrivileges = new Ext.util.HashMap();
		studentOnlinePaymentsPrivileges.add(FPCONSTANTS.SP_M11_F_ONLINEPAYMENTS_VIEW,"VIEW");
		studentOnlinePaymentsPrivileges.add(FPCONSTANTS.SP_M11_F_ONLINEPAYMENTS_MAKE_PAYMENT,"MAKE_PAYMENT");
		studentOnlinePaymentsPrivileges.add(FPCONSTANTS.SP_M11_F_ONLINEPAYMENTS_MAKE_PAYMENT_VIA_PAYTM,"MAKE_PAYMENT_VIA_PAYTM");
		studentOnlinePaymentsPrivileges.add(FPCONSTANTS.SP_M11_F_ONLINEPAYMENTS_BANK,"BANK");
		studentOnlinePaymentsPrivileges.add(FPCONSTANTS.SP_M11_F_ONLINEPAYMENTS_MAKE_PAYMENT_VIA_TECH_PROCESS,"MAKE_PAYMENT_VIA_TECH_PROCESS");
		studentOnlinePaymentsPrivileges.add(FPCONSTANTS.SP_M11_F_ONLINEPAYMENTS_PRINT,"PRINT");
		
		
		featurePrivilegesMap.add("STUDENT_ONLINE_PAYMENTS_PRIVILEGES", studentOnlinePaymentsPrivileges);
		
		/****** For Student Fee Plans***********/
		studentFeePlansPrivileges = new Ext.util.HashMap();
		studentFeePlansPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_FEE_PLANS_VIEW,"VIEW");
		studentFeePlansPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_FEE_PLANS_EXPORT,"EXPORT");
		studentFeePlansPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_FEE_PLANS_VIEW,"VIEW");
		studentFeePlansPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_FEE_PLANS_EXPORT,"EXPORT");
		studentFeePlansPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_FEE_PLANS_VIEW,"VIEW");
		studentFeePlansPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_FEE_PLANS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_FEE_PLANS_PRIVILEGES", studentFeePlansPrivileges);
		
		/****** For Student Request Raised History***********/
		studentRequestRaisedHistoryPrivileges = new Ext.util.HashMap();
		studentRequestRaisedHistoryPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_REQUEST_RAISED_HISTORY_VIEW,"VIEW");
		studentRequestRaisedHistoryPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_REQUEST_RAISED_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_REQUEST_RAISED_HISTORY_PRIVILEGES", studentRequestRaisedHistoryPrivileges);
		
		/****** For Student Request Pending Descision***********/
		studentRequestPendingDescisionPrivileges = new Ext.util.HashMap();
		studentRequestPendingDescisionPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_REQUEST_PENDING_DESCISION_VIEW,"VIEW");
		studentRequestPendingDescisionPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_REQUEST_PENDING_DESCISION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_REQUEST_PENDING_DESCISION_PRIVILEGES", studentRequestPendingDescisionPrivileges);
		
		
		/****** For Student Pending Bills***********/
		studentPendingBillsPrivileges = new Ext.util.HashMap();
		studentPendingBillsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PENDING_BILLS_VIEW,"VIEW");
		studentPendingBillsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PENDING_BILLS_EXPORT,"EXPORT");
		studentPendingBillsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PENDING_BILLS_MAKE_PAYMENT,"MAKE_PAYMENT");
		featurePrivilegesMap.add("STUDENT_PENDING_BILLS_PRIVILEGES", studentPendingBillsPrivileges);
		
		/*studentPortalPendingBillsPrivileges = new Ext.util.HashMap();
		//studentPendingBillsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PENDING_BILLS_VIEW,"VIEW");
		//studentPendingBillsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PENDING_BILLS_EXPORT,"EXPORT");
		studentPortalPendingBillsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_VIEW,"VIEW");
		studentPortalPendingBillsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_PENDING_BILLS_PRIVILEGES", studentPortalPendingBillsPrivileges);*/
		
		/****** For Student Payment Recieved***********/
		studentPaymentRecievedPrivileges = new Ext.util.HashMap();
		studentPaymentRecievedPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PAYMENT_RECIEVED_VIEW,"VIEW");
		studentPaymentRecievedPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PAYMENT_RECIEVED_EXPORT,"EXPORT");
		studentPaymentRecievedPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PAYMENT_RECIEVED_PRINT,"PRINT");
		studentPaymentRecievedPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PAYMENT_RECIEVED_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_PAYMENT_RECIEVED_PRIVILEGES", studentPaymentRecievedPrivileges);
		
		/****** For Student Refunds***********/
		studentRefundsPrivileges = new Ext.util.HashMap();
		studentRefundsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_REFUNDS_VIEW,"VIEW");
		studentRefundsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_REFUNDS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_REFUNDS_PRIVILEGES", studentRefundsPrivileges);
		
		/****** For Student Refundable Payments***********/
		studentRefundablePaymentsPrivileges = new Ext.util.HashMap();
		studentRefundablePaymentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_REFUNDABLE_PAYMENTS_VIEW,"VIEW");
		studentRefundablePaymentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_REFUNDABLE_PAYMENTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_REFUNDABLE_PAYMENTS_PRIVILEGES", studentRefundablePaymentsPrivileges);
		
		/****** For Student Post Dated Cheques***********/
		studentPostDatedChequesPrivileges = new Ext.util.HashMap();
		studentPostDatedChequesPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_POST_DATED_CHEQUES_VIEW,"VIEW");
		studentPostDatedChequesPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_POST_DATED_CHEQUES_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_POST_DATED_CHEQUES_PRIVILEGES", studentPostDatedChequesPrivileges);
		
		/****** For Student Services History***********/
		studentServicesHistoryPrivileges = new Ext.util.HashMap();
		studentServicesHistoryPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SERVICES_HISTORY_VIEW,"VIEW");
		studentServicesHistoryPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SERVICES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_SERVICES_HISTORY_PRIVILEGES", studentServicesHistoryPrivileges);
		
		/****** For Student Active Survey***********/
		studentActiveSurveyPrivileges = new Ext.util.HashMap();
		studentActiveSurveyPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ACTIVE_SURVEY_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_ACTIVE_SURVEY_PRIVILEGES", studentActiveSurveyPrivileges);
		
		/****** For Student Service Opt In/Opt Out***********/
		studentServiceOptPrivileges = new Ext.util.HashMap();
		studentServiceOptPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SERVICE_OPT_VIEW,"VIEW");
		studentServiceOptPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SERVICE_OPT_CREATE,"CREATE");
		studentServiceOptPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SERVICE_OPT_UPDATE,"UPDATE");
		studentServiceOptPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SERVICE_OPT_DELETE,"DELETE");
		studentServiceOptPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SERVICE_OPT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_SERVICE_OPT_PRIVILEGES", studentServiceOptPrivileges);
		
		/****** For Student Communities History***********/
		studentCommunitiesHistoryPrivileges = new Ext.util.HashMap();
		studentCommunitiesHistoryPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMMUNITIES_HISTORY_VIEW,"VIEW");
		studentCommunitiesHistoryPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMMUNITIES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_COMMUNITIES_HISTORY_PRIVILEGES", studentCommunitiesHistoryPrivileges);
		
		/****** For Student Communities Opt In/Opt Out***********/
		studentCommunitiesOptPrivileges = new Ext.util.HashMap();
		studentCommunitiesOptPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMMUNITIES_OPT_VIEW,"VIEW");
		studentCommunitiesOptPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMMUNITIES_OPT_CREATE,"CREATE");
		studentCommunitiesOptPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMMUNITIES_OPT_UPDATE,"UPDATE");
		studentCommunitiesOptPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMMUNITIES_OPT_DELETE,"DELETE");
		studentCommunitiesOptPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMMUNITIES_OPT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_COMMUNITIES_OPT_PRIVILEGES", studentCommunitiesOptPrivileges);
		
		/****** For Student Hostel Personal Requiremments***********/
		studentHostelPersonalRequirements = new Ext.util.HashMap();
		studentHostelPersonalRequirements.add(FPCONSTANTS.PS_M9_F_STUDENT_HOSTEL_PERSONAL_REQUIREMENTS_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_HOSTEL_PERSONAL_PRIVILEGES", studentHostelPersonalRequirements);
		
		/****** For Student Feedback Given***********/
		studentFeedbackGivenPrivileges = new Ext.util.HashMap();
		studentFeedbackGivenPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_FEEDBACK_GIVEN_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_FEEDBACK_GIVEN_PRIVILEGES", studentFeedbackGivenPrivileges);
		
		/****** For Student Feedback Received***********/
		studentFeedbackReceivedPrivileges = new Ext.util.HashMap();
		studentFeedbackReceivedPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_FEEDBACK_RECEIVED_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_FEEDBACK_RECEIVED_PRIVILEGES", studentFeedbackReceivedPrivileges);
		
		/****** For Student Disciplinary Actions***********/
		studentDisciplinaryActionsPrivileges = new Ext.util.HashMap();
		studentDisciplinaryActionsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_VIEW,"VIEW");
		studentDisciplinaryActionsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_CREATE,"CREATE");
		studentDisciplinaryActionsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_UPDATE,"UPDATE");
		studentDisciplinaryActionsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_DELETE,"DELETE");
		studentDisciplinaryActionsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_EXPORT,"EXPORT");
		studentDisciplinaryActionsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_ADD_STUDENTS,"PS_ADD_STUDENTS");
		studentDisciplinaryActionsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_DOCUMENT_DELETE,"PS_DOCUMENT_DELETE");
		studentDisciplinaryActionsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_DISCIPLINARY_ACTIONS_PRIVILEGES", studentDisciplinaryActionsPrivileges);
		
		/****** For Student Disciplinary Actions-SU***********/
		studentDisciplinaryActionsSUPrivileges = new Ext.util.HashMap();
		studentDisciplinaryActionsSUPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_SU_VIEW,"VIEW");
		studentDisciplinaryActionsSUPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_SU_CREATE,"CREATE");
		studentDisciplinaryActionsSUPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_SU_UPDATE,"UPDATE");
		studentDisciplinaryActionsSUPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_SU_DELETE,"DELETE");
		studentDisciplinaryActionsSUPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_SU_ADD_STUDENTS,"PS_ADD_STUDENTS");
		studentDisciplinaryActionsSUPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DISCIPLINARY_ACTIONS_SU_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_DISCIPLINARY_ACTIONS_SU_PRIVILEGES", studentDisciplinaryActionsSUPrivileges);
		
		/****** For Student Negative Incidents***********/
		studentNegativeIncidentsPrivileges = new Ext.util.HashMap();
		studentNegativeIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_NEGATIVE_INCIDENTS_VIEW,"VIEW");
		studentNegativeIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_NEGATIVE_INCIDENTS_CREATE,"CREATE");
		studentNegativeIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_NEGATIVE_INCIDENTS_UPDATE,"UPDATE");
		studentNegativeIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_NEGATIVE_INCIDENTS_DELETE,"DELETE");
		studentNegativeIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_NEGATIVE_INCIDENTS_EXPORT,"EXPORT");
		studentNegativeIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_NEGATIVE_INCIDENTS_ADD_STUDENTS,"PS_ADD_STUDENTS");
		studentNegativeIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_NEGATIVE_INCIDENTS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_NEGATIVE_INCIDENTS_PRIVILEGES", studentNegativeIncidentsPrivileges);
		
		/****** For Student Positive Incidents***********/
		studentPositiveIncidentsPrivileges = new Ext.util.HashMap();
		studentPositiveIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_POSITIVE_INCIDENTS_VIEW,"VIEW");
		studentPositiveIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_POSITIVE_INCIDENTS_CREATE,"CREATE");
		studentPositiveIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_POSITIVE_INCIDENTS_UPDATE,"UPDATE");
		studentPositiveIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_POSITIVE_INCIDENTS_DELETE,"DELETE");
		studentPositiveIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_POSITIVE_INCIDENTS_EXPORT,"EXPORT");
		studentPositiveIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_POSITIVE_INCIDENTS_ADD_STUDENTS,"PS_ADD_STUDENTS");
		studentPositiveIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_POSITIVE_INCIDENTS_DOCUMENT_DELETE,"PS_PI_DOC_DELETE");
		studentPositiveIncidentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_POSITIVE_INCIDENTS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_POSITIVE_INCIDENTS_PRIVILEGES", studentPositiveIncidentsPrivileges);
		
		/****** For Student Holds ***********/
		studentHoldsPrivileges = new Ext.util.HashMap();
		studentHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_HOLDS__VIEW,"VIEW");
		studentHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_HOLDS_AAPLY_HOLD,"APPLY_HOLD");
		studentHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_HOLDS_REMOVE_HOLD,"REMOVE_HOLD");
		studentHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_HOLDS_EXPORT,"EXPORT");
		studentHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_HOLDS_DELETE_HOLD,"DELETE_HOLD");
		studentHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_HOLDS_HOLDS_TAB,"HOLDS_TAB");
		studentHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_HOLDS_FINANCE_HOLDS_TAB,"FINANCE_HOLDS_TAB");
		featurePrivilegesMap.add("STUDENT_HOLDS_PRIVILEGES", studentHoldsPrivileges);
		
		/****** For Student KYS***********/
		studentKYSPrivileges = new Ext.util.HashMap();
		studentKYSPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_KYS_VIEW,"VIEW");
		studentKYSPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_KYS_EXPORT,"EXPORT");
		studentKYSPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_KYS_VIEW,"VIEW");
		studentKYSPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_KYS_EXPORT,"EXPORT");
		studentKYSPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_KYS_SUBMIT,"SUBMIT");
		studentKYSPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_KYS_SUBMIT,"SUBMIT");
		studentKYSPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_KYS_SUBMIT,"SUBMIT");
		featurePrivilegesMap.add("STUDENT_KYS_PRIVILEGES", studentKYSPrivileges);
		
		/****** For Student Pending KYS***********/
		studentPendingKYSPrivileges = new Ext.util.HashMap();
		studentPendingKYSPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PENDING_KYS_VIEW,"VIEW");
		studentPendingKYSPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PENDING_KYS_EXPORT,"EXPORT");
		studentPendingKYSPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_KYS_VIEW,"VIEW");
		studentPendingKYSPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_KYS_EXPORT,"EXPORT");
		studentPendingKYSPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PENDING_KYS_SUBMIT,"SUBMIT");
		studentPendingKYSPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_KYS_SUBMIT,"SUBMIT");
		studentPendingKYSPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PENDING_KYS_SUBMIT,"SUBMIT");
		featurePrivilegesMap.add("STUDENT_PENDING_KYS_PRIVILEGES", studentPendingKYSPrivileges);
		
		/****** For Student Documents***********/
		studentDocumentsPrivileges = new Ext.util.HashMap();
		studentDocumentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DOCUMENTS_VIEW,"VIEW");
		studentDocumentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DOCUMENTS_CREATE,"CREATE");
		studentDocumentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DOCUMENTS_UPDATE,"UPDATE");
		studentDocumentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DOCUMENTS_DELETE,"DELETE");
		studentDocumentsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DOCUMENTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_DOCUMENTS_PRIVILEGES", studentDocumentsPrivileges);
		
		/****** For Student Manage Appointment***********/
		studentManageAppointmentPrivileges = new Ext.util.HashMap();
		studentManageAppointmentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MANAGE_APPOINTMENT_VIEW,"VIEW");
		studentManageAppointmentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MANAGE_APPOINTMENT_DELETE,"DELETE");
		studentManageAppointmentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MANAGE_APPOINTMENT_UPDATE,"UPDATE");
		studentManageAppointmentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MANAGE_APPOINTMENT_CREATE,"CREATE");
		studentManageAppointmentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MANAGE_APPOINTMENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_MANAGE_APPOINTMENT_PRIVILEGES", studentManageAppointmentPrivileges);
		
		/****** For Student Manage Appointment followup***********/
		studentAppointmentFollowUpPrivileges = new Ext.util.HashMap();
		studentAppointmentFollowUpPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_APPOINTMENT_FOLLOWUP_VIEW,"VIEW");
		studentManageAppointmentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_APPOINTMENT_FOLLOWUP_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_MANAGE_APPOINTMENT_FOLLOWUP_PRIVILEGES", studentAppointmentFollowUpPrivileges);
		
		/****** For Student Manage Appointment followup faculty portal***********/
		studentFpAppointmentFollowUpPrivileges = new Ext.util.HashMap();
		studentFpAppointmentFollowUpPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_APPOINTMENT_FOLLOWUP_VIEW,"VIEW");
		studentFpAppointmentFollowUpPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_APPOINTMENT_FOLLOWUP_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FP_STUDENT_MANAGE_APPOINTMENT_FOLLOWUP_PRIVILEGES", studentFpAppointmentFollowUpPrivileges);
		
		
		
		studentManageAppointmentPrivilegesSP = new Ext.util.HashMap();
		studentManageAppointmentPrivilegesSP.add(FPCONSTANTS.SP_M9_F_STUDENT_MANAGE_APPOINTMENT_VIEW,"VIEW");
		studentManageAppointmentPrivilegesSP.add(FPCONSTANTS.SP_M9_F_STUDENT_MANAGE_APPOINTMENT_DELETE,"DELETE");
		studentManageAppointmentPrivilegesSP.add(FPCONSTANTS.SP_M9_F_STUDENT_MANAGE_APPOINTMENT_UPDATE,"UPDATE");
		studentManageAppointmentPrivilegesSP.add(FPCONSTANTS.SP_M9_F_STUDENT_MANAGE_APPOINTMENT_CREATE,"CREATE");
		studentManageAppointmentPrivilegesSP.add(FPCONSTANTS.SP_M9_F_STUDENT_MANAGE_APPOINTMENT_EXPORT,"EXPORT");
		studentManageAppointmentPrivilegesSP.add(FPCONSTANTS.SP_M9_F_STUDENT_MANAGE_APPOINTMENT_FOLLOW_UP_DETAILS,"FOLLOW_UP_DETAILS");
		featurePrivilegesMap.add("STUDENT_PORTAL_MANAGE_APPOINTMENT_PRIVILEGES", studentManageAppointmentPrivilegesSP);
		
		studentManageAppointmentPrivilegesFP = new Ext.util.HashMap();
		studentManageAppointmentPrivilegesFP.add(FPCONSTANTS.FP_M9_F_STUDENT_MANAGE_APPOINTMENT_VIEW,"VIEW");
		studentManageAppointmentPrivilegesFP.add(FPCONSTANTS.FP_M9_F_STUDENT_MANAGE_APPOINTMENT_DELETE,"DELETE");
		studentManageAppointmentPrivilegesFP.add(FPCONSTANTS.FP_M9_F_STUDENT_MANAGE_APPOINTMENT_UPDATE,"UPDATE");
		studentManageAppointmentPrivilegesFP.add(FPCONSTANTS.FP_M9_F_STUDENT_MANAGE_APPOINTMENT_CREATE,"CREATE");
		studentManageAppointmentPrivilegesFP.add(FPCONSTANTS.FP_M9_F_STUDENT_MANAGE_APPOINTMENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FP_STUDENT_PORTAL_MANAGE_APPOINTMENT_PRIVILEGES", studentManageAppointmentPrivilegesFP);
		
		/****** For Student portal Notification Bell Icon view***********/
		studentPortalNotificationBellIconPrivileges = new Ext.util.HashMap();
		studentPortalNotificationBellIconPrivileges.add(FPCONSTANTS.SP_M9_F_NOTIFICATION_BELL_ICON_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_PORTAL_NOTIFICATION_BELL_ICON_PRIVILEGES", studentPortalNotificationBellIconPrivileges);
		
		
		/****** For Faculty portal uploader view***********/
		facultyPortalLoaderPrivileges = new Ext.util.HashMap();
		facultyPortalLoaderPrivileges.add(FPCONSTANTS.FP_M10_G_UPLOADER_VIEW_VIEW,"VIEW");
		facultyPortalLoaderPrivileges.add(FPCONSTANTS.FP_M10_G_UPLOADER_VIEW_EVENT_MARK_ENTRY,"EVENT_MARK_ENTRY");
		facultyPortalLoaderPrivileges.add(FPCONSTANTS.FP_M10_G_UPLOADER_VIEW_QUESTION_MARK_ENTRY,"QUESTION_MARK_ENTRY");
		featurePrivilegesMap.add("FACULTY_PORTAL_LOADER_PRIVILEGES", facultyPortalLoaderPrivileges);
		
		/****** For Faculty portal Notification Bell Icon view***********/
		facultyPortalNotificationBellIconPrivileges = new Ext.util.HashMap();
		facultyPortalNotificationBellIconPrivileges.add(FPCONSTANTS.FP_M10_G_NOTIFICATION_BELL_ICON_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_NOTIFICATION_BELL_ICON_PRIVILEGES", facultyPortalNotificationBellIconPrivileges);
		
		/****** For Parent portal Notification Bell Icon view***********/
		parentPortalNotificationBellIconPrivileges = new Ext.util.HashMap();
		parentPortalNotificationBellIconPrivileges.add(FPCONSTANTS.PP_M9_F_NOTIFICATION_BELL_ICON_VIEW,"VIEW");
		featurePrivilegesMap.add("PARENT_PORTAL_NOTIFICATION_BELL_ICON_PRIVILEGES", parentPortalNotificationBellIconPrivileges);
		
		/****** For Parent portal Re-Registration Pop-up***********/
		ReRegistrationPopUpPrivileges = new Ext.util.HashMap();
		ReRegistrationPopUpPrivileges.add(FPCONSTANTS.PP_M9_F_RE_REGISTRATION_POP_UP_COMPLETE_REGISTRATION_LATER,"COMPLETE_REGISTRATION_LATER");
		featurePrivilegesMap.add("REREGISTRATION_POPUP_PRIVILEGES", ReRegistrationPopUpPrivileges);
		
		/****** For Applicant portal Notification Bell Icon view***********/
		applicanttPortalNotificationBellIconPrivileges = new Ext.util.HashMap();
		applicanttPortalNotificationBellIconPrivileges.add(FPCONSTANTS.AC_M1_F_NOTIFICATION_BELL_ICON_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICANT_PORTAL_NOTIFICATION_BELL_ICON_PRIVILEGES", applicanttPortalNotificationBellIconPrivileges);
		
		
		
		
		
		/****** For Student Termination***********/
		studentTerminationPrivileges = new Ext.util.HashMap();
		studentTerminationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSTERMINATION_VIEW,"VIEW");
		studentTerminationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSTERMINATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_TERMINATION_PRIVILEGES", studentTerminationPrivileges);
		
		/****** For Student Transfer***********/
		studentTransferPrivileges = new Ext.util.HashMap();
		studentTransferPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSTRANSFER_VIEW,"VIEW");
		studentTransferPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSTRANSFER_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_TRANSFER_PRIVILEGES", studentTransferPrivileges);
		
		/****** For Student Debarment***********/
		studentDebarmentPrivileges = new Ext.util.HashMap();
		studentDebarmentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSDEBARMENT_VIEW,"VIEW");
		studentDebarmentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSDEBARMENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_DEBARMENT_PRIVILEGES", studentDebarmentPrivileges);
		
				
		/****** For Student Manage Holds***********/
		studentManageHoldsPrivileges = new Ext.util.HashMap();
		studentManageHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSMANAGEHOLDS_VIEW,"VIEW");
		studentManageHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSMANAGEHOLDS_EXPORT,"EXPORT");
		studentManageHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSMANAGEHOLDS_CREATE,"CREATE");
		studentManageHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSMANAGEHOLDS_UPDATE,"UPDATE");
		studentManageHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSMANAGEHOLDS_DELETE,"DELETE");
		studentManageHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSMANAGEHOLDS_MOREACTIONS,"MOREACTIONS");
		studentManageHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSMANAGEHOLDS_APPLY_TO,"APPLY_TO");
		studentManageHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSMANAGEHOLDS_HOLD_SUB_CATEGORY,"HOLD_SUB_CATEGORY");
		studentManageHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSMANAGEHOLDS_IMPORT_STUDENT_HOLD,"IMPORT_STUDENT_HOLD");
		studentManageHoldsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTSMANAGEHOLDS_LOCK_PERSONAL_DETAILS,"LOCK_PERSONAL_DETAILS");
		featurePrivilegesMap.add("STUDENT_MANAGE_HOLDS_PRIVILEGES", studentManageHoldsPrivileges);
		
		/****** For Student Manage Sub Holds Category***********/
		studentManageSubHoldCatPrivileges = new Ext.util.HashMap();
		studentManageSubHoldCatPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTS_MANAGE_SUB_HOLD_CATEGORY_EXPORT,"EXPORT");
		studentManageSubHoldCatPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTS_MANAGE_SUB_HOLD_CATEGORY_CREATE,"CREATE");
		studentManageSubHoldCatPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTS_MANAGE_SUB_HOLD_CATEGORY_UPDATE,"UPDATE");
		studentManageSubHoldCatPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTS_MANAGE_SUB_HOLD_CATEGORY_DELETE,"DELETE");
		studentManageSubHoldCatPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTS_MANAGE_SUB_HOLD_CATEGORY_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_MANAGE_SUB_HOLD_CAT_PRIVILEGES", studentManageSubHoldCatPrivileges);
				
		/****** For Student Portal Holds Screen***********/
		studentPortalHoldsPrivileges = new Ext.util.HashMap();
		studentPortalHoldsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PORTAL_HOLDS_VIEW,"VIEW");
		studentPortalHoldsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PORTAL_HOLDS_HOLDS_TAB,"HOLDS_TAB");
		studentPortalHoldsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PORTAL_HOLDS_FINANCE_HOLDS_TAB,"FINANCE_HOLDS_TAB");
		studentPortalHoldsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PORTAL_HOLDS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_HOLDS_PRIVILEGES", studentPortalHoldsPrivileges);
		
		/****** For Student Portal Finance Hold Screen***********/
		studentPortalFinanceHoldPrivileges = new Ext.util.HashMap();
		studentPortalFinanceHoldPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PORTAL_FINANCE_HOLD_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_FINANCE_HOLD_PRIVILEGES", studentPortalFinanceHoldPrivileges);
		
		/****** For Student Request***********/
		studentRequestPrivileges = new Ext.util.HashMap();
		studentRequestPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTREQUEST_VIEW,"VIEW");
		studentRequestPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTREQUEST_EXPORT,"EXPORT");
		studentRequestPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTREQUEST_ALL_REQUEST,"ALL_REQUEST")
		studentRequestPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTREQUEST_TRANSFER_IN_REQUESTS,"TRANSFER_IN_REQUESTS");
	//	studentRequestPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTREQUEST_RE_ASSIGN_REQUEST,"REASSIGNREQUEST");
		//studentRequestPrivileges.add(FPCONSTANTS.PSS_M9_F_STUDENTREQUEST_CREATE,"CREATE");
		studentRequestPrivileges.add(FPCONSTANTS.PSS_M9_F_STUDENTREQUEST_VIEW,"VIEW");
		//studentRequestPrivileges.add(FPCONSTANTS.PSS_M9_F_STUDENTREQUEST_UPDATE,"UPDATE");
		studentRequestPrivileges.add(FPCONSTANTS.PSS_M9_F_STUDENTREQUEST_EXPORT,"EXPORT");
		//studentRequestPrivileges.add(FPCONSTANTS.PSS_M9_F_STUDENTREQUEST_DELETE,"DELETE");
		
		studentRequestPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENTREQUEST_VIEW,"VIEW");
		//studentRequestPrivileges.add(FPCONSTANTS.PSS_M9_F_STUDENTREQUEST_UPDATE,"UPDATE");
		studentRequestPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENTREQUEST_EXPORT,"EXPORT");
		studentRequestPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENTREQUEST_RAISEREQUEST,"RAISEREQUEST");
		studentRequestPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENTREQUEST_CANCELREQUEST,"CANCELREQUEST");
		studentRequestPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENTREQUEST_READMISSION_FORM,"READMISSION_FORM");
		studentRequestPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENTREQUEST_UPLOAD_AND_SUBMIT,"UPLOAD_AND_SUBMIT");
		studentRequestPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENTREQUEST_QUICKCOMMENT,"QUICKCOMMENT");
		studentRequestPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENTREQUEST_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		studentRequestPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENTREQUEST_FOLLOWUP_DETAILS,"FOLLOWUP_DETAILS");
		featurePrivilegesMap.add("STUDENT_REQUEST_PRIVILEGES", studentRequestPrivileges);
		
		coreERPRequestPrivileges = new Ext.util.HashMap();
		coreERPRequestPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTREQUEST_RE_ASSIGN_REQUEST,"REASSIGNREQUEST");
		coreERPRequestPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTREQUEST_CANCELREQUEST,"CANCELREQUEST");
		coreERPRequestPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTREQUEST_QUICK_COMMENT,"QUICK_COMMENT");
		coreERPRequestPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTREQUEST_READMISSION_FORM,"READMISSION_FORM");
		coreERPRequestPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTREQUEST_UPLOAD_AND_SUBMIT,"UPLOAD_AND_SUBMIT");
		coreERPRequestPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENTREQUEST_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		
		featurePrivilegesMap.add("COREERP_REQUEST_PRIVILEGES", coreERPRequestPrivileges);
		
		/****** For Student Kys report***********/
		studentKYSReportPrivileges = new Ext.util.HashMap();
		studentKYSReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSKYSREPORT_VIEW,"VIEW");
		studentKYSReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSKYSREPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_KYSREPORT_PRIVILEGES", studentKYSReportPrivileges);
		
		/****** For Student Extra Curr Activity report***********/
		studentExtraCurrActivityReportPrivileges = new Ext.util.HashMap();
		studentExtraCurrActivityReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSEXTRACURRICULUMACTIVITIESREPORT_VIEW,"VIEW");
		studentExtraCurrActivityReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSEXTRACURRICULUMACTIVITIESREPORT_EXPORT,"EXPORT");
		studentExtraCurrActivityReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSEXTRACURRICULUMACTIVITIESREPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		studentExtraCurrActivityReportPrivileges.add(FPCONSTANTS.PF_M9_R_STUDENTSEXTRACURRICULUMACTIVITIESREPORT_VIEW,"VIEW");
		
		studentExtraCurrActivityReportPrivileges.add(FPCONSTANTS.PSS_M9_R_STUDENTSEXTRACURRICULUMACTIVITIESREPORT_VIEW,"VIEW");
		studentExtraCurrActivityReportPrivileges.add(FPCONSTANTS.PSS_M9_R_STUDENTSEXTRACURRICULUMACTIVITIESREPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_EXTRACURRICULUMREPORT_PRIVILEGES", studentExtraCurrActivityReportPrivileges);
		
		/****** For Student Siblings report***********/
		studentSiblingsReportPrivileges = new Ext.util.HashMap();
		studentSiblingsReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSSIBLINGSREPORT_VIEW,"VIEW");
		studentSiblingsReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSSIBLINGSREPORT_EXPORT,"EXPORT");
		//studentSiblingsReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSSIBLINGSREPORT_EXPORT_REPORTS,"EXPORTREPORTS");
		studentSiblingsReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSSIBLINGSREPORT_STUDENT_SIBLINGS_DETAILED_REPORT,"STUDENT_SIBLINGS_DETAILED_REPORT");
		studentSiblingsReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSSIBLINGSREPORT_STUDENT_PARENT_WISE_SIBLING_REPORT,"STUDENT_PARENT_WISE_SIBLING_REPORT");
		featurePrivilegesMap.add("STUDENT_SIBLINGREPORT_PRIVILEGES", studentSiblingsReportPrivileges);
		
		/****** For Student ChildrenOfEmployee report***********/
		studentChildrenOfEmployeeReportPrivileges = new Ext.util.HashMap();
		studentChildrenOfEmployeeReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSEMPLOYEECHILDRENREPORT_VIEW,"VIEW");
		studentChildrenOfEmployeeReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSEMPLOYEECHILDRENREPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_EMPLOYEECHILDREPORT_PRIVILEGES", studentChildrenOfEmployeeReportPrivileges);
		
		/****** For Student Community report***********/
		studentCommunityReportPrivileges = new Ext.util.HashMap();
		studentCommunityReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSCOMMUNITYREPORT_VIEW,"VIEW");
		studentCommunityReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSCOMMUNITYREPORT_EXPORT,"EXPORT");
		studentCommunityReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSCOMMUNITYREPORT_EXPORT_REPORT,"EXPORTREPORTS");
		studentCommunityReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSCOMMUNITYREPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_COMMUNITYREPORT_PRIVILEGES", studentCommunityReportPrivileges);
		
		/****** For Student Unassigned Request***********/
		studentUnassignedRequestReportPrivileges = new Ext.util.HashMap();
		studentUnassignedRequestReportPrivileges.add(FPCONSTANTS.PF_M9_R_STUDENTUNASSIGNEDREQUEST_VIEW,"VIEW");
		studentUnassignedRequestReportPrivileges.add(FPCONSTANTS.PF_M9_R_STUDENTUNASSIGNEDREQUEST_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_UNASSIGNEDREQUEST_PRIVILEGES", studentUnassignedRequestReportPrivileges);
		
		/****** For Student Follow Up Scheduled***********/
		studentFollowUpScheduledReportPrivileges = new Ext.util.HashMap();
		studentFollowUpScheduledReportPrivileges.add(FPCONSTANTS.PF_M9_R_STUDENTFOLLOWUPSCHEDULED_VIEW,"VIEW");
		studentFollowUpScheduledReportPrivileges.add(FPCONSTANTS.PF_M9_R_STUDENTFOLLOWUPSCHEDULED_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_FOLLOWUPSCHEDULED_PRIVILEGES", studentFollowUpScheduledReportPrivileges);
		
		/****** For Students Reports***********/
		studentsReportPrivileges = new Ext.util.HashMap();
		studentsReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSREPORT_VIEW,"VIEW");
		studentsReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSREPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENTS_REPORT_PRIVILEGES", studentsReportPrivileges);
		
		/******************Faculty Module Starts*******************************************************/
		
		/****** For faculty List***********/
		facultyListPrivileges = new Ext.util.HashMap();
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_VIEW,"VIEW");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_EXPORT,"EXPORT");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_RAISEREQUEST,"RAISEREQUEST");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_SENDMESSAGE,"SENDMESSAGE");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_EMPLOYEES_LIST_SEND_MESSAGE_ADHOC_MESSAGE,"ADHOC_MESSAGE");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_EMPLOYEES_LIST_SEND_MESSAGE_MESSAGE_TEMPLATE,"MESSAGE_TEMPLATE");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_SENDSURVEY,"SENDSURVEY");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_PRINT,"PRINT");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_MAP_COMMITTEE,"ADD_COMMITTEE");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_IMPORT_BULK_EMPLOYEE_UPDATE,"IMPORT_BULK_EMPLOYEE_UPDATE");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_ASSIGN_CALENDAR,"ASSIGN_WORK_CALENDAR");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_BULK_DOCUMENT_DOWNLOAD_STATUS,"BULK_DOCUMENT_DOWNLOAD_STATUS");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_BULK_APPLICATION_DOCUMENT_DOWNLOAD,"BULK_APPLICATION_DOCUMENT_DOWNLOAD");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_APPOINTMENT,"APPOINTMENT");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_MOREACTION,"MOREACTION");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_ADD_LIBRARY,"ADD_LIBRARY");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_ADD_PATRON_CATEGORY,"ADD_PATRON_CATEGORY");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_DOCUMENT_REQUEST,"DOCUMENT_REQUEST");
		facultyListPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_UPLOAD_IMAGE_EDIT_ICON,"UPLOAD_IMAGE_EDIT_ICON");
		featurePrivilegesMap.add("FACULTY_LIST_PRIVILEGES", facultyListPrivileges);
		
		/****** For faculty Education***********/
		facultyEducationPrivileges = new Ext.util.HashMap();
		facultyEducationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EDUCATION_VIEW,"VIEW");
		facultyEducationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EDUCATION_CREATE,"CREATE");
		facultyEducationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EDUCATION_UPDATE,"UPDATE");
		facultyEducationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EDUCATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_EDUCATION_PRIVILEGES", facultyEducationPrivileges);
		
		facultyProfileEducationPrivileges = new Ext.util.HashMap();
		facultyProfileEducationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_EDUCATION_VIEW,"VIEW");
		facultyProfileEducationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_EDUCATION_CREATE,"CREATE");
		facultyProfileEducationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_EDUCATION_UPDATE,"UPDATE");
		facultyProfileEducationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_EDUCATION_DELETE,"DELETE");
		facultyProfileEducationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_EDUCATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_EDUCATION_PRIVILEGES", facultyProfileEducationPrivileges);
		
		/****** For faculty Work Experience***********/
		facultyWorkExperiencePrivileges = new Ext.util.HashMap();
		facultyWorkExperiencePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_WORK_EXPERIENCE_VIEW,"VIEW");
		facultyWorkExperiencePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_WORK_EXPERIENCE_CREATE,"CREATE");
		facultyWorkExperiencePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_WORK_EXPERIENCE_UPDATE,"UPDATE");
		facultyWorkExperiencePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_WORK_EXPERIENCE_DELETE,"DELETE");
		facultyWorkExperiencePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_WORK_EXPERIENCE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_WORK_EXPERIENCE_PRIVILEGES", facultyWorkExperiencePrivileges);
		
		facultyProfleWorkExperiencePrivileges = new Ext.util.HashMap();
		facultyProfleWorkExperiencePrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_WORK_EXPERIENCE_VIEW,"VIEW");
		facultyProfleWorkExperiencePrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_WORK_EXPERIENCE_CREATE,"CREATE");
		facultyProfleWorkExperiencePrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_WORK_EXPERIENCE_UPDATE,"UPDATE");
		facultyProfleWorkExperiencePrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_WORK_EXPERIENCE_DELETE,"DELETE");
		facultyProfleWorkExperiencePrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_WORK_EXPERIENCE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_WORK_EXPERIENCE_PRIVILEGES", facultyProfleWorkExperiencePrivileges);
		
		/****** For faculty Medical***********/
		facultyMedicalPrivileges = new Ext.util.HashMap();
		facultyMedicalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MEDICAL_VIEW,"VIEW");
		facultyMedicalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MEDICAL_CREATE,"CREATE");
		facultyMedicalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MEDICAL_UPDATE,"UPDATE");
		facultyMedicalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MEDICAL_DELETE,"DELETE");
		facultyMedicalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MEDICAL_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_MEDICAL_PRIVILEGES", facultyMedicalPrivileges);
		
		facultyProfileMedicalPrivileges = new Ext.util.HashMap();
		facultyProfileMedicalPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_MEDICAL_VIEW,"VIEW");
		facultyProfileMedicalPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_MEDICAL_CREATE,"CREATE");
		facultyProfileMedicalPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_MEDICAL_UPDATE,"UPDATE");
		facultyProfileMedicalPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_MEDICAL_DELETE,"DELETE");
		facultyProfileMedicalPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_MEDICAL_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_MEDICAL_PRIVILEGES", facultyProfileMedicalPrivileges);
		
		/****** For faculty Vaccination***********/
		facultyVaccinationPrivileges = new Ext.util.HashMap();
		facultyVaccinationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_VACCINATION_VIEW,"VIEW");
		facultyVaccinationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_VACCINATION_CREATE,"CREATE");
		facultyVaccinationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_VACCINATION_UPDATE,"UPDATE");
		facultyVaccinationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_VACCINATION_DELETE,"DELETE");
		facultyVaccinationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_VACCINATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_VACCINATION_PRIVILEGES", facultyVaccinationPrivileges);
		
		facultyProfileVaccinationPrivileges = new Ext.util.HashMap();
		facultyProfileVaccinationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_VACCINATION_VIEW,"VIEW");
		facultyProfileVaccinationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_VACCINATION_CREATE,"CREATE");
		facultyProfileVaccinationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_VACCINATION_UPDATE,"UPDATE");
		facultyProfileVaccinationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_VACCINATION_DELETE,"DELETE");
		facultyProfileVaccinationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_VACCINATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_VACCINATION_PRIVILEGES", facultyProfileVaccinationPrivileges);
		
		/****** For faculty Extra Curricular Activity***********/
		facultyExtraCurricularActivityPrivileges = new Ext.util.HashMap();
		facultyExtraCurricularActivityPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXTRA_CARRICULAR_ACTIVITY_VIEW,"VIEW");
		facultyExtraCurricularActivityPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXTRA_CARRICULAR_ACTIVITY_CREATE,"CREATE");
		facultyExtraCurricularActivityPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXTRA_CARRICULAR_ACTIVITY_UPDATE,"UPDATE");
		facultyExtraCurricularActivityPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXTRA_CARRICULAR_ACTIVITY_DELETE,"DELETE");
		facultyExtraCurricularActivityPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXTRA_CARRICULAR_ACTIVITY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES", facultyExtraCurricularActivityPrivileges);
		
		facultyProfileExtraCurricularActivityPrivileges = new Ext.util.HashMap();
		facultyProfileExtraCurricularActivityPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_EXTRA_CURRICULAR_ACTIVITY_VIEW,"VIEW");
		facultyProfileExtraCurricularActivityPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_EXTRA_CURRICULAR_ACTIVITY_CREATE,"CREATE");
		facultyProfileExtraCurricularActivityPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_EXTRA_CURRICULAR_ACTIVITY_UPDATE,"UPDATE");
		facultyProfileExtraCurricularActivityPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_EXTRA_CURRICULAR_ACTIVITY_DELETE,"DELETE");
		facultyProfileExtraCurricularActivityPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_EXTRA_CURRICULAR_ACTIVITY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES", facultyProfileExtraCurricularActivityPrivileges);
		
		/****** For Faculty Development Goal***********/
		facultyDevelopmentGoalPrivileges = new Ext.util.HashMap();
		facultyDevelopmentGoalPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DEVELOPMENT_GOAL_VIEW,"VIEW");
		facultyDevelopmentGoalPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DEVELOPMENT_GOAL_CREATE,"CREATE");
		facultyDevelopmentGoalPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DEVELOPMENT_GOAL_UPDATE,"UPDATE");
		facultyDevelopmentGoalPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DEVELOPMENT_GOAL_DELETE,"DELETE");
		facultyDevelopmentGoalPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DEVELOPMENT_GOAL_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_DEVELOPMENT_GOAL_PRIVILEGES", facultyDevelopmentGoalPrivileges);
		
		facultyPortalDevelopmentGoalPrivileges = new Ext.util.HashMap();
		facultyPortalDevelopmentGoalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DEVELOPMENT_GOAL_VIEW,"VIEW");
		facultyPortalDevelopmentGoalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DEVELOPMENT_GOAL_CREATE,"CREATE");
		facultyPortalDevelopmentGoalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DEVELOPMENT_GOAL_UPDATE,"UPDATE");
		facultyPortalDevelopmentGoalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DEVELOPMENT_GOAL_DELETE,"DELETE");
		facultyPortalDevelopmentGoalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DEVELOPMENT_GOAL_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_DEVELOPMENT_GOAL_PRIVILEGES", facultyPortalDevelopmentGoalPrivileges);
		
		/****** For Faculty Course Interest***********/
		facultyCourseInterestPrivileges = new Ext.util.HashMap();
		facultyCourseInterestPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COURSE_INTEREST_VIEW,"VIEW");
		facultyCourseInterestPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COURSE_INTEREST_CREATE,"CREATE");
		facultyCourseInterestPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COURSE_INTEREST_UPDATE,"UPDATE");
		facultyCourseInterestPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COURSE_INTEREST_DELETE,"DELETE");
		facultyCourseInterestPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COURSE_INTEREST_EXPORT,"EXPORT");
		facultyCourseInterestPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COURSE_INTEREST_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_COURSE_INTEREST_PRIVILEGES", facultyCourseInterestPrivileges);
		
		/******* For faculty Competitive Exam ************/
		
		facultyCompetitiveExamPrivileges = new Ext.util.HashMap();
		facultyCompetitiveExamPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COMPETITIVE_EXAM_DETAILS_VIEW,"VIEW");
		facultyCompetitiveExamPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COMPETITIVE_EXAM_DETAILS_CREATE,"CREATE");
		facultyCompetitiveExamPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COMPETITIVE_EXAM_DETAILS_UPDATE,"UPDATE");
		facultyCompetitiveExamPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COMPETITIVE_EXAM_DETAILS_DELETE,"DELETE");
		facultyCompetitiveExamPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COMPETITIVE_EXAM_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_COMPETITIVE_EXAM_PRIVILEGES", facultyCompetitiveExamPrivileges);
		
		facultyProfileCompetitiveExamPrivileges = new Ext.util.HashMap();
		facultyProfileCompetitiveExamPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_COMPETITIVE_EXAM_VIEW,"VIEW");
		facultyProfileCompetitiveExamPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_COMPETITIVE_EXAM_CREATE,"CREATE");
		facultyProfileCompetitiveExamPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_COMPETITIVE_EXAM_UPDATE,"UPDATE");
		facultyProfileCompetitiveExamPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_COMPETITIVE_EXAM_DELETE,"DELETE");
		facultyProfileCompetitiveExamPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_COMPETITIVE_EXAM_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_COMPETITIVE_EXAM_PRIVILEGES", facultyProfileCompetitiveExamPrivileges);
		
		/******* For Faculty Hostel Details ************/
		
		facultyHostelDetailsExamPrivileges = new Ext.util.HashMap();
		facultyHostelDetailsExamPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_HOSTEL_DETAILS_VIEW,"VIEW");
		facultyHostelDetailsExamPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_HOSTEL_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_HOSTEL_DETAILS_PRIVILEGES", facultyHostelDetailsExamPrivileges);
	
		
		facultyProfileHostelDetailsPrivileges = new Ext.util.HashMap();
		facultyProfileHostelDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_HOSTEL_DETAILS_VIEW,"VIEW");
		facultyProfileHostelDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_HOSTEL_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_HOSTEL_DETAILS_PRIVILEGES", facultyProfileHostelDetailsPrivileges);
		
		/******* For Faculty My Committes Details ************/
		facultyMyCommitteesPrivileges = new Ext.util.HashMap();
		facultyMyCommitteesPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MY_COMMITTEES_VIEW,"VIEW");
		facultyMyCommitteesPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MY_COMMITTEES_EXPORT,"EXPORT");
		facultyMyCommitteesPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MY_COMMITTEES_PARTICIPANT_HYPERLINK,"PARTICIPANT_HYPERLINK");
		featurePrivilegesMap.add("FACULTY_PROFILE_MY_COMMITTEES_PRIVILEGES", facultyMyCommitteesPrivileges);
		
		/******* For Faculty Transport Details ************/
		
		
		facultyTransportDetailsExamPrivileges = new Ext.util.HashMap();
		facultyTransportDetailsExamPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_TRANSPORT_DETAILS_VIEW,"VIEW");
		facultyTransportDetailsExamPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_TRANSPORT_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_TRANSPORT_DETAILS_PRIVILEGES", facultyTransportDetailsExamPrivileges);
		
		facultyProfileTransportDetailsPrivileges = new Ext.util.HashMap();
		facultyProfileTransportDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_TRANSPORT_DETAILS_VIEW,"VIEW");
		facultyProfileTransportDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_TRANSPORT_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_TRANSPORT_DETAILS_PRIVILEGES", facultyProfileTransportDetailsPrivileges);
		
		/******* For Faculty Event Schedules************/
		
		facultyEventSchedulesPrivileges = new Ext.util.HashMap();
		facultyEventSchedulesPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EVENT_SCHEDULES_VIEW,"VIEW");
		facultyEventSchedulesPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EVENT_SCHEDULES_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_EVENT_SCHEDULES_PRIVILEGES", facultyEventSchedulesPrivileges);
		
		
		/******* For Faculty Elections************/
		
		facultyElectionsPrivileges = new Ext.util.HashMap();
		facultyElectionsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ELECTIONS_VIEW,"VIEW");
		facultyElectionsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ELECTIONS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_ELECTIONS_PRIVILEGES", facultyElectionsPrivileges);
		
		/****** For faculty Seminar Details***********/
		
		facultySeminarDetailsPrivileges = new Ext.util.HashMap();
		facultySeminarDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SEMINAR_DETAILS_VIEW,"VIEW");
		facultySeminarDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SEMINAR_DETAILS_EXPORT,"EXPORT");
		facultySeminarDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SEMINAR_DETAILS_CREATE,"CREATE");
		facultySeminarDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SEMINAR_DETAILS_UPDATE,"UPDATE");
		facultySeminarDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SEMINAR_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_SEMINAR_DETAILS_PRIVILEGES", facultySeminarDetailsPrivileges);
		
		facultyProfileSeminarDetailsPrivileges = new Ext.util.HashMap();
		facultyProfileSeminarDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_SEMINAR_DETAILS_VIEW,"VIEW");
		facultyProfileSeminarDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_SEMINAR_DETAILS_EXPORT,"EXPORT");
		facultyProfileSeminarDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_SEMINAR_DETAILS_CREATE,"CREATE");
		facultyProfileSeminarDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_SEMINAR_DETAILS_UPDATE,"UPDATE");
		facultyProfileSeminarDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_SEMINAR_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_PROFILE_SEMINAR_DETAILS_PRIVILEGES", facultyProfileSeminarDetailsPrivileges);
		
		/****** For Employee profile Physical Characteristics***********/
		facultyProfilePhysicalCharacteristicsPrivileges = new Ext.util.HashMap();
		facultyProfilePhysicalCharacteristicsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_PHYSICAL_CHARACTERISTICS_VIEW,"VIEW");
		facultyProfilePhysicalCharacteristicsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_PHYSICAL_CHARACTERISTICS_EXPORT,"EXPORT");
		facultyProfilePhysicalCharacteristicsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_PHYSICAL_CHARACTERISTICS_CREATE,"CREATE");
		facultyProfilePhysicalCharacteristicsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_PHYSICAL_CHARACTERISTICS_UPDATE,"UPDATE");
		facultyProfilePhysicalCharacteristicsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_PHYSICAL_CHARACTERISTICS_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_PROFILE_PHYSICAL_CHARACTERISTICS_PRIVILEGES", facultyProfilePhysicalCharacteristicsPrivileges);
		
		/****** For faculty Physical Characteristics***********/
		
		facultyPhysicalCharacteristicsPrivileges = new Ext.util.HashMap();
		facultyPhysicalCharacteristicsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PHYSICAL_CHARACTERISTICS_VIEW,"VIEW");
		facultyPhysicalCharacteristicsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PHYSICAL_CHARACTERISTICS_EXPORT,"EXPORT");
		facultyPhysicalCharacteristicsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PHYSICAL_CHARACTERISTICS_CREATE,"CREATE");
		facultyPhysicalCharacteristicsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PHYSICAL_CHARACTERISTICS_UPDATE,"UPDATE");
		facultyPhysicalCharacteristicsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PHYSICAL_CHARACTERISTICS_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_PHYSICAL_CHARACTERISTICS_PRIVILEGES", facultyPhysicalCharacteristicsPrivileges);
		
		/****** For Employee profile Insurance History***********/
		facultyProfileInsuranceHistoryPrivileges = new Ext.util.HashMap();
		facultyProfileInsuranceHistoryPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_INSURANCE_HISTORY_VIEW,"VIEW");
		facultyProfileInsuranceHistoryPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_INSURANCE_HISTORY_EXPORT,"EXPORT");
		facultyProfileInsuranceHistoryPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_INSURANCE_HISTORY_CREATE,"CREATE");
		facultyProfileInsuranceHistoryPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_INSURANCE_HISTORY_UPDATE,"UPDATE");
		facultyProfileInsuranceHistoryPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_INSURANCE_HISTORY_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_PROFILE_INSURANCE_HISTORY_PRIVILEGES", facultyProfileInsuranceHistoryPrivileges);
		
		/****** For faculty Insurance History***********/
		
		facultyInsuranceHistoryPrivileges = new Ext.util.HashMap();
		facultyInsuranceHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_INSURANCE_HISTORY_VIEW,"VIEW");
		facultyInsuranceHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_INSURANCE_HISTORY_EXPORT,"EXPORT");
		facultyInsuranceHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_INSURANCE_HISTORY_CREATE,"CREATE");
		facultyInsuranceHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_INSURANCE_HISTORY_UPDATE,"UPDATE");
		facultyInsuranceHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_INSURANCE_HISTORY_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_INSURANCE_HISTORY_PRIVILEGES", facultyInsuranceHistoryPrivileges);
		
		/****** For faculty Training***********/
		facultyTrainingPrivileges = new Ext.util.HashMap();
		facultyTrainingPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_TRAINING_DETAILS_VIEW,"VIEW");
		facultyTrainingPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_TRAINING_DETAILS_EXPORT,"EXPORT");
		facultyTrainingPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_TRAINING_DETAILS_CREATE,"CREATE");
		facultyTrainingPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_TRAINING_DETAILS_UPDATE,"UPDATE");
		facultyTrainingPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_TRAINING_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_TRAINING_PRIVILEGES", facultyTrainingPrivileges);
		
		/****** For faculty Qualification***********/
		facultyQualificationPrivileges = new Ext.util.HashMap();
		facultyQualificationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_QUALIFICATION_DETAILS_VIEW,"VIEW");
		facultyQualificationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_QUALIFICATION_DETAILS_CREATE,"CREATE");
		facultyQualificationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_QUALIFICATION_DETAILS_UPDATE,"UPDATE");
		facultyQualificationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_QUALIFICATION_DETAILS_DELETE,"DELETE");
		facultyQualificationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_QUALIFICATION_DETAILS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_QUALIFICATION_PRIVILEGES", facultyQualificationPrivileges);
		
		facultyProfileTrainingPrivileges = new Ext.util.HashMap();
		facultyProfileTrainingPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_TRAINING_VIEW,"VIEW");
		facultyProfileTrainingPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_TRAINING_CREATE,"CREATE");
		facultyProfileTrainingPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_TRAINING_UPDATE,"UPDATE");
		facultyProfileTrainingPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_TRAINING_DELETE,"DELETE");
		facultyProfileTrainingPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_TRAINING_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_TRAINING_PRIVILEGES", facultyProfileTrainingPrivileges);
		
		/****** For faculty Attendance***********/
		facultyAttendancePrivileges = new Ext.util.HashMap();
		facultyAttendancePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ATTENDANCE_VIEW,"VIEW");
		facultyAttendancePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ATTENDANCE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_ATTENDANCE_PRIVILEGES", facultyAttendancePrivileges);
		
		/**************Faculty Teaching Hour**********************************/
		facultyTeachingHoursPrivileges = new Ext.util.HashMap();
		facultyTeachingHoursPrivileges.add(FPCONSTANTS.FP_M9_F_TEACHING_HOURS_VIEW,"VIEW");
		facultyTeachingHoursPrivileges.add(FPCONSTANTS.FP_M9_F_TEACHING_HOURS_EXPORT,"EXPORT");
		//facultyTeachingHoursPrivileges.add(FPCONSTANTS.FP_M9_F_TEACHING_HOURS_SAVE,"SAVE");
		featurePrivilegesMap.add("FACULTY_PORTAL_TEACHING_HOUR_PRIVILEGES", facultyTeachingHoursPrivileges);
		
		/**************Faculty Learning Targets**********************************/
		facultyLearningTargetsPrivileges = new Ext.util.HashMap();
		facultyLearningTargetsPrivileges.add(FPCONSTANTS.FP_M9_F_LEARNING_TARGETS_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_LEARNING_TARGETS_PRIVILEGES", facultyLearningTargetsPrivileges);
		 
	    /**************CORE-ERP Learning Targets**********************************/
		facultyLearningTargetsCorePrivileges = new Ext.util.HashMap();
		//facultyLearningTargetsCorePrivileges.add(FPCONSTANTS.PC_M4_F_LEARNING_TARGETS_SAVE,"SAVE");
		facultyLearningTargetsCorePrivileges.add(FPCONSTANTS.PC_M4_F_LEARNING_TARGETS_APPROVE_TARGETS,"APPROVE_TARGETS");
		featurePrivilegesMap.add("LEARNING_TARGETS_PERMISSIONS", facultyLearningTargetsCorePrivileges);
		
		facultyProfileAttendancePrivileges = new Ext.util.HashMap();
		facultyProfileAttendancePrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ATTENDANCE_VIEW,"VIEW");
		facultyProfileAttendancePrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ATTENDANCE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_ATTENDANCE_PRIVILEGES", facultyProfileAttendancePrivileges);
		/*********faculty teaching hour  for core erp***/
		
		facultyEmpTeachingHoursPrivileges = new Ext.util.HashMap();
		facultyEmpTeachingHoursPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_TEACHING_HOURSCE_VIEW,"VIEW");
		facultyEmpTeachingHoursPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_TEACHING_HOURS_EXPORT,"EXPORT");
		facultyEmpTeachingHoursPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_TEACHING_HOURS_SAVE,"SAVE");
		featurePrivilegesMap.add("FACULTY_PROFILE_TEACHING_HOUR_PRIVILEGES", facultyEmpTeachingHoursPrivileges);
		/****** For faculty Profile Schedule***********/
		facultySchedulePrivileges = new Ext.util.HashMap();
		facultySchedulePrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_SCHEDULE_VIEW,"VIEW");
		facultySchedulePrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_SCHEDULE_EXPORT_TO_PNG,"EXPORT_TO_PNG");
		featurePrivilegesMap.add("FACULTY_PROFILE_SCHEDULE_PRIVILEGES", facultySchedulePrivileges);
		
		/****** For faculty Assessment Scheme***********/
		facultyEvaluationPlanPrivileges = new Ext.util.HashMap();
		facultyEvaluationPlanPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_EVALUATION_PLANS_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_EVALUATION_PLANS_PRIVILEGES", facultyEvaluationPlanPrivileges);
		
		/****** For faculty Program & Courses***********/
		facultyProgramCoursesPrivileges = new Ext.util.HashMap();
		facultyProgramCoursesPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PROGRAM_AND_COURSE_VIEW,"VIEW");
		facultyProgramCoursesPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PROGRAM_AND_COURSE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROGRAM_COURSE_PRIVILEGES", facultyProgramCoursesPrivileges);

		facultyProfileProgramCoursesPrivileges = new Ext.util.HashMap();
		facultyProfileProgramCoursesPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PROGRAM_COURSE_VIEW,"VIEW");
		facultyProfileProgramCoursesPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PROGRAM_COURSE_CREATE,"CREATE");
		facultyProfileProgramCoursesPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PROGRAM_COURSE_UPDATE,"UPDATE");
		facultyProfileProgramCoursesPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PROGRAM_COURSE_DELETE,"DELETE");
		facultyProfileProgramCoursesPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PROGRAM_COURSE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_PROGRAM_COURSE_PRIVILEGES", facultyProfileProgramCoursesPrivileges);
		
		/****** For faculty Examination Duty Profile***********/
		facultyProfileExaminationDutyPrivileges = new Ext.util.HashMap();
		facultyProfileExaminationDutyPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_EXAM_DUTY_VIEW,"VIEW");
		facultyProfileExaminationDutyPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_EXAM_DUTY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_EXAMINATION_DUTY_PRIVILEGES", facultyProfileExaminationDutyPrivileges);
		
		/****** For Faculty Services History***********/
		facultyServicesHistoryPrivileges = new Ext.util.HashMap();
		facultyServicesHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SERVICE_HISTORY_VIEW,"VIEW");
		facultyServicesHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SERVICE_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_SERVICES_HISTORY_PRIVILEGES", facultyServicesHistoryPrivileges);
		
		facultyProfileServicesHistoryPrivileges = new Ext.util.HashMap();
		facultyProfileServicesHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_SERVICES_HISTORY_VIEW,"VIEW");
		facultyProfileServicesHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_SERVICES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_SERVICES_HISTORY_PRIVILEGES", facultyProfileServicesHistoryPrivileges);
		
		/****** For faculty Service Opt In/Opt Out***********/
		facultyServiceOptPrivileges = new Ext.util.HashMap();
		facultyServiceOptPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SERVICE_OPTIN_OPTOUT_VIEW,"VIEW");
		facultyServiceOptPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SERVICE_OPTIN_OPTOUT_CREATE,"CREATE");
		facultyServiceOptPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SERVICE_OPTIN_OPTOUT_UPDATE,"UPDATE");
		facultyServiceOptPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SERVICE_OPTIN_OPTOUT_DELETE,"DELETE");
		facultyServiceOptPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SERVICE_OPTIN_OPTOUT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_SERVICE_OPT_PRIVILEGES", facultyServiceOptPrivileges);
		
		facultyProfileServiceOptPrivileges = new Ext.util.HashMap();
		facultyProfileServiceOptPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_SERVICE_OPT_VIEW,"VIEW");
		facultyProfileServiceOptPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_SERVICE_OPT_CREATE,"CREATE");
		facultyProfileServiceOptPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_SERVICE_OPT_UPDATE,"UPDATE");
		facultyProfileServiceOptPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_SERVICE_OPT_DELETE,"DELETE");
		facultyProfileServiceOptPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_SERVICE_OPT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_SERVICE_OPT_PRIVILEGES", facultyProfileServiceOptPrivileges);
		
		/****** For faculty Communities History***********/
		facultyCommunitiesHistoryPrivileges = new Ext.util.HashMap();
		facultyCommunitiesHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COMMUNITIES_HISTORY_VIEW,"VIEW");
		facultyCommunitiesHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COMMUNITIES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_COMMUNITIES_HISTORY_PRIVILEGES", facultyCommunitiesHistoryPrivileges);
		
		facultyProfileCommunitiesHistoryPrivileges = new Ext.util.HashMap();
		facultyProfileCommunitiesHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COMMUNITIES_HISTORY_VIEW,"VIEW");
		facultyProfileCommunitiesHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COMMUNITIES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_COMMUNITIES_HISTORY_PRIVILEGES", facultyProfileCommunitiesHistoryPrivileges);
		
		/****** For faculty Communities Opt In/Opt Out***********/
		facultyCommunitiesOptPrivileges = new Ext.util.HashMap();
		facultyCommunitiesOptPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COMMUNITIES_OPTIN_OPTOUT_VIEW,"VIEW");
		facultyCommunitiesOptPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COMMUNITIES_OPTIN_OPTOUT_CREATE,"CREATE");
		facultyCommunitiesOptPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COMMUNITIES_OPTIN_OPTOUT_UPDATE,"UPDATE");
		facultyCommunitiesOptPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COMMUNITIES_OPTIN_OPTOUT_DELETE,"DELETE");
		facultyCommunitiesOptPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COMMUNITIES_OPTIN_OPTOUT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_COMMUNITIES_OPT_PRIVILEGES", facultyCommunitiesOptPrivileges);
		
		facultyProfileCommunitiesOptPrivileges = new Ext.util.HashMap();
		facultyProfileCommunitiesOptPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COMMUNITIES_OPT_VIEW,"VIEW");
		facultyProfileCommunitiesOptPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COMMUNITIES_OPT_CREATE,"CREATE");
		facultyProfileCommunitiesOptPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COMMUNITIES_OPT_UPDATE,"UPDATE");
		facultyProfileCommunitiesOptPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COMMUNITIES_OPT_DELETE,"DELETE");
		facultyProfileCommunitiesOptPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COMMUNITIES_OPT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_COMMUNITIES_OPT_PRIVILEGES", facultyProfileCommunitiesOptPrivileges);
		
		/****** For Faculty Request Raised History***********/
		facultyRequestRaisedHistoryPrivileges = new Ext.util.HashMap();
		facultyRequestRaisedHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_REQUEST_RAISED_HISTORY_VIEW,"VIEW");
		facultyRequestRaisedHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_REQUEST_RAISED_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_REQUEST_RAISED_HISTORY_PRIVILEGES", facultyRequestRaisedHistoryPrivileges);
		
		facultyProfileRequestRaisedHistoryPrivileges = new Ext.util.HashMap();
		facultyProfileRequestRaisedHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REQUEST_RAISED_HISTORY_VIEW,"VIEW");
		facultyProfileRequestRaisedHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REQUEST_RAISED_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_REQUEST_RAISED_HISTORY_PRIVILEGES", facultyProfileRequestRaisedHistoryPrivileges);
		
		/****** For faculty Request Executed History***********/
		facultyRequestExecutedHistoryPrivileges = new Ext.util.HashMap();
		facultyRequestExecutedHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_REQUEST_EXECUTED_HISTORY_VIEW,"VIEW");
		facultyRequestExecutedHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_REQUEST_EXECUTED_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_REQUEST_EXECUTED_HISTORY_PRIVILEGES", facultyRequestExecutedHistoryPrivileges);
		
		facultyProfileRequestExecutedHistoryPrivileges = new Ext.util.HashMap();
		facultyProfileRequestExecutedHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REQUEST_EXECUTED_HISTORY_VIEW,"VIEW");
		facultyProfileRequestExecutedHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REQUEST_EXECUTED_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_REQUEST_EXECUTED_HISTORY_PRIVILEGES", facultyProfileRequestExecutedHistoryPrivileges);
		
		/****** For Faculty Request Pending Descision***********/
		facultyRequestPendingDescisionPrivileges = new Ext.util.HashMap();
		facultyRequestPendingDescisionPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_REQUEST_PENDING_DECISION_VIEW,"VIEW");
		facultyRequestPendingDescisionPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_REQUEST_PENDING_DECISION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_REQUEST_PENDING_DESCISION_PRIVILEGES", facultyRequestPendingDescisionPrivileges);
		
		facultyProfileRequestPendingDescisionPrivileges = new Ext.util.HashMap();
		facultyProfileRequestPendingDescisionPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REQUEST_PENDING_DESCISION_VIEW,"VIEW");
		facultyProfileRequestPendingDescisionPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REQUEST_PENDING_DESCISION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_REQUEST_PENDING_DESCISION_PRIVILEGES", facultyProfileRequestPendingDescisionPrivileges);
		
		/****** For faculty Request Pending Action***********/
		facultyRequestPendingActionPrivileges = new Ext.util.HashMap();
		facultyRequestPendingActionPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_REQUEST_PENDING_ACTION_VIEW,"VIEW");
		facultyRequestPendingActionPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_REQUEST_PENDING_ACTION_EXPORT,"EXPORT");
		facultyRequestPendingActionPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_REQUEST_PENDING_ACTION_QUICKCOMMENT,"QUICKCOMMENT");
		featurePrivilegesMap.add("FACULTY_REQUEST_PENDING_ACTION_PRIVILEGES", facultyRequestPendingActionPrivileges);
		
		facultyProfileRequestPendingActionPrivileges = new Ext.util.HashMap();
		facultyProfileRequestPendingActionPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REQUEST_PENDING_ACTION_VIEW,"VIEW");
		facultyProfileRequestPendingActionPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REQUEST_PENDING_ACTION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_REQUEST_PENDING_ACTION_PRIVILEGES", facultyProfileRequestPendingActionPrivileges);
		
		/****** For Faculty Feedback Given***********/
		facultyFeedbackGivenPrivileges = new Ext.util.HashMap();
		facultyFeedbackGivenPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_FEEDBACK_GIVEN_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_FEEDBACK_GIVEN_PRIVILEGES", facultyFeedbackGivenPrivileges);
		
		/****** For Faculty Feedback Received***********/
		facultyFeedbackReceivedPrivileges = new Ext.util.HashMap();
		facultyFeedbackReceivedPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_FEEDBACK_RECEIVED_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_FEEDBACK_RECEIVED_PRIVILEGES", facultyFeedbackReceivedPrivileges);
		
		/****** For Faculty Active Survey***********/
		facultyActiveSurveyPrivileges = new Ext.util.HashMap();
		facultyActiveSurveyPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ACTIVE_SURVEY_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_ACTIVE_SURVEY_PRIVILEGES", facultyActiveSurveyPrivileges);
		
		/****** For Faculty Survey History***********/
		facultySurveyHistoryPrivileges = new Ext.util.HashMap();
		facultySurveyHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_SURVEY_HISTORY_VIEW,"VIEW");
		facultySurveyHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_SURVEY_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_SURVEY_HISTORY_PRIVILEGES", facultySurveyHistoryPrivileges);
		
		/****** For Faculty Pending Bills***********/
		facultyPendingBillsPrivileges = new Ext.util.HashMap();
		facultyPendingBillsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_BILLS_VIEW,"VIEW");
		facultyPendingBillsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_BILLS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PENDING_BILLS_PRIVILEGES", facultyPendingBillsPrivileges);
		
		facultyProfilePendingBillsPrivileges = new Ext.util.HashMap();
		facultyProfilePendingBillsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PENDING_BILLS_VIEW,"VIEW");
		facultyProfilePendingBillsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PENDING_BILLS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_PENDING_BILLS_PRIVILEGES", facultyProfilePendingBillsPrivileges);
		
		/****** For Faculty Payment Recieved***********/
		facultyPaymentRecievedPrivileges = new Ext.util.HashMap();
		facultyPaymentRecievedPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_RECIEPTS_VIEW,"VIEW");
		facultyPaymentRecievedPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_RECIEPTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PAYMENT_RECIEVED_PRIVILEGES", facultyPaymentRecievedPrivileges);
		
		facultyProfilePaymentRecievedPrivileges = new Ext.util.HashMap();
		facultyProfilePaymentRecievedPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PAYMENT_RECIEVED_VIEW,"VIEW");
		facultyProfilePaymentRecievedPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PAYMENT_RECIEVED_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_PAYMENT_RECIEVED_PRIVILEGES", facultyProfilePaymentRecievedPrivileges);
		
		/****** For Faculty Refunds***********/
		facultyRefundsPrivileges = new Ext.util.HashMap();
		facultyRefundsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REFUNDS_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_REFUNDS_PRIVILEGES", facultyRefundsPrivileges);
		
		/****** For Faculty Refundable Payments***********/
		facultyRefundablePaymentsPrivileges = new Ext.util.HashMap();
		facultyRefundablePaymentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REFUNDABLE_PAYMENTS_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_REFUNDABLE_PAYMENTS_PRIVILEGES", facultyRefundablePaymentsPrivileges);
		
		/****** For Faculty Post Dated Cheques***********/
		facultyPostDatedChequesPrivileges = new Ext.util.HashMap();
		facultyPostDatedChequesPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_POST_DATED_CHEQUES_VIEW,"VIEW");
		facultyPostDatedChequesPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_POST_DATED_CHEQUES_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_POST_DATED_CHEQUES_PRIVILEGES", facultyPostDatedChequesPrivileges);
		
		facultyProfilePostDatedChequesPrivileges = new Ext.util.HashMap();
		facultyProfilePostDatedChequesPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_POST_DATED_CHEQUES_VIEW,"VIEW");
		facultyProfilePostDatedChequesPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_POST_DATED_CHEQUES_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_POST_DATED_CHEQUES_PRIVILEGES", facultyProfilePostDatedChequesPrivileges);
		
		/****** For Faculty Payment Settings***********/
		facultyPaymentSettingsPrivileges = new Ext.util.HashMap();
		facultyPaymentSettingsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PAYMENT_SETTINGS_VIEW,"VIEW");
		facultyPaymentSettingsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PAYMENT_SETTINGS_CREATE,"CREATE");
		facultyPaymentSettingsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PAYMENT_SETTINGS_UPDATE,"UPDATE");
		facultyPaymentSettingsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PAYMENT_SETTINGS_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_PAYMENT_SETTINGS_PRIVILEGES", facultyPaymentSettingsPrivileges);
		
		/****** For Faculty Unpaid Faculty Bills***********/
		facultyUnpaidFacultyBillsPrivileges = new Ext.util.HashMap();
		facultyUnpaidFacultyBillsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_UNPAID_FACULTY_BILLS_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_UNPAID_FACULTY_BILLS_PRIVILEGES", facultyUnpaidFacultyBillsPrivileges);
		
		/****** For Faculty Unbilled Sessions***********/
		facultyUnbilledSessionsPrivileges = new Ext.util.HashMap();
		facultyUnbilledSessionsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_UNBILLED_SESSIONS_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_UNBILLED_SESSIONS_PRIVILEGES", facultyUnbilledSessionsPrivileges);
		
		/****** For Faculty Over Payments***********/
		facultyOverPaymentsPrivileges = new Ext.util.HashMap();
		facultyOverPaymentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_OVER_PAYMENTS_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_OVER_PAYMENTS_PRIVILEGES", facultyOverPaymentsPrivileges);
		
		/****** For Faculty Payment Made History***********/
		facultyPaymentMadeHistoryPrivileges = new Ext.util.HashMap();
		facultyPaymentMadeHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PAYMENT_MADE_HISTORY_VIEW,"VIEW");
		facultyPaymentMadeHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PAYMENT_MADE_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PAYMENT_MADE_HISTORY_PRIVILEGES", facultyPaymentMadeHistoryPrivileges);
		
		facultyProfilePaymentMadeHistoryPrivileges = new Ext.util.HashMap();
		facultyProfilePaymentMadeHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PAYMENT_MADE_HISTORY_VIEW,"VIEW");
		facultyProfilePaymentMadeHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PAYMENT_MADE_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_PAYMENT_MADE_HISTORY_PRIVILEGES", facultyProfilePaymentMadeHistoryPrivileges);
		
		/****** For Faculty Disciplinary Actions***********/
		facultyDisciplinaryActionsPrivileges = new Ext.util.HashMap();
		facultyDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DISCIPLINARY_ACTION_VIEW,"VIEW");
		facultyDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DISCIPLINARY_ACTION_CREATE,"CREATE");
		facultyDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DISCIPLINARY_ACTION_UPDATE,"UPDATE");
		facultyDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DISCIPLINARY_ACTION_DELETE,"DELETE");
		facultyDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DISCIPLINARY_ACTION_EXPORT,"EXPORT");
		facultyDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DISCIPLINARY_ACTION_DOCUMENT_DELETE, "FP_DOCUMENT_DELETE");
		featurePrivilegesMap.add("FACULTY_DISCIPLINARY_ACTIONS_PRIVILEGES", facultyDisciplinaryActionsPrivileges);
		
		facultyProfileDisciplinaryActionsPrivileges = new Ext.util.HashMap();
		facultyProfileDisciplinaryActionsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DISCIPLINARY_ACTIONS_VIEW,"VIEW");
		facultyProfileDisciplinaryActionsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DISCIPLINARY_ACTIONS_CREATE,"CREATE");
		facultyProfileDisciplinaryActionsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DISCIPLINARY_ACTIONS_UPDATE,"UPDATE");
		facultyProfileDisciplinaryActionsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DISCIPLINARY_ACTIONS_DELETE,"DELETE");
		facultyProfileDisciplinaryActionsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DISCIPLINARY_ACTIONS_EXPORT,"EXPORT");
		facultyProfileDisciplinaryActionsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DISCIPLINARY_ACTIONS_DOCUMENT_DELETE,"PF_DOCUMENT_DELETE");
		featurePrivilegesMap.add("FACULTY_PROFILE_DISCIPLINARY_ACTIONS_PRIVILEGES", facultyProfileDisciplinaryActionsPrivileges);
		
		/****** For Faculty Negative Incidents***********/
		facultyNegativeIncidentsPrivileges = new Ext.util.HashMap();
		facultyNegativeIncidentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_NEGATIVE_INCIDENTS_VIEW,"VIEW");
		facultyNegativeIncidentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_NEGATIVE_INCIDENTS_CREATE,"CREATE");
		facultyNegativeIncidentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_NEGATIVE_INCIDENTS_UPDATE,"UPDATE");
		facultyNegativeIncidentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_NEGATIVE_INCIDENTS_DELETE,"DELETE");
		facultyNegativeIncidentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_NEGATIVE_INCIDENTS_EXPORT,"EXPORT");
		
		facultyNegativeIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_NEGATIVE_INCIDENTS_VIEW,"VIEW");
		facultyNegativeIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_NEGATIVE_INCIDENTS_CREATE,"CREATE");
		facultyNegativeIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_NEGATIVE_INCIDENTS_UPDATE,"UPDATE");
		facultyNegativeIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_NEGATIVE_INCIDENTS_DELETE,"DELETE");
		facultyNegativeIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_NEGATIVE_INCIDENTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_NEGATIVE_INCIDENTS_PRIVILEGES", facultyNegativeIncidentsPrivileges);
		
		/****** For Faculty Positive Incidents***********/
		facultyPositiveIncidentsPrivileges = new Ext.util.HashMap();
		facultyPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_POSITIVE_INCIDENTS_VIEW,"VIEW");
		facultyPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_POSITIVE_INCIDENTS_CREATE,"CREATE");
		facultyPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_POSITIVE_INCIDENTS_UPDATE,"UPDATE");
		facultyPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_POSITIVE_INCIDENTS_DELETE,"DELETE");
		facultyPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_POSITIVE_INCIDENTS_EXPORT,"EXPORT");
		facultyPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_POSITIVE_INCIDENTS_DOCUMENT_DELETE,"FP_PI_DOC_DELETE");
		featurePrivilegesMap.add("FACULTY_POSITIVE_INCIDENTS_PRIVILEGES", facultyPositiveIncidentsPrivileges);
		
		facultyProfilePositiveIncidentsPrivileges = new Ext.util.HashMap();
		facultyProfilePositiveIncidentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_POSITIVE_INCIDENTS_VIEW,"VIEW");
		facultyProfilePositiveIncidentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_POSITIVE_INCIDENTS_CREATE,"CREATE");
		facultyProfilePositiveIncidentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_POSITIVE_INCIDENTS_UPDATE,"UPDATE");
		facultyProfilePositiveIncidentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_POSITIVE_INCIDENTS_DELETE,"DELETE");
		facultyProfilePositiveIncidentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_POSITIVE_INCIDENTS_EXPORT,"EXPORT");
		facultyProfilePositiveIncidentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_POSITIVE_INCIDENTS_DOCUMENT_DELETE,"PF_PI_DOC_DELETE");
		featurePrivilegesMap.add("FACULTY_PROFILE_POSITIVE_INCIDENTS_PRIVILEGES", facultyProfilePositiveIncidentsPrivileges);
		
		/****** For Faculty Documents***********/
		facultyDocumentsPrivileges = new Ext.util.HashMap();
		facultyDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DOCUMENTS_VIEW,"VIEW");
		facultyDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DOCUMENTS_CREATE,"CREATE");
		facultyDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DOCUMENTS_UPDATE,"UPDATE");
		facultyDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DOCUMENTS_DELETE,"DELETE");
		facultyDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_DOCUMENTS_EXPORT,"EXPORT");
		
		facultyDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DOCUMENTS_VIEW,"VIEW");
		facultyDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DOCUMENTS_CREATE,"CREATE");
		facultyDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DOCUMENTS_UPDATE,"UPDATE");
		facultyDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DOCUMENTS_DELETE,"DELETE");
		facultyDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DOCUMENTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_DOCUMENTS_PRIVILEGES", facultyDocumentsPrivileges);
		
		facultyOnlineDocumentsPrivileges = new Ext.util.HashMap();
		facultyOnlineDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ONLINE_DOCUMENTS_VIEW,"VIEW");
		facultyOnlineDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ONLINE_DOCUMENTS_CREATE,"CREATE");
		facultyOnlineDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ONLINE_DOCUMENTS_EDIT,"EDIT");
		facultyOnlineDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ONLINE_DOCUMENTS_EXPORT,"EXPORT");
		facultyOnlineDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ONLINE_DOCUMENTS_DELETE,"DELETE");
		facultyOnlineDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ONLINE_DOCUMENTS_PREDEFINED_DOCUMENTS,"PREDEFINED_DOCUMENTS");
		facultyOnlineDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ONLINE_DOCUMENTS_OTHERS,"OTHERS");
		featurePrivilegesMap.add("FACULTY_ONLINE_DOCUMENTS_PRIVILEGES", facultyOnlineDocumentsPrivileges);
		
		facultyPhysicalDocumentsPrivileges = new Ext.util.HashMap();
		facultyPhysicalDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PHYSICAL_DOCUMENTS_VIEW,"VIEW");
		facultyPhysicalDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PHYSICAL_DOCUMENTS_CREATE,"CREATE");
		facultyPhysicalDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PHYSICAL_DOCUMENTS_EDIT,"EDIT");
		facultyPhysicalDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PHYSICAL_DOCUMENTS_EXPORT,"EXPORT");
		facultyPhysicalDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PHYSICAL_DOCUMENTS_DELETE,"DELETE");
		facultyPhysicalDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PHYSICAL_DOCUMENTS_PREDEFINED_DOCUMENTS,"PREDEFINED_DOCUMENTS");
		facultyPhysicalDocumentsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PHYSICAL_DOCUMENTS_OTHERS,"OTHERS");
		featurePrivilegesMap.add("FACULTY_PHYSICAL_DOCUMENTS_PRIVILEGES", facultyPhysicalDocumentsPrivileges);
		
		
		
		facultyPortalStudentProfileOnlineDocumentsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentProfileOnlineDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_ONLINE_DOCUMENT_VIEW,"VIEW");
		facultyPortalStudentProfileOnlineDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_ONLINE_DOCUMENT_CREATE,"CREATE");
		facultyPortalStudentProfileOnlineDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_ONLINE_DOCUMENT_EDIT,"EDIT");
		facultyPortalStudentProfileOnlineDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_ONLINE_DOCUMENT_EXPORT,"EXPORT");
		facultyPortalStudentProfileOnlineDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_ONLINE_DOCUMENT_DELETE,"DELETE");
		facultyPortalStudentProfileOnlineDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_ONLINE_DOCUMENT_PREDEFINED_DOCUMENTS,"PREDEFINED_DOCUMENTS");
		facultyPortalStudentProfileOnlineDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_ONLINE_DOCUMENT_OTHERS,"OTHERS");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_PROFILE_ONLINE_DOCUMENTS_PRIVILEGES", facultyPortalStudentProfileOnlineDocumentsPrivileges);
		
		facultyPortalStudentProfilePhysicalDocumentsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentProfilePhysicalDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_PHYSICAL_DOCUMENT_VIEW,"VIEW");
		facultyPortalStudentProfilePhysicalDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_PHYSICAL_DOCUMENT_CREATE,"CREATE");
		facultyPortalStudentProfilePhysicalDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_PHYSICAL_DOCUMENT_EDIT,"EDIT");
		facultyPortalStudentProfilePhysicalDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_PHYSICAL_DOCUMENT_EXPORT,"EXPORT");
		facultyPortalStudentProfilePhysicalDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_PHYSICAL_DOCUMENT_DELETE,"DELETE");
		facultyPortalStudentProfilePhysicalDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_PHYSICAL_DOCUMENT_PREDEFINED_DOCUMENTS,"PREDEFINED_DOCUMENTS");
		facultyPortalStudentProfilePhysicalDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PROFILE_PHYSICAL_DOCUMENT_OTHERS,"OTHERS");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_PROFILE_PHYSICAL_DOCUMENTS_PRIVILEGES", facultyPortalStudentProfilePhysicalDocumentsPrivileges);
		
		facultyPortalOnlineDocumentsPrivileges = new Ext.util.HashMap();
		facultyPortalOnlineDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ONLINE_DOCUMENTS_VIEW,"VIEW");
		facultyPortalOnlineDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ONLINE_DOCUMENTS_CREATE,"CREATE");
		facultyPortalOnlineDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ONLINE_DOCUMENTS_EDIT,"EDIT");
		facultyPortalOnlineDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ONLINE_DOCUMENTS_EXPORT,"EXPORT");
		facultyPortalOnlineDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ONLINE_DOCUMENTS_PREDEFINED_DOCUMENTS,"PREDEFINED_DOCUMENTS");
		facultyPortalOnlineDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ONLINE_DOCUMENTS_OTHERS,"OTHERS");
        featurePrivilegesMap.add("FACULTY_PORTAL_ONLINE_DOCUMENTS_PRIVILEGES", facultyPortalOnlineDocumentsPrivileges);
		
		facultyPortalPhysicalDocumentsPrivileges = new Ext.util.HashMap();
		facultyPortalPhysicalDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PHYSICAL_DOCUMENTS_VIEW,"VIEW");
		facultyPortalPhysicalDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PHYSICAL_DOCUMENTS_CREATE,"CREATE");
		facultyPortalPhysicalDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PHYSICAL_DOCUMENTS_EDIT,"EDIT");
		facultyPortalPhysicalDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PHYSICAL_DOCUMENTS_EXPORT,"EXPORT");
		facultyPortalPhysicalDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PHYSICAL_DOCUMENTS_PREDEFINED_DOCUMENTS,"PREDEFINED_DOCUMENTS");
		facultyPortalPhysicalDocumentsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PHYSICAL_DOCUMENTS_OTHERS,"OTHERS");
		featurePrivilegesMap.add("FACULTY_PORTAL_PHYSICAL_DOCUMENTS_PRIVILEGES", facultyPortalPhysicalDocumentsPrivileges);
		
		/****** For Faculty Request***********/
		facultyRequestPrivileges = new Ext.util.HashMap();
		facultyRequestPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYREQUEST_VIEW,"VIEW");
		facultyRequestPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYREQUEST_EXPORT,"EXPORT");
		
		facultyRequestPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ALL_REQUEST_VIEW,"VIEW");
		facultyRequestPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ALL_REQUEST_EXPORT,"EXPORT");
		facultyRequestPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ALL_REQUEST_RAISEREQUEST,"RAISEREQUEST");
		facultyRequestPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ALL_REQUEST_QUICKCOMMENT,"QUICKCOMMENT");
		featurePrivilegesMap.add("FACULTY_REQUEST_PRIVILEGES", facultyRequestPrivileges);
		
		/****** For LM Employee Request Pending Action***********/
		/*employeeRequestPendingActionPrivileges = new Ext.util.HashMap();
		employeeRequestPendingActionPrivileges.add(FPCONSTANTS.PF_M8_F_EMPLOYEE_LEAVE_REQUEST_VIEW,"VIEW");
		employeeRequestPendingActionPrivileges.add(FPCONSTANTS.PF_M8_F_EMPLOYEE_LEAVE_REQUEST_EXPORT,"EXPORT");
		employeeRequestPendingActionPrivileges.add(FPCONSTANTS.PF_M8_F_EMPLOYEE_LEAVE_REQUEST_REQUEST_PENDING_FOR,"REQUEST_PENDING_FOR");
		featurePrivilegesMap.add("EMPLOYEE_REQUEST_PENDING_ACTION_PRIVILEGES", employeeRequestPendingActionPrivileges);*/
		
		/****** For Faculty Extra Curr Activity***********/
		facultyExtraCurrActivityReportPrivileges = new Ext.util.HashMap();
		facultyExtraCurrActivityReportPrivileges.add(FPCONSTANTS.PF_M8_R_FACULTYEXTRACURRICULUMACTIVITIESREPORT_VIEW,"VIEW");
		facultyExtraCurrActivityReportPrivileges.add(FPCONSTANTS.PF_M8_R_FACULTYEXTRACURRICULUMACTIVITIESREPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_EXTRACURRICULUMREPORT_PRIVILEGES", facultyExtraCurrActivityReportPrivileges);
		
		/****** For Faculty Employee Child***********/
		facultyEmployeeChildReportPrivileges = new Ext.util.HashMap();
		facultyEmployeeChildReportPrivileges.add(FPCONSTANTS.PF_M8_R_FACULTYEMPLOYEECHILDREPORT_VIEW,"VIEW");
		facultyEmployeeChildReportPrivileges.add(FPCONSTANTS.PF_M8_R_FACULTYEMPLOYEECHILDREPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_EMPLOYEECHILDREPORT_PRIVILEGES", facultyEmployeeChildReportPrivileges);
		
		/****** For Faculty Unassigned Request***********/
		facultyUnassignedRequestReportPrivileges = new Ext.util.HashMap();
		facultyUnassignedRequestReportPrivileges.add(FPCONSTANTS.PF_M8_R_FACULTYUNASSIGNEDREQUEST_VIEW,"VIEW");
		facultyUnassignedRequestReportPrivileges.add(FPCONSTANTS.PF_M8_R_FACULTYUNASSIGNEDREQUEST_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_UNASSIGNEDREQUEST_PRIVILEGES", facultyUnassignedRequestReportPrivileges);
		
		/****** For Faculty Follow Up Scheduled***********/
		facultyFollowUpScheduledReportPrivileges = new Ext.util.HashMap();
		facultyFollowUpScheduledReportPrivileges.add(FPCONSTANTS.PF_M8_R_FACULTYFOLLOWUPSCHEDULED_VIEW,"VIEW");
		facultyFollowUpScheduledReportPrivileges.add(FPCONSTANTS.PF_M8_R_FACULTYFOLLOWUPSCHEDULED_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_FOLLOWUPSCHEDULED_PRIVILEGES", facultyFollowUpScheduledReportPrivileges);
		
		/***************************************** Tools and Services Module*********************************************/
		
		/****** For Make a Booking***********/
		makeBookingPrivileges = new Ext.util.HashMap();
		makeBookingPrivileges.add(FPCONSTANTS.PC_M7_F_RESOURCEBOOKING_VIEW,"VIEW");
		makeBookingPrivileges.add(FPCONSTANTS.PC_M7_F_RESOURCEBOOKING_CREATE,"CREATE");
		makeBookingPrivileges.add(FPCONSTANTS.PC_M7_F_RESOURCEBOOKING_UPDATE,"UPDATE");
		makeBookingPrivileges.add(FPCONSTANTS.PC_M7_F_RESOURCEBOOKING_DELETE,"DELETE");
		makeBookingPrivileges.add(FPCONSTANTS.PC_M7_F_RESOURCEBOOKING_MOREACTIONS,"MOREACTIONS");
		makeBookingPrivileges.add(FPCONSTANTS.PC_M7_F_RESOURCEBOOKING_EXPORT,"EXPORT");
		makeBookingPrivileges.add(FPCONSTANTS.PC_M7_F_RESOURCEBOOKING_MANAGE_MINUTES,"MANAGE_MINUTES");
		makeBookingPrivileges.add(FPCONSTANTS.PC_M7_F_RESOURCEBOOKING_PRINT_ATTENDANCE_SHEET,"PRINT_ATTENDANCE_SHEET");
		makeBookingPrivileges.add(FPCONSTANTS.PC_M7_F_RESOURCEBOOKING_LAST_REGISTRATION_DATE,"LAST_REGISTRATION_DATE");
		makeBookingPrivileges.add(FPCONSTANTS.PC_M7_F_RESOURCEBOOKING_ALUMNI_EVENT_TAB,"ALUMNI_EVENT_TAB");
		makeBookingPrivileges.add(FPCONSTANTS.PC_M7_F_RESOURCEBOOKING_ALUMNI_COLUMN,"GRID_CONFIGURATION");
		makeBookingPrivileges.add(FPCONSTANTS.PC_M7_F_RESOURCEBOOKING_ALUMNI_VIEW_EVENT_DETAIL,"ALUMNI_VIEW_EVENT_DETAIL");
		makeBookingPrivileges.add(FPCONSTANTS.PC_M7_F_RESOURCEBOOKING_ALUMNI_VIEW_MODAL,"ALUMNI_VIEW_MODAL");
		//Alumni View Event Detail
		featurePrivilegesMap.add("RESOURCE_BOOKING_PRIVILEGES", makeBookingPrivileges);
		
		cerpManageGalleryPrivileges = new Ext.util.HashMap();
		cerpManageGalleryPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_GALLERY_VIEW,"VIEW");
		cerpManageGalleryPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_GALLERY_ADD_FOLDER,"ADD_FOLDER");
		cerpManageGalleryPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_GALLERY_ADD_FILE,"ADD_FILE");
		cerpManageGalleryPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_GALLERY_SHARE_FOLDER,"SHARE_FOLDER");
		cerpManageGalleryPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_GALLERY_FOLDER_DETAILS,"FOLDER_DETAILS");
		cerpManageGalleryPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_GALLERY_SAVE_ALBUM,"SAVE_ALBUM");
		cerpManageGalleryPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_GALLERY_DELETE_FOLDER,"DELETE_FOLDER");
		cerpManageGalleryPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_GALLERY_DELETE_FILE,"DELETE_FILE");
		cerpManageGalleryPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_GALLERY_EDIT_LINKS,"EDIT_LINKS");
		cerpManageGalleryPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_GALLERY_ALUMNI_CHECKBOX,"ALUMNI_CHECKBOX");

		featurePrivilegesMap.add("CERP_MANAGE_GALLERY_PRIVILEGES", cerpManageGalleryPrivileges);
		
		/****************************** Scholarship And Sponsorship  Module****************************/
		
		/************ Scholarship Listing ****************/
		scholarshipListingPrivileges = new Ext.util.HashMap();
		scholarshipListingPrivileges.add(FPCONSTANTS.PF_M11_F_SCHOLARSHIPAWARDS_VIEW,"VIEW");
		scholarshipListingPrivileges.add(FPCONSTANTS.SP_M11_F_SCHOLARSHIPAWARDS_VIEW,"VIEW");
		scholarshipListingPrivileges.add(FPCONSTANTS.SP_M11_F_SCHOLARSHIPAWARDS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		scholarshipListingPrivileges.add(FPCONSTANTS.SP_M11_F_SCHOLARSHIPAWARDS_EXPORT,"EXPORT");
		scholarshipListingPrivileges.add(FPCONSTANTS.PC_M11_F_SCHOLARSHIPAWARDS_UPDATE,"UPDATE");
		scholarshipListingPrivileges.add(FPCONSTANTS.PC_M11_F_SCHOLARSHIPAWARDS_MOREACTIONS,"MOREACTIONS");
		scholarshipListingPrivileges.add(FPCONSTANTS.PC_M11_F_SCHOLARSHIPAWARDS_CREATE,"CREATE");
		scholarshipListingPrivileges.add(FPCONSTANTS.PP_M11_F_SCHOLARSHIPAWARDS_VIEW,"VIEW");
		scholarshipListingPrivileges.add(FPCONSTANTS.SP_M11_F_SCHOLARSHIPAWARDSDOCUMENTS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		scholarshipListingPrivileges.add(FPCONSTANTS.PP_M11_F_SCHOLARSHIPAWARDS_EXPORT,"EXPORT");
		
		featurePrivilegesMap.add("SCHOLARSHIP_LISTING_PRIVILEGES", scholarshipListingPrivileges);
		
		scholarshipAwardeePrivileges = new Ext.util.HashMap();
		scholarshipAwardeePrivileges.add(FPCONSTANTS.PC_M11_F_SCHOLARSHIPAWARDS_VIEW,"VIEW");
		scholarshipAwardeePrivileges.add(FPCONSTANTS.PC_M11_F_SCHOLARSHIPAWARDS_DELETE,"DELETE");
		scholarshipAwardeePrivileges.add(FPCONSTANTS.PC_M11_F_SCHOLARSHIPAWARDS_EXPORT,"EXPORT");
		scholarshipAwardeePrivileges.add(FPCONSTANTS.PC_M11_F_SCHOLARSHIPAWARDS_ACTIVE_SCHOLARSHIP,"ACTIVE_SCHOLARSHIP");
		scholarshipAwardeePrivileges.add(FPCONSTANTS.PC_M11_F_SCHOLARSHIPAWARDS_TRANSFER_SCHOLARSHIP,"TRANSFER_SCHOLARSHIP");
		scholarshipAwardeePrivileges.add(FPCONSTANTS.PC_M11_F_SCHOLARSHIPAWARDS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("SCHOLARSHIP_AWARDEE_PRIVILEGES", scholarshipAwardeePrivileges);
		
		/************ Scholarship Listing Documents****************/
		scholarshipListingDocumentsPrivileges = new Ext.util.HashMap();
		scholarshipListingDocumentsPrivileges.add(FPCONSTANTS.SP_M11_F_SCHOLARSHIPAWARDSDOCUMENTS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		
		featurePrivilegesMap.add("SCHOLARSHIP_LISTING_DOCUMENTS_PRIVILEGES", scholarshipListingDocumentsPrivileges);
		
		/************ Scholarship Receipt ****************/
		scholarshipReceiptPrivileges = new Ext.util.HashMap();
		scholarshipReceiptPrivileges.add(FPCONSTANTS.PC_M11_F_SCHOLARSHIPRECIEPT_VIEW,"VIEW");
		scholarshipReceiptPrivileges.add(FPCONSTANTS.PC_M11_F_SCHOLARSHIPRECIEPT_CREATE,"CREATE");
		scholarshipReceiptPrivileges.add(FPCONSTANTS.PC_M11_F_SCHOLARSHIPRECIEPT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("SCHOLARSHIP_RECEIPT_PRIVILEGES", scholarshipReceiptPrivileges);

		studentScholarshipPrivileges = new Ext.util.HashMap();
		studentScholarshipPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SCHOLARSHIP_AWARDEE_VIEW,"VIEW");
		studentScholarshipPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SCHOLARSHIP_AWARDEE_EXPORT,"EXPORT");
	    featurePrivilegesMap.add("STUDENT_SCHOLARSHIP_PRIVILEGES", studentScholarshipPrivileges);
		
		/************ Add Sponsored Student  ****************/
		sponsoredStudentPrivileges = new Ext.util.HashMap();
		sponsoredStudentPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSOREDSTUDENT_VIEW,"VIEW");
		sponsoredStudentPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSOREDSTUDENT_CREATE,"CREATE");
		sponsoredStudentPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSOREDSTUDENT_UPDATE,"UPDATE");
		sponsoredStudentPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSOREDSTUDENT_DELETE,"DELETE");
		/*sponsorshipListingPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSOREDSTUDENT_EXPORT,"EXPORT");*/
		
		//sponsorshipListingPrivileges.add(FPCONSTANTS.PS_M11_F_SPONSOREDSTUDENT_VIEW,"VIEW");
		featurePrivilegesMap.add("SPONSORED_STUDENT_PRIVILEGES", sponsoredStudentPrivileges);
		
		/************ Sponsorship Receipt ****************/
		sponsorshipReceiptPrivileges = new Ext.util.HashMap();
		sponsorshipReceiptPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSORSHIPRECIEPT_VIEW,"VIEW");
		/*sponsorshipReceiptPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSORSHIPRECIEPT_CREATE,"CREATE");*/
		sponsorshipReceiptPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSORSHIPRECIEPT_EXPORT,"EXPORT");
		sponsorshipReceiptPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSORSHIPRECIEPT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		
		featurePrivilegesMap.add("SPONSORSHIP_RECEIPT_PRIVILEGES", sponsorshipReceiptPrivileges);
		
		/************ Sponsorship Awardees List ****************/
		sponsorshipAwardeesListPrivileges = new Ext.util.HashMap();
		sponsorshipAwardeesListPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSORSHIPAWARDEESLIST_VIEW,"VIEW");
		sponsorshipAwardeesListPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSORSHIPAWARDEESLIST_CREATE,"CREATE");
		sponsorshipAwardeesListPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSORSHIPAWARDEESLIST_UPDATE,"UPDATE");
		sponsorshipAwardeesListPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSORSHIPAWARDEESLIST_DELETE,"DELETE");
		sponsorshipAwardeesListPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSORSHIPAWARDEESLIST_EXPORT,"EXPORT");
		sponsorshipAwardeesListPrivileges.add(FPCONSTANTS.PC_M11_F_SPONSORSHIPAWARDEESLIST_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("SPONSORSHIP_AWARDEES_LIST_PRIVILEGES", sponsorshipAwardeesListPrivileges);
		
		
		/************ Sponsorship Invoice ****************/
		sponsorInvoicePrivileges = new Ext.util.HashMap();
		sponsorInvoicePrivileges.add(FPCONSTANTS.PC_M11_F_MANAGESPONSORINVOICE_VIEW,"VIEW");
		sponsorInvoicePrivileges.add(FPCONSTANTS.PC_M11_F_MANAGESPONSORINVOICE_CREATE,"CREATE");
		sponsorInvoicePrivileges.add(FPCONSTANTS.PC_M11_F_MANAGESPONSORINVOICE_UPDATE,"UPDATE");
		sponsorInvoicePrivileges.add(FPCONSTANTS.PC_M11_F_MANAGESPONSORINVOICE_DELETE,"DELETE");
		sponsorInvoicePrivileges.add(FPCONSTANTS.PC_M11_F_MANAGESPONSORINVOICE_UPDATE_AMOUNT_RECEIVED,"UPDATE_AMOUNT_RECEIVED");
		featurePrivilegesMap.add("SPONSOR_INVOICE_PRIVILEGES", sponsorInvoicePrivileges);
		
		/********************* System Admin *************************************************************/
		
		/************** User **********************************/
		userManagementPrivileges = new Ext.util.HashMap();
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_UPDATE, "UPDATE");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_CREATE, "CREATE");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_VIEW, "VIEW");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_DELETE, "DELETE");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_EXPORT, "EXPORT");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_RESETPASSWORD, "RESETPASSWORD");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_ACTIVATEUSER, "ACTIVATEUSER");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_MOREACTIONS, "MOREACTIONS");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_IMPORT_BULK_USERS, "IMPORT_BULK_USERS");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_IMPORT_BULK_USER_ROLE, "IMPORT_BULK_USER_ROLE");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_IMPORT_BULK_USER_UPDATE, "IMPORT_BULK_USER_UPDATE");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_SEND_MESSAGE, "SEND_MESSAGE");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_ADHOC_MESSAGE, "ADHOC_MESSAGE");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_MESSAGE_TEMPLATE, "MESSAGE_TEMPLATE");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_MAKE_ACTIVE, "MAKE_ACTIVE");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_USRMANAGEMENT_GRID_CONFIG, "GRID_CONFIGURATION");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_CREATE_USER_ALFRESCO, "CREATE_USER_IN_ALFRESCO");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_SELECT_SIMILAR_RECORDS, "SELECT_SIMILAR_RECORDS");
		userManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_UPLOAD_IMAGE_EDIT_ICON_TO_USER, "UPLOAD_IMAGE_EDIT_ICON_TO_USER");
		featurePrivilegesMap.add("USER_MANAGEMENT", userManagementPrivileges);
		
		/************** Users Profile - Under Users & Roles **********************************/
		userProfilePrivileges = new Ext.util.HashMap();
		userProfilePrivileges.add(FPCONSTANTS.PSA_M13_F_USER_PROFILE_TO_VISITED_RECORD_VIEW, "VIEW");
		featurePrivilegesMap.add("USER_PROFILE_PERMISSION", userProfilePrivileges);
		
		/************** Promotion Panel **********************************/
		promotionPanelPrivileges = new Ext.util.HashMap();
		promotionPanelPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_VIEW, "VIEW");
		promotionPanelPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_GRID_CONFIG, "GRID_CONFIGURATION");
		promotionPanelPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_ADD_TO_PANEL, "ADD_TO_PANEL");		
		promotionPanelPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_DETAILED_VIEW, "DETAILED_VIEW");
		promotionPanelPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_P_SAVE, "CREATE");
		promotionPanelPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_REVERT_TO_DRAFTED, "REVERT_TO_DRAFTED");
		promotionPanelPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_REGENERATE_LETTER, "REGENERATE_LETTER");
		featurePrivilegesMap.add("PROMOTION_PANEL_PERMISSION", promotionPanelPrivileges);
		
		
		/************** User Access Rights **********************************/
		userAccessRightsPrivileges = new Ext.util.HashMap();
		userAccessRightsPrivileges.add(FPCONSTANTS.PSA_M13_F_ADD_ACADEMY_LOCATION_CREATE, "ADD_ACADEMY_LOCATION");
		userAccessRightsPrivileges.add(FPCONSTANTS.PSA_M13_F_ADD_ROLE_CREATE, "ADD_ROLE");
		userAccessRightsPrivileges.add(FPCONSTANTS.PSA_M13_F_ADD_MULTIPLE_ACADEMY_LOCATION_AND_ROLE_CREATE, "ADD_MULTIPLE_ACADEMY_LOCATION_AND_ROLE");
		userAccessRightsPrivileges.add(FPCONSTANTS.PSA_M13_F_EDIT_ACADEMY_LOCATION_UPDATE, "EDIT_ACADEMY_LOCATION");
		userAccessRightsPrivileges.add(FPCONSTANTS.PSA_M13_F_EDIT_ROLE_UPDATE, "EDIT_ROLE");
		userAccessRightsPrivileges.add(FPCONSTANTS.PSA_M13_F_EDIT_PRIVILEGES_UPDATE, "EDIT_PRIVILEGES");
		userAccessRightsPrivileges.add(FPCONSTANTS.PSA_M13_F_PROGRAM_AND_COURSES_UPDATE, "EDIT_PROGRAM_AND_COURSES");
		userAccessRightsPrivileges.add(FPCONSTANTS.PSA_M13_F_UNASSIGN_ACADEMY_LOCATION_UPDATE, "UNASSIGN_ACADEMY_LOCATION");
		userAccessRightsPrivileges.add(FPCONSTANTS.PSA_M13_F_UNASSIGN_ROLE_UPDATE, "UNASSIGN_ROLE");
		featurePrivilegesMap.add("USER_ACCESS_RIGHTS", userAccessRightsPrivileges);
		
		/************** Role Management **********************************/
		roleManagementPrivileges = new Ext.util.HashMap();
		roleManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEMANAGEMENT_UPDATE, "UPDATE");
		roleManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEMANAGEMENT_CREATE, "CREATE");
		roleManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEMANAGEMENT_VIEW, "VIEW");
		roleManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEMANAGEMENT_DELETE, "DELETE");
		roleManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEMANAGEMENT_MOREACTIONS, "MOREACTIONS");
		roleManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEMANAGEMENT_SEARCH, "SEARCH");
		roleManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEMANAGEMENT_EXPORT, "EXPORT");
		roleManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEMANAGEMENT_RESET, "RESET");
		roleManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEMANAGEMENT_LOCK_USER_ROLE, "LOCK_USER_ROLE");
		roleManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEMANAGEMENT_UNLOCK_USER_ROLE, "UNLOCK_USER_ROLE");
		featurePrivilegesMap.add("ROLE_MANAGEMENT_PRIVILEGES", roleManagementPrivileges);
		
		/************** Dashboard Management **********************************/
		dashboardManagementPrivileges = new Ext.util.HashMap();
		dashboardManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEDASHLETMAPPING_UPDATE, "UPDATE");
		dashboardManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEDASHLETMAPPING_CREATE, "CREATE");
		dashboardManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEDASHLETMAPPING_VIEW, "VIEW");
		dashboardManagementPrivileges.add(FPCONSTANTS.PSA_M13_F_ROLEDASHLETMAPPING_DELETE, "DELETE");
		featurePrivilegesMap.add("DASHBOARD_MANAGEMENT_PRIVILEGES", dashboardManagementPrivileges);
		
		myDashboardPrivilege = new Ext.util.HashMap();
		myDashboardPrivilege.add(FPCONSTANTS.PSA_M13_F_MY_DASHBOARD_VIEW, "VIEW");
		//myDashboardPrivilege.add(FPCONSTANTS.FP_M13_F_MY_DASHBOARD_VIEW, "VIEW");
		myDashboardPrivilege.add(FPCONSTANTS.PSA_M13_F_MY_DASHBOARD_CHANGE_PASSWORD, "CHANGE_PASSWORD");
		myDashboardPrivilege.add(FPCONSTANTS.PSA_M13_F_MY_DASHBOARD_GOOGLE_TRANSLATION, "GOOGLE_TRANSLATION");
		featurePrivilegesMap.add("MY_DASHBOARD_PRIVILEGES", myDashboardPrivilege);
		
		FPMyDashboardPriviledge = new Ext.util.HashMap();
		FPMyDashboardPriviledge.add(FPCONSTANTS.FP_M13_F_MY_DASHBOARD_VIEW, "VIEW");
		FPMyDashboardPriviledge.add(FPCONSTANTS.FP_M13_F_MY_DASHBOARD_CHANGE_PASSWORD, "CHANGE_PASSWORD");
		featurePrivilegesMap.add("FACULTY_MY_DASHBOARD_PRIVILEGES", FPMyDashboardPriviledge);
		
		studentPortalmyDashboardPrivilege = new Ext.util.HashMap();
		studentPortalmyDashboardPrivilege.add(FPCONSTANTS.SP_M13_F_MY_DASHBOARD_VIEW, "VIEW");
		studentPortalmyDashboardPrivilege.add(FPCONSTANTS.SP_M13_F_MY_DASHBOARD_CHANGE_PASSWORD, "CHANGE_PASSWORD");
		featurePrivilegesMap.add("STUDENT_PORTAL_MY_DASHBOARD_PRIVILEGES", studentPortalmyDashboardPrivilege);
		
		studentPortalStudentInformationPrivilege = new Ext.util.HashMap();
		studentPortalStudentInformationPrivilege.add(FPCONSTANTS.SP_M13_F_STUDENT_INFORMATION_PRINT, "PRINT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_INFORMATION_PRIVILEGES", studentPortalStudentInformationPrivilege);
		
		parentPortalmyDashboardPrivilege = new Ext.util.HashMap();
		parentPortalmyDashboardPrivilege.add(FPCONSTANTS.PP_M13_F_MY_DASHBOARD_VIEW, "VIEW");
		parentPortalmyDashboardPrivilege.add(FPCONSTANTS.PP_M13_F_MY_DASHBOARD_CHANGE_PASSWORD, "CHANGE_PASSWORD");
		featurePrivilegesMap.add("PARENT_PORTAL_MY_DASHBOARD_PRIVILEGES", parentPortalmyDashboardPrivilege);
		
		parentAttendanceDashletPrivilege = new Ext.util.HashMap();
		parentAttendanceDashletPrivilege.add(FPCONSTANTS.PP_M13_F_ATTENDANCE_DASHBOARD_PROGRAM_WISE, "PROGRAM_WISE");
		parentAttendanceDashletPrivilege.add(FPCONSTANTS.PP_M13_F_ATTENDANCE_DASHBOARD_COURSE_WISE, "COURSE_WISE");
		parentAttendanceDashletPrivilege.add(FPCONSTANTS.PP_M13_F_ATTENDANCE_DASHBOARD_SESSION_WISE, "SESSION_WISE");
		featurePrivilegesMap.add("PARENT_ATTENDANCE_DASHBOARD_PRIVILEGES", parentAttendanceDashletPrivilege);
		
		attendanceDashletPrivilege = new Ext.util.HashMap();
		attendanceDashletPrivilege.add(FPCONSTANTS.FP_M13_F_ATTENDANCE_DASHBOARD_RESETPASSWORD, "RESETPASSWORD");
		attendanceDashletPrivilege.add(FPCONSTANTS.SP_M13_F_ATTENDANCE_DASHBOARD_PROGRAM_WISE, "PROGRAM_WISE");
		attendanceDashletPrivilege.add(FPCONSTANTS.SP_M13_F_ATTENDANCE_DASHBOARD_COURSE_WISE, "COURSE_WISE");
		attendanceDashletPrivilege.add(FPCONSTANTS.SP_M13_F_ATTENDANCE_DASHBOARD_SESSION_WISE, "SESSION_WISE");
		featurePrivilegesMap.add("ATTENDANCE_DASHBOARD_PRIVILEGES", attendanceDashletPrivilege);
		
		studentPortalCalendarDashletPrivilege = new Ext.util.HashMap();
		studentPortalCalendarDashletPrivilege.add(FPCONSTANTS.SP_M13_S_CALENDAR_DESHLET_DETAILED, "DETAILED_TIMETABLE");
		studentPortalCalendarDashletPrivilege.add(FPCONSTANTS.SP_M13_S_CALENDAR_DESHLET_MASTER, "MASTER_TIMETABLE");
		studentPortalCalendarDashletPrivilege.add(FPCONSTANTS.SP_M13_S_CALENDAR_DESHLET_EVENTS, "EVENTS");
		featurePrivilegesMap.add("STUDENT_PORTAL_CALENDAR_DASHLET_PRIVILEGES", studentPortalCalendarDashletPrivilege);
		
		parentPortalCalendarDashletPrivilege = new Ext.util.HashMap();
		parentPortalCalendarDashletPrivilege.add(FPCONSTANTS.PP_M13_S_CALENDAR_DESHLET_DETAILED, "DETAILED_TIMETABLE");
		parentPortalCalendarDashletPrivilege.add(FPCONSTANTS.PP_M13_S_CALENDAR_DESHLET_MASTER, "MASTER_TIMETABLE");
		parentPortalCalendarDashletPrivilege.add(FPCONSTANTS.PP_M13_S_CALENDAR_DESHLET_EVENTS, "EVENTS");
		featurePrivilegesMap.add("PARENT_PORTAL_CALENDAR_DASHLET_PRIVILEGES", parentPortalCalendarDashletPrivilege);
		
		facultyPortalAttendanceDashletPrivilege = new Ext.util.HashMap();
		facultyPortalAttendanceDashletPrivilege.add(FPCONSTANTS.FP_M13_F_ATTENDANCE_DESHLET_PROGRAM_WISE, "PROGRAM_WISE");
		facultyPortalAttendanceDashletPrivilege.add(FPCONSTANTS.FP_M13_F_ATTENDANCE_DESHLET_SESSION_WISE, "SESSION_WISE");
		featurePrivilegesMap.add("FACULTY_PORTAL_ATTENDANCE_DASHLET_PRIVILEGES", facultyPortalAttendanceDashletPrivilege);
		
		facultyPortalCalendarDashletPrivilege = new Ext.util.HashMap();
		facultyPortalCalendarDashletPrivilege.add(FPCONSTANTS.FP_M13_F_CALENDAR_DESHLET_DETAILED, "DETAILED_TIMETABLE");
		facultyPortalCalendarDashletPrivilege.add(FPCONSTANTS.FP_M13_F_CALENDAR_DESHLET_MASTER, "MASTER_TIMETABLE");
		facultyPortalCalendarDashletPrivilege.add(FPCONSTANTS.FP_M13_F_CALENDAR_DESHLET_EVENTS, "EVENTS");
		featurePrivilegesMap.add("FACULTY_PORTAL_CALENDAR_DASHLET_PRIVILEGES", facultyPortalCalendarDashletPrivilege);
		
		employeePortalAttendanceDashletPrivilege = new Ext.util.HashMap();
		employeePortalAttendanceDashletPrivilege.add(FPCONSTANTS.FP_M13_F_ATTENDANCE_DESHLET_SEND_MESSAGE_ADHOC_MESSAGE, "ADHOC_MESSAGE");
		employeePortalAttendanceDashletPrivilege.add(FPCONSTANTS.FP_M13_F_ATTENDANCE_DESHLET_SEND_MESSAGE_MESSAGE_TEMPLATE, "MESSAGE_TEMPLATE");
		featurePrivilegesMap.add("EMPLOYEE_PORTAL_ATTENDANCE_DASHLET_PRIVILEGES", employeePortalAttendanceDashletPrivilege);
		
		/************** Online User Report **********************************/
		onlineUserReportPrivileges = new Ext.util.HashMap();
		onlineUserReportPrivileges.add(FPCONSTANTS.PSA_M13_F_ONLINEUSERS_VIEW, "VIEW");
		onlineUserReportPrivileges.add(FPCONSTANTS.PSA_M13_F_ONLINEUSERS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("ONLINE_USER_REPORT_PRIVILEGES", onlineUserReportPrivileges);
		
		/************** Inactive User Report **********************************/
		inactiveUserReportPrivileges = new Ext.util.HashMap();
		inactiveUserReportPrivileges.add(FPCONSTANTS.PSA_M13_F_INACTIVEUSERS_VIEW, "VIEW");
		//inactiveUserReportPrivileges.add(FPCONSTANTS.PSA_M13_F_INVENTORYMANAGEMENT_VIEW, "VIEW");
		inactiveUserReportPrivileges.add(FPCONSTANTS.PSA_M13_F_INACTIVEUSERS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("INACTIVE_USER_REPORT_PRIVILEGES", inactiveUserReportPrivileges);
		
		/************** User Frequency **********************************/
		userFrequencyPrivileges = new Ext.util.HashMap();
		userFrequencyPrivileges.add(FPCONSTANTS.PSA_M13_F_SYSTEMUSAGE_VIEW, "VIEW");
		userFrequencyPrivileges.add(FPCONSTANTS.PSA_M13_F_SYSTEMUSAGE_EXPORT, "EXPORT");
		featurePrivilegesMap.add("USER_FREQUENCY_PRIVILEGES", userFrequencyPrivileges);
		
		
		/************** User Login Frequency **********************************/
		loginFrequencyPrivileges = new Ext.util.HashMap();
		loginFrequencyPrivileges.add(FPCONSTANTS.PSA_M13_F_LOGIN_FREQUENCY_VIEW, "VIEW");
		loginFrequencyPrivileges.add(FPCONSTANTS.PSA_M13_F_LOGIN_FREQUENCY_EXPORT, "EXPORT");
		featurePrivilegesMap.add("LOGIN_FREQUENCY_PRIVILEGES", loginFrequencyPrivileges);
		
		/************** Average Time **********************************/
		averageTimePrivileges = new Ext.util.HashMap();
		averageTimePrivileges.add(FPCONSTANTS.PSA_M13_F_AVERAGE_TIME_VIEW, "VIEW");
		averageTimePrivileges.add(FPCONSTANTS.PSA_M13_F_AVERAGE_TIME_EXPORT, "EXPORT");
		featurePrivilegesMap.add("AVERAGE_TIME_PRIVILEGES", averageTimePrivileges);
		
		/************** Daily Usage **********************************/
		dailyUsagePrivileges = new Ext.util.HashMap();
		dailyUsagePrivileges.add(FPCONSTANTS.PSA_M13_F_DAILY_USAGE_VIEW, "VIEW");
		dailyUsagePrivileges.add(FPCONSTANTS.PSA_M13_F_DAILY_USAGE_EXPORT, "EXPORT");
		featurePrivilegesMap.add("DAILY_USAGE_PRIVILEGES", dailyUsagePrivileges);
		
		/************** Previously Locked User **********************************/
		previouslyLockedUserPrivileges = new Ext.util.HashMap();
		previouslyLockedUserPrivileges.add(FPCONSTANTS.PSA_M13_F_UNLOCKLOCKEDUSER_VIEW, "VIEW");
		previouslyLockedUserPrivileges.add(FPCONSTANTS.PSA_M13_F_UNLOCKLOCKEDUSER_EXPORT, "EXPORT");
		featurePrivilegesMap.add("PREVIOUSLY_LOCKED_USER_PRIVILEGES", previouslyLockedUserPrivileges);
		
		/************** Never Locked User **********************************/
		neverLockedUserPrivileges = new Ext.util.HashMap();
		neverLockedUserPrivileges.add(FPCONSTANTS.PSA_M13_F_NEVERLOCKEDUSER_VIEW, "VIEW");
		neverLockedUserPrivileges.add(FPCONSTANTS.PSA_M13_F_NEVERLOCKEDUSER_EXPORT, "EXPORT");
		featurePrivilegesMap.add("NEVER_LOCKED_USER_PRIVILEGES", neverLockedUserPrivileges);
		
		/************** Currently Locked User **********************************/
		currentlyLockedUserPrivileges = new Ext.util.HashMap();
		currentlyLockedUserPrivileges.add(FPCONSTANTS.PSA_M13_F_LOCKEDUSER_VIEW, "VIEW");
		currentlyLockedUserPrivileges.add(FPCONSTANTS.PSA_M13_F_LOCKEDUSER_EXPORT, "EXPORT");
		currentlyLockedUserPrivileges.add(FPCONSTANTS.PSA_M13_F_LOCKEDUSER_RELEASE_LOCK, "RELEASE_LOCK");
		featurePrivilegesMap.add("CURRENTLY_LOCKED_USER_PRIVILEGES", currentlyLockedUserPrivileges);
		
		/*********************** Admission Module *********************************************/
		
		/******************************** Selection Process ****************************/
		admissionSetupPrivileges = new Ext.util.HashMap();
		admissionSetupPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSETTING_VIEW, "VIEW");
		admissionSetupPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSETTING_CREATE, "CREATE");
		admissionSetupPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSETTING_UPDATE, "UPDATE");
		admissionSetupPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSETTING_DELETE, "DELETE");
		admissionSetupPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSETTING_PROGRAMGROUPS, "PROGRAMGROUPS");
		admissionSetupPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSETTING_VIEWCONFIGURE, "VIEWCONFIGURE");
		admissionSetupPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSETTING_COPYCONFIGCOMB, "COPYCONFIGCOMB");
		admissionSetupPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSETTING_EXPORT, "EXPORT");
		featurePrivilegesMap.add("ADMISSION_SETUP_PRIVILEGES", admissionSetupPrivileges);
		

		/******** admission setup update ***********************************************/
		
		admissionSetupUpdatePrivileges=new Ext.util.HashMap();
		admissionSetupUpdatePrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSETTING_ADMISSION_SETUP_UPDATE_TAB, "VIEW");
		featurePrivilegesMap.add("ADMISSION_SETUP_UPDATE_TAB_PRIVILEGES", admissionSetupUpdatePrivileges);
		

		/******************************** Selection Process ****************************/
		selectionProcessPrivileges = new Ext.util.HashMap();
		selectionProcessPrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONPROCESS_VIEW, "VIEW");
		selectionProcessPrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONPROCESS_CREATE, "CREATE");
		selectionProcessPrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONPROCESS_UPDATE, "UPDATE");
		selectionProcessPrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONPROCESS_DELETE, "DELETE");
		featurePrivilegesMap.add("SELECTION_PROCESS_PRIVILEGES", selectionProcessPrivileges);
		
		/******************************** Final Admission List****************************/
		finalAdmissionListPrivileges = new Ext.util.HashMap();
		finalAdmissionListPrivileges.add(FPCONSTANTS.PC_M3_F_FINAL_ADMISSION_LIST_VIEW, "VIEW");
		finalAdmissionListPrivileges.add(FPCONSTANTS.PC_M3_F_FINAL_ADMISSION_LIST_EXPORT, "EXPORT");
		featurePrivilegesMap.add("FINAL_ADMISSION_LIST_PRIVILEGES", finalAdmissionListPrivileges);
		
		/******************************** Quota ****************************/
		/*quotaPrivileges = new Ext.util.HashMap();
		quotaPrivileges.add(FPCONSTANTS.PC_M3_F_QUOTASETTING_VIEW, "VIEW");
		quotaPrivileges.add(FPCONSTANTS.PC_M3_F_QUOTASETTING_CREATE, "CREATE");
		quotaPrivileges.add(FPCONSTANTS.PC_M3_F_QUOTASETTING_UPDATE, "UPDATE");
		quotaPrivileges.add(FPCONSTANTS.PC_M3_F_QUOTASETTING_DELETE, "DELETE");
		quotaPrivileges.add(FPCONSTANTS.PC_M3_F_QUOTASETTING_REORDER, "REORDER");
		featurePrivilegesMap.add("QUOTA_PRIVILEGES", quotaPrivileges);
		*/
		/******************************** Application Report ****************************/
		applicationReportPrivileges = new Ext.util.HashMap();
		applicationReportPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_APPLICATION_REPORT_VIEW, "VIEW");
		applicationReportPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_APPLICATION_REPORT_EXPORT, "EXPORT");
		applicationReportPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_APPLICATION_REPORT_EXPORTREPORTS, "EXPORTREPORTS");
		featurePrivilegesMap.add("APPLICATION_REPORT_PRIVILEGES", applicationReportPrivileges);
		
		
		/******************************** Quota Type ****************************/
	/*	quotaTypePrivileges = new Ext.util.HashMap();
		quotaTypePrivileges.add(FPCONSTANTS.PC_M3_F_QUOTATYPESETTING_VIEW, "VIEW");
		quotaTypePrivileges.add(FPCONSTANTS.PC_M3_F_QUOTATYPESETTING_CREATE, "CREATE");
		quotaTypePrivileges.add(FPCONSTANTS.PC_M3_F_QUOTATYPESETTING_UPDATE, "UPDATE");
		quotaTypePrivileges.add(FPCONSTANTS.PC_M3_F_QUOTATYPESETTING_DELETE, "DELETE");
		quotaTypePrivileges.add(FPCONSTANTS.PC_M3_F_QUOTATYPESETTING_REORDER, "REORDER");
		featurePrivilegesMap.add("QUOTA_TYPE_PRIVILEGES", quotaTypePrivileges);*/
		
		/******************************** Application Form Sale ****************************/
		/*applicationFormSalePrivileges = new Ext.util.HashMap();
		applicationFormSalePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_VIEW, "VIEW");
		applicationFormSalePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_CREATE, "CREATE");
		applicationFormSalePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_DELETE, "DELETE");
		featurePrivilegesMap.add("APPLICATION_FORM_SALE_PRIVILEGES", applicationFormSalePrivileges);*/
		
		/******************************** Application Form Sale Program****************************/
		/*applicationFormSaleProgramPrivileges = new Ext.util.HashMap();
		applicationFormSaleProgramPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_PROGRAM_VIEW, "VIEW");
		applicationFormSaleProgramPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_PROGRAM_CREATE, "CREATE");
		applicationFormSaleProgramPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_PROGRAM_DELETE, "DELETE");
		applicationFormSaleProgramPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_PROGRAM_UPDATEPRIORITY, "UPDATEPRIORITY");
		featurePrivilegesMap.add("APPLICATION_FORM_SALE_PROGRAM_PRIVILEGES", applicationFormSaleProgramPrivileges);*/
		
		/******************************** Application Create Application****************************/
		applicationCreateApplicationPrivileges = new Ext.util.HashMap();
		applicationCreateApplicationPrivileges.add(FPCONSTANTS.PC_M3_F_CREATE_APPLICATION_VIEW, "VIEW");
		featurePrivilegesMap.add("APPLICATION_CREATE_APPLICATION_PRIVILEGES", applicationCreateApplicationPrivileges);
		
		/******************************** Application Manage Form****************************/
		applicationManageFormsPrivileges = new Ext.util.HashMap();
		applicationManageFormsPrivileges.add(FPCONSTANTS.PC_M3_F_MANAGE_FORMS_VIEW, "VIEW");
		applicationManageFormsPrivileges.add(FPCONSTANTS.PC_M3_F_MANAGE_FORMS_UPDATE, "UPDATE");
		applicationManageFormsPrivileges.add(FPCONSTANTS.PC_M3_F_MANAGE_FORMS_COLLECTPAYMENT, "COLLECTPAYMENT");
		applicationManageFormsPrivileges.add(FPCONSTANTS.PC_M3_F_MANAGE_FORMS_ASSINGNAPPLICATIONID, "ASSINGNAPPLICATIONID");
		applicationManageFormsPrivileges.add(FPCONSTANTS.PC_M3_F_MANAGE_FORMS_SUBMITFORM, "SUBMITFORM");
		applicationManageFormsPrivileges.add(FPCONSTANTS.PC_M3_F_MANAGE_FORMS_EXPORT, "EXPORT");
		applicationManageFormsPrivileges.add(FPCONSTANTS.PC_M3_F_MANAGE_FORMS_SENDREMINDER, "SENDREMINDER");
		applicationManageFormsPrivileges.add(FPCONSTANTS.PC_M3_F_MANAGE_GRID_CONFIG, "GRID_CONFIGURATION");
		applicationManageFormsPrivileges.add(FPCONSTANTS.PC_M3_F_MANAGE_FORMS_DELETE, "DELETE");
		featurePrivilegesMap.add("APPLICATION_MANAGE_FORMS_PRIVILEGES", applicationManageFormsPrivileges);
		
		/******************************** Application Form Sale Parent****************************/
	/*	applicationFormSaleParentPrivileges = new Ext.util.HashMap();
		applicationFormSaleParentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_PARENT_VIEW, "VIEW");
		applicationFormSaleParentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_PARENT_CREATE, "CREATE");
		applicationFormSaleParentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_PARENT_UPDATE, "UPDATE");
		applicationFormSaleParentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_PARENT_DELETE, "DELETE");
		featurePrivilegesMap.add("APPLICATION_FORM_SALE_PARENT_PRIVILEGES", applicationFormSaleParentPrivileges);*/
		
		/******************************** Application Form Sale Sibling****************************/
		/*applicationFormSaleSiblingPrivileges = new Ext.util.HashMap();
		applicationFormSaleSiblingPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_SIBLING_VIEW, "VIEW");
		applicationFormSaleSiblingPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_SIBLING_CREATE, "CREATE");
		applicationFormSaleSiblingPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_SIBLING_UPDATE, "UPDATE");
		applicationFormSaleSiblingPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMSALE_SIBLING_DELETE, "DELETE");
		featurePrivilegesMap.add("APPLICATION_FORM_SALE_SIBLING_PRIVILEGES", applicationFormSaleSiblingPrivileges);*/
		
		/******************************** Direct Submission Program ****************************/
		/*directSubmissionProgramPrivileges = new Ext.util.HashMap();
		directSubmissionProgramPrivileges.add(FPCONSTANTS.PC_M3_F_DIRECTSUBMISSION_PROGRAM_VIEW, "VIEW");
		directSubmissionProgramPrivileges.add(FPCONSTANTS.PC_M3_F_DIRECTSUBMISSION_PROGRAM_CREATE, "CREATE");
		directSubmissionProgramPrivileges.add(FPCONSTANTS.PC_M3_F_DIRECTSUBMISSION_PROGRAM_DELETE, "DELETE");
		directSubmissionProgramPrivileges.add(FPCONSTANTS.PC_M3_F_DIRECTSUBMISSION_PROGRAM_UPDATEPRIORITY, "UPDATEPRIORITY");
		featurePrivilegesMap.add("DIRECT_SUBMISSION_PROGRAM_PRIVILEGES", directSubmissionProgramPrivileges);
	
		*//********************************  Direct Submission Parent****************************//*
		directSubmissionParentPrivileges = new Ext.util.HashMap();
		directSubmissionParentPrivileges.add(FPCONSTANTS.PC_M3_F_DIRECTSUBMISSION_PARENT_VIEW, "VIEW");
		directSubmissionParentPrivileges.add(FPCONSTANTS.PC_M3_F_DIRECTSUBMISSION_PARENT_CREATE, "CREATE");
		directSubmissionParentPrivileges.add(FPCONSTANTS.PC_M3_F_DIRECTSUBMISSION_PARENT_UPDATE, "UPDATE");
		directSubmissionParentPrivileges.add(FPCONSTANTS.PC_M3_F_DIRECTSUBMISSION_PARENT_DELETE, "DELETE");
		featurePrivilegesMap.add("DIRECT_SUBMISSION_PARENT_PRIVILEGES", directSubmissionParentPrivileges);
		
		*//********************************  Direct Submission Sibling****************************//*
		directSubmissionSiblingPrivileges = new Ext.util.HashMap();
		directSubmissionSiblingPrivileges.add(FPCONSTANTS.PC_M3_F_DIRECTSUBMISSION_SIBLING_VIEW, "VIEW");
		directSubmissionSiblingPrivileges.add(FPCONSTANTS.PC_M3_F_DIRECTSUBMISSION_SIBLING_CREATE, "CREATE");
		directSubmissionSiblingPrivileges.add(FPCONSTANTS.PC_M3_F_DIRECTSUBMISSION_SIBLING_UPDATE, "UPDATE");
		directSubmissionSiblingPrivileges.add(FPCONSTANTS.PC_M3_F_DIRECTSUBMISSION_SIBLING_DELETE, "DELETE");
		featurePrivilegesMap.add("DIRECT_SUBMISSION_SIBLING_PRIVILEGES", directSubmissionSiblingPrivileges);*/
		
		/******************************** Assign Application ID ****************************/
		/*assignApplicationIdPrivileges = new Ext.util.HashMap();
		assignApplicationIdPrivileges.add(FPCONSTANTS.PC_M3_F_ASSIGNAPPLICATIONID_VIEW, "VIEW");
		assignApplicationIdPrivileges.add(FPCONSTANTS.PC_M3_F_ASSIGNAPPLICATIONID_FINDAPPLICANT, "FINDAPPLICANT");
		assignApplicationIdPrivileges.add(FPCONSTANTS.PC_M3_F_ASSIGNAPPLICATIONID_ASSIGNAPPLID, "ASSIGNAPPLID");
		assignApplicationIdPrivileges.add(FPCONSTANTS.PC_M3_F_ASSIGNAPPLICATIONID_MAKEPAYMENT, "MAKEPAYMENT");
		featurePrivilegesMap.add("ASSIGN_APPLICATION_ID_PRIVILEGES", assignApplicationIdPrivileges);*/
		/*****************************Application form generate Token privileges ****************/
		/*applicationFormGenerateTokenprivileges = new Ext.util.HashMap();
		applicationFormGenerateTokenprivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMGENERATETOKEN_SUBMITANDGENERATETOKEN, "SUBMITANDGENERATETOKEN");
		applicationFormGenerateTokenprivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMGENERATETOKEN_ASSIGNAPPLID, "ASSIGNAPPLID");
		applicationFormGenerateTokenprivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMGENERATETOKEN_MAKEPAYMENT, "MAKEPAYMENT");
		applicationFormGenerateTokenprivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFORMGENERATETOKEN_DELETE, "DELETE");
		featurePrivilegesMap.add("APPLICATION_FORM_GENERATE_TOKEN_PRIVILEGES", applicationFormGenerateTokenprivileges);*/
		
		/********************************  Application Fee ****************************/
		/*applicationFeePrivileges = new Ext.util.HashMap();
		applicationFeePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFEE_VIEW, "VIEW");
		applicationFeePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFEE_FINDAPPLICANT, "FINDAPPLICANT");
		applicationFeePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFEE_ASSIGNAPPLID, "ASSIGNAPPLID");
		applicationFeePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFEE_MAKEPAYMENT, "MAKEPAYMENT");
		featurePrivilegesMap.add("APPLICATION_FEE_PRIVILEGES", applicationFeePrivileges);
		
		*//********************************  Submission Fee ****************************//*
		submissionFeePrivileges = new Ext.util.HashMap();
		submissionFeePrivileges.add(FPCONSTANTS.PC_M3_F_SUBMISSIONFEE_VIEW, "VIEW");
		submissionFeePrivileges.add(FPCONSTANTS.PC_M3_F_SUBMISSIONFEE_FINDAPPLICANT, "FINDAPPLICANT");
		submissionFeePrivileges.add(FPCONSTANTS.PC_M3_F_SUBMISSIONFEE_ASSIGNAPPLID, "ASSIGNAPPLID");
		submissionFeePrivileges.add(FPCONSTANTS.PC_M3_F_SUBMISSIONFEE_MAKEPAYMENT, "MAKEPAYMENT");
		featurePrivilegesMap.add("SUBMISSION_FEE_PRIVILEGES", submissionFeePrivileges);*/
		
		/********************************  Stage Fee ****************************/
		stageFeePrivileges = new Ext.util.HashMap();
		stageFeePrivileges.add(FPCONSTANTS.PC_M3_F_STAGEFEE_VIEW, "VIEW");
		stageFeePrivileges.add(FPCONSTANTS.PC_M3_F_STAGEFEE_FINDAPPLICANT, "FINDAPPLICANT");
		stageFeePrivileges.add(FPCONSTANTS.PC_M3_F_STAGEFEE_ASSIGNAPPLID, "ASSIGNAPPLID");
		stageFeePrivileges.add(FPCONSTANTS.PC_M3_F_STAGEFEE_MAKEPAYMENT, "MAKEPAYMENT");
		featurePrivilegesMap.add("STAGE_FEE_PRIVILEGES", stageFeePrivileges);
		
		/********************************  Refund ****************************/
		refundPrivileges = new Ext.util.HashMap();
		refundPrivileges.add(FPCONSTANTS.PC_M3_F_REFUND_VIEW, "VIEW");
		refundPrivileges.add(FPCONSTANTS.PC_M3_F_REFUND_FINDAPPLICANT, "FINDAPPLICANT");
		refundPrivileges.add(FPCONSTANTS.PC_M3_F_REFUND_ASSIGNAPPLID, "ASSIGNAPPLID");
		refundPrivileges.add(FPCONSTANTS.PC_M3_F_REFUND_MAKEPAYMENT, "MAKEPAYMENT");
		featurePrivilegesMap.add("REFUND_PRIVILEGES", refundPrivileges);
		
		/****** For Application***********/
		applicationPrivileges = new Ext.util.HashMap();
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_VIEW,"VIEW");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CREATE,"CREATE");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_UPDATE,"UPDATE");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_EXPORT,"EXPORT");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_EXPORTREPORTS,"EXPORTREPORTS");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_MOREACTIONS,"MOREACTIONS");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ADVANCESEARCH,"ADVANCESEARCH");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_SENDMESSAGE,"SENDMESSAGE");
		applicationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTYLIST_SENDSURVEY,"SENDSURVEY");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_RESETPASSWORD,"RESETPASSWORD");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_FROZEN,"FROZEN");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_UNFROZEN,"UNFROZEN");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PENDING_OFFER_FLAG,"PENDING_OFFER_FLAG");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_OFFER_LETTER_DETAILS,"OFFER_LETTER_DETAILS");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ADMISSION_APPROVAL_DETAILS,"ADMISSION_APPROVAL_DETAILS");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REACTIVATE_APPLICATION,"REACTIVATE_APPLICATION");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONSADMISSIONBULKIMPORTUTILITY_VIEW,"IMPORT_BULK_ADMISSION");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONSAPPLICATIONBULKIMPORTUTILITY_VIEW,"IMPORT_BULK_APPLICATION");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONSNEWAPPLICATIONBULKIMPORTUTILITY_VIEW,"IMPORT_BULK_APPLICATION_NEW");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_BULK_APPLICATION_DOCUMENT_DOWNLOAD_VIEW,"BULK_APPLICATION_DOCUMENT_DOWNLOAD");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_BULK_OFFER_STATUS_UPDATE_VIEW,"BULK_OFFER_STATUS_UPDATE");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_BULK_DOCUMENT_DOWNLOAD,"BULK_DOCUMENT_DOWNLOAD");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ACCEPT_OFFER_LETTER,"ACCEPT_OFFER_LETTER");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DECLINE_OFFER_LETTER,"DECLINE_OFFER_LETTER");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PRINT_PROFILE,"PRINT_PROFILE");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DELETE,"DELETE");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_MY_APPLICATIONS,"MY_APPLICATIONS");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ALL_APPLICATIONS,"ALL_APPLICATIONS");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_GRID_CONFIG,"GRID_CONFIGURATION");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REASSIGN_APPLICATION,"REASSIGN_APPLICATION");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REVIEW_APPLICATION,"REVIEW_APPLICATION");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CHECK_DUPLICATE_EMAIL,"CHECK_DUPLICATE_EMAI");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CHECK_DUPLICATE_NATIONAL_ID,"CHECK_DUPLICATE_NATIONAL_ID");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PRE_ELIGIBILITY_APPLICATION,"PRE_ELIGIBILITY_CHECK");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CALCULATE_EXAM_AGGREGATE,"CALCULATE_EXAM_AGGREGATE");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DOCUMENT_REQUEST,"DOCUMENT_REQUEST");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_FETCH_NSC_DATA,"FETCH_NSC_DATA");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REFRESH_ALL,"REFRESH_ALL");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ONLY_UNMATCHED_RECORDS,"ONLY_UNMATCHED_RECORDS");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PRINT_OFFER_LETTER_WORDS,"PRINT_OFFER_LETTER_WORDS");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ISSUE_OFFER_LETTER,"ISSUE_OFFER_LETTER");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_EXPIRE_OFFER_LETTER,"EXPIRE_OFFER_LETTER");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_SEND_MESSAGE_TO_ALL,"SEND_MESSAGE_TO_ALL");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REASSIGN_ESCALATION,"REASSIGN_ESCALATION");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_APPLICATION_AND_ADMISSION_COMMENTS,"APPLICATION_AND_ADMISSION_COMMENTS");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_IMPORT_APPLICANT_RELATIONSHIP,"IMPORT_APPLICANT_RELATIONSHIP");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_POPIA_OPTION,"POPIA_OPTION");
		applicationPrivileges.add(FPCONSTANTS.PC_M5_F_APPLICATION_PANDADOC_BTN,"PANDADOC_BTN");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_RAISE_SCHOLARSHIP_REQUEST,"RAISE_SCHOLARSHIP_REQUEST");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_RAISE_PRIORITY,"RAISE_PRIORITY");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_MARK_APPLICATION_OFF_TRACK,"MARK_APPLICATION_OFF_TRACK");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_APPLICANT_PROFILE_IMAGE_ICON,"APPLICANT_PROFILE_IMAGE_ICON");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONSADMISSIONAPPROVALBULKIMPORTUTILITY_VIEW,"IMPORT_BULK_ADMISSION_APPROVAL");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_BULK_UPDATE_APPLICATION_STATUS_VIEW,"BULK_UPDATE_APPLICATION_STATUS");
		applicationPrivileges.add(FPCONSTANTS.PC_M3_F_IMPORT_EXISTING_STUDENTS_VIEW,"IMPORT_EXISTING_STUDENTS");

		featurePrivilegesMap.add("APPLICATION_PRIVILEGES", applicationPrivileges);
		
		applicationEligibilityGridPrivileges = new Ext.util.HashMap();
		applicationEligibilityGridPrivileges.add(FPCONSTANTS.PC_M3_F_ELIGIBILITY_CALCULATION_DETAILS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICATION_ELIGIBILITY_CALCULATION_DETAILS_PRIVILEGES", applicationEligibilityGridPrivileges);
		
		/****** For Application Parents & Guardians***********/
		
		applicationDuplicateGridPrivileges = new Ext.util.HashMap();
		applicationDuplicateGridPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DUPLICATE_GRID_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPLICATION_DUPLICATE_GRID_PRIVILEGES", applicationDuplicateGridPrivileges);
		
		applicationApplicantAddressPrivileges = new Ext.util.HashMap();
		applicationApplicantAddressPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATION_APPLICANT_ADDRESS_PRIVILEGES_CURRENT_ADDRESS,"CURRENT_ADDRESS");
		applicationApplicantAddressPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATION_APPLICANT_ADDRESS_PRIVILEGES_ADDRESS_FOR_CORRESPONDANCE,"ADDRESS_FOR_CORRESPONDANCE");
		applicationApplicantAddressPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATION_APPLICANT_ADDRESS_PRIVILEGES_PERMANENT_ADDRESS,"PERMANENT_ADDRESS");
		applicationApplicantAddressPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATION_APPLICANT_ADDRESS_PRIVILEGES_OFFICE_ADDRESS,"OFFICE_ADDRESS");
		applicationApplicantAddressPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATION_APPLICANT_ADDRESS_PRIVILEGES_ADD_ADDRESS,"ADD_ADDRESS");
		applicationApplicantAddressPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATION_APPLICANT_ADDRESS_PRIVILEGES_MODIFY,"MODIFY");
		applicationApplicantAddressPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATION_APPLICANT_ADDRESS_PRIVILEGES_PRINT,"PRINT");
		applicationApplicantAddressPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATION_APPLICANT_ADDRESS_PRIVILEGES_GOOGLE_ADDRESS,"GOOGLE_ADDRESS");
		featurePrivilegesMap.add("APPLICATION_APPLICANT_ADDRESS_PRIVILEGES", applicationApplicantAddressPrivileges);
		
		
		applicationPersonalInfoPrivileges = new Ext.util.HashMap();
		applicationPersonalInfoPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PERSONAL_INFORMATION_VIEW,"VIEW");
		applicationPersonalInfoPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PERSONAL_INFORMATION_SAVE,"SAVE");
		applicationPersonalInfoPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PERSONAL_INFORMATION_VERIFY_DETAILS_BUTTON,"VERIFY_DETAILS_BUTTON");
		applicationPersonalInfoPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PERSONAL_INFORMATION_VALIDATE_ID_BUTTON,"VALIDATE_ID_BUTTON");
		applicationPersonalInfoPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PERSONAL_INFORMATION_PRINT,"PRINT");
		featurePrivilegesMap.add("APPLICANT_PERSONAL_INFORMATION_PRIVILEGES", applicationPersonalInfoPrivileges);
		
		applicationAddressPrivileges = new Ext.util.HashMap();
		applicationAddressPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ADDRESS_VIEW,"VIEW");
		applicationAddressPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ADDRESS_SAVE,"SAVE");
		
		applicationAddressPrivileges.add(FPCONSTANTS.AC_M2_F_CONTACT_DETAILS_VIEW,"VIEW");
		applicationAddressPrivileges.add(FPCONSTANTS.AC_M2_F_CONTACT_DETAILS_SAVE,"SAVE");
		featurePrivilegesMap.add("APPLICANT_ADDRESS_PRIVILEGES", applicationAddressPrivileges);
		
		/****** For Application Parents & Guardians***********/
		applicationParentsGuardiansPrivileges = new Ext.util.HashMap();
		applicationParentsGuardiansPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PARENTS_GUARDIANS_VIEW,"VIEW");
		applicationParentsGuardiansPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PARENTS_GUARDIANS_CREATE,"CREATE");
		applicationParentsGuardiansPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PARENTS_GUARDIANS_UPDATE,"UPDATE");
		applicationParentsGuardiansPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PARENTS_GUARDIANS_DELETE,"DELETE");
		
		applicationParentsGuardiansPrivileges.add(FPCONSTANTS.AC_M11_F_PARENTS_AND_GUARDIANS_VIEW,"VIEW");
		applicationParentsGuardiansPrivileges.add(FPCONSTANTS.AC_M11_F_PARENTS_AND_GUARDIANS_CREATE,"CREATE");
		applicationParentsGuardiansPrivileges.add(FPCONSTANTS.AC_M11_F_PARENTS_AND_GUARDIANS_UPDATE,"UPDATE");
		applicationParentsGuardiansPrivileges.add(FPCONSTANTS.AC_M11_F_PARENTS_AND_GUARDIANS_DELETE,"DELETE");
		applicationParentsGuardiansPrivileges.add(FPCONSTANTS.AC_M11_F_PARENTS_AND_GUARDIANS_EXPORT,"EXPORT");
		
		featurePrivilegesMap.add("APPLICANT_PARENTS_GUARDIANS_PRIVILEGES", applicationParentsGuardiansPrivileges);
		
		/** For Application Fee Payer Details */
		applicationFeePayerDetailPrivileges = new Ext.util.HashMap();
		applicationFeePayerDetailPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_FEE_PAYER_DETAILS_VIEW,"VIEW");
		applicationFeePayerDetailPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_FEE_PAYER_DETAILS_CREATE,"CREATE");
		applicationFeePayerDetailPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_FEE_PAYER_DETAILS_UPDATE,"UPDATE");
		applicationFeePayerDetailPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_FEE_PAYER_DETAILS_DELETE,"DELETE");
		applicationFeePayerDetailPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_FEE_PAYER_DETAILS_GOOGLE_ADDRESS,"GOOGLE_ADDRESS");
		
		applicationFeePayerDetailPrivileges.add(FPCONSTANTS.AC_M28_F_FEE_PAYER_DETAILS_VIEW,"VIEW");
		applicationFeePayerDetailPrivileges.add(FPCONSTANTS.AC_M28_F_FEE_PAYER_DETAILS_CREATE,"CREATE");
		applicationFeePayerDetailPrivileges.add(FPCONSTANTS.AC_M28_F_FEE_PAYER_DETAILS_UPDATE,"UPDATE");
		applicationFeePayerDetailPrivileges.add(FPCONSTANTS.AC_M28_F_FEE_PAYER_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("APPLICANT_FEE_PAYER_DETAILS_PRIVILEGES", applicationFeePayerDetailPrivileges);
		
		/** For Applicant Offer Letter */
		applicantOfferLetterPrivileges = new Ext.util.HashMap();
		/*applicantOfferLetterPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_OFFER_LETTER_ACCEPT_OFFER, "ACCEPT_OFFER");
		applicantOfferLetterPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_OFFER_LETTER_DECLINE_OFFER, "DECLINE_OFFER");*/
		
		applicantOfferLetterPrivileges.add(FPCONSTANTS.AC_M29_F_SELECTION_SNAPSHOT_VIEW, "VIEW");
		applicantOfferLetterPrivileges.add(FPCONSTANTS.AC_M29_F_SELECTION_SNAPSHOT_ACCEPT_OFFER, "ACCEPT_OFFER");
		applicantOfferLetterPrivileges.add(FPCONSTANTS.AC_M29_F_SELECTION_SNAPSHOT_DECLINE_OFFER, "DECLINE_OFFER");
		applicantOfferLetterPrivileges.add(FPCONSTANTS.AC_M29_F_SELECTION_SNAPSHOT_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICANT_OFFER_LETTER_PRIVILEGES", applicantOfferLetterPrivileges);
		
		applicationIdentityDetailsPrivileges = new Ext.util.HashMap();
		applicationIdentityDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_IDENTITY_DETAILS_VIEW,"VIEW");
		applicationIdentityDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_IDENTITY_DETAILS_CREATE,"CREATE");
		applicationIdentityDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_IDENTITY_DETAILS_UPDATE,"UPDATE");
		applicationIdentityDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_IDENTITY_DETAILS_DELETE,"DELETE");
		applicationIdentityDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_IDENTITY_DETAILS_EXPORT,"EXPORT");
		
		applicationIdentityDetailsPrivileges.add(FPCONSTANTS.AC_M13_F_IDENTITY_DOCUMENTS_VIEW,"VIEW");
		applicationIdentityDetailsPrivileges.add(FPCONSTANTS.AC_M13_F_IDENTITY_DOCUMENTS_CREATE,"CREATE");
		applicationIdentityDetailsPrivileges.add(FPCONSTANTS.AC_M13_F_IDENTITY_DOCUMENTS_UPDATE,"UPDATE");
		applicationIdentityDetailsPrivileges.add(FPCONSTANTS.AC_M13_F_IDENTITY_DOCUMENTS_DELETE,"DELETE");
		applicationIdentityDetailsPrivileges.add(FPCONSTANTS.AC_M13_F_IDENTITY_DOCUMENTS_EXPORT,"EXPORT");
		applicationIdentityDetailsPrivileges.add(FPCONSTANTS.AC_M13_F_IDENTITY_DOCUMENTS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICANT_IDENTITY_DETAILS_PRIVILEGES", applicationIdentityDetailsPrivileges);
		
		/*** For Application Payment, Refunds and Fee plan**/
		
		applicationPaymentPrivileges = new Ext.util.HashMap();
		applicationPaymentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PAYMENT_VIEW,"VIEW");
		applicationPaymentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PAYMENT_PRINT,"PRINT");
		
		applicationPaymentPrivileges.add(FPCONSTANTS.AC_M20_F_PAYMENTS_VIEW,"VIEW");
		applicationPaymentPrivileges.add(FPCONSTANTS.AC_M20_F_PAYMENTS_PRINT,"PRINT");
		featurePrivilegesMap.add("APPLICANT_PAYMENT_PRIVILEGES", applicationPaymentPrivileges);
		
		/*applicationOnlinePaymentPrivileges = new Ext.util.HashMap();
		applicationOnlinePaymentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ONLINE_PAYMENT_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICANT_ONLINEPAYMENT_PRIVILEGES", applicationOnlinePaymentPrivileges);*/

		applicationReceiptPrivileges = new Ext.util.HashMap();
		applicationReceiptPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_RECIEPT_VIEW,"VIEW");
		applicationReceiptPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_RECIEPT_PRINT,"PRINT");
		applicationReceiptPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_RECIEPT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		applicationReceiptPrivileges.add(FPCONSTANTS.AC_M24_F_RECIEPTS_VIEW,"VIEW");
		applicationReceiptPrivileges.add(FPCONSTANTS.AC_M24_F_RECIEPTS_PRINT,"PRINT");
		featurePrivilegesMap.add("APPLICATION_RECEIPT_PRIVILEGES", applicationReceiptPrivileges);
		
		applicationRefundsPrivileges = new Ext.util.HashMap();
		applicationRefundsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REFUNDS_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICANT_REFUNDS_PRIVILEGES", applicationRefundsPrivileges);
		
		applicationFeePlanPrivileges = new Ext.util.HashMap();
		applicationFeePlanPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_FEE_PLAN_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICANT_FEEPLAN_PRIVILEGES", applicationFeePlanPrivileges);
		
		
		/*** START NSFAS PERMISSION ****/
		applicationNsfasPrivileges = new Ext.util.HashMap();
		applicationNsfasPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_NSFAS_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICATIONS_NSFAS_PRIVILEGES", applicationNsfasPrivileges);
		
		studentNsfasPrivileges = new Ext.util.HashMap();
		studentNsfasPrivileges.add(FPCONSTANTS.PC_M3_F_STUDENT_NSFAS_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_NSFAS_PRIVILEGES", studentNsfasPrivileges);
		
		studentFundingAndMonitoringPrivileges = new Ext.util.HashMap();
		studentFundingAndMonitoringPrivileges.add(FPCONSTANTS.PC_M3_F_STUDENT_FUNDING_AND_MONITORING_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_FUNDING_AND_MONITORING_PRIVILEGES", studentFundingAndMonitoringPrivileges);
		
		studentFinancialSupportPrivileges = new Ext.util.HashMap();
		studentFinancialSupportPrivileges.add(FPCONSTANTS.PC_M3_F_STUDENT_FINANCIAL_SUPPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_FINANCIAL_SUPPORT_PRIVILEGES", studentFinancialSupportPrivileges);
		
		studentProFormaInvoicePrivileges = new Ext.util.HashMap();
		studentProFormaInvoicePrivileges.add(FPCONSTANTS.PC_M3_F_STUDENT_PRO_FORMA_INVOICE_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_PRO_FORMA_INVOICE_PRIVILEGES", studentProFormaInvoicePrivileges);
		
		applicationNsfasApplicantStatusPrivileges = new Ext.util.HashMap();
		applicationNsfasApplicantStatusPrivileges.add(FPCONSTANTS.PC_M3_F_NSFAS_APPLICANT_STATUS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		applicationNsfasApplicantStatusPrivileges.add(FPCONSTANTS.PC_M3_F_NSFAS_APPLICANT_STATUS_CHECK_STATUS,"CHECK_STATUS");
		featurePrivilegesMap.add("NSFAS_STATUS_DATA_GRID_PRIVILEGES", applicationNsfasApplicantStatusPrivileges);
		
		applicationNsfasFunddingDetailPrivileges = new Ext.util.HashMap();
		applicationNsfasFunddingDetailPrivileges.add(FPCONSTANTS.PC_M3_F_NSFAS_APP_FUNDDING_DETAIL_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		applicationNsfasFunddingDetailPrivileges.add(FPCONSTANTS.PC_M3_F_NSFAS_APP_FUNDDING_DETAIL_CHECK_STATUS,"CHECK_STATUS");
		featurePrivilegesMap.add("NSFAS_APP_FUNDDING_DATA_GRID_PRIVILEGES", applicationNsfasFunddingDetailPrivileges);
		
		applicationNsfasApplicationDetailPrivileges = new Ext.util.HashMap();
		applicationNsfasApplicationDetailPrivileges.add(FPCONSTANTS.PC_M3_F_NSFAS_APPLICATION_DETAIL_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		applicationNsfasApplicationDetailPrivileges.add(FPCONSTANTS.PC_M3_F_NSFAS_APPLICATION_DETAIL_CHECK_STATUS,"CHECK_STATUS");
		featurePrivilegesMap.add("NSFAS_APPLICATION_DETAIL_DATA_GRID_PRIVILEGES", applicationNsfasApplicationDetailPrivileges);
		
		applicationNsfasStudentStatusPrivileges = new Ext.util.HashMap();
		applicationNsfasStudentStatusPrivileges.add(FPCONSTANTS.PC_M3_F_NSFAS_STUDENT_STATUS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		applicationNsfasStudentStatusPrivileges.add(FPCONSTANTS.PC_M3_F_NSFAS_STUDENT_STATUS_CHECK_STATUS,"CHECK_STATUS");
		
		featurePrivilegesMap.add("NSFAS_STUDENT_STATUS_DATA_GRID_PRIVILEGES", applicationNsfasStudentStatusPrivileges);
		
		applicationNsfasStdFunddingDetailPrivileges = new Ext.util.HashMap();
		applicationNsfasStdFunddingDetailPrivileges.add(FPCONSTANTS.PC_M3_F_NSFAS_STD_FUNDDING_DETAIL_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		applicationNsfasStdFunddingDetailPrivileges.add(FPCONSTANTS.PC_M3_F_NSFAS_STD_FUNDDING_DETAIL_CHECK_STATUS,"CHECK_STATUS");
		
		featurePrivilegesMap.add("NSFAS_STD_FUNDDING_DATA_GRID_PRIVILEGES", applicationNsfasStdFunddingDetailPrivileges);
		
		applicationNsfasStudentDetailPrivileges = new Ext.util.HashMap();
		applicationNsfasStudentDetailPrivileges.add(FPCONSTANTS.PC_M3_F_NSFAS_STUDENT_DETAIL_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		applicationNsfasStudentDetailPrivileges.add(FPCONSTANTS.PC_M3_F_NSFAS_STUDENT_DETAIL_CHECK_STATUS,"CHECK_STATUS");
		featurePrivilegesMap.add("NSFAS_STUDENT_DETAIL_DATA_GRID_PRIVILEGES", applicationNsfasStudentDetailPrivileges);
		
		
		/*** END NSFAS PERMISSION ****/
		
		approveApplicationPrivileges = new Ext.util.HashMap();
		approveApplicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPROVE_APPLICATION_APPROVEAPPLICATION,"APPROVEAPPLICATION");
		approveApplicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPROVE_APPLICATION_REJECTAPPLICATION,"REJECTAPPLICATION");
		approveApplicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPROVE_APPLICATION_WITHDRAWAPPLICATION,"WITHDRAWAPPLICATION");
		approveApplicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPROVE_APPLICATION_WITHDRAWADMISSION,"WITHDRAWADMISSION");
		approveApplicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPROVE_APPLICATION_REJECTADMISSION,"REJECTADMISSION");
		approveApplicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPROVE_APPLICATION_APPROVEADMISSION,"APPROVEADMISSION");
		approveApplicationPrivileges.add(FPCONSTANTS.PC_M3_F_APPROVE_APPLICATION_PRINT,"PRINT");
		featurePrivilegesMap.add("APPROVE_APPLICATION_PRIVILEGES", approveApplicationPrivileges);
		
		withdrawFromProgramPrivileges = new Ext.util.HashMap();
		withdrawFromProgramPrivileges.add(FPCONSTANTS.PC_M3_F_APPROVE_APPLICATION_WITHDRAW_FROM_PROGRAM,"WITHDRAW_FROM_PROGRAM");
		featurePrivilegesMap.add("WITHDRAW_FROM_PROGRAM_PRIVILEGES", withdrawFromProgramPrivileges);
		 
		/****** For Application Siblings***********/
		applicationSiblingsPrivileges = new Ext.util.HashMap();
		applicationSiblingsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_SIBLINGS_VIEW,"VIEW");
		applicationSiblingsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_SIBLINGS_CREATE,"CREATE");
		applicationSiblingsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_SIBLINGS_UPDATE,"UPDATE");
		applicationSiblingsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_SIBLINGS_DELETE,"DELETE");
		
		applicationSiblingsPrivileges.add(FPCONSTANTS.AC_M12_F_SIBLING_VIEW,"VIEW");
		applicationSiblingsPrivileges.add(FPCONSTANTS.AC_M12_F_SIBLING_CREATE,"CREATE");
		applicationSiblingsPrivileges.add(FPCONSTANTS.AC_M12_F_SIBLING_UPDATE,"UPDATE");
		applicationSiblingsPrivileges.add(FPCONSTANTS.AC_M12_F_SIBLING_DELETE,"DELETE");
		applicationSiblingsPrivileges.add(FPCONSTANTS.AC_M12_F_SIBLING_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPLICANT_SIBLINGS_PRIVILEGES", applicationSiblingsPrivileges);
		
		/****** For Application Details***********/
		applicationDetailsPrivileges = new Ext.util.HashMap();
		applicationDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DETAILS_VIEW,"VIEW");
		applicationDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DETAILS_CREATE,"CREATE");
		applicationDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DETAILS_DELETE,"DELETE");
		applicationDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DETAILS_UPDATEPRIORITY,"UPDATEPRIORITY");
		applicationDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DETAILS_GRID_CONFIG,"GRID_CONFIGURATION");
		applicationDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DETAILS_SENDOFFERLETTER,"SENDOFFERLETTER");
		applicationDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DETAILS_RESEND_OFFER_LETTER,"RESEND_OFFER_LETTER");
		applicationDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DETAILS_UPDATEOFFERSTATUS,"UPDATEOFFERSTATUS");
		
		applicationDetailsPrivileges.add(FPCONSTANTS.AC_M4_F_PROGRAM_DETAILS_VIEW,"VIEW");
		applicationDetailsPrivileges.add(FPCONSTANTS.AC_M4_F_PROGRAM_DETAILS_UPDATEPRIORITY,"UPDATEPRIORITY");
		applicationDetailsPrivileges.add(FPCONSTANTS.AC_M4_F_PROGRAM_DETAILS_CREATE,"CREATE");
		applicationDetailsPrivileges.add(FPCONSTANTS.AC_M4_F_PROGRAM_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("APPLICATION_DETAILS_PRIVILEGES", applicationDetailsPrivileges);
		
		/****** For Application References***********/
		applicationReferencesPrivileges = new Ext.util.HashMap();
		applicationReferencesPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REFERENCES_VIEW,"VIEW");
		applicationReferencesPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REFERENCES_CREATE,"CREATE");
		applicationReferencesPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REFERENCES_UPDATE,"UPDATE");
		applicationReferencesPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REFERENCES_DELETE,"DELETE");
		applicationReferencesPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REFERENCES_RESENDLINK,"RESENDLINK");
		featurePrivilegesMap.add("APPLICATION_REFERENCES_PRIVILEGES", applicationReferencesPrivileges);
		
		/****** For Application Admission Details***********/
		applicationAdmissionDetailsPrivileges = new Ext.util.HashMap();
		applicationAdmissionDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ADMISSION_DETAILS_VIEW,"VIEW");
		applicationAdmissionDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ADMISSION_DETAILS_ADDPROGRAM,"ADDPROGRAM");
		applicationAdmissionDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ADMISSION_DETAILS_CONFIRMDENYADMISSION,"CONFIRMDENYADMISSION");
		applicationAdmissionDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ADMISSION_DETAILS_CONFIRMWITHDRAWADMISSION,"CONFIRMWITHDRAWADMISSION");
		applicationAdmissionDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ADMISSION_DETAILS_EDIT,"EDIT");
		applicationAdmissionDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ADMISSION_DETAILS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICATION_ADMISSION_DETAILS_PRIVILEGES", applicationAdmissionDetailsPrivileges);
		
		acApplicationAdmissionDetailsPrivileges = new Ext.util.HashMap();
		acApplicationAdmissionDetailsPrivileges.add(FPCONSTANTS.AC_M18_F_ADMISSION_DETAILS_VIEW,"VIEW");
		acApplicationAdmissionDetailsPrivileges.add(FPCONSTANTS.AC_M18_F_ADMISSION_DETAILS_ADDPROGRAM,"ADDPROGRAM");
		acApplicationAdmissionDetailsPrivileges.add(FPCONSTANTS.AC_M18_F_ADMISSION_DETAILS_EDIT,"EDIT");
		featurePrivilegesMap.add("AC_APPLICATION_ADMISSION_DETAILS_PRIVILEGES", acApplicationAdmissionDetailsPrivileges);
		
		/****** For Application MidTerm Admission Details***********/
		/*applicationMidTermAdmissionDetailsPrivileges = new Ext.util.HashMap();
		applicationMidTermAdmissionDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_MIDTERM_ADMISSION_DETAILS_VIEW,"VIEW");
		applicationMidTermAdmissionDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_MIDTERM_ADMISSION_DETAILS_CREATE,"CREATE");
		applicationMidTermAdmissionDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_MIDTERM_ADMISSION_DETAILS_UPDATE,"UPDATE");
		applicationMidTermAdmissionDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_MIDTERM_ADMISSION_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("APPLICATION_MIDTERM_ADMISSION_DETAILS_PRIVILEGES", applicationMidTermAdmissionDetailsPrivileges);
		*/
		/****** For Application Change application program***********/
		applicationChangeApplicationProgramPrivileges = new Ext.util.HashMap();
		applicationChangeApplicationProgramPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CHANGE_APPLICATION_PROGRAM_VIEW,"VIEW");
		applicationChangeApplicationProgramPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CHANGE_APPLICATION_PROGRAM_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICATION_CHANGE_APPLICATION_PROGRAM_PRIVILEGES", applicationChangeApplicationProgramPrivileges);
		
		/****** For Application Change application Inner Grid program***********/
		applicationChangeApplicationProgramInnerPrivileges = new Ext.util.HashMap();
		applicationChangeApplicationProgramInnerPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CHANGE_PROGRAM_INNER_GRID_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICATION_CHANGE_APPLICATION_PROGRAM_INNER_GRID_PRIVILEGES", applicationChangeApplicationProgramInnerPrivileges);
		
		/****** For Application Education***********/
		applicationEducationPrivileges = new Ext.util.HashMap();
		applicationEducationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_EDUCATION_VIEW,"VIEW");
		applicationEducationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_EDUCATION_CREATE,"CREATE");
		applicationEducationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_EDUCATION_UPDATE,"UPDATE");
		applicationEducationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_EDUCATION_DELETE,"DELETE");
		applicationEducationPrivileges.add(FPCONSTANTS.AC_M5_F_EDUCATIONAL_BACKGROUND_VIEW,"VIEW");
		applicationEducationPrivileges.add(FPCONSTANTS.AC_M5_F_EDUCATIONAL_BACKGROUND_CREATE,"CREATE");
		applicationEducationPrivileges.add(FPCONSTANTS.AC_M5_F_EDUCATIONAL_BACKGROUND_UPDATE,"UPDATE");
		applicationEducationPrivileges.add(FPCONSTANTS.AC_M5_F_EDUCATIONAL_BACKGROUND_DELETE,"DELETE");
		applicationEducationPrivileges.add(FPCONSTANTS.AC_M5_F_EDUCATIONAL_BACKGROUND_EXPORT,"EXPORT");
		applicationEducationPrivileges.add(FPCONSTANTS.AC_M5_F_EDUCATIONAL_BACKGROUND_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		applicationEducationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICANT_EDUCATION_PRIVILEGES", applicationEducationPrivileges);
		
		
		/****** For Application Work Experience***********/
		applicationWorkExperiencePrivileges = new Ext.util.HashMap();
		applicationWorkExperiencePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_WORK_EXPERIENCE_VIEW,"VIEW");
		applicationWorkExperiencePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_WORK_EXPERIENCE_CREATE,"CREATE");
		applicationWorkExperiencePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_WORK_EXPERIENCE_UPDATE,"UPDATE");
		applicationWorkExperiencePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_WORK_EXPERIENCE_DELETE,"DELETE");
		
		applicationWorkExperiencePrivileges.add(FPCONSTANTS.AC_M6_F_WORK_EXPERIENCE_VIEW,"VIEW");
		applicationWorkExperiencePrivileges.add(FPCONSTANTS.AC_M6_F_WORK_EXPERIENCE_CREATE,"CREATE");
		applicationWorkExperiencePrivileges.add(FPCONSTANTS.AC_M6_F_WORK_EXPERIENCE_UPDATE,"UPDATE");
		applicationWorkExperiencePrivileges.add(FPCONSTANTS.AC_M6_F_WORK_EXPERIENCE_DELETE,"DELETE");
		applicationWorkExperiencePrivileges.add(FPCONSTANTS.AC_M6_F_WORK_EXPERIENCE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPLICANT_WORK_EXPERIENCE_PRIVILEGES", applicationWorkExperiencePrivileges);
		
		/****** For Application Church Information***********/
		applicationChurchInformationPrivileges = new Ext.util.HashMap();
		applicationChurchInformationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CHURCH_INFORMATION_VIEW,"VIEW");
		applicationChurchInformationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CHURCH_INFORMATION_CREATE,"CREATE");
		applicationChurchInformationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CHURCH_INFORMATION_UPDATE,"UPDATE");
		applicationChurchInformationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CHURCH_INFORMATION_DELETE,"DELETE");
		
		applicationChurchInformationPrivileges.add(FPCONSTANTS.AC_M7_F_CHURCH_INFORMATION_VIEW,"VIEW");
		applicationChurchInformationPrivileges.add(FPCONSTANTS.AC_M7_F_CHURCH_INFORMATION_CREATE,"CREATE");
		applicationChurchInformationPrivileges.add(FPCONSTANTS.AC_M7_F_CHURCH_INFORMATION_UPDATE,"UPDATE");
		applicationChurchInformationPrivileges.add(FPCONSTANTS.AC_M7_F_CHURCH_INFORMATION_DELETE,"DELETE");
		applicationChurchInformationPrivileges.add(FPCONSTANTS.AC_M7_F_CHURCH_INFORMATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPLICANT_CHURCH_INFORMATION_PRIVILEGES", applicationChurchInformationPrivileges);
		
		/****** For Application Church Information***********/
		applicationCommunicationHistoryPrivileges = new Ext.util.HashMap();
		applicationCommunicationHistoryPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_COMMUNICATION_HISTORY_VIEW,"VIEW");
		applicationCommunicationHistoryPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_COMMUNICATION_HISTORY_EXPORT_REPORTS,"EXPORT_REPORTS");
		featurePrivilegesMap.add("APPLICANT_COMMUNICATION_HISTORY_PRIVILEGES", applicationCommunicationHistoryPrivileges);

		applicationPaymentModePrivileges = new Ext.util.HashMap();
		applicationPaymentModePrivileges.add(FPCONSTANTS.AC_M10_F_DEC_PAYMENTS_OFFLINE_PAYMENT_MODE,"OFFLINE_PAYMENT_MODE");
		applicationPaymentModePrivileges.add(FPCONSTANTS.AC_M10_F_DEC_PAYMENTS_ONLINE_PAYMENT_MODE,"ONLINE_PAYMENT_MODE");
		featurePrivilegesMap.add("PAYMENT_MODE_APPLICANT_PROFILE_PRIVILEGES", applicationPaymentModePrivileges);
		
			/****** For Application Non Academic Achievements***********/
		applicationNonAcademicAchievementsPrivileges = new Ext.util.HashMap();
		applicationNonAcademicAchievementsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_NON_ACADEMIC_ACHIEVEMENTS_VIEW,"VIEW");
		applicationNonAcademicAchievementsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_NON_ACADEMIC_ACHIEVEMENTS_CREATE,"CREATE");
		applicationNonAcademicAchievementsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_NON_ACADEMIC_ACHIEVEMENTS_UPDATE,"UPDATE");
		applicationNonAcademicAchievementsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_NON_ACADEMIC_ACHIEVEMENTS_DELETE,"DELETE");
		
		applicationNonAcademicAchievementsPrivileges.add(FPCONSTANTS.AC_M32_F_NON_ACADEMIC_ACHIEVEMENTS_VIEW,"VIEW");
		applicationNonAcademicAchievementsPrivileges.add(FPCONSTANTS.AC_M32_F_NON_ACADEMIC_ACHIEVEMENTS_CREATE,"CREATE");
		applicationNonAcademicAchievementsPrivileges.add(FPCONSTANTS.AC_M32_F_NON_ACADEMIC_ACHIEVEMENTS_UPDATE,"UPDATE");
		applicationNonAcademicAchievementsPrivileges.add(FPCONSTANTS.AC_M32_F_NON_ACADEMIC_ACHIEVEMENTS_DELETE,"DELETE");
		featurePrivilegesMap.add("APPLICANT_NON_ACADEMIC_ACHIEVEMENTS_PRIVILEGES", applicationNonAcademicAchievementsPrivileges);

		/***********Document Requested *************/
		applicationDocumentRequestedPrivileges = new Ext.util.HashMap();
		applicationDocumentRequestedPrivileges.add(FPCONSTANTS.AC_M32_F_DOCUMENT_REQUESTED_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICANT_DOCUMENT_REQUESTED_PRIVILEGES", applicationDocumentRequestedPrivileges);
		
		/****** For Application Medical***********/
		applicationMedicalPrivileges = new Ext.util.HashMap();
		applicationMedicalPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_MEDICAL_VIEW,"VIEW");
		applicationMedicalPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_MEDICAL_CREATE,"CREATE");
		applicationMedicalPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_MEDICAL_UPDATE,"UPDATE");
		applicationMedicalPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_MEDICAL_DELETE,"DELETE");
		
		applicationMedicalPrivileges.add(FPCONSTANTS.AC_M3_F_MEDICAL_DETAILS_CREATE,"CREATE");
		applicationMedicalPrivileges.add(FPCONSTANTS.AC_M3_F_MEDICAL_DETAILS_UPDATE,"UPDATE");
		applicationMedicalPrivileges.add(FPCONSTANTS.AC_M3_F_MEDICAL_DETAILS_DELETE,"DELETE");
		applicationMedicalPrivileges.add(FPCONSTANTS.AC_M3_F_MEDICAL_DETAILS_EXPORT,"EXPORT");
		
		featurePrivilegesMap.add("APPLICANT_MEDICAL_PRIVILEGES", applicationMedicalPrivileges);
		
		/****** For Application Vaccination***********/
		applicationVaccinationPrivileges = new Ext.util.HashMap();
		applicationVaccinationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_VACCINATION_VIEW,"VIEW");
		applicationVaccinationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_VACCINATION_CREATE,"CREATE");
		applicationVaccinationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_VACCINATION_UPDATE,"UPDATE");
		applicationVaccinationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_VACCINATION_DELETE,"DELETE");
		applicationVaccinationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_VACCINATION_EXPORT,"EXPORT");
		
		applicationVaccinationPrivileges.add(FPCONSTANTS.AC_M15_F_VACCINATION_VIEW,"VIEW");
		applicationVaccinationPrivileges.add(FPCONSTANTS.AC_M15_F_VACCINATION_CREATE,"CREATE");
		applicationVaccinationPrivileges.add(FPCONSTANTS.AC_M15_F_VACCINATION_UPDATE,"UPDATE");
		applicationVaccinationPrivileges.add(FPCONSTANTS.AC_M15_F_VACCINATION_DELETE,"DELETE");
		applicationVaccinationPrivileges.add(FPCONSTANTS.AC_M15_F_VACCINATION_EXPORT,"EXPORT");
		
		featurePrivilegesMap.add("APPLICANT_VACCINATION_PRIVILEGES", applicationVaccinationPrivileges);
		
		/****** For Application Extra Curricular Activity***********/
		applicationExtraCurricularActivityPrivileges = new Ext.util.HashMap();
		applicationExtraCurricularActivityPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_EXTRA_CURRICULAR_ACTIVITY_VIEW,"VIEW");
		applicationExtraCurricularActivityPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_EXTRA_CURRICULAR_ACTIVITY_CREATE,"CREATE");
		applicationExtraCurricularActivityPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_EXTRA_CURRICULAR_ACTIVITY_UPDATE,"UPDATE");
		applicationExtraCurricularActivityPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_EXTRA_CURRICULAR_ACTIVITY_DELETE,"DELETE");
		
		applicationExtraCurricularActivityPrivileges.add(FPCONSTANTS.AC_M16_F_EXTRACURRICULAR_ACTIVITY_VIEW,"VIEW");
		applicationExtraCurricularActivityPrivileges.add(FPCONSTANTS.AC_M16_F_EXTRACURRICULAR_ACTIVITY_CREATE,"CREATE");
		applicationExtraCurricularActivityPrivileges.add(FPCONSTANTS.AC_M16_F_EXTRACURRICULAR_ACTIVITY_UPDATE,"UPDATE");
		applicationExtraCurricularActivityPrivileges.add(FPCONSTANTS.AC_M16_F_EXTRACURRICULAR_ACTIVITY_DELETE,"DELETE");
		
		featurePrivilegesMap.add("APPLICANT_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES", applicationExtraCurricularActivityPrivileges);
		
		/****** For Application Competitive exam***********/
		applicationCompetitiveExamPrivileges = new Ext.util.HashMap();
		applicationCompetitiveExamPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_COMPETITIVE_EXAM_VIEW,"VIEW");
		applicationCompetitiveExamPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_COMPETITIVE_EXAM_CREATE,"CREATE");
		applicationCompetitiveExamPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_COMPETITIVE_EXAM_UPDATE,"UPDATE");
		applicationCompetitiveExamPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_COMPETITIVE_EXAM_DELETE,"DELETE");
		
		applicationCompetitiveExamPrivileges.add(FPCONSTANTS.AC_M8_F_ENG_LANG_COMPETENCY_VIEW,"VIEW");
		applicationCompetitiveExamPrivileges.add(FPCONSTANTS.AC_M8_F_ENG_LANG_COMPETENCY_CREATE,"CREATE");
		applicationCompetitiveExamPrivileges.add(FPCONSTANTS.AC_M8_F_ENG_LANG_COMPETENCY_UPDATE,"UPDATE");
		applicationCompetitiveExamPrivileges.add(FPCONSTANTS.AC_M8_F_ENG_LANG_COMPETENCY_DELETE,"DELETE");
		applicationCompetitiveExamPrivileges.add(FPCONSTANTS.AC_M8_F_ENG_LANG_COMPETENCY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPLICANT_COMPETITIVE_EXAM_PRIVILEGES", applicationCompetitiveExamPrivileges);
		
		/****** For Application Other Information***********/
		applicationOtherInformationPrivileges = new Ext.util.HashMap();
		applicationOtherInformationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_OTHER_INFORMATION_VIEW,"VIEW");
		applicationOtherInformationPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_OTHER_INFORMATION_SAVE,"SAVE");
		
		applicationOtherInformationPrivileges.add(FPCONSTANTS.AC_M14_F_OTHER_INFORMATION_VIEW,"VIEW");
		applicationOtherInformationPrivileges.add(FPCONSTANTS.AC_M14_F_OTHER_INFORMATION_SAVE,"SAVE");
		
		featurePrivilegesMap.add("APPLICANT_OTHER_INFORMATION_PRIVILEGES", applicationOtherInformationPrivileges);
		
		/** For Application Medical Detail */
		applicationMedicalDetailPrivileges = new Ext.util.HashMap();
		applicationMedicalDetailPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_MEDICAL_DETAIL_VIEW,"VIEW");
		applicationMedicalDetailPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_MEDICAL_DETAIL_SAVE,"SAVE");
		
		applicationMedicalDetailPrivileges.add(FPCONSTANTS.AC_M30_F_MEDICAL_DETAILS2_VIEW,"VIEW");
		applicationMedicalDetailPrivileges.add(FPCONSTANTS.AC_M30_F_MEDICAL_DETAILS2_SAVE,"SAVE");
		
		featurePrivilegesMap.add("APPLICANT_MEDICAL_DETAIL_PRIVILEGES", applicationMedicalDetailPrivileges);
		
		/** For Application Detail form for AU */
		applicantDetailFormPrivileges = new Ext.util.HashMap();
		applicantDetailFormPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_APPLICANT_DEATAILS_FORM_VIEW,"VIEW");
//		applicantDetailFormPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_APPLICANT_DEATAILS_FORM_SAVE,"SAVE");
//		applicantDetailFormPrivileges.add(FPCONSTANTS.AC_M3_F_MEDICAL_DETAILS_VIEW,"VIEW");
		
		featurePrivilegesMap.add("APPLICANT_DETAIL_FORM_PRIVILEGES", applicantDetailFormPrivileges);
		
		/****** For Application Documents***********/
		applicationDocumentsPrivileges = new Ext.util.HashMap();
		applicationDocumentsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DOCUMENTS_VIEW,"VIEW");
		applicationDocumentsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DOCUMENTS_CREATE,"CREATE");
		applicationDocumentsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DOCUMENTS_UPDATE,"UPDATE");
		applicationDocumentsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DOCUMENTS_DELETE,"DELETE");
		applicationDocumentsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DOCUMENTS_UPLOAD_DOCUMENT,"UPLOAD_DOCUMENT");
		applicationDocumentsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_DOCUMENTS_BULK_DOCUMENT_UPDATE,"BULK_DOCUMENT_UPDATE");
		
		applicationDocumentsPrivileges.add(FPCONSTANTS.AC_M9_F_UPLOAD_DOCUMENTS_VIEW,"VIEW");
		applicationDocumentsPrivileges.add(FPCONSTANTS.AC_M9_F_UPLOAD_DOCUMENTS_CREATE,"CREATE");
		applicationDocumentsPrivileges.add(FPCONSTANTS.AC_M9_F_UPLOAD_DOCUMENTS_UPDATE,"UPDATE");
		applicationDocumentsPrivileges.add(FPCONSTANTS.AC_M9_F_UPLOAD_DOCUMENTS_DELETE,"DELETE");
		applicationDocumentsPrivileges.add(FPCONSTANTS.AC_M9_F_UPLOAD_DOCUMENTS_UPLOAD_DOCUMENT,"UPLOAD_DOCUMENT");
		applicationDocumentsPrivileges.add(FPCONSTANTS.AC_M9_F_UPLOAD_DOCUMENTS_EXPORT,"EXPORT");
		applicationDocumentsPrivileges.add(FPCONSTANTS.AC_M9_F_UPLOAD_DOCUMENTS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICATION_DOCUMENTS_PRIVILEGES", applicationDocumentsPrivileges);
		
		/****** For Application Service Opt In***********/
		applicationServiceOptInPrivileges = new Ext.util.HashMap();
		applicationServiceOptInPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_SERVICEOPTIN_VIEW,"VIEW");
		applicationServiceOptInPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_SERVICEOPTIN_CREATE,"CREATE");
		applicationServiceOptInPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_SERVICEOPTIN_UPDATE,"UPDATE");
		applicationServiceOptInPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_SERVICEOPTIN_DELETE,"DELETE");
		
		applicationServiceOptInPrivileges.add(FPCONSTANTS.AC_M25_F_SERVICE_OPT_IN_VIEW,"VIEW");
		applicationServiceOptInPrivileges.add(FPCONSTANTS.AC_M25_F_SERVICE_OPT_IN_CREATE,"CREATE");
		applicationServiceOptInPrivileges.add(FPCONSTANTS.AC_M25_F_SERVICE_OPT_IN_UPDATE,"UPDATE");
		applicationServiceOptInPrivileges.add(FPCONSTANTS.AC_M25_F_SERVICE_OPT_IN_DELETE,"DELETE");
		applicationServiceOptInPrivileges.add(FPCONSTANTS.AC_M16_F_EXTRACURRICULAR_ACTIVITY_CREATE,"CREATE");
		applicationServiceOptInPrivileges.add(FPCONSTANTS.AC_M16_F_EXTRACURRICULAR_ACTIVITY_UPDATE,"UPDATE");
		applicationServiceOptInPrivileges.add(FPCONSTANTS.AC_M16_F_EXTRACURRICULAR_ACTIVITY_DELETE,"DELETE");
		
		featurePrivilegesMap.add("APPLICATION_SERVICEOPTIN_PRIVILEGES", applicationServiceOptInPrivileges);
		
		/****** For Application Communities Opt In***********/
		applicationCommunitiesOptInPrivileges = new Ext.util.HashMap();
		applicationCommunitiesOptInPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_COMMUNITIESOPTIN_VIEW,"VIEW");
		applicationCommunitiesOptInPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_COMMUNITIESOPTIN_CREATE,"CREATE");
		applicationCommunitiesOptInPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_COMMUNITIESOPTIN_UPDATE,"UPDATE");
		applicationCommunitiesOptInPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_COMMUNITIESOPTIN_DELETE,"DELETE");
		
		applicationCommunitiesOptInPrivileges.add(FPCONSTANTS.AC_M26_F_COMMUNITIES_OPT_IN_VIEW,"VIEW");
		applicationCommunitiesOptInPrivileges.add(FPCONSTANTS.AC_M26_F_COMMUNITIES_OPT_IN_CREATE,"CREATE");
		applicationCommunitiesOptInPrivileges.add(FPCONSTANTS.AC_M26_F_COMMUNITIES_OPT_IN_UPDATE,"UPDATE");
		applicationCommunitiesOptInPrivileges.add(FPCONSTANTS.AC_M26_F_COMMUNITIES_OPT_IN_DELETE,"DELETE");
		
		featurePrivilegesMap.add("APPLICATION_COMMUNITIESOPTIN_PRIVILEGES", applicationCommunitiesOptInPrivileges);
		
		/****** For Application Hostel Personal Requiremments ***********/
		applicantionHostelPersonalRequirements = new Ext.util.HashMap();
		applicantionHostelPersonalRequirements.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_HOSTEL_PERSONAL_REQUIREMENTS_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICATION_HOSTEL_PERSONAL_PRIVILEGES", applicantionHostelPersonalRequirements);
		/****** End Application Hostel Personal Requiremments ***********/
		
		/****** For Application Service Opt In***********/
		/*applicationCheckListItemsPrivileges = new Ext.util.HashMap();
		applicationCheckListItemsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CHECKLIST_ITEMS_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICATION_CHECKlISTITEMS_PRIVILEGES", applicationCheckListItemsPrivileges);*/
		
		/****** For Selection Stage Applicant in Stage***********/
		applicantStagePrivileges = new Ext.util.HashMap();
		applicantStagePrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_APPLICANTINSTAGE_VIEW,"VIEW");
		applicantStagePrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_APPLICANTINSTAGE_ENTERMARKS,"ENTERMARKS");
		applicantStagePrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_APPLICANTINSTAGE_IMPORTMARKS,"IMPORTMARKS");
		applicantStagePrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_APPLICANTINSTAGE_CHANGESTATUS,"CHANGESTATUS");
		applicantStagePrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_APPLICANTINSTAGE_EXPORT,"EXPORT");
		applicantStagePrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_IMPORT_SELECTION_STAGE,"IMPORT_BULK_SELECTION_STAGE_MARK");
		applicantStagePrivileges.add(FPCONSTANTS.PC_M3_F_UPDATING_INDIVIDUAL_SELECTION_STAGE_STATUS,"IMPORT_BULK_SELECTION_STAGE_STATUS");
		featurePrivilegesMap.add("SELECTIONSTAGE_APPLICANTINSTAGE_PRIVILEGES", applicantStagePrivileges);
		
		/****** For Selection Stage Stage Statistics***********/
		stageStatisticsPrivileges = new Ext.util.HashMap();
		stageStatisticsPrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_STAGESTATISTICS_VIEW,"VIEW");
		stageStatisticsPrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_STAGESTATISTICS_OVERRIDEQUOTALIMIT,"OVERRIDEQUOTALIMIT");
		stageStatisticsPrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_STAGESTATISTICS_TRANSFERSEATS,"TRANSFERSEATS");
		stageStatisticsPrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_STAGESTATISTICS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("SELECTIONSTAGE_STAGESTATISTICS_PRIVILEGES", stageStatisticsPrivileges);
		
		/****** For Selection Stage Transfer Seats***********/
		transferSeatsPrivileges = new Ext.util.HashMap();
		transferSeatsPrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_TRANSFERSEATS_VIEW,"VIEW");
		transferSeatsPrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_TRANSFERSEATS_PREVIEWCHANGE,"PREVIEWCHANGE");
		transferSeatsPrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_TRANSFERSEATS_APPLYSEATTRANSFER,"APPLYSEATTRANSFER");
		transferSeatsPrivileges.add(FPCONSTANTS.PC_M3_F_SELECTIONSTAGE_TRANSFERSEATS_ADDCOLUMN,"ADDCOLUMN");
		featurePrivilegesMap.add("SELECTIONSTAGE_TRANSFERSEATS_PRIVILEGES", transferSeatsPrivileges);
		
		/****** For provisional trial admission report***********/
		provisionalTrialAdmissionReportPrivileges = new Ext.util.HashMap();
		provisionalTrialAdmissionReportPrivileges.add(FPCONSTANTS.PC_M3_F_PROVISIONALTRIALADMISSIONREPORT_VIEW,"VIEW");
		provisionalTrialAdmissionReportPrivileges.add(FPCONSTANTS.PC_M3_F_PROVISIONALTRIALADMISSIONREPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PROVISIONAL_TRIAL_ADMISSION_PRIVILEGES", provisionalTrialAdmissionReportPrivileges);
		
		/****** For quota report***********/
		/*quotaReportPrivileges = new Ext.util.HashMap();
		quotaReportPrivileges.add(FPCONSTANTS.PC_M3_F_QUOTAREPORTVIEW_VIEW,"VIEW");
		quotaReportPrivileges.add(FPCONSTANTS.PC_M3_F_QUOTAREPORTVIEW_EXPORT,"EXPORT");
		featurePrivilegesMap.add("QUATO_REPORT_PRIVILEGES", quotaReportPrivileges);
		*/
		/****** For Replacements Closed Start***********/
		/*replacementsClosedStartPrivileges = new Ext.util.HashMap();
		replacementsClosedStartPrivileges.add(FPCONSTANTS.PC_M3_F_REPLACEMENTS_CLOSED_START_VIEW,"VIEW");
		replacementsClosedStartPrivileges.add(FPCONSTANTS.PC_M3_F_REPLACEMENTS_CLOSED_START_STARTREPLACEMENT,"STARTREPLACEMENT");
		featurePrivilegesMap.add("START_REPLACEMENT_PRIVILEGES", replacementsClosedStartPrivileges);*/
		
		/************************************* Completion Module Starts*******************************/
		
		/************* Completion Passing Out ************************************/
		completionPassingOutPrivileges = new Ext.util.HashMap();
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_VIEW,"VIEW");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_EXPORT,"EXPORT");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_UPDATE,"UPDATE");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_MOREACTION,"MOREACTION");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_D_PASSINGOUT_PUBLISH_GRADUATION_CERTIFICATE,"PUBLISH_GRADUATION_CERTIFICATE");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_D_PASSINGOUT_EMAIL_CERTIFICATE,"EMAIL_CERTIFICATE");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_D_PASSINGOUT_EMAIL_ISSUE_CERTIFICATE,"EMAIL_ISSUE_CERTIFICATE");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_BYPASS_PENDING_PAYMENTS_VALIDATION,"PASSINGOUT_BYPASS_PENDING_PAYMENTS_VALIDATION");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_BYPASS_PENDING_REFUNDABLE_VALIDATION,"PASSINGOUT_BYPASS_PENDING_REFUNDABLE_VALIDATION");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_REJECTED,"REJECTED");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_D_PASSINGOUT_PRINT_GRADUATION_CERTIFICATE,"PRINT_GRADUATION_CERTIFICATE");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_D_PASSINGOUT_PRINT_CERTIFICATE,"PRINT_CERTIFICATE");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_DATA_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_UPDATE_PENDING_PAYMENT,"PENDING_PAYMENT");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_UPDATE_REFUND_HISTORY,"REFUND_HISTORY");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_UPDATE_PENDING_REFUNDABLE,"PENDING_REFUNDABLE");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_UPDATE_ISSUE_CERTIFICATES,"ISSUE_CERTIFICATES");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_UPDATE_DOCUMENTS,"DOCUMENTS");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_SEND_TO_STUDENT_PROFILE,"SEND_TO_STUDENT_PROFILE");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_PRINT_AS_WORD_FILE,"PRINT_AS_WORD_FILE");
		completionPassingOutPrivileges.add(FPCONSTANTS.PC_M10_D_PASSINGOUT_BULK_IMPORT_PASSOUT_REJECTION,"BULK_IMPORT_PASSOUT_REJECTION");
		featurePrivilegesMap.add("COMPLETION_PASSING_OUT_PRIVILEGES", completionPassingOutPrivileges);
		
		/************* Completion Passing Out issue certificate ************************************/
		completionPassingOutIssueCertificatePrivileges = new Ext.util.HashMap();
		completionPassingOutIssueCertificatePrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_ISSUE_SEND_MESSAGE,"SEND_MESSAGE");		
		featurePrivilegesMap.add("COMPLETION_PASSING_OUT_ISSUE_CERTIFICATE_SEND_MESSAGE", completionPassingOutIssueCertificatePrivileges);
		
		/************* Completion Passing Out Pending Refunding ************************************/
		completionPassingOutPendingRefundingPrivileges = new Ext.util.HashMap();
		completionPassingOutPendingRefundingPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_PENDING_REFUNDING_SEND_MESSAGE,"SEND_MESSAGE");		
		featurePrivilegesMap.add("COMPLETION_PASSINGOUT_PENDING_REFUNDING_SEND_MESSAGE", completionPassingOutPendingRefundingPrivileges);
		
		/************* Completion Passing Out Pending Payment ************************************/
		completionPassingOutPendingPaymentPrivileges = new Ext.util.HashMap();
		completionPassingOutPendingPaymentPrivileges.add(FPCONSTANTS.PC_M10_F_PASSINGOUT_PENDING_PAYMENT_SEND_MESSAGE,"SEND_MESSAGE");		
		featurePrivilegesMap.add("COMPLETION_PASSINGOUT_PENDING_PAYMENT_SEND_MESSAGE", completionPassingOutPendingPaymentPrivileges);
		
		
		/************* Completion Termination ************************************/
		completionTerminationPrivileges = new Ext.util.HashMap();
		completionTerminationPrivileges.add(FPCONSTANTS.PC_M10_F_TERMINATIONS_VIEW,"VIEW");
		completionTerminationPrivileges.add(FPCONSTANTS.PC_M10_F_TERMINATIONS_EXPORT,"EXPORT");
		completionTerminationPrivileges.add(FPCONSTANTS.PC_M10_F_TERMINATIONS_EMAIL_CERTIFICATE,"EMAIL_CERTIFICATE");
		featurePrivilegesMap.add("COMPLETION_TERMINATION_PRIVILEGES", completionTerminationPrivileges);
		
		/************* Completion Temporary Termination ************************************/
		completionTemporaryTerminationPrivileges = new Ext.util.HashMap();
		completionTemporaryTerminationPrivileges.add(FPCONSTANTS.PC_M10_F_TEMPORARY_TERMINATIONS_VIEW,"VIEW");
		completionTemporaryTerminationPrivileges.add(FPCONSTANTS.PC_M10_F_TEMPORARY_TERMINATIONS_EXPORT,"EXPORT");
		completionTemporaryTerminationPrivileges.add(FPCONSTANTS.PC_M10_F_TEMPORARY_TERMINATIONS_EMAIL_CERTIFICATE,"EMAIL_CERTIFICATE");
		featurePrivilegesMap.add("COMPLETION_TEMPORARY_TERMINATION_PRIVILEGES", completionTemporaryTerminationPrivileges);
		
		/************* Completion Transfer ************************************/
		completionTransferPrivileges = new Ext.util.HashMap();
		completionTransferPrivileges.add(FPCONSTANTS.PC_M10_F_TRANSFERS_VIEW,"VIEW");
		completionTransferPrivileges.add(FPCONSTANTS.PC_M10_F_TRANSFERS_EXPORT,"EXPORT");
		completionTransferPrivileges.add(FPCONSTANTS.PC_M10_F_TRANSFERS_EMAIL_CERTIFICATE,"EMAIL_CERTIFICATE");
		featurePrivilegesMap.add("COMPLETION_TRANSFER_PRIVILEGES", completionTransferPrivileges);
		
		/************* Completion Withdraw from program ************************************/
		completionWithdrawFromProgramPrivileges = new Ext.util.HashMap();
		completionWithdrawFromProgramPrivileges.add(FPCONSTANTS.PC_M10_F_WITHDRAWFROMPROGRAM_VIEW,"VIEW");
		completionWithdrawFromProgramPrivileges.add(FPCONSTANTS.PC_M10_F_WITHDRAWFROMPROGRAM_EXPORT,"EXPORT");
		completionWithdrawFromProgramPrivileges.add(FPCONSTANTS.PC_M10_F_WITHDRAWFROMPROGRAM_BYPASS_PENDING_PAYMENTS_VALIDATION,"BYPASS_PENDING_PAYMENTS_VALIDATION");
		completionWithdrawFromProgramPrivileges.add(FPCONSTANTS.PC_M10_F_WITHDRAWFROMPROGRAM_BYPASS_PENDING_REFUNDABLE_VALIDATION,"BYPASS_PENDING_REFUNDABLE_VALIDATION");
		completionWithdrawFromProgramPrivileges.add(FPCONSTANTS.PC_M10_F_WITHDRAWFROMPROGRAM_EMAIL_CERTIFICATE,"EMAIL_CERTIFICATE");
		featurePrivilegesMap.add("COMPLETION_WITHDRAW_FROM_PROGRAM_PRIVILEGES", completionWithdrawFromProgramPrivileges);
		
		/************************************* Tools and Services Module Starts*******************************/
		
		/************* Tools and Services Complaint ************************************/
		toolServicesComplaintPrivileges = new Ext.util.HashMap();
		toolServicesComplaintPrivileges.add(FPCONSTANTS.PSA_M13_F_COMPLAINTS_VIEW,"VIEW");
		toolServicesComplaintPrivileges.add(FPCONSTANTS.PSA_M13_F_COMPLAINTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("TOOLSERVICE_COMPLAINT_PRIVILEGES", toolServicesComplaintPrivileges);
		
		/********START :Room Allocation***********************************/
		roomAllocationPrivileges = new Ext.util.HashMap();
		//roomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_VIEW,"VIEW");
		roomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_CREATE,"CREATE");
		//roomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_UPDATE,"UPDATE");
		roomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_DELETE,"DELETE");
		roomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_EXPORT,"EXPORT");
		roomAllocationPrivileges.add(FPCONSTANTS.PF_M5_F_ROOMALLOCATION_VIEW,"VIEW");
		
		//roomAllocationPrivileges.add(FPCONSTANTS.SP_M5_F_ROOMALLOCATION_VIEW,"VIEW");
		
		roomAllocationPrivileges.add(FPCONSTANTS.PP_M5_F_ROOMALLOCATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("ROOM_ALLOCATION_PRIVILEGES", roomAllocationPrivileges);
		
		studentRoomAllocationPrivileges = new Ext.util.HashMap();
		studentRoomAllocationPrivileges.add(FPCONSTANTS.SP_M5_F_ROOMALLOCATION_PRINTTIMETABLE,"PRINTTIMETABLE");
		featurePrivilegesMap.add("STUDENT_ROOM_ALLOCATION_PRIVILEGES", studentRoomAllocationPrivileges);
		
		roomAllocationForRoomCapacityPrivileges = new Ext.util.HashMap();
		//roomAllocationForRoomCapacityPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_ROOM_CAPACITY_VIEW,"VIEW");
		roomAllocationForRoomCapacityPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_ROOM_CAPACITY_CREATE,"CREATE");
		//roomAllocationForRoomCapacityPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_ROOM_CAPACITY_UPDATE,"UPDATE");
		//roomAllocationForRoomCapacityPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_ROOM_CAPACITY_DELETE,"DELETE");
		roomAllocationForRoomCapacityPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_ROOM_CAPACITY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("ROOM_ALLOCATION_FOR_ROOM_CAPACITY_PRIVILEGES", roomAllocationForRoomCapacityPrivileges);
		
		roomAllocationForCenterRoomAllocationPrivileges = new Ext.util.HashMap();
		//roomAllocationForCenterRoomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_CENTER_ROOM_ALLOCATION_VIEW,"VIEW");
		roomAllocationForCenterRoomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_CENTER_ROOM_ALLOCATION_CREATE,"CREATE");
		//roomAllocationForCenterRoomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_CENTER_ROOM_ALLOCATION_UPDATE,"UPDATE");
		roomAllocationForCenterRoomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_CENTER_ROOM_ALLOCATION_DELETE,"DELETE");
		roomAllocationForCenterRoomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_CENTER_ROOM_ALLOCATION_EXPORT,"EXPORT");
		roomAllocationForCenterRoomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_CENTER_ROOM_ALLOCATION_MOREACTIONS,"MOREACTION");
		roomAllocationForCenterRoomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_CENTER_ROOM_ALLOCATION_STUDENTROOMALLOCATION,"STUDENTROOMAALOCATION");
		roomAllocationForCenterRoomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_CENTER_ROOM_ALLOCATION_ASSIGNINVIGILATOR,"ASSIGNINVIGILATOR");
		roomAllocationForCenterRoomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_CENTER_ROOM_ALLOCATION_PRINTTIMETABLE,"PRINTTIMETABLE");
		roomAllocationForCenterRoomAllocationPrivileges.add(FPCONSTANTS.PC_M5_F_ROOMALLOCATION_CENTER_ROOM_ALLOCATION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("ROOM_ALLOCATION_FOR_CENTER_ROOM_ALLOCATION_PRIVILEGES", roomAllocationForCenterRoomAllocationPrivileges);
		
		regAssesmentGroupCorePrivileges = new Ext.util.HashMap();
		regAssesmentGroupCorePrivileges.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_GROUP_REGISTRATIONS,"VIEW");
		featurePrivilegesMap.add("ASSESSMENTGROUP_CORE_REGISTRATION_PRIVILEGES", regAssesmentGroupCorePrivileges);

		examBlockCorePrivileges = new Ext.util.HashMap();
		examBlockCorePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_BLOCK, "VIEW");
		featurePrivilegesMap.add("EXAM_BLOCK_PRIVILEGES", examBlockCorePrivileges);

		assessmentSchedultCorePrivileges = new Ext.util.HashMap();
		assessmentSchedultCorePrivileges.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_SCHEDULE, "VIEW");
		featurePrivilegesMap.add("EXAM_SCHEDULED_PRIVILEGES", assessmentSchedultCorePrivileges);
		
		/********END :Room Allocation***********************************/
		
		/********START :Exam Staff Allocation***********************************/
		examStaffAllocationForPnCPrivileges = new Ext.util.HashMap();
		//examStaffAllocationForPnCPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMSTAFFALLOCATION_VIEW,"VIEW");
		examStaffAllocationForPnCPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMSTAFFALLOCATION_CREATE,"CREATE");
		//examStaffAllocationForPnCPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMSTAFFALLOCATION_UPDATE,"UPDATE");
		examStaffAllocationForPnCPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMSTAFFALLOCATION_DELETE,"DELETE");
		examStaffAllocationForPnCPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMSTAFFALLOCATION_EXPORT,"EXPORT");
		//examStaffAllocationForPnCPrivileges.add(FPCONSTANTS.PF_M5_F_EXAMSTAFFALLOCATION_VIEW,"VIEW");
		examStaffAllocationForPnCPrivileges.add(FPCONSTANTS.PF_M5_F_EXAMSTAFFALLOCATION_CREATE,"CREATE");
		//examStaffAllocationForPnCPrivileges.add(FPCONSTANTS.PF_M5_F_EXAMSTAFFALLOCATION_UPDATE,"UPDATE");
		examStaffAllocationForPnCPrivileges.add(FPCONSTANTS.PF_M5_F_EXAMSTAFFALLOCATION_DELETE,"DELETE");
		examStaffAllocationForPnCPrivileges.add(FPCONSTANTS.PF_M5_F_EXAMSTAFFALLOCATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAM_STAFF_ALLOCATION_FOR_PnC_PRIVILEGES", examStaffAllocationForPnCPrivileges);
		
		examStaffAllocationForEvalGroupPrivileges = new Ext.util.HashMap();
		//examStaffAllocationForEvalGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMSTAFFALLOCATION_EVAL_GROUP_VIEW,"VIEW");
		examStaffAllocationForEvalGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMSTAFFALLOCATION_EVAL_GROUP_CREATE,"CREATE");
		//examStaffAllocationForEvalGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMSTAFFALLOCATION_EVAL_GROUP_UPDATE,"UPDATE");
		//examStaffAllocationForEvalGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMSTAFFALLOCATION_EVAL_GROUP_DELETE,"DELETE");
		examStaffAllocationForEvalGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMSTAFFALLOCATION_EVAL_GROUP_EXPORT,"EXPORT");
		examStaffAllocationForEvalGroupPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMSTAFFALLOCATION_EVAL_GROUP_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("EXAM_STAFF_ALLOCATION_FOR_EVAL_GROUP_PRIVILEGES", examStaffAllocationForEvalGroupPrivileges);
		
		/********END :Exam Staff Allocation***********************************/
		
		/********START :Exam Logistics***********************************/
		examLogisticsPrivileges = new Ext.util.HashMap();
		//examLogisticsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_LOGISTIC_VIEW,"VIEW");
		examLogisticsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_LOGISTIC_CREATE,"CREATE");
		//examLogisticsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_LOGISTIC_UPDATE,"UPDATE");
		examLogisticsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_LOGISTIC_DELETE,"DELETE");
		examLogisticsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_LOGISTIC_EXPORT,"EXPORT");
		//examLogisticsPrivileges.add(FPCONSTANTS.PF_M5_F_EXAM_LOGISTIC_VIEW,"VIEW");
		examLogisticsPrivileges.add(FPCONSTANTS.PF_M5_F_EXAM_LOGISTIC_CREATE,"CREATE");
		//examLogisticsPrivileges.add(FPCONSTANTS.PF_M5_F_EXAM_LOGISTIC_UPDATE,"UPDATE");
		examLogisticsPrivileges.add(FPCONSTANTS.PF_M5_F_EXAM_LOGISTIC_DELETE,"DELETE");
		examLogisticsPrivileges.add(FPCONSTANTS.PF_M5_F_EXAM_LOGISTIC_EXPORT,"EXPORT");
		
		examLogisticsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_LOGISTIC_ROOM_WISE_ATTENDANCE,"ROOM_WISE_ATTENDANCE");
		examLogisticsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_LOGISTIC_SCHEME_WISE_ATTENDANCE,"SCHEME_WISE_ATTENDANCE");
		examLogisticsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_LOGISTIC_STUDENT_WISE_ATTENDANCE,"STUDENT_WISE_ATTENDANCE");
		featurePrivilegesMap.add("EXAM_LOGISTICS_PRIVILEGES", examLogisticsPrivileges);
		
		/********END :Exam Logistics***********************************/
		
		/********START :Exam Detention***********************************/
		examDetentionPrivileges = new Ext.util.HashMap();
		examDetentionPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_DETENTION_VIEW,"VIEW");
		examDetentionPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_DETENTION_CREATE,"CREATE");
		examDetentionPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_DETENTION_UPDATE,"UPDATE");
		examDetentionPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_DETENTION_DELETE,"DELETE");
		examDetentionPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_DETENTION_EXPORT,"EXPORT");
		
		featurePrivilegesMap.add("EXAM_DETENTION_PRIVILEGES", examDetentionPrivileges);
		
		/********END :Exam Detention***********************************/
		
		/********START :Exam Thesis Management***********************************/
		examThesisManagementPrivileges = new Ext.util.HashMap();
		examThesisManagementPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_THESIS_VIEW,"VIEW");
		examThesisManagementPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_THESIS_EXPORT,"EXPORT");
		examThesisManagementPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_THESIS_ALL_THESIS,"ALL_THESIS");
		examThesisManagementPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_THESIS_MY_THESIS,"MY_THESIS");
		examThesisManagementPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_THESIS_ADD,"ADD");
		examThesisManagementPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_THESIS_EDIT,"EDIT");
		examThesisManagementPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_THESIS_CANCEL_NOMINATION,"CANCEL_NOMINATION");
		examThesisManagementPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_THESIS_SUBMIT_THESIS,"SUBMIT_THESIS");
		examThesisManagementPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_THESIS_APPROVE_REJECT,"APPROVE_REJECT");
		examThesisManagementPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_THESIS_THESIS_DOCUMENT_DELETE,"THESIS_DOCUMENT_DELETE");
		examThesisManagementPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_THESIS_OTHER_DOCUMENT_DELETE,"OTHER_DOCUMENT_DELETE");
		featurePrivilegesMap.add("EXAM_THESIS_MANAGEMENT_PRIVILEGES", examThesisManagementPrivileges);
		
		/********END :Exam Detention***********************************/
		
		/*****************************START : PROMOTION***********************/
		
		promotionPrivileges = new Ext.util.HashMap();
		promotionPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_APPROVE,"APPROVE");
		promotionPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_PROMOTERETAIN,"PROMOTIONRETAINED");
		promotionPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_SAVE,"SAVE");
		promotionPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_EXPORT,"EXPORT");
		promotionPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_GRID_CONFIG,"GRID_CONFIGURATION");
		promotionPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_IMPORT_PASSOUT_STATUS_UPDATE,"IMPORT_PASSOUT_STATUS_UPDATE");
		promotionPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_SEND_MESSAGE,"SEND_MESSAGE");
		promotionPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_BULK_PROGRESSION_STATUS_UPDATE,"BULK_PROGRESSION_STATUS_UPDATE");
		promotionPrivileges.add(FPCONSTANTS.PC_M4_F_PROMOTION_IMPORT_DEMOTE_STATUS,"IMPORT_DEMOTE_STATUS");
		featurePrivilegesMap.add("PROMOTION", promotionPrivileges);
		
		/************************* END : PROMOTION******************************/
		/***********************start template mapping***********************************/
		reportTemplateMappingPrivileges = new Ext.util.HashMap();
		reportTemplateMappingPrivileges.add(FPCONSTANTS.PC_M12_F_REPORT_TEMPLATE_MAPPING_VIEW,"VIEW");
		reportTemplateMappingPrivileges.add(FPCONSTANTS.PC_M12_F_REPORT_TEMPLATE_MAPPING_UPDATE,"UPDATE");
		reportTemplateMappingPrivileges.add(FPCONSTANTS.PC_M12_F_REPORT_TEMPLATE_MAPPING_CREATE,"CREATE");
		reportTemplateMappingPrivileges.add(FPCONSTANTS.PC_M12_F_REPORT_TEMPLATE_MAPPING_DELETE,"DELETE");
		//reportTemplateMappingPrivileges.add(FPCONSTANTS.PC_M12_F_REPORT_TEMPLATE_MAPPING_EXPORT,"EXPORT");
		featurePrivilegesMap.add("REPORT_TEMPLATE_MAPPING", reportTemplateMappingPrivileges);
		
		reportTranslationMappingPrivileges = new Ext.util.HashMap();
		reportTranslationMappingPrivileges.add(FPCONSTANTS.PC_M12_F_REPORT_TRANSLATION_MAPPING_VIEW,"VIEW");
		featurePrivilegesMap.add("REPORT_TRANSLATION_MAPPING", reportTranslationMappingPrivileges);
		/******************************End********************************************/
		/**********************TRANSPORT MODULE VEHICLE***********************************/
		transportVehiclePrivileges = new Ext.util.HashMap();
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_VIEW,"VIEW");
		//transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_CREATE,"CREATE");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_UPDATE,"UPDATE");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_DELETE,"DELETE");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_EXPORT,"EXPORT");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_MOREACTION,"MOREACTION");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_LICENCEHISTORY,"LICENCEHISTORY");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_INSURANCEHISTORY,"INSURANCEHISTORY");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_EMISSIONHISTORY,"EMISSIONHISTORY");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_ROADTAXHISTORY,"ROADTAXHISTORY");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_JOURNEYASSIGNMENT,"JOURNEYASSIGNMENT");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_FUELCONSUMPTION,"FUELCONSUMPTION");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_SERVICEHISTORY,"SERVICEHISTORY");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_VEHICLEPERMIT,"VEHICLEPERMIT");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_VIEWVEHICLELOCATIONSTATUS,"VIEWVEHICLELOCATIONSTATUS");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		transportVehiclePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_FITNESS_CERTIFICATE,"FITNESS_CERTIFICATE");
		featurePrivilegesMap.add("TRANSPORT_VEHICLE_PRIVILEGES", transportVehiclePrivileges);
		/******************************End********************************************/
		/***********************start TRANSPORT MODULE RUOTE***********************************/
		transportRoutePrivileges = new Ext.util.HashMap();
		transportRoutePrivileges.add(FPCONSTANTS.PC_M11_ROUTE_VIEW,"VIEW");
		transportRoutePrivileges.add(FPCONSTANTS.PC_M11_ROUTE_UPDATE,"UPDATE");
		transportRoutePrivileges.add(FPCONSTANTS.PC_M11_ROUTE_CREATE,"CREATE");
		transportRoutePrivileges.add(FPCONSTANTS.PC_M11_ROUTE_DELETE,"DELETE");
		transportRoutePrivileges.add(FPCONSTANTS.PC_M11_ROUTE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("TRANSPORT_ROUTE_PRIVILEGES", transportRoutePrivileges);
		/******************************End********************************************/
		/***********************start TRANSPORT SERVICE RUOTE***********************************/
		transportServiceRoutePrivileges = new Ext.util.HashMap();
		transportServiceRoutePrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_VIEW,"VIEW");
		transportServiceRoutePrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_UPDATE,"UPDATE");
		transportServiceRoutePrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_CREATE,"CREATE");
		transportServiceRoutePrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_DELETE,"DELETE");
		transportServiceRoutePrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_EXPORT,"EXPORT");
		transportServiceRoutePrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_MOREACTIONS,"MOREACTIONS");
		transportServiceRoutePrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_ASSIGN_DRIVER,"ASSIGN_DRIVER");
		transportServiceRoutePrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_ROUTE_STOPPAGE_REPORT,"ROUTE_STOPPAGE_REPORT");
		transportServiceRoutePrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("TRANSPORT_SERVICE_ROUTE_PRIVILEGES", transportServiceRoutePrivileges);
		/******************************End********************************************/
		/***********************start TRANSPORT VEHICLE TYPE***********************************/
		transportVehicleTypePrivileges = new Ext.util.HashMap();
		transportVehicleTypePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_TYPE_VIEW,"VIEW");
		transportVehicleTypePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_TYPE_UPDATE,"UPDATE");
		transportVehicleTypePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_TYPE_CREATE,"CREATE");
		transportVehicleTypePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_TYPE_DELETE,"DELETE");
		featurePrivilegesMap.add("TRANSPORT_VEHICLE_TYPE_PRIVILEGES", transportVehicleTypePrivileges);
		/******************************End********************************************/
		
		/***********************start TRANSPORT SERVICE ROUTE PEOPLE COVERED***********************************/
		transportServiceRoutePeopleCoveredPrivileges = new Ext.util.HashMap();
		transportServiceRoutePeopleCoveredPrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_PEOPLE_COVERED_VIEW,"VIEW");
		transportServiceRoutePeopleCoveredPrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_PEOPLE_COVERED_UPDATE,"UPDATE");
		transportServiceRoutePeopleCoveredPrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_PEOPLE_COVERED_CREATE,"CREATE");
		transportServiceRoutePeopleCoveredPrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_PEOPLE_COVERED_DELETE,"DELETE");
		transportServiceRoutePeopleCoveredPrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_PEOPLE_COVERED_EXPORT,"EXPORT");
		transportServiceRoutePeopleCoveredPrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_PEOPLE_COVERED_SEND_MESSAGE,"SEND_MESSAGE");
		transportServiceRoutePeopleCoveredPrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_PEOPLE_COVERED_SEND_MESSAGE_ADHOC_MESSAGE,"ADHOC_MESSAGE");
		transportServiceRoutePeopleCoveredPrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_PEOPLE_COVERED_SEND_MESSAGE_MESSAGE_TEMPLATE,"MESSAGE_TEMPLATE");
		transportServiceRoutePeopleCoveredPrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_PEOPLE_COVERED_SEND_MESSAGE,"SEND_MESSAGE");
		transportServiceRoutePeopleCoveredPrivileges.add(FPCONSTANTS.PC_M11_SERVICEROUTE_PEOPLE_COVERED_PRINT_BUS_PASS,"PRINT_BUS_PASS");
	    featurePrivilegesMap.add("TRANSPORT_SERVICE_ROUTE_PEOPLE_COVERED_PRIVILEGES", transportServiceRoutePeopleCoveredPrivileges);
		/******************************End********************************************/
		
		/***********************Start Stop Location***********************************/
		transportStopLocationPrivileges = new Ext.util.HashMap();
		transportStopLocationPrivileges.add(FPCONSTANTS.PC_M11_STOP_LOCATION_VIEW,"VIEW");
		transportStopLocationPrivileges.add(FPCONSTANTS.PC_M11_STOP_LOCATION_UPDATE,"UPDATE");
		transportStopLocationPrivileges.add(FPCONSTANTS.PC_M11_STOP_LOCATION_CREATE,"CREATE");
	//	transportStopLocationPrivileges.add(FPCONSTANTS.PC_M11_STOP_LOCATION_DELETE,"DELETE");
		featurePrivilegesMap.add("TRANSPORT_STOP_LOCATION_PRIVILEGES", transportStopLocationPrivileges);
		/******************************End********************************************/
		
		/***********************Start Licence History***********************************/
		transportVehicleLicenceHistoryPrivileges = new Ext.util.HashMap();
		transportVehicleLicenceHistoryPrivileges.add(FPCONSTANTS.PC_M11_LICENCE_HISTORY_VIEW,"VIEW");
		transportVehicleLicenceHistoryPrivileges.add(FPCONSTANTS.PC_M11_LICENCE_HISTORY_UPDATE,"UPDATE");
		transportVehicleLicenceHistoryPrivileges.add(FPCONSTANTS.PC_M11_LICENCE_HISTORY_CREATE,"CREATE");
		transportVehicleLicenceHistoryPrivileges.add(FPCONSTANTS.PC_M11_LICENCE_HISTORY_DELETE,"DELETE");
		transportVehicleLicenceHistoryPrivileges.add(FPCONSTANTS.PC_M11_LICENCE_HISTORY_EXPORT,"EXPORT");
		transportVehicleLicenceHistoryPrivileges.add(FPCONSTANTS.PC_M11_LICENCE_HISTORY_MOREACTIONS,"MOREACTIONS");
		transportVehicleLicenceHistoryPrivileges.add(FPCONSTANTS.PC_M11_LICENCE_HISTORY_UPLOADDOCUMENT,"UPLOAD_DOCUMENT");
		transportVehicleLicenceHistoryPrivileges.add(FPCONSTANTS.PC_M11_LICENCE_HISTORY_DELETE_DOCUMENT,"DELETE_DOCUMENT");
		
		featurePrivilegesMap.add("TRANSPORT_VEHICLE_LICENCE_HISTORY_PRIVILEGES", transportVehicleLicenceHistoryPrivileges);
		/******************************End********************************************/
		
		/***********************Start Insurance History***********************************/
		transportVehicleInsuranceHistoryPrivileges = new Ext.util.HashMap();
		transportVehicleInsuranceHistoryPrivileges.add(FPCONSTANTS.PC_M11_INSURANCE_HISTORY_VIEW,"VIEW");
		transportVehicleInsuranceHistoryPrivileges.add(FPCONSTANTS.PC_M11_INSURANCE_HISTORY_UPDATE,"UPDATE");
		transportVehicleInsuranceHistoryPrivileges.add(FPCONSTANTS.PC_M11_INSURANCE_HISTORY_CREATE,"CREATE");
		transportVehicleInsuranceHistoryPrivileges.add(FPCONSTANTS.PC_M11_INSURANCE_HISTORY_DELETE,"DELETE");
		transportVehicleInsuranceHistoryPrivileges.add(FPCONSTANTS.PC_M11_INSURANCE_HISTORY_EXPORT,"EXPORT");
		transportVehicleInsuranceHistoryPrivileges.add(FPCONSTANTS.PC_M11_INSURANCE_HISTORY_MOREACTIONS,"MOREACTIONS");
		transportVehicleInsuranceHistoryPrivileges.add(FPCONSTANTS.PC_M11_INSURANCE_HISTORY_UPLOADDOCUMENT,"UPLOAD_DOCUMENT");
		transportVehicleInsuranceHistoryPrivileges.add(FPCONSTANTS.PC_M11_INSURANCE_HISTORY_ADDADDRESS,"ADD_ADDRESS");
		transportVehicleInsuranceHistoryPrivileges.add(FPCONSTANTS.PC_M11_INSURANCE_HISTORY__DELETE_DOCUMENT,"DELETE_DOCUMENT");
	    featurePrivilegesMap.add("TRANSPORT_VEHICLE_INSURANCE_HISTORY_PRIVILEGES", transportVehicleInsuranceHistoryPrivileges);
		/******************************End********************************************/
		
		/***********************Start Emisson History***********************************/
		transportVehicleEmissionHistoryPrivileges = new Ext.util.HashMap();
		transportVehicleEmissionHistoryPrivileges.add(FPCONSTANTS.PC_M11_EMISSION_HISTORY_VIEW,"VIEW");
		transportVehicleEmissionHistoryPrivileges.add(FPCONSTANTS.PC_M11_EMISSION_HISTORY_UPDATE,"UPDATE");
		transportVehicleEmissionHistoryPrivileges.add(FPCONSTANTS.PC_M11_EMISSION_HISTORY_CREATE,"CREATE");
		transportVehicleEmissionHistoryPrivileges.add(FPCONSTANTS.PC_M11_EMISSION_HISTORY_DELETE,"DELETE");
		transportVehicleEmissionHistoryPrivileges.add(FPCONSTANTS.PC_M11_EMISSION_HISTORY_EXPORT,"EXPORT");
		transportVehicleEmissionHistoryPrivileges.add(FPCONSTANTS.PC_M11_EMISSION_HISTORY_MOREACTIONS,"MOREACTIONS");
		transportVehicleEmissionHistoryPrivileges.add(FPCONSTANTS.PC_M11_EMISSION_HISTORY_UPLOADDOCUMENT,"UPLOAD_DOCUMENT");
		transportVehicleEmissionHistoryPrivileges.add(FPCONSTANTS.PC_M11_EMISSION_HISTORY_ADDADDRESS,"ADD_ADDRESS");
		transportVehicleEmissionHistoryPrivileges.add(FPCONSTANTS.PC_M11_EMISSION_HISTORY_DELETE_DOCUMENT,"DELETE_DOCUMENT")
		featurePrivilegesMap.add("TRANSPORT_VEHICLE_EMISSION_HISTORY_PRIVILEGES", transportVehicleEmissionHistoryPrivileges);
		/******************************End********************************************/
		
		/***********************Start Road Tax History***********************************/
		transportVehicleRoadTaxHistoryPrivileges = new Ext.util.HashMap();
		transportVehicleRoadTaxHistoryPrivileges.add(FPCONSTANTS.PC_M11_ROAD_TAX_HISTORY_VIEW,"VIEW");
		transportVehicleRoadTaxHistoryPrivileges.add(FPCONSTANTS.PC_M11_ROAD_TAX_HISTORY_UPDATE,"UPDATE");
		transportVehicleRoadTaxHistoryPrivileges.add(FPCONSTANTS.PC_M11_ROAD_TAX_HISTORY_CREATE,"CREATE");
		transportVehicleRoadTaxHistoryPrivileges.add(FPCONSTANTS.PC_M11_ROAD_TAX_HISTORY_DELETE,"DELETE");
		transportVehicleRoadTaxHistoryPrivileges.add(FPCONSTANTS.PC_M11_ROAD_TAX_HISTORY_EXPORT,"EXPORT");
		transportVehicleRoadTaxHistoryPrivileges.add(FPCONSTANTS.PC_M11_ROAD_TAX_HISTORY_MOREACTIONS,"MOREACTIONS");
		transportVehicleRoadTaxHistoryPrivileges.add(FPCONSTANTS.PC_M11_ROAD_TAX_HISTORY_UPLOADDOCUMENT,"UPLOAD_DOCUMENT");
		transportVehicleRoadTaxHistoryPrivileges.add(FPCONSTANTS.PC_M11_ROAD_TAX_HISTORY_ADDADDRESS,"ADD_ADDRESS");
		transportVehicleRoadTaxHistoryPrivileges.add(FPCONSTANTS.PC_M11_ROAD_TAX_HISTORY_DELETE_DOCUMENT,"DELETE_DOCUMENT");
		featurePrivilegesMap.add("TRANSPORT_VEHICLE_ROAD_TAX_HISTORY_PRIVILEGES", transportVehicleRoadTaxHistoryPrivileges);
		/******************************End********************************************/
		
		
		/***********************Start Vehicle Permit***********************************/
		transportVehiclePermitPrivileges = new Ext.util.HashMap();
		transportVehiclePermitPrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_PERMIT_VIEW,"VIEW");
		transportVehiclePermitPrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_PERMIT_CREATE,"UPDATE");
		transportVehiclePermitPrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_PERMIT_UPDATE,"CREATE");
		transportVehiclePermitPrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_PERMIT_DELETE,"DELETE");
		transportVehiclePermitPrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_PERMIT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("TRANSPORT_VEHICLE_PERMIT_PRIVILEGES", transportVehiclePermitPrivileges);
		/******************************End********************************************/
		
		/***********************Start Vehicle Fitness Certificate***********************************/
		transportVehicleFitnessCertificatePrivileges = new Ext.util.HashMap();
		transportVehicleFitnessCertificatePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_FITNESS_CERTIFICATE_VIEW,"VIEW");
		transportVehicleFitnessCertificatePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_FITNESS_CERTIFICATE_CREATE,"UPDATE");
		transportVehicleFitnessCertificatePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_FITNESS_CERTIFICATE_UPDATE,"CREATE");
		transportVehicleFitnessCertificatePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_FITNESS_CERTIFICATE_DELETE,"DELETE");
		transportVehicleFitnessCertificatePrivileges.add(FPCONSTANTS.PC_M11_VEHICLE_FITNESS_CERTIFICATE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("TRANSPORT_VEHICLE_FITNESS_CERTIFICATE_PRIVILEGES", transportVehicleFitnessCertificatePrivileges);
		/******************************End********************************************/
		
		
		/***********************start JOURNEY ASSIGNMENT***********************************/
		journeyAssignmentPrivileges = new Ext.util.HashMap();
		journeyAssignmentPrivileges.add(FPCONSTANTS.PC_M11_JOURNEYASSIGNMENT_VIEW,"VIEW");
		journeyAssignmentPrivileges.add(FPCONSTANTS.PC_M11_JOURNEYASSIGNMENT_UPDATE,"UPDATE");
		journeyAssignmentPrivileges.add(FPCONSTANTS.PC_M11_JOURNEYASSIGNMENT_CREATE,"CREATE");
		//journeyAssignmentPrivileges.add(FPCONSTANTS.PC_M11_JOURNEYASSIGNMENT_DELETE,"DELETE");
		journeyAssignmentPrivileges.add(FPCONSTANTS.PC_M11_JOURNEYASSIGNMENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("JOURNEY_ASSIGNMENT_PRIVILEGES", journeyAssignmentPrivileges);
		/******************************End********************************************/
		/***********************start JOURNEY ASSIGNMENT***********************************/
		journeyReportPrivileges = new Ext.util.HashMap();
		//journeyReportPrivileges.add(FPCONSTANTS.PC_M11_JOURNEYASSIGNMENT_VIEW,"VIEW");
		journeyReportPrivileges.add(FPCONSTANTS.PC_M11_JOURNEYREPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("JOURNEY_REPORT_PRIVILEGES", journeyReportPrivileges);
		/******************************End********************************************/
		/***********************start JOURNEY ASSIGNMENT***********************************/
		repititionAndCompletionPrivileges = new Ext.util.HashMap();
		//repititionAndCompletionPrivileges.add(FPCONSTANTS.PC_M5_F_REPETITION_AND_COMPLETION_VIEW,"VIEW");
		//repititionAndCompletionPrivileges.add(FPCONSTANTS.PC_M5_F_REPETITION_AND_COMPLETION_UPDATE,"UPDATE");
		repititionAndCompletionPrivileges.add(FPCONSTANTS.PC_M5_F_REPETITION_AND_COMPLETION_CREATE,"CREATE");
		//repititionAndCompletionPrivileges.add(FPCONSTANTS.PC_M5_F_REPETITION_AND_COMPLETION_DELETE,"DELETE");
		repititionAndCompletionPrivileges.add(FPCONSTANTS.PC_M5_F_REPETITION_AND_COMPLETION_MOREACTION,"MOREACTION");
		repititionAndCompletionPrivileges.add(FPCONSTANTS.PC_M5_F_REPETITION_AND_COMPLETION_APPROVE,"APPROVE");
		repititionAndCompletionPrivileges.add(FPCONSTANTS.PC_M5_F_REPETITION_AND_COMPLETION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("REPITITION_AND_COMPLETION_PRIVILEGES", repititionAndCompletionPrivileges);
		/******************************End*******************************************/
		/***********************start MARKSHEET***********************************/
		examMarksheetPrivileges = new Ext.util.HashMap();
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MARKSHEET_VIEW,"VIEW");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MARKSHEET_UPDATE,"UPDATE");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MARKSHEET_CREATE,"CREATE");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MARKSHEET_DELETE,"DELETE");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MARKSHEET_EXPORT,"EXPORT");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MARKSHEET_DOWNLOADMARKSHEETS,"DOWNLOADMARKSHEETS");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MARKSHEET_PUBLISHMARKSHEET,"PUBLISHMARKSHEET");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MARKSHEET_GENERATEANDDOWNLOADMARKSHEET,"GENERATEANDDOWNLOADMARKSHEET");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MARKSHEET_SETUPMARKSHEET,"SETUPMARKSHEET");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MARKSHEET_EXAM_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MARKSHEET_DELETE_RECORD,"DELETE_RECORD");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MARKSHEET_UNPUBLISH_MARKSHEET,"UNPUBLISH_MARKSHEET");
		featurePrivilegesMap.add("EXAM_MARKSHEET_PRIVILEGES", examMarksheetPrivileges);
		/******************************End*******************************************/
		/***********************start MARKSHEET EVAL TYPE***********************************/
		examMarksheetEvalTypePrivileges = new Ext.util.HashMap();
		//examMarksheetEvalTypePrivileges.add(FPCONSTANTS.PC_M5_F_EVAL_TYPE_VIEW,"VIEW");
		//examMarksheetEvalTypePrivileges.add(FPCONSTANTS.PC_M5_F_EVAL_TYPE_UPDATE,"UPDATE");
		examMarksheetEvalTypePrivileges.add(FPCONSTANTS.PC_M5_F_EVAL_TYPE_CREATE,"CREATE");
		examMarksheetEvalTypePrivileges.add(FPCONSTANTS.PC_M5_F_EVAL_TYPE_DELETE,"DELETE");
		//examMarksheetEvalTypePrivileges.add(FPCONSTANTS.PC_M5_F_EVAL_TYPE_EXPORT,"EXPORT");
		
		
		
		featurePrivilegesMap.add("EXAM_MARKSHEET_EVAL_TYPE_PRIVILEGES", examMarksheetEvalTypePrivileges);
		/******************************End*******************************************/
		//************************Manage Repetition and Completion****************************************
		manageRepetitionAndCompletionPrivileges = new Ext.util.HashMap();
		manageRepetitionAndCompletionPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_REPETITION_AND_COMPLETION_SAVEBUTTON,"SAVEBUTTON");
		manageRepetitionAndCompletionPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_REPETITION_AND_COMPLETION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("MANAGE_REPETITION_AND_COMPLETION_PRIVILEGES", manageRepetitionAndCompletionPrivileges);
        //******************************End*************************************************************** 		
		//************************Attendance Eval plan****************************************
		studentAttendancePrivileges = new Ext.util.HashMap();
		studentAttendancePrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ATTENDANCE_SAVABUTTON,"SAVEBUTTON");
		studentAttendancePrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ATTENDANCE_MALPRACTICESAVABUTTON,"MALPRACTICESAVABUTTON");
		studentAttendancePrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ATTENDANCE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_ATTENDANCE_PRIVILEGES", studentAttendancePrivileges);
        //******************************End*************************************************************** 
		//*******************************Attendance Eval Group*********************************
		studentAttendanceEvalGroupPrivileges = new Ext.util.HashMap();
		studentAttendanceEvalGroupPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ATTENDANCE_EVAL_GROUP_SAVABUTTON,"SAVEBUTTON");
		studentAttendanceEvalGroupPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ATTENDANCE_EVAL_GROUP_MALPRACTICESAVABUTTON,"MALPRACTICESAVABUTTON");
		studentAttendanceEvalGroupPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ATTENDANCE_EVAL_GROUP_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_ATTENDANCE_EVAL_GROUP_PRIVILEGES", studentAttendanceEvalGroupPrivileges);
        //******************************End***************************************************************
		//*******************************Attendance Eval Group*********************************
		pandcDashboardPrivileges = new Ext.util.HashMap();
		pandcDashboardPrivileges.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_EXPORT,"EXPORT");
		pandcDashboardPrivileges.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_GENERATE_COURSE_ROSTER_REPORT, "GENERATE_COURSE_ROSTER_REPORT");
		
		//pandcDashboardPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_LEAVE_REPORT_VIEW,"VIEW");
		pandcDashboardPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_LEAVE_REPORT_EXPORT,"EXPORT");
		pandcDashboardPrivileges.add(FPCONSTANTS.SP_M4_F_LEAVEMANAGEMENT_EXPORT,"EXPORT");
		pandcDashboardPrivileges.add(FPCONSTANTS.PP_M4_F_LEAVEMANAGEMENT_EXPORT,"EXPORT");
		pandcDashboardPrivileges.add(FPCONSTANTS.PC_M4_F_SPECIALIZATION_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PANDCDASHBOARD_PRIVILEGES", pandcDashboardPrivileges);
		
		myCouriersPrivileges = new Ext.util.HashMap();
		myCouriersPrivileges.add(FPCONSTANTS.SP_M4_F_COURIERSMANAGEMENT_VIEW,"VIEW");
		myCouriersPrivileges.add(FPCONSTANTS.SP_M4_F_COURIERSMANAGEMENT_EXPORT,"EXPORT");
		myCouriersPrivileges.add(FPCONSTANTS.SP_M4_F_COURIERSMANAGEMENT_UPDATE_ACK_STATUS,"UPDATE_ACKNOWLEDGEMENT_STATUS");
		featurePrivilegesMap.add("FRONT_DESK_MANAGEMENT_STUDENT_PORTAL_PRIVILEGES", myCouriersPrivileges);
		
		
		pandcDashboardOfStudentCourseEnrollmentReportPrivileges = new Ext.util.HashMap();
		pandcDashboardOfStudentCourseEnrollmentReportPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_COURSE_ENROLLMENT_REPORT_EXPORT_REPORTS,"EXPORT_REPORTS");
		pandcDashboardOfStudentCourseEnrollmentReportPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_COURSE_ENROLLMENT_REPORT_EXPORT,"EXPORT");
		pandcDashboardOfStudentCourseEnrollmentReportPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_COURSE_ENROLLMENT_REPORT_VIEW,"VIEW");
		pandcDashboardOfStudentCourseEnrollmentReportPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_COURSE_ENROLLMENT_DATA_GRID,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_COURSE_ENROLLMENT_REPORT_PRIVILEGES", pandcDashboardOfStudentCourseEnrollmentReportPrivileges);
		
		pandcDashboardOfStudentCourseSectionReportPrivileges = new Ext.util.HashMap();
		pandcDashboardOfStudentCourseSectionReportPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_COURSE_SECTION_REPORT_VIEW,"VIEW");
		pandcDashboardOfStudentCourseSectionReportPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_COURSE_SECTION_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_COURSE_SECTION_REPORT_PRIVILEGES", pandcDashboardOfStudentCourseSectionReportPrivileges);
		
		pandcDashboardOfCourseWiseAttendanceReportPrivileges = new Ext.util.HashMap();
		pandcDashboardOfCourseWiseAttendanceReportPrivileges.add(FPCONSTANTS.PC_M5_F_COURSE_WISE_ATTENDANCE_REPORT_PROGRAM_BATCH_SECTION,"PROGRAM_BATCH_SECTION");
		pandcDashboardOfCourseWiseAttendanceReportPrivileges.add(FPCONSTANTS.PC_M5_F_COURSE_WISE_ATTENDANCE_REPORT_SECTION_GROUP,"SECTION_GROUP");
		featurePrivilegesMap.add("COURSE_WISE_ATTENDANCE_REPORT_PRIVILEGES", pandcDashboardOfCourseWiseAttendanceReportPrivileges);
		//******************************End***************************************************************
		
		/*******************************Attendance Eval Group*********************************/
		programPromotionReportPrivileges = new Ext.util.HashMap();
		programPromotionReportPrivileges.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_PROGRAM_PROMOTION_REPORT_VIEW,"VIEW");
		programPromotionReportPrivileges.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_PROGRAM_PROMOTION_REPORT_EXPORT,"EXPORT");
		programPromotionReportPrivileges.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_PROGRAM_PROMOTION_GRID_CONFIGURATION,"GRID_CONFIGURATION");

		featurePrivilegesMap.add("PROGRAM_PROMOTION_REPORT_PRIVILEGES", programPromotionReportPrivileges);
        /******************************End***************************************************************/
		/***********************start MANAGE EVALUATION REMARK***********************************/
		manageEvaluationRemarkPrivileges = new Ext.util.HashMap();
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_EVALUATION_REMARK_VIEW,"VIEW");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_EVALUATION_REMARK_CREATE,"CREATE");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_EVALUATION_REMARK_UPDATE,"UPDATE");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_EVALUATION_REMARK_DELETE,"DELETE");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_EVALUATION_REMARK_EXPORT,"EXPORT");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_EVALUATION_REMARK_SAVEBUTTON,"SAVEBUTTON");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_EVALUATION_REMARK_GENERIC_REMARK,"GENERIC_REMARK");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_EVALUATION_IMPORT_ASSIGN_REMARK,"IMPORT_ASSIGN_REMARK");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_EVALUATION_ENTER_REMARK,"ENTER_REMARK");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_EVALUATION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_EVALUATION_MANAGE_REMARK_STATUS,"MANAGE_REMARK_STATUS");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_EVALUATION_REMARK_GENERATE_REMARK,"GENERATE_REMARK");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_EVALUATION_REMARK_GENERATE_GENERIC_REMARK,"GENERATE_GENERIC_REMARK");
		/*manageEvaluationRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_REMARK_VIEW,"VIEW");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_REMARK_EXPORT,"EXPORT");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_REMARK_CREATE,"CREATE");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_REMARK_UPDATE,"UPDATE");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_REMARK_DELETE,"DELETE");
		manageEvaluationRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_SAVE_BUTTON,"SAVEBUTTON");*/
		
		featurePrivilegesMap.add("MANAGE_EVALUATION_REMARK_PRIVILEGES", manageEvaluationRemarkPrivileges);
		
		manageAssessmentStatusPrivileges = new Ext.util.HashMap();
		manageAssessmentStatusPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_ASSESSMENT_STATUS_VIEW,"VIEW");
		manageAssessmentStatusPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_ASSESSMENT_STATUS_EXPORT,"EXPORT");
		manageAssessmentStatusPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_ASSESSMENT_STATUS_MANAGE_EVENT_STATUS_PENDING,"MANAGE_EVENT_STATUS_PENDING");
		manageAssessmentStatusPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_ASSESSMENT_STATUS_OPEN_FOR_MARK_ENTRY,"OPEN_FOR_MARK_ENTRY");
		manageAssessmentStatusPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_ASSESSMENT_STATUS_CLOSE_MARK_ENTRY,"CLOSE_MARK_ENTRY");
		manageAssessmentStatusPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_ASSESSMENT_STATUS_MANAGE_EVENT_STATUS_RESULT_DECLARED,"MANAGE_EVENT_STATUS_RESULT_DECLARED");
		manageAssessmentStatusPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_ASSESSMENT_STATUS_MANAGE_HIERARCHY_STATUS_PENDING,"MANAGE_HIERARCHY_STATUS_PENDING");
		manageAssessmentStatusPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_ASSESSMENT_STATUS_MANAGE_HIERARCHY_STATUS_RESULT_DECLARED,"MANAGE_HIERARCHY_STATUS_RESULT_DECLARED");
		manageAssessmentStatusPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_ASSESSMENT_STATUS_MANAGE_HIERARCHY_STATUS_OPEN_MARKENTRY,"MANAGE_HIERARCHY_STATUS_OPEN_MARKENTRY");
		manageAssessmentStatusPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_MANAGE_ASSESSMENT_STATUS_REMARK_ENTRY_HOST_FACULTY,"REMARK_ENTRY_HOST_FACULTY");
		featurePrivilegesMap.add("MANAGE_ASSESSMENT_STATUS_PRIVILEGES", manageAssessmentStatusPrivileges);
		
		manageAssessmentStatusFacultyPrivileges = new Ext.util.HashMap();
		manageAssessmentStatusFacultyPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXAM_MANAGE_ASSESSMENT_STATUS_MANAGE_EVENT_STATUS_PENDING,"MANAGE_EVENT_STATUS_PENDING");
		manageAssessmentStatusFacultyPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXAM_MANAGE_ASSESSMENT_STATUS_OPEN_FOR_MARK_ENTRY,"OPEN_FOR_MARK_ENTRY");
		manageAssessmentStatusFacultyPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXAM_MANAGE_ASSESSMENT_STATUS_CLOSE_MARK_ENTRY,"CLOSE_MARK_ENTRY");
		manageAssessmentStatusFacultyPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXAM_MANAGE_ASSESSMENT_STATUS_MANAGE_EVENT_STATUS_RESULT_DECLARED,"MANAGE_EVENT_STATUS_RESULT_DECLARED");
		manageAssessmentStatusFacultyPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_ASSESSMENT_STATUS_MANAGE_HIERARCHY_STATUS_PENDING,"MANAGE_HIERARCHY_STATUS_PENDING");
		manageAssessmentStatusFacultyPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_ASSESSMENT_STATUS_MANAGE_HIERARCHY_STATUS_RESULT_DECLARED,"MANAGE_HIERARCHY_STATUS_RESULT_DECLARED");
		featurePrivilegesMap.add("MANAGE_ASSESSMENT_STATUS_FACULTY_PRIVILEGES", manageAssessmentStatusFacultyPrivileges);
		
		manageEvaluationRemarkPrivilegesFacultyPortal = new Ext.util.HashMap();
		manageEvaluationRemarkPrivilegesFacultyPortal.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_REMARK_VIEW,"VIEW");
		manageEvaluationRemarkPrivilegesFacultyPortal.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_REMARK_EXPORT,"EXPORT");
		manageEvaluationRemarkPrivilegesFacultyPortal.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_REMARK_CREATE,"CREATE");
		manageEvaluationRemarkPrivilegesFacultyPortal.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_REMARK_UPDATE,"UPDATE");
		manageEvaluationRemarkPrivilegesFacultyPortal.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_REMARK_DELETE,"DELETE");
		manageEvaluationRemarkPrivilegesFacultyPortal.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_SAVE_BUTTON,"SAVEBUTTON");
		manageEvaluationRemarkPrivilegesFacultyPortal.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_IMPORT_ASSIGN_REMARK,"IMPORT_ASSIGN_REMARK");
		manageEvaluationRemarkPrivilegesFacultyPortal.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_ENTER_REMARK,"ENTER_REMARK");
		manageEvaluationRemarkPrivilegesFacultyPortal.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_GENERATE_COMMENT,"GENERATE_COMMENT");
		manageEvaluationRemarkPrivilegesFacultyPortal.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		manageEvaluationRemarkPrivilegesFacultyPortal.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_EVALUATION_GENERATE_GENERIC_REMARK,"GENERATE_GENERIC_REMARK");
		featurePrivilegesMap.add("MANAGE_EVALUATION_REMARK_PRIVILEGES_FACULTY", manageEvaluationRemarkPrivilegesFacultyPortal);
		
		/******************************End********************************************/
		
		employeeExaminationDutyChargeRemarkPrivileges = new Ext.util.HashMap();
		employeeExaminationDutyChargeRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXAMINATION_DUTY_CHART_VIEW,"VIEW");
		featurePrivilegesMap.add("FP_M9_F_FACULTY_EXAMINATION_DUTY_CHART_PRIVILEGES", employeeExaminationDutyChargeRemarkPrivileges);
		
		//*******************************Enquiry Dashboard*********************************
		enquiryDashboardPrivileges = new Ext.util.HashMap();
		enquiryDashboardPrivileges.add(FPCONSTANTS.PC_M2_D_ENQUIRIESDASHBOARD_VIEW,"VIEW");
		featurePrivilegesMap.add("ENQUIRYDASHBOARD_PRIVILEGES", enquiryDashboardPrivileges);
        //******************************End***************************************************************
		//*******************************Campaign Dashboard*********************************
		campaignDashboardPrivileges = new Ext.util.HashMap();
		campaignDashboardPrivileges.add(FPCONSTANTS.PC_M1_D_DASHBOARD_VIEW,"VIEW");
		featurePrivilegesMap.add("CAMPAIGNSDASHBOARD_PRIVILEGES", campaignDashboardPrivileges);
        //******************************End***************************************************************
		//*******************************Fee and Payment Dashboard*********************************
		feeAndPaymentDashboardPrivileges = new Ext.util.HashMap();
		feeAndPaymentDashboardPrivileges.add(FPCONSTANTS.PC_M6_D_DASHBOARD_VIEW,"VIEW");
		featurePrivilegesMap.add("FEEANDPAYMENTDASHBOARD_PRIVILEGES", feeAndPaymentDashboardPrivileges);
        //******************************End*************************************************************
		
		//*******************************Fee Report link*********************************
		feeReportPrivileges = new Ext.util.HashMap();
		feeReportPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("FEE_REPORT_PRIVILEGES", feeReportPrivileges);
        //******************************End*************************************************************
		
		//*******************************Fee and Payment Dashboard Fee Payament Statistics*********************************
		feeAndPaymentDashboardStatisticsPrivileges = new Ext.util.HashMap();
		feeAndPaymentDashboardStatisticsPrivileges.add(FPCONSTANTS.PC_M6_D_FEE_DASHBOARD_FEE_PAYMENT_STATISTICS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FEEANDPAYMENT_DASHBOARD_STATISTICS_PRIVILEGES", feeAndPaymentDashboardStatisticsPrivileges);
        //******************************End*************************************************************
		//*******************************Admission Dashboard*********************************
		admissionDashboardPrivileges = new Ext.util.HashMap();
		admissionDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONDASHBOARD_VIEW,"VIEW");
		featurePrivilegesMap.add("ADMISSIONDASHBOARD_PRIVILEGES", admissionDashboardPrivileges);
        //******************************End*************************************************************
		//*******************************DTEF Dashboard*********************************
		dtefDashboardPrivileges = new Ext.util.HashMap();
		dtefDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_DTEF_DASHBOARD_VIEW,"VIEW");
		dtefDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_DTEF_DASHBOARD_EXPORT,"EXPORT");
		dtefDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_DTEF_DASHBOARD_ADMISSION_REPORT,"DTEF_DASHBOARD_ADMISSION_REPORT");
		dtefDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_DTEF_DASHBOARD_SEND_TO_DTEF,"DTEF_DASHBOARD_SEND_TO_DTEF");
		dtefDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_DTEF_DASHBOARD_COURSE_ENROLLMENT_REPORT,"DTEF_DASHBOARD_COURSE_ENROLLMENT_REPORT");
		dtefDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_DTEF_DASHBOARD_DTEF_MODULE_RESULTS,"DTEF_DASHBOARD_DTEF_MODULE_RESULTS");
		dtefDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_DTEF_DASHBOARD_DTEF_INVOICES,"DTEF_DASHBOARD_DTEF_INVOICES");
		featurePrivilegesMap.add("DTEF_DASHBOARD_PRIVILEGES", dtefDashboardPrivileges);
		
        //******************************End*************************************************************
		
		//*******************************DTEF Course Enrollment Grid*************************
		dtefCourseEnrollmentGridPrivileges = new Ext.util.HashMap();
		dtefCourseEnrollmentGridPrivileges.add(FPCONSTANTS.PC_M3_F_DTEF_COURSE_ENROLLMENT_VIEW,"VIEW");
		dtefCourseEnrollmentGridPrivileges.add(FPCONSTANTS.PC_M3_F_DTEF_COURSE_ENROLLMENT_EXPORT,"EXPORT");
		dtefCourseEnrollmentGridPrivileges.add(FPCONSTANTS.PC_M3_F_DTEF_COURSE_ENROLLMENT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		dtefCourseEnrollmentGridPrivileges.add(FPCONSTANTS.PC_M3_F_DTEF_COURSE_ENROLLMENT_SEND_TO_DTEF,"DTEF_COURSE_ENROLLMENT_SEND_TO_DTEF");
		featurePrivilegesMap.add("DTEF_COURSE_ENROLLMENT_PRIVILEGES", dtefCourseEnrollmentGridPrivileges);
		//******************************************End**************************************
		
		//*******************************DTEF Module Results Grid*************************
		dtefModuleResultsGridPrivileges = new Ext.util.HashMap();
		dtefModuleResultsGridPrivileges.add(FPCONSTANTS.PC_M3_F_DTEF_MODULE_RESULTS_EXPORT,"EXPORT");
		dtefModuleResultsGridPrivileges.add(FPCONSTANTS.PC_M3_F_DTEF_MODULE_RESULTS_SEND_TO_DTEF,"DTEF_MODULE_RESULTS_SEND_TO_DTEF");
		featurePrivilegesMap.add("DTEF_MODULE_RESULTS_PRIVILEGES", dtefModuleResultsGridPrivileges);
		//******************************************End**************************************
		
		//*******************************DTEF Invoices Grid*************************
		dtefInvoicesGridPrivileges = new Ext.util.HashMap();
		dtefInvoicesGridPrivileges.add(FPCONSTANTS.PC_M3_F_DTEF_INVOICES_EXPORT,"EXPORT");
		dtefInvoicesGridPrivileges.add(FPCONSTANTS.PC_M3_F_DTEF_INVOICES_SEND_TO_DTEF,"DTEF_INVOICES_SEND_TO_DTEF");
		featurePrivilegesMap.add("DTEF_INVOICES_PRIVILEGES", dtefInvoicesGridPrivileges);
		//******************************************End**************************************
		
		//*******************************Admission Dashboard*********************************
		admissionDemoGraphicsReportDashboardPrivileges = new Ext.util.HashMap();
		admissionDemoGraphicsReportDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONDEMOGRAPHICSREPORTVIEW_VIEW,"VIEW");
		featurePrivilegesMap.add("ADMISSION_DEMOGRAPHICSREPORT_DASHBOARD_PRIVILEGES", admissionDemoGraphicsReportDashboardPrivileges);
		//******************************End*************************************************************
		//*******************************Application Follow Dashboard*********************************
		applicationFollowUpReportDashboardPrivileges = new Ext.util.HashMap();
		applicationFollowUpReportDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFOLLOWUPDASHBOARD_VIEW,"VIEW");
		applicationFollowUpReportDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFOLLOWUPDASHBOARD_EXPORT,"EXPORT");
		applicationFollowUpReportDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONFOLLOWUPDASHBOARD_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICATION_FOLLOWUP_DASHBOARD_PRIVILEGES", applicationFollowUpReportDashboardPrivileges);

        //******************************End*************************************************************
		//*******************************Examination Dashboard*********************************
		examinationDashboardPrivileges = new Ext.util.HashMap();
		examinationDashboardPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_DASHBOARD_VIEW,"VIEW");
		featurePrivilegesMap.add("EXAMINATIONDASHBOARD_PRIVILEGES", examinationDashboardPrivileges);
        //******************************End*************************************************************
		//*******************************Program and Course Dashboard*********************************
		programCourseDashboardPrivileges = new Ext.util.HashMap();
		programCourseDashboardPrivileges.add(FPCONSTANTS.PC_M4_D_PROGRAMSANDCOURSESDASHBOARD_VIEW,"VIEW");
		featurePrivilegesMap.add("PROGRAMCOURSEDASHBOARD_PRIVILEGES", programCourseDashboardPrivileges);
        //******************************End*************************************************************
		
		//*******************************Program and Course Dashboard*********************************
		programBatchReportDashboardPrivileges = new Ext.util.HashMap();
		programBatchReportDashboardPrivileges.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_PROGRAM_BATCH_REPORT_VIEW,"VIEW");
		programBatchReportDashboardPrivileges.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_PROGRAM_BATCH_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PANDCDASHBOARD_PROGRAM_BATCH_REPORT_PRIVILEGES", programBatchReportDashboardPrivileges);
        //******************************End*************************************************************
		
		//*******************************Final Admission List Dashboard*********************************
		finalAdmissionListDashboardPrivileges = new Ext.util.HashMap();
		finalAdmissionListDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_FINAL_ADMISSION_LIST_VIEW,"VIEW");
		featurePrivilegesMap.add("FINALADMISSIONLISTDASHBOARD_PRIVILEGES", finalAdmissionListDashboardPrivileges);
        //******************************End*************************************************************
		//*******************************Provisional and Trial Dashboard*********************************
		provosionalAndTrialDashboardPrivileges = new Ext.util.HashMap();
		provosionalAndTrialDashboardPrivileges.add(FPCONSTANTS.PC_M3_F_PROVISIONALTRIALADMISSIONREPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("PROVOSIONALANDTRIAL_DASHBOARD_PRIVILEGES", provosionalAndTrialDashboardPrivileges);
        //******************************End***************************************************
		//*******************************Complaint Dashboard*********************************
		complaintDashboardPrivileges = new Ext.util.HashMap();
		complaintDashboardPrivileges.add(FPCONSTANTS.PC_M7_D_COMMONSERVICESDASHBOARD_VIEW,"VIEW");
		featurePrivilegesMap.add("COMPLAINTDASHBOARD_PRIVILEGES", complaintDashboardPrivileges);
        //******************************End***************************************************
		//*******************************Completion Dashboard*********************************
		completionDashboardPrivileges = new Ext.util.HashMap();
		completionDashboardPrivileges.add(FPCONSTANTS.PC_M10_F_COMPLETION_DASHBOARD_VIEW,"VIEW");
		featurePrivilegesMap.add("COMPLETIONDASHBOARD_PRIVILEGES", completionDashboardPrivileges);
        //******************************End***************************************************
		//*******************************Completion Report*********************************
		completionReportPrivileges = new Ext.util.HashMap();
		completionReportPrivileges.add(FPCONSTANTS.PC_M10_F_COMPLETION_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("COMPLETIONREPORT_PRIVILEGES", completionReportPrivileges);
        //******************************End***************************************************
		//*******************************Faculty Dashboard*********************************
		facultyDashboardPrivileges = new Ext.util.HashMap();
		facultyDashboardPrivileges.add(FPCONSTANTS.PF_M8_D_FACULTYDASHBOARD_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTYDASHBOARD_PRIVILEGES", facultyDashboardPrivileges);
        //******************************End***************************************************
		//*******************************Faculty Leave Dashboard*********************************
		facultyLeaveDashboardPrivileges = new Ext.util.HashMap();
		facultyLeaveDashboardPrivileges.add(FPCONSTANTS.PF_M8_D_FACULTY_LEAVE_DASHBOARD_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_LEAVE_DASHBOARD_PRIVILEGES", facultyLeaveDashboardPrivileges);
        //******************************End***************************************************
		
		//*******************************Faculty Job Posting*********************************
		facultyJobPostingPrivileges = new Ext.util.HashMap();
		facultyJobPostingPrivileges.add(FPCONSTANTS.PF_M8_E_FACULTY_JOB_POSTING_VIEW,"VIEW");
		facultyJobPostingPrivileges.add(FPCONSTANTS.PF_M8_E_FACULTY_JOB_POSTING_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_JOB_POSTING_PRIVILEGES", facultyJobPostingPrivileges);
		
		//*******************************Faculty Job Posting Applications*********************************
		JobApplicationPrivileges = new Ext.util.HashMap();
		JobApplicationPrivileges.add(FPCONSTANTS.PF_M8_E_FACULTY_JOB_APPLICATION_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_JOB_APPLICATION_PRIVILEGES", JobApplicationPrivileges);
      
        //******************************End***************************************************
		
		
		//*******************************Student Dashboard*********************************
		studentDashboardPrivileges = new Ext.util.HashMap();
		studentDashboardPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSDASHBOARDREPORTS_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENTDASHBOARD_PRIVILEGES", studentDashboardPrivileges);
        //******************************End***************************************************
		//*******************************Journy Report Dashboard*********************************
		journeyReportDashboardPrivileges = new Ext.util.HashMap();
		journeyReportDashboardPrivileges.add(FPCONSTANTS.PC_M11_JOURNEYREPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("JOURNEYREPORTDASHBOARD_PRIVILEGES", journeyReportDashboardPrivileges);
        //******************************End***************************************************
		//*******************************Examination Result*********************************
		examinationResultPrivileges = new Ext.util.HashMap();
		examinationResultPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_RESULT_EXPORT,"EXPORT");
		examinationResultPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_RESULT_APPROVE,"APPROVE");
		
		//examinationResultPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXAMINATION_RESULTS_VIEW,"VIEW");
		examinationResultPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXAMINATION_RESULTS_EXPORT,"EXPORT");
		examinationResultPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXAMINATION_RESULTS_EXPORT_REPORTS,"EXPORT_REPORTS");
		//examMarksheetPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXAMINATION_RESULTS_CREATE,"CREATE");
		//examMarksheetPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_EXAMINATION_RESULTS_UPDATE,"UPDATE");
		examinationResultPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_RESULT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		
		
		featurePrivilegesMap.add("EXAMINATIONRESULT_PRIVILEGES", examinationResultPrivileges);
        //******************************End***************************************************
		//*******************************Faculty Portal Personal Information*********************************
		facultyPortalPersonalDetailsPrivileges = new Ext.util.HashMap();
		facultyPortalPersonalDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PERSONAL_DETAILS_VIEW,"VIEW");
		facultyPortalPersonalDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PERSONAL_DETAILS_SAVEBUTTON,"SAVEBUTTON");
		facultyPortalPersonalDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PERSONAL_DETAILS_VERIFY_DETAILS_BUTTON,"VERIFY_DETAILS_BUTTON");
		facultyPortalPersonalDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PERSONAL_DETAILS_UPLOAD_IMAGE,"UPLOAD_IMAGE");
		//facultyPortalPersonalDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PERSONAL_DETAILS_VIEW,"VIEW");
		//facultyPortalPersonalDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PERSONAL_DETAILS_VERIFY_DETAILS_BUTTON,"VERIFY_DETAILS_BUTTON");
		featurePrivilegesMap.add("FACULTY_PORTAL_PERSONAL_INFORMATION_PRIVILEGES", facultyPortalPersonalDetailsPrivileges);
//		facultyPortalPersonalDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_PERSONAL_DETAILS_UPLOAD_IMAGE_EDIT_ICON,"UPLOAD_IMAGE_EDIT_ICON");
		
		
		employeeProfilePersonalDetailsPrivileges = new Ext.util.HashMap();
		employeeProfilePersonalDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PERSONAL_DETAILS_VIEW,"VIEW");
		employeeProfilePersonalDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PERSONAL_DETAILS_VERIFY_DETAILS_SAVEBUTTON,"SAVEBUTTON");
		employeeProfilePersonalDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PERSONAL_DETAILS_VERIFY_DETAILS_BUTTON,"VERIFY_DETAILS_BUTTON");
		employeeProfilePersonalDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PERSONAL_DETAILS_UPLOAD_IMAGE,"UPLOAD_IMAGE");
		featurePrivilegesMap.add("EMPLOYEE_PROFILE_PERSONAL_INFORMATION_PRIVILEGES", employeeProfilePersonalDetailsPrivileges);
		//employeeProfilePersonalDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_PERSONAL_DETAILS_UPLOAD_IMAGE,"UPLOAD_IMAGE_EDIT_ICON");
		
		//*******************************Faculty Portal Address *********************************
		facultyPortalPersonalAddressPrivileges = new Ext.util.HashMap();
		facultyPortalPersonalAddressPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ADDRESSES_VIEW,"VIEW");
		facultyPortalPersonalAddressPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ADDRESSES_SAVEBUTTON,"SAVEBUTTON");
		facultyPortalPersonalAddressPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ADDRESSES_SAVEBUTTON,"SAVEBUTTON");
		facultyPortalPersonalAddressPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ADDRESSES_CREATE,"CREATE");
		facultyPortalPersonalAddressPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ADDRESSES_UPDATE,"UPDATE");
		facultyPortalPersonalAddressPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_ADDRESSES_PRINT,"PRINT");
		facultyPortalPersonalAddressPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_ADDRESSES_GOOGLE_ADDRESS,"GOOGLE_ADDRESS");
		featurePrivilegesMap.add("FACULTY_PORTAL_PERSONAL_ADDRESS_PRIVILEGES", facultyPortalPersonalAddressPrivileges);
		
        //******************************End***************************************************
		
		//*******************************Faculty Portal Family Details *********************************
		facultyPortalFamilyDetailPrivileges = new Ext.util.HashMap();
		facultyPortalFamilyDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_FAMILY_DETAILS_VIEW,"VIEW");
		facultyPortalFamilyDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_FAMILY_DETAILS_CREATE,"CREATE");
		facultyPortalFamilyDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_FAMILY_DETAILS_UPDATE,"UPDATE");
		facultyPortalFamilyDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_FAMILY_DETAILS_DELETE,"DELETE");
		facultyPortalFamilyDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_FAMILY_DETAILS_EXPORT,"EXPORT");
		facultyPortalFamilyDetailPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_FAMILY_DETAILS_VIEW_DETAILS,"VIEW_DETAILS");
		featurePrivilegesMap.add("FACULTY_PORTAL_FAMILY_DETAILS_PRIVILEGES", facultyPortalFamilyDetailPrivileges);
		
        //******************************End***************************************************
		
		//*******************************Employee Profile Address *********************************
		employeeProfileAddressPrivileges = new Ext.util.HashMap();
		employeeProfileAddressPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ADDRESSES_VIEW,"VIEW");
		employeeProfileAddressPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ADDRESSES_CREATE,"CREATE");
		employeeProfileAddressPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ADDRESSES_UPDATE,"UPDATE");
		employeeProfileAddressPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_ADDRESSES_PRINT,"PRINT");
		featurePrivilegesMap.add("EMPLOYEE_PROFILE_ADDRESS_PRIVILEGES", employeeProfileAddressPrivileges);
		
		//*******************************Employee Profile Family Detail *********************************
		employeeProfileFamilyDetailPrivileges = new Ext.util.HashMap();
		employeeProfileFamilyDetailPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_FAMILY_DETAILS_VIEW,"VIEW");
		employeeProfileFamilyDetailPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_FAMILY_DETAILS_CREATE,"CREATE");
		employeeProfileFamilyDetailPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_FAMILY_DETAILS_UPDATE,"UPDATE");
		employeeProfileFamilyDetailPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_FAMILY_DETAILS_DELETE,"DELETE");
		employeeProfileFamilyDetailPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_FAMILY_DETAILS_EXPORT,"EXPORT");
		employeeProfileFamilyDetailPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_FAMILY_DETAILS_VIEW_DETAILS,"VIEW_DETAILS");
		featurePrivilegesMap.add("EMPLOYEE_PROFILE_FAMILY_DETAILS_PRIVILEGES", employeeProfileFamilyDetailPrivileges);
		
		//*******************************Selection Stage Buttons*********************************
		admissionSelectionStagePrivileges = new Ext.util.HashMap();
		admissionSelectionStagePrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSELECTIONSTAGES_VIEWRULECRITERIA,"VIEWRULECRITERIA");
		admissionSelectionStagePrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSELECTIONSTAGES_STAGEDOCUMENTS,"STAGEDOCUMENTS");
		admissionSelectionStagePrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSELECTIONSTAGES_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		//admissionSelectionStagePrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSELECTIONSTAGES_EVALUATEAPPLICANT,"EVALUATEAPPLICANT");
		//admissionSelectionStagePrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSELECTIONSTAGES_PROMOTETONEXTSTAGE,"PROMOTETONEXTSTAGE");
		//admissionSelectionStagePrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSELECTIONSTAGES_CALCULATERANK,"CALCULATERANK");
		//admissionSelectionStagePrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSELECTIONSTAGES_GENERATEPRECLOSURELIST,"GENERATEPRECLOSURELIST");
		featurePrivilegesMap.add("ADMISSION_SELECTION_STAGE_PRIVILEGES", admissionSelectionStagePrivileges);
        //******************************End***************************************************
		//*******************************Selection Stage Bottom Panel Buttons*********************************
		admissionSelectionStageBottomPanelPrivileges = new Ext.util.HashMap();
		admissionSelectionStageBottomPanelPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSELECTIONSTAGES_EVALUATEAPPLICANT,"EVALUATEAPPLICANT");
		admissionSelectionStageBottomPanelPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSELECTIONSTAGES_PROMOTETONEXTSTAGE,"PROMOTETONEXTSTAGE");
		admissionSelectionStageBottomPanelPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSELECTIONSTAGES_CALCULATERANK,"CALCULATERANK");
		admissionSelectionStageBottomPanelPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSELECTIONSTAGES_GENERATEPRECLOSURELIST,"GENERATEPRECLOSURELIST");
		admissionSelectionStageBottomPanelPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSELECTIONSTAGES_CLOSESTAGE,"CLOSESTAGE");
		admissionSelectionStageBottomPanelPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSIONSELECTIONSTAGES_PROMOTEWITHCONDITIONS,"PROMOTEWITHCONDITIONS");
		featurePrivilegesMap.add("ADMISSION_SELECTION_STAGE_BOTTOM_PANEL_PRIVILEGES", admissionSelectionStageBottomPanelPrivileges);
        //******************************End***************************************************
		//*******************************Admission Replacement *********************************
		/*admissionReplacementStudentToBeReplacedPrivileges = new Ext.util.HashMap();
		admissionReplacementStudentToBeReplacedPrivileges.add(FPCONSTANTS.PC_M3_F_ADMREPLACEMENTSTUDENTTOBEREPLACED_SELECTIONSTATISTIC,"SELECTIONSTATISTIC");
		admissionReplacementStudentToBeReplacedPrivileges.add(FPCONSTANTS.PC_M3_F_ADMREPLACEMENTSTUDENTTOBEREPLACED_EXPORT,"EXPORT");
		featurePrivilegesMap.add("ADMISSION_REPLACEMENT_STUDENT_TOBE_REPLACED_PRIVILEGES", admissionReplacementStudentToBeReplacedPrivileges);*/
        //******************************End***************************************************
		//*******************************Admission Replacement *********************************
		/*admissionReplacementPrivileges = new Ext.util.HashMap();
		admissionReplacementPrivileges.add(FPCONSTANTS.PC_M3_F_ADMREPLACEMENT_ADDTOAPPROVALLIST,"ADDTOAPPROVALLIST");
		admissionReplacementPrivileges.add(FPCONSTANTS.PC_M3_F_ADMREPLACEMENT_VIEWAPPROVALLIST,"VIEWAPPROVALLIST");
		featurePrivilegesMap.add("ADMISSION_REPLACEMENT_PRIVILEGES", admissionReplacementPrivileges);*/
        //******************************End***********************************************************************
		/*admissionApprovalReplacementPrivileges = new Ext.util.HashMap();
		admissionApprovalReplacementPrivileges.add(FPCONSTANTS.PC_M3_F_ADMREPLACEMENT_APPROVALREPLACEMENT,"APPROVALREPLACEMENT");
		admissionApprovalReplacementPrivileges.add(FPCONSTANTS.PC_M3_F_ADMREPLACEMENT_REJECTREPLACEMENT,"REJECTREPLACEMENT");
		featurePrivilegesMap.add("ADMISSION_APPROVAL_REPLACEMENT_PRIVILEGES", admissionApprovalReplacementPrivileges);*/
        //******************************End**************************************************************************
		/*admissionCloseReplacementPrivileges = new Ext.util.HashMap();
		admissionCloseReplacementPrivileges.add(FPCONSTANTS.PC_M3_F_ADMREPLACEMENT_CLOSEREPLACEMENT,"CLOSEREPLACEMENT");
		featurePrivilegesMap.add("ADMISSION_CLOSE_REPLACEMENT_PRIVILEGES", admissionCloseReplacementPrivileges);*/
        //******************************End***************************************************
		/*admissionStartReplacementPrivileges = new Ext.util.HashMap();
		featurePrivilegesMap.add("ADMISSION_START_REPLACEMENT_PRIVILEGES", admissionStartReplacementPrivileges);*/
        //******************************End**********************************************************************
		//******************************Count Of enquiry***************************************************
		countOfEnquiryPrivileges = new Ext.util.HashMap();
		countOfEnquiryPrivileges.add(FPCONSTANTS.PC_M2_D_COUNTOFENQUIRIES_VIEW,"VIEW");
		featurePrivilegesMap.add("COUNT_OF_ENQUIRY_PRIVILEGES", countOfEnquiryPrivileges);
        //******************************End*********************************************************************
		//******************************Closure Rate enquiry***************************************************
		enquiryClosureRatePrivileges = new Ext.util.HashMap();
		enquiryClosureRatePrivileges.add(FPCONSTANTS.PC_M2_D_ENQUIRYCLOSURERATE_VIEW,"VIEW");
		featurePrivilegesMap.add("ENQUIRY_CLOSURE_RATE_PRIVILEGES", enquiryClosureRatePrivileges);
        //******************************End*********************************************************************
		//******************************Closure Reason enquiry***************************************************
		enquiryClosureReasonPrivileges = new Ext.util.HashMap();
		enquiryClosureReasonPrivileges.add(FPCONSTANTS.PC_M2_D_ENQUIRYCLOSUREREASON_VIEW,"VIEW");
		featurePrivilegesMap.add("ENQUIRY_CLOSURE_REASON_PRIVILEGES", enquiryClosureReasonPrivileges);
        //******************************End*********************************************************************
		//******************************Follow up Scheduled***************************************************
		enquiryFollowupScheduledPrivileges = new Ext.util.HashMap();
		enquiryFollowupScheduledPrivileges.add(FPCONSTANTS.PC_M2_D_ENQUIRYFOLLOWUPSHEDULE_VIEW,"VIEW");
		featurePrivilegesMap.add("ENQUIRY_FOLLOWUP_SCHEDULED_PRIVILEGES", enquiryFollowupScheduledPrivileges);
        //******************************End*********************************************************************
		//******************************Pending Enquiry***************************************************
		pendingEnquiryPrivileges = new Ext.util.HashMap();
		pendingEnquiryPrivileges.add(FPCONSTANTS.PC_M2_D_PENDINGENQUIRY_VIEW,"VIEW");
		featurePrivilegesMap.add("PENDING_ENQUIRY_PRIVILEGES", pendingEnquiryPrivileges);
        //******************************End*********************************************************************
		//******************************Pending Enquiry***************************************************
		readingMaterialInformationPrivileges = new Ext.util.HashMap();
		readingMaterialInformationPrivileges.add(FPCONSTANTS.PC_M4_F_READINGMATERIAL_VIEW,"VIEW");
		readingMaterialInformationPrivileges.add(FPCONSTANTS.PC_M4_F_READINGMATERIAL_CREATE,"CREATE");
		readingMaterialInformationPrivileges.add(FPCONSTANTS.PC_M4_F_READINGMATERIAL_UPDATE,"UPDATE");
		readingMaterialInformationPrivileges.add(FPCONSTANTS.PC_M4_F_READINGMATERIAL_EXPORT,"EXPORT");
		readingMaterialInformationPrivileges.add(FPCONSTANTS.PC_M4_F_READINGMATERIAL_DELETE,"DELETE");
		readingMaterialInformationPrivileges.add(FPCONSTANTS.PC_M4_F_READINGMATERIAL_MOREACTIONS,"MOREACTIONS");
		readingMaterialInformationPrivileges.add(FPCONSTANTS.PC_M4_F_READINGMATERIAL_ADD_STOCK,"ADD_STOCK");
		readingMaterialInformationPrivileges.add(FPCONSTANTS.PC_M4_F_READINGMATERIAL_MAP_COURSES,"MAP_COURSES");
		readingMaterialInformationPrivileges.add(FPCONSTANTS.PC_M4_F_READINGMATERIAL_PC_READING_MATERIAL,"PC_READING_MATERIAL");
		readingMaterialInformationPrivileges.add(FPCONSTANTS.PC_M4_F_READINGMATERIAL_PC_OTHER_RESOURCES,"PC_OTHER_RESOURCES");
		readingMaterialInformationPrivileges.add(FPCONSTANTS.PC_M4_F_READINGMATERIAL_MAP_COURSE_VARIANTS,"MAP_COURSE_VARIANTS");
		readingMaterialInformationPrivileges.add(FPCONSTANTS.PC_M4_F_READINGMATERIAL_EXPORT_REPORTS,"EXPORT_REPORTS");
		readingMaterialInformationPrivileges.add(FPCONSTANTS.PC_M4_F_READINGMATERIAL_GRID_CONFIG,"GRID_CONFIGURATION");
        featurePrivilegesMap.add("READING_MATERIAL_INFORMATION_PRIVILEGES", readingMaterialInformationPrivileges);
        //******************************End*********************************************************************
        
       
        mapCourseVariantPrivileges = new Ext.util.HashMap();
        mapCourseVariantPrivileges.add(FPCONSTANTS.PC_M4_F_MAPCOURSEVARIENT_CREATE,"CREATE");
        mapCourseVariantPrivileges.add(FPCONSTANTS.PC_M4_F_MAPCOURSEVARIENT_DELETE,"DELETE");
        mapCourseVariantPrivileges.add(FPCONSTANTS.PC_M4_F_MAPCOURSEVARIENT_EXPORT,"EXPORT");
        featurePrivilegesMap.add("MAP_COURSE_VARIANT_PRIVILEGES", mapCourseVariantPrivileges);
        
        addStockPrivileges = new Ext.util.HashMap();
        addStockPrivileges.add(FPCONSTANTS.PC_M4_F_ADDSTOCK_CREATE,"CREATE");
        addStockPrivileges.add(FPCONSTANTS.PC_M4_F_ADDSTOCK_EXPORT,"EXPORT");
        featurePrivilegesMap.add("ADD_STOCK_PRIVILEGES", addStockPrivileges);
        
		//******************************Exam Dashboard***************************************************
		examinationStatisticsPrivileges = new Ext.util.HashMap();
		examinationStatisticsPrivileges.add(FPCONSTANTS.PC_M5_D_EXAMINATIONSTATISTICS_VIEW,"VIEW");
		examinationStatisticsPrivileges.add(FPCONSTANTS.PC_M5_D_EXAMINATIONSTATISTICS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_STATISTICS_PRIVILEGES", examinationStatisticsPrivileges);
        //******************************End*********************************************************************
		//******************************Exam Dashboard***************************************************
		examinationLogisticsStatisticsSupervisorPrivileges = new Ext.util.HashMap();
		examinationLogisticsStatisticsSupervisorPrivileges.add(FPCONSTANTS.PC_M5_D_EXAMLOGISTICS_SUPERVISOR_VIEW,"VIEW");
		examinationLogisticsStatisticsSupervisorPrivileges.add(FPCONSTANTS.PC_M5_D_EXAMLOGISTICS_SUPERVISOR_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_LOGISTICS_STATISTICS_SUPERVISOR_PRIVILEGES", examinationLogisticsStatisticsSupervisorPrivileges);
        //******************************End*********************************************************************
		//******************************Exam Dashboard***************************************************
		examinationLogisticsUpcomingCenterUsagePrivileges = new Ext.util.HashMap();
		examinationLogisticsUpcomingCenterUsagePrivileges.add(FPCONSTANTS.PC_M5_D_EXAMLOGISTICUPCOMINGCENTERUSAGE_VIEW,"VIEW");
		examinationLogisticsUpcomingCenterUsagePrivileges.add(FPCONSTANTS.PC_M5_D_EXAMLOGISTICUPCOMINGCENTERUSAGE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_LOGISTICS_UPCOMING_CENTER_USAGE_PRIVILEGES", examinationLogisticsUpcomingCenterUsagePrivileges);
        //******************************End*********************************************************************
		//******************************Manage Distributin List***************************************************
		manageDistributionListPrivileges = new Ext.util.HashMap();
		manageDistributionListPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_DISTRIBUTION_CREATE,"CREATE");
		manageDistributionListPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_DISTRIBUTION_UPDATE,"UPDATE");
		manageDistributionListPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_DISTRIBUTION_DELETE,"DELETE");
		manageDistributionListPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_DISTRIBUTION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("MANAGE_DISTRIBUTION_LIST_PRIVILEGES", manageDistributionListPrivileges);
        //******************************End*********************************************************************
		//******************************Manage Distributin List***************************************************
		studyMaterialDistributionPrivileges = new Ext.util.HashMap();
		//studyMaterialDistributionPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTION_VIEW,"VIEW");
		studyMaterialDistributionPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTION_CREATE,"CREATE");
		//studyMaterialDistributionPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTION_UPDATE,"UPDATE");
		//studyMaterialDistributionPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTION_DELETE,"DELETE");
		studyMaterialDistributionPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTION_EXPORT,"EXPORT");
		studyMaterialDistributionPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTION_MOREACTION,"MOREACTIONS");
		studyMaterialDistributionPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTION_PRINT_DISPATCH_FORM,"PRINT_DISPATCH_FORM");
		featurePrivilegesMap.add("STUDY_MATERIAL_DISTRIBUTION_L_PRIVILEGES", studyMaterialDistributionPrivileges);
        //******************************End*********************************************************************
		//******************************Manage Voucher***************************************************
		manageVoucherPrivileges = new Ext.util.HashMap();
		manageVoucherPrivileges.add(FPCONSTANTS.PC_M6_F_VOUCHERMODE_VIEW,"VIEW");
		manageVoucherPrivileges.add(FPCONSTANTS.PC_M6_F_VOUCHERMODE_EXPORT,"EXPORT");
		manageVoucherPrivileges.add(FPCONSTANTS.PC_M6_F_VOUCHERMODE_EXPORT_TO_XML,"EXPORT_TO_XML");
		manageVoucherPrivileges.add(FPCONSTANTS.PC_M6_F_VOUCHERMODE_CHANGESTATUS,"CHANGESTATUS");
		manageVoucherPrivileges.add(FPCONSTANTS.PC_M6_F_VOUCHERMODE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		manageVoucherPrivileges.add(FPCONSTANTS.PC_M6_F_VOUCHERMODE_VERIFY_VOUCHERS,"VERIFY_VOUCHERS");
		featurePrivilegesMap.add("MANAGE_VOUCHER_PRIVILEGES", manageVoucherPrivileges);
        //******************************End*********************************************************************
		//******************************Fee Report Dashboard***************************************************
		feeReportConsolidatePrivileges = new Ext.util.HashMap();
		feeReportConsolidatePrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_CONSOLIDATE_VIEW,"VIEW");
		feeReportConsolidatePrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_CONSOLIDATE_EXPORT,"EXPORT");
		feeReportConsolidatePrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_CONSOLIDATE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FEE_REPORT_CONSOLIDATE_PRIVILEGES", feeReportConsolidatePrivileges);
        //******************************End*********************************************************************
		//******************************Fee Report Dashboard***************************************************
		feeReportCollectionPrivileges = new Ext.util.HashMap();
		feeReportCollectionPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_COLLECTION_VIEW,"VIEW");
		feeReportCollectionPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_COLLECTION_EXPORT,"EXPORT");
		feeReportCollectionPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_COLLECTION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FEE_REPORT_COLLECTION_PRIVILEGES", feeReportCollectionPrivileges);
        //******************************End*********************************************************************
		//******************************Fee Report Dashboard***************************************************
		feeReportOutstandingPrivileges = new Ext.util.HashMap();
		feeReportOutstandingPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_OUTSTANDING_VIEW,"VIEW");
		feeReportOutstandingPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_OUTSTANDING_SENDMESSAGE,"SENDMESSAGE");
		feeReportOutstandingPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_OUTSTANDING_ENTER_REMARK,"ENTER_REMARK");
		feeReportOutstandingPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_OUTSTANDING_EXPORT,"EXPORT");
		feeReportOutstandingPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_OUTSTANDING_EXPORT_REPORTS,"EXPORT_REPORTS");		
		feeReportOutstandingPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_OUTSTANDING_EXPORT_REPORTS,"EXPORT_REPORTS");
		feeReportOutstandingPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_OUTSTANDING_PRINT_CERTIFICATE,"PRINT_CERTIFICATE");
		feeReportOutstandingPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_OUTSTANDING_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FEE_REPORT_OUTSTANDING_PRIVILEGES", feeReportOutstandingPrivileges);
        //******************************End*********************************************************************
		//******************************Fee Report Dashboard***************************************************
		feeReportDiscountPrivileges = new Ext.util.HashMap();
		feeReportDiscountPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_DISCOUNT_VIEW,"VIEW");
		feeReportDiscountPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_DISCOUNT__EXPORT,"EXPORT");
		feeReportDiscountPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_DISCOUNT_GRID_CONFIGURATION,"GRID_CONFIGURATION")
		featurePrivilegesMap.add("FEE_REPORT_DISCOUNT_PRIVILEGES", feeReportDiscountPrivileges);
        //******************************End*********************************************************************
		//******************************Fee Report Dashboard***************************************************
		feeReportUserwiseCollectiontPrivileges = new Ext.util.HashMap();
		feeReportUserwiseCollectiontPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_USERWISE_COLLECTION_VIEW,"VIEW");
		feeReportUserwiseCollectiontPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_USERWISE_COLLECTION_EXPORT,"EXPORT");
		feeReportUserwiseCollectiontPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_USERWISE_COLLECTION_EXPORT_REPORTS,"EXPORT_REPORTS");
		feeReportUserwiseCollectiontPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_USERWISE_COLLECTION_GRID_CONFIG,"GRID_CONFIGURATION");		
		featurePrivilegesMap.add("FEE_REPORT_USERWISE_COLLECTION_PRIVILEGES", feeReportUserwiseCollectiontPrivileges);
        //******************************End*********************************************************************
		//******************************Fee Report Dashboard***************************************************
		programFeeReportPrivileges = new Ext.util.HashMap();
		programFeeReportPrivileges.add(FPCONSTANTS.PC_M6_F_PROGRAM_FEE_REPORT_VIEW,"VIEW");
		programFeeReportPrivileges.add(FPCONSTANTS.PC_M6_F_PROGRAM_FEE_REPORT_EXPORT,"EXPORT");
		programFeeReportPrivileges.add(FPCONSTANTS.PC_M6_F_PROGRAM_FEE_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("PROGRAM_FEE_REPORT_PRIVILEGES", programFeeReportPrivileges);
		
		courseFeeDefinationMappingPrivileges = new Ext.util.HashMap();
		courseFeeDefinationMappingPrivileges.add(FPCONSTANTS.PC_M6_F_COURSE_FEE_DEFINATION_MAPPING_VIEW,"VIEW");
		courseFeeDefinationMappingPrivileges.add(FPCONSTANTS.PC_M6_F_COURSE_FEE_DEFINATION_MAPPING_EXPORT,"EXPORT");
		courseFeeDefinationMappingPrivileges.add(FPCONSTANTS.PC_M6_F_COURSE_FEE_DEFINATION_MAPPING_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("COURSE_FEE_DEFINATION_MAPPING_PRIVILEGES", courseFeeDefinationMappingPrivileges);
		
        //******************************End*********************************************************************
		//******************************Credit Based Report Dashboard***************************************************
		creditBasedReportPrivileges = new Ext.util.HashMap();
		//creditBasedReportPrivileges.add(FPCONSTANTS.PC_M5_F_CREDIT_BASED_REPORT_VIEW,"VIEW");
		creditBasedReportPrivileges.add(FPCONSTANTS.PC_M5_F_CREDIT_BASED_REPORT_EXPORT,"EXPORT");
		creditBasedReportPrivileges.add(FPCONSTANTS.PC_M5_F_CREDIT_BASED_REPORT_EXPORTREPORTS,"EXPORTREPORTS");
		creditBasedReportPrivileges.add(FPCONSTANTS.PC_M5_F_CREDIT_BASED_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		
		featurePrivilegesMap.add("CREDIT_BASED_REPORT_PRIVILEGES", creditBasedReportPrivileges);
        //******************************End*********************************************************************
		//******************************Credit Based Report Dashboard***************************************************
		importUtilityForceRunPrivileges = new Ext.util.HashMap();
		importUtilityForceRunPrivileges.add(FPCONSTANTS.PC_M12_F_IMPORTUTILITY_FORCERUN,"FORCERUN");
		featurePrivilegesMap.add("IMPORT_UTILITY_FORCE_RUN_PRIVILEGES", importUtilityForceRunPrivileges);
        //******************************End*********************************************************************
		//******************************Survey Report ***************************************************
		surveyReportPrivileges = new Ext.util.HashMap();
		surveyReportPrivileges.add(FPCONSTANTS.PSA_M13_F_SURVEYREPORT_VIEW,"VIEW");
		surveyReportPrivileges.add(FPCONSTANTS.PSA_M13_F_SURVEYREPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("SURVEY_REPORT_PRIVILEGES", surveyReportPrivileges);
        //******************************End*********************************************************************
		
		//******************************student Report ***************************************************
		examinationMarkentryReportPrivileges = new Ext.util.HashMap();
		examinationMarkentryReportPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_VIEW,"VIEW");
		examinationMarkentryReportPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_MARK_ENTRY_REPORT_PRIVILEGES", examinationMarkentryReportPrivileges);
        //******************************End*********************************************************************
		//******************************Student Report ***************************************************
		examinationMarkentryReportByStudentPrivileges = new Ext.util.HashMap();
		//examinationMarkentryReportByStudentPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_BY_STUDENT_VIEW,"VIEW");
		examinationMarkentryReportByStudentPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_BY_STUDENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_MARK_ENTRY_REPORT_BY_STUDENT_PRIVILEGES", examinationMarkentryReportByStudentPrivileges);
        //******************************End*********************************************************************
		//******************************Event Level Report ***************************************************
		examinationEventLevelReportPrivileges = new Ext.util.HashMap();
		examinationEventLevelReportPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_EVENT_LEVEL_REPORT_VIEW,"VIEW");
		examinationEventLevelReportPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_EVENT_LEVEL_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_EVENT_LEVEL_REPORT_PRIVILEGES", examinationEventLevelReportPrivileges);
        //******************************End*********************************************************************
		//******************************faculty Report ***************************************************
		examinationMarkentryReportByFacultyPrivileges = new Ext.util.HashMap();
		//examinationMarkentryReportByFacultyPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_BY_FACULTY_VIEW,"VIEW");
		examinationMarkentryReportByFacultyPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_BY_FACULTY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_MARK_ENTRY_REPORT_BY_FACULTY_PRIVILEGES", examinationMarkentryReportByFacultyPrivileges);
        //******************************End*********************************************************************
		//******************************fee Report ***************************************************
		feeReportReciptHeadwisePrivileges = new Ext.util.HashMap();
		feeReportReciptHeadwisePrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_RECIEPT_HEADWISE_VIEW,"VIEW");
		feeReportReciptHeadwisePrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_RECIEPT_HEADWISE_EXPORT,"EXPORT");
		feeReportReciptHeadwisePrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_RECIEPT_HEADWISE_EXPORTREPORTS,"EXPORT_REPORTS");
		feeReportReciptHeadwisePrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_RECIEPT_HEADWISE_GRID_CONFIGURATION,"GRID_CONFIGURATION")
		featurePrivilegesMap.add("FEE_REPORT_RECIEPT_HEADWISE_PRIVILEGES", feeReportReciptHeadwisePrivileges);
        //******************************End*********************************************************************
		//******************************fee Report ***************************************************
		feeReportInstrumentPrivileges = new Ext.util.HashMap();
		feeReportInstrumentPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_INSTRUMENT_VIEW,"VIEW");
		feeReportInstrumentPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_INSTRUMENT_EXPORT,"EXPORT");
		feeReportInstrumentPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_INSTRUMENT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FEE_REPORT_INSTRUMENT_PRIVILEGES", feeReportInstrumentPrivileges);
        //******************************End*********************************************************************
		//******************************fee Report Applicant Consolidated ***************************************************
		feeReportApplicantConsolidatedPrivileges = new Ext.util.HashMap();
		feeReportApplicantConsolidatedPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_APPLICANT_CONSOLIDATE_VIEW,"VIEW");
		feeReportApplicantConsolidatedPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_APPLICANT_CONSOLIDATE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FEE_REPORT_APPLICANT_CONSOLIDATED_PRIVILEGES", feeReportApplicantConsolidatedPrivileges);
        //******************************End*********************************************************************
		//******************************fee Report Applicant Collection ***************************************************
		feeReportApplicantCollectionPrivileges = new Ext.util.HashMap();
		feeReportApplicantCollectionPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_APPLICANT_COLLECTION_VIEW,"VIEW");
		feeReportApplicantCollectionPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_APPLICANT_COLLECTION_EXPORT,"EXPORT");
		feeReportApplicantCollectionPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_APPLICANT_COLLECTION_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FEE_REPORT_APPLICANT_COLLECTION_PRIVILEGES", feeReportApplicantCollectionPrivileges);
        //******************************End*********************************************************************
		
		//******************************fee Report Applicant Collection ***************************************************
		feeReportApplicantOutstandingPrivileges = new Ext.util.HashMap();
		feeReportApplicantOutstandingPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_APPLICANT_OUTSTANDING_VIEW,"VIEW");
		feeReportApplicantOutstandingPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_APPLICANT_OUTSTANDING_EXPORT,"EXPORT");
		feeReportApplicantOutstandingPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_APPLICANT_OUTSTANDING_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FEE_REPORT_APPLICANT_OUTSTANDING_PRIVILEGES", feeReportApplicantOutstandingPrivileges);
        //******************************End*********************************************************************
		
		//******************************fee Report Applicant Collection ***************************************************
		feeReportApplicantDiscountPrivileges = new Ext.util.HashMap();
		feeReportApplicantDiscountPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_APPLICANT_DISCOUNT_VIEW,"VIEW");
		feeReportApplicantDiscountPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_APPLICANT_DISCOUNT_EXPORT,"EXPORT");
		feeReportApplicantDiscountPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_APPLICANT_DISCOUNT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FEE_REPORT_APPLICANT_DISCOUNT_PRIVILEGES", feeReportApplicantDiscountPrivileges);
        //******************************End*********************************************************************
		
		
		//******************************fee Report Dependent Collection ***************************************************
		feeReportDependentCollectionPrivileges = new Ext.util.HashMap();
		feeReportDependentCollectionPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_DEPENDENT_COLLECTION_VIEW,"VIEW");
		feeReportDependentCollectionPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_DEPENDENT_COLLECTION_EXPORT,"EXPORT");
		feeReportDependentCollectionPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_DEPENDENT_COLLECTION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FEE_REPORT_DEPENDENT_COLLECTION_PRIVILEGES", feeReportDependentCollectionPrivileges);
		
		//***********************Student Fee Head Wise Collection Report******************************//
		studentFeeHeadWiseCollectionReportPrivileges = new Ext.util.HashMap();
		studentFeeHeadWiseCollectionReportPrivileges.add(FPCONSTANTS.PC_M6_F_STUDENT_COLLECTION_FEE_REPORT_VIEW,"VIEW");
		studentFeeHeadWiseCollectionReportPrivileges.add(FPCONSTANTS.PC_M6_F_STUDENT_COLLECTION_FEE_REPORT_EXPORT,"EXPORT");
		studentFeeHeadWiseCollectionReportPrivileges.add(FPCONSTANTS.PC_M6_F_STUDENT_COLLECTION_FEE_REPORT_EXPORT_REPORTS,"EXPORT_REPORTS");
		studentFeeHeadWiseCollectionReportPrivileges.add(FPCONSTANTS.PC_M6_F_STUDENT_COLLECTION_FEE_REPORT_EXPORT_REPORT_PDF,"EXPORT_REPORT_PDF");
		featurePrivilegesMap.add("STUDENT_FEE_HEAD_WISE_COLLECTION_REPORT_PRIVILEGES",studentFeeHeadWiseCollectionReportPrivileges);
		
		//***********************Student Fee Head Based Collection Report******************************//
		studentFeeHeadBasedCollectionReportPrivileges = new Ext.util.HashMap();
		studentFeeHeadBasedCollectionReportPrivileges.add(FPCONSTANTS.PC_M6_F_STUDENT_BASED_COLLECTION_FEE_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_FEE_HEAD_BASED_COLLECTION_REPORT_PRIVILEGES",studentFeeHeadBasedCollectionReportPrivileges);
		
		//***********************Applicant Fee Head Wise Collection Report******************************//
		applicantFeeHeadWiseCollectionReportPrivileges = new Ext.util.HashMap();
		applicantFeeHeadWiseCollectionReportPrivileges.add(FPCONSTANTS.PC_M6_F_APPLICANT_FEE_HEAD_WISE_COLLECTION_REPORT_VIEW,"VIEW");
		applicantFeeHeadWiseCollectionReportPrivileges.add(FPCONSTANTS.PC_M6_F_APPLICANT_FEE_HEAD_WISE_COLLECTION_REPORT_EXPORT,"EXPORT");
		applicantFeeHeadWiseCollectionReportPrivileges.add(FPCONSTANTS.PC_M6_F_APPLICANT_FEE_HEAD_WISE_COLLECTION_REPORT_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICANT_FEE_HEAD_WISE_COLLECTION_REPORT_PRIVILEGES",applicantFeeHeadWiseCollectionReportPrivileges);
		
		//***********************Applicant Fee Head Based Collection Report******************************//
		applicantFeeHeadBasedeCollectionReportPrivileges = new Ext.util.HashMap();
		applicantFeeHeadBasedeCollectionReportPrivileges.add(FPCONSTANTS.PC_M6_F_APPLICANT_FEE_HEAD_BASED_COLLECTION_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPLICANT_FEE_HEAD_BASED_COLLECTION_REPORT_PRIVILEGES",applicantFeeHeadBasedeCollectionReportPrivileges);
		
		//******************************REquest Recieved ***************************************************
		courseEnrollmentRequestRecievedPrivileges = new Ext.util.HashMap();
		courseEnrollmentRequestRecievedPrivileges.add(FPCONSTANTS.PC_M4_D_COURSESENROLLMENT_REQUESTRECIEVED_EXPORT,"EXPORT");
		featurePrivilegesMap.add("COURSE_ENROLLMENT_REQUEST_RECIEVED_PRIVILEGES", courseEnrollmentRequestRecievedPrivileges);
        //******************************End*********************************************************************
		//******************************REquest Rejected ***************************************************
		courseEnrollmentRequestRejectedPrivileges = new Ext.util.HashMap();
		courseEnrollmentRequestRejectedPrivileges.add(FPCONSTANTS.PC_M4_D_COURSESENROLLMENT_REQUESTREJECTED_EXPORT,"EXPORT");
		featurePrivilegesMap.add("COURSE_ENROLLMENT_REQUEST_REJECTED_PRIVILEGES", courseEnrollmentRequestRejectedPrivileges);
        //******************************End*********************************************************************
		//******************************Currently Enrolled ***************************************************
		courseEnrollmentCurrentlyEnrolledPrivileges = new Ext.util.HashMap();
		courseEnrollmentCurrentlyEnrolledPrivileges.add(FPCONSTANTS.PC_M4_D_COURSESENROLLMENT_CURRENTLYENROLLED_EXPORT,"EXPORT");
		featurePrivilegesMap.add("COURSE_ENROLLMENT_CURRENTLY_ENROLL_PRIVILEGES", courseEnrollmentCurrentlyEnrolledPrivileges);
        //******************************End*********************************************************************
		//******************************REquest De Enroll ***************************************************
		courseEnrollmentDeEnrollPrivileges = new Ext.util.HashMap();
		courseEnrollmentDeEnrollPrivileges.add(FPCONSTANTS.PC_M4_D_COURSESENROLLMENT_DEENROLL_EXPORT,"EXPORT");
		courseEnrollmentDeEnrollPrivileges.add(FPCONSTANTS.PC_M4_D_COURSESENROLLMENT_DEENROLL_REMOVE_WITHDRAWN_STATUS,"REMOVE_WITHDRAWN_STATUS");
		featurePrivilegesMap.add("COURSE_ENROLLMENT_DE_ENROLL_PRIVILEGES", courseEnrollmentDeEnrollPrivileges);
        //******************************End*********************************************************************
		//******************************Course Parameter Courses ***************************************************
		courseParameterCoursesPrivileges = new Ext.util.HashMap();
		courseParameterCoursesPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEPARAMETER_COURSES_EXPORT,"EXPORT");
		courseParameterCoursesPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAMCOURSEPARAMETER_COURSES_DELETE,"DELETE");
		featurePrivilegesMap.add("COURSE_PARAMETER_COURSES_PRIVILEGES", courseParameterCoursesPrivileges);
        //******************************End*********************************************************************
		//******************************Examination Reports Exports Reports ***************************************************
		examinationReportExportReportsPrivileges = new Ext.util.HashMap();
		examinationReportExportReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_EXPORT_REPORT_EXPORTREPORTS,"EXPORTREPORTS");
		examinationReportExportReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_REPORT_EXPORT,"EXPORT");
		examinationReportExportReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("EXAMINATION_REPORT_EXPORT_REPORTS_PRIVILEGES", examinationReportExportReportsPrivileges);
        //******************************End*********************************************************************
		
		examinationGradeRosterReportsPrivileges = new Ext.util.HashMap();
		examinationGradeRosterReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_GRADE_ROSTER_REPORTS_EXPORT,"EXPORT");
		examinationGradeRosterReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_GRADE_ROSTER_REPORTS_GENERATE_GRADE_ROSTER_REPORT, "GENERATE_GRADE_ROSTER_REPORT");
		examinationGradeRosterReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_GRADE_ROSTER_REPORTS_GENERATE_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("EXAMINATION_GRADE_ROSTER_REPORT_PRIVILEGES", examinationGradeRosterReportsPrivileges);
		//******************************Hostel module**************************************************
		
		//****************************** Manage Room Type Hostel module**************************************************
		
		hostelManageRoomTypePrivileges = new Ext.util.HashMap();
		hostelManageRoomTypePrivileges.add(FPCONSTANTS.PC_M14_MANAGE_ROOM_TYPE_VIEW,"VIEW");
		hostelManageRoomTypePrivileges.add(FPCONSTANTS.PC_M14_MANAGE_ROOM_TYPE_EXPORT,"EXPORT");
		hostelManageRoomTypePrivileges.add(FPCONSTANTS.PC_M14_MANAGE_ROOM_TYPE_CREATE,"CREATE");
		hostelManageRoomTypePrivileges.add(FPCONSTANTS.PC_M14_MANAGE_ROOM_TYPE_UPDATE,"UPDATE");
		hostelManageRoomTypePrivileges.add(FPCONSTANTS.PC_M14_MANAGE_ROOM_TYPE_DELETE,"DELETE");
		featurePrivilegesMap.add("HOSTEL_MANAGE_ROOM_TYPE_PRIVILEGES", hostelManageRoomTypePrivileges);
		
		//******************************Manage Restriction Hostel module**************************************************
		
		hostelManageRestrictionTypePrivileges = new Ext.util.HashMap();
		hostelManageRestrictionTypePrivileges.add(FPCONSTANTS.PC_M14_MANAGE_RESTRICTION_TYPE_VIEW,"VIEW");
		hostelManageRestrictionTypePrivileges.add(FPCONSTANTS.PC_M14_MANAGE_RESTRICTION_TYPE_EXPORT,"EXPORT");
		hostelManageRestrictionTypePrivileges.add(FPCONSTANTS.PC_M14_MANAGE_RESTRICTION_TYPE_CREATE,"CREATE");
		hostelManageRestrictionTypePrivileges.add(FPCONSTANTS.PC_M14_MANAGE_RESTRICTION_TYPE_UPDATE,"UPDATE");
		hostelManageRestrictionTypePrivileges.add(FPCONSTANTS.PC_M14_MANAGE_RESTRICTION_TYPE_DELETE,"DELETE");
		featurePrivilegesMap.add("HOSTEL_MANAGE_RESTRICTION_TYPE_PRIVILEGES", hostelManageRestrictionTypePrivileges);
		
		//******************************Manage Hostel Hostel module**************************************************
		
		hostelManageHostelPrivileges = new Ext.util.HashMap();
		hostelManageHostelPrivileges.add(FPCONSTANTS.PC_M14_MANAGE_HOSTEL_VIEW,"VIEW");
		hostelManageHostelPrivileges.add(FPCONSTANTS.PC_M14_MANAGE_HOSTEL_EXPORT,"EXPORT");
		/*hostelManageHostelPrivileges.add(FPCONSTANTS.PC_M14_MANAGE_HOSTEL_CREATE,"CREATE");*/
		hostelManageHostelPrivileges.add(FPCONSTANTS.PC_M14_MANAGE_HOSTEL_UPDATE,"UPDATE");
		/*hostelManageHostelPrivileges.add(FPCONSTANTS.PC_M14_MANAGE_HOSTEL_DELETE,"DELETE");*/
		hostelManageHostelPrivileges.add(FPCONSTANTS.PC_M14_MANAGE_HOSTEL_IMPORT_BULK_HOSTEL_BED,"IMPORT_BULK_HOSTEL_BED");
		hostelManageHostelPrivileges.add(FPCONSTANTS.PC_M14_MANAGE_HOSTEL_MANAGE_CAPACITY,"MANAGE_CAPACITY");
		featurePrivilegesMap.add("HOSTEL_MANAGE_HOSTEL_PRIVILEGES", hostelManageHostelPrivileges);
		
		//******************************Hostel Application module**************************************************
		
		hostelApplicationPrivileges = new Ext.util.HashMap();
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_VIEW,"VIEW");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_EXPORT,"EXPORT");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_ALLOTEROOM,"ALLOTEROOM");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_APPLY_RULE,"APPLY_RULE");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_REJECTAPPLICATION,"REJECTAPPLICATION");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_MOREACTIONS,"MOREACTIONS");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_SEND_OFFER_LETTER,"SEND_OFFER_LETTER");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_REVOKE_OFFER_LETTER,"REVOKE_OFFER_LETTER");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_PRINT_OFFER_LETTER,"PRINT_OFFER_LETTER");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_ASSIGN_OFFER_LETTER,"ASSIGN_OFFER_LETTER");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_ASSIGN_OFFER_EXPIRY_DATE,"ASSIGN_OFFER_EXPIRY_DATE");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_BULK_RESIDENCE_APPLICATION_STATUS_UPDATE,"BULK_RESIDENCE_APPLICATION_STATUS_UPDATE");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_BULK_HOSTEL_ALLOCATION,"BULK_HOSTEL_ALLOCATION");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_ACCEPT_OFFER,"ACCEPT_OFFER");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_ALLOCATED_RESIDENCE,"ALLOCATED_RESIDENCE");
		hostelApplicationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_CANCEL_RESIDENCE_ALLOCATION,"CANCEL_RESIDENCE_ALLOCATION");
		featurePrivilegesMap.add("HOSTEL_APPLICATION_PRIVILEGES", hostelApplicationPrivileges);
		
		
		hostelApplicationForApplicantsGridPrivileges = new Ext.util.HashMap();
		hostelApplicationForApplicantsGridPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_FOR_APPLICANTS_GRID_EXPORT,"EXPORT");
		hostelApplicationForApplicantsGridPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_FOR_APPLICANTS_GRID_ALLOTEROOM,"ALLOTEROOM");
		hostelApplicationForApplicantsGridPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_FOR_APPLICANTS_GRID_APPLY_RULE,"APPLY_RULE");
		hostelApplicationForApplicantsGridPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_FOR_APPLICANTS_GRID_REJECTAPPLICATION,"REJECTAPPLICATION");
		hostelApplicationForApplicantsGridPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_FOR_APPLICANTS_GRID_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		hostelApplicationForApplicantsGridPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_FOR_APPLICANTS_MOREACTIONS,"MOREACTIONS");
		hostelApplicationForApplicantsGridPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_FOR_APPLICANTS_SEND_OFFER_LETTER,"SEND_OFFER_LETTER");
		hostelApplicationForApplicantsGridPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_FOR_APPLICANTS_REVOKE_OFFER_LETTER,"REVOKE_OFFER_LETTER");
		hostelApplicationForApplicantsGridPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_FOR_APPLICANTS_PRINT_OFFER_LETTER,"PRINT_OFFER_LETTER");
		hostelApplicationForApplicantsGridPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_FOR_APPLICANTS_ASSIGN_OFFER_LETTER,"ASSIGN_OFFER_LETTER");
		hostelApplicationForApplicantsGridPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_APPLICATIONS_FOR_APPLICANTS_ASSIGN_OFFER_EXPIRY_DATE,"ASSIGN_OFFER_EXPIRY_DATE");		
		featurePrivilegesMap.add("HOSTEL_APPLICATION_APPLICANT_GRID_PRIVILEGES", hostelApplicationForApplicantsGridPrivileges);
		
		residenceApplicationsGridPrivileges = new Ext.util.HashMap();
		residenceApplicationsGridPrivileges.add(FPCONSTANTS.PC_M14_RESIDENCE_APPLICATIONS_GRID_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		residenceApplicationsGridPrivileges.add(FPCONSTANTS.PC_M14_RESIDENCE_APPLICATIONS_GRID_EXPORT,"EXPORT");
		featurePrivilegesMap.add("RESIDENCE_APPLICATIONS_GRID_PRIVILEGES", residenceApplicationsGridPrivileges);
		//******************************Room Allocation Hostel module**************************************************
		
		hostelRoomAllocationPrivileges = new Ext.util.HashMap();
		hostelRoomAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_ROOM_ALLOCATION_VIEW,"VIEW");
		hostelRoomAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_ROOM_ALLOCATION_EXPORT,"EXPORT");
		hostelRoomAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_ROOM_ALLOCATION_ALLOTEROOM,"ALLOTEROOM");
		hostelRoomAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_ROOM_ALLOCATION_IMPORT_HOSTEL_ROOM_ALLOCATION,"IMPORT_HOSTEL_ROOM_ALLOCATION");
		hostelRoomAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_ROOM_ALLOCATION_IMPORT_HOSTEL_ROOM_ALLOTMENT,"IMPORT_HOSTEL_ROOM_ALLOTMENT");
		featurePrivilegesMap.add("HOSTEL_ROOM_ALLOCATION_PRIVILEGES", hostelRoomAllocationPrivileges);
		
		//******************************Manage Allocation Hostel module**************************************************
		
		hostelManageAllocationPrivileges = new Ext.util.HashMap();
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_VIEW,"VIEW");
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_EXPORT,"EXPORT");
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_CANCELALLOTEMENT,"CANCELALLOTEMENT");
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_CHECKIN,"CHECKIN");
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_CHECKOUT,"CHECKOUT");
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_SENDMESSAGE,"SENDMESSAGE");
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_IMPORT_BULK_HOSTEL_CHECKIN,"IMPORT_BULK_HOSTEL_CHECK-IN");
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_SENDMESSAGE_ADHOC_MESSAGE,"ADHOC_MESSAGE");
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_SENDMESSAGE_MESSAGE_TEMPLATE,"MESSAGE_TEMPLATE");
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_MANAGE_DOCUMENT,"MANAGE_DOCUMENT");
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_IMPORT_BULK_HOSTEL_CHECKOUT,"IMPORT_BULK_HOSTEL_CHECK-OUT");
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_GENERATE_EMAIL,"GENERATE_EMAIL");
		hostelManageAllocationPrivileges.add(FPCONSTANTS.PC_M14_HOSTEL_MANAGE_ALLOCATION_CANCELCHECKIN,"CANCELCHECKIN");
		featurePrivilegesMap.add("HOSTEL_MANAGE_ALLOCATION_PRIVILEGES", hostelManageAllocationPrivileges);
		
		//******************************Core ERP Loader Permission**************************************************
		
		coreERPLoaderPrivileges = new Ext.util.HashMap();
		coreERPLoaderPrivileges.add(FPCONSTANTS.PC_M14_L_UPLOADER_VIEW_VIEW,"VIEW");
		coreERPLoaderPrivileges.add(FPCONSTANTS.PC_M14_L_UPLOADER_VIEW_EVENT_MARK_ENTRY,"EVENT_MARK_ENTRY");
		coreERPLoaderPrivileges.add(FPCONSTANTS.PC_M14_L_UPLOADER_VIEW_QUESTION_MARK_ENTRY,"QUESTION_MARK_ENTRY");
		featurePrivilegesMap.add("CORE_ERP_LOADER_PRIVILEGES", coreERPLoaderPrivileges);
		
		//******************************Core ERP Notification Bell Icon Permission**************************************************
		
		coreERPNotificationBellIconPrivileges = new Ext.util.HashMap();
		coreERPNotificationBellIconPrivileges.add(FPCONSTANTS.PC_M14_L_NOTIFICATION_BELL_ICON_VIEW,"VIEW");
		featurePrivilegesMap.add("CORE_ERP_NOTIFICATION_BELL_ICON_PRIVILEGES", coreERPNotificationBellIconPrivileges);
		
		//******************************Core ERP AI ChatBot Permission**************************************************
		
		coreERPAIChatBotPrivileges = new Ext.util.HashMap();
		coreERPAIChatBotPrivileges.add(FPCONSTANTS.PC_M14_L_AI_CHAT_BOT_VIEW,"VIEW");
		coreERPAIChatBotPrivileges.add(FPCONSTANTS.PC_M14_L_AI_CHAT_BOT_REDIRECT_VIEW,"AI_CHATBOT_ICON");
		featurePrivilegesMap.add("CORE_ERP_AI_CHATBOT_PRIVILEGES", coreERPAIChatBotPrivileges);
		
		//******************************Core ERP Notification History Icon Permission**************************************************
		
		coreERPNotificationHistoryIconPrivileges = new Ext.util.HashMap();
		coreERPNotificationHistoryIconPrivileges.add(FPCONSTANTS.PC_M14_L_NOTIFICATION_HISTORY_ICON_VIEW,"VIEW");
		featurePrivilegesMap.add("CORE_ERP_NOTIFICATION_HISTORY_ICON_PRIVILEGES", coreERPNotificationHistoryIconPrivileges);
		
		//******************************Hostel Dashboard **************************************************
		hostelDashboardPrivileges = new Ext.util.HashMap();
		hostelDashboardPrivileges.add(FPCONSTANTS.PC_M14_D_DASHBOARD_VIEW,"VIEW");
		hostelDashboardPrivileges.add(FPCONSTANTS.PC_M14_D_DASHBOARD_EXPORT,"EXPORT");
		featurePrivilegesMap.add("HOSTEL_DASHBOARD_PRIVILEGES", hostelDashboardPrivileges);
		
		//******************************Hostel Report **************************************************
		roomAvailabilityReportPrivileges = new Ext.util.HashMap();
		roomAvailabilityReportPrivileges.add(FPCONSTANTS.PC_M14_R_ROOM_AVAILABILITY_VIEW,"VIEW");
		roomAvailabilityReportPrivileges.add(FPCONSTANTS.PC_M14_R_ROOM_AVAILABILITY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("ROOM_AVAILABILITY_REPORT_PRIVILEGES", roomAvailabilityReportPrivileges);
		
		roomOccupancyReportPrivileges = new Ext.util.HashMap();
		roomOccupancyReportPrivileges.add(FPCONSTANTS.PC_M14_R_ROOM_OCCUPANCY_VIEW,"VIEW");
		roomOccupancyReportPrivileges.add(FPCONSTANTS.PC_M14_R_ROOM_OCCUPANCY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("ROOM_OCCUPANCY_REPORT_PRIVILEGES", roomOccupancyReportPrivileges);
		
		hostelFeeReportPrivileges = new Ext.util.HashMap();
		hostelFeeReportPrivileges.add(FPCONSTANTS.PC_M14_R_HOSTEL_FEE_REPORT_VIEW,"VIEW");
		hostelFeeReportPrivileges.add(FPCONSTANTS.PC_M14_R_HOSTEL_FEE_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("HOSTEL_FEE_REPORT_PRIVILEGES", hostelFeeReportPrivileges);
		
		hostelDetailReportPrivileges = new Ext.util.HashMap();
		hostelDetailReportPrivileges.add(FPCONSTANTS.PC_M14_R_HOSTEL_DETAIL_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap .add("HOSTEL_DETAIL_REPORT_PRIVILEGES",hostelDetailReportPrivileges)
		
		
		hostelAttendanceReportPrivileges = new Ext.util.HashMap();
		hostelAttendanceReportPrivileges.add(FPCONSTANTS.PC_M14_R_CAPTURE_HOSTEL_ATTENDANCE_VIEW,"VIEW");
		featurePrivilegesMap.add("CAPTURE_HOSTEL_ATTENDANCE_PRIVILEGES", hostelAttendanceReportPrivileges);
		
		hostelAttendancePrivileges = new Ext.util.HashMap();
		hostelAttendancePrivileges.add(FPCONSTANTS.PC_M14_R_HOSTEL_ATTENDANCE_REPORT_VIEW,"VIEW");
		hostelAttendancePrivileges.add(FPCONSTANTS.PC_M14_R_HOSTEL_ATTENDANCE_REPORT_EXPORT_REPORTS, "EXPORTREPORTS");
		//hostelAttendancePrivileges.add(FPCONSTANTS.PC_M14_R_CAPTURE_HOSTEL_ATTENDANCE_CREATE,"CREATE");
		hostelAttendancePrivileges.add(FPCONSTANTS.PC_M14_R_HOSTEL_ATTENDANCE_REPORT_UPDATE_ATTENDANCE, "UpdateAttendance");
		hostelAttendancePrivileges.add(FPCONSTANTS.PC_M14_R_HOSTEL_ATTENDANCE_REPORT_CHECKOUT_OCCUPANT, "CHECKOUT_OCCUPANT");

		
		featurePrivilegesMap.add("HOSTEL_ATTENDANCE_PRIVILEGES", hostelAttendancePrivileges);
		
		/***** Leave management module **********/
		
		newLeaveTypePrivileges = new Ext.util.HashMap();
		newLeaveTypePrivileges.add(FPCONSTANTS.PF_M8_R_NEW_LEAVE_TYPE_VIEW,"VIEW");
		featurePrivilegesMap.add("NEW_LEAVE_TYPE_PRIVILEGES", newLeaveTypePrivileges);
		
		leaveSettingsPrivileges = new Ext.util.HashMap();
		leaveSettingsPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_SETTINGS_VIEW,"VIEW");
		featurePrivilegesMap.add("LEAVE_SETTINGS_PRIVILEGES", leaveSettingsPrivileges);
		
		leaveAdministrationSettingsPrivileges = new Ext.util.HashMap();
		leaveAdministrationSettingsPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_ADMINISTRATION_SETTINGS_VIEW,"VIEW");
		featurePrivilegesMap.add("LEAVE_ADMINISTRATION_SETTINGS_PRIVILEGES", leaveAdministrationSettingsPrivileges);
		
		leaveSanctioningSettingsPrivileges = new Ext.util.HashMap();
		leaveSanctioningSettingsPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_SANCTIONING_SETTINGS_VIEW,"VIEW");
		featurePrivilegesMap.add("LEAVE_SANCTIONING_SETTINGS_PRIVILEGES", leaveSanctioningSettingsPrivileges);
		
		toolsEventCalenderPrivileges = new Ext.util.HashMap();
		toolsEventCalenderPrivileges.add(FPCONSTANTS.TS_TOOLS_EVENT_CALENDAR_VIEW,"VIEW");
		toolsEventCalenderPrivileges.add(FPCONSTANTS.TS_TOOLS_EVENT_CALENDAR_EXPORT,"EXPORT");
		toolsEventCalenderPrivileges.add(FPCONSTANTS.TS_TOOLS_EVENT_CALENDAR_CREATE,"CREATE");
		toolsEventCalenderPrivileges.add(FPCONSTANTS.TS_TOOLS_EVENT_CALENDAR_UPDATE,"UPDATE");
		toolsEventCalenderPrivileges.add(FPCONSTANTS.TS_TOOLS_EVENT_CALENDAR_DELETE,"DELETE");
		toolsEventCalenderPrivileges.add(FPCONSTANTS.TS_TOOLS_EVENT_CALENDAR_VIEWCALENDAR,"VIEWCALENDAR");
		featurePrivilegesMap.add("TOOLS_EVENT_CALENDER_PRIVILEGES", toolsEventCalenderPrivileges);
		
		examDocumentsPrivileges = new Ext.util.HashMap();
		examDocumentsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_DOCUMENTS_VIEW,"VIEW");
		examDocumentsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_DOCUMENTS_EXPORT,"EXPORT");
		examDocumentsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_DOCUMENTS_CREATE,"CREATE");
		examDocumentsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_DOCUMENTS_UPDATE,"UPDATE");
		examDocumentsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_DOCUMENTS_DELETE,"DELETE");
		featurePrivilegesMap.add("EXAMINATION_EXAM_DOCUMENTS_PRIVILEGES", examDocumentsPrivileges);
		
		studentOtherInformationPrivileges = new Ext.util.HashMap();
		studentOtherInformationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_OTHER_INFORMATION_VIEW,"VIEW");
		studentOtherInformationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_OTHER_INFORMATION_SAVE,"SAVE");
		featurePrivilegesMap.add("STUDENT_OTHER_INFORMATION_PRIVILEGES", studentOtherInformationPrivileges);
		
		facultyOtherInformationPrivileges = new Ext.util.HashMap();
		facultyOtherInformationPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_OTHER_INFORMATION_VIEW,"VIEW");
		facultyOtherInformationPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_OTHER_INFORMATION_SAVE,"SAVE");
		featurePrivilegesMap.add("FACULTY_OTHER_INFORMATION_PRIVILEGES", facultyOtherInformationPrivileges);
		
		facultyPortalOtherInformationPrivileges = new Ext.util.HashMap();
		facultyPortalOtherInformationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_OTHER_INFORMATION_VIEW,"VIEW");
		facultyPortalOtherInformationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_OTHER_INFORMATION_SAVE,"SAVE");
		featurePrivilegesMap.add("FACULTY_PORTAL_OTHER_INFORMATION_PRIVILEGES", facultyPortalOtherInformationPrivileges);
		
		studentSSODetailsPrivileges = new Ext.util.HashMap();
		studentSSODetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SSO_DETAILS_VIEW,"VIEW");
		studentSSODetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SSO_DETAILS_CREATE,"CREATE");
		studentSSODetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SSO_DETAILS_DELETE,"DELETE");
		studentSSODetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_SSO_DETAILS_SAVE,"SAVE");
		featurePrivilegesMap.add("STUDENT_SSO_DETAILS_PRIVILEGES", studentSSODetailsPrivileges);
		
		studentBankDetailsPrivileges = new Ext.util.HashMap();
		studentBankDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_BANK_DETAILS_VIEW,"VIEW");
		studentBankDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_BANK_DETAILS_CREATE,"CREATE");
		studentBankDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_BANK_DETAILS_UPDATE,"UPDATE");
		studentBankDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_BANK_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("STUDENT_BANK_DETAILS_PRIVILEGES", studentBankDetailsPrivileges); 
		
		studentPortalSSODetailsPrivileges = new Ext.util.HashMap();
		studentPortalSSODetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SSO_DETAILS_VIEW,"VIEW");
		studentPortalSSODetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SSO_DETAILS_CREATE,"CREATE");
		studentPortalSSODetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SSO_DETAILS_DELETE,"DELETE");
		studentPortalSSODetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SSO_DETAILS_SAVE,"SAVE");
		featurePrivilegesMap.add("STUDENT_PORTAL_SSO_DETAILS_PRIVILEGES", studentPortalSSODetailsPrivileges);
		
		studentPortalStudentJourneyPrivileges = new Ext.util.HashMap();
		studentPortalStudentJourneyPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_JOURNEY_VIEW,"VIEW");
		studentPortalStudentJourneyPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_JOURNEY_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_JOURNEY_PRIVILEGES", studentPortalStudentJourneyPrivileges);

		studentPortalPassportDetail = new Ext.util.HashMap();
		studentPortalPassportDetail.add(FPCONSTANTS.SP_M9_F_STUDENT_PASSPORT_VIEW,"VIEW");
		studentPortalPassportDetail.add(FPCONSTANTS.SP_M9_F_STUDENT_PASSPORT_CREATE,"CREATE");
		studentPortalPassportDetail.add(FPCONSTANTS.SP_M9_F_STUDENT_PASSPORT_UPDATE,"UPDATE");
		studentPortalPassportDetail.add(FPCONSTANTS.SP_M9_F_STUDENT_PASSPORT_DELETE,"DELETE");
		studentPortalPassportDetail.add(FPCONSTANTS.SP_M9_F_STUDENT_PASSPORT_EXPORT,"EXPORT");
		studentPortalPassportDetail.add(FPCONSTANTS.SP_M9_F_STUDENT_PASSPORT_GRID,"GRID");
		featurePrivilegesMap.add("STUDENT_PORTAL_PASSPORT_PREVILEGES",studentPortalPassportDetail); 
		
		
		facultySSODetailsPrivileges = new Ext.util.HashMap();
		facultySSODetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_SSO_DETAILS_VIEW,"VIEW");
		facultySSODetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_SSO_DETAILS_CREATE,"CREATE");
		facultySSODetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_SSO_DETAILS_DELETE,"DELETE");
		facultySSODetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_SSO_DETAILS_SAVE,"SAVE");
		featurePrivilegesMap.add("FACULTY_SSO_DETAILS_PRIVILEGES", facultySSODetailsPrivileges);
		
		facultyEADetailsPrivileges = new Ext.util.HashMap();
		facultyEADetailsPrivileges.add(FPCONSTANTS.PS_M9_F_FACULTY_EMP_ADDITIONAL_DETAILS_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_EMP_ADDITIONAL_DETAILS_PRIVILEGES", facultyEADetailsPrivileges);

		 
		facultyPortalSSODetailsPrivileges = new Ext.util.HashMap();
		facultyPortalSSODetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SSO_DETAILS_VIEW,"VIEW");
		facultyPortalSSODetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SSO_DETAILS_CREATE,"CREATE");
		facultyPortalSSODetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SSO_DETAILS_DELETE,"DELETE");
		facultyPortalSSODetailsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SSO_DETAILS_SAVE,"SAVE");
		featurePrivilegesMap.add("FACULTY_PORTAL_SSO_DETAILS_PRIVILEGES", facultyPortalSSODetailsPrivileges);
		
		facultyPortalPassportDetail = new Ext.util.HashMap();
		facultyPortalPassportDetail.add(FPCONSTANTS.FP_M9_F_PASSPORT_VIEW,"VIEW");
		facultyPortalPassportDetail.add(FPCONSTANTS.FP_M9_F_PASSPORT_CREATE,"CREATE");
		facultyPortalPassportDetail.add(FPCONSTANTS.FP_M9_F_PASSPORT_UPDATE,"UPDATE");
		facultyPortalPassportDetail.add(FPCONSTANTS.FP_M9_F_PASSPORT_DELETE,"DELETE");
		facultyPortalPassportDetail.add(FPCONSTANTS.FP_M9_F_PASSPORT_EXPORT,"EXPORT");
		facultyPortalPassportDetail.add(FPCONSTANTS.FP_M9_F_PASSPORT_GRID,"GRID");
		featurePrivilegesMap.add("FACULTY_PORTAL_PASSPORT_DETAIL_PRIVILEGES", facultyPortalPassportDetail);
		
		studentPortalEducationHistoryDetail = new Ext.util.HashMap();
		studentPortalEducationHistoryDetail.add(FPCONSTANTS.SP_M9_F_STUDENT_EDUCATION_HISTORY_VIEW,"VIEW");
		studentPortalEducationHistoryDetail.add(FPCONSTANTS.SP_M9_F_STUDENT_EDUCATION_HISTORY_CREATE,"CREATE");
		studentPortalEducationHistoryDetail.add(FPCONSTANTS.SP_M9_F_STUDENT_EDUCATION_HISTORY_UPDATE,"UPDATE");
		studentPortalEducationHistoryDetail.add(FPCONSTANTS.SP_M9_F_STUDENT_EDUCATION_HISTORY_DELETE,"DELETE");
		studentPortalEducationHistoryDetail.add(FPCONSTANTS.SP_M9_F_STUDENT_EDUCATION_HISTORY_EXPORT,"EXPORT");
		studentPortalEducationHistoryDetail.add(FPCONSTANTS.SP_M9_F_STUDENT_EDUCATION_HISTORY_GRID,"GRID");
		featurePrivilegesMap.add("STUDENT_PORTAL_EDUCATION_HISTORY_PREVILEGES",studentPortalEducationHistoryDetail);
		
		
		parentPortalEducationHistory = new Ext.util.HashMap();
		parentPortalEducationHistory.add(FPCONSTANTS.PP_M2_F_PARENT_PORTAL_EDUCATION_HISTORY_VIEW,"VIEW");
		parentPortalEducationHistory.add(FPCONSTANTS.PP_M2_F_PARENT_PORTAL_EDUCATION_HISTORY_CREATE,"CREATE");
		parentPortalEducationHistory.add(FPCONSTANTS.PP_M2_F_PARENT_PORTAL_EDUCATION_HISTORY_UPDATE,"UPDATE");
		parentPortalEducationHistory.add(FPCONSTANTS.PP_M2_F_PARENT_PORTAL_EDUCATION_HISTORY_DELETE,"DELETE");
		parentPortalEducationHistory.add(FPCONSTANTS.PP_M2_F_PARENT_PORTAL_EDUCATION_HISTORY_EXPORT,"EXPORT");
		parentPortalEducationHistory.add(FPCONSTANTS.SP_M9_F_STUDENT_INSURANCE_DETAILS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("PARENT_PORTAL_EDUCATION_HISTORY_PRIVILEGES",parentPortalEducationHistory);
		
		facultyPortalEducationHistory = new Ext.util.HashMap();
		facultyPortalEducationHistory.add(FPCONSTANTS.FP_M2_F_STUDENT_FACULTY_EDUCATION_HISTORY_VIEW,"VIEW");
		facultyPortalEducationHistory.add(FPCONSTANTS.FP_M2_F_STUDENT_FACULTY_EDUCATION_HISTORY_CREATE,"CREATE");
		facultyPortalEducationHistory.add(FPCONSTANTS.FP_M2_F_STUDENT_FACULTY_EDUCATION_HISTORY_UPDATE,"UPDATE");
		facultyPortalEducationHistory.add(FPCONSTANTS.FP_M2_F_STUDENT_FACULTY_EDUCATION_HISTORY_DELETE,"DELETE");
		facultyPortalEducationHistory.add(FPCONSTANTS.FP_M2_F_STUDENT_FACULTY_EDUCATION_HISTORY_EXPORT,"EXPORT");
		facultyPortalEducationHistory.add(FPCONSTANTS.FP_M2_F_STUDENT_FACULTY_EDUCATION_HISTORY_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_PORTAL_EDUCATION_HISTORY_PRIVILEGES",facultyPortalEducationHistory);
		
		
		facultyPortalStudentProfileSSODetailsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentProfileSSODetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SSO_DETAILS_VIEW,"VIEW");
		facultyPortalStudentProfileSSODetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SSO_DETAILS_CREATE,"CREATE");
		facultyPortalStudentProfileSSODetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SSO_DETAILS_DELETE,"DELETE");
		facultyPortalStudentProfileSSODetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SSO_DETAILS_SAVE,"SAVE");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_PROFILE_SSO_DETAILS_PRIVILEGES", facultyPortalStudentProfileSSODetailsPrivileges);
		
		parentPortalSSODetailsPrivileges = new Ext.util.HashMap();
		parentPortalSSODetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SSO_DETAILS_VIEW,"VIEW");
		parentPortalSSODetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SSO_DETAILS_CREATE,"CREATE");
		parentPortalSSODetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SSO_DETAILS_DELETE,"DELETE");
		parentPortalSSODetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SSO_DETAILS_SAVE,"SAVE");
		parentPortalSSODetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_JOURNEY_VIEW,"VIEW");
		featurePrivilegesMap.add("PARENT_PORTAL_SSO_DETAILS_PRIVILEGES", parentPortalSSODetailsPrivileges);
		
		parentPortalFlagDetailsPrivileges = new Ext.util.HashMap();
		parentPortalFlagDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_FLAG_DETAILS_VIEW,"VIEW");
		parentPortalFlagDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_FLAG_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_FLAG_DETAILS_PRIVILEGES", parentPortalFlagDetailsPrivileges);
		
		parentPortalPassportDetailsPrivileges = new Ext.util.HashMap();
		parentPortalPassportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PASSPORT_VIEW,"VIEW");
		parentPortalPassportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PASSPORT_CREATE,"CREATE");
		parentPortalPassportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PASSPORT_UPDATE,"UPDATE");
		parentPortalPassportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PASSPORT_DELETE,"DELETE");
		parentPortalPassportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PASSPORT_EXPORT,"EXPORT");
		parentPortalPassportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PASSPORT_GRID,"GRID");
		featurePrivilegesMap.add("PARENT_PORTAL_PASSPORT_PREVILEGES",parentPortalPassportDetailsPrivileges);
		
		parentPortalPassportDetailsPrivileges = new Ext.util.HashMap();
		parentPortalPassportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PASSPORT_VIEW,"VIEW");
		parentPortalPassportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PASSPORT_CREATE,"CREATE");
		parentPortalPassportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PASSPORT_UPDATE,"UPDATE");
		parentPortalPassportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PASSPORT_DELETE,"DELETE");
		parentPortalPassportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PASSPORT_EXPORT,"EXPORT");
		parentPortalPassportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PASSPORT_GRID,"GRID");
		featurePrivilegesMap.add("PARENT_PORTAL_PASSPORT_PREVILEGES",parentPortalPassportDetailsPrivileges);
		
		
		studentParentSSODetailsPrivileges = new Ext.util.HashMap();
		studentParentSSODetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PARENTS_GUARDIANS_SSO_DETAILS_CREATE,"CREATE");
		studentParentSSODetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PARENTS_GUARDIANS_SSO_DETAILS_DELETE,"DELETE");
		studentParentSSODetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PARENTS_GUARDIANS_SSO_DETAILS_SAVE,"SAVE");
		featurePrivilegesMap.add("STUDENT_PARENT_SSO_DETAILS_PRIVILEGES", studentParentSSODetailsPrivileges);
		
		facultyPortalStudentProfileParentSSODetailsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentProfileParentSSODetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PARENTS_GUARDIANS_SSO_DETAILS_CREATE,"CREATE");
		facultyPortalStudentProfileParentSSODetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PARENTS_GUARDIANS_SSO_DETAILS_DELETE,"DELETE");
		facultyPortalStudentProfileParentSSODetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PARENTS_GUARDIANS_SSO_DETAILS_SAVE,"SAVE");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_PROFILE_PARENT_SSO_DETAILS_PRIVILEGES", facultyPortalStudentProfileParentSSODetailsPrivileges);
		
		examQuestionPaperBankPrivileges = new Ext.util.HashMap();
		examQuestionPaperBankPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_PAPER_BANK_VIEW,"VIEW");
		examQuestionPaperBankPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_PAPER_BANK_EXPORT,"EXPORT");
		examQuestionPaperBankPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_PAPER_BANK_CREATE,"CREATE");
		examQuestionPaperBankPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_PAPER_BANK_UPDATE,"UPDATE");
		examQuestionPaperBankPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_PAPER_BANK_DELETE,"DELETE");
		examQuestionPaperBankPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_PAPER_BANK_SAVE,"SAVE");
		examQuestionPaperBankPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_PAPER_BANK_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("EXAM_QUESTION_PAPER_BANK_PRIVILEGES", examQuestionPaperBankPrivileges);
		
		
		placementTypePrivileges = new Ext.util.HashMap();
		placementTypePrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_TYPE_VIEW,"VIEW");
		placementTypePrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_TYPE_CREATE,"CREATE");
		placementTypePrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_TYPE_UPDATE,"UPDATE");
		placementTypePrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_TYPE_DELETE,"DELETE");
		placementTypePrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_TYPE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PLACEMENT_TYPE_PRIVILEGES", placementTypePrivileges);
		
		placementCampusPrivileges = new Ext.util.HashMap();
		placementCampusPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_CAMPUS_VIEW,"VIEW");
		placementCampusPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_CAMPUS_CREATE,"CREATE");
		placementCampusPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_CAMPUS_UPDATE,"UPDATE");
		placementCampusPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_CAMPUS_DELETE,"DELETE");
		placementCampusPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_CAMPUS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PLACEMENT_CAMPUS_PRIVILEGES", placementCampusPrivileges);
		
		placementJobPostingPrivileges = new Ext.util.HashMap();
		placementJobPostingPrivileges.add(FPCONSTANTS.PC_M8_D_JOB_POSTING_VIEW,"VIEW");
		placementJobPostingPrivileges.add(FPCONSTANTS.PC_M8_D_JOB_POSTING_CREATE,"CREATE");
		placementJobPostingPrivileges.add(FPCONSTANTS.PC_M8_D_JOB_POSTING_UPDATE,"UPDATE");
		placementJobPostingPrivileges.add(FPCONSTANTS.PC_M8_D_JOB_POSTING_DELETE,"DELETE");
		placementJobPostingPrivileges.add(FPCONSTANTS.PC_M8_D_JOB_POSTING_EXPORT,"EXPORT");
		placementJobPostingPrivileges.add(FPCONSTANTS.PC_M8_D_JOB_POSTING_JOBLOCATIONS,"JOBLOCATIONS");
		placementJobPostingPrivileges.add(FPCONSTANTS.PC_M8_D_JOB_POSTING_GENERATE_JOB_DESC,"GENERATE_JOB_DESC");
		featurePrivilegesMap.add("PLACEMENT_JOB_POSTING_PRIVILEGES", placementJobPostingPrivileges);
		
		placementJobApplicationPrivileges = new Ext.util.HashMap();
		placementJobApplicationPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_JOB_APPLICATION_VIEW,"VIEW");
		placementJobApplicationPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_JOB_APPLICATION_ADDAPPLICATION,"ADDAPPLICATION");
		placementJobApplicationPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_JOB_APPLICATION_SENDOFFERLETTER,"SENDOFFERLETTER");
		placementJobApplicationPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_JOB_APPLICATION_UPDATEOFFERSTATUS,"UPDATEOFFERSTATUS");
		placementJobApplicationPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_JOB_APPLICATION_UPDATEJOININGSTATUS,"UPDATEJOININGSTATUS");
		placementJobApplicationPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_JOB_APPLICATION_UPLOADRESUME,"UPLOADRESUME");
		placementJobApplicationPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_JOB_APPLICATION_EXPORT,"EXPORT");
		placementJobApplicationPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_JOB_APPLICATION_SEND_MESSAGE_ADHOC_MESSAGE,"ADHOC_MESSAGE");
		placementJobApplicationPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_JOB_APPLICATION_SEND_MESSAGE_MESSAGE_TEMPLATE,"MESSAGE_TEMPLATE");
		featurePrivilegesMap.add("PLACEMENT_JOB_APPLICATION_PRIVILEGES", placementJobApplicationPrivileges);
		
		studentTransferReportsPrivileges = new Ext.util.HashMap();
		studentTransferReportsPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSTRANSFERREPORT_VIEW,"VIEW");
		studentTransferReportsPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSTRANSFERREPORT_EXPORT,"EXPORT");
		studentTransferReportsPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSTRANSFERREPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_TRANSFER_REPORTS_PRIVILEGES", studentTransferReportsPrivileges);
		
		placementRecruitmentStagePrivileges = new Ext.util.HashMap();
		placementRecruitmentStagePrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_RECRUITMENT_STAGE_VIEW,"VIEW");
		placementRecruitmentStagePrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_RECRUITMENT_STAGE_EXPORT,"EXPORT");
		placementRecruitmentStagePrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_RECRUITMENT_STAGE_ENTERMARKS,"ENTERMARKS");
		placementRecruitmentStagePrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_RECRUITMENT_STAGE_PROMOTESTUDENT,"PROMOTESTUDENT");
		placementRecruitmentStagePrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_RECRUITMENT_STAGE_CALCULATERANK,"CALCULATERANK");
		placementRecruitmentStagePrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_RECRUITMENT_STAGE_SENDMESSAGE,"SENDMESSAGE");
		placementRecruitmentStagePrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_RECRUITMENT_PROCESS_SEND_MESSAGE_ADHOC_MESSAGE,"ADHOC_MESSAGE");
		placementRecruitmentStagePrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_RECRUITMENT_PROCESS_SEND_MESSAGE_MESSAGE_TEMPLATE,"MESSAGE_TEMPLATE");
		
		featurePrivilegesMap.add("PLACEMENT_RECRUITMENT_STAGE_PRIVILEGES", placementRecruitmentStagePrivileges);
		
		placementDetailReportPrivileges = new Ext.util.HashMap();
		placementDetailReportPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_DETAIL_REPORT_VIEW,"VIEW");
		placementDetailReportPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_DETAIL_REPORT_CREATE,"CREATE");
		placementDetailReportPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_DETAIL_REPORT_UPDATE,"UPDATE");
		placementDetailReportPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_DETAIL_REPORT_DELETE,"DELETE");
		placementDetailReportPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_DETAIL_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PLACEMENT__DETAIL_REPORT_PRIVILEGES", placementDetailReportPrivileges);
		
		placementMasterPrivileges = new Ext.util.HashMap();
		placementMasterPrivileges.add(FPCONSTANTS.PC_M8_D_PLACEMENT_MASTER_VIEW,"VIEW");
		featurePrivilegesMap.add("PLACEMENT_MASTER_PRIVILEGES", placementMasterPrivileges);
		
		/*mobileSyncReportPrivileges = new Ext.util.HashMap();
		mobileSyncReportPrivileges.add(FPCONSTANTS.PC_M12_R_MOBILE_SYNC_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("MOBILE_SYNC_REPORT_PRIVILEGES", mobileSyncReportPrivileges);*/
		
		licenseDetailsReportPrivileges = new Ext.util.HashMap();
		licenseDetailsReportPrivileges.add(FPCONSTANTS.PC_M12_LICENSE_DETAILS_REPORT_VIEW,"VIEW");
		licenseDetailsReportPrivileges.add(FPCONSTANTS.PC_M12_LICENSE_DETAILS_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		licenseDetailsReportPrivileges.add(FPCONSTANTS.PC_M12_LICENSE_DETAILS_REPORT_STUDENT_LICENSE_DETAILS,"STUDENT_LICENSE_DETAILS");
		licenseDetailsReportPrivileges.add(FPCONSTANTS.PC_M12_LICENSE_DETAILS_REPORT_ALUMNI_LICENSE_DETAILS,"ALUMNI_LICENSE_DETAILS");
		featurePrivilegesMap.add("LICENSE_DETAILS_REPORT_PRIVILEGES", licenseDetailsReportPrivileges);
		
		programWiseGradeReportPrivileges = new Ext.util.HashMap();
		programWiseGradeReportPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_GRADE_WISE_REPORTS_EXPORT,"EXPORT");
		programWiseGradeReportPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_GRADE_WISE_REPORTS_EXPORT_REPORTS,"EXPORT_REPORTS");
		featurePrivilegesMap.add("EXAMINATION_GRADE_WISE_REPORT_PRIVILEGES", programWiseGradeReportPrivileges);
		
		examWiseGradeReportPrivileges = new Ext.util.HashMap();
		examWiseGradeReportPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_GRADE_WISE_STUDENT_REPORTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_GRADE_WISE_STUDENT_REPORT_PRIVILEGES", examWiseGradeReportPrivileges);
		
		examCrossListReportPrivileges = new Ext.util.HashMap();
		examCrossListReportPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_CROSS_LIST_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_CROSS_LIST_REPORT_PRIVILEGES", examCrossListReportPrivileges);
		
		examGradeGPAReportPrivileges = new Ext.util.HashMap();
		examGradeGPAReportPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_GPA_REPORT_EXPORT,"EXPORT");
		examGradeGPAReportPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_GPA_REPORT_EXPORT_REPORTS,"EXPORT_REPORTS");
		featurePrivilegesMap.add("EXAMINATION_GPA_REPORT_PRIVILEGES", examGradeGPAReportPrivileges);
		
		examinationRemarkPrivileges = new Ext.util.HashMap();
		examinationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REMARK_VIEW,"VIEW");
		//examinationRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REMARK_IMPORT_BULK_EXAMINATION_REMARK,"IMPORT_BULK_EXAMINATION_REMARK");
//		examinationRemarkPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSTRANSFERREPORT_EXPORT,"EXPORT");
		examinationRemarkPrivileges.add("EXAMINATION_REMARK_PRIVILEGES", examinationRemarkPrivileges);
		
		examinationRemarkListPrivileges = new Ext.util.HashMap();
		examinationRemarkListPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REMARK_LIST_CREATE,"CREATE");
		examinationRemarkListPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REMARK_LIST_DELETE,"DELETE");
		examinationRemarkListPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REMARK_LIST_UPDATE,"UPDATE");
		examinationRemarkListPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REMARK_LIST_EXPORT,"EXPORT");
		examinationRemarkListPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REMARK_IMPORT_BULK_EXAMINATION_REMARK,
				"IMPORT_BULK_EXAMINATION_REMARK");
		featurePrivilegesMap.add("EXAMINATION_REMARK_LIST_PRIVILEGES", examinationRemarkListPrivileges);
		
		examinationRemarkCoursePrivileges = new Ext.util.HashMap();
		examinationRemarkCoursePrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REMARK_COURSE_LIST_CREATE,"CREATE");
		examinationRemarkCoursePrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REMARK_COURSE_LIST_DELETE,"DELETE");
		examinationRemarkCoursePrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REMARK_COURSE_LIST_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_REMARK_COURSE_PRIVILEGES", examinationRemarkCoursePrivileges);
		
		examinationRemarkPlanPrivileges = new Ext.util.HashMap();
		examinationRemarkPlanPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REMARK_PLAN_LIST_CREATE,"CREATE");
		examinationRemarkPlanPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REMARK_PLAN_LIST_DELETE,"DELETE");
		examinationRemarkPlanPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REMARK_PLAN_LIST_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_REMARK_PLAN_PRIVILEGES", examinationRemarkPlanPrivileges);
		
		applyforevaluationgroupCollectPayement = new Ext.util.HashMap();
		applyforevaluationgroupCollectPayement.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_COLLECT_PAYEMENT_COLLECT_PAYMENT,"COLLECT_PAYMENT");
		applyforevaluationgroupCollectPayement.add(FPCONSTANTS.PC_M5_F_APPLYFOREVALUATIONGROUP_COLLECT_PAYEMENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPLYFOREVALUATIONGROUP_COLLECT_PAYEMENT_PRIVILEGES", applyforevaluationgroupCollectPayement);
		
		examDetentionReportsPrivileges = new Ext.util.HashMap();
		examDetentionReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_DETENTION_REPORTS_EXPORT,"EXPORT");
		examDetentionReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_DETENTION_REPORTS_ALLOW_DETENTATION,"PERMIT_STUDENT");
		
		featurePrivilegesMap.add("EXAMINATION_DETENTION_REPORTS_PRIVILEGES", examDetentionReportsPrivileges);

		examinationDegreeRemarkPrivileges = new Ext.util.HashMap();
		examinationDegreeRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS,"VIEW");
		examinationDegreeRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_CREATE,"CREATE");
		examinationDegreeRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_UPDATE,"UPDATE");
		examinationDegreeRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_DELETE,"DELETE");
		examinationDegreeRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_APPLY,"APPLY");
		examinationDegreeRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_EXPORT,"EXPORT");
		/*examinationDegreeRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_CR_CREATE,"CREATE_CR");
		examinationDegreeRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_CR_UPDATE,"UPDATE_CR");
		examinationDegreeRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_CR_DELETE,"DELETE_CR");
		examinationDegreeRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_CR_EXPORT,"EXPORT_CR");*/
		featurePrivilegesMap.add("EXAMINATION_DEGREE_REMARK_PRIVILEGES", examinationDegreeRemarkPrivileges);

		examinationAttendenceRulePrivileges = new Ext.util.HashMap();
		examinationAttendenceRulePrivileges.add(FPCONSTANTS.PC_M5_F_ATTENDANCE_RULE_VIEW,"VIEW");
		examinationAttendenceRulePrivileges.add(FPCONSTANTS.PC_M5_F_ATTENDANCE_RULE_CREATE,"CREATE");
		examinationAttendenceRulePrivileges.add(FPCONSTANTS.PC_M5_F_ATTENDANCE_RULE_UPDATE,"UPDATE");
		examinationAttendenceRulePrivileges.add(FPCONSTANTS.PC_M5_F_ATTENDANCE_RULE_DELETE,"DELETE");
		examinationAttendenceRulePrivileges.add(FPCONSTANTS.PC_M5_F_ATTENDANCE_RULE_APPLY,"APPLY");
		examinationAttendenceRulePrivileges.add(FPCONSTANTS.PC_M5_F_ATTENDANCE_RULE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_ATTENDANCE_RULE_PRIVILEGES", examinationAttendenceRulePrivileges);
		
		examinationAttendenceRangePrivileges = new Ext.util.HashMap();
		examinationAttendenceRangePrivileges.add(FPCONSTANTS.PC_M5_F_ATTENDANCE_RANGE_CREATE,"CREATE");
		examinationAttendenceRangePrivileges.add(FPCONSTANTS.PC_M5_F_ATTENDANCE_RANGE_UPDATE,"UPDATE");
		examinationAttendenceRangePrivileges.add(FPCONSTANTS.PC_M5_F_ATTENDANCE_RANGE_DELETE,"DELETE");
		examinationAttendenceRangePrivileges.add(FPCONSTANTS.PC_M5_F_ATTENDANCE_RANGE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_ATTENDANCE_RANGE_PRIVILEGES", examinationAttendenceRangePrivileges);
		
		examinationAttendenceRulePrivilegesApplyTo = new Ext.util.HashMap();
		examinationAttendenceRulePrivilegesApplyTo.add(FPCONSTANTS.PC_M5_F_ATTENDANCE_RULE_APPLY_TO_CREATE,"CREATE");
		examinationAttendenceRulePrivilegesApplyTo.add(FPCONSTANTS.PC_M5_F_ATTENDANCE_RULE_APPLY_TO_VIEW,"VIEW");
		examinationAttendenceRulePrivilegesApplyTo.add(FPCONSTANTS.PC_M5_F_ATTENDANCE_RULE_APPLY_TO_DELETE,"DELETE");
		featurePrivilegesMap.add("EXAMINATION_ATTENDANCE_RULE_PRIVILEGES_APPLY_TO", examinationAttendenceRulePrivilegesApplyTo);
		
				
		
		examinationExamCancellationPrivileges = new Ext.util.HashMap();
		examinationExamCancellationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION,"VIEW");
		examinationExamCancellationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION_CREATE,"CREATE");
		examinationExamCancellationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION_UPDATE,"UPDATE");
		examinationExamCancellationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION_DELETE,"DELETE");
		examinationExamCancellationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION_APPLY,"APPLY");
		examinationExamCancellationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION_EXPORT,"EXPORT");
		examinationExamCancellationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("EXAMINATION_EXAM_CANCELLATION_PRIVILEGES", examinationExamCancellationPrivileges);
		
		
		examinationExamCancellationRequestPrivileges = new Ext.util.HashMap();
		examinationExamCancellationRequestPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION_REQUEST,"VIEW");
		examinationExamCancellationRequestPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION_REQUEST_EXPORT,"EXPORT");
		examinationExamCancellationRequestPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION_REQUEST_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		examinationExamCancellationRequestPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION_REQUEST_APPROVE_REJECT, "APPROVE_OR_REJECT");
		
		featurePrivilegesMap.add("EXAMINATION_EXAM_CANCELLATION_REQUEST_PRIVILEGES", examinationExamCancellationRequestPrivileges);
		
		
		examinationExamConcessionPrivileges = new Ext.util.HashMap();
		examinationExamConcessionPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CONCESSION,"VIEW");
		examinationExamConcessionPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CONCESSION_CREATE,"CREATE");
		examinationExamConcessionPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CONCESSION_UPDATE,"UPDATE");
		examinationExamConcessionPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CONCESSION_DELETE,"DELETE");
		examinationExamConcessionPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CONCESSION_APPLY,"APPLY");
		examinationExamConcessionPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CONCESSION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_EXAM_CONCESSION_PRIVILEGES", examinationExamConcessionPrivileges);
		
		
		examConcessionPrivilegesApplyTo = new Ext.util.HashMap();
		examConcessionPrivilegesApplyTo.add(FPCONSTANTS.PC_M5_F_EXAM_CONCESSION_APPLY_TO_CREATE,"CREATE");
		examConcessionPrivilegesApplyTo.add(FPCONSTANTS.PC_M5_F_EXAM_CONCESSION_APPLY_TO_VIEW,"VIEW");
		examConcessionPrivilegesApplyTo.add(FPCONSTANTS.PC_M5_F_EXAM_CONCESSION_APPLY_TO_DELETE,"DELETE");
		featurePrivilegesMap.add("EXAM_CONCESSION_PRIVILEGES_APPLY_TO", examConcessionPrivilegesApplyTo);
		
		
		examinationExamConcessionRequestPrivileges = new Ext.util.HashMap();
		examinationExamConcessionRequestPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CONCESSION_REQUEST,"VIEW");
		featurePrivilegesMap.add("EXAMINATION_EXAM_CONCESSION_REQUEST_PRIVILEGES", examinationExamConcessionRequestPrivileges);
		
		
		facultyExamConcessionPrivileges = new Ext.util.HashMap();
		facultyExamConcessionPrivileges.add(FPCONSTANTS.PC_M5_F_FP_EXAM_CONCESSION,"VIEW");
		featurePrivilegesMap.add("FP_EXAMINATION_EXAM_CONCESSION_PRIVILEGES", facultyExamConcessionPrivileges);
		
		
		examinationDegreeRemarkPrivilegesCr = new Ext.util.HashMap();
		examinationDegreeRemarkPrivilegesCr.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_CR_CREATE,"CREATE");
		examinationDegreeRemarkPrivilegesCr.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_CR_UPDATE,"UPDATE");
		examinationDegreeRemarkPrivilegesCr.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_CR_DELETE,"DELETE");
		examinationDegreeRemarkPrivilegesCr.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_CR_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_DEGREE_REMARK_PRIVILEGES_CR", examinationDegreeRemarkPrivilegesCr);
		
		examinationDegreeRemarkPrivilegesApplyTo = new Ext.util.HashMap();
		examinationDegreeRemarkPrivilegesApplyTo.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_APPLY_TO_CREATE,"CREATE");
		examinationDegreeRemarkPrivilegesApplyTo.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_APPLY_TO_VIEW,"VIEW");
		examinationDegreeRemarkPrivilegesApplyTo.add(FPCONSTANTS.PC_M5_F_DEGREE_REMARKS_APPLY_TO_DELETE,"DELETE");
		featurePrivilegesMap.add("EXAMINATION_DEGREE_REMARK_PRIVILEGES_APPLY_TO", examinationDegreeRemarkPrivilegesApplyTo);
		
		obeAttainmentRulesPrivileges = new Ext.util.HashMap();
		obeAttainmentRulesPrivileges.add(FPCONSTANTS.PC_M5_F_OBE_ATTAINMENT_RULES,"VIEW");
		obeAttainmentRulesPrivileges.add(FPCONSTANTS.PC_M5_F_OBE_ATTAINMENT_RULES_CREATE,"CREATE");
		obeAttainmentRulesPrivileges.add(FPCONSTANTS.PC_M5_F_OBE_ATTAINMENT_RULES_UPDATE,"UPDATE");
		obeAttainmentRulesPrivileges.add(FPCONSTANTS.PC_M5_F_OBE_ATTAINMENT_RULES_DELETE,"DELETE");
		obeAttainmentRulesPrivileges.add(FPCONSTANTS.PC_M5_F_OBE_ATTAINMENT_RULES_SAVE,"SAVE");
		featurePrivilegesMap.add("OBE_ATTAINMENT_RULES_PRIVILEGES", obeAttainmentRulesPrivileges);
		
		
		
		obeCorrelationRulePrivileges = new Ext.util.HashMap();
		obeCorrelationRulePrivileges.add(FPCONSTANTS.PC_M5_F_OBE_CORRELATION_VIEW,"VIEW");
		obeCorrelationRulePrivileges.add(FPCONSTANTS.PC_M5_F_OBE_CORRELATION_CREATE,"CREATE");
		obeCorrelationRulePrivileges.add(FPCONSTANTS.PC_M5_F_OBE_CORRELATION_DELETE,"DELETE");
		obeCorrelationRulePrivileges.add(FPCONSTANTS.PC_M5_F_OBE_CORRELATION_UPDATE,"UPDATE");
		featurePrivilegesMap.add("OBE_CORRELATION_RULES_PRIVILEGES", obeCorrelationRulePrivileges);
		
		obeManageQuestionTemplatePrivileges = new Ext.util.HashMap();
		obeManageQuestionTemplatePrivileges.add(FPCONSTANTS.PC_M5_F_OBE_MANAGE_QUESTION_TEMPLATES_VIEW,"VIEW");
		obeManageQuestionTemplatePrivileges.add(FPCONSTANTS.PC_M5_F_OBE_MANAGE_QUESTION_TEMPLATES_IMPORT_QUESTIONS,"IMPORT_QUESTIONS");
		featurePrivilegesMap.add("OBE_MANAGE_QUESTION_TEMPLATE_PRIVILEGES", obeManageQuestionTemplatePrivileges);
		
		obeSubmenu1Report1Privileges = new Ext.util.HashMap();
		obeSubmenu1Report1Privileges.add(FPCONSTANTS.PBI_OBE_SUBMENU1_REPORT1_VIEW,"VIEW");
		featurePrivilegesMap.add("OBE_SUBMENU1_REPORT1_PRIVILEGE", obeSubmenu1Report1Privileges);
		
		obeSubmenu1Report2Privileges = new Ext.util.HashMap();
		obeSubmenu1Report2Privileges.add(FPCONSTANTS.PBI_OBE_SUBMENU1_REPORT2_VIEW,"VIEW");
		featurePrivilegesMap.add("OBE_SUBMENU1_REPORT2_PRIVILEGE", obeSubmenu1Report2Privileges);
		
		obeSubmenu1Report3Privileges = new Ext.util.HashMap();
		obeSubmenu1Report3Privileges.add(FPCONSTANTS.PBI_OBE_SUBMENU1_REPORT3_VIEW,"VIEW");
		featurePrivilegesMap.add("OBE_SUBMENU1_REPORT3_PRIVILEGE", obeSubmenu1Report3Privileges);
		
		obeSubmenu1Report4Privileges = new Ext.util.HashMap();
		obeSubmenu1Report4Privileges.add(FPCONSTANTS.PBI_OBE_SUBMENU1_REPORT4,"VIEW");
		featurePrivilegesMap.add("OBE_SUBMENU1_REPORT4_PRIVILEGE", obeSubmenu1Report4Privileges);
		
		userRolesAssociationReportsPrivileges = new Ext.util.HashMap();
		userRolesAssociationReportsPrivileges.add(FPCONSTANTS.PSA_M13_F_USER_ROLES_ASSOCIATION_REPORT_VIEW,"VIEW");
		userRolesAssociationReportsPrivileges.add(FPCONSTANTS.PSA_M13_F_USER_ROLES_ASSOCIATION_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("USER_ROLES_ASSOCIATION_REPORTS_PRIVILEGES", userRolesAssociationReportsPrivileges);
		
		/************* User Role And Privilege Report ************************************/
		userRolesAndPrivilegeReportsPrivileges = new Ext.util.HashMap();
		userRolesAndPrivilegeReportsPrivileges.add(FPCONSTANTS.PSA_M13_F_USER_ROLE_AND_PRIVILEGE_REPORT_VIEW,"VIEW");
		userRolesAndPrivilegeReportsPrivileges.add(FPCONSTANTS.PSA_M13_F_USER_ROLE_AND_PRIVILEGE_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("USER_ROLES_AND_PRIVILEGE_REPORTS_PRIVILEGES", userRolesAndPrivilegeReportsPrivileges);
		
		userRolesAndPrivilegeReportsUsersPrivileges = new Ext.util.HashMap();
		userRolesAndPrivilegeReportsUsersPrivileges.add(FPCONSTANTS.PSA_M13_F_USER_ROLE_AND_PRIVILEGE_REPORT_USERS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("USER_ROLES_AND_PRIVILEGE_REPORTS_USERS_PRIVILEGES", userRolesAndPrivilegeReportsUsersPrivileges);
		
		examEligibilityPrivileges = new Ext.util.HashMap();
		examEligibilityPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_EXAM_ELIGIBILITY_VIEW,"VIEW");
		examEligibilityPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_EXAM_ELIGIBILITY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_EXAM_ELIGIBILITY_PRIVILEGES", examEligibilityPrivileges);
		
		eventAwardsPrivileges = new Ext.util.HashMap();
		eventAwardsPrivileges.add(FPCONSTANTS.PC_M7_F_EVENT_AWARDS_VIEW,"VIEW");
		eventAwardsPrivileges.add(FPCONSTANTS.PC_M7_F_EVENT_AWARDS_EXPORT,"EXPORT");
		eventAwardsPrivileges.add(FPCONSTANTS.PC_M7_F_EVENT_AWARDS_CREATE,"CREATE");
		eventAwardsPrivileges.add(FPCONSTANTS.PC_M7_F_EVENT_AWARDS_UPDATE,"UPDATE");
		eventAwardsPrivileges.add(FPCONSTANTS.PC_M7_F_EVENT_AWARDS_DELETE,"DELETE");
		featurePrivilegesMap.add("EVENT_AWARDS_PRIVILEGES", eventAwardsPrivileges);
		
		examAnonymousReportsPrivileges = new Ext.util.HashMap();
		examAnonymousReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_ANONYMOUS_REPORTS_EXPORT,"EXPORT");
		examAnonymousReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_ANONYMOUS_REPORTS_EXPORT_BARCODE_REPORT,"EXPORT_BARCODE_REPORT");		
		examAnonymousReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_ANONYMOUS_REPORTS_GRID_CONFIGURATION, "GRID_CONFIGURATION");		
		featurePrivilegesMap.add("EXAMINATION_ANONYMOUS_REPORTS_PRIVILEGES", examAnonymousReportsPrivileges);
		
		examStudentAssessmentReportsPrivileges = new Ext.util.HashMap();
		examStudentAssessmentReportsPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ASSESSMENT_REPORT_VIEW,"VIEW");
		examStudentAssessmentReportsPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ASSESSMENT_REPORT_PUBLISH,"PUBLISH");
		examStudentAssessmentReportsPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ASSESSMENT_REPORT_SENDMESSAGE,"SENDMESSAGE");
		examStudentAssessmentReportsPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ASSESSMENT_REPORT_EXPORT_GRADE_BOOK,"EXPORT_GRADE_BOOK");
		examStudentAssessmentReportsPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ASSESSMENT_REPORT_EXPORT_EXPORT_REPORTS,"EXPORT_REPORTS");
		examStudentAssessmentReportsPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ASSESSMENT_REPORT_EXPORT_ADHOC_MESSAGE,"ADHOC_MESSAGE");
		examStudentAssessmentReportsPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ASSESSMENT_REPORT_EXPORT_MESSAGE_TEMPLATE,"MESSAGE_TEMPLATE");
		examStudentAssessmentReportsPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ASSESSMENT_REPORT_DELETE,"DELETE");
		examStudentAssessmentReportsPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ASSESSMENT_REPORT_GENERATE_AND_PUBLISH_BUTTON,"GENERATE_AND_PUBLISH_BUTTON");
		examStudentAssessmentReportsPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ASSESSMENT_REPORT_GENERATE_BUTTON,"GENERATE_BUTTON");
		examStudentAssessmentReportsPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ASSESSMENT_REPORT_UNPUBLISH_GRADE_BOOK,"UNPUBLISH_GRADE_BOOK");
		examStudentAssessmentReportsPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ASSESSMENT_PUBLISH_PROGRESSION_STATUS,"PUBLISH_PROGRESSION_STATUS");
		examStudentAssessmentReportsPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_ASSESSMENT_REPORT_UNPUBLISH_RESULT,"UNPUBLISH_RESULT");
		
		featurePrivilegesMap.add("EXAMINATION_STUDENT_ASSESSMENT_REPORTS_PRIVILEGES", examStudentAssessmentReportsPrivileges);

		studentMyDashboardPrivileges = new Ext.util.HashMap();
		studentMyDashboardPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_MY_DASHBOARD_PROFILE_PRINT,"PROFILE_PRINT");
		studentMyDashboardPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MY_DASHBOARD_PROFILE_PRINT,"PROFILE_PRINT");
		featurePrivilegesMap.add("STUDENT_MY_DASHBOARD_PRIVILEGES", studentMyDashboardPrivileges);
		
		pncCourseAttendanceReportsPrivileges = new Ext.util.HashMap();
		pncCourseAttendanceReportsPrivileges.add(FPCONSTANTS.PC_M4_R_COURSE_ATTENDANCE_REPORT_EXPORT,"EXPORT");
		pncCourseAttendanceReportsPrivileges.add(FPCONSTANTS.PC_M4_R_COURSE_ATTENDANCE_REPORT_EXPORT_REPORTS,"EXPORT_REPORTS");	
		pncCourseAttendanceReportsPrivileges.add(FPCONSTANTS.PC_M4_R_COURSE_ATTENDANCE_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("COURSE_ATTENDANCE_REPORT_PRIVILEGES", pncCourseAttendanceReportsPrivileges);
		
		pncFacultyWorkLoadReportsPrivileges = new Ext.util.HashMap();
		pncFacultyWorkLoadReportsPrivileges.add(FPCONSTANTS.PC_M4_R_FACULTY_WORKLOAD_REPORT_EXPORT,"EXPORT");
		pncFacultyWorkLoadReportsPrivileges.add(FPCONSTANTS.PC_M4_R_FACULTY_WORKLOAD_REPORT_EXPORT_REPORTS,"EXPORT_REPORTS");
		pncFacultyWorkLoadReportsPrivileges.add(FPCONSTANTS.PC_M4_R_FACULTY_WORKLOAD_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_WORKLOAD_REPORT_PRIVILEGES", pncFacultyWorkLoadReportsPrivileges);
		
		sectionCourseViewTimeTablePrivileges = new Ext.util.HashMap();
		sectionCourseViewTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSEVIEWTIMETABLE_PROGRAM_BATCH_SECTION,"PROGRAM_BATCH_SECTION");
		sectionCourseViewTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSEVIEWTIMETABLE_COURSE_SECTION,"COURSE_SECTION");
		sectionCourseViewTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSEVIEWTIMETABLE_DELETE,"DELETE");
		sectionCourseViewTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSEVIEWTIMETABLE_EXPORT,"EXPORT");
		sectionCourseViewTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSEVIEWTIMETABLE_EXPORT_TIMETABLE,"EXPORT_TIMETABLE");
		sectionCourseViewTimeTablePrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONCOURSEVIEWTIMETABLE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("SECTION_COURSE_VIEW_TIMETABLE_PRIVILEGES", sectionCourseViewTimeTablePrivileges);
		
		placementCreateCompanyPrivileges = new Ext.util.HashMap();
		placementCreateCompanyPrivileges.add(FPCONSTANTS.PC_M8_D_CREATE_COMPANY_VIEW,"VIEW");
		placementCreateCompanyPrivileges.add(FPCONSTANTS.PC_M8_D_CREATE_COMPANY_CREATE,"CREATE");
		placementCreateCompanyPrivileges.add(FPCONSTANTS.PC_M8_D_CREATE_COMPANY_UPDATE,"UPDATE");
		placementCreateCompanyPrivileges.add(FPCONSTANTS.PC_M8_D_CREATE_COMPANY_DELETE,"DELETE");
		placementCreateCompanyPrivileges.add(FPCONSTANTS.PC_M8_D_CREATE_COMPANY_EXPORT,"EXPORT");
		placementCreateCompanyPrivileges.add(FPCONSTANTS.PC_M8_D_CREATE_COMPANY_ADD_ADDRESS,"ADD_ADDRESS");
		featurePrivilegesMap.add("PLACEMENT_CREATE_COMPANY_PRIVILEGES", placementCreateCompanyPrivileges);
		
		examinationReportPendingMarkEntryPrivileges = new Ext.util.HashMap();
		examinationReportPendingMarkEntryPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_PENDING_MARK_ENTRY_EXPORT,"EXPORT");
		examinationReportPendingMarkEntryPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_PENDING_MARK_ENTRY_EXPORT_SENDMESSAGE, "SENDMESSAGE");
		examinationReportPendingMarkEntryPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_PENDING_MARK_ENTRY_EXPORT_ADHOC_MESSAGE, "ADHOC_MESSAGE");
		examinationReportPendingMarkEntryPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_PENDING_MARK_ENTRY_EXPORT_MESSAGE_TEMPLATE, "MESSAGE_TEMPLATE");
		examinationReportPendingMarkEntryPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_PENDING_MARK_ENTRY_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("EXAMINATION_REPORTS_PENDING_MARK_ENTRY_PRIVILEGES", examinationReportPendingMarkEntryPrivileges);
        
		examinationReportPendingRemarkEntryPrivileges = new Ext.util.HashMap();
		examinationReportPendingRemarkEntryPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_PENDING_REMARK_ENTRY_EXPORT,"EXPORT");
		examinationReportPendingRemarkEntryPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_PENDING_REMARK_ENTRY_EXPORT_SENDMESSAGE, "SENDMESSAGE");
		examinationReportPendingRemarkEntryPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_PENDING_REMARK_ENTRY_EXPORT_ADHOC_MESSAGE, "ADHOC_MESSAGE");
		examinationReportPendingRemarkEntryPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_PENDING_REMARK_ENTRY_EXPORT_MESSAGE_TEMPLATE, "MESSAGE_TEMPLATE");
		examinationReportPendingRemarkEntryPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_REPORTS_PENDING_REMARK_ENTRY_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("EXAMINATION_REPORTS_PENDING_REMARK_ENTRY_PRIVILEGES", examinationReportPendingRemarkEntryPrivileges);
        
        studentViewExaminationPrivileges = new Ext.util.HashMap();
		studentViewExaminationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_VIEW_EXAMINATION_VIEW,"VIEW");
		studentViewExaminationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_VIEW_EXAMINATION_EXPORT,"EXPORT");		
		featurePrivilegesMap.add("STUDENT_VIEW_EXAMINATION_PRIVILEGES", studentViewExaminationPrivileges);
		
		fileManagementPrivileges=new Ext.util.HashMap();
		fileManagementPrivileges.add(FPCONSTANTS.PC_M7_D_TS_MANAGEMENT_FILE_VIEW,"VIEW");
		fileManagementPrivileges.add(FPCONSTANTS.PC_M7_D_TS_MANAGEMENT_FILE_CREATE, "CREATE");
		fileManagementPrivileges.add(FPCONSTANTS.PC_M7_D_TS_MANAGEMENT_FILE_UPDATE, "UPDATE");
		fileManagementPrivileges.add(FPCONSTANTS.PC_M7_D_TS_MANAGEMENT_FILE_DELETE, "DELETE");
		fileManagementPrivileges.add(FPCONSTANTS.PC_M7_D_TS_MANAGEMENT_FILE_MOREACTIONS, "MOREACTIONS");
		fileManagementPrivileges.add(FPCONSTANTS.PC_M7_D_TS_MANAGEMENT_FILE_ASSIGNTO, "ASSIGNTO");
		fileManagementPrivileges.add(FPCONSTANTS.PC_M7_D_TS_MANAGEMENT_FILE_UPDATE_STATUS, "UPDATE_STATUS");
		fileManagementPrivileges.add(FPCONSTANTS.PC_M7_D_TS_MANAGEMENT_FILE_UPLOAD_DOCUMENT, "UPLOAD_DOCUMENT");
		fileManagementPrivileges.add(FPCONSTANTS.PC_M7_D_TS_MANAGEMENT_FILE_EXPORT, "EXPORT");
		fileManagementPrivileges.add(FPCONSTANTS.PC_M7_D_TS_MANAGEMENT_FILE_ACCESS_ALL_FILES, "ACCESSALLFILES");
		featurePrivilegesMap.add("FILE_MANAGEMENT_PRIVILEGES", fileManagementPrivileges);
		
		managePeriodEnrollmentPrivileges = new Ext.util.HashMap();
		managePeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_PERIOD_ENROLLMENT_VIEW,"VIEW");
		managePeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_PERIOD_ENROLLMENT_STUDENT_ENROLLMENT,"STUDENT_ENROLLMENT");
		managePeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_PERIOD_ENROLLMENT_ENROLL,"ENROLL");
		managePeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_PERIOD_ENROLLMENT_APPROVE,"APPROVE");
		managePeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_PERIOD_ENROLLMENT_OPTIONAL_PERIOD_ENROLLMENT,"OPTIONAL_PERIOD_ENROLLMENT");
		managePeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_PERIOD_ENROLLMENT_CHANGE_PAYMENT_TERM,"CHANGE_PAYMENT_TERM");
		managePeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_PERIOD_ENROLLMENT_RESEND_CONFIRMATION_LETTER,"RESEND_CONFIRMATION_LETTER");
		managePeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_PERIOD_ENROLLMENT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		managePeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_PERIOD_ENROLLMENT_REJECT,"REJECT");
		managePeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_PERIOD_ENROLLMENT_IMPORT_PERIOD_ENROLLMENT,"IMPORT_PERIOD_ENROLLMENT");
		featurePrivilegesMap.add("MANAGE_PERIOD_ENROLLMENT_PRIVILEGES", managePeriodEnrollmentPrivileges);
		
		studentPeriodEnrollmentPrivileges = new Ext.util.HashMap();
		studentPeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENT_PERIOD_ENROLLMENT,"SAVE");
		studentPeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENT_PERIOD_ENROLLMENT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		studentPeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENT_PERIOD_ENROLLMENT_CHANGE_PAYMENT_TERM,"CHANGE_PAYMENT_TERM");
		studentPeriodEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_PERIOD_ENROLLMENT_DE_ENROLL,"PERIOD_DE_ENROLL");
		featurePrivilegesMap.add("STUDENT_PERIOD_ENROLLMENT_PRIVILEGES", studentPeriodEnrollmentPrivileges);
		
		studentPeriodRegistrationPrivileges = new Ext.util.HashMap();
		studentPeriodRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_PERIOD_REGISTRATION_VIEW,"VIEW");
		studentPeriodRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_PERIOD_REGISTRATION_ENROLL,"ENROLL");
		studentPeriodRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_PERIOD_REGISTRATION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_PERIOD_REGISTRATION_PRIVILEGES", studentPeriodRegistrationPrivileges);
		
		
		studentRegistrationPaymentDetailsPrivileges = new Ext.util.HashMap();
		studentRegistrationPaymentDetailsPrivileges.add(FPCONSTANTS.SP_M4_F_REGISTRATION_PAYMENT_DETAILS_PAY_NOW,"PAY_NOW");
		featurePrivilegesMap.add("STUDENT_REGISTRATION_PAYMENT_DETAILS_PRIVILEGES", studentRegistrationPaymentDetailsPrivileges);
		
		
		studentAcademicsTopicPrivileges = new Ext.util.HashMap();
		studentAcademicsTopicPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ACADEMICS_TOPIC_VIEW,"VIEW");
		studentAcademicsTopicPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ACADEMICS_TOPIC_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_ACADEMICS_TOPIC_PRIVILEGES", studentAcademicsTopicPrivileges);
		
		studentJourneyPrivileges = new Ext.util.HashMap();
		studentJourneyPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_JOURNEY_VIEW,"VIEW");
		studentJourneyPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_JOURNEY_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		studentJourneyPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_JOURNEY_GRID_CHANGE_PROGRESSION_STATUS,"CHANGE_PROGRESSION_STATUS");
		studentJourneyPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_JOURNEY_GRID_MODIFY_ENROLLMENT,"MODIFY_ENROLLMENT");
		studentJourneyPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_JOURNEY_SAVE,"SAVE");
		studentJourneyPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_JOURNEY_MORE_ACTION,"MORE_ACTION");
		studentJourneyPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_JOURNEY_ADD_ENROLLMENT_FOR_THE_NEXT_LINE,"ADD_ENROLLMENT_FOR_THE_NEXT_LINE");
		studentJourneyPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_JOURNEY_CANCEL,"CANCEL");  
		featurePrivilegesMap.add("STUDENT_JOURNEY_PRIVILEGES", studentJourneyPrivileges);
		
		examAssignProgramFacultyRemarkPrivileges = new Ext.util.HashMap();
		examAssignProgramFacultyRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGN_PROGRAM_FACULTY_REMARK_VIEW,"VIEW");
		examAssignProgramFacultyRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGN_PROGRAM_FACULTY_REMARK_EXPORT,"EXPORT");
		examAssignProgramFacultyRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGN_PROGRAM_FACULTY_REMARK_SAVE,"SAVE");
		examAssignProgramFacultyRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGN_PROGRAM_FACULTY_REMARK_CREATE,"CREATE");
		examAssignProgramFacultyRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGN_PROGRAM_FACULTY_REMARK_UPDATE,"UPDATE");
		examAssignProgramFacultyRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGN_PROGRAM_FACULTY_REMARK_DELETE,"DELETE");
		examAssignProgramFacultyRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGN_PROGRAM_FACULTY_REMARK_ENTER_REMARK,"ENTER_REMARK");
		examAssignProgramFacultyRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGN_PROGRAM_FACULTY_REMARK_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		examAssignProgramFacultyRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGN_PROGRAM_FACULTY_MANAGE_REMARK_STATUS,"MANAGE_REMARK_STATUS");
		examAssignProgramFacultyRemarkPrivileges.add(FPCONSTANTS.PC_M5_F_ASSIGN_PROGRAM_FACULTY_GENERATE_REMARK,"GENERATE_REMARK");
		featurePrivilegesMap.add("ASSIGN_PROGRAM_FACULTY_REMARK_PRIVILEGES", examAssignProgramFacultyRemarkPrivileges);
		
		facultyPortalAssignStudentLevelRemarkPrivileges = new Ext.util.HashMap();
		facultyPortalAssignStudentLevelRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_STUDENT_LEVEL_REMARK_VIEW,"VIEW");
		facultyPortalAssignStudentLevelRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_STUDENT_LEVEL_REMARK_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_PORTAL_ASSIGN_STUDENT_LEVEL_REMARK_PRIVILEGES", facultyPortalAssignStudentLevelRemarkPrivileges);
		
		facultyPortalAssignClassteacherLevelRemarkPrivileges = new Ext.util.HashMap();
		facultyPortalAssignClassteacherLevelRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_CLASSTEACHER_LEVEL_REMARK_ENTER_REMARK,"ENTER_REMARK");
		facultyPortalAssignClassteacherLevelRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_CLASSTEACHER_LEVEL_REMARK_DELETE,"DELETE");
		facultyPortalAssignClassteacherLevelRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_CLASSTEACHER_LEVEL_REMARK_SAVE,"SAVE");
		facultyPortalAssignClassteacherLevelRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_CLASSTEACHER_LEVEL_REMARK_EXPORT,"EXPORT");
		facultyPortalAssignClassteacherLevelRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_CLASSTEACHER_LEVEL_REMARK_GENERATE_REMARK,"GENERATE_REMARK");
		facultyPortalAssignClassteacherLevelRemarkPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_CLASSTEACHER_LEVEL_REMARK_ENTRY_HOST_FACULTY,"REMARK_ENTRY_HOST_FACULTY");
		featurePrivilegesMap.add("ASSIGN_CLASSTEACHER_FACULTY_REMARK_PRIVILEGES", facultyPortalAssignClassteacherLevelRemarkPrivileges);
		
		facultyPortalClassteacherLevelRemarkPrivileges = new Ext.util.HashMap();
		facultyPortalClassteacherLevelRemarkPrivileges.add(FPCONSTANTS.FP_FACULTY_STUDENT_LEVEL_REMARK,"REMARK_ENTRY_HOST_FACULTY");
		featurePrivilegesMap.add("CLASSTEACHER_FACULTY_REMARK_PRIVILEGES", facultyPortalClassteacherLevelRemarkPrivileges);
		
		studentLevelRemarkPrivileges = new Ext.util.HashMap();
		studentLevelRemarkPrivileges.add(FPCONSTANTS.CERP_STUDENT_LEVEL_REMARK,"REMARK_ENTRY_HOST_FACULTY");
		featurePrivilegesMap.add("STUDENT_LEVEL_REMARK_PRIVILEGES", studentLevelRemarkPrivileges);
		
		studentEnrollementGenerationPrivileges = new Ext.util.HashMap();
		studentEnrollementGenerationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ENROLLEMENT_GENERATION_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_ENROLLEMENT_GENERATION_PRIVILEGES", studentEnrollementGenerationPrivileges);
		
		employeeCourseRosterReport = new Ext.util.HashMap();
		employeeCourseRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_ROSTER_REPORT_EXPORT,"EXPORT");
		employeeCourseRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_ROSTER_REPORT_GENERATE_COURSE_ROSTER_REPORT, "GENERATE_COURSE_ROSTER_REPORT");
		employeeCourseRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_ROSTER_REPORT_SEND_MESSAGE, "SEND_MESSAGE_COURSE_ROSTER_REPORT");
		employeeCourseRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_ROSTER_REPORT_ADHOC_MESSAGE, "ADHOC_MESSAGE");
		employeeCourseRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_ROSTER_REPORT_MESSAGE_TEMPLATE, "MESSAGE_TEMPLATE");
		employeeCourseRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_ROSTER_REPORT_RESETPASSWORD, "RESETPASSWORD");
		featurePrivilegesMap.add("EMPLOYEE_COURSE_ROSTER_REPORT_PRIVILEGES", employeeCourseRosterReport);
		
		employeeSectionRosterReport = new Ext.util.HashMap();
		employeeSectionRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_SECTION_ROSTER_REPORT_VIEW,"VIEW");
		employeeSectionRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_SECTION_ROSTER_REPORT_EXPORT,"EXPORT");
		employeeSectionRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_SECTION_ROSTER_REPORT_SEND_MESSAGE, "SEND_MESSAGE_SECTION_ROSTER_REPORT");
		employeeSectionRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_SECTION_ROSTER_REPORT_EXPORT_REPORT, "GENERATE_SECTION_ROSTER_REPORT");
		employeeSectionRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_SECTION_ROSTER_REPORT_ADHOC_MESSAGE, "ADHOC_MESSAGE");
		employeeSectionRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_SECTION_ROSTER_REPORT_MESSAGE_TEMPLATE, "MESSAGE_TEMPLATE");
		employeeSectionRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_SECTION_ROSTER_REPORT_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("EMPLOYEE_SECTION_ROSTER_REPORT_PRIVILEGES", employeeSectionRosterReport);
		
		sessionReportPrivileges = new Ext.util.HashMap();
		sessionReportPrivileges.add(FPCONSTANTS.PC_M4_R_SESSION_REPORT_VIEW,"VIEW");
		sessionReportPrivileges.add(FPCONSTANTS.PC_M4_R_SESSION_REPORT_EXPORT,"EXPORT");
		sessionReportPrivileges.add(FPCONSTANTS.PC_M4_R_SESSION_REPORT_DATA_GRID,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("SESSION_REPORT_PRIVILEGES", sessionReportPrivileges);
		
		examinationProgramLevelReportsPrivileges = new Ext.util.HashMap();
		examinationProgramLevelReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_PROGRAM_LEVEL_REPORTS_EXPORT,"EXPORT");
		examinationProgramLevelReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_PROGRAM_LEVEL_REPORTS_VIEW,"VIEW");
		featurePrivilegesMap.add("EXAMINATION_PROGRAM_LEVEL_REPORT_PRIVILEGES", examinationProgramLevelReportsPrivileges);
		
		examinationExamLevelReportsPrivileges = new Ext.util.HashMap();
		examinationExamLevelReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_EXAM_LEVEL_REPORTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_EXAM_LEVEL_REPORT_PRIVILEGES", examinationExamLevelReportsPrivileges);
		
		courseSessionDiaryPrivileges=new Ext.util.HashMap();
		courseSessionDiaryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_SESSION_DIARY_VIEW,"VIEW");
		courseSessionDiaryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_SESSION_DIARY_CREATE, "CREATE");
		courseSessionDiaryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_SESSION_DIARY_UPDATE, "UPDATE");
		courseSessionDiaryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_SESSION_DIARY_DELETE, "DELETE");
		courseSessionDiaryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_SESSION_DIARY_EXPORT, "EXPORT");
		courseSessionDiaryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_SESSION_DIARY_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("COURSE_SESSION_DIARY_PRIVILEGES", courseSessionDiaryPrivileges);
		
		
		courseInterestInformationFacultyPortalPrivileges=new Ext.util.HashMap();
		courseInterestInformationFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_INTEREST_INFORMATION_VIEW,"VIEW");
		courseInterestInformationFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_INTEREST_INFORMATION_CREATE, "CREATE");
		courseInterestInformationFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_INTEREST_INFORMATION_UPDATE, "UPDATE");
		courseInterestInformationFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_INTEREST_INFORMATION_DELETE, "DELETE");
		courseInterestInformationFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_INTEREST_INFORMATION_EXPORT, "EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_COURSE_INTEREST_INFORMATION_PRIVILEGES", courseInterestInformationFacultyPortalPrivileges);
		
		
		availabilityPlanningFacultyPortalPrivileges=new Ext.util.HashMap();
		availabilityPlanningFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_AVAILABILITY_PLANNING_VIEW,"VIEW");
		availabilityPlanningFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_AVAILABILITY_PLANNING_CREATE, "CREATE");
		availabilityPlanningFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_AVAILABILITY_PLANNING_UPDATE, "UPDATE");
		availabilityPlanningFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_AVAILABILITY_PLANNING_DELETE, "DELETE");
		featurePrivilegesMap.add("FACULTY_PORTAL_AVAILABILITY_PLANNING_PRIVILEGES", availabilityPlanningFacultyPortalPrivileges);
		
		/***************Faculty Portal Incidents reports******************/
		negativeIncidentReportFacultyPortalPrivileges = new Ext.util.HashMap();
		negativeIncidentReportFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_NEGATIVE_INCIDENTS_REPORT_VIEW,"VIEW");
		negativeIncidentReportFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_NEGATIVE_INCIDENTS_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_NEGATIVE_INCIDENTS_REPORT_PRIVILEGES", negativeIncidentReportFacultyPortalPrivileges);
		
		positiveIncidentReportFacultyPortalPrivileges = new Ext.util.HashMap();
		positiveIncidentReportFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_POSITIVE_INCIDENTS_REPORT_VIEW,"VIEW");
		positiveIncidentReportFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_POSITIVE_INCIDENTS_REPORT_EXPORT,"EXPORT");
		positiveIncidentReportFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_POSITIVE_INCIDENTS_REPORT_EXPORT_REPORTS, "EXPORTREPORTS");
		featurePrivilegesMap.add("FACULTY_PORTAL_POSITIVE_INCIDENTS_REPORT_PRIVILEGES", positiveIncidentReportFacultyPortalPrivileges);

		disciplinaryActionReportFacultyPortalPrivileges = new Ext.util.HashMap();
		disciplinaryActionReportFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DISCIPLINARY_ACTION_REPORT_VIEW,"VIEW");
		disciplinaryActionReportFacultyPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_DISCIPLINARY_ACTION_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_DISCIPLINARY_ACTION_REPORT_PRIVILEGES", disciplinaryActionReportFacultyPortalPrivileges);
		
		pncSessionDiaryPrivileges=new Ext.util.HashMap();
		pncSessionDiaryPrivileges.add(FPCONSTANTS.PC_M4_F_SESSION_DIARY_VIEW,"VIEW");
		pncSessionDiaryPrivileges.add(FPCONSTANTS.PC_M4_F_SESSION_DIARY_CREATE, "CREATE");
		pncSessionDiaryPrivileges.add(FPCONSTANTS.PC_M4_F_SESSION_DIARY_UPDATE, "UPDATE");
		pncSessionDiaryPrivileges.add(FPCONSTANTS.PC_M4_F_SESSION_DIARY_DELETE, "DELETE");
		pncSessionDiaryPrivileges.add(FPCONSTANTS.PC_M4_F_SESSION_DIARY_EXPORT, "EXPORT");
		pncSessionDiaryPrivileges.add(FPCONSTANTS.PC_M4_F_SESSION_DIARY_GRID_CONFIG, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("PNC_SESSION_DIARY_PRIVILEGES", pncSessionDiaryPrivileges);
		
		learningTargetsPrivileges=new Ext.util.HashMap();
		learningTargetsPrivileges.add(FPCONSTANTS.PC_M4_F_LEARNING_TARGETS_VIEW,"VIEW");
		featurePrivilegesMap.add("LEARNING_TARGETS_PRIVILEGES", learningTargetsPrivileges);
		
		
		examinationPeriodLevelReportsPrivileges = new Ext.util.HashMap();
		examinationPeriodLevelReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_PERIOD_LEVEL_REPORTS_EXPORT,"EXPORT");
		examinationPeriodLevelReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_PERIOD_LEVEL_REPORTS_GENERATE_TABULATION,"GENERATETABULATION");
		examinationPeriodLevelReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_PERIOD_LEVEL_REPORTS_VIEW_SAVED_TABULATION_REGISTERS,"VIEW_SAVED_TABULATION_REGISTERS");
		
		
		examinationPeriodLevelReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_PERIOD_LEVEL_REPORTS_EXPORT_REPORTS,"EXPORT_REPORTS");
		examinationPeriodLevelReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_PERIOD_LEVEL_REPORTS_SAVE_AND_GENRATE,"SAVE_AND_GENRATE");
		examinationPeriodLevelReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_PERIOD_LEVEL_REPORTS_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		examinationPeriodLevelReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_PERIOD_LEVEL_REPORTS_VIEW_GENERATED_REPORT, "VIEW_GENERATED_REPORT");
		featurePrivilegesMap.add("EXAMINATION_PERIOD_LEVEL_REPORT_PRIVILEGES", examinationPeriodLevelReportsPrivileges);
		
		studentProgressPrivileges=new Ext.util.HashMap();
		studentProgressPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTS_PROGRESS_REPORT_VIEW,"VIEW");
		studentProgressPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTS_PROGRESS_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("STUDENT_PROGRESS_PRIVILEGES", studentProgressPrivileges);
		
		tnsManageCommittee=new Ext.util.HashMap();
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_VIEW,"VIEW");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_CREATE, "CREATE");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_DELETE, "DELETE");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_UPDATE, "UPDATE");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_EXPORT, "EXPORT");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_SENDMESSAGE, "SENDMESSAGE");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_ADD_MEETING, "ADD_MEETING");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_APPLY_TO, "APPLY_TO");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_BULK_COMMITTEE_CREATION,"BULK_COMMITTEE_CREATION");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_SEND_MESSAGE_ADHOC_MESSAGE, "ADHOC_MESSAGE");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_SEND_MESSAGE_MESSAGE_TEMPLATE, "MESSAGE_TEMPLATE");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_ALL_COMMITTEE, "ALL_COMMITTEE");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_PARTICIPANT_HYPERLINK, "PARTICIPANT_HYPERLINK");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_ALUMNI_RADIO_COMMITTEE, "ALUMNI_RADIO_COMMITTEE");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_BULK_COMMITTEE_PARTICIPANT, "BULK_COMMITTEE_PARTICIPANT");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_BULK_MEMBERSHIP_CREATION, "BULK_MEMBERSHIP_CREATION");
		featurePrivilegesMap.add("TNS_MANAGE_COMMITTEE_PRIVILEGES", tnsManageCommittee);
		
		tnsManageCommittee=new Ext.util.HashMap();
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_ALUMNI_VIEW,"VIEW");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_ALUMNI_CREATE, "CREATE");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_ALUMNI_DELETE, "DELETE");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_ALUMNI_UPDATE, "UPDATE");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_ALUMNI_EXPORT, "EXPORT");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_ALUMNI_SENDMESSAGE, "SENDMESSAGE");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_ALUMNI_ADD_MEETING, "ADD_MEETING");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_ALUMNI_APPLY_TO, "APPLY_TO");
		tnsManageCommittee.add(FPCONSTANTS.PC_M7_F_MANAGE_COMMITTEE_ALUMNI_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("TNS_MANAGE_ALUMNI_COMMITTEE_PRIVILEGES", tnsManageCommittee);
		
		
		tnsManageElection=new Ext.util.HashMap();
		tnsManageElection.add(FPCONSTANTS.PC_M7_F_MANAGE_ELECTIONS_VIEW,"VIEW");
		tnsManageElection.add(FPCONSTANTS.PC_M7_F_MANAGE_ELECTIONS_CREATE, "CREATE");
		tnsManageElection.add(FPCONSTANTS.PC_M7_F_MANAGE_ELECTIONS_DELETE, "DELETE");
		tnsManageElection.add(FPCONSTANTS.PC_M7_F_MANAGE_ELECTIONS_UPDATE, "UPDATE");
		tnsManageElection.add(FPCONSTANTS.PC_M7_F_MANAGE_ELECTIONS_EXPORT, "EXPORT");
		tnsManageElection.add(FPCONSTANTS.PC_M7_F_MANAGE_ELECTIONS_SENDMESSAGE, "SENDMESSAGE");
		tnsManageElection.add(FPCONSTANTS.PC_M7_F_MANAGE_ELECTIONS_MOREACTIONS, "MOREACTIONS");
		tnsManageElection.add(FPCONSTANTS.PC_M7_F_MANAGE_ELECTIONS_CANDIDATE_LIST, "CANDIDATE_LIST");
		tnsManageElection.add(FPCONSTANTS.PC_M7_F_MANAGE_ELECTIONS_VOTER_POOL, "VOTER_POOL");
		tnsManageElection.add(FPCONSTANTS.PC_M7_F_MANAGE_ELECTIONS_ELECTION_RESULTS, "ELECTION_RESULTS");
		tnsManageElection.add(FPCONSTANTS.PC_M7_F_MANAGE_ELECTIONS_COPY_ELECTION, "COPY_ELECTION");
		tnsManageElection.add(FPCONSTANTS.PC_M7_F_MANAGE_ELECTIONS_PRINT_ELECTION_SHEET, "PRINT_ELECTION_SHEET");
		featurePrivilegesMap.add("TNS_MANAGE_ELECTIONS_PRIVILEGES", tnsManageElection);
		
		tnsManageElectionVoterPool=new Ext.util.HashMap();
		tnsManageElectionVoterPool.add(FPCONSTANTS.PC_M7_F_VOTER_POOL_CAPTURE_BALLOT_VOTE, "CAPTURE_BALLOT_VOTE");
		tnsManageElectionVoterPool.add(FPCONSTANTS.PC_M7_F_VOTER_POOL_SEND_MESSAGE, "SENDMESSAGE");
		tnsManageElectionVoterPool.add(FPCONSTANTS.PC_M7_F_VOTER_POOL_CHANGE_WEIGHTAGE, "CHANGE_WEIGHTAGE");
		featurePrivilegesMap.add("TNS_MANAGE_ELECTIONS_VOTER_POOL_PRIVILEGES", tnsManageElectionVoterPool);
		
		
		committeeParticipant=new Ext.util.HashMap();
		committeeParticipant.add(FPCONSTANTS.PC_M7_F_COMMITTEE_PARTICIPANT_VIEW,"VIEW");
		committeeParticipant.add(FPCONSTANTS.PC_M7_F_COMMITTEE_PARTICIPANT_CREATE, "CREATE");
		committeeParticipant.add(FPCONSTANTS.PC_M7_F_COMMITTEE_PARTICIPANT_DELETE, "DELETE");
		committeeParticipant.add(FPCONSTANTS.PC_M7_F_COMMITTEE_PARTICIPANT_SAVE, "SAVE");
		committeeParticipant.add(FPCONSTANTS.PC_M7_F_COMMITTEE_PARTICIPANT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("COMMITTEE_PARTICIPANT_PRIVILEGES", committeeParticipant);
		
		tnsMembership=new Ext.util.HashMap();
		tnsMembership.add(FPCONSTANTS.PC_M7_F_MEMBERSHIP_VIEW,"VIEW");
		tnsMembership.add(FPCONSTANTS.PC_M7_F_MEMBERSHIP_CREATE, "CREATE");
		tnsMembership.add(FPCONSTANTS.PC_M7_F_MEMBERSHIP_DELETE, "DELETE");
		tnsMembership.add(FPCONSTANTS.PC_M7_F_MEMBERSHIP_UPDATE,"UPDATE");
		tnsMembership.add(FPCONSTANTS.PC_M7_F_MEMBERSHIP_EXPORT, "EXPORT");
		tnsMembership.add(FPCONSTANTS.PC_M7_F_MEMBERSHIP, "MEMBERSHIP");
		featurePrivilegesMap.add("TNS_MANAGE_COMMITTEE_MEMBERSHIP", tnsMembership);
		
		tnsManageCommitteeApplyTo=new Ext.util.HashMap();
		tnsManageCommitteeApplyTo.add(FPCONSTANTS.PC_M7_F_MANAGECOMMITTEE_APPLYTO_VIEW,"VIEW");
		tnsManageCommitteeApplyTo.add(FPCONSTANTS.PC_M7_F_MANAGECOMMITTEE_APPLYTO_CREATE, "CREATE");
		tnsManageCommitteeApplyTo.add(FPCONSTANTS.PC_M7_F_MANAGECOMMITTEE_APPLYTO_DELETE, "DELETE");
		tnsManageCommitteeApplyTo.add(FPCONSTANTS.PC_M7_F_MANAGECOMMITTEE_APPLYTO_PROGRAM_BATCH_PERIOD, "APPLYTO_PROGRAM_BATCH_PERIOD");
		tnsManageCommitteeApplyTo.add(FPCONSTANTS.PC_M7_F_MANAGECOMMITTEE_APPLYTO_COURSE_SECTION, "APPLYTO_COURSE_SECTION");
		featurePrivilegesMap.add("TNS_MANAGE_COMMITTEE_APPLY_TO_PRIVILEGES", tnsManageCommitteeApplyTo);

		employeeGradeRosterReport = new Ext.util.HashMap();
		employeeGradeRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_GRADE_ROSTER_REPORT_EXPORT,"EXPORT");
		employeeGradeRosterReport.add(FPCONSTANTS.FP_M9_F_FACULTY_GRADE_ROSTER_REPORT_GENERATE_GRADE_ROSTER_REPORT, "GENERATE_GRADE_ROSTER_REPORT");
		featurePrivilegesMap.add("EMPLOYEE_GRADE_ROSTER_REPORT_PRIVILEGES", employeeGradeRosterReport);

		studentSessionReport = new Ext.util.HashMap();
		studentSessionReport.add(FPCONSTANTS.SP_M4_F_SESSION_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_SESSION_REPORT_PRIVILEGES", studentSessionReport);
		
		studentAcademicTopic = new Ext.util.HashMap();
		studentAcademicTopic.add(FPCONSTANTS.SP_M11_F_ACADEMIC_TOPIC_VIEW,"VIEW");
		featurePrivilegesMap.add("SP_FOR_ACADEMIC_TOPIC", studentAcademicTopic);
		
		studentTransferCredit = new Ext.util.HashMap();
		studentTransferCredit.add(FPCONSTANTS.SP_M11_F_TRANSFER_CREDIT_VIEW,"VIEW");
		studentTransferCredit.add(FPCONSTANTS.SP_M11_F_STUDENT_TRANSFER_CREDIT_INTERNAL_TRANSFER_CREDIT_TAB,"INTERNAL_TRANSFER_CREDIT_TAB");
		featurePrivilegesMap.add("SP_FOR_TRANSFER_CREDIT", studentTransferCredit);
		
		
		studentRegistrationPortal = new Ext.util.HashMap();
		studentRegistrationPortal.add(FPCONSTANTS.SP_M11_F_REGISTRATION_PORTAL_VIEW,"VIEW");
		featurePrivilegesMap.add("SP_FOR_REGISTRATION_PORTAL", studentRegistrationPortal);
		
		parentAcademicTopic = new Ext.util.HashMap();
		parentAcademicTopic.add(FPCONSTANTS.PP_M11_F_ACADEMIC_TOPIC_VIEW,"VIEW");
		featurePrivilegesMap.add("PP_FOR_ACADEMIC_TOPIC", parentAcademicTopic);

		parentSessionReport = new Ext.util.HashMap();
		parentSessionReport.add(FPCONSTANTS.PP_M4_F_Session_Report_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_SESSION_REPORT_PRIVILEGES", parentSessionReport);
		
		studentPlacementAvailableJobsPrivileges = new Ext.util.HashMap();
		studentPlacementAvailableJobsPrivileges.add(FPCONSTANTS.SP_M11_F_AVAILABLE_JOBS_APPLY,"APPLY");
		studentPlacementAvailableJobsPrivileges.add(FPCONSTANTS.SP_M11_F_AVAILABLE_JOBS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PLACEMENT_AVAILABLE_JOBS_PRIVILEGES", studentPlacementAvailableJobsPrivileges);
		
		studentPlacementAppliedJobsPrivileges = new Ext.util.HashMap();
		studentPlacementAppliedJobsPrivileges.add(FPCONSTANTS.SP_M11_F_APPLIED_JOBS_UPLOADRESUME,"UPLOADRESUME");
		studentPlacementAppliedJobsPrivileges.add(FPCONSTANTS.SP_M11_F_APPLIED_JOBS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PLACEMENT_APPLIED_JOBS_PRIVILEGES", studentPlacementAppliedJobsPrivileges);
		
		studentPlacementDrivePrivileges = new Ext.util.HashMap();
		studentPlacementDrivePrivileges.add(FPCONSTANTS.SP_M11_F_PLACEMENTDRIVE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PLACEMENT_DRIVE_PRIVILEGES", studentPlacementDrivePrivileges);
		
		generateHallTicketPrivileges=new Ext.util.HashMap();
//		generateHallTicketPrivileges.add(FPCONSTANTS.PC_M5_F_GENERATE_HALL_TICKET_VIEW,"VIEW");
		generateHallTicketPrivileges.add(FPCONSTANTS.PC_M5_F_GENERATE_HALL_TICKET_EXPORT,"EXPORT");
		generateHallTicketPrivileges.add(FPCONSTANTS.PC_M5_F_GENERATE_HALL_TICKET_APPROVE, "APPROVE");
		generateHallTicketPrivileges.add(FPCONSTANTS.PC_M5_F_GENERATE_HALL_TICKET_WITHDRAWN, "WITHDRAWN");
		generateHallTicketPrivileges.add(FPCONSTANTS.PC_M5_F_GENERATE_HALL_TICKET_HALLTICKETGENERATION, "HALLTICKETGENERATION");
		generateHallTicketPrivileges.add(FPCONSTANTS.PC_M5_F_GENERATE_HALL_TICKET_REGENERATE_HALL_TICKET, "REGENERATE_HALL_TICKET");
		generateHallTicketPrivileges.add(FPCONSTANTS.PC_M5_F_GENERATE_HALL_TICKET_PUBLISH_HALL_TICKET, "PUBLISH_HALL_TICKET");
		generateHallTicketPrivileges.add(FPCONSTANTS.PC_M5_F_GENERATE_HALL_TICKET_DOWNLOAD_ALL_HALL_TICKET, "DOWNLOAD_ALL_HALL_TICKET");
		generateHallTicketPrivileges.add(FPCONSTANTS.PC_M5_F_GENERATE_HALL_TICKET_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("GENERATE_HALL_TICKET_PRIVILEGES", generateHallTicketPrivileges);
		
		visiotorManagePrivileges=new Ext.util.HashMap();
		visiotorManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_VISITORS_VIEW,"VIEW");
		visiotorManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_VISITORS_CREATE, "CREATE");
		visiotorManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_VISITORS_UPDATE, "UPDATE");
		visiotorManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_VISITORS_DELETE, "DELETE");
		visiotorManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_VISITORS_EXPORT, "EXPORT");
		visiotorManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_VISITORS_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		visiotorManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_VISITORS_MOREACTION, "MOREACTIONS");
		visiotorManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_VISITORS_PRINT_DOCUMENTS, "PRINT_DOCUMENTS");
		featurePrivilegesMap.add("VISITOR_MANAGE_PRIVILEGES", visiotorManagePrivileges);
		
		appointmentManagePrivileges=new Ext.util.HashMap();
		appointmentManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_APPOINTMENTS_VIEW,"VIEW");
		appointmentManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_APPOINTMENTS_CREATE, "CREATE");
		appointmentManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_APPOINTMENTS_UPDATE, "UPDATE");
		appointmentManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_APPOINTMENTS_DELETE, "DELETE");
		appointmentManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_APPOINTMENTS_EXPORT, "EXPORT");
		appointmentManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_APPOINTMENTS_FOLLOW_UP_DETAILS, "FOLLOW_UP_DETAILS");
		appointmentManagePrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_APPOINTMENTS_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPOINTMENT_MANAGE_PRIVILEGES", appointmentManagePrivileges);
		
		facultyGalleryPrivileges=new Ext.util.HashMap();
		facultyGalleryPrivileges.add(FPCONSTANTS.FP_M7_F_MANAGE_GALLERY_VIEW,"VIEW");
		facultyGalleryPrivileges.add(FPCONSTANTS.FP_M7_F_MANAGE_GALLERY_VIEW_ALBUM_DETAILS,"VIEW_ALBUM_DETAILS");
		facultyGalleryPrivileges.add(FPCONSTANTS.FP_M7_F_MANAGE_GALLERY_ADD_FOLDER,"ADD_FOLDER");
		facultyGalleryPrivileges.add(FPCONSTANTS.FP_M7_F_MANAGE_GALLERY_ADD_FILE,"ADD_FILE");
		facultyGalleryPrivileges.add(FPCONSTANTS.FP_M7_F_MANAGE_GALLERY_SHARE_FOLDER,"SHARE_FOLDER");
		facultyGalleryPrivileges.add(FPCONSTANTS.FP_M7_F_MANAGE_GALLERY_DELETE_FOLDER,"DELETE_FOLDER");
		facultyGalleryPrivileges.add(FPCONSTANTS.FP_M7_F_MANAGE_GALLERY_DELETE_FILE,"DELETE_FILE");
		facultyGalleryPrivileges.add(FPCONSTANTS.FP_M7_F_MANAGE_GALLERY_EDIT_DETAILS,"EDIT_DETAILS");
		facultyGalleryPrivileges.add(FPCONSTANTS.FP_M7_F_MANAGE_GALLERY_EDIT_LINKS,"EDIT_LINKS");
		featurePrivilegesMap.add("FACULTY_GALLERY_PRIVILEGES", facultyGalleryPrivileges);
		
		facultyanalyticsSubMenu7Report1Privileges = new Ext.util.HashMap();
		facultyanalyticsSubMenu7Report1Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT1_VIEW, "VIEW");
		facultyanalyticsSubMenu7Report1Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT1_RELOAD_BUTTON, "REFRESH");
		facultyanalyticsSubMenu7Report1Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT1_EDIT_BUTTON, "EDIT");
		facultyanalyticsSubMenu7Report1Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT1_PRINT_BUTTON, "PRINT");
		facultyanalyticsSubMenu7Report1Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT1_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("FACULTY_ANALYTICS_SUBMENU7_REPORT1_PRIVILEGES", facultyanalyticsSubMenu7Report1Privileges);
		
		facultyanalyticsSubMenu7Report2Privileges = new Ext.util.HashMap();
		facultyanalyticsSubMenu7Report2Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT2_VIEW, "VIEW");
		facultyanalyticsSubMenu7Report2Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT2_RELOAD_BUTTON, "REFRESH");
		facultyanalyticsSubMenu7Report2Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT2_EDIT_BUTTON, "EDIT");
		facultyanalyticsSubMenu7Report2Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT2_PRINT_BUTTON, "PRINT");
		facultyanalyticsSubMenu7Report2Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT2_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("FACULTY_ANALYTICS_SUBMENU7_REPORT2_PRIVILEGES", facultyanalyticsSubMenu7Report2Privileges);
		
		facultyanalyticsSubMenu7Report3Privileges = new Ext.util.HashMap();
		facultyanalyticsSubMenu7Report3Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT3_VIEW, "VIEW");
		facultyanalyticsSubMenu7Report3Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT3_RELOAD_BUTTON, "REFRESH");
		facultyanalyticsSubMenu7Report3Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT3_EDIT_BUTTON, "EDIT");
		facultyanalyticsSubMenu7Report3Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT3_PRINT_BUTTON, "PRINT");
		facultyanalyticsSubMenu7Report3Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT3_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("FACULTY_ANALYTICS_SUBMENU7_REPORT3_PRIVILEGES", facultyanalyticsSubMenu7Report3Privileges);
		
		facultyanalyticsSubMenu7Report4Privileges = new Ext.util.HashMap();
		facultyanalyticsSubMenu7Report4Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT4_VIEW, "VIEW");
		facultyanalyticsSubMenu7Report4Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT4_RELOAD_BUTTON, "REFRESH");
		facultyanalyticsSubMenu7Report4Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT4_EDIT_BUTTON, "EDIT");
		facultyanalyticsSubMenu7Report4Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT4_PRINT_BUTTON, "PRINT");
		facultyanalyticsSubMenu7Report4Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT4_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("FACULTY_ANALYTICS_SUBMENU7_REPORT4_PRIVILEGES", facultyanalyticsSubMenu7Report4Privileges);
		
		facultyanalyticsSubMenu7Report5Privileges = new Ext.util.HashMap();
		facultyanalyticsSubMenu7Report5Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT5_VIEW, "VIEW");
		facultyanalyticsSubMenu7Report5Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT5_RELOAD_BUTTON, "REFRESH");
		facultyanalyticsSubMenu7Report5Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT5_EDIT_BUTTON, "EDIT");
		facultyanalyticsSubMenu7Report5Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT5_PRINT_BUTTON, "PRINT");
		facultyanalyticsSubMenu7Report5Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT5_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("FACULTY_ANALYTICS_SUBMENU7_REPORT5_PRIVILEGES", facultyanalyticsSubMenu7Report5Privileges);
		
		facultyanalyticsSubMenu7Report6Privileges = new Ext.util.HashMap();
		facultyanalyticsSubMenu7Report6Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT6_VIEW, "VIEW");
		facultyanalyticsSubMenu7Report6Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT6_RELOAD_BUTTON, "REFRESH");
		facultyanalyticsSubMenu7Report6Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT6_EDIT_BUTTON, "EDIT");
		facultyanalyticsSubMenu7Report6Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT6_PRINT_BUTTON, "PRINT");
		facultyanalyticsSubMenu7Report6Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT6_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("FACULTY_ANALYTICS_SUBMENU7_REPORT6_PRIVILEGES", facultyanalyticsSubMenu7Report6Privileges);
		
		facultyanalyticsSubMenu7Report7Privileges = new Ext.util.HashMap();
		facultyanalyticsSubMenu7Report7Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT7_VIEW, "VIEW");
		facultyanalyticsSubMenu7Report7Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT7_RELOAD_BUTTON, "REFRESH");
		facultyanalyticsSubMenu7Report7Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT7_EDIT_BUTTON, "EDIT");
		facultyanalyticsSubMenu7Report7Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT7_PRINT_BUTTON, "PRINT");
		facultyanalyticsSubMenu7Report7Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT7_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("FACULTY_ANALYTICS_SUBMENU7_REPORT7_PRIVILEGES", facultyanalyticsSubMenu7Report7Privileges);
		
		facultyanalyticsSubMenu7Report8Privileges = new Ext.util.HashMap();
		facultyanalyticsSubMenu7Report8Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT8_VIEW, "VIEW");
		facultyanalyticsSubMenu7Report8Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT8_RELOAD_BUTTON, "REFRESH");
		facultyanalyticsSubMenu7Report8Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT8_EDIT_BUTTON, "EDIT");
		facultyanalyticsSubMenu7Report8Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT8_PRINT_BUTTON, "PRINT");
		facultyanalyticsSubMenu7Report8Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT8_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("FACULTY_ANALYTICS_SUBMENU7_REPORT8_PRIVILEGES", facultyanalyticsSubMenu7Report8Privileges);
		
		facultyanalyticsSubMenu7Report9Privileges = new Ext.util.HashMap();
		facultyanalyticsSubMenu7Report9Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT9_VIEW, "VIEW");
		facultyanalyticsSubMenu7Report9Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT9_RELOAD_BUTTON, "REFRESH");
		facultyanalyticsSubMenu7Report9Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT9_EDIT_BUTTON, "EDIT");
		facultyanalyticsSubMenu7Report9Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT9_PRINT_BUTTON, "PRINT");
		facultyanalyticsSubMenu7Report9Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT9_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("FACULTY_ANALYTICS_SUBMENU7_REPORT9_PRIVILEGES", facultyanalyticsSubMenu7Report9Privileges);
		
		facultyanalyticsSubMenu7Report10Privileges = new Ext.util.HashMap();
		facultyanalyticsSubMenu7Report10Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT10_VIEW, "VIEW");
		facultyanalyticsSubMenu7Report10Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT10_RELOAD_BUTTON, "REFRESH");
		facultyanalyticsSubMenu7Report10Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT10_EDIT_BUTTON, "EDIT");
		facultyanalyticsSubMenu7Report10Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT10_PRINT_BUTTON, "PRINT");
		facultyanalyticsSubMenu7Report10Privileges.add(FPCONSTANTS.FP_SUBMENU7_REPORT10_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("FACULTY_ANALYTICS_SUBMENU7_REPORT10_PRIVILEGES", facultyanalyticsSubMenu7Report10Privileges);
		
		
		studentGalleryPrivileges=new Ext.util.HashMap();
		studentGalleryPrivileges.add(FPCONSTANTS.SP_M9_F_MANAGE_GALLERY_VIEW,"VIEW");
		studentGalleryPrivileges.add(FPCONSTANTS.SP_M9_F_MANAGE_GALLERY_VIEW_ALBUM_DETAILS,"VIEW_ALBUM_DETAILS");
		featurePrivilegesMap.add("STUDENT_GALLERY_PRIVILEGES", studentGalleryPrivileges);
		
		parentGalleryPrivileges=new Ext.util.HashMap();
		parentGalleryPrivileges.add(FPCONSTANTS.PP_M9_F_MANAGE_GALLERY_VIEW,"VIEW");
		parentGalleryPrivileges.add(FPCONSTANTS.PP_M9_F_MANAGE_GALLERY_VIEW_ALBUM_DETAILS,"VIEW_ALBUM_DETAILS");
		featurePrivilegesMap.add("PARENT_GALLERY_PRIVILEGES", parentGalleryPrivileges);
		
		frontDeskManagementPrivileges=new Ext.util.HashMap();
		frontDeskManagementPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_ITEM_ENTRIES_VIEW,"VIEW");
		frontDeskManagementPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_ITEM_ENTRIES_CREATE, "CREATE");
		frontDeskManagementPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_ITEM_ENTRIES_UPDATE, "UPDATE");
		frontDeskManagementPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_ITEM_ENTRIES_DELETE, "DELETE");
		frontDeskManagementPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_ITEM_ENTRIES_EXPORT, "EXPORT");
		frontDeskManagementPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_ITEM_ENTRIES_UPDATE_STATUS, "UPDATESTATUS");
		frontDeskManagementPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_ITEM_ENTRIES_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("FRONT_DESK_MANAGEMENT_PRIVILEGES", frontDeskManagementPrivileges);
		
		examRoomWiseAttendance=new Ext.util.HashMap();
		examRoomWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_ROOM_WISE_ATTENDANCE_CREATE,"CREATE");
		examRoomWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_ROOM_WISE_ATTENDANCE_EXPORT, "EXPORT");
		examRoomWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_ROOM_WISE_ATTENDANCE_MARK_ALL_PRESENT, "MARKALLPRESENT");
		examRoomWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_ROOM_WISE_ATTENDANCE_MARK_ALL_ABSENT, "MARKALLABSENT");
		examRoomWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_ROOM_WISE_ATTENDANCE_GENERATE_REPORT, "GENERATEREPORT");
		featurePrivilegesMap.add("EXAM_ROOM_WISE_ATTENDANCE_PRIVILEGES", examRoomWiseAttendance);

		examPlanWiseAttendance=new Ext.util.HashMap();
		examPlanWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_PLAN_WISE_ATTENDANCE_CREATE,"CREATE");
		examPlanWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_PLAN_WISE_ATTENDANCE_EXPORT, "EXPORT");
		examPlanWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_PLAN_WISE_ATTENDANCE_MARK_ALL_PRESENT, "MARKALLPRESENT");
		examPlanWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_PLAN_WISE_ATTENDANCE_MARK_ALL_ABSENT, "MARKALLABSENT");
		examPlanWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_PLAN_WISE_ATTENDANCE_GENERATE_REPORT, "GENERATEREPORT");
		examPlanWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_PLAN_WISE_ATTENDANCE_MARK_ATTENDANCE_AS_A_HOST_FACULTY, "MARK_ATTENDANCE_AS_A_HOST_FACULTY");
		featurePrivilegesMap.add("EXAM_PLAN_WISE_ATTENDANCE_PRIVILEGES", examPlanWiseAttendance);

		examStudentWiseAttendance=new Ext.util.HashMap();
		examStudentWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_STUDENT_WISE_ATTENDANCE_CREATE,"CREATE");
		examStudentWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_STUDENT_WISE_ATTENDANCE_EXPORT, "EXPORT");
		examStudentWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_STUDENT_WISE_ATTENDANCE_MARK_ALL_PRESENT, "MARKALLPRESENT");
		examStudentWiseAttendance.add(FPCONSTANTS.PC_M5_F_EXAM_STUDENT_WISE_ATTENDANCE_MARK_ALL_ABSENT, "MARKALLABSENT");
		featurePrivilegesMap.add("EXAM_STUDENT_WISE_ATTENDANCE_PRIVILEGES", examStudentWiseAttendance);

		examAttestationForm=new Ext.util.HashMap();
		examAttestationForm.add(FPCONSTANTS.PC_M5_F_EXAM_ATTESTATION_FORM_EXPORT,"EXPORT");
		examAttestationForm.add(FPCONSTANTS.PC_M5_F_EXAM_ATTESTATION_FORM_GENERATE_ATT_FORM, "GENERATEATTFORM");
		examAttestationForm.add(FPCONSTANTS.PC_M5_F_EXAM_ATTESTATION_FORM_REGENERATE_ATT_FORM, "REGENERATEATTFORM");
		examAttestationForm.add(FPCONSTANTS.PC_M5_F_EXAM_ATTESTATION_FORM_DOWNLOAD_ATT_FORM, "DOWNLOADATTFORM");
		featurePrivilegesMap.add("EXAM_ATTESTATION_FORM_PRIVILEGES", examAttestationForm);

		examStudentRollList=new Ext.util.HashMap();
		examStudentRollList.add(FPCONSTANTS.PC_M5_F_EXAM_STUDENT_ROLL_LIST_EXPORT,"EXPORT");
		examStudentRollList.add(FPCONSTANTS.PC_M5_F_EXAM_STUDENT_ROLL_LIST_GENERATE_ROLL_LIST, "GENERATEROLLLIST");
		examStudentRollList.add(FPCONSTANTS.PC_M5_F_EXAM_STUDENT_ROLL_LIST_REGENERATE_ROLL_LIST, "REGENERATEROLLLIST");
		featurePrivilegesMap.add("EXAM_STUDENT_ROLL_LIST_PRIVILEGES", examStudentRollList);
		
		frontDeskManagementEmpPortalPrivileges=new Ext.util.HashMap();
		frontDeskManagementEmpPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MY_COURIERS_VIEW, "VIEW");
		frontDeskManagementEmpPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MY_COURIERS_EXPORT, "EXPORT");
		frontDeskManagementEmpPortalPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MY_COURIERS_UPDATE_ACKNOWLEDGEMENT_STATUS, "UPDATE_ACKNOWLEDGEMENT_STATUS");
		featurePrivilegesMap.add("FRONT_DESK_MANAGEMENT_EMP_PORTAL_PRIVILEGES", frontDeskManagementEmpPortalPrivileges);
		
		employeeMyLeavePrivileges=new Ext.util.HashMap();
		employeeMyLeavePrivileges.add(FPCONSTANTS.FP_M9_F_MY_LEAVE_REPORT_VIEW, "VIEW");
		employeeMyLeavePrivileges.add(FPCONSTANTS.FP_M9_F_MY_LEAVE_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("EMPLOYEE_MY_LEAVE_PRIVILEGES", employeeMyLeavePrivileges);

		facultyIdentityCard=new Ext.util.HashMap();
		facultyIdentityCard.add(FPCONSTANTS.PF_M8_F_FACULTY_IDENTITY_CARDS_VIEW,"VIEW");
		facultyIdentityCard.add(FPCONSTANTS.PF_M8_F_FACULTY_IDENTITY_CARDS_CREATE, "CREATE");
		facultyIdentityCard.add(FPCONSTANTS.PF_M8_F_FACULTY_IDENTITY_CARDS_UPDATE, "UPDATE");
		facultyIdentityCard.add(FPCONSTANTS.PF_M8_F_FACULTY_IDENTITY_CARDS_DELETE, "DELETE");
		facultyIdentityCard.add(FPCONSTANTS.PF_M8_F_FACULTY_IDENTITY_CARDS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("FACULTY_IDENTITY_CARD_PRIVILEGES", facultyIdentityCard);
		
		studentManageComplaintPrivileges=new Ext.util.HashMap();
		//studentManageComplaintPrivileges.add(FPCONSTANTS.SP_M7_F_MANAGE_COMPLAINT_VIEW, "VIEW");
		studentManageComplaintPrivileges.add(FPCONSTANTS.SP_M7_F_MANAGE_COMPLAINT_EXPORT, "EXPORT");
		studentManageComplaintPrivileges.add(FPCONSTANTS.SP_M7_F_MANAGE_COMPLAINT_FOLLOWUP_DETAILS, "FOLLOWUP_DETAILS");
		featurePrivilegesMap.add("STUDENT_MANAGE_COMPLAINT_PRIVILEGES", studentManageComplaintPrivileges);
		
		enrollmentSummaryReportPrivileges=new Ext.util.HashMap();
		enrollmentSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_F_ENROLLMENT_SUMMARY_REPORT_VIEW, "VIEW");
		enrollmentSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_F_ENROLLMENT_SUMMARY_REPORT_EXPORT, "EXPORT");
		enrollmentSummaryReportPrivileges.add(FPCONSTANTS.PC_M4_F_ENROLLMENT_SUMMARY_REPORT_EXPORT_REPORTS, "EXPORT_REPORTS");
		featurePrivilegesMap.add("ENROLLMENT_SUMMARY_REPORT_PRIVILEGES", enrollmentSummaryReportPrivileges);
		
		studentportalExamDocumentsHallTicketPrivileges=new Ext.util.HashMap();
		studentportalExamDocumentsHallTicketPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_DOCUMENTS_HALL_TICKET_VIEW, "VIEW");
		/*studentportalExamDocumentsHallTicketPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_DOCUMENTS_HALL_TICKET_EXPORT, "EXPORT");*/
		studentportalExamDocumentsHallTicketPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_DOCUMENTS_HALL_TICKET_DOWNLOADALLHALLTICKET, "DOWNLOADALLHALLTICKET");
		featurePrivilegesMap.add("STUDENT_PORTAL_EXAM_DOCUMENTS_HALL_TICKET_PRIVILEGES", studentportalExamDocumentsHallTicketPrivileges);
		
		studentPortalExamDocumentsMarkseetsPrivileges=new Ext.util.HashMap();
		studentPortalExamDocumentsMarkseetsPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_DOCUMENTS_MARKSHEETS_VIEW, "VIEW");
		/*studentPortalExamDocumentsMarkseetsPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_DOCUMENTS_MARKSHEETS_EXPORT, "EXPORT");*/
		studentPortalExamDocumentsMarkseetsPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_DOCUMENTS_MARKSHEETS_DOWNLOADMARKSHEETS, "DOWNLOADMARKSHEETS");
		featurePrivilegesMap.add("STUDENT_PORTAL_EXAM_DOCUMENTS_MARKSHEETS_PRIVILEGES", studentPortalExamDocumentsMarkseetsPrivileges);
		
		studentportalExamDocumentsPrivileges=new Ext.util.HashMap();
		studentportalExamDocumentsPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_DOCUMENTS_VIEW, "VIEW");
		featurePrivilegesMap.add("STUDENT_PORTAL_EXAM_DOCUMENTS_PRIVILEGES", studentportalExamDocumentsPrivileges);
			
		studentPortalCourseRegistrationPrivileges=new Ext.util.HashMap();
		studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_VIEW, "VIEW");
		studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_EXPORT, "EXPORT");
		studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_ENROLL, "ENROLL");
		studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_UNENROLL, "UNENROLL");
		studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_DELETEENROLL, "DELETEENROLL");
		studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_PERIODDETAILS, "PERIODDETAILS");
		studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_BULK_ENROL, "BULK_ENROL");
		studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_PROOF_OF_REGISTRATION, "PROOF_OF_REGISTRATION");
		studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_PAY_AND_ENROLL, "PAY_AND_ENROLL");
		studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_DETAILED_TIMETABLE, "DETAILED_TIMETABLE");
		studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_PAYMENT_DETAILS, "PAYMENT_DETAILS");
		featurePrivilegesMap.add("STUDENT_PORTAL_COURSE_REGISTRATION_PRIVILEGES", studentPortalCourseRegistrationPrivileges);
		
		studentPortalFeeRequest=new Ext.util.HashMap();
		studentPortalFeeRequest.add(FPCONSTANTS.SP_M11_FEE_REQUEST_VIEW, "VIEW");
		studentPortalFeeRequest.add(FPCONSTANTS.SP_M11_FEE_REQUEST_RAISEREQUEST, "RAISEREQUEST");
		featurePrivilegesMap.add("STUDENT_PORTAL_FEE_REQUEST_PRIVILEGES", studentPortalFeeRequest);
		
		manageSpecialGradePrivileges=new Ext.util.HashMap();
		manageSpecialGradePrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_SPECIAL_GRADE_VIEW, "VIEW");
		manageSpecialGradePrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_SPECIAL_GRADE_EXPORT, "EXPORT");
		manageSpecialGradePrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_SPECIAL_GRADE_GRADESUBMISSION, "GRADESUBMISSION");
		manageSpecialGradePrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_SPECIAL_GRADE_DELETE, "DELETE");
		manageSpecialGradePrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_SPECIAL_GRADE_IMPORT_BULK_SPECIAL_GRADE, "IMPORT_BULK_SPECIAL_GRADE");
		
		
		featurePrivilegesMap.add("MANAGE_SPECIAL_GRADE_PRIVILEGES", manageSpecialGradePrivileges);
		
		enquiryImportUtilityPrivileges=new Ext.util.HashMap();
		enquiryImportUtilityPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRYIMPORTUTILITY_VIEW, "VIEW");
		featurePrivilegesMap.add("ENQUIRY_IMPORT_UTILITY_PRIVILEGES", enquiryImportUtilityPrivileges);
		
		applicationsAdmissionImportBulkUtilityPrivileges=new Ext.util.HashMap();
		applicationsAdmissionImportBulkUtilityPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONSADMISSIONBULKIMPORTUTILITY_VIEW, "IMPORT_BULK_ADMISSION");
		featurePrivilegesMap.add("APPLICATIONS_ADMISSION_IMPORT_UTILITY_PRIVILEGES", applicationsAdmissionImportBulkUtilityPrivileges);
		
		receiptImportTabPrivileges=new Ext.util.HashMap();
		receiptImportTabPrivileges.add(FPCONSTANTS.PC_M6_F_RECEIPT_BULK_IMPORT_UTILITY_VIEW, "IMPORT_BULK_RECIEPTS");
		receiptImportTabPrivileges.add(FPCONSTANTS.PC_M6_F_RECEIPT_BULK_IMPORT_UTILITY_MAP_ACADEMY_LOCATION, "MAP_ACADEMY_LOCATIONS");
		featurePrivilegesMap.add("RECEIPT_BULK_IMPORT_UTILITY_PRIVILEGES", receiptImportTabPrivileges);
		
		billImportTabPrivileges=new Ext.util.HashMap();
		billImportTabPrivileges.add(FPCONSTANTS.PC_M6_F_BILL_BULK_IMPORT_UTILITY, "IMPORT_BULK_BILLS");
		featurePrivilegesMap.add("BILL_BULK_IMPORT_UTILITY_PRIVILEGES", billImportTabPrivileges);
		
		personCoveredImportTabPrivileges=new Ext.util.HashMap();
		personCoveredImportTabPrivileges.add(FPCONSTANTS.PC_M6_F_PERSON_COVERED_BULK_IMPORT_UTILITY, "IMPORT_BULK_PERSON_COVERED");
		personCoveredImportTabPrivileges.add(FPCONSTANTS.PC_M6_F_PERSON_COVERED_BULK_IMPORT_UTILITY_IMPORT_FEE_PLAN, "IMPORT_FEE_PLAN");
		personCoveredImportTabPrivileges.add(FPCONSTANTS.PC_M6_F_PERSON_COVERED_BULK_IMPORT_UTILITY_IMPORT_PERSON_COVERED_UPDATES, "IMPORT_PERSON_COVERED_UPDATES");
		featurePrivilegesMap.add("PERSON_COVERED_BULK_IMPORT_UTILITY_PRIVILEGES", personCoveredImportTabPrivileges);
		
		facultyCourseExecutionReport=new Ext.util.HashMap();
		facultyCourseExecutionReport.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_EXECUTION_VIEW, "VIEW");
		facultyCourseExecutionReport.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_EXECUTION_EXPORT, "EXPORT");
		facultyCourseExecutionReport.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_EXECUTION_PROGRAM_BATCH_SECTION,"PROGRAM_BATCH_SECTION");
		facultyCourseExecutionReport.add(FPCONSTANTS.FP_M9_F_FACULTY_COURSE_EXECUTION_COURSE_SECTION,"COURSE_SECTION");
		featurePrivilegesMap.add("FACULTY_COURSE_EXECUTION_PRIVILEGES", facultyCourseExecutionReport);
		
		studentTimeTablePrivileges=new Ext.util.HashMap();
		studentTimeTablePrivileges.add(FPCONSTANTS.SP_M4_F_VIEW_MASTER_SCHEDULE_VIEW, "VIEW");
		studentTimeTablePrivileges.add(FPCONSTANTS.SP_M4_F_VIEW_MASTER_SCHEDULE_PRINT, "PRINT");
		featurePrivilegesMap.add("STUDENT_TIMETABLE_PRIVILEGES", studentTimeTablePrivileges);
		
		consolidatedAttendanceReport=new Ext.util.HashMap();
		consolidatedAttendanceReport.add(FPCONSTANTS.PC_M4_R_CONSOLIDATED_ATTENDANCE_REPORT_UPDATE, "UPDATE");
		consolidatedAttendanceReport.add(FPCONSTANTS.PC_M4_R_CONSOLIDATED_ATTENDANCE_REPORT_DELETE, "DELETE");
		consolidatedAttendanceReport.add(FPCONSTANTS.PC_M4_R_CONSOLIDATED_ATTENDANCE_REPORT_EXPORT, "EXPORT");
		consolidatedAttendanceReport.add(FPCONSTANTS.PC_M4_R_CONSOLIDATED_ATTENDANCE_REPORT_PROGRAM_WISE, "PROGRAM_WISE");
		consolidatedAttendanceReport.add(FPCONSTANTS.PC_M4_R_CONSOLIDATED_ATTENDANCE_REPORT_COURSE_WISE, "COURSE_WISE");
		consolidatedAttendanceReport.add(FPCONSTANTS.PC_M4_R_CONSOLIDATED_ATTENDANCE_REPORT_SESSION_WISE, "SESSION_WISE");
		consolidatedAttendanceReport.add(FPCONSTANTS.PC_M4_R_CONSOLIDATED_ATTENDANCE_REPORT_VIEW, "VIEW");
		consolidatedAttendanceReport.add(FPCONSTANTS.PC_M4_R_CONSOLIDATED_ATTENDANCE_REPORT_GRID_CONFIGURATION, "GRID_CONFIGURATION"); 

		featurePrivilegesMap.add("CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES", consolidatedAttendanceReport);
		
		facultyConsolidatedAttendanceReport=new Ext.util.HashMap();
		facultyConsolidatedAttendanceReport.add(FPCONSTANTS.FP_M9_F_CONSOLIDATED_ATTENDANCE_REPORT_UPDATE, "UPDATE");
		facultyConsolidatedAttendanceReport.add(FPCONSTANTS.FP_M9_F_CONSOLIDATED_ATTENDANCE_REPORT_DELETE, "DELETE");
		facultyConsolidatedAttendanceReport.add(FPCONSTANTS.FP_M9_F_CONSOLIDATED_ATTENDANCE_REPORT_EXPORT, "EXPORT");
		facultyConsolidatedAttendanceReport.add(FPCONSTANTS.FP_M9_F_CONSOLIDATED_ATTENDANCE_REPORT_PROGRAM_WISE, "PROGRAM_WISE");
		facultyConsolidatedAttendanceReport.add(FPCONSTANTS.FP_M9_F_CONSOLIDATED_ATTENDANCE_REPORT_COURSE_WISE, "COURSE_WISE");
		facultyConsolidatedAttendanceReport.add(FPCONSTANTS.FP_M9_F_CONSOLIDATED_ATTENDANCE_REPORT_SESSION_WISE, "SESSION_WISE");
		facultyConsolidatedAttendanceReport.add(FPCONSTANTS.FP_M9_F_CONSOLIDATED_ATTENDANCE_REPORT_VIEW, "VIEW");
		facultyConsolidatedAttendanceReport.add(FPCONSTANTS.FP_M9_F_CONSOLIDATED_ATTENDANCE_REPORT_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_CONSOLIDATED_ATTENDANCE_REPORT_PRIVILEGES", facultyConsolidatedAttendanceReport);
		
		pendingAttendanceReport=new Ext.util.HashMap();
		pendingAttendanceReport.add(FPCONSTANTS.PC_M4_R_PENDING_ATTENDANCE_REPORT_EXPORT, "EXPORT");
		pendingAttendanceReport.add(FPCONSTANTS.PC_M4_R_PENDING_ATTENDANCE_REPORT_PROGRAM_WISE, "PROGRAM_WISE");
		pendingAttendanceReport.add(FPCONSTANTS.PC_M4_R_PENDING_ATTENDANCE_REPORT_COURSE_WISE, "COURSE_WISE");
		pendingAttendanceReport.add(FPCONSTANTS.PC_M4_R_PENDING_ATTENDANCE_REPORT_SESSION_WISE, "SESSION_WISE");
		
		pendingAttendanceReport.add(FPCONSTANTS.PC_M4_R_PENDING_ATTENDANCE_REPORT_GRID_CONFIGURATION, "GRID_CONFIGURATION"); 
		featurePrivilegesMap.add("PENDING_ATTENDANCE_REPORT_PRIVILEGES", pendingAttendanceReport);
		
		pendingAttendanceDateReport=new Ext.util.HashMap();
		pendingAttendanceDateReport.add(FPCONSTANTS.PC_M4_R_ATTENDANCE_PENDING_DATE_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("PENDING_ATTENDANCE_DATES_PRIVILEGES", pendingAttendanceDateReport);
		
		facultyPendingAttendanceReport=new Ext.util.HashMap();
		facultyPendingAttendanceReport.add(FPCONSTANTS.FP_M9_F_PENDING_ATTENDANCE_REPORT_EXPORT, "EXPORT");
		facultyPendingAttendanceReport.add(FPCONSTANTS.FP_M9_F_PENDING_ATTENDANCE_REPORT_PROGRAM_WISE, "PROGRAM_WISE");
		facultyPendingAttendanceReport.add(FPCONSTANTS.FP_M9_F_PENDING_ATTENDANCE_REPORT_COURSE_WISE, "COURSE_WISE");
		facultyPendingAttendanceReport.add(FPCONSTANTS.FP_M9_F_PENDING_ATTENDANCE_REPORT_SESSION_WISE, "SESSION_WISE");
		featurePrivilegesMap.add("FACULTY_PENDING_ATTENDANCE_REPORT_PRIVILEGES", facultyPendingAttendanceReport);
		
		facultyPendingAttendanceDateReport=new Ext.util.HashMap();
		facultyPendingAttendanceDateReport.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_PENDING_DATE_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("FACULTY_PENDING_ATTENDANCE_DATES_PRIVILEGES", facultyPendingAttendanceDateReport);
		
		facultyAttendanceReports=new Ext.util.HashMap();
		facultyAttendanceReports.add(FPCONSTANTS.FP_M9_F_FACULTY_ATTENDANCE_REPORT_VIEW, "VIEW");
		featurePrivilegesMap.add("FACULTY_ATTENDANCE_REPORT_PRIVILEGES", facultyAttendanceReports);
		
		studentWiseAttendanceReport=new Ext.util.HashMap();
		studentWiseAttendanceReport.add(FPCONSTANTS.PC_M4_R_STUDENT_WSIE_ATTENDANCE_REPORT_EXPORT, "EXPORT");
		studentWiseAttendanceReport.add(FPCONSTANTS.PC_M4_R_STUDENT_WSIE_ATTENDANCE_REPORT_UPDATE, "UPDATE");
		studentWiseAttendanceReport.add(FPCONSTANTS.PC_M4_R_STUDENT_WSIE_ATTENDANCE_REPORT_DELETE, "DELETE");
		studentWiseAttendanceReport.add(FPCONSTANTS.PC_M4_R_STUDENT_WSIE_ATTENDANCE_REPORT_PROGRAM_WISE, "PROGRAM_WISE");
		studentWiseAttendanceReport.add(FPCONSTANTS.PC_M4_R_STUDENT_WSIE_ATTENDANCE_REPORT_COURSE_WISE, "COURSE_WISE");
		studentWiseAttendanceReport.add(FPCONSTANTS.PC_M4_R_STUDENT_WSIE_ATTENDANCE_REPORT_SESSION_WISE, "SESSION_WISE");
		studentWiseAttendanceReport.add(FPCONSTANTS.PC_M4_R_STUDENT_WSIE_ATTENDANCE_REPORT_PRESENT, "PRESENT");
		studentWiseAttendanceReport.add(FPCONSTANTS.PC_M4_R_STUDENT_WSIE_ATTENDANCE_REPORT_ABSENT, "ABSENT");
		studentWiseAttendanceReport.add(FPCONSTANTS.PC_M4_R_STUDENT_WSIE_ATTENDANCE_REPORT_LEAVE, "LEAVE");
		studentWiseAttendanceReport.add(FPCONSTANTS.PC_M4_R_STUDENT_WSIE_ATTENDANCE_REPORT_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_WISE_ATTENDANCE_REPORT_PRIVILEGES", studentWiseAttendanceReport);
		
		facultyStudentWiseAttendanceReport=new Ext.util.HashMap();
		facultyStudentWiseAttendanceReport.add(FPCONSTANTS.FP_M9_F_STUDENT_WSIE_ATTENDANCE_REPORT_EXPORT, "EXPORT");
		facultyStudentWiseAttendanceReport.add(FPCONSTANTS.FP_M9_F_STUDENT_WSIE_ATTENDANCE_REPORT_UPDATE, "UPDATE");
		facultyStudentWiseAttendanceReport.add(FPCONSTANTS.FP_M9_F_STUDENT_WSIE_ATTENDANCE_REPORT_DELETE, "DELETE");
		facultyStudentWiseAttendanceReport.add(FPCONSTANTS.FP_M9_F_STUDENT_WSIE_ATTENDANCE_REPORT_PROGRAM_WISE, "PROGRAM_WISE");
		facultyStudentWiseAttendanceReport.add(FPCONSTANTS.FP_M9_F_STUDENT_WSIE_ATTENDANCE_REPORT_COURSE_WISE, "COURSE_WISE");
		facultyStudentWiseAttendanceReport.add(FPCONSTANTS.FP_M9_F_STUDENT_WSIE_ATTENDANCE_REPORT_SESSION_WISE, "SESSION_WISE");
		facultyStudentWiseAttendanceReport.add(FPCONSTANTS.FP_M9_F_STUDENT_WSIE_ATTENDANCE_REPORT_PRESENT, "PRESENT");
		facultyStudentWiseAttendanceReport.add(FPCONSTANTS.FP_M9_F_STUDENT_WSIE_ATTENDANCE_REPORT_ABSENT, "ABSENT");
		facultyStudentWiseAttendanceReport.add(FPCONSTANTS.FP_M9_F_STUDENT_WSIE_ATTENDANCE_REPORT_LEAVE, "LEAVE");
		featurePrivilegesMap.add("FACULTY_STUDENT_WISE_ATTENDANCE_REPORT_PRIVILEGES", facultyStudentWiseAttendanceReport);
		
		facultyAttendanceSummaryReportPrivileges = new Ext.util.HashMap();
		facultyAttendanceSummaryReportPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_SUMMARY_REPORT_SENDSURVEY, "SENDSURVEY");
		facultyAttendanceSummaryReportPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_SUMMARY_REPORT_EXPORT, "EXPORT");
		/*facultyAttendanceSummaryReportPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_SUMMARY_REPORT_EXPORT_REPORT, "EXPORT_REPORT");*/
		facultyAttendanceSummaryReportPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_SUMMARY_REPORT_SENDMESSAGE, "SENDMESSAGE");
		facultyAttendanceSummaryReportPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_SUMMARY_REPORT_PROGRAM_WISE, "PROGRAM_WISE");
		facultyAttendanceSummaryReportPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_SUMMARY_REPORT_COURSE_WISE, "COURSE_WISE");
		facultyAttendanceSummaryReportPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_SUMMARY_REPORT_SESSION_WISE, "SESSION_WISE");
		facultyAttendanceSummaryReportPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_SUMMARY_REPORT_ADHOC_MESSAGE, "ADHOC_MESSAGE");
		facultyAttendanceSummaryReportPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_SUMMARY_REPORT_MESSAGE_TEMPLATE, "MESSAGE_TEMPLATE");
		facultyAttendanceSummaryReportPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_SUMMARY_REPORT_ATTENDANCE_REGISTER_BLANK, "ATTENDANCE_REGISTER_BLANK");
		facultyAttendanceSummaryReportPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_SUMMARY_REPORT_ATTENDANCE_REGISTER, "ATTENDANCE_REGISTER");
		facultyAttendanceSummaryReportPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_SUMMARY_REPORT_PROGRAM_AND_COURSE_WISE_REPORT, "PROGRAM_AND_COURSE_WISE_REPORT");
		featurePrivilegesMap.add("FACULTY_ATTENDANCE_SUMMARY_REPORT_PRIVILEGES", facultyAttendanceSummaryReportPrivileges);
		
		eventMeetingMinutesPrivileges=new Ext.util.HashMap();
		eventMeetingMinutesPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_MINUTES_VIEW,"VIEW");
		eventMeetingMinutesPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_MINUTES_CREATE, "CREATE");
		eventMeetingMinutesPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_MINUTES_UPDATE, "UPDATE");
		eventMeetingMinutesPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_MINUTES_DELETE, "DELETE");
		eventMeetingMinutesPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_MINUTES_EXPORT, "EXPORT");
		eventMeetingMinutesPrivileges.add(FPCONSTANTS.PC_M7_F_MANAGE_MINUTES_PRINT_MINUTE, "PRINT_MINUTE");
		featurePrivilegesMap.add("EVENT_MEETING_MINUTES_PRIVILEGES", eventMeetingMinutesPrivileges);
		
		eventMinuteReportsPrivileges=new Ext.util.HashMap();
		eventMinuteReportsPrivileges.add(FPCONSTANTS.PC_M7_R_MINUTE_REPORTS_VIEW,"VIEW");
		eventMinuteReportsPrivileges.add(FPCONSTANTS.PC_M7_R_MINUTE_REPORTS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("EVENT_MINUTE_REPORTS_PRIVILEGES", eventMinuteReportsPrivileges);
		
		facultyMarkEntryPrivileges=new Ext.util.HashMap();
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_VIEW,"VIEW");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_EXPORT,"EXPORT");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_UPDATE,"UPDATE");
		//createExaminationResultsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_MOREACTIONS,"MOREACTIONS");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_APPROVE,"APPROVE");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_SAVEBUTTON,"SAVEBUTTON");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_SUBMIT,"SUBMIT");
		//createExaminationResultsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_SENTFORAPPROVE,"SENTFORAPPROVE");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_IMPORT_BULK_MARKS,"IMPORT_BULK_MARKS");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_GRID_EDIT_BTN,"GRID_EDIT_BTN");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_GRID_VIEW_BTN,"GRID_VIEW_BTN");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_GENERATE_FOILS,"GENERATEFOILS");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_MARK_ATTENDANCE,"MARK_ATTENDANCE");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_ANONYMOUS_ASSESSMENT_EVENT,"ANONYMOUS_ASSESSMENT_EVENT");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_DELETEBUTTON,"DELETE");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_SET_DEFAULT_MARKS,"SET_DEFAULT_MARKS");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_SET_DEFAULT_GRADE,"SET_DEFAULT_GRADE");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_ENTER_REMARK,"ENTER_REMARK");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_PUBLISH_MARKS_GRADE,"PUBLISH_MARKS_GRADE");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_UNPUBLISH_MARK_ENTRY,"UNPUBLISH_MARKS_GRADE");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_IMPORT_EXAM_ATTENDANCE,"IMPORT_EXAM_ATTENDANCE");
		
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_MARK_ENTRY_AS_HOST_FACULTY,"MARK_ENTRY_AS_HOST_FACULTY");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_CHECK_HISTORY,"CHECK_HISTORY");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_EVENT_MARK_ENTRY_FACULTY,"EVENT_MARK_ENTRY");
		facultyMarkEntryPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARK_ENTRY_QUESTION_MARK_ENTRY_FACULTY,"QUESTION_MARK_ENTRY");
		featurePrivilegesMap.add("FACULTY_MARK_ENTRY_PRIVILEGES", facultyMarkEntryPrivileges);

		studentDemographicReport = new Ext.util.HashMap();
		studentDemographicReport.add(FPCONSTANTS.PS_M9_R_STD_DEMOGRAPHIC_REPORT_EXPORT, "EXPORT");
		studentDemographicReport.add(FPCONSTANTS.PS_M9_R_STD_DEMOGRAPHIC_REPORT_EXPORT_REPORTS, "EXPORTREPORTS");
		featurePrivilegesMap.add("STUDENT_DEMOGRAPHIC_REPORT_PRIVILEDGE", studentDemographicReport);
		
		evalPlanEligibleVariantMappingPrivileges=new Ext.util.HashMap();
		evalPlanEligibleVariantMappingPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONPLAN_ELIGIBLE_VARIANT_MAPPING_EXPORT, "EXPORT");
		evalPlanEligibleVariantMappingPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONPLAN_ELIGIBLE_VARIANT_MAPPING_SAVE, "SAVE");
		featurePrivilegesMap.add("EVAL_PLAN_ELIGIBLE_VARIANT_MAPPING_PRIVILEGES", evalPlanEligibleVariantMappingPrivileges);
		
		evalPlanMappedVariantMappingPrivileges=new Ext.util.HashMap();
		evalPlanMappedVariantMappingPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONPLAN_MAPPED_VARIANT_MAPPING_DELETE, "DELETE");
		evalPlanMappedVariantMappingPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONPLAN_MAPPED_VARIANT_MAPPING_MARKASCOMPLETE, "MARKASCOMPLETE");
		evalPlanMappedVariantMappingPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONPLAN_MAPPED_VARIANT_MAPPING_EXPORT, "EXPORT");
		evalPlanMappedVariantMappingPrivileges.add(FPCONSTANTS.PC_M5_F_EVALUATIONPLAN_MAPPED_VARIANT_MARKASPENDING, "MARKASPENDING");
		featurePrivilegesMap.add("EVAL_PLAN_MAPPED_VARIANT_MAPPING_PRIVILEGES", evalPlanMappedVariantMappingPrivileges);
		

		specializationEnrollmentPrivileges=new Ext.util.HashMap();
		specializationEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_SPECIALIZATION_ENROLLMENT_VIEW,"VIEW");
		specializationEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_SPECIALIZATION_ENROLLMENT_CHANGE_SPECIALIZATION,"CHANGE_SPECIALIZATION");
		specializationEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_SPECIALIZATION_ENROLLMENT_APPROVE,"APPROVE");
		specializationEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_SPECIALIZATION_ENROLLMENT_ENROLL_SPECIALIZATION,"ENROLL_SPECIALIZATION");
		specializationEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_F_SPECIALIZATION_ENROLLMENT_GRID_CONFIG, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("SPECIALIZATION_ENROLLMENT", specializationEnrollmentPrivileges);
		
		transferCreditPrivileges=new Ext.util.HashMap();
		transferCreditPrivileges.add(FPCONSTANTS.PC_M4_F_TRANSFER_CREDITS_VIEW,"VIEW");
		transferCreditPrivileges.add(FPCONSTANTS.PC_M4_F_TRANSFER_CREDITS_EDIT,"EDIT");
		transferCreditPrivileges.add(FPCONSTANTS.PC_M4_F_TRANSFER_CREDITS_ADD_EXTERNAL_COURSE_INSTITUTE,"ENTER_EXTERNAL_COURSE_INSTITUTE");
		transferCreditPrivileges.add(FPCONSTANTS.PC_M4_F_TRANSFER_CREDITS_DELETE,"DELETE");
		featurePrivilegesMap.add("TRANSFER_CREDITS", transferCreditPrivileges);
		
		studentTransferCreditPrivileges=new Ext.util.HashMap();
		studentTransferCreditPrivileges.add(FPCONSTANTS.PC_M4_F_STUDENT_TRANSFER_CREDITS_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_TRANSFER_CREDITS", studentTransferCreditPrivileges);
		
		specializationEnrollmentPrivileges=new Ext.util.HashMap();
		specializationEnrollmentPrivileges.add(FPCONSTANTS.SP_M4_F_SPECIALIZATION_ENROLLMENT_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_SPECIALIZATION_ENROLLMENT", specializationEnrollmentPrivileges);
		
		facultyPendingMarkRemarkReport = new Ext.util.HashMap();
		facultyPendingMarkRemarkReport.add(FPCONSTANTS.FP_M9_F_FP_PENDING_MARKENTRY_REPORT_VIEW, "VIEW");
		facultyPendingMarkRemarkReport.add(FPCONSTANTS.FP_M9_F_FP_PENDING_MARKENTRY_REPORT_EXPORT, "EXPORT");
		facultyPendingMarkRemarkReport.add(FPCONSTANTS.FP_M9_F_FP_PENDING_MARKENTRY_REPORT_GRID_Configuration, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_PENDING_MARKS_REMARKS_PRIVILEGES", facultyPendingMarkRemarkReport);
		
		/* Core ERP Current Enrollment Status Report Permissions Start */
		currentStudentEnrollmentReport = new Ext.util.HashMap();
		currentStudentEnrollmentReport.add(FPCONSTANTS.PS_M9_R_STD_CURRENT_STUDENT_ENROLLMENT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("CURRENT_STUDENT_ENROLLMENT_REPORT_PRIVILEGES", currentStudentEnrollmentReport);

		studentSucceedingEnrollmentReport = new Ext.util.HashMap();
		studentSucceedingEnrollmentReport.add(FPCONSTANTS.PS_M9_R_STD_SUCCEEDING_ENROLLMENT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("SUCCEEDING_ENROLLMENT_REPORT_PRIVILEGES", studentSucceedingEnrollmentReport);

		leftStudentsReport = new Ext.util.HashMap();
		leftStudentsReport.add(FPCONSTANTS.PS_M9_R_STD_LEFT_STUDENTS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("LEFT_STUDENTS_REPORT_PRIVILEGES", leftStudentsReport);

		currentStudentsReport = new Ext.util.HashMap();
		currentStudentsReport.add(FPCONSTANTS.PS_M9_R_STD_CURRENT_STUDENTS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("CURRENT_STUDENTS_REPORT_PRIVILEGES", currentStudentsReport);

		leavingStudentsReport = new Ext.util.HashMap();
		leavingStudentsReport.add(FPCONSTANTS.PS_M9_R_STD_LEAVING_STUDENTS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("LEAVING_STUDENTS_REPORT_PRIVILEGES", leavingStudentsReport);

		repeatStudentsReport = new Ext.util.HashMap();
		repeatStudentsReport.add(FPCONSTANTS.PS_M9_R_STD_REPEAT_STUDENTS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("REPEAT_STUDENTS_REPORT_PRIVILEGES", repeatStudentsReport);

		startingStudentsReport = new Ext.util.HashMap();
		startingStudentsReport.add(FPCONSTANTS.PS_M9_R_STD_STARTING_STUDENTS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("STARTING_STUDENTS_REPORT_PRIVILEGES", startingStudentsReport);

		currentTotalEnrollmentReport = new Ext.util.HashMap();
		currentTotalEnrollmentReport.add(FPCONSTANTS.PS_M9_R_STD_CURRENT_TOTAL_ENROLLMENTS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("CURRENT_TOTAL_ENROLLMENT_REPORT_PRIVILEGES", currentTotalEnrollmentReport);

		confirmedStudentsReport = new Ext.util.HashMap();
		confirmedStudentsReport.add(FPCONSTANTS.PS_M9_R_STD_CONFIRMED_STUDENTS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("CONFIRMED_STUDENTS_REPORT_PRIVILEGES", confirmedStudentsReport);

		projectedPromotionsReport = new Ext.util.HashMap();
		projectedPromotionsReport.add(FPCONSTANTS.PS_M9_R_STD_PROJECTED_PROMOTIONS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("PROJECTED_PROMOTIONS_REPORT_PRIVILEGES", projectedPromotionsReport);

		succeedingTotalEnrollmentReport = new Ext.util.HashMap();
		succeedingTotalEnrollmentReport.add(FPCONSTANTS.PS_M9_R_STD_SUCCEEDING_TOTAL_ENROLLMENTS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("SUCCEEDING_TOTAL_ENROLLMENT_REPORT_PRIVILEGES", succeedingTotalEnrollmentReport);
		
		/* Core ERP Current Enrollment Status Report Permissions End */
		
		facultyStudentAssessmentReport = new Ext.util.HashMap();
		facultyStudentAssessmentReport.add(FPCONSTANTS.FP_M9_F_FP_STUDENT_ASSESSMENT_REPORT_VIEW, "VIEW");
		facultyStudentAssessmentReport.add(FPCONSTANTS.FP_M9_F_FP_STUDENT_ASSESSMENT_REPORT_PUBLISH, "PUBLISH");
		facultyStudentAssessmentReport.add(FPCONSTANTS.FP_M9_F_FP_STUDENT_ASSESSMENT_REPORT_SENDMESSAGE, "SENDMESSAGE");
		facultyStudentAssessmentReport.add(FPCONSTANTS.FP_M9_F_FP_STUDENT_ASSESSMENT_REPORT_EXPORT_GRADE_BOOK, "EXPORT_GRADE_BOOK");
		facultyStudentAssessmentReport.add(FPCONSTANTS.FP_M9_F_FP_STUDENT_ASSESSMENT_REPORT_EXPORT_REPORTS, "EXPORT_REPORTS");
		facultyStudentAssessmentReport.add(FPCONSTANTS.FP_M9_F_FP_STUDENT_ASSESSMENT_REPORT_EXPORT_ADHOC_MESSAGE, "ADHOC_MESSAGE");
		facultyStudentAssessmentReport.add(FPCONSTANTS.FP_M9_F_FP_STUDENT_ASSESSMENT_REPORT_EXPORT_MESSAGE_TEMPLATE, "MESSAGE_TEMPLATE");
		facultyStudentAssessmentReport.add(FPCONSTANTS.FP_M9_F_FP_STUDENT_ASSESSMENT_REPORT_GENERATE_AND_PUBLISH_BUTTON, "GENERATE_AND_PUBLISH_BUTTON");
		facultyStudentAssessmentReport.add(FPCONSTANTS.FP_M9_F_FP_STUDENT_ASSESSMENT_REPORT_GENERATE_BUTTON, "GENERATE_BUTTON");
		facultyStudentAssessmentReport.add(FPCONSTANTS.FP_M9_F_FP_STUDENT_ASSESSMENT_REPORT_UNPUBLISH, "UNPUBLISH");
		featurePrivilegesMap.add("FACULTY_STUDENT_ASSESSMENT_REPORT_PRIVILEGES", facultyStudentAssessmentReport);
		
		facultyThesisManagement = new Ext.util.HashMap();
		facultyThesisManagement.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_THESIS_MANAGEMENT_VIEW, "VIEW");
		facultyThesisManagement.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_THESIS_MANAGEMENT_EXPORT,"EXPORT");
		facultyThesisManagement.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_THESIS_MANAGEMENT_ADD,"ADD");
		facultyThesisManagement.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_THESIS_MANAGEMENT_EDIT,"EDIT");
		facultyThesisManagement.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_THESIS_MANAGEMENT_CANCEL_NOMINATION,"CANCEL_NOMINATION");
		facultyThesisManagement.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_THESIS_MANAGEMENT_SUBMIT_THESIS,"SUBMIT_THESIS");
		facultyThesisManagement.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_THESIS_MANAGEMENT_APPROVE_REJECT,"APPROVE_REJECT");
		featurePrivilegesMap.add("FACULTY_THESIS_MANAGEMENT_PRIVILEGES", facultyThesisManagement);
		
		facultyMarkSummaryReport = new Ext.util.HashMap();
		facultyMarkSummaryReport.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_MARK_SUMMARY_REPORT_VIEW, "VIEW");
		facultyMarkSummaryReport.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_MARK_SUMMARY_REPORT_REFRESH, "REFRESH");
		featurePrivilegesMap.add("FACULTY_MARK_SUMMARY_REPORT_PRIVILEGES", facultyMarkSummaryReport);
		
		studentInfirmaryManageEntries = new Ext.util.HashMap();
		studentInfirmaryManageEntries.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_DETAILS_VIEW, "VIEW");
		studentInfirmaryManageEntries.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_DETAILS_CREATE, "CREATE");
		studentInfirmaryManageEntries.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_DETAILS_UPDATE, "UPDATE");
		studentInfirmaryManageEntries.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_DETAILS_DELETE, "DELETE");
		studentInfirmaryManageEntries.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_DETAILS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("STUDENT_INFIRMARY_MANAGE_ENTRIES_PRIVILEGES", studentInfirmaryManageEntries);
		
		studentInfirmaryInterventionManageEntries = new Ext.util.HashMap();
		studentInfirmaryInterventionManageEntries.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_VIEW, "VIEW");
		studentInfirmaryInterventionManageEntries.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_CREATE, "CREATE");
		studentInfirmaryInterventionManageEntries.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_UPDATE, "UPDATE");
		studentInfirmaryInterventionManageEntries.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_DELETE, "DELETE");
		studentInfirmaryInterventionManageEntries.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("STUDENT_INFIRMARY_INTERVENTION_MANAGE_ENTRIES_PRIVILEGES", studentInfirmaryInterventionManageEntries);
		
		studentProfileInterventionInfirmaryManageEntriesDownload = new Ext.util.HashMap();
		studentProfileInterventionInfirmaryManageEntriesDownload.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_DOC_DOWNLOADALL, "DOWNLOADALL");
		studentProfileInterventionInfirmaryManageEntriesDownload.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_DOC_DOWNLOADALL_DELETE, "DELETE");
		featurePrivilegesMap.add("STUDENT_PROFILE_INTERVENTION_INFIRMARY_MANAGE_ENTRIES_DOWNLOAD_PRIVILEGES", studentProfileInterventionInfirmaryManageEntriesDownload);
		
		tmCreateTasksPrivileges = new Ext.util.HashMap();
		tmCreateTasksPrivileges.add(FPCONSTANTS.PC_M7_F_CREATE_TASKS_VIEW, "VIEW");
		tmCreateTasksPrivileges.add(FPCONSTANTS.PC_M7_F_CREATE_TASKS_CREATE, "CREATE");
		tmCreateTasksPrivileges.add(FPCONSTANTS.PC_M7_F_CREATE_TASKS_UPDATE, "UPDATE");
		tmCreateTasksPrivileges.add(FPCONSTANTS.PC_M7_F_CREATE_TASKS_DELETE, "DELETE");
		tmCreateTasksPrivileges.add(FPCONSTANTS.PC_M7_F_CREATE_TASKS_EXPORT, "EXPORT");
		tmCreateTasksPrivileges.add(FPCONSTANTS.PC_M7_F_CREATE_TASKS_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("TM_CREATE_TASKS_PRIVILEGES", tmCreateTasksPrivileges);

		tmMyTasksPrivileges = new Ext.util.HashMap();
		tmMyTasksPrivileges.add(FPCONSTANTS.PC_M7_F_MY_TASKS_VIEW, "VIEW");
		featurePrivilegesMap.add("TM_MY_TASKS_PRIVILEGES", tmMyTasksPrivileges);

		tmTaskReportsPrivileges = new Ext.util.HashMap();
		tmTaskReportsPrivileges.add(FPCONSTANTS.PC_M7_F_TASK_REPORTS_VIEW, "VIEW");
		tmTaskReportsPrivileges.add(FPCONSTANTS.PC_M7_F_TASK_REPORTS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("TM_TASK_REPORTS_PRIVILEGES", tmTaskReportsPrivileges);
		
		infirmaryManageEntries = new Ext.util.HashMap();
		infirmaryManageEntries.add(FPCONSTANTS.PC_M7_F_INFIRMARY_MANAGE_ENTRIES_VIEW, "VIEW");
		infirmaryManageEntries.add(FPCONSTANTS.PC_M7_F_INFIRMARY_MANAGE_ENTRIES_CREATE, "CREATE");
		infirmaryManageEntries.add(FPCONSTANTS.PC_M7_F_INFIRMARY_MANAGE_ENTRIES_UPDATE, "UPDATE");
		infirmaryManageEntries.add(FPCONSTANTS.PC_M7_F_INFIRMARY_MANAGE_ENTRIES_DELETE, "DELETE");
		infirmaryManageEntries.add(FPCONSTANTS.PC_M7_F_INFIRMARY_MANAGE_ENTRIES_EXPORT, "EXPORT");
		infirmaryManageEntries.add(FPCONSTANTS.PC_M7_F_INFIRMARY_MANAGE_ENTRIES_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("INFIRMARY_MANAGE_ENTRIES_PRIVILEGES", infirmaryManageEntries);
		
		infirmaryManageIntervention = new Ext.util.HashMap();
		infirmaryManageIntervention.add(FPCONSTANTS.PC_M7_F_INFIRMARY_MANAGE_INTERVENTION_VIEW, "VIEW");
		infirmaryManageIntervention.add(FPCONSTANTS.PC_M7_F_INFIRMARY_MANAGE_INTERVENTION_CREATE, "CREATE");
		infirmaryManageIntervention.add(FPCONSTANTS.PC_M7_F_INFIRMARY_MANAGE_INTERVENTION_UPDATE, "UPDATE");
		infirmaryManageIntervention.add(FPCONSTANTS.PC_M7_F_INFIRMARY_MANAGE_INTERVENTION_DELETE, "DELETE");
		infirmaryManageIntervention.add(FPCONSTANTS.PC_M7_F_INFIRMARY_MANAGE_INTERVENTION_EXPORT, "EXPORT");
		infirmaryManageIntervention.add(FPCONSTANTS.PC_M7_F_INFIRMARY_MANAGE_INTERVENTION_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("INFIRMARY_MANAGE_INTERVENTION_PRIVILEGES", infirmaryManageIntervention);
		
		hrWorkHourDetails = new Ext.util.HashMap();
		hrWorkHourDetails.add(FPCONSTANTS.FP_M9_F_WORK_HOUR_DETAILS_VIEW, "VIEW");
		hrWorkHourDetails.add(FPCONSTANTS.FP_M9_F_WORK_HOUR_DETAILS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("HR_PROFILE_PRIVILEGES", hrWorkHourDetails);
		
		facultyWorkHourDetails = new Ext.util.HashMap();
		facultyWorkHourDetails.add(FPCONSTANTS.PF_M8_F_FACULTY_WORK_HOURS_VIEW, "VIEW");
		facultyWorkHourDetails.add(FPCONSTANTS.PF_M8_F_FACULTY_WORK_HOURS_CREATE, "CREATE");
		facultyWorkHourDetails.add(FPCONSTANTS.PF_M8_F_FACULTY_WORK_HOURS_UPDATE, "UPDATE");
		featurePrivilegesMap.add("FACULTY_WORK_HOURS_PRIVILEGES", facultyWorkHourDetails);
		
		studyMaterialDistributionListPrivileges = new Ext.util.HashMap();
		studyMaterialDistributionListPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTION_LIST_SENDMATERIAL,"SENDMATERIAL");
		studyMaterialDistributionListPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTION_LIST_EXPORT,"EXPORT");
		studyMaterialDistributionListPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTION_LIST_PRINT_DISPATCH_FORM,"PRINT_DISPATCH_FORM");
		studyMaterialDistributionListPrivileges.add(FPCONSTANTS.PC_M4_F_STUDYMATERIALDISTRIBUTION_LIST_DOWNLOAD_ALL,"DOWNLOAD_ALL");
		featurePrivilegesMap.add("STUDY_MATERIAL_DISTRIBUTION_LIST_PRIVILEGES", studyMaterialDistributionListPrivileges);

		studentportalRevaluationPrivileges=new Ext.util.HashMap();
		studentportalRevaluationPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_APPLY_FOR_REVALUATION_VIEW, "VIEW");
		studentportalRevaluationPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_APPLY_FOR_REVALUATION_APPLY_AND_PAY_ONLINE, "APPLY_AND_PAY_ONLINE");
		studentportalRevaluationPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_APPLY_FOR_REVALUATION_COLLECT_PAYMENT, "COLLECT_PAYMENT");
		studentportalRevaluationPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_APPLY_FOR_REVALUATION_OFFLINE_PAYMENT, "OFFLINE_PAYMENT");
		studentportalRevaluationPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_APPLY_FOR_REVALUATION_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		studentportalRevaluationPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_APPLY_FOR_REVALUATION_APPLY_NOW, "APPLY_NOW");
		featurePrivilegesMap.add("STUDENT_PORTAL_EXAM_REVALUATION_PRIVILEGES", studentportalRevaluationPrivileges);
		
		studentportalStudentAssessmentReportPrivileges=new Ext.util.HashMap();
		studentportalStudentAssessmentReportPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_STUDENT_ASSESSMENT_REPORT_VIEW, "VIEW");
		studentportalStudentAssessmentReportPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_STUDENT_ASSESSMENT_REPORT_SAVE, "SAVE");
		studentportalStudentAssessmentReportPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_STUDENT_ASSESSMENT_REPORT_SUBMIT, "SUBMIT");
		studentportalStudentAssessmentReportPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_STUDENT_ASSESSMENT_REPORT_EXPORT_GRADE_BOOK, "EXPORT_GRADE_BOOK");
		studentportalStudentAssessmentReportPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_STUDENT_ASSESSMENT_REPORT_EXPORT_REPORTS, "EXPORT_REPORTS");
		featurePrivilegesMap.add("STUDENT_PORTAL_EXAM_STUDENT_ASSESSMENT_REPORT_PRIVILEGES", studentportalStudentAssessmentReportPrivileges);
		
		studentPortalStudentResultReportPrivileges=new Ext.util.HashMap();
		studentPortalStudentResultReportPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_STUDENT_RESULT_REPORT_VIEW, "VIEW");
		featurePrivilegesMap.add("STUDENT_PORTAL_EXAM_STUDENT_RESULT_REPORT_PRIVILEGES", studentPortalStudentResultReportPrivileges);
	
		studentPortalThesisManagementPrivileges=new Ext.util.HashMap();
		studentPortalThesisManagementPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_THESIS_MANAGEMENT_VIEW, "VIEW");
		studentPortalThesisManagementPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_THESIS_MANAGEMENT_EXPORT, "EXPORT");
		studentPortalThesisManagementPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_THESIS_MANAGEMENT_SUBMIT_THESIS, "SUBMIT_THESIS");
		featurePrivilegesMap.add("STUDENT_PORTAL_EXAM_THESIS_MANAGEMENT_PRIVILEGES", studentPortalThesisManagementPrivileges);
		
		CourseGroupReportPrivileges=new Ext.util.HashMap();
		CourseGroupReportPrivileges.add(FPCONSTANTS.PC_M4_R_COURSEREPORT_COURSE_GROUP_REPORT_RELOAD_BUTTON, "REFRESH");
		featurePrivilegesMap.add("COURSE_GROUP_REPORT_PRIVILEGES", CourseGroupReportPrivileges);
		
		
		studentPortalCourseGroupReportPrivileges=new Ext.util.HashMap();
		studentPortalCourseGroupReportPrivileges.add(FPCONSTANTS.SP_M5_F_COURSE_GROUP_REPORT_VIEW, "VIEW");
		studentPortalCourseGroupReportPrivileges.add(FPCONSTANTS.SP_M5_F_COURSE_GROUP_REPORT_RELOAD_BUTTON, "REFRESH");
		featurePrivilegesMap.add("SP_COURSE_GROUP_REPORT_PRIVILEGES", studentPortalCourseGroupReportPrivileges);
		  
		studentPortalMarkEntryReportPrivileges=new Ext.util.HashMap();
		studentPortalMarkEntryReportPrivileges.add(FPCONSTANTS.SP_M5_F_MARK_ENTRY_REPORT_VIEW, "VIEW");
		studentPortalMarkEntryReportPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_TIMETABLE_VIEW, "VIEW");
		studentPortalMarkEntryReportPrivileges.add(FPCONSTANTS.SP_M5_F_MARK_ENTRY_REPORT_RELOAD_BUTTON, "REFRESH");
		featurePrivilegesMap.add("SP_MARK_ENTRY_REPORT_PRIVILEGES", studentPortalMarkEntryReportPrivileges);
		
		studentPortalRegistraionGroupPrivileges=new Ext.util.HashMap();
		studentPortalRegistraionGroupPrivileges.add(FPCONSTANTS.SP_M5_F_REGISTER_FOR_ASSESSMENT_GROUP, "VIEW");
		featurePrivilegesMap.add("REGISTOER_FOR_ASSESSMENT_GROUP_PRIVILEGES", studentPortalRegistraionGroupPrivileges);
		
		studentPortalDegreeAuditReportPrivileges=new Ext.util.HashMap();
		studentPortalDegreeAuditReportPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_DEGREE_AUDIT_REPORT_VIEW, "VIEW");
		studentPortalDegreeAuditReportPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_DEGREE_AUDIT_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PRIVILEGES", studentPortalDegreeAuditReportPrivileges);
		
		parentPortalStudentResultReportPrivileges=new Ext.util.HashMap();
		parentPortalStudentResultReportPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_STUDENT_RESULT_REPORT_VIEW, "VIEW");
		featurePrivilegesMap.add("PARENT_PORTAL_EXAM_STUDENT_RESULT_REPORT_PRIVILEGES", parentPortalStudentResultReportPrivileges);
		
		parentPortalDegreeAuditReportPrivileges=new Ext.util.HashMap();
		parentPortalDegreeAuditReportPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_DEGREE_AUDIT_REPORT_VIEW, "VIEW");
		parentPortalDegreeAuditReportPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_DEGREE_AUDIT_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PRIVILEGES", parentPortalDegreeAuditReportPrivileges);
		
		parentPortalThesisManagementPrivileges=new Ext.util.HashMap();
		parentPortalThesisManagementPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_THESIS_MANAGEMENT_VIEW, "VIEW");
		parentPortalThesisManagementPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_THESIS_MANAGEMENT_EXPORT, "EXPORT");
		parentPortalThesisManagementPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_THESIS_MANAGEMENT_SUBMIT_THESIS, "SUBMIT_THESIS");
		featurePrivilegesMap.add("PARENT_PORTAL_EXAM_THESIS_MANAGEMENT_PRIVILEGES", parentPortalThesisManagementPrivileges);
		
		parentPortalCourseGroupReportPrivileges=new Ext.util.HashMap();
		parentPortalCourseGroupReportPrivileges.add(FPCONSTANTS.PP_M5_F_COURSE_GROUP_REPORT_VIEW, "VIEW");
		parentPortalCourseGroupReportPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_TIMETABLE_VIEW, "VIEW");
		featurePrivilegesMap.add("PP_COURSE_GROUP_REPORT_PRIVILEGES", parentPortalCourseGroupReportPrivileges);
		
		parentPortalStudentAssessmentReportPrivileges=new Ext.util.HashMap();
		parentPortalStudentAssessmentReportPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_STUDENT_ASSESSMENT_REPORT_VIEW, "VIEW");
		parentPortalStudentAssessmentReportPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_STUDENT_ASSESSMENT_REPORT_SAVE, "SAVE");
		parentPortalStudentAssessmentReportPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_STUDENT_ASSESSMENT_REPORT_SUBMIT, "SUBMIT");
		parentPortalStudentAssessmentReportPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_STUDENT_ASSESSMENT_REPORT_EXPORT_GRADE_BOOK, "EXPORT_GRADE_BOOK");
		parentPortalStudentAssessmentReportPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_STUDENT_ASSESSMENT_REPORT_EXPORT_REPORTS, "EXPORT_REPORTS");
		featurePrivilegesMap.add("PARENT_PORTAL_EXAM_STUDENT_ASSESSMENT_REPORT_PRIVILEGES", parentPortalStudentAssessmentReportPrivileges);
		
		revaluationMarkentryPrivileges=new Ext.util.HashMap();
		revaluationMarkentryPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_MARK_ENTRY_VIEW, "VIEW");
		revaluationMarkentryPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_MARK_ENTRY_CALCULATE_MARKS, "CALCULAT_MARKS");
		featurePrivilegesMap.add("REVALUATION_MARKENTRY_PRIVILEGES", revaluationMarkentryPrivileges);
		
		revaluationSetupPrivileges=new Ext.util.HashMap();
		revaluationSetupPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_SETUP_VIEW, "VIEW");
		revaluationSetupPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_SETUP_EXPORT, "EXPORT");
		revaluationSetupPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_SETUP_CREATE, "CREATE");
		revaluationSetupPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_SETUP_UPDATE, "UPDATE");
		revaluationSetupPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_SETUP_DELETE, "DELETE");
		revaluationSetupPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_SETUP_MANAGERULE, "MANAGERULE");
		revaluationSetupPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_SETUP_MOREACTION, "MOREACTIONS");
		featurePrivilegesMap.add("REVALUATION_SETUP_PRIVILEGES", revaluationSetupPrivileges);
		
		revaluationRuleMappingPrivileges=new Ext.util.HashMap();
		revaluationRuleMappingPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_RULE_MAPPING_VIEW, "VIEW");
		revaluationRuleMappingPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_RULE_MAPPING_EXPORT, "EXPORT");
		revaluationRuleMappingPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_RULE_MAPPING_CREATE, "CREATE");
		revaluationRuleMappingPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_RULE_MAPPING_UPDATE, "UPDATE");
		revaluationRuleMappingPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_RULE_MAPPING_DELETE, "DELETE");
		revaluationRuleMappingPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_RULE_MAPPING_MOREACTION, "MOREACTIONS");
		revaluationRuleMappingPrivileges.add(FPCONSTANTS.PC_M5_F_REVALUATION_RULE_MAPPING_MAPPROGRAMDETAILS, "MAPPROGRAMDETAILS");
		featurePrivilegesMap.add("REVALUATION_RULE_MAPPING_PRIVILEGES", revaluationRuleMappingPrivileges);

		applicantOnlinePaymentPrivileges=new Ext.util.HashMap();
		applicantOnlinePaymentPrivileges.add(FPCONSTANTS.PC_M3_F_ONLINE_PAYMENT_MAKE_PAYMENT, "MAKE_PAYMENT");
		applicantOnlinePaymentPrivileges.add(FPCONSTANTS.PC_M3_F_ONLINE_PAYMENT_SEND_PAYMENT_LINK, "SEND_PAYMENT_LINK");
		applicantOnlinePaymentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ONLINE_PAYMENT_VIEW,"VIEW");
		
		applicantOnlinePaymentPrivileges.add(FPCONSTANTS.AC_M23_F_ONLINE_PAYMENTS_MAKE_PAYMENT, "MAKE_PAYMENT");
		applicantOnlinePaymentPrivileges.add(FPCONSTANTS.AC_M23_F_ONLINE_PAYMENTS_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICANT_ONLINE_PAYMENT_PRIVILEGES", applicantOnlinePaymentPrivileges);
		
		studentPortalCourseRegistrationDashboardPrivileges=new Ext.util.HashMap();
		studentPortalCourseRegistrationDashboardPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_DASHBOARD_VIEW, "VIEW");
		/*studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_EXPORT, "EXPORT");
		studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_ENROLL, "ENROLL");
		studentPortalCourseRegistrationPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_REGISTRATION_UNENROLL, "UNENROLL");*/
		featurePrivilegesMap.add("STUDENT_PORTAL_COURSE_REGISTRATION_DASHBOARD_PRIVILEGES", studentPortalCourseRegistrationDashboardPrivileges);
		
		academyTypeMasterPrivileges = new Ext.util.HashMap();
		academyTypeMasterPrivileges.add(FPCONSTANTS.PC_M12_F_ACADEMYTYPEMASTER_MANAGE_ADDRESSES, "MANAGE_ADDRESSES");
		academyTypeMasterPrivileges.add(FPCONSTANTS.PC_M12_F_ACADEMYTYPEMASTER_CREATE, "CREATE");
		academyTypeMasterPrivileges.add(FPCONSTANTS.PC_M12_F_ACADEMYTYPEMASTER_VIEW, "VIEW");
		academyTypeMasterPrivileges.add(FPCONSTANTS.PC_M12_F_ACADEMYTYPEMASTER_UPDATE, "UPDATE");
		academyTypeMasterPrivileges.add(FPCONSTANTS.PC_M12_F_ACADEMYTYPEMASTER_DELETE, "DELETE");
		academyTypeMasterPrivileges.add(FPCONSTANTS.PC_M12_F_ACADEMYTYPEMASTER_EXPORT, "EXPORT");
		featurePrivilegesMap.add("ACADEMY_TYPE_MASTER_PRIVILEGES", academyTypeMasterPrivileges);
		
		//For Quick Link Setup 
		quickLinkSetupPrivileges = new Ext.util.HashMap();
		quickLinkSetupPrivileges.add(FPCONSTANTS.PC_M12_F_QUICKLINKSETUP_VIEW, "VIEW");
		featurePrivilegesMap.add("QUICK_LINK_SETUP_PRIVILEGES", quickLinkSetupPrivileges);
		
		
		droolRulesPrivileges = new Ext.util.HashMap();
		droolRulesPrivileges.add(FPCONSTANTS.PC_M12_F_DROOLRULES_VIEW, "VIEW");
		droolRulesPrivileges.add(FPCONSTANTS.PC_M12_F_DROOLRULES_APPLY_TO, "APPLY_TO");
		featurePrivilegesMap.add("DROOL_RULES_PRIVILEGES", droolRulesPrivileges);
		
		campaignMasterPrivileges = new Ext.util.HashMap();
		campaignMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CAMPAIGNMASTER_VIEW, "VIEW");
		campaignMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CAMPAIGNMASTER_UPDATE, "UPDATE");
		campaignMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CAMPAIGNMASTER_CREATE, "CREATE");
		campaignMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CAMPAIGNMASTER_DELETE, "DELETE");
		campaignMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CAMPAIGNMASTER_EXPORT, "EXPORT");
		campaignMasterPrivileges.add(FPCONSTANTS.PC_M12_F_CAMPAIGN_SCHOOL_MASTER_GRID_CONFIG, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("CAMPAIGN_MASTER_PRIVILEGES", campaignMasterPrivileges);
		
		campaignMapSchoolPriorityTabPrivileges = new Ext.util.HashMap();
		campaignMapSchoolPriorityTabPrivileges.add(FPCONSTANTS.PC_M12_F_MAPSCHOOLPRIORITYTAB_VIEW, "VIEW");
		campaignMapSchoolPriorityTabPrivileges.add(FPCONSTANTS.PC_M12_F_MAPSCHOOLPRIORITYTAB_SET_DEFAULT_PRIORITY, "SET_DEFAULT_PRIORITY");
		campaignMapSchoolPriorityTabPrivileges.add(FPCONSTANTS.PC_M12_F_MAPSCHOOLPRIORITYTAB_EXPORT_REPORTS, "EXPORTREPORTS");
		featurePrivilegesMap.add("CAMPAIGN_MAP_SCHOOL_PRIORITY_TAB_PRIVILEGES", campaignMapSchoolPriorityTabPrivileges);
		
		enquiryAdvanceSearchPrivileges=new Ext.util.HashMap();
		enquiryAdvanceSearchPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRY_ADVANCE_SEARCH_VIEW, "VIEW");
		featurePrivilegesMap.add("ENQUIRY_ADVANCE_SEARCH_PRIVILEGES", enquiryAdvanceSearchPrivileges);
		
		leadImportUtilityPrivileges=new Ext.util.HashMap();
		leadImportUtilityPrivileges.add(FPCONSTANTS.PC_M2_F_LEAD_IMPORTUTILITY_VIEW, "VIEW");
		featurePrivilegesMap.add("LEAD_IMPORT_UTILITY_PRIVILEGES", leadImportUtilityPrivileges);
		
		leadImportEnquiryUpdatePrivileges=new Ext.util.HashMap();
		leadImportEnquiryUpdatePrivileges.add(FPCONSTANTS.PC_M2_F_LEAD_IMPORTENQUIRY_UPDATE_VIEW, "VIEW");
		featurePrivilegesMap.add("LEAD_IMPORT_ENQUIRY_UPDATE_PRIVILEGES", leadImportEnquiryUpdatePrivileges);
		
		campaignAdvanceSearchPrivileges=new Ext.util.HashMap();
		campaignAdvanceSearchPrivileges.add(FPCONSTANTS.PC_M1_F_ADVANCE_SEARCH_VIEWCAMPAIGN_VIEW,"VIEW");
		featurePrivilegesMap.add("CAMPAIGN_ADVANCE_SEARCH_PRIVILEGES", campaignAdvanceSearchPrivileges);
		
		facultyHomeworkAssignmentDetailPrivileges = new Ext.util.HashMap();
		facultyHomeworkAssignmentDetailPrivileges.add(FPCONSTANTS.FP_M4_F_ASSIGNMENTSDETAILS_VIEW, "VIEW");
		facultyHomeworkAssignmentDetailPrivileges.add(FPCONSTANTS.FP_M4_F_ASSIGNMENTSDETAILS_MOREACTIONS, "MOREACTIONS");
		facultyHomeworkAssignmentDetailPrivileges.add(FPCONSTANTS.FP_M4_F_ASSIGNMENTSDETAILS_UPDATE, "UPDATE");
		facultyHomeworkAssignmentDetailPrivileges.add(FPCONSTANTS.FP_M4_F_ASSIGNMENTSDETAILS_DELETE, "DELETE");
		facultyHomeworkAssignmentDetailPrivileges.add(FPCONSTANTS.FP_M4_F_ASSIGNMENTSDETAILS_CREATE, "CREATE");
		facultyHomeworkAssignmentDetailPrivileges.add(FPCONSTANTS.FP_M4_F_ASSIGNMENTSDETAILS_UPLOADFILE, "UPLOADFILE");
		facultyHomeworkAssignmentDetailPrivileges.add(FPCONSTANTS.FP_M4_F_ASSIGNMENTSDETAILS_EXPORT, "EXPORT");
		facultyHomeworkAssignmentDetailPrivileges.add(FPCONSTANTS.FP_M4_F_ASSIGNMENTSDETAILS_DOWNLOAD_ALL, "DOWNLOAD_ALL");
		facultyHomeworkAssignmentDetailPrivileges.add(FPCONSTANTS.FP_M4_F_ASSIGNMENTSDETAILS_BULK_DOCUMENT_DOWNLOAD, "BULK_DOCUMENT_DOWNLOAD");
		facultyHomeworkAssignmentDetailPrivileges.add(FPCONSTANTS.FP_M4_F_ASSIGNMENTSDETAILS_SUBMISSION_DETAILS, "SUBMISSION_DETAILS");
		facultyHomeworkAssignmentDetailPrivileges.add(FPCONSTANTS.FP_M4_F_ASSIGNMENTSDETAILS_ASSESSMENT_DETAILS, "ASSESSMENT_DETAILS");
		featurePrivilegesMap.add("FACULTY_HOMEWORK_ASSIGNMENT_DETAIL_PRIVILEGES", facultyHomeworkAssignmentDetailPrivileges);
		
		facultyHomeworkAssignmentDetailFormPrivileges = new Ext.util.HashMap();
		facultyHomeworkAssignmentDetailFormPrivileges.add(FPCONSTANTS.FP_M4_F_ASSIGNMENTSDETAILSFORM_CONFIGURE_NOTIFICATIONS, "CONFIGURE_NOTIFICATIONS");
		featurePrivilegesMap.add("FACULTY_HOMEWORK_ASSIGNMENT_DETAIL_FORM_PRIVILEGES", facultyHomeworkAssignmentDetailFormPrivileges);
		
		
		transportDuesReportPrivileges=new Ext.util.HashMap();
		transportDuesReportPrivileges.add(FPCONSTANTS.PC_M11_TRANSPORT_DUES_REPORT_VIEW,"VIEW");
		transportDuesReportPrivileges.add(FPCONSTANTS.PC_M11_TRANSPORT_DUES_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("TRANSPORT_DUES_REPORT_PRIVILEGES", transportDuesReportPrivileges);
		
		resourceUtilizationPriviliges=new Ext.util.HashMap();
		resourceUtilizationPriviliges.add(FPCONSTANTS.PC_M7_R_RESOURCEUTILIZATION_VIEW,"VIEW");
		resourceUtilizationPriviliges.add(FPCONSTANTS.PC_M7_R_RESOURCEUTILIZATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("RESOURCE_UTILIZATION_PRIVILEGES", resourceUtilizationPriviliges);
		
		facultyCourseInterestPriviliges=new Ext.util.HashMap();
		facultyCourseInterestPriviliges.add(FPCONSTANTS.PC_M7_R_FACULTY_INTEREST_REPORT_VIEW,"VIEW");
		facultyCourseInterestPriviliges.add(FPCONSTANTS.PC_M7_R_FACULTY_INTEREST_REPORT_APPROVE,"APPROVE");
		facultyCourseInterestPriviliges.add(FPCONSTANTS.PC_M7_R_FACULTY_INTEREST_REPORT_DECLINE,"DECLINE");
		facultyCourseInterestPriviliges.add(FPCONSTANTS.PC_M7_R_FACULTY_INTEREST_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_INTEREST_REPORT_PRIVILEGES", facultyCourseInterestPriviliges);
		
		higherQualificationWindowPriviliges=new Ext.util.HashMap();
		higherQualificationWindowPriviliges.add(FPCONSTANTS.PC_M7_R_FIR_HIGHEST_QUALIFICATION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FIR_HIGHEST_QUALIFICATION_PRIVILEGES", higherQualificationWindowPriviliges);
		
		preReqNotMetReportPriviliges=new Ext.util.HashMap();
		preReqNotMetReportPriviliges.add(FPCONSTANTS.PC_M7_R_PREREQ_NOT_MET_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("PREREQ_NOT_MET_REPORT_PRIVILEGES", preReqNotMetReportPriviliges);
		
		studentAcademicHistory=new Ext.util.HashMap();
		studentAcademicHistory.add(FPCONSTANTS.PS_M9_F_STUDENT_VIEW_ACADEMIC_HISTORY_VIEW,"VIEW");
		studentAcademicHistory.add(FPCONSTANTS.PS_M9_F_STUDENT_VIEW_ACADEMIC_HISTORY_EXPORT,"EXPORT");
		studentAcademicHistory.add(FPCONSTANTS.PS_M9_F_STUDENT_VIEW_ACADEMIC_HISTORY_PRINT_TRANSCRIPT,"PRINT_TRANSCRIPT");
		studentAcademicHistory.add(FPCONSTANTS.PS_M9_F_STUDENT_VIEW_ACADEMIC_HISTORY_PRINT_TRANSCRIPT_EXCEL,"PRINT_EXCEL_TRANSCRIPT");
		studentAcademicHistory.add(FPCONSTANTS.PS_M9_F_STUDENT_VIEW_ACADEMIC_HISTORY_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		
		featurePrivilegesMap.add("STUDENT_VIEW_ACADEMIC_HISTORY", studentAcademicHistory);
		
		genericRemarkReportsPrivileges = new Ext.util.HashMap();
		genericRemarkReportsPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_GENERIC_REMARK_REPORTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_GENERIC_REMARK_REPORTS_PRIVILEGES", genericRemarkReportsPrivileges);
		
		manageAssessmentEventPrivileges = new Ext.util.HashMap();
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_EXPORT,"EXPORT");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_SAVEBUTTON,"SAVEBUTTON");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_REMOVE,"REMOVE");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_RECALCULATE_RESULT,"RECALCULATE_RESULT");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_MANAGE_QUESTIONS,"MANAGE_QUESTIONS");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_MOREACTIONS,"MOREACTIONS");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_IMPORT_BULK_ASSESSMENT_EVENTS, "IMPORT_BULK_ASSESSMENT_EVENTS");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_MANAGE_EVENT_STATUS, "MANAGE_EVENT_STATUS");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_MANAGE_ASSESSMENT_STATUS, "MANAGE_ASSESSMENT_STATUS");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_MANAGE_HIERARCHY_STATUS, "MANAGE_HIERARCHY_STATUS");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_IMPORT_BULK_CONDUCTED_DATE, "IMPORT_BULK_CONDUCTED_DATE");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_EXAM_CONCESSION_STAFF_ALLOCATION, "EXAM_CONCESSION_STAFF_ALLOCATION");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_ROOM_AND_STAFF_ALLOCATION, "ROOM_AND_STAFF_ALLOCATION");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_IMPORT_PRE_EXAM_DETAILS, "IMPORT_PRE_EXAM_DETAILS");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_SAVE, "SAVE");
		manageAssessmentEventPrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_ASSESSMENT_EVENTS_DELETE, "DELETE");
		featurePrivilegesMap.add("EXAMINATION_MANAGE_ASSESSMENT_EVENT_PRIVILEGES", manageAssessmentEventPrivileges);
		
		eligibleStudentsPrivileges = new Ext.util.HashMap();
		eligibleStudentsPrivileges.add(FPCONSTANTS.PC_M5_F_ELIGIBLE_STUDENT_EXPORT,"EXPORT");
		eligibleStudentsPrivileges.add(FPCONSTANTS.PC_M5_F_ELIGIBLE_STUDENT_MAPSTUDENTS,"MAPSTUDENTS");
		featurePrivilegesMap.add("EXAMINATION_ELIGIBLE_STUDENTS_PRIVILEGES", eligibleStudentsPrivileges);
		
		mappedStudentsPrivileges = new Ext.util.HashMap();
		mappedStudentsPrivileges.add(FPCONSTANTS.PC_M5_F_MAPPED_STUDENT_EXPORT,"EXPORT");
		mappedStudentsPrivileges.add(FPCONSTANTS.PC_M5_F_MAPPED_STUDENT_UNMAP_STUDENTS,"UNMAP_STUDENTS");
		featurePrivilegesMap.add("EXAMINATION_MAPPED_STUDENTS_PRIVILEGES", mappedStudentsPrivileges);
		
		manageRevisedGradePrivileges=new Ext.util.HashMap();
		manageRevisedGradePrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_REVISED_GRADE_EXPORT, "EXPORT");
		manageRevisedGradePrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_REVISED_GRADE_APPLYCHANGES, "APPLYCHANGES");
		manageRevisedGradePrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_REVISED_GRADE_CRITERIA_BASED_GRADE, "CRITERIA_BASED_GRADE");
		manageRevisedGradePrivileges.add(FPCONSTANTS.PC_M5_F_MANAGE_REVISED_GRADE_SPECIALGRADE, "SPECIALGRADE");
		featurePrivilegesMap.add("MANAGE_REVISED_GRADE_PRIVILEGES", manageRevisedGradePrivileges);
		
		//******************************Course Enrollment***************************************************
		courseEnrollmentPrivileges = new Ext.util.HashMap();
		courseEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_COURSE_ENROLLMENT_ENROLL,"ENROLL");
		courseEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_COURSE_ENROLLMENT_UNENROLL,"UNENROLL");
		courseEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_COURSE_ENROLLMENT_DEENROLL,"DEENROLL");
		courseEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_COURSE_ENROLLMENT_ENROLLMENT_DATE,"CHANGE_ENROLLMENT_DATE");
		courseEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_COURSE_ENROLLMENT_UNENROLL_DROP_SUBJECT,"UNENROLL_DROP_SUBJECT");
		courseEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_COURSE_ENROLLMENT_UNENROLL_CHANGE_SUBJECT_SECTION,"UNENROLL_CHANGE_SUBJECT_SECTION");
		courseEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_COURSE_ENROLLMENT_DEENROLL_DROP_SUBJECT,"DEENROLL_DROP_SUBJECT");
		courseEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_COURSE_ENROLLMENT_DEENROLL_CHANGE_SUBJECT_SECTION,"DEENROLL_CHANGE_SUBJECT_SECTION");
		featurePrivilegesMap.add("COURSE_ENROLLMENT_PRIVILEGES", courseEnrollmentPrivileges);
        //******************************End*********************************************************************
		
		//******************************Student Enrollment***************************************************
		studentEnrollmentPrivileges = new Ext.util.HashMap();
		studentEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_STUDENT_ENROLLMENT_BULK_ENROL,"BULK_ENROL");
		studentEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_STUDENT_ENROLLMENT_ENROLL,"ENROLL");
		studentEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_STUDENT_ENROLLMENT_UNENROLL,"UNENROLL");
		studentEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_STUDENT_ENROLLMENT_DELETEENROLL,"DELETEENROLL");
		studentEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_STUDENT_ENROLLMENT_PERIODDETAILS,"PERIODDETAILS");
		studentEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_STUDENT_ENROLLMENT_DOWNLOAD_ELIGIBILITY_SHEET,"DOWNLOAD_ELIGIBILITY_SHEET");
		studentEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_PROOF_OF_REGISTRATION,"PROOF_OF_REGISTRATION");
		studentEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_APPROVE_REJECT,"APPROVE_REJECT");
		studentEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_ADDITIONAL_COURSE,"ADDITIONAL_COURSE");
		studentEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_CHANGE_EXAM_CENTER,"CHANGE_EXAM_CENTER");
		studentEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_STUDENT_ENROLLMENT_COURSE_CODE_SEARCH,"COURSE_CODE_SEARCH");
		studentEnrollmentPrivileges.add(FPCONSTANTS.PC_M4_D_PERIOD,"PERIOD");
		featurePrivilegesMap.add("STUDENT_ENROLLMENT_PRIVILEGES", studentEnrollmentPrivileges);
        //******************************End*********************************************************************
		
		calculateAveragePrivileges=new Ext.util.HashMap();
		calculateAveragePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_VIEW,"VIEW");
		calculateAveragePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_EXPORT,"EXPORT");
		calculateAveragePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_CALCULATE_AVERAGE,"CALCULATE_AVERAGE");
		calculateAveragePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_DELETE,"DELETE");
		calculateAveragePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		calculateAveragePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_CONDONE_SUBJECTS,"CONDONE_SUBJECTS");
		calculateAveragePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_SAVE,"SAVE");
		calculateAveragePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_TAB,"PC_M5_F_EXAM_CALCULATE_AVERAGE_TAB");
		calculateAveragePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_CALCULATE_RANK,"CALCULATE_RANK");
		featurePrivilegesMap.add("CALCULATE_AVERAGE_PRIVILEGES", calculateAveragePrivileges);
		
		calculateAverageYearlyPrivileges=new Ext.util.HashMap();
		calculateAverageYearlyPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_YEARLY,"CALCULATE_AVERAGE_YEARLY");
		calculateAverageYearlyPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_YEARLY_EXPORT,"EXPORT");
		calculateAverageYearlyPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_YEARLY_CALC_AVG,"CALCULATE_AVERAGE_YEARLY_CALC_AVG");
		calculateAverageYearlyPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_YEARLY_DELETE,"DELETE");
		calculateAverageYearlyPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_YEARLY_CALC_PROG_AVG,"CALCULATE_AVERAGE_YEARLY_CALC_PROG_AVG");
		calculateAverageYearlyPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_YEARLY_TAB,"CALCULATE_AVERAGE_YEARLY_TAB");
		featurePrivilegesMap.add("CALCULATE_AVERAGE_YEARLY_PRIVILEGES", calculateAverageYearlyPrivileges);
		
		calculateAverageLevelWisePrivileges=new Ext.util.HashMap();
		calculateAverageLevelWisePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_LEVEL_WISE_EXPORT,"EXPORT");
		calculateAverageLevelWisePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_LEVEL_WISE_CALC_AVG,"CALCULATE_AVERAGE_LEVEL_WISE_CALC_AVG");
		calculateAverageLevelWisePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_LEVEL_WISE_DELETE,"DELETE");
		calculateAverageLevelWisePrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_CALCULATE_AVERAGE_LEVEL_WISE_TAB,"CALCULATE_AVERAGE_LEVEL_WISE_TAB");
		featurePrivilegesMap.add("CALCULATE_AVERAGE_LEVEL_WISE_PRIVILEGES", calculateAverageLevelWisePrivileges);
		
		viewSchedulePriviliges = new Ext.util.HashMap();
		viewSchedulePriviliges.add(FPCONSTANTS.PC_M4_F_VIEWSCHEDULE_VIEW,"VIEW");
		viewSchedulePriviliges.add(FPCONSTANTS.PC_M4_F_VIEWSCHEDULE_SECTION_GROUP,"SECTION_GROUP");
		viewSchedulePriviliges.add(FPCONSTANTS.PC_M4_F_VIEWSCHEDULE_FACULTY,"FACULTY");
		viewSchedulePriviliges.add(FPCONSTANTS.PC_M4_F_VIEWSCHEDULE_STUDENT,"STUDENT");
		viewSchedulePriviliges.add(FPCONSTANTS.PC_M4_F_VIEWSCHEDULE_ROOM,"ROOM");
		viewSchedulePriviliges.add(FPCONSTANTS.PC_M4_F_VIEWSCHEDULE_EXPORT_TO_PNG,"EXPORT_TO_PNG");
		featurePrivilegesMap.add("VIEWSCHEDULE_PRIVILEGES", viewSchedulePriviliges);
		
		manageSectionRadioButtonPrivileges = new Ext.util.HashMap();
		manageSectionRadioButtonPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_SECTION_PROGRAM_BATCH_SECTION, "PROGRAM_BATCH_SECTION");
		manageSectionRadioButtonPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_SECTION_COURSE_SECTION, "COURSE_SECTION");
		manageSectionRadioButtonPrivileges.add(FPCONSTANTS.PC_M4_F_MANAGE_SECTION_SECTION_GROUP, "SECTION_GROUP");
		featurePrivilegesMap.add("MANAGE_SECTION_GROUP_PRIVILEGES", manageSectionRadioButtonPrivileges);
		
		importSessionAndTopicsMappingPrivileges = new Ext.util.HashMap();
		importSessionAndTopicsMappingPrivileges.add(FPCONSTANTS.PC_M4_F_IMPORT_SESSION_AND_TOPICS_MAPPING_VIEW, "VIEW");
		importSessionAndTopicsMappingPrivileges.add(FPCONSTANTS.PC_M4_F_IMPORT_SESSION_AND_TOPICS_MAPPING_PROGRAM_BATCH_SECTION, "PROGRAM_BATCH_SECTION");
		importSessionAndTopicsMappingPrivileges.add(FPCONSTANTS.PC_M4_F_IMPORT_SESSION_AND_TOPICS_MAPPING_COURSE_SECTION, "COURSE_SECTION");
		featurePrivilegesMap.add("IMPORT_SESSION_AND_TOPICS_MAPPING_PRIVILEGES", importSessionAndTopicsMappingPrivileges);
		
		manageCourseSectionRadioButtonPrivileges = new Ext.util.HashMap();
		manageCourseSectionRadioButtonPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONSCOURSEMANAGEMENT_VIEW, "VIEW");
		manageCourseSectionRadioButtonPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONSCOURSEMANAGEMENT_PROGRAM_SECTION, "PROGRAM_SECTION");
		manageCourseSectionRadioButtonPrivileges.add(FPCONSTANTS.PC_M4_F_SECTIONSCOURSEMANAGEMENT_OPEN_SECTION, "OPEN_SECTION");
		featurePrivilegesMap.add("MANAGE_COURSE_SECTION_GROUP_PRIVILEGES", manageCourseSectionRadioButtonPrivileges);
		                        
		// Employee Attendance
		employeeAttendancePrivileges= new Ext.util.HashMap();
		employeeAttendancePrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_BIO_ATTENDANCE_VIEW,"VIEW");
		employeeAttendancePrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_BIO_ATTENDANCE_SAVE,"SAVE");
		employeeAttendancePrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_BIO_ATTENDANCE_EXPORT_REPORTS,"EXPORTREPORTS");
		featurePrivilegesMap.add("EMPLOYEE_ATTENDANCE_PRIVILEGES", employeeAttendancePrivileges);
		
		//Import Employee Attendance
		importEmployeeAttendancePrivileges= new Ext.util.HashMap();
		importEmployeeAttendancePrivileges.add(FPCONSTANTS.PF_M8_F_IMPORT_FACULTY_BIO_ATTENDANCE_VIEW,"VIEW");
		featurePrivilegesMap.add("IMPORT_EMPLOYEE_ATTENDANCE_PRIVILEGES", importEmployeeAttendancePrivileges);
		
		// Employee Time Sheet
		employeeTimeSheetPrivileges= new Ext.util.HashMap();
		employeeTimeSheetPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_TIMESHEET_VIEW,"VIEW");
		employeeTimeSheetPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_TIMESHEET_GENERATE_TIMESHEET,"GENERATE_TIMESHEET");
		employeeTimeSheetPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_TIMESHEET_APPROVE_TIMESHEET,"APPROVE_TIMESHEET");
		employeeTimeSheetPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_TIMESHEET_DOWNLOAD_TIMESHEET,"DOWNLOAD_TIMESHEET");
		employeeTimeSheetPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_TIMESHEET_PRINT,"PRINT");
		featurePrivilegesMap.add("EMPLOYEE_TIMESHEET_PRIVILEGES", employeeTimeSheetPrivileges);
		
		// Employee Availability
		employeeAvailabilityPrivileges= new Ext.util.HashMap();
		employeeAvailabilityPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_AVAILABILITY_VIEW,"VIEW");
		employeeAvailabilityPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_AVAILABILITY_CREATE,"CREATE");
		employeeAvailabilityPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_AVAILABILITY_EDIT,"EDIT");
		employeeAvailabilityPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_AVAILABILITY_DELETE,"DELETE");
		featurePrivilegesMap.add("EMPLOYEE_AVAILABILITY_PRIVILEGES", employeeAvailabilityPrivileges);
		
		//Time Sheet Period
		hrmTimesheetPeriodPrivileges = new Ext.util.HashMap();
		hrmTimesheetPeriodPrivileges.add(FPCONSTANTS.PF_M8_R_TIMESHEET_CONFIGURATION_VIEW,"VIEW");
		hrmTimesheetPeriodPrivileges.add(FPCONSTANTS.PF_M8_R_TIMESHEET_CONFIGURATION_CREATE,"CREATE");
		hrmTimesheetPeriodPrivileges.add(FPCONSTANTS.PF_M8_R_TIMESHEET_CONFIGURATION_EDIT,"EDIT");
		hrmTimesheetPeriodPrivileges.add(FPCONSTANTS.PF_M8_R_TIMESHEET_CONFIGURATION_DELETE,"DELETE");
		featurePrivilegesMap.add("HRM_TIMESHEET_PERIOD_PRIVILEGES", hrmTimesheetPeriodPrivileges);
		
		//Employee Attendance Report
		employeeAttendanceReportPrivileges= new Ext.util.HashMap();
		employeeAttendanceReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_ATTENDANCE_REPORT_VIEW,"VIEW");
		employeeAttendanceReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_ATTENDANCE_REPORT_ATTENDANCE_SUMMARRY_REPORT, "ATTENDANCE_SUMMARRY_REPORT");
		employeeAttendanceReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_ATTENDANCE_REPORT_WORKING_HOUR_REPORT, "WORKING_HOUR_REPORT");
		employeeAttendanceReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_ATTENDANCE_REPORT_ATTENDANCE_PUNCH_LOG_REPORT, "ATTENDANCE_PUNCH_LOG_REPORT");
		employeeAttendanceReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_ATTENDANCE_REPORT_ATTENDANCE_STATUS_REPORT, "ATTENDANCE_STATUS_REPORT");
		//employeeAttendanceReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_ATTENDANCE_REPORT_EMPLOYEE_LEAVE_REPORT, "EMPLOYEE_LEAVE_REPORT");
		featurePrivilegesMap.add("EMPLOYEE_ATTENDANCE_REPORT_PRIVILEGES", employeeAttendanceReportPrivileges);
		
		//Employee Patent Report
		employeePatentReportPrivileges= new Ext.util.HashMap();
		employeePatentReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_PATENTE_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("EMPLOYEE_PATENT_REPORT_PRIVILEGES", employeePatentReportPrivileges);
		
		//Working Hour Report
		workingHourReportPrivileges= new Ext.util.HashMap();
		workingHourReportPrivileges.add(FPCONSTANTS.PF_M8_R_WORKING_HOUR_REPORT_EXPORT_REPORTS,"EXPORTREPORTS");
		featurePrivilegesMap.add("WORKING_HOUR_REPORT_PRIVILEGES", workingHourReportPrivileges);
		
		//Working Hour Report
		attendancePunchLogReportPrivileges= new Ext.util.HashMap();
		attendancePunchLogReportPrivileges.add(FPCONSTANTS.PF_M8_R_ATTENDANCE_PUNCH_LOG_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("ATTENDANCE_PUNCH_LOG_REPORT_PRIVILEGES", attendancePunchLogReportPrivileges);
	 	
	 	//ATTENDANCE STATUS REPORT
		attendanceStatusReportPrivileges= new Ext.util.HashMap();
		attendanceStatusReportPrivileges.add(FPCONSTANTS.PF_M8_R_ATTENDANCE_STATUS_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("ATTENDANCE_STATUS_REPORT_PRIVILEGES", attendanceStatusReportPrivileges);
	
		
		//Employee Attendance Summary Report
		attendanceSummaryReportEmployeePrivileges= new Ext.util.HashMap();
		attendanceSummaryReportEmployeePrivileges.add(FPCONSTANTS.PF_M8_R_ATTENDANCE_SUMMARY_REPORT_ATTENDANCE_REGISTER,"ATTENDANCE_REGISTER");
		featurePrivilegesMap.add("HRM_ATTENDANCE_SUMMARY_REPORT_PRIVILEGES", attendanceSummaryReportEmployeePrivileges);
		
		//Leave Approval Flow Report
		leaveApprovalFlowReportPrivileges= new Ext.util.HashMap();
		leaveApprovalFlowReportPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_APPROVAL_FLOW_REPORT_VIEW,"VIEW");
		leaveApprovalFlowReportPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_APPROVAL_FLOW_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("LEAVE_APPROVAL_FLOW_REPORT_PRIVILEGES", leaveApprovalFlowReportPrivileges);
		
		//Employee Leave Report of Employee leave dashboard
		employeeLeaveReportPrivileges= new Ext.util.HashMap();
		employeeLeaveReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_LEAVE_REPORT_VIEW,"VIEW");
		employeeLeaveReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_LEAVE_REPORT_EXPORT, "EXPORT");
		employeeLeaveReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_LEAVE_REPORT_CANCEL, "CANCEL");
		featurePrivilegesMap.add("EMPLOYEE_LEAVE_REPORT_PRIVILEGES", employeeLeaveReportPrivileges);
		
		leaveSLAReportPrivileges= new Ext.util.HashMap();
		leaveSLAReportPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_SLA_REPORT_VIEW,"VIEW");
		leaveSLAReportPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_SLA_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("LEAVE_SLA_REPORT_PRIVILEGES", leaveSLAReportPrivileges);
		
		employeeLeaveBalanceReportPrivileges= new Ext.util.HashMap();
		employeeLeaveBalanceReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_LEAVE_BALANCE_REPORT_VIEW,"VIEW");
		employeeLeaveBalanceReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_LEAVE_BALANCE_REPORT_EXPORT_REPORTS, "EXPORT_REPORTS");
		featurePrivilegesMap.add("EMPLOYEE_LEAVE_BALANCE_REPORT_PRIVILEGES", employeeLeaveBalanceReportPrivileges);
		
		employeeLeaveEncashmentReportPrivileges= new Ext.util.HashMap();
		employeeLeaveEncashmentReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_LEAVE_ENCASHMENT_REPORT_VIEW,"VIEW");
		employeeLeaveEncashmentReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_LEAVE_ENCASHMENT_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("EMPLOYEE_LEAVE_ENCASHMENT_REPORT_PRIVILEGES", employeeLeaveEncashmentReportPrivileges);
		
		employeeLeaveCarryForwardReportPrivileges= new Ext.util.HashMap();
		employeeLeaveCarryForwardReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_LEAVE_CARRY_FORWARD_REPORT_VIEW,"VIEW");
		employeeLeaveCarryForwardReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_LEAVE_CARRY_FORWARD_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("EMPLOYEE_LEAVE_CARRY_FORWARD_REPORT_PRIVILEGES", employeeLeaveCarryForwardReportPrivileges);
		
		employeeLeaveLapseReportPrivileges= new Ext.util.HashMap();
		employeeLeaveLapseReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_LEAVE_LAPSE_REPORT_VIEW,"VIEW");
		employeeLeaveLapseReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_LEAVE_LAPSE_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("EMPLOYEE_LEAVE_LAPSE_REPORT_PRIVILEGES", employeeLeaveLapseReportPrivileges);
		
		employeeLeaveCreditReportPrivileges= new Ext.util.HashMap();
		employeeLeaveCreditReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_LEAVE_CREDIT_REPORT_VIEW,"VIEW");
		employeeLeaveCreditReportPrivileges.add(FPCONSTANTS.PF_M8_R_EMPLOYEE_LEAVE_CREDIT_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("EMPLOYEE_LEAVE_CREDIT_REPORT_PRIVILEGES", employeeLeaveCreditReportPrivileges);
		
		/***********************start EXAM RESULT DELETION***********************************/
		examMarksheetPrivileges = new Ext.util.HashMap();
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_RESULT_DELETION_VIEW,"VIEW");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_RESULT_DELETION_DELETE,"DELETE");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_RESULT_DELETION_EXPORT,"EXPORT");
		examMarksheetPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_RESULT_DELETION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("EXAM_RESULT_DELETION_PRIVILEGES", examMarksheetPrivileges);
		
		examRevaluationPrivileges = new Ext.util.HashMap();
		examRevaluationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_APPLY_FOR_REVALUATION_VIEW,"VIEW");
		examRevaluationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_APPLY_FOR_REVALUATION_APPLY_AND_PAY_ONLINE, "APPLY_AND_PAY_ONLINE");
		examRevaluationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_APPLY_FOR_REVALUATION_APPLY_NOW, "APPLY_NOW");
		examRevaluationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_APPLY_FOR_REVALUATION_EXPORT, "EXPORT");
		examRevaluationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_APPLY_FOR_REVALUATION_OFFLINE_PAYMENT, "OFFLINE_PAYMENT");
		examRevaluationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_APPLY_FOR_REVALUATION_APPROVE_REJECT, "APPROVE_OR_REJECT");
		examRevaluationPrivileges.add(FPCONSTANTS.PC_M5_F_EXAM_APPLY_FOR_REVALUATION_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("EXAM_REVALUATION_PRIVILEGES", examRevaluationPrivileges);
		
		
		featurePrivilegesMap.add("EXAM_APPLY_FOR_REVALUATION_PRIVILEGES", examRevaluationPrivileges);
		/******************************End*******************************************/
		
		/***********Receipt Detail**************/
		receiptDetailsPrivileges = new Ext.util.HashMap();
		receiptDetailsPrivileges.add(FPCONSTANTS.PC_M6_F_RECEIPT_DETAIL_AUTO_SETTLE,"AUTO_SETTLE");
		receiptDetailsPrivileges.add(FPCONSTANTS.PC_M6_F_RECEIPT_DETAIL_SAVE_AND_SETTLE,"SAVE_AND_SETTLE");
		featurePrivilegesMap.add("RECEIPT_DETAIL_PRIVILEGES", receiptDetailsPrivileges);

		/*****************Student church info**********************/
		studentChurchInformationPrivileges = new Ext.util.HashMap();
		// student profile 
		studentChurchInformationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_CHURCH_INFORMATION_VIEW,"VIEW");
		studentChurchInformationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_CHURCH_INFORMATION_CREATE,"CREATE");
		studentChurchInformationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_CHURCH_INFORMATION_UPDATE,"UPDATE");
		studentChurchInformationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_CHURCH_INFORMATION_DELETE,"DELETE");
		studentChurchInformationPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_CHURCH_INFORMATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_CHURCH_INFORMATION_PRIVILEGES", studentChurchInformationPrivileges);
		
		/*****************Student core erp Non Academic Achievements**********************/
		studentNonAcademicAchievementsPrivileges = new Ext.util.HashMap();
		studentNonAcademicAchievementsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_NON_ACADEMIC_ACHIEVEMENTS_VIEW,"VIEW");
		studentNonAcademicAchievementsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_NON_ACADEMIC_ACHIEVEMENTS_CREATE,"CREATE");
		studentNonAcademicAchievementsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_NON_ACADEMIC_ACHIEVEMENTS_UPDATE,"UPDATE");
		studentNonAcademicAchievementsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_NON_ACADEMIC_ACHIEVEMENTS_DELETE,"DELETE");
		featurePrivilegesMap.add("STUDENT_NON_ACADEMIC_ACHIEVEMENTS_PRIVILEGES", studentNonAcademicAchievementsPrivileges);
		
		/*****************Student Communication history **********************/
		studentCommunicationHistoryPrivileges = new Ext.util.HashMap();
		// student profile 
		studentCommunicationHistoryPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMMUNICATION_HISTORY_VIEW,"VIEW");
		studentCommunicationHistoryPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_COMMUNICATION_HISTORY_EXPORT_REPORTS,"EXPORT_REPORTS");
		featurePrivilegesMap.add("STUDENT_COMMUNICATION_HISTORY_PRIVILEGES", studentCommunicationHistoryPrivileges);
		
		/***************Faculty Church Information************/
		
		facultyChurchInformationPrivileges = new Ext.util.HashMap();
		// faculty portal 
		facultyChurchInformationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_CHURCH_INFORMATION_VIEW,"VIEW");
		facultyChurchInformationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_CHURCH_INFORMATION_CREATE,"CREATE");
		facultyChurchInformationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_CHURCH_INFORMATION_UPDATE,"UPDATE");
		facultyChurchInformationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_CHURCH_INFORMATION_DELETE,"DELETE");
		facultyChurchInformationPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_CHURCH_INFORMATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_CHURCH_INFORMATION_PRIVILEGES", facultyChurchInformationPrivileges);
		
/***************Faculty Reference ************/
		
		facultyreferencePrivileges = new Ext.util.HashMap();
		// faculty portal 
		facultyreferencePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_REFERENCE_VIEW,"VIEW");
		facultyreferencePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_REFERENCE_CREATE,"CREATE");
		facultyreferencePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_REFERENCE_UPDATE,"UPDATE");
		facultyreferencePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_REFERENCE_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_REFERENCE_PRIVILEGES", facultyreferencePrivileges);
	
		
		facultyProfileChurchInformationPrivileges = new Ext.util.HashMap();
		// faculty profile 
		facultyProfileChurchInformationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_CHURCH_INFORMATION_VIEW,"VIEW");
		facultyProfileChurchInformationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_CHURCH_INFORMATION_CREATE,"CREATE");
		facultyProfileChurchInformationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_CHURCH_INFORMATION_UPDATE,"UPDATE");
		facultyProfileChurchInformationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_CHURCH_INFORMATION_DELETE,"DELETE");
		facultyProfileChurchInformationPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_CHURCH_INFORMATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PROFILE_CHURCH_INFORMATION_PRIVILEGES", facultyProfileChurchInformationPrivileges);
		
		// faculty profile 
		facultyProfileNonAcademicAchievementsPrivileges = new Ext.util.HashMap();
		facultyProfileNonAcademicAchievementsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_NON_ACADEMIC_ACHIEVEMENTS_VIEW,"VIEW");
		facultyProfileNonAcademicAchievementsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_NON_ACADEMIC_ACHIEVEMENTS_CREATE,"CREATE");
		facultyProfileNonAcademicAchievementsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_NON_ACADEMIC_ACHIEVEMENTS_UPDATE,"UPDATE");
		facultyProfileNonAcademicAchievementsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_NON_ACADEMIC_ACHIEVEMENTS_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_PROFILE_NON_ACADEMIC_ACHIEVEMENTS_PRIVILEGES", facultyProfileNonAcademicAchievementsPrivileges);
		
		// faculty portal 
		facultyPortalNonAcademicAchievementsPrivileges = new Ext.util.HashMap();
		facultyPortalNonAcademicAchievementsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_NON_ACADEMIC_ACHIEVEMENTS_VIEW,"VIEW");
		facultyPortalNonAcademicAchievementsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_NON_ACADEMIC_ACHIEVEMENTS_CREATE,"CREATE");
		facultyPortalNonAcademicAchievementsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_NON_ACADEMIC_ACHIEVEMENTS_UPDATE,"UPDATE");
		facultyPortalNonAcademicAchievementsPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_NON_ACADEMIC_ACHIEVEMENTS_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_PORTAL_NON_ACADEMIC_ACHIEVEMENTS_PRIVILEGES", facultyPortalNonAcademicAchievementsPrivileges);
		
		facultyQualificationDetailPrivileges = new Ext.util.HashMap();
		facultyQualificationDetailPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_QUALIFICATION_DETAILS_VIEW,"VIEW");
		facultyQualificationDetailPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_QUALIFICATION_DETAILS_CREATE,"CREATE");
		facultyQualificationDetailPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_QUALIFICATION_DETAILS_UPDATE,"UPDATE");
		facultyQualificationDetailPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_QUALIFICATION_DETAILS_DELETE,"DELETE");
		facultyQualificationDetailPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_QUALIFICATION_DETAILS_DATA_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_QUALIFICATION_DETAILS_PRIVILEGES",facultyQualificationDetailPrivileges);
		
		/***************Faculty Personal Details Sections************/
		facultyPortalPersonalDetailsSection = new Ext.util.HashMap();
		facultyPortalPersonalDetailsSection.add(FPCONSTANTS.FP_M9_F_FACULTY_PERSONAL_DETAILS_SECTION_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_PERSONAL_DETAILS_SECTION_PRIVILEGES", facultyPortalPersonalDetailsSection);
		
		facultyPortalContactInfoSection = new Ext.util.HashMap();
		facultyPortalContactInfoSection.add(FPCONSTANTS.FP_M9_F_FACULTY_CONTACT_INFORMATION_SECTION_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_CONTACT_INFO_SECTION_PRIVILEGES", facultyPortalContactInfoSection);
		
		facultyPortalBankDetailsSection = new Ext.util.HashMap();
		facultyPortalBankDetailsSection.add(FPCONSTANTS.FP_M9_F_FACULTY_BANK_DETAILS_SECTION_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_BANK_DETAILS_SECTION_PRIVILEGES", facultyPortalBankDetailsSection);
		
		facultyPortalOtherDetailsSection = new Ext.util.HashMap();
		facultyPortalOtherDetailsSection.add(FPCONSTANTS.FP_M9_F_FACULTY_OTHER_DETAILS_SECTION_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_OTHER_DETAILS_SECTION_PRIVILEGES", facultyPortalOtherDetailsSection);
		
		/***************Faculty Communication History************/
		// faculty profile 
		facultyProfileCommunicationHistoryPrivileges = new Ext.util.HashMap();
		facultyProfileCommunicationHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COMMUNICATION_HISTORY_VIEW,"VIEW");
		facultyProfileCommunicationHistoryPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_COMMUNICATION_HISTORY_EXPORT_REPORTS,"EXPORT_REPORTS");
		featurePrivilegesMap.add("FACULTY_PROFILE_COMMUNICATION_HISTORY_PRIVILEGES", facultyProfileCommunicationHistoryPrivileges);
		
		/***************Employee References ************/
		// faculty profile 
		employeeReferencesPrivileges = new Ext.util.HashMap();
		employeeReferencesPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REFERENCES_VIEW,"VIEW");
		employeeReferencesPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REFERENCES_CREATE,"CREATE");
		employeeReferencesPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REFERENCES_UPDATE,"UPDATE");
		employeeReferencesPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REFERENCES_DELETE,"DELETE");
		employeeReferencesPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_REFERENCES_RESENDLINK,"RESENDLINK");
		featurePrivilegesMap.add("EMPLOYEE_REFERENCES_PRIVILEGES", employeeReferencesPrivileges);
		
		
		/***********************Start LM Leave Approval Setup & LM Employee Request Pending Action***********************************/
		leaveApprovalSetupPrivileges = new Ext.util.HashMap();
		leaveApprovalSetupPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_APPROVAL_SETUP_VIEWCONFIGURE,"VIEWCONFIGURE");
		leaveApprovalSetupPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_APPROVAL_SETUP_EXPORT,"EXPORT");
		leaveApprovalSetupPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_APPROVAL_SETUP_DELETE,"DELETE");
		//leaveApprovalSetupPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_APPROVAL_SETUP_REQUEST_FOR,"FOR_OTHER_EMPLOYEE");
		featurePrivilegesMap.add("LEAVE_APPROVAL_SETUP_PRIVILEGES", leaveApprovalSetupPrivileges);
		
		lmFacultyPortalLeaveRequestTabPrivileges = new Ext.util.HashMap();
		lmFacultyPortalLeaveRequestTabPrivileges.add(FPCONSTANTS.FP_M9_F_LEAVE_REQUEST_TAB_REQUEST_PENDING_FOR,"FOR_OTHER_EMPLOYEE");
		featurePrivilegesMap.add("LM_FP_LEAVE_REQUEST_TAB_PRIVILEGES", lmFacultyPortalLeaveRequestTabPrivileges);
		
		lmFacultyPortalRequestPendingActionPrivileges = new Ext.util.HashMap();
		lmFacultyPortalRequestPendingActionPrivileges.add(FPCONSTANTS.FP_M9_F_LEAVE_REQUEST_VIEW,"VIEW");
		lmFacultyPortalRequestPendingActionPrivileges.add(FPCONSTANTS.FP_M9_F_REQUESTS_PENDING_ACTION_EXPORT,"EXPORT");
		lmFacultyPortalRequestPendingActionPrivileges.add(FPCONSTANTS.FP_M9_F_REQUESTS_PENDING_ACTION_REQUEST_PENDING_FOR,"FOR_OTHER_EMPLOYEE");
		lmFacultyPortalRequestPendingActionPrivileges.add(FPCONSTANTS.FP_M9_F_REQUESTS_PENDING_ACTION_CANCEL,"CANCEL");
		featurePrivilegesMap.add("LM_FP_REQUEST_PENDING_ACTION_PRIVILEGES", lmFacultyPortalRequestPendingActionPrivileges);
		
		lmEmployeeLeaveRequestTabPrivileges = new Ext.util.HashMap();
		lmEmployeeLeaveRequestTabPrivileges.add(FPCONSTANTS.PF_M8_F_LEAVE_REQUEST_TAB_REQUEST_PENDING_FOR,"FOR_OTHER_EMPLOYEE");
		featurePrivilegesMap.add("LM_EMPLOYEE_LEAVE_REQUEST_TAB_PRIVILEGES", lmEmployeeLeaveRequestTabPrivileges);
		
		lmEmployeeRequestPendingActionPrivileges = new Ext.util.HashMap();
		lmEmployeeRequestPendingActionPrivileges.add(FPCONSTANTS.PF_M8_F_EMPLOYEE_LEAVE_REQUEST_VIEW,"VIEW");
		lmEmployeeRequestPendingActionPrivileges.add(FPCONSTANTS.PF_M8_F_REQUESTS_PENDING_ACTION_EXPORT,"EXPORT");
		lmEmployeeRequestPendingActionPrivileges.add(FPCONSTANTS.PF_M8_F_REQUESTS_PENDING_ACTION_REQUEST_PENDING_FOR,"FOR_OTHER_EMPLOYEE");
		lmEmployeeRequestPendingActionPrivileges.add(FPCONSTANTS.PF_M8_F_REQUESTS_PENDING_ACTION_CANCEL,"CANCEL");
		featurePrivilegesMap.add("LM_EMPLOYEE_REQUEST_PENDING_ACTION_PRIVILEGES", lmEmployeeRequestPendingActionPrivileges);
		/******************************End*******************************************/
		
		/*****************************HR My Timesheet and My Attendance****************************/
		
		lmFacultyPortalMyTimesheetPrivileges = new Ext.util.HashMap();
		lmFacultyPortalMyTimesheetPrivileges.add(FPCONSTANTS.FP_M9_F_MY_TIMESHEET_VIEW,"VIEW");
		lmFacultyPortalMyTimesheetPrivileges.add(FPCONSTANTS.FP_M9_F_MY_TIMESHEET_EXPORT,"EXPORT");
		featurePrivilegesMap.add("LM_FP_MY_TIMESHEET_PRIVILEGES", lmFacultyPortalMyTimesheetPrivileges);
		
		lmFacultyPortalMyAttendancePrivileges = new Ext.util.HashMap();
		lmFacultyPortalMyAttendancePrivileges.add(FPCONSTANTS.FP_M9_F_MY_ATTENDANCE_VIEW,"VIEW");
		lmFacultyPortalMyAttendancePrivileges.add(FPCONSTANTS.FP_M9_F_MY_ATTENDANCE_EXPORT_REPORTS,"EXPORTREPORTS");
		featurePrivilegesMap.add("LM_FP_MY_ATTENDANCE_PRIVILEGES", lmFacultyPortalMyAttendancePrivileges);
		
		lmFacultyPortalAttendancePunchLogTabPrivileges = new Ext.util.HashMap();
		lmFacultyPortalAttendancePunchLogTabPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_PUNCH_LOG_TAB_VIEW,"VIEW");
		lmFacultyPortalAttendancePunchLogTabPrivileges.add(FPCONSTANTS.FP_M9_F_ATTENDANCE_PUNCH_LOG_TAB_EXPORT,"EXPORT");
		featurePrivilegesMap.add("HRM_FP_MY_ATTENDANCE_PUNCH_LOG_TAB_PRIVILEGES", lmFacultyPortalAttendancePunchLogTabPrivileges);
		
		lmFacultyPortalAttendancePaymentReportPrivileges = new Ext.util.HashMap();
		lmFacultyPortalAttendancePaymentReportPrivileges.add(FPCONSTANTS.FP_M9_F_IC_ATTENDANCE_AND_PAYMENT_REPORT_VIEW,"VIEW");
		lmFacultyPortalAttendancePaymentReportPrivileges.add(FPCONSTANTS.FP_M9_F_IC_ATTENDANCE_AND_PAYMENT_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("HRM_FP_MY_ATTENDANCE_AND_PAYMENT_REPORT_PRIVILEGES", lmFacultyPortalAttendancePaymentReportPrivileges);
		
		
		
		
		/******************************************************************************************/
		
		/*********************** Start Leave General Setting ***********************************/
		employeeLeaveGeneralSettingPrivileges = new Ext.util.HashMap();
		employeeLeaveGeneralSettingPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_GENERAL_SETTINGS_VIEW,"VIEW");
		featurePrivilegesMap.add("EMPLOYEE_LEAVE_GENERAL_SETTINGS_PRIVILEGES", employeeLeaveGeneralSettingPrivileges);
		/******************************End*******************************************/
		
		/*********************** Start Leave Credit Setting ***********************************/
		employeeLeaveCreditSettingPrivileges = new Ext.util.HashMap();
		employeeLeaveCreditSettingPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_CREDIT_SETTINGS_VIEW,"VIEW");
		employeeLeaveCreditSettingPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_CREDIT_SETTINGS_CREATE,"CREATE");
		employeeLeaveCreditSettingPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_CREDIT_SETTINGS_UPDATE,"UPDATE");
		employeeLeaveCreditSettingPrivileges.add(FPCONSTANTS.PF_M8_R_LEAVE_CREDIT_SETTINGS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EMPLOYEE_LEAVE_CREDIT_SETTINGS_PRIVILEGES", employeeLeaveCreditSettingPrivileges);
		/******************************End*******************************************/
		
		/*********************** Start Employee Manage Appointment ***********************************/
		employeeManageAppointmentPrivileges = new Ext.util.HashMap();
		employeeManageAppointmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_APPOINTMENT_VIEW,"VIEW");
		employeeManageAppointmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_APPOINTMENT_CREATE,"CREATE");
		employeeManageAppointmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_APPOINTMENT_UPDATE,"UPDATE");
		employeeManageAppointmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_APPOINTMENT_DELETE,"DELETE");
		employeeManageAppointmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MANAGE_APPOINTMENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_MANAGE_APPOINTMENT_PRIVILEGES", employeeManageAppointmentPrivileges);
		
		manageAppointmentPrivileges = new Ext.util.HashMap();
		manageAppointmentPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_MANAGE_APPOINTMENT_VIEW,"VIEW");
		manageAppointmentPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_MANAGE_APPOINTMENT_CREATE,"CREATE");
		manageAppointmentPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_MANAGE_APPOINTMENT_UPDATE,"UPDATE");
		manageAppointmentPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_MANAGE_APPOINTMENT_DELETE,"DELETE");
		manageAppointmentPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_MANAGE_APPOINTMENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("MANAGE_APPOINTMENT_PRIVILEGES", manageAppointmentPrivileges);
		
		enquiryManageAppointmentPrivileges = new Ext.util.HashMap();
		enquiryManageAppointmentPrivileges.add(FPCONSTANTS.PC_M2_F_LEAD_MANAGE_APPOINTMENT_VIEW,"VIEW");
		enquiryManageAppointmentPrivileges.add(FPCONSTANTS.PC_M2_F_LEAD_MANAGE_APPOINTMENT_CREATE,"CREATE");
		enquiryManageAppointmentPrivileges.add(FPCONSTANTS.PC_M2_F_LEAD_MANAGE_APPOINTMENT_UPDATE,"UPDATE");
		enquiryManageAppointmentPrivileges.add(FPCONSTANTS.PC_M2_F_LEAD_MANAGE_APPOINTMENT_DELETE,"DELETE");
		enquiryManageAppointmentPrivileges.add(FPCONSTANTS.PC_M2_F_LEAD_MANAGE_APPOINTMENT_EXPORT,"EXPORT");
		enquiryManageAppointmentPrivileges.add(FPCONSTANTS.PC_M2_F_LEAD_MANAGE_APPOINTMENT_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("ENQUIRY_MANAGE_APPOINTMENT_PRIVILEGES", enquiryManageAppointmentPrivileges);
		
		applicantSelectionSnapshotPrivileges = new Ext.util.HashMap();
		applicantSelectionSnapshotPrivileges.add(FPCONSTANTS.PC_M2_F_SELECTION_SNAPSHOT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICANT_SELECTION_SNAPSHOT_PRIVILEGES", applicantSelectionSnapshotPrivileges);
		
		applicantManageAppointmentPrivileges = new Ext.util.HashMap();
		applicantManageAppointmentPrivileges.add(FPCONSTANTS.PC_M2_F_APPLICANT_MANAGE_APPOINTMENT_VIEW,"VIEW");
		applicantManageAppointmentPrivileges.add(FPCONSTANTS.PC_M2_F_APPLICANT_MANAGE_APPOINTMENT_CREATE,"CREATE");
		applicantManageAppointmentPrivileges.add(FPCONSTANTS.PC_M2_F_APPLICANT_MANAGE_APPOINTMENT_UPDATE,"UPDATE");
		applicantManageAppointmentPrivileges.add(FPCONSTANTS.PC_M2_F_APPLICANT_MANAGE_APPOINTMENT_DELETE,"DELETE");
		applicantManageAppointmentPrivileges.add(FPCONSTANTS.PC_M2_F_APPLICANT_MANAGE_APPOINTMENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPLICANT_MANAGE_APPOINTMENT_PRIVILEGES", applicantManageAppointmentPrivileges);
		
		applicantPortalManageAppointmentPrivileges = new Ext.util.HashMap();
		applicantPortalManageAppointmentPrivileges.add(FPCONSTANTS.AC_M31_F_APPOINTMENT_VIEW,"VIEW");
		applicantPortalManageAppointmentPrivileges.add(FPCONSTANTS.AC_M31_F_APPOINTMENT_CREATE,"CREATE");
		applicantPortalManageAppointmentPrivileges.add(FPCONSTANTS.AC_M31_F_APPOINTMENT_UPDATE,"UPDATE");
		applicantPortalManageAppointmentPrivileges.add(FPCONSTANTS.AC_M31_F_APPOINTMENT_DELETE,"DELETE");
		applicantPortalManageAppointmentPrivileges.add(FPCONSTANTS.AC_M31_F_APPOINTMENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPLICANT_PORTAL_MANAGE_APPOINTMENT_PRIVILEGES", applicantPortalManageAppointmentPrivileges);
		
		/******************************End*******************************************/
		receiptSettingsPrivileges=new Ext.util.HashMap();
		/*receiptSettingsPrivileges.add(FPCONSTANTS.PC_M12_F_RECEIPTSETTING_VIEW, "VIEW");
		receiptSettingsPrivileges.add(FPCONSTANTS.PC_M12_F_RECEIPTSETTING_CREATE, "CREATE");
		receiptSettingsPrivileges.add(FPCONSTANTS.PC_M12_F_RECEIPTSETTING_UPDATE, "UPDATE");
		receiptSettingsPrivileges.add(FPCONSTANTS.PC_M12_F_RECEIPTSETTING_DELETE, "DELETE");*/
		receiptSettingsPrivileges.add(FPCONSTANTS.PC_M12_F_RECEIPTSETTING_CREDIT_FEE_MAPPING, "CREDIT_FEE_MAPPING");
		receiptSettingsPrivileges.add(FPCONSTANTS.PC_M12_F_RECEIPTSETTING_CONFIGURE_FEE_HEAD, "CONFIGURE_FEE_HEAD");
		receiptSettingsPrivileges.add(FPCONSTANTS.PC_M12_F_RECEIPTSETTING_AUTO_SETTLEMENT_JOB_CONFIGURATION, "AUTO_SETTLEMENT_JOB_CONFIGURATION");
		receiptSettingsPrivileges.add(FPCONSTANTS.PC_M12_F_RECEIPTSETTING_FEES_AND_PAYMENT_OTHER_SETTINGS, "FEES_AND_PAYMENT_OTHER_SETTINGS");
		featurePrivilegesMap.add("RECEIPT_SETTINGS_PRIVILEGES", receiptSettingsPrivileges);
		
		billSettingsPrivileges= new Ext.util.HashMap();
		billSettingsPrivileges.add(FPCONSTANTS.PC_M12_F_BILLSETTING_BILL_GENERATION_ON_SUBMIT_APPLICATION, "BILL_GENERATION_ON_SUBMIT_APPLICATION");
		featurePrivilegesMap.add("BILL_SETTINGS_PRIVILEGES", billSettingsPrivileges);
		/******************************End*******************************************/
		
		translationSettingsPrivileges=new Ext.util.HashMap();
		translationSettingsPrivileges.add(FPCONSTANTS.PC_M2_F_TRANSLATIONSETTING_VIEW, "VIEW");
		featurePrivilegesMap.add("TRANSLATION_SETTINGS_PRIVILEGES", translationSettingsPrivileges);
		
		// applicant portal persoanl details
		applicantPortalPersonalInfoPrivileges = new Ext.util.HashMap();
		applicantPortalPersonalInfoPrivileges.add(FPCONSTANTS.AC_M1_F_PERSTONAL_DETAILS_VIEW,"VIEW");
		applicantPortalPersonalInfoPrivileges.add(FPCONSTANTS.AC_M1_F_PERSTONAL_DETAILS_VERIFYDETAILS,"VERIFY_DETAILS_BUTTON");
		applicantPortalPersonalInfoPrivileges.add(FPCONSTANTS.AC_M1_F_PERSTONAL_DETAILS_SAVE,"SAVE");
		applicantPortalPersonalInfoPrivileges.add(FPCONSTANTS.AC_M1_F_PERSTONAL_DETAILS_PROFILE_PRINT,"ProfilePrint");
		featurePrivilegesMap.add("APPLICANT_PORTAL_PERSONAL_INFORMATION_PRIVILEGES", applicantPortalPersonalInfoPrivileges);
		
		/***********************start EXAM ASSESSMENT GROUP MARKSHEET ***********************************/
		assessmentGroupMarksheet = new Ext.util.HashMap();
		assessmentGroupMarksheet.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_GROUP_MARKSHEET_VIEW,"VIEW");
		assessmentGroupMarksheet.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_GROUP_MARKSHEET_CREATE,"CREATE");
		assessmentGroupMarksheet.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_GROUP_MARKSHEET_UPDATE,"UPDATE");
		assessmentGroupMarksheet.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_GROUP_MARKSHEET_GENERATE,"GENERATE");
		assessmentGroupMarksheet.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_GROUP_MARKSHEET_EXPORT,"EXPORT");
		assessmentGroupMarksheet.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_GROUP_MARKSHEET_GENERATEANDDOWNLOADMARKSHEET,"GENERATEANDDOWNLOADMARKSHEET");
		assessmentGroupMarksheet.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_GROUP_MARKSHEET_PUBLISHMARKSHEET,"PUBLISHMARKSHEET");
		assessmentGroupMarksheet.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_GROUP_MARKSHEET_DOWNLOADMARKSHEETS,"DOWNLOADMARKSHEETS");
		featurePrivilegesMap.add("ASSESSMENT_GROUP_MARKSHEET_PRIVILEGES", assessmentGroupMarksheet);
		/******************************End*******************************************/
	
		
		examinationSubjectLevelRemarkReportPrivileges = new Ext.util.HashMap();
		examinationSubjectLevelRemarkReportPrivileges.add(FPCONSTANTS.PC_M5_F_SUBJECT_LEVEL_REMARK_REPORT,"SUBJECT_LEVEL_REMARK_REPORT");
		examinationSubjectLevelRemarkReportPrivileges.add(FPCONSTANTS.PC_M5_F_SUBJECT_LEVEL_REMARK_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_SUBJECT_LEVEL_REMARK_REPORT_PRIVILEGES", examinationSubjectLevelRemarkReportPrivileges);
        
		
		studentProjectedBillingReportPrivileges = new Ext.util.HashMap();
		studentProjectedBillingReportPrivileges.add(FPCONSTANTS.SP_M11_PROJECTED_BILLING_REPORT_VIEW,"VIEW");
		studentProjectedBillingReportPrivileges.add(FPCONSTANTS.SP_M11_PROJECTED_BILLING_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PROJECTED_BILLING_REPORT_PRIVILEGES", studentProjectedBillingReportPrivileges);
        
		
		/***********************start Manage Marks Moderation ***********************************/
		manageMarksModeration = new Ext.util.HashMap();
		manageMarksModeration.add(FPCONSTANTS.PC_M5_F_MANAGE_MARKS_MODERATION_VIEW,"VIEW");
		manageMarksModeration.add(FPCONSTANTS.PC_M5_F_MANAGE_MARKS_MODERATION_DELETE,"DELETE");
		manageMarksModeration.add(FPCONSTANTS.PC_M5_F_MANAGE_MARKS_MODERATION_EXPORT,"EXPORT");
		manageMarksModeration.add(FPCONSTANTS.PC_M5_F_MANAGE_MARKS_MODERATION_APPLYCHANGES,"APPLYCHANGES");
		manageMarksModeration.add(FPCONSTANTS.PC_M5_F_MANAGE_MARKS_MODERATION_EDIT,"EDIT");
		manageMarksModeration.add(FPCONSTANTS.PC_M5_F_MANAGE_MARKS_MODERATION_SAVE,"SAVE");
		manageMarksModeration.add(FPCONSTANTS.PC_M5_F_MANAGE_MARKS_MODERATION_IMPORT_MARKS_MODERATION, "IMPORT_MARKS_MODERATION");
		manageMarksModeration.add(FPCONSTANTS.PC_M5_F_MANAGE_MARKS_MODERATION_PROGRAM_LEVEL_MARKS_MODERATION, "PROGRAM_LEVEL_MARKS_MODERATION");
		featurePrivilegesMap.add("MANAGE_MARKS_MODERATION_PRIVILEGES", manageMarksModeration);
		
		/* For Porgam Level REMARK */ 
		programManageMarksModeration = new Ext.util.HashMap();
		programManageMarksModeration.add(FPCONSTANTS.PC_M5_F_PROGRAM_MANAGE_MARKS_MODERATION_DELETE,"DELETE");
		programManageMarksModeration.add(FPCONSTANTS.PC_M5_F_PROGRAM_MANAGE_MARKS_MODERATION_EXPORT,"EXPORT");
		programManageMarksModeration.add(FPCONSTANTS.PC_M5_F_PROGRAM_MANAGE_MARKS_MODERATION_APPLYCHANGES,"APPLYCHANGES");
		programManageMarksModeration.add(FPCONSTANTS.PC_M5_F_PROGRAM_MANAGE_MARKS_MODERATION_EDIT,"EDIT");
		programManageMarksModeration.add(FPCONSTANTS.PC_M5_F_PROGRAM_MANAGE_MARKS_MODERATION_SAVE,"SAVE");
		featurePrivilegesMap.add("PROGRAM_MANAGE_MARKS_MODERATION_PRIVILEGES", programManageMarksModeration);
		
		/******************************End*******************************************/
		
		/****** For Application Conditions For Admission***********/
		applicationConditionsForAdmissionPrivileges = new Ext.util.HashMap();
		applicationConditionsForAdmissionPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CONDITIONS_FOR_ADMISSION_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICANT_CONDITIONS_FOR_ADMISSION_PRIVILEGES", applicationConditionsForAdmissionPrivileges);
		
		/****** For Application Program Wise Conditions For Admission***********/
		applicationPWConditionsForAdmissionPrivileges = new Ext.util.HashMap();
		applicationPWConditionsForAdmissionPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_PW_CONDITIONS_FOR_ADMISSION_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICATION_PROGRAM_WISE_CONDITIONS_REVIEW_DETAILS_PRIVILEGES", applicationPWConditionsForAdmissionPrivileges);
		
		/****** For Application Review Detail***********/
		applicationReviewDetailPrivileges = new Ext.util.HashMap();
		applicationReviewDetailPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REVIEW_DETAILS_VIEW,"VIEW");
		applicationReviewDetailPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REVIEW_DETAILS_CREATE,"CREATE");
		applicationReviewDetailPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_REVIEW_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("APPLICATION_REVIEW_DETAILS_PRIVILEGES", applicationReviewDetailPrivileges);
		
		applicantDocumentsAndNotes = new Ext.util.HashMap();
		applicantDocumentsAndNotes.add(FPCONSTANTS.PC_M3_F_APPLICANT_DOCUMENTS_AND_NOTES_VIEW,"VIEW");
		applicantDocumentsAndNotes.add(FPCONSTANTS.PC_M3_F_APPLICANT_DOCUMENTS_AND_NOTES_CREATE,"CREATE");
		applicantDocumentsAndNotes.add(FPCONSTANTS.PC_M3_F_APPLICANT_DOCUMENTS_AND_NOTES_UPDATE,"UPDATE");
		applicantDocumentsAndNotes.add(FPCONSTANTS.PC_M3_F_APPLICANT_DOCUMENTS_AND_NOTES_DELETE,"DELETE");
		applicantDocumentsAndNotes.add(FPCONSTANTS.PC_M3_F_APPLICANT_DOCUMENTS_AND_NOTES_EXPORT,"EXPORT");
		applicantDocumentsAndNotes.add(FPCONSTANTS.PC_M3_F_APPLICANT_DOCUMENTS_AND_NOTES_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICANT_DOCUMENTS_AND_NOTES_PRIVILEGES", applicantDocumentsAndNotes);
		
		applicantTransferCredits = new Ext.util.HashMap();
		applicantTransferCredits.add(FPCONSTANTS.PC_M3_F_APPLICANT_TRANSFER_CREDITS_VIEW,"VIEW");
		applicantTransferCredits.add(FPCONSTANTS.PC_M3_F_APPLICANT_TRANSFER_CREDITS_APPROVE,"APPROVE");
		applicantTransferCredits.add(FPCONSTANTS.PC_M3_F_APPLICANT_TRANSFER_CREDITS_REJECT,"REJECT");
		applicantTransferCredits.add(FPCONSTANTS.PC_M3_F_APPLICANT_TRANSFER_CREDITS_RESUBMIT,"RESUBMIT");
		applicantTransferCredits.add(FPCONSTANTS.PC_M3_F_APPLICANT_TRANSFER_CREDITS_MARK_AS_REPEAT,"MARK_AS_REPEAT");
		applicantTransferCredits.add(FPCONSTANTS.PC_M3_F_APPLICANT_TRANSFER_CREDITS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICANT_TRANSFER_CREDITS_PRIVILEGES", applicantTransferCredits);
		
		/****** For Application Eligibility Details***********/
		applicationEligibilityDetailsPrivileges = new Ext.util.HashMap();
		applicationEligibilityDetailsPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_ELIGIBILITY_DETAILS_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICATIONS_ELIGIBILITY_DETAILS_PRIVILEGES", applicationEligibilityDetailsPrivileges);
		
		/****** For Application Conditions Review Detail***********/
		applicationConditionsReviewDetailPrivileges = new Ext.util.HashMap();
		applicationConditionsReviewDetailPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CONDITIONS_REVIEW_DETAILS_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICATION_CONDITIONS_REVIEW_DETAILS_PRIVILEGES", applicationConditionsReviewDetailPrivileges);
		
		/****** For Student Conditions For Admission***********/
		studentConditionsForAdmissionPrivileges = new Ext.util.HashMap();
		studentConditionsForAdmissionPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_CONDITIONS_FOR_ADMISSION_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_CONDITIONS_FOR_ADMISSION_PRIVILEGES", studentConditionsForAdmissionPrivileges);
		
		/****** For Student Degree Audit Report***********/
		degreeAuditReportPrivileges = new Ext.util.HashMap();
		degreeAuditReportPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DEGREE_AUDIT_REPORT_VIEW,"VIEW");
		degreeAuditReportPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_DEGREE_AUDIT_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EXAMINATION_DEGREE_AUDIT_REPORT_PRIVILEGES", degreeAuditReportPrivileges);
		
		/****** For Student Biometric Machine Details***********/
		studentBMDetailsPrivileges = new Ext.util.HashMap();
		studentBMDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_BM_DETAILS_VIEW,"VIEW");
		studentBMDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_BM_DETAILS_EXPORT,"EXPORT");
		studentBMDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_BM_DETAILS_CREATE,"CREATE");
		studentBMDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_BM_DETAILS_EDIT,"EDIT");
		featurePrivilegesMap.add("STUDENT_BM_DETAILS_PRIVILEGES", studentBMDetailsPrivileges);
		
		employeeBMDetailsPrivileges = new Ext.util.HashMap();
		employeeBMDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_BIOMETRIC_MACHINE_DETAILS_VIEW,"VIEW");
		employeeBMDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_BIOMETRIC_MACHINE_DETAILS_EXPORT,"EXPORT");
		employeeBMDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_BIOMETRIC_MACHINE_DETAILS_CREATE,"CREATE");
		employeeBMDetailsPrivileges.add(FPCONSTANTS.PF_M8_F_FACULTY_BIOMETRIC_MACHINE_DETAILS_EDIT,"EDIT");
		featurePrivilegesMap.add("EMPLOYEE_BM_DETAILS_PRIVILEGES", employeeBMDetailsPrivileges);
		
		/****** For Examination Grade Average  Report ***********/
		examGradeAverageReport = new Ext.util.HashMap();
		examGradeAverageReport.add(FPCONSTANTS.PC_M5_F_GRADE_AVERAGE_REPORT,"GRADE_AVERAGE_REPORT");
		examGradeAverageReport.add(FPCONSTANTS.PC_M5_F_GRADE_AVERAGE_REPORT_EXPORT,"EXPORT");
		examGradeAverageReport.add(FPCONSTANTS.PC_M5_F_GRADE_AVERAGE_REPORT_EXPORT_REPORTS,"EXPORT_REPORTS");
		featurePrivilegesMap.add("EXAMINATION_GRADE_AVERAGE_REPORT_PRIVILEGES", examGradeAverageReport);
		
		/***********************start Manage Finance Hold ***********************************/
		manageFinanceHold = new Ext.util.HashMap();
		manageFinanceHold.add(FPCONSTANTS.PC_M6_F_MANAGEFINANCEHOLD_VIEW,"VIEW");
		manageFinanceHold.add(FPCONSTANTS.PC_M6_F_MANAGEFINANCEHOLD_CREATE,"CREATE");
		manageFinanceHold.add(FPCONSTANTS.PC_M6_F_MANAGEFINANCEHOLD_UPDATE,"UPDATE");
		manageFinanceHold.add(FPCONSTANTS.PC_M6_F_MANAGEFINANCEHOLD_DELETE,"DELETE");
		manageFinanceHold.add(FPCONSTANTS.PC_M6_F_MANAGEFINANCEHOLD_APPLICABLEFOR,"APPLICABLEFOR");
		manageFinanceHold.add(FPCONSTANTS.PC_M6_F_MANAGEFINANCEHOLD_EXPORT,"EXPORT");
		manageFinanceHold.add(FPCONSTANTS.PC_M6_F_MANAGEFINANCEHOLD_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_FINANCE_HOLD_PRIVILEGES", manageFinanceHold);
		/******************************End*******************************************/

		/***********************start Manage Finance Hold Apply To***********************************/
		manageFinanceHoldApplyTo = new Ext.util.HashMap();
		manageFinanceHoldApplyTo.add(FPCONSTANTS.PC_M6_F_MANAGEFINANCEHOLD_APPLYTO_VIEW,"VIEW");
		manageFinanceHoldApplyTo.add(FPCONSTANTS.PC_M6_F_MANAGEFINANCEHOLD_APPLYTO_CREATE,"CREATE");		
		manageFinanceHoldApplyTo.add(FPCONSTANTS.PC_M6_F_MANAGEFINANCEHOLD_APPLYTO_DELETE,"DELETE");
		manageFinanceHoldApplyTo.add(FPCONSTANTS.PC_M6_F_MANAGEFINANCEHOLD_APPLYTO_EXPORT,"EXPORT");
		featurePrivilegesMap.add("MANAGE_FINANCE_HOLD_APPLY_TO_PRIVILEGES", manageFinanceHoldApplyTo);
		/******************************End*******************************************/

		/***********************start Manage Finance Hold Blocked Students***********************************/
		manageFinanceHoldBlockedStudents = new Ext.util.HashMap();
		manageFinanceHoldBlockedStudents.add(FPCONSTANTS.PC_M6_F_MANAGEFINANCEHOLDBLOCKEDSTUDENTS_UNBLOCK,"UNBLOCK");
		manageFinanceHoldBlockedStudents.add(FPCONSTANTS.PC_M6_F_MANAGEFINANCEHOLDBLOCKEDSTUDENTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("MANAGE_FINANCE_HOLD_BLOCKED_STUDENTS_PRIVILEGES", manageFinanceHoldBlockedStudents);
		/******************************End*******************************************/
		
		/*************************** Start Service Opt In Report***********************************/
		studentServiceOptInReportPrivileges = new Ext.util.HashMap();
		studentServiceOptInReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_SERVICE_OPT_IN_REPORT_VIEW,"VIEW");
		studentServiceOptInReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_SERVICE_OPT_IN_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_SERVICE_OPT_IN_REPORTS_PRIVILEGES", studentServiceOptInReportPrivileges);
		/*************************************END**********************************************/
		
		/*************************** Start Student Identity Document Report***********************************/
		studentIdentityDocumentReportPrivileges = new Ext.util.HashMap();
		studentIdentityDocumentReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_IDENTITY_DOCUMENT_REPORT_VIEW,"VIEW");
		studentIdentityDocumentReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_IDENTITY_DOCUMENT_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_IDENTITY_DOCUMENT_REPORTS_PRIVILEGES", studentIdentityDocumentReportPrivileges);
		/*************************************END**********************************************/
		
		/****** For Resource Availability Report ***********/
		resourceAvailabilityReportPrivileges = new Ext.util.HashMap();
		resourceAvailabilityReportPrivileges.add(FPCONSTANTS.PC_M7_R_RESOURCE_AVAILABILITY_REPORT_VIEW,"VIEW");
		resourceAvailabilityReportPrivileges.add(FPCONSTANTS.PC_M7_R_RESOURCE_AVAILABILITY_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("RESOURCE_AVAILABILITY_REPORT_PRIVILEGES", resourceAvailabilityReportPrivileges);
		
		parentPortalHostelDetailsPrivileges = new Ext.util.HashMap();
		parentPortalHostelDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_HOSTEL_DETAILS_VIEW,"VIEW");
		parentPortalHostelDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_HOSTEL_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_HOSTEL_DETAILS_PRIVILEGES", parentPortalHostelDetailsPrivileges);
		
		parentPortalHostelDetailsPrivileges = new Ext.util.HashMap();
		parentPortalHostelDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_HOSTEL_DETAILS_VIEW,"VIEW");
		parentPortalHostelDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_HOSTEL_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_HOSTEL_DETAILS_PRIVILEGES", parentPortalHostelDetailsPrivileges);
		
		parentPortalTransportDetailsPrivileges = new Ext.util.HashMap();
		parentPortalTransportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_TRANSPORT_DETAILS_VIEW,"VIEW");
		parentPortalTransportDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_TRANSPORT_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_TRANSPORT_DETAILS_PRIVILEGES", parentPortalTransportDetailsPrivileges);
		
		
		parentPortalRequestPrivileges = new Ext.util.HashMap();
		parentPortalRequestPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENTREQUEST_VIEW,"VIEW");
		parentPortalRequestPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENTREQUEST_EXPORT,"EXPORT");
		parentPortalRequestPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENTREQUEST_RAISEREQUEST,"RAISEREQUEST");
		parentPortalRequestPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENTREQUEST_CANCELREQUEST,"CANCELREQUEST");
		featurePrivilegesMap.add("PARENT_REQUEST_PRIVILEGES", parentPortalRequestPrivileges);
		
		parentPortalMyCoursePrivileges = new Ext.util.HashMap();
		parentPortalMyCoursePrivileges.add(FPCONSTANTS.PP_M4_F_MYCOURSEMASTER_VIEW, "VIEW");
		parentPortalMyCoursePrivileges.add(FPCONSTANTS.PP_M4_F_MYCOURSEMASTER_EXPORT, "EXPORT");
		parentPortalMyCoursePrivileges.add(FPCONSTANTS.PP_M4_F_MYCOURSEMASTER_DOWNLOADMARKSHEETS, "DOWNLOADMARKSHEETS");
		parentPortalMyCoursePrivileges.add(FPCONSTANTS.PP_M4_F_MYCOURSEMASTER_COURSE_PERIOD_SELECTION, "COURSE_PERIOD_SELECTION");
		parentPortalMyCoursePrivileges.add(FPCONSTANTS.PP_M4_F_MYCOURSEMASTER_DOWNLOADUNOFFICIALTRANSCRIPT, "DOWNLOADUNOFFICIALTRANSCRIPT");
		parentPortalMyCoursePrivileges.add(FPCONSTANTS.PP_M4_F_MYCOURSEMASTER_COURSEWISERADIOBUTTON, "COURSEWISERADIOBUTTON");
		parentPortalMyCoursePrivileges.add(FPCONSTANTS.PP_M4_F_MYCOURSEMASTER_PERIODWISERADIOBUTTON, "PERIODWISERADIOBUTTON");
		parentPortalMyCoursePrivileges.add(FPCONSTANTS.PP_M4_F_MYCOURSEMASTER_REQUESTEXAMCANCELLATIONBUTTON,"REQUESTEXAMCANCELLATIONBUTTON");
		parentPortalMyCoursePrivileges.add(FPCONSTANTS.PP_M4_F_MYCOURSEMASTER_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("PARENT_MYCOURSE_PRIVILEGES", parentPortalMyCoursePrivileges);
		
		
		/***********************For Applicant Document History *********************************************/
		
		/*applicantOnlineDocumentPrivileges = new Ext.util.HashMap();
		applicantOnlineDocumentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_ONLINE_DOCUMENTS_VIEW,"VIEW");
		applicantOnlineDocumentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_ONLINE_DOCUMENTS_CREATE,"CREATE");
		applicantOnlineDocumentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_ONLINE_DOCUMENTS_EDIT,"EDIT");
		applicantOnlineDocumentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_ONLINE_DOCUMENTS_DELETE,"DELETE");
		applicantOnlineDocumentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_ONLINE_DOCUMENTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPLICANT_ONLINE_DOCUMENT_PRIVILEGES", applicantOnlineDocumentPrivileges);
		
		applicantPhysicalDocumentPrivileges = new Ext.util.HashMap();
		applicantPhysicalDocumentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_PHYSICAL_DOCUMENTS_VIEW,"VIEW");
		applicantPhysicalDocumentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_PHYSICAL_DOCUMENTS_CREATE,"CREATE");
		applicantPhysicalDocumentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_PHYSICAL_DOCUMENTS_EDIT,"UPDATE");
		applicantPhysicalDocumentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_PHYSICAL_DOCUMENTS_DELETE,"DELETE");
		applicantPhysicalDocumentPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_PHYSICAL_DOCUMENTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPLICANT_PHYSICAL_DOCUMENT_PRIVILEGES", applicantPhysicalDocumentPrivileges);*/
		
		/**********************************END of Applicant Document History *******************************/
		
        /***********************For Student Document History *********************************************/
		
		studentOnlineDocumentPrivileges = new Ext.util.HashMap();
		studentOnlineDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ONLINE_DOCUMENTS_VIEW,"VIEW");
		studentOnlineDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ONLINE_DOCUMENTS_CREATE,"CREATE");
		studentOnlineDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ONLINE_DOCUMENTS_EDIT,"EDIT");
		studentOnlineDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ONLINE_DOCUMENTS_DELETE,"DELETE");
		studentOnlineDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ONLINE_DOCUMENTS_EXPORT,"EXPORT");
		studentOnlineDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ONLINE_DOCUMENTS_PREDEFINED_DOCUMENTS,"PREDEFINED_DOCUMENTS");
		studentOnlineDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ONLINE_DOCUMENTS_OTHERS,"OTHERS");
		studentOnlineDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_FEE_PAYER_DOCUMENT,"FEE_PAYER_DOCUMENT");
		featurePrivilegesMap.add("STUDENT_ONLINE_DOCUMENT_PRIVILEGES", studentOnlineDocumentPrivileges);
		
		studentPhysicalDocumentPrivileges = new Ext.util.HashMap();
		studentPhysicalDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PHYSICAL_DOCUMENTS_VIEW,"VIEW");
		studentPhysicalDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PHYSICAL_DOCUMENTS_CREATE,"CREATE");
		studentPhysicalDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PHYSICAL_DOCUMENTS_EDIT,"UPDATE");
		studentPhysicalDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PHYSICAL_DOCUMENTS_DELETE,"DELETE");
		studentPhysicalDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PHYSICAL_DOCUMENTS_EXPORT,"EXPORT");
		studentPhysicalDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PHYSICAL_DOCUMENTS_PREDEFINED_DOCUMENTS,"PREDEFINED_DOCUMENTS");
		studentPhysicalDocumentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_PHYSICAL_DOCUMENTS_OTHERS,"OTHERS");
		featurePrivilegesMap.add("STUDENT_PHYSICAL_DOCUMENT_PRIVILEGES", studentPhysicalDocumentPrivileges);
		
		/**********************************END of Student Document History *******************************/
		
		
		positiveIncidentReportPrivileges = new Ext.util.HashMap();
		positiveIncidentReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_POSITIVE_INCIDENTS_REPORT_EXPORT, "EXPORT");
		positiveIncidentReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_POSITIVE_INCIDENTS_REPORT_VIEW, "VIEW");
		positiveIncidentReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_POSITIVE_INCIDENTS_REPORT_EXPORT_REPORTS, "EXPORTREPORTS");
		featurePrivilegesMap.add("POSITIVE_INCIDENTS_REPORT_PRIVILEGES", positiveIncidentReportPrivileges);
		
		disciplinaryActionReportPrivileges = new Ext.util.HashMap();
		disciplinaryActionReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_DISCIPLINARY_ACTIONS_REPORT_EXPORT, "EXPORT");
		disciplinaryActionReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_DISCIPLINARY_ACTIONS_REPORT_VIEW, "VIEW");
		featurePrivilegesMap.add("DISCIPLINARY_ACTION_REPORT_PRIVILEGES", disciplinaryActionReportPrivileges);
		
		disciplinaryActionSUReportPrivileges = new Ext.util.HashMap();
		disciplinaryActionSUReportPrivileges.add(FPCONSTANTS.Ps_M9_R_STD_DISCIPLINARY_ACTIONS_SU_REPORT_VIEW, "VIEW");
		featurePrivilegesMap.add("DISCIPLINARY_ACTION_SU_REPORT_PRIVILEGES", disciplinaryActionSUReportPrivileges);
		
		/********************************* Selection Stage Report In Admission *****************************/ 
		selectionStageAdmissionReport = new Ext.util.HashMap();
		selectionStageAdmissionReport.add(FPCONSTANTS.PC_M3_F_ADMISSION_SELECTIONSTAGE_REPORT_VIEW, "VIEW");
		selectionStageAdmissionReport.add(FPCONSTANTS.PC_M3_F_ADMISSION_SELECTIONSTAGE_REPORT_EXPORT, "EXPORT");
		selectionStageAdmissionReport.add(FPCONSTANTS.PC_M3_F_ADMISSION_SELECTIONSTAGE_REPORT_EXPORT_REPORTS, "EXPORTREPORTS");
		featurePrivilegesMap.add("STUDENT_SELECTIONSTAGE_REPORT_PRIVILEDGE", selectionStageAdmissionReport);
		
		/**********************************END of Selection Stage Report *******************************/
		
		linkAcademyLocationMappingPrivileges=new Ext.util.HashMap();
		linkAcademyLocationMappingPrivileges.add(FPCONSTANTS.PC_M5_F_LINK_ACADEMY_LOCATIONS_MAPPING_EXPORT, "EXPORT");
		linkAcademyLocationMappingPrivileges.add(FPCONSTANTS.PC_M5_F_LINK_ACADEMY_LOCATIONS_MAPPING_SAVE, "SAVE");
		featurePrivilegesMap.add("LINK_ACADEMY_LOCATIONS_MAPPING_PRIVILEGES", linkAcademyLocationMappingPrivileges);
		
		assessmentSchemeHierarchyPrivileges = new Ext.util.HashMap();
		assessmentSchemeHierarchyPrivileges.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_SCHEME_HIERARCHY_MORE_CREATE,"CREATE");
		assessmentSchemeHierarchyPrivileges.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_SCHEME_HIERARCHY_MORE_UPDATE,"UPDATE");
		assessmentSchemeHierarchyPrivileges.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_SCHEME_HIERARCHY_MORE_VIEW,"VIEW");
		assessmentSchemeHierarchyPrivileges.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_SCHEME_HIERARCHY_MORE_DELETE,"DELETE");
		featurePrivilegesMap.add("ASSESSMENT_SCHEME_HIERARCHY_MORE_PRIVILEGES", assessmentSchemeHierarchyPrivileges);
		
		parentPhysicalCharacteristicPrivileges = new Ext.util.HashMap();
		parentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_VIEW,"VIEW");
		parentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_EXPORT,"EXPORT");
		parentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_CREATE,"CREATE");
		parentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_UPDATE,"UPDATE");
		parentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_DELETE,"DELETE");
		featurePrivilegesMap.add("PARENT_PHYSICAL_CHARACTERISTICS_PRIVILEGES", parentPhysicalCharacteristicPrivileges);
		
		parentEducationPrivileges = new Ext.util.HashMap();
		parentEducationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_EDUCATION_VIEW,"VIEW");
		parentEducationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_EDUCATION_EXPORT,"EXPORT");
		parentEducationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_EDUCATION_CREATE,"CREATE");
		parentEducationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_EDUCATION_UPDATE,"UPDATE");
		featurePrivilegesMap.add("PARENT_EDUCATION_PRIVILEGES", parentEducationPrivileges);
		
		parentWorkExperiencePrivileges = new Ext.util.HashMap();
		parentWorkExperiencePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_WORK_EXPERIENCE_VIEW,"VIEW");
		parentWorkExperiencePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_WORK_EXPERIENCE_EXPORT,"EXPORT");
		parentWorkExperiencePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_WORK_EXPERIENCE_CREATE,"CREATE");
		parentWorkExperiencePrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_WORK_EXPERIENCE_UPDATE,"UPDATE");
		featurePrivilegesMap.add("PARENT_WORK_EXPERIENCE_PRIVILEGES", parentWorkExperiencePrivileges);
		
		parentMedicalPrivileges = new Ext.util.HashMap();
		parentMedicalPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_MEDICAL_VIEW,"VIEW");
		parentMedicalPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_MEDICAL_EXPORT,"EXPORT");
		parentMedicalPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_MEDICAL_CREATE,"CREATE");
		parentMedicalPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_MEDICAL_UPDATE,"UPDATE");
		featurePrivilegesMap.add("PARENT_MEDICAL_PRIVILEGES", parentMedicalPrivileges);
		
		parentVaccinationPrivileges = new Ext.util.HashMap();
		parentVaccinationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_VACCINATION_VIEW,"VIEW");
		parentVaccinationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_VACCINATION_EXPORT,"EXPORT");
		parentVaccinationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_VACCINATION_CREATE,"CREATE");
		parentVaccinationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_VACCINATION_UPDATE,"UPDATE");
		featurePrivilegesMap.add("PARENT_VACCINATION_PRIVILEGES", parentVaccinationPrivileges);
		
		parentExtraCurricularActivityPrivileges = new Ext.util.HashMap();
		parentExtraCurricularActivityPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_VIEW,"VIEW");
		parentExtraCurricularActivityPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_EXPORT,"EXPORT");
		parentExtraCurricularActivityPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_CREATE,"CREATE");
		parentExtraCurricularActivityPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_UPDATE,"UPDATE");
		featurePrivilegesMap.add("PARENT_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES", parentExtraCurricularActivityPrivileges);
		
		parentInfirmaryDetailsPrivileges = new Ext.util.HashMap();
		parentInfirmaryDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_INFIRMARY_DETAILS_VIEW,"VIEW");
		parentInfirmaryDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_INFIRMARY_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_INFIRMARY_DETAILS_PRIVILEGES", parentInfirmaryDetailsPrivileges);
		
		parentInfirmaryInterventionDetailsPrivileges = new Ext.util.HashMap();
		parentInfirmaryInterventionDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_VIEW,"VIEW");
		parentInfirmaryInterventionDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_INFIRMARY_INTERVENTION_DETAILS_PRIVILEGES", parentInfirmaryInterventionDetailsPrivileges);
		
		parentPendingBillsPrivileges = new Ext.util.HashMap();
		parentPendingBillsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PENDING_BILLS_VIEW,"VIEW");
		parentPendingBillsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PENDING_BILLS_EXPORT,"EXPORT");
		parentPendingBillsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PENDING_BILLS_PRINT,"PRINT");
		parentPendingBillsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PENDING_BILLS_PRINT_TAX_CERTIFICATE,"PRINT_TAX_CERTIFICATE");
		featurePrivilegesMap.add("PARENT_PENDING_BILLS_PRIVILEGES", parentPendingBillsPrivileges);
		
		parentOnlinePaymentsPrivileges = new Ext.util.HashMap();
		parentOnlinePaymentsPrivileges.add(FPCONSTANTS.PP_M11_F_ONLINEPAYMENTS_VIEW,"VIEW");
		parentOnlinePaymentsPrivileges.add(FPCONSTANTS.PP_M11_F_ONLINEPAYMENTS_MAKE_PAYMENT,"MAKE_PAYMENT");
		parentOnlinePaymentsPrivileges.add(FPCONSTANTS.PP_M11_F_ONLINEPAYMENTS_MAKE_PAYMENT_VIA_PAYTM,"MAKE_PAYMENT_VIA_PAYTM");
		parentOnlinePaymentsPrivileges.add(FPCONSTANTS.PP_M11_F_ONLINEPAYMENTS_MAKE_PAYMENT_VIA_TECH_PROCESS,"MAKE_PAYMENT_VIA_TECH_PROCESS");
		featurePrivilegesMap.add("PARENT_ONLINE_PAYMENTS_PRIVILEGES", parentOnlinePaymentsPrivileges);
		
		parentPersonalDetailsPrivileges = new Ext.util.HashMap();
		parentPersonalDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PERSONAL_DETAILS_VIEW,"VIEW");
		parentPersonalDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PERSONAL_DETAILS_SAVEBUTTON,"SAVEBUTTON");
		parentPersonalDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PERSONAL_DETAILS_VERIFY_DETAILS_BUTTON,"VERIFY_DETAILS_BUTTON");
		parentPersonalDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PERSONAL_DETAILS_SNAPSHOT_BUTTON,"SNAPSHOT");
		parentPersonalDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PERSONAL_DETAILS_PHOTOUPLOAD_BUTTON,"PHOTO_UPLOAD");
		parentPersonalDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PERSONAL_DETAILS_REMOVE_BUTTON,"REMOVEBUTTON");
		featurePrivilegesMap.add("PARENT_PERSONAL_DETAILS_PRIVILEGES", parentPersonalDetailsPrivileges);
		
		lessonPlanningPrivileges = new Ext.util.HashMap();
		lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_VIEW,"VIEW");
		lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_CREATE,"CREATE");
		lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_EDIT,"UPDATE");
		lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_DELETE,"DELETE");
		lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_EXPORT,"EXPORT");
		lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_EXPORT_REPORTS,"EXPORT_REPORTS");
		lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_VALIDATE,"VALIDATE");
        lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_PUBLISH,"PUBLISH");
        lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_UNVALIDATE,"UNVALIDATE");
        lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_UNPUBLISH,"UNPUBLISH");
        lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLANNING_GRID_CONFIGURATION,"GRID_CONFIGURATION");
        lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_IS_VALIDATION_REQUIRED,"IS_VALIDATION_REQUIRED");
		lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_RESTRICT_MULTIPLE_LP,"RESTRICT_MULTIPLE_LP");
		lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_COURSE_DESCRIPTOR_REPORT,"COURSE_DESCRIPTOR_REPORT");
		lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_ASSESSMENT_MAP_REPORT,"ASSESSMENT_MAP_REPORT");
		lessonPlanningPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLAN_BULK_COPY,"BULK_COPY");
		featurePrivilegesMap.add("LESSON_PLANNING_PRIVILEGES", lessonPlanningPrivileges);
		
		lessonPlanningFacultyPrivileges = new Ext.util.HashMap();
		lessonPlanningFacultyPrivileges.add(FPCONSTANTS.FP_M4_F_LESSON_FACULTY_PLAN_VIEW,"VIEW");
		lessonPlanningFacultyPrivileges.add(FPCONSTANTS.FP_M4_F_LESSON_FACULTY_PLAN_CREATE,"CREATE");
		lessonPlanningFacultyPrivileges.add(FPCONSTANTS.FP_M4_F_LESSON_FACULTY_PLAN_EDIT,"UPDATE");
		lessonPlanningFacultyPrivileges.add(FPCONSTANTS.FP_M4_F_LESSON_FACULTY_PLAN_DELETE,"DELETE");
		lessonPlanningFacultyPrivileges.add(FPCONSTANTS.FP_M4_F_LESSON_FACULTY_PLAN_EXPORT,"EXPORT");
		lessonPlanningFacultyPrivileges.add(FPCONSTANTS.FP_M4_F_LESSON_FACULTY_PLAN_EXPORT_REPORTS,"EXPORT_REPORTS");
		lessonPlanningFacultyPrivileges.add(FPCONSTANTS.FP_M4_F_LESSON_FACULTY_PLAN_PUBLISH,"PUBLISH");
		lessonPlanningFacultyPrivileges.add(FPCONSTANTS.FP_M4_F_LESSON_FACULTY_PLAN_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		lessonPlanningFacultyPrivileges.add(FPCONSTANTS.FP_M4_F_LESSON_FACULTY_PLAN_IS_VALIDATION_REQUIRED,"IS_VALIDATION_REQUIRED");
		lessonPlanningFacultyPrivileges.add(FPCONSTANTS.FP_M4_F_LESSON_FACULTY_PLAN_RESTRICT_MULTIPLE_LP,"RESTRICT_MULTIPLE_LP");
		lessonPlanningFacultyPrivileges.add(FPCONSTANTS.FP_M4_F_LESSON_FACULTY_PLAN_COURSE_DESCRIPTOR_REPORT,"COURSE_DESCRIPTOR_REPORT");
		lessonPlanningFacultyPrivileges.add(FPCONSTANTS.FP_M4_F_LESSON_FACULTY_PLAN_ASSESSMENT_MAP_REPORT,"ASSESSMENT_MAP_REPORT");
		featurePrivilegesMap.add("LESSON_PLANNING_FACULTY_PRIVILEGES", lessonPlanningFacultyPrivileges);
		
		lessonPlanningDetailFormPrivileges = new Ext.util.HashMap();
		lessonPlanningDetailFormPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLANNING_DETAIL_ADD_EXAM_DETAIL,"ADDEXAMDETAILBUTTON");
		lessonPlanningDetailFormPrivileges.add(FPCONSTANTS.PC_M4_F_LESSON_PLANNING_DETAIL_RESIT_DETAIL,"RESITDETAILBUTTON");
		featurePrivilegesMap.add("LESSON_PLANNING_DETAIL_FROM_BUTTON_PRIVILEGES",lessonPlanningDetailFormPrivileges);
		
		lessonPlanningFacultyDetailFormPrivileges = new Ext.util.HashMap();
		lessonPlanningFacultyDetailFormPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_LESSON_PLANNING_DETAIL_RESIT_DETAIL,"RESITDETAILBUTTON");
		featurePrivilegesMap.add("LESSON_PLANNING_FACULTY_DETAIL_FROM_BUTTON_PRIVILEGES",lessonPlanningFacultyDetailFormPrivileges);
		
		/********************************* Program Batches Associated *****************************/ 
		programBatchAssociatedReport = new Ext.util.HashMap();
		programBatchAssociatedReport.add(FPCONSTANTS.PC_M4_R_PROGRAM_REPORT_BATCH_ASSOCIATED_LINK, "LINK");
		programBatchAssociatedReport.add(FPCONSTANTS.PC_M4_R_PROGRAM_REPORT_BATCH_ASSOCIATED_EXPORT, "EXPORT");
		featurePrivilegesMap.add("PROGRAM_BATCH_ASSOCIATED_PRIVILIGES", programBatchAssociatedReport);
		
		/**********************************END of Program Batches Associated *******************************/
		
		/********************************* Program Periods Associated *****************************/ 
		programPeriodAssociatedReport = new Ext.util.HashMap();
		programPeriodAssociatedReport.add(FPCONSTANTS.PC_M4_R_PROGRAM_REPORT_PERIOD_ASSOCIATED_LINK, "LINK");
		programPeriodAssociatedReport.add(FPCONSTANTS.PC_M4_R_PROGRAM_REPORT_PERIOD_ASSOCIATED_EXPORT, "EXPORT");
		featurePrivilegesMap.add("PROGRAM_PERIOD_ASSOCIATED_PRIVILIGES", programPeriodAssociatedReport);
		
		/**********************************END of Program Periods Associated *******************************/
		
		/********************************* Program Exam Center Associated *****************************/ 
		programExamCenterAssociatedReport = new Ext.util.HashMap();
		programExamCenterAssociatedReport.add(FPCONSTANTS.PC_M4_R_PROGRAM_REPORT_EXAM_CENTERS_ASSOCIATED_LINK, "LINK");
		programExamCenterAssociatedReport.add(FPCONSTANTS.PC_M4_R_PROGRAM_REPORT_EXAM_CENTERS_ASSOCIATED_EXPORT, "EXPORT");
		featurePrivilegesMap.add("PROGRAM_EXAM_CENTER_ASSOCIATED_PRIVILIGES", programExamCenterAssociatedReport);
		
		/**********************************END of Program Exam Center Associated *******************************/
		
		/********************************* Program Sections Associated *****************************/ 
		programSectionAssociatedReport = new Ext.util.HashMap();
		programSectionAssociatedReport.add(FPCONSTANTS.PC_M4_R_PROGRAM_REPORT_SECTIONS_ASSOCIATED_ASSOCIATED_LINK, "LINK");
		programSectionAssociatedReport.add(FPCONSTANTS.PC_M4_R_PROGRAM_REPORT_SECTIONS_ASSOCIATED_ASSOCIATED_EXPORT, "EXPORT");
		featurePrivilegesMap.add("PROGRAM_SECTION_ASSOCIATED_PRIVILIGES", programSectionAssociatedReport);
		
		/**********************************END of Program Sections Associated *******************************/
		
		/********************************* Program Specialization Associated *****************************/ 
		programSpecializationAssociatedReport = new Ext.util.HashMap();
		programSpecializationAssociatedReport.add(FPCONSTANTS.PC_M4_R_PROGRAM_REPORT_SPECIALIZATION_AVAILABLE_LINK, "LINK");
		programSpecializationAssociatedReport.add(FPCONSTANTS.PC_M4_R_PROGRAM_REPORT_SPECIALIZATION_AVAILABLE_EXPORT, "EXPORT");
		featurePrivilegesMap.add("PROGRAM_SPECIALIZATION_ASSOCIATED_PRIVILIGES", programSpecializationAssociatedReport);
		
		/**********************************END of Program Exam Center Associated *******************************/
		
		/********************************* COLLPOLL Reports *****************************/ 
		facultyDetailReport = new Ext.util.HashMap();
		facultyDetailReport.add(FPCONSTANTS.PC_M4_R_FACULTY_DETAIL_REPORT_LINK, "LINK");
		facultyDetailReport.add(FPCONSTANTS.PC_M4_R_FACULTY_DETAIL_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("FACULTY_DETAIL_PRIVILIGES", facultyDetailReport);
		
		courseDetailReport = new Ext.util.HashMap();
		courseDetailReport.add(FPCONSTANTS.PC_M4_R_COURSE_DETAIL_REPORT_LINK, "LINK");
		courseDetailReport.add(FPCONSTANTS.PC_M4_R_COURSE_DETAIL_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("COURSE_DETAIL_PRIVILIGES", courseDetailReport);
		
		departmentDetailReport = new Ext.util.HashMap();
		departmentDetailReport.add(FPCONSTANTS.PC_M4_R_DEPARTMENT_DETAIL_REPORT_LINK, "LINK");
		departmentDetailReport.add(FPCONSTANTS.PC_M4_R_DEPARTMENT_DETAIL_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("DEPARTMENT_DETAIL_PRIVILIGES", departmentDetailReport);
		
		sectionDetailReport = new Ext.util.HashMap();
		sectionDetailReport.add(FPCONSTANTS.PC_M4_R_SECTION_DETAIL_REPORT_LINK, "LINK");
		sectionDetailReport.add(FPCONSTANTS.PC_M4_R_SECTION_DETAIL_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("SECTION_DETAIL_PRIVILIGES", sectionDetailReport);
		
		programDetailReport = new Ext.util.HashMap();
		programDetailReport.add(FPCONSTANTS.PC_M4_R_PROGRAM_DETAIL_REPORT_LINK, "LINK");
		programDetailReport.add(FPCONSTANTS.PC_M4_R_PROGRAM_DETAIL_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("PROGRAM_DETAIL_PRIVILIGES", programDetailReport);
		
		/**********************************END of COLLPOLL Reports *******************************/
		
		parentFeePayerDetailPrivileges = new Ext.util.HashMap();
		parentFeePayerDetailPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_FEE_PAYER_DETAILS_VIEW,"VIEW");
		parentFeePayerDetailPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_FEE_PAYER_DETAILS_CREATE,"CREATE");
		parentFeePayerDetailPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_FEE_PAYER_DETAILS_UPDATE,"UPDATE");
		parentFeePayerDetailPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_FEE_PAYER_DETAILS_DELETE,"DELETE");
		parentFeePayerDetailPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_FEE_PAYER_DETAILS_CORPORATE_ID,"CORPORATE_ID");
		featurePrivilegesMap.add("PARENT_FEE_PAYER_DETAILS_PRIVILEGES", parentFeePayerDetailPrivileges);
		
		
		parentCurrentGradeTermPrivileges = new Ext.util.HashMap();
		parentCurrentGradeTermPrivileges.add(FPCONSTANTS.PP_M9_F_PARENT_CURRENT_GRADE_PAYMENT_TERM_Enroll,"Enroll");
		featurePrivilegesMap.add("PARENT_CURRENT_GRADE_PAYMENT_TERM_PRIVILEGES", parentCurrentGradeTermPrivileges);
		
		parentMedicalDetailPrivileges = new Ext.util.HashMap();
		parentMedicalDetailPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_MEDICAL_DETAIL_VIEW,"VIEW");
		parentMedicalDetailPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_MEDICAL_DETAIL_SAVE,"SAVE");
		featurePrivilegesMap.add("PARENT_MEDICAL_DETAIL_PRIVILEGES", parentMedicalDetailPrivileges);
		
		parentServiceOptPrivileges = new Ext.util.HashMap();
		parentServiceOptPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SERVICE_OPT_VIEW,"VIEW");
		parentServiceOptPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SERVICE_OPT_EXPORT,"EXPORT");
		parentServiceOptPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SERVICE_OPT_CREATE,"CREATE");
		parentServiceOptPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SERVICE_OPT_UPDATE,"UPDATE");
		featurePrivilegesMap.add("PARENT_SERVICE_OPT_PRIVILEGES", parentServiceOptPrivileges);
		
		parentCommunitiesOptPrivileges = new Ext.util.HashMap();
		parentCommunitiesOptPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_COMMUNITIES_OPT_VIEW,"VIEW");
		parentCommunitiesOptPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_COMMUNITIES_OPT_EXPORT,"EXPORT");
		parentCommunitiesOptPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_COMMUNITIES_OPT_CREATE,"CREATE");
		parentCommunitiesOptPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_COMMUNITIES_OPT_UPDATE,"UPDATE");
		featurePrivilegesMap.add("PARENT_COMMUNITIES_OPT_PRIVILEGES", parentCommunitiesOptPrivileges);
		
		facultyMarksheetReportPrivileges = new Ext.util.HashMap();
		facultyMarksheetReportPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARKSHEET_REPORT_VIEW,"VIEW");
		facultyMarksheetReportPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARKSHEET_REPORT_EXPORT,"EXPORT");
		facultyMarksheetReportPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_MARKSHEET_REPORT_DOWNLOADMARKSHEETS,"DOWNLOADMARKSHEETS");
		featurePrivilegesMap.add("FACULTY_MARKSHEET_REPORT_PRIVILEGES", facultyMarksheetReportPrivileges);
		
		negativeIncidentReportPrivileges = new Ext.util.HashMap();
		negativeIncidentReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_NEGATIVE_INCIDENTS_REPORT_VIEW, "VIEW");
		negativeIncidentReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_NEGATIVE_INCIDENTS_REPORT_EXPORT, "EXPORT");
		negativeIncidentReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_NEGATIVE_INCIDENTS_REPORT_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		negativeIncidentReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_NEGATIVE_INCIDENTS_REPORT_SENDMESSAGE, "SENDMESSAGE");
		featurePrivilegesMap.add("NEGATIVE_INCIDENTS_REPORT_PRIVILEGES", negativeIncidentReportPrivileges);
		
		studentPortalInfirmaryManageEntries = new Ext.util.HashMap();
		studentPortalInfirmaryManageEntries.add(FPCONSTANTS.SP_M9_F_STUDENT_INFIRMARY_DETAILS_VIEW, "VIEW");
		studentPortalInfirmaryManageEntries.add(FPCONSTANTS.SP_M9_F_STUDENT_INFIRMARY_DETAILS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_INFIRMARY_MANAGE_ENTRIES_PRIVILEGES", studentPortalInfirmaryManageEntries);
		
		studentProfileInfirmaryManageEntriesDownload = new Ext.util.HashMap();
		studentProfileInfirmaryManageEntriesDownload.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_DETAILS_DOC_DOWNLOADALL, "DOWNLOADALL");
		studentProfileInfirmaryManageEntriesDownload.add(FPCONSTANTS.PS_M9_F_STUDENT_INFIRMARY_DETAILS_DOC_DOWNLOADALL_DELETE, "DELETE");
		featurePrivilegesMap.add("STUDENT_PROFILE_INFIRMARY_MANAGE_ENTRIES_DOWNLOAD_PRIVILEGES", studentProfileInfirmaryManageEntriesDownload);
		
		studentPortalInfirmaryManageEntriesDownload = new Ext.util.HashMap();
		studentPortalInfirmaryManageEntriesDownload.add(FPCONSTANTS.SP_M9_F_STUDENT_INFIRMARY_DETAILS_DOC_DOWNLOADALL, "DOWNLOADALL");
		studentPortalInfirmaryManageEntriesDownload.add(FPCONSTANTS.SP_M9_F_STUDENT_INFIRMARY_DETAILS_DOC_DOWNLOADALL_DELETE, "DELETE");
		featurePrivilegesMap.add("STUDENT_PORTAL_INFIRMARY_MANAGE_ENTRIES_DOWNLOAD_PRIVILEGES", studentPortalInfirmaryManageEntriesDownload);
		
		infirmaryManageEntriesFacultyPortal = new Ext.util.HashMap();
		infirmaryManageEntriesFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_DETAILS_VIEW, "VIEW");
		infirmaryManageEntriesFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_DETAILS_CREATE, "CREATE");
		infirmaryManageEntriesFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_DETAILS_UPDATE, "UPDATE");
		infirmaryManageEntriesFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_DETAILS_DELETE, "DELETE");
		infirmaryManageEntriesFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_DETAILS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_INFIRMARY_MANAGE_ENTRIES_PRIVILEGES", infirmaryManageEntriesFacultyPortal);
		
		infirmaryManageEntriesInterventionFacultyPortal = new Ext.util.HashMap();
		infirmaryManageEntriesInterventionFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_VIEW, "VIEW");
		infirmaryManageEntriesInterventionFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_CREATE, "CREATE");
		infirmaryManageEntriesInterventionFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_UPDATE, "UPDATE");
		infirmaryManageEntriesInterventionFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_DELETE, "DELETE");
		infirmaryManageEntriesInterventionFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_INFIRMARY_INTERVENTION_MANAGE_ENTRIES_PRIVILEGES", infirmaryManageEntriesInterventionFacultyPortal);
		
		infirmaryManageEntriesDownloadFacultyPortal = new Ext.util.HashMap();
		infirmaryManageEntriesDownloadFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_DETAILS_DOC_DOWNLOADALL, "DOWNLOADALL");
		infirmaryManageEntriesDownloadFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_DETAILS_DOC_DOWNLOADALL_DELETE, "DELETE");
		featurePrivilegesMap.add("FACULTY_PORTAL_INFIRMARY_MANAGE_ENTRIES_DOWNLOAD_PRIVILEGES", infirmaryManageEntriesDownloadFacultyPortal);
		
		infirmaryManageEntriesInterventionDownloadFacultyPortal = new Ext.util.HashMap();
		infirmaryManageEntriesInterventionDownloadFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_DOC_DOWNLOADALL, "DOWNLOADALL");
		infirmaryManageEntriesInterventionDownloadFacultyPortal.add(FPCONSTANTS.FP_M9_F_STUDENT_INFIRMARY_INTERVENTION_DETAILS_DOC_DOWNLOADALL_DELETE, "DELETE");
		featurePrivilegesMap.add("FACULTY_PORTAL_INFIRMARY_INTERVENTION_MANAGE_ENTRIES_DOWNLOAD_PRIVILEGES", infirmaryManageEntriesInterventionDownloadFacultyPortal);
		
		/****** For Student Personal Details***********/
		studentPortalStudentPersonalDetailsPrivileges = new Ext.util.HashMap();
		studentPortalStudentPersonalDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PERSONAL_DETAILS_VIEW,"VIEW");
		studentPortalStudentPersonalDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PERSONAL_DETAILS_SAVEBUTTON,"SAVEBUTTON");
		studentPortalStudentPersonalDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PERSONAL_DETAILS_VERIFY_DETAILS_BUTTON,"VERIFY_DETAILS_BUTTON");
		studentPortalStudentPersonalDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PERSONAL_DETAILS_SNAPSHOT_BUTTON,"SNAPSHOT");
		studentPortalStudentPersonalDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PERSONAL_DETAILS_PHOTOUPLOAD_BUTTON,"PHOTO_UPLOAD");
		studentPortalStudentPersonalDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PERSONAL_DETAILS_REMOVE_BUTTON,"REMOVEBUTTON");		
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_PERSONAL_DETAILS_PRIVILEGES", studentPortalStudentPersonalDetailsPrivileges);
		
		/****** For Student Personal Details***********/
		facultyPortalStudentPersonalDetailsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentPersonalDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PERSONAL_DETAILS_VIEW,"VIEW");
		facultyPortalStudentPersonalDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PERSONAL_DETAILS_SAVEBUTTON,"SAVEBUTTON");
		facultyPortalStudentPersonalDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PERSONAL_DETAILS_VERIFYDETAILS,"VERIFY_DETAILS_BUTTON");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_PERSONAL_DETAILS_PRIVILEGES", facultyPortalStudentPersonalDetailsPrivileges);
		
		parentPortalStudentAddressDetailsPrivileges = new Ext.util.HashMap();
		parentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ADDRESSES_VIEW,"VIEW");
		parentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ADDRESSES_CREATE,"CREATE");
		parentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ADDRESSES_UPDATE,"UPDATE");
		parentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ADDRESSES_PRINT,"PRINT");
		parentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ADDRESSES_GOOGLE_ADDRESS,"GOOGLE_ADDRESS");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_ADDRESS_DETAILS_PRIVILEGES", parentPortalStudentAddressDetailsPrivileges);
		
		studentPortalMyCoursePassFailTabPrivileges = new Ext.util.HashMap();
		studentPortalMyCoursePassFailTabPrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_PASSFAIL_TAB_PASS, "PASS");
		studentPortalMyCoursePassFailTabPrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_PASSFAIL_TAB_FAIL,"FAIL");
		studentPortalMyCoursePassFailTabPrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_TAB_LEARNING_TARGETS,"LEARNING_TARGETS");
		featurePrivilegesMap.add("STUDENT_PORTAL_MYCOURSE_PASSFAIL_TAB_PRIVILEGES", studentPortalMyCoursePassFailTabPrivileges);
		
		parentPortalMyCoursePassFailTabPrivileges = new Ext.util.HashMap();
		parentPortalMyCoursePassFailTabPrivileges.add(FPCONSTANTS.PP_M4_F_MYCOURSEMASTER_PASSFAIL_TAB_PASS, "PASS");
		parentPortalMyCoursePassFailTabPrivileges.add(FPCONSTANTS.PP_M4_F_MYCOURSEMASTER_PASSFAIL_TAB_FAIL,"FAIL");
		parentPortalMyCoursePassFailTabPrivileges.add(FPCONSTANTS.PP_M4_F_MYCOURSEMASTER_TAB_LEARNING_TARGETS,"LEARNING_TARGETS");
		featurePrivilegesMap.add("PARENT_PORTAL_MYCOURSE_PASSFAIL_TAB_PRIVILEGES", parentPortalMyCoursePassFailTabPrivileges);
		
		/****** For Student Documents***********/
		studentPortalStudentDocumentsPrivileges = new Ext.util.HashMap();
		studentPortalStudentDocumentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_DOCUMENTS_VIEW,"VIEW");
		studentPortalStudentDocumentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_DOCUMENTS_EXPORT,"EXPORT");
		studentPortalStudentDocumentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_DOCUMENTS_CREATE,"CREATE");
		studentPortalStudentDocumentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_DOCUMENTS_UPDATE,"UPDATE");
		studentPortalStudentDocumentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_DOCUMENTS_PREDEFINED_DOCUMENTS,"PREDEFINED_DOCUMENTS");
		studentPortalStudentDocumentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_DOCUMENTS_OTHERS,"OTHERS");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_DOCUMENTS_PRIVILEGES", studentPortalStudentDocumentsPrivileges);
		
		parentPortalStudentDocumentsPrivileges = new Ext.util.HashMap();
		parentPortalStudentDocumentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_DOCUMENTS_VIEW,"VIEW");
		parentPortalStudentDocumentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_DOCUMENTS_EXPORT,"EXPORT");
		parentPortalStudentDocumentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_DOCUMENTS_CREATE,"CREATE");
		parentPortalStudentDocumentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_DOCUMENTS_UPDATE,"UPDATE");
		parentPortalStudentDocumentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_DOCUMENTS_PREDEFINED_DOCUMENTS,"PREDEFINED_DOCUMENTS");
		parentPortalStudentDocumentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_DOCUMENTS_OTHERS,"OTHERS");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_DOCUMENTS_PRIVILEGES", parentPortalStudentDocumentsPrivileges);
	
		studentPortalPersonalDetailsPrivileges = new Ext.util.HashMap();
		studentPortalPersonalDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PERSONAL_DETAILS_VIEW,"VIEW");
		studentPortalPersonalDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PERSONAL_DETAILS_SAVEBUTTON,"SAVEBUTTON");
		studentPortalPersonalDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PERSONAL_DETAILS_VERIFY_DETAILS_BUTTON,"VERIFY_DETAILS_BUTTON");
		featurePrivilegesMap.add("STUDENT_PORTAL_PERSONAL_DETAILS_PRIVILEGES", studentPortalPersonalDetailsPrivileges);
		
				
		/****** For Student Address for student Portal, Parent Portal, Faculty Portal***********/
		facultyPortalstudentAddressDetailsPrivileges = new Ext.util.HashMap();
		facultyPortalstudentAddressDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_ADDRESSES_VIEW,"VIEW");
		facultyPortalstudentAddressDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_ADDRESSES_UPDATE,"UPDATE");
		facultyPortalstudentAddressDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_ADDRESSES_PRINT,"PRINT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_ADDRESS_DETAILS_PRIVILEGES", facultyPortalstudentAddressDetailsPrivileges);
		
		parentPortalstudentAddressDetailsPrivileges = new Ext.util.HashMap();
		parentPortalstudentAddressDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ADDRESSES_VIEW,"VIEW");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_ADDRESS_DETAILS_PRIVILEGES", parentPortalstudentAddressDetailsPrivileges);
		
		/****** END Student Address for student Portal, Parent Portal, Faculty Portal***********/
		
		/****** For Student Parents & Guardians for student Portal, Parent Portal, Faculty Portal***********/
		studentPortalStudentParentsGuardiansPrivileges = new Ext.util.HashMap();
		studentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PARENTS_GUARDIANS_VIEW,"VIEW");
		studentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PARENTS_GUARDIANS_EXPORT,"EXPORT");
		studentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PARENTS_GUARDIANS_DELETE,"DELETE");
		studentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PARENTS_GUARDIANS_UPDATE,"UPDATE");
		studentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PARENTS_GUARDIANS_CREATE,"CREATE");
		studentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PARENTS_GUARDIANS_CREATELOGIN,"CREATELOGIN");
		studentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PARENTS_GUARDIANS_RESETPASSWORD,"RESETPASSWORD");
		studentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PARENTS_GUARDIANS_VIEW_DETAILS,"VIEW_DETAILS");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_PARENTS_GUARDIANS_PRIVILEGES", studentPortalStudentParentsGuardiansPrivileges);
		
		FacultyPortalStudentParentsGuardiansPrivileges = new Ext.util.HashMap();
		FacultyPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PARENTS_GUARDIANS_VIEW,"VIEW");
		FacultyPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PARENTS_GUARDIANS_DELETE,"DELETE");
		FacultyPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PARENTS_GUARDIANS_UPDATE,"UPDATE");
		FacultyPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PARENTS_GUARDIANS_CREATE,"CREATE");
		FacultyPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PARENTS_GUARDIANS_EXPORT,"EXPORT");
		FacultyPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PARENTS_GUARDIANS_CREATELOGIN,"CREATELOGIN");
		FacultyPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PARENTS_GUARDIANS_RESETPASSWORD,"RESETPASSWORD");
		FacultyPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PARENTS_GUARDIANS_VIEW_DETAILS,"VIEW_DETAILS");
		FacultyPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PARENTS_GUARDIANS_SSOBUTTON,"SSOBUTTON");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_PARENTS_GUARDIANS_PRIVILEGES", FacultyPortalStudentParentsGuardiansPrivileges);
		
		parentPortalStudentParentsGuardiansPrivileges = new Ext.util.HashMap();
		parentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PARENTS_GUARDIANS_VIEW,"VIEW");
		parentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PARENTS_GUARDIANS_EXPORT,"EXPORT");
		parentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PARENTS_GUARDIANS_DELETE,"DELETE");
		parentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PARENTS_GUARDIANS_UPDATE,"UPDATE");
		parentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PARENTS_GUARDIANS_CREATE,"CREATE");
		parentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PARENTS_GUARDIANS_CREATELOGIN,"CREATELOGIN");
		parentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PARENTS_GUARDIANS_RESETPASSWORD,"RESETPASSWORD");
		parentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PARENTS_GUARDIANS_VIEW_DETAILS,"VIEW_DETAILS");
		parentPortalStudentParentsGuardiansPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PARENTS_GUARDIANS_SSOBUTTON,"SSOBUTTON");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_PARENTS_GUARDIANS_PRIVILEGES", parentPortalStudentParentsGuardiansPrivileges);
		/****** END For Student Parents & Guardians for student Portal, Parent Portal, Faculty Portal***********/
		
		
		/****** For Student Siblings for student Portal, Parent Portal, Faculty Portal ***********/
		studentPortalStudentSiblingsPrivileges = new Ext.util.HashMap();
		studentPortalStudentSiblingsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SIBLING_VIEW,"VIEW");
		studentPortalStudentSiblingsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SIBLING_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_SIBLINGS_PRIVILEGES", studentPortalStudentSiblingsPrivileges);
		
		parentPortalStudentSiblingsPrivileges = new Ext.util.HashMap();
		parentPortalStudentSiblingsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SIBLING_VIEW,"VIEW");
		parentPortalStudentSiblingsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SIBLING_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_SIBLINGS_PRIVILEGES", parentPortalStudentSiblingsPrivileges);
		
		facultyPortalStudentSiblingsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentSiblingsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SIBLING_VIEW,"VIEW");
		facultyPortalStudentSiblingsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SIBLING_CREATE,"CREATE");
		facultyPortalStudentSiblingsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SIBLING_UPDATE,"UPDATE");
		facultyPortalStudentSiblingsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SIBLING_DELETE,"DELETE");
		facultyPortalStudentSiblingsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SIBLING_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_SIBLINGS_PRIVILEGES", facultyPortalStudentSiblingsPrivileges);
		/****** END Student Siblings for student Portal, Parent Portal, Faculty Portal ***********/
		
		/****** For Student Identity Details for student Portal, Parent Portal, Faculty Portal ***********/
		studentPortalStudentIdentityDetailsPrivileges = new Ext.util.HashMap();
		studentPortalStudentIdentityDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_IDENTITY_CARDS_DETAILS_VIEW,"VIEW");
		studentPortalStudentIdentityDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_IDENTITY_CARDS_DETAILS_CREATE,"CREATE");
		studentPortalStudentIdentityDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_IDENTITY_CARDS_DETAILS_UPDATE,"UPDATE");
		studentPortalStudentIdentityDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_IDENTITY_CARDS_DETAILS_DELETE,"DELETE");
		studentPortalStudentIdentityDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_IDENTITY_CARDS_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_IDENTITY_DETAILS_PRIVILEGES", studentPortalStudentIdentityDetailsPrivileges);
		
		parentPortalstudentIdentityDetailsPrivileges = new Ext.util.HashMap();
		parentPortalstudentIdentityDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_IDENTITY_CARDS_DETAILS_VIEW,"VIEW");
		parentPortalstudentIdentityDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_IDENTITY_CARDS_DETAILS_CREATE,"CREATE");
		parentPortalstudentIdentityDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_IDENTITY_CARDS_DETAILS_UPDATE,"UPDATE");
		parentPortalstudentIdentityDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_IDENTITY_CARDS_DETAILS_DELETE,"DELETE");
		parentPortalstudentIdentityDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_IDENTITY_CARDS_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_IDENTITY_DETAILS_PRIVILEGES", parentPortalstudentIdentityDetailsPrivileges);
		
		facultyPortalStudentIdentityDetailsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentIdentityDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_IDENTITY_DETAILS_VIEW,"VIEW");
		facultyPortalStudentIdentityDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_IDENTITY_DETAILS_CREATE,"CREATE");
		facultyPortalStudentIdentityDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_IDENTITY_DETAILS_UPDATE,"UPDATE");
		facultyPortalStudentIdentityDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_IDENTITY_DETAILS_DELETE,"DELETE");
		facultyPortalStudentIdentityDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_IDENTITY_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_IDENTITY_DETAILS_PRIVILEGES", facultyPortalStudentIdentityDetailsPrivileges);
		/****** END Student Identity Details for student Portal, Parent Portal, Faculty Portal ***********/
		
		/** Start Student Fee Payer Details for student Portal,Faculty Portal */
		
		studentPortalStudentFeePayerDetailPrivileges = new Ext.util.HashMap();
		studentPortalStudentFeePayerDetailPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_FEE_PAYER_DETAILS_VIEW,"VIEW");
		studentPortalStudentFeePayerDetailPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_FEE_PAYER_DETAILS_CREATE,"CREATE");
		studentPortalStudentFeePayerDetailPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_FEE_PAYER_DETAILS_UPDATE,"UPDATE");
		studentPortalStudentFeePayerDetailPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_FEE_PAYER_DETAILS_DELETE,"DELETE");
		studentPortalStudentFeePayerDetailPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_FEE_PAYER_DETAILS_CORPORATE_ID,"CORPORATE_ID");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_FEE_PAYER_DETAILS_PRIVILEGES", studentPortalStudentFeePayerDetailPrivileges);
		
		facultyPortalStudentFeePayerDetailPrivileges = new Ext.util.HashMap();
		facultyPortalStudentFeePayerDetailPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_FEE_PAYER_DETAILS_VIEW,"VIEW");
		facultyPortalStudentFeePayerDetailPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_FEE_PAYER_DETAILS_CREATE,"CREATE");
		facultyPortalStudentFeePayerDetailPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_FEE_PAYER_DETAILS_UPDATE,"UPDATE");
		facultyPortalStudentFeePayerDetailPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_FEE_PAYER_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_FEE_PAYER_DETAILS_PRIVILEGES", facultyPortalStudentFeePayerDetailPrivileges);
		/** END Student Fee Payer Details for student Portal, Faculty Portal */
		
		/****** For Student Degree Audit Report***********/
		facultyPortelDegreeAuditReportPrivileges = new Ext.util.HashMap();
		facultyPortelDegreeAuditReportPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_DEGREE_AUDIT_REPORT_VIEW,"VIEW");
		facultyPortelDegreeAuditReportPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_DEGREE_AUDIT_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_EXAMINATION_DEGREE_AUDIT_REPORT_PRIVILEGES", facultyPortelDegreeAuditReportPrivileges);
		
	
		
		/** Start Student Other Information for student Portal,Parent Portal,Faculty Portal */
		studentPortalStudentOtherInformationPrivileges = new Ext.util.HashMap();
		studentPortalStudentOtherInformationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_OTHER_INFORMATION_VIEW,"VIEW");
		studentPortalStudentOtherInformationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_OTHER_INFORMATION_SAVE,"SAVE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_OTHER_INFORMATION_PRIVILEGES", studentPortalStudentOtherInformationPrivileges);
		
		parentPortalStudentOtherInformationPrivileges = new Ext.util.HashMap();
		parentPortalStudentOtherInformationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_OTHER_INFORMATION_VIEW,"VIEW");
		parentPortalStudentOtherInformationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_OTHER_INFORMATION_SAVE,"SAVE");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_OTHER_INFORMATION_PRIVILEGES", parentPortalStudentOtherInformationPrivileges);
		
		facultyPortalStudentOtherInformationPrivileges = new Ext.util.HashMap();
		facultyPortalStudentOtherInformationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_OTHER_INFORMATION_VIEW,"VIEW");
		facultyPortalStudentOtherInformationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_OTHER_INFORMATION_SAVE,"SAVE");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_OTHER_INFORMATION_PRIVILEGES", facultyPortalStudentOtherInformationPrivileges);
		/** END Student Other Information for student Portal,Parent Portal,Faculty Portal */
		
		/****** start Student Education for student Portal, Faculty Portal***********/
		studentPortalStudentEducationPrivileges = new Ext.util.HashMap();
		studentPortalStudentEducationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_EDUCATION_VIEW,"VIEW");
		studentPortalStudentEducationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_EDUCATION_EXPORT,"EXPORT");
		studentPortalStudentEducationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_EDUCATION_CREATE,"CREATE");
		studentPortalStudentEducationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_EDUCATION_UPDATE,"UPDATE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_EDUCATION_PRIVILEGES", studentPortalStudentEducationPrivileges);
		
		facultyPortalStudentEducationPrivileges = new Ext.util.HashMap();
		facultyPortalStudentEducationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_EDUCATION_VIEW,"VIEW");
		facultyPortalStudentEducationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_EDUCATION_CREATE,"CREATE");
		facultyPortalStudentEducationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_EDUCATION_UPDATE,"UPDATE");
		facultyPortalStudentEducationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_EDUCATION_DELETE,"DELETE");
		facultyPortalStudentEducationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_EDUCATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_EDUCATION_PRIVILEGES", facultyPortalStudentEducationPrivileges);
		/****** END Student Education for student Portal, Faculty Portal***********/
		
		/****** Start Student Work Experience for student Portal, Faculty Portal***********/
		studentPortalStudentWorkExperiencePrivileges = new Ext.util.HashMap();
		studentPortalStudentWorkExperiencePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_WORK_EXPERIENCE_VIEW,"VIEW");
		studentPortalStudentWorkExperiencePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_WORK_EXPERIENCE_EXPORT,"EXPORT");
		studentPortalStudentWorkExperiencePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_WORK_EXPERIENCE_CREATE,"CREATE");
		studentPortalStudentWorkExperiencePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_WORK_EXPERIENCE_UPDATE,"UPDATE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_WORK_EXPERIENCE_PRIVILEGES", studentPortalStudentWorkExperiencePrivileges);
		
		facultyPortalStudentWorkExperiencePrivileges = new Ext.util.HashMap();
		facultyPortalStudentWorkExperiencePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_WORK_EXPERIENCE_VIEW,"VIEW");
		facultyPortalStudentWorkExperiencePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_WORK_EXPERIENCE_CREATE,"CREATE");
		facultyPortalStudentWorkExperiencePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_WORK_EXPERIENCE_UPDATE,"UPDATE");
		facultyPortalStudentWorkExperiencePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_WORK_EXPERIENCE_DELETE,"DELETE");
		facultyPortalStudentWorkExperiencePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_WORK_EXPERIENCE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_WORK_EXPERIENCE_PRIVILEGES", facultyPortalStudentWorkExperiencePrivileges);
		/****** END Student Work Experience for student Portal, Faculty Portal***********/
		
		/****** start Student Medical for student Portal, Faculty Portal***********/
		studentPortalStudentMedicalPrivileges = new Ext.util.HashMap();
		studentPortalStudentMedicalPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_MEDICAL_VIEW,"VIEW");
		studentPortalStudentMedicalPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_MEDICAL_EXPORT,"EXPORT");
		studentPortalStudentMedicalPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_MEDICAL_CREATE,"CREATE");
		studentPortalStudentMedicalPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_MEDICAL_UPDATE,"UPDATE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_MEDICAL_PRIVILEGES", studentPortalStudentMedicalPrivileges);
		
		facultyPortalStudentMedicalPrivileges = new Ext.util.HashMap();
		facultyPortalStudentMedicalPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MEDICAL_VIEW,"VIEW");
		facultyPortalStudentMedicalPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MEDICAL_CREATE,"CREATE");
		facultyPortalStudentMedicalPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MEDICAL_UPDATE,"UPDATE");
		facultyPortalStudentMedicalPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MEDICAL_DELETE,"DELETE");
		facultyPortalStudentMedicalPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MEDICAL_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_MEDICAL_PRIVILEGES", facultyPortalStudentMedicalPrivileges);
		/****** END Student Medical for student Portal, Faculty Portal***********/
		
		/****** Start Student Vaccination for student Portal, Faculty Portal***********/
		studentPortalStudentVaccinationPrivileges = new Ext.util.HashMap();
		studentPortalStudentVaccinationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_VACCINATION_VIEW,"VIEW");
		studentPortalStudentVaccinationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_VACCINATION_EXPORT,"EXPORT");
		studentPortalStudentVaccinationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_VACCINATION_CREATE,"CREATE");
		studentPortalStudentVaccinationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_VACCINATION_UPDATE,"UPDATE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_VACCINATION_PRIVILEGES", studentPortalStudentVaccinationPrivileges);
		
		facultyPortalStudentVaccinationPrivileges = new Ext.util.HashMap();
		facultyPortalStudentVaccinationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_VACCINATION_VIEW,"VIEW");
		facultyPortalStudentVaccinationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_VACCINATION_CREATE,"CREATE");
		facultyPortalStudentVaccinationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_VACCINATION_UPDATE,"UPDATE");
		facultyPortalStudentVaccinationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_VACCINATION_DELETE,"DELETE");
		facultyPortalStudentVaccinationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_VACCINATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_VACCINATION_PRIVILEGES", facultyPortalStudentVaccinationPrivileges);
		/****** END Student Vaccination for student Portal, Faculty Portal***********/
		
		/****** start Student Extra Curricular Activity for student Portal, Faculty Portal***********/
		studentPortalStudentExtraCurricularActivityPrivileges = new Ext.util.HashMap();
		studentPortalStudentExtraCurricularActivityPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_VIEW,"VIEW");
		studentPortalStudentExtraCurricularActivityPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_EXPORT,"EXPORT");
		studentPortalStudentExtraCurricularActivityPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_CREATE,"CREATE");
		studentPortalStudentExtraCurricularActivityPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_UPDATE,"UPDATE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES", studentPortalStudentExtraCurricularActivityPrivileges);
		
		facultyPortalStudentExtraCurricularActivityPrivileges = new Ext.util.HashMap();
		facultyPortalStudentExtraCurricularActivityPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_VIEW,"VIEW");
		facultyPortalStudentExtraCurricularActivityPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_CREATE,"CREATE");
		facultyPortalStudentExtraCurricularActivityPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_UPDATE,"UPDATE");
		facultyPortalStudentExtraCurricularActivityPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_DELETE,"DELETE");
		facultyPortalStudentExtraCurricularActivityPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_EXTRA_CURRICULAR_ACTIVITY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_EXTRA_CURRICULAR_ACTIVITY_PRIVILEGES", facultyPortalStudentExtraCurricularActivityPrivileges);
		/****** END Student Extra Curricular Activity for student Portal, Faculty Portal***********/
		
		/****** For Student Physical characteristics for student Portal, Faculty Portal***********/
		studentPortalStudentPhysicalCharacteristicPrivileges = new Ext.util.HashMap();
		studentPortalStudentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_VIEW,"VIEW");
		studentPortalStudentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_EXPORT,"EXPORT");
		studentPortalStudentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_CREATE,"CREATE");
		studentPortalStudentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_UPDATE,"UPDATE");
		studentPortalStudentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_DELETE,"DELETE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_PHYSICAL_CHARACTERISTICS_PRIVILEGES", studentPortalStudentPhysicalCharacteristicPrivileges);
		
		facultyPortalStudentPhysicalCharacteristicPrivileges = new Ext.util.HashMap();
		facultyPortalStudentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_VIEW,"VIEW");
		facultyPortalStudentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_EXPORT,"EXPORT");
		facultyPortalStudentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_CREATE,"CREATE");
		facultyPortalStudentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_UPDATE,"UPDATE");
		facultyPortalStudentPhysicalCharacteristicPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PHYSICAL_CHARACTERISTICS_DELETE,"DELETE");
	    featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_PHYSICAL_CHARACTERISTICS_PRIVILEGES", facultyPortalStudentPhysicalCharacteristicPrivileges);
	    /****** END Student Physical characteristics for student Portal, Faculty Portal***********/
	    
	    
	    /****** For Student Research Details for student Portal,Parent portal, Faculty Portal***********/
	    studentPortalStudentResearchDetailsPrivileges = new Ext.util.HashMap();
	    studentPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_RESEARCH_DETAILS_VIEW,"VIEW");
	    studentPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_RESEARCH_DETAILS_EXPORT,"EXPORT");
	    studentPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_RESEARCH_DETAILS_CREATE,"CREATE");
	    studentPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_RESEARCH_DETAILS_UPDATE,"UPDATE");
	    studentPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_RESEARCH_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_RESEARCH_DETAILS_PRIVILEGES", studentPortalStudentResearchDetailsPrivileges);
		
		parentPortalStudentResearchDetailsPrivileges = new Ext.util.HashMap();
		parentPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_RESEARCH_DETAILS_VIEW,"VIEW");
		parentPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_RESEARCH_DETAILS_EXPORT,"EXPORT");
		parentPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_RESEARCH_DETAILS_CREATE,"CREATE");
		parentPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_RESEARCH_DETAILS_UPDATE,"UPDATE");
		parentPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_RESEARCH_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_RESEARCH_DETAILS_PRIVILEGES", parentPortalStudentResearchDetailsPrivileges);
		
		facultyPortalStudentResearchDetailsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_RESEARCH_DETAILS_VIEW,"VIEW");
		facultyPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_RESEARCH_DETAILS_CREATE,"CREATE");
		facultyPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_RESEARCH_DETAILS_UPDATE,"UPDATE");
		facultyPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_RESEARCH_DETAILS_DELETE,"DELETE");
		facultyPortalStudentResearchDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_RESEARCH_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_RESEARCH_DETAILS_PRIVILEGES", facultyPortalStudentResearchDetailsPrivileges);
		/****** END Student Research Details for student Portal,Parent portal, Faculty Portal***********/
		
		/****** For Student SEMINAR Details for student Portal,Parent portal, Faculty Portal ***********/
		studentPortalStudentSeminarDetailsPrivileges = new Ext.util.HashMap();
		studentPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SEMINAR_DETAILS_VIEW,"VIEW");
		studentPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SEMINAR_DETAILS_EXPORT,"EXPORT");
		studentPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SEMINAR_DETAILS_CREATE,"CREATE");
		studentPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SEMINAR_DETAILS_UPDATE,"UPDATE");
		studentPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SEMINAR_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_SEMINAR_DETAILS_PRIVILEGES", studentPortalStudentSeminarDetailsPrivileges);
		
		parentPortalStudentSeminarDetailsPrivileges = new Ext.util.HashMap();
		parentPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SEMINAR_DETAILS_VIEW,"VIEW");
		parentPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SEMINAR_DETAILS_EXPORT,"EXPORT");
		parentPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SEMINAR_DETAILS_CREATE,"CREATE");
		parentPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SEMINAR_DETAILS_UPDATE,"UPDATE");
		parentPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SEMINAR_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_SEMINAR_DETAILS_PRIVILEGES", parentPortalStudentSeminarDetailsPrivileges);
		
		facultyPortalStudentSeminarDetailsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SEMINAR_DETAILS_VIEW,"VIEW");
		facultyPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SEMINAR_DETAILS_CREATE,"CREATE");
		facultyPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SEMINAR_DETAILS_UPDATE,"UPDATE");
		facultyPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SEMINAR_DETAILS_DELETE,"DELETE");
		facultyPortalStudentSeminarDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SEMINAR_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_SEMINAR_DETAILS_PRIVILEGES", facultyPortalStudentSeminarDetailsPrivileges);
		/****** End Student SEMINAR Details for student Portal,Parent portal, Faculty Portal ***********/
		
		/****** For Student Patent for student Portal,Parent portal, Faculty Portal***********/
		studentPortalStudentPatentPrivileges = new Ext.util.HashMap();
		studentPortalStudentPatentPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PATENT_DETAILS_VIEW,"VIEW");
		studentPortalStudentPatentPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PATENT_DETAILS_EXPORT,"EXPORT");
		studentPortalStudentPatentPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PATENT_DETAILS_CREATE,"CREATE");
		studentPortalStudentPatentPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PATENT_DETAILS_UPDATE,"UPDATE");
		studentPortalStudentPatentPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PATENT_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_PATENT_PRIVILEGES", studentPortalStudentPatentPrivileges);
		
		parentPortalStudentPatentPrivileges = new Ext.util.HashMap();
		parentPortalStudentPatentPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PATENT_DETAILS_VIEW,"VIEW");
		parentPortalStudentPatentPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PATENT_DETAILS_EXPORT,"EXPORT");
		parentPortalStudentPatentPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PATENT_DETAILS_CREATE,"CREATE");
		parentPortalStudentPatentPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PATENT_DETAILS_UPDATE,"UPDATE");
		parentPortalStudentPatentPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PATENT_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_PATENT_PRIVILEGES", parentPortalStudentPatentPrivileges);
		
		facultyPortalStudentPatentPrivileges = new Ext.util.HashMap();
		facultyPortalStudentPatentPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PATENT_DETAILS_VIEW,"VIEW");
		facultyPortalStudentPatentPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PATENT_DETAILS_CREATE,"CREATE");
		facultyPortalStudentPatentPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PATENT_DETAILS_UPDATE,"UPDATE");
		facultyPortalStudentPatentPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PATENT_DETAILS_DELETE,"DELETE");
		facultyPortalStudentPatentPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PATENT_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_PATENT_PRIVILEGES", facultyPortalStudentPatentPrivileges);
		/****** End Student Patent for student Portal,Parent portal, Faculty Portal***********/
		
		/****** For Student Training for student Portal,Parent portal, Faculty Portal***********/
		studentPortalStudentTrainingPrivileges = new Ext.util.HashMap();
		studentPortalStudentTrainingPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_TRAINING_DETAILS_VIEW,"VIEW");
		studentPortalStudentTrainingPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_TRAINING_DETAILS_EXPORT,"EXPORT");
		studentPortalStudentTrainingPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_TRAINING_DETAILS_CREATE,"CREATE");
		studentPortalStudentTrainingPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_TRAINING_DETAILS_UPDATE,"UPDATE");
		studentPortalStudentTrainingPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_TRAINING_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_TRAINING_PRIVILEGES", studentPortalStudentTrainingPrivileges);
		
		parentPortalStudentTrainingPrivileges = new Ext.util.HashMap();
		parentPortalStudentTrainingPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_TRAINING_DETAILS_VIEW,"VIEW");
		parentPortalStudentTrainingPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_TRAINING_DETAILS_EXPORT,"EXPORT");
		parentPortalStudentTrainingPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_TRAINING_DETAILS_CREATE,"CREATE");
		parentPortalStudentTrainingPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_TRAINING_DETAILS_UPDATE,"UPDATE");
		parentPortalStudentTrainingPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_TRAINING_DETAILS_DELETE,"DELETE");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_TRAINING_PRIVILEGES", parentPortalStudentTrainingPrivileges);
		
		
		facultyPortalStudentTrainingPrivileges = new Ext.util.HashMap();
		facultyPortalStudentTrainingPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_TRAINING_VIEW,"VIEW");
		facultyPortalStudentTrainingPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_TRAINING_EXPORT,"EXPORT");
		facultyPortalStudentTrainingPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_TRAINING_CREATE,"CREATE");
		facultyPortalStudentTrainingPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_TRAINING_UPDATE,"UPDATE");
		facultyPortalStudentTrainingPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_TRAINING_DELETE,"DELETE");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_TRAINING_PRIVILEGES", facultyPortalStudentTrainingPrivileges);
		/****** End Student Training for student Portal,Parent portal, Faculty Portal***********/
		
		
		/****** For Student Hostel Details Details for student Portal,Faculty Portal***********/
		studentPortalStudentHostelDetailsPrivileges = new Ext.util.HashMap();
		studentPortalStudentHostelDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_HOSTEL_DETAILS_VIEW,"VIEW");
		studentPortalStudentHostelDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_HOSTEL_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_HOSTEL_DETAILS_PRIVILEGES", studentPortalStudentHostelDetailsPrivileges);
		
		facultyPortalStudentHostelDetailsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentHostelDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_HOSTEL_DETAILS_VIEW,"VIEW");
		facultyPortalStudentHostelDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_HOSTEL_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_HOSTEL_DETAILS_PRIVILEGES", facultyPortalStudentHostelDetailsPrivileges);
		/****** End Student Hostel Details Details for student Portal,Faculty Portal***********/
		
        /********* For Student Competitive Exam for student Portal,Parent Portal, Faculty Portal***************/
		studentPortalStudentCompetitiveExamPrivileges = new Ext.util.HashMap();
		studentPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_COMPETITIVE_EXAM_DETAILS_VIEW,"VIEW");
		studentPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_COMPETITIVE_EXAM_DETAILS_CREATE,"CREATE");
		studentPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_COMPETITIVE_EXAM_DETAILS_UPDATE,"UPDATE");
		studentPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_COMPETITIVE_EXAM_DETAILS_DELETE,"DELETE");
		studentPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_COMPETITIVE_EXAM_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_COMPETITIVE_EXAM_PRIVILEGES", studentPortalStudentCompetitiveExamPrivileges);
		
		/********* For Student Non Academic Achievements for student Portal,Parent Portal, Faculty Portal***************/
		studentPortalStudentNonAcademicAchievementsPrivileges = new Ext.util.HashMap();
		studentPortalStudentNonAcademicAchievementsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_NON_ACADEMIC_ACHIEVEMENTS_VIEW,"VIEW");
		studentPortalStudentNonAcademicAchievementsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_NON_ACADEMIC_ACHIEVEMENTS_CREATE,"CREATE");
		studentPortalStudentNonAcademicAchievementsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_NON_ACADEMIC_ACHIEVEMENTS_UPDATE,"UPDATE");
		studentPortalStudentNonAcademicAchievementsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_NON_ACADEMIC_ACHIEVEMENTS_DELETE,"DELETE");
		featurePrivilegesMap.add("STUDENT_PORTAL_NON_ACADEMIC_ACHIEVEMENTS_PRIVILEGES", studentPortalStudentNonAcademicAchievementsPrivileges);
		
		parentPortalStudentCompetitiveExamPrivileges = new Ext.util.HashMap();
		parentPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_COMPETITIVE_EXAM_DETAILS_VIEW,"VIEW");
		parentPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_COMPETITIVE_EXAM_DETAILS_CREATE,"CREATE");
		parentPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_COMPETITIVE_EXAM_DETAILS_UPDATE,"UPDATE");
		parentPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_COMPETITIVE_EXAM_DETAILS_DELETE,"DELETE");
		parentPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_COMPETITIVE_EXAM_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_COMPETITIVE_EXAM_PRIVILEGES", parentPortalStudentCompetitiveExamPrivileges);
		
		facultyPortalStudentCompetitiveExamPrivileges = new Ext.util.HashMap();
		facultyPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_COMPETITIVE_EXAM_VIEW,"VIEW");
		facultyPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_COMPETITIVE_EXAM_CREATE,"CREATE");
		facultyPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_COMPETITIVE_EXAM_UPDATE,"UPDATE");
		facultyPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_COMPETITIVE_EXAM_DELETE,"DELETE");
		facultyPortalStudentCompetitiveExamPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_COMPETITIVE_EXAM_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_COMPETITIVE_EXAM_PRIVILEGES", facultyPortalStudentCompetitiveExamPrivileges);
		 /********* End Student Competitive Exam for student Portal,Parent Portal, Faculty Portal***************/
		
		/** For Student Medical Detail for student Portal,Faculty Portal */
		studentPortalStudentMedicalDetailPrivileges = new Ext.util.HashMap();
		studentPortalStudentMedicalDetailPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_MEDICAL_DETAIL_VIEW,"VIEW");
		studentPortalStudentMedicalDetailPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_MEDICAL_DETAIL_SAVE,"SAVE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_MEDICAL_DETAIL_PRIVILEGES", studentPortalStudentMedicalDetailPrivileges);
		
		facultyPortalStudentMedicalDetailPrivileges = new Ext.util.HashMap();
		facultyPortalStudentMedicalDetailPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MEDICAL_DETAIL_VIEW,"VIEW");
		facultyPortalStudentMedicalDetailPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MEDICAL_DETAIL_SAVE,"SAVE");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_MEDICAL_DETAIL_PRIVILEGES", facultyPortalStudentMedicalDetailPrivileges);
		/** End Student Medical Detail for student Portal,Faculty Portal */
		
		/****** For Student Transport Details for student Portal,Faculty Portal***********/
		studentPortalStudentTransportDetailsPrivileges = new Ext.util.HashMap();
		studentPortalStudentTransportDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_TRANSPORT_DETAILS_VIEW,"VIEW");
		studentPortalStudentTransportDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_TRANSPORT_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_TRANSPORT_DETAILS_PRIVILEGES", studentPortalStudentTransportDetailsPrivileges);
		
		facultyPortalStudentTransportDetailsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentTransportDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_TRANSPORT_DETAILS_VIEW,"VIEW");
		facultyPortalStudentTransportDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_TRANSPORT_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_TRANSPORT_DETAILS_PRIVILEGES", facultyPortalStudentTransportDetailsPrivileges);
		/****** End Student Transport Details for student Portal,Faculty Portal***********/
		
		/*****************Student church info for student Portal, Faculty Portal**********************/
		studentPortalStudentChurchInformationPrivileges = new Ext.util.HashMap();
		studentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_CHURCH_INFORMATION_VIEW,"VIEW");
		studentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_CHURCH_INFORMATION_CREATE,"CREATE");
		studentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_CHURCH_INFORMATION_UPDATE,"UPDATE");
		studentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_CHURCH_INFORMATION_DELETE,"DELETE");
		studentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_CHURCH_INFORMATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_CHURCH_INFORMATION_PRIVILEGES", studentPortalStudentChurchInformationPrivileges);
		
		facultyPortalStudentPortalStudentChurchInformationPrivileges = new Ext.util.HashMap();
		facultyPortalStudentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_CHURCH_INFORMATION_VIEW,"VIEW");
		facultyPortalStudentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_CHURCH_INFORMATION_CREATE,"CREATE");
		facultyPortalStudentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_CHURCH_INFORMATION_UPDATE,"UPDATE");
		facultyPortalStudentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_CHURCH_INFORMATION_DELETE,"DELETE");
		facultyPortalStudentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_CHURCH_INFORMATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_CHURCH_INFORMATION_PRIVILEGES", facultyPortalStudentPortalStudentChurchInformationPrivileges);
		/*****************End Student church info for student Portal , Faculty Portal**********************/
		
		/****** For Student Schedule for Faculty Portal***********/
		facultyPortalStudentSchedulePrivileges = new Ext.util.HashMap();
		facultyPortalStudentSchedulePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SCHEDULE_DETAILS_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_SCHEDULE_DETAILS_PRIVILEGES", facultyPortalStudentSchedulePrivileges);
		/****** End Student Schedule for Faculty Portal***********/
		
		/****** Non academic achievements for Faculty Portal***********/
		facultyPortalNonAcademicAchievementsPrivileges = new Ext.util.HashMap();
		facultyPortalNonAcademicAchievementsPrivileges.add(FPCONSTANTS.FP_M9_F_NON_ACADEMIC_ACHIEVEMENTS_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_NON_ACADEMIC_ACHIEVEMENTS_PRIVILEGES", facultyPortalNonAcademicAchievementsPrivileges);
		/****** End Non academic achievement for Faculty Portal***********/
		
		
		/****** social Economic Information for Faculty Portal***********/
		facultysocialEconomicInformationPrivileges = new Ext.util.HashMap();
		facultysocialEconomicInformationPrivileges.add(FPCONSTANTS.FP_M9_F_SOCIO_ECONOMIC_INFORMATION_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_SOCIO_ECONOMIC_INFORMATION_PRIVILEGES", facultysocialEconomicInformationPrivileges);
		/****** End social Economic Information for Faculty Portal***********/
		
		/****** Post school studies for Faculty Portal***********/
		facultyPostSchoolStudiesPrivileges = new Ext.util.HashMap();
		facultyPostSchoolStudiesPrivileges.add(FPCONSTANTS.FP_M9_F_POST_SCHOOL_STUDIES_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_POST_SCHOOL_STUDIES_PRIVILEGES", facultyPostSchoolStudiesPrivileges);
		/****** Post school studies for Faculty Portal***********/
		
		/****** For Student Attendance for student Portal , Faculty Portal***********/
		studentPortalStudentAttendancePrivileges = new Ext.util.HashMap();
		studentPortalStudentAttendancePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ATTENDANCE_VIEW,"VIEW");
		studentPortalStudentAttendancePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ATTENDANCE_EXPORT, "EXPORT");
		studentPortalStudentAttendancePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ATTENDANCE_PROGRAM_WISE, "PROGRAM_WISE");
		studentPortalStudentAttendancePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ATTENDANCE_COURSE_WISE, "COURSE_WISE");
		studentPortalStudentAttendancePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ATTENDANCE_SESSION_WISE, "SESSION_WISE");
		studentPortalStudentAttendancePrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ATTENDANCE_ATTENDANCE_REGISTER, "ATTENDANCE_REGISTER");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_ATTENDANCE_DETAILS_PRIVILEGES", studentPortalStudentAttendancePrivileges);
		
		facultyPortalStudentAttendancePrivileges = new Ext.util.HashMap();
		facultyPortalStudentAttendancePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_ATTENDANCE_VIEW,"VIEW");
		facultyPortalStudentAttendancePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_ATTENDANCE_EXPORT,"EXPORT");
		facultyPortalStudentAttendancePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_ATTENDANCE_PROGRAM_WISE,"PROGRAM_WISE");
		facultyPortalStudentAttendancePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_ATTENDANCE_COURSE_WISE,"COURSE_WISE");
		facultyPortalStudentAttendancePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_ATTENDANCE_SESSION_WISE,"SESSION_WISE");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_ATTENDANCE_DETAILS_PRIVILEGES", facultyPortalStudentAttendancePrivileges);
		/****** End Student Attendance for student Portal , Faculty Portal***********/
		
		/****** For Student My Course for student Portal , Faculty Portal***********/
		studentPortalMyCoursePrivileges = new Ext.util.HashMap();
		studentPortalMyCoursePrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_EXPORT, "EXPORT");
		studentPortalMyCoursePrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_COURSE_PERIOD_SELECTION, "COURSE_PERIOD_SELECTION");
		studentPortalMyCoursePrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_DOWNLOADMARKSHEETS, "DOWNLOADMARKSHEETS");
		studentPortalMyCoursePrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_DOWNLOADUNOFFICIALTRANSCRIPT, "DOWNLOADUNOFFICIALTRANSCRIPT");
		studentPortalMyCoursePrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_COURSEWISERADIOBUTTON, "COURSEWISERADIOBUTTON");
		studentPortalMyCoursePrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_PERIODWISERADIOBUTTON, "PERIODWISERADIOBUTTON");
		studentPortalMyCoursePrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_REQUESTEXAMCANCELLATIONBUTTON,"REQUESTEXAMCANCELLATIONBUTTON");
		studentPortalMyCoursePrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_PORTAL_MYCOURSE_PRIVILEGES", studentPortalMyCoursePrivileges);
		
		facultyPortalMyCoursePrivileges = new Ext.util.HashMap();
		facultyPortalMyCoursePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MYCOURSE_VIEW,"VIEW");
		facultyPortalMyCoursePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MYCOURSE_EXPORT,"EXPORT");
		facultyPortalMyCoursePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MYCOURSE_DOWNLOADMARKSHEETS,"DOWNLOADMARKSHEETS");
		facultyPortalMyCoursePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MYCOURSE_DOWNLOADUNOFFICIALTRANSCRIPT,"DOWNLOADUNOFFICIALTRANSCRIPT");
		facultyPortalMyCoursePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MYCOURSE_COURSEWISERADIOBUTTON,"COURSEWISERADIOBUTTON");
		facultyPortalMyCoursePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MYCOURSE_PERIODWISERADIOBUTTON,"PERIODWISERADIOBUTTON");
		facultyPortalMyCoursePrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_MYCOURSE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		
		featurePrivilegesMap.add("FACULTY_PORTAL_MYCOURSE_PRIVILEGES", facultyPortalMyCoursePrivileges);
		/****** End Student My Course for student Portal , Faculty Portal***********/
		
		/****** For Student Exam Eligibility for student Portal , Faculty Portal***********/
		studentPortalExamEligibilityPrivileges = new Ext.util.HashMap();
		studentPortalExamEligibilityPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_ELIGIBILITY_VIEW,"VIEW");
		studentPortalExamEligibilityPrivileges.add(FPCONSTANTS.SP_M5_F_EXAM_ELIGIBILITY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_EXAMINATION_EXAM_ELIGIBILITY_PRIVILEGES", studentPortalExamEligibilityPrivileges);
		
		facultyPortalExamEligibilityPrivileges = new Ext.util.HashMap();
		facultyPortalExamEligibilityPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_EXAM_ELIGIBILITY_VIEW,"VIEW");
		facultyPortalExamEligibilityPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_EXAM_ELIGIBILITY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_EXAMINATION_EXAM_ELIGIBILITY_PRIVILEGES", facultyPortalExamEligibilityPrivileges);
		/****** End Student Exam Eligibility for student Portal , Faculty Portal***********/
		
		/****** For Student Exam Eligibility for student Portal , Faculty Portal***********/
		facultyPortalStudentViewExaminationPrivileges = new Ext.util.HashMap();
		facultyPortalStudentViewExaminationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_VIEW_EXAMINATION_VIEW,"VIEW");
		facultyPortalStudentViewExaminationPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_VIEW_EXAMINATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_VIEW_EXAMINATION_PRIVILEGES", facultyPortalStudentViewExaminationPrivileges);
		/****** End Student Exam Eligibility for student Portal , Faculty Portal***********/
		
		/****** For Student Student Academics Topic for Faculty Portal***********/
		facultyPortalStudentAcademicsTopicPrivileges = new Ext.util.HashMap();
		facultyPortalStudentAcademicsTopicPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_ACADEMICS_TOPIC_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_ACADEMICS_TOPIC_PRIVILEGES", facultyPortalStudentAcademicsTopicPrivileges);
		/****** End Student Student Academics Topic for Faculty Portal***********/
		
		/****** For Student Student Academic History for Faculty Portal***********/
		facultyPortalStudentAcademicHistory=new Ext.util.HashMap();
		facultyPortalStudentAcademicHistory.add(FPCONSTANTS.FP_M9_F_STUDENT_VIEW_ACADEMIC_HISTORY_VIEW,"VIEW");
		facultyPortalStudentAcademicHistory.add(FPCONSTANTS.FP_M9_F_STUDENT_VIEW_ACADEMIC_HISTORY_EXPORT,"EXPORT");
		facultyPortalStudentAcademicHistory.add(FPCONSTANTS.FP_M9_F_STUDENT_VIEW_ACADEMIC_HISTORY_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_VIEW_ACADEMIC_HISTORY", facultyPortalStudentAcademicHistory);
		/****** End Student Student Academic History for Faculty Portal***********/
		
		
		/****** For Course Roaster Report for Faculty Portal***********/
		facultyPortalCourseRoasterReport=new Ext.util.HashMap();
		facultyPortalCourseRoasterReport.add(FPCONSTANTS.FP_M9_F_COURSE_ROASTER_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_PORTAL_COURSE_ROASTER_REPORT", facultyPortalCourseRoasterReport);
		/****** End Course Roaster Report for Faculty Portal***********/
		
		/****** For Student Biometric Machine Details for Faculty Portal***********/
		facultyPortalStudentBMDetailsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentBMDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_BM_DETAILS_VIEW,"VIEW");
		facultyPortalStudentBMDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_BM_DETAILS_EXPORT,"EXPORT");
		facultyPortalStudentBMDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_BM_DETAILS_CREATE,"CREATE");
		facultyPortalStudentBMDetailsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_BM_DETAILS_EDIT,"EDIT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_BM_DETAILS_PRIVILEGES", facultyPortalStudentBMDetailsPrivileges);
		/****** End Student Biometric Machine Details for Faculty Portal***********/
		
		/****** For Student Request Raised History for Student Portal, Faculty Portal***********/
		studentPortalStudentRequestRaisedHistoryPrivileges = new Ext.util.HashMap();
		studentPortalStudentRequestRaisedHistoryPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_REQUEST_RAISED_HISTORY_VIEW,"VIEW");
		studentPortalStudentRequestRaisedHistoryPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_REQUEST_RAISED_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_REQUEST_RAISED_HISTORY_PRIVILEGES", studentPortalStudentRequestRaisedHistoryPrivileges);
	
		facultyPortalStudentRequestRaisedHistoryPrivileges = new Ext.util.HashMap();
		facultyPortalStudentRequestRaisedHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_REQUEST_RAISED_HISTORY_VIEW,"VIEW");
		facultyPortalStudentRequestRaisedHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_REQUEST_RAISED_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_REQUEST_RAISED_HISTORY_PRIVILEGES", facultyPortalStudentRequestRaisedHistoryPrivileges);

		facultyPortalStudentRequestCouriersPrivileges = new Ext.util.HashMap();
		facultyPortalStudentRequestCouriersPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_REQUEST_MY_COURIERS_VIEW,"VIEW");
		facultyPortalStudentRequestCouriersPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_REQUEST_MY_COURIERS_EXPORT,"EXPORT");
		facultyPortalStudentRequestCouriersPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_REQUEST_MY_COURIERS_UPDATE_ACK_STATUS,"UPDATE_ACKNOWLEDGEMENT_STATUS");
		featurePrivilegesMap.add("FRONT_DESK_MANAGEMENT_PARENT_PORTAL_PRIVILEGES", facultyPortalStudentRequestCouriersPrivileges);

		
		/****** End Student Request Raised History for Student Portal, Faculty Portal***********/
		
		/****** For Student Request Pending Descision for Student Portal,Parent Portal, Faculty Portal***********/
		studentPortalStudentRequestPendingDescisionPrivileges = new Ext.util.HashMap();
		studentPortalStudentRequestPendingDescisionPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_REQUEST_PENDING_DESCISION_VIEW,"VIEW");
		studentPortalStudentRequestPendingDescisionPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_REQUEST_PENDING_DESCISION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_REQUEST_PENDING_DESCISION_PRIVILEGES", studentPortalStudentRequestPendingDescisionPrivileges);
		
		parentPortalStudentRequestPendingDescisionPrivileges = new Ext.util.HashMap();
		parentPortalStudentRequestPendingDescisionPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_REQUEST_PENDING_DESCISION_VIEW,"VIEW");
		parentPortalStudentRequestPendingDescisionPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_REQUEST_PENDING_DESCISION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_REQUEST_PENDING_DESCISION_PRIVILEGES", parentPortalStudentRequestPendingDescisionPrivileges);
		
		facultyPortalStudentRequestPendingDescisionPrivileges = new Ext.util.HashMap();
		facultyPortalStudentRequestPendingDescisionPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_REQUEST_PENDING_DESCISION_VIEW,"VIEW");
		facultyPortalStudentRequestPendingDescisionPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_REQUEST_PENDING_DESCISION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_REQUEST_PENDING_DESCISION_PRIVILEGES", facultyPortalStudentRequestPendingDescisionPrivileges);
		/****** End Student Request Pending for Student Portal,Parent Portal, Faculty Portal***********/
		
		/****** For Student Pending Bills for Student Portal, Faculty Portal***********/
		studentPortalStudentPendingBillsPrivileges = new Ext.util.HashMap();
		studentPortalStudentPendingBillsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_VIEW,"VIEW");
		studentPortalStudentPendingBillsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_BILLS_TAB,"BILLS_TAB");
		studentPortalStudentPendingBillsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_CREDIT_NOTES_TAB,"CREDIT_NOTES_TAB");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_PENDING_BILLS_PRIVILEGES", studentPortalStudentPendingBillsPrivileges);
		
		/****** For Student Pending Bills Tab  for Student Portal ***********/
		studentPortalStudentPendingBillsTabPrivileges = new Ext.util.HashMap();
		studentPortalStudentPendingBillsTabPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_INVOICE_TAB_VIEW,"VIEW");
		studentPortalStudentPendingBillsTabPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_INVOICE_TAB_EXPORT,"EXPORT");
		studentPortalStudentPendingBillsTabPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_INVOICE_TAB_PRINT,"PRINT");
		studentPortalStudentPendingBillsTabPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_INVOICE_TAB_PRINT_TAX_CERTIFICATE,"PRINT_TAX_CERTIFICATE");
		studentPortalStudentPendingBillsTabPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_INVOICE_TAB_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		studentPortalStudentPendingBillsTabPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_INVOICE_TAB_PRINT_CONSOLIDATE_OUTSTANDING_VOUCHER,"PRINT_CONSOLIDATE_OUTSTANDING_VOUCHER");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_PENDING_BILLS_TABS_PRIVILEGES", studentPortalStudentPendingBillsTabPrivileges);
		
		/****** For Student  Credit Tab  for Student Portal ***********/
		studentPortalStudentCreditTabPrivileges = new Ext.util.HashMap();
		studentPortalStudentCreditTabPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_CREDIT_NOTES_TAB_VIEW,"VIEW");
		studentPortalStudentCreditTabPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_CREDIT_NOTES_TAB_EXPORT,"EXPORT");
		studentPortalStudentCreditTabPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_CREDIT_NOTES_TAB_PRINT,"PRINT");
		studentPortalStudentCreditTabPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_CREDIT_NOTES_TAB_PRINT_TAX_CERTIFICATE,"PRINT_TAX_CERTIFICATE");
		studentPortalStudentCreditTabPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PENDING_BILLS_CREDIT_NOTES_TAB_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_CREDIT_TAB_PRIVILEGES", studentPortalStudentCreditTabPrivileges);
		
		
		
		facultyPortalStudentPendingBillsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentPendingBillsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PENDING_BILLS_VIEW,"VIEW");
		facultyPortalStudentPendingBillsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PENDING_BILLS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_PENDING_BILLS_PRIVILEGES", facultyPortalStudentPendingBillsPrivileges);
		/****** End Student Pending Bills for Student Portal, Faculty Portal***********/
		
		/****** For Student Payment Recieved for Student Portal,Parent portal, Faculty Portal***********/
		studentPortalStudentPaymentRecievedPrivileges = new Ext.util.HashMap();
		studentPortalStudentPaymentRecievedPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PAYMENT_RECIEVED_VIEW,"VIEW");
		studentPortalStudentPaymentRecievedPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PAYMENT_RECIEVED_EXPORT,"EXPORT");
		studentPortalStudentPaymentRecievedPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PAYMENT_RECIEVED_PRINT,"PRINT");
//		studentPortalStudentPaymentRecievedPrivileges.add(FPCONSTANTS.FP_M5_F_PAYMENT_RECEIVED_HISTORY_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		studentPortalStudentPaymentRecievedPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PAYMENT_RECIEVED_GRID_CONFIGURATION_STUDENT,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_PAYMENT_RECIEVED_PRIVILEGES", studentPortalStudentPaymentRecievedPrivileges);
		
		/****** For Student Payment Recieved for Student Portal Data Grid***********/
		
		studentPortalStudentPaymentRecievedDataGridPrivileges = new Ext.util.HashMap();
		studentPortalStudentPaymentRecievedDataGridPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PAYMENT_RECIEVED_GRID_CONFIGURATION_STUDENT,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_PAYMENT_RECIEVED_DATA_GRID_PRIVILEGES", studentPortalStudentPaymentRecievedDataGridPrivileges);
		
		parentPortalStudentPaymentRecievedPrivileges = new Ext.util.HashMap();
		parentPortalStudentPaymentRecievedPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PAYMENT_RECIEVED_VIEW,"VIEW");
		parentPortalStudentPaymentRecievedPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PAYMENT_RECIEVED_EXPORT,"EXPORT");
		parentPortalStudentPaymentRecievedPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_PAYMENT_RECIEVED_PRINT,"PRINT");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_PAYMENT_RECIEVED_PRIVILEGES", parentPortalStudentPaymentRecievedPrivileges);
		
		facultyPortalStudentPaymentRecievedPrivileges = new Ext.util.HashMap();
		facultyPortalStudentPaymentRecievedPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PAYMENT_RECIEVED_VIEW,"VIEW");
		facultyPortalStudentPaymentRecievedPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PAYMENT_RECIEVED_EXPORT,"EXPORT");
		facultyPortalStudentPaymentRecievedPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_PAYMENT_RECIEVED_PRINT,"PRINT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_PAYMENT_RECIEVED_PRIVILEGES", facultyPortalStudentPaymentRecievedPrivileges);
		/****** End Student Payment Recieved for Student Portal,Parent portal, Faculty Portal***********/
		
		/****** For Student Refunds for Student Portal,Parent Portal***********/
		studentPortalStudentRefundsPrivileges = new Ext.util.HashMap();
		studentPortalStudentRefundsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_REFUNDS_VIEW,"VIEW");
		studentPortalStudentRefundsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_REFUNDS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_REFUNDS_PRIVILEGES", studentPortalStudentRefundsPrivileges);
		
		facultyPortalStudentRefundsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentRefundsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_REFUNDS_VIEW,"VIEW");
		facultyPortalStudentRefundsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_REFUNDS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_REFUNDS_PRIVILEGES", facultyPortalStudentRefundsPrivileges);
		
		parentPortalStudentRefundsPrivileges = new Ext.util.HashMap();
		parentPortalStudentRefundsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_REFUNDS_VIEW,"VIEW");
		parentPortalStudentRefundsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_REFUNDS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_REFUNDS_PRIVILEGES", parentPortalStudentRefundsPrivileges);
		/****** End Student Refunds for Student Portal,Parent Portal***********/
		
		/****** For Student Refundable Payments for Student Portal,Parent Portal, Faculty Portal***********/
		studentPortalStudentRefundablePaymentsPrivileges = new Ext.util.HashMap();
		studentPortalStudentRefundablePaymentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_REFUNDABLE_PAYMENTS_VIEW,"VIEW");
		studentPortalStudentRefundablePaymentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_REFUNDABLE_PAYMENTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_REFUNDABLE_PAYMENTS_PRIVILEGES", studentPortalStudentRefundablePaymentsPrivileges);
		
		facultyPortalStudentRefundablePaymentsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentRefundablePaymentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_REFUNDABLE_PAYMENTS_VIEW,"VIEW");
		facultyPortalStudentRefundablePaymentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_REFUNDABLE_PAYMENTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_REFUNDABLE_PAYMENTS_PRIVILEGES", facultyPortalStudentRefundablePaymentsPrivileges);
		
		parentPortalStudentRefundablePaymentsPrivileges = new Ext.util.HashMap();
		parentPortalStudentRefundablePaymentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_REFUNDABLE_PAYMENTS_VIEW,"VIEW");
		parentPortalStudentRefundablePaymentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_REFUNDABLE_PAYMENTS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_REFUNDABLE_PAYMENTS_PRIVILEGES", parentPortalStudentRefundablePaymentsPrivileges);
		/****** End Student Refundable for Student Portal,Parent Portal, Faculty Portal***********/
		
		/****** For Student Post Dated Cheques for Student Portal,Parent Portal, Faculty Portal***********/
		studentPortalStudentPostDatedChequesPrivileges = new Ext.util.HashMap();
		studentPortalStudentPostDatedChequesPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_POST_DATED_CHEQUES_VIEW,"VIEW");
		studentPortalStudentPostDatedChequesPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_POST_DATED_CHEQUES_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_POST_DATED_CHEQUES_PRIVILEGES", studentPortalStudentPostDatedChequesPrivileges);
		
		facultyPortalStudentPostDatedChequesPrivileges = new Ext.util.HashMap();
		facultyPortalStudentPostDatedChequesPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_POST_DATED_CHEQUES_VIEW,"VIEW");
		facultyPortalStudentPostDatedChequesPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_POST_DATED_CHEQUES_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_POST_DATED_CHEQUES_PRIVILEGES", facultyPortalStudentPostDatedChequesPrivileges);
		
		parentPortalStudentPostDatedChequesPrivileges = new Ext.util.HashMap();
		parentPortalStudentPostDatedChequesPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_POST_DATED_CHEQUES_VIEW,"VIEW");
		parentPortalStudentPostDatedChequesPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_POST_DATED_CHEQUES_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_POST_DATED_CHEQUES_PRIVILEGES", parentPortalStudentPostDatedChequesPrivileges);
		/****** End Student Post Dated Cheques for Student Portal,Parent Portal, Faculty Portal***********/
		
		/****** For Student Scholarship for Student Portal,Parent Portal, Faculty Portal***********/
		facultyPortalStudentScholarshipPrivileges = new Ext.util.HashMap();
		facultyPortalStudentScholarshipPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SCHOLARSHIP_AWARDEE_VIEW,"VIEW");
		facultyPortalStudentScholarshipPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SCHOLARSHIP_AWARDEE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_SCHOLARSHIP_PRIVILEGES", facultyPortalStudentScholarshipPrivileges);
		/****** End Student Scholarship for Student Portal,Parent Portal, Faculty Portal***********/
		
		/****** For Student Services History for Student Portal,Parent Portal, Faculty Portal***********/
		studentPortalStudentServicesHistoryPrivileges = new Ext.util.HashMap();
		studentPortalStudentServicesHistoryPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SERVICES_HISTORY_VIEW,"VIEW");
		studentPortalStudentServicesHistoryPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SERVICES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_SERVICES_HISTORY_PRIVILEGES", studentPortalStudentServicesHistoryPrivileges);
		
		parentPortalStudentServicesHistoryPrivileges = new Ext.util.HashMap();
		parentPortalStudentServicesHistoryPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SERVICES_HISTORY_VIEW,"VIEW");
		parentPortalStudentServicesHistoryPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_SERVICES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_SERVICES_HISTORY_PRIVILEGES", parentPortalStudentServicesHistoryPrivileges);
		
		facultyPortalStudentServicesHistoryPrivileges = new Ext.util.HashMap();
		facultyPortalStudentServicesHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SERVICES_HISTORY_VIEW,"VIEW");
		facultyPortalStudentServicesHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SERVICES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_SERVICES_HISTORY_PRIVILEGES", facultyPortalStudentServicesHistoryPrivileges);
		/****** End Student Services History for Student Portal,Parent Portal, Faculty Portal***********/
		
		/****** For Student Service Opt In/Opt Out for Student Portal,Faculty Portal***********/
		studentPortalStudentServiceOptPrivileges = new Ext.util.HashMap();
		studentPortalStudentServiceOptPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SERVICE_OPT_VIEW,"VIEW");
		studentPortalStudentServiceOptPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SERVICE_OPT_EXPORT,"EXPORT");
		studentPortalStudentServiceOptPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SERVICE_OPT_CREATE,"CREATE");
		studentPortalStudentServiceOptPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_SERVICE_OPT_UPDATE,"UPDATE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_SERVICE_OPT_PRIVILEGES", studentPortalStudentServiceOptPrivileges);
		
		facultyPortalStudentServiceOptPrivileges = new Ext.util.HashMap();
		facultyPortalStudentServiceOptPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SERVICE_OPT_VIEW,"VIEW");
		facultyPortalStudentServiceOptPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SERVICE_OPT_CREATE,"CREATE");
		facultyPortalStudentServiceOptPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SERVICE_OPT_UPDATE,"UPDATE");
		facultyPortalStudentServiceOptPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SERVICE_OPT_DELETE,"DELETE");
		facultyPortalStudentServiceOptPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_SERVICE_OPT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_SERVICE_OPT_PRIVILEGES", facultyPortalStudentServiceOptPrivileges);
		/****** End Student Service Opt In/Opt Out for Student Portal,Faculty Portal***********/
		
		/****** For Student Communities History for Student Portal,Parent Portal,Faculty Portal***********/
		studentPortalStudentCommunitiesHistoryPrivileges = new Ext.util.HashMap();
		studentPortalStudentCommunitiesHistoryPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_COMMUNITIES_HISTORY_VIEW,"VIEW");
		studentPortalStudentCommunitiesHistoryPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_COMMUNITIES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_COMMUNITIES_HISTORY_PRIVILEGES", studentPortalStudentCommunitiesHistoryPrivileges);
		
		parentPortalStudentCommunitiesHistoryPrivileges = new Ext.util.HashMap();
		parentPortalStudentCommunitiesHistoryPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_COMMUNITIES_HISTORY_VIEW,"VIEW");
		parentPortalStudentCommunitiesHistoryPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_COMMUNITIES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_COMMUNITIES_HISTORY_PRIVILEGES", parentPortalStudentCommunitiesHistoryPrivileges);
		
		facultyPortalStudentCommunitiesHistoryPrivileges = new Ext.util.HashMap();
		facultyPortalStudentCommunitiesHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_COMMUNITIES_HISTORY_VIEW,"VIEW");
		facultyPortalStudentCommunitiesHistoryPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_COMMUNITIES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_COMMUNITIES_HISTORY_PRIVILEGES", facultyPortalStudentCommunitiesHistoryPrivileges);
		/****** End Student Communities History for Student Portal,Parent Portal, Faculty Portal***********/
		
		/****** For Student Communities Opt In/Opt Out for Student Portal,Faculty Portal***********/
		studentPortalStudentCommunitiesOptPrivileges = new Ext.util.HashMap();
		studentPortalStudentCommunitiesOptPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_COMMUNITIES_OPT_VIEW,"VIEW");
		studentPortalStudentCommunitiesOptPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_COMMUNITIES_OPT_EXPORT,"EXPORT");
		studentPortalStudentCommunitiesOptPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_COMMUNITIES_OPT_CREATE,"CREATE");
		studentPortalStudentCommunitiesOptPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_COMMUNITIES_OPT_UPDATE,"UPDATE");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_COMMUNITIES_OPT_PRIVILEGES", studentPortalStudentCommunitiesOptPrivileges);
		
		facultyPortalStudentCommunitiesOptPrivileges = new Ext.util.HashMap();
		facultyPortalStudentCommunitiesOptPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_COMMUNITIES_OPT_VIEW,"VIEW");
		facultyPortalStudentCommunitiesOptPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_COMMUNITIES_OPT_CREATE,"CREATE");
		facultyPortalStudentCommunitiesOptPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_COMMUNITIES_OPT_UPDATE,"UPDATE");
		facultyPortalStudentCommunitiesOptPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_COMMUNITIES_OPT_DELETE,"DELETE");
		facultyPortalStudentCommunitiesOptPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_COMMUNITIES_OPT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_COMMUNITIES_OPT_PRIVILEGES", facultyPortalStudentCommunitiesOptPrivileges);
		/****** End Student Communities Opt In/Opt Out for Student Portal,Faculty Portal***********/
		
		/****** For Student Hostel Personal Requiremments for Faculty Portal***********/
		facultyPortalStudentHostelPersonalRequirements = new Ext.util.HashMap();
		facultyPortalStudentHostelPersonalRequirements.add(FPCONSTANTS.FP_M9_F_STUDENT_HOSTEL_PERSONAL_REQUIREMENTS_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_HOSTEL_PERSONAL_PRIVILEGES", facultyPortalStudentHostelPersonalRequirements);
		/****** End Student Hostel Personal Requiremments for Faculty Portal***********/
		
		/****** For Student Disciplinary Actions for Student Portal,Parent Portal,Faculty Portal***********/
		studentPortalStudentDisciplinaryActionsPrivileges = new Ext.util.HashMap();
		studentPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_VIEW,"VIEW");
		studentPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_EXPORT,"EXPORT");
		studentPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PRIVILEGES", studentPortalStudentDisciplinaryActionsPrivileges);
		
		studentPortalStudentDisciplinaryActionsSUPrivileges = new Ext.util.HashMap();
		studentPortalStudentDisciplinaryActionsSUPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_SU_VIEW,"VIEW");
		studentPortalStudentDisciplinaryActionsSUPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_SU_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PRIVILEGES", studentPortalStudentDisciplinaryActionsSUPrivileges);
		
		parentPortalStudentDisciplinaryActionsPrivileges = new Ext.util.HashMap();
		parentPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_VIEW,"VIEW");
		parentPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_EXPORT,"EXPORT");
		parentPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PRIVILEGES", parentPortalStudentDisciplinaryActionsPrivileges);
		
		parentPortalStudentDisciplinaryActionsSUPrivileges = new Ext.util.HashMap();
		parentPortalStudentDisciplinaryActionsSUPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_SU_VIEW,"VIEW");
		parentPortalStudentDisciplinaryActionsSUPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_SU_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PRIVILEGES", parentPortalStudentDisciplinaryActionsSUPrivileges);
		
		facultyPortalStudentDisciplinaryActionsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_VIEW,"VIEW");
		facultyPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_CREATE,"CREATE");
		facultyPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_UPDATE,"UPDATE");
		facultyPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_DELETE,"DELETE");
		facultyPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_EXPORT,"EXPORT");
		facultyPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_ADD_STUDENTS,"FPS_ADD_STUDENTS");
		facultyPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_DOCUMENT_DELETE,"FPS_DOCUMENT_DELETE");
		facultyPortalStudentDisciplinaryActionsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_DISCIPLINARY_ACTIONS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_PRIVILEGES", facultyPortalStudentDisciplinaryActionsPrivileges);
		/****** End Student Disciplinary Actions for Student Portal,Parent Portal,Faculty Portal***********/
		
		/****** For Student Negative Incidents for Student Portal,Parent Portal,Faculty Portal***********/
		studentPortalStudentNegativeIncidentsPrivileges = new Ext.util.HashMap();
		studentPortalStudentNegativeIncidentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_NEGATIVE_INCIDENTS_VIEW,"VIEW");
		studentPortalStudentNegativeIncidentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_NEGATIVE_INCIDENTS_EXPORT,"EXPORT");
		studentPortalStudentNegativeIncidentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_NEGATIVE_INCIDENTS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PRIVILEGES", studentPortalStudentNegativeIncidentsPrivileges);
		
		parentPortalStudentNegativeIncidentsPrivileges = new Ext.util.HashMap();
		parentPortalStudentNegativeIncidentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_NEGATIVE_INCIDENTS_VIEW,"VIEW");
		parentPortalStudentNegativeIncidentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_NEGATIVE_INCIDENTS_EXPORT,"EXPORT");
		parentPortalStudentNegativeIncidentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_NEGATIVE_INCIDENTS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
    	featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PRIVILEGES", parentPortalStudentNegativeIncidentsPrivileges);
		
		facultyPortalStudentNegativeIncidentsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentNegativeIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_NEGATIVE_INCIDENTS_VIEW,"VIEW");
		facultyPortalStudentNegativeIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_NEGATIVE_INCIDENTS_CREATE,"CREATE");
		facultyPortalStudentNegativeIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_NEGATIVE_INCIDENTS_UPDATE,"UPDATE");
		facultyPortalStudentNegativeIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_NEGATIVE_INCIDENTS_DELETE,"DELETE");
		facultyPortalStudentNegativeIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_NEGATIVE_INCIDENTS_EXPORT,"EXPORT");
		facultyPortalStudentNegativeIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_NEGATIVE_INCIDENTS_ADD_STUDENTS,"FPS_ADD_STUDENTS");
		facultyPortalStudentNegativeIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_NEGATIVE_INCIDENTS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_NEGATIVE_INCIDENTS_PRIVILEGES", facultyPortalStudentNegativeIncidentsPrivileges);
		/****** End Student Negative Incidents for Student Portal,Parent Portal,Faculty Portal***********/
		
		/****** For Student Positive Incidents for Student Portal,Parent Portal,Faculty Portal***********/
		studentPortalStudentPositiveIncidentsPrivileges = new Ext.util.HashMap();
		studentPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_POSITIVE_INCIDENTS_VIEW,"VIEW");
		studentPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_POSITIVE_INCIDENTS_EXPORT,"EXPORT");
		studentPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_POSITIVE_INCIDENTS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_POSITIVE_INCIDENTS_PRIVILEGES", studentPortalStudentPositiveIncidentsPrivileges);
		
		parentPortalStudentPositiveIncidentsPrivileges = new Ext.util.HashMap();
		parentPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_POSITIVE_INCIDENTS_VIEW,"VIEW");
		parentPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_POSITIVE_INCIDENTS_EXPORT,"EXPORT");
		parentPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_POSITIVE_INCIDENTS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_POSITIVE_INCIDENTS_PRIVILEGES", parentPortalStudentPositiveIncidentsPrivileges);
		
		facultyPortalStudentPositiveIncidentsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_POSITIVE_INCIDENTS_VIEW,"VIEW");
		facultyPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_POSITIVE_INCIDENTS_CREATE,"CREATE");
		facultyPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_POSITIVE_INCIDENTS_UPDATE,"UPDATE");
		facultyPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_POSITIVE_INCIDENTS_DELETE,"DELETE");
		facultyPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_POSITIVE_INCIDENTS_EXPORT,"EXPORT");
		facultyPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_POSITIVE_INCIDENTS_ADD_STUDENTS,"FPS_ADD_STUDENTS");
		facultyPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_POSITIVE_INCIDENTS_DOCUMENT_DELETE,"FPS_PI_DOC_DELETE");
		facultyPortalStudentPositiveIncidentsPrivileges.add(FPCONSTANTS.FP_M9_F_STUDENT_POSITIVE_INCIDENTS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_POSITIVE_INCIDENTS_PRIVILEGES", facultyPortalStudentPositiveIncidentsPrivileges);
		/****** End Student Positive Incidents for Student Portal,Parent Portal,Faculty Portal***********/
		
		
		programVacantSeatReportOnTree = new Ext.util.HashMap();
		programVacantSeatReportOnTree.add(FPCONSTANTS.PC_M4_D_PROGRAM_VACANT_SEAT_REPORT_VIEW, "VIEW");
		programVacantSeatReportOnTree.add(FPCONSTANTS.PC_M4_D_PROGRAM_VACANT_SEAT_REPORT_EXPORT_TO_PNG, "EXPORT_TO_PNG");
		featurePrivilegesMap.add("PROGRAM_VACANT_SEAT_REPORT_ON_TREE_PRIVILEGES", programVacantSeatReportOnTree);
		
	/*	programAbsenteeismReportOnTree = new Ext.util.HashMap();
		programAbsenteeismReportOnTree.add(FPCONSTANTS.PC_M4_D_PROGRAM_ABSENTEEISM_REPORT_VIEW, "VIEW");
		programAbsenteeismReportOnTree.add(FPCONSTANTS.PC_M4_D_PROGRAM_ABSENTEEISM_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("PROGRAM_ABSENTEEISM_REPORT_ON_TREE_PRIVILEGES", programAbsenteeismReportOnTree);*/
		
		coursePopularityReportOnTree = new Ext.util.HashMap();
		coursePopularityReportOnTree.add(FPCONSTANTS.PC_M4_D_COURSE_POPULARITY_REPORT_VIEW, "VIEW");
		coursePopularityReportOnTree.add(FPCONSTANTS.PC_M4_D_COURSE_POPULARITY_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("COURSE_POPULARITY_REPORT_ON_TREE_PRIVILEGES", coursePopularityReportOnTree);
		
		courseExecutionReportOnTree = new Ext.util.HashMap();
		courseExecutionReportOnTree.add(FPCONSTANTS.PC_M4_D_COURSE_EXECUTION_REPORT_VIEW, "VIEW");
		courseExecutionReportOnTree.add(FPCONSTANTS.PC_M4_D_COURSE_EXECUTION_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("COURSE_EXECUTION_REPORT_ON_TREE_PRIVILEGES", courseExecutionReportOnTree);
		
/*		courseAbsenteeismReportOnTree = new Ext.util.HashMap();
		courseAbsenteeismReportOnTree.add(FPCONSTANTS.PC_M4_D_COURSE_ABSENTEEISM_REPORT_VIEW, "VIEW");
		courseAbsenteeismReportOnTree.add(FPCONSTANTS.PC_M4_D_COURSE_ABSENTEEISM_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("COURSE_ABSENTEEISM_REPORT_ON_TREE_PRIVILEGES", courseAbsenteeismReportOnTree);
		*/
		courseRosterReportOnTree = new Ext.util.HashMap();
		courseRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_COURSE_ROSTER_REPORT_VIEW,"VIEW");
		courseRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_COURSE_ROSTER_REPORT_EXPORT,"EXPORT");
		courseRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_GENERATE_COURSE_ROSTER_REPORT, "GENERATE_COURSE_ROSTER_REPORT");
		courseRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_SEND_MESSAGE_COURSE_ROSTER_REPORT, "SEND_MESSAGE_COURSE_ROSTER_REPORT");
		courseRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_SEND_MESSAGE_COURSE_ROSTER_REPORT_ADHOC_MESSAGE, "ADHOC_MESSAGE");
		courseRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_SEND_MESSAGE_COURSE_ROSTER_REPORT_MESSAGE_TEMPLATE, "MESSAGE_TEMPLATE");
		courseRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_COURSE_ROSTER_REPORT_RESETPASSWORD,"RESETPASSWORD");
		courseRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_COURSE_ROSTER_REPORT_GRID_CONFIG,"GRID_CONFIGURATION");

		featurePrivilegesMap.add("COURSE_ROSTER_REPORT_ON_TREE_PRIVILEGES", courseRosterReportOnTree);
		
		courseDetailReportOnTree = new Ext.util.HashMap();
		courseDetailReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_COURSE_DETAIL_REPORT_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("COURSE_DETAIL_REPORT_ON_TREE_PRIVILEGES", courseDetailReportOnTree);

		
		sectionRosterReportOnTree = new Ext.util.HashMap();
		sectionRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_SECTION_ROSTER_REPORT_VIEW,"VIEW");
		sectionRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_SECTION_ROSTER_REPORT_EXPORT,"EXPORT");
		sectionRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_SEND_MESSAGE_SECTION_ROSTER_REPORT, "SEND_MESSAGE_SECTION_ROSTER_REPORT");
		sectionRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_SECTION_ROSTER_REPORT_EXPORT_REPORT, "GENERATE_SECTION_ROSTER_REPORT");
		sectionRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_SECTION_ROSTER_REPORT_ADHOC_MESSAGE, "ADHOC_MESSAGE");
		sectionRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_SECTION_ROSTER_REPORT_MESSAGE_TEMPLATE, "MESSAGE_TEMPLATE");
		sectionRosterReportOnTree.add(FPCONSTANTS.PC_M4_F_PANDCDASHBOARD_SECTION_ROSTER_REPORT_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("SECTION_ROSTER_REPORT_ON_TREE_PRIVILEGES", sectionRosterReportOnTree);
		
	/*	courseAttendanceAbsenteeismReportOnTree = new Ext.util.HashMap();
		courseAttendanceAbsenteeismReportOnTree.add(FPCONSTANTS.PC_M4_D_COURSE_ATTENDANCE_ABSENTEEISM_REPORT_VIEW, "VIEW");
		courseAttendanceAbsenteeismReportOnTree.add(FPCONSTANTS.PC_M4_D_COURSE_ATTENDANCE_ABSENTEEISM_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("COURSE_ATTENDANCE_ABSENTEEISM_REPORT_ON_TREE_PRIVILEGES", courseAttendanceAbsenteeismReportOnTree);*/
		
	
		/****** For Student Personal Details***********/
				
		studentPortalStudentAddressDetailsPrivileges = new Ext.util.HashMap();
		studentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ADDRESSES_VIEW,"VIEW");
		studentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ADDRESSES_CREATE,"CREATE");
		studentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ADDRESSES_UPDATE,"UPDATE");
		studentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ADDRESSES_PRINT,"PRINT");
		
		studentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ADDRESSES_FATHER_ADDRESS,"FATHER_ADDRESS");
		studentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ADDRESSES_MOTHER_ADDRESS,"MOTHER_ADDRESS");
		studentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ADDRESSES_GUARDIAN_ADDRESS,"GUARDIAN_ADDRESS");
		studentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ADDRESSES_LOCAL_GUARDIAN_ADDRESS,"LOCAL_GUARDIAN_ADDRESS");
		
		studentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ADDRESSES_CURRENT_ADDRESS,"CURRENT_ADDRESS");
		studentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ADDRESSES_ADDRESS_FOR_CORRESPONDANCE,"ADDRESS_FOR_CORRESPONDANCE");
		studentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ADDRESSES_PERMANENT_ADDRESS,"PERMANENT_ADDRESS");
		studentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ADDRESSES_OFFICE_ADDRESS,"OFFICE_ADDRESS");
		studentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_ADDRESSES_GOOGLE_ADDRESS,"GOOGLE_ADDRESS");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_ADDRESS_DETAILS_PRIVILEGES", studentPortalStudentAddressDetailsPrivileges);
		
		parentPortalStudentAddressDetailsPrivileges = new Ext.util.HashMap();
		parentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ADDRESSES_VIEW,"VIEW");
		parentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ADDRESSES_CREATE,"CREATE");
		parentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ADDRESSES_UPDATE,"UPDATE");
		parentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ADDRESSES_PRINT,"PRINT");
		parentPortalStudentAddressDetailsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_ADDRESSES_GOOGLE_ADDRESS,"GOOGLE_ADDRESS");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_ADDRESS_DETAILS_PRIVILEGES", parentPortalStudentAddressDetailsPrivileges);
		
		studentPortalMyCoursePassFailTabPrivileges = new Ext.util.HashMap();
		studentPortalMyCoursePassFailTabPrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_PASSFAIL_TAB_PASS, "PASS");
		studentPortalMyCoursePassFailTabPrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_PASSFAIL_TAB_FAIL,"FAIL");
		studentPortalMyCoursePassFailTabPrivileges.add(FPCONSTANTS.SP_M4_F_MYCOURSEMASTER_TAB_LEARNING_TARGETS,"LEARNING_TARGETS");
		featurePrivilegesMap.add("STUDENT_PORTAL_MYCOURSE_PASSFAIL_TAB_PRIVILEGES", studentPortalMyCoursePassFailTabPrivileges);
		
				
		/****** For Parent Portal Period Registration***********/
		parentPortalPeriodRegistrationPrivileges = new Ext.util.HashMap();
		parentPortalPeriodRegistrationPrivileges.add(FPCONSTANTS.PP_M4_F_PERIOD_REGISTRATION_VIEW,"VIEW");
		parentPortalPeriodRegistrationPrivileges.add(FPCONSTANTS.PP_M4_F_PERIOD_REGISTRATION_ENROLL,"ENROLL");
		parentPortalPeriodRegistrationPrivileges.add(FPCONSTANTS.PP_M4_F_PERIOD_REGISTRATION_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_PERIOD_REGISTRATION_PRIVILEGES", parentPortalPeriodRegistrationPrivileges);
		
		/****** For Student Exam Eligibility for parent Portal***********/
		parentPortalExamEligibilityPrivileges = new Ext.util.HashMap();
		parentPortalExamEligibilityPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_ELIGIBILITY_VIEW,"VIEW");
		parentPortalExamEligibilityPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_ELIGIBILITY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_EXAMINATION_EXAM_ELIGIBILITY_PRIVILEGES", parentPortalExamEligibilityPrivileges);
		
		/****** For Student Exam Document for parent Portal***********/
		parentportalExamDocumentsPrivileges=new Ext.util.HashMap();
		parentportalExamDocumentsPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_DOCUMENTS_VIEW, "VIEW");
		featurePrivilegesMap.add("PARENT_PORTAL_EXAM_DOCUMENTS_PRIVILEGES", parentportalExamDocumentsPrivileges);
		
		/****** For Student Exam Hall Ticket and Marksheet for parent Portal***********/
		parentportalExamDocumentsHallTicketPrivileges=new Ext.util.HashMap();
		parentportalExamDocumentsHallTicketPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_DOCUMENTS_HALL_TICKET_VIEW, "VIEW");
		parentportalExamDocumentsHallTicketPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_DOCUMENTS_HALL_TICKET_DOWNLOADALLHALLTICKET, "DOWNLOADALLHALLTICKET");
		featurePrivilegesMap.add("PARENT_PORTAL_EXAM_DOCUMENTS_HALL_TICKET_PRIVILEGES", parentportalExamDocumentsHallTicketPrivileges);
		
		parentPortalExamDocumentsMarkseetsPrivileges=new Ext.util.HashMap();
		parentPortalExamDocumentsMarkseetsPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_DOCUMENTS_MARKSHEETS_VIEW, "VIEW");
		parentPortalExamDocumentsMarkseetsPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_DOCUMENTS_MARKSHEETS_DOWNLOADMARKSHEETS, "DOWNLOADMARKSHEETS");
		featurePrivilegesMap.add("PARENT_PORTAL_EXAM_DOCUMENTS_MARKSHEETS_PRIVILEGES", parentPortalExamDocumentsMarkseetsPrivileges);
		
		/****** For Student Revaluation for parent Portal***********/
		parentPortalRevaluationPrivileges=new Ext.util.HashMap();
		parentPortalRevaluationPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_APPLY_FOR_REVALUATION_VIEW, "VIEW");
		parentPortalRevaluationPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_APPLY_FOR_REVALUATION_APPLY_AND_PAY_ONLINE, "APPLY_AND_PAY_ONLINE");
		parentPortalRevaluationPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_APPLY_FOR_REVALUATION_COLLECT_PAYMENT, "COLLECT_PAYMENT");
		parentPortalRevaluationPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_APPLY_FOR_REVALUATION_OFFLINE_PAYMENT, "OFFLINE_PAYMENT");
		parentPortalRevaluationPrivileges.add(FPCONSTANTS.PP_M5_F_EXAM_APPLY_FOR_REVALUATION_APPLY_NOW, "APPLY_NOW");
		featurePrivilegesMap.add("PARENT_PORTAL_EXAM_REVALUATION_PRIVILEGES", parentPortalRevaluationPrivileges);
		
		parentPortalFeeRequest=new Ext.util.HashMap();
		parentPortalFeeRequest.add(FPCONSTANTS.PP_M11_FEE_REQUEST_VIEW, "VIEW");
		parentPortalFeeRequest.add(FPCONSTANTS.PP_M11_FEE_REQUEST_RAISEREQUEST, "RAISEREQUEST");
		featurePrivilegesMap.add("PARENT_PORTAL_FEE_REQUEST_PRIVILEGES", parentPortalFeeRequest);
		
		parentProjectedBillingReportPrivileges = new Ext.util.HashMap();
		parentProjectedBillingReportPrivileges.add(FPCONSTANTS.PP_M11_PROJECTED_BILLING_REPORT_VIEW,"VIEW");
		parentProjectedBillingReportPrivileges.add(FPCONSTANTS.PP_M11_PROJECTED_BILLING_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_PROJECTED_BILLING_REPORT_PRIVILEGES", parentProjectedBillingReportPrivileges);
        
		/*****************Student church info for parent Portal**********************/
		parentPortalStudentChurchInformationPrivileges = new Ext.util.HashMap();
		parentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_CHURCH_INFORMATION_VIEW,"VIEW");
		parentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_CHURCH_INFORMATION_CREATE,"CREATE");
		parentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_CHURCH_INFORMATION_UPDATE,"UPDATE");
		parentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_CHURCH_INFORMATION_DELETE,"DELETE");
		parentPortalStudentChurchInformationPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_CHURCH_INFORMATION_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_CHURCH_INFORMATION_PRIVILEGES", parentPortalStudentChurchInformationPrivileges);
		
		/*****************Student Manage Holds info for parent Portal**********************/
		parentPortalStudentHoldsPrivileges = new Ext.util.HashMap();
		parentPortalStudentHoldsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_HOLDS_VIEW,"VIEW");
		parentPortalStudentHoldsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_HOLDS_HOLDS_TAB,"HOLDS_TAB");
		parentPortalStudentHoldsPrivileges.add(FPCONSTANTS.PP_M9_F_STUDENT_HOLDS_FINANCE_HOLDS_TAB,"FINANCE_HOLDS_TAB");
		featurePrivilegesMap.add("PARENT_PORTAL_STUDENT_HOLDS_PRIVILEGES", parentPortalStudentHoldsPrivileges);
		
			
		manageBillReceivablePayableRadioButtonPrivileges = new Ext.util.HashMap();
		manageBillReceivablePayableRadioButtonPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_BILLRECEIVABLE_PAYABLE, "BILL_RECEIVABLE_PAYABLE");
		featurePrivilegesMap.add("MANAGE_BILL_RECEIVABLE_PAYABLE_PRIVILEGES", manageBillReceivablePayableRadioButtonPrivileges);
		
		studentLeaversReportPrivileges = new Ext.util.HashMap();
		studentLeaversReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_LEAVERS_REPORT_EXPORT, "EXPORT");
		studentLeaversReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_LEAVERS_REPORT_VIEW, "VIEW");
		studentLeaversReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_LEAVERS_REPORT_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_LEAVERS_REPORT_PRIVILEGES", studentLeaversReportPrivileges);
		
		discountMapFeePlanTypePrivileges = new Ext.util.HashMap();
		discountMapFeePlanTypePrivileges.add(FPCONSTANTS.PC_M6_F_DISCOUNT_MAP_FEEPLANTYPE_SUBMIT, "SUBMIT");
		featurePrivilegesMap.add("DISCOUNT_MAP_FEEPLANTYPE", discountMapFeePlanTypePrivileges);
		
		discountMapFeeHeadPrivileges = new Ext.util.HashMap();
		discountMapFeeHeadPrivileges.add(FPCONSTANTS.PC_M6_F_DISCOUNT_MAP_FEEHEAD_SUBMIT, "SUBMIT");
		featurePrivilegesMap.add("DISCOUNT_MAP_FEEHEAD", discountMapFeeHeadPrivileges);
		
		//******************************fee Report ***************************************************
		feeReportFeeRuleAssociationPrivileges = new Ext.util.HashMap();
		feeReportFeeRuleAssociationPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_FEE_RULE_ASSOCIATION_VIEW,"VIEW");
		feeReportFeeRuleAssociationPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_FEE_RULE_ASSOCIATION_EXPORT,"EXPORT");
		feeReportFeeRuleAssociationPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_FEE_RULE_ASSOCIATION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FEE_REPORT_FEE_RULE_ASSOCIATION_PRIVILEGES", feeReportFeeRuleAssociationPrivileges);
        //******************************End*********************************************************************
		
		//******************************fee VOUCHER Report ***************************************************
		voucherSummaryReportAssociationPrivileges = new Ext.util.HashMap();
		voucherSummaryReportAssociationPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_VOUCHER_SUMMARY_REPORT_VIEW,"VIEW");
		voucherSummaryReportAssociationPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_VOUCHER_SUMMARY_REPORT_EXPORT,"EXPORT");
		voucherSummaryReportAssociationPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_VOUCHER_SUMMARY_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("VOUCHER_SUMMARY_REPORT_ASSOCIATION_PRIVILEGES", voucherSummaryReportAssociationPrivileges);
        //******************************End*********************************************************************
		
		studentDeletedReportPrivileges = new Ext.util.HashMap();
		studentDeletedReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_DELETED_REPORT_EXPORT, "EXPORT");
		studentDeletedReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_DELETED_REPORT_VIEW, "VIEW");
		featurePrivilegesMap.add("STUDENT_DELETED_REPORT_PRIVILEGES", studentDeletedReportPrivileges);
		
		studentPunchLogReportPrivileges = new Ext.util.HashMap();
		studentPunchLogReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_PUNCH_LOG_REPORT_EXPORT, "EXPORT");
		studentPunchLogReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_PUNCH_LOG_REPORT_VIEW, "VIEW");
		featurePrivilegesMap.add("STUDENT_PUNCH_LOG_REPORT_PRIVILEGES", studentPunchLogReportPrivileges);
		
		studentHoldReportPrivileges = new Ext.util.HashMap();
		studentHoldReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_HOLD_REPORT_EXPORT, "EXPORT");
		studentHoldReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_HOLD_REPORT_VIEW, "VIEW");
		studentHoldReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_HOLD_REPORT_REMOVE_HOLD, "REMOVE_HOLD");
		studentHoldReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_HOLD_REPORT_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		studentHoldReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_HOLD_REPORT_DELETE_HOLD, "DELETE_HOLD");
		studentHoldReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_STUDENT_HOLD_REPORT_SENDMESSAGE, "SENDMESSAGE");
		featurePrivilegesMap.add("STUDENT_HOLD_REPORT_PRIVILEGES", studentHoldReportPrivileges);
		
		applicantDeletedReportPrivileges = new Ext.util.HashMap();
		applicantDeletedReportPrivileges.add(FPCONSTANTS.PC_M3_F_DELETED_APPLICANTS_REPORT_VIEW, "VIEW");
		applicantDeletedReportPrivileges.add(FPCONSTANTS.PC_M3_F_DELETED_APPLICANTS_REPORT_EXPORT, "EXPORT");
		featurePrivilegesMap.add("APPLICANT_DELETED_REPORT_PRIVILEGES", applicantDeletedReportPrivileges);
		
		assessmentSchemeSubTypeLevelPrivileges = new Ext.util.HashMap();
		assessmentSchemeSubTypeLevelPrivileges.add(FPCONSTANTS.PC_M5_F_ASSESSMENT_SCHEME_SUBTYPE_LEVEL_ZSCORE,"ZSCORE");
		featurePrivilegesMap.add("ASSESSMENT_SCHEME_SUBTYPE_LEVEL_PRIVILEGES", assessmentSchemeSubTypeLevelPrivileges);
		
		collectionTypeRadioButtonPrivileges = new Ext.util.HashMap();
		collectionTypeRadioButtonPrivileges.add(FPCONSTANTS.PC_M6_F_USERWISE_COLLECTIONTYPE, "ALL_COLLECTION");
		featurePrivilegesMap.add("COLLECTION_TYPE_RADIO_BUTTON_PRIVILEGES", collectionTypeRadioButtonPrivileges);
		
		manageTargetsPriviledges=new Ext.util.HashMap();
		manageTargetsPriviledges.add(FPCONSTANTS.PC_M2_F_MANAGE_TARGETS_EXPORT, "EXPORT");
		/*manageTargetsPriviledges.add(FPCONSTANTS.PC_M2_F_MANAGE_TARGETS_EXPORT_REPORT,"EXPORTREPORTS");*/
		manageTargetsPriviledges.add(FPCONSTANTS.PC_M2_F_MANAGE_TARGETS_CREATE,"CREATE");
		manageTargetsPriviledges.add(FPCONSTANTS.PC_M2_F_MANAGE_TARGETS_APPLICATION_FORECAST,"APPLICATION_FORECAST");
		featurePrivilegesMap.add("MANAGE_TARGET_PRIVILEGES", manageTargetsPriviledges);
		
		examResultPublishPrivileges = new Ext.util.HashMap();
		examResultPublishPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_RESULT_PUBLISH_VIEW, "VIEW");
		examResultPublishPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_RESULT_PUBLISH_PUBLISH_RESULT, "PUBLISH_RESULT");
		examResultPublishPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_RESULT_PUBLISH_EXPORT, "EXPORT");
		examResultPublishPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_RESULT_PUBLISH_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		examResultPublishPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_RESULT_PUBLISH_UNPUBLISH_RESULT, "UNPUBLISH_RESULT");
		examResultPublishPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_RESULT_PUBLISH_BULK_EXAM_RESULT_PUBLISH_TAB, "BULK_EXAM_RESULT_PUBLISH_TAB");
		examResultPublishPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_RESULT_PUBLISH_BULK_PUBLISH_GRID_CONFIGURATION, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("EXAM_RESULT_PUBLISH_PRIVILEGES", examResultPublishPrivileges);
		
		bulkExamResultPublish = new Ext.util.HashMap();
		bulkExamResultPublish.add(FPCONSTANTS.PC_M5_F_BULK_EXAM_RESULT_PUBLISH_BULK_PUBLISH_BUTTON, "BULK_PUBLISH_RESULT");
		bulkExamResultPublish.add(FPCONSTANTS.PC_M5_F_BULK_EXAM_RESULT_PUBLISH_PUBLISH_RESULT_BUTTON, "PUBLISH_RESULT");
		bulkExamResultPublish.add(FPCONSTANTS.PC_M5_F_BULK_EXAM_RESULT_PUBLISH_UNPUBLISH_RESULT_BUTTON, "UNPUBLISH_RESULT");
		bulkExamResultPublish.add(FPCONSTANTS.PC_M5_F_BULK_EXAM_RESULT_PUBLISH_BULK_UNPUBLISH_BUTTON, "BULK_UNPUBLISH_RESULT");
		bulkExamResultPublish.add(FPCONSTANTS.PC_M5_F_BULK_EXAM_RESULT_PUBLISH_BULK_EXPORT, "EXPORT");
		bulkExamResultPublish.add(FPCONSTANTS.PC_M5_F_BULK_EXAM_RESULT_PUBLISH_BULK_HOST_FACULTY_CB, "HOST_FACULTY_CB");
		featurePrivilegesMap.add("BULK_EXAM_RESULT_PUBLISH_PRIVILEGES", bulkExamResultPublish);
		
		studentStatementOfAccount=new Ext.util.HashMap();
		studentStatementOfAccount.add(FPCONSTANTS.SP_M11_STATEMENT_OF_ACCOUNT_VIEW, "VIEW");
		studentStatementOfAccount.add(FPCONSTANTS.SP_M11_STATEMENT_OF_ACCOUNT_PRINT,"PRINT");
		studentStatementOfAccount.add(FPCONSTANTS.SP_M11_STATEMENT_OF_ACCOUNT_EXPORT,"EXPORT");
		studentStatementOfAccount.add(FPCONSTANTS.SP_M11_STATEMENT_OF_ACCOUNT_ACTUAL_TRANSACTION,"ACTUAL_TRANS");
		studentStatementOfAccount.add(FPCONSTANTS.SP_M11_STATEMENT_OF_ACCOUNT_VOUCHER_BASED_TRANSACTION,"VOUCHER_BASED_TRANS");
		featurePrivilegesMap.add("STUDENT_STATEMENT_OF_ACCOUNT_PRIVILEGES", studentStatementOfAccount);
		
		parentStatementOfAccount=new Ext.util.HashMap();
		parentStatementOfAccount.add(FPCONSTANTS.PP_M11_STATEMENT_OF_ACCOUNT_VIEW, "VIEW");
		parentStatementOfAccount.add(FPCONSTANTS.PP_M11_STATEMENT_OF_ACCOUNT_PRINT,"PRINT");
		parentStatementOfAccount.add(FPCONSTANTS.PP_M11_STATEMENT_OF_ACCOUNT_EXPORT,"EXPORT");
		parentStatementOfAccount.add(FPCONSTANTS.PP_M11_STATEMENT_OF_ACCOUNT_ACTUAL_TRANSACTION,"ACTUAL_TRANS");
		parentStatementOfAccount.add(FPCONSTANTS.PP_M11_STATEMENT_OF_ACCOUNT_VOUCHER_BASED_TRANSACTION,"VOUCHER_BASED_TRANS");
		featurePrivilegesMap.add("PARENT_STATEMENT_OF_ACCOUNT_PRIVILEGES", parentStatementOfAccount);
		
		coreERPStudentStatementOfAccount=new Ext.util.HashMap();
		coreERPStudentStatementOfAccount.add(FPCONSTANTS.PC_M6_F_STATEMENT_OF_ACCOUNT_EXPORT, "EXPORT");
		coreERPStudentStatementOfAccount.add(FPCONSTANTS.PC_M6_F_STATEMENT_OF_ACCOUNT_PRINT,"PRINT");
		coreERPStudentStatementOfAccount.add(FPCONSTANTS.PC_M6_F_STATEMENT_OF_ACCOUNT_VIEW_DETAILS,"VIEW_DETAILS");
		coreERPStudentStatementOfAccount.add(FPCONSTANTS.PC_M6_F_STATEMENT_OF_ACCOUNT_ACTUAL_TRANSACTION,"ACTUAL_TRANS");
		coreERPStudentStatementOfAccount.add(FPCONSTANTS.PC_M6_F_STATEMENT_OF_ACCOUNT_VOUCHER_BASED_TRANSACTION,"VOUCHER_BASED_TRANS");
		coreERPStudentStatementOfAccount.add(FPCONSTANTS.PC_M6_F_STATEMENT_OF_ACCOUNT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		coreERPStudentStatementOfAccount.add(FPCONSTANTS.PC_M6_F_STATEMENT_OF_ACCOUNT_EXPORT_REPORTS,"EXPORTREPORTS");
		coreERPStudentStatementOfAccount.add(FPCONSTANTS.PC_M6_F_STATEMENT_OF_ACCOUNT_DOWNLOAD_ALL,"DOWNLOAD_ALL");
		coreERPStudentStatementOfAccount.add(FPCONSTANTS.PC_M6_F_STATEMENT_OF_ACCOUNT_SHOW_ALL_STUDENT,"SHOWALLSTUDENT");
		coreERPStudentStatementOfAccount.add(FPCONSTANTS.PC_M6_F_STATEMENT_OF_ACCOUNT_TOTAL_BALANCE,"TOTAL_BALANCE");
		coreERPStudentStatementOfAccount.add(FPCONSTANTS.PC_M6_F_STATEMENT_OF_ACCOUNT_CANCEL,"CANCEL");
		featurePrivilegesMap.add("PC_STUDENT_STATEMENT_OF_ACCOUNT_PRIVILEGES", coreERPStudentStatementOfAccount);
		
		studentPortalOnlinePaymentTabPrivileges = new Ext.util.HashMap();
		studentPortalOnlinePaymentTabPrivileges.add(FPCONSTANTS.SP_M9_F_APPLY_FOR_GRAYQUEST_LOAN,"APPLY_FOR_GRAYQUEST_LOAN");
		studentPortalOnlinePaymentTabPrivileges.add(FPCONSTANTS.SP_M9_F_ONLINEPAYMENT_TAB_BILLDETAILS, "BILLDETAILS");
		studentPortalOnlinePaymentTabPrivileges.add(FPCONSTANTS.SP_M9_F_ONLINEPAYMENT_TAB_FEEHEADDETAILS,"FEEHEADDETAILS");
		featurePrivilegesMap.add("STUDENT_PORTAL_ONLINEPAYMENT_TAB_PRIVILEGES", studentPortalOnlinePaymentTabPrivileges);
		
		parentPortalOnlinePaymentTabPrivileges = new Ext.util.HashMap();
		parentPortalOnlinePaymentTabPrivileges.add(FPCONSTANTS.PP_M9_F_ONLINEPAYMENT_TAB_BILLDETAILS, "BILLDETAILS");
		parentPortalOnlinePaymentTabPrivileges.add(FPCONSTANTS.PP_M9_F_ONLINEPAYMENT_TAB_FEEHEADDETAILS,"FEEHEADDETAILS");
		featurePrivilegesMap.add("PARENT_PORTAL_ONLINEPAYMENT_TAB_PRIVILEGES", parentPortalOnlinePaymentTabPrivileges);
		
		appointmentDashboardReportPrivileges = new Ext.util.HashMap();
		appointmentDashboardReportPrivileges.add(FPCONSTANTS.PC_M3_A_DASHBOARD_VIEW, "VIEW");
		appointmentDashboardReportPrivileges.add(FPCONSTANTS.PC_M3_A_DASHBOARD_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPOINTMENT_DASHBOARD_REPORT_PRIVILEGES", appointmentDashboardReportPrivileges);
	
        followUpDashboardPrivileges = new Ext.util.HashMap();
		followUpDashboardPrivileges.add(FPCONSTANTS.PC_M2_D_FOLLOWUPDASHBOARD_VIEW, "VIEW");
		followUpDashboardPrivileges.add(FPCONSTANTS.PC_M2_D_FOLLOWUPDASHBOARD_EXPORT, "EXPORT");
		featurePrivilegesMap.add("FOLLOWUP_DASHBOARD_PRIVILEGES", followUpDashboardPrivileges);		
		
		admissionActivityReportPrivileges = new Ext.util.HashMap();
		admissionActivityReportPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_ADMISSION_ACTIVITY_REPORT_VIEW, "VIEW");
		admissionActivityReportPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_ADMISSION_ACTIVITY_REPORT_EXPORT, "EXPORT");
		admissionActivityReportPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_ADMISSION_ACTIVITY_REPORT_USER_ACTIVITY_REPORT, "USER_ACTIVITY_REPORT");
		admissionActivityReportPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_ADMISSION_ACTIVITY_REPORT_SALE_SUMMARY_REPORT, "SALE_ADMISSION_ENROLMENT_SUMMARY_REPORT");
		featurePrivilegesMap.add("ADMISSION_ACTIVITY_REPORT_PRIVILEGES", admissionActivityReportPrivileges);
		
		powerBiSubMenu1Report1Privileges = new Ext.util.HashMap();
		powerBiSubMenu1Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT1_VIEW, "VIEW");		
		powerBiSubMenu1Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT1_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu1Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT1_EDIT_BUTTON, "EDIT");
		powerBiSubMenu1Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT1_PRINT_BUTTON, "PRINT");
		powerBiSubMenu1Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT1_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU1_REPORT1_PRIVILEGES", powerBiSubMenu1Report1Privileges);
		
		powerBiSubMenu1Report2Privileges = new Ext.util.HashMap();
		powerBiSubMenu1Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT2_VIEW, "VIEW");
		powerBiSubMenu1Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT2_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu1Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT2_EDIT_BUTTON, "EDIT");
		powerBiSubMenu1Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT2_PRINT_BUTTON, "PRINT");
		powerBiSubMenu1Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT2_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU1_REPORT2_PRIVILEGES", powerBiSubMenu1Report2Privileges);
		
		powerBiSubMenu1Report3Privileges = new Ext.util.HashMap();		
		powerBiSubMenu1Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT3_VIEW, "VIEW");
		powerBiSubMenu1Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT3_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu1Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT3_EDIT_BUTTON, "EDIT");
		powerBiSubMenu1Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT3_PRINT_BUTTON, "PRINT");
		powerBiSubMenu1Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT3_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU1_REPORT3_PRIVILEGES", powerBiSubMenu1Report3Privileges);
		
		powerBiSubMenu1Report4Privileges = new Ext.util.HashMap();
		powerBiSubMenu1Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT4_VIEW, "VIEW");
		powerBiSubMenu1Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT4_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu1Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT4_EDIT_BUTTON, "EDIT");
		powerBiSubMenu1Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT4_PRINT_BUTTON, "PRINT");
		powerBiSubMenu1Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT4_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU1_REPORT4_PRIVILEGES", powerBiSubMenu1Report4Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu1Report5Privileges = new Ext.util.HashMap();
		powerBiSubMenu1Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT5_VIEW, "VIEW");
		powerBiSubMenu1Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT5_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu1Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT5_EDIT_BUTTON, "EDIT");
		powerBiSubMenu1Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT5_PRINT_BUTTON, "PRINT");
		powerBiSubMenu1Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT5_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU1_REPORT5_PRIVILEGES", powerBiSubMenu1Report5Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu1Report6Privileges = new Ext.util.HashMap();
		powerBiSubMenu1Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT6_VIEW, "VIEW");
		powerBiSubMenu1Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT6_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu1Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT6_EDIT_BUTTON, "EDIT");
		powerBiSubMenu1Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT6_PRINT_BUTTON, "PRINT");
		powerBiSubMenu1Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT6_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU1_REPORT6_PRIVILEGES", powerBiSubMenu1Report6Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu1Report7Privileges = new Ext.util.HashMap();
		powerBiSubMenu1Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT7_VIEW, "VIEW");
		powerBiSubMenu1Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT7_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu1Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT7_EDIT_BUTTON, "EDIT");
		powerBiSubMenu1Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT7_PRINT_BUTTON, "PRINT");
		powerBiSubMenu1Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT7_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU1_REPORT7_PRIVILEGES", powerBiSubMenu1Report7Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu1Report8Privileges = new Ext.util.HashMap();
		powerBiSubMenu1Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT8_VIEW, "VIEW");
		powerBiSubMenu1Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT8_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu1Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT8_EDIT_BUTTON, "EDIT");
		powerBiSubMenu1Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT8_PRINT_BUTTON, "PRINT");
		powerBiSubMenu1Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT8_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU1_REPORT8_PRIVILEGES", powerBiSubMenu1Report8Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu1Report9Privileges = new Ext.util.HashMap();
		powerBiSubMenu1Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT9_VIEW, "VIEW");
		powerBiSubMenu1Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT9_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu1Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT9_EDIT_BUTTON, "EDIT");
		powerBiSubMenu1Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT9_PRINT_BUTTON, "PRINT");
		powerBiSubMenu1Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT9_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU1_REPORT9_PRIVILEGES", powerBiSubMenu1Report9Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu1Report10Privileges = new Ext.util.HashMap();
		powerBiSubMenu1Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT10_VIEW, "VIEW");
		powerBiSubMenu1Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT10_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu1Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT10_EDIT_BUTTON, "EDIT");
		powerBiSubMenu1Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT10_PRINT_BUTTON, "PRINT");
		powerBiSubMenu1Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU1_REPORT10_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU1_REPORT10_PRIVILEGES", powerBiSubMenu1Report10Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu2Report1Privileges = new Ext.util.HashMap();
		powerBiSubMenu2Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT1_VIEW, "VIEW");
		powerBiSubMenu2Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT1_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu2Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT1_EDIT_BUTTON, "EDIT");
		powerBiSubMenu2Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT1_PRINT_BUTTON, "PRINT");
		powerBiSubMenu2Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT1_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU2_REPORT1_PRIVILEGES", powerBiSubMenu2Report1Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu2Report2Privileges = new Ext.util.HashMap();
		powerBiSubMenu2Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT2_VIEW, "VIEW");
		powerBiSubMenu2Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT2_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu2Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT2_EDIT_BUTTON, "EDIT");
		powerBiSubMenu2Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT2_PRINT_BUTTON, "PRINT");
		powerBiSubMenu2Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT2_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU2_REPORT2_PRIVILEGES", powerBiSubMenu2Report2Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu2Report3Privileges = new Ext.util.HashMap();
		powerBiSubMenu2Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT3_VIEW, "VIEW");
		powerBiSubMenu2Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT3_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu2Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT3_EDIT_BUTTON, "EDIT");
		powerBiSubMenu2Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT3_PRINT_BUTTON, "PRINT");
		powerBiSubMenu2Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT3_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU2_REPORT3_PRIVILEGES", powerBiSubMenu2Report3Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu2Report4Privileges = new Ext.util.HashMap();
		powerBiSubMenu2Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT4_VIEW, "VIEW");
		powerBiSubMenu2Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT4_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu2Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT4_EDIT_BUTTON, "EDIT");
		powerBiSubMenu2Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT4_PRINT_BUTTON, "PRINT");
		powerBiSubMenu2Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT4_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU2_REPORT4_PRIVILEGES", powerBiSubMenu2Report4Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu2Report5Privileges = new Ext.util.HashMap();
		powerBiSubMenu2Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT5_VIEW, "VIEW");
		powerBiSubMenu2Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT5_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu2Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT5_EDIT_BUTTON, "EDIT");
		powerBiSubMenu2Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT5_PRINT_BUTTON, "PRINT");
		powerBiSubMenu2Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU2_REPORT5_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU2_REPORT5_PRIVILEGES", powerBiSubMenu2Report5Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu3Report1Privileges = new Ext.util.HashMap();
		powerBiSubMenu3Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT1_VIEW, "VIEW");
		powerBiSubMenu3Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT1_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu3Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT1_EDIT_BUTTON, "EDIT");
		powerBiSubMenu3Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT1_PRINT_BUTTON, "PRINT");
		powerBiSubMenu3Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT1_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU3_REPORT1_PRIVILEGES", powerBiSubMenu3Report1Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu3Report2Privileges = new Ext.util.HashMap();
		powerBiSubMenu3Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT2_VIEW, "VIEW");
		powerBiSubMenu3Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT2_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu3Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT2_EDIT_BUTTON, "EDIT");
		powerBiSubMenu3Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT2_PRINT_BUTTON, "PRINT");
		powerBiSubMenu3Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT2_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU3_REPORT2_PRIVILEGES", powerBiSubMenu3Report2Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu3Report3Privileges = new Ext.util.HashMap();
		powerBiSubMenu3Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT3_VIEW, "VIEW");
		powerBiSubMenu3Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT3_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu3Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT3_EDIT_BUTTON, "EDIT");
		powerBiSubMenu3Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT3_PRINT_BUTTON, "PRINT");
		powerBiSubMenu3Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT3_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU3_REPORT3_PRIVILEGES", powerBiSubMenu3Report3Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu3Report4Privileges = new Ext.util.HashMap();
		powerBiSubMenu3Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT4_VIEW, "VIEW");
		powerBiSubMenu3Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT4_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu3Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT4_EDIT_BUTTON, "EDIT");
		powerBiSubMenu3Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT4_PRINT_BUTTON, "PRINT");
		powerBiSubMenu3Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT4_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU3_REPORT4_PRIVILEGES", powerBiSubMenu3Report4Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu3Report5Privileges = new Ext.util.HashMap();
		powerBiSubMenu3Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT5_VIEW, "VIEW");
		powerBiSubMenu3Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT5_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu3Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT5_EDIT_BUTTON, "EDIT");
		powerBiSubMenu3Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT5_PRINT_BUTTON, "PRINT");
		powerBiSubMenu3Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU3_REPORT5_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU3_REPORT5_PRIVILEGES", powerBiSubMenu3Report5Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu4Report1Privileges = new Ext.util.HashMap();
		powerBiSubMenu4Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT1_VIEW, "VIEW");
		powerBiSubMenu4Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT1_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu4Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT1_EDIT_BUTTON, "EDIT");
		powerBiSubMenu4Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT1_PRINT_BUTTON, "PRINT");
		powerBiSubMenu4Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT1_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU4_REPORT1_PRIVILEGES", powerBiSubMenu4Report1Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu4Report2Privileges = new Ext.util.HashMap();
		powerBiSubMenu4Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT2_VIEW, "VIEW");
		powerBiSubMenu4Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT2_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu4Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT2_EDIT_BUTTON, "EDIT");
		powerBiSubMenu4Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT2_PRINT_BUTTON, "PRINT");
		powerBiSubMenu4Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT2_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU4_REPORT2_PRIVILEGES", powerBiSubMenu4Report2Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu4Report3Privileges = new Ext.util.HashMap();
		powerBiSubMenu4Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT3_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu4Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT3_EDIT_BUTTON, "EDIT");
		powerBiSubMenu4Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT3_PRINT_BUTTON, "PRINT");
		powerBiSubMenu4Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT3_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU4_REPORT3_PRIVILEGES", powerBiSubMenu4Report3Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu4Report4Privileges = new Ext.util.HashMap();
		powerBiSubMenu4Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT4_VIEW, "VIEW");
		powerBiSubMenu4Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT4_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu4Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT4_EDIT_BUTTON, "EDIT");
		powerBiSubMenu4Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT4_PRINT_BUTTON, "PRINT");
		powerBiSubMenu4Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT4_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU4_REPORT4_PRIVILEGES", powerBiSubMenu4Report4Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu4Report5Privileges = new Ext.util.HashMap();
		powerBiSubMenu4Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT5_VIEW, "VIEW");
		powerBiSubMenu4Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT5_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu4Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT5_EDIT_BUTTON, "EDIT");
		powerBiSubMenu4Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT5_PRINT_BUTTON, "PRINT");
		powerBiSubMenu4Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU4_REPORT5_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU4_REPORT5_PRIVILEGES", powerBiSubMenu4Report5Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu5Report1Privileges = new Ext.util.HashMap();
		powerBiSubMenu5Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT1_VIEW, "VIEW");
		powerBiSubMenu5Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT1_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu5Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT1_EDIT_BUTTON, "EDIT");
		powerBiSubMenu5Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT1_PRINT_BUTTON, "PRINT");
		powerBiSubMenu5Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT1_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU5_REPORT1_PRIVILEGES", powerBiSubMenu5Report1Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		
		powerBiSubMenu5Report2Privileges = new Ext.util.HashMap();
		powerBiSubMenu5Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT2_VIEW, "VIEW");
		powerBiSubMenu5Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT2_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu5Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT2_EDIT_BUTTON, "EDIT");
		powerBiSubMenu5Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT2_PRINT_BUTTON, "PRINT");
		powerBiSubMenu5Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT2_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU5_REPORT2_PRIVILEGES", powerBiSubMenu5Report2Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu5Report3Privileges = new Ext.util.HashMap();
		powerBiSubMenu5Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT3_VIEW, "VIEW");
		powerBiSubMenu5Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT3_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu5Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT3_EDIT_BUTTON, "EDIT");
		powerBiSubMenu5Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT3_PRINT_BUTTON, "PRINT");
		powerBiSubMenu5Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT3_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU5_REPORT3_PRIVILEGES", powerBiSubMenu5Report3Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu5Report4Privileges = new Ext.util.HashMap();
		powerBiSubMenu5Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT4_VIEW, "VIEW");
		powerBiSubMenu5Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT4_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu5Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT4_EDIT_BUTTON, "EDIT");
		powerBiSubMenu5Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT4_PRINT_BUTTON, "PRINT");
		powerBiSubMenu5Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT4_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU5_REPORT4_PRIVILEGES", powerBiSubMenu5Report4Privileges);
		this.featurePrivilegesMap = featurePrivilegesMap;
		
		powerBiSubMenu5Report5Privileges = new Ext.util.HashMap();
		powerBiSubMenu5Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT5_VIEW, "VIEW");
		powerBiSubMenu5Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT5_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu5Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT5_EDIT_BUTTON, "EDIT");
		powerBiSubMenu5Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT5_PRINT_BUTTON, "PRINT");
		powerBiSubMenu5Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU5_REPORT5_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		featurePrivilegesMap.add("POWERBI_MENU5_REPORT5_PRIVILEGES", powerBiSubMenu5Report5Privileges);
		
		powerBiSubMenu6Report1Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT1_VIEW, "VIEW");
		powerBiSubMenu6Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT1_EDIT, "EDIT");
		powerBiSubMenu6Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT1_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT1_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT1_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT1_PRIVILEGES", powerBiSubMenu6Report1Privileges);
		
		powerBiSubMenu6Report2Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT2_VIEW, "VIEW");
		powerBiSubMenu6Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT2_EDIT, "EDIT");
		powerBiSubMenu6Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT2_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT2_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT2_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT2_PRIVILEGES", powerBiSubMenu6Report2Privileges);
		
		powerBiSubMenu6Report3Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT3_VIEW, "VIEW");
		powerBiSubMenu6Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT3_EDIT, "EDIT");
		powerBiSubMenu6Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT3_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT3_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT3_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT3_PRIVILEGES", powerBiSubMenu6Report3Privileges);
		
		powerBiSubMenu6Report4Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT4_VIEW, "VIEW");
		powerBiSubMenu6Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT4_EDIT, "EDIT");
		powerBiSubMenu6Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT4_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT4_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT4_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT4_PRIVILEGES", powerBiSubMenu6Report4Privileges);
		
		powerBiSubMenu6Report5Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT5_VIEW, "VIEW");
		powerBiSubMenu6Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT5_EDIT, "EDIT");
		powerBiSubMenu6Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT5_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT5_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT5_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT5_PRIVILEGES", powerBiSubMenu6Report5Privileges);
		
		powerBiSubMenu6Report6Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT6_VIEW, "VIEW");
		powerBiSubMenu6Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT6_EDIT, "EDIT");
		powerBiSubMenu6Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT6_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT6_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT6_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT6_PRIVILEGES", powerBiSubMenu6Report6Privileges);
		
		powerBiSubMenu6Report7Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT7_VIEW, "VIEW");
		powerBiSubMenu6Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT7_EDIT, "EDIT");
		powerBiSubMenu6Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT7_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT7_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT7_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT7_PRIVILEGES", powerBiSubMenu6Report7Privileges);
		
		powerBiSubMenu6Report8Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT8_VIEW, "VIEW");
		powerBiSubMenu6Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT8_EDIT, "EDIT");
		powerBiSubMenu6Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT8_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT8_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT8_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT8_PRIVILEGES", powerBiSubMenu6Report8Privileges);
		
		powerBiSubMenu6Report9Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT9_VIEW, "VIEW");
		powerBiSubMenu6Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT9_EDIT, "EDIT");
		powerBiSubMenu6Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT9_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT9_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT9_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT9_PRIVILEGES", powerBiSubMenu6Report9Privileges);
		
		powerBiSubMenu6Report10Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT10_VIEW, "VIEW");
		powerBiSubMenu6Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT10_EDIT, "EDIT");
		powerBiSubMenu6Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT10_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT10_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT10_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT10_PRIVILEGES", powerBiSubMenu6Report10Privileges);
		
		powerBiSubMenu6Report11Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report11Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT11_VIEW, "VIEW");
		powerBiSubMenu6Report11Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT11_EDIT, "EDIT");
		powerBiSubMenu6Report11Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT11_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report11Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT11_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report11Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT11_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT11_PRIVILEGES", powerBiSubMenu6Report11Privileges);
		
		powerBiSubMenu6Report12Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report12Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT12_VIEW, "VIEW");
		powerBiSubMenu6Report12Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT12_EDIT, "EDIT");
		powerBiSubMenu6Report12Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT12_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report12Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT12_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report12Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT12_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT12_PRIVILEGES", powerBiSubMenu6Report12Privileges);
		
		powerBiSubMenu6Report13Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report13Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT13_VIEW, "VIEW");
		powerBiSubMenu6Report13Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT13_EDIT, "EDIT");
		powerBiSubMenu6Report13Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT13_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report13Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT13_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report13Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT13_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT13_PRIVILEGES", powerBiSubMenu6Report13Privileges);
		
		powerBiSubMenu6Report14Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report14Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT14_VIEW, "VIEW");
		powerBiSubMenu6Report14Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT14_EDIT, "EDIT");
		powerBiSubMenu6Report14Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT14_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report14Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT14_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report14Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT14_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT14_PRIVILEGES", powerBiSubMenu6Report14Privileges);
		
		powerBiSubMenu6Report15Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report15Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT15_VIEW, "VIEW");
		powerBiSubMenu6Report15Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT15_EDIT, "EDIT");
		powerBiSubMenu6Report15Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT15_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report15Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT15_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report15Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT15_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT15_PRIVILEGES", powerBiSubMenu6Report15Privileges);
		
		powerBiSubMenu6Report16Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report16Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT16_VIEW, "VIEW");
		powerBiSubMenu6Report16Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT16_EDIT, "EDIT");
		powerBiSubMenu6Report16Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT16_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report16Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT16_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report16Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT16_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT16_PRIVILEGES", powerBiSubMenu6Report16Privileges);
		
		powerBiSubMenu6Report17Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report17Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT17_VIEW, "VIEW");
		powerBiSubMenu6Report17Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT17_EDIT, "EDIT");
		powerBiSubMenu6Report17Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT17_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report17Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT17_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report17Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT17_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT17_PRIVILEGES", powerBiSubMenu6Report17Privileges);
		
		powerBiSubMenu6Report18Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report18Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT18_VIEW, "VIEW");
		powerBiSubMenu6Report18Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT18_EDIT, "EDIT");
		powerBiSubMenu6Report18Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT18_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report18Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT18_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report18Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT18_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT18_PRIVILEGES", powerBiSubMenu6Report18Privileges);
		
		powerBiSubMenu6Report19Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report19Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT19_VIEW, "VIEW");
		powerBiSubMenu6Report19Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT19_EDIT, "EDIT");
		powerBiSubMenu6Report19Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT19_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report19Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT19_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report19Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT19_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT19_PRIVILEGES", powerBiSubMenu6Report19Privileges);
		
		
		powerBiSubMenu6Report20Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report20Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT20_VIEW, "VIEW");
		powerBiSubMenu6Report20Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT20_EDIT, "EDIT");
		powerBiSubMenu6Report20Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT20_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report20Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT20_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report20Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT20_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT20_PRIVILEGES", powerBiSubMenu6Report20Privileges);
		
		powerBiSubMenu6Report21Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report21Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT21_VIEW, "VIEW");
		powerBiSubMenu6Report21Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT21_EDIT, "EDIT");
		powerBiSubMenu6Report21Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT21_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report21Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT21_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report21Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT21_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT21_PRIVILEGES", powerBiSubMenu6Report21Privileges);
		
		powerBiSubMenu6Report22Privileges = new Ext.util.HashMap();
		powerBiSubMenu6Report22Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT22_VIEW, "VIEW");
		powerBiSubMenu6Report22Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT22_EDIT, "EDIT");
		powerBiSubMenu6Report22Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT22_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu6Report22Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT22_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu6Report22Privileges.add(FPCONSTANTS.PBI_SUBMENU6_REPORT22_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU6_REPORT22_PRIVILEGES", powerBiSubMenu6Report22Privileges);
			 
		powerBiSubMenu7Report1Privileges = new Ext.util.HashMap();
		powerBiSubMenu7Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT1_VIEW, "VIEW");
		powerBiSubMenu7Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT1_EDIT, "EDIT");
		powerBiSubMenu7Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT1_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu7Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT1_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu7Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT1_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU7_REPORT1_PRIVILEGES", powerBiSubMenu7Report1Privileges);
		
		powerBiSubMenu7Report2Privileges = new Ext.util.HashMap();
		powerBiSubMenu7Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT2_VIEW, "VIEW");
		powerBiSubMenu7Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT2_EDIT, "EDIT");
		powerBiSubMenu7Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT2_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu7Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT2_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu7Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT2_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU7_REPORT2_PRIVILEGES", powerBiSubMenu7Report2Privileges);
		
		powerBiSubMenu7Report3Privileges = new Ext.util.HashMap();
		powerBiSubMenu7Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT3_VIEW, "VIEW");
		powerBiSubMenu7Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT3_EDIT, "EDIT");
		powerBiSubMenu7Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT3_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu7Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT3_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu7Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT3_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU7_REPORT3_PRIVILEGES", powerBiSubMenu7Report3Privileges);
		
		powerBiSubMenu7Report4Privileges = new Ext.util.HashMap();
		powerBiSubMenu7Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT4_VIEW, "VIEW");
		powerBiSubMenu7Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT4_EDIT, "EDIT");
		powerBiSubMenu7Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT4_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu7Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT4_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu7Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT4_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU7_REPORT4_PRIVILEGES", powerBiSubMenu7Report4Privileges);
		
		powerBiSubMenu7Report5Privileges = new Ext.util.HashMap();
		powerBiSubMenu7Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT5_VIEW, "VIEW");
		powerBiSubMenu7Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT5_EDIT, "EDIT");
		powerBiSubMenu7Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT5_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu7Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT5_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu7Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT5_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU7_REPORT5_PRIVILEGES", powerBiSubMenu7Report5Privileges);
		
		powerBiSubMenu7Report6Privileges = new Ext.util.HashMap();
		powerBiSubMenu7Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT6_VIEW, "VIEW");
		powerBiSubMenu7Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT6_EDIT, "EDIT");
		powerBiSubMenu7Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT6_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu7Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT6_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu7Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT6_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU7_REPORT6_PRIVILEGES", powerBiSubMenu7Report6Privileges);
		
		powerBiSubMenu7Report7Privileges = new Ext.util.HashMap();
		powerBiSubMenu7Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT7_VIEW, "VIEW");
		powerBiSubMenu7Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT7_EDIT, "EDIT");
		powerBiSubMenu7Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT7_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu7Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT7_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu7Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT7_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU7_REPORT7_PRIVILEGES", powerBiSubMenu7Report7Privileges);
		
		powerBiSubMenu7Report8Privileges = new Ext.util.HashMap();
		powerBiSubMenu7Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT8_VIEW, "VIEW");
		powerBiSubMenu7Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT8_EDIT, "EDIT");
		powerBiSubMenu7Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT8_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu7Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT8_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu7Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT8_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU7_REPORT8_PRIVILEGES", powerBiSubMenu7Report8Privileges);
		
		powerBiSubMenu7Report9Privileges = new Ext.util.HashMap();
		powerBiSubMenu7Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT9_VIEW, "VIEW");
		powerBiSubMenu7Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT9_EDIT, "EDIT");
		powerBiSubMenu7Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT9_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu7Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT9_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu7Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT9_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU7_REPORT9_PRIVILEGES", powerBiSubMenu7Report9Privileges);
		
		powerBiSubMenu7Report10Privileges = new Ext.util.HashMap();
		powerBiSubMenu7Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT10_VIEW, "VIEW");
		powerBiSubMenu7Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT10_EDIT, "EDIT");
		powerBiSubMenu7Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT10_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
		powerBiSubMenu7Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT10_RELOAD_BUTTON, "REFRESH");
		powerBiSubMenu7Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU7_REPORT10_PRINT_BUTTON, "PRINT");
		featurePrivilegesMap.add("POWERBI_MENU7_REPORT10_PRIVILEGES", powerBiSubMenu7Report10Privileges);
		
		 powerBiSubMenu8Report1Privileges = new Ext.util.HashMap();
	     powerBiSubMenu8Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT1_VIEW, "VIEW");
	     powerBiSubMenu8Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT1_EDIT, "EDIT");
	     powerBiSubMenu8Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT1_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT1_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report1Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT1_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT1_PRIVILEGES", powerBiSubMenu8Report1Privileges);
		 
		 powerBiSubMenu8Report2Privileges = new Ext.util.HashMap();
	     powerBiSubMenu8Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT2_VIEW, "VIEW");
	     powerBiSubMenu8Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT2_EDIT, "EDIT");
	     powerBiSubMenu8Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT2_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT2_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report2Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT2_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT2_PRIVILEGES", powerBiSubMenu8Report2Privileges);
		 
		 powerBiSubMenu8Report3Privileges = new Ext.util.HashMap();
	     powerBiSubMenu8Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT3_VIEW, "VIEW");
	     powerBiSubMenu8Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT3_EDIT, "EDIT");
	     powerBiSubMenu8Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT3_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT3_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report3Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT3_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT3_PRIVILEGES", powerBiSubMenu8Report3Privileges);
		 
		 powerBiSubMenu8Report4Privileges = new Ext.util.HashMap();
	     powerBiSubMenu8Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT4_VIEW, "VIEW");
	     powerBiSubMenu8Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT4_EDIT, "EDIT");
	     powerBiSubMenu8Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT4_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT4_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report4Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT4_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT4_PRIVILEGES", powerBiSubMenu8Report4Privileges);
		 
		 powerBiSubMenu8Report5Privileges = new Ext.util.HashMap();
	     powerBiSubMenu8Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT5_VIEW, "VIEW");
	     powerBiSubMenu8Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT5_EDIT, "EDIT");
	     powerBiSubMenu8Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT5_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT5_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report5Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT5_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT5_PRIVILEGES", powerBiSubMenu8Report5Privileges);
		
     	 powerBiSubMenu8Report6Privileges = new Ext.util.HashMap();
	     powerBiSubMenu8Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT6_VIEW, "VIEW");
	     powerBiSubMenu8Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT6_EDIT, "EDIT");
	     powerBiSubMenu8Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT6_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT6_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report6Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT6_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT6_PRIVILEGES", powerBiSubMenu8Report6Privileges);
			
		 powerBiSubMenu8Report7Privileges = new Ext.util.HashMap();
	 	 powerBiSubMenu8Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT7_VIEW, "VIEW");
	 	powerBiSubMenu8Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT7_EDIT, "EDIT");
		powerBiSubMenu8Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT7_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT7_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report7Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT7_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT7_PRIVILEGES", powerBiSubMenu8Report7Privileges);
			
		 powerBiSubMenu8Report8Privileges = new Ext.util.HashMap();
		 powerBiSubMenu8Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT8_VIEW, "VIEW");
		 powerBiSubMenu8Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT8_EDIT, "EDIT");
		 powerBiSubMenu8Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT8_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT8_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report8Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT8_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT8_PRIVILEGES", powerBiSubMenu8Report8Privileges);
			
		 powerBiSubMenu8Report9Privileges = new Ext.util.HashMap();
		 powerBiSubMenu8Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT9_VIEW, "VIEW");
		 powerBiSubMenu8Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT9_EDIT, "EDIT");
		 powerBiSubMenu8Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT9_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT9_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report9Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT9_PRINT_BUTTON, "PRINT");
	     featurePrivilegesMap.add("POWERBI_MENU8_REPORT9_PRIVILEGES", powerBiSubMenu8Report9Privileges);
			
		 powerBiSubMenu8Report10Privileges = new Ext.util.HashMap();
		 powerBiSubMenu8Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT10_VIEW, "VIEW");
		 powerBiSubMenu8Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT10_EDIT, "EDIT");
		 powerBiSubMenu8Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT10_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT10_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report10Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT10_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT10_PRIVILEGES", powerBiSubMenu8Report10Privileges);

		 powerBiSubMenu8Report11Privileges = new Ext.util.HashMap();
		 powerBiSubMenu8Report11Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT11_VIEW, "VIEW");
		 powerBiSubMenu8Report11Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT11_EDIT, "EDIT");
		 powerBiSubMenu8Report11Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT11_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report11Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT11_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report11Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT11_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT11_PRIVILEGES", powerBiSubMenu8Report11Privileges);
		 
		 powerBiSubMenu8Report12Privileges = new Ext.util.HashMap();
		 powerBiSubMenu8Report12Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT12_VIEW, "VIEW");
		 powerBiSubMenu8Report12Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT12_EDIT, "EDIT");
		 powerBiSubMenu8Report12Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT12_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report12Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT12_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report12Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT12_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT12_PRIVILEGES", powerBiSubMenu8Report12Privileges);
		 
		 powerBiSubMenu8Report13Privileges = new Ext.util.HashMap();
		 powerBiSubMenu8Report13Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT13_VIEW, "VIEW");
		 powerBiSubMenu8Report13Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT13_EDIT, "EDIT");
		 powerBiSubMenu8Report13Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT13_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report13Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT13_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report13Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT13_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT13_PRIVILEGES", powerBiSubMenu8Report13Privileges);
		 
		 powerBiSubMenu8Report14Privileges = new Ext.util.HashMap();
		 powerBiSubMenu8Report14Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT14_VIEW, "VIEW");
		 powerBiSubMenu8Report14Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT14_EDIT, "EDIT");
		 powerBiSubMenu8Report14Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT14_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report14Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT14_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report14Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT14_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT14_PRIVILEGES", powerBiSubMenu8Report14Privileges);
		 
		 powerBiSubMenu8Report15Privileges = new Ext.util.HashMap();
		 powerBiSubMenu8Report15Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT15_VIEW, "VIEW");
		 powerBiSubMenu8Report15Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT15_EDIT, "EDIT");
		 powerBiSubMenu8Report15Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT15_REFRESH_DATASET_BUTTON, "REFRESH_DATASET");
	     powerBiSubMenu8Report15Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT15_RELOAD_BUTTON, "REFRESH");
	     powerBiSubMenu8Report15Privileges.add(FPCONSTANTS.PBI_SUBMENU8_REPORT15_PRINT_BUTTON, "PRINT");
		 featurePrivilegesMap.add("POWERBI_MENU8_REPORT15_PRIVILEGES", powerBiSubMenu8Report15Privileges);
       
		
		//******************************Admission Statistics Dashboard Report Tree Links***************************************************
		admissionStatisticsTreeLinksPrivileges = new Ext.util.HashMap();
		admissionStatisticsTreeLinksPrivileges.add(FPCONSTANTS.PC_M6_F_ADMISSION_STATISTICS_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("ADMISSION_STATISTICS_REPORT_TREELINKS_PRIVILEGES", admissionStatisticsTreeLinksPrivileges);
        //******************************End*********************************************************************
		//******************************Application Statistics Dashboard Report Tree Links***************************************************
		applicationStatisticsTreeLinksPrivileges = new Ext.util.HashMap();
		applicationStatisticsTreeLinksPrivileges.add(FPCONSTANTS.PC_M6_F_APPLICATION_STATISTICS_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICATION_STATISTICS_REPORT_TREELINKS_PRIVILEGES", applicationStatisticsTreeLinksPrivileges);
        //******************************End*********************************************************************
		
		//******************************Admission Rejection Dashboard Report Tree Links***************************************************
		admissionRejectionTreeLinksPrivileges = new Ext.util.HashMap();
		admissionRejectionTreeLinksPrivileges.add(FPCONSTANTS.PC_M6_F_ADMISSION_REJECTION_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("ADMISSION_REJECTION_ANALYSIS_REPORT_TREELINKS_PRIVILEGES", admissionRejectionTreeLinksPrivileges);
        //******************************End*********************************************************************
		
		
		//******************************Selection Process Dashboard Report Tree Links***************************************************
		selectionProcessTreeLinksPrivileges = new Ext.util.HashMap();
		selectionProcessTreeLinksPrivileges.add(FPCONSTANTS.PC_M6_F_SELECTION_PROCESS_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("SELECTION_PROCESS_OVERVIEW_REPORT_TREELINKS_PRIVILEGES", selectionProcessTreeLinksPrivileges);
        //******************************End*********************************************************************
		
		//******************************Application Summary Dashboard Report Tree Links***************************************************
		applicationSummaryTreeLinksPrivileges = new Ext.util.HashMap();
		applicationSummaryTreeLinksPrivileges.add(FPCONSTANTS.PC_M6_F_APPLICATION_SUMMARY_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICATION_SUMMARY_REPORT_TREELINKS_PRIVILEGES", applicationSummaryTreeLinksPrivileges);
        //******************************End*********************************************************************
		
		//******************************Admissions Summary by Admissions Date Tree Links***************************************************
		admissionSummaryTreeLinksPrivileges = new Ext.util.HashMap();
		admissionSummaryTreeLinksPrivileges.add(FPCONSTANTS.PC_M6_F_ADMISSION_SUMMARY_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("ADMISSION_SUMMARY_REPORT_TREELINKS_PRIVILEGES", admissionSummaryTreeLinksPrivileges);
        //******************************End*********************************************************************
		
		//******************************Admissions Summary by Admissions Approved on Date Tree Links***************************************************
		admissionSummaryByApprovedDateTreeLinksPrivileges = new Ext.util.HashMap();
		admissionSummaryByApprovedDateTreeLinksPrivileges.add(FPCONSTANTS.PC_M6_F_ADMISSION_SUMMARY_BYAPPROVEDATE_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("ADMISSION_SUMMARY_BYAPPROVEDATE_REPORT_TREELINKS_PRIVILEGES", admissionSummaryByApprovedDateTreeLinksPrivileges);
        //******************************End*********************************************************************
		
		//******************************Admission Statistics Dashboard Report Tree Links***************************************************
		applicationCommentsTreeLinksPrivileges = new Ext.util.HashMap();
		applicationCommentsTreeLinksPrivileges.add(FPCONSTANTS.PC_M6_F_APPLICATION_COMMENTS_REPORT_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICATION_COMMENTS_REPORT_TREELINKS_PRIVILEGES", applicationCommentsTreeLinksPrivileges);
        //******************************End*********************************************************************
				
		enquiryStudentDetailsTabsPrivileges = new Ext.util.HashMap();
		enquiryStudentDetailsTabsPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRY_STUDENT_DETAILS_VIEW, "VIEW");
		featurePrivilegesMap.add("ENQUIRY_STUDENT_DETAILS_TAB_PRIVILEGES", enquiryStudentDetailsTabsPrivileges);
		
		enquiryEducationDetailsTabsPrivileges = new Ext.util.HashMap();
		enquiryEducationDetailsTabsPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRY_EDUCATION_DETAILS_VIEW,"VIEW");
		featurePrivilegesMap.add("ENQUIRY_EDUCATION_DETAILS_TAB_PRIVILEGES", enquiryEducationDetailsTabsPrivileges);
		
		enquiryCommunicationHistoryDetailsTabsPrivileges = new Ext.util.HashMap();
		enquiryCommunicationHistoryDetailsTabsPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRY_COMMUNICATION_HISTORY_VIEW,"VIEW");
		featurePrivilegesMap.add("ENQUIRY_COMMUNICATION_HISTORY_DETAILS_TAB_PRIVILEGES", enquiryCommunicationHistoryDetailsTabsPrivileges);		
		
		enquiryImportCampaignUtilityPrivileges=new Ext.util.HashMap();
		enquiryImportCampaignUtilityPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRYIMPORTCAMPAIGNUTILITY_VIEW, "VIEW");
		featurePrivilegesMap.add("ENQUIRY_IMPORT_CAMPAIGN_UTILITY_PRIVILEGES", enquiryImportCampaignUtilityPrivileges);
		
		enquiryImportCampaignUtilityPrivileges=new Ext.util.HashMap();
		enquiryImportCampaignUtilityPrivileges.add(FPCONSTANTS.PC_M2_F_ENQUIRYIMPORTCAMPAIGNUTILITY_VIEW, "VIEW");
		featurePrivilegesMap.add("ENQUIRY_IMPORT_CAMPAIGN_UTILITY_PRIVILEGES", enquiryImportCampaignUtilityPrivileges);
		
		
		/****** For Student Certificate Print As Word File Details***********/
		studentCertificatePrintAsWordFileDetailsPrivileges = new Ext.util.HashMap();
		studentCertificatePrintAsWordFileDetailsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_CERTIFICATE_PRINT_AS_WORD_FILE,"PRINT_AS_WORD_FILE");
		featurePrivilegesMap.add("STUDENT_CERTIFICATE_PRINT_AS_WORD_FILE_PRIVILEGES", studentCertificatePrintAsWordFileDetailsPrivileges);
		
		/****** For References on Applicant Portal***********/
		applicantApplicationReferencesPrivileges = new Ext.util.HashMap();
		applicantApplicationReferencesPrivileges.add(FPCONSTANTS.AC_M17_F_REFERENCES_RESENDLINK,"RESENDLINK");
		featurePrivilegesMap.add("APPLICANT_APPLICATION_REFERENCES_PRIVILEGES", applicantApplicationReferencesPrivileges);
		

		/****** For Student Head Wise Bills***********/
		studentHeadWiseBillsPrivileges = new Ext.util.HashMap();
		studentHeadWiseBillsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_HEAD_WISE_BILLS_VIEW,"VIEW");
		studentHeadWiseBillsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_HEAD_WISE_BILLS_EXPORT,"EXPORT");
		studentHeadWiseBillsPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_HEAD_WISE_BILLS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_HEAD_WISE_BILLS_PRIVILEGES", studentHeadWiseBillsPrivileges);
		
		followupDetailApplicantProfilePrivileges = new Ext.util.HashMap();
		followupDetailApplicantProfilePrivileges.add(FPCONSTANTS.PC_M2_F_APPLICANT_PROFILE_FOLLOWUPDETAIL_VIEW, "VIEW");
		followupDetailApplicantProfilePrivileges.add(FPCONSTANTS.PC_M2_F_APPLICANT_PROFILE_FOLLOWUPDETAIL_UPDATE,"UPDATE");
		followupDetailApplicantProfilePrivileges.add(FPCONSTANTS.PC_M2_F_APPLICANT_PROFILE_FOLLOWUPDETAIL_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FOLLOWUP_DETAIL_APPLICANT_PROFILE_PRIVILEGES", followupDetailApplicantProfilePrivileges);
	
		paymentModeRadioButtonPrivileges = new Ext.util.HashMap();
		paymentModeRadioButtonPrivileges.add(FPCONSTANTS.AC_M10_F_DEC_PAYMENTS_ONLINE_PAYMENT_MODE, "ONLINE_PAYMENT_MODE");
		paymentModeRadioButtonPrivileges.add(FPCONSTANTS.AC_M10_F_DEC_PAYMENTS_OFFLINE_PAYMENT_MODE, "OFFLINE_PAYMENT_MODE");
		featurePrivilegesMap.add("PAYMENT_MODE_APPLICANT_PROFILE_PRIVILEGES", paymentModeRadioButtonPrivileges);
		
		applicantPortalSetupProfilePrivileges = new Ext.util.HashMap();
		applicantPortalSetupProfilePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_PORTAL_SETUP_VIEW,"VIEW");
		applicantPortalSetupProfilePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_PORTAL_SETUP_CREATE,"CREATE");
		applicantPortalSetupProfilePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_PORTAL_SETUP_UPDATE,"UPDATE");
		applicantPortalSetupProfilePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_PORTAL_SETUP_DELETE,"DELETE");
		applicantPortalSetupProfilePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_PORTAL_SETUP_COPY,"COPY");
		applicantPortalSetupProfilePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_PORTAL_SETUP_APPLY,"APPLY");
		applicantPortalSetupProfilePrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_PORTAL_SETUP_DEFAULT_PROGRAM_DETAILS_SETUP,"DEFAULT_PROGRAM_DETAILS_SETUP");
		featurePrivilegesMap.add("APPLICANT_PORTAL_SETUP_PROFILE_PRIVILEGES", applicantPortalSetupProfilePrivileges);

		
		studentCurrentlyIssuedBooksToStudent = new Ext.util.HashMap();
		studentCurrentlyIssuedBooksToStudent.add(FPCONSTANTS.SP_M9_SP_LIBRARY_ISSUED_BOOKS_VIEW,"VIEW");
		studentCurrentlyIssuedBooksToStudent.add(FPCONSTANTS.SP_M9_SP_LIBRARY_ISSUED_BOOKS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT", studentCurrentlyIssuedBooksToStudent);
		
		studentBookCirculationHistoryToStudent = new Ext.util.HashMap();
		studentBookCirculationHistoryToStudent.add(FPCONSTANTS.SP_M9_SP_SP_CIRCULATION_BOOKS_HISTORY_VIEW,"VIEW");
		studentBookCirculationHistoryToStudent.add(FPCONSTANTS.SP_M9_SP_SP_CIRCULATION_BOOKS_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT", studentBookCirculationHistoryToStudent);
		
		studentBookReservedHistoryToStudent = new Ext.util.HashMap();
		studentBookReservedHistoryToStudent.add(FPCONSTANTS.SP_M9_SP_SP_RESERVED_BOOKS_HISTORY_VIEW,"VIEW");
		studentBookReservedHistoryToStudent.add(FPCONSTANTS.SP_M9_SP_SP_RESERVED_BOOKS_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_BOOK_RESERVED_HISTORY_TO_STUDENT", studentBookReservedHistoryToStudent);
		
		studentLibraryDueFeesToStudent = new Ext.util.HashMap();
		studentLibraryDueFeesToStudent.add(FPCONSTANTS.SP_M9_SP_BOOKS_FEES_HISTORY_VIEW,"VIEW");
		studentLibraryDueFeesToStudent.add(FPCONSTANTS.SP_M9_SP_BOOKS_FEES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_LIBRARY_DUE_FEES_TO_STUDENT", studentLibraryDueFeesToStudent);

		
		parentCurrentlyIssuedBooksToStudent = new Ext.util.HashMap();
		parentCurrentlyIssuedBooksToStudent.add(FPCONSTANTS.PP_M9_SP_LIBRARY_ISSUED_BOOKS_VIEW,"VIEW");
		parentCurrentlyIssuedBooksToStudent.add(FPCONSTANTS.PP_M9_SP_LIBRARY_ISSUED_BOOKS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_CURRENTLY_ISSUED_BOOKS_TO_STUDENT", parentCurrentlyIssuedBooksToStudent);
		
		parentBookCirculationHistoryToStudent = new Ext.util.HashMap();
		parentBookCirculationHistoryToStudent.add(FPCONSTANTS.PP_M9_SP_CIRCULATION_BOOKS_HISTORY_VIEW,"VIEW");
		parentBookCirculationHistoryToStudent.add(FPCONSTANTS.PP_M9_SP_CIRCULATION_BOOKS_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_BOOK_CIRCULATION_HISTORY_TO_STUDENT", parentBookCirculationHistoryToStudent);
		
		parentBookReservedHistoryToStudent = new Ext.util.HashMap();
		parentBookReservedHistoryToStudent.add(FPCONSTANTS.PP_M9_SP_RESERVED_BOOKS_HISTORY_VIEW,"VIEW");
		parentBookReservedHistoryToStudent.add(FPCONSTANTS.PP_M9_SP_RESERVED_BOOKS_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_BOOK_RESERVED_HISTORY_TO_STUDENT", parentBookReservedHistoryToStudent);
		
		parentLibraryDueFeesToStudent = new Ext.util.HashMap();
		parentLibraryDueFeesToStudent.add(FPCONSTANTS.PP_M9_BOOKS_FEES_HISTORY_VIEW,"VIEW");
		parentLibraryDueFeesToStudent.add(FPCONSTANTS.PP_M9_BOOKS_FEES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_LIBRARY_DUE_FEES_TO_STUDENT", parentLibraryDueFeesToStudent);
		
		employeeCurrentlyIssuedBooksToStudent = new Ext.util.HashMap();
		employeeCurrentlyIssuedBooksToStudent.add(FPCONSTANTS.FP_M9_F_FP_ISSUED_BOOKS_VIEW,"VIEW");
		employeeCurrentlyIssuedBooksToStudent.add(FPCONSTANTS.FP_M9_F_FP_ISSUED_BOOKS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EMPLOYEE_CURRENTLY_ISSUED_BOOKS_TO_EMPLOYEE", employeeCurrentlyIssuedBooksToStudent);
		
		employeeBookCirculationHistory= new Ext.util.HashMap();
		employeeBookCirculationHistory.add(FPCONSTANTS.FP_M9_F_FP_CIRCULATION_BOOKS_HISTORY_VIEW,"VIEW");
		employeeBookCirculationHistory.add(FPCONSTANTS.FP_M9_F_FP_CIRCULATION_BOOKS_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EMPLOYEE_BOOK_CIRCULATION_HISTORY", employeeBookCirculationHistory);
		
		employeeBookReservedHistory= new Ext.util.HashMap();
		employeeBookReservedHistory.add(FPCONSTANTS.FP_M9_F_FP_RESERVED_BOOKS_HISTORY_VIEW,"VIEW");
		employeeBookReservedHistory.add(FPCONSTANTS.FP_M9_F_FP_RESERVED_BOOKS_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EMPLOYEE_BOOK_RESERVED_HISTORY", employeeBookReservedHistory);
		
		employeeLibraryDueFees= new Ext.util.HashMap();
		employeeLibraryDueFees.add(FPCONSTANTS.FP_M9_FP_BOOKS_FEES_HISTORY_VIEW,"VIEW");
		employeeLibraryDueFees.add(FPCONSTANTS.FP_M9_FP_BOOKS_FEES_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("EMPLOYEE_LIBRARY_DUE_FEES", employeeLibraryDueFees);
		
		/* Session Logout Time Setup Link */
		sessionLogoutTimeSetup= new Ext.util.HashMap();
		sessionLogoutTimeSetup.add(FPCONSTANTS.PC_M12_F_LIBRARY_CONFIGURATION_VIEW,"VIEW");
		featurePrivilegesMap.add("SESSION_LOGOUT_TIME_PRIVILEGES", sessionLogoutTimeSetup);
		
		/*Manage Portal Permission Setup Link */
		managePortalPermissionSetup= new Ext.util.HashMap();
		managePortalPermissionSetup.add(FPCONSTANTS.PC_M12_F_MANAGE_PORTAL_PERMISSIONS_VIEW,"VIEW");
		managePortalPermissionSetup.add(FPCONSTANTS.PC_M12_F_MANAGE_PORTAL_PERMISSIONS_STUDENT_PORTAL_CONFIG_TAB,"STUDENT_PORTAL_CONFIG_TAB");
		managePortalPermissionSetup.add(FPCONSTANTS.PC_M12_F_MANAGE_PORTAL_PERMISSIONS_MOBILE_APP_CONFIG_TAB,"MOBILE_APP_CONFIG_TAB");
		featurePrivilegesMap.add("MANAGE_PORTAL_PRIVILEGES", managePortalPermissionSetup);
		
	    studentJourneySettingMap= new Ext.util.HashMap();
	    studentJourneySettingMap.add(FPCONSTANTS.PC_M12_F_STUDENT_JOURNEY_SETTING_PERMISSIONS_VIEW,"VIEW");
	    featurePrivilegesMap.add("STUDENT_JOURNEY_SETUP_PRIVILEGES", studentJourneySettingMap);
	    
	    studentPortalAngularLoginSetupMap= new Ext.util.HashMap();
	    studentPortalAngularLoginSetupMap.add(FPCONSTANTS.PC_M12_F_STUDENT_PORTAL_ANGULAR_LOGIN_SETUP_PERMISSIONS_VIEW,"VIEW");
	    featurePrivilegesMap.add("STUDENT_PORTAL_ANGULAR_LOGIN_SETUP_PRIVILEGES", studentPortalAngularLoginSetupMap);
		
		libraryBranchAndCategoryMapping= new Ext.util.HashMap();
		libraryBranchAndCategoryMapping.add(FPCONSTANTS.PC_M12_F_LIBRARY_CONFIGURATION_VIEW,"VIEW");
		libraryBranchAndCategoryMapping.add(FPCONSTANTS.PC_M12_F_LIBRARY_CONFIGURATION_MAP_LIBRARY,"MAP_LIBRARY");
		libraryBranchAndCategoryMapping.add(FPCONSTANTS.PC_M12_F_LIBRARY_CONFIGURATION_MAP_CATEGORY,"MAP_CATEGORY");
		libraryBranchAndCategoryMapping.add(FPCONSTANTS.PC_M12_F_LIBRARY_CONFIGURATION_DELETE,"Delete");
		libraryBranchAndCategoryMapping.add(FPCONSTANTS.PC_M12_F_LIBRARY_CONFIGURATION_UPDATE_LIBRARY_CARD_SETTING,"Edit");
		featurePrivilegesMap.add("LIBRARY_BRANCH_AND_CATEGORY_MAPPING", libraryBranchAndCategoryMapping);
		
		jasperReportMapping= new Ext.util.HashMap();
		jasperReportMapping.add(FPCONSTANTS.PC_M12_F_JASPER_REPORT_STRUCTURE_VIEW,"VIEW");
		
		coreErpBookIssuedStudentHistory= new Ext.util.HashMap();
		coreErpBookIssuedStudentHistory.add(FPCONSTANTS.CERP_M9_SP_LIBRARY_ISSUED_BOOKS_STUDENT_VIEW,"VIEW");
		coreErpBookIssuedStudentHistory.add(FPCONSTANTS.CERP_M9_SP_LIBRARY_ISSUED_BOOKS_STUDENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_BOOK_ISSUED_STUDENT_HISTORY", coreErpBookIssuedStudentHistory);
		
		FPTOSPErpBookIssuedStudentHistory= new Ext.util.HashMap();
		FPTOSPErpBookIssuedStudentHistory.add(FPCONSTANTS.FPTOSP_M9_SP_LIBRARY_ISSUED_BOOKS_STUDENT_VIEW,"VIEW");
		FPTOSPErpBookIssuedStudentHistory.add(FPCONSTANTS.FPTOSP_M9_SP_LIBRARY_ISSUED_BOOKS_STUDENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FPTOSP_ERP_BOOK_ISSUED_STUDENT_HISTORY", FPTOSPErpBookIssuedStudentHistory);
		
		coreERPBookCirculationStudentHistory= new Ext.util.HashMap();
		coreERPBookCirculationStudentHistory.add(FPCONSTANTS.CERP_M9_SP_SP_CIRCULATION_BOOKS_HISTORY_STUDENT_VIEW,"VIEW");
		coreERPBookCirculationStudentHistory.add(FPCONSTANTS.CERP_M9_SP_SP_CIRCULATION_BOOKS_HISTORY_STUDENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_BOOK_CIRCULATION_STUDENT_HISTORY", coreERPBookCirculationStudentHistory);
		
		FPTOSPERPBookCirculationStudentHistory= new Ext.util.HashMap();
		FPTOSPERPBookCirculationStudentHistory.add(FPCONSTANTS.FPTOSP_M9_SP_SP_CIRCULATION_BOOKS_HISTORY_VIEW,"VIEW");
		FPTOSPERPBookCirculationStudentHistory.add(FPCONSTANTS.FPTOSP_M9_SP_SP_CIRCULATION_BOOKS_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FPTOSP_ERP_BOOK_CIRCULATION_STUDENT_HISTORY", FPTOSPERPBookCirculationStudentHistory);
		

		FPTOSPERPBookReservedStudentHistory= new Ext.util.HashMap();
		FPTOSPERPBookReservedStudentHistory.add(FPCONSTANTS.FPTOSP_M9_SP_SP_RESERVED_BOOKS_HISTORY_VIEW,"VIEW");
		FPTOSPERPBookReservedStudentHistory.add(FPCONSTANTS.FPTOSP_M9_SP_SP_RESERVED_BOOKS_HISTORY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FPTOSP_ERP_BOOK_RESERVED_STUDENT_HISTORY", FPTOSPERPBookReservedStudentHistory);
		
		
		coreERPBookReservedStudentHistory= new Ext.util.HashMap();
		coreERPBookReservedStudentHistory.add(FPCONSTANTS.CERP_M9_SP_SP_RESERVED_BOOKS_HISTORY_STUDENT_VIEW,"VIEW");
		coreERPBookReservedStudentHistory.add(FPCONSTANTS.CERP_M9_SP_SP_RESERVED_BOOKS_HISTORY_STUDENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_BOOK_RESERVED_STUDENT_HISTORY", coreERPBookReservedStudentHistory);
		
		coreERPLibraryDueStudentFees= new Ext.util.HashMap();
		coreERPLibraryDueStudentFees.add(FPCONSTANTS.CERP_M9_SP_BOOKS_FEES_HISTORY_STUDENT_VIEW,"VIEW");
		coreERPLibraryDueStudentFees.add(FPCONSTANTS.CERP_M9_SP_BOOKS_FEES_HISTORY_STUDENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_LIBRARY_DUE_STUDENT_FEES", coreERPLibraryDueStudentFees);
		
		FPTOSPERPLibraryDueStudentFees= new Ext.util.HashMap();
		FPTOSPERPLibraryDueStudentFees.add(FPCONSTANTS.FPTOSP_ERP_LIBRARY_DUE_STUDENT_FEES_VIEW,"VIEW");
		FPTOSPERPLibraryDueStudentFees.add(FPCONSTANTS.FPTOSP_ERP_LIBRARY_DUE_STUDENT_FEES_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FPTOSP_ERP_LIBRARY_DUE_STUDENT_FEES", FPTOSPERPLibraryDueStudentFees);
		
		
		
		coreErpBookIssuedEmployeeHistory= new Ext.util.HashMap();
		coreErpBookIssuedEmployeeHistory.add(FPCONSTANTS.CERP_M9_SP_LIBRARY_ISSUED_BOOKS_EMPLOYEE_VIEW,"VIEW");
		coreErpBookIssuedEmployeeHistory.add(FPCONSTANTS.CERP_M9_SP_LIBRARY_ISSUED_BOOKS_EMPLOYEE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_BOOK_ISSUED_EMPLOYEE_HISTORY", coreErpBookIssuedEmployeeHistory);
		
		coreERPBookCirculationEmployeeHistory= new Ext.util.HashMap();
		coreERPBookCirculationEmployeeHistory.add(FPCONSTANTS.CERP_M9_SP_SP_CIRCULATION_BOOKS_HISTORY_EMPLOYEE_VIEW,"VIEW");
		coreERPBookCirculationEmployeeHistory.add(FPCONSTANTS.CERP_M9_SP_SP_CIRCULATION_BOOKS_HISTORY_EMPLOYEE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_BOOK_CIRCULATION_EMPLOYEE_HISTORY", coreERPBookCirculationEmployeeHistory);
		

		coreERPBookReservedEmployeeHistory= new Ext.util.HashMap();
		coreERPBookReservedEmployeeHistory.add(FPCONSTANTS.CERP_M9_SP_SP_RESERVED_BOOKS_HISTORY_EMPLOYEE_VIEW,"VIEW");
		coreERPBookReservedEmployeeHistory.add(FPCONSTANTS.CERP_M9_SP_SP_RESERVED_BOOKS_HISTORY_EMPLOYEE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_BOOK_RESERVED_EMPLOYEE_HISTORY", coreERPBookReservedEmployeeHistory);
		
		coreERPLibraryDueEmployeeFees= new Ext.util.HashMap();
		coreERPLibraryDueEmployeeFees.add(FPCONSTANTS.CERP_M9_SP_BOOKS_FEES_HISTORY_EMPLOYEE_VIEW,"VIEW");
		coreERPLibraryDueEmployeeFees.add(FPCONSTANTS.CERP_M9_SP_BOOKS_FEES_HISTORY_EMPLOYEE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_LIBRARY_DUE_EMPLOYEE_FEES", coreERPLibraryDueEmployeeFees);
		
		
		
		outcomebasededucationPrivileges = new Ext.util.HashMap();
		outcomebasededucationPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_VIEW,"VIEW");
		outcomebasededucationPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_CREATE,"CREATE");
		outcomebasededucationPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_UPDATE,"UPDATE");
		outcomebasededucationPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_DELETE,"DELETE");
		outcomebasededucationPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_EXPORT,"EXPORT");
		outcomebasededucationPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_SAVEPROGRAMOUTCOME,"SAVEPROGRAMOUTCOME");
		outcomebasededucationPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_SAVECOURSEOUTCOME,"SAVECOURSEOUTCOME");
		outcomebasededucationPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_DELETECOURSEOUTCOME,"DELETECOURSEOUTCOME");
		outcomebasededucationPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_EXPORTCOURSEOUTCOME,"EXPORTCOURSEOUTCOME");
		outcomebasededucationPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_EXPORTPROGRAMOUTCOME,"EXPORTPROGRAMOUTCOME");
		outcomebasededucationPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_DELETEPROGRAMOUTCOME,"DELETEPROGRAMOUTCOME");
		featurePrivilegesMap.add("OUT_COME_BASED_EDUCATION_PRIVILEGES", outcomebasededucationPrivileges);
		
		registrationSetupPrivileges = new Ext.util.HashMap();
		registrationSetupPrivileges.add(FPCONSTANTS.PC_M4_F_REGISTRATIONSETUP_VIEW,"VIEW");
		registrationSetupPrivileges.add(FPCONSTANTS.PC_M4_F_REGISTRATIONSETUP_CREATE,"CREATE");
		registrationSetupPrivileges.add(FPCONSTANTS.PC_M4_F_REGISTRATIONSETUP_UPDATE,"UPDATE");
		registrationSetupPrivileges.add(FPCONSTANTS.PC_M4_F_REGISTRATIONSETUP_DELETE,"DELETE");
		registrationSetupPrivileges.add(FPCONSTANTS.PC_M4_F_REGISTRATIONSETUP_COPY_SETUP,"COPY_SETUP");
		registrationSetupPrivileges.add(FPCONSTANTS.PC_M4_F_REGISTRATIONSETUP_CONFIGURE_ADDRESS,"CONFIGURE_ADDRESS");
		registrationSetupPrivileges.add(FPCONSTANTS.PC_M4_F_REGISTRATIONSETUP_CONFIGURE_PARENT_DETAILS,"CONFIGURE_PARENT_DETAILS");
		registrationSetupPrivileges.add(FPCONSTANTS.PC_M4_F_REGISTRATIONSETUP_REGISTRATION_RULES,"REGISTRATION_RULES");
		featurePrivilegesMap.add("REGISTRATION_SETUP_PRIVILEGES", registrationSetupPrivileges);
		
		
		/************** Lecturer Costing Definition **********************************/
		
		lecturerCostingDefinitionPrivilages = new Ext.util.HashMap();
		lecturerCostingDefinitionPrivilages.add(FPCONSTANTS.PC_M4_F_LECTURERCOSTINGDEFINITION_VIEW, "VIEW");
		lecturerCostingDefinitionPrivilages.add(FPCONSTANTS.PC_M4_F_LECTURERCOSTINGDEFINITION_SERVICE_COSTING, "SERVICE_COSTING");
		lecturerCostingDefinitionPrivilages.add(FPCONSTANTS.PC_M4_F_LECTURERCOSTINGDEFINITION_COURSE_COSTING, "COURSE_COSTING");
		lecturerCostingDefinitionPrivilages.add(FPCONSTANTS.PC_M4_F_LECTURERCOSTINGDEFINITION_IMPORT_LECTURE_COSTING, "IMPORT_BULK_LECTURER_COSTING");
		lecturerCostingDefinitionPrivilages.add(FPCONSTANTS.PC_M4_F_LECTURERCOSTINGDEFINITION_CREATE, "CREATE");
		lecturerCostingDefinitionPrivilages.add(FPCONSTANTS.PC_M4_F_LECTURERCOSTINGDEFINITION_DELETE, "DELETE");
		lecturerCostingDefinitionPrivilages.add(FPCONSTANTS.PC_M3_F_LECTURERCOSTINGDEFINITION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("LECTURER_COSTING_DEFINITION_PRIVILEGES", lecturerCostingDefinitionPrivilages);
		
		outcomebasededucationtabPrivileges = new Ext.util.HashMap();
		outcomebasededucationtabPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_TAB_MANAGE_PROGRAM_OUTCOMES,"MANAGE_PROGRAM_OUTCOMES");
		outcomebasededucationtabPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_TAB_MANAGE_COURSE_OUTCOMES,"MANAGE_COURSE_OUTCOMES");
		outcomebasededucationtabPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_TAB_MAP_COURSE_AND_PROGRAM_OUTCOMES,"MAP_COURSE_AND_PROGRAM_OUTCOMES");
		outcomebasededucationtabPrivileges.add(FPCONSTANTS.PC_M4_F_OUTCOMEBASEDEDUCATION_TAB_IMPORT_BULK,"IMPORT_BULK");
		featurePrivilegesMap.add("OUT_COME_BASED_EDUCATION_TAB_PRIVILEGES", outcomebasededucationtabPrivileges);
		
		examQuestionTempBankRadioPrivileges = new Ext.util.HashMap();
		examQuestionTempBankRadioPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_RADIO_TEMPLATE, "QUESTION_TEMPLATE");
		examQuestionTempBankRadioPrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_RADIO_PAPER_BANK, "QUESTION_PAPER_BANK");
		featurePrivilegesMap.add("EXAM_QUESTION_TEMP_BANK_RADIO_PRIVILEGES", examQuestionTempBankRadioPrivileges);
		
		examQuestionTemplatePrivileges = new Ext.util.HashMap();
		examQuestionTemplatePrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_TEMPLATE_VIEW,"VIEW");
		examQuestionTemplatePrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_TEMPLATE_EXPORT,"EXPORT");
		examQuestionTemplatePrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_TEMPLATE_CREATE,"CREATE");
		examQuestionTemplatePrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_TEMPLATE_UPDATE,"UPDATE");
		examQuestionTemplatePrivileges.add(FPCONSTANTS.PC_M5_F_EXAMINATION_QUESTION_TEMPLATE_DELETE,"DELETE");
		featurePrivilegesMap.add("EXAM_QUESTION_TEMPLATE_LIST_PRIVILEGES", examQuestionTemplatePrivileges);
		
		/****** For Currency Master LIST Button Permission***********/
		currencyMasterListGridButtonPrivileges = new Ext.util.HashMap();
		currencyMasterListGridButtonPrivileges.add(FPCONSTANTS.PC_M12_F_CURRENCYMASTERLISTGRID_CREATE,"CREATE");
		currencyMasterListGridButtonPrivileges.add(FPCONSTANTS.PC_M12_F_CURRENCYMASTERLISTGRID_UPDATE,"UPDATE");
		currencyMasterListGridButtonPrivileges.add(FPCONSTANTS.PC_M12_F_CURRENCYMASTERLISTGRID_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CURRENCY_LIST_GRID_BUTTON_PRIVILEGES", currencyMasterListGridButtonPrivileges);
		
		facultyDetailedSchedulePrivileges = new Ext.util.HashMap();
		facultyDetailedSchedulePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SHEDULE_VIEW, "VIEW");
		facultyDetailedSchedulePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SHEDULE_EXPORT,"EXPORT");
		facultyDetailedSchedulePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SHEDULE_ASSIGNTOPIC,"ASSIGNTOPIC");
		facultyDetailedSchedulePrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_SHEDULE_EXPORT_REPORT,"EXPORT_REPORT");
		featurePrivilegesMap.add("FACULTY_DETAILED_SCHEDULE_PRIVILEGE", facultyDetailedSchedulePrivileges);
		
		facultyImportSessionAndTopicsMappingPrivileges = new Ext.util.HashMap();
		facultyImportSessionAndTopicsMappingPrivileges.add(FPCONSTANTS.FP_M9_F_IMPORT_SESSION_AND_TOPICS_MAPPING_VIEW, "VIEW");
		facultyImportSessionAndTopicsMappingPrivileges.add(FPCONSTANTS.FP_M9_F_IMPORT_SESSION_AND_TOPICS_MAPPING_PROGRAM_BATCH_SECTION, "PROGRAM_BATCH_SECTION");
		facultyImportSessionAndTopicsMappingPrivileges.add(FPCONSTANTS.FP_M9_F_IMPORT_SESSION_AND_TOPICS_MAPPING_COURSE_SECTION, "COURSE_SECTION");
		featurePrivilegesMap.add("FACULTY_IMPORT_SESSION_AND_TOPICS_MAPPING_PRIVILEGES", facultyImportSessionAndTopicsMappingPrivileges);

		
		ManagePaymentsPrivileges = new Ext.util.HashMap();
		ManagePaymentsPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGEPAYMENTS_MAP_ACADEMY_LOCATION, "MAP_ACADEMY_LOCATIONS");
        featurePrivilegesMap.add("MANAGE_PAYMENTS_PRIVILEGES", ManagePaymentsPrivileges);
		
		signUpReportPrivileges = new Ext.util.HashMap();
		signUpReportPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_SIGNUP_REPORT_VIEW, "VIEW");
		signUpReportPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_SIGNUP_REPORT_EXPORT, "EXPORT");
		signUpReportPrivileges.add(FPCONSTANTS.PC_M3_F_ADM_SIGNUP_REPORT_GRID_CONFIG, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("SIGNUP_REPORT_PRIVILEGES", signUpReportPrivileges);
		
		manageProjectedBillingReportPrivileges = new Ext.util.HashMap();
		manageProjectedBillingReportPrivileges.add(FPCONSTANTS.PC_M1_F_PROJECTED_BILLING_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PROJECTED_BILLING_REPORT_PRIVILEGES", manageProjectedBillingReportPrivileges);
		
		manageProjectedDiscountReportPrivileges = new Ext.util.HashMap();
		manageProjectedDiscountReportPrivileges.add(FPCONSTANTS.FP_M10_F_PROJECTED_DISCOUNT_REPORT_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PROJECTED_DISCOUNT_REPORT_PRIVILEGES", manageProjectedDiscountReportPrivileges);
		
		
		ProjectedSponsorReportPrivileges = new Ext.util.HashMap();	
		ProjectedSponsorReportPrivileges.add(FPCONSTANTS.PC_M13_SPONSOR_REPORT_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PROJECTED_SPONSOR_REPORT_PRIVILEGES", ProjectedSponsorReportPrivileges);		

		
		
		manageStudentFeeHeadwiseReportPrivilege = new Ext.util.HashMap();
		manageStudentFeeHeadwiseReportPrivilege.add(FPCONSTANTS.FP_M11_F_STUDENT_FEE_HEAD_WISE_REPORT_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_FEE_HEAD_WISE_REPORT_BUTTON_PRIVILEGES", manageStudentFeeHeadwiseReportPrivilege);
		
		paymentImportTabPrivileges = new Ext.util.HashMap();
		paymentImportTabPrivileges.add(FPCONSTANTS.PC_M6_F_PAYMENT_BULK_IMPORT_UTILITY_VIEW, "IMPORT_BULK_PAYMENTS");
		paymentImportTabPrivileges.add(FPCONSTANTS.PC_M6_F_PAYMENT_BULK_IMPORT_UTILITY_MAP_ACADEMY_LOCATION, "MAP_ACADEMY_LOCATIONS");
		featurePrivilegesMap.add("PAYMENT_BULK_IMPORT_UTILITY_PRIVILEGES", paymentImportTabPrivileges);
		
		studentDetailsPrivilege = new Ext.util.HashMap();
		studentDetailsPrivilege.add(FPCONSTANTS.PC_M2_F_STUDENT_DETAILS_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_DETAILS_PRIVILEGES", studentDetailsPrivilege);
		
		applicationProgramDetailsPrivilege = new Ext.util.HashMap();
		applicationProgramDetailsPrivilege.add(FPCONSTANTS.PC_M3_F_APPLICATION_PROGRAM_DETAILS_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICATION_PROGRAM_DETAILS_PRIVILEGES", applicationProgramDetailsPrivilege);
		
		manageApplicantConsolidatedReportPrivilege = new Ext.util.HashMap();
		manageApplicantConsolidatedReportPrivilege.add(FPCONSTANTS.FP_M11_F_APPLICANT_CONSOLIDATED_REPORT_GRID_CONFIG,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICANT_CONSOLIDATED_REPORT_BUTTON_PRIVILEGES", manageApplicantConsolidatedReportPrivilege);
		
		manageAdvanceFeeReportPrivileges = new Ext.util.HashMap();
		manageAdvanceFeeReportPrivileges.add(FPCONSTANTS.PC_M6_F_ADVANCE_FEE_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("ADVANCE_FEE_REPORT_PRIVILEGES", manageAdvanceFeeReportPrivileges);
		performSettelementRadioButtonPrivileges = new Ext.util.HashMap();
		performSettelementRadioButtonPrivileges.add(FPCONSTANTS.PC_M6_F_SETTLEMENT_WITH_MULTICURRENCY, "SETTLEMENT_WITH_MULTICURRENCY");
		featurePrivilegesMap.add("PERFORM_SETTELEMENT_RADIOBTN_PRIVILEGES", performSettelementRadioButtonPrivileges);
		
		/************** Manage Payment Plan ************/
		
		managePaymentPlanPrivileges = new Ext.util.HashMap();
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_VIEW,"VIEW");
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_EXPORT,"EXPORT");
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_DELETE,"DELETE");
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_CREATE,"CREATE");
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_UPDATE,"UPDATE");
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_MOREACTIONS,"MOREACTION");
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_APPLICABLEFOR,"APPLICABLEFOR");
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_APPROVE,"APPROVE");
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_PAYMENTTERMSETTINGS,"PAYMENT_TERM_SETTINGS");
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_STUDENTENROLLMENT,"STUDENTENROLLMENT");
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_PLAN_ENROLLMENT,"PLAN_ENROLLMENT");
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_ONLINE_PAYMENT_ACCEPT_AT_MOBILE, "ONLINE_PAYMENT_ACCEPT_AT_MOBILE");
		managePaymentPlanPrivileges.add(FPCONSTANTS.FP_M1_F_MANAGEPAYMENTPLAN_STUDENT_PAYMENT_TRANSFER, "STUDENT_PAYMENT_TRANSFER");
		featurePrivilegesMap.add("MANAGE_PAYMENT_PLAN_PRIVILEGES", managePaymentPlanPrivileges);
		
		
		manageDiscountScreenPrivileges = new Ext.util.HashMap();
		manageDiscountScreenPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_DISCOUNT_MANAGE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		manageDiscountScreenPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_DISCOUNT_MANAGE_APPROVE,"APPROVE");
		manageDiscountScreenPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_DISCOUNT_MANAGE_REJECT,"REJECT");
		featurePrivilegesMap.add("MANAGE_DISCOUNT_SCREEN_PRIVILEGES", manageDiscountScreenPrivileges);
		
		discountMasterPrivileges = new Ext.util.HashMap();
		discountMasterPrivileges.add(FPCONSTANTS.PC_M6_F_DISCOUNT_MASTER_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("DISCOUNT_MASTER_PRIVILEGES", discountMasterPrivileges);
		
		//***************For MANAGE PAYMENT For P&C and service provided for Applicant*************************
		managePaymentPCAndServiceProvidedForApplicantPrivileges = new Ext.util.HashMap();
		managePaymentPCAndServiceProvidedForApplicantPrivileges.add(FPCONSTANTS.FP_M4_MANAGE_PAYMENT_PC_SERVICEPROVIDED_FOR_APPLICANT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PAYMENT_PC_SERVICEPROVIDED_FOR_APPLICANT_GRID_PRIVILEGES", managePaymentPCAndServiceProvidedForApplicantPrivileges);
		
		//***************For MANAGE PAYMENT For P&C and service Provided For Student*************************
		managePaymentPCAndServiceProvidedPrivileges = new Ext.util.HashMap();
		managePaymentPCAndServiceProvidedPrivileges.add(FPCONSTANTS.FP_M4_MANAGE_PAYMENT_FOR_PC_AND_SERVICEPROVIDED_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PAYMENT_FOR_PC_AND_SERVICEPROVIDED_GRID_PRIVILEGES", managePaymentPCAndServiceProvidedPrivileges);
		
		//***************For MANAGE PAYMENT For P&C and Service Provided For Sponsor*************************
		managePaymentPCAndServiceProvidedForSponsorPrivileges = new Ext.util.HashMap();
		managePaymentPCAndServiceProvidedForSponsorPrivileges.add(FPCONSTANTS.FP_M4_MANAGE_PAYMENT_PC_SERVICEPROVIDED_FOR_SPONSOR_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PAYMENT_PC_SERVICEPROVIDED_FOR_SPONSOR_GRID_PRIVILEGES", managePaymentPCAndServiceProvidedForSponsorPrivileges);
		
		//***************For MANAGE PAYMENT For Scholarship*************************
		managePaymentScholarshipPrivileges = new Ext.util.HashMap();
		managePaymentScholarshipPrivileges.add(FPCONSTANTS.FP_M4_MANAGE_PAYMENT_FOR_SCHOLARSHIP_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PAYMENT_FOR_SCHOLARSHIP_GRID_PRIVILEGES", managePaymentScholarshipPrivileges);
		
		//***************For MANAGE RECEIPT GRID CONFIGURATION *************************
		manageReceiptGridUserPrivileges = new Ext.util.HashMap();
		manageReceiptGridUserPrivileges.add(FPCONSTANTS.PC_M6_F_RECEIPT_GRID_CONFIGURATION_USER,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_RECEIPT_USESR_GRID_CONFIGURATION", manageReceiptGridUserPrivileges);
		
		manageReceiptGridPrivileges = new Ext.util.HashMap();
		manageReceiptGridPrivileges.add(FPCONSTANTS.PC_M6_F_RECEIPT_GRID_CONFIGURATION_SPONSOR,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_RECEIPT_GRID_CONFIGURATION", manageReceiptGridPrivileges);
		
		manageReceiptStudentGridPrivileges = new Ext.util.HashMap();
		manageReceiptStudentGridPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_RECEIPT_FOR_STUDENT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_RECEIPT_STUDENT_GRID_CONFIGURATION", manageReceiptStudentGridPrivileges);
		
		manageReceiptLoaderInactiveStudentPrivileges = new Ext.util.HashMap();
		manageReceiptLoaderInactiveStudentPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_RECEIPT_FOR_INACTIVE_STUDENT,"INACTIVE_STUDENT");
		featurePrivilegesMap.add("MANAGE_RECEIPT_FOR_INACTIVE_STUDENT", manageReceiptLoaderInactiveStudentPrivileges);
		
		manageReceiptLoaderPrivileges = new Ext.util.HashMap();
		manageReceiptLoaderPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_RECEIPT_LOADER,"DOWNLOAD_WITHOUT_ID_NAME");
		featurePrivilegesMap.add("MANAGE_RECEIPT_LOADER", manageReceiptLoaderPrivileges);
		
		
		manageReceiptApplicantGridPrivileges = new Ext.util.HashMap();
		manageReceiptApplicantGridPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_RECEIPT_FOR_APPICANT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_RECEIPT_APPLICANT_GRID_CONFIGURATION", manageReceiptApplicantGridPrivileges);
		
		manageReceiptScholarshipGridPrivileges = new Ext.util.HashMap();
		manageReceiptScholarshipGridPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_RECEIPT_FOR_SCHOLARSHIP_STUDENT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_RECEIPT_SCHOLARSHIP_GRID_CONFIGURATION", manageReceiptScholarshipGridPrivileges);
		
		manageOfflinePaymentPrivileges = new Ext.util.HashMap();
		manageOfflinePaymentPrivileges.add(FPCONSTANTS.FP_M4_MANAGE_OFFLINE_PAYMENT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_OFFLINES_PAYMENT_GRID_CONFIGURATION", manageOfflinePaymentPrivileges);

		
		/****** For Sibling Discount in Add Discount Entry ***********/
		addDiscountStudentSibilingGridPrivileges = new Ext.util.HashMap();
		addDiscountStudentSibilingGridPrivileges.add(FPCONSTANTS.FP_M4_ADD_DISCOUNT_STUDENT_SIBLING_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("ADD_DISCOUNT_STUDENT_SIBLING_GRID_PRIVILEGES", addDiscountStudentSibilingGridPrivileges);
		
		/****** For Parent/guardian List in Add Discount Entry ***********/
		addDiscountStudentParentGridPrivileges = new Ext.util.HashMap();
		addDiscountStudentParentGridPrivileges.add(FPCONSTANTS.FP_M4_ADD_DISCOUNT_STUDENT_PARENT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("ADD_DISCOUNT_STUDENT_PARENT_GRID_PRIVILEGES", addDiscountStudentParentGridPrivileges);
		
		/****** For Manage payment User Service Provided ***********/
		managePaymentServiceProvidedGridPrivileges = new Ext.util.HashMap();
		managePaymentServiceProvidedGridPrivileges.add(FPCONSTANTS.FP_M4_MANAGE_PAYMENT_SERVICE_PROVIDED_USER_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PAYMENT_SERVICE_PROVIDED_USER_GRID_PRIVILEGES", managePaymentServiceProvidedGridPrivileges);
		
		/****** For Manage payment User Service Received ***********/
		managePaymentServiceReceivedGridPrivileges = new Ext.util.HashMap();
		managePaymentServiceReceivedGridPrivileges.add(FPCONSTANTS.FP_M4_MANAGE_PAYMENT_SERVICE_RECEIVED_USER_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PAYMENT_SERVICE_RECEIVED_USER_GRID_PRIVILEGES", managePaymentServiceReceivedGridPrivileges);
		
		/****** For Sibling Discount in Add Discount Entry ***********/
		addDiscountStudentSibilingGridPrivileges = new Ext.util.HashMap();
		addDiscountStudentSibilingGridPrivileges.add(FPCONSTANTS.FP_M4_ADD_DISCOUNT_STUDENT_SIBLING_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("ADD_DISCOUNT_STUDENT_SIBLING_GRID_PRIVILEGES", addDiscountStudentSibilingGridPrivileges);
		
		/****** For Parent/guardian List in Add Discount Entry ***********/
		addDiscountStudentParentGridPrivileges = new Ext.util.HashMap();
		addDiscountStudentParentGridPrivileges.add(FPCONSTANTS.FP_M4_ADD_DISCOUNT_STUDENT_PARENT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("ADD_DISCOUNT_STUDENT_PARENT_GRID_PRIVILEGES", addDiscountStudentParentGridPrivileges);
		
		/*manageDiscountScreenPrivileges = new Ext.util.HashMap();
		manageDiscountScreenPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_DISCOUNT_MANAGE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_DISCOUNT_SCREEN_PRIVILEGES", manageDiscountScreenPrivileges); duplicate code*/
		
		/****** For Manage payment User Service Provided ***********/
		managePaymentServiceProvidedGridPrivileges = new Ext.util.HashMap();
		managePaymentServiceProvidedGridPrivileges.add(FPCONSTANTS.FP_M4_MANAGE_PAYMENT_SERVICE_PROVIDED_USER_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PAYMENT_SERVICE_PROVIDED_USER_GRID_PRIVILEGES", managePaymentServiceProvidedGridPrivileges);
		
		/****** For Manage payment User Service Received ***********/
		managePaymentServiceReceivedGridPrivileges = new Ext.util.HashMap();
		managePaymentServiceReceivedGridPrivileges.add(FPCONSTANTS.FP_M4_MANAGE_PAYMENT_SERVICE_RECEIVED_USER_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PAYMENT_SERVICE_RECEIVED_USER_GRID_PRIVILEGES", managePaymentServiceReceivedGridPrivileges);
		
		discountMasterPrivileges = new Ext.util.HashMap();
		discountMasterPrivileges.add(FPCONSTANTS.PC_M6_F_DISCOUNT_MASTER_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("DISCOUNT_MASTER_PRIVILEGES", discountMasterPrivileges);
		
		//***************For MANAGE PAYMENT For P&C and service provided for Applicant*************************
		managePaymentPCAndServiceProvidedForApplicantPrivileges = new Ext.util.HashMap();
		managePaymentPCAndServiceProvidedForApplicantPrivileges.add(FPCONSTANTS.FP_M4_MANAGE_PAYMENT_PC_SERVICEPROVIDED_FOR_APPLICANT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PAYMENT_PC_SERVICEPROVIDED_FOR_APPLICANT_GRID_PRIVILEGES", managePaymentPCAndServiceProvidedForApplicantPrivileges);
		
		//***************For MANAGE PAYMENT For P&C and service Provided For Student*************************
		managePaymentPCAndServiceProvidedPrivileges = new Ext.util.HashMap();
		managePaymentPCAndServiceProvidedPrivileges.add(FPCONSTANTS.FP_M4_MANAGE_PAYMENT_FOR_PC_AND_SERVICEPROVIDED_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PAYMENT_FOR_PC_AND_SERVICEPROVIDED_GRID_PRIVILEGES", managePaymentPCAndServiceProvidedPrivileges);
		
		//***************For MANAGE PAYMENT For P&C and Service Provided For Sponsor*************************
		managePaymentPCAndServiceProvidedForSponsorPrivileges = new Ext.util.HashMap();
		managePaymentPCAndServiceProvidedForSponsorPrivileges.add(FPCONSTANTS.FP_M4_MANAGE_PAYMENT_PC_SERVICEPROVIDED_FOR_SPONSOR_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PAYMENT_PC_SERVICEPROVIDED_FOR_SPONSOR_GRID_PRIVILEGES", managePaymentPCAndServiceProvidedForSponsorPrivileges);
		
		//***************For MANAGE PAYMENT For Scholarship*************************
		managePaymentScholarshipPrivileges = new Ext.util.HashMap();
		managePaymentScholarshipPrivileges.add(FPCONSTANTS.FP_M4_MANAGE_PAYMENT_FOR_SCHOLARSHIP_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_PAYMENT_FOR_SCHOLARSHIP_GRID_PRIVILEGES", managePaymentScholarshipPrivileges);
		
		//***************For MANAGE RECEIPT GRID CONFIGURATION *************************
		manageReceiptGridUserPrivileges = new Ext.util.HashMap();
		manageReceiptGridUserPrivileges.add(FPCONSTANTS.PC_M6_F_RECEIPT_GRID_CONFIGURATION_USER,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_RECEIPT_USESR_GRID_CONFIGURATION", manageReceiptGridUserPrivileges);
		
		manageReceiptGridPrivileges = new Ext.util.HashMap();
		manageReceiptGridPrivileges.add(FPCONSTANTS.PC_M6_F_RECEIPT_GRID_CONFIGURATION_SPONSOR,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_RECEIPT_GRID_CONFIGURATION", manageReceiptGridPrivileges);
		
		manageReceiptStudentGridPrivileges = new Ext.util.HashMap();
		manageReceiptStudentGridPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_RECEIPT_FOR_STUDENT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_RECEIPT_STUDENT_GRID_CONFIGURATION", manageReceiptStudentGridPrivileges);
		
		manageReceiptApplicantGridPrivileges = new Ext.util.HashMap();
		manageReceiptApplicantGridPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_RECEIPT_FOR_APPICANT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_RECEIPT_APPLICANT_GRID_CONFIGURATION", manageReceiptApplicantGridPrivileges);
		
		manageReceiptScholarshipGridPrivileges = new Ext.util.HashMap();
		manageReceiptScholarshipGridPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_RECEIPT_FOR_SCHOLARSHIP_STUDENT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("MANAGE_RECEIPT_SCHOLARSHIP_GRID_CONFIGURATION", manageReceiptScholarshipGridPrivileges);
		
		studentMyCourseLearningTargetTabPrivileges = new Ext.util.HashMap();
		studentMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.PC_M7_F_STUDENT_MYCOURSE_LEARNING_TAB, "LEARNING_TARGETS");
		featurePrivilegesMap.add("STUDENT_MYCOURSE_LEARNING_TAB_PRIVILEGES", studentMyCourseLearningTargetTabPrivileges);
		
		
		studentMyCourseLearningTargetTabPrivileges = new Ext.util.HashMap();
		studentMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.PC_M7_F_STUDENT_MYCOURSE_LEARNING_TAB, "LEARNING_TARGETS");
		studentMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.PC_M7_F_STUDENT_MYCOURSE_PRINT_LEARNING_PLAN, "PRINT_LEARNING_PLAN");
		studentMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.PC_M7_F_STUDENT_MYCOURSE_LEARNING_EXPORT, "EXPORT");
		studentMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.PC_M7_F_STUDENT_MYCOURSE_LEARNING_SAVE, "SAVE");
		featurePrivilegesMap.add("STUDENT_MYCOURSE_LEARNING_PRIVILEGES", studentMyCourseLearningTargetTabPrivileges);
		
		facultyPortalMyCourseLearningTargetTabPrivileges = new Ext.util.HashMap();
		facultyPortalMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.FP_M14_F_COURSE_LEARNING_TAB_LEARNING_TAB, "LEARNING_TARGETS");
		facultyPortalMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.FP_M14_F_COURSE_LEARNING_TAB_LEARNING_PLAN, "PRINT_LEARNING_PLAN");
		facultyPortalMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.FP_M14_F_COURSE_LEARNING_TAB_LEARNING_EXPORT, "EXPORT");
		facultyPortalMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.FP_M14_F_COURSE_LEARNING_TAB_LEARNING_SAVE, "SAVE");
		featurePrivilegesMap.add("FACULTY_MYCOURSE_LEARNING_PRIVILEGES", facultyPortalMyCourseLearningTargetTabPrivileges);
		
		studentPortalMyCourseLearningTargetTabPrivileges = new Ext.util.HashMap();
		studentPortalMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_LEARNING_TAB_LEARNING_PLAN, "PRINT_LEARNING_PLAN");
		studentPortalMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_LEARNING_TAB_EXPORT, "EXPORT");
		studentPortalMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.SP_M4_F_COURSE_LEARNING_TAB_SAVE, "SAVE");
		featurePrivilegesMap.add("STUDENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES", studentPortalMyCourseLearningTargetTabPrivileges);
		
		parentPortalMyCourseLearningTargetTabPrivileges = new Ext.util.HashMap();
		parentPortalMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.PP_M4_F_COURSE_LEARNING_TAB_LEARNING_PLAN, "PRINT_LEARNING_PLAN");
		parentPortalMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.PP_M4_F_COURSE_LEARNING_EXPORT, "EXPORT");
		parentPortalMyCourseLearningTargetTabPrivileges.add(FPCONSTANTS.PP_M4_F_COURSE_LEARNING_SAVE, "SAVE");
		featurePrivilegesMap.add("PARENT_PORTAL_MYCOURSE_LEARNING_PRIVILEGES", parentPortalMyCourseLearningTargetTabPrivileges);
		
		studentPaymentPlanPrivileges = new Ext.util.HashMap();
		studentPaymentPlanPrivileges.add(FPCONSTANTS.SP_M11_PAYMENT_PLAN_VIEW,"VIEW");
		studentPaymentPlanPrivileges.add(FPCONSTANTS.SP_M11_PAYMENT_PLAN_MAKE_PAYMEMT,"MAKE_PAYMEMT");
		studentPaymentPlanPrivileges.add(FPCONSTANTS.SP_M11_PAYMENT_PLAN_PRINT_VOUCHER,"PRINT_VOUCHER");
		featurePrivilegesMap.add("STUDENT_PAYMENT_PLAN_VIEW", studentPaymentPlanPrivileges);
		
		/** For Applicant Socio Economic Detail */
		
		applicationSocioEconomicInfoPrivileges = new Ext.util.HashMap();
		applicationSocioEconomicInfoPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_SOCIO_ECONOMIC_INFORMATION_VIEW,"VIEW");
		applicationSocioEconomicInfoPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_SOCIO_ECONOMIC_INFORMATION_SAVE,"SAVE");
		featurePrivilegesMap.add("APPLICANT_SOCIO_ECONOMIC_INFORMATION_PRIVILEGES", applicationSocioEconomicInfoPrivileges);
		
		/** For Student Socio Economic Detail */
		studentSocioEconomicInfoPrivileges = new Ext.util.HashMap();
		studentSocioEconomicInfoPrivileges.add(FPCONSTANTS.PC_M3_F_STUDENT_SOCIO_ECONOMIC_INFORMATION_VIEW,"VIEW");
		studentSocioEconomicInfoPrivileges.add(FPCONSTANTS.PC_M3_F_STUDENT_SOCIO_ECONOMIC_INFORMATION_SAVE,"SAVE");
		featurePrivilegesMap.add("STUDENT_SOCIO_ECONOMIC_INFORMATION_PRIVILEGES", studentSocioEconomicInfoPrivileges);
		
		/** For Student Socio Economic Detail For Student Portal */
		studentSocioEconomicStudentPortalInfoPrivileges = new Ext.util.HashMap();
		studentSocioEconomicStudentPortalInfoPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PORTAL_SOCIO_ECONOMIC_INFORMATION_VIEW,"VIEW");
		studentSocioEconomicStudentPortalInfoPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_PORTAL_SOCIO_ECONOMIC_INFORMATION_SAVE,"SAVE");
		featurePrivilegesMap.add("STUDENT_PORTAL_SOCIO_ECONOMIC_INFORMATION_PRIVILEGES", studentSocioEconomicStudentPortalInfoPrivileges);
		
		ObeProgramAndCoursePrivileges = new Ext.util.HashMap();
		ObeProgramAndCoursePrivileges.add(FPCONSTANTS.PC_M5_F_OBE_PROGRAM_AND_COURSE_OUTCOMES_VIEW,"VIEW");
		ObeProgramAndCoursePrivileges.add(FPCONSTANTS.PC_M5_F_OBE_PROGRAM_AND_COURSE_OUTCOMES_EXPORT,"EXPORT");
		ObeProgramAndCoursePrivileges.add(FPCONSTANTS.PC_M5_F_OBE_PROGRAM_AND_COURSE_OUTCOMES_INDIRECT_ATTAINMENT_SAVE,"SAVE");
		ObeProgramAndCoursePrivileges.add(FPCONSTANTS.PC_M5_F_OBE_PROGRAM_AND_COURSE_OUTCOMES_MANAGE_INDIRECT_ATTAINMENT,"MANAGE_INDIRECT_ATTAINMENT");
		featurePrivilegesMap.add("OBE_PROGRAM_AND_COURSE_PRIVILEGES", ObeProgramAndCoursePrivileges);
		
		applicantportalcontactdetailPrivileges = new Ext.util.HashMap();
		applicantportalcontactdetailPrivileges.add(FPCONSTANTS.AC_M3_APPLICANT_PORTAL_CONTACT_PRIVILEGES_CURRENT_ADDRESS,"CURRENT_ADDRESS");
		applicantportalcontactdetailPrivileges.add(FPCONSTANTS.AC_M3_APPLICANT_PORTAL_CONTACT_PRIVILEGES_ADDRESS_FOR_CORRESPONDANCE,"ADDRESS_FOR_CORRESPONDANCE");
		applicantportalcontactdetailPrivileges.add(FPCONSTANTS.AC_M3_APPLICANT_PORTAL_CONTACT_PRIVILEGES_PERMANENT_ADDRESS,"PERMANENT_ADDRESS");
		applicantportalcontactdetailPrivileges.add(FPCONSTANTS.AC_M3_APPLICANT_PORTAL_CONTACT_PRIVILEGES_OFFICE_ADDRESS,"OFFICE_ADDRESS");
		applicantportalcontactdetailPrivileges.add(FPCONSTANTS.AC_M3_APPLICANT_PORTAL_CONTACT_PRIVILEGES_ADD_ADDRESS,"ADD_ADDRESS");
		applicantportalcontactdetailPrivileges.add(FPCONSTANTS.AC_M3_APPLICANT_PORTAL_CONTACT_PRIVILEGES_MODIFY,"MODIFY");
		applicantportalcontactdetailPrivileges.add(FPCONSTANTS.AC_M3_APPLICANT_PORTAL_CONTACT_PRIVILEGES_PRINT,"PRINT");
		featurePrivilegesMap.add("APPLICANT_PORTAL_CONTACTDETAILS_ADDRESS_PRIVILEGES", applicantportalcontactdetailPrivileges);

		studentProfileOnlinePaymentTabPrivileges = new Ext.util.HashMap();
		studentProfileOnlinePaymentTabPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ONLINEPAYMENT_TAB_BILLDETAILS, "BILLDETAILS");
		studentProfileOnlinePaymentTabPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_ONLINEPAYMENT_TAB_FEEHEADDETAILS,"FEEHEADDETAILS");
		featurePrivilegesMap.add("STUDENT_ONLINEPAYMENT_TAB_PRIVILEGES", studentProfileOnlinePaymentTabPrivileges);
		manageAccountControlAccountPrivileges = new Ext.util.HashMap();	
		manageAccountControlAccountPrivileges.add(FPCONSTANTS.PC_M6_CONTROL_ACCOUNT_GC_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("CONTROL_ACCOUNT_GRID_CONFIGURATION", manageAccountControlAccountPrivileges);
		
		manageConfigureMappingPrivileges = new Ext.util.HashMap();	
		manageConfigureMappingPrivileges.add(FPCONSTANTS.PC_M6_ACCOUNTING_MAPPING_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("CONFIGURATION_MAPPING_GRID_CONFIGURATION", manageAccountControlAccountPrivileges);
		
		manageFeeRequestMappingPrivileges = new Ext.util.HashMap();	
		manageFeeRequestMappingPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REQUEST_GRID,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FEE_REQUEST_GRID_CONFIGURATION", manageFeeRequestMappingPrivileges);
		
		/****** For Student Fees Registration report***********/
		studentFeesRegistrationReportPrivileges = new Ext.util.HashMap();
		studentFeesRegistrationReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTFEESREGISTRATIONREPORT_VIEW,"VIEW");
		studentFeesRegistrationReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTFEESREGISTRATIONREPORT_EXPORT,"EXPORT");
		studentFeesRegistrationReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTFEESREGISTRATIONREPORT_EXPORT_REPORT,"EXPORTREPORTS");
		studentFeesRegistrationReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTFEESREGISTRATIONREPORT_SENDMESSAGE, "SENDMESSAGE");
		studentFeesRegistrationReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTFEESREGISTRATIONREPORT_START_REGISTRATION, "START_REGISTRATION");
		featurePrivilegesMap.add("STUDENT_FEESREGISTRATIONREPORT_PRIVILEGES", studentFeesRegistrationReportPrivileges);
		
        examStudentAverageReportPrivileges = new Ext.util.HashMap();
		examStudentAverageReportPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_AVERAGE_REPORT_VIEW,"VIEW");
		examStudentAverageReportPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_AVERAGE_REPORT_EXPORT_REPORT,"EXPORT_REPORT");
		examStudentAverageReportPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_AVERAGE_REPORT_EXPORT,"EXPORT");
		examStudentAverageReportPrivileges.add(FPCONSTANTS.PC_M5_F_STUDENT_AVERAGE_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("EXAM_STUDENT_AVERAGE_REPORT_PRIVILEGES", examStudentAverageReportPrivileges);
		
		
		studentBillsOnlinePaymentsPrivileges = new Ext.util.HashMap();
		studentBillsOnlinePaymentsPrivileges.add(FPCONSTANTS.PS_M11_STUDENT_BILLS_ONLINEPAYMENTS_MAKE_PAYMENT,"MAKE_PAYMENT");
		studentBillsOnlinePaymentsPrivileges.add(FPCONSTANTS.PS_M11_STUDENT_BILLS_ONLINEPAYMENTS_MAKE_PAYMENT_VIA_PAYTM,"MAKE_PAYMENT_VIA_PAYTM");
		
		featurePrivilegesMap.add("STUDENT_BILLS_ONLINE_PAYMENTS_PRIVILEGES", studentBillsOnlinePaymentsPrivileges);
		
		studentManageBillsOnlinePaymentsTabPrivileges = new Ext.util.HashMap();
		studentManageBillsOnlinePaymentsTabPrivileges.add(FPCONSTANTS.PC_M6_STUDENT_MANAGEBILLS_ONLINEPAYMENTS_TAB_BILLDETAILS,"BILLDETAILS");
		studentManageBillsOnlinePaymentsTabPrivileges.add(FPCONSTANTS.PC_M6_STUDENT_MANAGEBILLS_ONLINEPAYMENTS_TAB_FEEHEADDETAILS,"FEEHEADDETAILS");
		featurePrivilegesMap.add("STUDENT_MANAGEBILL_ONLINEPAYMENT_TAB_PRIVILEGES", studentManageBillsOnlinePaymentsTabPrivileges);
		
		studentManageBillsOnlinePaymentsPrivileges = new Ext.util.HashMap();
		studentManageBillsOnlinePaymentsPrivileges.add(FPCONSTANTS.PC_M6_STUDENT_MANAGEBILLS_ONLINEPAYMENTS_MAKE_PAYMENT,"MAKE_PAYMENT");
		studentManageBillsOnlinePaymentsPrivileges.add(FPCONSTANTS.PC_M6_STUDENT_MANAGEBILLS_ONLINEPAYMENTS_MAKE_PAYMENT_VIA_PAYTM,"MAKE_PAYMENT_VIA_PAYTM");
		featurePrivilegesMap.add("STUDENT_MANAGEBILLS_ONLINE_PAYMENTS_PRIVILEGES", studentManageBillsOnlinePaymentsPrivileges);
				/** For Application Owner Setup ERP**/
		applicationOwnerSetupPrivileges = new Ext.util.HashMap();
		applicationOwnerSetupPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATION_OWNER_SETUP_UPDATE,"EDIT");
		applicationOwnerSetupPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATION_OWNER_SETUP_DELETE,"DELETE");
		applicationOwnerSetupPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATION_OWNER_SETUP_CREATE,"CREATE");
		featurePrivilegesMap.add("APPLICANT_OWNER_SETUP_PRIVILEGES", applicationOwnerSetupPrivileges);
		
		accountConfigurationMappingPrivileges = new Ext.util.HashMap();	
		accountConfigurationMappingPrivileges.add(FPCONSTANTS.PC_M6_ACCOUNTING_GC,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("ACCOUNT_CONFIGURATION_GRID_CONFIGURATION", accountConfigurationMappingPrivileges);
		
		/****** For Application Post School Studies***********/
		applicationPostSchoolStudeisPrivileges = new Ext.util.HashMap();
		applicationPostSchoolStudeisPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_POST_SCHOOL_STUDIES_VIEW,"VIEW");
		applicationPostSchoolStudeisPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_POST_SCHOOL_STUDIES_CREATE,"CREATE");
		applicationPostSchoolStudeisPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_POST_SCHOOL_STUDIES_UPDATE,"UPDATE");
		applicationPostSchoolStudeisPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_POST_SCHOOL_STUDIES_DELETE,"DELETE");
		applicationPostSchoolStudeisPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICANT_POST_SCHOOL_STUDIES_EXPORT,"EXPORT");
		featurePrivilegesMap.add("APPLICANT_POST_SCHOOL_STUDIES_PRIVILEGES", applicationPostSchoolStudeisPrivileges);
		
		/****** For Student Post School Studies***********/
		studentPostSchoolStudeisPrivileges = new Ext.util.HashMap();
		studentPostSchoolStudeisPrivileges.add(FPCONSTANTS.PC_M3_F_STUDENT_POST_SCHOOL_STUDIES_VIEW,"VIEW");
		studentPostSchoolStudeisPrivileges.add(FPCONSTANTS.PC_M3_F_STUDENT_POST_SCHOOL_STUDIES_CREATE,"CREATE");
		studentPostSchoolStudeisPrivileges.add(FPCONSTANTS.PC_M3_F_STUDENT_POST_SCHOOL_STUDIES_UPDATE,"UPDATE");
		studentPostSchoolStudeisPrivileges.add(FPCONSTANTS.PC_M3_F_STUDENT_POST_SCHOOL_STUDIES_DELETE,"DELETE");
		studentPostSchoolStudeisPrivileges.add(FPCONSTANTS.PC_M3_F_STUDENTT_POST_SCHOOL_STUDIES_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_POST_SCHOOL_STUDIES_PRIVILEGES", studentPostSchoolStudeisPrivileges);
		
		/****** For Student Portal Post School Studies***********/
		studentPortalPostSchoolStudeisPrivileges = new Ext.util.HashMap();
		studentPortalPostSchoolStudeisPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_POST_SCHOOL_STUDIES_VIEW,"VIEW");
		studentPortalPostSchoolStudeisPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_POST_SCHOOL_STUDIES_CREATE,"CREATE");
		studentPortalPostSchoolStudeisPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_POST_SCHOOL_STUDIES_UPDATE,"UPDATE");
		studentPortalPostSchoolStudeisPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_POST_SCHOOL_STUDIES_DELETE,"DELETE");
		studentPortalPostSchoolStudeisPrivileges.add(FPCONSTANTS.SP_M9_F_STUDENT_POST_SCHOOL_STUDIES_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_POST_SCHOOL_STUDIES_PRIVILEGES", studentPortalPostSchoolStudeisPrivileges);
		
		//******************************Enquiry Report Dashboard***************************************************
		enquiryDashboardReportFSPrivileges = new Ext.util.HashMap();
		enquiryDashboardReportFSPrivileges.add(FPCONSTANTS.PC_M6_F_ENQ_DASHBOARD_REPORT_FOLLOWUP_SCHEDULED_VIEW,"VIEW");
		featurePrivilegesMap.add("ENQUIRY_DASHBOARD_FOLLOWUP_SCHEDULED_PRIVILEGES", enquiryDashboardReportFSPrivileges);
        //******************************End*********************************************************************
		
		//******************************Enquiry Report Dashboard***************************************************
		enquiryDashboardReportRPQPrivileges = new Ext.util.HashMap();
		enquiryDashboardReportRPQPrivileges.add(FPCONSTANTS.PC_M6_F_ENQ_DASHBOARD_REPORT_PENDING_ENQ_VIEW,"VIEW");
		featurePrivilegesMap.add("ENQUIRY_DASHBOARD_REPORT_PENDING_ENQ_PRIVILEGES", enquiryDashboardReportRPQPrivileges);
        //******************************End*********************************************************************
		
		//******************************Enquiry Report Dashboard***************************************************
		enquiryDashboardReportRCOEPrivileges = new Ext.util.HashMap();
		enquiryDashboardReportRCOEPrivileges.add(FPCONSTANTS.PC_M6_F_ENQ_DASHBOARD_REPORT_COUNT_OF_ENQ_VIEW,"VIEW");
		featurePrivilegesMap.add("ENQUIRY_DASHBOARD_REPORT_COUNT_OF_ENQ_PRIVILEGES", enquiryDashboardReportRCOEPrivileges);
        //******************************End*********************************************************************
		
		//******************************Enquiry Report Dashboard***************************************************
		enquiryDashboardReportRECRPrivileges = new Ext.util.HashMap();
		enquiryDashboardReportRECRPrivileges.add(FPCONSTANTS.PC_M6_F_ENQ_DASHBOARD_REPORT_ENQ_CLOSURE_RATE_VIEW,"VIEW");
		featurePrivilegesMap.add("ENQUIRY_DASHBOARD_REPORT_ENQ_CLOSURE_RATE_PRIVILEGES", enquiryDashboardReportRECRPrivileges);
        //******************************End*********************************************************************
		
		//******************************Enquiry Report Dashboard***************************************************
		enquiryDashboardReportRCRPrivileges = new Ext.util.HashMap();
		enquiryDashboardReportRCRPrivileges.add(FPCONSTANTS.PC_M6_F_ENQ_DASHBOARD_REPORT_CLOSURE_REASON_VIEW,"VIEW");
		featurePrivilegesMap.add("ENQUIRY_DASHBOARD_REPORT_CLOSURE_REASON_PRIVILEGES", enquiryDashboardReportRCRPrivileges);
        //******************************End*********************************************************************
		
		//******************************Enquiry Report Dashboard***************************************************
		enquiryDashboardReportRESPrivileges = new Ext.util.HashMap();
		enquiryDashboardReportRESPrivileges.add(FPCONSTANTS.PC_M6_F_ENQ_DASHBOARD_REPORT_ENQUIRY_SUMMARY_VIEW,"VIEW");
		featurePrivilegesMap.add("ENQUIRY_DASHBOARD_REPORT_ENQUIRY_SUMMARY_PRIVILEGES", enquiryDashboardReportRESPrivileges);
		
		
		courseFeeDefinitionPrivilege = new Ext.util.HashMap();
		courseFeeDefinitionPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_FEE_DEFINITION,"VIEW");
				courseFeeDefinitionPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_FEE_DEFINITION_CREATE,"CREATE");
		courseFeeDefinitionPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_FEE_DEFINITION_EDIT,"EDIT");
		courseFeeDefinitionPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_FEE_DEFINITION_DELETE,"DELETE");
		courseFeeDefinitionPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_FEE_DEFINITION_EXPORT,"EXPORT");
		courseFeeDefinitionPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_FEE_DEFINITION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		courseFeeDefinitionPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_FEE_DEFINITION_IMPORT_COURSE_FEE_DEFINITION,"IMPORT_COURSE_FEE_DEFINITION");
		featurePrivilegesMap.add("COURSE_FEE_DEFINITION_PRIVILEGES", courseFeeDefinitionPrivilege);
		
		courseFeeHeadConfigurationPrivilege = new Ext.util.HashMap();
		courseFeeHeadConfigurationPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_FEE_HEAD_CONFIGURATION_ADD,"ADD");
		courseFeeHeadConfigurationPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_FEE_HEAD_CONFIGURATION_DELETE,"DELETE");
		courseFeeHeadConfigurationPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_FEE_HEAD_CONFIGURATION_SAVE,"SAVE");
		courseFeeHeadConfigurationPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_FEE_HEAD_CONFIGURATION_RESET,"RESET");
		featurePrivilegesMap.add("COURSE_FEE_HEAD_CONFIGURATION_PRIVILEGES", courseFeeHeadConfigurationPrivilege);
		
		courseRepetitionConfigurationPrivilege = new Ext.util.HashMap();
		courseRepetitionConfigurationPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_REPETITION_CONFIGURATION_CREATE,"CREATE");
		courseRepetitionConfigurationPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_REPETITION_CONFIGURATION_EDIT,"EDIT");
		courseRepetitionConfigurationPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_REPETITION_CONFIGURATION_DELETE,"DELETE");
		courseRepetitionConfigurationPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_COURSE_REPETITION_CONFIGURATION_FOR_ALL_ENROLLMENTS,"FOR_ALL_ENROLLMENTS");
		featurePrivilegesMap.add("COURSE_REPETITION_CONFIGURATION_PRIVILEGES", courseRepetitionConfigurationPrivilege);
      
        //******************************End*********************************************************************
		
		//******************************Student Fee Payer Report ***************************************************
		studentFeePayerReportPrivileges = new Ext.util.HashMap();
		studentFeePayerReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSFEEPAYEREPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		studentFeePayerReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSFEEPAYEREPORT_SENDMESSAGE,"SENDMESSAGE");
		studentFeePayerReportPrivileges.add(FPCONSTANTS.PS_M9_R_STUDENTSFEEPAYEREPORT_VALIDATION_STATUS,"VALIDATION_STATUS");
		featurePrivilegesMap.add("STUDENT_FEE_PAYER_REPORT_PRIVILEGES", studentFeePayerReportPrivileges);
        //******************************End*********************************************************************
		
		examCancellationPrivilegesApplyTo = new Ext.util.HashMap();
		examCancellationPrivilegesApplyTo.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION_APPLY_TO_CREATE,"CREATE");
		examCancellationPrivilegesApplyTo.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION_APPLY_TO_VIEW,"VIEW");
		examCancellationPrivilegesApplyTo.add(FPCONSTANTS.PC_M5_F_EXAM_CANCELLATION_APPLY_TO_DELETE,"DELETE");
		featurePrivilegesMap.add("EXAM_CANCELLATION_PRIVILEGES_APPLY_TO", examCancellationPrivilegesApplyTo);
		
		
		creditFeeMappingPrivilege = new Ext.util.HashMap();
		creditFeeMappingPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_VIEW,"VIEW");
		creditFeeMappingPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		creditFeeMappingPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_SET_DEFAULT_AMOUNT,"SET_DEFAULT_AMOUNT");
		creditFeeMappingPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_SAVE,"SAVE");
		creditFeeMappingPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_RESET,"RESET");
		featurePrivilegesMap.add("CREDIT_FEE_MAPPING_PRIVILEGE", creditFeeMappingPrivilege);
		
		creditFeeMappingRegTabPrivilege = new Ext.util.HashMap();
		creditFeeMappingRegTabPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_REGULARCOURSE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		creditFeeMappingRegTabPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_REGULARCOURSE_SET_DEFAULT_AMOUNT,"SET_DEFAULT_AMOUNT");
		creditFeeMappingRegTabPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_REGULARCOURSE_SAVE,"SAVE");
		creditFeeMappingRegTabPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_REGULARCOURSE_RESET,"RESET");
		featurePrivilegesMap.add("CREDIT_FEE_MAPPING_REG_TAB_PRIVILEGE", creditFeeMappingRegTabPrivilege);
		
		creditFeeMappingRepeatTabPrivilege = new Ext.util.HashMap();
		creditFeeMappingRepeatTabPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_REPEATCOURSE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		creditFeeMappingRepeatTabPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_REPEATCOURSE_SET_DEFAULT_AMOUNT,"SET_DEFAULT_AMOUNT");
		creditFeeMappingRepeatTabPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_REPEATCOURSE_SAVE,"SAVE");
		creditFeeMappingRepeatTabPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_REPEATCOURSE_RESET,"RESET");
		featurePrivilegesMap.add("CREDIT_FEE_MAPPING_REPEAT_TAB_PRIVILEGE", creditFeeMappingRepeatTabPrivilege);
		
		studentMarkRemarkEntryPrivilege = new Ext.util.HashMap();	
		studentMarkRemarkEntryPrivilege.add(FPCONSTANTS.PC_M5_F_STUDENT_MARK_REMARK_ENTRY_VIEW,"VIEW");
		studentMarkRemarkEntryPrivilege.add(FPCONSTANTS.PC_M5_F_STUDENT_MARK_REMARK_ENTRY_SAVE,"SAVE");
		studentMarkRemarkEntryPrivilege.add(FPCONSTANTS.PC_M5_F_STUDENT_MARK_REMARK_ENTRY_DELETE_MARKS_GRADE,"DELETE_MARKS_GRADE");
		studentMarkRemarkEntryPrivilege.add(FPCONSTANTS.PC_M5_F_STUDENT_MARK_REMARK_ENTRY_PUBLISH_MARKS_GRADE,"PUBLISH_MARKS_GRADE");
		studentMarkRemarkEntryPrivilege.add(FPCONSTANTS.PC_M5_F_STUDENT_MARK_REMARK_ENTRY_CHECK_HISTORY,"CHECK_HISTORY");
		studentMarkRemarkEntryPrivilege.add(FPCONSTANTS.PC_M5_F_STUDENT_MARK_REMARK_ENTRY_CREATE,"CREATE");
		studentMarkRemarkEntryPrivilege.add(FPCONSTANTS.PC_M5_F_STUDENT_MARK_REMARK_ENTRY_EDIT,"EDIT");
		studentMarkRemarkEntryPrivilege.add(FPCONSTANTS.PC_M5_F_STUDENT_MARK_REMARK_ENTRY_DELETE,"DELETE");
		studentMarkRemarkEntryPrivilege.add(FPCONSTANTS.PC_M5_F_STUDENT_MARK_REMARK_ENTRY_UNPUBLISH_MARKS_GRADE,"UNPUBLISH_MARKS_GRADE");
		featurePrivilegesMap.add("STUDENT_MARK_REMARK_ENTRY_PRIVILEGES", studentMarkRemarkEntryPrivilege);
		
		/*creditFeeMappingPrivilege = new Ext.util.HashMap();
		creditFeeMappingPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_VIEW,"VIEW");
		creditFeeMappingPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		creditFeeMappingPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_SET_DEFAULT_AMOUNT,"SET_DEFAULT_AMOUNT");
		creditFeeMappingPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_SAVE,"SAVE");
		creditFeeMappingPrivilege.add(FPCONSTANTS.PC_M6_F_FEES_ACADEMICTERM_CREDITFEEMAPPING_RESET,"RESET");
		featurePrivilegesMap.add("CREDIT_FEE_MAPPING_PRIVILEGE", creditFeeMappingPrivilege);*/
		
		//******************************payment plan Report ***************************************************
		feeReportPaymentPlanPrivileges = new Ext.util.HashMap();
		feeReportPaymentPlanPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_PAYMENT_PLAN_VIEW,"VIEW");
		feeReportPaymentPlanPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_PAYMENT_PLAN_EXPORT,"EXPORT");
		feeReportPaymentPlanPrivileges.add(FPCONSTANTS.PC_M6_F_FEE_REPORT_PAYMENT_PLAN_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FEE_REPORT_PAYMENT_PLAN_PRIVILEGES", feeReportPaymentPlanPrivileges);
        //******************************End*********************************************************************
		
		studentMarkRemarkEntryFacultyPrivilege = new Ext.util.HashMap();	
		studentMarkRemarkEntryFacultyPrivilege.add(FPCONSTANTS.FP_M9_F_FACULTY_STUDENT_MARK_REMARK_ENTRY_VIEW,"VIEW");
		studentMarkRemarkEntryFacultyPrivilege.add(FPCONSTANTS.FP_M9_F_FACULTY_STUDENT_MARK_REMARK_ENTRY_SAVE,"SAVE");
		studentMarkRemarkEntryFacultyPrivilege.add(FPCONSTANTS.FP_M9_F_FACULTY_STUDENT_MARK_REMARK_ENTRY_DELETE_MARKS_GRADE,"DELETE_MARKS_GRADE");
		studentMarkRemarkEntryFacultyPrivilege.add(FPCONSTANTS.FP_M9_F_FACULTY_STUDENT_MARK_REMARK_ENTRY_PUBLISH_MARKS_GRADE,"PUBLISH_MARKS_GRADE");
		studentMarkRemarkEntryFacultyPrivilege.add(FPCONSTANTS.FP_M9_F_FACULTY_STUDENT_MARK_REMARK_ENTRY_UNPUBLISH_MARKS_GRADE,"UNPUBLISH_MARKS_GRADE");
		studentMarkRemarkEntryFacultyPrivilege.add(FPCONSTANTS.FP_M9_F_FACULTY_STUDENT_MARK_REMARK_ENTRY_CHECK_HISTORY,"CHECK_HISTORY");
		studentMarkRemarkEntryFacultyPrivilege.add(FPCONSTANTS.FP_M9_F_FACULTY_STUDENT_MARK_REMARK_ENTRY_CREATE,"CREATE");
		studentMarkRemarkEntryFacultyPrivilege.add(FPCONSTANTS.FP_M9_F_FACULTY_STUDENT_MARK_REMARK_ENTRY_EDIT,"EDIT");
		studentMarkRemarkEntryFacultyPrivilege.add(FPCONSTANTS.FP_M9_F_FACULTY_STUDENT_MARK_REMARK_ENTRY_DELETE,"DELETE");
		studentMarkRemarkEntryFacultyPrivilege.add(FPCONSTANTS.FP_M9_F_FACULTY_STUDENT_MARK_REMARK_ENTRY_SUBMIT,"SUBMIT");
		featurePrivilegesMap.add("STUDENT_MARK_REMARK_ENTRY_FACULTY_PRIVILEGES", studentMarkRemarkEntryFacultyPrivilege);
		
		/****** For Student Program Wise Conditions For Admission***********/
		studentProgramConditionsForAdmissionPrivileges = new Ext.util.HashMap();
		studentProgramConditionsForAdmissionPrivileges.add(FPCONSTANTS.PC_M9_F_STUDENT_PROGRAM_CONDITIONS_FOR_ADMISSION_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_PROGRAM_WISE_CONDITIONS_FOR_ADMISSION_PRIVILEGES", studentProgramConditionsForAdmissionPrivileges);
		
		studentListOfApplicableConditionsForAdmissionPrivileges = new Ext.util.HashMap();
		studentListOfApplicableConditionsForAdmissionPrivileges.add(FPCONSTANTS.PC_M9_F_STUDENT_LIST_OF_APPLICABLE_CONDITIONS_FOR_ADMISSION_CREATE,"CREATE");
		studentListOfApplicableConditionsForAdmissionPrivileges.add(FPCONSTANTS.PC_M9_F_STUDENT_LIST_OF_APPLICABLE_CONDITIONS_FOR_ADMISSION_DELETE,"DELETE");
		featurePrivilegesMap.add("STUDENT_LIST_OF_APPLICABLE_CONDITIONS_FOR_ADMISSION_PRIVILEGES", studentListOfApplicableConditionsForAdmissionPrivileges);
		
		/************** For Withdraw Admission Grid **************/
		withdrawAdmissionPrivileges = new Ext.util.HashMap();
		withdrawAdmissionPrivileges.add(FPCONSTANTS.PC_M3_F_WITHDRAW_ADMISSION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("WITHDRAW_ADMISSION_PRIVILEGES", withdrawAdmissionPrivileges);
		
		/************** For Reject Admission Grid **************/
		rejectAdmissionPrivileges = new Ext.util.HashMap();
		rejectAdmissionPrivileges.add(FPCONSTANTS.PC_M3_F_REJECT_ADMISSION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("REJECT_ADMISSION_PRIVILEGES", rejectAdmissionPrivileges);
		
		/************** For Approve Admission Grid **************/
		approveAdmissionPrivileges = new Ext.util.HashMap();
		approveAdmissionPrivileges.add(FPCONSTANTS.PC_M3_F_APPROVE_ADMISSION_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPROVE_ADMISSION_PRIVILEGES", approveAdmissionPrivileges);
		
		/************** For Create Application Add Program Grid **************/
		createApplicationAddProgramPrivileges = new Ext.util.HashMap();
		createApplicationAddProgramPrivileges.add(FPCONSTANTS.PC_M3_F_CREATE_APPLICATION_ADD_PROGRAM_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("CREATE_APPLICATION_ADD_PROGRAM_PRIVILEGES", createApplicationAddProgramPrivileges);
		
		/************** For Application Add Program Details Grid **************/
		applicationDetailsAddProgramPrivileges = new Ext.util.HashMap();
		applicationDetailsAddProgramPrivileges.add(FPCONSTANTS.PC_M3_F_APPLICATION_ADD_PROGRAM_DETAILS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICATION_DETAILS_ADD_PROGRAM_PRIVILEGES", applicationDetailsAddProgramPrivileges);
		
		/************** For Admission Details Add Program Grid **************/
		admissionDetailsAddProgramPrivileges = new Ext.util.HashMap();
		admissionDetailsAddProgramPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSION_ADD_PROGRAM_DETAILS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("ADMISSION_DETAILS_ADD_PROGRAM_PRIVILEGES", admissionDetailsAddProgramPrivileges);
		
		/************** For Admission Details Edit Program Grid **************/
		admissionDetailsEditProgramPrivileges = new Ext.util.HashMap();
		admissionDetailsEditProgramPrivileges.add(FPCONSTANTS.PC_M3_F_ADMISSION_EDIT_PROGRAM_DETAILS_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("ADMISSION_DETAILS_EDIT_PROGRAM_PRIVILEGES", admissionDetailsEditProgramPrivileges);
		
		
		//******************************Stage Attribute Tree Links***************************************************
		stageAttributeTreeLinksPrivileges = new Ext.util.HashMap();
		stageAttributeTreeLinksPrivileges.add(FPCONSTANTS.PC_M6_F_STAGE_ATTRIBUTE_LINK_VIEW,"VIEW");
		featurePrivilegesMap.add("STAGE_ATTRIBUTE_TREELINKS_PRIVILEGES", stageAttributeTreeLinksPrivileges);
        //******************************End*********************************************************************
		
		//******************************Stage Statistics Tree Links***************************************************
		stageStatisticsTreeLinksPrivileges = new Ext.util.HashMap();
		stageStatisticsTreeLinksPrivileges.add(FPCONSTANTS.PC_M6_F_STAGE_STATISTICS_LINK_VIEW,"VIEW");
		featurePrivilegesMap.add("STAGE_STATISTICS_TREELINKS_PRIVILEGES", stageStatisticsTreeLinksPrivileges);
        //******************************End*********************************************************************
		
		//******************************TRANSFER SEATS Tree Links***************************************************
		transferSeatsTreeLinksPrivileges = new Ext.util.HashMap();
		transferSeatsTreeLinksPrivileges.add(FPCONSTANTS.PC_M6_F_TRANSFER_SEATS_LINK_VIEW,"VIEW");
		featurePrivilegesMap.add("TRANSFER_SEATS_TREELINKS_PRIVILEGES", transferSeatsTreeLinksPrivileges);
        //******************************End*********************************************************************
		
		//******************************OVERRIDE QUOTA LIMITS Tree Links***************************************************
		overrideQuotaLimitsTreeLinksPrivileges = new Ext.util.HashMap();
		overrideQuotaLimitsTreeLinksPrivileges.add(FPCONSTANTS.PC_M6_F_OVERRIDE_QUOTA_LIMITS_LINK_VIEW,"VIEW");
		featurePrivilegesMap.add("OVERRIDE_QUOTA_LIMITS_TREELINKS_PRIVILEGES", overrideQuotaLimitsTreeLinksPrivileges);
        //******************************End*********************************************************************
		
		//******************************STAGE FEE STATISTICS Tree Links***************************************************
		stageFeeStatisticsTreeLinksPrivileges = new Ext.util.HashMap();
		stageFeeStatisticsTreeLinksPrivileges.add(FPCONSTANTS.PC_M6_F_STAGE_FEE_STATISTICS_LINK_VIEW,"VIEW");
		featurePrivilegesMap.add("STAGE_FEE_STATISTICS_TREELINKS_PRIVILEGES", stageFeeStatisticsTreeLinksPrivileges);
        //******************************End*********************************************************************
		
		studentMedicalDetailsReportPrivileges = new Ext.util.HashMap();
		studentMedicalDetailsReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_MEDICAL_DETAILS_REPORT_EXPORT, "EXPORT");
		studentMedicalDetailsReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_MEDICAL_DETAILS_REPORT_REPORT_VIEW, "VIEW");
		studentMedicalDetailsReportPrivileges.add(FPCONSTANTS.PS_M9_R_STD_MEDICAL_DETAILS_REPORT_REPORT_GRID_CONFIG, "GRID_CONFIGURATION");
		featurePrivilegesMap.add("MEDICAL_DETAILS_REPORT_PRIVILEGES", studentMedicalDetailsReportPrivileges);
		
		programBatchCourseGroupPrivileges = new Ext.util.HashMap();
		programBatchCourseGroupPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAM_BATCH_COURSE_GROUP_EXPORT, "EXPORT");
		programBatchCourseGroupPrivileges.add(FPCONSTANTS.PC_M4_F_PROGRAM_BATCH_COURSE_GROUP_SAVE, "SAVE");
		featurePrivilegesMap.add("PROGRAM_BATCH_COURSE_GROUP_PRIVILEGES", programBatchCourseGroupPrivileges);
		
		/****** For Student Holds ***********/
		facultyPortalStudentHoldsPrivileges = new Ext.util.HashMap();
		facultyPortalStudentHoldsPrivileges.add(FPCONSTANTS.FP_M14_F_STUDENT_HOLDS_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_HOLDS_PRIVILEGES", facultyPortalStudentHoldsPrivileges);
		
		/****** For Student Disciplinary Actions-SU***********/
		facultyPortalDisciplinaryActionsSUPrivileges = new Ext.util.HashMap();
		facultyPortalDisciplinaryActionsSUPrivileges.add(FPCONSTANTS.FP_M14_F_STUDENT_DISCIPLINARY_ACTIONS_SU_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_DISCIPLINARY_ACTIONS_SU_PRIVILEGES", facultyPortalDisciplinaryActionsSUPrivileges);
		
		/****** For Student Head Wise Bills***********/
		facultyPortalHeadWiseBillsPrivileges = new Ext.util.HashMap();
		facultyPortalHeadWiseBillsPrivileges.add(FPCONSTANTS.FP_M14_F_STUDENT_HEAD_WISE_BILLS_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_HEAD_WISE_BILLS_PRIVILEGES", facultyPortalHeadWiseBillsPrivileges);
		
		/****** For Student NSFAS***********/
		facultyportalstudentnsfasprivileges = new Ext.util.HashMap();
		facultyportalstudentnsfasprivileges.add(FPCONSTANTS.FP_M14_F_STUDENT_NSFAS_PRIVILEGES_VIEW,"VIEW");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_NSFAS_PRIVILEGES", facultyportalstudentnsfasprivileges);
		
		
		examinationResultsPrivilege = new Ext.util.HashMap();
		examinationResultsPrivilege.add(FPCONSTANTS.PC_M5_F_EXAMINATION_RESULTS_EXPORT_REPORTS,"EXPORT_REPORTS");
		examinationResultsPrivilege.add(FPCONSTANTS.PC_M5_F_EXAMINATION_RESULTS_COURSE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		examinationResultsPrivilege.add(FPCONSTANTS.FP_M9_F_FACULTY_EXAMINATION_RESULTS_TYPE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		examinationResultsPrivilege.add(FPCONSTANTS.FP_M9_F_FACULTY_EXAMINATION_RESULTS_COURSE_SCREEN_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("EXAMINATIONRESULTS_PRIVILEGES", examinationResultsPrivilege);
		
		parentDetailsVisitorPrivileges = new Ext.util.HashMap();
		parentDetailsVisitorPrivileges.add(FPCONSTANTS.PC_M3_F_PARENT_DETAILS_PRIVILEGES_RELATIONSHIP_VISITOR1,"RELATIONSHIP_VISITOR1");
		parentDetailsVisitorPrivileges.add(FPCONSTANTS.PC_M3_F_PARENT_DETAILS_PRIVILEGES_RELATIONSHIP_VISITOR2,"RELATIONSHIP_VISITOR2");
		parentDetailsVisitorPrivileges.add(FPCONSTANTS.PC_M3_F_PARENT_DETAILS_PRIVILEGES_RELATIONSHIP_VISITOR3,"RELATIONSHIP_VISITOR3");
		parentDetailsVisitorPrivileges.add(FPCONSTANTS.PC_M3_F_PARENT_DETAILS_PRIVILEGES_RELATIONSHIP_VISITOR4,"RELATIONSHIP_VISITOR4");
		featurePrivilegesMap.add("PARENT_DETAILS_VISITOR_PRIVILEGES", parentDetailsVisitorPrivileges);
		
		spParentDetailsVisitorPrivileges = new Ext.util.HashMap();
		spParentDetailsVisitorPrivileges.add(FPCONSTANTS.SP_M3_F_PARENT_DETAILS_PRIVILEGES_RELATIONSHIP_VISITOR1,"RELATIONSHIP_VISITOR1");
		spParentDetailsVisitorPrivileges.add(FPCONSTANTS.SP_M3_F_PARENT_DETAILS_PRIVILEGES_RELATIONSHIP_VISITOR2,"RELATIONSHIP_VISITOR2");
		spParentDetailsVisitorPrivileges.add(FPCONSTANTS.SP_M3_F_PARENT_DETAILS_PRIVILEGES_RELATIONSHIP_VISITOR3,"RELATIONSHIP_VISITOR3");
		spParentDetailsVisitorPrivileges.add(FPCONSTANTS.SP_M3_F_PARENT_DETAILS_PRIVILEGES_RELATIONSHIP_VISITOR4,"RELATIONSHIP_VISITOR4");
		featurePrivilegesMap.add("STUDENT_PORTAL_PARENT_DETAILS_VISITOR_PRIVILEGES", spParentDetailsVisitorPrivileges);
		
		ppParentDetailsVisitorPrivileges = new Ext.util.HashMap();
		ppParentDetailsVisitorPrivileges.add(FPCONSTANTS.PP_M3_F_PARENT_DETAILS_PRIVILEGES_RELATIONSHIP_VISITOR1,"RELATIONSHIP_VISITOR1");
		ppParentDetailsVisitorPrivileges.add(FPCONSTANTS.PP_M3_F_PARENT_DETAILS_PRIVILEGES_RELATIONSHIP_VISITOR2,"RELATIONSHIP_VISITOR2");
		ppParentDetailsVisitorPrivileges.add(FPCONSTANTS.PP_M3_F_PARENT_DETAILS_PRIVILEGES_RELATIONSHIP_VISITOR3,"RELATIONSHIP_VISITOR3");
		ppParentDetailsVisitorPrivileges.add(FPCONSTANTS.PP_M3_F_PARENT_DETAILS_PRIVILEGES_RELATIONSHIP_VISITOR4,"RELATIONSHIP_VISITOR4");
		featurePrivilegesMap.add("PARENT_PORTAL_PARENT_DETAILS_VISITOR_PRIVILEGES", ppParentDetailsVisitorPrivileges);
		
		studentPortalDownloadIdCardPrivilege = new Ext.util.HashMap();
		studentPortalDownloadIdCardPrivilege.add(FPCONSTANTS.SP_M13_F_STUDENT_DOWNLOAD_ID_CARD, "VIEW");
		featurePrivilegesMap.add("STUDENT_PORTAL_DOWNLOAD_ID_CARD_PRIVILEGES", studentPortalDownloadIdCardPrivilege);
		
		outstandingDashletPrivilege = new Ext.util.HashMap();
        outstandingDashletPrivilege.add(FPCONSTANTS.SP_M13_F_OUTSTANDING_DASHLET, "MAKE_PAYMENT");
        featurePrivilegesMap.add("OUTSTANDING_DASHBOARD_PRIVILEGES", outstandingDashletPrivilege);
		
		studentPortalFlagDetailPrivilege = new Ext.util.HashMap();
		studentPortalFlagDetailPrivilege.add(FPCONSTANTS.SP_M9_F_STUDENT_FLAG_DETAILS_VIEW, "VIEW");
		studentPortalFlagDetailPrivilege.add(FPCONSTANTS.SP_M9_F_STUDENT_FLAG_DETAILS_EXPORT, "EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_FLAG_DETAILS_PRIVILEGES", studentPortalFlagDetailPrivilege);
		
		parentPortalDownloadIdCardPrivilege = new Ext.util.HashMap();
		parentPortalDownloadIdCardPrivilege.add(FPCONSTANTS.PP_M13_F_PARENT_DOWNLOAD_ID_CARD, "VIEW");
		featurePrivilegesMap.add("PARENT_PORTAL_DOWNLOAD_ID_CARD_PRIVILEGES", parentPortalDownloadIdCardPrivilege);
		
		updatedMarksRemarksReportPrivilege = new Ext.util.HashMap();
		updatedMarksRemarksReportPrivilege.add(FPCONSTANTS.PS_M13_F_UPDATED_MARKS_REMARKS_REPORT_VIEW, "VIEW");
		featurePrivilegesMap.add("EXAMINATION_REPORTS_UPDATED_MARKS_REMARKS_PRIVILEGES", updatedMarksRemarksReportPrivilege);
		
		studentAcademicHistoryForMarkType=new Ext.util.HashMap();
		studentAcademicHistoryForMarkType.add(FPCONSTANTS.PS_M9_F_STUDENT_VIEW_ACADEMIC_HISTORY_MARK_TYPE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("STUDENT_VIEW_ACADEMIC_HISTORY_FOR_MARK_TYPE_PRIVILEGES", studentAcademicHistoryForMarkType);
		
		
		facultyPortalStudentAcademicHistoryForMarkType=new Ext.util.HashMap();
		facultyPortalStudentAcademicHistoryForMarkType.add(FPCONSTANTS.FP_M9_F_STUDENT_VIEW_ACADEMIC_HISTORY_MARK_TYPE_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("FACULTY_PORTAL_STUDENT_VIEW_ACADEMIC_HISTORY_MARK_TYPE_PRIVILEGES", facultyPortalStudentAcademicHistoryForMarkType);
		
		adhocApplicationDocumentsPrivileges = new Ext.util.HashMap();
		adhocApplicationDocumentsPrivileges.add(FPCONSTANTS.PC_M3_F_AD_HOC_APPLICATIONS_DOCUMENTS_VIEW,"VIEW");
		adhocApplicationDocumentsPrivileges.add(FPCONSTANTS.PC_M3_F_AD_HOC_APPLICATIONS_DOCUMENTS_CREATE,"CREATE");
		adhocApplicationDocumentsPrivileges.add(FPCONSTANTS.PC_M3_F_AD_HOC_APPLICATIONS_DOCUMENTS_UPDATE,"UPDATE");
		adhocApplicationDocumentsPrivileges.add(FPCONSTANTS.PC_M3_F_AD_HOC_APPLICATIONS_DOCUMENTS_DELETE,"DELETE");
		adhocApplicationDocumentsPrivileges.add(FPCONSTANTS.PC_M3_F_AD_HOC_APPLICATIONS_DOCUMENTS_EXPORT,"EXPORT");
		
		featurePrivilegesMap.add("AD_HOC_APPLICATION_DOCUMENTS_PRIVILEGES", adhocApplicationDocumentsPrivileges);
		
		studentFeeRegistrationResetPrivileges = new Ext.util.HashMap();
		studentFeeRegistrationResetPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_FEE_REGISTRATION_RESET_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_FEE_REGISTRATION_RESET_PRIVILEGES", studentFeeRegistrationResetPrivileges);
		
		studentTransferCreditRequestPrivileges = new Ext.util.HashMap();
		studentTransferCreditRequestPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_TRANSFER_CREDIT_REQUEST_VIEW,"VIEW");
		featurePrivilegesMap.add("STUDENT_TRANSFER_CREDIT_REQUEST_PRIVILEGES", studentTransferCreditRequestPrivileges);
		

		applyForJobPrivileges = new Ext.util.HashMap();
		applyForJobPrivileges.add(FPCONSTANTS.PC_M8_D_APPLY_FOR_JOB_MANAGE_APPLICATION_STATUS,"MANAGE_APPLICATION_STATUS");
		featurePrivilegesMap.add("APPLY_FOR_JOB_PRIVILEGES", applyForJobPrivileges);
		
		facultyMarkSummaryReport2021 = new Ext.util.HashMap();
		facultyMarkSummaryReport2021.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_MARK_SUMMARY_VIEW_2021_VIEW, "VIEW");
		featurePrivilegesMap.add("FACULTY_MARK_SUMMARY_REPORT_2021_PRIVILEGES", facultyMarkSummaryReport2021);
		
		facultyMarkSummaryReport2022 = new Ext.util.HashMap();
		facultyMarkSummaryReport2022.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_MARK_SUMMARY_VIEW_2022_VIEW, "VIEW");
		featurePrivilegesMap.add("FACULTY_MARK_SUMMARY_REPORT_2022_PRIVILEGES", facultyMarkSummaryReport2022);
		
		facultyMarkSummaryReport2023 = new Ext.util.HashMap();
		facultyMarkSummaryReport2023.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_MARK_SUMMARY_VIEW_2023_VIEW, "VIEW");
		featurePrivilegesMap.add("FACULTY_MARK_SUMMARY_REPORT_2023_PRIVILEGES", facultyMarkSummaryReport2023);
		
		facultyMarkSummaryReport2024 = new Ext.util.HashMap();
		facultyMarkSummaryReport2024.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_MARK_SUMMARY_VIEW_2024_VIEW, "VIEW");
		featurePrivilegesMap.add("FACULTY_MARK_SUMMARY_REPORT_2024_PRIVILEGES", facultyMarkSummaryReport2024);
		
		facultyMarkSummaryReport2025 = new Ext.util.HashMap();
		facultyMarkSummaryReport2025.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_MARK_SUMMARY_VIEW_2025_VIEW, "VIEW");
		featurePrivilegesMap.add("FACULTY_MARK_SUMMARY_REPORT_2025_PRIVILEGES", facultyMarkSummaryReport2025);
		
		facultyMarkSummaryReport2026 = new Ext.util.HashMap();
		facultyMarkSummaryReport2026.add(FPCONSTANTS.FP_M9_F_FP_FACULTY_MARK_SUMMARY_VIEW_2026_VIEW, "VIEW");
		featurePrivilegesMap.add("FACULTY_MARK_SUMMARY_REPORT_2026_PRIVILEGES", facultyMarkSummaryReport2026);
		
		/*********************For Student mobile app Proof of Registration*************************/
		SMAproofOfRegistrationPrivileges = new Ext.util.HashMap();
		SMAproofOfRegistrationPrivileges.add(FPCONSTANTS.SMA_M4_F_PROOF_OF_REGISTRATION_VIEW, "VIEW");
		featurePrivilegesMap.add("SMA_PROOF_OF_REGISTRATION_PRIVILEGES", SMAproofOfRegistrationPrivileges);
		
		/*********************For Parent mobile app Proof of Registration*************************/
		PMAproofOfRegistrationPrivileges = new Ext.util.HashMap();
		PMAproofOfRegistrationPrivileges.add(FPCONSTANTS.PMA_M4_F_PROOF_OF_REGISTRATION_VIEW, "VIEW");
		featurePrivilegesMap.add("PMA_PROOF_OF_REGISTRATION_PRIVILEGES", PMAproofOfRegistrationPrivileges);
		
		applicantPortalSetupDashboardPrivilege = new Ext.util.HashMap();
		applicantPortalSetupDashboardPrivilege.add(FPCONSTANTS.PC_M3_F_APPLICANT_PORTAL_SETUP_DASHBOARD_VIEW, "VIEW");
		featurePrivilegesMap.add("APPLICANT_PORTAL_SETUP_DASHBOARD_PRIVILEGE", applicantPortalSetupDashboardPrivilege);
		
		studentPortalGraduateCertificatePrivilege = new Ext.util.HashMap();
		studentPortalGraduateCertificatePrivilege.add(FPCONSTANTS.SP_M13_F_STUDENT_GRADUATE_CERTIFICATE, "VIEW");
		featurePrivilegesMap.add("STUDENT_PORTAL_GRADUATE_CERTIFICATE_PRIVILEGES", studentPortalGraduateCertificatePrivilege);
		
		
		studentLevelRemarkReportPrivilege = new Ext.util.HashMap();
		studentLevelRemarkReportPrivilege.add(FPCONSTANTS.PC_M3_F_STUDENT_LEVEL_REMARK_REPORT_VIEW, "VIEW");
		studentLevelRemarkReportPrivilege.add(FPCONSTANTS.PC_M3_F_STUDENT_LEVEL_REMARK_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		
		featurePrivilegesMap.add("STUDENT_LEVEL_REMARK_REPORT_PRIVILEGES", studentLevelRemarkReportPrivilege);
		
		studentAcademicTopicPrivilege = new Ext.util.HashMap();
		studentAcademicTopicPrivilege.add(FPCONSTANTS.PS_M9_F_STUDENT_ACADEMIC_TOPIC_DETAILS_UPLOAD_DOCUMENT, "UPLOAD_DOCUMENT");
		featurePrivilegesMap.add("STUDENT_ACADEMIC_TOPIC_DETAILS_PRIVILEGE", studentAcademicTopicPrivilege);
		
		
		
		
		
		examinationResultReportPrivilege = new Ext.util.HashMap();
		examinationResultReportPrivilege.add(FPCONSTANTS.PC_M3_F_EXAMINATION_RESULT_REPORT_VIEW, "VIEW");
		examinationResultReportPrivilege.add(FPCONSTANTS.PC_M3_F_EXAMINATION_RESULT_REPORT_GRID_CONFIGURATION, "GRID_CONFIGURATION");		
		featurePrivilegesMap.add("EXAMINATION_RESULT_REPORTS_PRIVILEGES", examinationResultReportPrivilege);
		
		facultyExaminationResultReportPrivilege = new Ext.util.HashMap();
		facultyExaminationResultReportPrivilege.add(FPCONSTANTS.FP_M9_F_FACULTY_EXAMINATION_RESULTS_REPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");		
		featurePrivilegesMap.add("FACULTY_EXAMINATION_RESULT_REPORTS_PRIVILEGES", facultyExaminationResultReportPrivilege);		
		
		applicationCheckListDetails = new Ext.util.HashMap();
		applicationCheckListDetails.add(FPCONSTANTS.PC_M3_F_APPLICATIONS_CHECK_LIST_DETAILS_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICATIONS_CHECK_LIST_DETAILS_PRIVILEGES", applicationCheckListDetails);
	
		applicationandadmissioncomments = new Ext.util.HashMap();
		applicationandadmissioncomments.add(FPCONSTANTS.PC_M3_F_APPLICATION_AND_ADMISSION_COMMENTS_VIEW,"VIEW");
		featurePrivilegesMap.add("APPLICATION_AND_ADMISSION_COMMENTS_PRIVILEGES", applicationandadmissioncomments);
		
		dataGridConfigurationPrivilege = new Ext.util.HashMap();
		dataGridConfigurationPrivilege.add(FPCONSTANTS.PC_M12_F_DATAGRID_CONFIGURATION_ENABLE_SORTING_CONFIGURATION, "ENABLE_SORTING_CONFIGURATION");
		featurePrivilegesMap.add("DATA_GRID_CONFIG_PRIVILEGE", dataGridConfigurationPrivilege);
		
		coreErpStudentThesisTitle= new Ext.util.HashMap();
		coreErpStudentThesisTitle.add(FPCONSTANTS.CERP_M9_SP_STUDENT_THESIS_TITLE_VIEW,"VIEW");
		coreErpStudentThesisTitle.add(FPCONSTANTS.CERP_M9_SP_STUDENT_THESIS_TITLE_CREATE,"CREATE");
		coreErpStudentThesisTitle.add(FPCONSTANTS.CERP_M9_SP_STUDENT_THESIS_TITLE_UPDATE,"UPDATE");
		coreErpStudentThesisTitle.add(FPCONSTANTS.CERP_M9_SP_STUDENT_THESIS_TITLE_DELETE,"DELETE");
		coreErpStudentThesisTitle.add(FPCONSTANTS.CERP_M9_SP_STUDENT_THESIS_TITLE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_STUDENT_THESIS_TITLE", coreErpStudentThesisTitle);
		
		coreErpStudentPostDocInfo= new Ext.util.HashMap();
		coreErpStudentPostDocInfo.add(FPCONSTANTS.CERP_M9_SP_STUDENT_POST_DOC_INFO_VIEW,"VIEW");
		coreErpStudentPostDocInfo.add(FPCONSTANTS.CERP_M9_SP_STUDENT_POST_DOC_INFO_CREATE,"CREATE");
		coreErpStudentPostDocInfo.add(FPCONSTANTS.CERP_M9_SP_STUDENT_POST_DOC_INFO_UPDATE,"UPDATE");
		coreErpStudentPostDocInfo.add(FPCONSTANTS.CERP_M9_SP_STUDENT_POST_DOC_INFO_DELETE,"DELETE");
		coreErpStudentPostDocInfo.add(FPCONSTANTS.CERP_M9_SP_STUDENT_POST_DOC_INFO_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_STUDENT_POST_DOC_INFO", coreErpStudentPostDocInfo);
		
		coreErpStudentJointDegree= new Ext.util.HashMap();
		coreErpStudentJointDegree.add(FPCONSTANTS.CERP_M9_SP_STUDENT_JOINT_DEGREE_VIEW,"VIEW");
		coreErpStudentJointDegree.add(FPCONSTANTS.CERP_M9_SP_STUDENT_JOINT_DEGREE_CREATE,"CREATE");
		coreErpStudentJointDegree.add(FPCONSTANTS.CERP_M9_SP_STUDENT_JOINT_DEGREE_UPDATE,"UPDATE");
		coreErpStudentJointDegree.add(FPCONSTANTS.CERP_M9_SP_STUDENT_JOINT_DEGREE_DELETE,"DELETE");
		coreErpStudentJointDegree.add(FPCONSTANTS.CERP_M9_SP_STUDENT_JOINT_DEGREE_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_STUDENT_JOINT_DEGREE", coreErpStudentJointDegree);
		
		coreErpStudentOwnProgressReport= new Ext.util.HashMap();
		coreErpStudentOwnProgressReport.add(FPCONSTANTS.CERP_M9_SP_STUDENT_OWN_PROGRESS_REPORT_VIEW,"VIEW");
		coreErpStudentOwnProgressReport.add(FPCONSTANTS.CERP_M9_SP_STUDENT_OWN_PROGRESS_REPORT_CREATE,"CREATE");
		coreErpStudentOwnProgressReport.add(FPCONSTANTS.CERP_M9_SP_STUDENT_OWN_PROGRESS_REPORT_UPDATE,"UPDATE");
		coreErpStudentOwnProgressReport.add(FPCONSTANTS.CERP_M9_SP_STUDENT_OWN_PROGRESS_REPORT_DELETE,"DELETE");
		coreErpStudentOwnProgressReport.add(FPCONSTANTS.CERP_M9_SP_STUDENT_OWN_PROGRESS_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_STUDENT_OWN_PROGRESS_REPORT", coreErpStudentOwnProgressReport);
		
		coreErpFunctionaryProgressReport= new Ext.util.HashMap();
		coreErpFunctionaryProgressReport.add(FPCONSTANTS.CERP_M9_SP_FUNCTIONARY_PROGRESS_REPORT_VIEW,"VIEW");
		coreErpFunctionaryProgressReport.add(FPCONSTANTS.CERP_M9_SP_FUNCTIONARY_PROGRESS_REPORT_CREATE,"CREATE");
		coreErpFunctionaryProgressReport.add(FPCONSTANTS.CERP_M9_SP_FUNCTIONARY_PROGRESS_REPORT_UPDATE,"UPDATE");
		coreErpFunctionaryProgressReport.add(FPCONSTANTS.CERP_M9_SP_FUNCTIONARY_PROGRESS_REPORT_DELETE,"DELETE");
		coreErpFunctionaryProgressReport.add(FPCONSTANTS.CERP_M9_SP_FUNCTIONARY_PROGRESS_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_FUNCTIONARY_PROGRESS_REPORT", coreErpFunctionaryProgressReport);
		
		coreErpStudentMOU= new Ext.util.HashMap();
		coreErpStudentMOU.add(FPCONSTANTS.CERP_M9_SP_STUDENT_MOU_VIEW,"VIEW");
		coreErpStudentMOU.add(FPCONSTANTS.CERP_M9_SP_STUDENT_MOU_CREATE,"CREATE");
		coreErpStudentMOU.add(FPCONSTANTS.CERP_M9_SP_STUDENT_MOU_UPDATE,"UPDATE");
		coreErpStudentMOU.add(FPCONSTANTS.CERP_M9_SP_STUDENT_MOU_DELETE,"DELETE");
		coreErpStudentMOU.add(FPCONSTANTS.CERP_M9_SP_STUDENT_MOU_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_STUDENT_MOU", coreErpStudentMOU);
		
		coreErpStudentEthicsClearanceLetter= new Ext.util.HashMap();
		coreErpStudentEthicsClearanceLetter.add(FPCONSTANTS.CERP_M9_SP_STUDENT_ETHICS_CLEARANCE_LETTER_VIEW,"VIEW");
		coreErpStudentEthicsClearanceLetter.add(FPCONSTANTS.CERP_M9_SP_STUDENT_ETHICS_CLEARANCE_LETTER_CREATE,"CREATE");
		coreErpStudentEthicsClearanceLetter.add(FPCONSTANTS.CERP_M9_SP_STUDENT_ETHICS_CLEARANCE_LETTER_UPDATE,"UPDATE");
		coreErpStudentEthicsClearanceLetter.add(FPCONSTANTS.CERP_M9_SP_STUDENT_ETHICS_CLEARANCE_LETTER_DELETE,"DELETE");
		coreErpStudentEthicsClearanceLetter.add(FPCONSTANTS.CERP_M9_SP_STUDENT_ETHICS_CLEARANCE_LETTER_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_STUDENT_ETHICS_CLEARANCE_LETTER", coreErpStudentEthicsClearanceLetter);
		
		
		coreExaminersReportGrid= new Ext.util.HashMap();
		coreExaminersReportGrid.add(FPCONSTANTS.CERP_M9_SP_EXAMINERS_REPORT_VIEW,"VIEW");
		coreExaminersReportGrid.add(FPCONSTANTS.CERP_M9_SP_EXAMINERS_REPORT_CREATE,"CREATE");
		coreExaminersReportGrid.add(FPCONSTANTS.CERP_M9_SP_EXAMINERS_REPORT_UPDATE,"UPDATE");
		coreExaminersReportGrid.add(FPCONSTANTS.CERP_M9_SP_EXAMINERS_REPORT_DELETE,"DELETE");
		coreExaminersReportGrid.add(FPCONSTANTS.CERP_M9_SP_EXAMINERS_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_EXAMINERS_REPORT",coreExaminersReportGrid);
		
		coreIndependentNonExaminingChairpersonReportGrid= new Ext.util.HashMap();
		coreIndependentNonExaminingChairpersonReportGrid.add(FPCONSTANTS.CERP_M9_SP_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_VIEW,"VIEW");
		coreIndependentNonExaminingChairpersonReportGrid.add(FPCONSTANTS.CERP_M9_SP_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_CREATE,"CREATE");
		coreIndependentNonExaminingChairpersonReportGrid.add(FPCONSTANTS.CERP_M9_SP_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_UPDATE,"UPDATE");
		coreIndependentNonExaminingChairpersonReportGrid.add(FPCONSTANTS.CERP_M9_SP_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_DELETE,"DELETE");
		coreIndependentNonExaminingChairpersonReportGrid.add(FPCONSTANTS.CERP_M9_SP_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_INDEPENDENT_NON_EXAMINING_CHAIRPERSON_REPORT",coreIndependentNonExaminingChairpersonReportGrid);
		
		coreProofOfActivityGrid= new Ext.util.HashMap();
		coreProofOfActivityGrid.add(FPCONSTANTS.CERP_M9_SP_PROOF_OF_ACTIVITY_VIEW,"VIEW");
		coreProofOfActivityGrid.add(FPCONSTANTS.CERP_M9_SP_PROOF_OF_ACTIVITY_CREATE,"CREATE");
		coreProofOfActivityGrid.add(FPCONSTANTS.CERP_M9_SP_PROOF_OF_ACTIVITY_UPDATE,"UPDATE");
		coreProofOfActivityGrid.add(FPCONSTANTS.CERP_M9_SP_PROOF_OF_ACTIVITY_DELETE,"DELETE");
		coreProofOfActivityGrid.add(FPCONSTANTS.CERP_M9_SP_PROOF_OF_ACTIVITY_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_PROOF_OF_ACTIVITY",coreProofOfActivityGrid);
		
		coreStudentThesisUploadGrid= new Ext.util.HashMap();
		coreStudentThesisUploadGrid.add(FPCONSTANTS.CERP_M9_SP_STUDENT_THESIS_UPLOAD_VIEW,"VIEW");
		coreStudentThesisUploadGrid.add(FPCONSTANTS.CERP_M9_SP_STUDENT_THESIS_UPLOAD_CREATE,"CREATE");
		coreStudentThesisUploadGrid.add(FPCONSTANTS.CERP_M9_SP_STUDENT_THESIS_UPLOAD_UPDATE,"UPDATE");
		coreStudentThesisUploadGrid.add(FPCONSTANTS.CERP_M9_SP_STUDENT_THESIS_UPLOAD_DELETE,"DELETE");
		coreStudentThesisUploadGrid.add(FPCONSTANTS.CERP_M9_SP_STUDENT_THESIS_UPLOAD_EXPORT,"EXPORT");
		coreStudentThesisUploadGrid.add(FPCONSTANTS.CERP_M9_SP_STUDENT_THESIS_UPLOAD_SEND_DOCUMENT,"SEND_DOCUMENT");
		coreStudentThesisUploadGrid.add(FPCONSTANTS.CERP_M9_SP_STUDENT_THESIS_UPLOAD_USER_SEARCH,"USER_SEARCH");
		featurePrivilegesMap.add("CORE_ERP_STUDENT_THESIS_UPLOAD",coreStudentThesisUploadGrid);
		
		
		coreFunctionaryDetailsGrid= new Ext.util.HashMap();
		coreFunctionaryDetailsGrid.add(FPCONSTANTS.CERP_M9_SP_FUNCTIONARY_DETAILS_VIEW,"VIEW");
		coreFunctionaryDetailsGrid.add(FPCONSTANTS.CERP_M9_SP_FUNCTIONARY_DETAILS_CREATE,"CREATE");
		coreFunctionaryDetailsGrid.add(FPCONSTANTS.CERP_M9_SP_FUNCTIONARY_DETAILS_UPDATE,"UPDATE");
		coreFunctionaryDetailsGrid.add(FPCONSTANTS.CERP_M9_SP_FUNCTIONARY_DETAILS_DELETE,"DELETE");
		coreFunctionaryDetailsGrid.add(FPCONSTANTS.CERP_M9_SP_FUNCTIONARY_DETAILS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_FUNCTIONARY_DETAILS",coreFunctionaryDetailsGrid);
		
	
		
		
		
		coreNominateExaminersGrid= new Ext.util.HashMap();
		coreNominateExaminersGrid.add(FPCONSTANTS.CERP_M9_SP_NOMINATE_EXAMINERS_VIEW,"VIEW");
		coreNominateExaminersGrid.add(FPCONSTANTS.CERP_M9_SP_NOMINATE_EXAMINERS_CREATE,"CREATE");
		coreNominateExaminersGrid.add(FPCONSTANTS.CERP_M9_SP_NOMINATE_EXAMINERS_UPDATE,"UPDATE");
		coreNominateExaminersGrid.add(FPCONSTANTS.CERP_M9_SP_NOMINATE_EXAMINERS_DELETE,"DELETE");
		coreNominateExaminersGrid.add(FPCONSTANTS.CERP_M9_SP_NOMINATE_EXAMINERS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("CORE_ERP_NOMINATE_EXAMINERS",coreNominateExaminersGrid);
		
		
		studentLivingArrangmentPrivileges = new Ext.util.HashMap();
		studentLivingArrangmentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_LIVING_ARRANGMENT_VIEW,"VIEW");
		studentLivingArrangmentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_LIVING_ARRANGMENT_CREATE,"CREATE");
		studentLivingArrangmentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_LIVING_ARRANGMENT_UPDATE,"UPDATE");
		studentLivingArrangmentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_LIVING_ARRANGMENT_DELETE,"DELETE");
		studentLivingArrangmentPrivileges.add(FPCONSTANTS.PS_M9_F_STUDENT_LIVING_ARRANGMENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_LIVING_ARRANGMENT_PRIVILEGES", studentLivingArrangmentPrivileges);
		
		facultyLivingArrangmentPrivileges = new Ext.util.HashMap();
		facultyLivingArrangmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_LIVING_ARRANGMENT_VIEW,"VIEW");
		facultyLivingArrangmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_LIVING_ARRANGMENT_CREATE,"CREATE");
		facultyLivingArrangmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_LIVING_ARRANGMENT_UPDATE,"UPDATE");
		facultyLivingArrangmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_LIVING_ARRANGMENT_DELETE,"DELETE");
		facultyLivingArrangmentPrivileges.add(FPCONSTANTS.FP_M9_F_FACULTY_LIVING_ARRANGMENT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("FACULTY_LIVING_ARRANGMENT_PRIVILEGES", facultyLivingArrangmentPrivileges);
		
		accommodationProviderHostelPrivileges = new Ext.util.HashMap();
		accommodationProviderHostelPrivileges.add(FPCONSTANTS.PC_M14_MANAGE_ACCOMMODATION_PROVIDER_VIEW,"VIEW");
		accommodationProviderHostelPrivileges.add(FPCONSTANTS.PC_M14_MANAGE_ACCOMMODATION_PROVIDER_CREATE,"CREATE");
		accommodationProviderHostelPrivileges.add(FPCONSTANTS.PC_M14_MANAGE_ACCOMMODATION_PROVIDER_UPDATE,"UPDATE");
		accommodationProviderHostelPrivileges.add(FPCONSTANTS.PC_M14_MANAGE_ACCOMMODATION_PROVIDER_DELETE,"DELETE");
		accommodationProviderHostelPrivileges.add(FPCONSTANTS.PC_M14_MANAGE_ACCOMMODATION_PROVIDER_VIEW_DETAILS,"VIEW_DETAILS");
		featurePrivilegesMap.add("MANAGE_ACCOMMODATION_PROVIDER_PRIVILEGES", accommodationProviderHostelPrivileges);
		
		manageDebitOrderPrivileges = new Ext.util.HashMap();
		manageDebitOrderPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_DEBIT_ORDERS_EXPORTREPORTS,"EXPORTREPORTS");
		manageDebitOrderPrivileges.add(FPCONSTANTS.PC_M6_F_MANAGE_DEBIT_ORDERS_CHANGESTATUS,"CHANGESTATUS");
		featurePrivilegesMap.add("MANAGE_DEBIT_ORDER_PRIVILEGES", manageDebitOrderPrivileges);
		
		SPortalStudentMOU= new Ext.util.HashMap();
		SPortalStudentMOU.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_MOU_VIEW,"VIEW");
		SPortalStudentMOU.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_MOU_CREATE,"CREATE");
		SPortalStudentMOU.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_MOU_UPDATE,"UPDATE");
		SPortalStudentMOU.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_MOU_DELETE,"DELETE");
		SPortalStudentMOU.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_MOU_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_MOU_PRIVILEGES", SPortalStudentMOU);
		
		FPLeaveRequestPrivileges= new Ext.util.HashMap();
		FPLeaveRequestPrivileges.add(FPCONSTANTS.FP_M9_F_LEAVE_REQUEST_VIEW,"VIEW");
		FPLeaveRequestPrivileges.add(FPCONSTANTS.FP_M9_F_LEAVE_REQUEST_ACTION_HISTORY_TAB,"LEAVE_REQUEST_ACTION_HISTORY_TAB");
		featurePrivilegesMap.add("FP_LEAVE_REQUEST_PRIVILEGES", FPLeaveRequestPrivileges);
		
		SPortalStudentEthicsClearanceLetter= new Ext.util.HashMap();
		SPortalStudentEthicsClearanceLetter.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_ETHICS_CLEARANCE_LETTER_VIEW,"VIEW");
		SPortalStudentEthicsClearanceLetter.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_ETHICS_CLEARANCE_LETTER_CREATE,"CREATE");
		SPortalStudentEthicsClearanceLetter.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_ETHICS_CLEARANCE_LETTER_UPDATE,"UPDATE");
		SPortalStudentEthicsClearanceLetter.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_ETHICS_CLEARANCE_LETTER_DELETE,"DELETE");
		SPortalStudentEthicsClearanceLetter.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_ETHICS_CLEARANCE_LETTER_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_ETHICS_CLEARANCE_LETTER_PRIVILEGES", SPortalStudentEthicsClearanceLetter);
		
		SPortalStudentOwnProgressReport= new Ext.util.HashMap();
		SPortalStudentOwnProgressReport.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_OWN_PROGRESS_REPORT_VIEW,"VIEW");
		SPortalStudentOwnProgressReport.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_OWN_PROGRESS_REPORT_CREATE,"CREATE");
		SPortalStudentOwnProgressReport.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_OWN_PROGRESS_REPORT_UPDATE,"UPDATE");
		SPortalStudentOwnProgressReport.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_OWN_PROGRESS_REPORT_DELETE,"DELETE");
		SPortalStudentOwnProgressReport.add(FPCONSTANTS.SPortal_M9_SP_STUDENT_OWN_PROGRESS_REPORT_EXPORT,"EXPORT");
		featurePrivilegesMap.add("STUDENT_PORTAL_STUDENT_OWN_PROGRESS_REPORT_PRIVILEGES", SPortalStudentOwnProgressReport);
		
		SunsuccessFLAG = new Ext.util.HashMap();
		SunsuccessFLAG.add(FPCONSTANTS.SUN_SUCCESSFLAGS_VIEW,"VIEW");
		SunsuccessFLAG.add(FPCONSTANTS.SUN_SUCCESSFLAGS_CREATE,"CREATE");
		SunsuccessFLAG.add(FPCONSTANTS.SUN_SUCCESSFLAGS_UPDATE,"UPDATE");
		SunsuccessFLAG.add(FPCONSTANTS.SUN_SUCCESSFLAGS_DELETE,"DELETE");
		SunsuccessFLAG.add(FPCONSTANTS.SUN_SUCCESSFLAGS_VIEW_DETAILS,"VIEW_DETAILS");
		SunsuccessFLAG.add(FPCONSTANTS.SUN_SUCCESSFLAGS_EXPORT,"EXPORT");
		SunsuccessFLAG.add(FPCONSTANTS.SUN_SUCCESSFLAGS_APPROVE,"APPROVE");
		SunsuccessFLAG.add(FPCONSTANTS.SUN_SUCCESSFLAGS_CALCULATE_SCORE,"CALCULATE_SCORE");	
		SunsuccessFLAG.add(FPCONSTANTS.SUN_SUCCESSFLAGS_IMPORT,"IMPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_SUNSUCCESS_MOU_PRIVILEGES",SunsuccessFLAG);
		
		SunsuccessBusinessAttributes = new Ext.util.HashMap();
		SunsuccessBusinessAttributes.add(FPCONSTANTS.SUNSUCCESS_BUISRULES_ATTRIBUTES_LIST_GRID_VIEW,"VIEW");
		SunsuccessBusinessAttributes.add(FPCONSTANTS.SUNSUCCESS_BUISRULES_ATTRIBUTES_LIST_GRID_CREATE,"CREATE");
		SunsuccessBusinessAttributes.add(FPCONSTANTS.SUNSUCCESS_BUISRULES_ATTRIBUTES_LIST_GRID_UPDATE,"UPDATE");
		SunsuccessBusinessAttributes.add(FPCONSTANTS.SUNSUCCESS_BUISRULES_ATTRIBUTES_LIST_GRID_DELETE,"DELETE");
		SunsuccessBusinessAttributes.add(FPCONSTANTS.SUNSUCCESS_BUISRULES_ATTRIBUTES_LIST_GRID_EXPORT,"EXPORT");
		featurePrivilegesMap.add("SUNSUCCESS_BUSINESS_ATTRIBUTES_PRIVILEGES",SunsuccessBusinessAttributes);
		
		SunsuccessBusinessAttributesRules = new Ext.util.HashMap();
		SunsuccessBusinessAttributesRules.add(FPCONSTANTS.SUNSUCCESS_BUISRULES_ATTRIBUTES_RULE_LIST_GRID_VIEW,"VIEW");
		SunsuccessBusinessAttributesRules.add(FPCONSTANTS.SUNSUCCESS_BUISRULES_ATTRIBUTES_RULE_LIST_GRID_CREATE,"CREATE");
		SunsuccessBusinessAttributesRules.add(FPCONSTANTS.SUNSUCCESS_BUISRULES_ATTRIBUTES_RULE_LIST_GRID_UPDATE,"UPDATE");
		SunsuccessBusinessAttributesRules.add(FPCONSTANTS.SUNSUCCESS_BUISRULES_ATTRIBUTES_RULE_LIST_GRID_DELETE,"DELETE");
		SunsuccessBusinessAttributesRules.add(FPCONSTANTS.SUNSUCCESS_BUISRULES_ATTRIBUTES_RULE_LIST_GRID_EXPORT,"EXPORT");
		featurePrivilegesMap.add("SUNSUCCESS_BUSINESS_ATTRIBUTES_RULES_PRIVILEGES",SunsuccessBusinessAttributesRules);
		
		SunsuccessMAPFLAG = new Ext.util.HashMap();
		SunsuccessMAPFLAG.add(FPCONSTANTS.SUN_SUCCESSMAPFLAGS_REMOVE_FLAG,"REMOVE_FLAG");
		SunsuccessMAPFLAG.add(FPCONSTANTS.SUN_SUCCESSMAPFLAGS_PUBLISH_FLAG,"PUBLISH_FLAG");
		SunsuccessMAPFLAG.add(FPCONSTANTS.SUN_SUCCESSMAPFLAGS_SEND_MESSAGESS,"SEND_MESSAGE");
		SunsuccessMAPFLAG.add(FPCONSTANTS.SUN_SUCCESSMAPFLAGS_EXPORT,"EXPORT");
		featurePrivilegesMap.add("PARENT_PORTAL_SUNSUCCESS_MAPFLAG_PRIVILEGES",SunsuccessMAPFLAG);
		
		studentAppointmentFollowUp = new Ext.util.HashMap();
		studentAppointmentFollowUp.add(FPCONSTANTS.SP_M9_F_STUDENT_APPOINTMENT_FOLLOW_UP_VIEW,"VIEW");
		studentAppointmentFollowUp.add(FPCONSTANTS.SP_M9_F_STUDENT_APPOINTMENT_FOLLOW_UP_EXPORT,"EXPORT");
		featurePrivilegesMap.add("SP_STUDENT_APPOINTMENT_FOLLOW_UP_PRIVILEGES",studentAppointmentFollowUp);
		
		
		ChargebleNonChargebleGrid = new Ext.util.HashMap();
		ChargebleNonChargebleGrid.add(FPCONSTANTS.PC_M14_CHARGEABLE_AND_NON_CHARGEABLE_DAYS_SCHEDULE_UPDATE,"UPDATE");	
		featurePrivilegesMap.add("CHARGEABLE_AND_NON_CHARGEABLE_GRID_PRIVILEGES",ChargebleNonChargebleGrid)
		
		SunsuccessBusinessRules = new Ext.util.HashMap();
		SunsuccessBusinessRules.add(FPCONSTANTS.SUN_SUCCESS_BUSINESS_RULES_VIEW,"VIEW");
		SunsuccessBusinessRules.add(FPCONSTANTS.SUN_SUCCESS_BUSINESS_RULES_ADD,"CREATE");
		SunsuccessBusinessRules.add(FPCONSTANTS.SUN_SUCCESS_BUSINESS_RULES_EDIT,"UPDATE");
		SunsuccessBusinessRules.add(FPCONSTANTS.SUN_SUCCESS_BUSINESS_RULES_DELETE,"DELETE");
		SunsuccessBusinessRules.add(FPCONSTANTS.SUN_SUCCESS_BUSINESS_RULES_EXPORT,"EXPORT");
		SunsuccessBusinessRules.add(FPCONSTANTS.SUN_SUCCESS_BUSINESS_RULES_APPROVE,"APPROVE");		
		SunsuccessBusinessRules.add(FPCONSTANTS.SUN_SUCCESS_BUSINESS_RULES_APPLY_TO,"APPLY_TO");
		featurePrivilegesMap.add("SUNSUCCESS_BUSINESS_RULES_PRIVILEGES",SunsuccessBusinessRules);
		
		coreApplicantPassportGrid= new Ext.util.HashMap();
		coreApplicantPassportGrid.add(FPCONSTANTS.PC_M3_F_APPLICANT_PASSPORT_VIEW,"VIEW");
		coreApplicantPassportGrid.add(FPCONSTANTS.PC_M3_F_APPLICANT_PASSPORT_CREATE,"CREATE");
		coreApplicantPassportGrid.add(FPCONSTANTS.PC_M3_F_APPLICANT_PASSPORT_UPDATE,"UPDATE");
		coreApplicantPassportGrid.add(FPCONSTANTS.PC_M3_F_APPLICANT_PASSPORT_DELETE,"DELETE");
		coreApplicantPassportGrid.add(FPCONSTANTS.PC_M3_F_APPLICANT_PASSPORT_EXPORT,"EXPORT");
		coreApplicantPassportGrid.add(FPCONSTANTS.PC_M3_F_APPLICANT_PASSPORT_GRID_CONFIGURATION,"GRID_CONFIGURATION");
		featurePrivilegesMap.add("APPLICANT_PASSPORT_PRIVILEGES",coreApplicantPassportGrid);
		
		passportDetail = new Ext.util.HashMap();
		passportDetail.add(FPCONSTANTS.PS_M9_F_PASSPORT_DETAILS_VIEW,"VIEW");
		passportDetail.add(FPCONSTANTS.PS_M9_F_PASSPORT_DETAILS_CREATE,"CREATE");
		passportDetail.add(FPCONSTANTS.PS_M9_F_PASSPORT_DETAILS_UPDATE,"UPDATE");
		passportDetail.add(FPCONSTANTS.PS_M9_F_PASSPORT_DETAILS_DELETE,"DELETE");
		passportDetail.add(FPCONSTANTS.PS_M9_F_PASSPO