Ext.define('Academia.utilities.ux.CustomTopPagingToolBar', {
	extend : 'Ext.container.Container',
	alias : 'widget.customTopPagingToolBar',
	cls:'customTopPagingToolBarCls',
	items:[{	
				xtype:'container',
				layout:'hbox',
				cls: 'paginationArrowBoxCls',
				items:[
				{
					xtype:'button',
					cls:'double-backward-btn',
					disabled:true,
					margin:'5x 0px 0px 5px',
					itemId:'firstButton',
					handler:function(cmp){
						var me = this,
					    grid = me.up('grid'),
					    firstpagingButton = grid.down('#first');
						firstpagingButton.fireHandler();
					}
				},{
					xtype:'button',
					cls:'first-backward-btn',
					disabled:true,
					itemId:'prevButton',
					margin:'5x 0px 0px 5px',
					handler:function(cmp){
						var me = this,
					    grid = me.up('grid'),
					    pagingButton = grid.down('#prev');
					pagingButton.fireHandler();
					}
					
				},{
					xtype:'combo',
					queryMode: 'local',
				    displayField: 'value',
				    valueField: 'id',
				    width:60,
					disabled:true,
				    margin:'0x 0px 0px 5px',
				    itemId:'pageSizeCombo',
				    name:'pageSizeCombo',
				    cls:'coustomPagingCls',
				   // height:30,
				    store:Ext.create('Ext.data.Store', {
				        fields: ['id', 'value'],
				        data : [
				            {"id":"5", "value":"5"},
				            {"id":"10", "value":"10"},
				            {"id":"25", "value":"25"},
				            {"id":"50", "value":"50"},
				            {"id":"100", "value":"100"},
				            {"id":"250", "value":"250"},
				            {"id":"500", "value":"500"}
				        ]
				    }),
				    listeners:{
				    	select:function(cmp){
				    		var me = this,
						    grid = me.up('grid'),
						    custompagingtoolbar = grid.down('custompagingtoolbar'),
						    toolbarCombo = custompagingtoolbar.down('combo');
				    		toolbarCombo.setValue(cmp.getValue());
				    		toolbarCombo.fireEvent('select',toolbarCombo);
				    	}
				    }
				},{
					xtype:'displayfield',
					minWidth:40,
					height:30,
					//hidden:true,
					itemId:'pagingDisplayField',
					cls:'total-Record-cls',
					margin:'-3x 0px 0px 10px',
					value:'of 0'
				},{
					xtype:'displayfield',
					//minWidth:20,
					height:30,
					hidden:true,
					itemId:'totalCountDisplayField',
					cls:'total-grid-count-cls',
					//margin:'-3px 0px 0px 10px'
				},{
					xtype:'button',
					cls:'first-forward-btn',
					disabled:true,
					margin:'4.5px 0px 0px 10px',
					itemId:'nextButtonPaging',
					handler:function(cmp){
						var me = this,
					    grid = me.up('grid'),
					    nextPagingButton = grid.down('#next');
						nextPagingButton.fireHandler();
				}
				},{
					xtype:'button',
					cls:'double-forward-btn',
					disabled:true,
					margin:'4.5px 0px 0px 5px',
					itemId:'lastButton',
					handler:function(cmp){
						var me = this,
						    grid = me.up('grid'),
						    lastPagingButton = grid.down('#last');
						lastPagingButton.fireHandler();
						
					}
				},{
					xtype:'hidden',
					itemId:'totalRecordCount',
				}]
		}
	]
});
