Ext.define('Academia.view.DMSView.DocumentLibraryCenterPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.documentlibrarycenterpanel',
    margin: 0,
    items:[{
    	xtype: 'panel',
    	autoScroll: true,
        frame: true,
        border: true,
        height: 580,
        dockedItems: [{
            xtype: 'toolbar',
            dock: 'top',
            style: 'background:rgb(224, 224, 224);',
            items: [{
            	xtype: 'button',
            	text: getDMSTranslation('CREATE_FOLDER'),
            	itemId: 'createFolderBtn'
            },{
            	xtype: 'button',
            	text: getDMSTranslation('UPLOAD_DOCUMENT'),
            	itemId: 'uploadDocuemntBtn'
            },{
            	xtype: 'splitbutton',
            	text:getDMSTranslation('SELECTED_ITEMS'),
            	itemId: 'selectedItemsMenuItemId',
            	disabled: true,
            	menu: [{
            		text: 'Download as Zip',
            		iconCls:'dms-dowload-icon',
            		itemId: 'documentDownloadMenuItemId'
            	},{
            		text: 'Copy to...',
            		iconCls:'dms-copy-to-icon',
            		itemId: 'documentCopyMenuItemId'
            	},{
            		text: 'Move to...',
            		iconCls:'dms-copy-to-icon',
            		itemId: 'documentMoveMenuItemId'            	
            	},{
            		text: 'Start Workflow...',
            		iconCls:'dms-workflow-icon',
            		itemId: 'documentWorkflowMenuItemId'
            	},{
            		text: 'Delete',
            		iconCls:'dms-delete-icon',
            		itemId: 'documentDeleteMenuItemId'            	
            	}]
            }]
        }],
        bodyStyle:{
        	padding: 0
        },
    	items:[{
    		xtype: 'dataview',
    		itemId: 'documentLibraryDataViewItemId',
    		autoScroll: true,
    		store: Ext.create('Ext.data.ArrayStore',{
        		id: 0,
        		fields: ['type','img','fileName','action','time','displayTime','userName','version','size','displayVersion','folderPath','nodeRef', 'isLocked', 'lockedByUsername', 'lockedByDisplayName', 'role', 'activeWorkflows', 'parendNodeRef'],
    			data: []
        	}),
        	itemSelector: 'div.thumb-wrap-document-library',
    		tpl: new Ext.XTemplate(
		    	   '<tpl for=".">',
			            '<div class="thumb-wrap-document-library {[this.isLockedDocumentHeight(values)]}" >',
			            	'<input type="checkbox" name="file" value="{type}::{fileName}::{nodeRef}" style="display:inline-block;float:left;margin:10px;"/>',
			            	'{[this.getWorkFlowIcon(values)]}',
			            	'<img src="{img}" {[this.isLockedDocumentImgHeight(values)]} />',
			            	'<div class="listItem">',
			            		'{[this.isLockedDocument(values)]}',
				            	'<span style="color: #333;cursor: pointer;font-size: 14px;" class="fileNameSpan">{fileName}</span>',
				            	'<span class="version" style="opacity:0;margin-left: 15px;padding: 1px 5px;background: #aaa;color: #fff;{displayVersion}">{version}</span><br />',
				            	'<span style="float:left;" title="{displayTime}">{action} {time} ago by {userName}</span>',
				            	'<span style="margin-left:20px;">{size}</span>',
				            	'<span class="SideMenu">{[this.sideMenus(values)]}</span>',
			            	'</div>',
			            '</div>',
			        '</tpl>',
			        {
		    		   getWorkFlowIcon: function(values) {
		    			   if(values.activeWorkflows){
		    				   return "<img src='resources/images/document-assign-workflow-16.png' title='Belongs to "+values.activeWorkflows+" active workflows' />";
		    			   }
		    			   else{
		    				   return "<img src='resources/images/document-assign-workflow-16.png' style='opacity:0;' >";
		    			   }
		    		   },
		    		   isLockedDocument: function(values) {
		    			   if(values.isLocked==true){
		    				   return '<span class="document_blocked_span">This document is locked by '+values.lockedByDisplayName+' for offline editing.</span>';
		    			   }
		    			   else{
		    				   return '';
		    			   }
		    		   },
		    		   isLockedDocumentImgHeight: function(values) {
		    			   if(values.isLocked==true){
		    				   return 'style="margin-bottom: 26px;"';
		    			   }
		    			   else{
		    				   return '';
		    			   }
		    		   },
		    		   isLockedDocumentHeight: function(values) {
		    			   if(values.isLocked==true){
		    				   return 'lockedDocument';
		    			   }
		    			   else{
		    				   return '';
		    			   }
		    		   },
		    		   sideMenus: function(values){
		    			   var btnHtml = '';
		    			   var isDownloadAvailable = true;
		    			   if(values.type=="file"){
		    				   var isUploadAvailable = true;
		    				   if(values.isLocked==true){
		    					   var isEditOfflineAvailable = false;
		    					   if(values.lockedByDisplayName=="you"){
			    					   var isCancelEditAvailable = true;
		    					   }
		    					   else{
		    						   var isCancelEditAvailable = false;
		    						   var isUploadAvailable = false;
		    					   }
		    				   }
		    				   else{
		    					   var isEditOfflineAvailable = true;
		    					   var isCancelEditAvailable = false;
		    				   }
		    			   }
		    			   else{
		    				   var isUploadAvailable = false;
		    				   var isEditOfflineAvailable = false;
		    				   var isCancelEditAvailable = false;
		    			   }
	    				   
	    				   if(values.role=="Consumer"){
	    					   var isUploadAvailable = false;
	    					   var isEditOfflineAvailable = false;
		    				   var isCancelEditAvailable = false;
	    				   }
	    				   else if(values.role=="Contributor"){
	    					   var isUploadAvailable = false;
	    					   var isEditOfflineAvailable = false;
		    				   var isCancelEditAvailable = false;
	    				   }

		    			   if(isDownloadAvailable){
		    				   btnHtml = btnHtml+'<span title="Download as Zip" class="downloadBtnIconCls"></span>';
		    			   }
		    			   if(isUploadAvailable){
		    				   btnHtml = btnHtml+'<span title="Upload New Version" class="uploadBtnIconCls"></span>';
		    			   }
		    			   if(isEditOfflineAvailable){
		    				   btnHtml = btnHtml+'<span title="Edit Offline" class="editOfflineBtnIconCls"></span>';
		    			   }
		    			   if(isCancelEditAvailable){
		    				   btnHtml = btnHtml+'<span title="Cancel Editing" class="cancelEditBtnIconCls"></span>';
		    			   }
		    			   return btnHtml;
		    		   }
			        }
		    ),
		    emptyText: '<div style="float: left; width: 100%;text-align: center;padding: 5px;">'+getDMSTranslation('NO_ITEMS_TO_SHOW')+'</div>'
    	}]
    }]
});