Ext.define('Academia.view.DMSView.EditSiteStructure', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.editsitestructure',
    autoScroll:true,
	layout: 'border',
	width: '100%',
    height: 700,
    cls:'horizontalScrollingFixed editsitestructureCls' ,
    margin: 0,
    padding: 0,
    bodyStyle:{
    	outline: '2px solid rgb(224, 224, 224);'
    },
    tbar : [{
    	xtype: 'label',
    	itemId: 'siteNameField',
    	style:{
    		'font-size': '18px',
    		'margin-top': '-6px'
    	}
    },{
    	xtype: 'label',
    	itemId: 'siteVisibility',
    	style:{
    		'font-size': '13px',
    		'margin-top': '-6px',
    		'border': '1px solid rgb(214, 233, 198)',
    		'background': '#dff0d8',
    		'border-radius': '2px',
    		'padding': '3px',
    		'cursor': 'help'
    	}
    },{
    	xtype: 'label',
    	html: '<span id="fav">★</span>',
    	cls: 'starLabel',
    	itemId: 'starLabel',
    	listeners: {
    		render: function(c){
    			c.getEl().on('click', function(){
    				var siteId = this.up('editsitestructure').siteId;
            		$('.starLabel span').each(function(index) {
            			var me = this;
            			if(Ext.query('.starLabel span')[0].classList.contains("selected")){
            				var url=SERVERURL.PATH_REMOVE_SITE_FROM_FAVORITE+'?site='+siteId;
            			}
            			else{
            				var url=SERVERURL.PATH_ADD_SITE_TO_FAVORITE+'?site='+siteId;
            			}
            			Ext.Ajax.request({
            				type : 'rest',
            				url : url,
            				headers : {
           	    				'Content-Type' : 'application/json'
           	    			},
            				method : 'POST',
            				success : function(response) {
                    			$(me).toggleClass('selected');
            				}
            			});
            			
            		});
    			}, c);
    		}
    	}
    },{
    	xtype: 'tbspacer',
    	flex:1
    },
    {
    	xtype: 'button',
    	text: getDMSTranslation('Site Dashboard'),
    	cls: 'segmentBtnCls',
    	itemId: 'siteDashboardBtnItemId'
    },
    {
    	xtype: 'button',
    	text: 'Document Library',
    	cls: 'segmentBtnCls',
    	itemId: 'documentLibraryBtnItemId'
    },
    {
    	xtype: 'button',
    	text: 'Site Members',
    	cls: 'segmentBtnCls',
    	itemId: 'siteMembersBtnItemId'
    },
    {
    	xtype: 'button',
    	iconCls:'dms-add-user-icon',
    	itemId: 'editSiteAddUserBtnItemId',
    	hidden: true
    },
    {
    	xtype: 'splitbutton',
    	iconCls:'dms-setting-icon',
    	menu: [{
    		text: 'Customize Dashboard',
    		iconCls:'dms-setting-icon',
    		itemId: 'settingCustomizeDashboardMenuBtnItemId'
    	},{
    		text: 'Edit Site Details',
    		iconCls:'dms-setting-icon',
    		itemId: 'editDmsSiteDetailsItemId'
    	},{
    		text: 'Customize Site',
    		iconCls:'dms-setting-icon',
    		itemId: 'settingCustomizeSiteMenuBtnItemId'            	
    	},{
    		text: 'Delete Site',
    		iconCls:'dms-setting-icon',
    		itemId: 'settingDeleteSiteMenuBtnItemId'            	
    	},{
    		text: 'Leave Site',
    		iconCls:'dms-setting-icon',
    		itemId: 'settingLeaveSiteMenuBtnItemId'            	
    	}]
    }
    ],
    items: [{
        region:'west',
        xtype: 'panel',
        width: 320,
        collapsible: false,
        padding:0,
        layout: 'fit',
        items:[{
        	xtype: 'sitedashboardsidepanel',
        }]
    },{
        region: 'center',
        xtype: 'panel',
        border:  false,
        frame: false,
        itemId:'siteCenterPanel',
        cls: 'siteCenterPanelCls',
        autoScroll: false,
        height: 600,
        items:[{
        	xtype: 'sitedashboardcenterpanel',
        }]
    }]
});