Ext.define('Academia.view.DMSView.EditWorkflowPanel', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.editworkflowpanel',
    margin: 0,
    autoScroll: true,
    frame: true,
    border: true,
    height: 580,
    items:[{
    	xtype: 'form',
    	itemId: 'editWorflowInnerPanelItemId',
    	cls: 'workflowInnerPanelCls',
    	defaults: {
			labelAlign: 'top',
    		width: 800
		},
    	items:[{
    		xtype: 'hiddenfield',
    		name: 'activityId',
    		itemId: 'activityIdItemId'
    	},{
    		xtype: 'fieldset',
    		title: getDMSTranslation('INFO'),
    		defaults: {
    			labelAlign: 'left',
    			labelWidth: 80
    		},
        	layout: 'column',
    		items:[{
    			xtype: 'displayfield',
    			itemId: 'messageDisplayFieldItemId',
    			name: 'messageDisplayField',
    			fieldLabel: getDMSTranslation('MESSAGE'),
        		columnWidth: 1,
        		maxLength: 250
    		},{
    			xtype: 'displayfield',
    			itemId: 'ownerDisplayFieldItemId',
    			name: 'ownerDisplayField',
    			fieldLabel: getDMSTranslation('OWNER'),
        		columnWidth: 0.30
    		},{
    			xtype: 'displayfield',
    			hideLabel: true,
    			value: '',
    			columnWidth: 0.05
    		},{
    			xtype: 'displayfield',
    			itemId: 'priorityDisplayFieldItemId',
    			name: 'priorityDisplayField',
    			allowBlank: true,
    			fieldLabel: getDMSTranslation('PRIORITY'),
        		columnWidth: 0.30
    		},{
    			xtype: 'displayfield',
    			hideLabel: true,
    			value: '',
    			columnWidth: 0.05
    		},{
    			xtype: 'displayfield',
    			itemId: 'dueDateDisplayFieldItemId',
    			name: 'dueDateDisplayField',
    			fieldLabel: getDMSTranslation('DUE'),
        		columnWidth: 0.30,
        		format: "Y-m-d"
    		},{
    			xtype: 'displayfield',
    			itemId: 'identifierDisplayFieldItemId',
    			name: 'identifierDisplayField',
    			fieldLabel: getDMSTranslation('IDENTIFIER'),
        		columnWidth: 0.30
    		}]
    	},{
    		xtype: 'fieldset',
    		title: getDMSTranslation('PROGRESS'),
    		defaults: {
    			labelAlign: 'left',
    			labelWidth: 80
    		},
        	layout: 'column',
    		items:[{
        		xtype: 'customcombobox',
        		name: 'statusField',
        		itemId: 'statusFieldItemId',
        		fieldLabel: getDMSTranslation('STATUS'),
        		valueField: 'id',
    			displayField: 'value',
    			store: new Ext.data.ArrayStore({
    	    		id: 0,
    	    		fields: ['value'],
    				data: ['Not Yet Started','In Progress','On Hold','Cancelled','Completed']  // data is local
    	    	}),
    			queryMode: 'local',
    			editable: false,
    			allowBlank: false
        	}]
    	},{
    		xtype: 'fieldset',
    		title: getDMSTranslation('ITEMS'),
    		frame: true,
    		border: true,
    		defaults: {
    			labelAlign: 'top',
    			labelWidth: 80
    		},
        	layout: 'column',
    		items:[{
        		xtype: 'dataview',
        		itemId: 'editWorkflowDocumentItemId',
        		autoScroll: true,
    			columnWidth: 1,
        		store: Ext.create('Ext.data.ArrayStore',{
            		id: 0,
            		fields: ['type','img','fileName','action','time','displayTime','userName','version','size','displayVersion','folderPath','nodeRef', 'isLocked', 'lockedByUsername', 'lockedByDisplayName', 'role', 'activeWorkflows'],
        			data: []
            	}),
            	itemSelector: 'div.thumb-wrap-document-workflow',
        		tpl: new Ext.XTemplate(
    		    	   '<tpl for=".">',
    			            '<div class="thumb-wrap-document-workflow" >',
    			            	'<img src="{img}" />',
    			            	'<div class="listItem">',
    				            	'<span style="color: #333;cursor: pointer;font-size: 14px;display: inline-block;float: left;width: 80%;" class="fileNameSpan">{fileName}</span>',
    				            	'<span style="float:left;" title="{displayTime}">{action} {time} ago by {userName}</span>',
    			            	'</div>',
    			            '</div>',
    			        '</tpl>'
    		    ),
    		    emptyText: '<div style="float: left; width: 100%;text-align: center;padding: 5px;">'+getDMSTranslation('NO_ITEMS_TO_SHOW')+'</div>'
        	}]
    	},{
    		xtype: 'fieldset',
    		title: getDMSTranslation('RESPONSE'),
    		defaults: {
    			labelAlign: 'top',
    			labelWidth: 80
    		},
        	layout: 'column',
    		items:[{
        		xtype: 'textarea',
        		name: 'commentField',
        		itemId: 'commentFieldItemId',
        		fieldLabel: getDMSTranslation('COMMENT'),
        		width: 780
        	}]
    	},{
    		xtype: 'fieldset',
    		frame: true,
    		border: true,
    		defaults: {
    			labelAlign: 'top'
    		},
        	layout: 'hbox',
    		items:[{
    			xtype: 'button',
    			text: getDMSTranslation('APPROVE'),
    			itemId: 'approveWorkflowBtnItemId',
    			ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
    			hidden: true
    		},{
    			xtype: 'button',
    			text: getDMSTranslation('REJECT'),
    			itemId: 'rejectWorkflowBtnItemId',
    			ui:'CustomBtnSubmit',
    			scale: CONSTANTS.BUTTONSIZE,
    			hidden: true
    		},{
    			xtype: 'button',
    			text: getDMSTranslation('TASK_DONE'),
    			itemId: 'taskDoneBtnItemId',
    			ui:'CustomBtnSubmit',
    			scale: CONSTANTS.BUTTONSIZE,
    			hidden: true
    		}]
    	},{
    		xtype: 'fieldset',
    		frame: true,
    		border: true,
    		defaults: {
    			labelAlign: 'top'
    		},
        	layout: 'hbox',
    		items:[{
    			xtype: 'button',
    			text: getDMSTranslation('SAVE_AND_CLOSE'),
    			itemId: 'saveAndCloseEditWorkflowBtnItemId',
    			ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
    			hidden: true
    		},{
    			xtype: 'button',
    			text: getDMSTranslation('CANCEL'),
    			itemId: 'cancelEditWorkflowBtnItemId',
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
    		}]
    	}]
    }]
});