
Ext.define('Academia.view.DMSView.SiteSearchForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.sitesearchform',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'student',
			itemId:'student',
			width:226,
			fieldLabel: getDMSTranslation('SEARCH'),
			store: Ext.create('Academia.store.DMSStore.DMSSiteSearchStore'),
			valueField: 'shortName',
			displayField: 'title',
			queryParam:'site',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			emptyText: getDMSTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			//allowBlank : false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getDMSTranslation('SEARCHING'),
				emptyText: getDMSTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		}]
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getDMSTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getDMSTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}


	]
});
