/**
 * This Grid is used for Quota Type Applicability Grid from the Quota Type applicability tab
 *  of the configure Combination tab of the admission Cycle
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.admission.admissionCycle.QuotaTypeApplicabilityGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.quotatypeapplicabilitygrid',
    title : getAdmissionTranslation('QUOTA_TYPE_APPLICABILITY'),
	border : true,
	cls:'panelNoSpace',
	store: 'Academia.store.admission.admissionCycle.QuotaTypeApplicabilities',
	
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	 selType: 'cellmodel',
     plugins: [
        Ext.create('Ext.grid.plugin.CellEditing', {
            clicksToEdit: 1
        })
     ],
	columns: [{
		xtype: 'rownumberer',
		flex: 0.05
	},{
		text : getAdmissionTranslation('PRIORITY'),
        dataIndex: 'priority',
        hidden:true
	},{
		text : getAdmissionTranslation('QUOTA_TYPE_ID'),
        dataIndex: 'quotaTypeId',
        hidden:true
	},{
		text : getAdmissionTranslation('QUOTA_TYPE'),
		dataIndex: 'quotaType',
		flex:0.4,
		sortable : false
	}, {
		xtype : 'checkcolumn',
	     inputValue :true,
         uncheckedValue : false,
		text : getAdmissionTranslation('MANDATORY'),
		dataIndex : 'whetherMandatory',
		flex: 0.1,
		sortable : false,
		renderer: function(value, metadata,record) {
			if (metadata.recordIndex != 0) {
				 metadata.style+= ' opacity:0.3';
				 value=false;
				 if(record.data.whetherMandatory)
					 record.set(this.dataIndex, false);
			 }
			
			 var cssPrefix = Ext.baseCSSPrefix,
			 cls = cssPrefix + 'grid-checkcolumn';
			 if (value) {
					cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
				}
				return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
		},
		processEvent: function(type, view, cell, recordIndex, cellIndex, e) {
			var me = this;
			if (type == 'mousedown' || (type == 'keydown' && (e.getKey() == e.ENTER || e.getKey() == e.SPACE))) {
				var record = view.panel.store.getAt(recordIndex);
				if (recordIndex == 0) {
					dataIndex = this.dataIndex;
					checked = !record.get(dataIndex);
					record.set(dataIndex, checked);
					me.fireEvent('checkchange', me, recordIndex, checked);
				}
				return false;	
			}
		}
		
	}, {
		text : getAdmissionTranslation('DISTRIBUTION_BASIS'),
		dataIndex : 'distributionBasis',
		flex: 0.15,
		sortable : false,
		renderer:function(value) {
			return getAdmissionTranslation(value);
		},
		editor: {
            xtype: 'customcombobox',
            allowBlank: false,
            triggerAction: 'all',
            selectOnTab: true,
            store: [
                ['SEATS', getAdmissionTranslation('SEATS')],
                ['PERCENTAGE', getAdmissionTranslation('PERCENTAGE')]
            ],
            lazyRender: true
        }
	},{
        xtype:'actioncolumn',
        text : getAdmissionTranslation('PRIORITY'),
        flex: 0.1,
        width:50,
        sortable : false,
        items: [{
        	xtype: 'button',
        	itemId: 'upButton',
        	iconCls: Ext.baseCSSPrefix + 'form-itemselector-up',  // Use a URL in the icon config
            tooltip: 'UP',
            handler: function(grid, rowIndex, colIndex) {
            	if(rowIndex != 0) {
	            	var record = grid.getStore().getAt(rowIndex);
	            	var previousRecord = grid.getStore().getAt(rowIndex-1); 
	            	previousRecord.set('priority', (previousRecord.get('priority'))+1);
	            	record.set('priority', (record.get('priority'))-1);
	            	grid.getStore().sort();
	            	
	            	grid.getStore().remove(record, true);
                    grid.getStore().insert(rowIndex-1, record);
                    grid.getStore().remove(previousRecord, true);
                    grid.getStore().insert(rowIndex, previousRecord);
            	} else {
            		showErrorMessage(getCommonTranslation('REORDER'), getErrorTranslation('UPERRORMESSAGE'));
            	}
            }
        },{
        	xtype: 'button',
        	itemId: 'downButton',
        	iconCls: Ext.baseCSSPrefix + 'form-itemselector-down',
            tooltip: 'DOWN',
            handler: function(grid, rowIndex, colIndex) {
            	lastRowIndex = grid.getStore().getCount()-1;
            	if(rowIndex != lastRowIndex) {
	            	var record = grid.getStore().getAt(rowIndex);
	            	var nextRecord = grid.getStore().getAt(rowIndex+1); 
	            	nextRecord.set('priority', (nextRecord.get('priority'))-1);
	            	record.set('priority', (record.get('priority'))+1);
	            	
	            	grid.getStore().remove(record, true);
                    grid.getStore().insert(rowIndex+1, record);
                    grid.getStore().remove(nextRecord, true);
                    grid.getStore().insert(rowIndex, nextRecord);
            	} else {
            		showErrorMessage(getCommonTranslation('REORDER'), getErrorTranslation('DOWNERRORMESSAGE'));
            	}
            }
        }]
	}],
	 
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
        	displayInfo : true,		 
        	emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
			store : 'Academia.store.admission.admissionCycle.QuotaTypeApplicabilities'
        }]
    }],
    
    tbar : [{
		xtype : 'button',				
		itemId : 'btnSaveQuotaType',
		text: getCommonTranslation('SAVE')
	}]
});