Ext.define('Academia.view.admission.applicationFollowUpReport.ApplicationFollowUpDashboardGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	title: getCommonTranslation('ADM_APPLICATION_FOLLOWUP_DASHBOARD'),
	alias : 'widget.applicationfollowupdashboardgrid',
	store: 'reports.applicationreport.ApplicationFollowupListStore',
	border: true,
	enableColumnHide : false,
	refreshStoreData:true,
	autoScroll: false,
	frame: false,
	isGridConfigurable: true,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'applicationfollowupdashboardform':1
		}},
		dockedItems : [ {
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store: 'reports.applicationreport.ApplicationFollowupListStore',
				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}
		],
		initComponent: function() {
			var grid = this;
			grid.addExportToolBarItems(grid, false);
			this.callParent(arguments);
		},

		columns: [
			{
				header: getCommonTranslation('APPLICATION_ID'),
				dataIndex: 'applicantCode',
				flex: 1,
				sortable: true,
				renderer : function(value) {
					return '<a href="#">' + value + '</a>';
				}
			},
			{
				header :getCommonTranslation('APPLICATION_DATE'),
				dataIndex : 'applicationDate',
				flex:1,
				renderer:function(date) {
					return dateRender(date);
				}
			},
			{
				header: getCommonTranslation('APPLICANT_NAME'),
				dataIndex: 'applicantName',
				flex: 1,
				sortable: true
			},
			{
				header: getAdmissionTranslation('ACADEMY_LOCATION'),
				dataIndex: 'academyLocationName',
				flex: 1,
				sortable: true
			},
			{
				header: getCommonTranslation('REGISTRATION_TYPE'),
				dataIndex: 'registrationType',
				flex: 1,
				sortable: true,
				renderer : function(value) {
					if(!isNullOrEmpty(value))
					{
						if(value==false)
						{
							return 'Full Time';
						}
						else
						{
							return 'Part Time';
						}
					}
				}
			},
			{
				header: getCommonTranslation('PROGRAM'),
				dataIndex: 'programName',
				flex: 1,
				sortable: true
			},{
				header: getCommonTranslation('BATCH'),
				dataIndex: 'batchName',
				flex: 1,
				sortable: true
			},
			{
				header: getCommonTranslation('OWNER'),
				dataIndex: 'assignToUserName',
				flex: 1,
				sortable: true
			},
			{
				header:  getCommonTranslation('APPLICATION_STATUS'),
				dataIndex: 'applicationStatus',
				flex:1,
				sortable:true
			},
			{
				header: getCommonTranslation('PRIORITY'),
				dataIndex: 'priorityName',
				flex: 1,
				sortable: true
			},
			{
				header :getCommonTranslation('FOLLOW_UP_DATE'),
				dataIndex : 'actualFollowUpDate',
				flex:1,
				renderer:function(date) {
					return dateRender(date);
				}
			},
			{
				header : getCommonTranslation('REASON_FOR_FOLLOW-UP'),
				dataIndex : 'reasonForFollowUp',
				flex:1,
				sortable:true
			},
			{
				header : getCommonTranslation('FOLLOW_UP_ACTIVITY_STATUS'),
				dataIndex : 'followUpActivityStatus',
				flex:1,
				sortable:true
			},
			{
				header :getCommonTranslation('FOLLOW_UP_SCHEDULE'),
				dataIndex : 'followUpDate',
				flex:1,
				renderer:function(date) {
					return dateRender(date);
				}
			}
			]
});