/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show search result of list of enquires in Dialog box
 */
Ext.define('Academia.view.admission.applicationFormSale.SearchApplicantWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.searchapplicantwindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    height: (Ext.isIE8) ? 600 : '65%',
    width: (Ext.isIE8) ? 600 : '65%',
    title: getAdmissionTranslation('SEARCH_RESULT'), //Search Result
    items: [{
        xtype: 'grid',
        itemId: 'searchEnquirerGrid',
        title: getAdmissionTranslation('LIST_OF_ENQUIRERS'), //List Of enquirers
        viewConfig: {
            stripeRows: CONSTANTS.STRIPEROWS
        },
        border: true,
        autoScroll: true,
        columns: []
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        style :{marginLeft: '8px'},
        items: [{
            xtype: 'button',
            text: getAdmissionTranslation('IMPORT'), //Import
            itemId: 'importBtn',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            action: 'cancel',
            ui: 'CustomBtnCancel',
            itemId: 'cancelBtn',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});