/**
 * @author trupti.paoneker
 * 
 * This component is used for to show window with confirmed or denied status of Admission details. 
 * 
 */
Ext.define('Academia.view.admission.applications.admissionAndMidTermAdmission.ConfirmOrDenyAdmissionWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.confirmordenyadmissionwindow',
    modal: true,
    resizable: false,
    title: getAdmissionTranslation('PROVISIONAL_ADMISSION_CLOSURE'), //Provisional Admission Closure
    margin: 0,
    items: [{
        xtype: 'form',
        itemId: 'confirmordenyadmissionForm',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'confirmordenyadmission_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'version'
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'vbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'radiogroup',
                fieldLabel: getAdmissionTranslation('CONCLUSION_PROVISIONAL_ADM'), //Conclusion of Provisional Admission 
                name: 'RADIO_Btn',
                //allowBlank: false,
                layout: {
                    type: 'hbox'
                },
                items: [{
                    boxLabel: getAdmissionTranslation('CONFIRMED'), //Confirmed
                    name: 'conclusion',
                    inputValue: 'CONFIRMED',
                    checked: true
                }, {
                    boxLabel: getAdmissionTranslation('DENIED'), //Denied
                    name: 'conclusion',
                    inputValue: 'DENIED'
                }]
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            items: [{
                fieldLabel: getAdmissionTranslation('REASON'), //Reason
                xtype: 'textarea',
                itemId: 'provisionalAdmissionClosureReason',
                name: 'provisionalAdmissionClosureReason',
                labelAlign: 'top',
                allowBlank: false
            }]
          }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
	            xtype: 'button',
	            itemId: 'btnSaveConfirmOrDenyAdmissionForm',
	            text: getCommonTranslation('SAVE'), //Save
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind: true,
	            hasDisableForProfileViewMode:true
	        }, {
	            xtype: 'button',
	            itemId: 'btnCancelConfirmOrDenyAdmissionForm',
	            text: getCommonTranslation('CANCEL'), //Cancel
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        }]
        }]
    }]
});