/**
 * @author <a href="mailto:gajendra.verma@serosoft.in">Gajendra Verma</a>
 * 
 */
Ext.define('Academia.view.admission.applications.applicationBase.ApplicantCompetitivePastHistoryloaderDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.applicantcompetitivepasthistoryloaderdownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{

		xtype:'fieldcontainer',
		items:[{
			xtype : 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name:'templateType',
				itemId:'templateTypeItemId',
				store:'importutility.ImportApplicantPastHistoryTypeStore',
				fieldLabel : getProgramandcourseTranslation('TEMPLATE_FOR'),	
				valueField: 'name',
				displayField: 'value',
				typeAhead:false,
				allowBlank:false,
				forceSelection: true,
				editable: false,
				maxLength: 40,
			}]
		}]
	},{
		xtype:'fieldcontainer',
		itemId:'programBatchContainerId',
		items:[{
			xtype:'fieldcontainer',
			items:[{
				xtype : 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					labelAlign: 'top'
				},
				items : [{	
					xtype: 'customcombobox',
		            itemId: 'examPassed',
		            fieldLabel: getPersonModuleTranslation('EXAM_PASSED'),
		            store: 'common.ExamPassedStore',
		            valueField: 'id',
		            displayField: 'value',
		            name: 'examPassed',
		            editable : false,
		            hidden: true,
		            allowBlank:true,
		            hideTrigger:false,
		            triggerAction: 'all',
		            forceSelection:true,
		            width:200,
		            matchFieldWidth:true
		            },
		            {
		            xtype: 'customcombobox',
		            itemId: 'examBoard',
		            fieldLabel: getPersonModuleTranslation('EXAM_BOARD'),
		            store: 'common.ExamBoardStore',
		            valueField: 'id',
		            displayField: 'value',
		            name: 'examBoard',
		            editable : false,
		            hidden: true,
		            allowBlank:true,
		            hideTrigger:false,
		            triggerAction: 'all',
		            forceSelection:true,
		            width:200,
		            matchFieldWidth:true
		            }]
			}]
		}, {
			xtype : 'fieldcontainer',
			width: '100%',
			itemId:'programBatchContainer',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'PROGRAM_NAME',
				itemId: 'program',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				width:410,
				minChars:3,
				queryParam:'programName',
				matchFieldWidth:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
						combo.bindStore(store);
					},
					select:function(obj,record){

						var programId = record[0].get("id");
						var  batch = obj.nextSibling();
						var  period = batch.nextSibling();

						batch.setDisabled(false);
						batch.reset();

						period.setDisabled(true);
						period.reset();

						var store = batch.getStore();

						store.proxy.extraParams = {
								id : programId
						};
						store.load();
					}
				},
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'BATCH_NAME',
				itemId: 'batch',
				fieldLabel: getPersonModuleTranslation('BATCH'),
				disabled:true,
				editable: false,
				queryMode: 'local',
				displayField: 'value',
				valueField: 'id',
				matchFieldWidth:true,
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
						combo.bindStore(store);
					},
					select:function(obj,record){
						var batchId = record[0].get("id");
						var seatType= obj.nextSibling();

						seatType.setDisabled(false);
						seatType.reset();

						var store = seatType.getStore();

						store.proxy.extraParams = {
								id : batchId
						};
						store.load();

					}
				}
			},{
				xtype: 'customcombobox',
				itemId:'seatType',
				disabled:true,
				editable: false,
				displayField: 'value',
				valueField: 'id',
				queryMode: 'local',
				fieldLabel: getEnquiryTranslation('SEAT_TYPE'),
				name: 'SEAT_TYPE',
				matchFieldWidth:true,
				listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.enquiry.ProgramBatchSeatTypeStore');
						combo.bindStore(store);
					}
				}
			}]
		}]},{
			xtype:'fieldcontainer',
			layout : 'hbox',
			items:[{
				xtype: 'fieldcontainer',
				width: 'auto',
				items: [{
					xtype: 'button',
					text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
					itemId: 'programBatchDownolad',
					hidden:false,
					ui: 'CustomBtnSubmit'
				},{
					xtype: 'button',
					text: getCourseTxCommonTranslation('RESET'),
					itemId: 'resetBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]}]});
