/**
 * @author prathamesh.sheth
 * 
 * This component is used for to search applicants  
 */
Ext.define('Academia.view.admission.applications.applicationBase.ApplicantSearchComponent', {
    extend: 'Academia.view.common.DynamicFieldForm',
    alias: 'widget.applicantsearchcomponent',
    items: [{
        xtype: 'panel',
        itemId: 'searchComponent',
        autoScroll: false,
        layout: {
            type: 'vbox'
        },        
        items: [{
            xtype: 'customcombobox',
            name: 'applicationType',
            itemId: 'cmbApplicationType',
            store: 'admission.applicationFormSale.ApplicantTypeStore',
            fieldLabel:getAdmissionTranslation('APPLICANT_TYPE'),   //Applicant Type
            labelAlign:'top',
            valueField: 'name',
            displayField: 'value',
            editable: false,
            width: 'auto',
            queryMode: 'local',
            value: 'FRESH_APPLICANT',
            allowBlank: false,
            width: 164
        }, {
            xtype: 'fieldcontainer',
           // fieldLabel:getAdmissionTranslation('SEARCH_CRITERIA'), //Search Criteria
            labelAlign:'top',
            itemId: 'searchCriteriaPanel',
            hidden:true,
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width:  200
            },            
            items: [{
                xtype: 'customcombobox',
                name: 'enqId',  //Enquiry ID	
                itemId: 'enqId',
                hidden: true,
                store :Ext.create('Academia.store.enquiry.OpenEnquiryCodeSearchAccessibleALStore'),
                fieldLabel: getAdmissionTranslation('ENQUIRY_ID'),
				valueField: 'id',
				displayField: 'code',
				queryParam:'codeOrName',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}

			}, {
				xtype: 'customcombobox',
				name: 'enqName',
				itemId: 'enqName',
				hidden: true,
				store :Ext.create('Academia.store.enquiry.EnquiryStudentSmartSearchAccessibleALStore'),
				fieldLabel: getAdmissionTranslation('STUDENT_NAME'), //Enquirer Name 	
				valueField: 'id',
				displayField: 'value',
				queryParam:'codeOrName',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			/*  xtype: 'customcombobox',
                name: 'enqName',
                itemId: 'enqName',
                hidden: true,
                fieldLabel: getAdmissionTranslation('STUDENT_NAME') //Enquirer Name 	*/ 				
			}, {
				xtype: 'numberfield',
				name: 'enqContactNo',
				itemId: 'enqContactNo',
				hideTrigger: true,
				hidden: true,
				fieldLabel: getAdmissionTranslation('CONTACT_NO') //Contact No.
			}, {
				xtype: 'textfield',
				name: 'enqEmailId',
				itemId: 'enqEmailId',
				hidden: true,
				fieldLabel: getAdmissionTranslation('EMAIL_ID') //Email ID
			}, {
				xtype: 'customcombobox',
				name:'appId',
				itemId:'appId',
				store:'admission.applications.applicantProfileBase.ApplicantSmartSearchStore',
				fieldLabel:getAdmissionTranslation('APPLICANT_ID_NAME'),
				width:226,
				valueField: 'code',
				displayField: 'printName',
				queryParam:'codeOrName',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				hidden: true,
				triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            forceSelection:true,
				  listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code}/{printName}'  +
		                    '</div>';
		                }
		            }
			}, {
				xtype: 'textfield',
				name: 'appEmailId',
				itemId: 'appEmailId',
				hidden: true,
				vtype: 'email',
				fieldLabel: getAdmissionTranslation('EMAIL_ID')
			}, {
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('ID_TYPE'),
				itemId: 'idTypeCombo',
				store: 'common.IDTypeStore',
				valueField: 'id',
				displayField: 'idTypeName',
				name: 'idTypeCombo',
				width: 226,
				hidden: true,
				editable: false
			}, {
				xtype: 'customcombobox',
				name:'nationalId',
				itemId:'nationalId',
				store:'common.FindAllNationalIdsStore',
				fieldLabel:getAdmissionTranslation('ID_NUMBER'),
				width:226,
				valueField: 'value',
				displayField: 'value',
				queryParam:'value',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				hidden: true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			}, {
				xtype: 'textfield',
				name: 'studentId',
				itemId: 'studentId',
				hidden: true,
				fieldLabel: getAdmissionTranslation('STUDENT_ID') //Student Id
			},{
				xtype: 'button',
				defaultAlign: 'right',
				text: getAdmissionTranslation('SEARCH'), //Search                
				itemId: 'searchBtn',
				width: 'auto',                
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE     ,
				style : {
					marginTop : '29px'
				}
			}]
		}]
	}]
});