/**
 * @author Amit G
 */
Ext.define('Academia.view.admission.applications.applicationBase.ApplicationConditionsDocumentList', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.applicationconditionsdocumentlist',
    title: getCommonTranslation('LIST_OF_APPLICABLE_DOCUMENTS'),
    border: true,
    autoScroll: false,
    columnLines : true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	tbar: [{
		xtype: 'button',
		itemId: 'btnUploadDocument',
		text: getAdmissionTranslation('UPDATE_DOCUMENTS'),
		tooltip: getAdmissionTranslation('UPDATE_DOCUMENTS'),
		buttonAlign: 'left',
	}],
    columns: [ {
    	xtype: 'rownumberer',
        header: getCommonTranslation('SNO'),
        dataIndex: 'sNO',
        sortable: true,
        align: 'center',
        flex: .1
    }, {
        header: getDocumentTranslation('DOCUMENT_NAME'),
        dataIndex: 'value',
        //align: 'center',
        sortable: true,
        flex: .2
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.document.DocumentConditionalOfferLetterPendingStore');
    }
});