var targetedCell = -1;
var checkCell = -1;
Ext.define('Academia.view.admission.applications.applicationBase.ApplicationDetailsCheckListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.applicationdetailschecklistgrid',
	title: getAdmissionTranslation('APPLICATION_CHECKLIST_GRID'),
	border: true,
	selType:'checkboxmodel',
	viewConfig: {
		listeners: {
			cellclick: function(view, cell, cellIdx, record, row, rowIdx, eOpts) {
				if(cell.classList.contains('x-grid-cell-row-checker')){
					checkCell = cellIdx;
				}
				targetedCell = cellIdx;
			}
		}
	},
	store: 'admission.applicationFormSale.ApplicationCheckListDetailStore',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		injectCheckbox:5,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		},
		listeners: {
			beforedeselect: function (thisSelModel, record, idx, eOpts) {
				if(targetedCell != checkCell) {
					return false;
				}
				return true;
			}
		}
	},
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'admission.applicationFormSale.ApplicationCheckListDetailStore',
			displayInfo: true,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,

		}]
	}],
	tbar : [{
		xtype : 'button',				
		itemId : 'saveRemark',
		text : getCommonTranslation('SAVE'),
		buttonAlign: 'left',
		cls: 'CustomBtnSubmit',
		scale: CONSTANTS.BUTTONSIZE
	}],
	columns : [{
		xtype: 'rownumberer',
		header : getCommonTranslation('SERIAL_NO'),
		dataIndex : 'serialNo',
		flex: 0.04
	},{
		header: getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocation',
		hidden:true,
		flex: .2
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'program',
		flex :.2,
		hidden:true,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}

		}
	},{
		header: getCommonTranslation('SEAT_TYPE'), 
		dataIndex: 'seatType',        
		flex: 0.1,
		hidden:true,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
		}
	},{
		header: getCompletionModuleTranslation('CHECKLIST_ITEM'),
		dataIndex: 'checkListItem',
		sortable: true,
		flex : 0.1
	},{
		dataIndex : 'status',
		flex: 0.1,
		align: 'left',
		header: getAdmissionTranslation('STATUS'),
		disabledCls : 'x-item-enabled',
		defaultValue: false,
		hideable: false,
		columnHeaderCheckbox: true,
		renderer : function(value){
			value = '';
		}
	},
	{  
		header: getProgramandcourseTranslation('REMARKS'),
		dataIndex: 'remark',
		flex:.2,
		sortable: false,
		getSortParam: Ext.emptyFn,
		editor : {
			xtype: 'textfield',
			name: 'coverageRemarks',
			itemId: 'coverageRemarksItemId',
			maxLength:254
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
				rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
				rec.tdCls ="assign-remark-column-cls";
				return val;
			}
		}}],
		plugins: [
			Ext.create('Ext.grid.plugin.CellEditing', {
				clicksToEdit: 1
			})]
});