/**
 *  Dharmendra.p
 */

Ext.define('Academia.view.admission.applications.applicationBase.ReassignApplicationForm', {
	extend: 'Ext.window.Window',
	alias: 'widget.reassignapplicationform',
	autoScroll: true,
	title:getAdmissionTranslation('REASSIGN_APPLICATION'),
	modal:true,
	frame: true,
	items: [{
		xtype: 'idgeneratorformwin',

		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			//width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'

		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{  
				xtype: 'hidden',
				name: 'id'
			},{
				xtype: 'customcombobox',
				name: 'applicationOwner',
				itemId:'applicationOwner',
				 store: Ext.create('Academia.store.enquiry.FollowUpUserWithDepartment'),
				 fieldLabel: getAdmissionTranslation('APPLICATION_REASSIGN_TO'),
				 valueField: 'id',
				 displayField: 'value',
				 queryParam:'name',
				 minChars:3,
				 editable:true,
				 typeAhead:true,
				 triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				 enableKeyEvents  : 'true',
				 hideTrigger:false,
				 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				 triggerAction: '',
				 forceSelection:true,
				 allowBlank:false,
				 listConfig: {
					 listeners: {
						 beforeshow: function(picker) {
							 picker.minWidth = picker.up('combobox').getSize().width;
						 }
					 },
					 loadingText: getCommonTranslation('SEARCHING'),
					 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					 getInnerTpl: function() {
						 return '<div class="search-item">' +
						 '{value}'+
						 '</div>';
					 }
				 }
			 },{
				xtype: 'datefield',
				name: 'reassignOwnerdate',
				maxValue: new Date(),
				fieldLabel: getAdmissionTranslation('APPLICATION_REASSIGNMENT_DATE'),
				listeners: {
					render: function(field) {
						dateFormatRender(field);
						field.setValue(new Date());
					}
				}
			},
			]
		},{
			xtype: 'fieldcontainer',
			layout: 'vbox',
			defaults: {
				labelAlign: 'top',
				width: 460
			},
			items: [{
				xtype: 'checkboxfield',
				itemId : 'sendReassignNotificationField',
				name :  'sendReassignNotificationField',
				labelAlign: 'right',
				region: 'south',
				style: {
					marginTop: '15px'
				},
				boxLabel: getCommonTranslation('SEND_REASSIGN_NOTIFICATION'),
				name: 'sendReassignNotification',
				inputValue: true,
				uncheckedValue: false,
				checked:true
 			},{
				xtype: 'textarea',
				name: 'reassignOwnerRemark',
				itemId: 'remarkItemId',
				fieldLabel: getAdmissionTranslation('APPLICATION_REASSIGNMENT_REASON')
			}]
		},
		{
			border : false,

			layout : {
				type : 'hbox',
				width : '100%'
			},
			style:{
				marginLeft:'0px'
			},
			items: [{

				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'ard_submitbuttonId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			}, {	
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId:'ard_cancelbuttonId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});