/**
 * @author Amandeep Bhatia
 */
Ext.define('Academia.view.admission.applications.applicationBase.ReviewDetailsPanel', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.reviewdetailspanel',
	title: getAdmissionTranslation('REVIEW_DETAILS'),
	border: true,
	refreshStoreData: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
	},
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: []
		});
		this$.callParent(arguments);
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode: true
	}],
	columns: [{
		header: getCommonTranslation('REVIEWER'),
		dataIndex: 'reviewer',
		sortable: true,
		flex: 0.7,
		renderer: function(value) {
			return !isNullOrEmpty(value) ? value : '';
		}
	}, {
		header: getAdmissionTranslation('REVIEW_PARAMETER'),
		dataIndex: 'reviewParameter',
		menuDisabled: true,
		flex: 0.7,
		editor: {
			xtype: 'customcombobox',
			name: 'reviewParameterId',
			itemId: 'reviewParameterId',
			valueField: 'value',
			displayField: 'value',
			forceSelection: true,
			triggerAction: 'all',
			store: Ext.create('Academia.store.admission.applications.applicationReviewer.ReviewParamaterComboStore'),
			listeners: {
				select: function(combo, records) {
					var grid = combo.up('grid');
					var selectedRecord = grid.getSelectionModel().getSelection()[0];
					var selected = records[0];
					var duplicateFound = false;

					grid.getStore().each(function(rec) {
						if (rec !== selectedRecord && rec.get('reviewParameterId') === selected.get('id')) {
							duplicateFound = true;
							return false;
						}
					});

					if (duplicateFound) {
						combo.setValue(null);
						combo.setRawValue('');
						showWarningMessage(getCommonTranslation('ALERT'), getAdmissionTranslation('REVIEW_PARAMETER_ALREADY_SELECTED'));
						return false;
					}

					selectedRecord.set('reviewParameterId', selected.get('id'));
					selectedRecord.set('reviewParameter', selected.get('value'));

					grid.getView().refreshNode(selectedRecord);
				}
			}
		},
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(record.get('reviewParameter'))) {
				return record.get('reviewParameter');
			} else {
				meta.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},{
		header: getAdmissionTranslation('RATING'),
		dataIndex: 'reviewRating',
		menuDisabled: true,
		flex: 0.7,
		editor: {
			xtype: 'customcombobox',
			name: 'reviewRatingId',
			itemId: 'reviewRatingId',
			valueField: 'value',
			displayField: 'value',
			forceSelection: true,
			store: Ext.create('Academia.store.admission.applications.applicationReviewer.ReviewRatingComboStore'),
			editable: false,
			listeners: {
				focus: function(combo) {
					var grid = combo.up('reviewdetailspanel');
					var selectedRecord = grid.getSelectionModel().getSelection()[0];
					var reviewParameterId = selectedRecord.get('reviewParameterId');

					var store = combo.getStore();
					store.getProxy().extraParams = {
						reviewParameterId: reviewParameterId
					};
					store.load();
				},
				select: function(combo, records) {
					var grid = combo.up('grid');
					var selectedRecord = grid.getSelectionModel().getSelection()[0];
					var selected = records[0];
					var duplicateFound = false;

					grid.getStore().each(function(rec) {
						if (rec !== selectedRecord && rec.get('reviewRatingId') === selected.get('id')) {
							duplicateFound = true;
							return false;
						}
					});

					if (duplicateFound) {
						combo.setValue(null);
						combo.setRawValue('');
						showWarningMessage(getCommonTranslation('ALERT'), getAdmissionTranslation('REVIEW_RATING_ALREADY_SELECTED'));
						return false;
					}

					selectedRecord.set('reviewRatingId', selected.get('id'));
					selectedRecord.set('reviewRating', selected.get('value'));

					grid.getView().refreshNode(selectedRecord);
				}
			}
		},
		renderer: function(value, meta, record) {
			if (!isNullOrEmpty(record.get('reviewRating'))) {
				return record.get('reviewRating');
			} else {
				meta.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	}, {
		header: getPersonModuleTranslation('REMARKS'),
		dataIndex: 'remarks',
		menuDisabled: true,
		flex: 0.7,
		editor: {
			xtype: 'textfield',
			name: 'remarks',
			itemId: 'remarks',
			maxLength: 1000
		},
		renderer: function(value, rec, record) {
			if (!isNullOrEmpty(value) && value !== '') {
				return value;
			}
			else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	}],
	buildStore: function() {
		return Ext.create('Academia.store.admission.applications.applicationReviewer.ApplicationReviewerDetailStore');
	},
	plugins: [{
		ptype: 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(editor, context) {
				if (editor.context.field == 'reviewParameter') {
					if (!isNullOrEmpty(context.record.data.id)) {
						context.grid.columns[1].getEditor().setReadOnly(true);
						return context.colIdx !== 1;
					} else {
						context.grid.columns[1].getEditor().setReadOnly(false);
					}
				} else if (editor.context.field == 'reviewRating') {
					if (!isNullOrEmpty(context.record.data.reviewRating)) {
						context.grid.columns[2].getEditor().setReadOnly(true);
						return context.colIdx !== 2;
					} else {
						context.grid.columns[2].getEditor().setReadOnly(false);
					}
				}
			}
		}
	}]
});
