/**
 * Amit G
 */
Ext.define('Academia.view.admission.applications.applicationFollowUp.ApplicationFollowUpDetailForm', {
	//extend : 'Ext.form.Panel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.applicationfollowupdetailform',
	autoScroll: false,
	title: getEnquiryTranslation('FOLLOW_UP_DETAIL'),
	cls: 'panelNoSpace',
	frame: true,
	height:580,
	items: [{
		xtype: 'form',
		plugins: "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [
				{
					xtype : 'datefield',
					name : 'actualApplicantFollowUpDate',
					itemId : 'actualApplicantFollowUpDate',
					editable : false,
					value : new Date(),
					vtype : 'daterange',
					endDateField : 'applicantNextFollowUpDateId',
					maxValue : new Date(),
					allowBlank : false,
					fieldLabel : getEnquiryTranslation('FOLLOW_UP_DATE'),
					listeners : {
						render : function(field) {
							return dateFormatRender(field);
						}
					}
				},
				{
					xtype : 'timefield',
					name : 'applicantFollowupTime',
					itemId : 'applicantFollowupTime',
					editable : true,
					format : 'H:i',
					allowBlank : true,
					width:290,
					readOnly : false,
					value : new Date(),
					fieldLabel : getEnquiryTranslation('FOLLOW_UP_TIME'),
				},
				{
					xtype : 'textfield',
					name : 'applicantFollowupuser',
					itemId : 'applicantFollowUpUser',
					fieldLabel : getEnquiryTranslation('FOLLOW_UP_USER'),
					store : 'enquiry.EnquiryRegisteredBy',
					valueField : 'id',
					displayField : 'value',
					editable : false,
					readOnly : true,
					allowBlank : true
				} ]
		},
		{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 230,
				labelAlign : 'top',
				regex : /[a-zA-Z0-9]+/
			},
			items : [
				{
					xtype : 'textfield',
					name : 'applicantFollowupActivityTo',
					itemId : 'applicantFollowupactivityto',
					editable : false,
					readOnly : true,
					allowBlank : true,
					fieldLabel : getEnquiryTranslation('FOLLOW_UP_ACTIVITY_TO'),
					maxLength : 100,
					enforceMaxLength : true
				},
				{
					xtype : 'textfield',
					name : 'applicantEmailAdress',
					itemId : 'applicantEmailAdress',
					editable : false,
					readOnly : true,
					allowBlank : true,
					vtype : 'email',
					width:290,
					fieldLabel : getCommonTranslation('EMAIL'),
					maxLength : 100,
					enforceMaxLength : true
				},
				{
					xtype : 'fieldcontainer',
					labelSeparator : '',
					fieldLabel : getCommonTranslation('MOBILE_NO'),
					itemId : 'applicantDetail_cellNumber',
					name : 'applicantDetail_cellNumber',
					editable : false,
					readOnly : true,
					allowBlank : true,
					layout : 'hbox',
					width : 226,
					labelAlign : 'top',
					items : [{
							xtype : 'customcombobox',
							valueField : 'isdCode',
							displayField : 'isdCode',
							store : 'common.CountryStore',
							itemId : 'phoneCountryCode',
							triggerAction : 'all',
							name : 'phoneCountryCode',
							width : 80,
							typeAhead : true,
							editable : false,
							readOnly : true,
							emptyText : 'Code',
							allowBlank : true,
							minChars : 1
						},{
							xtype : 'numberfield',
							name : 'cellNo',
							itemId : 'applicant_mobileno',
							minLength : 0,
							maxLength : 11,
							width : 135,
							readOnly : true,
							hideTrigger : true,

						} ]
				} ]
		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [
				{
					xtype : 'customcombobox',
					name : 'applicantFollowUpActivityType',
					itemId : 'applicantFollowupactivitytypeId',
					store : 'enquiry.FollowupActivityType',
					fieldLabel : getEnquiryTranslation('FOLLOW-UP_ACTIVITY_TYPE'),
					valueField : 'id',
					displayField : 'value',
					allowBlank : false,
					typeAhead : true,
					forceSelection : true
				},
				{
					xtype : 'customcombobox',
					name : 'applicantReasonForFollowUp',
					itemId : 'applicantReasonforfollowup',
					fieldLabel : getEnquiryTranslation('REASON_FOR_FOLLOW-UP'),
					store : 'enquiry.ReasonForFollowup',
					displayField : 'value',
					width:290,
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					allowBlank : false
				},
				{
					xtype : 'customcombobox',
					name : 'applicantFollowUpActivityStatus',
					itemId : 'applicantFollowupactivitystatusId',
					fieldLabel : getEnquiryTranslation('FOLLOW_UP_ACTIVITY_STATUS'),
					store : 'enquiry.FollowupActivityStatus',
					displayField : 'value',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					allowBlank : false
				} ]
		},

		{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'applicantPriority',
				itemId: 'applicantPriority',
				fieldLabel: getEnquiryTranslation('PRIORITY'),
				store: 'enquiry.Priority',
				displayField: 'value',
				valueField: 'id',
				typeAhead: true,
				forceSelection: true,
				allowBlank: false
			},{
				xtype : 'textfield',
				name : 'followupStatusUpdateTime',
				itemId : 'followupStatusUpdateTimeId',
				fieldLabel : getEnquiryTranslation('FOLLOW_UP_STATUS_UPDATE_DATE_AND_TIME'),
				//store : 'enquiry.FollowupActivityStatus',
				displayField : 'value',
				valueField : 'id',
				width: 290,
				typeAhead : true,
				forceSelection : true,
				allowBlank : false
			}]
		}, {
			xtype: 'textarea',
			width: 455,
			maxLength : 1000,
			name: 'remark',
			itemId: 'remarkItemId',
			fieldLabel: getEnquiryTranslation('FOLLOW_UP_REMARKS'),
		}, {
			xtype: 'checkboxfield',
			boxLabel:getEnquiryTranslation('SCHEDULE_NEXT_FOLLOW_UP'),
			name:'applicantWhetherNextFollowUp',
			itemId:'applicantWhetherNextFollowUpId'
		}, {

			xtype: 'fieldcontainer',
			width: 'auto',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'applicantStatus',
				itemId:'applicantStatus',
				fieldLabel: getEnquiryTranslation('TRACK_ENQUIRY_STATUS'),
				valueField: 'id',
				displayField: 'value',
				hidden:true,//Hidden status as discussed with  mrinal and acd-12046 
				typeAhead: true,
				forceSelection: true,
				store: {
					fields: ['text', 'value', 'code'],
					data : [
						{"id":"O", "value":"Open", "code": "O"},
						{"id":"C", "value":"Closed", "code": "C"},
						]
				}
			},{
				xtype: 'datefield',
				name: 'applicantNextFollowUpDate',
				itemId: 'applicantNextFollowUpDateId',
				vtype: 'daterange',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				fieldLabel: getEnquiryTranslation('NEXT_FOLLOW_UP_DATE'),
				allowBlank: true,
				hidden:true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}, {
				xtype: 'customcombobox',
				name: 'applicantUserByAssignTo',
				itemId: 'applicantUserByAssignToId',
				store: 'enquiry.FollowUpUserWithDepartment',
				fieldLabel: getEnquiryTranslation('ASSIGN_TO'),
				valueField: 'id',
				displayField: 'value',
				queryParam: 'name',
				minChars: 3,
				allowBlank: true,
				typeAhead: false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection: true,
				hidden:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		}, {
			border : false,
			layout : {
				type : 'hbox',
				width : '100%'
			},
			style:{
				marginLeft:'0px'
			},
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				itemId: 'followdetail_submitbuttonId',
				name: 'followdetail_submitbutton',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}]
		}
		]
	}]
});