/**
 * @author Pankaj Sisodiya
 * 
 */
Ext.define('Academia.view.admission.preAdmissionFeesAndRefund.RefundAndStageFeeForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.refundAndStageFeeForm',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [/*{
	        xtype: 'textfield',
	        itemId: 'txtApplicationId',	        
	         //Application Id
	        labelWidth:96,
	        fieldLabel: getAdmissionTranslation('APPLICATION_ID') //Application Id
	    },{
	        xtype: 'textfield',
	        itemId: 'txtApplicantName',
	        labelWidth:110,
	         //Applicant Name
	        fieldLabel: getAdmissionTranslation('APPLICANT_NAME') //Applicant Name
	    }*/{
			xtype: 'customcombobox',
			name:'applicantName',
			itemId:'applicantName',
			store:'feeandpayment.managebill.Applicant',
			fieldLabel:getCommonTranslation('APPLICANT_ID_NAME'),
			valueField: 'applicantPrintName',
			displayField: 'printName',
			queryParam:'codeOrName',
			minChars:CONST.SMART_SEARCH_LIMIT,
			typeAhead:false,
			hideTrigger:true,
			triggerAction: '',
			forceSelection:true,
			listeners: {
				afterrender: function(field) {
					field.emptyText = 'Enter ' + field.minChars + ' char to auto search';
					field.applyEmptyText();
				}
			},
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{printName}'  +
					'</div>';
				}
			}
		},{
	        xtype: 'textfield',
	        itemId: 'txtReceiptNo',
	        labelWidth:80,
	        fieldLabel: getAdmissionTranslation('RECEIPT_NO') //Receipt NO.
	    }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
        items: [{
        	xtype: 'button',
        	itemId: 'btnFindApplication',        
	        disabled:true,
	        tooltip: getAdmissionTranslation('SEARCH'), //Search
	        text: getAdmissionTranslation('SEARCH'),
	        ui:'CustomBtnSubmit',
            //margin: '0 44 0 0'
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetRefundItemId',
            //buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});