/**
 *  @author Harshit Satya
 */

Ext.define('Academia.view.alumniSystem.alumniNewsAndFeeds.AlumniNewsAndFeedsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.alumninewsandfeedsgrid',
    store: 'alumni.alumniNewsAndFeeds.AlumniNewsAndFeedsFilterStore',
    title: getAlumni('NEWS_AND_FEEDS'),
    border: true,
	autoScroll: false,
    selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
	},
    refreshStoreData: true,
    isGridConfigurable: true, 
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
    },
    headerFix: {
    	headerFix: true,
    	portalIdsWithStructure: {
			'alumninewsandfeedsstructure':1
		}
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'alumni.alumniNewsAndFeeds.AlumniNewsAndFeedsFilterStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true,
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		disabled:true,
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		disabled:true,
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		disabled:true,
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'publishBtnitemId',
		disabled:true,
		tooltip: getAlumni('PUBLISH'),
		text: getAlumni('PUBLISH'),
	},{

		xtype: 'button',
		itemId: 'unPublishBtnitemId',
		disabled:true,
		tooltip: getAlumni('UNPUBLISH'),
		text: getAlumni('UNPUBLISH'),
	
	},'->'],
    columns: [{
        header: getCommonTranslation('NEWS_ID'),
        dataIndex: 'code',
        flex: 1
    }, {
        header: getAlumni('TITLE'),
        dataIndex: 'title',
        flex: 1
    }, {
        header: getAlumni('DESCRIPTION'),
        dataIndex: 'description',
        flex: 2
    }, {
        header: getCommonTranslation('START_DATE'),
        dataIndex: 'alumniStartDate',
        flex: 1
    }, {
        header: getCommonTranslation('END_DATE'),
        dataIndex: 'alumniEndDate',
        flex: 1
    }, {
        header: getAlumni('STATUS'),
        dataIndex: 'status',
        flex: 1,
		renderer:function(value) {
			if(value=='PUBLISHED'){ 
				return  'Published' ;
				}
			else{ 
				return 'Un-published';
				}
			
		}
    }]
});
