/**
 * @author Harshit Satya
 * Photo upload form for alumni mandatory
 */
Ext.define('Academia.view.alumniSystem.alumniNewsAndFeeds.AlumniPhotoUploadForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.alumniphotouploadform',
    border: false,
    frame: false,
    cls: 'panelNoSpace',
//    plugins: "formlabelrequired",
    defaults: {
        labelAlign: 'top',
        width: 226
    },
    style: {
    	marginTop: '-3px !important'
    },
    items: [{
        xtype: 'filefield',
        fieldLabel: getPersonModuleTranslation('UPLOAD_LOGO'),
        buttonText: getPersonModuleTranslation('UPLOAD'),
        itemId: 'alumniPhotoFileImage',
        ui: 'CustomBtnSubmit',
        name: 'file',
        allowBlank: false,
        listeners: {
        	afterrender: function(cmp) {
                if (!cmp.tooltip) {
                    cmp.tooltip = Ext.create('Ext.tip.ToolTip', {
                        target: cmp.getEl(),
                        html: 'Formats: JPEG and PNG & max size 5 MB',
                        dismissDelay: 0, // Keeps the tooltip visible indefinitely unless dismissed manually
                        trackMouse: true, // Follows the mouse pointer
                        anchor: 'top',
                        showDelay: 50 // Adds a small delay before showing the tooltip
                    });
                }
            },
            change: function(cmp, value) {
                // Store full file name with extension in hidden field on file selection
                var fullFileName = value.split('\\').pop();
                cmp.up('form').down('#hiddenFileName').setValue(fullFileName);
            }
        },
    }, {
    	xtype: 'button',
    	text: '',
    	itemId: 'evidenceLink',
    	hidden: true,
    	cls: 'hyperlinkBtn',
    	handler: function(btn) {
    		var a = document.createElement('a');
			a.href = btn.href;
			var fileExtension = btn.fileExtension;
			a.download = btn.text.replaceAll(" ","_")+"."+fileExtension;
			document.body.appendChild(a);
			a.click();
			document.body.removeChild(a);
    	}
    },{
    	xtype: 'hiddenfield',
	    itemId: 'hiddenFileName',
	    name: 'hiddenFileName'
    }]
});