/**
 *  @author Niklesh T
 * 
 */
Ext.define('Academia.view.alumniSystem.signUpRequest.SignUpRequestFilter',{
	extend: 'Ext.form.Panel',
	alias : 'widget.signUpRequestFilter',
	itemId: 'signUpRequestFilterItemId',
	autoScroll: false,
	bodyPadding:'10 10 10 11',
	frame:false,
	cls:'customSearchPanel',
	plugins:"formlabelrequired",
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	defaults: {
		labelAlign: 'top',
	},
	items:[{
        xtype: 'fieldcontainer',
        width : '100%',
		layout: {
			type : 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},		
        items: [{
			xtype : 'customcombobox',
			fieldLabel : getAlumni('REQUEST_ID'),		
			name : 'requestId',
			itemId : 'requestIdItemId',	
			minChars:3,
			forceSelection:true,
			store: 'alumni.signUpRequest.AlumniSignUpRequestIDStore',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			valueField: 'value',
			displayField: 'value',
			queryParam:'requestId',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			}
		},{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('NAME'),
				name:'requestName',
				itemId:'requestNameItemId',
				minChars:3,
				forceSelection:true,
				store: 'alumni.signUpRequest.SignUpNameStore',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
			},{
				xtype : 'customcombobox',
				fieldLabel : getAlumni('MOBILE_NUMBER'),		
				name : 'requestMobileNumber',
				itemId : 'requestMobileItemId',	
				minChars:3,
				forceSelection:true,
				store: 'alumni.signUpRequest.SignUpMobileNoStore',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'value',
				displayField: 'value',
				queryParam:'mobileNo',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
			}]
    	},{

            xtype: 'fieldcontainer',
            width : '100%',
    		layout: {
    			type : 'hbox'
    		},
    		defaults: {
    			width: 226,
    			labelAlign: 'top'
    		},		
            items: [{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('STATUS'),
				name:'alumniStatus',
				itemId:'alumniStatusItemId',
				store: Ext.create('Ext.data.Store', {
				    fields: ['id', 'value'],
				    data: [{
						id:'PENDING',
						value:getAlumni('PENDING') 
					},{
						id:'APPROVED',
						value:getAlumni('APPROVED') 
					},{
						id:'REJECTED',
						value:getAlumni('REJECTED')  
					}]
				}),
				displayField: 'value',
		        valueField: 'value',
				forceSelection: true,
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}	
			},{
				xtype : 'customcombobox',
				fieldLabel : getAlumni('EMAIL_ID'),		
				name : 'requestEmailId',
				itemId : 'requestEmailItemId',
				minChars:3,
				forceSelection:true,
				store: 'alumni.signUpRequest.SignUpEmailStore',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				valueField: 'value',
				displayField: 'value',
				queryParam:'emailId',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
			},{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('PROGRAM'),
				name:'alumniProgram',
				itemId:'alumniProgramItemId',
				store: Ext.create('Academia.store.common.ProgramStore'),
				queryParam:'programName',
				editable: true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				minChars:3,
				valueField: 'id',
				displayField: 'value',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			}
			}]
    	},{xtype: 'fieldcontainer',
    		width : '100%',
    		layout: {
    		    type : 'hbox'
    		},
    		defaults: {
    		    width: 226,
    		    labelAlign: 'top'
    		},		
    		items: [{
				xtype: 'customcombobox',
				fieldLabel:getAlumni('BATCH'),
				store: 'alumni.alumniList.AlumniBatchStore',
				name:'alumniBatch',
				itemId:'alumniBatchItemId',
				forceSelection: true,
				queryParam:'qry',
				editable: true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				minChars:3,				
				valueField: 'id',
				displayField: 'value',
				listConfig: {
					listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			},
    			disabled: true,
			}]},{
    		xtype: 'fieldcontainer',    
    		layout : {
    			type : 'hbox'
    		},
    		width:'auto',
    		items : [{
    			xtype : 'button',
    			text : getCommonTranslation("SEARCH") ,
    			name : 'searchBtn',
    			itemId : 'searchBtn',
    			ui : 'CustomBtnSubmit',
    			scale : CONSTANTS.BUTTONSIZE,
    			formBind : true
    		},{
    			xtype: 'button',
    			itemId: 'resetBtn',
    			name: 'resetBtn',
    			text: getCommonTranslation("RESET"),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE,
    		}]
    	
    	}]
});

