/**
 * @author Prakash Sharma
 */
Ext.define('Academia.view.applicantportalsetup.ApplicantPortalSetupFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.applicantportalsetupfilter',
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    plugins:"formlabelrequired",
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
    			xtype: 'customcombobox',
    			name: 'applicantSetupId',
    			itemId:'applicantSetupId',
    			fieldLabel: getCommonTranslation('APPLICANT_SETUP_ID_NAME'),
    			store:Ext.create('Academia.store.applicantPortalSetup.applicantPortalSetupFindAllSetupStore'),
    			displayField:'value',
    			valueField:'id',
    			forceSelection:true,
    			minChars:3,
    			queryParam:'setupName',
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
     				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
     				loadingText: getCommonTranslation('SEARCHING'),
     				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
     				getInnerTpl: function() {
     					return '<div class="search-item">' +
     					'{value}' +
     					'</div>';
     				}
     			}
    		},{
    			xtype: 'customcombobox',
    			name: 'createdById',
    			itemId:'createdById',
    			fieldLabel: getCommonTranslation('CREATED_BY'),
    			store:Ext.create('Academia.store.applicantPortalSetup.applicantPortalSetupFindAllSetupUserStore'),
    			displayField:'value',
    			valueField:'id',
    			forceSelection:true,
    			minChars:3,
    			queryParam:'userName',
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listConfig: {
     				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
     				loadingText: getCommonTranslation('SEARCHING'),
     				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
     				getInnerTpl: function() {
     					return '<div class="search-item">' +
     					'{value}' +
     					'</div>';
     				}
     			}
    		},{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
				name: 'academyLocationId',
				itemId:'academyLocationCombo',
				store: 'user.UserAcademyLocationStore',
				displayField: 'value',
				valueField: 'id',
				typeAhead : false,
	            forceSelection:true,
	            hideTrigger:false,
	            queryMode: 'remote',
	            queryParam: 'qry',
	    	    triggerAction: 'all',
	            minChars:3,
	            matchFieldWidth:true,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
			}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'programGroupId',
            itemId: 'programGroupItemId',
            fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
            store: Ext.create('Academia.store.committee.committee.CommitteeProgramGroupSmartComboStore'),
            //store: 'program.ProgramGroupStore',
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            editable: false,
        },{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programItemId',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            store: 'program.ProgramByGroupIdStore',
            valueField: 'id',
            displayField: 'valueCode',
            forceSelection: true,
            minChars:3,
			queryParam:'qry',
			hideTrigger:false,
            triggerAction: 'all',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'+ 
	                    '</div>';
	                }
	            }
         },{
            xtype: 'customcombobox',
            name: 'batchId',
            itemId: 'batchItemId',
            fieldLabel: getCommonTranslation('BATCH'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            editable: true,
            disabled : true,
            typeAhead:false,
            queryMode : 'remote',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		       listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'+ 
						'</div>';
					}
			},
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
        }]
    },{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('SEAT_TYPE'),
			name: 'seatType',
			itemId: 'seatTypeId',
			editable: false,
			autoload: false,
			disabled : true,
			store:'common.SeatTypesByBatchId',
			valueField: 'seatTypeId',
			displayField: 'seatTypeName',
			queryMode : 'local'
		},{
			xtype: 'datefield',
			name: 'startDate',
			itemId: 'startDate',
			vtype: 'daterange',
			endDateField: 'endDate',
			fieldLabel: getCommonTranslation('CREATION_FROM_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}, {
			xtype: 'datefield',
			name: 'endDate',
			itemId: 'endDate',
			vtype: 'daterange',
			startDateField: 'startDate',
			fieldLabel: getCommonTranslation('CREATION_TO_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
		},{
        	xtype:'fieldset',
        	title: getTransportTranslation('MORE_FILTERS'),
        	//layout:'vbox',
        	frame:true,	
        	itemId:'moreFilterItemId',
        	collapsible:true,
        	collapsed:true,
        	style:{marginTop: '33px!important'},
        	width:'100%',
        	items: [{
        		xtype: 'fieldcontainer',
        		width: 'auto',
        		layout: 'hbox',
        		defaults: {
        			width: 226,
        			labelAlign: 'top'
        		},
        		items: [{
        			xtype: 'customcombobox',
        			name: 'mappingstatus',
        			itemId:'mappingstatusItemId',
        			store:'feeandpayment.MappingStatus',
        			displayField:'value',
        			valueField:'id',
        			forceSelection:true,
        			typeAhead:true,
        			//minChars:3,
        			//hidden:true,
        			//disabled:true,
        			fieldLabel:getCommonTranslation('APPLICANT_MAPPING_STATUS')
        		}]
        	}]
		},{
	    xtype: 'fieldcontainer',
        width:'100%',
        cls:'windowBtnPos',
        items: [{
            xtype: 'button',
            itemId:'searchBtn',
            text: getCommonTranslation('SEARCH'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId:'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
}]
});
