/**
 *  @Amit G
 */
Ext.define('Academia.view.applicantportalsetup.RenameApplicantSetupNameWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.renameapplicantsetupnamewin',
    modal: true,
    autoScroll:true,
    title: getCommonTranslation('APPLICANT_PORTAL_NEW_SETUP_NAME'),
    maxHeight:600,
    items: [{
        xtype: 'form',
        method: 'POST',
        autoScroll:true,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: 'anchor',
        standardSubmit: false,
        plugins:"formlabelrequired",
        defaults: {
        	  labelAlign: 'top',
        	  width: 226,
//            anchor: '100%'
        },
        items: [{  
        	    xtype: 'hidden',
                name: 'id'
            },{
				xtype: 'textfield',
				name: 'setupName',
				itemId:'setupName',
				allowBlank:false,
				fieldLabel: getCommonTranslation('PLEASE_ENTER_NEW_SETUP_NAME')
				
			},{
            layout: {
                type: 'hbox'
            },
            style:{
            	marginLeft:'0px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'saveBtn',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'cancelBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                handler :function(button) {
                	button.up('window').close();
                }
            }]
        }]
    }]
});