/**
 * @author Amandeep Bhatia
 */
Ext.define('Academia.view.applicantportalsetup.UploadDocumentList', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.uploaddocumentlist',
    store : 'applicantPortalSetup.GuidelinesDocumentListStore',
    title: getHostelTranslation('UPLOAD_GUIDELINE_DOCUMENT'),
    border: true,
    autoScroll: true,
    columnLines : true,
    cls:'centerAlignTitle',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
/*	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			 style: {
	        	 marginLeft: '-150px',
             },
			store : 'applicantPortalSetup.GuidelinesDocumentListStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],*/
	tbar: [{
        xtype: 'button',
        itemId: 'deleteGuidelineDocument',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    },
    {
        xtype: 'button',
        itemId: 'addGuidelineDocument',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }],
    
    columns: [{
        header: getDocumentTranslation('DOCUMENT_NAME'),
        dataIndex: 'documentName',
        align: 'left',
        sortable: false,
        flex: 1,
    	renderer:function(value,rec){
			if(value){
				return "<a href='#'>"+value+"</a>";
			}
		}
    }]
});