Ext.define('Academia.view.applicantportalsetup.VWAdmApplicantPortalSetupCustomColumnGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.vwadmapplicantportalsetupcustomcolumngrid',	
	store:'applicantPortalSetup.StoAdmApplicantPortalCustomColumnSetUpStore', 
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar:[{
		xtype:'button',
		text:getCommonTranslation('SAVE'),
		action:'save',
		itemId:'btnSave'
	}],	
	columns:[{
		header:getCommonTranslation('COLUMN_NAME'),
		dataIndex:'displayName',
		flex:1,
		renderer:function(value) {
			return value;
		}	
	},{
		xtype:'checkcolumn',
		header:getCommonTranslation('MODULE_VISIBILITY'),
		flex:1,
		dataIndex : 'isVisible',
		renderer: function(value, metadata,record) {
			var data=record.data;
				 var cssPrefix = Ext.baseCSSPrefix,
				 cls = cssPrefix + 'grid-checkcolumn';
				 if (value) {
						cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
					}
					return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
		}			
	},{
		xtype:'checkcolumn',
		flex:1,
		header:getCommonTranslation('WHETHER_COLUMN_MANDATORY'),
		dataIndex : 'isMandatory'	,
		renderer: function(value, metadata,record) {
			var data=record.data;
				 var disabled=!data.isVisible;
				 if(disabled){
					 metadata.style+= ' opacity:0.3';
					 value=data.isMandatory;
				 }
				
				 var cssPrefix = Ext.baseCSSPrefix,
				 cls = cssPrefix + 'grid-checkcolumn';
				 if (value) {
						cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
					}
					return '<img class="' + cls + '" src="' + Ext.BLANK_IMAGE_URL + '"/>';
		},
		 processEvent: function(type, view, cell, recordIndex, cellIndex, e) {
			 if (type == 'mousedown' || (type == 'keydown' && (e.getKey() == e.ENTER || e.getKey() == e.SPACE))) {
				var record = view.panel.store.getAt(recordIndex);
				var data=record.data;
				var disabled=!data.isVisible;
				 //do not change data and fire checkchange event if it's disabled
				 view.focusRow(recordIndex);
				 if (!disabled) {
	                        dataIndex = this.dataIndex;
	                        checked = !record.get(dataIndex);
	                        record.set(dataIndex, checked);
	                        this.fireEvent('checkchange', this, recordIndex, checked);
	              }
				 return false;
                }
            }	
	},
	{
		header:getCommonTranslation('MODULE_SEQUENCE'),
		flex:1,
		sortable:false,
		dataIndex : 'sequenceNo',
		style: {
			'text-align': 'center'
        },
		editor: {
        	xtype: 'numberfield',
        	name: 'sequenceNo',
        	minValue:1,
        	maxLength: 6,
        	width: 12,
        	enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowDecimals:false,
        	style: {
                margin: 'auto'
            },
        	itemId: 'sequenceNoItemId',
        	listeners: {
        		blur: function(obj, record){
        			var grid = obj.up('grid')
        			record = obj.getValue();
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			var rowIndex = selectedRecord.index;
        			var items = grid.getStore().data.items;
					var isValid = false;
					var isIndexValid = true;
					Ext.each(items, function(item, index, opt) {
						if (rowIndex != index) {
							if (item.data.sequenceNo != record) {
								isValid = true;
							}else{
								isIndexValid = false;
							}
						}else{
							isValid = true;
						}
						
					});
					if (!(isValid && isIndexValid)) {
						obj.reset();
					}
        		}
        	}
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	var data=record.data;
        	var oldValue = record.modified.sequenceNo;
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					rec.tdCls = 'gridInputCustomStyleForSqeuence';
					return value;
					
				}
				catch(e){
					rec.tdCls = 'gridInputCustomStyleForSqeuence';
					return null;
				}
			}
        	else {
					rec.tdCls = 'gridInputCustomStyleForSqeuence';
	                return getExaminationTranslation('CLICK_TO_ENTER');
        	}
        }			
	},
	{
		/*
		 * If custom field false means it is custom category
		 * If custom filed true means it is not custom category
		 **/
		header:getCommonTranslation('WHETHER_CUSTOM_CATEGORY'),
		flex:1,
		dataIndex : 'whetherCustomField',
		renderer:function(value) {
			if (value == true) {
				return 'No';	
			}else{
				return 'Yes';
			}
			
		}
	}],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    }
}
);