/**
 * @author Manas
 */
Ext.define('Academia.view.assessmentSchedule.AssessmentScheduleSearchFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.assessmentschedulesearchfilter',

    autoScroll: false,
    frame: false,
    standardSubmit: false,
    plugins: "formlabelrequired",
    cls: 'customSearchPanel',

    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 260,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'academicTermId',
            itemId: 'academicTermId',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            store: 'common.AcademicTermStore' , 
            displayField: 'value',
            valueField: 'id',
            forceSelection: true,
            editable: false,
            typeAhead: true
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtn',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});
