/**
 * @author Manas
 * @description Simplified filter with only Academic Term and Evaluation Plan
 */
Ext.define('Academia.view.assessmentSchedule.DownloadForEvalScheduleFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.downloadforevalschedulefilter',
    autoScroll: false,
    frame: false,
    standardSubmit: false,
    plugins: "formlabelrequired",
    
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top',
            margin: '0 10 10 0'
        },
        items: [
			{
			    xtype: 'customcombobox',
			    fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			    name: 'templateName',
			    itemId: 'templateName',
			    displayField: 'value',
			    valueField: 'code',
			    store: Ext.create('Academia.store.schedule.TemplateTypeStore'),
			    typeAhead: true,
			    allowBlank: false,
			    forceSelection: true,

			    listeners: {
			        beforerender: function (combo) {
			            combo.getStore().filterBy(function (rec) {
			                return rec.get('code') !== 'CAT'; // CAT hide
			            });
			        }
			    }
			},{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            name: 'scbeduleTermId',
            itemId: 'scbeduleTermId',
            displayField: 'value',
            valueField: 'id',
            // Store created directly as per your previous requirement
            store: Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
            typeAhead: true,
            allowBlank: false,
            forceSelection: true
        }, {
            xtype: 'customcombobox',
            name: 'evalautionPlanNo',
            itemId: 'evalautionPlanNoItemId',
            // Store for Evaluation Plan
            store: Ext.create('Academia.store.examinationcenters.evaluationgroup.detailsequencecovered.EvaluationPlanOtherForTemplate'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN'),
            valueField: 'id',
            displayField: 'value',
            queryParam: 'evaluationPlanNumber',
            minChars: 3,
			hidden:true,
            typeAhead: true,
            allowBlank: true,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">{value}</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        margin: '10 0 0 0',
        items: [{
            xtype: 'button',
            itemId: 'scheduleDownload',
            text: getExaminationTranslation('MARK_ENTRY_DOWNLOAD'),
            ui: 'CustomBtnSubmit',
            formBind: true,
            margin: '0 10 0 0'
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});