Ext.define('Academia.view.attendance.importAttendance.AttendanceImportStructure', {
	extend : 'Ext.panel.Panel',
	alias : 'widget.attendanceImportStructure',
	 layout: 'fit',
	    autoScroll: false,

	    listeners: {
	        afterrender: function (panel) {
	            // IMPORTANT: set height via JS, not CSS
	            panel.setHeight(Ext.Element.getViewportHeight() * 0.85);

	            // FORCE scroll on BODY
	            panel.body.setStyle({
	                overflowY: 'auto',
	                overflowX: 'hidden'
	            });

	            panel.doLayout();
	        },
	         activate: function (tab) {
	            var parent = tab.up('markattendancemasterstructure');

	            if (parent && parent.body) {
	                parent.body.setStyle('overflow', 'hidden');
	            }
	        },

	        deactivate: function (tab) {
	            var parent = tab.up('markattendancemasterstructure');

	            if (parent && parent.body) {
	                parent.body.setStyle('overflow', 'auto'); 
	            }
	        }
	    },

	    bodyStyle: {
	        margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
	    },
	    items: [{
	        xtype: 'panel',
	        layout: 'fit',
	        border: false,

	        items: [{
	        	xtype : 'attendanceImport',
				itemId: 'attendanceImport',
	        }]
	    }]
});
