/**
 * @author seshagiri.k
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.campaign.quicksearch.CampaignQuickSearch', {
	extend: 'Ext.form.Panel',
	alias: 'widget.campaignQuickSearch',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	items: [{
		xtype: 'fieldcontainer',
		layout: 'vbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'CAMPAIGN_ID_NAME',
			store:'campaign.CampaignCodeOrNameSmartSearch',
			fieldLabel:getCampaignTranslation('CAMPAIGN_ID_NAME'),
			width:460,
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
            hideTrigger:true,
        	regex : /^[a-zA-Z0-9%\-\/\\\s]+$/,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'  +
	                    '</div>';
	                }
	            }
		},{
            xtype: 'multiselectcombofield',
            fieldLabel: getCommonTranslation('FACULTY_CAMPUS'),
            name: 'ACADEMY_LOCATION_ID',
            itemId: 'academyLocationId',
            store:'common.AcademyLocationNameSeparated',
            displayField: 'value',
            valueField: 'id',
            width: 460,
            allowBlank:true,
            queryMode: 'remote',
            typeAhead : false,
            forceSelection:true,
           // triggerAction: 'all',
            minChars:3,
            queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        }]
	},{ 
		xtype:'fieldset',
		title:getEnquiryTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		//width:'100%',
		defaults: {
			labelAlign: 'top',
			//width:226
		},
		style: {
			marginTop: '40px!important',
			//marginLeft:'-10px !important'
		},
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				width: 460,
				labelAlign: 'top'
			},
			 
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			style: {
				//marginTop: '40px!important',
				marginLeft:'-0px !important'
			},
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'FROM_DATE',
				itemId: 'startDate',
				vtype: 'daterange',
				endDateField: 'endDate',
				fieldLabel:getCampaignTranslation('FROM_DATE'),
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
//				format: CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype: 'datefield',
				name: 'TO_DATE',
				itemId: 'endDate',
				vtype: 'daterange',
				startDateField: 'startDate',
				fieldLabel:getCampaignTranslation('TO_DATE'),
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
//				format: CONSTANTS.DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 300,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//				translationKey: 'PROGRAM',
				name: 'PROGRAM',
				store: 'common.ProgramByAcademyLocationStore',
				displayField: 'valueCode',
				valueField: 'id',
				typeAhead: true,
	            forceSelection: true,
	            triggerAction: 'all',
	            queryParam:'programName',
	            minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		 			listConfig: {
		 				listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		 				loadingText: getCommonTranslation('SEARCHING'),
		 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		 				getInnerTpl: function() {
		 					return '<div class="search-item">' +
		 					'{code} / {value}'+ 
		 					'</div>';
		 				}
		 			}
	            
			},{
				xtype: 'checkboxfield',
				width: 300,
				style: {'margin-top':'25px'},
				labelAlign: 'right',
				boxLabel: getCommonTranslation('INCLUDE_DELETED_RECORDS'),
				name: 'whetherDeleted',
				inputValue: true
			}]  
		}]
	}, {
		xtype: 'fieldcontainer',
		width: 'auto',

		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'campaignSearchButtonId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'cancelBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});